/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.jms.module.validators.JMSModuleValidator;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSDestinationKeyMBean;
import weblogic.management.configuration.JMSDestinationKeyMBeanImpl;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSDestinationMBeanImpl;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.mbeans.custom.JMSQueue;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JMSQueueMBeanImpl
extends JMSDestinationMBeanImpl
implements JMSQueueMBean,
Serializable {
    private long _BytesMaximum;
    private long _BytesThresholdHigh;
    private long _BytesThresholdLow;
    private long _CreationTime;
    private String _DeliveryModeOverride;
    private JMSDestinationKeyMBean[] _DestinationKeys;
    private JMSDestinationMBean _ErrorDestination;
    private String _ExpirationLoggingPolicy;
    private String _ExpirationPolicy;
    private String _JNDIName;
    private boolean _JNDINameReplicated;
    private int _MaximumMessageSize;
    private long _MessagesMaximum;
    private long _MessagesThresholdHigh;
    private long _MessagesThresholdLow;
    private String _Name;
    private String _Notes;
    private int _PriorityOverride;
    private long _RedeliveryDelayOverride;
    private int _RedeliveryLimit;
    private String _StoreEnabled;
    private JMSTemplateMBean _Template;
    private String _TimeToDeliverOverride;
    private long _TimeToLiveOverride;
    private JMSQueue _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JMSQueueMBeanImpl() {
        try {
            this._customizer = new JMSQueue(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSQueueMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JMSQueue(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSDestinationKeyMBean[] getDestinationKeys() {
        return this._customizer.getDestinationKeys();
    }

    public String getDestinationKeysAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getDestinationKeys());
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public JMSTemplateMBean getTemplate() {
        return this._customizer.getTemplate();
    }

    public String getTemplateAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getTemplate();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDestinationKeysSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTemplateSet() {
        return this._isSet(25);
    }

    public void setDestinationKeysAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = this._DestinationKeys;
            this._initializeProperty(7);
            this._postSet(7, jMSDestinationKeyMBeanArray, this._DestinationKeys);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._DestinationKeys);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, JMSDestinationKeyMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JMSQueueMBeanImpl.this.addDestinationKey((JMSDestinationKeyMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (JMSDestinationKeyMBean jMSDestinationKeyMBean : this._DestinationKeys) {
                    if (!string2.equals(jMSDestinationKeyMBean.getName())) continue;
                    try {
                        this.removeDestinationKey(jMSDestinationKeyMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setTemplateAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSTemplateMBean jMSTemplateMBean = this._Template;
            this._initializeProperty(25);
            this._postSet(25, jMSTemplateMBean, this._Template);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JMSTemplateMBean.class, new ReferenceManager.Resolver(this, 25){

                public void resolveReference(Object object) {
                    try {
                        JMSQueueMBeanImpl.this.setTemplate((JMSTemplateMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void useDelegates(DomainMBean domainMBean, JMSBean jMSBean, QueueBean queueBean) {
        this._customizer.useDelegates(domainMBean, jMSBean, queueBean);
    }

    public boolean addDestinationKey(JMSDestinationKeyMBean jMSDestinationKeyMBean) {
        this._getHelper()._ensureNonNull((Object)jMSDestinationKeyMBean);
        if (!((AbstractDescriptorBean)jMSDestinationKeyMBean).isChildProperty((DescriptorBean)this, 7)) {
            JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = (JMSDestinationKeyMBean[])this._getHelper()._extendArray((Object)this.getDestinationKeys(), JMSDestinationKeyMBean.class, (Object)jMSDestinationKeyMBean);
            try {
                this.setDestinationKeys(jMSDestinationKeyMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTemplate(JMSTemplateMBean jMSTemplateMBean) throws InvalidAttributeValueException {
        JMSTemplateMBean jMSTemplateMBean2 = this.getTemplate();
        this._customizer.setTemplate(jMSTemplateMBean);
        this._postSet(25, jMSTemplateMBean2, jMSTemplateMBean);
    }

    public String getJNDIName() {
        return this._customizer.getJNDIName();
    }

    public String getNotes() {
        return this._customizer.getNotes();
    }

    public boolean isJNDINameSet() {
        return this._isSet(26);
    }

    public boolean isNotesSet() {
        return this._isSet(3);
    }

    public void setDestinationKeys(JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray) throws InvalidAttributeValueException {
        jMSDestinationKeyMBeanArray = jMSDestinationKeyMBeanArray == null ? new JMSDestinationKeyMBeanImpl[]{} : jMSDestinationKeyMBeanArray;
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray2 = this.getDestinationKeys();
        this._customizer.setDestinationKeys(jMSDestinationKeyMBeanArray);
        this._postSet(7, jMSDestinationKeyMBeanArray2, jMSDestinationKeyMBeanArray);
    }

    public boolean removeDestinationKey(JMSDestinationKeyMBean jMSDestinationKeyMBean) {
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = this.getDestinationKeys();
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray2 = (JMSDestinationKeyMBean[])this._getHelper()._removeElement((Object)jMSDestinationKeyMBeanArray, JMSDestinationKeyMBean.class, (Object)jMSDestinationKeyMBean);
        if (jMSDestinationKeyMBeanArray2.length != jMSDestinationKeyMBeanArray.length) {
            try {
                this.setDestinationKeys(jMSDestinationKeyMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setJNDIName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getJNDIName();
        this._customizer.setJNDIName(string);
        this._postSet(26, string2, string);
    }

    public void setNotes(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String string2 = this.getNotes();
        this._customizer.setNotes(string);
        this._postSet(3, string2, string);
    }

    public long getBytesMaximum() {
        return this._customizer.getBytesMaximum();
    }

    public boolean isBytesMaximumSet() {
        return this._isSet(8);
    }

    public boolean isJNDINameReplicated() {
        return this._customizer.isJNDINameReplicated();
    }

    public boolean isJNDINameReplicatedSet() {
        return this._isSet(27);
    }

    public void setBytesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesMaximum", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getBytesMaximum();
        this._customizer.setBytesMaximum(l);
        this._postSet(8, l2, l);
    }

    public void setJNDINameReplicated(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isJNDINameReplicated();
        this._customizer.setJNDINameReplicated(bl);
        this._postSet(27, bl2, bl);
    }

    public long getBytesThresholdHigh() {
        return this._customizer.getBytesThresholdHigh();
    }

    public String getStoreEnabled() {
        return this._customizer.getStoreEnabled();
    }

    public boolean isBytesThresholdHighSet() {
        return this._isSet(9);
    }

    public boolean isStoreEnabledSet() {
        return this._isSet(28);
    }

    public void setBytesThresholdHigh(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesThresholdHigh", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getBytesThresholdHigh();
        this._customizer.setBytesThresholdHigh(l);
        this._postSet(9, l2, l);
    }

    public void setStoreEnabled(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"default", "false", "true"};
        string = LegalChecks.checkInEnum((String)"StoreEnabled", (String)string, (String[])stringArray);
        String string2 = this.getStoreEnabled();
        this._customizer.setStoreEnabled(string);
        this._postSet(28, string2, string);
    }

    public long getBytesThresholdLow() {
        return this._customizer.getBytesThresholdLow();
    }

    public boolean isBytesThresholdLowSet() {
        return this._isSet(10);
    }

    public void setBytesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesThresholdLow", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getBytesThresholdLow();
        this._customizer.setBytesThresholdLow(l);
        this._postSet(10, l2, l);
    }

    public long getMessagesMaximum() {
        return this._customizer.getMessagesMaximum();
    }

    public boolean isMessagesMaximumSet() {
        return this._isSet(11);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setMessagesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesMaximum", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getMessagesMaximum();
        this._customizer.setMessagesMaximum(l);
        this._postSet(11, l2, l);
    }

    public long getMessagesThresholdHigh() {
        return this._customizer.getMessagesThresholdHigh();
    }

    public boolean isMessagesThresholdHighSet() {
        return this._isSet(12);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setMessagesThresholdHigh(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesThresholdHigh", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getMessagesThresholdHigh();
        this._customizer.setMessagesThresholdHigh(l);
        this._postSet(12, l2, l);
    }

    public long getMessagesThresholdLow() {
        return this._customizer.getMessagesThresholdLow();
    }

    public boolean isMessagesThresholdLowSet() {
        return this._isSet(13);
    }

    public void setMessagesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesThresholdLow", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getMessagesThresholdLow();
        this._customizer.setMessagesThresholdLow(l);
        this._postSet(13, l2, l);
    }

    public int getPriorityOverride() {
        return this._customizer.getPriorityOverride();
    }

    public boolean isPriorityOverrideSet() {
        return this._isSet(14);
    }

    public void setPriorityOverride(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"PriorityOverride", (long)n, (long)-1L, (long)9L);
        int n2 = this.getPriorityOverride();
        this._customizer.setPriorityOverride(n);
        this._postSet(14, n2, n);
    }

    public String getTimeToDeliverOverride() {
        return this._customizer.getTimeToDeliverOverride();
    }

    public boolean isTimeToDeliverOverrideSet() {
        return this._isSet(15);
    }

    public void setTimeToDeliverOverride(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        JMSModuleValidator.validateTimeToDeliverOverride(string);
        String string2 = this.getTimeToDeliverOverride();
        this._customizer.setTimeToDeliverOverride(string);
        this._postSet(15, string2, string);
    }

    public long getRedeliveryDelayOverride() {
        return this._customizer.getRedeliveryDelayOverride();
    }

    public boolean isRedeliveryDelayOverrideSet() {
        return this._isSet(16);
    }

    public void setRedeliveryDelayOverride(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"RedeliveryDelayOverride", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getRedeliveryDelayOverride();
        this._customizer.setRedeliveryDelayOverride(l);
        this._postSet(16, l2, l);
    }

    public void setErrorDestination(JMSDestinationMBean jMSDestinationMBean) throws InvalidAttributeValueException, DistributedManagementException {
        JMSDestinationMBean jMSDestinationMBean2 = this.getErrorDestination();
        this._customizer.setErrorDestination(jMSDestinationMBean);
        this._postSet(17, jMSDestinationMBean2, jMSDestinationMBean);
    }

    public JMSDestinationMBean getErrorDestination() {
        return this._customizer.getErrorDestination();
    }

    public String getErrorDestinationAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getErrorDestination();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isErrorDestinationSet() {
        return this._isSet(17);
    }

    public void setErrorDestinationAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSDestinationMBean jMSDestinationMBean = this._ErrorDestination;
            this._initializeProperty(17);
            this._postSet(17, jMSDestinationMBean, this._ErrorDestination);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JMSDestinationMBean.class, new ReferenceManager.Resolver(this, 17){

                public void resolveReference(Object object) {
                    try {
                        JMSQueueMBeanImpl.this.setErrorDestination((JMSDestinationMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public int getRedeliveryLimit() {
        return this._customizer.getRedeliveryLimit();
    }

    public boolean isRedeliveryLimitSet() {
        return this._isSet(18);
    }

    public void setRedeliveryLimit(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"RedeliveryLimit", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this.getRedeliveryLimit();
        this._customizer.setRedeliveryLimit(n);
        this._postSet(18, n2, n);
    }

    public long getTimeToLiveOverride() {
        return this._customizer.getTimeToLiveOverride();
    }

    public boolean isTimeToLiveOverrideSet() {
        return this._isSet(19);
    }

    public void setTimeToLiveOverride(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"TimeToLiveOverride", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getTimeToLiveOverride();
        this._customizer.setTimeToLiveOverride(l);
        this._postSet(19, l2, l);
    }

    public String getDeliveryModeOverride() {
        return this._customizer.getDeliveryModeOverride();
    }

    public boolean isDeliveryModeOverrideSet() {
        return this._isSet(20);
    }

    public void setDeliveryModeOverride(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Persistent", "Non-Persistent", "No-Delivery"};
        string = LegalChecks.checkInEnum((String)"DeliveryModeOverride", (String)string, (String[])stringArray);
        String string2 = this.getDeliveryModeOverride();
        this._customizer.setDeliveryModeOverride(string);
        this._postSet(20, string2, string);
    }

    public void setExpirationPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Discard", "Log", "Redirect"};
        string = LegalChecks.checkInEnum((String)"ExpirationPolicy", (String)string, (String[])stringArray);
        String string2 = this.getExpirationPolicy();
        this._customizer.setExpirationPolicy(string);
        this._postSet(21, string2, string);
    }

    public String getExpirationPolicy() {
        return this._customizer.getExpirationPolicy();
    }

    public boolean isExpirationPolicySet() {
        return this._isSet(21);
    }

    public void setExpirationLoggingPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getExpirationLoggingPolicy();
        this._customizer.setExpirationLoggingPolicy(string);
        this._postSet(22, string2, string);
    }

    public String getExpirationLoggingPolicy() {
        return this._customizer.getExpirationLoggingPolicy();
    }

    public boolean isExpirationLoggingPolicySet() {
        return this._isSet(22);
    }

    public int getMaximumMessageSize() {
        return this._customizer.getMaximumMessageSize();
    }

    public boolean isMaximumMessageSizeSet() {
        return this._isSet(23);
    }

    public void setMaximumMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaximumMessageSize", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getMaximumMessageSize();
        this._customizer.setMaximumMessageSize(n);
        this._postSet(23, n2, n);
    }

    public long getCreationTime() {
        return this._customizer.getCreationTime();
    }

    public boolean isCreationTimeSet() {
        return this._isSet(24);
    }

    public void setCreationTime(long l) {
        long l2 = this.getCreationTime();
        this._customizer.setCreationTime(l);
        this._postSet(24, l2, l);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _preDestroy() {
        this._customizer._preDestroy();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._customizer.setBytesMaximum(-1L);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setBytesThresholdHigh(-1L);
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setBytesThresholdLow(-1L);
                    if (bl) break;
                }
                case 24: {
                    this._customizer.setCreationTime(1L);
                    if (bl) break;
                }
                case 20: {
                    this._customizer.setDeliveryModeOverride("No-Delivery");
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setDestinationKeys(new JMSDestinationKeyMBean[0]);
                    if (bl) break;
                }
                case 17: {
                    this._customizer.setErrorDestination(null);
                    if (bl) break;
                }
                case 22: {
                    this._customizer.setExpirationLoggingPolicy(null);
                    if (bl) break;
                }
                case 21: {
                    this._customizer.setExpirationPolicy("Discard");
                    if (bl) break;
                }
                case 26: {
                    this._customizer.setJNDIName(null);
                    if (bl) break;
                }
                case 23: {
                    this._customizer.setMaximumMessageSize(Integer.MAX_VALUE);
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setMessagesMaximum(-1L);
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setMessagesThresholdHigh(-1L);
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setMessagesThresholdLow(-1L);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 3: {
                    this._customizer.setNotes(null);
                    if (bl) break;
                }
                case 14: {
                    this._customizer.setPriorityOverride(-1);
                    if (bl) break;
                }
                case 16: {
                    this._customizer.setRedeliveryDelayOverride(-1L);
                    if (bl) break;
                }
                case 18: {
                    this._customizer.setRedeliveryLimit(-1);
                    if (bl) break;
                }
                case 28: {
                    this._customizer.setStoreEnabled("default");
                    if (bl) break;
                }
                case 25: {
                    this._customizer.setTemplate(null);
                    if (bl) break;
                }
                case 15: {
                    this._customizer.setTimeToDeliverOverride("-1");
                    if (bl) break;
                }
                case 19: {
                    this._customizer.setTimeToLiveOverride(-1L);
                    if (bl) break;
                }
                case 27: {
                    this._customizer.setJNDINameReplicated(true);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMSQueue";
    }

    public void putValue(String string, Object object) {
        if (string.equals("BytesMaximum")) {
            long l = this._BytesMaximum;
            this._BytesMaximum = (Long)object;
            this._postSet(8, l, this._BytesMaximum);
            return;
        }
        if (string.equals("BytesThresholdHigh")) {
            long l = this._BytesThresholdHigh;
            this._BytesThresholdHigh = (Long)object;
            this._postSet(9, l, this._BytesThresholdHigh);
            return;
        }
        if (string.equals("BytesThresholdLow")) {
            long l = this._BytesThresholdLow;
            this._BytesThresholdLow = (Long)object;
            this._postSet(10, l, this._BytesThresholdLow);
            return;
        }
        if (string.equals("CreationTime")) {
            long l = this._CreationTime;
            this._CreationTime = (Long)object;
            this._postSet(24, l, this._CreationTime);
            return;
        }
        if (string.equals("DeliveryModeOverride")) {
            String string2 = this._DeliveryModeOverride;
            this._DeliveryModeOverride = (String)object;
            this._postSet(20, string2, this._DeliveryModeOverride);
            return;
        }
        if (string.equals("DestinationKeys")) {
            JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = this._DestinationKeys;
            this._DestinationKeys = (JMSDestinationKeyMBean[])object;
            this._postSet(7, jMSDestinationKeyMBeanArray, this._DestinationKeys);
            return;
        }
        if (string.equals("ErrorDestination")) {
            JMSDestinationMBean jMSDestinationMBean = this._ErrorDestination;
            this._ErrorDestination = (JMSDestinationMBean)object;
            this._postSet(17, jMSDestinationMBean, this._ErrorDestination);
            return;
        }
        if (string.equals("ExpirationLoggingPolicy")) {
            String string3 = this._ExpirationLoggingPolicy;
            this._ExpirationLoggingPolicy = (String)object;
            this._postSet(22, string3, this._ExpirationLoggingPolicy);
            return;
        }
        if (string.equals("ExpirationPolicy")) {
            String string4 = this._ExpirationPolicy;
            this._ExpirationPolicy = (String)object;
            this._postSet(21, string4, this._ExpirationPolicy);
            return;
        }
        if (string.equals("JNDIName")) {
            String string5 = this._JNDIName;
            this._JNDIName = (String)object;
            this._postSet(26, string5, this._JNDIName);
            return;
        }
        if (string.equals("JNDINameReplicated")) {
            boolean bl = this._JNDINameReplicated;
            this._JNDINameReplicated = (Boolean)object;
            this._postSet(27, bl, this._JNDINameReplicated);
            return;
        }
        if (string.equals("MaximumMessageSize")) {
            int n = this._MaximumMessageSize;
            this._MaximumMessageSize = (Integer)object;
            this._postSet(23, n, this._MaximumMessageSize);
            return;
        }
        if (string.equals("MessagesMaximum")) {
            long l = this._MessagesMaximum;
            this._MessagesMaximum = (Long)object;
            this._postSet(11, l, this._MessagesMaximum);
            return;
        }
        if (string.equals("MessagesThresholdHigh")) {
            long l = this._MessagesThresholdHigh;
            this._MessagesThresholdHigh = (Long)object;
            this._postSet(12, l, this._MessagesThresholdHigh);
            return;
        }
        if (string.equals("MessagesThresholdLow")) {
            long l = this._MessagesThresholdLow;
            this._MessagesThresholdLow = (Long)object;
            this._postSet(13, l, this._MessagesThresholdLow);
            return;
        }
        if (string.equals("Name")) {
            String string6 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string6, this._Name);
            return;
        }
        if (string.equals("Notes")) {
            String string7 = this._Notes;
            this._Notes = (String)object;
            this._postSet(3, string7, this._Notes);
            return;
        }
        if (string.equals("PriorityOverride")) {
            int n = this._PriorityOverride;
            this._PriorityOverride = (Integer)object;
            this._postSet(14, n, this._PriorityOverride);
            return;
        }
        if (string.equals("RedeliveryDelayOverride")) {
            long l = this._RedeliveryDelayOverride;
            this._RedeliveryDelayOverride = (Long)object;
            this._postSet(16, l, this._RedeliveryDelayOverride);
            return;
        }
        if (string.equals("RedeliveryLimit")) {
            int n = this._RedeliveryLimit;
            this._RedeliveryLimit = (Integer)object;
            this._postSet(18, n, this._RedeliveryLimit);
            return;
        }
        if (string.equals("StoreEnabled")) {
            String string8 = this._StoreEnabled;
            this._StoreEnabled = (String)object;
            this._postSet(28, string8, this._StoreEnabled);
            return;
        }
        if (string.equals("Template")) {
            JMSTemplateMBean jMSTemplateMBean = this._Template;
            this._Template = (JMSTemplateMBean)object;
            this._postSet(25, jMSTemplateMBean, this._Template);
            return;
        }
        if (string.equals("TimeToDeliverOverride")) {
            String string9 = this._TimeToDeliverOverride;
            this._TimeToDeliverOverride = (String)object;
            this._postSet(15, string9, this._TimeToDeliverOverride);
            return;
        }
        if (string.equals("TimeToLiveOverride")) {
            long l = this._TimeToLiveOverride;
            this._TimeToLiveOverride = (Long)object;
            this._postSet(19, l, this._TimeToLiveOverride);
            return;
        }
        if (string.equals("customizer")) {
            JMSQueue jMSQueue = this._customizer;
            this._customizer = (JMSQueue)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("BytesMaximum")) {
            return new Long(this._BytesMaximum);
        }
        if (string.equals("BytesThresholdHigh")) {
            return new Long(this._BytesThresholdHigh);
        }
        if (string.equals("BytesThresholdLow")) {
            return new Long(this._BytesThresholdLow);
        }
        if (string.equals("CreationTime")) {
            return new Long(this._CreationTime);
        }
        if (string.equals("DeliveryModeOverride")) {
            return this._DeliveryModeOverride;
        }
        if (string.equals("DestinationKeys")) {
            return this._DestinationKeys;
        }
        if (string.equals("ErrorDestination")) {
            return this._ErrorDestination;
        }
        if (string.equals("ExpirationLoggingPolicy")) {
            return this._ExpirationLoggingPolicy;
        }
        if (string.equals("ExpirationPolicy")) {
            return this._ExpirationPolicy;
        }
        if (string.equals("JNDIName")) {
            return this._JNDIName;
        }
        if (string.equals("JNDINameReplicated")) {
            return new Boolean(this._JNDINameReplicated);
        }
        if (string.equals("MaximumMessageSize")) {
            return new Integer(this._MaximumMessageSize);
        }
        if (string.equals("MessagesMaximum")) {
            return new Long(this._MessagesMaximum);
        }
        if (string.equals("MessagesThresholdHigh")) {
            return new Long(this._MessagesThresholdHigh);
        }
        if (string.equals("MessagesThresholdLow")) {
            return new Long(this._MessagesThresholdLow);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Notes")) {
            return this._Notes;
        }
        if (string.equals("PriorityOverride")) {
            return new Integer(this._PriorityOverride);
        }
        if (string.equals("RedeliveryDelayOverride")) {
            return new Long(this._RedeliveryDelayOverride);
        }
        if (string.equals("RedeliveryLimit")) {
            return new Integer(this._RedeliveryLimit);
        }
        if (string.equals("StoreEnabled")) {
            return this._StoreEnabled;
        }
        if (string.equals("Template")) {
            return this._Template;
        }
        if (string.equals("TimeToDeliverOverride")) {
            return this._TimeToDeliverOverride;
        }
        if (string.equals("TimeToLiveOverride")) {
            return new Long(this._TimeToLiveOverride);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends JMSDestinationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (string.equals("bytes-maximum")) {
                        return 8;
                    }
                    if (string.equals("creation-time")) {
                        return 24;
                    }
                    if (!string.equals("store-enabled")) break;
                    return 28;
                }
                case 20: {
                    if (string.equals("bytes-threshold-high")) {
                        return 9;
                    }
                    if (string.equals("maximum-message-size")) {
                        return 23;
                    }
                    if (!string.equals("jndi-name-replicated")) break;
                    return 27;
                }
                case 19: {
                    if (!string.equals("bytes-threshold-low")) break;
                    return 10;
                }
                case 22: {
                    if (string.equals("delivery-mode-override")) {
                        return 20;
                    }
                    if (!string.equals("messages-threshold-low")) break;
                    return 13;
                }
                case 15: {
                    if (!string.equals("destination-key")) break;
                    return 7;
                }
                case 17: {
                    if (string.equals("error-destination")) {
                        return 17;
                    }
                    if (string.equals("expiration-policy")) {
                        return 21;
                    }
                    if (!string.equals("priority-override")) break;
                    return 14;
                }
                case 25: {
                    if (string.equals("expiration-logging-policy")) {
                        return 22;
                    }
                    if (!string.equals("redelivery-delay-override")) break;
                    return 16;
                }
                case 9: {
                    if (!string.equals("jndi-name")) break;
                    return 26;
                }
                case 16: {
                    if (string.equals("messages-maximum")) {
                        return 11;
                    }
                    if (!string.equals("redelivery-limit")) break;
                    return 18;
                }
                case 23: {
                    if (!string.equals("messages-threshold-high")) break;
                    return 12;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 5: {
                    if (!string.equals("notes")) break;
                    return 3;
                }
                case 8: {
                    if (!string.equals("template")) break;
                    return 25;
                }
                case 24: {
                    if (!string.equals("time-to-deliver-override")) break;
                    return 15;
                }
                case 21: {
                    if (!string.equals("time-to-live-override")) break;
                    return 19;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "bytes-maximum";
                }
                case 9: {
                    return "bytes-threshold-high";
                }
                case 10: {
                    return "bytes-threshold-low";
                }
                case 24: {
                    return "creation-time";
                }
                case 20: {
                    return "delivery-mode-override";
                }
                case 7: {
                    return "destination-key";
                }
                case 17: {
                    return "error-destination";
                }
                case 22: {
                    return "expiration-logging-policy";
                }
                case 21: {
                    return "expiration-policy";
                }
                case 26: {
                    return "jndi-name";
                }
                case 23: {
                    return "maximum-message-size";
                }
                case 11: {
                    return "messages-maximum";
                }
                case 12: {
                    return "messages-threshold-high";
                }
                case 13: {
                    return "messages-threshold-low";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "notes";
                }
                case 14: {
                    return "priority-override";
                }
                case 16: {
                    return "redelivery-delay-override";
                }
                case 18: {
                    return "redelivery-limit";
                }
                case 28: {
                    return "store-enabled";
                }
                case 25: {
                    return "template";
                }
                case 15: {
                    return "time-to-deliver-override";
                }
                case 19: {
                    return "time-to-live-override";
                }
                case 27: {
                    return "jndi-name-replicated";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends JMSDestinationMBeanImpl.Helper {
        private JMSQueueMBeanImpl bean;

        protected Helper(JMSQueueMBeanImpl jMSQueueMBeanImpl) {
            super(jMSQueueMBeanImpl);
            this.bean = jMSQueueMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "BytesMaximum";
                }
                case 9: {
                    return "BytesThresholdHigh";
                }
                case 10: {
                    return "BytesThresholdLow";
                }
                case 24: {
                    return "CreationTime";
                }
                case 20: {
                    return "DeliveryModeOverride";
                }
                case 7: {
                    return "DestinationKeys";
                }
                case 17: {
                    return "ErrorDestination";
                }
                case 22: {
                    return "ExpirationLoggingPolicy";
                }
                case 21: {
                    return "ExpirationPolicy";
                }
                case 26: {
                    return "JNDIName";
                }
                case 23: {
                    return "MaximumMessageSize";
                }
                case 11: {
                    return "MessagesMaximum";
                }
                case 12: {
                    return "MessagesThresholdHigh";
                }
                case 13: {
                    return "MessagesThresholdLow";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Notes";
                }
                case 14: {
                    return "PriorityOverride";
                }
                case 16: {
                    return "RedeliveryDelayOverride";
                }
                case 18: {
                    return "RedeliveryLimit";
                }
                case 28: {
                    return "StoreEnabled";
                }
                case 25: {
                    return "Template";
                }
                case 15: {
                    return "TimeToDeliverOverride";
                }
                case 19: {
                    return "TimeToLiveOverride";
                }
                case 27: {
                    return "JNDINameReplicated";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BytesMaximum")) {
                return 8;
            }
            if (string.equals("BytesThresholdHigh")) {
                return 9;
            }
            if (string.equals("BytesThresholdLow")) {
                return 10;
            }
            if (string.equals("CreationTime")) {
                return 24;
            }
            if (string.equals("DeliveryModeOverride")) {
                return 20;
            }
            if (string.equals("DestinationKeys")) {
                return 7;
            }
            if (string.equals("ErrorDestination")) {
                return 17;
            }
            if (string.equals("ExpirationLoggingPolicy")) {
                return 22;
            }
            if (string.equals("ExpirationPolicy")) {
                return 21;
            }
            if (string.equals("JNDIName")) {
                return 26;
            }
            if (string.equals("MaximumMessageSize")) {
                return 23;
            }
            if (string.equals("MessagesMaximum")) {
                return 11;
            }
            if (string.equals("MessagesThresholdHigh")) {
                return 12;
            }
            if (string.equals("MessagesThresholdLow")) {
                return 13;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Notes")) {
                return 3;
            }
            if (string.equals("PriorityOverride")) {
                return 14;
            }
            if (string.equals("RedeliveryDelayOverride")) {
                return 16;
            }
            if (string.equals("RedeliveryLimit")) {
                return 18;
            }
            if (string.equals("StoreEnabled")) {
                return 28;
            }
            if (string.equals("Template")) {
                return 25;
            }
            if (string.equals("TimeToDeliverOverride")) {
                return 15;
            }
            if (string.equals("TimeToLiveOverride")) {
                return 19;
            }
            if (string.equals("JNDINameReplicated")) {
                return 27;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBytesMaximumSet()) {
                    stringBuffer.append("BytesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getBytesMaximum()));
                }
                if (this.bean.isBytesThresholdHighSet()) {
                    stringBuffer.append("BytesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdHigh()));
                }
                if (this.bean.isBytesThresholdLowSet()) {
                    stringBuffer.append("BytesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdLow()));
                }
                if (this.bean.isCreationTimeSet()) {
                    stringBuffer.append("CreationTime");
                    stringBuffer.append(String.valueOf(this.bean.getCreationTime()));
                }
                if (this.bean.isDeliveryModeOverrideSet()) {
                    stringBuffer.append("DeliveryModeOverride");
                    stringBuffer.append(String.valueOf(this.bean.getDeliveryModeOverride()));
                }
                if (this.bean.isDestinationKeysSet()) {
                    stringBuffer.append("DestinationKeys");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getDestinationKeys())));
                }
                if (this.bean.isErrorDestinationSet()) {
                    stringBuffer.append("ErrorDestination");
                    stringBuffer.append(String.valueOf(this.bean.getErrorDestination()));
                }
                if (this.bean.isExpirationLoggingPolicySet()) {
                    stringBuffer.append("ExpirationLoggingPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getExpirationLoggingPolicy()));
                }
                if (this.bean.isExpirationPolicySet()) {
                    stringBuffer.append("ExpirationPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getExpirationPolicy()));
                }
                if (this.bean.isJNDINameSet()) {
                    stringBuffer.append("JNDIName");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIName()));
                }
                if (this.bean.isMaximumMessageSizeSet()) {
                    stringBuffer.append("MaximumMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumMessageSize()));
                }
                if (this.bean.isMessagesMaximumSet()) {
                    stringBuffer.append("MessagesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesMaximum()));
                }
                if (this.bean.isMessagesThresholdHighSet()) {
                    stringBuffer.append("MessagesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdHigh()));
                }
                if (this.bean.isMessagesThresholdLowSet()) {
                    stringBuffer.append("MessagesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdLow()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNotesSet()) {
                    stringBuffer.append("Notes");
                    stringBuffer.append(String.valueOf(this.bean.getNotes()));
                }
                if (this.bean.isPriorityOverrideSet()) {
                    stringBuffer.append("PriorityOverride");
                    stringBuffer.append(String.valueOf(this.bean.getPriorityOverride()));
                }
                if (this.bean.isRedeliveryDelayOverrideSet()) {
                    stringBuffer.append("RedeliveryDelayOverride");
                    stringBuffer.append(String.valueOf(this.bean.getRedeliveryDelayOverride()));
                }
                if (this.bean.isRedeliveryLimitSet()) {
                    stringBuffer.append("RedeliveryLimit");
                    stringBuffer.append(String.valueOf(this.bean.getRedeliveryLimit()));
                }
                if (this.bean.isStoreEnabledSet()) {
                    stringBuffer.append("StoreEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getStoreEnabled()));
                }
                if (this.bean.isTemplateSet()) {
                    stringBuffer.append("Template");
                    stringBuffer.append(String.valueOf(this.bean.getTemplate()));
                }
                if (this.bean.isTimeToDeliverOverrideSet()) {
                    stringBuffer.append("TimeToDeliverOverride");
                    stringBuffer.append(String.valueOf(this.bean.getTimeToDeliverOverride()));
                }
                if (this.bean.isTimeToLiveOverrideSet()) {
                    stringBuffer.append("TimeToLiveOverride");
                    stringBuffer.append(String.valueOf(this.bean.getTimeToLiveOverride()));
                }
                if (this.bean.isJNDINameReplicatedSet()) {
                    stringBuffer.append("JNDINameReplicated");
                    stringBuffer.append(String.valueOf(this.bean.isJNDINameReplicated()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMSQueueMBeanImpl jMSQueueMBeanImpl = (JMSQueueMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesMaximum", this.bean.getBytesMaximum(), jMSQueueMBeanImpl.getBytesMaximum(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesThresholdHigh", this.bean.getBytesThresholdHigh(), jMSQueueMBeanImpl.getBytesThresholdHigh(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesThresholdLow", this.bean.getBytesThresholdLow(), jMSQueueMBeanImpl.getBytesThresholdLow(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("CreationTime", this.bean.getCreationTime(), jMSQueueMBeanImpl.getCreationTime(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DeliveryModeOverride", this.bean.getDeliveryModeOverride(), jMSQueueMBeanImpl.getDeliveryModeOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DestinationKeys", this.bean.getDestinationKeys(), jMSQueueMBeanImpl.getDestinationKeys(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ErrorDestination", this.bean.getErrorDestination(), jMSQueueMBeanImpl.getErrorDestination(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ExpirationLoggingPolicy", this.bean.getExpirationLoggingPolicy(), jMSQueueMBeanImpl.getExpirationLoggingPolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ExpirationPolicy", this.bean.getExpirationPolicy(), jMSQueueMBeanImpl.getExpirationPolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JNDIName", this.bean.getJNDIName(), jMSQueueMBeanImpl.getJNDIName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MaximumMessageSize", this.bean.getMaximumMessageSize(), jMSQueueMBeanImpl.getMaximumMessageSize(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesMaximum", this.bean.getMessagesMaximum(), jMSQueueMBeanImpl.getMessagesMaximum(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesThresholdHigh", this.bean.getMessagesThresholdHigh(), jMSQueueMBeanImpl.getMessagesThresholdHigh(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesThresholdLow", this.bean.getMessagesThresholdLow(), jMSQueueMBeanImpl.getMessagesThresholdLow(), true);
                }
                this.computeDiff("Name", this.bean.getName(), jMSQueueMBeanImpl.getName(), false);
                this.computeDiff("Notes", this.bean.getNotes(), jMSQueueMBeanImpl.getNotes(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PriorityOverride", this.bean.getPriorityOverride(), jMSQueueMBeanImpl.getPriorityOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RedeliveryDelayOverride", this.bean.getRedeliveryDelayOverride(), jMSQueueMBeanImpl.getRedeliveryDelayOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RedeliveryLimit", this.bean.getRedeliveryLimit(), jMSQueueMBeanImpl.getRedeliveryLimit(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StoreEnabled", this.bean.getStoreEnabled(), jMSQueueMBeanImpl.getStoreEnabled(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Template", this.bean.getTemplate(), jMSQueueMBeanImpl.getTemplate(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TimeToDeliverOverride", this.bean.getTimeToDeliverOverride(), jMSQueueMBeanImpl.getTimeToDeliverOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TimeToLiveOverride", this.bean.getTimeToLiveOverride(), jMSQueueMBeanImpl.getTimeToLiveOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JNDINameReplicated", this.bean.isJNDINameReplicated(), jMSQueueMBeanImpl.isJNDINameReplicated(), false);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMSQueueMBeanImpl jMSQueueMBeanImpl = (JMSQueueMBeanImpl)beanUpdateEvent.getSourceBean();
                JMSQueueMBeanImpl jMSQueueMBeanImpl2 = (JMSQueueMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BytesMaximum")) {
                    jMSQueueMBeanImpl.setBytesMaximum(jMSQueueMBeanImpl2.getBytesMaximum());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("BytesThresholdHigh")) {
                    jMSQueueMBeanImpl.setBytesThresholdHigh(jMSQueueMBeanImpl2.getBytesThresholdHigh());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("BytesThresholdLow")) {
                    jMSQueueMBeanImpl.setBytesThresholdLow(jMSQueueMBeanImpl2.getBytesThresholdLow());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("CreationTime")) {
                    jMSQueueMBeanImpl.setCreationTime(jMSQueueMBeanImpl2.getCreationTime());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("DeliveryModeOverride")) {
                    jMSQueueMBeanImpl.setDeliveryModeOverride(jMSQueueMBeanImpl2.getDeliveryModeOverride());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("DestinationKeys")) {
                    jMSQueueMBeanImpl.setDestinationKeysAsString(jMSQueueMBeanImpl2.getDestinationKeysAsString());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("ErrorDestination")) {
                    jMSQueueMBeanImpl.setErrorDestinationAsString(jMSQueueMBeanImpl2.getErrorDestinationAsString());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("ExpirationLoggingPolicy")) {
                    jMSQueueMBeanImpl.setExpirationLoggingPolicy(jMSQueueMBeanImpl2.getExpirationLoggingPolicy());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("ExpirationPolicy")) {
                    jMSQueueMBeanImpl.setExpirationPolicy(jMSQueueMBeanImpl2.getExpirationPolicy());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("JNDIName")) {
                    jMSQueueMBeanImpl.setJNDIName(jMSQueueMBeanImpl2.getJNDIName());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("MaximumMessageSize")) {
                    jMSQueueMBeanImpl.setMaximumMessageSize(jMSQueueMBeanImpl2.getMaximumMessageSize());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("MessagesMaximum")) {
                    jMSQueueMBeanImpl.setMessagesMaximum(jMSQueueMBeanImpl2.getMessagesMaximum());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("MessagesThresholdHigh")) {
                    jMSQueueMBeanImpl.setMessagesThresholdHigh(jMSQueueMBeanImpl2.getMessagesThresholdHigh());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("MessagesThresholdLow")) {
                    jMSQueueMBeanImpl.setMessagesThresholdLow(jMSQueueMBeanImpl2.getMessagesThresholdLow());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("Name")) {
                    jMSQueueMBeanImpl.setName(jMSQueueMBeanImpl2.getName());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("Notes")) {
                    jMSQueueMBeanImpl.setNotes(jMSQueueMBeanImpl2.getNotes());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                } else if (string.equals("PriorityOverride")) {
                    jMSQueueMBeanImpl.setPriorityOverride(jMSQueueMBeanImpl2.getPriorityOverride());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("RedeliveryDelayOverride")) {
                    jMSQueueMBeanImpl.setRedeliveryDelayOverride(jMSQueueMBeanImpl2.getRedeliveryDelayOverride());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("RedeliveryLimit")) {
                    jMSQueueMBeanImpl.setRedeliveryLimit(jMSQueueMBeanImpl2.getRedeliveryLimit());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("StoreEnabled")) {
                    jMSQueueMBeanImpl.setStoreEnabled(jMSQueueMBeanImpl2.getStoreEnabled());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("Template")) {
                    jMSQueueMBeanImpl.setTemplateAsString(jMSQueueMBeanImpl2.getTemplateAsString());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("TimeToDeliverOverride")) {
                    jMSQueueMBeanImpl.setTimeToDeliverOverride(jMSQueueMBeanImpl2.getTimeToDeliverOverride());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("TimeToLiveOverride")) {
                    jMSQueueMBeanImpl.setTimeToLiveOverride(jMSQueueMBeanImpl2.getTimeToLiveOverride());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("JNDINameReplicated")) {
                    jMSQueueMBeanImpl.setJNDINameReplicated(jMSQueueMBeanImpl2.isJNDINameReplicated());
                    jMSQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JMSQueueMBeanImpl jMSQueueMBeanImpl = (JMSQueueMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMSQueueMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("BytesMaximum")) && this.bean.isBytesMaximumSet()) {
                    jMSQueueMBeanImpl.setBytesMaximum(this.bean.getBytesMaximum());
                }
                if (bl && (list == null || !list.contains("BytesThresholdHigh")) && this.bean.isBytesThresholdHighSet()) {
                    jMSQueueMBeanImpl.setBytesThresholdHigh(this.bean.getBytesThresholdHigh());
                }
                if (bl && (list == null || !list.contains("BytesThresholdLow")) && this.bean.isBytesThresholdLowSet()) {
                    jMSQueueMBeanImpl.setBytesThresholdLow(this.bean.getBytesThresholdLow());
                }
                if (bl && (list == null || !list.contains("CreationTime")) && this.bean.isCreationTimeSet()) {
                    jMSQueueMBeanImpl.setCreationTime(this.bean.getCreationTime());
                }
                if (bl && (list == null || !list.contains("DeliveryModeOverride")) && this.bean.isDeliveryModeOverrideSet()) {
                    jMSQueueMBeanImpl.setDeliveryModeOverride(this.bean.getDeliveryModeOverride());
                }
                if (bl && (list == null || !list.contains("DestinationKeys")) && this.bean.isDestinationKeysSet()) {
                    jMSQueueMBeanImpl._unSet(jMSQueueMBeanImpl, 7);
                    jMSQueueMBeanImpl.setDestinationKeysAsString(this.bean.getDestinationKeysAsString());
                }
                if (bl && (list == null || !list.contains("ErrorDestination")) && this.bean.isErrorDestinationSet()) {
                    jMSQueueMBeanImpl._unSet(jMSQueueMBeanImpl, 17);
                    jMSQueueMBeanImpl.setErrorDestinationAsString(this.bean.getErrorDestinationAsString());
                }
                if (bl && (list == null || !list.contains("ExpirationLoggingPolicy")) && this.bean.isExpirationLoggingPolicySet()) {
                    jMSQueueMBeanImpl.setExpirationLoggingPolicy(this.bean.getExpirationLoggingPolicy());
                }
                if (bl && (list == null || !list.contains("ExpirationPolicy")) && this.bean.isExpirationPolicySet()) {
                    jMSQueueMBeanImpl.setExpirationPolicy(this.bean.getExpirationPolicy());
                }
                if (bl && (list == null || !list.contains("JNDIName")) && this.bean.isJNDINameSet()) {
                    jMSQueueMBeanImpl.setJNDIName(this.bean.getJNDIName());
                }
                if (bl && (list == null || !list.contains("MaximumMessageSize")) && this.bean.isMaximumMessageSizeSet()) {
                    jMSQueueMBeanImpl.setMaximumMessageSize(this.bean.getMaximumMessageSize());
                }
                if (bl && (list == null || !list.contains("MessagesMaximum")) && this.bean.isMessagesMaximumSet()) {
                    jMSQueueMBeanImpl.setMessagesMaximum(this.bean.getMessagesMaximum());
                }
                if (bl && (list == null || !list.contains("MessagesThresholdHigh")) && this.bean.isMessagesThresholdHighSet()) {
                    jMSQueueMBeanImpl.setMessagesThresholdHigh(this.bean.getMessagesThresholdHigh());
                }
                if (bl && (list == null || !list.contains("MessagesThresholdLow")) && this.bean.isMessagesThresholdLowSet()) {
                    jMSQueueMBeanImpl.setMessagesThresholdLow(this.bean.getMessagesThresholdLow());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jMSQueueMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Notes")) && this.bean.isNotesSet()) {
                    jMSQueueMBeanImpl.setNotes(this.bean.getNotes());
                }
                if (bl && (list == null || !list.contains("PriorityOverride")) && this.bean.isPriorityOverrideSet()) {
                    jMSQueueMBeanImpl.setPriorityOverride(this.bean.getPriorityOverride());
                }
                if (bl && (list == null || !list.contains("RedeliveryDelayOverride")) && this.bean.isRedeliveryDelayOverrideSet()) {
                    jMSQueueMBeanImpl.setRedeliveryDelayOverride(this.bean.getRedeliveryDelayOverride());
                }
                if (bl && (list == null || !list.contains("RedeliveryLimit")) && this.bean.isRedeliveryLimitSet()) {
                    jMSQueueMBeanImpl.setRedeliveryLimit(this.bean.getRedeliveryLimit());
                }
                if (bl && (list == null || !list.contains("StoreEnabled")) && this.bean.isStoreEnabledSet()) {
                    jMSQueueMBeanImpl.setStoreEnabled(this.bean.getStoreEnabled());
                }
                if (bl && (list == null || !list.contains("Template")) && this.bean.isTemplateSet()) {
                    jMSQueueMBeanImpl._unSet(jMSQueueMBeanImpl, 25);
                    jMSQueueMBeanImpl.setTemplateAsString(this.bean.getTemplateAsString());
                }
                if (bl && (list == null || !list.contains("TimeToDeliverOverride")) && this.bean.isTimeToDeliverOverrideSet()) {
                    jMSQueueMBeanImpl.setTimeToDeliverOverride(this.bean.getTimeToDeliverOverride());
                }
                if (bl && (list == null || !list.contains("TimeToLiveOverride")) && this.bean.isTimeToLiveOverrideSet()) {
                    jMSQueueMBeanImpl.setTimeToLiveOverride(this.bean.getTimeToLiveOverride());
                }
                if (bl && (list == null || !list.contains("JNDINameReplicated")) && this.bean.isJNDINameReplicatedSet()) {
                    jMSQueueMBeanImpl.setJNDINameReplicated(this.bean.isJNDINameReplicated());
                }
                return jMSQueueMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDestinationKeys(), clazz, object);
            this.inferSubTree(this.bean.getErrorDestination(), clazz, object);
            this.inferSubTree(this.bean.getTemplate(), clazz, object);
        }
    }
}

