/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSConstants;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSDestinationMBeanImpl;
import weblogic.management.configuration.JMSLegalHelper;
import weblogic.management.configuration.JMSMessageLogFileMBean;
import weblogic.management.configuration.JMSMessageLogFileMBeanImpl;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSQueueMBeanImpl;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.configuration.JMSSessionPoolMBeanImpl;
import weblogic.management.configuration.JMSStoreMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.configuration.JMSTopicMBeanImpl;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.JMSServer;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class JMSServerMBeanImpl
extends DeploymentMBeanImpl
implements JMSServerMBean,
Serializable {
    private boolean _AllowsPersistentDowngrade;
    private String _BlockingSendPolicy;
    private long _BytesMaximum;
    private boolean _BytesPagingEnabled;
    private long _BytesThresholdHigh;
    private long _BytesThresholdLow;
    private String _ConsumptionPausedAtStartup;
    private JMSDestinationMBean[] _Destinations;
    private int _ExpirationScanInterval;
    private boolean _HostingTemporaryDestinations;
    private String _InsertionPausedAtStartup;
    private boolean _JDBCStoreUpgradeEnabled;
    private JMSMessageLogFileMBean _JMSMessageLogFile;
    private JMSQueueMBean[] _JMSQueues;
    private JMSSessionPoolMBean[] _JMSSessionPools;
    private JMSTopicMBean[] _JMSTopics;
    private int _MaximumMessageSize;
    private long _MessageBufferSize;
    private long _MessagesMaximum;
    private boolean _MessagesPagingEnabled;
    private long _MessagesThresholdHigh;
    private long _MessagesThresholdLow;
    private String _Name;
    private int _PagingBlockSize;
    private String _PagingDirectory;
    private boolean _PagingFileLockingEnabled;
    private int _PagingIoBufferSize;
    private long _PagingMaxFileSize;
    private int _PagingMaxWindowBufferSize;
    private int _PagingMinWindowBufferSize;
    private JMSStoreMBean _PagingStore;
    private PersistentStoreMBean _PersistentStore;
    private String _ProductionPausedAtStartup;
    private Set _ServerNames;
    private JMSSessionPoolMBean[] _SessionPools;
    private JMSStoreMBean _Store;
    private boolean _StoreEnabled;
    private TargetMBean[] _Targets;
    private JMSTemplateMBean _TemporaryTemplate;
    private String _TemporaryTemplateName;
    private String _TemporaryTemplateResource;
    private JMSServer _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JMSServerMBeanImpl() {
        try {
            this._customizer = new JMSServer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSServerMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JMSServer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public Set getServerNames() {
        return this._customizer.getServerNames();
    }

    public TargetMBean[] getTargets() {
        return this._Targets;
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isServerNamesSet() {
        return this._isSet(9);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setServerNames(Set set) throws InvalidAttributeValueException {
        this._ServerNames = set;
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JMSServerMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        JMSLegalHelper.validateSingleServerTargets(targetMBeanArray);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JMSServerMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this._Targets;
        this._Targets = targetMBeanArray;
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = this._isSet(7) ? (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean) : new TargetMBean[]{targetMBean};
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public JMSSessionPoolMBean[] getSessionPools() {
        return this._customizer.getSessionPools();
    }

    public boolean isSessionPoolsSet() {
        return this._isSet(10);
    }

    public void setSessionPools(JMSSessionPoolMBean[] jMSSessionPoolMBeanArray) throws InvalidAttributeValueException {
        jMSSessionPoolMBeanArray = jMSSessionPoolMBeanArray == null ? new JMSSessionPoolMBeanImpl[]{} : jMSSessionPoolMBeanArray;
        this._customizer.setSessionPools(jMSSessionPoolMBeanArray);
    }

    public boolean addSessionPool(JMSSessionPoolMBean jMSSessionPoolMBean) throws InvalidAttributeValueException, DistributedManagementException {
        return this._customizer.addSessionPool(jMSSessionPoolMBean);
    }

    public boolean removeSessionPool(JMSSessionPoolMBean jMSSessionPoolMBean) throws InvalidAttributeValueException, DistributedManagementException {
        return this._customizer.removeSessionPool(jMSSessionPoolMBean);
    }

    public void addJMSSessionPool(JMSSessionPoolMBean jMSSessionPoolMBean) {
        this._getHelper()._ensureNonNull((Object)jMSSessionPoolMBean);
        if (!((AbstractDescriptorBean)jMSSessionPoolMBean).isChildProperty((DescriptorBean)this, 11)) {
            JMSSessionPoolMBean[] jMSSessionPoolMBeanArray = this._isSet(11) ? (JMSSessionPoolMBean[])this._getHelper()._extendArray((Object)this.getJMSSessionPools(), JMSSessionPoolMBean.class, (Object)jMSSessionPoolMBean) : new JMSSessionPoolMBean[]{jMSSessionPoolMBean};
            try {
                this.setJMSSessionPools(jMSSessionPoolMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JMSSessionPoolMBean[] getJMSSessionPools() {
        return this._JMSSessionPools;
    }

    public boolean isJMSSessionPoolsSet() {
        return this._isSet(11);
    }

    public void removeJMSSessionPool(JMSSessionPoolMBean jMSSessionPoolMBean) {
        this.destroyJMSSessionPool(jMSSessionPoolMBean);
    }

    public void setJMSSessionPools(JMSSessionPoolMBean[] jMSSessionPoolMBeanArray) throws InvalidAttributeValueException {
        jMSSessionPoolMBeanArray = jMSSessionPoolMBeanArray == null ? new JMSSessionPoolMBeanImpl[]{} : jMSSessionPoolMBeanArray;
        for (int i = 0; i < jMSSessionPoolMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSSessionPoolMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 11)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        JMSSessionPoolMBean[] jMSSessionPoolMBeanArray2 = this._JMSSessionPools;
        this._JMSSessionPools = jMSSessionPoolMBeanArray;
        this._postSet(11, jMSSessionPoolMBeanArray2, jMSSessionPoolMBeanArray);
    }

    public JMSSessionPoolMBean createJMSSessionPool(String string) throws InvalidAttributeValueException, DistributedManagementException {
        JMSSessionPoolMBeanImpl jMSSessionPoolMBeanImpl = new JMSSessionPoolMBeanImpl(this, -1);
        try {
            jMSSessionPoolMBeanImpl.setName(string);
            this.addJMSSessionPool(jMSSessionPoolMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            if (exception instanceof DistributedManagementException) {
                throw (DistributedManagementException)((Object)exception);
            }
            throw new UndeclaredThrowableException(exception);
        }
        return jMSSessionPoolMBeanImpl;
    }

    public JMSSessionPoolMBean createJMSSessionPool(String string, JMSSessionPoolMBean jMSSessionPoolMBean) throws InvalidAttributeValueException, DistributedManagementException {
        return this._customizer.createJMSSessionPool(string, jMSSessionPoolMBean);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void destroyJMSSessionPool(JMSSessionPoolMBean jMSSessionPoolMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(jMSSessionPoolMBean, 11);
                JMSSessionPoolMBean[] jMSSessionPoolMBeanArray = this.getJMSSessionPools();
                JMSSessionPoolMBean[] jMSSessionPoolMBeanArray2 = (JMSSessionPoolMBean[])this._getHelper()._removeElement((Object)jMSSessionPoolMBeanArray, JMSSessionPoolMBean.class, (Object)jMSSessionPoolMBean);
                if (jMSSessionPoolMBeanArray.length == jMSSessionPoolMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)jMSSessionPoolMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSSessionPoolMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setJMSSessionPools(jMSSessionPoolMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public JMSSessionPoolMBean lookupJMSSessionPool(String string) {
        for (JMSSessionPoolMBeanImpl jMSSessionPoolMBeanImpl : Arrays.asList((Object[])this._JMSSessionPools)) {
            String string2 = string;
            if (!jMSSessionPoolMBeanImpl.getName().equals(string2)) continue;
            return jMSSessionPoolMBeanImpl;
        }
        return null;
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public JMSDestinationMBean[] getDestinations() {
        return this._customizer.getDestinations();
    }

    public boolean isDestinationsSet() {
        return this._isSet(12);
    }

    public void setDestinations(JMSDestinationMBean[] jMSDestinationMBeanArray) throws InvalidAttributeValueException {
        jMSDestinationMBeanArray = jMSDestinationMBeanArray == null ? new JMSDestinationMBeanImpl[]{} : jMSDestinationMBeanArray;
        this._customizer.setDestinations(jMSDestinationMBeanArray);
    }

    public boolean addDestination(JMSDestinationMBean jMSDestinationMBean) throws InvalidAttributeValueException, DistributedManagementException {
        return this._customizer.addDestination(jMSDestinationMBean);
    }

    public boolean removeDestination(JMSDestinationMBean jMSDestinationMBean) throws InvalidAttributeValueException, DistributedManagementException {
        return this._customizer.removeDestination(jMSDestinationMBean);
    }

    public JMSStoreMBean getStore() {
        return this._Store;
    }

    public String getStoreAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getStore();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isStoreSet() {
        return this._isSet(13);
    }

    public void setStoreAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSStoreMBean jMSStoreMBean = this._Store;
            this._initializeProperty(13);
            this._postSet(13, jMSStoreMBean, this._Store);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JMSStoreMBean.class, new ReferenceManager.Resolver(this, 13){

                public void resolveReference(Object object) {
                    try {
                        JMSServerMBeanImpl.this.setStore((JMSStoreMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setStore(JMSStoreMBean jMSStoreMBean) throws InvalidAttributeValueException {
        JMSStoreMBean jMSStoreMBean2 = this._Store;
        this._Store = jMSStoreMBean;
        this._postSet(13, jMSStoreMBean2, jMSStoreMBean);
    }

    public PersistentStoreMBean getPersistentStore() {
        return this._PersistentStore;
    }

    public String getPersistentStoreAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getPersistentStore();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isPersistentStoreSet() {
        return this._isSet(14);
    }

    public void setPersistentStoreAsString(String string) {
        if (string == null || string.length() == 0) {
            PersistentStoreMBean persistentStoreMBean = this._PersistentStore;
            this._initializeProperty(14);
            this._postSet(14, persistentStoreMBean, this._PersistentStore);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, PersistentStoreMBean.class, new ReferenceManager.Resolver(this, 14){

                public void resolveReference(Object object) {
                    try {
                        JMSServerMBeanImpl.this.setPersistentStore((PersistentStoreMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setPersistentStore(PersistentStoreMBean persistentStoreMBean) throws InvalidAttributeValueException {
        PersistentStoreMBean persistentStoreMBean2;
        if (persistentStoreMBean != null) {
            persistentStoreMBean2 = new ResolvedReference(this, 14, (AbstractDescriptorBean)persistentStoreMBean){

                protected Object getPropertyValue() {
                    return JMSServerMBeanImpl.this.getPersistentStore();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)persistentStoreMBean, (ResolvedReference)persistentStoreMBean2);
        }
        persistentStoreMBean2 = this._PersistentStore;
        this._PersistentStore = persistentStoreMBean;
        this._postSet(14, persistentStoreMBean2, persistentStoreMBean);
    }

    public boolean getStoreEnabled() {
        return this._StoreEnabled;
    }

    public boolean isStoreEnabledSet() {
        return this._isSet(15);
    }

    public void setStoreEnabled(boolean bl) {
        boolean bl2 = this._StoreEnabled;
        this._StoreEnabled = bl;
        this._postSet(15, bl2, bl);
    }

    public boolean isAllowsPersistentDowngrade() {
        return this._AllowsPersistentDowngrade;
    }

    public boolean isAllowsPersistentDowngradeSet() {
        return this._isSet(16);
    }

    public void setAllowsPersistentDowngrade(boolean bl) {
        boolean bl2 = this._AllowsPersistentDowngrade;
        this._AllowsPersistentDowngrade = bl;
        this._postSet(16, bl2, bl);
    }

    public JMSTemplateMBean getTemporaryTemplate() {
        return this._customizer.getTemporaryTemplate();
    }

    public String getTemporaryTemplateAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getTemporaryTemplate();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isTemporaryTemplateSet() {
        return this._isSet(17);
    }

    public void setTemporaryTemplateAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSTemplateMBean jMSTemplateMBean = this._TemporaryTemplate;
            this._initializeProperty(17);
            this._postSet(17, jMSTemplateMBean, this._TemporaryTemplate);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JMSTemplateMBean.class, new ReferenceManager.Resolver(this, 17){

                public void resolveReference(Object object) {
                    try {
                        JMSServerMBeanImpl.this.setTemporaryTemplate((JMSTemplateMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setTemporaryTemplate(JMSTemplateMBean jMSTemplateMBean) throws InvalidAttributeValueException {
        JMSTemplateMBean jMSTemplateMBean2 = this.getTemporaryTemplate();
        this._customizer.setTemporaryTemplate(jMSTemplateMBean);
        this._postSet(17, jMSTemplateMBean2, jMSTemplateMBean);
    }

    public boolean isHostingTemporaryDestinations() {
        return this._HostingTemporaryDestinations;
    }

    public boolean isHostingTemporaryDestinationsSet() {
        return this._isSet(18);
    }

    public void setHostingTemporaryDestinations(boolean bl) {
        boolean bl2 = this._HostingTemporaryDestinations;
        this._HostingTemporaryDestinations = bl;
        this._postSet(18, bl2, bl);
    }

    public String getTemporaryTemplateResource() {
        return this._TemporaryTemplateResource;
    }

    public boolean isTemporaryTemplateResourceSet() {
        return this._isSet(19);
    }

    public void setTemporaryTemplateResource(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TemporaryTemplateResource;
        this._TemporaryTemplateResource = string;
        this._postSet(19, string2, string);
    }

    public String getTemporaryTemplateName() {
        return this._TemporaryTemplateName;
    }

    public boolean isTemporaryTemplateNameSet() {
        return this._isSet(20);
    }

    public void setTemporaryTemplateName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TemporaryTemplateName;
        this._TemporaryTemplateName = string;
        this._postSet(20, string2, string);
    }

    public long getBytesMaximum() {
        return this._BytesMaximum;
    }

    public boolean isBytesMaximumSet() {
        return this._isSet(21);
    }

    public void setBytesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesMaximum", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._BytesMaximum;
        this._BytesMaximum = l;
        this._postSet(21, l2, l);
    }

    public long getBytesThresholdHigh() {
        return this._BytesThresholdHigh;
    }

    public boolean isBytesThresholdHighSet() {
        return this._isSet(22);
    }

    public void setBytesThresholdHigh(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesThresholdHigh", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._BytesThresholdHigh;
        this._BytesThresholdHigh = l;
        this._postSet(22, l2, l);
    }

    public long getBytesThresholdLow() {
        return this._BytesThresholdLow;
    }

    public boolean isBytesThresholdLowSet() {
        return this._isSet(23);
    }

    public void setBytesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesThresholdLow", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._BytesThresholdLow;
        this._BytesThresholdLow = l;
        this._postSet(23, l2, l);
    }

    public long getMessagesMaximum() {
        return this._MessagesMaximum;
    }

    public boolean isMessagesMaximumSet() {
        return this._isSet(24);
    }

    public void setMessagesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesMaximum", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._MessagesMaximum;
        this._MessagesMaximum = l;
        this._postSet(24, l2, l);
    }

    public long getMessagesThresholdHigh() {
        return this._MessagesThresholdHigh;
    }

    public boolean isMessagesThresholdHighSet() {
        return this._isSet(25);
    }

    public void setMessagesThresholdHigh(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MessagesThresholdHigh", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._MessagesThresholdHigh;
        this._MessagesThresholdHigh = l;
        this._postSet(25, l2, l);
    }

    public long getMessagesThresholdLow() {
        return this._MessagesThresholdLow;
    }

    public boolean isMessagesThresholdLowSet() {
        return this._isSet(26);
    }

    public void setMessagesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesThresholdLow", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._MessagesThresholdLow;
        this._MessagesThresholdLow = l;
        this._postSet(26, l2, l);
    }

    public boolean isJDBCStoreUpgradeEnabled() {
        return this._JDBCStoreUpgradeEnabled;
    }

    public boolean isJDBCStoreUpgradeEnabledSet() {
        return this._isSet(27);
    }

    public void setJDBCStoreUpgradeEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._JDBCStoreUpgradeEnabled;
        this._JDBCStoreUpgradeEnabled = bl;
        this._postSet(27, bl2, bl);
    }

    public JMSStoreMBean getPagingStore() {
        return this._PagingStore;
    }

    public String getPagingStoreAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getPagingStore();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isPagingStoreSet() {
        return this._isSet(28);
    }

    public void setPagingStoreAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSStoreMBean jMSStoreMBean = this._PagingStore;
            this._initializeProperty(28);
            this._postSet(28, jMSStoreMBean, this._PagingStore);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JMSStoreMBean.class, new ReferenceManager.Resolver(this, 28){

                public void resolveReference(Object object) {
                    try {
                        JMSServerMBeanImpl.this.setPagingStore((JMSStoreMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setPagingStore(JMSStoreMBean jMSStoreMBean) throws InvalidAttributeValueException {
        JMSStoreMBean jMSStoreMBean2 = this._PagingStore;
        this._PagingStore = jMSStoreMBean;
        this._postSet(28, jMSStoreMBean2, jMSStoreMBean);
    }

    public boolean isMessagesPagingEnabled() {
        return this._MessagesPagingEnabled;
    }

    public boolean isMessagesPagingEnabledSet() {
        return this._isSet(29);
    }

    public void setMessagesPagingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._MessagesPagingEnabled;
        this._MessagesPagingEnabled = bl;
        this._postSet(29, bl2, bl);
    }

    public boolean isBytesPagingEnabled() {
        return this._BytesPagingEnabled;
    }

    public boolean isBytesPagingEnabledSet() {
        return this._isSet(30);
    }

    public void setBytesPagingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._BytesPagingEnabled;
        this._BytesPagingEnabled = bl;
        this._postSet(30, bl2, bl);
    }

    public long getMessageBufferSize() {
        return this._MessageBufferSize;
    }

    public boolean isMessageBufferSizeSet() {
        return this._isSet(31);
    }

    public void setMessageBufferSize(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MessageBufferSize", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._MessageBufferSize;
        this._MessageBufferSize = l;
        this._postSet(31, l2, l);
    }

    public String getPagingDirectory() {
        return this._PagingDirectory;
    }

    public boolean isPagingDirectorySet() {
        return this._isSet(32);
    }

    public void setPagingDirectory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._PagingDirectory;
        this._PagingDirectory = string;
        this._postSet(32, string2, string);
    }

    public boolean isPagingFileLockingEnabled() {
        return this._PagingFileLockingEnabled;
    }

    public boolean isPagingFileLockingEnabledSet() {
        return this._isSet(33);
    }

    public void setPagingFileLockingEnabled(boolean bl) {
        boolean bl2 = this._PagingFileLockingEnabled;
        this._PagingFileLockingEnabled = bl;
        this._postSet(33, bl2, bl);
    }

    public int getPagingMinWindowBufferSize() {
        return this._PagingMinWindowBufferSize;
    }

    public boolean isPagingMinWindowBufferSizeSet() {
        return this._isSet(34);
    }

    public void setPagingMinWindowBufferSize(int n) {
        LegalChecks.checkInRange((String)"PagingMinWindowBufferSize", (long)n, (long)-1L, (long)0x40000000L);
        int n2 = this._PagingMinWindowBufferSize;
        this._PagingMinWindowBufferSize = n;
        this._postSet(34, n2, n);
    }

    public int getPagingMaxWindowBufferSize() {
        return this._PagingMaxWindowBufferSize;
    }

    public boolean isPagingMaxWindowBufferSizeSet() {
        return this._isSet(35);
    }

    public void setPagingMaxWindowBufferSize(int n) {
        LegalChecks.checkInRange((String)"PagingMaxWindowBufferSize", (long)n, (long)-1L, (long)0x40000000L);
        int n2 = this._PagingMaxWindowBufferSize;
        this._PagingMaxWindowBufferSize = n;
        this._postSet(35, n2, n);
    }

    public int getPagingIoBufferSize() {
        return this._PagingIoBufferSize;
    }

    public boolean isPagingIoBufferSizeSet() {
        return this._isSet(36);
    }

    public void setPagingIoBufferSize(int n) {
        LegalChecks.checkInRange((String)"PagingIoBufferSize", (long)n, (long)-1L, (long)0x4000000L);
        int n2 = this._PagingIoBufferSize;
        this._PagingIoBufferSize = n;
        this._postSet(36, n2, n);
    }

    public long getPagingMaxFileSize() {
        return this._PagingMaxFileSize;
    }

    public boolean isPagingMaxFileSizeSet() {
        return this._isSet(37);
    }

    public void setPagingMaxFileSize(long l) {
        LegalChecks.checkMin((String)"PagingMaxFileSize", (long)l, (long)0xA00000L);
        long l2 = this._PagingMaxFileSize;
        this._PagingMaxFileSize = l;
        this._postSet(37, l2, l);
    }

    public int getPagingBlockSize() {
        return this._PagingBlockSize;
    }

    public boolean isPagingBlockSizeSet() {
        return this._isSet(38);
    }

    public void setPagingBlockSize(int n) {
        LegalChecks.checkInRange((String)"PagingBlockSize", (long)n, (long)-1L, (long)8192L);
        int n2 = this._PagingBlockSize;
        this._PagingBlockSize = n;
        this._postSet(38, n2, n);
    }

    public void setExpirationScanInterval(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ExpirationScanInterval", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._ExpirationScanInterval;
        this._ExpirationScanInterval = n;
        this._postSet(39, n2, n);
    }

    public int getExpirationScanInterval() {
        return this._ExpirationScanInterval;
    }

    public boolean isExpirationScanIntervalSet() {
        return this._isSet(39);
    }

    public int getMaximumMessageSize() {
        return this._MaximumMessageSize;
    }

    public boolean isMaximumMessageSizeSet() {
        return this._isSet(40);
    }

    public void setMaximumMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaximumMessageSize", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._MaximumMessageSize;
        this._MaximumMessageSize = n;
        this._postSet(40, n2, n);
    }

    public String getBlockingSendPolicy() {
        return this._BlockingSendPolicy;
    }

    public boolean isBlockingSendPolicySet() {
        return this._isSet(41);
    }

    public void setBlockingSendPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"FIFO", "Preemptive"};
        string = LegalChecks.checkInEnum((String)"BlockingSendPolicy", (String)string, (String[])stringArray);
        String string2 = this._BlockingSendPolicy;
        this._BlockingSendPolicy = string;
        this._postSet(41, string2, string);
    }

    public void setProductionPausedAtStartup(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ProductionPausedAtStartup;
        this._ProductionPausedAtStartup = string;
        this._postSet(42, string2, string);
    }

    public String getProductionPausedAtStartup() {
        return this._ProductionPausedAtStartup;
    }

    public boolean isProductionPausedAtStartupSet() {
        return this._isSet(42);
    }

    public void setInsertionPausedAtStartup(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._InsertionPausedAtStartup;
        this._InsertionPausedAtStartup = string;
        this._postSet(43, string2, string);
    }

    public String getInsertionPausedAtStartup() {
        return this._InsertionPausedAtStartup;
    }

    public boolean isInsertionPausedAtStartupSet() {
        return this._isSet(43);
    }

    public void setConsumptionPausedAtStartup(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ConsumptionPausedAtStartup;
        this._ConsumptionPausedAtStartup = string;
        this._postSet(44, string2, string);
    }

    public String getConsumptionPausedAtStartup() {
        return this._ConsumptionPausedAtStartup;
    }

    public boolean isConsumptionPausedAtStartupSet() {
        return this._isSet(44);
    }

    public void addJMSQueue(JMSQueueMBean jMSQueueMBean) {
        this._getHelper()._ensureNonNull((Object)jMSQueueMBean);
        if (!((AbstractDescriptorBean)jMSQueueMBean).isChildProperty((DescriptorBean)this, 45)) {
            JMSQueueMBean[] jMSQueueMBeanArray = this._isSet(45) ? (JMSQueueMBean[])this._getHelper()._extendArray((Object)this.getJMSQueues(), JMSQueueMBean.class, (Object)jMSQueueMBean) : new JMSQueueMBean[]{jMSQueueMBean};
            try {
                this.setJMSQueues(jMSQueueMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JMSQueueMBean[] getJMSQueues() {
        return this._JMSQueues;
    }

    public boolean isJMSQueuesSet() {
        return this._isSet(45);
    }

    public void removeJMSQueue(JMSQueueMBean jMSQueueMBean) {
        this.destroyJMSQueue(jMSQueueMBean);
    }

    public void setJMSQueues(JMSQueueMBean[] jMSQueueMBeanArray) throws InvalidAttributeValueException {
        jMSQueueMBeanArray = jMSQueueMBeanArray == null ? new JMSQueueMBeanImpl[]{} : jMSQueueMBeanArray;
        for (int i = 0; i < jMSQueueMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSQueueMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 45)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        JMSQueueMBean[] jMSQueueMBeanArray2 = this._JMSQueues;
        this._JMSQueues = jMSQueueMBeanArray;
        this._postSet(45, jMSQueueMBeanArray2, jMSQueueMBeanArray);
    }

    public JMSQueueMBean createJMSQueue(String string) {
        JMSQueueMBeanImpl jMSQueueMBeanImpl = new JMSQueueMBeanImpl(this, -1);
        try {
            jMSQueueMBeanImpl.setName(string);
            this.addJMSQueue(jMSQueueMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return jMSQueueMBeanImpl;
    }

    public JMSQueueMBean createJMSQueue(String string, JMSQueueMBean jMSQueueMBean) {
        return this._customizer.createJMSQueue(string, jMSQueueMBean);
    }

    public void destroyJMSQueue(JMSQueueMBean jMSQueueMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(jMSQueueMBean, 45);
                JMSQueueMBean[] jMSQueueMBeanArray = this.getJMSQueues();
                JMSQueueMBean[] jMSQueueMBeanArray2 = (JMSQueueMBean[])this._getHelper()._removeElement((Object)jMSQueueMBeanArray, JMSQueueMBean.class, (Object)jMSQueueMBean);
                if (jMSQueueMBeanArray.length == jMSQueueMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)jMSQueueMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSQueueMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setJMSQueues(jMSQueueMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JMSQueueMBean lookupJMSQueue(String string) {
        for (JMSQueueMBeanImpl jMSQueueMBeanImpl : Arrays.asList((Object[])this._JMSQueues)) {
            String string2 = string;
            if (!jMSQueueMBeanImpl.getName().equals(string2)) continue;
            return jMSQueueMBeanImpl;
        }
        return null;
    }

    public void addJMSTopic(JMSTopicMBean jMSTopicMBean) {
        this._getHelper()._ensureNonNull((Object)jMSTopicMBean);
        if (!((AbstractDescriptorBean)jMSTopicMBean).isChildProperty((DescriptorBean)this, 46)) {
            JMSTopicMBean[] jMSTopicMBeanArray = this._isSet(46) ? (JMSTopicMBean[])this._getHelper()._extendArray((Object)this.getJMSTopics(), JMSTopicMBean.class, (Object)jMSTopicMBean) : new JMSTopicMBean[]{jMSTopicMBean};
            try {
                this.setJMSTopics(jMSTopicMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JMSTopicMBean[] getJMSTopics() {
        return this._JMSTopics;
    }

    public boolean isJMSTopicsSet() {
        return this._isSet(46);
    }

    public void removeJMSTopic(JMSTopicMBean jMSTopicMBean) {
        this.destroyJMSTopic(jMSTopicMBean);
    }

    public void setJMSTopics(JMSTopicMBean[] jMSTopicMBeanArray) throws InvalidAttributeValueException {
        jMSTopicMBeanArray = jMSTopicMBeanArray == null ? new JMSTopicMBeanImpl[]{} : jMSTopicMBeanArray;
        for (int i = 0; i < jMSTopicMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSTopicMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 46)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        JMSTopicMBean[] jMSTopicMBeanArray2 = this._JMSTopics;
        this._JMSTopics = jMSTopicMBeanArray;
        this._postSet(46, jMSTopicMBeanArray2, jMSTopicMBeanArray);
    }

    public JMSTopicMBean createJMSTopic(String string) {
        JMSTopicMBeanImpl jMSTopicMBeanImpl = new JMSTopicMBeanImpl(this, -1);
        try {
            jMSTopicMBeanImpl.setName(string);
            this.addJMSTopic(jMSTopicMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return jMSTopicMBeanImpl;
    }

    public JMSTopicMBean createJMSTopic(String string, JMSTopicMBean jMSTopicMBean) {
        return this._customizer.createJMSTopic(string, jMSTopicMBean);
    }

    public void destroyJMSTopic(JMSTopicMBean jMSTopicMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(jMSTopicMBean, 46);
                JMSTopicMBean[] jMSTopicMBeanArray = this.getJMSTopics();
                JMSTopicMBean[] jMSTopicMBeanArray2 = (JMSTopicMBean[])this._getHelper()._removeElement((Object)jMSTopicMBeanArray, JMSTopicMBean.class, (Object)jMSTopicMBean);
                if (jMSTopicMBeanArray.length == jMSTopicMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)jMSTopicMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSTopicMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setJMSTopics(jMSTopicMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JMSTopicMBean lookupJMSTopic(String string) {
        for (JMSTopicMBeanImpl jMSTopicMBeanImpl : Arrays.asList((Object[])this._JMSTopics)) {
            String string2 = string;
            if (!jMSTopicMBeanImpl.getName().equals(string2)) continue;
            return jMSTopicMBeanImpl;
        }
        return null;
    }

    public JMSMessageLogFileMBean getJMSMessageLogFile() {
        return this._JMSMessageLogFile;
    }

    public boolean isJMSMessageLogFileSet() {
        return this._isSet(47) || this._isAnythingSet((AbstractDescriptorBean)this.getJMSMessageLogFile());
    }

    public void setJMSMessageLogFile(JMSMessageLogFileMBean jMSMessageLogFileMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSMessageLogFileMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 47)) {
            this._postCreate(abstractDescriptorBean);
        }
        JMSMessageLogFileMBean jMSMessageLogFileMBean2 = this._JMSMessageLogFile;
        this._JMSMessageLogFile = jMSMessageLogFileMBean;
        this._postSet(47, jMSMessageLogFileMBean2, jMSMessageLogFileMBean);
    }

    public void useDelegates(DomainMBean domainMBean) {
        this._customizer.useDelegates(domainMBean);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        JMSLegalHelper.validateJMSServer(this);
        JMSLegalHelper.validateServerBytesValues(this);
        JMSLegalHelper.validateServerMessagesValues(this);
    }

    protected void _preDestroy() {
        this._customizer._preDestroy();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet() || this.isJMSMessageLogFileSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 41;
        }
        try {
            switch (n) {
                case 41: {
                    this._BlockingSendPolicy = "FIFO";
                    if (bl) break;
                }
                case 21: {
                    this._BytesMaximum = -1L;
                    if (bl) break;
                }
                case 22: {
                    this._BytesThresholdHigh = -1L;
                    if (bl) break;
                }
                case 23: {
                    this._BytesThresholdLow = -1L;
                    if (bl) break;
                }
                case 44: {
                    this._ConsumptionPausedAtStartup = "default";
                    if (bl) break;
                }
                case 12: {
                    this._Destinations = new JMSDestinationMBean[0];
                    if (bl) break;
                }
                case 39: {
                    this._ExpirationScanInterval = 30;
                    if (bl) break;
                }
                case 43: {
                    this._InsertionPausedAtStartup = "default";
                    if (bl) break;
                }
                case 47: {
                    this._JMSMessageLogFile = new JMSMessageLogFileMBeanImpl(this, 47);
                    this._postCreate((AbstractDescriptorBean)this._JMSMessageLogFile);
                    if (bl) break;
                }
                case 45: {
                    this._JMSQueues = new JMSQueueMBean[0];
                    if (bl) break;
                }
                case 11: {
                    this._JMSSessionPools = new JMSSessionPoolMBean[0];
                    if (bl) break;
                }
                case 46: {
                    this._JMSTopics = new JMSTopicMBean[0];
                    if (bl) break;
                }
                case 40: {
                    this._MaximumMessageSize = Integer.MAX_VALUE;
                    if (bl) break;
                }
                case 31: {
                    this._MessageBufferSize = -1L;
                    if (bl) break;
                }
                case 24: {
                    this._MessagesMaximum = -1L;
                    if (bl) break;
                }
                case 25: {
                    this._MessagesThresholdHigh = -1L;
                    if (bl) break;
                }
                case 26: {
                    this._MessagesThresholdLow = -1L;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 38: {
                    this._PagingBlockSize = -1;
                    if (bl) break;
                }
                case 32: {
                    this._PagingDirectory = null;
                    if (bl) break;
                }
                case 36: {
                    this._PagingIoBufferSize = -1;
                    if (bl) break;
                }
                case 37: {
                    this._PagingMaxFileSize = 0x50000000L;
                    if (bl) break;
                }
                case 35: {
                    this._PagingMaxWindowBufferSize = -1;
                    if (bl) break;
                }
                case 34: {
                    this._PagingMinWindowBufferSize = -1;
                    if (bl) break;
                }
                case 28: {
                    this._PagingStore = null;
                    if (bl) break;
                }
                case 14: {
                    this._PersistentStore = null;
                    if (bl) break;
                }
                case 42: {
                    this._ProductionPausedAtStartup = "default";
                    if (bl) break;
                }
                case 9: {
                    this._ServerNames = null;
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setSessionPools(new JMSSessionPoolMBean[0]);
                    if (bl) break;
                }
                case 13: {
                    this._Store = null;
                    if (bl) break;
                }
                case 15: {
                    this._StoreEnabled = true;
                    if (bl) break;
                }
                case 7: {
                    this._Targets = new TargetMBean[0];
                    if (bl) break;
                }
                case 17: {
                    this._customizer.setTemporaryTemplate(null);
                    if (bl) break;
                }
                case 20: {
                    this._TemporaryTemplateName = null;
                    if (bl) break;
                }
                case 19: {
                    this._TemporaryTemplateResource = null;
                    if (bl) break;
                }
                case 16: {
                    this._AllowsPersistentDowngrade = false;
                    if (bl) break;
                }
                case 30: {
                    this._BytesPagingEnabled = false;
                    if (bl) break;
                }
                case 18: {
                    this._HostingTemporaryDestinations = true;
                    if (bl) break;
                }
                case 27: {
                    this._JDBCStoreUpgradeEnabled = true;
                    if (bl) break;
                }
                case 29: {
                    this._MessagesPagingEnabled = false;
                    if (bl) break;
                }
                case 33: {
                    this._PagingFileLockingEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMSServer";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AllowsPersistentDowngrade")) {
            boolean bl = this._AllowsPersistentDowngrade;
            this._AllowsPersistentDowngrade = (Boolean)object;
            this._postSet(16, bl, this._AllowsPersistentDowngrade);
            return;
        }
        if (string.equals("BlockingSendPolicy")) {
            String string2 = this._BlockingSendPolicy;
            this._BlockingSendPolicy = (String)object;
            this._postSet(41, string2, this._BlockingSendPolicy);
            return;
        }
        if (string.equals("BytesMaximum")) {
            long l = this._BytesMaximum;
            this._BytesMaximum = (Long)object;
            this._postSet(21, l, this._BytesMaximum);
            return;
        }
        if (string.equals("BytesPagingEnabled")) {
            boolean bl = this._BytesPagingEnabled;
            this._BytesPagingEnabled = (Boolean)object;
            this._postSet(30, bl, this._BytesPagingEnabled);
            return;
        }
        if (string.equals("BytesThresholdHigh")) {
            long l = this._BytesThresholdHigh;
            this._BytesThresholdHigh = (Long)object;
            this._postSet(22, l, this._BytesThresholdHigh);
            return;
        }
        if (string.equals("BytesThresholdLow")) {
            long l = this._BytesThresholdLow;
            this._BytesThresholdLow = (Long)object;
            this._postSet(23, l, this._BytesThresholdLow);
            return;
        }
        if (string.equals("ConsumptionPausedAtStartup")) {
            String string3 = this._ConsumptionPausedAtStartup;
            this._ConsumptionPausedAtStartup = (String)object;
            this._postSet(44, string3, this._ConsumptionPausedAtStartup);
            return;
        }
        if (string.equals("Destinations")) {
            JMSDestinationMBean[] jMSDestinationMBeanArray = this._Destinations;
            this._Destinations = (JMSDestinationMBean[])object;
            this._postSet(12, jMSDestinationMBeanArray, this._Destinations);
            return;
        }
        if (string.equals("ExpirationScanInterval")) {
            int n = this._ExpirationScanInterval;
            this._ExpirationScanInterval = (Integer)object;
            this._postSet(39, n, this._ExpirationScanInterval);
            return;
        }
        if (string.equals("HostingTemporaryDestinations")) {
            boolean bl = this._HostingTemporaryDestinations;
            this._HostingTemporaryDestinations = (Boolean)object;
            this._postSet(18, bl, this._HostingTemporaryDestinations);
            return;
        }
        if (string.equals("InsertionPausedAtStartup")) {
            String string4 = this._InsertionPausedAtStartup;
            this._InsertionPausedAtStartup = (String)object;
            this._postSet(43, string4, this._InsertionPausedAtStartup);
            return;
        }
        if (string.equals("JDBCStoreUpgradeEnabled")) {
            boolean bl = this._JDBCStoreUpgradeEnabled;
            this._JDBCStoreUpgradeEnabled = (Boolean)object;
            this._postSet(27, bl, this._JDBCStoreUpgradeEnabled);
            return;
        }
        if (string.equals("JMSMessageLogFile")) {
            JMSMessageLogFileMBean jMSMessageLogFileMBean = this._JMSMessageLogFile;
            this._JMSMessageLogFile = (JMSMessageLogFileMBean)object;
            this._postSet(47, jMSMessageLogFileMBean, this._JMSMessageLogFile);
            return;
        }
        if (string.equals("JMSQueues")) {
            JMSQueueMBean[] jMSQueueMBeanArray = this._JMSQueues;
            this._JMSQueues = (JMSQueueMBean[])object;
            this._postSet(45, jMSQueueMBeanArray, this._JMSQueues);
            return;
        }
        if (string.equals("JMSSessionPools")) {
            JMSSessionPoolMBean[] jMSSessionPoolMBeanArray = this._JMSSessionPools;
            this._JMSSessionPools = (JMSSessionPoolMBean[])object;
            this._postSet(11, jMSSessionPoolMBeanArray, this._JMSSessionPools);
            return;
        }
        if (string.equals("JMSTopics")) {
            JMSTopicMBean[] jMSTopicMBeanArray = this._JMSTopics;
            this._JMSTopics = (JMSTopicMBean[])object;
            this._postSet(46, jMSTopicMBeanArray, this._JMSTopics);
            return;
        }
        if (string.equals("MaximumMessageSize")) {
            int n = this._MaximumMessageSize;
            this._MaximumMessageSize = (Integer)object;
            this._postSet(40, n, this._MaximumMessageSize);
            return;
        }
        if (string.equals("MessageBufferSize")) {
            long l = this._MessageBufferSize;
            this._MessageBufferSize = (Long)object;
            this._postSet(31, l, this._MessageBufferSize);
            return;
        }
        if (string.equals("MessagesMaximum")) {
            long l = this._MessagesMaximum;
            this._MessagesMaximum = (Long)object;
            this._postSet(24, l, this._MessagesMaximum);
            return;
        }
        if (string.equals("MessagesPagingEnabled")) {
            boolean bl = this._MessagesPagingEnabled;
            this._MessagesPagingEnabled = (Boolean)object;
            this._postSet(29, bl, this._MessagesPagingEnabled);
            return;
        }
        if (string.equals("MessagesThresholdHigh")) {
            long l = this._MessagesThresholdHigh;
            this._MessagesThresholdHigh = (Long)object;
            this._postSet(25, l, this._MessagesThresholdHigh);
            return;
        }
        if (string.equals("MessagesThresholdLow")) {
            long l = this._MessagesThresholdLow;
            this._MessagesThresholdLow = (Long)object;
            this._postSet(26, l, this._MessagesThresholdLow);
            return;
        }
        if (string.equals("Name")) {
            String string5 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string5, this._Name);
            return;
        }
        if (string.equals("PagingBlockSize")) {
            int n = this._PagingBlockSize;
            this._PagingBlockSize = (Integer)object;
            this._postSet(38, n, this._PagingBlockSize);
            return;
        }
        if (string.equals("PagingDirectory")) {
            String string6 = this._PagingDirectory;
            this._PagingDirectory = (String)object;
            this._postSet(32, string6, this._PagingDirectory);
            return;
        }
        if (string.equals("PagingFileLockingEnabled")) {
            boolean bl = this._PagingFileLockingEnabled;
            this._PagingFileLockingEnabled = (Boolean)object;
            this._postSet(33, bl, this._PagingFileLockingEnabled);
            return;
        }
        if (string.equals("PagingIoBufferSize")) {
            int n = this._PagingIoBufferSize;
            this._PagingIoBufferSize = (Integer)object;
            this._postSet(36, n, this._PagingIoBufferSize);
            return;
        }
        if (string.equals("PagingMaxFileSize")) {
            long l = this._PagingMaxFileSize;
            this._PagingMaxFileSize = (Long)object;
            this._postSet(37, l, this._PagingMaxFileSize);
            return;
        }
        if (string.equals("PagingMaxWindowBufferSize")) {
            int n = this._PagingMaxWindowBufferSize;
            this._PagingMaxWindowBufferSize = (Integer)object;
            this._postSet(35, n, this._PagingMaxWindowBufferSize);
            return;
        }
        if (string.equals("PagingMinWindowBufferSize")) {
            int n = this._PagingMinWindowBufferSize;
            this._PagingMinWindowBufferSize = (Integer)object;
            this._postSet(34, n, this._PagingMinWindowBufferSize);
            return;
        }
        if (string.equals("PagingStore")) {
            JMSStoreMBean jMSStoreMBean = this._PagingStore;
            this._PagingStore = (JMSStoreMBean)object;
            this._postSet(28, jMSStoreMBean, this._PagingStore);
            return;
        }
        if (string.equals("PersistentStore")) {
            PersistentStoreMBean persistentStoreMBean = this._PersistentStore;
            this._PersistentStore = (PersistentStoreMBean)object;
            this._postSet(14, persistentStoreMBean, this._PersistentStore);
            return;
        }
        if (string.equals("ProductionPausedAtStartup")) {
            String string7 = this._ProductionPausedAtStartup;
            this._ProductionPausedAtStartup = (String)object;
            this._postSet(42, string7, this._ProductionPausedAtStartup);
            return;
        }
        if (string.equals("ServerNames")) {
            Set set = this._ServerNames;
            this._ServerNames = (Set)object;
            this._postSet(9, set, this._ServerNames);
            return;
        }
        if (string.equals("SessionPools")) {
            JMSSessionPoolMBean[] jMSSessionPoolMBeanArray = this._SessionPools;
            this._SessionPools = (JMSSessionPoolMBean[])object;
            this._postSet(10, jMSSessionPoolMBeanArray, this._SessionPools);
            return;
        }
        if (string.equals("Store")) {
            JMSStoreMBean jMSStoreMBean = this._Store;
            this._Store = (JMSStoreMBean)object;
            this._postSet(13, jMSStoreMBean, this._Store);
            return;
        }
        if (string.equals("StoreEnabled")) {
            boolean bl = this._StoreEnabled;
            this._StoreEnabled = (Boolean)object;
            this._postSet(15, bl, this._StoreEnabled);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("TemporaryTemplate")) {
            JMSTemplateMBean jMSTemplateMBean = this._TemporaryTemplate;
            this._TemporaryTemplate = (JMSTemplateMBean)object;
            this._postSet(17, jMSTemplateMBean, this._TemporaryTemplate);
            return;
        }
        if (string.equals("TemporaryTemplateName")) {
            String string8 = this._TemporaryTemplateName;
            this._TemporaryTemplateName = (String)object;
            this._postSet(20, string8, this._TemporaryTemplateName);
            return;
        }
        if (string.equals("TemporaryTemplateResource")) {
            String string9 = this._TemporaryTemplateResource;
            this._TemporaryTemplateResource = (String)object;
            this._postSet(19, string9, this._TemporaryTemplateResource);
            return;
        }
        if (string.equals("customizer")) {
            JMSServer jMSServer = this._customizer;
            this._customizer = (JMSServer)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AllowsPersistentDowngrade")) {
            return new Boolean(this._AllowsPersistentDowngrade);
        }
        if (string.equals("BlockingSendPolicy")) {
            return this._BlockingSendPolicy;
        }
        if (string.equals("BytesMaximum")) {
            return new Long(this._BytesMaximum);
        }
        if (string.equals("BytesPagingEnabled")) {
            return new Boolean(this._BytesPagingEnabled);
        }
        if (string.equals("BytesThresholdHigh")) {
            return new Long(this._BytesThresholdHigh);
        }
        if (string.equals("BytesThresholdLow")) {
            return new Long(this._BytesThresholdLow);
        }
        if (string.equals("ConsumptionPausedAtStartup")) {
            return this._ConsumptionPausedAtStartup;
        }
        if (string.equals("Destinations")) {
            return this._Destinations;
        }
        if (string.equals("ExpirationScanInterval")) {
            return new Integer(this._ExpirationScanInterval);
        }
        if (string.equals("HostingTemporaryDestinations")) {
            return new Boolean(this._HostingTemporaryDestinations);
        }
        if (string.equals("InsertionPausedAtStartup")) {
            return this._InsertionPausedAtStartup;
        }
        if (string.equals("JDBCStoreUpgradeEnabled")) {
            return new Boolean(this._JDBCStoreUpgradeEnabled);
        }
        if (string.equals("JMSMessageLogFile")) {
            return this._JMSMessageLogFile;
        }
        if (string.equals("JMSQueues")) {
            return this._JMSQueues;
        }
        if (string.equals("JMSSessionPools")) {
            return this._JMSSessionPools;
        }
        if (string.equals("JMSTopics")) {
            return this._JMSTopics;
        }
        if (string.equals("MaximumMessageSize")) {
            return new Integer(this._MaximumMessageSize);
        }
        if (string.equals("MessageBufferSize")) {
            return new Long(this._MessageBufferSize);
        }
        if (string.equals("MessagesMaximum")) {
            return new Long(this._MessagesMaximum);
        }
        if (string.equals("MessagesPagingEnabled")) {
            return new Boolean(this._MessagesPagingEnabled);
        }
        if (string.equals("MessagesThresholdHigh")) {
            return new Long(this._MessagesThresholdHigh);
        }
        if (string.equals("MessagesThresholdLow")) {
            return new Long(this._MessagesThresholdLow);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PagingBlockSize")) {
            return new Integer(this._PagingBlockSize);
        }
        if (string.equals("PagingDirectory")) {
            return this._PagingDirectory;
        }
        if (string.equals("PagingFileLockingEnabled")) {
            return new Boolean(this._PagingFileLockingEnabled);
        }
        if (string.equals("PagingIoBufferSize")) {
            return new Integer(this._PagingIoBufferSize);
        }
        if (string.equals("PagingMaxFileSize")) {
            return new Long(this._PagingMaxFileSize);
        }
        if (string.equals("PagingMaxWindowBufferSize")) {
            return new Integer(this._PagingMaxWindowBufferSize);
        }
        if (string.equals("PagingMinWindowBufferSize")) {
            return new Integer(this._PagingMinWindowBufferSize);
        }
        if (string.equals("PagingStore")) {
            return this._PagingStore;
        }
        if (string.equals("PersistentStore")) {
            return this._PersistentStore;
        }
        if (string.equals("ProductionPausedAtStartup")) {
            return this._ProductionPausedAtStartup;
        }
        if (string.equals("ServerNames")) {
            return this._ServerNames;
        }
        if (string.equals("SessionPools")) {
            return this._SessionPools;
        }
        if (string.equals("Store")) {
            return this._Store;
        }
        if (string.equals("StoreEnabled")) {
            return new Boolean(this._StoreEnabled);
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("TemporaryTemplate")) {
            return this._TemporaryTemplate;
        }
        if (string.equals("TemporaryTemplateName")) {
            return this._TemporaryTemplateName;
        }
        if (string.equals("TemporaryTemplateResource")) {
            return this._TemporaryTemplateResource;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (string.equals("blocking-send-policy")) {
                        return 41;
                    }
                    if (string.equals("bytes-threshold-high")) {
                        return 22;
                    }
                    if (string.equals("jms-message-log-file")) {
                        return 47;
                    }
                    if (string.equals("maximum-message-size")) {
                        return 40;
                    }
                    if (string.equals("paging-max-file-size")) {
                        return 37;
                    }
                    if (!string.equals("bytes-paging-enabled")) break;
                    return 30;
                }
                case 13: {
                    if (string.equals("bytes-maximum")) {
                        return 21;
                    }
                    if (!string.equals("store-enabled")) break;
                    return 15;
                }
                case 19: {
                    if (string.equals("bytes-threshold-low")) {
                        return 23;
                    }
                    if (!string.equals("message-buffer-size")) break;
                    return 31;
                }
                case 29: {
                    if (string.equals("consumption-paused-at-startup")) {
                        return 44;
                    }
                    if (string.equals("paging-max-window-buffer-size")) {
                        return 35;
                    }
                    if (!string.equals("paging-min-window-buffer-size")) break;
                    return 34;
                }
                case 11: {
                    if (!string.equals("destination")) break;
                    return 12;
                }
                case 24: {
                    if (!string.equals("expiration-scan-interval")) break;
                    return 39;
                }
                case 27: {
                    if (string.equals("insertion-paused-at-startup")) {
                        return 43;
                    }
                    if (string.equals("temporary-template-resource")) {
                        return 19;
                    }
                    if (string.equals("allows-persistent-downgrade")) {
                        return 16;
                    }
                    if (!string.equals("paging-file-locking-enabled")) break;
                    return 33;
                }
                case 9: {
                    if (string.equals("jms-queue")) {
                        return 45;
                    }
                    if (!string.equals("jms-topic")) break;
                    return 46;
                }
                case 16: {
                    if (string.equals("jms-session-pool")) {
                        return 11;
                    }
                    if (string.equals("messages-maximum")) {
                        return 24;
                    }
                    if (string.equals("paging-directory")) {
                        return 32;
                    }
                    if (!string.equals("persistent-store")) break;
                    return 14;
                }
                case 23: {
                    if (string.equals("messages-threshold-high")) {
                        return 25;
                    }
                    if (string.equals("temporary-template-name")) {
                        return 20;
                    }
                    if (!string.equals("messages-paging-enabled")) break;
                    return 29;
                }
                case 22: {
                    if (!string.equals("messages-threshold-low")) break;
                    return 26;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 17: {
                    if (!string.equals("paging-block-size")) break;
                    return 38;
                }
                case 21: {
                    if (!string.equals("paging-io-buffer-size")) break;
                    return 36;
                }
                case 12: {
                    if (string.equals("paging-store")) {
                        return 28;
                    }
                    if (string.equals("server-names")) {
                        return 9;
                    }
                    if (!string.equals("session-pool")) break;
                    return 10;
                }
                case 28: {
                    if (!string.equals("production-paused-at-startup")) break;
                    return 42;
                }
                case 5: {
                    if (!string.equals("store")) break;
                    return 13;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 18: {
                    if (!string.equals("temporary-template")) break;
                    return 17;
                }
                case 30: {
                    if (!string.equals("hosting-temporary-destinations")) break;
                    return 18;
                }
                case 26: {
                    if (!string.equals("jdbc-store-upgrade-enabled")) break;
                    return 27;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 47: {
                    return new JMSMessageLogFileMBeanImpl.SchemaHelper2();
                }
                case 45: {
                    return new JMSQueueMBeanImpl.SchemaHelper2();
                }
                case 11: {
                    return new JMSSessionPoolMBeanImpl.SchemaHelper2();
                }
                case 46: {
                    return new JMSTopicMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 41: {
                    return "blocking-send-policy";
                }
                case 21: {
                    return "bytes-maximum";
                }
                case 22: {
                    return "bytes-threshold-high";
                }
                case 23: {
                    return "bytes-threshold-low";
                }
                case 44: {
                    return "consumption-paused-at-startup";
                }
                case 12: {
                    return "destination";
                }
                case 39: {
                    return "expiration-scan-interval";
                }
                case 43: {
                    return "insertion-paused-at-startup";
                }
                case 47: {
                    return "jms-message-log-file";
                }
                case 45: {
                    return "jms-queue";
                }
                case 11: {
                    return "jms-session-pool";
                }
                case 46: {
                    return "jms-topic";
                }
                case 40: {
                    return "maximum-message-size";
                }
                case 31: {
                    return "message-buffer-size";
                }
                case 24: {
                    return "messages-maximum";
                }
                case 25: {
                    return "messages-threshold-high";
                }
                case 26: {
                    return "messages-threshold-low";
                }
                case 2: {
                    return "name";
                }
                case 38: {
                    return "paging-block-size";
                }
                case 32: {
                    return "paging-directory";
                }
                case 36: {
                    return "paging-io-buffer-size";
                }
                case 37: {
                    return "paging-max-file-size";
                }
                case 35: {
                    return "paging-max-window-buffer-size";
                }
                case 34: {
                    return "paging-min-window-buffer-size";
                }
                case 28: {
                    return "paging-store";
                }
                case 14: {
                    return "persistent-store";
                }
                case 42: {
                    return "production-paused-at-startup";
                }
                case 9: {
                    return "server-names";
                }
                case 10: {
                    return "session-pool";
                }
                case 13: {
                    return "store";
                }
                case 15: {
                    return "store-enabled";
                }
                case 7: {
                    return "target";
                }
                case 17: {
                    return "temporary-template";
                }
                case 20: {
                    return "temporary-template-name";
                }
                case 19: {
                    return "temporary-template-resource";
                }
                case 16: {
                    return "allows-persistent-downgrade";
                }
                case 30: {
                    return "bytes-paging-enabled";
                }
                case 18: {
                    return "hosting-temporary-destinations";
                }
                case 27: {
                    return "jdbc-store-upgrade-enabled";
                }
                case 29: {
                    return "messages-paging-enabled";
                }
                case 33: {
                    return "paging-file-locking-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 12: {
                    return true;
                }
                case 45: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 46: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 47: {
                    return true;
                }
                case 45: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 46: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private JMSServerMBeanImpl bean;

        protected Helper(JMSServerMBeanImpl jMSServerMBeanImpl) {
            super(jMSServerMBeanImpl);
            this.bean = jMSServerMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 41: {
                    return "BlockingSendPolicy";
                }
                case 21: {
                    return "BytesMaximum";
                }
                case 22: {
                    return "BytesThresholdHigh";
                }
                case 23: {
                    return "BytesThresholdLow";
                }
                case 44: {
                    return "ConsumptionPausedAtStartup";
                }
                case 12: {
                    return "Destinations";
                }
                case 39: {
                    return "ExpirationScanInterval";
                }
                case 43: {
                    return "InsertionPausedAtStartup";
                }
                case 47: {
                    return "JMSMessageLogFile";
                }
                case 45: {
                    return "JMSQueues";
                }
                case 11: {
                    return "JMSSessionPools";
                }
                case 46: {
                    return "JMSTopics";
                }
                case 40: {
                    return "MaximumMessageSize";
                }
                case 31: {
                    return "MessageBufferSize";
                }
                case 24: {
                    return "MessagesMaximum";
                }
                case 25: {
                    return "MessagesThresholdHigh";
                }
                case 26: {
                    return "MessagesThresholdLow";
                }
                case 2: {
                    return "Name";
                }
                case 38: {
                    return "PagingBlockSize";
                }
                case 32: {
                    return "PagingDirectory";
                }
                case 36: {
                    return "PagingIoBufferSize";
                }
                case 37: {
                    return "PagingMaxFileSize";
                }
                case 35: {
                    return "PagingMaxWindowBufferSize";
                }
                case 34: {
                    return "PagingMinWindowBufferSize";
                }
                case 28: {
                    return "PagingStore";
                }
                case 14: {
                    return "PersistentStore";
                }
                case 42: {
                    return "ProductionPausedAtStartup";
                }
                case 9: {
                    return "ServerNames";
                }
                case 10: {
                    return "SessionPools";
                }
                case 13: {
                    return "Store";
                }
                case 15: {
                    return "StoreEnabled";
                }
                case 7: {
                    return "Targets";
                }
                case 17: {
                    return "TemporaryTemplate";
                }
                case 20: {
                    return "TemporaryTemplateName";
                }
                case 19: {
                    return "TemporaryTemplateResource";
                }
                case 16: {
                    return "AllowsPersistentDowngrade";
                }
                case 30: {
                    return "BytesPagingEnabled";
                }
                case 18: {
                    return "HostingTemporaryDestinations";
                }
                case 27: {
                    return "JDBCStoreUpgradeEnabled";
                }
                case 29: {
                    return "MessagesPagingEnabled";
                }
                case 33: {
                    return "PagingFileLockingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BlockingSendPolicy")) {
                return 41;
            }
            if (string.equals("BytesMaximum")) {
                return 21;
            }
            if (string.equals("BytesThresholdHigh")) {
                return 22;
            }
            if (string.equals("BytesThresholdLow")) {
                return 23;
            }
            if (string.equals("ConsumptionPausedAtStartup")) {
                return 44;
            }
            if (string.equals("Destinations")) {
                return 12;
            }
            if (string.equals("ExpirationScanInterval")) {
                return 39;
            }
            if (string.equals("InsertionPausedAtStartup")) {
                return 43;
            }
            if (string.equals("JMSMessageLogFile")) {
                return 47;
            }
            if (string.equals("JMSQueues")) {
                return 45;
            }
            if (string.equals("JMSSessionPools")) {
                return 11;
            }
            if (string.equals("JMSTopics")) {
                return 46;
            }
            if (string.equals("MaximumMessageSize")) {
                return 40;
            }
            if (string.equals("MessageBufferSize")) {
                return 31;
            }
            if (string.equals("MessagesMaximum")) {
                return 24;
            }
            if (string.equals("MessagesThresholdHigh")) {
                return 25;
            }
            if (string.equals("MessagesThresholdLow")) {
                return 26;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PagingBlockSize")) {
                return 38;
            }
            if (string.equals("PagingDirectory")) {
                return 32;
            }
            if (string.equals("PagingIoBufferSize")) {
                return 36;
            }
            if (string.equals("PagingMaxFileSize")) {
                return 37;
            }
            if (string.equals("PagingMaxWindowBufferSize")) {
                return 35;
            }
            if (string.equals("PagingMinWindowBufferSize")) {
                return 34;
            }
            if (string.equals("PagingStore")) {
                return 28;
            }
            if (string.equals("PersistentStore")) {
                return 14;
            }
            if (string.equals("ProductionPausedAtStartup")) {
                return 42;
            }
            if (string.equals("ServerNames")) {
                return 9;
            }
            if (string.equals("SessionPools")) {
                return 10;
            }
            if (string.equals("Store")) {
                return 13;
            }
            if (string.equals("StoreEnabled")) {
                return 15;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("TemporaryTemplate")) {
                return 17;
            }
            if (string.equals("TemporaryTemplateName")) {
                return 20;
            }
            if (string.equals("TemporaryTemplateResource")) {
                return 19;
            }
            if (string.equals("AllowsPersistentDowngrade")) {
                return 16;
            }
            if (string.equals("BytesPagingEnabled")) {
                return 30;
            }
            if (string.equals("HostingTemporaryDestinations")) {
                return 18;
            }
            if (string.equals("JDBCStoreUpgradeEnabled")) {
                return 27;
            }
            if (string.equals("MessagesPagingEnabled")) {
                return 29;
            }
            if (string.equals("PagingFileLockingEnabled")) {
                return 33;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getJMSMessageLogFile() != null) {
                arrayList.add(new ArrayIterator((Object[])new JMSMessageLogFileMBean[]{this.bean.getJMSMessageLogFile()}));
            }
            arrayList.add(new ArrayIterator((Object[])this.bean.getJMSQueues()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getJMSSessionPools()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getJMSTopics()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBlockingSendPolicySet()) {
                    stringBuffer.append("BlockingSendPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getBlockingSendPolicy()));
                }
                if (this.bean.isBytesMaximumSet()) {
                    stringBuffer.append("BytesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getBytesMaximum()));
                }
                if (this.bean.isBytesThresholdHighSet()) {
                    stringBuffer.append("BytesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdHigh()));
                }
                if (this.bean.isBytesThresholdLowSet()) {
                    stringBuffer.append("BytesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdLow()));
                }
                if (this.bean.isConsumptionPausedAtStartupSet()) {
                    stringBuffer.append("ConsumptionPausedAtStartup");
                    stringBuffer.append(String.valueOf(this.bean.getConsumptionPausedAtStartup()));
                }
                if (this.bean.isDestinationsSet()) {
                    stringBuffer.append("Destinations");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getDestinations())));
                }
                if (this.bean.isExpirationScanIntervalSet()) {
                    stringBuffer.append("ExpirationScanInterval");
                    stringBuffer.append(String.valueOf(this.bean.getExpirationScanInterval()));
                }
                if (this.bean.isInsertionPausedAtStartupSet()) {
                    stringBuffer.append("InsertionPausedAtStartup");
                    stringBuffer.append(String.valueOf(this.bean.getInsertionPausedAtStartup()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getJMSMessageLogFile())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getJMSQueues().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getJMSQueues()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getJMSSessionPools().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getJMSSessionPools()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getJMSTopics().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getJMSTopics()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isMaximumMessageSizeSet()) {
                    stringBuffer.append("MaximumMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumMessageSize()));
                }
                if (this.bean.isMessageBufferSizeSet()) {
                    stringBuffer.append("MessageBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getMessageBufferSize()));
                }
                if (this.bean.isMessagesMaximumSet()) {
                    stringBuffer.append("MessagesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesMaximum()));
                }
                if (this.bean.isMessagesThresholdHighSet()) {
                    stringBuffer.append("MessagesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdHigh()));
                }
                if (this.bean.isMessagesThresholdLowSet()) {
                    stringBuffer.append("MessagesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdLow()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPagingBlockSizeSet()) {
                    stringBuffer.append("PagingBlockSize");
                    stringBuffer.append(String.valueOf(this.bean.getPagingBlockSize()));
                }
                if (this.bean.isPagingDirectorySet()) {
                    stringBuffer.append("PagingDirectory");
                    stringBuffer.append(String.valueOf(this.bean.getPagingDirectory()));
                }
                if (this.bean.isPagingIoBufferSizeSet()) {
                    stringBuffer.append("PagingIoBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getPagingIoBufferSize()));
                }
                if (this.bean.isPagingMaxFileSizeSet()) {
                    stringBuffer.append("PagingMaxFileSize");
                    stringBuffer.append(String.valueOf(this.bean.getPagingMaxFileSize()));
                }
                if (this.bean.isPagingMaxWindowBufferSizeSet()) {
                    stringBuffer.append("PagingMaxWindowBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getPagingMaxWindowBufferSize()));
                }
                if (this.bean.isPagingMinWindowBufferSizeSet()) {
                    stringBuffer.append("PagingMinWindowBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getPagingMinWindowBufferSize()));
                }
                if (this.bean.isPagingStoreSet()) {
                    stringBuffer.append("PagingStore");
                    stringBuffer.append(String.valueOf(this.bean.getPagingStore()));
                }
                if (this.bean.isPersistentStoreSet()) {
                    stringBuffer.append("PersistentStore");
                    stringBuffer.append(String.valueOf(this.bean.getPersistentStore()));
                }
                if (this.bean.isProductionPausedAtStartupSet()) {
                    stringBuffer.append("ProductionPausedAtStartup");
                    stringBuffer.append(String.valueOf(this.bean.getProductionPausedAtStartup()));
                }
                if (this.bean.isServerNamesSet()) {
                    stringBuffer.append("ServerNames");
                    stringBuffer.append(String.valueOf(this.bean.getServerNames()));
                }
                if (this.bean.isSessionPoolsSet()) {
                    stringBuffer.append("SessionPools");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getSessionPools())));
                }
                if (this.bean.isStoreSet()) {
                    stringBuffer.append("Store");
                    stringBuffer.append(String.valueOf(this.bean.getStore()));
                }
                if (this.bean.isStoreEnabledSet()) {
                    stringBuffer.append("StoreEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getStoreEnabled()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isTemporaryTemplateSet()) {
                    stringBuffer.append("TemporaryTemplate");
                    stringBuffer.append(String.valueOf(this.bean.getTemporaryTemplate()));
                }
                if (this.bean.isTemporaryTemplateNameSet()) {
                    stringBuffer.append("TemporaryTemplateName");
                    stringBuffer.append(String.valueOf(this.bean.getTemporaryTemplateName()));
                }
                if (this.bean.isTemporaryTemplateResourceSet()) {
                    stringBuffer.append("TemporaryTemplateResource");
                    stringBuffer.append(String.valueOf(this.bean.getTemporaryTemplateResource()));
                }
                if (this.bean.isAllowsPersistentDowngradeSet()) {
                    stringBuffer.append("AllowsPersistentDowngrade");
                    stringBuffer.append(String.valueOf(this.bean.isAllowsPersistentDowngrade()));
                }
                if (this.bean.isBytesPagingEnabledSet()) {
                    stringBuffer.append("BytesPagingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isBytesPagingEnabled()));
                }
                if (this.bean.isHostingTemporaryDestinationsSet()) {
                    stringBuffer.append("HostingTemporaryDestinations");
                    stringBuffer.append(String.valueOf(this.bean.isHostingTemporaryDestinations()));
                }
                if (this.bean.isJDBCStoreUpgradeEnabledSet()) {
                    stringBuffer.append("JDBCStoreUpgradeEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isJDBCStoreUpgradeEnabled()));
                }
                if (this.bean.isMessagesPagingEnabledSet()) {
                    stringBuffer.append("MessagesPagingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isMessagesPagingEnabled()));
                }
                if (this.bean.isPagingFileLockingEnabledSet()) {
                    stringBuffer.append("PagingFileLockingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isPagingFileLockingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMSServerMBeanImpl jMSServerMBeanImpl = (JMSServerMBeanImpl)abstractDescriptorBean;
                this.computeDiff("BlockingSendPolicy", this.bean.getBlockingSendPolicy(), jMSServerMBeanImpl.getBlockingSendPolicy(), true);
                this.computeDiff("BytesMaximum", this.bean.getBytesMaximum(), jMSServerMBeanImpl.getBytesMaximum(), true);
                this.computeDiff("BytesThresholdHigh", this.bean.getBytesThresholdHigh(), jMSServerMBeanImpl.getBytesThresholdHigh(), true);
                this.computeDiff("BytesThresholdLow", this.bean.getBytesThresholdLow(), jMSServerMBeanImpl.getBytesThresholdLow(), true);
                this.computeDiff("ConsumptionPausedAtStartup", this.bean.getConsumptionPausedAtStartup(), jMSServerMBeanImpl.getConsumptionPausedAtStartup(), false);
                this.computeDiff("ExpirationScanInterval", this.bean.getExpirationScanInterval(), jMSServerMBeanImpl.getExpirationScanInterval(), true);
                this.computeDiff("InsertionPausedAtStartup", this.bean.getInsertionPausedAtStartup(), jMSServerMBeanImpl.getInsertionPausedAtStartup(), false);
                this.computeSubDiff("JMSMessageLogFile", this.bean.getJMSMessageLogFile(), jMSServerMBeanImpl.getJMSMessageLogFile());
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("JMSQueues", this.bean.getJMSQueues(), jMSServerMBeanImpl.getJMSQueues(), false);
                }
                this.computeChildDiff("JMSSessionPools", this.bean.getJMSSessionPools(), jMSServerMBeanImpl.getJMSSessionPools(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("JMSTopics", this.bean.getJMSTopics(), jMSServerMBeanImpl.getJMSTopics(), true);
                }
                this.computeDiff("MaximumMessageSize", this.bean.getMaximumMessageSize(), jMSServerMBeanImpl.getMaximumMessageSize(), true);
                this.computeDiff("MessageBufferSize", this.bean.getMessageBufferSize(), jMSServerMBeanImpl.getMessageBufferSize(), true);
                this.computeDiff("MessagesMaximum", this.bean.getMessagesMaximum(), jMSServerMBeanImpl.getMessagesMaximum(), true);
                this.computeDiff("MessagesThresholdHigh", this.bean.getMessagesThresholdHigh(), jMSServerMBeanImpl.getMessagesThresholdHigh(), true);
                this.computeDiff("MessagesThresholdLow", this.bean.getMessagesThresholdLow(), jMSServerMBeanImpl.getMessagesThresholdLow(), true);
                this.computeDiff("Name", this.bean.getName(), jMSServerMBeanImpl.getName(), false);
                this.computeDiff("PagingBlockSize", this.bean.getPagingBlockSize(), jMSServerMBeanImpl.getPagingBlockSize(), false);
                this.computeDiff("PagingDirectory", this.bean.getPagingDirectory(), jMSServerMBeanImpl.getPagingDirectory(), false);
                this.computeDiff("PagingIoBufferSize", this.bean.getPagingIoBufferSize(), jMSServerMBeanImpl.getPagingIoBufferSize(), false);
                this.computeDiff("PagingMaxFileSize", this.bean.getPagingMaxFileSize(), jMSServerMBeanImpl.getPagingMaxFileSize(), false);
                this.computeDiff("PagingMaxWindowBufferSize", this.bean.getPagingMaxWindowBufferSize(), jMSServerMBeanImpl.getPagingMaxWindowBufferSize(), false);
                this.computeDiff("PagingMinWindowBufferSize", this.bean.getPagingMinWindowBufferSize(), jMSServerMBeanImpl.getPagingMinWindowBufferSize(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PagingStore", this.bean.getPagingStore(), jMSServerMBeanImpl.getPagingStore(), false);
                }
                this.computeDiff("PersistentStore", this.bean.getPersistentStore(), jMSServerMBeanImpl.getPersistentStore(), false);
                this.computeDiff("ProductionPausedAtStartup", this.bean.getProductionPausedAtStartup(), jMSServerMBeanImpl.getProductionPausedAtStartup(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Store", this.bean.getStore(), jMSServerMBeanImpl.getStore(), false);
                }
                this.computeDiff("StoreEnabled", this.bean.getStoreEnabled(), jMSServerMBeanImpl.getStoreEnabled(), false);
                this.computeDiff("Targets", this.bean.getTargets(), jMSServerMBeanImpl.getTargets(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TemporaryTemplate", this.bean.getTemporaryTemplate(), jMSServerMBeanImpl.getTemporaryTemplate(), false);
                }
                this.computeDiff("TemporaryTemplateName", this.bean.getTemporaryTemplateName(), jMSServerMBeanImpl.getTemporaryTemplateName(), true);
                this.computeDiff("TemporaryTemplateResource", this.bean.getTemporaryTemplateResource(), jMSServerMBeanImpl.getTemporaryTemplateResource(), true);
                this.computeDiff("AllowsPersistentDowngrade", this.bean.isAllowsPersistentDowngrade(), jMSServerMBeanImpl.isAllowsPersistentDowngrade(), true);
                this.computeDiff("BytesPagingEnabled", this.bean.isBytesPagingEnabled(), jMSServerMBeanImpl.isBytesPagingEnabled(), false);
                this.computeDiff("HostingTemporaryDestinations", this.bean.isHostingTemporaryDestinations(), jMSServerMBeanImpl.isHostingTemporaryDestinations(), true);
                this.computeDiff("JDBCStoreUpgradeEnabled", this.bean.isJDBCStoreUpgradeEnabled(), jMSServerMBeanImpl.isJDBCStoreUpgradeEnabled(), false);
                this.computeDiff("MessagesPagingEnabled", this.bean.isMessagesPagingEnabled(), jMSServerMBeanImpl.isMessagesPagingEnabled(), false);
                this.computeDiff("PagingFileLockingEnabled", this.bean.isPagingFileLockingEnabled(), jMSServerMBeanImpl.isPagingFileLockingEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMSServerMBeanImpl jMSServerMBeanImpl = (JMSServerMBeanImpl)beanUpdateEvent.getSourceBean();
                JMSServerMBeanImpl jMSServerMBeanImpl2 = (JMSServerMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BlockingSendPolicy")) {
                    jMSServerMBeanImpl.setBlockingSendPolicy(jMSServerMBeanImpl2.getBlockingSendPolicy());
                    jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 41);
                } else if (string.equals("BytesMaximum")) {
                    jMSServerMBeanImpl.setBytesMaximum(jMSServerMBeanImpl2.getBytesMaximum());
                    jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("BytesThresholdHigh")) {
                    jMSServerMBeanImpl.setBytesThresholdHigh(jMSServerMBeanImpl2.getBytesThresholdHigh());
                    jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("BytesThresholdLow")) {
                    jMSServerMBeanImpl.setBytesThresholdLow(jMSServerMBeanImpl2.getBytesThresholdLow());
                    jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("ConsumptionPausedAtStartup")) {
                    jMSServerMBeanImpl.setConsumptionPausedAtStartup(jMSServerMBeanImpl2.getConsumptionPausedAtStartup());
                    jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 44);
                } else if (!string.equals("Destinations")) {
                    if (string.equals("ExpirationScanInterval")) {
                        jMSServerMBeanImpl.setExpirationScanInterval(jMSServerMBeanImpl2.getExpirationScanInterval());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                    } else if (string.equals("InsertionPausedAtStartup")) {
                        jMSServerMBeanImpl.setInsertionPausedAtStartup(jMSServerMBeanImpl2.getInsertionPausedAtStartup());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 43);
                    } else if (string.equals("JMSMessageLogFile")) {
                        if (n == 2) {
                            jMSServerMBeanImpl.setJMSMessageLogFile((JMSMessageLogFileMBean)this.createCopy((AbstractDescriptorBean)jMSServerMBeanImpl2.getJMSMessageLogFile()));
                        } else if (n == 3) {
                            jMSServerMBeanImpl._destroySingleton("JMSMessageLogFile", jMSServerMBeanImpl.getJMSMessageLogFile());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 47);
                    } else if (string.equals("JMSQueues")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                            jMSServerMBeanImpl.addJMSQueue((JMSQueueMBean)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            jMSServerMBeanImpl.removeJMSQueue((JMSQueueMBean)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (jMSServerMBeanImpl.getJMSQueues() == null || jMSServerMBeanImpl.getJMSQueues().length == 0) {
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 45);
                        }
                    } else if (string.equals("JMSSessionPools")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                            jMSServerMBeanImpl.addJMSSessionPool((JMSSessionPoolMBean)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            jMSServerMBeanImpl.removeJMSSessionPool((JMSSessionPoolMBean)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (jMSServerMBeanImpl.getJMSSessionPools() == null || jMSServerMBeanImpl.getJMSSessionPools().length == 0) {
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                        }
                    } else if (string.equals("JMSTopics")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                            jMSServerMBeanImpl.addJMSTopic((JMSTopicMBean)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            jMSServerMBeanImpl.removeJMSTopic((JMSTopicMBean)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (jMSServerMBeanImpl.getJMSTopics() == null || jMSServerMBeanImpl.getJMSTopics().length == 0) {
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 46);
                        }
                    } else if (string.equals("MaximumMessageSize")) {
                        jMSServerMBeanImpl.setMaximumMessageSize(jMSServerMBeanImpl2.getMaximumMessageSize());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                    } else if (string.equals("MessageBufferSize")) {
                        jMSServerMBeanImpl.setMessageBufferSize(jMSServerMBeanImpl2.getMessageBufferSize());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                    } else if (string.equals("MessagesMaximum")) {
                        jMSServerMBeanImpl.setMessagesMaximum(jMSServerMBeanImpl2.getMessagesMaximum());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                    } else if (string.equals("MessagesThresholdHigh")) {
                        jMSServerMBeanImpl.setMessagesThresholdHigh(jMSServerMBeanImpl2.getMessagesThresholdHigh());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                    } else if (string.equals("MessagesThresholdLow")) {
                        jMSServerMBeanImpl.setMessagesThresholdLow(jMSServerMBeanImpl2.getMessagesThresholdLow());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                    } else if (string.equals("Name")) {
                        jMSServerMBeanImpl.setName(jMSServerMBeanImpl2.getName());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("PagingBlockSize")) {
                        jMSServerMBeanImpl.setPagingBlockSize(jMSServerMBeanImpl2.getPagingBlockSize());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                    } else if (string.equals("PagingDirectory")) {
                        jMSServerMBeanImpl.setPagingDirectory(jMSServerMBeanImpl2.getPagingDirectory());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                    } else if (string.equals("PagingIoBufferSize")) {
                        jMSServerMBeanImpl.setPagingIoBufferSize(jMSServerMBeanImpl2.getPagingIoBufferSize());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                    } else if (string.equals("PagingMaxFileSize")) {
                        jMSServerMBeanImpl.setPagingMaxFileSize(jMSServerMBeanImpl2.getPagingMaxFileSize());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                    } else if (string.equals("PagingMaxWindowBufferSize")) {
                        jMSServerMBeanImpl.setPagingMaxWindowBufferSize(jMSServerMBeanImpl2.getPagingMaxWindowBufferSize());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                    } else if (string.equals("PagingMinWindowBufferSize")) {
                        jMSServerMBeanImpl.setPagingMinWindowBufferSize(jMSServerMBeanImpl2.getPagingMinWindowBufferSize());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                    } else if (string.equals("PagingStore")) {
                        jMSServerMBeanImpl.setPagingStoreAsString(jMSServerMBeanImpl2.getPagingStoreAsString());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                    } else if (string.equals("PersistentStore")) {
                        jMSServerMBeanImpl.setPersistentStoreAsString(jMSServerMBeanImpl2.getPersistentStoreAsString());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (string.equals("ProductionPausedAtStartup")) {
                        jMSServerMBeanImpl.setProductionPausedAtStartup(jMSServerMBeanImpl2.getProductionPausedAtStartup());
                        jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                    } else if (!string.equals("ServerNames") && !string.equals("SessionPools")) {
                        if (string.equals("Store")) {
                            jMSServerMBeanImpl.setStoreAsString(jMSServerMBeanImpl2.getStoreAsString());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                        } else if (string.equals("StoreEnabled")) {
                            jMSServerMBeanImpl.setStoreEnabled(jMSServerMBeanImpl2.getStoreEnabled());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                        } else if (string.equals("Targets")) {
                            jMSServerMBeanImpl.setTargetsAsString(jMSServerMBeanImpl2.getTargetsAsString());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                        } else if (string.equals("TemporaryTemplate")) {
                            jMSServerMBeanImpl.setTemporaryTemplateAsString(jMSServerMBeanImpl2.getTemporaryTemplateAsString());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                        } else if (string.equals("TemporaryTemplateName")) {
                            jMSServerMBeanImpl.setTemporaryTemplateName(jMSServerMBeanImpl2.getTemporaryTemplateName());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                        } else if (string.equals("TemporaryTemplateResource")) {
                            jMSServerMBeanImpl.setTemporaryTemplateResource(jMSServerMBeanImpl2.getTemporaryTemplateResource());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                        } else if (string.equals("AllowsPersistentDowngrade")) {
                            jMSServerMBeanImpl.setAllowsPersistentDowngrade(jMSServerMBeanImpl2.isAllowsPersistentDowngrade());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                        } else if (string.equals("BytesPagingEnabled")) {
                            jMSServerMBeanImpl.setBytesPagingEnabled(jMSServerMBeanImpl2.isBytesPagingEnabled());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                        } else if (string.equals("HostingTemporaryDestinations")) {
                            jMSServerMBeanImpl.setHostingTemporaryDestinations(jMSServerMBeanImpl2.isHostingTemporaryDestinations());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                        } else if (string.equals("JDBCStoreUpgradeEnabled")) {
                            jMSServerMBeanImpl.setJDBCStoreUpgradeEnabled(jMSServerMBeanImpl2.isJDBCStoreUpgradeEnabled());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                        } else if (string.equals("MessagesPagingEnabled")) {
                            jMSServerMBeanImpl.setMessagesPagingEnabled(jMSServerMBeanImpl2.isMessagesPagingEnabled());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                        } else if (string.equals("PagingFileLockingEnabled")) {
                            jMSServerMBeanImpl.setPagingFileLockingEnabled(jMSServerMBeanImpl2.isPagingFileLockingEnabled());
                            jMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                        } else {
                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                int n;
                JMSConstants[] jMSConstantsArray;
                JMSConstants[] jMSConstantsArray2;
                JMSServerMBeanImpl jMSServerMBeanImpl = (JMSServerMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMSServerMBeanImpl, bl, list);
                if ((list == null || !list.contains("BlockingSendPolicy")) && this.bean.isBlockingSendPolicySet()) {
                    jMSServerMBeanImpl.setBlockingSendPolicy(this.bean.getBlockingSendPolicy());
                }
                if ((list == null || !list.contains("BytesMaximum")) && this.bean.isBytesMaximumSet()) {
                    jMSServerMBeanImpl.setBytesMaximum(this.bean.getBytesMaximum());
                }
                if ((list == null || !list.contains("BytesThresholdHigh")) && this.bean.isBytesThresholdHighSet()) {
                    jMSServerMBeanImpl.setBytesThresholdHigh(this.bean.getBytesThresholdHigh());
                }
                if ((list == null || !list.contains("BytesThresholdLow")) && this.bean.isBytesThresholdLowSet()) {
                    jMSServerMBeanImpl.setBytesThresholdLow(this.bean.getBytesThresholdLow());
                }
                if ((list == null || !list.contains("ConsumptionPausedAtStartup")) && this.bean.isConsumptionPausedAtStartupSet()) {
                    jMSServerMBeanImpl.setConsumptionPausedAtStartup(this.bean.getConsumptionPausedAtStartup());
                }
                if ((list == null || !list.contains("ExpirationScanInterval")) && this.bean.isExpirationScanIntervalSet()) {
                    jMSServerMBeanImpl.setExpirationScanInterval(this.bean.getExpirationScanInterval());
                }
                if ((list == null || !list.contains("InsertionPausedAtStartup")) && this.bean.isInsertionPausedAtStartupSet()) {
                    jMSServerMBeanImpl.setInsertionPausedAtStartup(this.bean.getInsertionPausedAtStartup());
                }
                if (!(list != null && list.contains("JMSMessageLogFile") || !this.bean.isJMSMessageLogFileSet() || jMSServerMBeanImpl._isSet(47))) {
                    JMSMessageLogFileMBean jMSMessageLogFileMBean = this.bean.getJMSMessageLogFile();
                    jMSServerMBeanImpl.setJMSMessageLogFile(null);
                    jMSServerMBeanImpl.setJMSMessageLogFile(jMSMessageLogFileMBean == null ? null : (JMSMessageLogFileMBean)this.createCopy((AbstractDescriptorBean)jMSMessageLogFileMBean, bl));
                }
                if (bl && (list == null || !list.contains("JMSQueues")) && this.bean.isJMSQueuesSet() && !jMSServerMBeanImpl._isSet(45)) {
                    jMSConstantsArray2 = this.bean.getJMSQueues();
                    jMSConstantsArray = new JMSQueueMBean[jMSConstantsArray2.length];
                    for (n = 0; n < jMSConstantsArray.length; ++n) {
                        jMSConstantsArray[n] = (JMSQueueMBean)this.createCopy((AbstractDescriptorBean)jMSConstantsArray2[n], bl);
                    }
                    jMSServerMBeanImpl.setJMSQueues((JMSQueueMBean[])jMSConstantsArray);
                }
                if (!(list != null && list.contains("JMSSessionPools") || !this.bean.isJMSSessionPoolsSet() || jMSServerMBeanImpl._isSet(11))) {
                    jMSConstantsArray2 = this.bean.getJMSSessionPools();
                    jMSConstantsArray = new JMSSessionPoolMBean[jMSConstantsArray2.length];
                    for (n = 0; n < jMSConstantsArray.length; ++n) {
                        jMSConstantsArray[n] = (JMSSessionPoolMBean)this.createCopy((AbstractDescriptorBean)jMSConstantsArray2[n], bl);
                    }
                    jMSServerMBeanImpl.setJMSSessionPools((JMSSessionPoolMBean[])jMSConstantsArray);
                }
                if (bl && (list == null || !list.contains("JMSTopics")) && this.bean.isJMSTopicsSet() && !jMSServerMBeanImpl._isSet(46)) {
                    jMSConstantsArray2 = this.bean.getJMSTopics();
                    jMSConstantsArray = new JMSTopicMBean[jMSConstantsArray2.length];
                    for (n = 0; n < jMSConstantsArray.length; ++n) {
                        jMSConstantsArray[n] = (JMSTopicMBean)this.createCopy((AbstractDescriptorBean)jMSConstantsArray2[n], bl);
                    }
                    jMSServerMBeanImpl.setJMSTopics((JMSTopicMBean[])jMSConstantsArray);
                }
                if ((list == null || !list.contains("MaximumMessageSize")) && this.bean.isMaximumMessageSizeSet()) {
                    jMSServerMBeanImpl.setMaximumMessageSize(this.bean.getMaximumMessageSize());
                }
                if ((list == null || !list.contains("MessageBufferSize")) && this.bean.isMessageBufferSizeSet()) {
                    jMSServerMBeanImpl.setMessageBufferSize(this.bean.getMessageBufferSize());
                }
                if ((list == null || !list.contains("MessagesMaximum")) && this.bean.isMessagesMaximumSet()) {
                    jMSServerMBeanImpl.setMessagesMaximum(this.bean.getMessagesMaximum());
                }
                if ((list == null || !list.contains("MessagesThresholdHigh")) && this.bean.isMessagesThresholdHighSet()) {
                    jMSServerMBeanImpl.setMessagesThresholdHigh(this.bean.getMessagesThresholdHigh());
                }
                if ((list == null || !list.contains("MessagesThresholdLow")) && this.bean.isMessagesThresholdLowSet()) {
                    jMSServerMBeanImpl.setMessagesThresholdLow(this.bean.getMessagesThresholdLow());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jMSServerMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PagingBlockSize")) && this.bean.isPagingBlockSizeSet()) {
                    jMSServerMBeanImpl.setPagingBlockSize(this.bean.getPagingBlockSize());
                }
                if ((list == null || !list.contains("PagingDirectory")) && this.bean.isPagingDirectorySet()) {
                    jMSServerMBeanImpl.setPagingDirectory(this.bean.getPagingDirectory());
                }
                if ((list == null || !list.contains("PagingIoBufferSize")) && this.bean.isPagingIoBufferSizeSet()) {
                    jMSServerMBeanImpl.setPagingIoBufferSize(this.bean.getPagingIoBufferSize());
                }
                if ((list == null || !list.contains("PagingMaxFileSize")) && this.bean.isPagingMaxFileSizeSet()) {
                    jMSServerMBeanImpl.setPagingMaxFileSize(this.bean.getPagingMaxFileSize());
                }
                if ((list == null || !list.contains("PagingMaxWindowBufferSize")) && this.bean.isPagingMaxWindowBufferSizeSet()) {
                    jMSServerMBeanImpl.setPagingMaxWindowBufferSize(this.bean.getPagingMaxWindowBufferSize());
                }
                if ((list == null || !list.contains("PagingMinWindowBufferSize")) && this.bean.isPagingMinWindowBufferSizeSet()) {
                    jMSServerMBeanImpl.setPagingMinWindowBufferSize(this.bean.getPagingMinWindowBufferSize());
                }
                if (bl && (list == null || !list.contains("PagingStore")) && this.bean.isPagingStoreSet()) {
                    jMSServerMBeanImpl._unSet(jMSServerMBeanImpl, 28);
                    jMSServerMBeanImpl.setPagingStoreAsString(this.bean.getPagingStoreAsString());
                }
                if ((list == null || !list.contains("PersistentStore")) && this.bean.isPersistentStoreSet()) {
                    jMSServerMBeanImpl._unSet(jMSServerMBeanImpl, 14);
                    jMSServerMBeanImpl.setPersistentStoreAsString(this.bean.getPersistentStoreAsString());
                }
                if ((list == null || !list.contains("ProductionPausedAtStartup")) && this.bean.isProductionPausedAtStartupSet()) {
                    jMSServerMBeanImpl.setProductionPausedAtStartup(this.bean.getProductionPausedAtStartup());
                }
                if (bl && (list == null || !list.contains("Store")) && this.bean.isStoreSet()) {
                    jMSServerMBeanImpl._unSet(jMSServerMBeanImpl, 13);
                    jMSServerMBeanImpl.setStoreAsString(this.bean.getStoreAsString());
                }
                if ((list == null || !list.contains("StoreEnabled")) && this.bean.isStoreEnabledSet()) {
                    jMSServerMBeanImpl.setStoreEnabled(this.bean.getStoreEnabled());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    jMSServerMBeanImpl._unSet(jMSServerMBeanImpl, 7);
                    jMSServerMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if (bl && (list == null || !list.contains("TemporaryTemplate")) && this.bean.isTemporaryTemplateSet()) {
                    jMSServerMBeanImpl._unSet(jMSServerMBeanImpl, 17);
                    jMSServerMBeanImpl.setTemporaryTemplateAsString(this.bean.getTemporaryTemplateAsString());
                }
                if ((list == null || !list.contains("TemporaryTemplateName")) && this.bean.isTemporaryTemplateNameSet()) {
                    jMSServerMBeanImpl.setTemporaryTemplateName(this.bean.getTemporaryTemplateName());
                }
                if ((list == null || !list.contains("TemporaryTemplateResource")) && this.bean.isTemporaryTemplateResourceSet()) {
                    jMSServerMBeanImpl.setTemporaryTemplateResource(this.bean.getTemporaryTemplateResource());
                }
                if ((list == null || !list.contains("AllowsPersistentDowngrade")) && this.bean.isAllowsPersistentDowngradeSet()) {
                    jMSServerMBeanImpl.setAllowsPersistentDowngrade(this.bean.isAllowsPersistentDowngrade());
                }
                if ((list == null || !list.contains("BytesPagingEnabled")) && this.bean.isBytesPagingEnabledSet()) {
                    jMSServerMBeanImpl.setBytesPagingEnabled(this.bean.isBytesPagingEnabled());
                }
                if ((list == null || !list.contains("HostingTemporaryDestinations")) && this.bean.isHostingTemporaryDestinationsSet()) {
                    jMSServerMBeanImpl.setHostingTemporaryDestinations(this.bean.isHostingTemporaryDestinations());
                }
                if ((list == null || !list.contains("JDBCStoreUpgradeEnabled")) && this.bean.isJDBCStoreUpgradeEnabledSet()) {
                    jMSServerMBeanImpl.setJDBCStoreUpgradeEnabled(this.bean.isJDBCStoreUpgradeEnabled());
                }
                if ((list == null || !list.contains("MessagesPagingEnabled")) && this.bean.isMessagesPagingEnabledSet()) {
                    jMSServerMBeanImpl.setMessagesPagingEnabled(this.bean.isMessagesPagingEnabled());
                }
                if ((list == null || !list.contains("PagingFileLockingEnabled")) && this.bean.isPagingFileLockingEnabledSet()) {
                    jMSServerMBeanImpl.setPagingFileLockingEnabled(this.bean.isPagingFileLockingEnabled());
                }
                return jMSServerMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDestinations(), clazz, object);
            this.inferSubTree(this.bean.getJMSMessageLogFile(), clazz, object);
            this.inferSubTree(this.bean.getJMSQueues(), clazz, object);
            this.inferSubTree(this.bean.getJMSSessionPools(), clazz, object);
            this.inferSubTree(this.bean.getJMSTopics(), clazz, object);
            this.inferSubTree(this.bean.getPagingStore(), clazz, object);
            this.inferSubTree(this.bean.getPersistentStore(), clazz, object);
            this.inferSubTree(this.bean.getSessionPools(), clazz, object);
            this.inferSubTree(this.bean.getStore(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
            this.inferSubTree(this.bean.getTemporaryTemplate(), clazz, object);
        }
    }
}

