/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.configuration.DeploymentMBeanImplBeanInfo;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSServerMBeanImpl;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.internal.mbean.BeanInfoHelper;

public class JMSServerMBeanImplBeanInfo
extends DeploymentMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = JMSServerMBean.class;

    public JMSServerMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public JMSServerMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = JMSServerMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.management.configuration");
        String string = new String("This class represents a JMS server. A JMS server manages connections and message requests on behalf of clients.  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime. For more information, see \"Developing Manageable Applications with JMX.\"</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
        beanDescriptor.setValue("rolesAllowed", stringArray);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.configuration.JMSServerMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("BlockingSendPolicy")) {
            string2 = "getBlockingSendPolicy";
            string = null;
            if (!this.readOnly) {
                string = "setBlockingSendPolicy";
            }
            propertyDescriptor = new PropertyDescriptor("BlockingSendPolicy", JMSServerMBean.class, string2, string);
            map.put("BlockingSendPolicy", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Determines whether the JMS server delivers smaller messages before larger ones when a destination has exceeded its maximum number of messages. <code>FIFO</code> prevents the JMS server from delivering smaller messages when larger ones are already waiting for space. <code>Preemptive</code> allows smaller send requests to preempt previous larger ones when there is sufficient space for smaller messages on the destination.</p>  <p>This policy is defined only for the JMS server; it cannot be set on individual destinations.</p>  <p>Additional information on the <code>FIFO</code> and <code>Preemptive</code> policies is provided below.</p> <p> <code>FIFO</code> (first in, first out) indicates that all send requests for the same destination are queued up one behind the other until space is available. No send request is permitted to successfully complete if there is another send request waiting for space before it. When space is limited, the FIFO policy prevents the starvation of larger requests because smaller requests cannot continuously use the remaining available space. Smaller requests are delayed, though not starved, until the larger request can be completed. When space does become available, requests are considered in the order in which they were made. If there is sufficient space for a given request, then that request is completed and the next request is considered. If there is insufficient space for a given request, then no further requests are considered until sufficient space becomes available for the current request to complete.</p> <p> <code>Preemptive</code> indicates that a send operation can preempt other blocking send operations if space is available. That is, if there is sufficient space for the current request, then that space is used even if there are other requests waiting for space. When space is limited, the Preemptive policy can result in the starvation of larger requests. For example, if there is insufficient available space for a large request, then it is queued up behind other existing requests. When space does become available, all requests are considered in the order in which they were originally made. If there is sufficient space for a given request, then that request is allowed to continue and the next request is considered. If there is insufficient space for a given request, then that request is skipped and the next request is considered.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"FIFO");
            propertyDescriptor.setValue("legalValues", new Object[]{"FIFO", "Preemptive"});
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("BytesMaximum")) {
            string2 = "getBytesMaximum";
            string = null;
            if (!this.readOnly) {
                string = "setBytesMaximum";
            }
            propertyDescriptor = new PropertyDescriptor("BytesMaximum", JMSServerMBean.class, string2, string);
            map.put("BytesMaximum", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of bytes that can be stored in this JMS server. A value of <code>-1</code> removes any WebLogic Server limits.</p>  <p>Because excessive bytes volume can cause memory saturation, Oracle recommends that this maximum corresponds to the total amount of system memory available after accounting for the rest of your application load.</p>  <p><b>Range of Values:</b> &gt;= BytesThresholdHigh</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMax", new Long(Long.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("BytesThresholdHigh")) {
            string2 = "getBytesThresholdHigh";
            string = null;
            if (!this.readOnly) {
                string = "setBytesThresholdHigh";
            }
            propertyDescriptor = new PropertyDescriptor("BytesThresholdHigh", JMSServerMBean.class, string2, string);
            map.put("BytesThresholdHigh", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The upper threshold (number of bytes stored in this JMS server) that triggers flow control and logging events. A value of <code>-1</code> disables the events for this JMS server.</p>  <p>The triggered events are:</p> <ul> <li> <code>Log Messages</code> - A message is logged on the server indicating a high threshold condition. </li> <li> <code>Flow Control</code> - If flow control is enabled, the JMS server becomes armed and instructs producers to begin decreasing their message flow. </li> </ul>  <p><b>Range of Values:</b> &lt;= BytesMaximum; &gt;= BytesThresholdLow</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMax", new Long(Long.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("BytesThresholdLow")) {
            string2 = "getBytesThresholdLow";
            string = null;
            if (!this.readOnly) {
                string = "setBytesThresholdLow";
            }
            propertyDescriptor = new PropertyDescriptor("BytesThresholdLow", JMSServerMBean.class, string2, string);
            map.put("BytesThresholdLow", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The lower threshold (number of bytes stored in this JMS server) that triggers flow control and logging events. A value of <code>-1</code> disables the events for this JMS server.</p>  <p>If the number of bytes falls below this threshold, the triggered events are:</p> <ul> <li> <code>Log Messages</code> - A message is logged on the server indicating that the threshold condition has cleared. </li> <li> <code>Flow Control</code> - If flow control is enabled, the JMS server becomes disarmed and instructs producers to begin increasing their message flow. </li> </ul>  <p><b>Range of Values:</b> &lt;= BytesThresholdHigh</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMax", new Long(Long.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ConsumptionPausedAtStartup")) {
            string2 = "getConsumptionPausedAtStartup";
            string = null;
            if (!this.readOnly) {
                string = "setConsumptionPausedAtStartup";
            }
            propertyDescriptor = new PropertyDescriptor("ConsumptionPausedAtStartup", JMSServerMBean.class, string2, string);
            map.put("ConsumptionPausedAtStartup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether consumption is paused at startup on destinations targeted to this JMS server at startup. A destination cannot receive any new messages while it is paused.</p>  <p>When the value is set to <code>true</code>, then immediately after the host server instance is booted, then this JMS server and its targeted destinations are modified such that they are in a \"consumption paused\" state, which prevents any message consuming activity on those destinations.</p>  <p>To allow normal message consumption on the destinations, later you will have to change the state of this JMS server to a \"consumption enabled\" state by setting this value to <code>false</code>, and then either redeploy the JMS server or reboot the hosting server instance.</p>  <p>When the value is set to <code>default</code>, then the Consumption Paused At Startup is determined based on the corresponding setting on the individual destination.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.runtime.JMSServerRuntimeMBean#resumeConsumption"), BeanInfoHelper.encodeEntities((String)"weblogic.management.runtime.JMSDestinationRuntimeMBean#resumeConsumption")};
            propertyDescriptor.setValue("see", stringArray);
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"default");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("Destinations")) {
            string2 = "getDestinations";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Destinations", JMSServerMBean.class, string2, string);
            map.put("Destinations", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>All defined destinations and their associated JNDI names.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("adder", "addDestination");
            propertyDescriptor.setValue("remover", "removeDestination");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the functionality of JMS modules. ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("ExpirationScanInterval")) {
            string2 = "getExpirationScanInterval";
            string = null;
            if (!this.readOnly) {
                string = "setExpirationScanInterval";
            }
            propertyDescriptor = new PropertyDescriptor("ExpirationScanInterval", JMSServerMBean.class, string2, string);
            map.put("ExpirationScanInterval", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds between this JMS server's cycles of scanning local destinations for expired messages. A value of <code>0</code> disables active scanning. A very large scan interval effectively disables active scanning.</p>  <p>With scanning disabled, users still do not receive expired messages and any expired messages that are discovered by other system activities are removed. However, expired messages sitting in idle destinations (such as an inactive queue or disconnected durable subscriber) are not removed and continue to consume system resources.</p>  <p>The scanning cycle for expired messages occurs as follows:</p> <ul> <li> After the specified waiting period, the JMS server devotes a separate thread to scan all of its local destinations for expired messages. </li> <li> After the scanning is completed, all located expired messages are processed according to the specified Expiration Policy on the destination (Discard, Log, or Redirect). </li> <li> The entire process repeats after another specified waiting period. </li> </ul>  <p><b>Note:</b> Because a new scan does not start until the current one is finished and until the specified waiting period ends, an expired message could still remain in the system for the maximum scan waiting period plus the amount of time it takes to perform the scan.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(30));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("InsertionPausedAtStartup")) {
            string2 = "getInsertionPausedAtStartup";
            string = null;
            if (!this.readOnly) {
                string = "setInsertionPausedAtStartup";
            }
            propertyDescriptor = new PropertyDescriptor("InsertionPausedAtStartup", JMSServerMBean.class, string2, string);
            map.put("InsertionPausedAtStartup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether insertion is paused at startup on destinations targeted to this JMS server. A destination cannot receive any new messages while it is paused.</p>  <p>When the value is set to <code>true</code>, then immediately after the host server instance is booted, then this JMS server and its targeted destinations are modified such that they are in a \"insertion paused\" state, which results preventing messages that are result of the \"in-flight\" work completion to arrive on those destinations.</p>  <p><b>Note:</b> For a detailed definition of \"in-flight\" work/messages, see weblogic.management.runtime.JMSServerRuntimeMBean#resumeInsertion and weblogic.management.runtime.JMSDestinationRuntime#resumeInsertion</p>  <p>To allow in-flight work messages to appear on the destinations, later you will have to change the state of this JMS server to an \"insertion enabled\" state by setting this value to <code>false</code>, and then either redeploy the JMS server or reboot the hosting server instance.</p>  <p>When the value is set to <code>default</code>, then the Insertion Paused At Startup is determined based on the corresponding setting on the individual destination.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.runtime.JMSServerRuntimeMBean#resumeInsertion"), BeanInfoHelper.encodeEntities((String)"weblogic.management.runtime.JMSDestinationRuntimeMBean#resumeInsertion")};
            propertyDescriptor.setValue("see", stringArray);
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"default");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("JMSMessageLogFile")) {
            string2 = "getJMSMessageLogFile";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JMSMessageLogFile", JMSServerMBean.class, string2, string);
            map.put("JMSMessageLogFile", propertyDescriptor);
            propertyDescriptor.setValue("description", "The message log file configuration for this JMS Server. ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("JMSQueues")) {
            string2 = "getJMSQueues";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JMSQueues", JMSServerMBean.class, string2, string);
            map.put("JMSQueues", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Acquire JMSQueues for this JMSServer</p> ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyJMSQueue");
            propertyDescriptor.setValue("creator", "createJMSQueue");
            propertyDescriptor.setValue("creator", "createJMSQueue");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("JMSSessionPools")) {
            string2 = "getJMSSessionPools";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JMSSessionPools", JMSServerMBean.class, string2, string);
            map.put("JMSSessionPools", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The session pools defined for the JMS server.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyJMSSessionPool");
            propertyDescriptor.setValue("creator", "createJMSSessionPool");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by message-driven beans. The JMSSessionPoolMBean type was deprecated. See JMSSessionPoolMBean for more information. ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("JMSTopics")) {
            string2 = "getJMSTopics";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JMSTopics", JMSServerMBean.class, string2, string);
            map.put("JMSTopics", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Define JMSTopics for this Domain</p> ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("creator", "createJMSTopic");
            propertyDescriptor.setValue("destroyer", "destroyJMSTopic");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("MaximumMessageSize")) {
            string2 = "getMaximumMessageSize";
            string = null;
            if (!this.readOnly) {
                string = "setMaximumMessageSize";
            }
            propertyDescriptor = new PropertyDescriptor("MaximumMessageSize", JMSServerMBean.class, string2, string);
            map.put("MaximumMessageSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of bytes allowed in individual messages on this JMS server. The size of a message includes the message body, any user-defined properties, and the user-defined JMS header fields <code>JMSCorrelationID</code> and <code>JMSType</code>.</p>  <p>The maximum message size is only enforced for the initial production of a message. Messages that are redirected to an error destination or forwarded to a member of a distributed destination are not checked for size. For instance, if a destination and its corresponding error destination are configured with a maximum message size of 128K bytes and 64K bytes, respectively, a message of 96K bytes could be redirected to the error destination (even though it exceeds the 64K byte maximum), but a producer could not directly send the 96K byte message to the error destination.</p>  <p><b>Note:</b> Any change to this maximum affects only incoming messages; stored messages are not affected.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessageBufferSize")) {
            string2 = "getMessageBufferSize";
            string = null;
            if (!this.readOnly) {
                string = "setMessageBufferSize";
            }
            propertyDescriptor = new PropertyDescriptor("MessageBufferSize", JMSServerMBean.class, string2, string);
            map.put("MessageBufferSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The amount of memory (in bytes) that this JMS server can use to store message bodies before it writes them to disk. When the JMS server writes the message bodies to disk, it clears them from memory.</p>  <p>A value of -1 (the default) specifies that the server will automatically determine a size based on the maximum heap size of the JVM. This default will be set to either one-third the maximum heap size, or 512 megabytes, whichever is smaller.</p>  <p>The larger the buffer, the more memory JMS will consume when many messages are waiting on queues or topics. Once the buffer is surpassed, JMS may write message bodies to the directory specified by PagingDirectory in an effort to reduce memory usage below this buffer.</p>  <p>Surpassing the buffer size does not stop the JMS server from accepting new messages. It is still possible to run out of memory if messages are arriving faster than they can be written to disk. Users with high messaging loads who wish to support the highest possible availability should consider setting a quota or setting a threshold and enabling flow control.</p>  <p>Paging is always supported.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getPagingDirectory")};
            propertyDescriptor.setValue("see", stringArray);
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMax", new Long(Long.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessagesMaximum")) {
            string2 = "getMessagesMaximum";
            string = null;
            if (!this.readOnly) {
                string = "setMessagesMaximum";
            }
            propertyDescriptor = new PropertyDescriptor("MessagesMaximum", JMSServerMBean.class, string2, string);
            map.put("MessagesMaximum", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of messages that can be stored in this JMS server. A value of <code>-1</code> removes any WebLogic Server limits.</p>  <p>Because excessive message volume can cause memory saturation, Oracle recommends that this value corresponds to the total amount of system memory available after accounting for the rest of your application load.</p>  <p><b>Range of Values:</b> &gt;= MessagesThresholdHigh.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMax", new Long(Long.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessagesThresholdHigh")) {
            string2 = "getMessagesThresholdHigh";
            string = null;
            if (!this.readOnly) {
                string = "setMessagesThresholdHigh";
            }
            propertyDescriptor = new PropertyDescriptor("MessagesThresholdHigh", JMSServerMBean.class, string2, string);
            map.put("MessagesThresholdHigh", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The upper threshold (number of messages stored in this JMS server) that triggers flow control and logging events. A value of <code>-1</code> disables the events for this JMS server.</p>  <p>If the number of messages exceeds this threshold, the triggered events are:</p> <ul> <li> <code>Log Messages</code> - A message is logged on the server indicating a high threshold condition. </li> <li> <code>Flow Control</code> - If flow control is enabled, the JMS server becomes armed and instructs producers to begin decreasing their message flow. </li> </ul>  <p><b>Range of Values:</b> &lt;= MessagesMaximum; &gt;= MessagesThresholdLow.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMax", new Long(Long.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessagesThresholdLow")) {
            string2 = "getMessagesThresholdLow";
            string = null;
            if (!this.readOnly) {
                string = "setMessagesThresholdLow";
            }
            propertyDescriptor = new PropertyDescriptor("MessagesThresholdLow", JMSServerMBean.class, string2, string);
            map.put("MessagesThresholdLow", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The lower threshold (number of messages stored in this JMS server) that triggers flow control and logging events. A value of <code>-1</code> disables the events for this JMS server.</p>  <p>If the number of messages falls below this threshold, the triggered events are:</p> <ul> <li> <code>Log Messages</code> - A message is logged on the server indicating that the threshold condition has cleared. </li> <li> <code>Flow Control</code> - If flow control is enabled, the JMS server becomes disarmed and instructs producers to begin increasing their message flow. </li> </ul>  <p><i>Note:</i> This attribute is dynamically configurable.</p>  <p><b>Range of Values:</b> &lt;= MessagesThresholdHigh</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMax", new Long(Long.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            if (!this.readOnly) {
                string = "setName";
            }
            propertyDescriptor = new PropertyDescriptor("Name", JMSServerMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The user-specified name of this MBean instance.</p>  <p>This name is included as one of the key properties in the MBean's <code>javax.management.ObjectName</code>:<br clear=\"none\" /> <code>Name=<i>user-specified-name</i></code></p> ");
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("key", Boolean.TRUE);
        }
        if (!map.containsKey("PagingBlockSize")) {
            string2 = "getPagingBlockSize";
            string = null;
            if (!this.readOnly) {
                string = "setPagingBlockSize";
            }
            propertyDescriptor = new PropertyDescriptor("PagingBlockSize", JMSServerMBean.class, string2, string);
            map.put("PagingBlockSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The smallest addressable block, in bytes, of a file. When a native <code>wlfileio</code> driver is available and the paging block size has not been configured by the user, the store selects the minimum OS specific value for unbuffered (direct) I/O, if it is within the range [512, 8192].</p> A paging store's block size does not change once the paging store creates its files. Changes to block size only take effect for new paging stores or after the current files have been deleted. See \"Tuning the Persistent Store\" in <i>Performance and Tuning for Oracle WebLogic Server</i>. ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(8192));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("PagingDirectory")) {
            string2 = "getPagingDirectory";
            string = null;
            if (!this.readOnly) {
                string = "setPagingDirectory";
            }
            propertyDescriptor = new PropertyDescriptor("PagingDirectory", JMSServerMBean.class, string2, string);
            map.put("PagingDirectory", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Specifies where message bodies are written when the size of the message bodies in the JMS server exceeds the message buffer size.</p> <p> If unspecified, messages are written to the default <code>tmp</code> directory inside the <code><i>server-name</i></code> subdirectory of a domain's root directory. For example, <code><i>domain-name</i>/servers/<i>server-name</i>/tmp</code>, where <code><i>domain-name</i></code> is the root directory of your domain. </p> <p> For best performance, this directory should not be the same as the directory used by the JMS server's persistent store. </p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getMessageBufferSize")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("PagingIoBufferSize")) {
            string2 = "getPagingIoBufferSize";
            string = null;
            if (!this.readOnly) {
                string = "setPagingIoBufferSize";
            }
            propertyDescriptor = new PropertyDescriptor("PagingIoBufferSize", JMSServerMBean.class, string2, string);
            map.put("PagingIoBufferSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The I/O buffer size, in bytes, automatically rounded down to the nearest power of 2. <ul> <li>When a native <code>wlfileio</code> driver is available, the setting applies to off-heap (native) memory.</li> <li>When a native <code>wlfileio</code> driver is not available, the setting applies to JAVA heap memory.</li> <li>For the best runtime performance, Oracle recommends setting <code>PagingIOBufferSize</code> so that it is larger than the largest write (multiple concurrent store requests may be combined into a single write).</li> <li>See the JMS server runtime MBean attribute <code>PagingAllocatedIOBufferBytes</code> to find out the actual allocated off-heap (native) memory amount.</li> </ul> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(0x4000000));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("PagingMaxFileSize")) {
            string2 = "getPagingMaxFileSize";
            string = null;
            if (!this.readOnly) {
                string = "setPagingMaxFileSize";
            }
            propertyDescriptor = new PropertyDescriptor("PagingMaxFileSize", JMSServerMBean.class, string2, string);
            map.put("PagingMaxFileSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The paging maximum file size, in bytes. <ul> <li>The <code>PagingMaxFileSize</code> value affects the number of files needed to accommodate a paging store of a particular size (number of files = paging store size/MaxFileSize rounded up).</li>  <li>A paging store automatically reuses space freed by deleted records and automatically expands individual files up to <code>PagingMaxFileSize</code> if there is not enough space for a new record. If there is no space left in exiting files for a new record, a paging store creates an additional file.</li>  <li> A small number of larger files is normally preferred over a large number of smaller files as each file allocates Window Buffer and file handles. </li>  <li> If <code>PagingMaxFileSize</code> is larger than 2^24 * <code>PagingBlockSize</code>, then <code>MaxFileSize</code> is ignored, and the value becomes 2^24 * <code>PagingBlockSize</code>. The default <code>PagingBlockSize</code> is 512, and 2^24 * 512 is 8 GB. </li> </ul> Oracle recommends not setting the Paging Max File Size above the default value of 1,342,177,280.  </p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(0x50000000L));
            propertyDescriptor.setValue("legalMin", new Long(0xA00000L));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("PagingMaxWindowBufferSize")) {
            string2 = "getPagingMaxWindowBufferSize";
            string = null;
            if (!this.readOnly) {
                string = "setPagingMaxWindowBufferSize";
            }
            propertyDescriptor = new PropertyDescriptor("PagingMaxWindowBufferSize", JMSServerMBean.class, string2, string);
            map.put("PagingMaxWindowBufferSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum amount of data, in bytes and rounded down to the nearest power of 2, mapped into the JVM's address space per paging store file. Applies only when a native <code>wlfileio</code> library is loaded.</p>  <p>A window buffer does not consume Java heap memory, but does consume off-heap (native) memory. If the paging store is unable to allocate the requested buffer size, it allocates smaller and smaller buffers until it reaches <code>PagingMinWindowBufferSize</code>, and then fails if it cannot honor <code>PagingMinWindowBufferSize</code>.</p>  <p>Oracle recommends setting the max window buffer size to more than double the size of the largest write (multiple concurrently updated records may be combined into a single write), and greater than or equal to the file size, unless there are other constraints. 32-bit JVMs may impose a total limit of between 2 and 4GB for combined Java heap plus off-heap (native) memory usage.</p>  <ul> <li>See the JMS server runtime MBean attribute <code>PagingAllocatedWindowBufferBytes</code> to find out the actual allocated Window Buffer Size.<li> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(0x40000000));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("PagingMinWindowBufferSize")) {
            string2 = "getPagingMinWindowBufferSize";
            string = null;
            if (!this.readOnly) {
                string = "setPagingMinWindowBufferSize";
            }
            propertyDescriptor = new PropertyDescriptor("PagingMinWindowBufferSize", JMSServerMBean.class, string2, string);
            map.put("PagingMinWindowBufferSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The minimum amount of data, in bytes and rounded down to the nearest power of 2, mapped into the JVM's address space per paging store file.  Applies only when a native <code>wlfileio</code> library is loaded. See <a href='#getPagingMaxWindowBufferSize'>Paging Maximum Window Buffer Size</a>.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(0x40000000));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("PagingStore")) {
            string2 = "getPagingStore";
            string = null;
            if (!this.readOnly) {
                string = "setPagingStore";
            }
            propertyDescriptor = new PropertyDescriptor("PagingStore", JMSServerMBean.class, string2, string);
            map.put("PagingStore", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>This parameter has been deprecated. New configurations should use the \"PagingDirectory\" parameter if they wish to control where non-persistent messages will be temporarily stored.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getPagingDirectory")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the PagingDirectory attribute. ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("PersistentStore")) {
            string2 = "getPersistentStore";
            string = null;
            if (!this.readOnly) {
                string = "setPersistentStore";
            }
            propertyDescriptor = new PropertyDescriptor("PersistentStore", JMSServerMBean.class, string2, string);
            map.put("PersistentStore", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The file or database in which this JMS server stores persistent messages. If unspecified, the JMS server uses the default persistent store that is configured on each targeted WebLogic Server instance.</p>  <p>The disk-based file store or JDBC-accessible database store that you specify must be targeted to the same server instance as this JMS server. Multiple services on the same WebLogic Server instance, including multiple JMS servers, may share the same persistent store. Each service's persistent data will be kept apart.</p>  <p>If you specify a PersistentStore, the deprecated <b>Store</b> field must not be set. If neither the <b>PersistentStore</b> field nor the <b>Store</b> field are set, the JMS server supports persistent messaging using the default persistent store for the targeted WebLogic Server instance.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.PersistentStoreMBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ProductionPausedAtStartup")) {
            string2 = "getProductionPausedAtStartup";
            string = null;
            if (!this.readOnly) {
                string = "setProductionPausedAtStartup";
            }
            propertyDescriptor = new PropertyDescriptor("ProductionPausedAtStartup", JMSServerMBean.class, string2, string);
            map.put("ProductionPausedAtStartup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether production is paused at server startup on destinations targeted to this JMS server. A destination cannot receive any new messages while it is paused.</p>  <p>When the value is set to <code>true</code>, then immediately after the host server instance is rebooted, then this JMS server and its targeted destinations are modified such that they are in a \"production paused\" state, which results in preventing new message production activities on those destinations.</p>  <p>To resume normal new message production activity, later you will have to change the state of this JMS server to a \"production enabled\" state by setting this value to <code>false</code>, and then either redeploy the JMS server or reboot the hosting server instance. </p>  <p>When the value is set to <code>default</code>, then the Production Paused At Startup is determined based on the corresponding setting on the individual destination.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.runtime.JMSServerRuntimeMBean#resumeProduction"), BeanInfoHelper.encodeEntities((String)"weblogic.management.runtime.JMSDestinationRuntimeMBean#resumeProduction")};
            propertyDescriptor.setValue("see", stringArray);
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"default");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("SessionPools")) {
            string2 = "getSessionPools";
            string = null;
            if (!this.readOnly) {
                string = "setSessionPools";
            }
            propertyDescriptor = new PropertyDescriptor("SessionPools", JMSServerMBean.class, string2, string);
            map.put("SessionPools", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The session pools defined for the JMS server. This method is provided for backward compatibility.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("remover", "removeSessionPool");
            propertyDescriptor.setValue("adder", "addSessionPool");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by message-driven beans. The JMSSessionPoolMBean type was deprecated. See JMSSessionPoolMBean for more information. ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("Store")) {
            string2 = "getStore";
            string = null;
            if (!this.readOnly) {
                string = "setStore";
            }
            propertyDescriptor = new PropertyDescriptor("Store", JMSServerMBean.class, string2, string);
            map.put("Store", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The persistent disk-based file or JDBC-accessible database for the JMS server.</p>  <p>A persistent store may only be used by one JMS server. If this value is unset, the value set by the \"PersistentStore\" attribute is used. If neither attribute is set, the default persistent store for the targeted managed server is used. It is an error to set both attributes.</p>  <p>This attribute has been deprecated. New configurations should use the \"PersistentStore\" attribute, which allows multiple subsystems, including multiple JMS servers on the same managed server, to share the same persistent store.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getPersistentStore")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the PersistentStore attribute. ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("StoreEnabled")) {
            string2 = "getStoreEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setStoreEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("StoreEnabled", JMSServerMBean.class, string2, string);
            map.put("StoreEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Specifies whether message persistence is supported for this JMS server.</p> <p> When set to true, the default, then if the JMS server has no store configured, the targeted WebLogic Server instance's default store is used to store persistent messages. When set to false, then this JMS server does not support persistent messages, and instead downgrades them to non-persistent.</p> <p> Oracle recommends not setting this parameter to false. It is available to provide compatibility with older releases.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Targets")) {
            string2 = "getTargets";
            string = null;
            if (!this.readOnly) {
                string = "setTargets";
            }
            propertyDescriptor = new PropertyDescriptor("Targets", JMSServerMBean.class, string2, string);
            map.put("Targets", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The server instances or a migratable targets defined in the current domain that are candidates for hosting the JMSSerer.</p>  <p>In a clustered environment, a recommended best practice is to target a JMSServer to the same migratable target as the Persistent Store that it uses, so that a member server will not be a single point of failure. A JMSServer can also be configured to automatically migrate from an unhealthy server instance to a healthy server instance with the help of the automatic service migration feature.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("adder", "addTarget");
            propertyDescriptor.setValue("remover", "removeTarget");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("TemporaryTemplate")) {
            string2 = "getTemporaryTemplate";
            string = null;
            if (!this.readOnly) {
                string = "setTemporaryTemplate";
            }
            propertyDescriptor = new PropertyDescriptor("TemporaryTemplate", JMSServerMBean.class, string2, string);
            map.put("TemporaryTemplate", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of an existing JMS template to use when creating all temporary queues and topics for this JMS server. Specifying a value for this field allows JMS applications to create temporary destinations. If Store values are provided as part of a temporary template, they are ignored, because temporary destinations do not support persistent messaging.</p>  <p><i>Note:</i> If this attribute is set to none, attempts to create a temporary destination (queue or topic) will fail.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the TemporaryTemplateName and TemporaryTemplateResource attributes. ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("TemporaryTemplateName")) {
            string2 = "getTemporaryTemplateName";
            string = null;
            if (!this.readOnly) {
                string = "setTemporaryTemplateName";
            }
            propertyDescriptor = new PropertyDescriptor("TemporaryTemplateName", JMSServerMBean.class, string2, string);
            map.put("TemporaryTemplateName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of a configured JMS template that this JMS server uses to create temporary destinations.</p>  <p>Entering a template name, requires you to specify the JMS module that contains this template. However, a template name cannot be specified if the <b>Hosting Temporary Destinations</b> field is disabled.</p>  <p><b>Note:</b> If the specified JMS template provides persistent store values, they are ignored because temporary destinations do not support persistent messaging.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.JMSSystemResourceMBean"), BeanInfoHelper.encodeEntities((String)"weblogic.j2ee.descriptor.wl.TemplateBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("TemporaryTemplateResource")) {
            string2 = "getTemporaryTemplateResource";
            string = null;
            if (!this.readOnly) {
                string = "setTemporaryTemplateResource";
            }
            propertyDescriptor = new PropertyDescriptor("TemporaryTemplateResource", JMSServerMBean.class, string2, string);
            map.put("TemporaryTemplateResource", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of a JMS module that contains a template that this JMS server can use to create temporary destinations.</p>  <p>Entering a JMS module name requires you to specify a temporary template name. However, a module name cannot be specified if the <b>Hosting Temporary Destinations</b> field is disabled.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.JMSSystemResourceMBean"), BeanInfoHelper.encodeEntities((String)"weblogic.j2ee.descriptor.wl.TemplateBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("AllowsPersistentDowngrade")) {
            string2 = "isAllowsPersistentDowngrade";
            string = null;
            if (!this.readOnly) {
                string = "setAllowsPersistentDowngrade";
            }
            propertyDescriptor = new PropertyDescriptor("AllowsPersistentDowngrade", JMSServerMBean.class, string2, string);
            map.put("AllowsPersistentDowngrade", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether JMS clients will get an exception when sending persistent messages to a destination targeted to a JMS server that does not have a persistent store configured. This parameter only has effect when the Store Enabled parameter is disabled (false).</p>  <p>When set to false, the default, clients will get an exception when sending persistent messages to a JMS server with no store configured. When set to true, then persistent messages are downgraded to non-persistent; however, the send operations are allowed to continue.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("BytesPagingEnabled")) {
            string2 = "isBytesPagingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setBytesPagingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("BytesPagingEnabled", JMSServerMBean.class, string2, string);
            map.put("BytesPagingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>This parameter has been deprecated. Paging is always enabled. The \"MessageBufferSize\" parameter controls how much memory is used before paging kicks in.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getMessageBufferSize")};
            propertyDescriptor.setValue("see", stringArray);
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by defaulting the paging to always be enabled. ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("HostingTemporaryDestinations")) {
            string2 = "isHostingTemporaryDestinations";
            string = null;
            if (!this.readOnly) {
                string = "setHostingTemporaryDestinations";
            }
            propertyDescriptor = new PropertyDescriptor("HostingTemporaryDestinations", JMSServerMBean.class, string2, string);
            map.put("HostingTemporaryDestinations", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether this JMS server can be used to host temporary destinations.</p>  <p>If this field is enabled and no <b>Temporary Template Name</b> is defined, then the temporary destinations created on this JMS server will use all default destination values. If this field is enabled, then the JMS template to be used for creating temporary destinations is specified by the <b>Temporary Template Name</b> field. If this field is disabled, then this JMS server will not host temporary destinations.</p> ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessagesPagingEnabled")) {
            string2 = "isMessagesPagingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setMessagesPagingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("MessagesPagingEnabled", JMSServerMBean.class, string2, string);
            map.put("MessagesPagingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>This parameter has been deprecated. Paging is always enabled. The \"MessageBufferSize\" parameter controls how much memory is used before paging kicks in.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getMessageBufferSize")};
            propertyDescriptor.setValue("see", stringArray);
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by defaulting the paging to always be enabled. ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("PagingFileLockingEnabled")) {
            string2 = "isPagingFileLockingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setPagingFileLockingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("PagingFileLockingEnabled", JMSServerMBean.class, string2, string);
            map.put("PagingFileLockingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Determines whether OS file locking is used. </p> When file locking protection is enabled, a store boot fails if another store instance already has opened the store files. Do not disable this setting unless you have procedures in place to prevent multiple store instances from opening the same file. File locking is not required but helps prevent corruption in the event that two same-named file store instances attempt to operate in the same directories. This setting applies to both primary and cache files. ");
            JMSServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = JMSServerMBean.class.getMethod("createJMSSessionPool", String.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"the name of the sessionPool to add to the JMS server ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced by message-driven beans. The JMSSessionPoolMBean type was deprecated. See JMSSessionPoolMBean for more information. ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Add a session pool to the JMS server.</p> ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "JMSSessionPools");
        }
        method = JMSServerMBean.class.getMethod("destroyJMSSessionPool", JMSSessionPoolMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"sessionPool", (String)"the sessionPool to remove from the JMS server ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced by message-driven beans. The JMSSessionPoolMBean type was deprecated. See JMSSessionPoolMBean for more information. ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Remove a session pool from the JMS server.</p> ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "JMSSessionPools");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("createJMSQueue", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Factory method to create JMSQueue object</p> ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "JMSQueues");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("createJMSQueue", String.class, JMSQueueMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", null), JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"toClone", (String)"is the JMSQueueMBean that is being moved from the DomainMBean ")};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Factory method to create JMSQueue object</p> ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "JMSQueues");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("destroyJMSQueue", JMSQueueMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"queue", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Removes a JMSQueue from this domain</p> ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "JMSQueues");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("createJMSTopic", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Factory method to create JMSTopic object</p> ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "JMSTopics");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("destroyJMSTopic", JMSTopicMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"topic", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Removes a JMSTopic from this domain</p> ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "JMSTopics");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String[] stringArray;
        MethodDescriptor methodDescriptor;
        Method method = JMSServerMBean.class.getMethod("addTarget", TargetMBean.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"target", (String)"The target where the JMSServer needs to be deployed ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Targets the JMSServer to the specified target instance. The target must be either a server or a migratable target.</p> ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "Targets");
        }
        method = JMSServerMBean.class.getMethod("removeTarget", TargetMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"target", (String)"The target that has to be removed from the JMSServer ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Untargets the JMSServer instance from the current target.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#addTarget")};
            methodDescriptor.setValue("see", stringArray);
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "Targets");
        }
        method = JMSServerMBean.class.getMethod("addSessionPool", JMSSessionPoolMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"sessionPool", (String)"the sessionPool to add to the JMS server ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced by message-driven beans. The JMSSessionPoolMBean type was deprecated. See JMSSessionPoolMBean for more information. ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Add a session pool to the JMS server. This method is provided for backward compatibility.</p> ");
            methodDescriptor.setValue("transient", Boolean.TRUE);
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "SessionPools");
        }
        method = JMSServerMBean.class.getMethod("removeSessionPool", JMSSessionPoolMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"sessionPool", (String)"the sessionPool to remove from the JMS server ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced by message-driven beans. The JMSSessionPoolMBean type was deprecated. See JMSSessionPoolMBean for more information. ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Remove a session pool from the JMS server. This method is provided for backward compatibility.</p> ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "SessionPools");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("addDestination", JMSDestinationMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"destination", (String)"the destination to be added to the JMS server ")};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"IllegalArgumentException if destination is null or exists")};
                methodDescriptor.setValue("throws", stringArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the functionality of JMS modules. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Add a JMS destination to the JMS server.</p> ");
                methodDescriptor.setValue("role", "collection");
                methodDescriptor.setValue("property", "Destinations");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("removeDestination", JMSDestinationMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"destination", (String)"the destination to be removed from the JMS server ")};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"IllegalArgumentException if destination is null or does not exist")};
                methodDescriptor.setValue("throws", stringArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the functionality of JMS modules. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Removes a destination from the JNDI tree.</p> ");
                methodDescriptor.setValue("role", "collection");
                methodDescriptor.setValue("property", "Destinations");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String string;
        MethodDescriptor methodDescriptor;
        Method method = JMSServerMBean.class.getMethod("lookupJMSSessionPool", String.class);
        ParameterDescriptor[] parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(parameterDescriptorArray)) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced by message-driven beans. The JMSSessionPoolMBean type was deprecated. See JMSSessionPoolMBean for more information. ");
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Get a session pool by name from the JMS server.</p> ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "JMSSessionPools");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("lookupJMSQueue", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", " ");
                methodDescriptor.setValue("role", "finder");
                methodDescriptor.setValue("property", "JMSQueues");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("lookupJMSTopic", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", " ");
                methodDescriptor.setValue("role", "finder");
                methodDescriptor.setValue("property", "JMSTopics");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = JMSServerMBean.class.getMethod("createJMSSessionPool", String.class, JMSSessionPoolMBean.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", null), JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"toClone", (String)"the JMSSessionPool that is being cloned. ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Factory method to create JMSTopic object</p> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
        method = JMSServerMBean.class.getMethod("freezeCurrentValue", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has not been set explicitly, and if the attribute has a default value, this operation forces the MBean to persist the default value.</p>  <p>Unless you use this operation, the default value is not saved and is subject to change if you update to a newer release of WebLogic Server. Invoking this operation isolates this MBean from the effects of such changes.</p>  <dl> <dt>Note:</dt>  <dd> <p>To insure that you are freezing the default value, invoke the <code>restoreDefaultValue</code> operation before you invoke this.</p> </dd> </dl>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute for which some other value has been set.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = JMSServerMBean.class.getMethod("restoreDefaultValue", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string) && !this.readOnly) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has a default value, this operation removes any value that has been set explicitly and causes the attribute to use the default value.</p>  <p>Default values are subject to change if you update to a newer release of WebLogic Server. To prevent the value from changing if you update to a newer release, invoke the <code>freezeCurrentValue</code> operation.</p>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute that is already using the default.</p> ");
            methodDescriptor.setValue("role", "operation");
            methodDescriptor.setValue("impact", "action");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("setDestinations", JMSDestinationMBean[].class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"destinations", (String)"The new destinations value ")};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the functionality of JMS modules. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Sets the value of the Destinations attribute.</p> ");
                String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getDestinations")};
                methodDescriptor.setValue("see", stringArray);
                methodDescriptor.setValue("role", "operation");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion)) {
            method = JMSServerMBean.class.getMethod("createJMSTopic", String.class, JMSTopicMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{JMSServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("obsolete", "9.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 Replaced with the JMS module functionality. ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Factory method to create JMSTopic object</p> ");
                methodDescriptor.setValue("role", "operation");
                methodDescriptor.setValue("obsolete", "9.0.0.0");
            }
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

