/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.jms.module.validators.JMSModuleValidator;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.JMSConnectionConsumerMBean;
import weblogic.management.configuration.JMSConnectionConsumerMBeanImpl;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.mbeans.custom.JMSSessionPool;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class JMSSessionPoolMBeanImpl
extends ConfigurationMBeanImpl
implements JMSSessionPoolMBean,
Serializable {
    private String _AcknowledgeMode;
    private JMSConnectionConsumerMBean[] _ConnectionConsumers;
    private String _ConnectionFactory;
    private JMSConnectionConsumerMBean[] _JMSConnectionConsumers;
    private String _ListenerClass;
    private String _Name;
    private int _SessionsMaximum;
    private boolean _Transacted;
    private JMSSessionPool _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JMSSessionPoolMBeanImpl() {
        try {
            this._customizer = new JMSSessionPool(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSSessionPoolMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JMSSessionPool(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSConnectionConsumerMBean[] getConnectionConsumers() {
        return this._customizer.getConnectionConsumers();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isConnectionConsumersSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setConnectionConsumers(JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray) throws InvalidAttributeValueException {
        jMSConnectionConsumerMBeanArray = jMSConnectionConsumerMBeanArray == null ? new JMSConnectionConsumerMBeanImpl[]{} : jMSConnectionConsumerMBeanArray;
        this._ConnectionConsumers = jMSConnectionConsumerMBeanArray;
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public boolean addConnectionConsumer(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)jMSConnectionConsumerMBean);
        if (!((AbstractDescriptorBean)jMSConnectionConsumerMBean).isChildProperty((DescriptorBean)this, 7)) {
            JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray = (JMSConnectionConsumerMBean[])this._getHelper()._extendArray((Object)this.getConnectionConsumers(), JMSConnectionConsumerMBean.class, (Object)jMSConnectionConsumerMBean);
            try {
                this.setConnectionConsumers(jMSConnectionConsumerMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeConnectionConsumer(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) throws InvalidAttributeValueException, DistributedManagementException {
        JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray = this.getConnectionConsumers();
        JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray2 = (JMSConnectionConsumerMBean[])this._getHelper()._removeElement((Object)jMSConnectionConsumerMBeanArray, JMSConnectionConsumerMBean.class, (Object)jMSConnectionConsumerMBean);
        if (jMSConnectionConsumerMBeanArray2.length != jMSConnectionConsumerMBeanArray.length) {
            try {
                this.setConnectionConsumers(jMSConnectionConsumerMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void addJMSConnectionConsumer(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) {
        this._getHelper()._ensureNonNull((Object)jMSConnectionConsumerMBean);
        if (!((AbstractDescriptorBean)jMSConnectionConsumerMBean).isChildProperty((DescriptorBean)this, 8)) {
            JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray = this._isSet(8) ? (JMSConnectionConsumerMBean[])this._getHelper()._extendArray((Object)this.getJMSConnectionConsumers(), JMSConnectionConsumerMBean.class, (Object)jMSConnectionConsumerMBean) : new JMSConnectionConsumerMBean[]{jMSConnectionConsumerMBean};
            try {
                this.setJMSConnectionConsumers(jMSConnectionConsumerMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JMSConnectionConsumerMBean[] getJMSConnectionConsumers() {
        return this._JMSConnectionConsumers;
    }

    public boolean isJMSConnectionConsumersSet() {
        return this._isSet(8);
    }

    public void removeJMSConnectionConsumer(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) {
        this.destroyJMSConnectionConsumer(jMSConnectionConsumerMBean);
    }

    public void setJMSConnectionConsumers(JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray) throws InvalidAttributeValueException {
        jMSConnectionConsumerMBeanArray = jMSConnectionConsumerMBeanArray == null ? new JMSConnectionConsumerMBeanImpl[]{} : jMSConnectionConsumerMBeanArray;
        for (int i = 0; i < jMSConnectionConsumerMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSConnectionConsumerMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 8)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray2 = this._JMSConnectionConsumers;
        this._JMSConnectionConsumers = jMSConnectionConsumerMBeanArray;
        this._postSet(8, jMSConnectionConsumerMBeanArray2, jMSConnectionConsumerMBeanArray);
    }

    public JMSConnectionConsumerMBean createJMSConnectionConsumer(String string) throws InvalidAttributeValueException, DistributedManagementException {
        JMSConnectionConsumerMBeanImpl jMSConnectionConsumerMBeanImpl = new JMSConnectionConsumerMBeanImpl(this, -1);
        try {
            jMSConnectionConsumerMBeanImpl.setName(string);
            this.addJMSConnectionConsumer(jMSConnectionConsumerMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            if (exception instanceof DistributedManagementException) {
                throw (DistributedManagementException)((Object)exception);
            }
            throw new UndeclaredThrowableException(exception);
        }
        return jMSConnectionConsumerMBeanImpl;
    }

    public void destroyJMSConnectionConsumer(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(jMSConnectionConsumerMBean, 8);
                JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray = this.getJMSConnectionConsumers();
                JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray2 = (JMSConnectionConsumerMBean[])this._getHelper()._removeElement((Object)jMSConnectionConsumerMBeanArray, JMSConnectionConsumerMBean.class, (Object)jMSConnectionConsumerMBean);
                if (jMSConnectionConsumerMBeanArray.length == jMSConnectionConsumerMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)jMSConnectionConsumerMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSConnectionConsumerMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setJMSConnectionConsumers(jMSConnectionConsumerMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JMSConnectionConsumerMBean lookupJMSConnectionConsumer(String string) {
        for (JMSConnectionConsumerMBeanImpl jMSConnectionConsumerMBeanImpl : Arrays.asList((Object[])this._JMSConnectionConsumers)) {
            String string2 = string;
            if (!jMSConnectionConsumerMBeanImpl.getName().equals(string2)) continue;
            return jMSConnectionConsumerMBeanImpl;
        }
        return null;
    }

    public String getConnectionFactory() {
        return this._ConnectionFactory;
    }

    public boolean isConnectionFactorySet() {
        return this._isSet(9);
    }

    public void setConnectionFactory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ConnectionFactory;
        this._ConnectionFactory = string;
        this._postSet(9, string2, string);
    }

    public JMSConnectionConsumerMBean createJMSConnectionConsumer(String string, JMSConnectionConsumerMBean jMSConnectionConsumerMBean) {
        return this._customizer.createJMSConnectionConsumer(string, jMSConnectionConsumerMBean);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void destroyJMSConnectionConsumer(String string, JMSConnectionConsumerMBean jMSConnectionConsumerMBean) {
        this._customizer.destroyJMSConnectionConsumer(string, jMSConnectionConsumerMBean);
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public String getListenerClass() {
        return this._ListenerClass;
    }

    public boolean isListenerClassSet() {
        return this._isSet(10);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setListenerClass(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ListenerClass;
        this._ListenerClass = string;
        this._postSet(10, string2, string);
    }

    public String getAcknowledgeMode() {
        return this._AcknowledgeMode;
    }

    public boolean isAcknowledgeModeSet() {
        return this._isSet(11);
    }

    public void setAcknowledgeMode(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Auto", "Client", "Dups-Ok", "None"};
        string = LegalChecks.checkInEnum((String)"AcknowledgeMode", (String)string, (String[])stringArray);
        String string2 = this._AcknowledgeMode;
        this._AcknowledgeMode = string;
        this._postSet(11, string2, string);
    }

    public int getSessionsMaximum() {
        return this._SessionsMaximum;
    }

    public boolean isSessionsMaximumSet() {
        return this._isSet(12);
    }

    public void setSessionsMaximum(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"SessionsMaximum", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        JMSModuleValidator.validateSessionPoolSessionsMaximum(n);
        int n2 = this._SessionsMaximum;
        this._SessionsMaximum = n;
        this._postSet(12, n2, n);
    }

    public boolean isTransacted() {
        return this._Transacted;
    }

    public boolean isTransactedSet() {
        return this._isSet(13);
    }

    public void setTransacted(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._Transacted;
        this._Transacted = bl;
        this._postSet(13, bl2, bl);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._AcknowledgeMode = "Auto";
                    if (bl) break;
                }
                case 7: {
                    this._ConnectionConsumers = new JMSConnectionConsumerMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._ConnectionFactory = null;
                    if (bl) break;
                }
                case 8: {
                    this._JMSConnectionConsumers = new JMSConnectionConsumerMBean[0];
                    if (bl) break;
                }
                case 10: {
                    this._ListenerClass = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 12: {
                    this._SessionsMaximum = -1;
                    if (bl) break;
                }
                case 13: {
                    this._Transacted = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMSSessionPool";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AcknowledgeMode")) {
            String string2 = this._AcknowledgeMode;
            this._AcknowledgeMode = (String)object;
            this._postSet(11, string2, this._AcknowledgeMode);
            return;
        }
        if (string.equals("ConnectionConsumers")) {
            JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray = this._ConnectionConsumers;
            this._ConnectionConsumers = (JMSConnectionConsumerMBean[])object;
            this._postSet(7, jMSConnectionConsumerMBeanArray, this._ConnectionConsumers);
            return;
        }
        if (string.equals("ConnectionFactory")) {
            String string3 = this._ConnectionFactory;
            this._ConnectionFactory = (String)object;
            this._postSet(9, string3, this._ConnectionFactory);
            return;
        }
        if (string.equals("JMSConnectionConsumers")) {
            JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray = this._JMSConnectionConsumers;
            this._JMSConnectionConsumers = (JMSConnectionConsumerMBean[])object;
            this._postSet(8, jMSConnectionConsumerMBeanArray, this._JMSConnectionConsumers);
            return;
        }
        if (string.equals("ListenerClass")) {
            String string4 = this._ListenerClass;
            this._ListenerClass = (String)object;
            this._postSet(10, string4, this._ListenerClass);
            return;
        }
        if (string.equals("Name")) {
            String string5 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string5, this._Name);
            return;
        }
        if (string.equals("SessionsMaximum")) {
            int n = this._SessionsMaximum;
            this._SessionsMaximum = (Integer)object;
            this._postSet(12, n, this._SessionsMaximum);
            return;
        }
        if (string.equals("Transacted")) {
            boolean bl = this._Transacted;
            this._Transacted = (Boolean)object;
            this._postSet(13, bl, this._Transacted);
            return;
        }
        if (string.equals("customizer")) {
            JMSSessionPool jMSSessionPool = this._customizer;
            this._customizer = (JMSSessionPool)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AcknowledgeMode")) {
            return this._AcknowledgeMode;
        }
        if (string.equals("ConnectionConsumers")) {
            return this._ConnectionConsumers;
        }
        if (string.equals("ConnectionFactory")) {
            return this._ConnectionFactory;
        }
        if (string.equals("JMSConnectionConsumers")) {
            return this._JMSConnectionConsumers;
        }
        if (string.equals("ListenerClass")) {
            return this._ListenerClass;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("SessionsMaximum")) {
            return new Integer(this._SessionsMaximum);
        }
        if (string.equals("Transacted")) {
            return new Boolean(this._Transacted);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 16: {
                    if (string.equals("acknowledge-mode")) {
                        return 11;
                    }
                    if (!string.equals("sessions-maximum")) break;
                    return 12;
                }
                case 19: {
                    if (!string.equals("connection-consumer")) break;
                    return 7;
                }
                case 18: {
                    if (!string.equals("connection-factory")) break;
                    return 9;
                }
                case 23: {
                    if (!string.equals("jms-connection-consumer")) break;
                    return 8;
                }
                case 14: {
                    if (!string.equals("listener-class")) break;
                    return 10;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 10: {
                    if (!string.equals("transacted")) break;
                    return 13;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 8: {
                    return new JMSConnectionConsumerMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "acknowledge-mode";
                }
                case 7: {
                    return "connection-consumer";
                }
                case 9: {
                    return "connection-factory";
                }
                case 8: {
                    return "jms-connection-consumer";
                }
                case 10: {
                    return "listener-class";
                }
                case 2: {
                    return "name";
                }
                case 12: {
                    return "sessions-maximum";
                }
                case 13: {
                    return "transacted";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
                case 8: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 8: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private JMSSessionPoolMBeanImpl bean;

        protected Helper(JMSSessionPoolMBeanImpl jMSSessionPoolMBeanImpl) {
            super(jMSSessionPoolMBeanImpl);
            this.bean = jMSSessionPoolMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "AcknowledgeMode";
                }
                case 7: {
                    return "ConnectionConsumers";
                }
                case 9: {
                    return "ConnectionFactory";
                }
                case 8: {
                    return "JMSConnectionConsumers";
                }
                case 10: {
                    return "ListenerClass";
                }
                case 2: {
                    return "Name";
                }
                case 12: {
                    return "SessionsMaximum";
                }
                case 13: {
                    return "Transacted";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AcknowledgeMode")) {
                return 11;
            }
            if (string.equals("ConnectionConsumers")) {
                return 7;
            }
            if (string.equals("ConnectionFactory")) {
                return 9;
            }
            if (string.equals("JMSConnectionConsumers")) {
                return 8;
            }
            if (string.equals("ListenerClass")) {
                return 10;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("SessionsMaximum")) {
                return 12;
            }
            if (string.equals("Transacted")) {
                return 13;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getJMSConnectionConsumers()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAcknowledgeModeSet()) {
                    stringBuffer.append("AcknowledgeMode");
                    stringBuffer.append(String.valueOf(this.bean.getAcknowledgeMode()));
                }
                if (this.bean.isConnectionConsumersSet()) {
                    stringBuffer.append("ConnectionConsumers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getConnectionConsumers())));
                }
                if (this.bean.isConnectionFactorySet()) {
                    stringBuffer.append("ConnectionFactory");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionFactory()));
                }
                l2 = 0L;
                for (int i = 0; i < this.bean.getJMSConnectionConsumers().length; ++i) {
                    l2 ^= this.computeChildHashValue(this.bean.getJMSConnectionConsumers()[i]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isListenerClassSet()) {
                    stringBuffer.append("ListenerClass");
                    stringBuffer.append(String.valueOf(this.bean.getListenerClass()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isSessionsMaximumSet()) {
                    stringBuffer.append("SessionsMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getSessionsMaximum()));
                }
                if (this.bean.isTransactedSet()) {
                    stringBuffer.append("Transacted");
                    stringBuffer.append(String.valueOf(this.bean.isTransacted()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMSSessionPoolMBeanImpl jMSSessionPoolMBeanImpl = (JMSSessionPoolMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AcknowledgeMode", this.bean.getAcknowledgeMode(), jMSSessionPoolMBeanImpl.getAcknowledgeMode(), false);
                this.computeDiff("ConnectionFactory", this.bean.getConnectionFactory(), jMSSessionPoolMBeanImpl.getConnectionFactory(), false);
                this.computeChildDiff("JMSConnectionConsumers", this.bean.getJMSConnectionConsumers(), jMSSessionPoolMBeanImpl.getJMSConnectionConsumers(), false);
                this.computeDiff("ListenerClass", this.bean.getListenerClass(), jMSSessionPoolMBeanImpl.getListenerClass(), false);
                this.computeDiff("Name", this.bean.getName(), jMSSessionPoolMBeanImpl.getName(), false);
                this.computeDiff("SessionsMaximum", this.bean.getSessionsMaximum(), jMSSessionPoolMBeanImpl.getSessionsMaximum(), true);
                this.computeDiff("Transacted", this.bean.isTransacted(), jMSSessionPoolMBeanImpl.isTransacted(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMSSessionPoolMBeanImpl jMSSessionPoolMBeanImpl = (JMSSessionPoolMBeanImpl)beanUpdateEvent.getSourceBean();
                JMSSessionPoolMBeanImpl jMSSessionPoolMBeanImpl2 = (JMSSessionPoolMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AcknowledgeMode")) {
                    jMSSessionPoolMBeanImpl.setAcknowledgeMode(jMSSessionPoolMBeanImpl2.getAcknowledgeMode());
                    jMSSessionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (!string.equals("ConnectionConsumers")) {
                    if (string.equals("ConnectionFactory")) {
                        jMSSessionPoolMBeanImpl.setConnectionFactory(jMSSessionPoolMBeanImpl2.getConnectionFactory());
                        jMSSessionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("JMSConnectionConsumers")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                            jMSSessionPoolMBeanImpl.addJMSConnectionConsumer((JMSConnectionConsumerMBean)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            jMSSessionPoolMBeanImpl.removeJMSConnectionConsumer((JMSConnectionConsumerMBean)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (jMSSessionPoolMBeanImpl.getJMSConnectionConsumers() == null || jMSSessionPoolMBeanImpl.getJMSConnectionConsumers().length == 0) {
                            jMSSessionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                        }
                    } else if (string.equals("ListenerClass")) {
                        jMSSessionPoolMBeanImpl.setListenerClass(jMSSessionPoolMBeanImpl2.getListenerClass());
                        jMSSessionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("Name")) {
                        jMSSessionPoolMBeanImpl.setName(jMSSessionPoolMBeanImpl2.getName());
                        jMSSessionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("SessionsMaximum")) {
                        jMSSessionPoolMBeanImpl.setSessionsMaximum(jMSSessionPoolMBeanImpl2.getSessionsMaximum());
                        jMSSessionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("Transacted")) {
                        jMSSessionPoolMBeanImpl.setTransacted(jMSSessionPoolMBeanImpl2.isTransacted());
                        jMSSessionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JMSSessionPoolMBeanImpl jMSSessionPoolMBeanImpl = (JMSSessionPoolMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMSSessionPoolMBeanImpl, bl, list);
                if ((list == null || !list.contains("AcknowledgeMode")) && this.bean.isAcknowledgeModeSet()) {
                    jMSSessionPoolMBeanImpl.setAcknowledgeMode(this.bean.getAcknowledgeMode());
                }
                if ((list == null || !list.contains("ConnectionFactory")) && this.bean.isConnectionFactorySet()) {
                    jMSSessionPoolMBeanImpl.setConnectionFactory(this.bean.getConnectionFactory());
                }
                if (!(list != null && list.contains("JMSConnectionConsumers") || !this.bean.isJMSConnectionConsumersSet() || jMSSessionPoolMBeanImpl._isSet(8))) {
                    JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray = this.bean.getJMSConnectionConsumers();
                    JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray2 = new JMSConnectionConsumerMBean[jMSConnectionConsumerMBeanArray.length];
                    for (int i = 0; i < jMSConnectionConsumerMBeanArray2.length; ++i) {
                        jMSConnectionConsumerMBeanArray2[i] = (JMSConnectionConsumerMBean)this.createCopy((AbstractDescriptorBean)jMSConnectionConsumerMBeanArray[i], bl);
                    }
                    jMSSessionPoolMBeanImpl.setJMSConnectionConsumers(jMSConnectionConsumerMBeanArray2);
                }
                if ((list == null || !list.contains("ListenerClass")) && this.bean.isListenerClassSet()) {
                    jMSSessionPoolMBeanImpl.setListenerClass(this.bean.getListenerClass());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jMSSessionPoolMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("SessionsMaximum")) && this.bean.isSessionsMaximumSet()) {
                    jMSSessionPoolMBeanImpl.setSessionsMaximum(this.bean.getSessionsMaximum());
                }
                if ((list == null || !list.contains("Transacted")) && this.bean.isTransactedSet()) {
                    jMSSessionPoolMBeanImpl.setTransacted(this.bean.isTransacted());
                }
                return jMSSessionPoolMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getConnectionConsumers(), clazz, object);
            this.inferSubTree(this.bean.getJMSConnectionConsumers(), clazz, object);
        }
    }
}

