/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.jms.module.validators.JMSModuleValidator;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSDestCommonMBeanImpl;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSDestinationMBeanImpl;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.mbeans.custom.JMSTemplate;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JMSTemplateMBeanImpl
extends JMSDestCommonMBeanImpl
implements JMSTemplateMBean,
Serializable {
    private long _BytesMaximum;
    private boolean _BytesPagingEnabled;
    private long _BytesThresholdHigh;
    private long _BytesThresholdLow;
    private String _DeliveryModeOverride;
    private JMSDestinationMBean[] _Destinations;
    private JMSDestinationMBean _ErrorDestination;
    private String _ExpirationLoggingPolicy;
    private String _ExpirationPolicy;
    private int _MaximumMessageSize;
    private long _MessagesMaximum;
    private boolean _MessagesPagingEnabled;
    private long _MessagesThresholdHigh;
    private long _MessagesThresholdLow;
    private String _Name;
    private String _Notes;
    private int _PriorityOverride;
    private long _RedeliveryDelayOverride;
    private int _RedeliveryLimit;
    private String _TimeToDeliverOverride;
    private long _TimeToLiveOverride;
    private JMSTemplate _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JMSTemplateMBeanImpl() {
        try {
            this._customizer = new JMSTemplate(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSTemplateMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JMSTemplate(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSDestinationMBean[] getDestinations() {
        return this._Destinations;
    }

    public String getDestinationsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getDestinations());
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isDestinationsSet() {
        return this._isSet(25);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setDestinationsAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSDestinationMBean[] jMSDestinationMBeanArray = this._Destinations;
            this._initializeProperty(25);
            this._postSet(25, jMSDestinationMBeanArray, this._Destinations);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Destinations);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, JMSDestinationMBean.class, new ReferenceManager.Resolver(this, 25){

                    public void resolveReference(Object object) {
                        try {
                            JMSTemplateMBeanImpl.this.addDestination((JMSDestinationMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (JMSDestinationMBean jMSDestinationMBean : this._Destinations) {
                    if (!string2.equals(jMSDestinationMBean.getName())) continue;
                    try {
                        this.removeDestination(jMSDestinationMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setDestinations(JMSDestinationMBean[] jMSDestinationMBeanArray) throws InvalidAttributeValueException {
        jMSDestinationMBeanArray = jMSDestinationMBeanArray == null ? new JMSDestinationMBeanImpl[]{} : jMSDestinationMBeanArray;
        JMSDestinationMBean[] jMSDestinationMBeanArray2 = this._Destinations;
        this._Destinations = jMSDestinationMBeanArray;
        this._postSet(25, jMSDestinationMBeanArray2, jMSDestinationMBeanArray);
    }

    public boolean addDestination(JMSDestinationMBean jMSDestinationMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)jMSDestinationMBean);
        if (!((AbstractDescriptorBean)jMSDestinationMBean).isChildProperty((DescriptorBean)this, 25)) {
            JMSDestinationMBean[] jMSDestinationMBeanArray = this._isSet(25) ? (JMSDestinationMBean[])this._getHelper()._extendArray((Object)this.getDestinations(), JMSDestinationMBean.class, (Object)jMSDestinationMBean) : new JMSDestinationMBean[]{jMSDestinationMBean};
            try {
                this.setDestinations(jMSDestinationMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public String getNotes() {
        return this._customizer.getNotes();
    }

    public boolean isNotesSet() {
        return this._isSet(3);
    }

    public boolean removeDestination(JMSDestinationMBean jMSDestinationMBean) throws InvalidAttributeValueException, DistributedManagementException {
        JMSDestinationMBean[] jMSDestinationMBeanArray = this.getDestinations();
        JMSDestinationMBean[] jMSDestinationMBeanArray2 = (JMSDestinationMBean[])this._getHelper()._removeElement((Object)jMSDestinationMBeanArray, JMSDestinationMBean.class, (Object)jMSDestinationMBean);
        if (jMSDestinationMBeanArray2.length != jMSDestinationMBeanArray.length) {
            try {
                this.setDestinations(jMSDestinationMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public boolean isMessagesPagingEnabled() {
        return this._MessagesPagingEnabled;
    }

    public boolean isMessagesPagingEnabledSet() {
        return this._isSet(26);
    }

    public void setNotes(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String string2 = this.getNotes();
        this._customizer.setNotes(string);
        this._postSet(3, string2, string);
    }

    public long getBytesMaximum() {
        return this._customizer.getBytesMaximum();
    }

    public boolean isBytesMaximumSet() {
        return this._isSet(8);
    }

    public void setMessagesPagingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._MessagesPagingEnabled;
        this._MessagesPagingEnabled = bl;
        this._postSet(26, bl2, bl);
    }

    public boolean isBytesPagingEnabled() {
        return this._BytesPagingEnabled;
    }

    public boolean isBytesPagingEnabledSet() {
        return this._isSet(27);
    }

    public void setBytesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesMaximum", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getBytesMaximum();
        this._customizer.setBytesMaximum(l);
        this._postSet(8, l2, l);
    }

    public long getBytesThresholdHigh() {
        return this._customizer.getBytesThresholdHigh();
    }

    public boolean isBytesThresholdHighSet() {
        return this._isSet(9);
    }

    public void setBytesPagingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._BytesPagingEnabled;
        this._BytesPagingEnabled = bl;
        this._postSet(27, bl2, bl);
    }

    public void setBytesThresholdHigh(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesThresholdHigh", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getBytesThresholdHigh();
        this._customizer.setBytesThresholdHigh(l);
        this._postSet(9, l2, l);
    }

    public void useDelegates(DomainMBean domainMBean, JMSBean jMSBean, TemplateBean templateBean) {
        this._customizer.useDelegates(domainMBean, jMSBean, templateBean);
    }

    public long getBytesThresholdLow() {
        return this._customizer.getBytesThresholdLow();
    }

    public boolean isBytesThresholdLowSet() {
        return this._isSet(10);
    }

    public void setBytesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesThresholdLow", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getBytesThresholdLow();
        this._customizer.setBytesThresholdLow(l);
        this._postSet(10, l2, l);
    }

    public long getMessagesMaximum() {
        return this._customizer.getMessagesMaximum();
    }

    public boolean isMessagesMaximumSet() {
        return this._isSet(11);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setMessagesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesMaximum", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getMessagesMaximum();
        this._customizer.setMessagesMaximum(l);
        this._postSet(11, l2, l);
    }

    public long getMessagesThresholdHigh() {
        return this._customizer.getMessagesThresholdHigh();
    }

    public boolean isMessagesThresholdHighSet() {
        return this._isSet(12);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setMessagesThresholdHigh(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesThresholdHigh", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getMessagesThresholdHigh();
        this._customizer.setMessagesThresholdHigh(l);
        this._postSet(12, l2, l);
    }

    public long getMessagesThresholdLow() {
        return this._customizer.getMessagesThresholdLow();
    }

    public boolean isMessagesThresholdLowSet() {
        return this._isSet(13);
    }

    public void setMessagesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesThresholdLow", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getMessagesThresholdLow();
        this._customizer.setMessagesThresholdLow(l);
        this._postSet(13, l2, l);
    }

    public int getPriorityOverride() {
        return this._customizer.getPriorityOverride();
    }

    public boolean isPriorityOverrideSet() {
        return this._isSet(14);
    }

    public void setPriorityOverride(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"PriorityOverride", (long)n, (long)-1L, (long)9L);
        int n2 = this.getPriorityOverride();
        this._customizer.setPriorityOverride(n);
        this._postSet(14, n2, n);
    }

    public String getTimeToDeliverOverride() {
        return this._customizer.getTimeToDeliverOverride();
    }

    public boolean isTimeToDeliverOverrideSet() {
        return this._isSet(15);
    }

    public void setTimeToDeliverOverride(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        JMSModuleValidator.validateTimeToDeliverOverride(string);
        String string2 = this.getTimeToDeliverOverride();
        this._customizer.setTimeToDeliverOverride(string);
        this._postSet(15, string2, string);
    }

    public long getRedeliveryDelayOverride() {
        return this._customizer.getRedeliveryDelayOverride();
    }

    public boolean isRedeliveryDelayOverrideSet() {
        return this._isSet(16);
    }

    public void setRedeliveryDelayOverride(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"RedeliveryDelayOverride", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getRedeliveryDelayOverride();
        this._customizer.setRedeliveryDelayOverride(l);
        this._postSet(16, l2, l);
    }

    public void setErrorDestination(JMSDestinationMBean jMSDestinationMBean) throws InvalidAttributeValueException, DistributedManagementException {
        JMSDestinationMBean jMSDestinationMBean2 = this.getErrorDestination();
        this._customizer.setErrorDestination(jMSDestinationMBean);
        this._postSet(17, jMSDestinationMBean2, jMSDestinationMBean);
    }

    public JMSDestinationMBean getErrorDestination() {
        return this._customizer.getErrorDestination();
    }

    public String getErrorDestinationAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getErrorDestination();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isErrorDestinationSet() {
        return this._isSet(17);
    }

    public void setErrorDestinationAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSDestinationMBean jMSDestinationMBean = this._ErrorDestination;
            this._initializeProperty(17);
            this._postSet(17, jMSDestinationMBean, this._ErrorDestination);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JMSDestinationMBean.class, new ReferenceManager.Resolver(this, 17){

                public void resolveReference(Object object) {
                    try {
                        JMSTemplateMBeanImpl.this.setErrorDestination((JMSDestinationMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public int getRedeliveryLimit() {
        return this._customizer.getRedeliveryLimit();
    }

    public boolean isRedeliveryLimitSet() {
        return this._isSet(18);
    }

    public void setRedeliveryLimit(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"RedeliveryLimit", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this.getRedeliveryLimit();
        this._customizer.setRedeliveryLimit(n);
        this._postSet(18, n2, n);
    }

    public long getTimeToLiveOverride() {
        return this._customizer.getTimeToLiveOverride();
    }

    public boolean isTimeToLiveOverrideSet() {
        return this._isSet(19);
    }

    public void setTimeToLiveOverride(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"TimeToLiveOverride", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this.getTimeToLiveOverride();
        this._customizer.setTimeToLiveOverride(l);
        this._postSet(19, l2, l);
    }

    public String getDeliveryModeOverride() {
        return this._customizer.getDeliveryModeOverride();
    }

    public boolean isDeliveryModeOverrideSet() {
        return this._isSet(20);
    }

    public void setDeliveryModeOverride(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Persistent", "Non-Persistent", "No-Delivery"};
        string = LegalChecks.checkInEnum((String)"DeliveryModeOverride", (String)string, (String[])stringArray);
        String string2 = this.getDeliveryModeOverride();
        this._customizer.setDeliveryModeOverride(string);
        this._postSet(20, string2, string);
    }

    public void setExpirationPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Discard", "Log", "Redirect"};
        string = LegalChecks.checkInEnum((String)"ExpirationPolicy", (String)string, (String[])stringArray);
        String string2 = this.getExpirationPolicy();
        this._customizer.setExpirationPolicy(string);
        this._postSet(21, string2, string);
    }

    public String getExpirationPolicy() {
        return this._customizer.getExpirationPolicy();
    }

    public boolean isExpirationPolicySet() {
        return this._isSet(21);
    }

    public void setExpirationLoggingPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getExpirationLoggingPolicy();
        this._customizer.setExpirationLoggingPolicy(string);
        this._postSet(22, string2, string);
    }

    public String getExpirationLoggingPolicy() {
        return this._customizer.getExpirationLoggingPolicy();
    }

    public boolean isExpirationLoggingPolicySet() {
        return this._isSet(22);
    }

    public int getMaximumMessageSize() {
        return this._customizer.getMaximumMessageSize();
    }

    public boolean isMaximumMessageSizeSet() {
        return this._isSet(23);
    }

    public void setMaximumMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaximumMessageSize", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getMaximumMessageSize();
        this._customizer.setMaximumMessageSize(n);
        this._postSet(23, n2, n);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._customizer.setBytesMaximum(-1L);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setBytesThresholdHigh(-1L);
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setBytesThresholdLow(-1L);
                    if (bl) break;
                }
                case 20: {
                    this._customizer.setDeliveryModeOverride("No-Delivery");
                    if (bl) break;
                }
                case 25: {
                    this._Destinations = new JMSDestinationMBean[0];
                    if (bl) break;
                }
                case 17: {
                    this._customizer.setErrorDestination(null);
                    if (bl) break;
                }
                case 22: {
                    this._customizer.setExpirationLoggingPolicy(null);
                    if (bl) break;
                }
                case 21: {
                    this._customizer.setExpirationPolicy("Discard");
                    if (bl) break;
                }
                case 23: {
                    this._customizer.setMaximumMessageSize(Integer.MAX_VALUE);
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setMessagesMaximum(-1L);
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setMessagesThresholdHigh(-1L);
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setMessagesThresholdLow(-1L);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 3: {
                    this._customizer.setNotes(null);
                    if (bl) break;
                }
                case 14: {
                    this._customizer.setPriorityOverride(-1);
                    if (bl) break;
                }
                case 16: {
                    this._customizer.setRedeliveryDelayOverride(-1L);
                    if (bl) break;
                }
                case 18: {
                    this._customizer.setRedeliveryLimit(-1);
                    if (bl) break;
                }
                case 15: {
                    this._customizer.setTimeToDeliverOverride("-1");
                    if (bl) break;
                }
                case 19: {
                    this._customizer.setTimeToLiveOverride(-1L);
                    if (bl) break;
                }
                case 27: {
                    this._BytesPagingEnabled = false;
                    if (bl) break;
                }
                case 26: {
                    this._MessagesPagingEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMSTemplate";
    }

    public void putValue(String string, Object object) {
        if (string.equals("BytesMaximum")) {
            long l = this._BytesMaximum;
            this._BytesMaximum = (Long)object;
            this._postSet(8, l, this._BytesMaximum);
            return;
        }
        if (string.equals("BytesPagingEnabled")) {
            boolean bl = this._BytesPagingEnabled;
            this._BytesPagingEnabled = (Boolean)object;
            this._postSet(27, bl, this._BytesPagingEnabled);
            return;
        }
        if (string.equals("BytesThresholdHigh")) {
            long l = this._BytesThresholdHigh;
            this._BytesThresholdHigh = (Long)object;
            this._postSet(9, l, this._BytesThresholdHigh);
            return;
        }
        if (string.equals("BytesThresholdLow")) {
            long l = this._BytesThresholdLow;
            this._BytesThresholdLow = (Long)object;
            this._postSet(10, l, this._BytesThresholdLow);
            return;
        }
        if (string.equals("DeliveryModeOverride")) {
            String string2 = this._DeliveryModeOverride;
            this._DeliveryModeOverride = (String)object;
            this._postSet(20, string2, this._DeliveryModeOverride);
            return;
        }
        if (string.equals("Destinations")) {
            JMSDestinationMBean[] jMSDestinationMBeanArray = this._Destinations;
            this._Destinations = (JMSDestinationMBean[])object;
            this._postSet(25, jMSDestinationMBeanArray, this._Destinations);
            return;
        }
        if (string.equals("ErrorDestination")) {
            JMSDestinationMBean jMSDestinationMBean = this._ErrorDestination;
            this._ErrorDestination = (JMSDestinationMBean)object;
            this._postSet(17, jMSDestinationMBean, this._ErrorDestination);
            return;
        }
        if (string.equals("ExpirationLoggingPolicy")) {
            String string3 = this._ExpirationLoggingPolicy;
            this._ExpirationLoggingPolicy = (String)object;
            this._postSet(22, string3, this._ExpirationLoggingPolicy);
            return;
        }
        if (string.equals("ExpirationPolicy")) {
            String string4 = this._ExpirationPolicy;
            this._ExpirationPolicy = (String)object;
            this._postSet(21, string4, this._ExpirationPolicy);
            return;
        }
        if (string.equals("MaximumMessageSize")) {
            int n = this._MaximumMessageSize;
            this._MaximumMessageSize = (Integer)object;
            this._postSet(23, n, this._MaximumMessageSize);
            return;
        }
        if (string.equals("MessagesMaximum")) {
            long l = this._MessagesMaximum;
            this._MessagesMaximum = (Long)object;
            this._postSet(11, l, this._MessagesMaximum);
            return;
        }
        if (string.equals("MessagesPagingEnabled")) {
            boolean bl = this._MessagesPagingEnabled;
            this._MessagesPagingEnabled = (Boolean)object;
            this._postSet(26, bl, this._MessagesPagingEnabled);
            return;
        }
        if (string.equals("MessagesThresholdHigh")) {
            long l = this._MessagesThresholdHigh;
            this._MessagesThresholdHigh = (Long)object;
            this._postSet(12, l, this._MessagesThresholdHigh);
            return;
        }
        if (string.equals("MessagesThresholdLow")) {
            long l = this._MessagesThresholdLow;
            this._MessagesThresholdLow = (Long)object;
            this._postSet(13, l, this._MessagesThresholdLow);
            return;
        }
        if (string.equals("Name")) {
            String string5 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string5, this._Name);
            return;
        }
        if (string.equals("Notes")) {
            String string6 = this._Notes;
            this._Notes = (String)object;
            this._postSet(3, string6, this._Notes);
            return;
        }
        if (string.equals("PriorityOverride")) {
            int n = this._PriorityOverride;
            this._PriorityOverride = (Integer)object;
            this._postSet(14, n, this._PriorityOverride);
            return;
        }
        if (string.equals("RedeliveryDelayOverride")) {
            long l = this._RedeliveryDelayOverride;
            this._RedeliveryDelayOverride = (Long)object;
            this._postSet(16, l, this._RedeliveryDelayOverride);
            return;
        }
        if (string.equals("RedeliveryLimit")) {
            int n = this._RedeliveryLimit;
            this._RedeliveryLimit = (Integer)object;
            this._postSet(18, n, this._RedeliveryLimit);
            return;
        }
        if (string.equals("TimeToDeliverOverride")) {
            String string7 = this._TimeToDeliverOverride;
            this._TimeToDeliverOverride = (String)object;
            this._postSet(15, string7, this._TimeToDeliverOverride);
            return;
        }
        if (string.equals("TimeToLiveOverride")) {
            long l = this._TimeToLiveOverride;
            this._TimeToLiveOverride = (Long)object;
            this._postSet(19, l, this._TimeToLiveOverride);
            return;
        }
        if (string.equals("customizer")) {
            JMSTemplate jMSTemplate = this._customizer;
            this._customizer = (JMSTemplate)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("BytesMaximum")) {
            return new Long(this._BytesMaximum);
        }
        if (string.equals("BytesPagingEnabled")) {
            return new Boolean(this._BytesPagingEnabled);
        }
        if (string.equals("BytesThresholdHigh")) {
            return new Long(this._BytesThresholdHigh);
        }
        if (string.equals("BytesThresholdLow")) {
            return new Long(this._BytesThresholdLow);
        }
        if (string.equals("DeliveryModeOverride")) {
            return this._DeliveryModeOverride;
        }
        if (string.equals("Destinations")) {
            return this._Destinations;
        }
        if (string.equals("ErrorDestination")) {
            return this._ErrorDestination;
        }
        if (string.equals("ExpirationLoggingPolicy")) {
            return this._ExpirationLoggingPolicy;
        }
        if (string.equals("ExpirationPolicy")) {
            return this._ExpirationPolicy;
        }
        if (string.equals("MaximumMessageSize")) {
            return new Integer(this._MaximumMessageSize);
        }
        if (string.equals("MessagesMaximum")) {
            return new Long(this._MessagesMaximum);
        }
        if (string.equals("MessagesPagingEnabled")) {
            return new Boolean(this._MessagesPagingEnabled);
        }
        if (string.equals("MessagesThresholdHigh")) {
            return new Long(this._MessagesThresholdHigh);
        }
        if (string.equals("MessagesThresholdLow")) {
            return new Long(this._MessagesThresholdLow);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Notes")) {
            return this._Notes;
        }
        if (string.equals("PriorityOverride")) {
            return new Integer(this._PriorityOverride);
        }
        if (string.equals("RedeliveryDelayOverride")) {
            return new Long(this._RedeliveryDelayOverride);
        }
        if (string.equals("RedeliveryLimit")) {
            return new Integer(this._RedeliveryLimit);
        }
        if (string.equals("TimeToDeliverOverride")) {
            return this._TimeToDeliverOverride;
        }
        if (string.equals("TimeToLiveOverride")) {
            return new Long(this._TimeToLiveOverride);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends JMSDestCommonMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (!string.equals("bytes-maximum")) break;
                    return 8;
                }
                case 20: {
                    if (string.equals("bytes-threshold-high")) {
                        return 9;
                    }
                    if (string.equals("maximum-message-size")) {
                        return 23;
                    }
                    if (!string.equals("bytes-paging-enabled")) break;
                    return 27;
                }
                case 19: {
                    if (!string.equals("bytes-threshold-low")) break;
                    return 10;
                }
                case 22: {
                    if (string.equals("delivery-mode-override")) {
                        return 20;
                    }
                    if (!string.equals("messages-threshold-low")) break;
                    return 13;
                }
                case 11: {
                    if (!string.equals("destination")) break;
                    return 25;
                }
                case 17: {
                    if (string.equals("error-destination")) {
                        return 17;
                    }
                    if (string.equals("expiration-policy")) {
                        return 21;
                    }
                    if (!string.equals("priority-override")) break;
                    return 14;
                }
                case 25: {
                    if (string.equals("expiration-logging-policy")) {
                        return 22;
                    }
                    if (!string.equals("redelivery-delay-override")) break;
                    return 16;
                }
                case 16: {
                    if (string.equals("messages-maximum")) {
                        return 11;
                    }
                    if (!string.equals("redelivery-limit")) break;
                    return 18;
                }
                case 23: {
                    if (string.equals("messages-threshold-high")) {
                        return 12;
                    }
                    if (!string.equals("messages-paging-enabled")) break;
                    return 26;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 5: {
                    if (!string.equals("notes")) break;
                    return 3;
                }
                case 24: {
                    if (!string.equals("time-to-deliver-override")) break;
                    return 15;
                }
                case 21: {
                    if (!string.equals("time-to-live-override")) break;
                    return 19;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "bytes-maximum";
                }
                case 9: {
                    return "bytes-threshold-high";
                }
                case 10: {
                    return "bytes-threshold-low";
                }
                case 20: {
                    return "delivery-mode-override";
                }
                case 25: {
                    return "destination";
                }
                case 17: {
                    return "error-destination";
                }
                case 22: {
                    return "expiration-logging-policy";
                }
                case 21: {
                    return "expiration-policy";
                }
                case 23: {
                    return "maximum-message-size";
                }
                case 11: {
                    return "messages-maximum";
                }
                case 12: {
                    return "messages-threshold-high";
                }
                case 13: {
                    return "messages-threshold-low";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "notes";
                }
                case 14: {
                    return "priority-override";
                }
                case 16: {
                    return "redelivery-delay-override";
                }
                case 18: {
                    return "redelivery-limit";
                }
                case 15: {
                    return "time-to-deliver-override";
                }
                case 19: {
                    return "time-to-live-override";
                }
                case 27: {
                    return "bytes-paging-enabled";
                }
                case 26: {
                    return "messages-paging-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
                case 25: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends JMSDestCommonMBeanImpl.Helper {
        private JMSTemplateMBeanImpl bean;

        protected Helper(JMSTemplateMBeanImpl jMSTemplateMBeanImpl) {
            super(jMSTemplateMBeanImpl);
            this.bean = jMSTemplateMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "BytesMaximum";
                }
                case 9: {
                    return "BytesThresholdHigh";
                }
                case 10: {
                    return "BytesThresholdLow";
                }
                case 20: {
                    return "DeliveryModeOverride";
                }
                case 25: {
                    return "Destinations";
                }
                case 17: {
                    return "ErrorDestination";
                }
                case 22: {
                    return "ExpirationLoggingPolicy";
                }
                case 21: {
                    return "ExpirationPolicy";
                }
                case 23: {
                    return "MaximumMessageSize";
                }
                case 11: {
                    return "MessagesMaximum";
                }
                case 12: {
                    return "MessagesThresholdHigh";
                }
                case 13: {
                    return "MessagesThresholdLow";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Notes";
                }
                case 14: {
                    return "PriorityOverride";
                }
                case 16: {
                    return "RedeliveryDelayOverride";
                }
                case 18: {
                    return "RedeliveryLimit";
                }
                case 15: {
                    return "TimeToDeliverOverride";
                }
                case 19: {
                    return "TimeToLiveOverride";
                }
                case 27: {
                    return "BytesPagingEnabled";
                }
                case 26: {
                    return "MessagesPagingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BytesMaximum")) {
                return 8;
            }
            if (string.equals("BytesThresholdHigh")) {
                return 9;
            }
            if (string.equals("BytesThresholdLow")) {
                return 10;
            }
            if (string.equals("DeliveryModeOverride")) {
                return 20;
            }
            if (string.equals("Destinations")) {
                return 25;
            }
            if (string.equals("ErrorDestination")) {
                return 17;
            }
            if (string.equals("ExpirationLoggingPolicy")) {
                return 22;
            }
            if (string.equals("ExpirationPolicy")) {
                return 21;
            }
            if (string.equals("MaximumMessageSize")) {
                return 23;
            }
            if (string.equals("MessagesMaximum")) {
                return 11;
            }
            if (string.equals("MessagesThresholdHigh")) {
                return 12;
            }
            if (string.equals("MessagesThresholdLow")) {
                return 13;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Notes")) {
                return 3;
            }
            if (string.equals("PriorityOverride")) {
                return 14;
            }
            if (string.equals("RedeliveryDelayOverride")) {
                return 16;
            }
            if (string.equals("RedeliveryLimit")) {
                return 18;
            }
            if (string.equals("TimeToDeliverOverride")) {
                return 15;
            }
            if (string.equals("TimeToLiveOverride")) {
                return 19;
            }
            if (string.equals("BytesPagingEnabled")) {
                return 27;
            }
            if (string.equals("MessagesPagingEnabled")) {
                return 26;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBytesMaximumSet()) {
                    stringBuffer.append("BytesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getBytesMaximum()));
                }
                if (this.bean.isBytesThresholdHighSet()) {
                    stringBuffer.append("BytesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdHigh()));
                }
                if (this.bean.isBytesThresholdLowSet()) {
                    stringBuffer.append("BytesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdLow()));
                }
                if (this.bean.isDeliveryModeOverrideSet()) {
                    stringBuffer.append("DeliveryModeOverride");
                    stringBuffer.append(String.valueOf(this.bean.getDeliveryModeOverride()));
                }
                if (this.bean.isDestinationsSet()) {
                    stringBuffer.append("Destinations");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getDestinations())));
                }
                if (this.bean.isErrorDestinationSet()) {
                    stringBuffer.append("ErrorDestination");
                    stringBuffer.append(String.valueOf(this.bean.getErrorDestination()));
                }
                if (this.bean.isExpirationLoggingPolicySet()) {
                    stringBuffer.append("ExpirationLoggingPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getExpirationLoggingPolicy()));
                }
                if (this.bean.isExpirationPolicySet()) {
                    stringBuffer.append("ExpirationPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getExpirationPolicy()));
                }
                if (this.bean.isMaximumMessageSizeSet()) {
                    stringBuffer.append("MaximumMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumMessageSize()));
                }
                if (this.bean.isMessagesMaximumSet()) {
                    stringBuffer.append("MessagesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesMaximum()));
                }
                if (this.bean.isMessagesThresholdHighSet()) {
                    stringBuffer.append("MessagesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdHigh()));
                }
                if (this.bean.isMessagesThresholdLowSet()) {
                    stringBuffer.append("MessagesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdLow()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNotesSet()) {
                    stringBuffer.append("Notes");
                    stringBuffer.append(String.valueOf(this.bean.getNotes()));
                }
                if (this.bean.isPriorityOverrideSet()) {
                    stringBuffer.append("PriorityOverride");
                    stringBuffer.append(String.valueOf(this.bean.getPriorityOverride()));
                }
                if (this.bean.isRedeliveryDelayOverrideSet()) {
                    stringBuffer.append("RedeliveryDelayOverride");
                    stringBuffer.append(String.valueOf(this.bean.getRedeliveryDelayOverride()));
                }
                if (this.bean.isRedeliveryLimitSet()) {
                    stringBuffer.append("RedeliveryLimit");
                    stringBuffer.append(String.valueOf(this.bean.getRedeliveryLimit()));
                }
                if (this.bean.isTimeToDeliverOverrideSet()) {
                    stringBuffer.append("TimeToDeliverOverride");
                    stringBuffer.append(String.valueOf(this.bean.getTimeToDeliverOverride()));
                }
                if (this.bean.isTimeToLiveOverrideSet()) {
                    stringBuffer.append("TimeToLiveOverride");
                    stringBuffer.append(String.valueOf(this.bean.getTimeToLiveOverride()));
                }
                if (this.bean.isBytesPagingEnabledSet()) {
                    stringBuffer.append("BytesPagingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isBytesPagingEnabled()));
                }
                if (this.bean.isMessagesPagingEnabledSet()) {
                    stringBuffer.append("MessagesPagingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isMessagesPagingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMSTemplateMBeanImpl jMSTemplateMBeanImpl = (JMSTemplateMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesMaximum", this.bean.getBytesMaximum(), jMSTemplateMBeanImpl.getBytesMaximum(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesThresholdHigh", this.bean.getBytesThresholdHigh(), jMSTemplateMBeanImpl.getBytesThresholdHigh(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesThresholdLow", this.bean.getBytesThresholdLow(), jMSTemplateMBeanImpl.getBytesThresholdLow(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DeliveryModeOverride", this.bean.getDeliveryModeOverride(), jMSTemplateMBeanImpl.getDeliveryModeOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Destinations", this.bean.getDestinations(), jMSTemplateMBeanImpl.getDestinations(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ErrorDestination", this.bean.getErrorDestination(), jMSTemplateMBeanImpl.getErrorDestination(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ExpirationLoggingPolicy", this.bean.getExpirationLoggingPolicy(), jMSTemplateMBeanImpl.getExpirationLoggingPolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ExpirationPolicy", this.bean.getExpirationPolicy(), jMSTemplateMBeanImpl.getExpirationPolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MaximumMessageSize", this.bean.getMaximumMessageSize(), jMSTemplateMBeanImpl.getMaximumMessageSize(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesMaximum", this.bean.getMessagesMaximum(), jMSTemplateMBeanImpl.getMessagesMaximum(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesThresholdHigh", this.bean.getMessagesThresholdHigh(), jMSTemplateMBeanImpl.getMessagesThresholdHigh(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesThresholdLow", this.bean.getMessagesThresholdLow(), jMSTemplateMBeanImpl.getMessagesThresholdLow(), true);
                }
                this.computeDiff("Name", this.bean.getName(), jMSTemplateMBeanImpl.getName(), false);
                this.computeDiff("Notes", this.bean.getNotes(), jMSTemplateMBeanImpl.getNotes(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PriorityOverride", this.bean.getPriorityOverride(), jMSTemplateMBeanImpl.getPriorityOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RedeliveryDelayOverride", this.bean.getRedeliveryDelayOverride(), jMSTemplateMBeanImpl.getRedeliveryDelayOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RedeliveryLimit", this.bean.getRedeliveryLimit(), jMSTemplateMBeanImpl.getRedeliveryLimit(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TimeToDeliverOverride", this.bean.getTimeToDeliverOverride(), jMSTemplateMBeanImpl.getTimeToDeliverOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TimeToLiveOverride", this.bean.getTimeToLiveOverride(), jMSTemplateMBeanImpl.getTimeToLiveOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesPagingEnabled", this.bean.isBytesPagingEnabled(), jMSTemplateMBeanImpl.isBytesPagingEnabled(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesPagingEnabled", this.bean.isMessagesPagingEnabled(), jMSTemplateMBeanImpl.isMessagesPagingEnabled(), false);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMSTemplateMBeanImpl jMSTemplateMBeanImpl = (JMSTemplateMBeanImpl)beanUpdateEvent.getSourceBean();
                JMSTemplateMBeanImpl jMSTemplateMBeanImpl2 = (JMSTemplateMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BytesMaximum")) {
                    jMSTemplateMBeanImpl.setBytesMaximum(jMSTemplateMBeanImpl2.getBytesMaximum());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("BytesThresholdHigh")) {
                    jMSTemplateMBeanImpl.setBytesThresholdHigh(jMSTemplateMBeanImpl2.getBytesThresholdHigh());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("BytesThresholdLow")) {
                    jMSTemplateMBeanImpl.setBytesThresholdLow(jMSTemplateMBeanImpl2.getBytesThresholdLow());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("DeliveryModeOverride")) {
                    jMSTemplateMBeanImpl.setDeliveryModeOverride(jMSTemplateMBeanImpl2.getDeliveryModeOverride());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("Destinations")) {
                    jMSTemplateMBeanImpl.setDestinationsAsString(jMSTemplateMBeanImpl2.getDestinationsAsString());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("ErrorDestination")) {
                    jMSTemplateMBeanImpl.setErrorDestinationAsString(jMSTemplateMBeanImpl2.getErrorDestinationAsString());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("ExpirationLoggingPolicy")) {
                    jMSTemplateMBeanImpl.setExpirationLoggingPolicy(jMSTemplateMBeanImpl2.getExpirationLoggingPolicy());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("ExpirationPolicy")) {
                    jMSTemplateMBeanImpl.setExpirationPolicy(jMSTemplateMBeanImpl2.getExpirationPolicy());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("MaximumMessageSize")) {
                    jMSTemplateMBeanImpl.setMaximumMessageSize(jMSTemplateMBeanImpl2.getMaximumMessageSize());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("MessagesMaximum")) {
                    jMSTemplateMBeanImpl.setMessagesMaximum(jMSTemplateMBeanImpl2.getMessagesMaximum());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("MessagesThresholdHigh")) {
                    jMSTemplateMBeanImpl.setMessagesThresholdHigh(jMSTemplateMBeanImpl2.getMessagesThresholdHigh());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("MessagesThresholdLow")) {
                    jMSTemplateMBeanImpl.setMessagesThresholdLow(jMSTemplateMBeanImpl2.getMessagesThresholdLow());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("Name")) {
                    jMSTemplateMBeanImpl.setName(jMSTemplateMBeanImpl2.getName());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("Notes")) {
                    jMSTemplateMBeanImpl.setNotes(jMSTemplateMBeanImpl2.getNotes());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                } else if (string.equals("PriorityOverride")) {
                    jMSTemplateMBeanImpl.setPriorityOverride(jMSTemplateMBeanImpl2.getPriorityOverride());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("RedeliveryDelayOverride")) {
                    jMSTemplateMBeanImpl.setRedeliveryDelayOverride(jMSTemplateMBeanImpl2.getRedeliveryDelayOverride());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("RedeliveryLimit")) {
                    jMSTemplateMBeanImpl.setRedeliveryLimit(jMSTemplateMBeanImpl2.getRedeliveryLimit());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("TimeToDeliverOverride")) {
                    jMSTemplateMBeanImpl.setTimeToDeliverOverride(jMSTemplateMBeanImpl2.getTimeToDeliverOverride());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("TimeToLiveOverride")) {
                    jMSTemplateMBeanImpl.setTimeToLiveOverride(jMSTemplateMBeanImpl2.getTimeToLiveOverride());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("BytesPagingEnabled")) {
                    jMSTemplateMBeanImpl.setBytesPagingEnabled(jMSTemplateMBeanImpl2.isBytesPagingEnabled());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("MessagesPagingEnabled")) {
                    jMSTemplateMBeanImpl.setMessagesPagingEnabled(jMSTemplateMBeanImpl2.isMessagesPagingEnabled());
                    jMSTemplateMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JMSTemplateMBeanImpl jMSTemplateMBeanImpl = (JMSTemplateMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMSTemplateMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("BytesMaximum")) && this.bean.isBytesMaximumSet()) {
                    jMSTemplateMBeanImpl.setBytesMaximum(this.bean.getBytesMaximum());
                }
                if (bl && (list == null || !list.contains("BytesThresholdHigh")) && this.bean.isBytesThresholdHighSet()) {
                    jMSTemplateMBeanImpl.setBytesThresholdHigh(this.bean.getBytesThresholdHigh());
                }
                if (bl && (list == null || !list.contains("BytesThresholdLow")) && this.bean.isBytesThresholdLowSet()) {
                    jMSTemplateMBeanImpl.setBytesThresholdLow(this.bean.getBytesThresholdLow());
                }
                if (bl && (list == null || !list.contains("DeliveryModeOverride")) && this.bean.isDeliveryModeOverrideSet()) {
                    jMSTemplateMBeanImpl.setDeliveryModeOverride(this.bean.getDeliveryModeOverride());
                }
                if (bl && (list == null || !list.contains("Destinations")) && this.bean.isDestinationsSet()) {
                    jMSTemplateMBeanImpl._unSet(jMSTemplateMBeanImpl, 25);
                    jMSTemplateMBeanImpl.setDestinationsAsString(this.bean.getDestinationsAsString());
                }
                if (bl && (list == null || !list.contains("ErrorDestination")) && this.bean.isErrorDestinationSet()) {
                    jMSTemplateMBeanImpl._unSet(jMSTemplateMBeanImpl, 17);
                    jMSTemplateMBeanImpl.setErrorDestinationAsString(this.bean.getErrorDestinationAsString());
                }
                if (bl && (list == null || !list.contains("ExpirationLoggingPolicy")) && this.bean.isExpirationLoggingPolicySet()) {
                    jMSTemplateMBeanImpl.setExpirationLoggingPolicy(this.bean.getExpirationLoggingPolicy());
                }
                if (bl && (list == null || !list.contains("ExpirationPolicy")) && this.bean.isExpirationPolicySet()) {
                    jMSTemplateMBeanImpl.setExpirationPolicy(this.bean.getExpirationPolicy());
                }
                if (bl && (list == null || !list.contains("MaximumMessageSize")) && this.bean.isMaximumMessageSizeSet()) {
                    jMSTemplateMBeanImpl.setMaximumMessageSize(this.bean.getMaximumMessageSize());
                }
                if (bl && (list == null || !list.contains("MessagesMaximum")) && this.bean.isMessagesMaximumSet()) {
                    jMSTemplateMBeanImpl.setMessagesMaximum(this.bean.getMessagesMaximum());
                }
                if (bl && (list == null || !list.contains("MessagesThresholdHigh")) && this.bean.isMessagesThresholdHighSet()) {
                    jMSTemplateMBeanImpl.setMessagesThresholdHigh(this.bean.getMessagesThresholdHigh());
                }
                if (bl && (list == null || !list.contains("MessagesThresholdLow")) && this.bean.isMessagesThresholdLowSet()) {
                    jMSTemplateMBeanImpl.setMessagesThresholdLow(this.bean.getMessagesThresholdLow());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jMSTemplateMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Notes")) && this.bean.isNotesSet()) {
                    jMSTemplateMBeanImpl.setNotes(this.bean.getNotes());
                }
                if (bl && (list == null || !list.contains("PriorityOverride")) && this.bean.isPriorityOverrideSet()) {
                    jMSTemplateMBeanImpl.setPriorityOverride(this.bean.getPriorityOverride());
                }
                if (bl && (list == null || !list.contains("RedeliveryDelayOverride")) && this.bean.isRedeliveryDelayOverrideSet()) {
                    jMSTemplateMBeanImpl.setRedeliveryDelayOverride(this.bean.getRedeliveryDelayOverride());
                }
                if (bl && (list == null || !list.contains("RedeliveryLimit")) && this.bean.isRedeliveryLimitSet()) {
                    jMSTemplateMBeanImpl.setRedeliveryLimit(this.bean.getRedeliveryLimit());
                }
                if (bl && (list == null || !list.contains("TimeToDeliverOverride")) && this.bean.isTimeToDeliverOverrideSet()) {
                    jMSTemplateMBeanImpl.setTimeToDeliverOverride(this.bean.getTimeToDeliverOverride());
                }
                if (bl && (list == null || !list.contains("TimeToLiveOverride")) && this.bean.isTimeToLiveOverrideSet()) {
                    jMSTemplateMBeanImpl.setTimeToLiveOverride(this.bean.getTimeToLiveOverride());
                }
                if (bl && (list == null || !list.contains("BytesPagingEnabled")) && this.bean.isBytesPagingEnabledSet()) {
                    jMSTemplateMBeanImpl.setBytesPagingEnabled(this.bean.isBytesPagingEnabled());
                }
                if (bl && (list == null || !list.contains("MessagesPagingEnabled")) && this.bean.isMessagesPagingEnabledSet()) {
                    jMSTemplateMBeanImpl.setMessagesPagingEnabled(this.bean.isMessagesPagingEnabled());
                }
                return jMSTemplateMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDestinations(), clazz, object);
            this.inferSubTree(this.bean.getErrorDestination(), clazz, object);
        }
    }
}

