/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMXMBean;
import weblogic.management.configuration.LegalHelper;
import weblogic.utils.collections.CombinedIterator;

public class JMXMBeanImpl
extends ConfigurationMBeanImpl
implements JMXMBean,
Serializable {
    private boolean _CompatibilityMBeanServerEnabled;
    private boolean _DomainMBeanServerEnabled;
    private boolean _EditMBeanServerEnabled;
    private int _InvocationTimeoutSeconds;
    private boolean _ManagementEJBEnabled;
    private boolean _PlatformMBeanServerEnabled;
    private boolean _PlatformMBeanServerUsed;
    private boolean _RuntimeMBeanServerEnabled;
    private static SchemaHelper2 _schemaHelper;

    public JMXMBeanImpl() {
        this._initializeProperty(-1);
    }

    public JMXMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public boolean isRuntimeMBeanServerEnabled() {
        return this._RuntimeMBeanServerEnabled;
    }

    public boolean isRuntimeMBeanServerEnabledSet() {
        return this._isSet(7);
    }

    public void setRuntimeMBeanServerEnabled(boolean bl) {
        boolean bl2 = this._RuntimeMBeanServerEnabled;
        this._RuntimeMBeanServerEnabled = bl;
        this._postSet(7, bl2, bl);
    }

    public boolean isDomainMBeanServerEnabled() {
        return this._DomainMBeanServerEnabled;
    }

    public boolean isDomainMBeanServerEnabledSet() {
        return this._isSet(8);
    }

    public void setDomainMBeanServerEnabled(boolean bl) {
        boolean bl2 = this._DomainMBeanServerEnabled;
        this._DomainMBeanServerEnabled = bl;
        this._postSet(8, bl2, bl);
    }

    public boolean isEditMBeanServerEnabled() {
        return this._EditMBeanServerEnabled;
    }

    public boolean isEditMBeanServerEnabledSet() {
        return this._isSet(9);
    }

    public void setEditMBeanServerEnabled(boolean bl) {
        boolean bl2 = this._EditMBeanServerEnabled;
        this._EditMBeanServerEnabled = bl;
        this._postSet(9, bl2, bl);
    }

    public boolean isCompatibilityMBeanServerEnabled() {
        return this._CompatibilityMBeanServerEnabled;
    }

    public boolean isCompatibilityMBeanServerEnabledSet() {
        return this._isSet(10);
    }

    public void setCompatibilityMBeanServerEnabled(boolean bl) {
        boolean bl2 = this._CompatibilityMBeanServerEnabled;
        this._CompatibilityMBeanServerEnabled = bl;
        this._postSet(10, bl2, bl);
    }

    public boolean isManagementEJBEnabled() {
        return this._ManagementEJBEnabled;
    }

    public boolean isManagementEJBEnabledSet() {
        return this._isSet(11);
    }

    public void setManagementEJBEnabled(boolean bl) {
        boolean bl2 = this._ManagementEJBEnabled;
        this._ManagementEJBEnabled = bl;
        this._postSet(11, bl2, bl);
    }

    public boolean isPlatformMBeanServerEnabled() {
        return this._PlatformMBeanServerEnabled;
    }

    public boolean isPlatformMBeanServerEnabledSet() {
        return this._isSet(12);
    }

    public void setPlatformMBeanServerEnabled(boolean bl) {
        boolean bl2 = this._PlatformMBeanServerEnabled;
        this._PlatformMBeanServerEnabled = bl;
        this._postSet(12, bl2, bl);
    }

    public int getInvocationTimeoutSeconds() {
        return this._InvocationTimeoutSeconds;
    }

    public boolean isInvocationTimeoutSecondsSet() {
        return this._isSet(13);
    }

    public void setInvocationTimeoutSeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"InvocationTimeoutSeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._InvocationTimeoutSeconds;
        this._InvocationTimeoutSeconds = n;
        this._postSet(13, n2, n);
    }

    public boolean isPlatformMBeanServerUsed() {
        if (!this._isSet(14)) {
            try {
                return !LegalHelper.versionEarlierThan(((DomainMBean)this.getParent()).getDomainVersion(), "10.3.3.0");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._PlatformMBeanServerUsed;
    }

    public boolean isPlatformMBeanServerUsedSet() {
        return this._isSet(14);
    }

    public void setPlatformMBeanServerUsed(boolean bl) {
        boolean bl2 = this._PlatformMBeanServerUsed;
        this._PlatformMBeanServerUsed = bl;
        this._postSet(14, bl2, bl);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 13;
        }
        try {
            switch (n) {
                case 13: {
                    this._InvocationTimeoutSeconds = 0;
                    if (bl) break;
                }
                case 10: {
                    this._CompatibilityMBeanServerEnabled = true;
                    if (bl) break;
                }
                case 8: {
                    this._DomainMBeanServerEnabled = true;
                    if (bl) break;
                }
                case 9: {
                    this._EditMBeanServerEnabled = true;
                    if (bl) break;
                }
                case 11: {
                    this._ManagementEJBEnabled = true;
                    if (bl) break;
                }
                case 12: {
                    this._PlatformMBeanServerEnabled = false;
                    if (bl) break;
                }
                case 14: {
                    this._PlatformMBeanServerUsed = false;
                    if (bl) break;
                }
                case 7: {
                    this._RuntimeMBeanServerEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMX";
    }

    public void putValue(String string, Object object) {
        if (string.equals("CompatibilityMBeanServerEnabled")) {
            boolean bl = this._CompatibilityMBeanServerEnabled;
            this._CompatibilityMBeanServerEnabled = (Boolean)object;
            this._postSet(10, bl, this._CompatibilityMBeanServerEnabled);
            return;
        }
        if (string.equals("DomainMBeanServerEnabled")) {
            boolean bl = this._DomainMBeanServerEnabled;
            this._DomainMBeanServerEnabled = (Boolean)object;
            this._postSet(8, bl, this._DomainMBeanServerEnabled);
            return;
        }
        if (string.equals("EditMBeanServerEnabled")) {
            boolean bl = this._EditMBeanServerEnabled;
            this._EditMBeanServerEnabled = (Boolean)object;
            this._postSet(9, bl, this._EditMBeanServerEnabled);
            return;
        }
        if (string.equals("InvocationTimeoutSeconds")) {
            int n = this._InvocationTimeoutSeconds;
            this._InvocationTimeoutSeconds = (Integer)object;
            this._postSet(13, n, this._InvocationTimeoutSeconds);
            return;
        }
        if (string.equals("ManagementEJBEnabled")) {
            boolean bl = this._ManagementEJBEnabled;
            this._ManagementEJBEnabled = (Boolean)object;
            this._postSet(11, bl, this._ManagementEJBEnabled);
            return;
        }
        if (string.equals("PlatformMBeanServerEnabled")) {
            boolean bl = this._PlatformMBeanServerEnabled;
            this._PlatformMBeanServerEnabled = (Boolean)object;
            this._postSet(12, bl, this._PlatformMBeanServerEnabled);
            return;
        }
        if (string.equals("PlatformMBeanServerUsed")) {
            boolean bl = this._PlatformMBeanServerUsed;
            this._PlatformMBeanServerUsed = (Boolean)object;
            this._postSet(14, bl, this._PlatformMBeanServerUsed);
            return;
        }
        if (string.equals("RuntimeMBeanServerEnabled")) {
            boolean bl = this._RuntimeMBeanServerEnabled;
            this._RuntimeMBeanServerEnabled = (Boolean)object;
            this._postSet(7, bl, this._RuntimeMBeanServerEnabled);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("CompatibilityMBeanServerEnabled")) {
            return new Boolean(this._CompatibilityMBeanServerEnabled);
        }
        if (string.equals("DomainMBeanServerEnabled")) {
            return new Boolean(this._DomainMBeanServerEnabled);
        }
        if (string.equals("EditMBeanServerEnabled")) {
            return new Boolean(this._EditMBeanServerEnabled);
        }
        if (string.equals("InvocationTimeoutSeconds")) {
            return new Integer(this._InvocationTimeoutSeconds);
        }
        if (string.equals("ManagementEJBEnabled")) {
            return new Boolean(this._ManagementEJBEnabled);
        }
        if (string.equals("PlatformMBeanServerEnabled")) {
            return new Boolean(this._PlatformMBeanServerEnabled);
        }
        if (string.equals("PlatformMBeanServerUsed")) {
            return new Boolean(this._PlatformMBeanServerUsed);
        }
        if (string.equals("RuntimeMBeanServerEnabled")) {
            return new Boolean(this._RuntimeMBeanServerEnabled);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 26: {
                    if (string.equals("invocation-timeout-seconds")) {
                        return 13;
                    }
                    if (!string.equals("platformm-bean-server-used")) break;
                    return 14;
                }
                case 34: {
                    if (!string.equals("compatibilitym-bean-server-enabled")) break;
                    return 10;
                }
                case 27: {
                    if (!string.equals("domainm-bean-server-enabled")) break;
                    return 8;
                }
                case 25: {
                    if (!string.equals("editm-bean-server-enabled")) break;
                    return 9;
                }
                case 21: {
                    if (!string.equals("managementejb-enabled")) break;
                    return 11;
                }
                case 29: {
                    if (!string.equals("platformm-bean-server-enabled")) break;
                    return 12;
                }
                case 28: {
                    if (!string.equals("runtimem-bean-server-enabled")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 13: {
                    return "invocation-timeout-seconds";
                }
                case 10: {
                    return "compatibilitym-bean-server-enabled";
                }
                case 8: {
                    return "domainm-bean-server-enabled";
                }
                case 9: {
                    return "editm-bean-server-enabled";
                }
                case 11: {
                    return "managementejb-enabled";
                }
                case 12: {
                    return "platformm-bean-server-enabled";
                }
                case 14: {
                    return "platformm-bean-server-used";
                }
                case 7: {
                    return "runtimem-bean-server-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private JMXMBeanImpl bean;

        protected Helper(JMXMBeanImpl jMXMBeanImpl) {
            super(jMXMBeanImpl);
            this.bean = jMXMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 13: {
                    return "InvocationTimeoutSeconds";
                }
                case 10: {
                    return "CompatibilityMBeanServerEnabled";
                }
                case 8: {
                    return "DomainMBeanServerEnabled";
                }
                case 9: {
                    return "EditMBeanServerEnabled";
                }
                case 11: {
                    return "ManagementEJBEnabled";
                }
                case 12: {
                    return "PlatformMBeanServerEnabled";
                }
                case 14: {
                    return "PlatformMBeanServerUsed";
                }
                case 7: {
                    return "RuntimeMBeanServerEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("InvocationTimeoutSeconds")) {
                return 13;
            }
            if (string.equals("CompatibilityMBeanServerEnabled")) {
                return 10;
            }
            if (string.equals("DomainMBeanServerEnabled")) {
                return 8;
            }
            if (string.equals("EditMBeanServerEnabled")) {
                return 9;
            }
            if (string.equals("ManagementEJBEnabled")) {
                return 11;
            }
            if (string.equals("PlatformMBeanServerEnabled")) {
                return 12;
            }
            if (string.equals("PlatformMBeanServerUsed")) {
                return 14;
            }
            if (string.equals("RuntimeMBeanServerEnabled")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isInvocationTimeoutSecondsSet()) {
                    stringBuffer.append("InvocationTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getInvocationTimeoutSeconds()));
                }
                if (this.bean.isCompatibilityMBeanServerEnabledSet()) {
                    stringBuffer.append("CompatibilityMBeanServerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCompatibilityMBeanServerEnabled()));
                }
                if (this.bean.isDomainMBeanServerEnabledSet()) {
                    stringBuffer.append("DomainMBeanServerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDomainMBeanServerEnabled()));
                }
                if (this.bean.isEditMBeanServerEnabledSet()) {
                    stringBuffer.append("EditMBeanServerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isEditMBeanServerEnabled()));
                }
                if (this.bean.isManagementEJBEnabledSet()) {
                    stringBuffer.append("ManagementEJBEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isManagementEJBEnabled()));
                }
                if (this.bean.isPlatformMBeanServerEnabledSet()) {
                    stringBuffer.append("PlatformMBeanServerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isPlatformMBeanServerEnabled()));
                }
                if (this.bean.isPlatformMBeanServerUsedSet()) {
                    stringBuffer.append("PlatformMBeanServerUsed");
                    stringBuffer.append(String.valueOf(this.bean.isPlatformMBeanServerUsed()));
                }
                if (this.bean.isRuntimeMBeanServerEnabledSet()) {
                    stringBuffer.append("RuntimeMBeanServerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isRuntimeMBeanServerEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMXMBeanImpl jMXMBeanImpl = (JMXMBeanImpl)abstractDescriptorBean;
                this.computeDiff("InvocationTimeoutSeconds", this.bean.getInvocationTimeoutSeconds(), jMXMBeanImpl.getInvocationTimeoutSeconds(), false);
                this.computeDiff("CompatibilityMBeanServerEnabled", this.bean.isCompatibilityMBeanServerEnabled(), jMXMBeanImpl.isCompatibilityMBeanServerEnabled(), true);
                this.computeDiff("DomainMBeanServerEnabled", this.bean.isDomainMBeanServerEnabled(), jMXMBeanImpl.isDomainMBeanServerEnabled(), true);
                this.computeDiff("EditMBeanServerEnabled", this.bean.isEditMBeanServerEnabled(), jMXMBeanImpl.isEditMBeanServerEnabled(), true);
                this.computeDiff("ManagementEJBEnabled", this.bean.isManagementEJBEnabled(), jMXMBeanImpl.isManagementEJBEnabled(), true);
                this.computeDiff("PlatformMBeanServerEnabled", this.bean.isPlatformMBeanServerEnabled(), jMXMBeanImpl.isPlatformMBeanServerEnabled(), false);
                this.computeDiff("PlatformMBeanServerUsed", this.bean.isPlatformMBeanServerUsed(), jMXMBeanImpl.isPlatformMBeanServerUsed(), false);
                this.computeDiff("RuntimeMBeanServerEnabled", this.bean.isRuntimeMBeanServerEnabled(), jMXMBeanImpl.isRuntimeMBeanServerEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMXMBeanImpl jMXMBeanImpl = (JMXMBeanImpl)beanUpdateEvent.getSourceBean();
                JMXMBeanImpl jMXMBeanImpl2 = (JMXMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("InvocationTimeoutSeconds")) {
                    jMXMBeanImpl.setInvocationTimeoutSeconds(jMXMBeanImpl2.getInvocationTimeoutSeconds());
                    jMXMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("CompatibilityMBeanServerEnabled")) {
                    jMXMBeanImpl.setCompatibilityMBeanServerEnabled(jMXMBeanImpl2.isCompatibilityMBeanServerEnabled());
                    jMXMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("DomainMBeanServerEnabled")) {
                    jMXMBeanImpl.setDomainMBeanServerEnabled(jMXMBeanImpl2.isDomainMBeanServerEnabled());
                    jMXMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("EditMBeanServerEnabled")) {
                    jMXMBeanImpl.setEditMBeanServerEnabled(jMXMBeanImpl2.isEditMBeanServerEnabled());
                    jMXMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ManagementEJBEnabled")) {
                    jMXMBeanImpl.setManagementEJBEnabled(jMXMBeanImpl2.isManagementEJBEnabled());
                    jMXMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("PlatformMBeanServerEnabled")) {
                    jMXMBeanImpl.setPlatformMBeanServerEnabled(jMXMBeanImpl2.isPlatformMBeanServerEnabled());
                    jMXMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("PlatformMBeanServerUsed")) {
                    jMXMBeanImpl.setPlatformMBeanServerUsed(jMXMBeanImpl2.isPlatformMBeanServerUsed());
                    jMXMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("RuntimeMBeanServerEnabled")) {
                    jMXMBeanImpl.setRuntimeMBeanServerEnabled(jMXMBeanImpl2.isRuntimeMBeanServerEnabled());
                    jMXMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JMXMBeanImpl jMXMBeanImpl = (JMXMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMXMBeanImpl, bl, list);
                if ((list == null || !list.contains("InvocationTimeoutSeconds")) && this.bean.isInvocationTimeoutSecondsSet()) {
                    jMXMBeanImpl.setInvocationTimeoutSeconds(this.bean.getInvocationTimeoutSeconds());
                }
                if ((list == null || !list.contains("CompatibilityMBeanServerEnabled")) && this.bean.isCompatibilityMBeanServerEnabledSet()) {
                    jMXMBeanImpl.setCompatibilityMBeanServerEnabled(this.bean.isCompatibilityMBeanServerEnabled());
                }
                if ((list == null || !list.contains("DomainMBeanServerEnabled")) && this.bean.isDomainMBeanServerEnabledSet()) {
                    jMXMBeanImpl.setDomainMBeanServerEnabled(this.bean.isDomainMBeanServerEnabled());
                }
                if ((list == null || !list.contains("EditMBeanServerEnabled")) && this.bean.isEditMBeanServerEnabledSet()) {
                    jMXMBeanImpl.setEditMBeanServerEnabled(this.bean.isEditMBeanServerEnabled());
                }
                if ((list == null || !list.contains("ManagementEJBEnabled")) && this.bean.isManagementEJBEnabledSet()) {
                    jMXMBeanImpl.setManagementEJBEnabled(this.bean.isManagementEJBEnabled());
                }
                if ((list == null || !list.contains("PlatformMBeanServerEnabled")) && this.bean.isPlatformMBeanServerEnabledSet()) {
                    jMXMBeanImpl.setPlatformMBeanServerEnabled(this.bean.isPlatformMBeanServerEnabled());
                }
                if ((list == null || !list.contains("PlatformMBeanServerUsed")) && this.bean.isPlatformMBeanServerUsedSet()) {
                    jMXMBeanImpl.setPlatformMBeanServerUsed(this.bean.isPlatformMBeanServerUsed());
                }
                if ((list == null || !list.contains("RuntimeMBeanServerEnabled")) && this.bean.isRuntimeMBeanServerEnabledSet()) {
                    jMXMBeanImpl.setRuntimeMBeanServerEnabled(this.bean.isRuntimeMBeanServerEnabled());
                }
                return jMXMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

