/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.JTAMBean;
import weblogic.utils.collections.CombinedIterator;

public class JTAMBeanImpl
extends ConfigurationMBeanImpl
implements JTAMBean,
Serializable {
    private int _AbandonTimeoutSeconds;
    private int _BeforeCompletionIterationLimit;
    private int _CheckpointIntervalSeconds;
    private int _CompletionTimeoutSeconds;
    private boolean _ForgetHeuristics;
    private int _MaxResourceRequestsOnServer;
    private long _MaxResourceUnavailableMillis;
    private int _MaxTransactions;
    private long _MaxTransactionsHealthIntervalMillis;
    private int _MaxUniqueNameStatistics;
    private long _MaxXACallMillis;
    private int _MigrationCheckpointIntervalSeconds;
    private String _ParallelXADispatchPolicy;
    private boolean _ParallelXAEnabled;
    private int _PurgeResourceFromCheckpointIntervalSeconds;
    private long _RecoveryThresholdMillis;
    private String _SecurityInteropMode;
    private long _SerializeEnlistmentsGCIntervalMillis;
    private int _TimeoutSeconds;
    private boolean _TwoPhaseEnabled;
    private int _UnregisterResourceGracePeriod;
    private boolean _WSATIssuedTokenEnabled;
    private String _WSATTransportSecurityMode;
    private static SchemaHelper2 _schemaHelper;

    public JTAMBeanImpl() {
        this._initializeProperty(-1);
    }

    public JTAMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public int getTimeoutSeconds() {
        return this._TimeoutSeconds;
    }

    public boolean isTimeoutSecondsSet() {
        return this._isSet(7);
    }

    public void setTimeoutSeconds(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"TimeoutSeconds", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._TimeoutSeconds;
        this._TimeoutSeconds = n;
        this._postSet(7, n2, n);
    }

    public int getAbandonTimeoutSeconds() {
        return this._AbandonTimeoutSeconds;
    }

    public boolean isAbandonTimeoutSecondsSet() {
        return this._isSet(8);
    }

    public void setAbandonTimeoutSeconds(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"AbandonTimeoutSeconds", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._AbandonTimeoutSeconds;
        this._AbandonTimeoutSeconds = n;
        this._postSet(8, n2, n);
    }

    public int getCompletionTimeoutSeconds() {
        return this._CompletionTimeoutSeconds;
    }

    public boolean isCompletionTimeoutSecondsSet() {
        return this._isSet(9);
    }

    public void setCompletionTimeoutSeconds(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompletionTimeoutSeconds", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this._CompletionTimeoutSeconds;
        this._CompletionTimeoutSeconds = n;
        this._postSet(9, n2, n);
    }

    public boolean getForgetHeuristics() {
        return this._ForgetHeuristics;
    }

    public boolean isForgetHeuristicsSet() {
        return this._isSet(10);
    }

    public void setForgetHeuristics(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._ForgetHeuristics;
        this._ForgetHeuristics = bl;
        this._postSet(10, bl2, bl);
    }

    public int getBeforeCompletionIterationLimit() {
        return this._BeforeCompletionIterationLimit;
    }

    public boolean isBeforeCompletionIterationLimitSet() {
        return this._isSet(11);
    }

    public void setBeforeCompletionIterationLimit(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BeforeCompletionIterationLimit", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._BeforeCompletionIterationLimit;
        this._BeforeCompletionIterationLimit = n;
        this._postSet(11, n2, n);
    }

    public int getMaxTransactions() {
        return this._MaxTransactions;
    }

    public boolean isMaxTransactionsSet() {
        return this._isSet(12);
    }

    public void setMaxTransactions(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxTransactions", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._MaxTransactions;
        this._MaxTransactions = n;
        this._postSet(12, n2, n);
    }

    public int getMaxUniqueNameStatistics() {
        return this._MaxUniqueNameStatistics;
    }

    public boolean isMaxUniqueNameStatisticsSet() {
        return this._isSet(13);
    }

    public void setMaxUniqueNameStatistics(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxUniqueNameStatistics", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._MaxUniqueNameStatistics;
        this._MaxUniqueNameStatistics = n;
        this._postSet(13, n2, n);
    }

    public int getMaxResourceRequestsOnServer() {
        return this._MaxResourceRequestsOnServer;
    }

    public boolean isMaxResourceRequestsOnServerSet() {
        return this._isSet(14);
    }

    public void setMaxResourceRequestsOnServer(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxResourceRequestsOnServer", (long)n, (long)10L, (long)Integer.MAX_VALUE);
        int n2 = this._MaxResourceRequestsOnServer;
        this._MaxResourceRequestsOnServer = n;
        this._postSet(14, n2, n);
    }

    public long getMaxXACallMillis() {
        return this._MaxXACallMillis;
    }

    public boolean isMaxXACallMillisSet() {
        return this._isSet(15);
    }

    public void setMaxXACallMillis(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxXACallMillis", (long)l, (long)0L, (long)Long.MAX_VALUE);
        long l2 = this._MaxXACallMillis;
        this._MaxXACallMillis = l;
        this._postSet(15, l2, l);
    }

    public long getMaxResourceUnavailableMillis() {
        return this._MaxResourceUnavailableMillis;
    }

    public boolean isMaxResourceUnavailableMillisSet() {
        return this._isSet(16);
    }

    public void setMaxResourceUnavailableMillis(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxResourceUnavailableMillis", (long)l, (long)0L, (long)Long.MAX_VALUE);
        long l2 = this._MaxResourceUnavailableMillis;
        this._MaxResourceUnavailableMillis = l;
        this._postSet(16, l2, l);
    }

    public long getRecoveryThresholdMillis() {
        return this._RecoveryThresholdMillis;
    }

    public boolean isRecoveryThresholdMillisSet() {
        return this._isSet(17);
    }

    public void setRecoveryThresholdMillis(long l) {
        LegalChecks.checkInRange((String)"RecoveryThresholdMillis", (long)l, (long)60000L, (long)Long.MAX_VALUE);
        long l2 = this._RecoveryThresholdMillis;
        this._RecoveryThresholdMillis = l;
        this._postSet(17, l2, l);
    }

    public int getMigrationCheckpointIntervalSeconds() {
        return this._MigrationCheckpointIntervalSeconds;
    }

    public boolean isMigrationCheckpointIntervalSecondsSet() {
        return this._isSet(18);
    }

    public void setMigrationCheckpointIntervalSeconds(int n) {
        LegalChecks.checkInRange((String)"MigrationCheckpointIntervalSeconds", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._MigrationCheckpointIntervalSeconds;
        this._MigrationCheckpointIntervalSeconds = n;
        this._postSet(18, n2, n);
    }

    public long getMaxTransactionsHealthIntervalMillis() {
        return this._MaxTransactionsHealthIntervalMillis;
    }

    public boolean isMaxTransactionsHealthIntervalMillisSet() {
        return this._isSet(19);
    }

    public void setMaxTransactionsHealthIntervalMillis(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxTransactionsHealthIntervalMillis", (long)l, (long)1000L, (long)Long.MAX_VALUE);
        long l2 = this._MaxTransactionsHealthIntervalMillis;
        this._MaxTransactionsHealthIntervalMillis = l;
        this._postSet(19, l2, l);
    }

    public int getPurgeResourceFromCheckpointIntervalSeconds() {
        return this._PurgeResourceFromCheckpointIntervalSeconds;
    }

    public boolean isPurgeResourceFromCheckpointIntervalSecondsSet() {
        return this._isSet(20);
    }

    public void setPurgeResourceFromCheckpointIntervalSeconds(int n) {
        LegalChecks.checkInRange((String)"PurgeResourceFromCheckpointIntervalSeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._PurgeResourceFromCheckpointIntervalSeconds;
        this._PurgeResourceFromCheckpointIntervalSeconds = n;
        this._postSet(20, n2, n);
    }

    public int getCheckpointIntervalSeconds() {
        return this._CheckpointIntervalSeconds;
    }

    public boolean isCheckpointIntervalSecondsSet() {
        return this._isSet(21);
    }

    public void setCheckpointIntervalSeconds(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CheckpointIntervalSeconds", (long)n, (long)10L, (long)1800L);
        int n2 = this._CheckpointIntervalSeconds;
        this._CheckpointIntervalSeconds = n;
        this._postSet(21, n2, n);
    }

    public long getSerializeEnlistmentsGCIntervalMillis() {
        return this._SerializeEnlistmentsGCIntervalMillis;
    }

    public boolean isSerializeEnlistmentsGCIntervalMillisSet() {
        return this._isSet(22);
    }

    public void setSerializeEnlistmentsGCIntervalMillis(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"SerializeEnlistmentsGCIntervalMillis", (long)l, (long)0L);
        long l2 = this._SerializeEnlistmentsGCIntervalMillis;
        this._SerializeEnlistmentsGCIntervalMillis = l;
        this._postSet(22, l2, l);
    }

    public boolean getParallelXAEnabled() {
        return this._ParallelXAEnabled;
    }

    public boolean isParallelXAEnabledSet() {
        return this._isSet(23);
    }

    public void setParallelXAEnabled(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._ParallelXAEnabled;
        this._ParallelXAEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public String getParallelXADispatchPolicy() {
        return this._ParallelXADispatchPolicy;
    }

    public boolean isParallelXADispatchPolicySet() {
        return this._isSet(24);
    }

    public void setParallelXADispatchPolicy(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ParallelXADispatchPolicy;
        this._ParallelXADispatchPolicy = string;
        this._postSet(24, string2, string);
    }

    public int getUnregisterResourceGracePeriod() {
        return this._UnregisterResourceGracePeriod;
    }

    public boolean isUnregisterResourceGracePeriodSet() {
        return this._isSet(25);
    }

    public void setUnregisterResourceGracePeriod(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"UnregisterResourceGracePeriod", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._UnregisterResourceGracePeriod;
        this._UnregisterResourceGracePeriod = n;
        this._postSet(25, n2, n);
    }

    public String getSecurityInteropMode() {
        return this._SecurityInteropMode;
    }

    public boolean isSecurityInteropModeSet() {
        return this._isSet(26);
    }

    public void setSecurityInteropMode(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"default", "performance", "compatibility"};
        string = LegalChecks.checkInEnum((String)"SecurityInteropMode", (String)string, (String[])stringArray);
        String string2 = this._SecurityInteropMode;
        this._SecurityInteropMode = string;
        this._postSet(26, string2, string);
    }

    public String getWSATTransportSecurityMode() {
        return this._WSATTransportSecurityMode;
    }

    public boolean isWSATTransportSecurityModeSet() {
        return this._isSet(27);
    }

    public void setWSATTransportSecurityMode(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"SSLNotRequired", "SSLRequired", "ClientCertRequired"};
        string = LegalChecks.checkInEnum((String)"WSATTransportSecurityMode", (String)string, (String[])stringArray);
        String string2 = this._WSATTransportSecurityMode;
        this._WSATTransportSecurityMode = string;
        this._postSet(27, string2, string);
    }

    public boolean isWSATIssuedTokenEnabled() {
        return this._WSATIssuedTokenEnabled;
    }

    public boolean isWSATIssuedTokenEnabledSet() {
        return this._isSet(28);
    }

    public void setWSATIssuedTokenEnabled(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._WSATIssuedTokenEnabled;
        this._WSATIssuedTokenEnabled = bl;
        this._postSet(28, bl2, bl);
    }

    public boolean isTwoPhaseEnabled() {
        return this._TwoPhaseEnabled;
    }

    public boolean isTwoPhaseEnabledSet() {
        return this._isSet(29);
    }

    public void setTwoPhaseEnabled(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._TwoPhaseEnabled;
        this._TwoPhaseEnabled = bl;
        this._postSet(29, bl2, bl);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._AbandonTimeoutSeconds = 86400;
                    if (bl) break;
                }
                case 11: {
                    this._BeforeCompletionIterationLimit = 10;
                    if (bl) break;
                }
                case 21: {
                    this._CheckpointIntervalSeconds = 300;
                    if (bl) break;
                }
                case 9: {
                    this._CompletionTimeoutSeconds = 0;
                    if (bl) break;
                }
                case 10: {
                    this._ForgetHeuristics = true;
                    if (bl) break;
                }
                case 14: {
                    this._MaxResourceRequestsOnServer = 50;
                    if (bl) break;
                }
                case 16: {
                    this._MaxResourceUnavailableMillis = 1800000L;
                    if (bl) break;
                }
                case 12: {
                    this._MaxTransactions = 10000;
                    if (bl) break;
                }
                case 19: {
                    this._MaxTransactionsHealthIntervalMillis = 60000L;
                    if (bl) break;
                }
                case 13: {
                    this._MaxUniqueNameStatistics = 1000;
                    if (bl) break;
                }
                case 15: {
                    this._MaxXACallMillis = 120000L;
                    if (bl) break;
                }
                case 18: {
                    this._MigrationCheckpointIntervalSeconds = 60;
                    if (bl) break;
                }
                case 24: {
                    this._ParallelXADispatchPolicy = null;
                    if (bl) break;
                }
                case 23: {
                    this._ParallelXAEnabled = true;
                    if (bl) break;
                }
                case 20: {
                    this._PurgeResourceFromCheckpointIntervalSeconds = 86400;
                    if (bl) break;
                }
                case 17: {
                    this._RecoveryThresholdMillis = 300000L;
                    if (bl) break;
                }
                case 26: {
                    this._SecurityInteropMode = "default";
                    if (bl) break;
                }
                case 22: {
                    this._SerializeEnlistmentsGCIntervalMillis = 30000L;
                    if (bl) break;
                }
                case 7: {
                    this._TimeoutSeconds = 30;
                    if (bl) break;
                }
                case 25: {
                    this._UnregisterResourceGracePeriod = 30;
                    if (bl) break;
                }
                case 27: {
                    this._WSATTransportSecurityMode = "SSLNotRequired";
                    if (bl) break;
                }
                case 29: {
                    this._TwoPhaseEnabled = true;
                    if (bl) break;
                }
                case 28: {
                    this._WSATIssuedTokenEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JTA";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AbandonTimeoutSeconds")) {
            int n = this._AbandonTimeoutSeconds;
            this._AbandonTimeoutSeconds = (Integer)object;
            this._postSet(8, n, this._AbandonTimeoutSeconds);
            return;
        }
        if (string.equals("BeforeCompletionIterationLimit")) {
            int n = this._BeforeCompletionIterationLimit;
            this._BeforeCompletionIterationLimit = (Integer)object;
            this._postSet(11, n, this._BeforeCompletionIterationLimit);
            return;
        }
        if (string.equals("CheckpointIntervalSeconds")) {
            int n = this._CheckpointIntervalSeconds;
            this._CheckpointIntervalSeconds = (Integer)object;
            this._postSet(21, n, this._CheckpointIntervalSeconds);
            return;
        }
        if (string.equals("CompletionTimeoutSeconds")) {
            int n = this._CompletionTimeoutSeconds;
            this._CompletionTimeoutSeconds = (Integer)object;
            this._postSet(9, n, this._CompletionTimeoutSeconds);
            return;
        }
        if (string.equals("ForgetHeuristics")) {
            boolean bl = this._ForgetHeuristics;
            this._ForgetHeuristics = (Boolean)object;
            this._postSet(10, bl, this._ForgetHeuristics);
            return;
        }
        if (string.equals("MaxResourceRequestsOnServer")) {
            int n = this._MaxResourceRequestsOnServer;
            this._MaxResourceRequestsOnServer = (Integer)object;
            this._postSet(14, n, this._MaxResourceRequestsOnServer);
            return;
        }
        if (string.equals("MaxResourceUnavailableMillis")) {
            long l = this._MaxResourceUnavailableMillis;
            this._MaxResourceUnavailableMillis = (Long)object;
            this._postSet(16, l, this._MaxResourceUnavailableMillis);
            return;
        }
        if (string.equals("MaxTransactions")) {
            int n = this._MaxTransactions;
            this._MaxTransactions = (Integer)object;
            this._postSet(12, n, this._MaxTransactions);
            return;
        }
        if (string.equals("MaxTransactionsHealthIntervalMillis")) {
            long l = this._MaxTransactionsHealthIntervalMillis;
            this._MaxTransactionsHealthIntervalMillis = (Long)object;
            this._postSet(19, l, this._MaxTransactionsHealthIntervalMillis);
            return;
        }
        if (string.equals("MaxUniqueNameStatistics")) {
            int n = this._MaxUniqueNameStatistics;
            this._MaxUniqueNameStatistics = (Integer)object;
            this._postSet(13, n, this._MaxUniqueNameStatistics);
            return;
        }
        if (string.equals("MaxXACallMillis")) {
            long l = this._MaxXACallMillis;
            this._MaxXACallMillis = (Long)object;
            this._postSet(15, l, this._MaxXACallMillis);
            return;
        }
        if (string.equals("MigrationCheckpointIntervalSeconds")) {
            int n = this._MigrationCheckpointIntervalSeconds;
            this._MigrationCheckpointIntervalSeconds = (Integer)object;
            this._postSet(18, n, this._MigrationCheckpointIntervalSeconds);
            return;
        }
        if (string.equals("ParallelXADispatchPolicy")) {
            String string2 = this._ParallelXADispatchPolicy;
            this._ParallelXADispatchPolicy = (String)object;
            this._postSet(24, string2, this._ParallelXADispatchPolicy);
            return;
        }
        if (string.equals("ParallelXAEnabled")) {
            boolean bl = this._ParallelXAEnabled;
            this._ParallelXAEnabled = (Boolean)object;
            this._postSet(23, bl, this._ParallelXAEnabled);
            return;
        }
        if (string.equals("PurgeResourceFromCheckpointIntervalSeconds")) {
            int n = this._PurgeResourceFromCheckpointIntervalSeconds;
            this._PurgeResourceFromCheckpointIntervalSeconds = (Integer)object;
            this._postSet(20, n, this._PurgeResourceFromCheckpointIntervalSeconds);
            return;
        }
        if (string.equals("RecoveryThresholdMillis")) {
            long l = this._RecoveryThresholdMillis;
            this._RecoveryThresholdMillis = (Long)object;
            this._postSet(17, l, this._RecoveryThresholdMillis);
            return;
        }
        if (string.equals("SecurityInteropMode")) {
            String string3 = this._SecurityInteropMode;
            this._SecurityInteropMode = (String)object;
            this._postSet(26, string3, this._SecurityInteropMode);
            return;
        }
        if (string.equals("SerializeEnlistmentsGCIntervalMillis")) {
            long l = this._SerializeEnlistmentsGCIntervalMillis;
            this._SerializeEnlistmentsGCIntervalMillis = (Long)object;
            this._postSet(22, l, this._SerializeEnlistmentsGCIntervalMillis);
            return;
        }
        if (string.equals("TimeoutSeconds")) {
            int n = this._TimeoutSeconds;
            this._TimeoutSeconds = (Integer)object;
            this._postSet(7, n, this._TimeoutSeconds);
            return;
        }
        if (string.equals("TwoPhaseEnabled")) {
            boolean bl = this._TwoPhaseEnabled;
            this._TwoPhaseEnabled = (Boolean)object;
            this._postSet(29, bl, this._TwoPhaseEnabled);
            return;
        }
        if (string.equals("UnregisterResourceGracePeriod")) {
            int n = this._UnregisterResourceGracePeriod;
            this._UnregisterResourceGracePeriod = (Integer)object;
            this._postSet(25, n, this._UnregisterResourceGracePeriod);
            return;
        }
        if (string.equals("WSATIssuedTokenEnabled")) {
            boolean bl = this._WSATIssuedTokenEnabled;
            this._WSATIssuedTokenEnabled = (Boolean)object;
            this._postSet(28, bl, this._WSATIssuedTokenEnabled);
            return;
        }
        if (string.equals("WSATTransportSecurityMode")) {
            String string4 = this._WSATTransportSecurityMode;
            this._WSATTransportSecurityMode = (String)object;
            this._postSet(27, string4, this._WSATTransportSecurityMode);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AbandonTimeoutSeconds")) {
            return new Integer(this._AbandonTimeoutSeconds);
        }
        if (string.equals("BeforeCompletionIterationLimit")) {
            return new Integer(this._BeforeCompletionIterationLimit);
        }
        if (string.equals("CheckpointIntervalSeconds")) {
            return new Integer(this._CheckpointIntervalSeconds);
        }
        if (string.equals("CompletionTimeoutSeconds")) {
            return new Integer(this._CompletionTimeoutSeconds);
        }
        if (string.equals("ForgetHeuristics")) {
            return new Boolean(this._ForgetHeuristics);
        }
        if (string.equals("MaxResourceRequestsOnServer")) {
            return new Integer(this._MaxResourceRequestsOnServer);
        }
        if (string.equals("MaxResourceUnavailableMillis")) {
            return new Long(this._MaxResourceUnavailableMillis);
        }
        if (string.equals("MaxTransactions")) {
            return new Integer(this._MaxTransactions);
        }
        if (string.equals("MaxTransactionsHealthIntervalMillis")) {
            return new Long(this._MaxTransactionsHealthIntervalMillis);
        }
        if (string.equals("MaxUniqueNameStatistics")) {
            return new Integer(this._MaxUniqueNameStatistics);
        }
        if (string.equals("MaxXACallMillis")) {
            return new Long(this._MaxXACallMillis);
        }
        if (string.equals("MigrationCheckpointIntervalSeconds")) {
            return new Integer(this._MigrationCheckpointIntervalSeconds);
        }
        if (string.equals("ParallelXADispatchPolicy")) {
            return this._ParallelXADispatchPolicy;
        }
        if (string.equals("ParallelXAEnabled")) {
            return new Boolean(this._ParallelXAEnabled);
        }
        if (string.equals("PurgeResourceFromCheckpointIntervalSeconds")) {
            return new Integer(this._PurgeResourceFromCheckpointIntervalSeconds);
        }
        if (string.equals("RecoveryThresholdMillis")) {
            return new Long(this._RecoveryThresholdMillis);
        }
        if (string.equals("SecurityInteropMode")) {
            return this._SecurityInteropMode;
        }
        if (string.equals("SerializeEnlistmentsGCIntervalMillis")) {
            return new Long(this._SerializeEnlistmentsGCIntervalMillis);
        }
        if (string.equals("TimeoutSeconds")) {
            return new Integer(this._TimeoutSeconds);
        }
        if (string.equals("TwoPhaseEnabled")) {
            return new Boolean(this._TwoPhaseEnabled);
        }
        if (string.equals("UnregisterResourceGracePeriod")) {
            return new Integer(this._UnregisterResourceGracePeriod);
        }
        if (string.equals("WSATIssuedTokenEnabled")) {
            return new Boolean(this._WSATIssuedTokenEnabled);
        }
        if (string.equals("WSATTransportSecurityMode")) {
            return this._WSATTransportSecurityMode;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 23: {
                    if (!string.equals("abandon-timeout-seconds")) break;
                    return 8;
                }
                case 33: {
                    if (!string.equals("before-completion-iteration-limit")) break;
                    return 11;
                }
                case 27: {
                    if (string.equals("checkpoint-interval-seconds")) {
                        return 21;
                    }
                    if (!string.equals("parallel-xa-dispatch-policy")) break;
                    return 24;
                }
                case 26: {
                    if (string.equals("completion-timeout-seconds")) {
                        return 9;
                    }
                    if (!string.equals("max-unique-name-statistics")) break;
                    return 13;
                }
                case 17: {
                    if (string.equals("forget-heuristics")) {
                        return 10;
                    }
                    if (!string.equals("two-phase-enabled")) break;
                    return 29;
                }
                case 31: {
                    if (string.equals("max-resource-requests-on-server")) {
                        return 14;
                    }
                    if (!string.equals("max-resource-unavailable-millis")) break;
                    return 16;
                }
                case 16: {
                    if (!string.equals("max-transactions")) break;
                    return 12;
                }
                case 39: {
                    if (string.equals("max-transactions-health-interval-millis")) {
                        return 19;
                    }
                    if (!string.equals("serialize-enlistmentsgc-interval-millis")) break;
                    return 22;
                }
                case 18: {
                    if (!string.equals("max-xa-call-millis")) break;
                    return 15;
                }
                case 37: {
                    if (!string.equals("migration-checkpoint-interval-seconds")) break;
                    return 18;
                }
                case 19: {
                    if (!string.equals("parallel-xa-enabled")) break;
                    return 23;
                }
                case 47: {
                    if (!string.equals("purge-resource-from-checkpoint-interval-seconds")) break;
                    return 20;
                }
                case 25: {
                    if (string.equals("recovery-threshold-millis")) {
                        return 17;
                    }
                    if (!string.equals("wsat-issued-token-enabled")) break;
                    return 28;
                }
                case 21: {
                    if (!string.equals("security-interop-mode")) break;
                    return 26;
                }
                case 15: {
                    if (!string.equals("timeout-seconds")) break;
                    return 7;
                }
                case 32: {
                    if (!string.equals("unregister-resource-grace-period")) break;
                    return 25;
                }
                case 28: {
                    if (!string.equals("wsat-transport-security-mode")) break;
                    return 27;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "abandon-timeout-seconds";
                }
                case 11: {
                    return "before-completion-iteration-limit";
                }
                case 21: {
                    return "checkpoint-interval-seconds";
                }
                case 9: {
                    return "completion-timeout-seconds";
                }
                case 10: {
                    return "forget-heuristics";
                }
                case 14: {
                    return "max-resource-requests-on-server";
                }
                case 16: {
                    return "max-resource-unavailable-millis";
                }
                case 12: {
                    return "max-transactions";
                }
                case 19: {
                    return "max-transactions-health-interval-millis";
                }
                case 13: {
                    return "max-unique-name-statistics";
                }
                case 15: {
                    return "max-xa-call-millis";
                }
                case 18: {
                    return "migration-checkpoint-interval-seconds";
                }
                case 24: {
                    return "parallel-xa-dispatch-policy";
                }
                case 23: {
                    return "parallel-xa-enabled";
                }
                case 20: {
                    return "purge-resource-from-checkpoint-interval-seconds";
                }
                case 17: {
                    return "recovery-threshold-millis";
                }
                case 26: {
                    return "security-interop-mode";
                }
                case 22: {
                    return "serialize-enlistmentsgc-interval-millis";
                }
                case 7: {
                    return "timeout-seconds";
                }
                case 25: {
                    return "unregister-resource-grace-period";
                }
                case 27: {
                    return "wsat-transport-security-mode";
                }
                case 29: {
                    return "two-phase-enabled";
                }
                case 28: {
                    return "wsat-issued-token-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 26: {
                    return true;
                }
                case 27: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private JTAMBeanImpl bean;

        protected Helper(JTAMBeanImpl jTAMBeanImpl) {
            super(jTAMBeanImpl);
            this.bean = jTAMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "AbandonTimeoutSeconds";
                }
                case 11: {
                    return "BeforeCompletionIterationLimit";
                }
                case 21: {
                    return "CheckpointIntervalSeconds";
                }
                case 9: {
                    return "CompletionTimeoutSeconds";
                }
                case 10: {
                    return "ForgetHeuristics";
                }
                case 14: {
                    return "MaxResourceRequestsOnServer";
                }
                case 16: {
                    return "MaxResourceUnavailableMillis";
                }
                case 12: {
                    return "MaxTransactions";
                }
                case 19: {
                    return "MaxTransactionsHealthIntervalMillis";
                }
                case 13: {
                    return "MaxUniqueNameStatistics";
                }
                case 15: {
                    return "MaxXACallMillis";
                }
                case 18: {
                    return "MigrationCheckpointIntervalSeconds";
                }
                case 24: {
                    return "ParallelXADispatchPolicy";
                }
                case 23: {
                    return "ParallelXAEnabled";
                }
                case 20: {
                    return "PurgeResourceFromCheckpointIntervalSeconds";
                }
                case 17: {
                    return "RecoveryThresholdMillis";
                }
                case 26: {
                    return "SecurityInteropMode";
                }
                case 22: {
                    return "SerializeEnlistmentsGCIntervalMillis";
                }
                case 7: {
                    return "TimeoutSeconds";
                }
                case 25: {
                    return "UnregisterResourceGracePeriod";
                }
                case 27: {
                    return "WSATTransportSecurityMode";
                }
                case 29: {
                    return "TwoPhaseEnabled";
                }
                case 28: {
                    return "WSATIssuedTokenEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AbandonTimeoutSeconds")) {
                return 8;
            }
            if (string.equals("BeforeCompletionIterationLimit")) {
                return 11;
            }
            if (string.equals("CheckpointIntervalSeconds")) {
                return 21;
            }
            if (string.equals("CompletionTimeoutSeconds")) {
                return 9;
            }
            if (string.equals("ForgetHeuristics")) {
                return 10;
            }
            if (string.equals("MaxResourceRequestsOnServer")) {
                return 14;
            }
            if (string.equals("MaxResourceUnavailableMillis")) {
                return 16;
            }
            if (string.equals("MaxTransactions")) {
                return 12;
            }
            if (string.equals("MaxTransactionsHealthIntervalMillis")) {
                return 19;
            }
            if (string.equals("MaxUniqueNameStatistics")) {
                return 13;
            }
            if (string.equals("MaxXACallMillis")) {
                return 15;
            }
            if (string.equals("MigrationCheckpointIntervalSeconds")) {
                return 18;
            }
            if (string.equals("ParallelXADispatchPolicy")) {
                return 24;
            }
            if (string.equals("ParallelXAEnabled")) {
                return 23;
            }
            if (string.equals("PurgeResourceFromCheckpointIntervalSeconds")) {
                return 20;
            }
            if (string.equals("RecoveryThresholdMillis")) {
                return 17;
            }
            if (string.equals("SecurityInteropMode")) {
                return 26;
            }
            if (string.equals("SerializeEnlistmentsGCIntervalMillis")) {
                return 22;
            }
            if (string.equals("TimeoutSeconds")) {
                return 7;
            }
            if (string.equals("UnregisterResourceGracePeriod")) {
                return 25;
            }
            if (string.equals("WSATTransportSecurityMode")) {
                return 27;
            }
            if (string.equals("TwoPhaseEnabled")) {
                return 29;
            }
            if (string.equals("WSATIssuedTokenEnabled")) {
                return 28;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAbandonTimeoutSecondsSet()) {
                    stringBuffer.append("AbandonTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getAbandonTimeoutSeconds()));
                }
                if (this.bean.isBeforeCompletionIterationLimitSet()) {
                    stringBuffer.append("BeforeCompletionIterationLimit");
                    stringBuffer.append(String.valueOf(this.bean.getBeforeCompletionIterationLimit()));
                }
                if (this.bean.isCheckpointIntervalSecondsSet()) {
                    stringBuffer.append("CheckpointIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getCheckpointIntervalSeconds()));
                }
                if (this.bean.isCompletionTimeoutSecondsSet()) {
                    stringBuffer.append("CompletionTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getCompletionTimeoutSeconds()));
                }
                if (this.bean.isForgetHeuristicsSet()) {
                    stringBuffer.append("ForgetHeuristics");
                    stringBuffer.append(String.valueOf(this.bean.getForgetHeuristics()));
                }
                if (this.bean.isMaxResourceRequestsOnServerSet()) {
                    stringBuffer.append("MaxResourceRequestsOnServer");
                    stringBuffer.append(String.valueOf(this.bean.getMaxResourceRequestsOnServer()));
                }
                if (this.bean.isMaxResourceUnavailableMillisSet()) {
                    stringBuffer.append("MaxResourceUnavailableMillis");
                    stringBuffer.append(String.valueOf(this.bean.getMaxResourceUnavailableMillis()));
                }
                if (this.bean.isMaxTransactionsSet()) {
                    stringBuffer.append("MaxTransactions");
                    stringBuffer.append(String.valueOf(this.bean.getMaxTransactions()));
                }
                if (this.bean.isMaxTransactionsHealthIntervalMillisSet()) {
                    stringBuffer.append("MaxTransactionsHealthIntervalMillis");
                    stringBuffer.append(String.valueOf(this.bean.getMaxTransactionsHealthIntervalMillis()));
                }
                if (this.bean.isMaxUniqueNameStatisticsSet()) {
                    stringBuffer.append("MaxUniqueNameStatistics");
                    stringBuffer.append(String.valueOf(this.bean.getMaxUniqueNameStatistics()));
                }
                if (this.bean.isMaxXACallMillisSet()) {
                    stringBuffer.append("MaxXACallMillis");
                    stringBuffer.append(String.valueOf(this.bean.getMaxXACallMillis()));
                }
                if (this.bean.isMigrationCheckpointIntervalSecondsSet()) {
                    stringBuffer.append("MigrationCheckpointIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getMigrationCheckpointIntervalSeconds()));
                }
                if (this.bean.isParallelXADispatchPolicySet()) {
                    stringBuffer.append("ParallelXADispatchPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getParallelXADispatchPolicy()));
                }
                if (this.bean.isParallelXAEnabledSet()) {
                    stringBuffer.append("ParallelXAEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getParallelXAEnabled()));
                }
                if (this.bean.isPurgeResourceFromCheckpointIntervalSecondsSet()) {
                    stringBuffer.append("PurgeResourceFromCheckpointIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getPurgeResourceFromCheckpointIntervalSeconds()));
                }
                if (this.bean.isRecoveryThresholdMillisSet()) {
                    stringBuffer.append("RecoveryThresholdMillis");
                    stringBuffer.append(String.valueOf(this.bean.getRecoveryThresholdMillis()));
                }
                if (this.bean.isSecurityInteropModeSet()) {
                    stringBuffer.append("SecurityInteropMode");
                    stringBuffer.append(String.valueOf(this.bean.getSecurityInteropMode()));
                }
                if (this.bean.isSerializeEnlistmentsGCIntervalMillisSet()) {
                    stringBuffer.append("SerializeEnlistmentsGCIntervalMillis");
                    stringBuffer.append(String.valueOf(this.bean.getSerializeEnlistmentsGCIntervalMillis()));
                }
                if (this.bean.isTimeoutSecondsSet()) {
                    stringBuffer.append("TimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getTimeoutSeconds()));
                }
                if (this.bean.isUnregisterResourceGracePeriodSet()) {
                    stringBuffer.append("UnregisterResourceGracePeriod");
                    stringBuffer.append(String.valueOf(this.bean.getUnregisterResourceGracePeriod()));
                }
                if (this.bean.isWSATTransportSecurityModeSet()) {
                    stringBuffer.append("WSATTransportSecurityMode");
                    stringBuffer.append(String.valueOf(this.bean.getWSATTransportSecurityMode()));
                }
                if (this.bean.isTwoPhaseEnabledSet()) {
                    stringBuffer.append("TwoPhaseEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isTwoPhaseEnabled()));
                }
                if (this.bean.isWSATIssuedTokenEnabledSet()) {
                    stringBuffer.append("WSATIssuedTokenEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isWSATIssuedTokenEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JTAMBeanImpl jTAMBeanImpl = (JTAMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AbandonTimeoutSeconds", this.bean.getAbandonTimeoutSeconds(), jTAMBeanImpl.getAbandonTimeoutSeconds(), true);
                this.computeDiff("BeforeCompletionIterationLimit", this.bean.getBeforeCompletionIterationLimit(), jTAMBeanImpl.getBeforeCompletionIterationLimit(), true);
                this.computeDiff("CheckpointIntervalSeconds", this.bean.getCheckpointIntervalSeconds(), jTAMBeanImpl.getCheckpointIntervalSeconds(), true);
                this.computeDiff("CompletionTimeoutSeconds", this.bean.getCompletionTimeoutSeconds(), jTAMBeanImpl.getCompletionTimeoutSeconds(), true);
                this.computeDiff("ForgetHeuristics", this.bean.getForgetHeuristics(), jTAMBeanImpl.getForgetHeuristics(), true);
                this.computeDiff("MaxResourceRequestsOnServer", this.bean.getMaxResourceRequestsOnServer(), jTAMBeanImpl.getMaxResourceRequestsOnServer(), true);
                this.computeDiff("MaxResourceUnavailableMillis", this.bean.getMaxResourceUnavailableMillis(), jTAMBeanImpl.getMaxResourceUnavailableMillis(), true);
                this.computeDiff("MaxTransactions", this.bean.getMaxTransactions(), jTAMBeanImpl.getMaxTransactions(), true);
                this.computeDiff("MaxTransactionsHealthIntervalMillis", this.bean.getMaxTransactionsHealthIntervalMillis(), jTAMBeanImpl.getMaxTransactionsHealthIntervalMillis(), true);
                this.computeDiff("MaxUniqueNameStatistics", this.bean.getMaxUniqueNameStatistics(), jTAMBeanImpl.getMaxUniqueNameStatistics(), true);
                this.computeDiff("MaxXACallMillis", this.bean.getMaxXACallMillis(), jTAMBeanImpl.getMaxXACallMillis(), true);
                this.computeDiff("MigrationCheckpointIntervalSeconds", this.bean.getMigrationCheckpointIntervalSeconds(), jTAMBeanImpl.getMigrationCheckpointIntervalSeconds(), true);
                this.computeDiff("ParallelXADispatchPolicy", this.bean.getParallelXADispatchPolicy(), jTAMBeanImpl.getParallelXADispatchPolicy(), true);
                this.computeDiff("ParallelXAEnabled", this.bean.getParallelXAEnabled(), jTAMBeanImpl.getParallelXAEnabled(), true);
                this.computeDiff("PurgeResourceFromCheckpointIntervalSeconds", this.bean.getPurgeResourceFromCheckpointIntervalSeconds(), jTAMBeanImpl.getPurgeResourceFromCheckpointIntervalSeconds(), true);
                this.computeDiff("RecoveryThresholdMillis", this.bean.getRecoveryThresholdMillis(), jTAMBeanImpl.getRecoveryThresholdMillis(), true);
                this.computeDiff("SecurityInteropMode", this.bean.getSecurityInteropMode(), jTAMBeanImpl.getSecurityInteropMode(), false);
                this.computeDiff("SerializeEnlistmentsGCIntervalMillis", this.bean.getSerializeEnlistmentsGCIntervalMillis(), jTAMBeanImpl.getSerializeEnlistmentsGCIntervalMillis(), true);
                this.computeDiff("TimeoutSeconds", this.bean.getTimeoutSeconds(), jTAMBeanImpl.getTimeoutSeconds(), true);
                this.computeDiff("UnregisterResourceGracePeriod", this.bean.getUnregisterResourceGracePeriod(), jTAMBeanImpl.getUnregisterResourceGracePeriod(), true);
                this.computeDiff("WSATTransportSecurityMode", this.bean.getWSATTransportSecurityMode(), jTAMBeanImpl.getWSATTransportSecurityMode(), false);
                this.computeDiff("TwoPhaseEnabled", this.bean.isTwoPhaseEnabled(), jTAMBeanImpl.isTwoPhaseEnabled(), false);
                this.computeDiff("WSATIssuedTokenEnabled", this.bean.isWSATIssuedTokenEnabled(), jTAMBeanImpl.isWSATIssuedTokenEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JTAMBeanImpl jTAMBeanImpl = (JTAMBeanImpl)beanUpdateEvent.getSourceBean();
                JTAMBeanImpl jTAMBeanImpl2 = (JTAMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AbandonTimeoutSeconds")) {
                    jTAMBeanImpl.setAbandonTimeoutSeconds(jTAMBeanImpl2.getAbandonTimeoutSeconds());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("BeforeCompletionIterationLimit")) {
                    jTAMBeanImpl.setBeforeCompletionIterationLimit(jTAMBeanImpl2.getBeforeCompletionIterationLimit());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("CheckpointIntervalSeconds")) {
                    jTAMBeanImpl.setCheckpointIntervalSeconds(jTAMBeanImpl2.getCheckpointIntervalSeconds());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("CompletionTimeoutSeconds")) {
                    jTAMBeanImpl.setCompletionTimeoutSeconds(jTAMBeanImpl2.getCompletionTimeoutSeconds());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ForgetHeuristics")) {
                    jTAMBeanImpl.setForgetHeuristics(jTAMBeanImpl2.getForgetHeuristics());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("MaxResourceRequestsOnServer")) {
                    jTAMBeanImpl.setMaxResourceRequestsOnServer(jTAMBeanImpl2.getMaxResourceRequestsOnServer());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("MaxResourceUnavailableMillis")) {
                    jTAMBeanImpl.setMaxResourceUnavailableMillis(jTAMBeanImpl2.getMaxResourceUnavailableMillis());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("MaxTransactions")) {
                    jTAMBeanImpl.setMaxTransactions(jTAMBeanImpl2.getMaxTransactions());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("MaxTransactionsHealthIntervalMillis")) {
                    jTAMBeanImpl.setMaxTransactionsHealthIntervalMillis(jTAMBeanImpl2.getMaxTransactionsHealthIntervalMillis());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("MaxUniqueNameStatistics")) {
                    jTAMBeanImpl.setMaxUniqueNameStatistics(jTAMBeanImpl2.getMaxUniqueNameStatistics());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("MaxXACallMillis")) {
                    jTAMBeanImpl.setMaxXACallMillis(jTAMBeanImpl2.getMaxXACallMillis());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("MigrationCheckpointIntervalSeconds")) {
                    jTAMBeanImpl.setMigrationCheckpointIntervalSeconds(jTAMBeanImpl2.getMigrationCheckpointIntervalSeconds());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("ParallelXADispatchPolicy")) {
                    jTAMBeanImpl.setParallelXADispatchPolicy(jTAMBeanImpl2.getParallelXADispatchPolicy());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("ParallelXAEnabled")) {
                    jTAMBeanImpl.setParallelXAEnabled(jTAMBeanImpl2.getParallelXAEnabled());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("PurgeResourceFromCheckpointIntervalSeconds")) {
                    jTAMBeanImpl.setPurgeResourceFromCheckpointIntervalSeconds(jTAMBeanImpl2.getPurgeResourceFromCheckpointIntervalSeconds());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("RecoveryThresholdMillis")) {
                    jTAMBeanImpl.setRecoveryThresholdMillis(jTAMBeanImpl2.getRecoveryThresholdMillis());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("SecurityInteropMode")) {
                    jTAMBeanImpl.setSecurityInteropMode(jTAMBeanImpl2.getSecurityInteropMode());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("SerializeEnlistmentsGCIntervalMillis")) {
                    jTAMBeanImpl.setSerializeEnlistmentsGCIntervalMillis(jTAMBeanImpl2.getSerializeEnlistmentsGCIntervalMillis());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("TimeoutSeconds")) {
                    jTAMBeanImpl.setTimeoutSeconds(jTAMBeanImpl2.getTimeoutSeconds());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("UnregisterResourceGracePeriod")) {
                    jTAMBeanImpl.setUnregisterResourceGracePeriod(jTAMBeanImpl2.getUnregisterResourceGracePeriod());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("WSATTransportSecurityMode")) {
                    jTAMBeanImpl.setWSATTransportSecurityMode(jTAMBeanImpl2.getWSATTransportSecurityMode());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("TwoPhaseEnabled")) {
                    jTAMBeanImpl.setTwoPhaseEnabled(jTAMBeanImpl2.isTwoPhaseEnabled());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("WSATIssuedTokenEnabled")) {
                    jTAMBeanImpl.setWSATIssuedTokenEnabled(jTAMBeanImpl2.isWSATIssuedTokenEnabled());
                    jTAMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JTAMBeanImpl jTAMBeanImpl = (JTAMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jTAMBeanImpl, bl, list);
                if ((list == null || !list.contains("AbandonTimeoutSeconds")) && this.bean.isAbandonTimeoutSecondsSet()) {
                    jTAMBeanImpl.setAbandonTimeoutSeconds(this.bean.getAbandonTimeoutSeconds());
                }
                if ((list == null || !list.contains("BeforeCompletionIterationLimit")) && this.bean.isBeforeCompletionIterationLimitSet()) {
                    jTAMBeanImpl.setBeforeCompletionIterationLimit(this.bean.getBeforeCompletionIterationLimit());
                }
                if ((list == null || !list.contains("CheckpointIntervalSeconds")) && this.bean.isCheckpointIntervalSecondsSet()) {
                    jTAMBeanImpl.setCheckpointIntervalSeconds(this.bean.getCheckpointIntervalSeconds());
                }
                if ((list == null || !list.contains("CompletionTimeoutSeconds")) && this.bean.isCompletionTimeoutSecondsSet()) {
                    jTAMBeanImpl.setCompletionTimeoutSeconds(this.bean.getCompletionTimeoutSeconds());
                }
                if ((list == null || !list.contains("ForgetHeuristics")) && this.bean.isForgetHeuristicsSet()) {
                    jTAMBeanImpl.setForgetHeuristics(this.bean.getForgetHeuristics());
                }
                if ((list == null || !list.contains("MaxResourceRequestsOnServer")) && this.bean.isMaxResourceRequestsOnServerSet()) {
                    jTAMBeanImpl.setMaxResourceRequestsOnServer(this.bean.getMaxResourceRequestsOnServer());
                }
                if ((list == null || !list.contains("MaxResourceUnavailableMillis")) && this.bean.isMaxResourceUnavailableMillisSet()) {
                    jTAMBeanImpl.setMaxResourceUnavailableMillis(this.bean.getMaxResourceUnavailableMillis());
                }
                if ((list == null || !list.contains("MaxTransactions")) && this.bean.isMaxTransactionsSet()) {
                    jTAMBeanImpl.setMaxTransactions(this.bean.getMaxTransactions());
                }
                if ((list == null || !list.contains("MaxTransactionsHealthIntervalMillis")) && this.bean.isMaxTransactionsHealthIntervalMillisSet()) {
                    jTAMBeanImpl.setMaxTransactionsHealthIntervalMillis(this.bean.getMaxTransactionsHealthIntervalMillis());
                }
                if ((list == null || !list.contains("MaxUniqueNameStatistics")) && this.bean.isMaxUniqueNameStatisticsSet()) {
                    jTAMBeanImpl.setMaxUniqueNameStatistics(this.bean.getMaxUniqueNameStatistics());
                }
                if ((list == null || !list.contains("MaxXACallMillis")) && this.bean.isMaxXACallMillisSet()) {
                    jTAMBeanImpl.setMaxXACallMillis(this.bean.getMaxXACallMillis());
                }
                if ((list == null || !list.contains("MigrationCheckpointIntervalSeconds")) && this.bean.isMigrationCheckpointIntervalSecondsSet()) {
                    jTAMBeanImpl.setMigrationCheckpointIntervalSeconds(this.bean.getMigrationCheckpointIntervalSeconds());
                }
                if ((list == null || !list.contains("ParallelXADispatchPolicy")) && this.bean.isParallelXADispatchPolicySet()) {
                    jTAMBeanImpl.setParallelXADispatchPolicy(this.bean.getParallelXADispatchPolicy());
                }
                if ((list == null || !list.contains("ParallelXAEnabled")) && this.bean.isParallelXAEnabledSet()) {
                    jTAMBeanImpl.setParallelXAEnabled(this.bean.getParallelXAEnabled());
                }
                if ((list == null || !list.contains("PurgeResourceFromCheckpointIntervalSeconds")) && this.bean.isPurgeResourceFromCheckpointIntervalSecondsSet()) {
                    jTAMBeanImpl.setPurgeResourceFromCheckpointIntervalSeconds(this.bean.getPurgeResourceFromCheckpointIntervalSeconds());
                }
                if ((list == null || !list.contains("RecoveryThresholdMillis")) && this.bean.isRecoveryThresholdMillisSet()) {
                    jTAMBeanImpl.setRecoveryThresholdMillis(this.bean.getRecoveryThresholdMillis());
                }
                if ((list == null || !list.contains("SecurityInteropMode")) && this.bean.isSecurityInteropModeSet()) {
                    jTAMBeanImpl.setSecurityInteropMode(this.bean.getSecurityInteropMode());
                }
                if ((list == null || !list.contains("SerializeEnlistmentsGCIntervalMillis")) && this.bean.isSerializeEnlistmentsGCIntervalMillisSet()) {
                    jTAMBeanImpl.setSerializeEnlistmentsGCIntervalMillis(this.bean.getSerializeEnlistmentsGCIntervalMillis());
                }
                if ((list == null || !list.contains("TimeoutSeconds")) && this.bean.isTimeoutSecondsSet()) {
                    jTAMBeanImpl.setTimeoutSeconds(this.bean.getTimeoutSeconds());
                }
                if ((list == null || !list.contains("UnregisterResourceGracePeriod")) && this.bean.isUnregisterResourceGracePeriodSet()) {
                    jTAMBeanImpl.setUnregisterResourceGracePeriod(this.bean.getUnregisterResourceGracePeriod());
                }
                if ((list == null || !list.contains("WSATTransportSecurityMode")) && this.bean.isWSATTransportSecurityModeSet()) {
                    jTAMBeanImpl.setWSATTransportSecurityMode(this.bean.getWSATTransportSecurityMode());
                }
                if ((list == null || !list.contains("TwoPhaseEnabled")) && this.bean.isTwoPhaseEnabledSet()) {
                    jTAMBeanImpl.setTwoPhaseEnabled(this.bean.isTwoPhaseEnabled());
                }
                if ((list == null || !list.contains("WSATIssuedTokenEnabled")) && this.bean.isWSATIssuedTokenEnabledSet()) {
                    jTAMBeanImpl.setWSATIssuedTokenEnabled(this.bean.isWSATIssuedTokenEnabled());
                }
                return jTAMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

