/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.cluster.migration.MTCustomValidator;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBeanImpl;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerMBeanImpl;
import weblogic.management.mbeans.custom.JTAMigratableTarget;
import weblogic.transaction.internal.JTAMTCustomValidator;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JTAMigratableTargetMBeanImpl
extends MigratableTargetMBeanImpl
implements JTAMigratableTargetMBean,
Serializable {
    private ServerMBean[] _AllCandidateServers;
    private ClusterMBean _Cluster;
    private ServerMBean[] _ConstrainedCandidateServers;
    private ServerMBean _HostingServer;
    private String _MigrationPolicy;
    private String _Name;
    private Set _ServerNames;
    private boolean _StrictOwnershipCheck;
    private ServerMBean _UserPreferredServer;
    private JTAMigratableTarget _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JTAMigratableTargetMBeanImpl() {
        try {
            this._customizer = new JTAMigratableTarget(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JTAMigratableTargetMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JTAMigratableTarget(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ServerMBean[] getConstrainedCandidateServers() {
        return this._customizer.getConstrainedCandidateServers();
    }

    public String getConstrainedCandidateServersAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getConstrainedCandidateServers());
    }

    public ServerMBean getHostingServer() {
        return this._customizer.getHostingServer();
    }

    public String getHostingServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getHostingServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public Set getServerNames() {
        return this._customizer.getServerNames();
    }

    public boolean isConstrainedCandidateServersSet() {
        return this._isSet(12);
    }

    public boolean isHostingServerSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isServerNamesSet() {
        return this._isSet(11);
    }

    public void setConstrainedCandidateServersAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean[] serverMBeanArray = this._ConstrainedCandidateServers;
            this._initializeProperty(12);
            this._postSet(12, serverMBeanArray, this._ConstrainedCandidateServers);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._ConstrainedCandidateServers);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, ServerMBean.class, new ReferenceManager.Resolver(this, 12){

                    public void resolveReference(Object object) {
                        try {
                            JTAMigratableTargetMBeanImpl.this.addConstrainedCandidateServer((ServerMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (ServerMBean serverMBean : this._ConstrainedCandidateServers) {
                    if (!string2.equals(serverMBean.getName())) continue;
                    try {
                        this.removeConstrainedCandidateServer(serverMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setHostingServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._HostingServer;
            this._initializeProperty(7);
            this._postSet(7, serverMBean, this._HostingServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 7){

                public void resolveReference(Object object) {
                    try {
                        JTAMigratableTargetMBeanImpl.this.setHostingServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setServerNames(Set set) throws InvalidAttributeValueException {
        this._ServerNames = set;
    }

    public void setConstrainedCandidateServers(ServerMBean[] serverMBeanArray) throws InvalidAttributeValueException {
        serverMBeanArray = serverMBeanArray == null ? new ServerMBeanImpl[]{} : serverMBeanArray;
        serverMBeanArray = (ServerMBean[])this._getHelper()._cleanAndValidateArray((Object)serverMBeanArray, ServerMBean.class);
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (serverMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 12, (AbstractDescriptorBean)serverMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JTAMigratableTargetMBeanImpl.this.getConstrainedCandidateServers();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBeanArray[i], resolvedReference);
        }
        ServerMBean[] serverMBeanArray2 = this.getConstrainedCandidateServers();
        this._customizer.setConstrainedCandidateServers(serverMBeanArray);
        this._postSet(12, serverMBeanArray2, serverMBeanArray);
    }

    public void setHostingServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 7, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return JTAMigratableTargetMBeanImpl.this.getHostingServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this._HostingServer;
        this._HostingServer = serverMBean;
        this._postSet(7, serverMBean2, serverMBean);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public boolean addConstrainedCandidateServer(ServerMBean serverMBean) throws InvalidAttributeValueException {
        this._getHelper()._ensureNonNull((Object)serverMBean);
        if (!((AbstractDescriptorBean)serverMBean).isChildProperty((DescriptorBean)this, 12)) {
            ServerMBean[] serverMBeanArray = (ServerMBean[])this._getHelper()._extendArray((Object)this.getConstrainedCandidateServers(), ServerMBean.class, (Object)serverMBean);
            try {
                this.setConstrainedCandidateServers(serverMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public ServerMBean getUserPreferredServer() {
        return this._customizer.getUserPreferredServer();
    }

    public String getUserPreferredServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getUserPreferredServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isUserPreferredServerSet() {
        return this._isSet(8);
    }

    public void setUserPreferredServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._UserPreferredServer;
            this._initializeProperty(8);
            this._postSet(8, serverMBean, this._UserPreferredServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 8){

                public void resolveReference(Object object) {
                    try {
                        JTAMigratableTargetMBeanImpl.this.setUserPreferredServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public boolean isStrictOwnershipCheck() {
        return this._StrictOwnershipCheck;
    }

    public boolean isStrictOwnershipCheckSet() {
        return this._isSet(24);
    }

    public boolean removeConstrainedCandidateServer(ServerMBean serverMBean) throws InvalidAttributeValueException {
        ServerMBean[] serverMBeanArray = this.getConstrainedCandidateServers();
        ServerMBean[] serverMBeanArray2 = (ServerMBean[])this._getHelper()._removeElement((Object)serverMBeanArray, ServerMBean.class, (Object)serverMBean);
        if (serverMBeanArray2.length != serverMBeanArray.length) {
            try {
                this.setConstrainedCandidateServers(serverMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setUserPreferredServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        JTAMTCustomValidator.validateUserPreferredServer(this, serverMBean);
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 8, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return JTAMigratableTargetMBeanImpl.this.getUserPreferredServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this.getUserPreferredServer();
        this._customizer.setUserPreferredServer(serverMBean);
        this._postSet(8, serverMBean2, serverMBean);
    }

    public void setStrictOwnershipCheck(boolean bl) {
        boolean bl2 = this._StrictOwnershipCheck;
        this._StrictOwnershipCheck = bl;
        this._postSet(24, bl2, bl);
    }

    public ClusterMBean getCluster() {
        return this._customizer.getCluster();
    }

    public String getClusterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getCluster();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isClusterSet() {
        return this._isSet(13);
    }

    public void setClusterAsString(String string) {
        if (string == null || string.length() == 0) {
            ClusterMBean clusterMBean = this._Cluster;
            this._initializeProperty(13);
            this._postSet(13, clusterMBean, this._Cluster);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ClusterMBean.class, new ReferenceManager.Resolver(this, 13){

                public void resolveReference(Object object) {
                    try {
                        JTAMigratableTargetMBeanImpl.this.setCluster((ClusterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setCluster(ClusterMBean clusterMBean) {
        ClusterMBean clusterMBean2;
        if (clusterMBean != null) {
            clusterMBean2 = new ResolvedReference(this, 13, (AbstractDescriptorBean)clusterMBean){

                protected Object getPropertyValue() {
                    return JTAMigratableTargetMBeanImpl.this.getCluster();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)clusterMBean, (ResolvedReference)clusterMBean2);
        }
        clusterMBean2 = this._Cluster;
        this._Cluster = clusterMBean;
        this._postSet(13, clusterMBean2, clusterMBean);
    }

    public void addAllCandidateServer(ServerMBean serverMBean) {
        this._getHelper()._ensureNonNull((Object)serverMBean);
        if (!((AbstractDescriptorBean)serverMBean).isChildProperty((DescriptorBean)this, 14)) {
            ServerMBean[] serverMBeanArray = (ServerMBean[])this._getHelper()._extendArray((Object)this.getAllCandidateServers(), ServerMBean.class, (Object)serverMBean);
            try {
                this.setAllCandidateServers(serverMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ServerMBean[] getAllCandidateServers() {
        return this._customizer.getAllCandidateServers();
    }

    public boolean isAllCandidateServersSet() {
        return this._isSet(14);
    }

    public void removeAllCandidateServer(ServerMBean serverMBean) {
        ServerMBean[] serverMBeanArray = this.getAllCandidateServers();
        ServerMBean[] serverMBeanArray2 = (ServerMBean[])this._getHelper()._removeElement((Object)serverMBeanArray, ServerMBean.class, (Object)serverMBean);
        if (serverMBeanArray2.length != serverMBeanArray.length) {
            try {
                this.setAllCandidateServers(serverMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setAllCandidateServers(ServerMBean[] serverMBeanArray) {
        serverMBeanArray = serverMBeanArray == null ? new ServerMBeanImpl[]{} : serverMBeanArray;
        this._AllCandidateServers = serverMBeanArray;
    }

    public boolean isManualActiveOn(ServerMBean serverMBean) {
        return this._customizer.isManualActiveOn(serverMBean);
    }

    public boolean isCandidate(ServerMBean serverMBean) {
        return this._customizer.isCandidate(serverMBean);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public String getMigrationPolicy() {
        return this._MigrationPolicy;
    }

    public boolean isMigrationPolicySet() {
        return this._isSet(16);
    }

    public void setMigrationPolicy(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"manual", "failure-recovery"};
        string = LegalChecks.checkInEnum((String)"MigrationPolicy", (String)string, (String[])stringArray);
        MTCustomValidator.validateMigrationPolicy(this, string);
        String string2 = this._MigrationPolicy;
        this._MigrationPolicy = string;
        this._postSet(16, string2, string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        MTCustomValidator.validateMigratableTarget(this);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 14;
        }
        try {
            switch (n) {
                case 14: {
                    this._AllCandidateServers = new ServerMBean[0];
                    if (bl) break;
                }
                case 13: {
                    this._Cluster = null;
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setConstrainedCandidateServers(new ServerMBean[0]);
                    if (bl) break;
                }
                case 7: {
                    this._HostingServer = null;
                    if (bl) break;
                }
                case 16: {
                    this._MigrationPolicy = "manual";
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 11: {
                    this._ServerNames = null;
                    if (bl) break;
                }
                case 8: {
                    this._customizer.setUserPreferredServer(null);
                    if (bl) break;
                }
                case 24: {
                    this._StrictOwnershipCheck = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JTAMigratableTarget";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AllCandidateServers")) {
            ServerMBean[] serverMBeanArray = this._AllCandidateServers;
            this._AllCandidateServers = (ServerMBean[])object;
            this._postSet(14, serverMBeanArray, this._AllCandidateServers);
            return;
        }
        if (string.equals("Cluster")) {
            ClusterMBean clusterMBean = this._Cluster;
            this._Cluster = (ClusterMBean)object;
            this._postSet(13, clusterMBean, this._Cluster);
            return;
        }
        if (string.equals("ConstrainedCandidateServers")) {
            ServerMBean[] serverMBeanArray = this._ConstrainedCandidateServers;
            this._ConstrainedCandidateServers = (ServerMBean[])object;
            this._postSet(12, serverMBeanArray, this._ConstrainedCandidateServers);
            return;
        }
        if (string.equals("HostingServer")) {
            ServerMBean serverMBean = this._HostingServer;
            this._HostingServer = (ServerMBean)object;
            this._postSet(7, serverMBean, this._HostingServer);
            return;
        }
        if (string.equals("MigrationPolicy")) {
            String string2 = this._MigrationPolicy;
            this._MigrationPolicy = (String)object;
            this._postSet(16, string2, this._MigrationPolicy);
            return;
        }
        if (string.equals("Name")) {
            String string3 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string3, this._Name);
            return;
        }
        if (string.equals("ServerNames")) {
            Set set = this._ServerNames;
            this._ServerNames = (Set)object;
            this._postSet(11, set, this._ServerNames);
            return;
        }
        if (string.equals("StrictOwnershipCheck")) {
            boolean bl = this._StrictOwnershipCheck;
            this._StrictOwnershipCheck = (Boolean)object;
            this._postSet(24, bl, this._StrictOwnershipCheck);
            return;
        }
        if (string.equals("UserPreferredServer")) {
            ServerMBean serverMBean = this._UserPreferredServer;
            this._UserPreferredServer = (ServerMBean)object;
            this._postSet(8, serverMBean, this._UserPreferredServer);
            return;
        }
        if (string.equals("customizer")) {
            JTAMigratableTarget jTAMigratableTarget = this._customizer;
            this._customizer = (JTAMigratableTarget)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AllCandidateServers")) {
            return this._AllCandidateServers;
        }
        if (string.equals("Cluster")) {
            return this._Cluster;
        }
        if (string.equals("ConstrainedCandidateServers")) {
            return this._ConstrainedCandidateServers;
        }
        if (string.equals("HostingServer")) {
            return this._HostingServer;
        }
        if (string.equals("MigrationPolicy")) {
            return this._MigrationPolicy;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("ServerNames")) {
            return this._ServerNames;
        }
        if (string.equals("StrictOwnershipCheck")) {
            return new Boolean(this._StrictOwnershipCheck);
        }
        if (string.equals("UserPreferredServer")) {
            return this._UserPreferredServer;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends MigratableTargetMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (!string.equals("all-candidate-server")) break;
                    return 14;
                }
                case 7: {
                    if (!string.equals("cluster")) break;
                    return 13;
                }
                case 28: {
                    if (!string.equals("constrained-candidate-server")) break;
                    return 12;
                }
                case 14: {
                    if (!string.equals("hosting-server")) break;
                    return 7;
                }
                case 16: {
                    if (!string.equals("migration-policy")) break;
                    return 16;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 12: {
                    if (!string.equals("server-names")) break;
                    return 11;
                }
                case 21: {
                    if (!string.equals("user-preferred-server")) break;
                    return 8;
                }
                case 22: {
                    if (!string.equals("strict-ownership-check")) break;
                    return 24;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 14: {
                    return "all-candidate-server";
                }
                case 13: {
                    return "cluster";
                }
                case 12: {
                    return "constrained-candidate-server";
                }
                case 7: {
                    return "hosting-server";
                }
                case 16: {
                    return "migration-policy";
                }
                case 2: {
                    return "name";
                }
                case 11: {
                    return "server-names";
                }
                case 8: {
                    return "user-preferred-server";
                }
                case 24: {
                    return "strict-ownership-check";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends MigratableTargetMBeanImpl.Helper {
        private JTAMigratableTargetMBeanImpl bean;

        protected Helper(JTAMigratableTargetMBeanImpl jTAMigratableTargetMBeanImpl) {
            super(jTAMigratableTargetMBeanImpl);
            this.bean = jTAMigratableTargetMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 14: {
                    return "AllCandidateServers";
                }
                case 13: {
                    return "Cluster";
                }
                case 12: {
                    return "ConstrainedCandidateServers";
                }
                case 7: {
                    return "HostingServer";
                }
                case 16: {
                    return "MigrationPolicy";
                }
                case 2: {
                    return "Name";
                }
                case 11: {
                    return "ServerNames";
                }
                case 8: {
                    return "UserPreferredServer";
                }
                case 24: {
                    return "StrictOwnershipCheck";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AllCandidateServers")) {
                return 14;
            }
            if (string.equals("Cluster")) {
                return 13;
            }
            if (string.equals("ConstrainedCandidateServers")) {
                return 12;
            }
            if (string.equals("HostingServer")) {
                return 7;
            }
            if (string.equals("MigrationPolicy")) {
                return 16;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("ServerNames")) {
                return 11;
            }
            if (string.equals("UserPreferredServer")) {
                return 8;
            }
            if (string.equals("StrictOwnershipCheck")) {
                return 24;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAllCandidateServersSet()) {
                    stringBuffer.append("AllCandidateServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getAllCandidateServers())));
                }
                if (this.bean.isClusterSet()) {
                    stringBuffer.append("Cluster");
                    stringBuffer.append(String.valueOf(this.bean.getCluster()));
                }
                if (this.bean.isConstrainedCandidateServersSet()) {
                    stringBuffer.append("ConstrainedCandidateServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getConstrainedCandidateServers())));
                }
                if (this.bean.isHostingServerSet()) {
                    stringBuffer.append("HostingServer");
                    stringBuffer.append(String.valueOf(this.bean.getHostingServer()));
                }
                if (this.bean.isMigrationPolicySet()) {
                    stringBuffer.append("MigrationPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getMigrationPolicy()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isServerNamesSet()) {
                    stringBuffer.append("ServerNames");
                    stringBuffer.append(String.valueOf(this.bean.getServerNames()));
                }
                if (this.bean.isUserPreferredServerSet()) {
                    stringBuffer.append("UserPreferredServer");
                    stringBuffer.append(String.valueOf(this.bean.getUserPreferredServer()));
                }
                if (this.bean.isStrictOwnershipCheckSet()) {
                    stringBuffer.append("StrictOwnershipCheck");
                    stringBuffer.append(String.valueOf(this.bean.isStrictOwnershipCheck()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JTAMigratableTargetMBeanImpl jTAMigratableTargetMBeanImpl = (JTAMigratableTargetMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Cluster", this.bean.getCluster(), jTAMigratableTargetMBeanImpl.getCluster(), false);
                this.computeDiff("ConstrainedCandidateServers", this.bean.getConstrainedCandidateServers(), jTAMigratableTargetMBeanImpl.getConstrainedCandidateServers(), false);
                this.computeDiff("HostingServer", this.bean.getHostingServer(), jTAMigratableTargetMBeanImpl.getHostingServer(), true);
                this.computeDiff("MigrationPolicy", this.bean.getMigrationPolicy(), jTAMigratableTargetMBeanImpl.getMigrationPolicy(), false);
                this.computeDiff("Name", this.bean.getName(), jTAMigratableTargetMBeanImpl.getName(), false);
                this.computeDiff("UserPreferredServer", this.bean.getUserPreferredServer(), jTAMigratableTargetMBeanImpl.getUserPreferredServer(), true);
                this.computeDiff("StrictOwnershipCheck", this.bean.isStrictOwnershipCheck(), jTAMigratableTargetMBeanImpl.isStrictOwnershipCheck(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JTAMigratableTargetMBeanImpl jTAMigratableTargetMBeanImpl = (JTAMigratableTargetMBeanImpl)beanUpdateEvent.getSourceBean();
                JTAMigratableTargetMBeanImpl jTAMigratableTargetMBeanImpl2 = (JTAMigratableTargetMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("AllCandidateServers")) {
                    if (string.equals("Cluster")) {
                        jTAMigratableTargetMBeanImpl.setClusterAsString(jTAMigratableTargetMBeanImpl2.getClusterAsString());
                        jTAMigratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("ConstrainedCandidateServers")) {
                        jTAMigratableTargetMBeanImpl.setConstrainedCandidateServersAsString(jTAMigratableTargetMBeanImpl2.getConstrainedCandidateServersAsString());
                        jTAMigratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("HostingServer")) {
                        jTAMigratableTargetMBeanImpl.setHostingServerAsString(jTAMigratableTargetMBeanImpl2.getHostingServerAsString());
                        jTAMigratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("MigrationPolicy")) {
                        jTAMigratableTargetMBeanImpl.setMigrationPolicy(jTAMigratableTargetMBeanImpl2.getMigrationPolicy());
                        jTAMigratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("Name")) {
                        jTAMigratableTargetMBeanImpl.setName(jTAMigratableTargetMBeanImpl2.getName());
                        jTAMigratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (!string.equals("ServerNames")) {
                        if (string.equals("UserPreferredServer")) {
                            jTAMigratableTargetMBeanImpl.setUserPreferredServerAsString(jTAMigratableTargetMBeanImpl2.getUserPreferredServerAsString());
                            jTAMigratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                        } else if (string.equals("StrictOwnershipCheck")) {
                            jTAMigratableTargetMBeanImpl.setStrictOwnershipCheck(jTAMigratableTargetMBeanImpl2.isStrictOwnershipCheck());
                            jTAMigratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                        } else {
                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JTAMigratableTargetMBeanImpl jTAMigratableTargetMBeanImpl = (JTAMigratableTargetMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jTAMigratableTargetMBeanImpl, bl, list);
                if ((list == null || !list.contains("Cluster")) && this.bean.isClusterSet()) {
                    jTAMigratableTargetMBeanImpl._unSet(jTAMigratableTargetMBeanImpl, 13);
                    jTAMigratableTargetMBeanImpl.setClusterAsString(this.bean.getClusterAsString());
                }
                if ((list == null || !list.contains("ConstrainedCandidateServers")) && this.bean.isConstrainedCandidateServersSet()) {
                    jTAMigratableTargetMBeanImpl._unSet(jTAMigratableTargetMBeanImpl, 12);
                    jTAMigratableTargetMBeanImpl.setConstrainedCandidateServersAsString(this.bean.getConstrainedCandidateServersAsString());
                }
                if ((list == null || !list.contains("HostingServer")) && this.bean.isHostingServerSet()) {
                    jTAMigratableTargetMBeanImpl._unSet(jTAMigratableTargetMBeanImpl, 7);
                    jTAMigratableTargetMBeanImpl.setHostingServerAsString(this.bean.getHostingServerAsString());
                }
                if ((list == null || !list.contains("MigrationPolicy")) && this.bean.isMigrationPolicySet()) {
                    jTAMigratableTargetMBeanImpl.setMigrationPolicy(this.bean.getMigrationPolicy());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jTAMigratableTargetMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("UserPreferredServer")) && this.bean.isUserPreferredServerSet()) {
                    jTAMigratableTargetMBeanImpl._unSet(jTAMigratableTargetMBeanImpl, 8);
                    jTAMigratableTargetMBeanImpl.setUserPreferredServerAsString(this.bean.getUserPreferredServerAsString());
                }
                if ((list == null || !list.contains("StrictOwnershipCheck")) && this.bean.isStrictOwnershipCheckSet()) {
                    jTAMigratableTargetMBeanImpl.setStrictOwnershipCheck(this.bean.isStrictOwnershipCheck());
                }
                return jTAMigratableTargetMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getAllCandidateServers(), clazz, object);
            this.inferSubTree(this.bean.getCluster(), clazz, object);
            this.inferSubTree(this.bean.getConstrainedCandidateServers(), clazz, object);
            this.inferSubTree(this.bean.getHostingServer(), clazz, object);
            this.inferSubTree(this.bean.getUserPreferredServer(), clazz, object);
        }
    }
}

