/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.JoltConnectionPoolMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JoltConnectionPoolMBeanImpl
extends DeploymentMBeanImpl
implements JoltConnectionPoolMBean,
Serializable {
    private String _ApplicationPassword;
    private byte[] _ApplicationPasswordEncrypted;
    private String[] _FailoverAddresses;
    private String _KeyPassPhrase;
    private byte[] _KeyPassPhraseEncrypted;
    private String _KeyStoreName;
    private String _KeyStorePassPhrase;
    private byte[] _KeyStorePassPhraseEncrypted;
    private int _MaximumPoolSize;
    private int _MinimumPoolSize;
    private String[] _PrimaryAddresses;
    private int _RecvTimeout;
    private boolean _SecurityContextEnabled;
    private String _TrustStoreName;
    private String _TrustStorePassPhrase;
    private byte[] _TrustStorePassPhraseEncrypted;
    private String _UserName;
    private String _UserPassword;
    private byte[] _UserPasswordEncrypted;
    private String _UserRole;
    private static SchemaHelper2 _schemaHelper;

    public JoltConnectionPoolMBeanImpl() {
        this._initializeProperty(-1);
    }

    public JoltConnectionPoolMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String[] getPrimaryAddresses() {
        return this._PrimaryAddresses;
    }

    public boolean isPrimaryAddressesSet() {
        return this._isSet(9);
    }

    public void setPrimaryAddresses(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._PrimaryAddresses;
        this._PrimaryAddresses = stringArray;
        this._postSet(9, stringArray2, stringArray);
    }

    public boolean addPrimaryAddress(String string) throws InvalidAttributeValueException {
        this._getHelper()._ensureNonNull((Object)string);
        String[] stringArray = this._isSet(9) ? (String[])this._getHelper()._extendArray((Object)this.getPrimaryAddresses(), String.class, (Object)string) : new String[]{string};
        try {
            this.setPrimaryAddresses(stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return true;
    }

    public boolean removePrimaryAddress(String string) throws InvalidAttributeValueException {
        String[] stringArray = this.getPrimaryAddresses();
        String[] stringArray2 = (String[])this._getHelper()._removeElement((Object)stringArray, String.class, (Object)string);
        if (stringArray2.length != stringArray.length) {
            try {
                this.setPrimaryAddresses(stringArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public String[] getFailoverAddresses() {
        return this._FailoverAddresses;
    }

    public boolean isFailoverAddressesSet() {
        return this._isSet(10);
    }

    public void setFailoverAddresses(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._FailoverAddresses;
        this._FailoverAddresses = stringArray;
        this._postSet(10, stringArray2, stringArray);
    }

    public boolean addFailoverAddress(String string) throws InvalidAttributeValueException {
        this._getHelper()._ensureNonNull((Object)string);
        String[] stringArray = this._isSet(10) ? (String[])this._getHelper()._extendArray((Object)this.getFailoverAddresses(), String.class, (Object)string) : new String[]{string};
        try {
            this.setFailoverAddresses(stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return true;
    }

    public boolean removeFailoverAddress(String string) throws InvalidAttributeValueException {
        String[] stringArray = this.getFailoverAddresses();
        String[] stringArray2 = (String[])this._getHelper()._removeElement((Object)stringArray, String.class, (Object)string);
        if (stringArray2.length != stringArray.length) {
            try {
                this.setFailoverAddresses(stringArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public int getMinimumPoolSize() {
        return this._MinimumPoolSize;
    }

    public boolean isMinimumPoolSizeSet() {
        return this._isSet(11);
    }

    public void setMinimumPoolSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MinimumPoolSize", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._MinimumPoolSize;
        this._MinimumPoolSize = n;
        this._postSet(11, n2, n);
    }

    public int getMaximumPoolSize() {
        return this._MaximumPoolSize;
    }

    public boolean isMaximumPoolSizeSet() {
        return this._isSet(12);
    }

    public void setMaximumPoolSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MaximumPoolSize", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._MaximumPoolSize;
        this._MaximumPoolSize = n;
        this._postSet(12, n2, n);
    }

    public String getUserName() {
        return this._UserName;
    }

    public boolean isUserNameSet() {
        return this._isSet(13);
    }

    public void setUserName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._UserName;
        this._UserName = string;
        this._postSet(13, string2, string);
    }

    public String getUserPassword() {
        byte[] byArray = this.getUserPasswordEncrypted();
        return byArray == null ? null : this._decrypt("UserPassword", byArray);
    }

    public boolean isUserPasswordSet() {
        return this.isUserPasswordEncryptedSet();
    }

    public void setUserPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setUserPasswordEncrypted(string == null ? null : this._encrypt("UserPassword", string));
    }

    public byte[] getUserPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._UserPasswordEncrypted);
    }

    public String getUserPasswordEncryptedAsString() {
        byte[] byArray = this.getUserPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isUserPasswordEncryptedSet() {
        return this._isSet(15);
    }

    public void setUserPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setUserPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getApplicationPassword() {
        byte[] byArray = this.getApplicationPasswordEncrypted();
        return byArray == null ? null : this._decrypt("ApplicationPassword", byArray);
    }

    public boolean isApplicationPasswordSet() {
        return this.isApplicationPasswordEncryptedSet();
    }

    public void setApplicationPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setApplicationPasswordEncrypted(string == null ? null : this._encrypt("ApplicationPassword", string));
    }

    public byte[] getApplicationPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._ApplicationPasswordEncrypted);
    }

    public String getApplicationPasswordEncryptedAsString() {
        byte[] byArray = this.getApplicationPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isApplicationPasswordEncryptedSet() {
        return this._isSet(17);
    }

    public void setApplicationPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setApplicationPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getUserRole() {
        return this._UserRole;
    }

    public boolean isUserRoleSet() {
        return this._isSet(18);
    }

    public void setUserRole(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._UserRole;
        this._UserRole = string;
        this._postSet(18, string2, string);
    }

    public boolean isSecurityContextEnabled() {
        return this._SecurityContextEnabled;
    }

    public boolean isSecurityContextEnabledSet() {
        return this._isSet(19);
    }

    public void setSecurityContextEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._SecurityContextEnabled;
        this._SecurityContextEnabled = bl;
        this._postSet(19, bl2, bl);
    }

    public int getRecvTimeout() {
        return this._RecvTimeout;
    }

    public boolean isRecvTimeoutSet() {
        return this._isSet(20);
    }

    public void setRecvTimeout(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RecvTimeout", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._RecvTimeout;
        this._RecvTimeout = n;
        this._postSet(20, n2, n);
    }

    public String getKeyStoreName() {
        return this._KeyStoreName;
    }

    public boolean isKeyStoreNameSet() {
        return this._isSet(21);
    }

    public void setKeyStoreName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._KeyStoreName;
        this._KeyStoreName = string;
        this._postSet(21, string2, string);
    }

    public String getTrustStoreName() {
        return this._TrustStoreName;
    }

    public boolean isTrustStoreNameSet() {
        return this._isSet(22);
    }

    public void setTrustStoreName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TrustStoreName;
        this._TrustStoreName = string;
        this._postSet(22, string2, string);
    }

    public String getKeyPassPhrase() {
        byte[] byArray = this.getKeyPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("KeyPassPhrase", byArray);
    }

    public boolean isKeyPassPhraseSet() {
        return this.isKeyPassPhraseEncryptedSet();
    }

    public void setKeyPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setKeyPassPhraseEncrypted(string == null ? null : this._encrypt("KeyPassPhrase", string));
    }

    public byte[] getKeyPassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._KeyPassPhraseEncrypted);
    }

    public String getKeyPassPhraseEncryptedAsString() {
        byte[] byArray = this.getKeyPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isKeyPassPhraseEncryptedSet() {
        return this._isSet(24);
    }

    public void setKeyPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setKeyPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getKeyStorePassPhrase() {
        byte[] byArray = this.getKeyStorePassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("KeyStorePassPhrase", byArray);
    }

    public boolean isKeyStorePassPhraseSet() {
        return this.isKeyStorePassPhraseEncryptedSet();
    }

    public void setKeyStorePassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setKeyStorePassPhraseEncrypted(string == null ? null : this._encrypt("KeyStorePassPhrase", string));
    }

    public byte[] getKeyStorePassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._KeyStorePassPhraseEncrypted);
    }

    public String getKeyStorePassPhraseEncryptedAsString() {
        byte[] byArray = this.getKeyStorePassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isKeyStorePassPhraseEncryptedSet() {
        return this._isSet(26);
    }

    public void setKeyStorePassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setKeyStorePassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getTrustStorePassPhrase() {
        byte[] byArray = this.getTrustStorePassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("TrustStorePassPhrase", byArray);
    }

    public boolean isTrustStorePassPhraseSet() {
        return this.isTrustStorePassPhraseEncryptedSet();
    }

    public void setTrustStorePassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setTrustStorePassPhraseEncrypted(string == null ? null : this._encrypt("TrustStorePassPhrase", string));
    }

    public byte[] getTrustStorePassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._TrustStorePassPhraseEncrypted);
    }

    public String getTrustStorePassPhraseEncryptedAsString() {
        byte[] byArray = this.getTrustStorePassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isTrustStorePassPhraseEncryptedSet() {
        return this._isSet(28);
    }

    public void setTrustStorePassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setTrustStorePassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setApplicationPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._ApplicationPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: ApplicationPasswordEncrypted of JoltConnectionPoolMBean");
        }
        this._getHelper()._clearArray(this._ApplicationPasswordEncrypted);
        this._ApplicationPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(17, byArray2, byArray);
    }

    public void setKeyPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._KeyPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: KeyPassPhraseEncrypted of JoltConnectionPoolMBean");
        }
        this._getHelper()._clearArray(this._KeyPassPhraseEncrypted);
        this._KeyPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(24, byArray2, byArray);
    }

    public void setKeyStorePassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._KeyStorePassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: KeyStorePassPhraseEncrypted of JoltConnectionPoolMBean");
        }
        this._getHelper()._clearArray(this._KeyStorePassPhraseEncrypted);
        this._KeyStorePassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(26, byArray2, byArray);
    }

    public void setTrustStorePassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._TrustStorePassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: TrustStorePassPhraseEncrypted of JoltConnectionPoolMBean");
        }
        this._getHelper()._clearArray(this._TrustStorePassPhraseEncrypted);
        this._TrustStorePassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(28, byArray2, byArray);
    }

    public void setUserPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._UserPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: UserPasswordEncrypted of JoltConnectionPoolMBean");
        }
        this._getHelper()._clearArray(this._UserPasswordEncrypted);
        this._UserPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(15, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 16) {
                this._markSet(17, false);
            }
            if (n == 23) {
                this._markSet(24, false);
            }
            if (n == 25) {
                this._markSet(26, false);
            }
            if (n == 27) {
                this._markSet(28, false);
            }
            if (n == 14) {
                this._markSet(15, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 16;
        }
        try {
            switch (n) {
                case 16: {
                    this._ApplicationPasswordEncrypted = null;
                    if (bl) break;
                }
                case 17: {
                    this._ApplicationPasswordEncrypted = null;
                    if (bl) break;
                }
                case 10: {
                    this._FailoverAddresses = new String[0];
                    if (bl) break;
                }
                case 23: {
                    this._KeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 24: {
                    this._KeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 21: {
                    this._KeyStoreName = null;
                    if (bl) break;
                }
                case 25: {
                    this._KeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 26: {
                    this._KeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 12: {
                    this._MaximumPoolSize = 1;
                    if (bl) break;
                }
                case 11: {
                    this._MinimumPoolSize = 0;
                    if (bl) break;
                }
                case 9: {
                    this._PrimaryAddresses = new String[0];
                    if (bl) break;
                }
                case 20: {
                    this._RecvTimeout = 0;
                    if (bl) break;
                }
                case 22: {
                    this._TrustStoreName = null;
                    if (bl) break;
                }
                case 27: {
                    this._TrustStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 28: {
                    this._TrustStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 13: {
                    this._UserName = null;
                    if (bl) break;
                }
                case 14: {
                    this._UserPasswordEncrypted = null;
                    if (bl) break;
                }
                case 15: {
                    this._UserPasswordEncrypted = null;
                    if (bl) break;
                }
                case 18: {
                    this._UserRole = null;
                    if (bl) break;
                }
                case 19: {
                    this._SecurityContextEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JoltConnectionPool";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ApplicationPassword")) {
            String string2 = this._ApplicationPassword;
            this._ApplicationPassword = (String)object;
            this._postSet(16, string2, this._ApplicationPassword);
            return;
        }
        if (string.equals("ApplicationPasswordEncrypted")) {
            byte[] byArray = this._ApplicationPasswordEncrypted;
            this._ApplicationPasswordEncrypted = (byte[])object;
            this._postSet(17, byArray, this._ApplicationPasswordEncrypted);
            return;
        }
        if (string.equals("FailoverAddresses")) {
            String[] stringArray = this._FailoverAddresses;
            this._FailoverAddresses = (String[])object;
            this._postSet(10, stringArray, this._FailoverAddresses);
            return;
        }
        if (string.equals("KeyPassPhrase")) {
            String string3 = this._KeyPassPhrase;
            this._KeyPassPhrase = (String)object;
            this._postSet(23, string3, this._KeyPassPhrase);
            return;
        }
        if (string.equals("KeyPassPhraseEncrypted")) {
            byte[] byArray = this._KeyPassPhraseEncrypted;
            this._KeyPassPhraseEncrypted = (byte[])object;
            this._postSet(24, byArray, this._KeyPassPhraseEncrypted);
            return;
        }
        if (string.equals("KeyStoreName")) {
            String string4 = this._KeyStoreName;
            this._KeyStoreName = (String)object;
            this._postSet(21, string4, this._KeyStoreName);
            return;
        }
        if (string.equals("KeyStorePassPhrase")) {
            String string5 = this._KeyStorePassPhrase;
            this._KeyStorePassPhrase = (String)object;
            this._postSet(25, string5, this._KeyStorePassPhrase);
            return;
        }
        if (string.equals("KeyStorePassPhraseEncrypted")) {
            byte[] byArray = this._KeyStorePassPhraseEncrypted;
            this._KeyStorePassPhraseEncrypted = (byte[])object;
            this._postSet(26, byArray, this._KeyStorePassPhraseEncrypted);
            return;
        }
        if (string.equals("MaximumPoolSize")) {
            int n = this._MaximumPoolSize;
            this._MaximumPoolSize = (Integer)object;
            this._postSet(12, n, this._MaximumPoolSize);
            return;
        }
        if (string.equals("MinimumPoolSize")) {
            int n = this._MinimumPoolSize;
            this._MinimumPoolSize = (Integer)object;
            this._postSet(11, n, this._MinimumPoolSize);
            return;
        }
        if (string.equals("PrimaryAddresses")) {
            String[] stringArray = this._PrimaryAddresses;
            this._PrimaryAddresses = (String[])object;
            this._postSet(9, stringArray, this._PrimaryAddresses);
            return;
        }
        if (string.equals("RecvTimeout")) {
            int n = this._RecvTimeout;
            this._RecvTimeout = (Integer)object;
            this._postSet(20, n, this._RecvTimeout);
            return;
        }
        if (string.equals("SecurityContextEnabled")) {
            boolean bl = this._SecurityContextEnabled;
            this._SecurityContextEnabled = (Boolean)object;
            this._postSet(19, bl, this._SecurityContextEnabled);
            return;
        }
        if (string.equals("TrustStoreName")) {
            String string6 = this._TrustStoreName;
            this._TrustStoreName = (String)object;
            this._postSet(22, string6, this._TrustStoreName);
            return;
        }
        if (string.equals("TrustStorePassPhrase")) {
            String string7 = this._TrustStorePassPhrase;
            this._TrustStorePassPhrase = (String)object;
            this._postSet(27, string7, this._TrustStorePassPhrase);
            return;
        }
        if (string.equals("TrustStorePassPhraseEncrypted")) {
            byte[] byArray = this._TrustStorePassPhraseEncrypted;
            this._TrustStorePassPhraseEncrypted = (byte[])object;
            this._postSet(28, byArray, this._TrustStorePassPhraseEncrypted);
            return;
        }
        if (string.equals("UserName")) {
            String string8 = this._UserName;
            this._UserName = (String)object;
            this._postSet(13, string8, this._UserName);
            return;
        }
        if (string.equals("UserPassword")) {
            String string9 = this._UserPassword;
            this._UserPassword = (String)object;
            this._postSet(14, string9, this._UserPassword);
            return;
        }
        if (string.equals("UserPasswordEncrypted")) {
            byte[] byArray = this._UserPasswordEncrypted;
            this._UserPasswordEncrypted = (byte[])object;
            this._postSet(15, byArray, this._UserPasswordEncrypted);
            return;
        }
        if (string.equals("UserRole")) {
            String string10 = this._UserRole;
            this._UserRole = (String)object;
            this._postSet(18, string10, this._UserRole);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ApplicationPassword")) {
            return this._ApplicationPassword;
        }
        if (string.equals("ApplicationPasswordEncrypted")) {
            return this._ApplicationPasswordEncrypted;
        }
        if (string.equals("FailoverAddresses")) {
            return this._FailoverAddresses;
        }
        if (string.equals("KeyPassPhrase")) {
            return this._KeyPassPhrase;
        }
        if (string.equals("KeyPassPhraseEncrypted")) {
            return this._KeyPassPhraseEncrypted;
        }
        if (string.equals("KeyStoreName")) {
            return this._KeyStoreName;
        }
        if (string.equals("KeyStorePassPhrase")) {
            return this._KeyStorePassPhrase;
        }
        if (string.equals("KeyStorePassPhraseEncrypted")) {
            return this._KeyStorePassPhraseEncrypted;
        }
        if (string.equals("MaximumPoolSize")) {
            return new Integer(this._MaximumPoolSize);
        }
        if (string.equals("MinimumPoolSize")) {
            return new Integer(this._MinimumPoolSize);
        }
        if (string.equals("PrimaryAddresses")) {
            return this._PrimaryAddresses;
        }
        if (string.equals("RecvTimeout")) {
            return new Integer(this._RecvTimeout);
        }
        if (string.equals("SecurityContextEnabled")) {
            return new Boolean(this._SecurityContextEnabled);
        }
        if (string.equals("TrustStoreName")) {
            return this._TrustStoreName;
        }
        if (string.equals("TrustStorePassPhrase")) {
            return this._TrustStorePassPhrase;
        }
        if (string.equals("TrustStorePassPhraseEncrypted")) {
            return this._TrustStorePassPhraseEncrypted;
        }
        if (string.equals("UserName")) {
            return this._UserName;
        }
        if (string.equals("UserPassword")) {
            return this._UserPassword;
        }
        if (string.equals("UserPasswordEncrypted")) {
            return this._UserPasswordEncrypted;
        }
        if (string.equals("UserRole")) {
            return this._UserRole;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (!string.equals("application-password")) break;
                    return 16;
                }
                case 30: {
                    if (!string.equals("application-password-encrypted")) break;
                    return 17;
                }
                case 16: {
                    if (string.equals("failover-address")) {
                        return 10;
                    }
                    if (!string.equals("trust-store-name")) break;
                    return 22;
                }
                case 15: {
                    if (string.equals("key-pass-phrase")) {
                        return 23;
                    }
                    if (!string.equals("primary-address")) break;
                    return 9;
                }
                case 25: {
                    if (!string.equals("key-pass-phrase-encrypted")) break;
                    return 24;
                }
                case 14: {
                    if (!string.equals("key-store-name")) break;
                    return 21;
                }
                case 21: {
                    if (!string.equals("key-store-pass-phrase")) break;
                    return 25;
                }
                case 31: {
                    if (!string.equals("key-store-pass-phrase-encrypted")) break;
                    return 26;
                }
                case 17: {
                    if (string.equals("maximum-pool-size")) {
                        return 12;
                    }
                    if (!string.equals("minimum-pool-size")) break;
                    return 11;
                }
                case 12: {
                    if (!string.equals("recv-timeout")) break;
                    return 20;
                }
                case 23: {
                    if (string.equals("trust-store-pass-phrase")) {
                        return 27;
                    }
                    if (!string.equals("user-password-encrypted")) break;
                    return 15;
                }
                case 33: {
                    if (!string.equals("trust-store-pass-phrase-encrypted")) break;
                    return 28;
                }
                case 9: {
                    if (string.equals("user-name")) {
                        return 13;
                    }
                    if (!string.equals("user-role")) break;
                    return 18;
                }
                case 13: {
                    if (!string.equals("user-password")) break;
                    return 14;
                }
                case 24: {
                    if (!string.equals("security-context-enabled")) break;
                    return 19;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 16: {
                    return "application-password";
                }
                case 17: {
                    return "application-password-encrypted";
                }
                case 10: {
                    return "failover-address";
                }
                case 23: {
                    return "key-pass-phrase";
                }
                case 24: {
                    return "key-pass-phrase-encrypted";
                }
                case 21: {
                    return "key-store-name";
                }
                case 25: {
                    return "key-store-pass-phrase";
                }
                case 26: {
                    return "key-store-pass-phrase-encrypted";
                }
                case 12: {
                    return "maximum-pool-size";
                }
                case 11: {
                    return "minimum-pool-size";
                }
                case 9: {
                    return "primary-address";
                }
                case 20: {
                    return "recv-timeout";
                }
                case 22: {
                    return "trust-store-name";
                }
                case 27: {
                    return "trust-store-pass-phrase";
                }
                case 28: {
                    return "trust-store-pass-phrase-encrypted";
                }
                case 13: {
                    return "user-name";
                }
                case 14: {
                    return "user-password";
                }
                case 15: {
                    return "user-password-encrypted";
                }
                case 18: {
                    return "user-role";
                }
                case 19: {
                    return "security-context-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private JoltConnectionPoolMBeanImpl bean;

        protected Helper(JoltConnectionPoolMBeanImpl joltConnectionPoolMBeanImpl) {
            super(joltConnectionPoolMBeanImpl);
            this.bean = joltConnectionPoolMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 16: {
                    return "ApplicationPassword";
                }
                case 17: {
                    return "ApplicationPasswordEncrypted";
                }
                case 10: {
                    return "FailoverAddresses";
                }
                case 23: {
                    return "KeyPassPhrase";
                }
                case 24: {
                    return "KeyPassPhraseEncrypted";
                }
                case 21: {
                    return "KeyStoreName";
                }
                case 25: {
                    return "KeyStorePassPhrase";
                }
                case 26: {
                    return "KeyStorePassPhraseEncrypted";
                }
                case 12: {
                    return "MaximumPoolSize";
                }
                case 11: {
                    return "MinimumPoolSize";
                }
                case 9: {
                    return "PrimaryAddresses";
                }
                case 20: {
                    return "RecvTimeout";
                }
                case 22: {
                    return "TrustStoreName";
                }
                case 27: {
                    return "TrustStorePassPhrase";
                }
                case 28: {
                    return "TrustStorePassPhraseEncrypted";
                }
                case 13: {
                    return "UserName";
                }
                case 14: {
                    return "UserPassword";
                }
                case 15: {
                    return "UserPasswordEncrypted";
                }
                case 18: {
                    return "UserRole";
                }
                case 19: {
                    return "SecurityContextEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ApplicationPassword")) {
                return 16;
            }
            if (string.equals("ApplicationPasswordEncrypted")) {
                return 17;
            }
            if (string.equals("FailoverAddresses")) {
                return 10;
            }
            if (string.equals("KeyPassPhrase")) {
                return 23;
            }
            if (string.equals("KeyPassPhraseEncrypted")) {
                return 24;
            }
            if (string.equals("KeyStoreName")) {
                return 21;
            }
            if (string.equals("KeyStorePassPhrase")) {
                return 25;
            }
            if (string.equals("KeyStorePassPhraseEncrypted")) {
                return 26;
            }
            if (string.equals("MaximumPoolSize")) {
                return 12;
            }
            if (string.equals("MinimumPoolSize")) {
                return 11;
            }
            if (string.equals("PrimaryAddresses")) {
                return 9;
            }
            if (string.equals("RecvTimeout")) {
                return 20;
            }
            if (string.equals("TrustStoreName")) {
                return 22;
            }
            if (string.equals("TrustStorePassPhrase")) {
                return 27;
            }
            if (string.equals("TrustStorePassPhraseEncrypted")) {
                return 28;
            }
            if (string.equals("UserName")) {
                return 13;
            }
            if (string.equals("UserPassword")) {
                return 14;
            }
            if (string.equals("UserPasswordEncrypted")) {
                return 15;
            }
            if (string.equals("UserRole")) {
                return 18;
            }
            if (string.equals("SecurityContextEnabled")) {
                return 19;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isApplicationPasswordSet()) {
                    stringBuffer.append("ApplicationPassword");
                    stringBuffer.append(String.valueOf(this.bean.getApplicationPassword()));
                }
                if (this.bean.isApplicationPasswordEncryptedSet()) {
                    stringBuffer.append("ApplicationPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getApplicationPasswordEncrypted())));
                }
                if (this.bean.isFailoverAddressesSet()) {
                    stringBuffer.append("FailoverAddresses");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getFailoverAddresses())));
                }
                if (this.bean.isKeyPassPhraseSet()) {
                    stringBuffer.append("KeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getKeyPassPhrase()));
                }
                if (this.bean.isKeyPassPhraseEncryptedSet()) {
                    stringBuffer.append("KeyPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getKeyPassPhraseEncrypted())));
                }
                if (this.bean.isKeyStoreNameSet()) {
                    stringBuffer.append("KeyStoreName");
                    stringBuffer.append(String.valueOf(this.bean.getKeyStoreName()));
                }
                if (this.bean.isKeyStorePassPhraseSet()) {
                    stringBuffer.append("KeyStorePassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getKeyStorePassPhrase()));
                }
                if (this.bean.isKeyStorePassPhraseEncryptedSet()) {
                    stringBuffer.append("KeyStorePassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getKeyStorePassPhraseEncrypted())));
                }
                if (this.bean.isMaximumPoolSizeSet()) {
                    stringBuffer.append("MaximumPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumPoolSize()));
                }
                if (this.bean.isMinimumPoolSizeSet()) {
                    stringBuffer.append("MinimumPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getMinimumPoolSize()));
                }
                if (this.bean.isPrimaryAddressesSet()) {
                    stringBuffer.append("PrimaryAddresses");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getPrimaryAddresses())));
                }
                if (this.bean.isRecvTimeoutSet()) {
                    stringBuffer.append("RecvTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getRecvTimeout()));
                }
                if (this.bean.isTrustStoreNameSet()) {
                    stringBuffer.append("TrustStoreName");
                    stringBuffer.append(String.valueOf(this.bean.getTrustStoreName()));
                }
                if (this.bean.isTrustStorePassPhraseSet()) {
                    stringBuffer.append("TrustStorePassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getTrustStorePassPhrase()));
                }
                if (this.bean.isTrustStorePassPhraseEncryptedSet()) {
                    stringBuffer.append("TrustStorePassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getTrustStorePassPhraseEncrypted())));
                }
                if (this.bean.isUserNameSet()) {
                    stringBuffer.append("UserName");
                    stringBuffer.append(String.valueOf(this.bean.getUserName()));
                }
                if (this.bean.isUserPasswordSet()) {
                    stringBuffer.append("UserPassword");
                    stringBuffer.append(String.valueOf(this.bean.getUserPassword()));
                }
                if (this.bean.isUserPasswordEncryptedSet()) {
                    stringBuffer.append("UserPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getUserPasswordEncrypted())));
                }
                if (this.bean.isUserRoleSet()) {
                    stringBuffer.append("UserRole");
                    stringBuffer.append(String.valueOf(this.bean.getUserRole()));
                }
                if (this.bean.isSecurityContextEnabledSet()) {
                    stringBuffer.append("SecurityContextEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSecurityContextEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JoltConnectionPoolMBeanImpl joltConnectionPoolMBeanImpl = (JoltConnectionPoolMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ApplicationPasswordEncrypted", this.bean.getApplicationPasswordEncrypted(), joltConnectionPoolMBeanImpl.getApplicationPasswordEncrypted(), false);
                this.computeDiff("FailoverAddresses", this.bean.getFailoverAddresses(), joltConnectionPoolMBeanImpl.getFailoverAddresses(), false);
                this.computeDiff("KeyPassPhraseEncrypted", this.bean.getKeyPassPhraseEncrypted(), joltConnectionPoolMBeanImpl.getKeyPassPhraseEncrypted(), true);
                this.computeDiff("KeyStoreName", this.bean.getKeyStoreName(), joltConnectionPoolMBeanImpl.getKeyStoreName(), false);
                this.computeDiff("KeyStorePassPhraseEncrypted", this.bean.getKeyStorePassPhraseEncrypted(), joltConnectionPoolMBeanImpl.getKeyStorePassPhraseEncrypted(), true);
                this.computeDiff("MaximumPoolSize", this.bean.getMaximumPoolSize(), joltConnectionPoolMBeanImpl.getMaximumPoolSize(), false);
                this.computeDiff("MinimumPoolSize", this.bean.getMinimumPoolSize(), joltConnectionPoolMBeanImpl.getMinimumPoolSize(), false);
                this.computeDiff("PrimaryAddresses", this.bean.getPrimaryAddresses(), joltConnectionPoolMBeanImpl.getPrimaryAddresses(), false);
                this.computeDiff("RecvTimeout", this.bean.getRecvTimeout(), joltConnectionPoolMBeanImpl.getRecvTimeout(), false);
                this.computeDiff("TrustStoreName", this.bean.getTrustStoreName(), joltConnectionPoolMBeanImpl.getTrustStoreName(), false);
                this.computeDiff("TrustStorePassPhraseEncrypted", this.bean.getTrustStorePassPhraseEncrypted(), joltConnectionPoolMBeanImpl.getTrustStorePassPhraseEncrypted(), true);
                this.computeDiff("UserName", this.bean.getUserName(), joltConnectionPoolMBeanImpl.getUserName(), false);
                this.computeDiff("UserPasswordEncrypted", this.bean.getUserPasswordEncrypted(), joltConnectionPoolMBeanImpl.getUserPasswordEncrypted(), false);
                this.computeDiff("UserRole", this.bean.getUserRole(), joltConnectionPoolMBeanImpl.getUserRole(), false);
                this.computeDiff("SecurityContextEnabled", this.bean.isSecurityContextEnabled(), joltConnectionPoolMBeanImpl.isSecurityContextEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JoltConnectionPoolMBeanImpl joltConnectionPoolMBeanImpl = (JoltConnectionPoolMBeanImpl)beanUpdateEvent.getSourceBean();
                JoltConnectionPoolMBeanImpl joltConnectionPoolMBeanImpl2 = (JoltConnectionPoolMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("ApplicationPassword")) {
                    if (string.equals("ApplicationPasswordEncrypted")) {
                        joltConnectionPoolMBeanImpl.setApplicationPasswordEncrypted(joltConnectionPoolMBeanImpl2.getApplicationPasswordEncrypted());
                        joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("FailoverAddresses")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject(propertyUpdate.getAddedObject());
                            joltConnectionPoolMBeanImpl.addFailoverAddress((String)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            joltConnectionPoolMBeanImpl.removeFailoverAddress((String)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (joltConnectionPoolMBeanImpl.getFailoverAddresses() == null || joltConnectionPoolMBeanImpl.getFailoverAddresses().length == 0) {
                            joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                        }
                    } else if (!string.equals("KeyPassPhrase")) {
                        if (string.equals("KeyPassPhraseEncrypted")) {
                            joltConnectionPoolMBeanImpl.setKeyPassPhraseEncrypted(joltConnectionPoolMBeanImpl2.getKeyPassPhraseEncrypted());
                            joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                        } else if (string.equals("KeyStoreName")) {
                            joltConnectionPoolMBeanImpl.setKeyStoreName(joltConnectionPoolMBeanImpl2.getKeyStoreName());
                            joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                        } else if (!string.equals("KeyStorePassPhrase")) {
                            if (string.equals("KeyStorePassPhraseEncrypted")) {
                                joltConnectionPoolMBeanImpl.setKeyStorePassPhraseEncrypted(joltConnectionPoolMBeanImpl2.getKeyStorePassPhraseEncrypted());
                                joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                            } else if (string.equals("MaximumPoolSize")) {
                                joltConnectionPoolMBeanImpl.setMaximumPoolSize(joltConnectionPoolMBeanImpl2.getMaximumPoolSize());
                                joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                            } else if (string.equals("MinimumPoolSize")) {
                                joltConnectionPoolMBeanImpl.setMinimumPoolSize(joltConnectionPoolMBeanImpl2.getMinimumPoolSize());
                                joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                            } else if (string.equals("PrimaryAddresses")) {
                                if (n == 2) {
                                    propertyUpdate.resetAddedObject(propertyUpdate.getAddedObject());
                                    joltConnectionPoolMBeanImpl.addPrimaryAddress((String)propertyUpdate.getAddedObject());
                                } else if (n == 3) {
                                    joltConnectionPoolMBeanImpl.removePrimaryAddress((String)propertyUpdate.getRemovedObject());
                                } else {
                                    throw new AssertionError((Object)("Invalid type: " + n));
                                }
                                if (joltConnectionPoolMBeanImpl.getPrimaryAddresses() == null || joltConnectionPoolMBeanImpl.getPrimaryAddresses().length == 0) {
                                    joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                                }
                            } else if (string.equals("RecvTimeout")) {
                                joltConnectionPoolMBeanImpl.setRecvTimeout(joltConnectionPoolMBeanImpl2.getRecvTimeout());
                                joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                            } else if (string.equals("TrustStoreName")) {
                                joltConnectionPoolMBeanImpl.setTrustStoreName(joltConnectionPoolMBeanImpl2.getTrustStoreName());
                                joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                            } else if (!string.equals("TrustStorePassPhrase")) {
                                if (string.equals("TrustStorePassPhraseEncrypted")) {
                                    joltConnectionPoolMBeanImpl.setTrustStorePassPhraseEncrypted(joltConnectionPoolMBeanImpl2.getTrustStorePassPhraseEncrypted());
                                    joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                                } else if (string.equals("UserName")) {
                                    joltConnectionPoolMBeanImpl.setUserName(joltConnectionPoolMBeanImpl2.getUserName());
                                    joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                                } else if (!string.equals("UserPassword")) {
                                    if (string.equals("UserPasswordEncrypted")) {
                                        joltConnectionPoolMBeanImpl.setUserPasswordEncrypted(joltConnectionPoolMBeanImpl2.getUserPasswordEncrypted());
                                        joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                                    } else if (string.equals("UserRole")) {
                                        joltConnectionPoolMBeanImpl.setUserRole(joltConnectionPoolMBeanImpl2.getUserRole());
                                        joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                                    } else if (string.equals("SecurityContextEnabled")) {
                                        joltConnectionPoolMBeanImpl.setSecurityContextEnabled(joltConnectionPoolMBeanImpl2.isSecurityContextEnabled());
                                        joltConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                                    } else {
                                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                Object[] objectArray;
                JoltConnectionPoolMBeanImpl joltConnectionPoolMBeanImpl = (JoltConnectionPoolMBeanImpl)abstractDescriptorBean;
                super.finishCopy(joltConnectionPoolMBeanImpl, bl, list);
                if ((list == null || !list.contains("ApplicationPasswordEncrypted")) && this.bean.isApplicationPasswordEncryptedSet()) {
                    objectArray = this.bean.getApplicationPasswordEncrypted();
                    joltConnectionPoolMBeanImpl.setApplicationPasswordEncrypted(objectArray == null ? null : (byte[])objectArray.clone());
                }
                if ((list == null || !list.contains("FailoverAddresses")) && this.bean.isFailoverAddressesSet()) {
                    objectArray = this.bean.getFailoverAddresses();
                    joltConnectionPoolMBeanImpl.setFailoverAddresses(objectArray == null ? null : (String[])((String[])objectArray).clone());
                }
                if ((list == null || !list.contains("KeyPassPhraseEncrypted")) && this.bean.isKeyPassPhraseEncryptedSet()) {
                    objectArray = this.bean.getKeyPassPhraseEncrypted();
                    joltConnectionPoolMBeanImpl.setKeyPassPhraseEncrypted(objectArray == null ? null : (byte[])objectArray.clone());
                }
                if ((list == null || !list.contains("KeyStoreName")) && this.bean.isKeyStoreNameSet()) {
                    joltConnectionPoolMBeanImpl.setKeyStoreName(this.bean.getKeyStoreName());
                }
                if ((list == null || !list.contains("KeyStorePassPhraseEncrypted")) && this.bean.isKeyStorePassPhraseEncryptedSet()) {
                    objectArray = this.bean.getKeyStorePassPhraseEncrypted();
                    joltConnectionPoolMBeanImpl.setKeyStorePassPhraseEncrypted(objectArray == null ? null : (byte[])objectArray.clone());
                }
                if ((list == null || !list.contains("MaximumPoolSize")) && this.bean.isMaximumPoolSizeSet()) {
                    joltConnectionPoolMBeanImpl.setMaximumPoolSize(this.bean.getMaximumPoolSize());
                }
                if ((list == null || !list.contains("MinimumPoolSize")) && this.bean.isMinimumPoolSizeSet()) {
                    joltConnectionPoolMBeanImpl.setMinimumPoolSize(this.bean.getMinimumPoolSize());
                }
                if ((list == null || !list.contains("PrimaryAddresses")) && this.bean.isPrimaryAddressesSet()) {
                    objectArray = this.bean.getPrimaryAddresses();
                    joltConnectionPoolMBeanImpl.setPrimaryAddresses(objectArray == null ? null : (String[])((String[])objectArray).clone());
                }
                if ((list == null || !list.contains("RecvTimeout")) && this.bean.isRecvTimeoutSet()) {
                    joltConnectionPoolMBeanImpl.setRecvTimeout(this.bean.getRecvTimeout());
                }
                if ((list == null || !list.contains("TrustStoreName")) && this.bean.isTrustStoreNameSet()) {
                    joltConnectionPoolMBeanImpl.setTrustStoreName(this.bean.getTrustStoreName());
                }
                if ((list == null || !list.contains("TrustStorePassPhraseEncrypted")) && this.bean.isTrustStorePassPhraseEncryptedSet()) {
                    objectArray = this.bean.getTrustStorePassPhraseEncrypted();
                    joltConnectionPoolMBeanImpl.setTrustStorePassPhraseEncrypted(objectArray == null ? null : (byte[])objectArray.clone());
                }
                if ((list == null || !list.contains("UserName")) && this.bean.isUserNameSet()) {
                    joltConnectionPoolMBeanImpl.setUserName(this.bean.getUserName());
                }
                if ((list == null || !list.contains("UserPasswordEncrypted")) && this.bean.isUserPasswordEncryptedSet()) {
                    objectArray = this.bean.getUserPasswordEncrypted();
                    joltConnectionPoolMBeanImpl.setUserPasswordEncrypted(objectArray == null ? null : (byte[])objectArray.clone());
                }
                if ((list == null || !list.contains("UserRole")) && this.bean.isUserRoleSet()) {
                    joltConnectionPoolMBeanImpl.setUserRole(this.bean.getUserRole());
                }
                if ((list == null || !list.contains("SecurityContextEnabled")) && this.bean.isSecurityContextEnabledSet()) {
                    joltConnectionPoolMBeanImpl.setSecurityContextEnabled(this.bean.isSecurityContextEnabled());
                }
                return joltConnectionPoolMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

