/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.configuration.DeploymentMBeanImplBeanInfo;
import weblogic.management.configuration.JoltConnectionPoolMBean;
import weblogic.management.configuration.JoltConnectionPoolMBeanImpl;
import weblogic.management.internal.mbean.BeanInfoHelper;

public class JoltConnectionPoolMBeanImplBeanInfo
extends DeploymentMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = JoltConnectionPoolMBean.class;

    public JoltConnectionPoolMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public JoltConnectionPoolMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = JoltConnectionPoolMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.management.configuration");
        String string = new String("This bean defines a Jolt connection pool. ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.configuration.JoltConnectionPoolMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String[] stringArray2;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("ApplicationPassword")) {
            string2 = "getApplicationPassword";
            string = null;
            if (!this.readOnly) {
                string = "setApplicationPassword";
            }
            propertyDescriptor = new PropertyDescriptor("ApplicationPassword", JoltConnectionPoolMBean.class, string2, string);
            map.put("ApplicationPassword", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The application password for this Jolt connection pool. (This is required only when the security level in the Tuxedo domain is <tt>USER_AUTH</tt>, <tt>ACL</tt> or <tt>MANDATORY_ACL</tt>).</p> <p>As of 8.1 sp4, when you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>ApplicationPasswordEncrypted</code> attribute. <li>Decrypts the value and returns the unencrypted password as a String. </ol>  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>ApplicationPasswordEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this attribute (<code>ApplicationPassword</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>ApplicationPasswordEncrypted</code>.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getApplicationPasswordEncrypted()")};
            propertyDescriptor.setValue("see", stringArray2);
            propertyDescriptor.setValue("secureValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            propertyDescriptor.setValue("rolesAllowedGet", stringArray);
        }
        if (!map.containsKey("ApplicationPasswordEncrypted")) {
            string2 = "getApplicationPasswordEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setApplicationPasswordEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("ApplicationPasswordEncrypted", JoltConnectionPoolMBean.class, string2, string);
            map.put("ApplicationPasswordEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted application password for this connection pool.</p> <p>To set this attribute, use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method.</p>  <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("secureValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            propertyDescriptor.setValue("rolesAllowedGet", stringArray2);
        }
        if (!map.containsKey("FailoverAddresses")) {
            string2 = "getFailoverAddresses";
            string = null;
            if (!this.readOnly) {
                string = "setFailoverAddresses";
            }
            propertyDescriptor = new PropertyDescriptor("FailoverAddresses", JoltConnectionPoolMBean.class, string2, string);
            map.put("FailoverAddresses", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The list of Jolt Server Listeners (JSLs) addresses that is used if the connection pool cannot estabilish connections to the Primary Addresses, or if the primary connections fail.</p>  <p>The format of each address is: <tt>//hostname:port</tt>. Multiple addresses should be separated by commas.</p>  <p>These JSLs need not reside on the same host as the primary JSLs.</p> ");
        }
        if (!map.containsKey("KeyPassPhrase")) {
            string2 = "getKeyPassPhrase";
            string = null;
            if (!this.readOnly) {
                string = "setKeyPassPhrase";
            }
            propertyDescriptor = new PropertyDescriptor("KeyPassPhrase", JoltConnectionPoolMBean.class, string2, string);
            map.put("KeyPassPhrase", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted identity passphrase.</p>  <p>When you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>KeyPassPhraseEncrypted</code> attribute. <li>Decrypts the value and returns the unencrypted password as a String. </ol>  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>KeyPassPhraseEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this attribute (<code>KeyPassPhrase</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>KeyPassPhraseEncrypted</code>.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getKeyPassPhraseEncrypted()")};
            propertyDescriptor.setValue("see", stringArray2);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("KeyPassPhraseEncrypted")) {
            string2 = "getKeyPassPhraseEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setKeyPassPhraseEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("KeyPassPhraseEncrypted", JoltConnectionPoolMBean.class, string2, string);
            map.put("KeyPassPhraseEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns encrypted identity pass phrase.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("KeyStoreName")) {
            string2 = "getKeyStoreName";
            string = null;
            if (!this.readOnly) {
                string = "setKeyStoreName";
            }
            propertyDescriptor = new PropertyDescriptor("KeyStoreName", JoltConnectionPoolMBean.class, string2, string);
            map.put("KeyStoreName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The path and file name of the keystore containing the private key used in SSL mutual authentication.</p> ");
        }
        if (!map.containsKey("KeyStorePassPhrase")) {
            string2 = "getKeyStorePassPhrase";
            string = null;
            if (!this.readOnly) {
                string = "setKeyStorePassPhrase";
            }
            propertyDescriptor = new PropertyDescriptor("KeyStorePassPhrase", JoltConnectionPoolMBean.class, string2, string);
            map.put("KeyStorePassPhrase", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted identity keystore's passphrase. If empty or null, then the keystore will be opened without a passphrase.</p>  <p>When you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>KeyStorePassPhraseEncrypted</code> attribute. <li>Decrypts the value and returns the unencrypted password as a String. </ol>  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>KeyStorePassPhraseEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this attribute (<code>KeyStorePassPhrase</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>KeyStorePassPhraseEncrypted</code>.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getKeyStorePassPhraseEncrypted()")};
            propertyDescriptor.setValue("see", stringArray2);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("KeyStorePassPhraseEncrypted")) {
            string2 = "getKeyStorePassPhraseEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setKeyStorePassPhraseEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("KeyStorePassPhraseEncrypted", JoltConnectionPoolMBean.class, string2, string);
            map.put("KeyStorePassPhraseEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns encrypted pass phrase defined when creating the keystore.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MaximumPoolSize")) {
            string2 = "getMaximumPoolSize";
            string = null;
            if (!this.readOnly) {
                string = "setMaximumPoolSize";
            }
            propertyDescriptor = new PropertyDescriptor("MaximumPoolSize", JoltConnectionPoolMBean.class, string2, string);
            map.put("MaximumPoolSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of connections that can be made from this Jolt connection pool.</p> ");
            JoltConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(1));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(1));
        }
        if (!map.containsKey("MinimumPoolSize")) {
            string2 = "getMinimumPoolSize";
            string = null;
            if (!this.readOnly) {
                string = "setMinimumPoolSize";
            }
            propertyDescriptor = new PropertyDescriptor("MinimumPoolSize", JoltConnectionPoolMBean.class, string2, string);
            map.put("MinimumPoolSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The minimum number of connections to be added to this Jolt connection pool when WebLogic Server starts.</p> ");
            JoltConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
        }
        if (!map.containsKey("PrimaryAddresses")) {
            string2 = "getPrimaryAddresses";
            string = null;
            if (!this.readOnly) {
                string = "setPrimaryAddresses";
            }
            propertyDescriptor = new PropertyDescriptor("PrimaryAddresses", JoltConnectionPoolMBean.class, string2, string);
            map.put("PrimaryAddresses", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The list of addresses for the primary Jolt Server Listeners (JSLs) on the Tuxedo system.</p>  <p>The format of each address is: <tt>//hostname:port</tt>. Multiple addresses should be separated by commas.</p> ");
        }
        if (!map.containsKey("RecvTimeout")) {
            string2 = "getRecvTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setRecvTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("RecvTimeout", JoltConnectionPoolMBean.class, string2, string);
            map.put("RecvTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds the client waits to receive a response before timing out.</p> ");
            JoltConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
        }
        if (!map.containsKey("TrustStoreName")) {
            string2 = "getTrustStoreName";
            string = null;
            if (!this.readOnly) {
                string = "setTrustStoreName";
            }
            propertyDescriptor = new PropertyDescriptor("TrustStoreName", JoltConnectionPoolMBean.class, string2, string);
            map.put("TrustStoreName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The path and file name of the keystore containing the trust certificates.</p> ");
        }
        if (!map.containsKey("TrustStorePassPhrase")) {
            string2 = "getTrustStorePassPhrase";
            string = null;
            if (!this.readOnly) {
                string = "setTrustStorePassPhrase";
            }
            propertyDescriptor = new PropertyDescriptor("TrustStorePassPhrase", JoltConnectionPoolMBean.class, string2, string);
            map.put("TrustStorePassPhrase", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted trust keystore's passphrase. If empty or null, then the keystore will be opened without a passphrase.</p>  <p>When you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>TrustStorePassPhraseEncrypted</code> attribute. <li>Decrypts the value and returns the unencrypted password as a String. </ol>  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>TrustStorePassPhraseEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this attribute (<code>TrustStorePassPhrase</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>TrustStorePassPhraseEncrypted</code>.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getTrustStorePassPhraseEncrypted()")};
            propertyDescriptor.setValue("see", stringArray2);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("TrustStorePassPhraseEncrypted")) {
            string2 = "getTrustStorePassPhraseEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setTrustStorePassPhraseEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("TrustStorePassPhraseEncrypted", JoltConnectionPoolMBean.class, string2, string);
            map.put("TrustStorePassPhraseEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns encrypted pass phrase defined when creating the keystore.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("UserName")) {
            string2 = "getUserName";
            string = null;
            if (!this.readOnly) {
                string = "setUserName";
            }
            propertyDescriptor = new PropertyDescriptor("UserName", JoltConnectionPoolMBean.class, string2, string);
            map.put("UserName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>A user name that applications specify to connect to this Jolt connection pool. If Security Context is enabled, this name must be the name of an authorized Tuxedo user. (Specifying a Tuxedo user name is required if the Tuxedo authentication level is <code>USER_AUTH</code>.)</p> ");
        }
        if (!map.containsKey("UserPassword")) {
            string2 = "getUserPassword";
            string = null;
            if (!this.readOnly) {
                string = "setUserPassword";
            }
            propertyDescriptor = new PropertyDescriptor("UserPassword", JoltConnectionPoolMBean.class, string2, string);
            map.put("UserPassword", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The user password for this Jolt connection pool.</p> <p>As of 8.1 sp4, when you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>UserPasswordEncrypted</code> attribute. <li>Decrypts the value and returns the unencrypted password as a String. </ol>  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>UserPasswordEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this attribute (<code>UserPassword</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>UserPasswordEncrypted</code>.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getUserPasswordEncrypted()")};
            propertyDescriptor.setValue("see", stringArray2);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            propertyDescriptor.setValue("rolesAllowedGet", stringArray);
        }
        if (!map.containsKey("UserPasswordEncrypted")) {
            string2 = "getUserPasswordEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setUserPasswordEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("UserPasswordEncrypted", JoltConnectionPoolMBean.class, string2, string);
            map.put("UserPasswordEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The user password for this connection pool.</p>  <p>To set this attribute, use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method.</p>  <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            propertyDescriptor.setValue("rolesAllowedGet", stringArray2);
        }
        if (!map.containsKey("UserRole")) {
            string2 = "getUserRole";
            string = null;
            if (!this.readOnly) {
                string = "setUserRole";
            }
            propertyDescriptor = new PropertyDescriptor("UserRole", JoltConnectionPoolMBean.class, string2, string);
            map.put("UserRole", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The Tuxedo user role for this Jolt connection pool. (This is required only when the security level in the Tuxedo domain is <tt>USER_AUTH</tt>, <tt>ACL</tt>, or <tt>MANDATORY_ACL</tt>).</p> ");
        }
        if (!map.containsKey("SecurityContextEnabled")) {
            string2 = "isSecurityContextEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setSecurityContextEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("SecurityContextEnabled", JoltConnectionPoolMBean.class, string2, string);
            map.put("SecurityContextEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether this Jolt connection pool passes the connection pool's security context (user name, password and other information) from the WebLogic Server user to the Tuxedo domain.</p>  <p>If you enable the connection pool to pass the security context, you must start the Jolt Service Handler (JSH) with the <code>-a</code> option. When the JSH gets a message with the caller's identity, it calls <code>impersonate_user()</code> to get the appkey for the user. JSH caches the appkey, so the next time the caller makes a request, the appkey is retrieved from the cache and the request is forwarded to the service. A cache is maintained by each JSH, which means that there will be a cache maintained for all the session pools connected to the same JSH.</p>  <p>You must enable Security Context if Tuxedo requires secured connections.</p> ");
            JoltConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = JoltConnectionPoolMBean.class.getMethod("addPrimaryAddress", String.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{JoltConnectionPoolMBeanImplBeanInfo.createParameterDescriptor((String)"address", (String)"The feature to be added to the PrimaryAddress attribute ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Adds a feature to the PrimaryAddress attribute of the JoltConnectionPoolMBean object</p> ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "PrimaryAddresses");
        }
        method = JoltConnectionPoolMBean.class.getMethod("removePrimaryAddress", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JoltConnectionPoolMBeanImplBeanInfo.createParameterDescriptor((String)"address", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "PrimaryAddresses");
        }
        method = JoltConnectionPoolMBean.class.getMethod("addFailoverAddress", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JoltConnectionPoolMBeanImplBeanInfo.createParameterDescriptor((String)"address", (String)"The feature to be added to the FailoverAddress attribute ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Adds a feature to the FailoverAddress attribute of the JoltConnectionPoolMBean object</p> ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "FailoverAddresses");
        }
        method = JoltConnectionPoolMBean.class.getMethod("removeFailoverAddress", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JoltConnectionPoolMBeanImplBeanInfo.createParameterDescriptor((String)"address", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "FailoverAddresses");
        }
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

