/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.ExecuteQueueMBeanImpl;
import weblogic.management.configuration.IIOPMBean;
import weblogic.management.configuration.IIOPMBeanImpl;
import weblogic.management.configuration.KernelDebugMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.KernelValidator;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.LogMBeanImpl;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.SSLMBeanImpl;
import weblogic.management.mbeans.custom.Kernel;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class KernelMBeanImpl
extends ConfigurationMBeanImpl
implements KernelMBean,
Serializable {
    private boolean _AddWorkManagerThreadsByCpuCount;
    private String _AdministrationProtocol;
    private int _CompleteCOMMessageTimeout;
    private int _CompleteHTTPMessageTimeout;
    private int _CompleteIIOPMessageTimeout;
    private int _CompleteMessageTimeout;
    private int _CompleteT3MessageTimeout;
    private int _ConnectTimeout;
    private int _DGCIdlePeriodsUntilTimeout;
    private int _DefaultGIOPMinorVersion;
    private String _DefaultProtocol;
    private String _DefaultSecureProtocol;
    private boolean _DevPollDisabled;
    private ExecuteQueueMBean[] _ExecuteQueues;
    private boolean _GatheredWritesEnabled;
    private IIOPMBean _IIOP;
    private String _IIOPLocationForwardPolicy;
    private String _IIOPTxMechanism;
    private int _IdleConnectionTimeout;
    private int _IdleIIOPConnectionTimeout;
    private int _IdlePeriodsUntilTimeout;
    private boolean _InstrumentStackTraceEnabled;
    private int _JMSThreadPoolSize;
    private KernelDebugMBean _KernelDebug;
    private boolean _LoadStubUsingContextClassLoader;
    private LogMBean _Log;
    private boolean _LogRemoteExceptionsEnabled;
    private int _MTUSize;
    private int _MaxCOMMessageSize;
    private int _MaxHTTPMessageSize;
    private int _MaxIIOPMessageSize;
    private int _MaxMessageSize;
    private int _MaxOpenSockCount;
    private int _MaxT3MessageSize;
    private int _MessagingBridgeThreadPoolSize;
    private String _MuxerClass;
    private String _Name;
    private boolean _NativeIOEnabled;
    private boolean _OutboundEnabled;
    private boolean _OutboundPrivateKeyEnabled;
    private int _PeriodLength;
    private boolean _RefreshClientRuntimeDescriptor;
    private int _ResponseTimeout;
    private boolean _ReverseDNSAllowed;
    private int _RjvmIdleTimeout;
    private SSLMBean _SSL;
    private boolean _ScatteredReadsEnabled;
    private int _SelfTuningThreadPoolSizeMax;
    private int _SelfTuningThreadPoolSizeMin;
    private boolean _SocketBufferSizeAsChunkSize;
    private int _SocketReaderTimeoutMaxMillis;
    private int _SocketReaderTimeoutMinMillis;
    private int _SocketReaders;
    private boolean _StdoutDebugEnabled;
    private boolean _StdoutEnabled;
    private String _StdoutFormat;
    private boolean _StdoutLogStack;
    private int _StdoutSeverityLevel;
    private int _StuckThreadMaxTime;
    private int _StuckThreadTimerInterval;
    private int _SystemThreadPoolSize;
    private int _T3ClientAbbrevTableSize;
    private int _T3ServerAbbrevTableSize;
    private int _ThreadPoolPercentSocketReaders;
    private int _ThreadPoolSize;
    private long _TimedOutRefIsolationTime;
    private boolean _TracingEnabled;
    private boolean _Use81StyleExecuteQueues;
    private boolean _UseConcurrentQueueForRequestManager;
    private boolean _UseIIOPLocateRequest;
    private Map _ValidProtocols;
    private Kernel _customizer;
    private static SchemaHelper2 _schemaHelper;

    public KernelMBeanImpl() {
        try {
            this._customizer = new Kernel(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public KernelMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new Kernel(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public Map getValidProtocols() {
        return this._ValidProtocols;
    }

    public String getValidProtocolsAsString() {
        return StringHelper.objectToString((Object)this.getValidProtocols());
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isValidProtocolsSet() {
        return this._isSet(7);
    }

    public void setValidProtocolsAsString(String string) {
        try {
            this.setValidProtocols(StringHelper.stringToMap((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setValidProtocols(Map map) throws InvalidAttributeValueException {
        Map map2 = this._ValidProtocols;
        this._ValidProtocols = map;
        this._postSet(7, map2, map);
    }

    public boolean isReverseDNSAllowed() {
        return this._ReverseDNSAllowed;
    }

    public boolean isReverseDNSAllowedSet() {
        return this._isSet(8);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setReverseDNSAllowed(boolean bl) throws DistributedManagementException {
        boolean bl2 = this._ReverseDNSAllowed;
        this._ReverseDNSAllowed = bl;
        this._postSet(8, bl2, bl);
    }

    public String getDefaultProtocol() {
        return this._DefaultProtocol;
    }

    public boolean isDefaultProtocolSet() {
        return this._isSet(9);
    }

    public void setDefaultProtocol(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"t3", "t3s", "http", "https", "iiop", "iiops"};
        string = LegalChecks.checkInEnum((String)"DefaultProtocol", (String)string, (String[])stringArray);
        String string2 = this._DefaultProtocol;
        this._DefaultProtocol = string;
        this._postSet(9, string2, string);
    }

    public String getDefaultSecureProtocol() {
        return this._DefaultSecureProtocol;
    }

    public boolean isDefaultSecureProtocolSet() {
        return this._isSet(10);
    }

    public void setDefaultSecureProtocol(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"t3s", "https", "iiops"};
        string = LegalChecks.checkInEnum((String)"DefaultSecureProtocol", (String)string, (String[])stringArray);
        String string2 = this._DefaultSecureProtocol;
        this._DefaultSecureProtocol = string;
        this._postSet(10, string2, string);
    }

    public String getAdministrationProtocol() {
        if (!this._isSet(11)) {
            try {
                return ((DomainMBean)this.getParent()).getAdministrationProtocol();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._AdministrationProtocol;
    }

    public boolean isAdministrationProtocolSet() {
        return this._isSet(11);
    }

    public void setAdministrationProtocol(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"t3s", "https", "iiops", "t3", "http", "iiop"};
        string = LegalChecks.checkInEnum((String)"AdministrationProtocol", (String)string, (String[])stringArray);
        String string2 = this._AdministrationProtocol;
        this._AdministrationProtocol = string;
        this._postSet(11, string2, string);
    }

    public int getThreadPoolSize() {
        return this._ThreadPoolSize;
    }

    public boolean isThreadPoolSizeSet() {
        return this._isSet(12);
    }

    public void setThreadPoolSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"ThreadPoolSize", (long)n, (long)0L, (long)65534L);
        int n2 = this._ThreadPoolSize;
        this._ThreadPoolSize = n;
        this._postSet(12, n2, n);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public int getSystemThreadPoolSize() {
        return this._SystemThreadPoolSize;
    }

    public boolean isSystemThreadPoolSizeSet() {
        return this._isSet(13);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setSystemThreadPoolSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"SystemThreadPoolSize", (long)n, (long)5L, (long)65534L);
        int n2 = this._SystemThreadPoolSize;
        this._SystemThreadPoolSize = n;
        this._postSet(13, n2, n);
    }

    public void setSelfTuningThreadPoolSizeMin(int n) {
        LegalChecks.checkInRange((String)"SelfTuningThreadPoolSizeMin", (long)n, (long)1L, (long)65534L);
        int n2 = this._SelfTuningThreadPoolSizeMin;
        this._SelfTuningThreadPoolSizeMin = n;
        this._postSet(14, n2, n);
    }

    public int getSelfTuningThreadPoolSizeMin() {
        return this._SelfTuningThreadPoolSizeMin;
    }

    public boolean isSelfTuningThreadPoolSizeMinSet() {
        return this._isSet(14);
    }

    public void setSelfTuningThreadPoolSizeMax(int n) {
        LegalChecks.checkInRange((String)"SelfTuningThreadPoolSizeMax", (long)n, (long)1L, (long)65534L);
        int n2 = this._SelfTuningThreadPoolSizeMax;
        this._SelfTuningThreadPoolSizeMax = n;
        this._postSet(15, n2, n);
    }

    public int getSelfTuningThreadPoolSizeMax() {
        return this._SelfTuningThreadPoolSizeMax;
    }

    public boolean isSelfTuningThreadPoolSizeMaxSet() {
        return this._isSet(15);
    }

    public int getJMSThreadPoolSize() {
        return this._JMSThreadPoolSize;
    }

    public boolean isJMSThreadPoolSizeSet() {
        return this._isSet(16);
    }

    public void setJMSThreadPoolSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"JMSThreadPoolSize", (long)n, (long)0L, (long)65534L);
        int n2 = this._JMSThreadPoolSize;
        this._JMSThreadPoolSize = n;
        this._postSet(16, n2, n);
    }

    public boolean isNativeIOEnabled() {
        return this._NativeIOEnabled;
    }

    public boolean isNativeIOEnabledSet() {
        return this._isSet(17);
    }

    public void setNativeIOEnabled(boolean bl) {
        boolean bl2 = this._NativeIOEnabled;
        this._NativeIOEnabled = bl;
        this._postSet(17, bl2, bl);
    }

    public void setDevPollDisabled(boolean bl) {
        boolean bl2 = this._DevPollDisabled;
        this._DevPollDisabled = bl;
        this._postSet(18, bl2, bl);
    }

    public boolean isDevPollDisabled() {
        return this._DevPollDisabled;
    }

    public boolean isDevPollDisabledSet() {
        return this._isSet(18);
    }

    public String getMuxerClass() {
        if (!this._isSet(19)) {
            try {
                return ((DomainMBean)this.getParent()).isExalogicOptimizationsEnabled() ? "weblogic.socket.NIOSocketMuxer" : null;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._MuxerClass;
    }

    public boolean isMuxerClassSet() {
        return this._isSet(19);
    }

    public void setMuxerClass(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._MuxerClass;
        this._MuxerClass = string;
        this._postSet(19, string2, string);
    }

    public int getSocketReaders() {
        return this._SocketReaders;
    }

    public boolean isSocketReadersSet() {
        return this._isSet(20);
    }

    public void setSocketReaders(int n) {
        LegalChecks.checkInRange((String)"SocketReaders", (long)n, (long)-1L, (long)65534L);
        int n2 = this._SocketReaders;
        this._SocketReaders = n;
        this._postSet(20, n2, n);
    }

    public int getThreadPoolPercentSocketReaders() {
        return this._ThreadPoolPercentSocketReaders;
    }

    public boolean isThreadPoolPercentSocketReadersSet() {
        return this._isSet(21);
    }

    public void setThreadPoolPercentSocketReaders(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"ThreadPoolPercentSocketReaders", (long)n, (long)1L, (long)99L);
        int n2 = this._ThreadPoolPercentSocketReaders;
        this._ThreadPoolPercentSocketReaders = n;
        this._postSet(21, n2, n);
    }

    public int getSocketReaderTimeoutMinMillis() {
        return this._SocketReaderTimeoutMinMillis;
    }

    public boolean isSocketReaderTimeoutMinMillisSet() {
        return this._isSet(22);
    }

    public void setSocketReaderTimeoutMinMillis(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"SocketReaderTimeoutMinMillis", (long)n, (long)0L, (long)65534L);
        int n2 = this._SocketReaderTimeoutMinMillis;
        this._SocketReaderTimeoutMinMillis = n;
        this._postSet(22, n2, n);
    }

    public int getSocketReaderTimeoutMaxMillis() {
        return this._SocketReaderTimeoutMaxMillis;
    }

    public boolean isSocketReaderTimeoutMaxMillisSet() {
        return this._isSet(23);
    }

    public void setSocketReaderTimeoutMaxMillis(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"SocketReaderTimeoutMaxMillis", (long)n, (long)0L, (long)65534L);
        int n2 = this._SocketReaderTimeoutMaxMillis;
        this._SocketReaderTimeoutMaxMillis = n;
        this._postSet(23, n2, n);
    }

    public boolean isOutboundEnabled() {
        return this._OutboundEnabled;
    }

    public boolean isOutboundEnabledSet() {
        return this._isSet(24);
    }

    public void setOutboundEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._OutboundEnabled;
        this._OutboundEnabled = bl;
        this._postSet(24, bl2, bl);
    }

    public boolean isOutboundPrivateKeyEnabled() {
        return this._OutboundPrivateKeyEnabled;
    }

    public boolean isOutboundPrivateKeyEnabledSet() {
        return this._isSet(25);
    }

    public void setOutboundPrivateKeyEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._OutboundPrivateKeyEnabled;
        this._OutboundPrivateKeyEnabled = bl;
        this._postSet(25, bl2, bl);
    }

    public int getMaxMessageSize() {
        return this._MaxMessageSize;
    }

    public boolean isMaxMessageSizeSet() {
        return this._isSet(26);
    }

    public void setMaxMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxMessageSize", (long)n, (long)4096L, (long)2000000000L);
        int n2 = this._MaxMessageSize;
        this._MaxMessageSize = n;
        this._postSet(26, n2, n);
    }

    public int getMaxT3MessageSize() {
        return this._MaxT3MessageSize;
    }

    public boolean isMaxT3MessageSizeSet() {
        return this._isSet(27);
    }

    public void setMaxT3MessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        KernelValidator.validateMaxT3MessageSize(n);
        int n2 = this._MaxT3MessageSize;
        this._MaxT3MessageSize = n;
        this._postSet(27, n2, n);
    }

    public void setSocketBufferSizeAsChunkSize(boolean bl) throws DistributedManagementException {
        boolean bl2 = this._SocketBufferSizeAsChunkSize;
        this._SocketBufferSizeAsChunkSize = bl;
        this._postSet(28, bl2, bl);
    }

    public boolean isSocketBufferSizeAsChunkSize() {
        return this._SocketBufferSizeAsChunkSize;
    }

    public boolean isSocketBufferSizeAsChunkSizeSet() {
        return this._isSet(28);
    }

    public int getMaxHTTPMessageSize() {
        return this._MaxHTTPMessageSize;
    }

    public boolean isMaxHTTPMessageSizeSet() {
        return this._isSet(29);
    }

    public void setMaxHTTPMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        KernelValidator.validateMaxHTTPMessageSize(n);
        int n2 = this._MaxHTTPMessageSize;
        this._MaxHTTPMessageSize = n;
        this._postSet(29, n2, n);
    }

    public int getMaxCOMMessageSize() {
        return this._MaxCOMMessageSize;
    }

    public boolean isMaxCOMMessageSizeSet() {
        return this._isSet(30);
    }

    public void setMaxCOMMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        KernelValidator.validateMaxCommMessageSize(n);
        int n2 = this._MaxCOMMessageSize;
        this._MaxCOMMessageSize = n;
        this._postSet(30, n2, n);
    }

    public int getMaxIIOPMessageSize() {
        return this._MaxIIOPMessageSize;
    }

    public boolean isMaxIIOPMessageSizeSet() {
        return this._isSet(31);
    }

    public void setMaxIIOPMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        KernelValidator.validateMaxIIOPMessageSize(n);
        int n2 = this._MaxIIOPMessageSize;
        this._MaxIIOPMessageSize = n;
        this._postSet(31, n2, n);
    }

    public int getDefaultGIOPMinorVersion() {
        return this._DefaultGIOPMinorVersion;
    }

    public boolean isDefaultGIOPMinorVersionSet() {
        return this._isSet(32);
    }

    public void setDefaultGIOPMinorVersion(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"DefaultGIOPMinorVersion", (long)n, (long)0L, (long)2L);
        int n2 = this._DefaultGIOPMinorVersion;
        this._DefaultGIOPMinorVersion = n;
        this._postSet(32, n2, n);
    }

    public boolean getUseIIOPLocateRequest() {
        return this._UseIIOPLocateRequest;
    }

    public boolean isUseIIOPLocateRequestSet() {
        return this._isSet(33);
    }

    public void setUseIIOPLocateRequest(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._UseIIOPLocateRequest;
        this._UseIIOPLocateRequest = bl;
        this._postSet(33, bl2, bl);
    }

    public String getIIOPTxMechanism() {
        return this._IIOPTxMechanism;
    }

    public boolean isIIOPTxMechanismSet() {
        return this._isSet(34);
    }

    public void setIIOPTxMechanism(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"ots", "jta"};
        string = LegalChecks.checkInEnum((String)"IIOPTxMechanism", (String)string, (String[])stringArray);
        String string2 = this._IIOPTxMechanism;
        this._IIOPTxMechanism = string;
        this._postSet(34, string2, string);
    }

    public String getIIOPLocationForwardPolicy() {
        return this._IIOPLocationForwardPolicy;
    }

    public boolean isIIOPLocationForwardPolicySet() {
        return this._isSet(35);
    }

    public void setIIOPLocationForwardPolicy(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"off", "failover", "round-robin", "random"};
        string = LegalChecks.checkInEnum((String)"IIOPLocationForwardPolicy", (String)string, (String[])stringArray);
        String string2 = this._IIOPLocationForwardPolicy;
        this._IIOPLocationForwardPolicy = string;
        this._postSet(35, string2, string);
    }

    public int getConnectTimeout() {
        return this._ConnectTimeout;
    }

    public boolean isConnectTimeoutSet() {
        return this._isSet(36);
    }

    public void setConnectTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"ConnectTimeout", (long)n, (long)0L, (long)240L);
        int n2 = this._ConnectTimeout;
        this._ConnectTimeout = n;
        this._postSet(36, n2, n);
    }

    public int getCompleteMessageTimeout() {
        return this._CompleteMessageTimeout;
    }

    public boolean isCompleteMessageTimeoutSet() {
        return this._isSet(37);
    }

    public void setCompleteMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteMessageTimeout", (long)n, (long)0L, (long)480L);
        int n2 = this._CompleteMessageTimeout;
        this._CompleteMessageTimeout = n;
        this._postSet(37, n2, n);
    }

    public int getCompleteT3MessageTimeout() {
        return this._CompleteT3MessageTimeout;
    }

    public boolean isCompleteT3MessageTimeoutSet() {
        return this._isSet(38);
    }

    public void setCompleteT3MessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteT3MessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteT3MessageTimeout;
        this._CompleteT3MessageTimeout = n;
        this._postSet(38, n2, n);
    }

    public int getCompleteHTTPMessageTimeout() {
        return this._CompleteHTTPMessageTimeout;
    }

    public boolean isCompleteHTTPMessageTimeoutSet() {
        return this._isSet(39);
    }

    public void setCompleteHTTPMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteHTTPMessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteHTTPMessageTimeout;
        this._CompleteHTTPMessageTimeout = n;
        this._postSet(39, n2, n);
    }

    public int getCompleteCOMMessageTimeout() {
        return this._CompleteCOMMessageTimeout;
    }

    public boolean isCompleteCOMMessageTimeoutSet() {
        return this._isSet(40);
    }

    public void setCompleteCOMMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteCOMMessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteCOMMessageTimeout;
        this._CompleteCOMMessageTimeout = n;
        this._postSet(40, n2, n);
    }

    public int getIdleConnectionTimeout() {
        return this._IdleConnectionTimeout;
    }

    public boolean isIdleConnectionTimeoutSet() {
        return this._isSet(41);
    }

    public void setIdleConnectionTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"IdleConnectionTimeout", (int)n, (int)0);
        int n2 = this._IdleConnectionTimeout;
        this._IdleConnectionTimeout = n;
        this._postSet(41, n2, n);
    }

    public int getIdleIIOPConnectionTimeout() {
        return this._IdleIIOPConnectionTimeout;
    }

    public boolean isIdleIIOPConnectionTimeoutSet() {
        return this._isSet(42);
    }

    public void setIdleIIOPConnectionTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"IdleIIOPConnectionTimeout", (int)n, (int)-1);
        int n2 = this._IdleIIOPConnectionTimeout;
        this._IdleIIOPConnectionTimeout = n;
        this._postSet(42, n2, n);
    }

    public int getCompleteIIOPMessageTimeout() {
        return this._CompleteIIOPMessageTimeout;
    }

    public boolean isCompleteIIOPMessageTimeoutSet() {
        return this._isSet(43);
    }

    public void setCompleteIIOPMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteIIOPMessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteIIOPMessageTimeout;
        this._CompleteIIOPMessageTimeout = n;
        this._postSet(43, n2, n);
    }

    public int getPeriodLength() {
        return this._PeriodLength;
    }

    public boolean isPeriodLengthSet() {
        return this._isSet(44);
    }

    public void setPeriodLength(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"PeriodLength", (int)n, (int)0);
        int n2 = this._PeriodLength;
        this._PeriodLength = n;
        this._postSet(44, n2, n);
    }

    public int getIdlePeriodsUntilTimeout() {
        return this._IdlePeriodsUntilTimeout;
    }

    public boolean isIdlePeriodsUntilTimeoutSet() {
        return this._isSet(45);
    }

    public void setIdlePeriodsUntilTimeout(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"IdlePeriodsUntilTimeout", (long)n, (long)4L, (long)65534L);
        int n2 = this._IdlePeriodsUntilTimeout;
        this._IdlePeriodsUntilTimeout = n;
        this._postSet(45, n2, n);
    }

    public int getRjvmIdleTimeout() {
        return this._RjvmIdleTimeout;
    }

    public boolean isRjvmIdleTimeoutSet() {
        return this._isSet(46);
    }

    public void setRjvmIdleTimeout(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RjvmIdleTimeout", (long)n, (long)0L, (long)900000L);
        int n2 = this._RjvmIdleTimeout;
        this._RjvmIdleTimeout = n;
        this._postSet(46, n2, n);
    }

    public int getResponseTimeout() {
        return this._ResponseTimeout;
    }

    public boolean isResponseTimeoutSet() {
        return this._isSet(47);
    }

    public void setResponseTimeout(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ResponseTimeout", (long)n, (long)0L, (long)65534L);
        int n2 = this._ResponseTimeout;
        this._ResponseTimeout = n;
        this._postSet(47, n2, n);
    }

    public KernelDebugMBean getKernelDebug() {
        return this._customizer.getKernelDebug();
    }

    public boolean isKernelDebugSet() {
        return this._isSet(48);
    }

    public void setKernelDebug(KernelDebugMBean kernelDebugMBean) throws InvalidAttributeValueException {
        this._KernelDebug = kernelDebugMBean;
    }

    public int getDGCIdlePeriodsUntilTimeout() {
        return this._DGCIdlePeriodsUntilTimeout;
    }

    public boolean isDGCIdlePeriodsUntilTimeoutSet() {
        return this._isSet(49);
    }

    public void setDGCIdlePeriodsUntilTimeout(int n) throws ConfigurationException {
        int n2 = this._DGCIdlePeriodsUntilTimeout;
        this._DGCIdlePeriodsUntilTimeout = n;
        this._postSet(49, n2, n);
    }

    public SSLMBean getSSL() {
        return this._SSL;
    }

    public boolean isSSLSet() {
        return this._isSet(50) || this._isAnythingSet((AbstractDescriptorBean)this.getSSL());
    }

    public void setSSL(SSLMBean sSLMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sSLMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 50)) {
            this._postCreate(abstractDescriptorBean);
        }
        SSLMBean sSLMBean2 = this._SSL;
        this._SSL = sSLMBean;
        this._postSet(50, sSLMBean2, sSLMBean);
    }

    public IIOPMBean getIIOP() {
        return this._IIOP;
    }

    public boolean isIIOPSet() {
        return this._isSet(51) || this._isAnythingSet((AbstractDescriptorBean)this.getIIOP());
    }

    public void setIIOP(IIOPMBean iIOPMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)iIOPMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 51)) {
            this._postCreate(abstractDescriptorBean);
        }
        IIOPMBean iIOPMBean2 = this._IIOP;
        this._IIOP = iIOPMBean;
        this._postSet(51, iIOPMBean2, iIOPMBean);
    }

    public LogMBean getLog() {
        return this._Log;
    }

    public boolean isLogSet() {
        return this._isSet(52) || this._isAnythingSet((AbstractDescriptorBean)this.getLog());
    }

    public void setLog(LogMBean logMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)logMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 52)) {
            this._postCreate(abstractDescriptorBean);
        }
        LogMBean logMBean2 = this._Log;
        this._Log = logMBean;
        this._postSet(52, logMBean2, logMBean);
    }

    public boolean isStdoutEnabled() {
        return this._customizer.isStdoutEnabled();
    }

    public boolean isStdoutEnabledSet() {
        return this._isSet(53);
    }

    public void setStdoutEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this.isStdoutEnabled();
        this._customizer.setStdoutEnabled(bl);
        this._postSet(53, bl2, bl);
    }

    public int getStdoutSeverityLevel() {
        return this._customizer.getStdoutSeverityLevel();
    }

    public boolean isStdoutSeverityLevelSet() {
        return this._isSet(54);
    }

    public void setStdoutSeverityLevel(int n) throws InvalidAttributeValueException, DistributedManagementException {
        int[] nArray = new int[]{256, 128, 64, 16, 8, 32, 4, 2, 1, 0};
        n = LegalChecks.checkInEnum((String)"StdoutSeverityLevel", (int)n, (int[])nArray);
        int n2 = this.getStdoutSeverityLevel();
        this._customizer.setStdoutSeverityLevel(n);
        this._postSet(54, n2, n);
    }

    public boolean isStdoutDebugEnabled() {
        return this._customizer.isStdoutDebugEnabled();
    }

    public boolean isStdoutDebugEnabledSet() {
        return this._isSet(55);
    }

    public void setStdoutDebugEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this.isStdoutDebugEnabled();
        this._customizer.setStdoutDebugEnabled(bl);
        this._postSet(55, bl2, bl);
    }

    public boolean isLogRemoteExceptionsEnabled() {
        return this._LogRemoteExceptionsEnabled;
    }

    public boolean isLogRemoteExceptionsEnabledSet() {
        return this._isSet(56);
    }

    public void setLogRemoteExceptionsEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this._LogRemoteExceptionsEnabled;
        this._LogRemoteExceptionsEnabled = bl;
        this._postSet(56, bl2, bl);
    }

    public boolean isInstrumentStackTraceEnabled() {
        return this._InstrumentStackTraceEnabled;
    }

    public boolean isInstrumentStackTraceEnabledSet() {
        return this._isSet(57);
    }

    public void setInstrumentStackTraceEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this._InstrumentStackTraceEnabled;
        this._InstrumentStackTraceEnabled = bl;
        this._postSet(57, bl2, bl);
    }

    public void addExecuteQueue(ExecuteQueueMBean executeQueueMBean) {
        this._getHelper()._ensureNonNull((Object)executeQueueMBean);
        if (!((AbstractDescriptorBean)executeQueueMBean).isChildProperty((DescriptorBean)this, 58)) {
            ExecuteQueueMBean[] executeQueueMBeanArray = this._isSet(58) ? (ExecuteQueueMBean[])this._getHelper()._extendArray((Object)this.getExecuteQueues(), ExecuteQueueMBean.class, (Object)executeQueueMBean) : new ExecuteQueueMBean[]{executeQueueMBean};
            try {
                this.setExecuteQueues(executeQueueMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ExecuteQueueMBean[] getExecuteQueues() {
        return this._ExecuteQueues;
    }

    public boolean isExecuteQueuesSet() {
        return this._isSet(58);
    }

    public void removeExecuteQueue(ExecuteQueueMBean executeQueueMBean) {
        this.destroyExecuteQueue(executeQueueMBean);
    }

    public void setExecuteQueues(ExecuteQueueMBean[] executeQueueMBeanArray) throws InvalidAttributeValueException {
        executeQueueMBeanArray = executeQueueMBeanArray == null ? new ExecuteQueueMBeanImpl[]{} : executeQueueMBeanArray;
        for (int i = 0; i < executeQueueMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)executeQueueMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 58)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        ExecuteQueueMBean[] executeQueueMBeanArray2 = this._ExecuteQueues;
        this._ExecuteQueues = executeQueueMBeanArray;
        this._postSet(58, executeQueueMBeanArray2, executeQueueMBeanArray);
    }

    public int getMaxOpenSockCount() {
        return this._MaxOpenSockCount;
    }

    public boolean isMaxOpenSockCountSet() {
        return this._isSet(59);
    }

    public void setMaxOpenSockCount(int n) {
        LegalChecks.checkInRange((String)"MaxOpenSockCount", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this._MaxOpenSockCount;
        this._MaxOpenSockCount = n;
        this._postSet(59, n2, n);
    }

    public String getStdoutFormat() {
        return this._customizer.getStdoutFormat();
    }

    public boolean isStdoutFormatSet() {
        return this._isSet(60);
    }

    public void setStdoutFormat(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"standard", "noid"};
        string = LegalChecks.checkInEnum((String)"StdoutFormat", (String)string, (String[])stringArray);
        String string2 = this.getStdoutFormat();
        this._customizer.setStdoutFormat(string);
        this._postSet(60, string2, string);
    }

    public boolean isStdoutLogStack() {
        return this._customizer.isStdoutLogStack();
    }

    public boolean isStdoutLogStackSet() {
        return this._isSet(61);
    }

    public void setStdoutLogStack(boolean bl) {
        boolean bl2 = this.isStdoutLogStack();
        this._customizer.setStdoutLogStack(bl);
        this._postSet(61, bl2, bl);
    }

    public int getStuckThreadMaxTime() {
        return this._StuckThreadMaxTime;
    }

    public boolean isStuckThreadMaxTimeSet() {
        return this._isSet(62);
    }

    public void setStuckThreadMaxTime(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"StuckThreadMaxTime", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._StuckThreadMaxTime;
        this._StuckThreadMaxTime = n;
        this._postSet(62, n2, n);
    }

    public int getStuckThreadTimerInterval() {
        return this._StuckThreadTimerInterval;
    }

    public boolean isStuckThreadTimerIntervalSet() {
        return this._isSet(63);
    }

    public void setStuckThreadTimerInterval(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"StuckThreadTimerInterval", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._StuckThreadTimerInterval;
        this._StuckThreadTimerInterval = n;
        this._postSet(63, n2, n);
    }

    public boolean getTracingEnabled() {
        return this._TracingEnabled;
    }

    public boolean isTracingEnabledSet() {
        return this._isSet(64);
    }

    public void setTracingEnabled(boolean bl) {
        boolean bl2 = this._TracingEnabled;
        this._TracingEnabled = bl;
        this._postSet(64, bl2, bl);
    }

    public int getMessagingBridgeThreadPoolSize() {
        return this._MessagingBridgeThreadPoolSize;
    }

    public boolean isMessagingBridgeThreadPoolSizeSet() {
        return this._isSet(65);
    }

    public void setMessagingBridgeThreadPoolSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagingBridgeThreadPoolSize", (long)n, (long)-1L, (long)65534L);
        int n2 = this._MessagingBridgeThreadPoolSize;
        this._MessagingBridgeThreadPoolSize = n;
        this._postSet(65, n2, n);
    }

    public int getMTUSize() {
        return this._MTUSize;
    }

    public boolean isMTUSizeSet() {
        return this._isSet(66);
    }

    public void setMTUSize(int n) {
        int n2 = this._MTUSize;
        this._MTUSize = n;
        this._postSet(66, n2, n);
    }

    public void setLoadStubUsingContextClassLoader(boolean bl) {
        boolean bl2 = this._LoadStubUsingContextClassLoader;
        this._LoadStubUsingContextClassLoader = bl;
        this._postSet(67, bl2, bl);
    }

    public boolean getLoadStubUsingContextClassLoader() {
        return this._LoadStubUsingContextClassLoader;
    }

    public boolean isLoadStubUsingContextClassLoaderSet() {
        return this._isSet(67);
    }

    public void setRefreshClientRuntimeDescriptor(boolean bl) {
        boolean bl2 = this._RefreshClientRuntimeDescriptor;
        this._RefreshClientRuntimeDescriptor = bl;
        this._postSet(68, bl2, bl);
    }

    public boolean getRefreshClientRuntimeDescriptor() {
        return this._RefreshClientRuntimeDescriptor;
    }

    public boolean isRefreshClientRuntimeDescriptorSet() {
        return this._isSet(68);
    }

    public void setTimedOutRefIsolationTime(long l) {
        long l2 = this._TimedOutRefIsolationTime;
        this._TimedOutRefIsolationTime = l;
        this._postSet(69, l2, l);
    }

    public long getTimedOutRefIsolationTime() {
        return this._TimedOutRefIsolationTime;
    }

    public boolean isTimedOutRefIsolationTimeSet() {
        return this._isSet(69);
    }

    public void setUse81StyleExecuteQueues(boolean bl) {
        boolean bl2 = this._Use81StyleExecuteQueues;
        this._Use81StyleExecuteQueues = bl;
        this._postSet(70, bl2, bl);
    }

    public boolean getUse81StyleExecuteQueues() {
        return this._Use81StyleExecuteQueues;
    }

    public boolean isUse81StyleExecuteQueuesSet() {
        return this._isSet(70);
    }

    public void setT3ClientAbbrevTableSize(int n) {
        LegalChecks.checkInRange((String)"T3ClientAbbrevTableSize", (long)n, (long)255L, (long)1024L);
        int n2 = this._T3ClientAbbrevTableSize;
        this._T3ClientAbbrevTableSize = n;
        this._postSet(71, n2, n);
    }

    public int getT3ClientAbbrevTableSize() {
        return this._T3ClientAbbrevTableSize;
    }

    public boolean isT3ClientAbbrevTableSizeSet() {
        return this._isSet(71);
    }

    public void setT3ServerAbbrevTableSize(int n) {
        LegalChecks.checkInRange((String)"T3ServerAbbrevTableSize", (long)n, (long)255L, (long)10240L);
        int n2 = this._T3ServerAbbrevTableSize;
        this._T3ServerAbbrevTableSize = n;
        this._postSet(72, n2, n);
    }

    public int getT3ServerAbbrevTableSize() {
        return this._T3ServerAbbrevTableSize;
    }

    public boolean isT3ServerAbbrevTableSizeSet() {
        return this._isSet(72);
    }

    public ExecuteQueueMBean createExecuteQueue(String string) {
        ExecuteQueueMBeanImpl executeQueueMBeanImpl = new ExecuteQueueMBeanImpl(this, -1);
        try {
            executeQueueMBeanImpl.setName(string);
            this.addExecuteQueue(executeQueueMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return executeQueueMBeanImpl;
    }

    public void destroyExecuteQueue(ExecuteQueueMBean executeQueueMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(executeQueueMBean, 58);
                ExecuteQueueMBean[] executeQueueMBeanArray = this.getExecuteQueues();
                ExecuteQueueMBean[] executeQueueMBeanArray2 = (ExecuteQueueMBean[])this._getHelper()._removeElement((Object)executeQueueMBeanArray, ExecuteQueueMBean.class, (Object)executeQueueMBean);
                if (executeQueueMBeanArray.length == executeQueueMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)executeQueueMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)executeQueueMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setExecuteQueues(executeQueueMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ExecuteQueueMBean lookupExecuteQueue(String string) {
        for (ExecuteQueueMBeanImpl executeQueueMBeanImpl : Arrays.asList((Object[])this._ExecuteQueues)) {
            String string2 = string;
            if (!executeQueueMBeanImpl.getName().equals(string2)) continue;
            return executeQueueMBeanImpl;
        }
        return null;
    }

    public void setGatheredWritesEnabled(boolean bl) {
        boolean bl2 = this._GatheredWritesEnabled;
        this._GatheredWritesEnabled = bl;
        this._postSet(73, bl2, bl);
    }

    public boolean isGatheredWritesEnabled() {
        if (!this._isSet(73)) {
            try {
                return ((DomainMBean)this.getParent()).isExalogicOptimizationsEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._GatheredWritesEnabled;
    }

    public boolean isGatheredWritesEnabledSet() {
        return this._isSet(73);
    }

    public void setScatteredReadsEnabled(boolean bl) {
        boolean bl2 = this._ScatteredReadsEnabled;
        this._ScatteredReadsEnabled = bl;
        this._postSet(74, bl2, bl);
    }

    public boolean isScatteredReadsEnabled() {
        if (!this._isSet(74)) {
            try {
                return ((DomainMBean)this.getParent()).isExalogicOptimizationsEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._ScatteredReadsEnabled;
    }

    public boolean isScatteredReadsEnabledSet() {
        return this._isSet(74);
    }

    public void setAddWorkManagerThreadsByCpuCount(boolean bl) {
        boolean bl2 = this._AddWorkManagerThreadsByCpuCount;
        this._AddWorkManagerThreadsByCpuCount = bl;
        this._postSet(75, bl2, bl);
    }

    public boolean isAddWorkManagerThreadsByCpuCount() {
        if (!this._isSet(75)) {
            try {
                return ((DomainMBean)this.getParent()).isExalogicOptimizationsEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._AddWorkManagerThreadsByCpuCount;
    }

    public boolean isAddWorkManagerThreadsByCpuCountSet() {
        return this._isSet(75);
    }

    public void setUseConcurrentQueueForRequestManager(boolean bl) {
        boolean bl2 = this._UseConcurrentQueueForRequestManager;
        this._UseConcurrentQueueForRequestManager = bl;
        this._postSet(76, bl2, bl);
    }

    public boolean isUseConcurrentQueueForRequestManager() {
        if (!this._isSet(76)) {
            try {
                return ((DomainMBean)this.getParent()).isExalogicOptimizationsEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._UseConcurrentQueueForRequestManager;
    }

    public boolean isUseConcurrentQueueForRequestManagerSet() {
        return this._isSet(76);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet() || this.isIIOPSet() || this.isLogSet() || this.isSSLSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._AdministrationProtocol = null;
                    if (bl) break;
                }
                case 40: {
                    this._CompleteCOMMessageTimeout = -1;
                    if (bl) break;
                }
                case 39: {
                    this._CompleteHTTPMessageTimeout = -1;
                    if (bl) break;
                }
                case 43: {
                    this._CompleteIIOPMessageTimeout = -1;
                    if (bl) break;
                }
                case 37: {
                    this._CompleteMessageTimeout = 60;
                    if (bl) break;
                }
                case 38: {
                    this._CompleteT3MessageTimeout = -1;
                    if (bl) break;
                }
                case 36: {
                    this._ConnectTimeout = 0;
                    if (bl) break;
                }
                case 49: {
                    this._DGCIdlePeriodsUntilTimeout = 5;
                    if (bl) break;
                }
                case 32: {
                    this._DefaultGIOPMinorVersion = 2;
                    if (bl) break;
                }
                case 9: {
                    this._DefaultProtocol = "t3";
                    if (bl) break;
                }
                case 10: {
                    this._DefaultSecureProtocol = "t3s";
                    if (bl) break;
                }
                case 58: {
                    this._ExecuteQueues = new ExecuteQueueMBean[0];
                    if (bl) break;
                }
                case 51: {
                    this._IIOP = new IIOPMBeanImpl(this, 51);
                    this._postCreate((AbstractDescriptorBean)this._IIOP);
                    if (bl) break;
                }
                case 35: {
                    this._IIOPLocationForwardPolicy = "off";
                    if (bl) break;
                }
                case 34: {
                    this._IIOPTxMechanism = "ots";
                    if (bl) break;
                }
                case 41: {
                    this._IdleConnectionTimeout = 65;
                    if (bl) break;
                }
                case 42: {
                    this._IdleIIOPConnectionTimeout = -1;
                    if (bl) break;
                }
                case 45: {
                    this._IdlePeriodsUntilTimeout = 4;
                    if (bl) break;
                }
                case 16: {
                    this._JMSThreadPoolSize = 15;
                    if (bl) break;
                }
                case 48: {
                    this._KernelDebug = null;
                    if (bl) break;
                }
                case 67: {
                    this._LoadStubUsingContextClassLoader = false;
                    if (bl) break;
                }
                case 52: {
                    this._Log = new LogMBeanImpl(this, 52);
                    this._postCreate((AbstractDescriptorBean)this._Log);
                    if (bl) break;
                }
                case 66: {
                    this._MTUSize = 1500;
                    if (bl) break;
                }
                case 30: {
                    this._MaxCOMMessageSize = -1;
                    if (bl) break;
                }
                case 29: {
                    this._MaxHTTPMessageSize = -1;
                    if (bl) break;
                }
                case 31: {
                    this._MaxIIOPMessageSize = -1;
                    if (bl) break;
                }
                case 26: {
                    this._MaxMessageSize = 10000000;
                    if (bl) break;
                }
                case 59: {
                    this._MaxOpenSockCount = -1;
                    if (bl) break;
                }
                case 27: {
                    this._MaxT3MessageSize = -1;
                    if (bl) break;
                }
                case 65: {
                    this._MessagingBridgeThreadPoolSize = 5;
                    if (bl) break;
                }
                case 19: {
                    this._MuxerClass = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 44: {
                    this._PeriodLength = 60000;
                    if (bl) break;
                }
                case 68: {
                    this._RefreshClientRuntimeDescriptor = false;
                    if (bl) break;
                }
                case 47: {
                    this._ResponseTimeout = 0;
                    if (bl) break;
                }
                case 46: {
                    this._RjvmIdleTimeout = 0;
                    if (bl) break;
                }
                case 50: {
                    this._SSL = new SSLMBeanImpl(this, 50);
                    this._postCreate((AbstractDescriptorBean)this._SSL);
                    if (bl) break;
                }
                case 15: {
                    this._SelfTuningThreadPoolSizeMax = 400;
                    if (bl) break;
                }
                case 14: {
                    this._SelfTuningThreadPoolSizeMin = 1;
                    if (bl) break;
                }
                case 23: {
                    this._SocketReaderTimeoutMaxMillis = 100;
                    if (bl) break;
                }
                case 22: {
                    this._SocketReaderTimeoutMinMillis = 10;
                    if (bl) break;
                }
                case 20: {
                    this._SocketReaders = -1;
                    if (bl) break;
                }
                case 60: {
                    this._customizer.setStdoutFormat("standard");
                    if (bl) break;
                }
                case 54: {
                    this._customizer.setStdoutSeverityLevel(32);
                    if (bl) break;
                }
                case 62: {
                    this._StuckThreadMaxTime = 600;
                    if (bl) break;
                }
                case 63: {
                    this._StuckThreadTimerInterval = 60;
                    if (bl) break;
                }
                case 13: {
                    this._SystemThreadPoolSize = 5;
                    if (bl) break;
                }
                case 71: {
                    this._T3ClientAbbrevTableSize = 255;
                    if (bl) break;
                }
                case 72: {
                    this._T3ServerAbbrevTableSize = 2048;
                    if (bl) break;
                }
                case 21: {
                    this._ThreadPoolPercentSocketReaders = 33;
                    if (bl) break;
                }
                case 12: {
                    this._ThreadPoolSize = 15;
                    if (bl) break;
                }
                case 69: {
                    this._TimedOutRefIsolationTime = 0L;
                    if (bl) break;
                }
                case 64: {
                    this._TracingEnabled = false;
                    if (bl) break;
                }
                case 70: {
                    this._Use81StyleExecuteQueues = false;
                    if (bl) break;
                }
                case 33: {
                    this._UseIIOPLocateRequest = false;
                    if (bl) break;
                }
                case 7: {
                    this._ValidProtocols = null;
                    if (bl) break;
                }
                case 75: {
                    this._AddWorkManagerThreadsByCpuCount = false;
                    if (bl) break;
                }
                case 18: {
                    this._DevPollDisabled = false;
                    if (bl) break;
                }
                case 73: {
                    this._GatheredWritesEnabled = false;
                    if (bl) break;
                }
                case 57: {
                    this._InstrumentStackTraceEnabled = true;
                    if (bl) break;
                }
                case 56: {
                    this._LogRemoteExceptionsEnabled = false;
                    if (bl) break;
                }
                case 17: {
                    this._NativeIOEnabled = true;
                    if (bl) break;
                }
                case 24: {
                    this._OutboundEnabled = false;
                    if (bl) break;
                }
                case 25: {
                    this._OutboundPrivateKeyEnabled = false;
                    if (bl) break;
                }
                case 8: {
                    this._ReverseDNSAllowed = false;
                    if (bl) break;
                }
                case 74: {
                    this._ScatteredReadsEnabled = false;
                    if (bl) break;
                }
                case 28: {
                    this._SocketBufferSizeAsChunkSize = false;
                    if (bl) break;
                }
                case 55: {
                    this._customizer.setStdoutDebugEnabled(false);
                    if (bl) break;
                }
                case 53: {
                    this._customizer.setStdoutEnabled(true);
                    if (bl) break;
                }
                case 61: {
                    this._customizer.setStdoutLogStack(true);
                    if (bl) break;
                }
                case 76: {
                    this._UseConcurrentQueueForRequestManager = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Kernel";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AddWorkManagerThreadsByCpuCount")) {
            boolean bl = this._AddWorkManagerThreadsByCpuCount;
            this._AddWorkManagerThreadsByCpuCount = (Boolean)object;
            this._postSet(75, bl, this._AddWorkManagerThreadsByCpuCount);
            return;
        }
        if (string.equals("AdministrationProtocol")) {
            String string2 = this._AdministrationProtocol;
            this._AdministrationProtocol = (String)object;
            this._postSet(11, string2, this._AdministrationProtocol);
            return;
        }
        if (string.equals("CompleteCOMMessageTimeout")) {
            int n = this._CompleteCOMMessageTimeout;
            this._CompleteCOMMessageTimeout = (Integer)object;
            this._postSet(40, n, this._CompleteCOMMessageTimeout);
            return;
        }
        if (string.equals("CompleteHTTPMessageTimeout")) {
            int n = this._CompleteHTTPMessageTimeout;
            this._CompleteHTTPMessageTimeout = (Integer)object;
            this._postSet(39, n, this._CompleteHTTPMessageTimeout);
            return;
        }
        if (string.equals("CompleteIIOPMessageTimeout")) {
            int n = this._CompleteIIOPMessageTimeout;
            this._CompleteIIOPMessageTimeout = (Integer)object;
            this._postSet(43, n, this._CompleteIIOPMessageTimeout);
            return;
        }
        if (string.equals("CompleteMessageTimeout")) {
            int n = this._CompleteMessageTimeout;
            this._CompleteMessageTimeout = (Integer)object;
            this._postSet(37, n, this._CompleteMessageTimeout);
            return;
        }
        if (string.equals("CompleteT3MessageTimeout")) {
            int n = this._CompleteT3MessageTimeout;
            this._CompleteT3MessageTimeout = (Integer)object;
            this._postSet(38, n, this._CompleteT3MessageTimeout);
            return;
        }
        if (string.equals("ConnectTimeout")) {
            int n = this._ConnectTimeout;
            this._ConnectTimeout = (Integer)object;
            this._postSet(36, n, this._ConnectTimeout);
            return;
        }
        if (string.equals("DGCIdlePeriodsUntilTimeout")) {
            int n = this._DGCIdlePeriodsUntilTimeout;
            this._DGCIdlePeriodsUntilTimeout = (Integer)object;
            this._postSet(49, n, this._DGCIdlePeriodsUntilTimeout);
            return;
        }
        if (string.equals("DefaultGIOPMinorVersion")) {
            int n = this._DefaultGIOPMinorVersion;
            this._DefaultGIOPMinorVersion = (Integer)object;
            this._postSet(32, n, this._DefaultGIOPMinorVersion);
            return;
        }
        if (string.equals("DefaultProtocol")) {
            String string3 = this._DefaultProtocol;
            this._DefaultProtocol = (String)object;
            this._postSet(9, string3, this._DefaultProtocol);
            return;
        }
        if (string.equals("DefaultSecureProtocol")) {
            String string4 = this._DefaultSecureProtocol;
            this._DefaultSecureProtocol = (String)object;
            this._postSet(10, string4, this._DefaultSecureProtocol);
            return;
        }
        if (string.equals("DevPollDisabled")) {
            boolean bl = this._DevPollDisabled;
            this._DevPollDisabled = (Boolean)object;
            this._postSet(18, bl, this._DevPollDisabled);
            return;
        }
        if (string.equals("ExecuteQueues")) {
            ExecuteQueueMBean[] executeQueueMBeanArray = this._ExecuteQueues;
            this._ExecuteQueues = (ExecuteQueueMBean[])object;
            this._postSet(58, executeQueueMBeanArray, this._ExecuteQueues);
            return;
        }
        if (string.equals("GatheredWritesEnabled")) {
            boolean bl = this._GatheredWritesEnabled;
            this._GatheredWritesEnabled = (Boolean)object;
            this._postSet(73, bl, this._GatheredWritesEnabled);
            return;
        }
        if (string.equals("IIOP")) {
            IIOPMBean iIOPMBean = this._IIOP;
            this._IIOP = (IIOPMBean)object;
            this._postSet(51, iIOPMBean, this._IIOP);
            return;
        }
        if (string.equals("IIOPLocationForwardPolicy")) {
            String string5 = this._IIOPLocationForwardPolicy;
            this._IIOPLocationForwardPolicy = (String)object;
            this._postSet(35, string5, this._IIOPLocationForwardPolicy);
            return;
        }
        if (string.equals("IIOPTxMechanism")) {
            String string6 = this._IIOPTxMechanism;
            this._IIOPTxMechanism = (String)object;
            this._postSet(34, string6, this._IIOPTxMechanism);
            return;
        }
        if (string.equals("IdleConnectionTimeout")) {
            int n = this._IdleConnectionTimeout;
            this._IdleConnectionTimeout = (Integer)object;
            this._postSet(41, n, this._IdleConnectionTimeout);
            return;
        }
        if (string.equals("IdleIIOPConnectionTimeout")) {
            int n = this._IdleIIOPConnectionTimeout;
            this._IdleIIOPConnectionTimeout = (Integer)object;
            this._postSet(42, n, this._IdleIIOPConnectionTimeout);
            return;
        }
        if (string.equals("IdlePeriodsUntilTimeout")) {
            int n = this._IdlePeriodsUntilTimeout;
            this._IdlePeriodsUntilTimeout = (Integer)object;
            this._postSet(45, n, this._IdlePeriodsUntilTimeout);
            return;
        }
        if (string.equals("InstrumentStackTraceEnabled")) {
            boolean bl = this._InstrumentStackTraceEnabled;
            this._InstrumentStackTraceEnabled = (Boolean)object;
            this._postSet(57, bl, this._InstrumentStackTraceEnabled);
            return;
        }
        if (string.equals("JMSThreadPoolSize")) {
            int n = this._JMSThreadPoolSize;
            this._JMSThreadPoolSize = (Integer)object;
            this._postSet(16, n, this._JMSThreadPoolSize);
            return;
        }
        if (string.equals("KernelDebug")) {
            KernelDebugMBean kernelDebugMBean = this._KernelDebug;
            this._KernelDebug = (KernelDebugMBean)object;
            this._postSet(48, kernelDebugMBean, this._KernelDebug);
            return;
        }
        if (string.equals("LoadStubUsingContextClassLoader")) {
            boolean bl = this._LoadStubUsingContextClassLoader;
            this._LoadStubUsingContextClassLoader = (Boolean)object;
            this._postSet(67, bl, this._LoadStubUsingContextClassLoader);
            return;
        }
        if (string.equals("Log")) {
            LogMBean logMBean = this._Log;
            this._Log = (LogMBean)object;
            this._postSet(52, logMBean, this._Log);
            return;
        }
        if (string.equals("LogRemoteExceptionsEnabled")) {
            boolean bl = this._LogRemoteExceptionsEnabled;
            this._LogRemoteExceptionsEnabled = (Boolean)object;
            this._postSet(56, bl, this._LogRemoteExceptionsEnabled);
            return;
        }
        if (string.equals("MTUSize")) {
            int n = this._MTUSize;
            this._MTUSize = (Integer)object;
            this._postSet(66, n, this._MTUSize);
            return;
        }
        if (string.equals("MaxCOMMessageSize")) {
            int n = this._MaxCOMMessageSize;
            this._MaxCOMMessageSize = (Integer)object;
            this._postSet(30, n, this._MaxCOMMessageSize);
            return;
        }
        if (string.equals("MaxHTTPMessageSize")) {
            int n = this._MaxHTTPMessageSize;
            this._MaxHTTPMessageSize = (Integer)object;
            this._postSet(29, n, this._MaxHTTPMessageSize);
            return;
        }
        if (string.equals("MaxIIOPMessageSize")) {
            int n = this._MaxIIOPMessageSize;
            this._MaxIIOPMessageSize = (Integer)object;
            this._postSet(31, n, this._MaxIIOPMessageSize);
            return;
        }
        if (string.equals("MaxMessageSize")) {
            int n = this._MaxMessageSize;
            this._MaxMessageSize = (Integer)object;
            this._postSet(26, n, this._MaxMessageSize);
            return;
        }
        if (string.equals("MaxOpenSockCount")) {
            int n = this._MaxOpenSockCount;
            this._MaxOpenSockCount = (Integer)object;
            this._postSet(59, n, this._MaxOpenSockCount);
            return;
        }
        if (string.equals("MaxT3MessageSize")) {
            int n = this._MaxT3MessageSize;
            this._MaxT3MessageSize = (Integer)object;
            this._postSet(27, n, this._MaxT3MessageSize);
            return;
        }
        if (string.equals("MessagingBridgeThreadPoolSize")) {
            int n = this._MessagingBridgeThreadPoolSize;
            this._MessagingBridgeThreadPoolSize = (Integer)object;
            this._postSet(65, n, this._MessagingBridgeThreadPoolSize);
            return;
        }
        if (string.equals("MuxerClass")) {
            String string7 = this._MuxerClass;
            this._MuxerClass = (String)object;
            this._postSet(19, string7, this._MuxerClass);
            return;
        }
        if (string.equals("Name")) {
            String string8 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string8, this._Name);
            return;
        }
        if (string.equals("NativeIOEnabled")) {
            boolean bl = this._NativeIOEnabled;
            this._NativeIOEnabled = (Boolean)object;
            this._postSet(17, bl, this._NativeIOEnabled);
            return;
        }
        if (string.equals("OutboundEnabled")) {
            boolean bl = this._OutboundEnabled;
            this._OutboundEnabled = (Boolean)object;
            this._postSet(24, bl, this._OutboundEnabled);
            return;
        }
        if (string.equals("OutboundPrivateKeyEnabled")) {
            boolean bl = this._OutboundPrivateKeyEnabled;
            this._OutboundPrivateKeyEnabled = (Boolean)object;
            this._postSet(25, bl, this._OutboundPrivateKeyEnabled);
            return;
        }
        if (string.equals("PeriodLength")) {
            int n = this._PeriodLength;
            this._PeriodLength = (Integer)object;
            this._postSet(44, n, this._PeriodLength);
            return;
        }
        if (string.equals("RefreshClientRuntimeDescriptor")) {
            boolean bl = this._RefreshClientRuntimeDescriptor;
            this._RefreshClientRuntimeDescriptor = (Boolean)object;
            this._postSet(68, bl, this._RefreshClientRuntimeDescriptor);
            return;
        }
        if (string.equals("ResponseTimeout")) {
            int n = this._ResponseTimeout;
            this._ResponseTimeout = (Integer)object;
            this._postSet(47, n, this._ResponseTimeout);
            return;
        }
        if (string.equals("ReverseDNSAllowed")) {
            boolean bl = this._ReverseDNSAllowed;
            this._ReverseDNSAllowed = (Boolean)object;
            this._postSet(8, bl, this._ReverseDNSAllowed);
            return;
        }
        if (string.equals("RjvmIdleTimeout")) {
            int n = this._RjvmIdleTimeout;
            this._RjvmIdleTimeout = (Integer)object;
            this._postSet(46, n, this._RjvmIdleTimeout);
            return;
        }
        if (string.equals("SSL")) {
            SSLMBean sSLMBean = this._SSL;
            this._SSL = (SSLMBean)object;
            this._postSet(50, sSLMBean, this._SSL);
            return;
        }
        if (string.equals("ScatteredReadsEnabled")) {
            boolean bl = this._ScatteredReadsEnabled;
            this._ScatteredReadsEnabled = (Boolean)object;
            this._postSet(74, bl, this._ScatteredReadsEnabled);
            return;
        }
        if (string.equals("SelfTuningThreadPoolSizeMax")) {
            int n = this._SelfTuningThreadPoolSizeMax;
            this._SelfTuningThreadPoolSizeMax = (Integer)object;
            this._postSet(15, n, this._SelfTuningThreadPoolSizeMax);
            return;
        }
        if (string.equals("SelfTuningThreadPoolSizeMin")) {
            int n = this._SelfTuningThreadPoolSizeMin;
            this._SelfTuningThreadPoolSizeMin = (Integer)object;
            this._postSet(14, n, this._SelfTuningThreadPoolSizeMin);
            return;
        }
        if (string.equals("SocketBufferSizeAsChunkSize")) {
            boolean bl = this._SocketBufferSizeAsChunkSize;
            this._SocketBufferSizeAsChunkSize = (Boolean)object;
            this._postSet(28, bl, this._SocketBufferSizeAsChunkSize);
            return;
        }
        if (string.equals("SocketReaderTimeoutMaxMillis")) {
            int n = this._SocketReaderTimeoutMaxMillis;
            this._SocketReaderTimeoutMaxMillis = (Integer)object;
            this._postSet(23, n, this._SocketReaderTimeoutMaxMillis);
            return;
        }
        if (string.equals("SocketReaderTimeoutMinMillis")) {
            int n = this._SocketReaderTimeoutMinMillis;
            this._SocketReaderTimeoutMinMillis = (Integer)object;
            this._postSet(22, n, this._SocketReaderTimeoutMinMillis);
            return;
        }
        if (string.equals("SocketReaders")) {
            int n = this._SocketReaders;
            this._SocketReaders = (Integer)object;
            this._postSet(20, n, this._SocketReaders);
            return;
        }
        if (string.equals("StdoutDebugEnabled")) {
            boolean bl = this._StdoutDebugEnabled;
            this._StdoutDebugEnabled = (Boolean)object;
            this._postSet(55, bl, this._StdoutDebugEnabled);
            return;
        }
        if (string.equals("StdoutEnabled")) {
            boolean bl = this._StdoutEnabled;
            this._StdoutEnabled = (Boolean)object;
            this._postSet(53, bl, this._StdoutEnabled);
            return;
        }
        if (string.equals("StdoutFormat")) {
            String string9 = this._StdoutFormat;
            this._StdoutFormat = (String)object;
            this._postSet(60, string9, this._StdoutFormat);
            return;
        }
        if (string.equals("StdoutLogStack")) {
            boolean bl = this._StdoutLogStack;
            this._StdoutLogStack = (Boolean)object;
            this._postSet(61, bl, this._StdoutLogStack);
            return;
        }
        if (string.equals("StdoutSeverityLevel")) {
            int n = this._StdoutSeverityLevel;
            this._StdoutSeverityLevel = (Integer)object;
            this._postSet(54, n, this._StdoutSeverityLevel);
            return;
        }
        if (string.equals("StuckThreadMaxTime")) {
            int n = this._StuckThreadMaxTime;
            this._StuckThreadMaxTime = (Integer)object;
            this._postSet(62, n, this._StuckThreadMaxTime);
            return;
        }
        if (string.equals("StuckThreadTimerInterval")) {
            int n = this._StuckThreadTimerInterval;
            this._StuckThreadTimerInterval = (Integer)object;
            this._postSet(63, n, this._StuckThreadTimerInterval);
            return;
        }
        if (string.equals("SystemThreadPoolSize")) {
            int n = this._SystemThreadPoolSize;
            this._SystemThreadPoolSize = (Integer)object;
            this._postSet(13, n, this._SystemThreadPoolSize);
            return;
        }
        if (string.equals("T3ClientAbbrevTableSize")) {
            int n = this._T3ClientAbbrevTableSize;
            this._T3ClientAbbrevTableSize = (Integer)object;
            this._postSet(71, n, this._T3ClientAbbrevTableSize);
            return;
        }
        if (string.equals("T3ServerAbbrevTableSize")) {
            int n = this._T3ServerAbbrevTableSize;
            this._T3ServerAbbrevTableSize = (Integer)object;
            this._postSet(72, n, this._T3ServerAbbrevTableSize);
            return;
        }
        if (string.equals("ThreadPoolPercentSocketReaders")) {
            int n = this._ThreadPoolPercentSocketReaders;
            this._ThreadPoolPercentSocketReaders = (Integer)object;
            this._postSet(21, n, this._ThreadPoolPercentSocketReaders);
            return;
        }
        if (string.equals("ThreadPoolSize")) {
            int n = this._ThreadPoolSize;
            this._ThreadPoolSize = (Integer)object;
            this._postSet(12, n, this._ThreadPoolSize);
            return;
        }
        if (string.equals("TimedOutRefIsolationTime")) {
            long l = this._TimedOutRefIsolationTime;
            this._TimedOutRefIsolationTime = (Long)object;
            this._postSet(69, l, this._TimedOutRefIsolationTime);
            return;
        }
        if (string.equals("TracingEnabled")) {
            boolean bl = this._TracingEnabled;
            this._TracingEnabled = (Boolean)object;
            this._postSet(64, bl, this._TracingEnabled);
            return;
        }
        if (string.equals("Use81StyleExecuteQueues")) {
            boolean bl = this._Use81StyleExecuteQueues;
            this._Use81StyleExecuteQueues = (Boolean)object;
            this._postSet(70, bl, this._Use81StyleExecuteQueues);
            return;
        }
        if (string.equals("UseConcurrentQueueForRequestManager")) {
            boolean bl = this._UseConcurrentQueueForRequestManager;
            this._UseConcurrentQueueForRequestManager = (Boolean)object;
            this._postSet(76, bl, this._UseConcurrentQueueForRequestManager);
            return;
        }
        if (string.equals("UseIIOPLocateRequest")) {
            boolean bl = this._UseIIOPLocateRequest;
            this._UseIIOPLocateRequest = (Boolean)object;
            this._postSet(33, bl, this._UseIIOPLocateRequest);
            return;
        }
        if (string.equals("ValidProtocols")) {
            Map map = this._ValidProtocols;
            this._ValidProtocols = (Map)object;
            this._postSet(7, map, this._ValidProtocols);
            return;
        }
        if (string.equals("customizer")) {
            Kernel kernel = this._customizer;
            this._customizer = (Kernel)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AddWorkManagerThreadsByCpuCount")) {
            return new Boolean(this._AddWorkManagerThreadsByCpuCount);
        }
        if (string.equals("AdministrationProtocol")) {
            return this._AdministrationProtocol;
        }
        if (string.equals("CompleteCOMMessageTimeout")) {
            return new Integer(this._CompleteCOMMessageTimeout);
        }
        if (string.equals("CompleteHTTPMessageTimeout")) {
            return new Integer(this._CompleteHTTPMessageTimeout);
        }
        if (string.equals("CompleteIIOPMessageTimeout")) {
            return new Integer(this._CompleteIIOPMessageTimeout);
        }
        if (string.equals("CompleteMessageTimeout")) {
            return new Integer(this._CompleteMessageTimeout);
        }
        if (string.equals("CompleteT3MessageTimeout")) {
            return new Integer(this._CompleteT3MessageTimeout);
        }
        if (string.equals("ConnectTimeout")) {
            return new Integer(this._ConnectTimeout);
        }
        if (string.equals("DGCIdlePeriodsUntilTimeout")) {
            return new Integer(this._DGCIdlePeriodsUntilTimeout);
        }
        if (string.equals("DefaultGIOPMinorVersion")) {
            return new Integer(this._DefaultGIOPMinorVersion);
        }
        if (string.equals("DefaultProtocol")) {
            return this._DefaultProtocol;
        }
        if (string.equals("DefaultSecureProtocol")) {
            return this._DefaultSecureProtocol;
        }
        if (string.equals("DevPollDisabled")) {
            return new Boolean(this._DevPollDisabled);
        }
        if (string.equals("ExecuteQueues")) {
            return this._ExecuteQueues;
        }
        if (string.equals("GatheredWritesEnabled")) {
            return new Boolean(this._GatheredWritesEnabled);
        }
        if (string.equals("IIOP")) {
            return this._IIOP;
        }
        if (string.equals("IIOPLocationForwardPolicy")) {
            return this._IIOPLocationForwardPolicy;
        }
        if (string.equals("IIOPTxMechanism")) {
            return this._IIOPTxMechanism;
        }
        if (string.equals("IdleConnectionTimeout")) {
            return new Integer(this._IdleConnectionTimeout);
        }
        if (string.equals("IdleIIOPConnectionTimeout")) {
            return new Integer(this._IdleIIOPConnectionTimeout);
        }
        if (string.equals("IdlePeriodsUntilTimeout")) {
            return new Integer(this._IdlePeriodsUntilTimeout);
        }
        if (string.equals("InstrumentStackTraceEnabled")) {
            return new Boolean(this._InstrumentStackTraceEnabled);
        }
        if (string.equals("JMSThreadPoolSize")) {
            return new Integer(this._JMSThreadPoolSize);
        }
        if (string.equals("KernelDebug")) {
            return this._KernelDebug;
        }
        if (string.equals("LoadStubUsingContextClassLoader")) {
            return new Boolean(this._LoadStubUsingContextClassLoader);
        }
        if (string.equals("Log")) {
            return this._Log;
        }
        if (string.equals("LogRemoteExceptionsEnabled")) {
            return new Boolean(this._LogRemoteExceptionsEnabled);
        }
        if (string.equals("MTUSize")) {
            return new Integer(this._MTUSize);
        }
        if (string.equals("MaxCOMMessageSize")) {
            return new Integer(this._MaxCOMMessageSize);
        }
        if (string.equals("MaxHTTPMessageSize")) {
            return new Integer(this._MaxHTTPMessageSize);
        }
        if (string.equals("MaxIIOPMessageSize")) {
            return new Integer(this._MaxIIOPMessageSize);
        }
        if (string.equals("MaxMessageSize")) {
            return new Integer(this._MaxMessageSize);
        }
        if (string.equals("MaxOpenSockCount")) {
            return new Integer(this._MaxOpenSockCount);
        }
        if (string.equals("MaxT3MessageSize")) {
            return new Integer(this._MaxT3MessageSize);
        }
        if (string.equals("MessagingBridgeThreadPoolSize")) {
            return new Integer(this._MessagingBridgeThreadPoolSize);
        }
        if (string.equals("MuxerClass")) {
            return this._MuxerClass;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NativeIOEnabled")) {
            return new Boolean(this._NativeIOEnabled);
        }
        if (string.equals("OutboundEnabled")) {
            return new Boolean(this._OutboundEnabled);
        }
        if (string.equals("OutboundPrivateKeyEnabled")) {
            return new Boolean(this._OutboundPrivateKeyEnabled);
        }
        if (string.equals("PeriodLength")) {
            return new Integer(this._PeriodLength);
        }
        if (string.equals("RefreshClientRuntimeDescriptor")) {
            return new Boolean(this._RefreshClientRuntimeDescriptor);
        }
        if (string.equals("ResponseTimeout")) {
            return new Integer(this._ResponseTimeout);
        }
        if (string.equals("ReverseDNSAllowed")) {
            return new Boolean(this._ReverseDNSAllowed);
        }
        if (string.equals("RjvmIdleTimeout")) {
            return new Integer(this._RjvmIdleTimeout);
        }
        if (string.equals("SSL")) {
            return this._SSL;
        }
        if (string.equals("ScatteredReadsEnabled")) {
            return new Boolean(this._ScatteredReadsEnabled);
        }
        if (string.equals("SelfTuningThreadPoolSizeMax")) {
            return new Integer(this._SelfTuningThreadPoolSizeMax);
        }
        if (string.equals("SelfTuningThreadPoolSizeMin")) {
            return new Integer(this._SelfTuningThreadPoolSizeMin);
        }
        if (string.equals("SocketBufferSizeAsChunkSize")) {
            return new Boolean(this._SocketBufferSizeAsChunkSize);
        }
        if (string.equals("SocketReaderTimeoutMaxMillis")) {
            return new Integer(this._SocketReaderTimeoutMaxMillis);
        }
        if (string.equals("SocketReaderTimeoutMinMillis")) {
            return new Integer(this._SocketReaderTimeoutMinMillis);
        }
        if (string.equals("SocketReaders")) {
            return new Integer(this._SocketReaders);
        }
        if (string.equals("StdoutDebugEnabled")) {
            return new Boolean(this._StdoutDebugEnabled);
        }
        if (string.equals("StdoutEnabled")) {
            return new Boolean(this._StdoutEnabled);
        }
        if (string.equals("StdoutFormat")) {
            return this._StdoutFormat;
        }
        if (string.equals("StdoutLogStack")) {
            return new Boolean(this._StdoutLogStack);
        }
        if (string.equals("StdoutSeverityLevel")) {
            return new Integer(this._StdoutSeverityLevel);
        }
        if (string.equals("StuckThreadMaxTime")) {
            return new Integer(this._StuckThreadMaxTime);
        }
        if (string.equals("StuckThreadTimerInterval")) {
            return new Integer(this._StuckThreadTimerInterval);
        }
        if (string.equals("SystemThreadPoolSize")) {
            return new Integer(this._SystemThreadPoolSize);
        }
        if (string.equals("T3ClientAbbrevTableSize")) {
            return new Integer(this._T3ClientAbbrevTableSize);
        }
        if (string.equals("T3ServerAbbrevTableSize")) {
            return new Integer(this._T3ServerAbbrevTableSize);
        }
        if (string.equals("ThreadPoolPercentSocketReaders")) {
            return new Integer(this._ThreadPoolPercentSocketReaders);
        }
        if (string.equals("ThreadPoolSize")) {
            return new Integer(this._ThreadPoolSize);
        }
        if (string.equals("TimedOutRefIsolationTime")) {
            return new Long(this._TimedOutRefIsolationTime);
        }
        if (string.equals("TracingEnabled")) {
            return new Boolean(this._TracingEnabled);
        }
        if (string.equals("Use81StyleExecuteQueues")) {
            return new Boolean(this._Use81StyleExecuteQueues);
        }
        if (string.equals("UseConcurrentQueueForRequestManager")) {
            return new Boolean(this._UseConcurrentQueueForRequestManager);
        }
        if (string.equals("UseIIOPLocateRequest")) {
            return new Boolean(this._UseIIOPLocateRequest);
        }
        if (string.equals("ValidProtocols")) {
            return this._ValidProtocols;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 23: {
                    if (string.equals("administration-protocol")) {
                        return 11;
                    }
                    if (string.equals("default-secure-protocol")) {
                        return 10;
                    }
                    if (string.equals("idle-connection-timeout")) {
                        return 41;
                    }
                    if (string.equals("system-thread-pool-size")) {
                        return 13;
                    }
                    if (string.equals("gathered-writes-enabled")) {
                        return 73;
                    }
                    if (!string.equals("scattered-reads-enabled")) break;
                    return 74;
                }
                case 27: {
                    if (string.equals("completecom-message-timeout")) {
                        return 40;
                    }
                    if (string.equals("idleiiop-connection-timeout")) {
                        return 42;
                    }
                    if (string.equals("stuck-thread-timer-interval")) {
                        return 63;
                    }
                    if (string.equals("t3-client-abbrev-table-size")) {
                        return 71;
                    }
                    if (!string.equals("t3-server-abbrev-table-size")) break;
                    return 72;
                }
                case 28: {
                    if (string.equals("completehttp-message-timeout")) {
                        return 39;
                    }
                    if (string.equals("completeiiop-message-timeout")) {
                        return 43;
                    }
                    if (string.equals("iiop-location-forward-policy")) {
                        return 35;
                    }
                    if (string.equals("timed-out-ref-isolation-time")) {
                        return 69;
                    }
                    if (!string.equals("outbound-private-key-enabled")) break;
                    return 25;
                }
                case 24: {
                    if (!string.equals("complete-message-timeout")) break;
                    return 37;
                }
                case 26: {
                    if (string.equals("completet3-message-timeout")) {
                        return 38;
                    }
                    if (string.equals("idle-periods-until-timeout")) {
                        return 45;
                    }
                    if (!string.equals("use81-style-execute-queues")) break;
                    return 70;
                }
                case 15: {
                    if (string.equals("connect-timeout")) {
                        return 36;
                    }
                    if (string.equals("tracing-enabled")) {
                        return 64;
                    }
                    if (!string.equals("valid-protocols")) break;
                    return 7;
                }
                case 30: {
                    if (string.equals("dgc-idle-periods-until-timeout")) {
                        return 49;
                    }
                    if (!string.equals("instrument-stack-trace-enabled")) break;
                    return 57;
                }
                case 25: {
                    if (!string.equals("defaultgiop-minor-version")) break;
                    return 32;
                }
                case 16: {
                    if (string.equals("default-protocol")) {
                        return 9;
                    }
                    if (string.equals("max-message-size")) {
                        return 26;
                    }
                    if (string.equals("response-timeout")) {
                        return 47;
                    }
                    if (string.equals("thread-pool-size")) {
                        return 12;
                    }
                    if (string.equals("nativeio-enabled")) {
                        return 17;
                    }
                    if (string.equals("outbound-enabled")) {
                        return 24;
                    }
                    if (!string.equals("stdout-log-stack")) break;
                    return 61;
                }
                case 13: {
                    if (string.equals("execute-queue")) {
                        return 58;
                    }
                    if (string.equals("period-length")) {
                        return 44;
                    }
                    if (!string.equals("stdout-format")) break;
                    return 60;
                }
                case 4: {
                    if (string.equals("iiop")) {
                        return 51;
                    }
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 17: {
                    if (string.equals("iiop-tx-mechanism")) {
                        return 34;
                    }
                    if (string.equals("rjvm-idle-timeout")) {
                        return 46;
                    }
                    if (!string.equals("dev-poll-disabled")) break;
                    return 18;
                }
                case 20: {
                    if (string.equals("jms-thread-pool-size")) {
                        return 16;
                    }
                    if (string.equals("maxhttp-message-size")) {
                        return 29;
                    }
                    if (string.equals("maxiiop-message-size")) {
                        return 31;
                    }
                    if (!string.equals("stdout-debug-enabled")) break;
                    return 55;
                }
                case 12: {
                    if (!string.equals("kernel-debug")) break;
                    return 48;
                }
                case 36: {
                    if (!string.equals("load-stub-using-context-class-loader")) break;
                    return 67;
                }
                case 3: {
                    if (string.equals("log")) {
                        return 52;
                    }
                    if (!string.equals("ssl")) break;
                    return 50;
                }
                case 8: {
                    if (!string.equals("mtu-size")) break;
                    return 66;
                }
                case 19: {
                    if (string.equals("maxcom-message-size")) {
                        return 30;
                    }
                    if (!string.equals("max-open-sock-count")) break;
                    return 59;
                }
                case 18: {
                    if (string.equals("maxt3-message-size")) {
                        return 27;
                    }
                    if (!string.equals("reversedns-allowed")) break;
                    return 8;
                }
                case 33: {
                    if (string.equals("messaging-bridge-thread-pool-size")) {
                        return 65;
                    }
                    if (!string.equals("refresh-client-runtime-descriptor")) break;
                    return 68;
                }
                case 11: {
                    if (!string.equals("muxer-class")) break;
                    return 19;
                }
                case 32: {
                    if (string.equals("self-tuning-thread-pool-size-max")) {
                        return 15;
                    }
                    if (string.equals("self-tuning-thread-pool-size-min")) {
                        return 14;
                    }
                    if (string.equals("socket-reader-timeout-max-millis")) {
                        return 23;
                    }
                    if (string.equals("socket-reader-timeout-min-millis")) {
                        return 22;
                    }
                    if (!string.equals("socket-buffer-size-as-chunk-size")) break;
                    return 28;
                }
                case 14: {
                    if (string.equals("socket-readers")) {
                        return 20;
                    }
                    if (!string.equals("stdout-enabled")) break;
                    return 53;
                }
                case 21: {
                    if (string.equals("stdout-severity-level")) {
                        return 54;
                    }
                    if (!string.equals("stuck-thread-max-time")) break;
                    return 62;
                }
                case 34: {
                    if (!string.equals("thread-pool-percent-socket-readers")) break;
                    return 21;
                }
                case 22: {
                    if (!string.equals("useiiop-locate-request")) break;
                    return 33;
                }
                case 37: {
                    if (!string.equals("add-work-manager-threads-by-cpu-count")) break;
                    return 75;
                }
                case 29: {
                    if (!string.equals("log-remote-exceptions-enabled")) break;
                    return 56;
                }
                case 40: {
                    if (!string.equals("use-concurrent-queue-for-request-manager")) break;
                    return 76;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 58: {
                    return new ExecuteQueueMBeanImpl.SchemaHelper2();
                }
                case 51: {
                    return new IIOPMBeanImpl.SchemaHelper2();
                }
                case 52: {
                    return new LogMBeanImpl.SchemaHelper2();
                }
                case 50: {
                    return new SSLMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "administration-protocol";
                }
                case 40: {
                    return "completecom-message-timeout";
                }
                case 39: {
                    return "completehttp-message-timeout";
                }
                case 43: {
                    return "completeiiop-message-timeout";
                }
                case 37: {
                    return "complete-message-timeout";
                }
                case 38: {
                    return "completet3-message-timeout";
                }
                case 36: {
                    return "connect-timeout";
                }
                case 49: {
                    return "dgc-idle-periods-until-timeout";
                }
                case 32: {
                    return "defaultgiop-minor-version";
                }
                case 9: {
                    return "default-protocol";
                }
                case 10: {
                    return "default-secure-protocol";
                }
                case 58: {
                    return "execute-queue";
                }
                case 51: {
                    return "iiop";
                }
                case 35: {
                    return "iiop-location-forward-policy";
                }
                case 34: {
                    return "iiop-tx-mechanism";
                }
                case 41: {
                    return "idle-connection-timeout";
                }
                case 42: {
                    return "idleiiop-connection-timeout";
                }
                case 45: {
                    return "idle-periods-until-timeout";
                }
                case 16: {
                    return "jms-thread-pool-size";
                }
                case 48: {
                    return "kernel-debug";
                }
                case 67: {
                    return "load-stub-using-context-class-loader";
                }
                case 52: {
                    return "log";
                }
                case 66: {
                    return "mtu-size";
                }
                case 30: {
                    return "maxcom-message-size";
                }
                case 29: {
                    return "maxhttp-message-size";
                }
                case 31: {
                    return "maxiiop-message-size";
                }
                case 26: {
                    return "max-message-size";
                }
                case 59: {
                    return "max-open-sock-count";
                }
                case 27: {
                    return "maxt3-message-size";
                }
                case 65: {
                    return "messaging-bridge-thread-pool-size";
                }
                case 19: {
                    return "muxer-class";
                }
                case 2: {
                    return "name";
                }
                case 44: {
                    return "period-length";
                }
                case 68: {
                    return "refresh-client-runtime-descriptor";
                }
                case 47: {
                    return "response-timeout";
                }
                case 46: {
                    return "rjvm-idle-timeout";
                }
                case 50: {
                    return "ssl";
                }
                case 15: {
                    return "self-tuning-thread-pool-size-max";
                }
                case 14: {
                    return "self-tuning-thread-pool-size-min";
                }
                case 23: {
                    return "socket-reader-timeout-max-millis";
                }
                case 22: {
                    return "socket-reader-timeout-min-millis";
                }
                case 20: {
                    return "socket-readers";
                }
                case 60: {
                    return "stdout-format";
                }
                case 54: {
                    return "stdout-severity-level";
                }
                case 62: {
                    return "stuck-thread-max-time";
                }
                case 63: {
                    return "stuck-thread-timer-interval";
                }
                case 13: {
                    return "system-thread-pool-size";
                }
                case 71: {
                    return "t3-client-abbrev-table-size";
                }
                case 72: {
                    return "t3-server-abbrev-table-size";
                }
                case 21: {
                    return "thread-pool-percent-socket-readers";
                }
                case 12: {
                    return "thread-pool-size";
                }
                case 69: {
                    return "timed-out-ref-isolation-time";
                }
                case 64: {
                    return "tracing-enabled";
                }
                case 70: {
                    return "use81-style-execute-queues";
                }
                case 33: {
                    return "useiiop-locate-request";
                }
                case 7: {
                    return "valid-protocols";
                }
                case 75: {
                    return "add-work-manager-threads-by-cpu-count";
                }
                case 18: {
                    return "dev-poll-disabled";
                }
                case 73: {
                    return "gathered-writes-enabled";
                }
                case 57: {
                    return "instrument-stack-trace-enabled";
                }
                case 56: {
                    return "log-remote-exceptions-enabled";
                }
                case 17: {
                    return "nativeio-enabled";
                }
                case 24: {
                    return "outbound-enabled";
                }
                case 25: {
                    return "outbound-private-key-enabled";
                }
                case 8: {
                    return "reversedns-allowed";
                }
                case 74: {
                    return "scattered-reads-enabled";
                }
                case 28: {
                    return "socket-buffer-size-as-chunk-size";
                }
                case 55: {
                    return "stdout-debug-enabled";
                }
                case 53: {
                    return "stdout-enabled";
                }
                case 61: {
                    return "stdout-log-stack";
                }
                case 76: {
                    return "use-concurrent-queue-for-request-manager";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 58: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 58: {
                    return true;
                }
                case 51: {
                    return true;
                }
                case 52: {
                    return true;
                }
                case 50: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 28: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private KernelMBeanImpl bean;

        protected Helper(KernelMBeanImpl kernelMBeanImpl) {
            super(kernelMBeanImpl);
            this.bean = kernelMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "AdministrationProtocol";
                }
                case 40: {
                    return "CompleteCOMMessageTimeout";
                }
                case 39: {
                    return "CompleteHTTPMessageTimeout";
                }
                case 43: {
                    return "CompleteIIOPMessageTimeout";
                }
                case 37: {
                    return "CompleteMessageTimeout";
                }
                case 38: {
                    return "CompleteT3MessageTimeout";
                }
                case 36: {
                    return "ConnectTimeout";
                }
                case 49: {
                    return "DGCIdlePeriodsUntilTimeout";
                }
                case 32: {
                    return "DefaultGIOPMinorVersion";
                }
                case 9: {
                    return "DefaultProtocol";
                }
                case 10: {
                    return "DefaultSecureProtocol";
                }
                case 58: {
                    return "ExecuteQueues";
                }
                case 51: {
                    return "IIOP";
                }
                case 35: {
                    return "IIOPLocationForwardPolicy";
                }
                case 34: {
                    return "IIOPTxMechanism";
                }
                case 41: {
                    return "IdleConnectionTimeout";
                }
                case 42: {
                    return "IdleIIOPConnectionTimeout";
                }
                case 45: {
                    return "IdlePeriodsUntilTimeout";
                }
                case 16: {
                    return "JMSThreadPoolSize";
                }
                case 48: {
                    return "KernelDebug";
                }
                case 67: {
                    return "LoadStubUsingContextClassLoader";
                }
                case 52: {
                    return "Log";
                }
                case 66: {
                    return "MTUSize";
                }
                case 30: {
                    return "MaxCOMMessageSize";
                }
                case 29: {
                    return "MaxHTTPMessageSize";
                }
                case 31: {
                    return "MaxIIOPMessageSize";
                }
                case 26: {
                    return "MaxMessageSize";
                }
                case 59: {
                    return "MaxOpenSockCount";
                }
                case 27: {
                    return "MaxT3MessageSize";
                }
                case 65: {
                    return "MessagingBridgeThreadPoolSize";
                }
                case 19: {
                    return "MuxerClass";
                }
                case 2: {
                    return "Name";
                }
                case 44: {
                    return "PeriodLength";
                }
                case 68: {
                    return "RefreshClientRuntimeDescriptor";
                }
                case 47: {
                    return "ResponseTimeout";
                }
                case 46: {
                    return "RjvmIdleTimeout";
                }
                case 50: {
                    return "SSL";
                }
                case 15: {
                    return "SelfTuningThreadPoolSizeMax";
                }
                case 14: {
                    return "SelfTuningThreadPoolSizeMin";
                }
                case 23: {
                    return "SocketReaderTimeoutMaxMillis";
                }
                case 22: {
                    return "SocketReaderTimeoutMinMillis";
                }
                case 20: {
                    return "SocketReaders";
                }
                case 60: {
                    return "StdoutFormat";
                }
                case 54: {
                    return "StdoutSeverityLevel";
                }
                case 62: {
                    return "StuckThreadMaxTime";
                }
                case 63: {
                    return "StuckThreadTimerInterval";
                }
                case 13: {
                    return "SystemThreadPoolSize";
                }
                case 71: {
                    return "T3ClientAbbrevTableSize";
                }
                case 72: {
                    return "T3ServerAbbrevTableSize";
                }
                case 21: {
                    return "ThreadPoolPercentSocketReaders";
                }
                case 12: {
                    return "ThreadPoolSize";
                }
                case 69: {
                    return "TimedOutRefIsolationTime";
                }
                case 64: {
                    return "TracingEnabled";
                }
                case 70: {
                    return "Use81StyleExecuteQueues";
                }
                case 33: {
                    return "UseIIOPLocateRequest";
                }
                case 7: {
                    return "ValidProtocols";
                }
                case 75: {
                    return "AddWorkManagerThreadsByCpuCount";
                }
                case 18: {
                    return "DevPollDisabled";
                }
                case 73: {
                    return "GatheredWritesEnabled";
                }
                case 57: {
                    return "InstrumentStackTraceEnabled";
                }
                case 56: {
                    return "LogRemoteExceptionsEnabled";
                }
                case 17: {
                    return "NativeIOEnabled";
                }
                case 24: {
                    return "OutboundEnabled";
                }
                case 25: {
                    return "OutboundPrivateKeyEnabled";
                }
                case 8: {
                    return "ReverseDNSAllowed";
                }
                case 74: {
                    return "ScatteredReadsEnabled";
                }
                case 28: {
                    return "SocketBufferSizeAsChunkSize";
                }
                case 55: {
                    return "StdoutDebugEnabled";
                }
                case 53: {
                    return "StdoutEnabled";
                }
                case 61: {
                    return "StdoutLogStack";
                }
                case 76: {
                    return "UseConcurrentQueueForRequestManager";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AdministrationProtocol")) {
                return 11;
            }
            if (string.equals("CompleteCOMMessageTimeout")) {
                return 40;
            }
            if (string.equals("CompleteHTTPMessageTimeout")) {
                return 39;
            }
            if (string.equals("CompleteIIOPMessageTimeout")) {
                return 43;
            }
            if (string.equals("CompleteMessageTimeout")) {
                return 37;
            }
            if (string.equals("CompleteT3MessageTimeout")) {
                return 38;
            }
            if (string.equals("ConnectTimeout")) {
                return 36;
            }
            if (string.equals("DGCIdlePeriodsUntilTimeout")) {
                return 49;
            }
            if (string.equals("DefaultGIOPMinorVersion")) {
                return 32;
            }
            if (string.equals("DefaultProtocol")) {
                return 9;
            }
            if (string.equals("DefaultSecureProtocol")) {
                return 10;
            }
            if (string.equals("ExecuteQueues")) {
                return 58;
            }
            if (string.equals("IIOP")) {
                return 51;
            }
            if (string.equals("IIOPLocationForwardPolicy")) {
                return 35;
            }
            if (string.equals("IIOPTxMechanism")) {
                return 34;
            }
            if (string.equals("IdleConnectionTimeout")) {
                return 41;
            }
            if (string.equals("IdleIIOPConnectionTimeout")) {
                return 42;
            }
            if (string.equals("IdlePeriodsUntilTimeout")) {
                return 45;
            }
            if (string.equals("JMSThreadPoolSize")) {
                return 16;
            }
            if (string.equals("KernelDebug")) {
                return 48;
            }
            if (string.equals("LoadStubUsingContextClassLoader")) {
                return 67;
            }
            if (string.equals("Log")) {
                return 52;
            }
            if (string.equals("MTUSize")) {
                return 66;
            }
            if (string.equals("MaxCOMMessageSize")) {
                return 30;
            }
            if (string.equals("MaxHTTPMessageSize")) {
                return 29;
            }
            if (string.equals("MaxIIOPMessageSize")) {
                return 31;
            }
            if (string.equals("MaxMessageSize")) {
                return 26;
            }
            if (string.equals("MaxOpenSockCount")) {
                return 59;
            }
            if (string.equals("MaxT3MessageSize")) {
                return 27;
            }
            if (string.equals("MessagingBridgeThreadPoolSize")) {
                return 65;
            }
            if (string.equals("MuxerClass")) {
                return 19;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PeriodLength")) {
                return 44;
            }
            if (string.equals("RefreshClientRuntimeDescriptor")) {
                return 68;
            }
            if (string.equals("ResponseTimeout")) {
                return 47;
            }
            if (string.equals("RjvmIdleTimeout")) {
                return 46;
            }
            if (string.equals("SSL")) {
                return 50;
            }
            if (string.equals("SelfTuningThreadPoolSizeMax")) {
                return 15;
            }
            if (string.equals("SelfTuningThreadPoolSizeMin")) {
                return 14;
            }
            if (string.equals("SocketReaderTimeoutMaxMillis")) {
                return 23;
            }
            if (string.equals("SocketReaderTimeoutMinMillis")) {
                return 22;
            }
            if (string.equals("SocketReaders")) {
                return 20;
            }
            if (string.equals("StdoutFormat")) {
                return 60;
            }
            if (string.equals("StdoutSeverityLevel")) {
                return 54;
            }
            if (string.equals("StuckThreadMaxTime")) {
                return 62;
            }
            if (string.equals("StuckThreadTimerInterval")) {
                return 63;
            }
            if (string.equals("SystemThreadPoolSize")) {
                return 13;
            }
            if (string.equals("T3ClientAbbrevTableSize")) {
                return 71;
            }
            if (string.equals("T3ServerAbbrevTableSize")) {
                return 72;
            }
            if (string.equals("ThreadPoolPercentSocketReaders")) {
                return 21;
            }
            if (string.equals("ThreadPoolSize")) {
                return 12;
            }
            if (string.equals("TimedOutRefIsolationTime")) {
                return 69;
            }
            if (string.equals("TracingEnabled")) {
                return 64;
            }
            if (string.equals("Use81StyleExecuteQueues")) {
                return 70;
            }
            if (string.equals("UseIIOPLocateRequest")) {
                return 33;
            }
            if (string.equals("ValidProtocols")) {
                return 7;
            }
            if (string.equals("AddWorkManagerThreadsByCpuCount")) {
                return 75;
            }
            if (string.equals("DevPollDisabled")) {
                return 18;
            }
            if (string.equals("GatheredWritesEnabled")) {
                return 73;
            }
            if (string.equals("InstrumentStackTraceEnabled")) {
                return 57;
            }
            if (string.equals("LogRemoteExceptionsEnabled")) {
                return 56;
            }
            if (string.equals("NativeIOEnabled")) {
                return 17;
            }
            if (string.equals("OutboundEnabled")) {
                return 24;
            }
            if (string.equals("OutboundPrivateKeyEnabled")) {
                return 25;
            }
            if (string.equals("ReverseDNSAllowed")) {
                return 8;
            }
            if (string.equals("ScatteredReadsEnabled")) {
                return 74;
            }
            if (string.equals("SocketBufferSizeAsChunkSize")) {
                return 28;
            }
            if (string.equals("StdoutDebugEnabled")) {
                return 55;
            }
            if (string.equals("StdoutEnabled")) {
                return 53;
            }
            if (string.equals("StdoutLogStack")) {
                return 61;
            }
            if (string.equals("UseConcurrentQueueForRequestManager")) {
                return 76;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getExecuteQueues()));
            if (this.bean.getIIOP() != null) {
                arrayList.add(new ArrayIterator((Object[])new IIOPMBean[]{this.bean.getIIOP()}));
            }
            if (this.bean.getLog() != null) {
                arrayList.add(new ArrayIterator((Object[])new LogMBean[]{this.bean.getLog()}));
            }
            if (this.bean.getSSL() != null) {
                arrayList.add(new ArrayIterator((Object[])new SSLMBean[]{this.bean.getSSL()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAdministrationProtocolSet()) {
                    stringBuffer.append("AdministrationProtocol");
                    stringBuffer.append(String.valueOf(this.bean.getAdministrationProtocol()));
                }
                if (this.bean.isCompleteCOMMessageTimeoutSet()) {
                    stringBuffer.append("CompleteCOMMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteCOMMessageTimeout()));
                }
                if (this.bean.isCompleteHTTPMessageTimeoutSet()) {
                    stringBuffer.append("CompleteHTTPMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteHTTPMessageTimeout()));
                }
                if (this.bean.isCompleteIIOPMessageTimeoutSet()) {
                    stringBuffer.append("CompleteIIOPMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteIIOPMessageTimeout()));
                }
                if (this.bean.isCompleteMessageTimeoutSet()) {
                    stringBuffer.append("CompleteMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteMessageTimeout()));
                }
                if (this.bean.isCompleteT3MessageTimeoutSet()) {
                    stringBuffer.append("CompleteT3MessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteT3MessageTimeout()));
                }
                if (this.bean.isConnectTimeoutSet()) {
                    stringBuffer.append("ConnectTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getConnectTimeout()));
                }
                if (this.bean.isDGCIdlePeriodsUntilTimeoutSet()) {
                    stringBuffer.append("DGCIdlePeriodsUntilTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getDGCIdlePeriodsUntilTimeout()));
                }
                if (this.bean.isDefaultGIOPMinorVersionSet()) {
                    stringBuffer.append("DefaultGIOPMinorVersion");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultGIOPMinorVersion()));
                }
                if (this.bean.isDefaultProtocolSet()) {
                    stringBuffer.append("DefaultProtocol");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultProtocol()));
                }
                if (this.bean.isDefaultSecureProtocolSet()) {
                    stringBuffer.append("DefaultSecureProtocol");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultSecureProtocol()));
                }
                l2 = 0L;
                for (int i = 0; i < this.bean.getExecuteQueues().length; ++i) {
                    l2 ^= this.computeChildHashValue(this.bean.getExecuteQueues()[i]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getIIOP())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isIIOPLocationForwardPolicySet()) {
                    stringBuffer.append("IIOPLocationForwardPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getIIOPLocationForwardPolicy()));
                }
                if (this.bean.isIIOPTxMechanismSet()) {
                    stringBuffer.append("IIOPTxMechanism");
                    stringBuffer.append(String.valueOf(this.bean.getIIOPTxMechanism()));
                }
                if (this.bean.isIdleConnectionTimeoutSet()) {
                    stringBuffer.append("IdleConnectionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getIdleConnectionTimeout()));
                }
                if (this.bean.isIdleIIOPConnectionTimeoutSet()) {
                    stringBuffer.append("IdleIIOPConnectionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getIdleIIOPConnectionTimeout()));
                }
                if (this.bean.isIdlePeriodsUntilTimeoutSet()) {
                    stringBuffer.append("IdlePeriodsUntilTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getIdlePeriodsUntilTimeout()));
                }
                if (this.bean.isJMSThreadPoolSizeSet()) {
                    stringBuffer.append("JMSThreadPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getJMSThreadPoolSize()));
                }
                if (this.bean.isKernelDebugSet()) {
                    stringBuffer.append("KernelDebug");
                    stringBuffer.append(String.valueOf(this.bean.getKernelDebug()));
                }
                if (this.bean.isLoadStubUsingContextClassLoaderSet()) {
                    stringBuffer.append("LoadStubUsingContextClassLoader");
                    stringBuffer.append(String.valueOf(this.bean.getLoadStubUsingContextClassLoader()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getLog())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isMTUSizeSet()) {
                    stringBuffer.append("MTUSize");
                    stringBuffer.append(String.valueOf(this.bean.getMTUSize()));
                }
                if (this.bean.isMaxCOMMessageSizeSet()) {
                    stringBuffer.append("MaxCOMMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxCOMMessageSize()));
                }
                if (this.bean.isMaxHTTPMessageSizeSet()) {
                    stringBuffer.append("MaxHTTPMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxHTTPMessageSize()));
                }
                if (this.bean.isMaxIIOPMessageSizeSet()) {
                    stringBuffer.append("MaxIIOPMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxIIOPMessageSize()));
                }
                if (this.bean.isMaxMessageSizeSet()) {
                    stringBuffer.append("MaxMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxMessageSize()));
                }
                if (this.bean.isMaxOpenSockCountSet()) {
                    stringBuffer.append("MaxOpenSockCount");
                    stringBuffer.append(String.valueOf(this.bean.getMaxOpenSockCount()));
                }
                if (this.bean.isMaxT3MessageSizeSet()) {
                    stringBuffer.append("MaxT3MessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxT3MessageSize()));
                }
                if (this.bean.isMessagingBridgeThreadPoolSizeSet()) {
                    stringBuffer.append("MessagingBridgeThreadPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getMessagingBridgeThreadPoolSize()));
                }
                if (this.bean.isMuxerClassSet()) {
                    stringBuffer.append("MuxerClass");
                    stringBuffer.append(String.valueOf(this.bean.getMuxerClass()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPeriodLengthSet()) {
                    stringBuffer.append("PeriodLength");
                    stringBuffer.append(String.valueOf(this.bean.getPeriodLength()));
                }
                if (this.bean.isRefreshClientRuntimeDescriptorSet()) {
                    stringBuffer.append("RefreshClientRuntimeDescriptor");
                    stringBuffer.append(String.valueOf(this.bean.getRefreshClientRuntimeDescriptor()));
                }
                if (this.bean.isResponseTimeoutSet()) {
                    stringBuffer.append("ResponseTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getResponseTimeout()));
                }
                if (this.bean.isRjvmIdleTimeoutSet()) {
                    stringBuffer.append("RjvmIdleTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getRjvmIdleTimeout()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getSSL())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isSelfTuningThreadPoolSizeMaxSet()) {
                    stringBuffer.append("SelfTuningThreadPoolSizeMax");
                    stringBuffer.append(String.valueOf(this.bean.getSelfTuningThreadPoolSizeMax()));
                }
                if (this.bean.isSelfTuningThreadPoolSizeMinSet()) {
                    stringBuffer.append("SelfTuningThreadPoolSizeMin");
                    stringBuffer.append(String.valueOf(this.bean.getSelfTuningThreadPoolSizeMin()));
                }
                if (this.bean.isSocketReaderTimeoutMaxMillisSet()) {
                    stringBuffer.append("SocketReaderTimeoutMaxMillis");
                    stringBuffer.append(String.valueOf(this.bean.getSocketReaderTimeoutMaxMillis()));
                }
                if (this.bean.isSocketReaderTimeoutMinMillisSet()) {
                    stringBuffer.append("SocketReaderTimeoutMinMillis");
                    stringBuffer.append(String.valueOf(this.bean.getSocketReaderTimeoutMinMillis()));
                }
                if (this.bean.isSocketReadersSet()) {
                    stringBuffer.append("SocketReaders");
                    stringBuffer.append(String.valueOf(this.bean.getSocketReaders()));
                }
                if (this.bean.isStdoutFormatSet()) {
                    stringBuffer.append("StdoutFormat");
                    stringBuffer.append(String.valueOf(this.bean.getStdoutFormat()));
                }
                if (this.bean.isStdoutSeverityLevelSet()) {
                    stringBuffer.append("StdoutSeverityLevel");
                    stringBuffer.append(String.valueOf(this.bean.getStdoutSeverityLevel()));
                }
                if (this.bean.isStuckThreadMaxTimeSet()) {
                    stringBuffer.append("StuckThreadMaxTime");
                    stringBuffer.append(String.valueOf(this.bean.getStuckThreadMaxTime()));
                }
                if (this.bean.isStuckThreadTimerIntervalSet()) {
                    stringBuffer.append("StuckThreadTimerInterval");
                    stringBuffer.append(String.valueOf(this.bean.getStuckThreadTimerInterval()));
                }
                if (this.bean.isSystemThreadPoolSizeSet()) {
                    stringBuffer.append("SystemThreadPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getSystemThreadPoolSize()));
                }
                if (this.bean.isT3ClientAbbrevTableSizeSet()) {
                    stringBuffer.append("T3ClientAbbrevTableSize");
                    stringBuffer.append(String.valueOf(this.bean.getT3ClientAbbrevTableSize()));
                }
                if (this.bean.isT3ServerAbbrevTableSizeSet()) {
                    stringBuffer.append("T3ServerAbbrevTableSize");
                    stringBuffer.append(String.valueOf(this.bean.getT3ServerAbbrevTableSize()));
                }
                if (this.bean.isThreadPoolPercentSocketReadersSet()) {
                    stringBuffer.append("ThreadPoolPercentSocketReaders");
                    stringBuffer.append(String.valueOf(this.bean.getThreadPoolPercentSocketReaders()));
                }
                if (this.bean.isThreadPoolSizeSet()) {
                    stringBuffer.append("ThreadPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getThreadPoolSize()));
                }
                if (this.bean.isTimedOutRefIsolationTimeSet()) {
                    stringBuffer.append("TimedOutRefIsolationTime");
                    stringBuffer.append(String.valueOf(this.bean.getTimedOutRefIsolationTime()));
                }
                if (this.bean.isTracingEnabledSet()) {
                    stringBuffer.append("TracingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getTracingEnabled()));
                }
                if (this.bean.isUse81StyleExecuteQueuesSet()) {
                    stringBuffer.append("Use81StyleExecuteQueues");
                    stringBuffer.append(String.valueOf(this.bean.getUse81StyleExecuteQueues()));
                }
                if (this.bean.isUseIIOPLocateRequestSet()) {
                    stringBuffer.append("UseIIOPLocateRequest");
                    stringBuffer.append(String.valueOf(this.bean.getUseIIOPLocateRequest()));
                }
                if (this.bean.isValidProtocolsSet()) {
                    stringBuffer.append("ValidProtocols");
                    stringBuffer.append(String.valueOf(this.bean.getValidProtocols()));
                }
                if (this.bean.isAddWorkManagerThreadsByCpuCountSet()) {
                    stringBuffer.append("AddWorkManagerThreadsByCpuCount");
                    stringBuffer.append(String.valueOf(this.bean.isAddWorkManagerThreadsByCpuCount()));
                }
                if (this.bean.isDevPollDisabledSet()) {
                    stringBuffer.append("DevPollDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isDevPollDisabled()));
                }
                if (this.bean.isGatheredWritesEnabledSet()) {
                    stringBuffer.append("GatheredWritesEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isGatheredWritesEnabled()));
                }
                if (this.bean.isInstrumentStackTraceEnabledSet()) {
                    stringBuffer.append("InstrumentStackTraceEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isInstrumentStackTraceEnabled()));
                }
                if (this.bean.isLogRemoteExceptionsEnabledSet()) {
                    stringBuffer.append("LogRemoteExceptionsEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLogRemoteExceptionsEnabled()));
                }
                if (this.bean.isNativeIOEnabledSet()) {
                    stringBuffer.append("NativeIOEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isNativeIOEnabled()));
                }
                if (this.bean.isOutboundEnabledSet()) {
                    stringBuffer.append("OutboundEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOutboundEnabled()));
                }
                if (this.bean.isOutboundPrivateKeyEnabledSet()) {
                    stringBuffer.append("OutboundPrivateKeyEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOutboundPrivateKeyEnabled()));
                }
                if (this.bean.isReverseDNSAllowedSet()) {
                    stringBuffer.append("ReverseDNSAllowed");
                    stringBuffer.append(String.valueOf(this.bean.isReverseDNSAllowed()));
                }
                if (this.bean.isScatteredReadsEnabledSet()) {
                    stringBuffer.append("ScatteredReadsEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isScatteredReadsEnabled()));
                }
                if (this.bean.isSocketBufferSizeAsChunkSizeSet()) {
                    stringBuffer.append("SocketBufferSizeAsChunkSize");
                    stringBuffer.append(String.valueOf(this.bean.isSocketBufferSizeAsChunkSize()));
                }
                if (this.bean.isStdoutDebugEnabledSet()) {
                    stringBuffer.append("StdoutDebugEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isStdoutDebugEnabled()));
                }
                if (this.bean.isStdoutEnabledSet()) {
                    stringBuffer.append("StdoutEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isStdoutEnabled()));
                }
                if (this.bean.isStdoutLogStackSet()) {
                    stringBuffer.append("StdoutLogStack");
                    stringBuffer.append(String.valueOf(this.bean.isStdoutLogStack()));
                }
                if (this.bean.isUseConcurrentQueueForRequestManagerSet()) {
                    stringBuffer.append("UseConcurrentQueueForRequestManager");
                    stringBuffer.append(String.valueOf(this.bean.isUseConcurrentQueueForRequestManager()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                KernelMBeanImpl kernelMBeanImpl = (KernelMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AdministrationProtocol", this.bean.getAdministrationProtocol(), kernelMBeanImpl.getAdministrationProtocol(), false);
                this.computeDiff("CompleteCOMMessageTimeout", this.bean.getCompleteCOMMessageTimeout(), kernelMBeanImpl.getCompleteCOMMessageTimeout(), true);
                this.computeDiff("CompleteHTTPMessageTimeout", this.bean.getCompleteHTTPMessageTimeout(), kernelMBeanImpl.getCompleteHTTPMessageTimeout(), true);
                this.computeDiff("CompleteIIOPMessageTimeout", this.bean.getCompleteIIOPMessageTimeout(), kernelMBeanImpl.getCompleteIIOPMessageTimeout(), true);
                this.computeDiff("CompleteMessageTimeout", this.bean.getCompleteMessageTimeout(), kernelMBeanImpl.getCompleteMessageTimeout(), true);
                this.computeDiff("CompleteT3MessageTimeout", this.bean.getCompleteT3MessageTimeout(), kernelMBeanImpl.getCompleteT3MessageTimeout(), true);
                this.computeDiff("ConnectTimeout", this.bean.getConnectTimeout(), kernelMBeanImpl.getConnectTimeout(), true);
                this.computeDiff("DGCIdlePeriodsUntilTimeout", this.bean.getDGCIdlePeriodsUntilTimeout(), kernelMBeanImpl.getDGCIdlePeriodsUntilTimeout(), false);
                this.computeDiff("DefaultGIOPMinorVersion", this.bean.getDefaultGIOPMinorVersion(), kernelMBeanImpl.getDefaultGIOPMinorVersion(), true);
                this.computeDiff("DefaultProtocol", this.bean.getDefaultProtocol(), kernelMBeanImpl.getDefaultProtocol(), false);
                this.computeDiff("DefaultSecureProtocol", this.bean.getDefaultSecureProtocol(), kernelMBeanImpl.getDefaultSecureProtocol(), false);
                this.computeChildDiff("ExecuteQueues", this.bean.getExecuteQueues(), kernelMBeanImpl.getExecuteQueues(), false);
                this.computeSubDiff("IIOP", this.bean.getIIOP(), kernelMBeanImpl.getIIOP());
                this.computeDiff("IIOPLocationForwardPolicy", this.bean.getIIOPLocationForwardPolicy(), kernelMBeanImpl.getIIOPLocationForwardPolicy(), true);
                this.computeDiff("IIOPTxMechanism", this.bean.getIIOPTxMechanism(), kernelMBeanImpl.getIIOPTxMechanism(), true);
                this.computeDiff("IdleConnectionTimeout", this.bean.getIdleConnectionTimeout(), kernelMBeanImpl.getIdleConnectionTimeout(), true);
                this.computeDiff("IdleIIOPConnectionTimeout", this.bean.getIdleIIOPConnectionTimeout(), kernelMBeanImpl.getIdleIIOPConnectionTimeout(), true);
                this.computeDiff("IdlePeriodsUntilTimeout", this.bean.getIdlePeriodsUntilTimeout(), kernelMBeanImpl.getIdlePeriodsUntilTimeout(), false);
                this.computeDiff("JMSThreadPoolSize", this.bean.getJMSThreadPoolSize(), kernelMBeanImpl.getJMSThreadPoolSize(), false);
                this.computeDiff("LoadStubUsingContextClassLoader", this.bean.getLoadStubUsingContextClassLoader(), kernelMBeanImpl.getLoadStubUsingContextClassLoader(), false);
                this.computeSubDiff("Log", this.bean.getLog(), kernelMBeanImpl.getLog());
                this.computeDiff("MTUSize", this.bean.getMTUSize(), kernelMBeanImpl.getMTUSize(), false);
                this.computeDiff("MaxCOMMessageSize", this.bean.getMaxCOMMessageSize(), kernelMBeanImpl.getMaxCOMMessageSize(), true);
                this.computeDiff("MaxHTTPMessageSize", this.bean.getMaxHTTPMessageSize(), kernelMBeanImpl.getMaxHTTPMessageSize(), true);
                this.computeDiff("MaxIIOPMessageSize", this.bean.getMaxIIOPMessageSize(), kernelMBeanImpl.getMaxIIOPMessageSize(), true);
                this.computeDiff("MaxMessageSize", this.bean.getMaxMessageSize(), kernelMBeanImpl.getMaxMessageSize(), true);
                this.computeDiff("MaxOpenSockCount", this.bean.getMaxOpenSockCount(), kernelMBeanImpl.getMaxOpenSockCount(), true);
                this.computeDiff("MaxT3MessageSize", this.bean.getMaxT3MessageSize(), kernelMBeanImpl.getMaxT3MessageSize(), true);
                this.computeDiff("MessagingBridgeThreadPoolSize", this.bean.getMessagingBridgeThreadPoolSize(), kernelMBeanImpl.getMessagingBridgeThreadPoolSize(), false);
                this.computeDiff("MuxerClass", this.bean.getMuxerClass(), kernelMBeanImpl.getMuxerClass(), false);
                this.computeDiff("Name", this.bean.getName(), kernelMBeanImpl.getName(), false);
                this.computeDiff("PeriodLength", this.bean.getPeriodLength(), kernelMBeanImpl.getPeriodLength(), false);
                this.computeDiff("RefreshClientRuntimeDescriptor", this.bean.getRefreshClientRuntimeDescriptor(), kernelMBeanImpl.getRefreshClientRuntimeDescriptor(), false);
                this.computeDiff("ResponseTimeout", this.bean.getResponseTimeout(), kernelMBeanImpl.getResponseTimeout(), false);
                this.computeDiff("RjvmIdleTimeout", this.bean.getRjvmIdleTimeout(), kernelMBeanImpl.getRjvmIdleTimeout(), false);
                this.computeSubDiff("SSL", this.bean.getSSL(), kernelMBeanImpl.getSSL());
                this.computeDiff("SelfTuningThreadPoolSizeMax", this.bean.getSelfTuningThreadPoolSizeMax(), kernelMBeanImpl.getSelfTuningThreadPoolSizeMax(), false);
                this.computeDiff("SelfTuningThreadPoolSizeMin", this.bean.getSelfTuningThreadPoolSizeMin(), kernelMBeanImpl.getSelfTuningThreadPoolSizeMin(), false);
                this.computeDiff("SocketReaderTimeoutMaxMillis", this.bean.getSocketReaderTimeoutMaxMillis(), kernelMBeanImpl.getSocketReaderTimeoutMaxMillis(), true);
                this.computeDiff("SocketReaderTimeoutMinMillis", this.bean.getSocketReaderTimeoutMinMillis(), kernelMBeanImpl.getSocketReaderTimeoutMinMillis(), true);
                this.computeDiff("SocketReaders", this.bean.getSocketReaders(), kernelMBeanImpl.getSocketReaders(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutFormat", this.bean.getStdoutFormat(), kernelMBeanImpl.getStdoutFormat(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutSeverityLevel", this.bean.getStdoutSeverityLevel(), kernelMBeanImpl.getStdoutSeverityLevel(), true);
                }
                this.computeDiff("StuckThreadMaxTime", this.bean.getStuckThreadMaxTime(), kernelMBeanImpl.getStuckThreadMaxTime(), false);
                this.computeDiff("StuckThreadTimerInterval", this.bean.getStuckThreadTimerInterval(), kernelMBeanImpl.getStuckThreadTimerInterval(), false);
                this.computeDiff("SystemThreadPoolSize", this.bean.getSystemThreadPoolSize(), kernelMBeanImpl.getSystemThreadPoolSize(), false);
                this.computeDiff("T3ClientAbbrevTableSize", this.bean.getT3ClientAbbrevTableSize(), kernelMBeanImpl.getT3ClientAbbrevTableSize(), false);
                this.computeDiff("T3ServerAbbrevTableSize", this.bean.getT3ServerAbbrevTableSize(), kernelMBeanImpl.getT3ServerAbbrevTableSize(), false);
                this.computeDiff("ThreadPoolPercentSocketReaders", this.bean.getThreadPoolPercentSocketReaders(), kernelMBeanImpl.getThreadPoolPercentSocketReaders(), true);
                this.computeDiff("ThreadPoolSize", this.bean.getThreadPoolSize(), kernelMBeanImpl.getThreadPoolSize(), false);
                this.computeDiff("TimedOutRefIsolationTime", this.bean.getTimedOutRefIsolationTime(), kernelMBeanImpl.getTimedOutRefIsolationTime(), false);
                this.computeDiff("TracingEnabled", this.bean.getTracingEnabled(), kernelMBeanImpl.getTracingEnabled(), false);
                this.computeDiff("Use81StyleExecuteQueues", this.bean.getUse81StyleExecuteQueues(), kernelMBeanImpl.getUse81StyleExecuteQueues(), false);
                this.computeDiff("UseIIOPLocateRequest", this.bean.getUseIIOPLocateRequest(), kernelMBeanImpl.getUseIIOPLocateRequest(), true);
                this.computeDiff("ValidProtocols", this.bean.getValidProtocols(), kernelMBeanImpl.getValidProtocols(), false);
                this.computeDiff("AddWorkManagerThreadsByCpuCount", this.bean.isAddWorkManagerThreadsByCpuCount(), kernelMBeanImpl.isAddWorkManagerThreadsByCpuCount(), false);
                this.computeDiff("DevPollDisabled", this.bean.isDevPollDisabled(), kernelMBeanImpl.isDevPollDisabled(), false);
                this.computeDiff("GatheredWritesEnabled", this.bean.isGatheredWritesEnabled(), kernelMBeanImpl.isGatheredWritesEnabled(), false);
                this.computeDiff("InstrumentStackTraceEnabled", this.bean.isInstrumentStackTraceEnabled(), kernelMBeanImpl.isInstrumentStackTraceEnabled(), true);
                this.computeDiff("LogRemoteExceptionsEnabled", this.bean.isLogRemoteExceptionsEnabled(), kernelMBeanImpl.isLogRemoteExceptionsEnabled(), true);
                this.computeDiff("NativeIOEnabled", this.bean.isNativeIOEnabled(), kernelMBeanImpl.isNativeIOEnabled(), false);
                this.computeDiff("OutboundEnabled", this.bean.isOutboundEnabled(), kernelMBeanImpl.isOutboundEnabled(), true);
                this.computeDiff("OutboundPrivateKeyEnabled", this.bean.isOutboundPrivateKeyEnabled(), kernelMBeanImpl.isOutboundPrivateKeyEnabled(), true);
                this.computeDiff("ReverseDNSAllowed", this.bean.isReverseDNSAllowed(), kernelMBeanImpl.isReverseDNSAllowed(), true);
                this.computeDiff("ScatteredReadsEnabled", this.bean.isScatteredReadsEnabled(), kernelMBeanImpl.isScatteredReadsEnabled(), false);
                this.computeDiff("SocketBufferSizeAsChunkSize", this.bean.isSocketBufferSizeAsChunkSize(), kernelMBeanImpl.isSocketBufferSizeAsChunkSize(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutDebugEnabled", this.bean.isStdoutDebugEnabled(), kernelMBeanImpl.isStdoutDebugEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutEnabled", this.bean.isStdoutEnabled(), kernelMBeanImpl.isStdoutEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutLogStack", this.bean.isStdoutLogStack(), kernelMBeanImpl.isStdoutLogStack(), true);
                }
                this.computeDiff("UseConcurrentQueueForRequestManager", this.bean.isUseConcurrentQueueForRequestManager(), kernelMBeanImpl.isUseConcurrentQueueForRequestManager(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                KernelMBeanImpl kernelMBeanImpl = (KernelMBeanImpl)beanUpdateEvent.getSourceBean();
                KernelMBeanImpl kernelMBeanImpl2 = (KernelMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AdministrationProtocol")) {
                    kernelMBeanImpl.setAdministrationProtocol(kernelMBeanImpl2.getAdministrationProtocol());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("CompleteCOMMessageTimeout")) {
                    kernelMBeanImpl.setCompleteCOMMessageTimeout(kernelMBeanImpl2.getCompleteCOMMessageTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                } else if (string.equals("CompleteHTTPMessageTimeout")) {
                    kernelMBeanImpl.setCompleteHTTPMessageTimeout(kernelMBeanImpl2.getCompleteHTTPMessageTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                } else if (string.equals("CompleteIIOPMessageTimeout")) {
                    kernelMBeanImpl.setCompleteIIOPMessageTimeout(kernelMBeanImpl2.getCompleteIIOPMessageTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 43);
                } else if (string.equals("CompleteMessageTimeout")) {
                    kernelMBeanImpl.setCompleteMessageTimeout(kernelMBeanImpl2.getCompleteMessageTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                } else if (string.equals("CompleteT3MessageTimeout")) {
                    kernelMBeanImpl.setCompleteT3MessageTimeout(kernelMBeanImpl2.getCompleteT3MessageTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                } else if (string.equals("ConnectTimeout")) {
                    kernelMBeanImpl.setConnectTimeout(kernelMBeanImpl2.getConnectTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                } else if (string.equals("DGCIdlePeriodsUntilTimeout")) {
                    kernelMBeanImpl.setDGCIdlePeriodsUntilTimeout(kernelMBeanImpl2.getDGCIdlePeriodsUntilTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 49);
                } else if (string.equals("DefaultGIOPMinorVersion")) {
                    kernelMBeanImpl.setDefaultGIOPMinorVersion(kernelMBeanImpl2.getDefaultGIOPMinorVersion());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                } else if (string.equals("DefaultProtocol")) {
                    kernelMBeanImpl.setDefaultProtocol(kernelMBeanImpl2.getDefaultProtocol());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("DefaultSecureProtocol")) {
                    kernelMBeanImpl.setDefaultSecureProtocol(kernelMBeanImpl2.getDefaultSecureProtocol());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("ExecuteQueues")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        kernelMBeanImpl.addExecuteQueue((ExecuteQueueMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        kernelMBeanImpl.removeExecuteQueue((ExecuteQueueMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (kernelMBeanImpl.getExecuteQueues() == null || kernelMBeanImpl.getExecuteQueues().length == 0) {
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 58);
                    }
                } else if (string.equals("IIOP")) {
                    if (n == 2) {
                        kernelMBeanImpl.setIIOP((IIOPMBean)this.createCopy((AbstractDescriptorBean)kernelMBeanImpl2.getIIOP()));
                    } else if (n == 3) {
                        kernelMBeanImpl._destroySingleton("IIOP", kernelMBeanImpl.getIIOP());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 51);
                } else if (string.equals("IIOPLocationForwardPolicy")) {
                    kernelMBeanImpl.setIIOPLocationForwardPolicy(kernelMBeanImpl2.getIIOPLocationForwardPolicy());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                } else if (string.equals("IIOPTxMechanism")) {
                    kernelMBeanImpl.setIIOPTxMechanism(kernelMBeanImpl2.getIIOPTxMechanism());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                } else if (string.equals("IdleConnectionTimeout")) {
                    kernelMBeanImpl.setIdleConnectionTimeout(kernelMBeanImpl2.getIdleConnectionTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 41);
                } else if (string.equals("IdleIIOPConnectionTimeout")) {
                    kernelMBeanImpl.setIdleIIOPConnectionTimeout(kernelMBeanImpl2.getIdleIIOPConnectionTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                } else if (string.equals("IdlePeriodsUntilTimeout")) {
                    kernelMBeanImpl.setIdlePeriodsUntilTimeout(kernelMBeanImpl2.getIdlePeriodsUntilTimeout());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 45);
                } else if (string.equals("JMSThreadPoolSize")) {
                    kernelMBeanImpl.setJMSThreadPoolSize(kernelMBeanImpl2.getJMSThreadPoolSize());
                    kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (!string.equals("KernelDebug")) {
                    if (string.equals("LoadStubUsingContextClassLoader")) {
                        kernelMBeanImpl.setLoadStubUsingContextClassLoader(kernelMBeanImpl2.getLoadStubUsingContextClassLoader());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 67);
                    } else if (string.equals("Log")) {
                        if (n == 2) {
                            kernelMBeanImpl.setLog((LogMBean)this.createCopy((AbstractDescriptorBean)kernelMBeanImpl2.getLog()));
                        } else if (n == 3) {
                            kernelMBeanImpl._destroySingleton("Log", kernelMBeanImpl.getLog());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 52);
                    } else if (string.equals("MTUSize")) {
                        kernelMBeanImpl.setMTUSize(kernelMBeanImpl2.getMTUSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 66);
                    } else if (string.equals("MaxCOMMessageSize")) {
                        kernelMBeanImpl.setMaxCOMMessageSize(kernelMBeanImpl2.getMaxCOMMessageSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                    } else if (string.equals("MaxHTTPMessageSize")) {
                        kernelMBeanImpl.setMaxHTTPMessageSize(kernelMBeanImpl2.getMaxHTTPMessageSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                    } else if (string.equals("MaxIIOPMessageSize")) {
                        kernelMBeanImpl.setMaxIIOPMessageSize(kernelMBeanImpl2.getMaxIIOPMessageSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                    } else if (string.equals("MaxMessageSize")) {
                        kernelMBeanImpl.setMaxMessageSize(kernelMBeanImpl2.getMaxMessageSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                    } else if (string.equals("MaxOpenSockCount")) {
                        kernelMBeanImpl.setMaxOpenSockCount(kernelMBeanImpl2.getMaxOpenSockCount());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 59);
                    } else if (string.equals("MaxT3MessageSize")) {
                        kernelMBeanImpl.setMaxT3MessageSize(kernelMBeanImpl2.getMaxT3MessageSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                    } else if (string.equals("MessagingBridgeThreadPoolSize")) {
                        kernelMBeanImpl.setMessagingBridgeThreadPoolSize(kernelMBeanImpl2.getMessagingBridgeThreadPoolSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 65);
                    } else if (string.equals("MuxerClass")) {
                        kernelMBeanImpl.setMuxerClass(kernelMBeanImpl2.getMuxerClass());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else if (string.equals("Name")) {
                        kernelMBeanImpl.setName(kernelMBeanImpl2.getName());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("PeriodLength")) {
                        kernelMBeanImpl.setPeriodLength(kernelMBeanImpl2.getPeriodLength());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 44);
                    } else if (string.equals("RefreshClientRuntimeDescriptor")) {
                        kernelMBeanImpl.setRefreshClientRuntimeDescriptor(kernelMBeanImpl2.getRefreshClientRuntimeDescriptor());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 68);
                    } else if (string.equals("ResponseTimeout")) {
                        kernelMBeanImpl.setResponseTimeout(kernelMBeanImpl2.getResponseTimeout());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 47);
                    } else if (string.equals("RjvmIdleTimeout")) {
                        kernelMBeanImpl.setRjvmIdleTimeout(kernelMBeanImpl2.getRjvmIdleTimeout());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 46);
                    } else if (string.equals("SSL")) {
                        if (n == 2) {
                            kernelMBeanImpl.setSSL((SSLMBean)this.createCopy((AbstractDescriptorBean)kernelMBeanImpl2.getSSL()));
                        } else if (n == 3) {
                            kernelMBeanImpl._destroySingleton("SSL", kernelMBeanImpl.getSSL());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 50);
                    } else if (string.equals("SelfTuningThreadPoolSizeMax")) {
                        kernelMBeanImpl.setSelfTuningThreadPoolSizeMax(kernelMBeanImpl2.getSelfTuningThreadPoolSizeMax());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("SelfTuningThreadPoolSizeMin")) {
                        kernelMBeanImpl.setSelfTuningThreadPoolSizeMin(kernelMBeanImpl2.getSelfTuningThreadPoolSizeMin());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (string.equals("SocketReaderTimeoutMaxMillis")) {
                        kernelMBeanImpl.setSocketReaderTimeoutMaxMillis(kernelMBeanImpl2.getSocketReaderTimeoutMaxMillis());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                    } else if (string.equals("SocketReaderTimeoutMinMillis")) {
                        kernelMBeanImpl.setSocketReaderTimeoutMinMillis(kernelMBeanImpl2.getSocketReaderTimeoutMinMillis());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                    } else if (string.equals("SocketReaders")) {
                        kernelMBeanImpl.setSocketReaders(kernelMBeanImpl2.getSocketReaders());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                    } else if (string.equals("StdoutFormat")) {
                        kernelMBeanImpl.setStdoutFormat(kernelMBeanImpl2.getStdoutFormat());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 60);
                    } else if (string.equals("StdoutSeverityLevel")) {
                        kernelMBeanImpl.setStdoutSeverityLevel(kernelMBeanImpl2.getStdoutSeverityLevel());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 54);
                    } else if (string.equals("StuckThreadMaxTime")) {
                        kernelMBeanImpl.setStuckThreadMaxTime(kernelMBeanImpl2.getStuckThreadMaxTime());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 62);
                    } else if (string.equals("StuckThreadTimerInterval")) {
                        kernelMBeanImpl.setStuckThreadTimerInterval(kernelMBeanImpl2.getStuckThreadTimerInterval());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 63);
                    } else if (string.equals("SystemThreadPoolSize")) {
                        kernelMBeanImpl.setSystemThreadPoolSize(kernelMBeanImpl2.getSystemThreadPoolSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("T3ClientAbbrevTableSize")) {
                        kernelMBeanImpl.setT3ClientAbbrevTableSize(kernelMBeanImpl2.getT3ClientAbbrevTableSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 71);
                    } else if (string.equals("T3ServerAbbrevTableSize")) {
                        kernelMBeanImpl.setT3ServerAbbrevTableSize(kernelMBeanImpl2.getT3ServerAbbrevTableSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 72);
                    } else if (string.equals("ThreadPoolPercentSocketReaders")) {
                        kernelMBeanImpl.setThreadPoolPercentSocketReaders(kernelMBeanImpl2.getThreadPoolPercentSocketReaders());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("ThreadPoolSize")) {
                        kernelMBeanImpl.setThreadPoolSize(kernelMBeanImpl2.getThreadPoolSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("TimedOutRefIsolationTime")) {
                        kernelMBeanImpl.setTimedOutRefIsolationTime(kernelMBeanImpl2.getTimedOutRefIsolationTime());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 69);
                    } else if (string.equals("TracingEnabled")) {
                        kernelMBeanImpl.setTracingEnabled(kernelMBeanImpl2.getTracingEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 64);
                    } else if (string.equals("Use81StyleExecuteQueues")) {
                        kernelMBeanImpl.setUse81StyleExecuteQueues(kernelMBeanImpl2.getUse81StyleExecuteQueues());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 70);
                    } else if (string.equals("UseIIOPLocateRequest")) {
                        kernelMBeanImpl.setUseIIOPLocateRequest(kernelMBeanImpl2.getUseIIOPLocateRequest());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                    } else if (string.equals("ValidProtocols")) {
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("AddWorkManagerThreadsByCpuCount")) {
                        kernelMBeanImpl.setAddWorkManagerThreadsByCpuCount(kernelMBeanImpl2.isAddWorkManagerThreadsByCpuCount());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 75);
                    } else if (string.equals("DevPollDisabled")) {
                        kernelMBeanImpl.setDevPollDisabled(kernelMBeanImpl2.isDevPollDisabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("GatheredWritesEnabled")) {
                        kernelMBeanImpl.setGatheredWritesEnabled(kernelMBeanImpl2.isGatheredWritesEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 73);
                    } else if (string.equals("InstrumentStackTraceEnabled")) {
                        kernelMBeanImpl.setInstrumentStackTraceEnabled(kernelMBeanImpl2.isInstrumentStackTraceEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 57);
                    } else if (string.equals("LogRemoteExceptionsEnabled")) {
                        kernelMBeanImpl.setLogRemoteExceptionsEnabled(kernelMBeanImpl2.isLogRemoteExceptionsEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 56);
                    } else if (string.equals("NativeIOEnabled")) {
                        kernelMBeanImpl.setNativeIOEnabled(kernelMBeanImpl2.isNativeIOEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("OutboundEnabled")) {
                        kernelMBeanImpl.setOutboundEnabled(kernelMBeanImpl2.isOutboundEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                    } else if (string.equals("OutboundPrivateKeyEnabled")) {
                        kernelMBeanImpl.setOutboundPrivateKeyEnabled(kernelMBeanImpl2.isOutboundPrivateKeyEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                    } else if (string.equals("ReverseDNSAllowed")) {
                        kernelMBeanImpl.setReverseDNSAllowed(kernelMBeanImpl2.isReverseDNSAllowed());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("ScatteredReadsEnabled")) {
                        kernelMBeanImpl.setScatteredReadsEnabled(kernelMBeanImpl2.isScatteredReadsEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 74);
                    } else if (string.equals("SocketBufferSizeAsChunkSize")) {
                        kernelMBeanImpl.setSocketBufferSizeAsChunkSize(kernelMBeanImpl2.isSocketBufferSizeAsChunkSize());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                    } else if (string.equals("StdoutDebugEnabled")) {
                        kernelMBeanImpl.setStdoutDebugEnabled(kernelMBeanImpl2.isStdoutDebugEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 55);
                    } else if (string.equals("StdoutEnabled")) {
                        kernelMBeanImpl.setStdoutEnabled(kernelMBeanImpl2.isStdoutEnabled());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 53);
                    } else if (string.equals("StdoutLogStack")) {
                        kernelMBeanImpl.setStdoutLogStack(kernelMBeanImpl2.isStdoutLogStack());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 61);
                    } else if (string.equals("UseConcurrentQueueForRequestManager")) {
                        kernelMBeanImpl.setUseConcurrentQueueForRequestManager(kernelMBeanImpl2.isUseConcurrentQueueForRequestManager());
                        kernelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 76);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ConfigurationMBean configurationMBean;
                KernelMBeanImpl kernelMBeanImpl = (KernelMBeanImpl)abstractDescriptorBean;
                super.finishCopy(kernelMBeanImpl, bl, list);
                if ((list == null || !list.contains("AdministrationProtocol")) && this.bean.isAdministrationProtocolSet()) {
                    kernelMBeanImpl.setAdministrationProtocol(this.bean.getAdministrationProtocol());
                }
                if ((list == null || !list.contains("CompleteCOMMessageTimeout")) && this.bean.isCompleteCOMMessageTimeoutSet()) {
                    kernelMBeanImpl.setCompleteCOMMessageTimeout(this.bean.getCompleteCOMMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteHTTPMessageTimeout")) && this.bean.isCompleteHTTPMessageTimeoutSet()) {
                    kernelMBeanImpl.setCompleteHTTPMessageTimeout(this.bean.getCompleteHTTPMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteIIOPMessageTimeout")) && this.bean.isCompleteIIOPMessageTimeoutSet()) {
                    kernelMBeanImpl.setCompleteIIOPMessageTimeout(this.bean.getCompleteIIOPMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteMessageTimeout")) && this.bean.isCompleteMessageTimeoutSet()) {
                    kernelMBeanImpl.setCompleteMessageTimeout(this.bean.getCompleteMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteT3MessageTimeout")) && this.bean.isCompleteT3MessageTimeoutSet()) {
                    kernelMBeanImpl.setCompleteT3MessageTimeout(this.bean.getCompleteT3MessageTimeout());
                }
                if ((list == null || !list.contains("ConnectTimeout")) && this.bean.isConnectTimeoutSet()) {
                    kernelMBeanImpl.setConnectTimeout(this.bean.getConnectTimeout());
                }
                if ((list == null || !list.contains("DGCIdlePeriodsUntilTimeout")) && this.bean.isDGCIdlePeriodsUntilTimeoutSet()) {
                    kernelMBeanImpl.setDGCIdlePeriodsUntilTimeout(this.bean.getDGCIdlePeriodsUntilTimeout());
                }
                if ((list == null || !list.contains("DefaultGIOPMinorVersion")) && this.bean.isDefaultGIOPMinorVersionSet()) {
                    kernelMBeanImpl.setDefaultGIOPMinorVersion(this.bean.getDefaultGIOPMinorVersion());
                }
                if ((list == null || !list.contains("DefaultProtocol")) && this.bean.isDefaultProtocolSet()) {
                    kernelMBeanImpl.setDefaultProtocol(this.bean.getDefaultProtocol());
                }
                if ((list == null || !list.contains("DefaultSecureProtocol")) && this.bean.isDefaultSecureProtocolSet()) {
                    kernelMBeanImpl.setDefaultSecureProtocol(this.bean.getDefaultSecureProtocol());
                }
                if (!(list != null && list.contains("ExecuteQueues") || !this.bean.isExecuteQueuesSet() || kernelMBeanImpl._isSet(58))) {
                    ExecuteQueueMBean[] executeQueueMBeanArray = this.bean.getExecuteQueues();
                    ExecuteQueueMBean[] executeQueueMBeanArray2 = new ExecuteQueueMBean[executeQueueMBeanArray.length];
                    for (int i = 0; i < executeQueueMBeanArray2.length; ++i) {
                        executeQueueMBeanArray2[i] = (ExecuteQueueMBean)this.createCopy((AbstractDescriptorBean)executeQueueMBeanArray[i], bl);
                    }
                    kernelMBeanImpl.setExecuteQueues(executeQueueMBeanArray2);
                }
                if (!(list != null && list.contains("IIOP") || !this.bean.isIIOPSet() || kernelMBeanImpl._isSet(51))) {
                    configurationMBean = this.bean.getIIOP();
                    kernelMBeanImpl.setIIOP(null);
                    kernelMBeanImpl.setIIOP(configurationMBean == null ? null : (IIOPMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("IIOPLocationForwardPolicy")) && this.bean.isIIOPLocationForwardPolicySet()) {
                    kernelMBeanImpl.setIIOPLocationForwardPolicy(this.bean.getIIOPLocationForwardPolicy());
                }
                if ((list == null || !list.contains("IIOPTxMechanism")) && this.bean.isIIOPTxMechanismSet()) {
                    kernelMBeanImpl.setIIOPTxMechanism(this.bean.getIIOPTxMechanism());
                }
                if ((list == null || !list.contains("IdleConnectionTimeout")) && this.bean.isIdleConnectionTimeoutSet()) {
                    kernelMBeanImpl.setIdleConnectionTimeout(this.bean.getIdleConnectionTimeout());
                }
                if ((list == null || !list.contains("IdleIIOPConnectionTimeout")) && this.bean.isIdleIIOPConnectionTimeoutSet()) {
                    kernelMBeanImpl.setIdleIIOPConnectionTimeout(this.bean.getIdleIIOPConnectionTimeout());
                }
                if ((list == null || !list.contains("IdlePeriodsUntilTimeout")) && this.bean.isIdlePeriodsUntilTimeoutSet()) {
                    kernelMBeanImpl.setIdlePeriodsUntilTimeout(this.bean.getIdlePeriodsUntilTimeout());
                }
                if ((list == null || !list.contains("JMSThreadPoolSize")) && this.bean.isJMSThreadPoolSizeSet()) {
                    kernelMBeanImpl.setJMSThreadPoolSize(this.bean.getJMSThreadPoolSize());
                }
                if ((list == null || !list.contains("LoadStubUsingContextClassLoader")) && this.bean.isLoadStubUsingContextClassLoaderSet()) {
                    kernelMBeanImpl.setLoadStubUsingContextClassLoader(this.bean.getLoadStubUsingContextClassLoader());
                }
                if (!(list != null && list.contains("Log") || !this.bean.isLogSet() || kernelMBeanImpl._isSet(52))) {
                    configurationMBean = this.bean.getLog();
                    kernelMBeanImpl.setLog(null);
                    kernelMBeanImpl.setLog(configurationMBean == null ? null : (LogMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("MTUSize")) && this.bean.isMTUSizeSet()) {
                    kernelMBeanImpl.setMTUSize(this.bean.getMTUSize());
                }
                if ((list == null || !list.contains("MaxCOMMessageSize")) && this.bean.isMaxCOMMessageSizeSet()) {
                    kernelMBeanImpl.setMaxCOMMessageSize(this.bean.getMaxCOMMessageSize());
                }
                if ((list == null || !list.contains("MaxHTTPMessageSize")) && this.bean.isMaxHTTPMessageSizeSet()) {
                    kernelMBeanImpl.setMaxHTTPMessageSize(this.bean.getMaxHTTPMessageSize());
                }
                if ((list == null || !list.contains("MaxIIOPMessageSize")) && this.bean.isMaxIIOPMessageSizeSet()) {
                    kernelMBeanImpl.setMaxIIOPMessageSize(this.bean.getMaxIIOPMessageSize());
                }
                if ((list == null || !list.contains("MaxMessageSize")) && this.bean.isMaxMessageSizeSet()) {
                    kernelMBeanImpl.setMaxMessageSize(this.bean.getMaxMessageSize());
                }
                if ((list == null || !list.contains("MaxOpenSockCount")) && this.bean.isMaxOpenSockCountSet()) {
                    kernelMBeanImpl.setMaxOpenSockCount(this.bean.getMaxOpenSockCount());
                }
                if ((list == null || !list.contains("MaxT3MessageSize")) && this.bean.isMaxT3MessageSizeSet()) {
                    kernelMBeanImpl.setMaxT3MessageSize(this.bean.getMaxT3MessageSize());
                }
                if ((list == null || !list.contains("MessagingBridgeThreadPoolSize")) && this.bean.isMessagingBridgeThreadPoolSizeSet()) {
                    kernelMBeanImpl.setMessagingBridgeThreadPoolSize(this.bean.getMessagingBridgeThreadPoolSize());
                }
                if ((list == null || !list.contains("MuxerClass")) && this.bean.isMuxerClassSet()) {
                    kernelMBeanImpl.setMuxerClass(this.bean.getMuxerClass());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    kernelMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PeriodLength")) && this.bean.isPeriodLengthSet()) {
                    kernelMBeanImpl.setPeriodLength(this.bean.getPeriodLength());
                }
                if ((list == null || !list.contains("RefreshClientRuntimeDescriptor")) && this.bean.isRefreshClientRuntimeDescriptorSet()) {
                    kernelMBeanImpl.setRefreshClientRuntimeDescriptor(this.bean.getRefreshClientRuntimeDescriptor());
                }
                if ((list == null || !list.contains("ResponseTimeout")) && this.bean.isResponseTimeoutSet()) {
                    kernelMBeanImpl.setResponseTimeout(this.bean.getResponseTimeout());
                }
                if ((list == null || !list.contains("RjvmIdleTimeout")) && this.bean.isRjvmIdleTimeoutSet()) {
                    kernelMBeanImpl.setRjvmIdleTimeout(this.bean.getRjvmIdleTimeout());
                }
                if (!(list != null && list.contains("SSL") || !this.bean.isSSLSet() || kernelMBeanImpl._isSet(50))) {
                    configurationMBean = this.bean.getSSL();
                    kernelMBeanImpl.setSSL(null);
                    kernelMBeanImpl.setSSL(configurationMBean == null ? null : (SSLMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("SelfTuningThreadPoolSizeMax")) && this.bean.isSelfTuningThreadPoolSizeMaxSet()) {
                    kernelMBeanImpl.setSelfTuningThreadPoolSizeMax(this.bean.getSelfTuningThreadPoolSizeMax());
                }
                if ((list == null || !list.contains("SelfTuningThreadPoolSizeMin")) && this.bean.isSelfTuningThreadPoolSizeMinSet()) {
                    kernelMBeanImpl.setSelfTuningThreadPoolSizeMin(this.bean.getSelfTuningThreadPoolSizeMin());
                }
                if ((list == null || !list.contains("SocketReaderTimeoutMaxMillis")) && this.bean.isSocketReaderTimeoutMaxMillisSet()) {
                    kernelMBeanImpl.setSocketReaderTimeoutMaxMillis(this.bean.getSocketReaderTimeoutMaxMillis());
                }
                if ((list == null || !list.contains("SocketReaderTimeoutMinMillis")) && this.bean.isSocketReaderTimeoutMinMillisSet()) {
                    kernelMBeanImpl.setSocketReaderTimeoutMinMillis(this.bean.getSocketReaderTimeoutMinMillis());
                }
                if ((list == null || !list.contains("SocketReaders")) && this.bean.isSocketReadersSet()) {
                    kernelMBeanImpl.setSocketReaders(this.bean.getSocketReaders());
                }
                if (bl && (list == null || !list.contains("StdoutFormat")) && this.bean.isStdoutFormatSet()) {
                    kernelMBeanImpl.setStdoutFormat(this.bean.getStdoutFormat());
                }
                if (bl && (list == null || !list.contains("StdoutSeverityLevel")) && this.bean.isStdoutSeverityLevelSet()) {
                    kernelMBeanImpl.setStdoutSeverityLevel(this.bean.getStdoutSeverityLevel());
                }
                if ((list == null || !list.contains("StuckThreadMaxTime")) && this.bean.isStuckThreadMaxTimeSet()) {
                    kernelMBeanImpl.setStuckThreadMaxTime(this.bean.getStuckThreadMaxTime());
                }
                if ((list == null || !list.contains("StuckThreadTimerInterval")) && this.bean.isStuckThreadTimerIntervalSet()) {
                    kernelMBeanImpl.setStuckThreadTimerInterval(this.bean.getStuckThreadTimerInterval());
                }
                if ((list == null || !list.contains("SystemThreadPoolSize")) && this.bean.isSystemThreadPoolSizeSet()) {
                    kernelMBeanImpl.setSystemThreadPoolSize(this.bean.getSystemThreadPoolSize());
                }
                if ((list == null || !list.contains("T3ClientAbbrevTableSize")) && this.bean.isT3ClientAbbrevTableSizeSet()) {
                    kernelMBeanImpl.setT3ClientAbbrevTableSize(this.bean.getT3ClientAbbrevTableSize());
                }
                if ((list == null || !list.contains("T3ServerAbbrevTableSize")) && this.bean.isT3ServerAbbrevTableSizeSet()) {
                    kernelMBeanImpl.setT3ServerAbbrevTableSize(this.bean.getT3ServerAbbrevTableSize());
                }
                if ((list == null || !list.contains("ThreadPoolPercentSocketReaders")) && this.bean.isThreadPoolPercentSocketReadersSet()) {
                    kernelMBeanImpl.setThreadPoolPercentSocketReaders(this.bean.getThreadPoolPercentSocketReaders());
                }
                if ((list == null || !list.contains("ThreadPoolSize")) && this.bean.isThreadPoolSizeSet()) {
                    kernelMBeanImpl.setThreadPoolSize(this.bean.getThreadPoolSize());
                }
                if ((list == null || !list.contains("TimedOutRefIsolationTime")) && this.bean.isTimedOutRefIsolationTimeSet()) {
                    kernelMBeanImpl.setTimedOutRefIsolationTime(this.bean.getTimedOutRefIsolationTime());
                }
                if ((list == null || !list.contains("TracingEnabled")) && this.bean.isTracingEnabledSet()) {
                    kernelMBeanImpl.setTracingEnabled(this.bean.getTracingEnabled());
                }
                if ((list == null || !list.contains("Use81StyleExecuteQueues")) && this.bean.isUse81StyleExecuteQueuesSet()) {
                    kernelMBeanImpl.setUse81StyleExecuteQueues(this.bean.getUse81StyleExecuteQueues());
                }
                if ((list == null || !list.contains("UseIIOPLocateRequest")) && this.bean.isUseIIOPLocateRequestSet()) {
                    kernelMBeanImpl.setUseIIOPLocateRequest(this.bean.getUseIIOPLocateRequest());
                }
                if (list != null && list.contains("ValidProtocols") || this.bean.isValidProtocolsSet()) {
                    // empty if block
                }
                if ((list == null || !list.contains("AddWorkManagerThreadsByCpuCount")) && this.bean.isAddWorkManagerThreadsByCpuCountSet()) {
                    kernelMBeanImpl.setAddWorkManagerThreadsByCpuCount(this.bean.isAddWorkManagerThreadsByCpuCount());
                }
                if ((list == null || !list.contains("DevPollDisabled")) && this.bean.isDevPollDisabledSet()) {
                    kernelMBeanImpl.setDevPollDisabled(this.bean.isDevPollDisabled());
                }
                if ((list == null || !list.contains("GatheredWritesEnabled")) && this.bean.isGatheredWritesEnabledSet()) {
                    kernelMBeanImpl.setGatheredWritesEnabled(this.bean.isGatheredWritesEnabled());
                }
                if ((list == null || !list.contains("InstrumentStackTraceEnabled")) && this.bean.isInstrumentStackTraceEnabledSet()) {
                    kernelMBeanImpl.setInstrumentStackTraceEnabled(this.bean.isInstrumentStackTraceEnabled());
                }
                if ((list == null || !list.contains("LogRemoteExceptionsEnabled")) && this.bean.isLogRemoteExceptionsEnabledSet()) {
                    kernelMBeanImpl.setLogRemoteExceptionsEnabled(this.bean.isLogRemoteExceptionsEnabled());
                }
                if ((list == null || !list.contains("NativeIOEnabled")) && this.bean.isNativeIOEnabledSet()) {
                    kernelMBeanImpl.setNativeIOEnabled(this.bean.isNativeIOEnabled());
                }
                if ((list == null || !list.contains("OutboundEnabled")) && this.bean.isOutboundEnabledSet()) {
                    kernelMBeanImpl.setOutboundEnabled(this.bean.isOutboundEnabled());
                }
                if ((list == null || !list.contains("OutboundPrivateKeyEnabled")) && this.bean.isOutboundPrivateKeyEnabledSet()) {
                    kernelMBeanImpl.setOutboundPrivateKeyEnabled(this.bean.isOutboundPrivateKeyEnabled());
                }
                if ((list == null || !list.contains("ReverseDNSAllowed")) && this.bean.isReverseDNSAllowedSet()) {
                    kernelMBeanImpl.setReverseDNSAllowed(this.bean.isReverseDNSAllowed());
                }
                if ((list == null || !list.contains("ScatteredReadsEnabled")) && this.bean.isScatteredReadsEnabledSet()) {
                    kernelMBeanImpl.setScatteredReadsEnabled(this.bean.isScatteredReadsEnabled());
                }
                if ((list == null || !list.contains("SocketBufferSizeAsChunkSize")) && this.bean.isSocketBufferSizeAsChunkSizeSet()) {
                    kernelMBeanImpl.setSocketBufferSizeAsChunkSize(this.bean.isSocketBufferSizeAsChunkSize());
                }
                if (bl && (list == null || !list.contains("StdoutDebugEnabled")) && this.bean.isStdoutDebugEnabledSet()) {
                    kernelMBeanImpl.setStdoutDebugEnabled(this.bean.isStdoutDebugEnabled());
                }
                if (bl && (list == null || !list.contains("StdoutEnabled")) && this.bean.isStdoutEnabledSet()) {
                    kernelMBeanImpl.setStdoutEnabled(this.bean.isStdoutEnabled());
                }
                if (bl && (list == null || !list.contains("StdoutLogStack")) && this.bean.isStdoutLogStackSet()) {
                    kernelMBeanImpl.setStdoutLogStack(this.bean.isStdoutLogStack());
                }
                if ((list == null || !list.contains("UseConcurrentQueueForRequestManager")) && this.bean.isUseConcurrentQueueForRequestManagerSet()) {
                    kernelMBeanImpl.setUseConcurrentQueueForRequestManager(this.bean.isUseConcurrentQueueForRequestManager());
                }
                return kernelMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getExecuteQueues(), clazz, object);
            this.inferSubTree(this.bean.getIIOP(), clazz, object);
            this.inferSubTree(this.bean.getKernelDebug(), clazz, object);
            this.inferSubTree(this.bean.getLog(), clazz, object);
            this.inferSubTree(this.bean.getSSL(), clazz, object);
        }
    }
}

