/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.BasicRealmMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.LDAPRealmMBean;
import weblogic.management.mbeans.custom.LDAPRealm;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class LDAPRealmMBeanImpl
extends BasicRealmMBeanImpl
implements LDAPRealmMBean,
Serializable {
    private String _AuthProtocol;
    private String _Credential;
    private byte[] _CredentialEncrypted;
    private String _GroupDN;
    private boolean _GroupIsContext;
    private String _GroupNameAttribute;
    private String _GroupUsernameAttribute;
    private String _LDAPURL;
    private String _LdapProvider;
    private String _Name;
    private String _Principal;
    private String _RealmClassName;
    private boolean _SSLEnable;
    private String _UserAuthentication;
    private String _UserDN;
    private String _UserNameAttribute;
    private String _UserPasswordAttribute;
    private LDAPRealm _customizer;
    private static SchemaHelper2 _schemaHelper;

    public LDAPRealmMBeanImpl() {
        try {
            this._customizer = new LDAPRealm(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public LDAPRealmMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new LDAPRealm(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getLDAPURL() {
        return this._LDAPURL;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public String getRealmClassName() {
        return this._customizer.getRealmClassName();
    }

    public boolean isLDAPURLSet() {
        return this._isSet(8);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isRealmClassNameSet() {
        return this._isSet(7);
    }

    public void setRealmClassName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._RealmClassName;
        this._RealmClassName = string;
        this._postSet(7, string2, string);
    }

    public void setLDAPURL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._LDAPURL;
        this._LDAPURL = string;
        this._postSet(8, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public String getPrincipal() {
        return this._Principal;
    }

    public boolean isPrincipalSet() {
        return this._isSet(9);
    }

    public void setPrincipal(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Principal;
        this._Principal = string;
        this._postSet(9, string2, string);
    }

    public String getCredential() {
        byte[] byArray = this.getCredentialEncrypted();
        return byArray == null ? null : this._decrypt("Credential", byArray);
    }

    public boolean isCredentialSet() {
        return this.isCredentialEncryptedSet();
    }

    public void setCredential(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setCredentialEncrypted(string == null ? null : this._encrypt("Credential", string));
    }

    public byte[] getCredentialEncrypted() {
        return this._getHelper()._cloneArray(this._CredentialEncrypted);
    }

    public String getCredentialEncryptedAsString() {
        byte[] byArray = this.getCredentialEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isCredentialEncryptedSet() {
        return this._isSet(11);
    }

    public void setCredentialEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setCredentialEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean getSSLEnable() {
        return this._SSLEnable;
    }

    public boolean isSSLEnableSet() {
        return this._isSet(12);
    }

    public void setSSLEnable(boolean bl) {
        boolean bl2 = this._SSLEnable;
        this._SSLEnable = bl;
        this._postSet(12, bl2, bl);
    }

    public String getLdapProvider() {
        return this._LdapProvider;
    }

    public boolean isLdapProviderSet() {
        return this._isSet(13);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setLdapProvider(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._LdapProvider;
        this._LdapProvider = string;
        this._postSet(13, string2, string);
    }

    public String getAuthProtocol() {
        return this._AuthProtocol;
    }

    public boolean isAuthProtocolSet() {
        return this._isSet(14);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setAuthProtocol(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"none", "simple", "CRAM-MD5"};
        string = LegalChecks.checkInEnum((String)"AuthProtocol", (String)string, (String[])stringArray);
        String string2 = this._AuthProtocol;
        this._AuthProtocol = string;
        this._postSet(14, string2, string);
    }

    public String getUserAuthentication() {
        return this._UserAuthentication;
    }

    public boolean isUserAuthenticationSet() {
        return this._isSet(15);
    }

    public void setUserAuthentication(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"bind", "external", "local"};
        string = LegalChecks.checkInEnum((String)"UserAuthentication", (String)string, (String[])stringArray);
        String string2 = this._UserAuthentication;
        this._UserAuthentication = string;
        this._postSet(15, string2, string);
    }

    public String getUserPasswordAttribute() {
        return this._UserPasswordAttribute;
    }

    public boolean isUserPasswordAttributeSet() {
        return this._isSet(16);
    }

    public void setUserPasswordAttribute(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._UserPasswordAttribute;
        this._UserPasswordAttribute = string;
        this._postSet(16, string2, string);
    }

    public String getUserDN() {
        return this._UserDN;
    }

    public boolean isUserDNSet() {
        return this._isSet(17);
    }

    public void setUserDN(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._UserDN;
        this._UserDN = string;
        this._postSet(17, string2, string);
    }

    public String getUserNameAttribute() {
        return this._UserNameAttribute;
    }

    public boolean isUserNameAttributeSet() {
        return this._isSet(18);
    }

    public void setUserNameAttribute(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._UserNameAttribute;
        this._UserNameAttribute = string;
        this._postSet(18, string2, string);
    }

    public String getGroupDN() {
        return this._GroupDN;
    }

    public boolean isGroupDNSet() {
        return this._isSet(19);
    }

    public void setGroupDN(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._GroupDN;
        this._GroupDN = string;
        this._postSet(19, string2, string);
    }

    public String getGroupNameAttribute() {
        return this._GroupNameAttribute;
    }

    public boolean isGroupNameAttributeSet() {
        return this._isSet(20);
    }

    public void setGroupNameAttribute(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._GroupNameAttribute;
        this._GroupNameAttribute = string;
        this._postSet(20, string2, string);
    }

    public boolean getGroupIsContext() {
        return this._GroupIsContext;
    }

    public boolean isGroupIsContextSet() {
        return this._isSet(21);
    }

    public void setGroupIsContext(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._GroupIsContext;
        this._GroupIsContext = bl;
        this._postSet(21, bl2, bl);
    }

    public String getGroupUsernameAttribute() {
        return this._GroupUsernameAttribute;
    }

    public boolean isGroupUsernameAttributeSet() {
        return this._isSet(22);
    }

    public void setGroupUsernameAttribute(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._GroupUsernameAttribute;
        this._GroupUsernameAttribute = string;
        this._postSet(22, string2, string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setCredentialEncrypted(byte[] byArray) {
        byte[] byArray2 = this._CredentialEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: CredentialEncrypted of LDAPRealmMBean");
        }
        this._getHelper()._clearArray(this._CredentialEncrypted);
        this._CredentialEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(11, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 10) {
                this._markSet(11, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 14;
        }
        try {
            switch (n) {
                case 14: {
                    this._AuthProtocol = "none";
                    if (bl) break;
                }
                case 10: {
                    this._CredentialEncrypted = null;
                    if (bl) break;
                }
                case 11: {
                    this._CredentialEncrypted = null;
                    if (bl) break;
                }
                case 19: {
                    this._GroupDN = null;
                    if (bl) break;
                }
                case 21: {
                    this._GroupIsContext = true;
                    if (bl) break;
                }
                case 20: {
                    this._GroupNameAttribute = "cn";
                    if (bl) break;
                }
                case 22: {
                    this._GroupUsernameAttribute = "member";
                    if (bl) break;
                }
                case 8: {
                    this._LDAPURL = "ldap://ldapserver:389";
                    if (bl) break;
                }
                case 13: {
                    this._LdapProvider = "com.sun.jndi.ldap.LdapCtxFactory";
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 9: {
                    this._Principal = null;
                    if (bl) break;
                }
                case 7: {
                    this._RealmClassName = null;
                    if (bl) break;
                }
                case 12: {
                    this._SSLEnable = false;
                    if (bl) break;
                }
                case 15: {
                    this._UserAuthentication = "bind";
                    if (bl) break;
                }
                case 17: {
                    this._UserDN = null;
                    if (bl) break;
                }
                case 18: {
                    this._UserNameAttribute = null;
                    if (bl) break;
                }
                case 16: {
                    this._UserPasswordAttribute = "userpassword";
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "LDAPRealm";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AuthProtocol")) {
            String string2 = this._AuthProtocol;
            this._AuthProtocol = (String)object;
            this._postSet(14, string2, this._AuthProtocol);
            return;
        }
        if (string.equals("Credential")) {
            String string3 = this._Credential;
            this._Credential = (String)object;
            this._postSet(10, string3, this._Credential);
            return;
        }
        if (string.equals("CredentialEncrypted")) {
            byte[] byArray = this._CredentialEncrypted;
            this._CredentialEncrypted = (byte[])object;
            this._postSet(11, byArray, this._CredentialEncrypted);
            return;
        }
        if (string.equals("GroupDN")) {
            String string4 = this._GroupDN;
            this._GroupDN = (String)object;
            this._postSet(19, string4, this._GroupDN);
            return;
        }
        if (string.equals("GroupIsContext")) {
            boolean bl = this._GroupIsContext;
            this._GroupIsContext = (Boolean)object;
            this._postSet(21, bl, this._GroupIsContext);
            return;
        }
        if (string.equals("GroupNameAttribute")) {
            String string5 = this._GroupNameAttribute;
            this._GroupNameAttribute = (String)object;
            this._postSet(20, string5, this._GroupNameAttribute);
            return;
        }
        if (string.equals("GroupUsernameAttribute")) {
            String string6 = this._GroupUsernameAttribute;
            this._GroupUsernameAttribute = (String)object;
            this._postSet(22, string6, this._GroupUsernameAttribute);
            return;
        }
        if (string.equals("LDAPURL")) {
            String string7 = this._LDAPURL;
            this._LDAPURL = (String)object;
            this._postSet(8, string7, this._LDAPURL);
            return;
        }
        if (string.equals("LdapProvider")) {
            String string8 = this._LdapProvider;
            this._LdapProvider = (String)object;
            this._postSet(13, string8, this._LdapProvider);
            return;
        }
        if (string.equals("Name")) {
            String string9 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string9, this._Name);
            return;
        }
        if (string.equals("Principal")) {
            String string10 = this._Principal;
            this._Principal = (String)object;
            this._postSet(9, string10, this._Principal);
            return;
        }
        if (string.equals("RealmClassName")) {
            String string11 = this._RealmClassName;
            this._RealmClassName = (String)object;
            this._postSet(7, string11, this._RealmClassName);
            return;
        }
        if (string.equals("SSLEnable")) {
            boolean bl = this._SSLEnable;
            this._SSLEnable = (Boolean)object;
            this._postSet(12, bl, this._SSLEnable);
            return;
        }
        if (string.equals("UserAuthentication")) {
            String string12 = this._UserAuthentication;
            this._UserAuthentication = (String)object;
            this._postSet(15, string12, this._UserAuthentication);
            return;
        }
        if (string.equals("UserDN")) {
            String string13 = this._UserDN;
            this._UserDN = (String)object;
            this._postSet(17, string13, this._UserDN);
            return;
        }
        if (string.equals("UserNameAttribute")) {
            String string14 = this._UserNameAttribute;
            this._UserNameAttribute = (String)object;
            this._postSet(18, string14, this._UserNameAttribute);
            return;
        }
        if (string.equals("UserPasswordAttribute")) {
            String string15 = this._UserPasswordAttribute;
            this._UserPasswordAttribute = (String)object;
            this._postSet(16, string15, this._UserPasswordAttribute);
            return;
        }
        if (string.equals("customizer")) {
            LDAPRealm lDAPRealm = this._customizer;
            this._customizer = (LDAPRealm)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AuthProtocol")) {
            return this._AuthProtocol;
        }
        if (string.equals("Credential")) {
            return this._Credential;
        }
        if (string.equals("CredentialEncrypted")) {
            return this._CredentialEncrypted;
        }
        if (string.equals("GroupDN")) {
            return this._GroupDN;
        }
        if (string.equals("GroupIsContext")) {
            return new Boolean(this._GroupIsContext);
        }
        if (string.equals("GroupNameAttribute")) {
            return this._GroupNameAttribute;
        }
        if (string.equals("GroupUsernameAttribute")) {
            return this._GroupUsernameAttribute;
        }
        if (string.equals("LDAPURL")) {
            return this._LDAPURL;
        }
        if (string.equals("LdapProvider")) {
            return this._LdapProvider;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Principal")) {
            return this._Principal;
        }
        if (string.equals("RealmClassName")) {
            return this._RealmClassName;
        }
        if (string.equals("SSLEnable")) {
            return new Boolean(this._SSLEnable);
        }
        if (string.equals("UserAuthentication")) {
            return this._UserAuthentication;
        }
        if (string.equals("UserDN")) {
            return this._UserDN;
        }
        if (string.equals("UserNameAttribute")) {
            return this._UserNameAttribute;
        }
        if (string.equals("UserPasswordAttribute")) {
            return this._UserPasswordAttribute;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends BasicRealmMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (string.equals("auth-protocol")) {
                        return 14;
                    }
                    if (!string.equals("ldap-provider")) break;
                    return 13;
                }
                case 10: {
                    if (string.equals("credential")) {
                        return 10;
                    }
                    if (!string.equals("ssl-enable")) break;
                    return 12;
                }
                case 20: {
                    if (string.equals("credential-encrypted")) {
                        return 11;
                    }
                    if (!string.equals("group-name-attribute")) break;
                    return 20;
                }
                case 7: {
                    if (!string.equals("groupdn")) break;
                    return 19;
                }
                case 16: {
                    if (string.equals("group-is-context")) {
                        return 21;
                    }
                    if (!string.equals("realm-class-name")) break;
                    return 7;
                }
                case 24: {
                    if (!string.equals("group-username-attribute")) break;
                    return 22;
                }
                case 8: {
                    if (!string.equals("ldap-url")) break;
                    return 8;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 9: {
                    if (!string.equals("principal")) break;
                    return 9;
                }
                case 19: {
                    if (string.equals("user-authentication")) {
                        return 15;
                    }
                    if (!string.equals("user-name-attribute")) break;
                    return 18;
                }
                case 6: {
                    if (!string.equals("userdn")) break;
                    return 17;
                }
                case 23: {
                    if (!string.equals("user-password-attribute")) break;
                    return 16;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 14: {
                    return "auth-protocol";
                }
                case 10: {
                    return "credential";
                }
                case 11: {
                    return "credential-encrypted";
                }
                case 19: {
                    return "groupdn";
                }
                case 21: {
                    return "group-is-context";
                }
                case 20: {
                    return "group-name-attribute";
                }
                case 22: {
                    return "group-username-attribute";
                }
                case 8: {
                    return "ldap-url";
                }
                case 13: {
                    return "ldap-provider";
                }
                case 2: {
                    return "name";
                }
                case 9: {
                    return "principal";
                }
                case 7: {
                    return "realm-class-name";
                }
                case 12: {
                    return "ssl-enable";
                }
                case 15: {
                    return "user-authentication";
                }
                case 17: {
                    return "userdn";
                }
                case 18: {
                    return "user-name-attribute";
                }
                case 16: {
                    return "user-password-attribute";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends BasicRealmMBeanImpl.Helper {
        private LDAPRealmMBeanImpl bean;

        protected Helper(LDAPRealmMBeanImpl lDAPRealmMBeanImpl) {
            super(lDAPRealmMBeanImpl);
            this.bean = lDAPRealmMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 14: {
                    return "AuthProtocol";
                }
                case 10: {
                    return "Credential";
                }
                case 11: {
                    return "CredentialEncrypted";
                }
                case 19: {
                    return "GroupDN";
                }
                case 21: {
                    return "GroupIsContext";
                }
                case 20: {
                    return "GroupNameAttribute";
                }
                case 22: {
                    return "GroupUsernameAttribute";
                }
                case 8: {
                    return "LDAPURL";
                }
                case 13: {
                    return "LdapProvider";
                }
                case 2: {
                    return "Name";
                }
                case 9: {
                    return "Principal";
                }
                case 7: {
                    return "RealmClassName";
                }
                case 12: {
                    return "SSLEnable";
                }
                case 15: {
                    return "UserAuthentication";
                }
                case 17: {
                    return "UserDN";
                }
                case 18: {
                    return "UserNameAttribute";
                }
                case 16: {
                    return "UserPasswordAttribute";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AuthProtocol")) {
                return 14;
            }
            if (string.equals("Credential")) {
                return 10;
            }
            if (string.equals("CredentialEncrypted")) {
                return 11;
            }
            if (string.equals("GroupDN")) {
                return 19;
            }
            if (string.equals("GroupIsContext")) {
                return 21;
            }
            if (string.equals("GroupNameAttribute")) {
                return 20;
            }
            if (string.equals("GroupUsernameAttribute")) {
                return 22;
            }
            if (string.equals("LDAPURL")) {
                return 8;
            }
            if (string.equals("LdapProvider")) {
                return 13;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Principal")) {
                return 9;
            }
            if (string.equals("RealmClassName")) {
                return 7;
            }
            if (string.equals("SSLEnable")) {
                return 12;
            }
            if (string.equals("UserAuthentication")) {
                return 15;
            }
            if (string.equals("UserDN")) {
                return 17;
            }
            if (string.equals("UserNameAttribute")) {
                return 18;
            }
            if (string.equals("UserPasswordAttribute")) {
                return 16;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAuthProtocolSet()) {
                    stringBuffer.append("AuthProtocol");
                    stringBuffer.append(String.valueOf(this.bean.getAuthProtocol()));
                }
                if (this.bean.isCredentialSet()) {
                    stringBuffer.append("Credential");
                    stringBuffer.append(String.valueOf(this.bean.getCredential()));
                }
                if (this.bean.isCredentialEncryptedSet()) {
                    stringBuffer.append("CredentialEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getCredentialEncrypted())));
                }
                if (this.bean.isGroupDNSet()) {
                    stringBuffer.append("GroupDN");
                    stringBuffer.append(String.valueOf(this.bean.getGroupDN()));
                }
                if (this.bean.isGroupIsContextSet()) {
                    stringBuffer.append("GroupIsContext");
                    stringBuffer.append(String.valueOf(this.bean.getGroupIsContext()));
                }
                if (this.bean.isGroupNameAttributeSet()) {
                    stringBuffer.append("GroupNameAttribute");
                    stringBuffer.append(String.valueOf(this.bean.getGroupNameAttribute()));
                }
                if (this.bean.isGroupUsernameAttributeSet()) {
                    stringBuffer.append("GroupUsernameAttribute");
                    stringBuffer.append(String.valueOf(this.bean.getGroupUsernameAttribute()));
                }
                if (this.bean.isLDAPURLSet()) {
                    stringBuffer.append("LDAPURL");
                    stringBuffer.append(String.valueOf(this.bean.getLDAPURL()));
                }
                if (this.bean.isLdapProviderSet()) {
                    stringBuffer.append("LdapProvider");
                    stringBuffer.append(String.valueOf(this.bean.getLdapProvider()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPrincipalSet()) {
                    stringBuffer.append("Principal");
                    stringBuffer.append(String.valueOf(this.bean.getPrincipal()));
                }
                if (this.bean.isRealmClassNameSet()) {
                    stringBuffer.append("RealmClassName");
                    stringBuffer.append(String.valueOf(this.bean.getRealmClassName()));
                }
                if (this.bean.isSSLEnableSet()) {
                    stringBuffer.append("SSLEnable");
                    stringBuffer.append(String.valueOf(this.bean.getSSLEnable()));
                }
                if (this.bean.isUserAuthenticationSet()) {
                    stringBuffer.append("UserAuthentication");
                    stringBuffer.append(String.valueOf(this.bean.getUserAuthentication()));
                }
                if (this.bean.isUserDNSet()) {
                    stringBuffer.append("UserDN");
                    stringBuffer.append(String.valueOf(this.bean.getUserDN()));
                }
                if (this.bean.isUserNameAttributeSet()) {
                    stringBuffer.append("UserNameAttribute");
                    stringBuffer.append(String.valueOf(this.bean.getUserNameAttribute()));
                }
                if (this.bean.isUserPasswordAttributeSet()) {
                    stringBuffer.append("UserPasswordAttribute");
                    stringBuffer.append(String.valueOf(this.bean.getUserPasswordAttribute()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                LDAPRealmMBeanImpl lDAPRealmMBeanImpl = (LDAPRealmMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AuthProtocol", this.bean.getAuthProtocol(), lDAPRealmMBeanImpl.getAuthProtocol(), false);
                this.computeDiff("CredentialEncrypted", this.bean.getCredentialEncrypted(), lDAPRealmMBeanImpl.getCredentialEncrypted(), false);
                this.computeDiff("GroupDN", this.bean.getGroupDN(), lDAPRealmMBeanImpl.getGroupDN(), false);
                this.computeDiff("GroupIsContext", this.bean.getGroupIsContext(), lDAPRealmMBeanImpl.getGroupIsContext(), false);
                this.computeDiff("GroupNameAttribute", this.bean.getGroupNameAttribute(), lDAPRealmMBeanImpl.getGroupNameAttribute(), false);
                this.computeDiff("GroupUsernameAttribute", this.bean.getGroupUsernameAttribute(), lDAPRealmMBeanImpl.getGroupUsernameAttribute(), false);
                this.computeDiff("LDAPURL", this.bean.getLDAPURL(), lDAPRealmMBeanImpl.getLDAPURL(), false);
                this.computeDiff("LdapProvider", this.bean.getLdapProvider(), lDAPRealmMBeanImpl.getLdapProvider(), false);
                this.computeDiff("Name", this.bean.getName(), lDAPRealmMBeanImpl.getName(), false);
                this.computeDiff("Principal", this.bean.getPrincipal(), lDAPRealmMBeanImpl.getPrincipal(), false);
                this.computeDiff("RealmClassName", this.bean.getRealmClassName(), lDAPRealmMBeanImpl.getRealmClassName(), false);
                this.computeDiff("SSLEnable", this.bean.getSSLEnable(), lDAPRealmMBeanImpl.getSSLEnable(), false);
                this.computeDiff("UserAuthentication", this.bean.getUserAuthentication(), lDAPRealmMBeanImpl.getUserAuthentication(), false);
                this.computeDiff("UserDN", this.bean.getUserDN(), lDAPRealmMBeanImpl.getUserDN(), false);
                this.computeDiff("UserNameAttribute", this.bean.getUserNameAttribute(), lDAPRealmMBeanImpl.getUserNameAttribute(), false);
                this.computeDiff("UserPasswordAttribute", this.bean.getUserPasswordAttribute(), lDAPRealmMBeanImpl.getUserPasswordAttribute(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                LDAPRealmMBeanImpl lDAPRealmMBeanImpl = (LDAPRealmMBeanImpl)beanUpdateEvent.getSourceBean();
                LDAPRealmMBeanImpl lDAPRealmMBeanImpl2 = (LDAPRealmMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AuthProtocol")) {
                    lDAPRealmMBeanImpl.setAuthProtocol(lDAPRealmMBeanImpl2.getAuthProtocol());
                    lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (!string.equals("Credential")) {
                    if (string.equals("CredentialEncrypted")) {
                        lDAPRealmMBeanImpl.setCredentialEncrypted(lDAPRealmMBeanImpl2.getCredentialEncrypted());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("GroupDN")) {
                        lDAPRealmMBeanImpl.setGroupDN(lDAPRealmMBeanImpl2.getGroupDN());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else if (string.equals("GroupIsContext")) {
                        lDAPRealmMBeanImpl.setGroupIsContext(lDAPRealmMBeanImpl2.getGroupIsContext());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("GroupNameAttribute")) {
                        lDAPRealmMBeanImpl.setGroupNameAttribute(lDAPRealmMBeanImpl2.getGroupNameAttribute());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                    } else if (string.equals("GroupUsernameAttribute")) {
                        lDAPRealmMBeanImpl.setGroupUsernameAttribute(lDAPRealmMBeanImpl2.getGroupUsernameAttribute());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                    } else if (string.equals("LDAPURL")) {
                        lDAPRealmMBeanImpl.setLDAPURL(lDAPRealmMBeanImpl2.getLDAPURL());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("LdapProvider")) {
                        lDAPRealmMBeanImpl.setLdapProvider(lDAPRealmMBeanImpl2.getLdapProvider());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("Name")) {
                        lDAPRealmMBeanImpl.setName(lDAPRealmMBeanImpl2.getName());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("Principal")) {
                        lDAPRealmMBeanImpl.setPrincipal(lDAPRealmMBeanImpl2.getPrincipal());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("RealmClassName")) {
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("SSLEnable")) {
                        lDAPRealmMBeanImpl.setSSLEnable(lDAPRealmMBeanImpl2.getSSLEnable());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("UserAuthentication")) {
                        lDAPRealmMBeanImpl.setUserAuthentication(lDAPRealmMBeanImpl2.getUserAuthentication());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("UserDN")) {
                        lDAPRealmMBeanImpl.setUserDN(lDAPRealmMBeanImpl2.getUserDN());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("UserNameAttribute")) {
                        lDAPRealmMBeanImpl.setUserNameAttribute(lDAPRealmMBeanImpl2.getUserNameAttribute());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("UserPasswordAttribute")) {
                        lDAPRealmMBeanImpl.setUserPasswordAttribute(lDAPRealmMBeanImpl2.getUserPasswordAttribute());
                        lDAPRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                LDAPRealmMBeanImpl lDAPRealmMBeanImpl = (LDAPRealmMBeanImpl)abstractDescriptorBean;
                super.finishCopy(lDAPRealmMBeanImpl, bl, list);
                if ((list == null || !list.contains("AuthProtocol")) && this.bean.isAuthProtocolSet()) {
                    lDAPRealmMBeanImpl.setAuthProtocol(this.bean.getAuthProtocol());
                }
                if ((list == null || !list.contains("CredentialEncrypted")) && this.bean.isCredentialEncryptedSet()) {
                    byte[] byArray = this.bean.getCredentialEncrypted();
                    lDAPRealmMBeanImpl.setCredentialEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("GroupDN")) && this.bean.isGroupDNSet()) {
                    lDAPRealmMBeanImpl.setGroupDN(this.bean.getGroupDN());
                }
                if ((list == null || !list.contains("GroupIsContext")) && this.bean.isGroupIsContextSet()) {
                    lDAPRealmMBeanImpl.setGroupIsContext(this.bean.getGroupIsContext());
                }
                if ((list == null || !list.contains("GroupNameAttribute")) && this.bean.isGroupNameAttributeSet()) {
                    lDAPRealmMBeanImpl.setGroupNameAttribute(this.bean.getGroupNameAttribute());
                }
                if ((list == null || !list.contains("GroupUsernameAttribute")) && this.bean.isGroupUsernameAttributeSet()) {
                    lDAPRealmMBeanImpl.setGroupUsernameAttribute(this.bean.getGroupUsernameAttribute());
                }
                if ((list == null || !list.contains("LDAPURL")) && this.bean.isLDAPURLSet()) {
                    lDAPRealmMBeanImpl.setLDAPURL(this.bean.getLDAPURL());
                }
                if ((list == null || !list.contains("LdapProvider")) && this.bean.isLdapProviderSet()) {
                    lDAPRealmMBeanImpl.setLdapProvider(this.bean.getLdapProvider());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    lDAPRealmMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Principal")) && this.bean.isPrincipalSet()) {
                    lDAPRealmMBeanImpl.setPrincipal(this.bean.getPrincipal());
                }
                if (list != null && list.contains("RealmClassName") || this.bean.isRealmClassNameSet()) {
                    // empty if block
                }
                if ((list == null || !list.contains("SSLEnable")) && this.bean.isSSLEnableSet()) {
                    lDAPRealmMBeanImpl.setSSLEnable(this.bean.getSSLEnable());
                }
                if ((list == null || !list.contains("UserAuthentication")) && this.bean.isUserAuthenticationSet()) {
                    lDAPRealmMBeanImpl.setUserAuthentication(this.bean.getUserAuthentication());
                }
                if ((list == null || !list.contains("UserDN")) && this.bean.isUserDNSet()) {
                    lDAPRealmMBeanImpl.setUserDN(this.bean.getUserDN());
                }
                if ((list == null || !list.contains("UserNameAttribute")) && this.bean.isUserNameAttributeSet()) {
                    lDAPRealmMBeanImpl.setUserNameAttribute(this.bean.getUserNameAttribute());
                }
                if ((list == null || !list.contains("UserPasswordAttribute")) && this.bean.isUserPasswordAttributeSet()) {
                    lDAPRealmMBeanImpl.setUserPasswordAttribute(this.bean.getUserPasswordAttribute());
                }
                return lDAPRealmMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

