/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.Arrays;
import javax.management.Attribute;
import javax.management.InvalidAttributeValueException;
import weblogic.utils.ArrayUtils;

public class LegalChecks {
    public static String checkLegalStringSet(Attribute attribute, String[] stringArray) throws InvalidAttributeValueException {
        String string = (String)attribute.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return stringArray[i];
        }
        throw new InvalidAttributeValueException(string + " is not a legal value for " + attribute.getName() + ".  " + "The value must be one of the following: " + Arrays.asList((Object[])stringArray));
    }

    public static void checkLegalIntSet(Attribute attribute, int[] nArray) throws InvalidAttributeValueException {
        int n = ((Number)attribute.getValue()).intValue();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return;
        }
        throw new InvalidAttributeValueException(n + " is not a legal value for " + attribute.getName() + ".  " + "The value must be one of the following: " + ArrayUtils.toString((int[])nArray));
    }

    public static void checkLegalRange(Attribute attribute, long l, long l2) throws InvalidAttributeValueException {
        long l3 = ((Number)attribute.getValue()).longValue();
        if (l3 < l || l3 > l2) {
            throw new InvalidAttributeValueException(l3 + " is not a legal value for " + attribute.getName() + ".  " + "It does not fall in the range [" + l + ", " + l2 + "]");
        }
    }

    public static void checkNonNull(Attribute attribute) throws InvalidAttributeValueException {
        if (attribute.getValue() == null) {
            throw new InvalidAttributeValueException("null is not a legal value for " + attribute.getName());
        }
    }

    public static void checkNonEmptyString(Attribute attribute) throws InvalidAttributeValueException {
        Object object = attribute.getValue();
        if (!(object instanceof String)) {
            throw new InvalidAttributeValueException("checkNonEmptyString called to check " + attribute.getName() + ", which is a " + object.getClass().getName());
        }
    }
}

