/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.logging.Loggable;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.security.SecurityLogger;

public class LegalHelper {
    public static boolean serverMBeanSetNameLegalCheck(String string, Object object) throws InvalidAttributeValueException {
        ServerMBean serverMBean = (ServerMBean)object;
        DomainMBean domainMBean = (DomainMBean)serverMBean.getParent();
        return domainMBean == null || domainMBean.getName() == null || !domainMBean.getName().equals(string);
    }

    static boolean exists(Set set, BooleanFun1Arg booleanFun1Arg) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!booleanFun1Arg.eval((WebLogicMBean)iterator.next())) continue;
            return true;
        }
        return false;
    }

    static boolean forall(Set set, BooleanFun1Arg booleanFun1Arg) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (booleanFun1Arg.eval((WebLogicMBean)iterator.next())) continue;
            return false;
        }
        return true;
    }

    static boolean in(final WebLogicMBean webLogicMBean, WebLogicMBean[] webLogicMBeanArray) {
        return LegalHelper.exists(new HashSet<Object>(Arrays.asList((Object[])webLogicMBeanArray)), new BooleanFun1Arg(){

            public boolean eval(WebLogicMBean webLogicMBean2) {
                return webLogicMBean2.getName().equals(webLogicMBean.getName());
            }
        });
    }

    static boolean subset(WebLogicMBean[] webLogicMBeanArray, final WebLogicMBean[] webLogicMBeanArray2) {
        return LegalHelper.forall(new HashSet<Object>(Arrays.asList((Object[])webLogicMBeanArray)), new BooleanFun1Arg(){

            public boolean eval(WebLogicMBean webLogicMBean) {
                return LegalHelper.in(webLogicMBean, webLogicMBeanArray2);
            }
        });
    }

    static final void validateListenPorts(ServerMBean serverMBean) {
        SSLMBean sSLMBean = serverMBean.getSSL();
        if (sSLMBean.isEnabled() && sSLMBean.getListenPort() == serverMBean.getListenPort()) {
            Loggable loggable = SecurityLogger.logSSLListenPortSameAsServerListenPortLoggable((String)(serverMBean.getListenPort() + ""));
            loggable.log();
            throw new IllegalArgumentException(loggable.getMessage());
        }
        if (serverMBean.isAdministrationPortEnabled() && sSLMBean.isEnabled() && sSLMBean.getListenPort() == serverMBean.getAdministrationPort()) {
            Loggable loggable = SecurityLogger.logSSLListenPortSameAsAdministrationPortLoggable((String)(sSLMBean.getListenPort() + ""));
            loggable.log();
            throw new IllegalArgumentException(loggable.getMessage());
        }
    }

    public static void validateJavaHome(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.indexOf(34) != -1) {
            throw new IllegalArgumentException("JavaHome may not contain '\"'");
        }
    }

    public static void validateClasspath(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.indexOf(34) != -1) {
            throw new IllegalArgumentException("Classpath may not contain '\"'");
        }
    }

    public static void validateBeaHome(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.indexOf(34) != -1) {
            throw new IllegalArgumentException("BeaHome may not contain '\"'");
        }
    }

    public static void validateRootDirectory(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.indexOf(34) != -1) {
            throw new IllegalArgumentException("RootDirectory may not contain '\"'");
        }
    }

    public static void validateSecurityPolicyFile(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.indexOf(34) != -1) {
            throw new IllegalArgumentException("SecurityPolicyFile may not contain '\"'");
        }
    }

    public static void validateIsSetIfTargetted(DeploymentMBean deploymentMBean, String string) throws IllegalArgumentException {
        TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
        if (targetMBeanArray != null && targetMBeanArray.length > 0) {
            Object object;
            try {
                object = deploymentMBean.getAttribute(string);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                object = null;
            }
            catch (ReflectionException reflectionException) {
                object = null;
            }
            catch (MBeanException mBeanException) {
                object = null;
            }
            if (object == null || object instanceof String && ((String)object).length() == 0) {
                throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getUnsetOnTargetted(deploymentMBean.getName(), string));
            }
        }
    }

    public static void validateNotNullable(String string, String string2) throws IllegalArgumentException {
        if (string2 != null && "".equals(string2.trim())) {
            throw new IllegalArgumentException("value may not be unset.");
        }
        if (string2 == null && string != null) {
            throw new IllegalArgumentException("value may not be set to empty string.");
        }
    }

    public static String checkClassName(String string) {
        String string2 = string;
        if (string2 != null && string2.endsWith(".class")) {
            int n = string2.length();
            string2 = string2.substring(0, n - 6);
        }
        return string2;
    }

    public static void validateArguments(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.indexOf(34) != -1 && !Boolean.getBoolean("weblogic.serverStart.allowQuotes")) {
            throw new IllegalArgumentException("Arguments may not contain '\"'");
        }
    }

    public static boolean versionEarlierThan(String string, String string2) throws IllegalArgumentException {
        if (string == null || string2 == null) {
            return false;
        }
        VersionInfo versionInfo = new VersionInfo(string);
        VersionInfo versionInfo2 = new VersionInfo(string2);
        return versionInfo.earlierThan((PackageInfo)versionInfo2);
    }

    static interface BooleanFun1Arg {
        public boolean eval(WebLogicMBean var1);
    }
}

