/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import com.bea.logging.DateFormatter;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.LogFileMBean;
import weblogic.management.configuration.LoggingLegalHelper;
import weblogic.management.mbeans.custom.LogFile;
import weblogic.utils.collections.CombinedIterator;

public class LogFileMBeanImpl
extends ConfigurationMBeanImpl
implements LogFileMBean,
Serializable {
    private int _BufferSizeKB;
    private String _DateFormatPattern;
    private int _FileCount;
    private int _FileMinSize;
    private String _FileName;
    private int _FileTimeSpan;
    private long _FileTimeSpanFactor;
    private String _LogFileRotationDir;
    private String _Name;
    private boolean _NumberOfFilesLimited;
    private OutputStream _OutputStream;
    private boolean _RotateLogOnStartup;
    private String _RotationTime;
    private String _RotationType;
    private LogFile _customizer;
    private static SchemaHelper2 _schemaHelper;

    public LogFileMBeanImpl() {
        try {
            this._customizer = new LogFile(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public LogFileMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new LogFile(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getDateFormatPattern() {
        if (!this._isSet(7)) {
            try {
                return DateFormatter.getDefaultDateFormatPattern();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._DateFormatPattern;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isDateFormatPatternSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setDateFormatPattern(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"DateFormatPattern", (String)string);
        LegalChecks.checkNonNull((String)"DateFormatPattern", (Object)string);
        DateFormatter.validateDateFormatPattern((String)string);
        String string2 = this._DateFormatPattern;
        this._DateFormatPattern = string;
        this._postSet(7, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public String getFileName() {
        if (!this._isSet(8)) {
            try {
                return "logs/" + this.getName() + ".log";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._FileName;
    }

    public boolean isFileNameSet() {
        return this._isSet(8);
    }

    public void setFileName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._FileName;
        this._FileName = string;
        this._postSet(8, string2, string);
    }

    public String getRotationType() {
        return this._RotationType;
    }

    public boolean isRotationTypeSet() {
        return this._isSet(9);
    }

    public void setRotationType(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"bySize", "byTime", "none"};
        string = LegalChecks.checkInEnum((String)"RotationType", (String)string, (String[])stringArray);
        String string2 = this._RotationType;
        this._RotationType = string;
        this._postSet(9, string2, string);
    }

    public void setNumberOfFilesLimited(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._NumberOfFilesLimited;
        this._NumberOfFilesLimited = bl;
        this._postSet(10, bl2, bl);
    }

    public boolean isNumberOfFilesLimited() {
        if (!this._isSet(10)) {
            return !this._isProductionModeEnabled();
        }
        return this._NumberOfFilesLimited;
    }

    public boolean isNumberOfFilesLimitedSet() {
        return this._isSet(10);
    }

    public int getFileCount() {
        return this._FileCount;
    }

    public boolean isFileCountSet() {
        return this._isSet(11);
    }

    public void setFileCount(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"FileCount", (long)n, (long)1L, (long)99999L);
        int n2 = this._FileCount;
        this._FileCount = n;
        this._postSet(11, n2, n);
    }

    public int getFileTimeSpan() {
        return this._FileTimeSpan;
    }

    public boolean isFileTimeSpanSet() {
        return this._isSet(12);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public String getRotationTime() {
        return this._RotationTime;
    }

    public boolean isRotationTimeSet() {
        return this._isSet(13);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setRotationTime(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LoggingLegalHelper.validateLogTimeString(string);
        String string2 = this._RotationTime;
        this._RotationTime = string;
        this._postSet(13, string2, string);
    }

    public void setFileTimeSpan(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"FileTimeSpan", (int)n, (int)1);
        int n2 = this._FileTimeSpan;
        this._FileTimeSpan = n;
        this._postSet(12, n2, n);
    }

    public long getFileTimeSpanFactor() {
        return this._FileTimeSpanFactor;
    }

    public boolean isFileTimeSpanFactorSet() {
        return this._isSet(14);
    }

    public void setFileTimeSpanFactor(long l) {
        long l2 = this._FileTimeSpanFactor;
        this._FileTimeSpanFactor = l;
        this._postSet(14, l2, l);
    }

    public int getFileMinSize() {
        if (!this._isSet(15)) {
            return this._isProductionModeEnabled() ? 5000 : 500;
        }
        return this._FileMinSize;
    }

    public boolean isFileMinSizeSet() {
        return this._isSet(15);
    }

    public void setFileMinSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"FileMinSize", (long)n, (long)1L, (long)65535L);
        int n2 = this._FileMinSize;
        this._FileMinSize = n;
        this._postSet(15, n2, n);
    }

    public boolean getRotateLogOnStartup() {
        if (!this._isSet(16)) {
            return !this._isProductionModeEnabled();
        }
        return this._RotateLogOnStartup;
    }

    public boolean isRotateLogOnStartupSet() {
        return this._isSet(16);
    }

    public void setRotateLogOnStartup(boolean bl) {
        boolean bl2 = this._RotateLogOnStartup;
        this._RotateLogOnStartup = bl;
        this._postSet(16, bl2, bl);
    }

    public String getLogFileRotationDir() {
        return this._LogFileRotationDir;
    }

    public boolean isLogFileRotationDirSet() {
        return this._isSet(17);
    }

    public void setLogFileRotationDir(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._LogFileRotationDir;
        this._LogFileRotationDir = string;
        this._postSet(17, string2, string);
    }

    public String computeLogFilePath() {
        return this._customizer.computeLogFilePath();
    }

    public OutputStream getOutputStream() {
        return this._OutputStream;
    }

    public boolean isOutputStreamSet() {
        return this._isSet(18);
    }

    public void setOutputStream(OutputStream outputStream) {
        this._OutputStream = outputStream;
    }

    public int getBufferSizeKB() {
        return this._BufferSizeKB;
    }

    public boolean isBufferSizeKBSet() {
        return this._isSet(19);
    }

    public void setBufferSizeKB(int n) {
        int n2 = this._BufferSizeKB;
        this._BufferSizeKB = n;
        this._postSet(19, n2, n);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 19;
        }
        try {
            switch (n) {
                case 19: {
                    this._BufferSizeKB = 8;
                    if (bl) break;
                }
                case 7: {
                    this._DateFormatPattern = null;
                    if (bl) break;
                }
                case 11: {
                    this._FileCount = 7;
                    if (bl) break;
                }
                case 15: {
                    this._FileMinSize = 500;
                    if (bl) break;
                }
                case 8: {
                    this._FileName = null;
                    if (bl) break;
                }
                case 12: {
                    this._FileTimeSpan = 24;
                    if (bl) break;
                }
                case 14: {
                    this._FileTimeSpanFactor = 3600000L;
                    if (bl) break;
                }
                case 17: {
                    this._LogFileRotationDir = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 18: {
                    this._OutputStream = null;
                    if (bl) break;
                }
                case 16: {
                    this._RotateLogOnStartup = true;
                    if (bl) break;
                }
                case 13: {
                    this._RotationTime = "00:00";
                    if (bl) break;
                }
                case 9: {
                    this._RotationType = "bySize";
                    if (bl) break;
                }
                case 10: {
                    this._NumberOfFilesLimited = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "LogFile";
    }

    public void putValue(String string, Object object) {
        if (string.equals("BufferSizeKB")) {
            int n = this._BufferSizeKB;
            this._BufferSizeKB = (Integer)object;
            this._postSet(19, n, this._BufferSizeKB);
            return;
        }
        if (string.equals("DateFormatPattern")) {
            String string2 = this._DateFormatPattern;
            this._DateFormatPattern = (String)object;
            this._postSet(7, string2, this._DateFormatPattern);
            return;
        }
        if (string.equals("FileCount")) {
            int n = this._FileCount;
            this._FileCount = (Integer)object;
            this._postSet(11, n, this._FileCount);
            return;
        }
        if (string.equals("FileMinSize")) {
            int n = this._FileMinSize;
            this._FileMinSize = (Integer)object;
            this._postSet(15, n, this._FileMinSize);
            return;
        }
        if (string.equals("FileName")) {
            String string3 = this._FileName;
            this._FileName = (String)object;
            this._postSet(8, string3, this._FileName);
            return;
        }
        if (string.equals("FileTimeSpan")) {
            int n = this._FileTimeSpan;
            this._FileTimeSpan = (Integer)object;
            this._postSet(12, n, this._FileTimeSpan);
            return;
        }
        if (string.equals("FileTimeSpanFactor")) {
            long l = this._FileTimeSpanFactor;
            this._FileTimeSpanFactor = (Long)object;
            this._postSet(14, l, this._FileTimeSpanFactor);
            return;
        }
        if (string.equals("LogFileRotationDir")) {
            String string4 = this._LogFileRotationDir;
            this._LogFileRotationDir = (String)object;
            this._postSet(17, string4, this._LogFileRotationDir);
            return;
        }
        if (string.equals("Name")) {
            String string5 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string5, this._Name);
            return;
        }
        if (string.equals("NumberOfFilesLimited")) {
            boolean bl = this._NumberOfFilesLimited;
            this._NumberOfFilesLimited = (Boolean)object;
            this._postSet(10, bl, this._NumberOfFilesLimited);
            return;
        }
        if (string.equals("OutputStream")) {
            OutputStream outputStream = this._OutputStream;
            this._OutputStream = (OutputStream)object;
            this._postSet(18, outputStream, this._OutputStream);
            return;
        }
        if (string.equals("RotateLogOnStartup")) {
            boolean bl = this._RotateLogOnStartup;
            this._RotateLogOnStartup = (Boolean)object;
            this._postSet(16, bl, this._RotateLogOnStartup);
            return;
        }
        if (string.equals("RotationTime")) {
            String string6 = this._RotationTime;
            this._RotationTime = (String)object;
            this._postSet(13, string6, this._RotationTime);
            return;
        }
        if (string.equals("RotationType")) {
            String string7 = this._RotationType;
            this._RotationType = (String)object;
            this._postSet(9, string7, this._RotationType);
            return;
        }
        if (string.equals("customizer")) {
            LogFile logFile = this._customizer;
            this._customizer = (LogFile)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("BufferSizeKB")) {
            return new Integer(this._BufferSizeKB);
        }
        if (string.equals("DateFormatPattern")) {
            return this._DateFormatPattern;
        }
        if (string.equals("FileCount")) {
            return new Integer(this._FileCount);
        }
        if (string.equals("FileMinSize")) {
            return new Integer(this._FileMinSize);
        }
        if (string.equals("FileName")) {
            return this._FileName;
        }
        if (string.equals("FileTimeSpan")) {
            return new Integer(this._FileTimeSpan);
        }
        if (string.equals("FileTimeSpanFactor")) {
            return new Long(this._FileTimeSpanFactor);
        }
        if (string.equals("LogFileRotationDir")) {
            return this._LogFileRotationDir;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NumberOfFilesLimited")) {
            return new Boolean(this._NumberOfFilesLimited);
        }
        if (string.equals("OutputStream")) {
            return this._OutputStream;
        }
        if (string.equals("RotateLogOnStartup")) {
            return new Boolean(this._RotateLogOnStartup);
        }
        if (string.equals("RotationTime")) {
            return this._RotationTime;
        }
        if (string.equals("RotationType")) {
            return this._RotationType;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (string.equals("buffer-sizekb")) {
                        return 19;
                    }
                    if (string.equals("file-min-size")) {
                        return 15;
                    }
                    if (string.equals("output-stream")) {
                        return 18;
                    }
                    if (string.equals("rotation-time")) {
                        return 13;
                    }
                    if (!string.equals("rotation-type")) break;
                    return 9;
                }
                case 19: {
                    if (!string.equals("date-format-pattern")) break;
                    return 7;
                }
                case 10: {
                    if (!string.equals("file-count")) break;
                    return 11;
                }
                case 9: {
                    if (!string.equals("file-name")) break;
                    return 8;
                }
                case 14: {
                    if (!string.equals("file-time-span")) break;
                    return 12;
                }
                case 21: {
                    if (string.equals("file-time-span-factor")) {
                        return 14;
                    }
                    if (string.equals("log-file-rotation-dir")) {
                        return 17;
                    }
                    if (!string.equals("rotate-log-on-startup")) break;
                    return 16;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 23: {
                    if (!string.equals("number-of-files-limited")) break;
                    return 10;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 19: {
                    return "buffer-sizekb";
                }
                case 7: {
                    return "date-format-pattern";
                }
                case 11: {
                    return "file-count";
                }
                case 15: {
                    return "file-min-size";
                }
                case 8: {
                    return "file-name";
                }
                case 12: {
                    return "file-time-span";
                }
                case 14: {
                    return "file-time-span-factor";
                }
                case 17: {
                    return "log-file-rotation-dir";
                }
                case 2: {
                    return "name";
                }
                case 18: {
                    return "output-stream";
                }
                case 16: {
                    return "rotate-log-on-startup";
                }
                case 13: {
                    return "rotation-time";
                }
                case 9: {
                    return "rotation-type";
                }
                case 10: {
                    return "number-of-files-limited";
                }
            }
            return super.getElementName(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 15: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 13: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private LogFileMBeanImpl bean;

        protected Helper(LogFileMBeanImpl logFileMBeanImpl) {
            super(logFileMBeanImpl);
            this.bean = logFileMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 19: {
                    return "BufferSizeKB";
                }
                case 7: {
                    return "DateFormatPattern";
                }
                case 11: {
                    return "FileCount";
                }
                case 15: {
                    return "FileMinSize";
                }
                case 8: {
                    return "FileName";
                }
                case 12: {
                    return "FileTimeSpan";
                }
                case 14: {
                    return "FileTimeSpanFactor";
                }
                case 17: {
                    return "LogFileRotationDir";
                }
                case 2: {
                    return "Name";
                }
                case 18: {
                    return "OutputStream";
                }
                case 16: {
                    return "RotateLogOnStartup";
                }
                case 13: {
                    return "RotationTime";
                }
                case 9: {
                    return "RotationType";
                }
                case 10: {
                    return "NumberOfFilesLimited";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BufferSizeKB")) {
                return 19;
            }
            if (string.equals("DateFormatPattern")) {
                return 7;
            }
            if (string.equals("FileCount")) {
                return 11;
            }
            if (string.equals("FileMinSize")) {
                return 15;
            }
            if (string.equals("FileName")) {
                return 8;
            }
            if (string.equals("FileTimeSpan")) {
                return 12;
            }
            if (string.equals("FileTimeSpanFactor")) {
                return 14;
            }
            if (string.equals("LogFileRotationDir")) {
                return 17;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("OutputStream")) {
                return 18;
            }
            if (string.equals("RotateLogOnStartup")) {
                return 16;
            }
            if (string.equals("RotationTime")) {
                return 13;
            }
            if (string.equals("RotationType")) {
                return 9;
            }
            if (string.equals("NumberOfFilesLimited")) {
                return 10;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBufferSizeKBSet()) {
                    stringBuffer.append("BufferSizeKB");
                    stringBuffer.append(String.valueOf(this.bean.getBufferSizeKB()));
                }
                if (this.bean.isDateFormatPatternSet()) {
                    stringBuffer.append("DateFormatPattern");
                    stringBuffer.append(String.valueOf(this.bean.getDateFormatPattern()));
                }
                if (this.bean.isFileCountSet()) {
                    stringBuffer.append("FileCount");
                    stringBuffer.append(String.valueOf(this.bean.getFileCount()));
                }
                if (this.bean.isFileMinSizeSet()) {
                    stringBuffer.append("FileMinSize");
                    stringBuffer.append(String.valueOf(this.bean.getFileMinSize()));
                }
                if (this.bean.isFileNameSet()) {
                    stringBuffer.append("FileName");
                    stringBuffer.append(String.valueOf(this.bean.getFileName()));
                }
                if (this.bean.isFileTimeSpanSet()) {
                    stringBuffer.append("FileTimeSpan");
                    stringBuffer.append(String.valueOf(this.bean.getFileTimeSpan()));
                }
                if (this.bean.isFileTimeSpanFactorSet()) {
                    stringBuffer.append("FileTimeSpanFactor");
                    stringBuffer.append(String.valueOf(this.bean.getFileTimeSpanFactor()));
                }
                if (this.bean.isLogFileRotationDirSet()) {
                    stringBuffer.append("LogFileRotationDir");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileRotationDir()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isOutputStreamSet()) {
                    stringBuffer.append("OutputStream");
                    stringBuffer.append(String.valueOf(this.bean.getOutputStream()));
                }
                if (this.bean.isRotateLogOnStartupSet()) {
                    stringBuffer.append("RotateLogOnStartup");
                    stringBuffer.append(String.valueOf(this.bean.getRotateLogOnStartup()));
                }
                if (this.bean.isRotationTimeSet()) {
                    stringBuffer.append("RotationTime");
                    stringBuffer.append(String.valueOf(this.bean.getRotationTime()));
                }
                if (this.bean.isRotationTypeSet()) {
                    stringBuffer.append("RotationType");
                    stringBuffer.append(String.valueOf(this.bean.getRotationType()));
                }
                if (this.bean.isNumberOfFilesLimitedSet()) {
                    stringBuffer.append("NumberOfFilesLimited");
                    stringBuffer.append(String.valueOf(this.bean.isNumberOfFilesLimited()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                LogFileMBeanImpl logFileMBeanImpl = (LogFileMBeanImpl)abstractDescriptorBean;
                this.computeDiff("BufferSizeKB", this.bean.getBufferSizeKB(), logFileMBeanImpl.getBufferSizeKB(), false);
                this.computeDiff("DateFormatPattern", this.bean.getDateFormatPattern(), logFileMBeanImpl.getDateFormatPattern(), false);
                this.computeDiff("FileCount", this.bean.getFileCount(), logFileMBeanImpl.getFileCount(), true);
                this.computeDiff("FileMinSize", this.bean.getFileMinSize(), logFileMBeanImpl.getFileMinSize(), true);
                this.computeDiff("FileName", this.bean.getFileName(), logFileMBeanImpl.getFileName(), false);
                this.computeDiff("FileTimeSpan", this.bean.getFileTimeSpan(), logFileMBeanImpl.getFileTimeSpan(), true);
                this.computeDiff("FileTimeSpanFactor", this.bean.getFileTimeSpanFactor(), logFileMBeanImpl.getFileTimeSpanFactor(), false);
                this.computeDiff("LogFileRotationDir", this.bean.getLogFileRotationDir(), logFileMBeanImpl.getLogFileRotationDir(), false);
                this.computeDiff("Name", this.bean.getName(), logFileMBeanImpl.getName(), false);
                this.computeDiff("RotateLogOnStartup", this.bean.getRotateLogOnStartup(), logFileMBeanImpl.getRotateLogOnStartup(), false);
                this.computeDiff("RotationTime", this.bean.getRotationTime(), logFileMBeanImpl.getRotationTime(), true);
                this.computeDiff("RotationType", this.bean.getRotationType(), logFileMBeanImpl.getRotationType(), false);
                this.computeDiff("NumberOfFilesLimited", this.bean.isNumberOfFilesLimited(), logFileMBeanImpl.isNumberOfFilesLimited(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                LogFileMBeanImpl logFileMBeanImpl = (LogFileMBeanImpl)beanUpdateEvent.getSourceBean();
                LogFileMBeanImpl logFileMBeanImpl2 = (LogFileMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BufferSizeKB")) {
                    logFileMBeanImpl.setBufferSizeKB(logFileMBeanImpl2.getBufferSizeKB());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("DateFormatPattern")) {
                    logFileMBeanImpl.setDateFormatPattern(logFileMBeanImpl2.getDateFormatPattern());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("FileCount")) {
                    logFileMBeanImpl.setFileCount(logFileMBeanImpl2.getFileCount());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("FileMinSize")) {
                    logFileMBeanImpl.setFileMinSize(logFileMBeanImpl2.getFileMinSize());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("FileName")) {
                    logFileMBeanImpl.setFileName(logFileMBeanImpl2.getFileName());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("FileTimeSpan")) {
                    logFileMBeanImpl.setFileTimeSpan(logFileMBeanImpl2.getFileTimeSpan());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("FileTimeSpanFactor")) {
                    logFileMBeanImpl.setFileTimeSpanFactor(logFileMBeanImpl2.getFileTimeSpanFactor());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("LogFileRotationDir")) {
                    logFileMBeanImpl.setLogFileRotationDir(logFileMBeanImpl2.getLogFileRotationDir());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("Name")) {
                    logFileMBeanImpl.setName(logFileMBeanImpl2.getName());
                    logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (!string.equals("OutputStream")) {
                    if (string.equals("RotateLogOnStartup")) {
                        logFileMBeanImpl.setRotateLogOnStartup(logFileMBeanImpl2.getRotateLogOnStartup());
                        logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("RotationTime")) {
                        logFileMBeanImpl.setRotationTime(logFileMBeanImpl2.getRotationTime());
                        logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("RotationType")) {
                        logFileMBeanImpl.setRotationType(logFileMBeanImpl2.getRotationType());
                        logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("NumberOfFilesLimited")) {
                        logFileMBeanImpl.setNumberOfFilesLimited(logFileMBeanImpl2.isNumberOfFilesLimited());
                        logFileMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                LogFileMBeanImpl logFileMBeanImpl = (LogFileMBeanImpl)abstractDescriptorBean;
                super.finishCopy(logFileMBeanImpl, bl, list);
                if ((list == null || !list.contains("BufferSizeKB")) && this.bean.isBufferSizeKBSet()) {
                    logFileMBeanImpl.setBufferSizeKB(this.bean.getBufferSizeKB());
                }
                if ((list == null || !list.contains("DateFormatPattern")) && this.bean.isDateFormatPatternSet()) {
                    logFileMBeanImpl.setDateFormatPattern(this.bean.getDateFormatPattern());
                }
                if ((list == null || !list.contains("FileCount")) && this.bean.isFileCountSet()) {
                    logFileMBeanImpl.setFileCount(this.bean.getFileCount());
                }
                if ((list == null || !list.contains("FileMinSize")) && this.bean.isFileMinSizeSet()) {
                    logFileMBeanImpl.setFileMinSize(this.bean.getFileMinSize());
                }
                if ((list == null || !list.contains("FileName")) && this.bean.isFileNameSet()) {
                    logFileMBeanImpl.setFileName(this.bean.getFileName());
                }
                if ((list == null || !list.contains("FileTimeSpan")) && this.bean.isFileTimeSpanSet()) {
                    logFileMBeanImpl.setFileTimeSpan(this.bean.getFileTimeSpan());
                }
                if ((list == null || !list.contains("FileTimeSpanFactor")) && this.bean.isFileTimeSpanFactorSet()) {
                    logFileMBeanImpl.setFileTimeSpanFactor(this.bean.getFileTimeSpanFactor());
                }
                if ((list == null || !list.contains("LogFileRotationDir")) && this.bean.isLogFileRotationDirSet()) {
                    logFileMBeanImpl.setLogFileRotationDir(this.bean.getLogFileRotationDir());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    logFileMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("RotateLogOnStartup")) && this.bean.isRotateLogOnStartupSet()) {
                    logFileMBeanImpl.setRotateLogOnStartup(this.bean.getRotateLogOnStartup());
                }
                if ((list == null || !list.contains("RotationTime")) && this.bean.isRotationTimeSet()) {
                    logFileMBeanImpl.setRotationTime(this.bean.getRotationTime());
                }
                if ((list == null || !list.contains("RotationType")) && this.bean.isRotationTypeSet()) {
                    logFileMBeanImpl.setRotationType(this.bean.getRotationType());
                }
                if ((list == null || !list.contains("NumberOfFilesLimited")) && this.bean.isNumberOfFilesLimitedSet()) {
                    logFileMBeanImpl.setNumberOfFilesLimited(this.bean.isNumberOfFilesLimited());
                }
                return logFileMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

