/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.configuration.ConfigurationMBeanImplBeanInfo;
import weblogic.management.configuration.LogFileMBean;
import weblogic.management.configuration.LogFileMBeanImpl;
import weblogic.management.internal.mbean.BeanInfoHelper;

public class LogFileMBeanImplBeanInfo
extends ConfigurationMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = LogFileMBean.class;

    public LogFileMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public LogFileMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = LogFileMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.management.configuration");
        String string = new String("Configures the location, file-rotation criteria, and number of files that a WebLogic Server uses to store log messages. The methods in this class configure both server and domain log files.  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime. For more information, see \"Developing Manageable Applications with JMX.\"</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.configuration.LogFileMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("BufferSizeKB")) {
            string2 = "getBufferSizeKB";
            string = null;
            if (!this.readOnly) {
                string = "setBufferSizeKB";
            }
            propertyDescriptor = new PropertyDescriptor("BufferSizeKB", LogFileMBean.class, string2, string);
            map.put("BufferSizeKB", propertyDescriptor);
            propertyDescriptor.setValue("description", "Gets the underlying log buffer size in kilobytes ");
            LogFileMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(8));
        }
        if (!map.containsKey("DateFormatPattern")) {
            string2 = "getDateFormatPattern";
            string = null;
            if (!this.readOnly) {
                string = "setDateFormatPattern";
            }
            propertyDescriptor = new PropertyDescriptor("DateFormatPattern", LogFileMBean.class, string2, string);
            map.put("DateFormatPattern", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The date format pattern used for rendering dates in the  log. The DateFormatPattern string conforms to the specification of the <code>java.text.SimpleDateFormat</code> class.</p> ");
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("FileCount")) {
            string2 = "getFileCount";
            string = null;
            if (!this.readOnly) {
                string = "setFileCount";
            }
            propertyDescriptor = new PropertyDescriptor("FileCount", LogFileMBean.class, string2, string);
            map.put("FileCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of log files that the server creates when it rotates the log. This number does not include the file that the server uses to store current messages. (Requires that you enable Number of Files Limited.)</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isNumberOfFilesLimited")};
            propertyDescriptor.setValue("see", stringArray);
            LogFileMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(7));
            propertyDescriptor.setValue("legalMax", new Integer(99999));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("FileMinSize")) {
            string2 = "getFileMinSize";
            string = null;
            if (!this.readOnly) {
                string = "setFileMinSize";
            }
            propertyDescriptor = new PropertyDescriptor("FileMinSize", LogFileMBean.class, string2, string);
            map.put("FileMinSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "The size (1 - 65535 kilobytes) that triggers the server to move log messages to a separate file. The default is 500 kilobytes. After the log file reaches the specified minimum size, the next time the server checks the file size, it will rename the current log file as <code><i>SERVER_NAME</i>.log<i>nnnnn</i></code> and create a new one to store subsequent messages. (Requires that you specify a file rotation type of <code>Size</code>.) ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getRotationType")};
            propertyDescriptor.setValue("see", stringArray);
            LogFileMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(500));
            propertyDescriptor.setValue("legalMax", new Integer(65535));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("FileName")) {
            string2 = "getFileName";
            string = null;
            if (!this.readOnly) {
                string = "setFileName";
            }
            propertyDescriptor = new PropertyDescriptor("FileName", LogFileMBean.class, string2, string);
            map.put("FileName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the file that stores current log messages. Usually it is a computed value based on the name of the parent of this MBean. For example, for a server log, it is <code><i>SERVER_NAME</i>.log</code>.</p> <p> However, if the name of the parent cannot be obtained, the file name is <code>weblogic.log</code>. If you specify a relative pathname, it is interpreted as relative to the server's root directory.</p>  <p>To include a time and date stamp in the file name when the log file is rotated, add <code>java.text.SimpleDateFormat</code> variables to the file name. Surround each variable with percentage (<code>%</code>) characters.</p>  <p>For example, if the file name is defined to be <code>myserver_%yyyy%_%MM%_%dd%_%hh%_%mm%.log</code>, the log file will be named <code>myserver_yyyy_mm_dd_hh_mm.log</code>.</p>  <p>When the log file is rotated, the rotated file name contains the date stamp. For example, if the log file is rotated for the first time on 2 April, 2003 at 10:05 AM, the log file that contains the old messages will be named <code>myserver_2003_04_02_10_05.log00001</code>.</p>  <p>If you do not include a time and date stamp, the rotated log files are numbered in order of creation. For example, <code>myserver.log00007</code>.</p> ");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("FileTimeSpan")) {
            string2 = "getFileTimeSpan";
            string = null;
            if (!this.readOnly) {
                string = "setFileTimeSpan";
            }
            propertyDescriptor = new PropertyDescriptor("FileTimeSpan", LogFileMBean.class, string2, string);
            map.put("FileTimeSpan", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The interval (in hours) at which the server saves old log messages to another file. (Requires that you specify a file rotation type of <code>TIME</code>.)</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getRotationType")};
            propertyDescriptor.setValue("see", stringArray);
            LogFileMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(24));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("LogFileRotationDir")) {
            string2 = "getLogFileRotationDir";
            string = null;
            if (!this.readOnly) {
                string = "setLogFileRotationDir";
            }
            propertyDescriptor = new PropertyDescriptor("LogFileRotationDir", LogFileMBean.class, string2, string);
            map.put("LogFileRotationDir", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The directory where the rotated log files will be stored. By default the rotated files are stored in the same directory where the log file is stored.</p> ");
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            if (!this.readOnly) {
                string = "setName";
            }
            propertyDescriptor = new PropertyDescriptor("Name", LogFileMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The user-specified name of this MBean instance.</p>  <p>This name is included as one of the key properties in the MBean's <code>javax.management.ObjectName</code>:<br clear=\"none\" /> <code>Name=<i>user-specified-name</i></code></p> ");
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("key", Boolean.TRUE);
        }
        if (!map.containsKey("RotateLogOnStartup")) {
            string2 = "getRotateLogOnStartup";
            string = null;
            if (!this.readOnly) {
                string = "setRotateLogOnStartup";
            }
            propertyDescriptor = new PropertyDescriptor("RotateLogOnStartup", LogFileMBean.class, string2, string);
            map.put("RotateLogOnStartup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether a server rotates its log file during its startup cycle. The default value in production mode is false.</p> ");
            LogFileMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
        }
        if (!map.containsKey("RotationTime")) {
            string2 = "getRotationTime";
            string = null;
            if (!this.readOnly) {
                string = "setRotationTime";
            }
            propertyDescriptor = new PropertyDescriptor("RotationTime", LogFileMBean.class, string2, string);
            map.put("RotationTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Determines the start time (hour and minute) for a time-based rotation sequence.  <p>At the time that this value specifies, the server renames the current log file. Thereafter, the server renames the log file at an interval that you specify in File Time Span.</p>  <p>Note that WebLogic Server sets a threshold size limit of 500 MB before it forces a hard rotation to prevent excessive log file growth.</p>  <p> Use the following format: <code>H:mm</code>, where <ul><li><code>H</code> is Hour in day (0-23). <li><code>mm</code> is the minute in hour </ul> <p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getRotationType"), BeanInfoHelper.encodeEntities((String)"#getFileTimeSpan")};
            propertyDescriptor.setValue("see", stringArray);
            LogFileMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"00:00");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("RotationType")) {
            string2 = "getRotationType";
            string = null;
            if (!this.readOnly) {
                string = "setRotationType";
            }
            propertyDescriptor = new PropertyDescriptor("RotationType", LogFileMBean.class, string2, string);
            map.put("RotationType", propertyDescriptor);
            propertyDescriptor.setValue("description", "Criteria for moving old log messages to a separate file. <ul> <li><code>NONE</code> Messages accumulate in a single file. You must erase the contents of the file when the size is too large. Note that WebLogic Server sets a threshold size limit of 500 MB before it forces a hard rotation to prevent excessive log file growth.  <li><code>SIZE</code> When the log file reaches the size that you specify in <code>FileMinSize</code>, the server renames the file as <code><i>SERVER_NAME</i>.log<i>nnnnn</i></code>.  <li><code>TIME</code> At each time interval that you specify in <code>TimeSpan</code>, the server renames the file as <code><i>SERVER_NAME</i>.log<i>nnnnn</i></code>. </ul>  <p>After the server renames a file, subsequent messages accumulate in a new file with the name that you specified as the log file name.</p> ");
            LogFileMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"bySize");
            propertyDescriptor.setValue("secureValue", "byTime");
            propertyDescriptor.setValue("legalValues", new Object[]{"bySize", "byTime", "none"});
        }
        if (!map.containsKey("NumberOfFilesLimited")) {
            string2 = "isNumberOfFilesLimited";
            string = null;
            if (!this.readOnly) {
                string = "setNumberOfFilesLimited";
            }
            propertyDescriptor = new PropertyDescriptor("NumberOfFilesLimited", LogFileMBean.class, string2, string);
            map.put("NumberOfFilesLimited", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether to limit the number of log files that this server instance creates to store old messages. (Requires that you specify a file rotation type of <code>SIZE</code> or <code>TIME</code>.)</p>  <p>After the server reaches this limit, it deletes the oldest log file and creates a new log file with the latest suffix.</p>  <p>If you do not enable this option, the server creates new files indefinitely and you must clean up these files as you require.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getRotationType")};
            propertyDescriptor.setValue("see", stringArray);
            LogFileMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = LogFileMBean.class.getMethod("freezeCurrentValue", String.class);
        Object object = new ParameterDescriptor[]{LogFileMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has not been set explicitly, and if the attribute has a default value, this operation forces the MBean to persist the default value.</p>  <p>Unless you use this operation, the default value is not saved and is subject to change if you update to a newer release of WebLogic Server. Invoking this operation isolates this MBean from the effects of such changes.</p>  <dl> <dt>Note:</dt>  <dd> <p>To insure that you are freezing the default value, invoke the <code>restoreDefaultValue</code> operation before you invoke this.</p> </dd> </dl>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute for which some other value has been set.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = LogFileMBean.class.getMethod("restoreDefaultValue", String.class);
        object = new ParameterDescriptor[]{LogFileMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string) && !this.readOnly) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has a default value, this operation removes any value that has been set explicitly and causes the attribute to use the default value.</p>  <p>Default values are subject to change if you update to a newer release of WebLogic Server. To prevent the value from changing if you update to a newer release, invoke the <code>freezeCurrentValue</code> operation.</p>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute that is already using the default.</p> ");
            methodDescriptor.setValue("role", "operation");
            methodDescriptor.setValue("impact", "action");
        }
        if (!map.containsKey(object = BeanInfoHelper.buildMethodKey((Method)(method = LogFileMBean.class.getMethod("computeLogFilePath", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "This method computes the log file path based on the defaults and server directory if the FileName attribute is defaulted. ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

