/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.diagnostics.query.Query;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.mbeans.custom.LogFilter;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class LogFilterMBeanImpl
extends ConfigurationMBeanImpl
implements LogFilterMBean,
Serializable {
    private String _FilterExpression;
    private String _Name;
    private Query _Query;
    private int _SeverityLevel;
    private String[] _SubsystemNames;
    private String[] _UserIds;
    private LogFilter _customizer;
    private static SchemaHelper2 _schemaHelper;

    public LogFilterMBeanImpl() {
        try {
            this._customizer = new LogFilter(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public LogFilterMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new LogFilter(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public int getSeverityLevel() {
        return this._customizer.getSeverityLevel();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isSeverityLevelSet() {
        return this._isSet(7);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setSeverityLevel(int n) {
        int[] nArray = new int[]{64, 16, 8, 32, 4, 2, 1};
        n = LegalChecks.checkInEnum((String)"SeverityLevel", (int)n, (int[])nArray);
        int n2 = this.getSeverityLevel();
        this._customizer.setSeverityLevel(n);
        this._postSet(7, n2, n);
    }

    public String[] getSubsystemNames() {
        return this._customizer.getSubsystemNames();
    }

    public boolean isSubsystemNamesSet() {
        return this._isSet(8);
    }

    public void setSubsystemNames(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this.getSubsystemNames();
        try {
            this._customizer.setSubsystemNames(stringArray);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(8, stringArray2, stringArray);
    }

    public String[] getUserIds() {
        return this._customizer.getUserIds();
    }

    public boolean isUserIdsSet() {
        return this._isSet(9);
    }

    public void setUserIds(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this.getUserIds();
        try {
            this._customizer.setUserIds(stringArray);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(9, stringArray2, stringArray);
    }

    public String getFilterExpression() {
        return this._customizer.getFilterExpression();
    }

    public boolean isFilterExpressionSet() {
        return this._isSet(10);
    }

    public void setFilterExpression(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getFilterExpression();
        this._customizer.setFilterExpression(string);
        this._postSet(10, string2, string);
    }

    public Query getQuery() {
        return this._customizer.getQuery();
    }

    public boolean isQuerySet() {
        return this._isSet(11);
    }

    public void setQuery(Query query) throws InvalidAttributeValueException {
        this._Query = query;
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 10;
        }
        try {
            switch (n) {
                case 10: {
                    this._customizer.setFilterExpression(null);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 11: {
                    this._Query = null;
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setSeverityLevel(16);
                    if (bl) break;
                }
                case 8: {
                    this._customizer.setSubsystemNames(new String[0]);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setUserIds(new String[0]);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "LogFilter";
    }

    public void putValue(String string, Object object) {
        if (string.equals("FilterExpression")) {
            String string2 = this._FilterExpression;
            this._FilterExpression = (String)object;
            this._postSet(10, string2, this._FilterExpression);
            return;
        }
        if (string.equals("Name")) {
            String string3 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string3, this._Name);
            return;
        }
        if (string.equals("Query")) {
            Query query = this._Query;
            this._Query = (Query)object;
            this._postSet(11, query, this._Query);
            return;
        }
        if (string.equals("SeverityLevel")) {
            int n = this._SeverityLevel;
            this._SeverityLevel = (Integer)object;
            this._postSet(7, n, this._SeverityLevel);
            return;
        }
        if (string.equals("SubsystemNames")) {
            String[] stringArray = this._SubsystemNames;
            this._SubsystemNames = (String[])object;
            this._postSet(8, stringArray, this._SubsystemNames);
            return;
        }
        if (string.equals("UserIds")) {
            String[] stringArray = this._UserIds;
            this._UserIds = (String[])object;
            this._postSet(9, stringArray, this._UserIds);
            return;
        }
        if (string.equals("customizer")) {
            LogFilter logFilter = this._customizer;
            this._customizer = (LogFilter)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("FilterExpression")) {
            return this._FilterExpression;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Query")) {
            return this._Query;
        }
        if (string.equals("SeverityLevel")) {
            return new Integer(this._SeverityLevel);
        }
        if (string.equals("SubsystemNames")) {
            return this._SubsystemNames;
        }
        if (string.equals("UserIds")) {
            return this._UserIds;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 17: {
                    if (!string.equals("filter-expression")) break;
                    return 10;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 5: {
                    if (!string.equals("query")) break;
                    return 11;
                }
                case 14: {
                    if (string.equals("severity-level")) {
                        return 7;
                    }
                    if (!string.equals("subsystem-name")) break;
                    return 8;
                }
                case 7: {
                    if (!string.equals("user-id")) break;
                    return 9;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 10: {
                    return "filter-expression";
                }
                case 2: {
                    return "name";
                }
                case 11: {
                    return "query";
                }
                case 7: {
                    return "severity-level";
                }
                case 8: {
                    return "subsystem-name";
                }
                case 9: {
                    return "user-id";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 8: {
                    return true;
                }
                case 9: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private LogFilterMBeanImpl bean;

        protected Helper(LogFilterMBeanImpl logFilterMBeanImpl) {
            super(logFilterMBeanImpl);
            this.bean = logFilterMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 10: {
                    return "FilterExpression";
                }
                case 2: {
                    return "Name";
                }
                case 11: {
                    return "Query";
                }
                case 7: {
                    return "SeverityLevel";
                }
                case 8: {
                    return "SubsystemNames";
                }
                case 9: {
                    return "UserIds";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("FilterExpression")) {
                return 10;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Query")) {
                return 11;
            }
            if (string.equals("SeverityLevel")) {
                return 7;
            }
            if (string.equals("SubsystemNames")) {
                return 8;
            }
            if (string.equals("UserIds")) {
                return 9;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isFilterExpressionSet()) {
                    stringBuffer.append("FilterExpression");
                    stringBuffer.append(String.valueOf(this.bean.getFilterExpression()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isQuerySet()) {
                    stringBuffer.append("Query");
                    stringBuffer.append(String.valueOf(this.bean.getQuery()));
                }
                if (this.bean.isSeverityLevelSet()) {
                    stringBuffer.append("SeverityLevel");
                    stringBuffer.append(String.valueOf(this.bean.getSeverityLevel()));
                }
                if (this.bean.isSubsystemNamesSet()) {
                    stringBuffer.append("SubsystemNames");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getSubsystemNames())));
                }
                if (this.bean.isUserIdsSet()) {
                    stringBuffer.append("UserIds");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getUserIds())));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                LogFilterMBeanImpl logFilterMBeanImpl = (LogFilterMBeanImpl)abstractDescriptorBean;
                this.computeDiff("FilterExpression", this.bean.getFilterExpression(), logFilterMBeanImpl.getFilterExpression(), true);
                this.computeDiff("Name", this.bean.getName(), logFilterMBeanImpl.getName(), false);
                this.computeDiff("SeverityLevel", this.bean.getSeverityLevel(), logFilterMBeanImpl.getSeverityLevel(), true);
                this.computeDiff("SubsystemNames", this.bean.getSubsystemNames(), logFilterMBeanImpl.getSubsystemNames(), true);
                this.computeDiff("UserIds", this.bean.getUserIds(), logFilterMBeanImpl.getUserIds(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                LogFilterMBeanImpl logFilterMBeanImpl = (LogFilterMBeanImpl)beanUpdateEvent.getSourceBean();
                LogFilterMBeanImpl logFilterMBeanImpl2 = (LogFilterMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("FilterExpression")) {
                    logFilterMBeanImpl.setFilterExpression(logFilterMBeanImpl2.getFilterExpression());
                    logFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("Name")) {
                    logFilterMBeanImpl.setName(logFilterMBeanImpl2.getName());
                    logFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (!string.equals("Query")) {
                    if (string.equals("SeverityLevel")) {
                        logFilterMBeanImpl.setSeverityLevel(logFilterMBeanImpl2.getSeverityLevel());
                        logFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("SubsystemNames")) {
                        logFilterMBeanImpl.setSubsystemNames(logFilterMBeanImpl2.getSubsystemNames());
                        logFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("UserIds")) {
                        logFilterMBeanImpl.setUserIds(logFilterMBeanImpl2.getUserIds());
                        logFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                String[] stringArray;
                LogFilterMBeanImpl logFilterMBeanImpl = (LogFilterMBeanImpl)abstractDescriptorBean;
                super.finishCopy(logFilterMBeanImpl, bl, list);
                if ((list == null || !list.contains("FilterExpression")) && this.bean.isFilterExpressionSet()) {
                    logFilterMBeanImpl.setFilterExpression(this.bean.getFilterExpression());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    logFilterMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("SeverityLevel")) && this.bean.isSeverityLevelSet()) {
                    logFilterMBeanImpl.setSeverityLevel(this.bean.getSeverityLevel());
                }
                if ((list == null || !list.contains("SubsystemNames")) && this.bean.isSubsystemNamesSet()) {
                    stringArray = this.bean.getSubsystemNames();
                    logFilterMBeanImpl.setSubsystemNames(stringArray == null ? null : (String[])stringArray.clone());
                }
                if ((list == null || !list.contains("UserIds")) && this.bean.isUserIdsSet()) {
                    stringArray = this.bean.getUserIds();
                    logFilterMBeanImpl.setUserIds(stringArray == null ? null : (String[])stringArray.clone());
                }
                return logFilterMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

