/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.CommonLogMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.management.mbeans.custom.Log;
import weblogic.utils.collections.CombinedIterator;

public class LogMBeanImpl
extends CommonLogMBeanImpl
implements LogMBean,
Serializable {
    private LogFilterMBean _DomainLogBroadcastFilter;
    private String _DomainLogBroadcastSeverity;
    private int _DomainLogBroadcasterBufferSize;
    private boolean _Log4jLoggingEnabled;
    private LogFilterMBean _LogFileFilter;
    private LogFilterMBean _MemoryBufferFilter;
    private String _MemoryBufferSeverity;
    private int _MemoryBufferSize;
    private String _Name;
    private boolean _RedirectStderrToServerLogEnabled;
    private boolean _RedirectStdoutToServerLogEnabled;
    private boolean _ServerLoggingBridgeUseParentLoggersEnabled;
    private LogFilterMBean _StdoutFilter;
    private Log _customizer;
    private static SchemaHelper2 _schemaHelper;

    public LogMBeanImpl() {
        try {
            this._customizer = new Log(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public LogMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new Log(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public LogFilterMBean getLogFileFilter() {
        return this._LogFileFilter;
    }

    public String getLogFileFilterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getLogFileFilter();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isLogFileFilterSet() {
        return this._isSet(27);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setLogFileFilterAsString(String string) {
        if (string == null || string.length() == 0) {
            LogFilterMBean logFilterMBean = this._LogFileFilter;
            this._initializeProperty(27);
            this._postSet(27, logFilterMBean, this._LogFileFilter);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, LogFilterMBean.class, new ReferenceManager.Resolver(this, 27){

                public void resolveReference(Object object) {
                    try {
                        LogMBeanImpl.this.setLogFileFilter((LogFilterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setLogFileFilter(LogFilterMBean logFilterMBean) {
        LogFilterMBean logFilterMBean2;
        if (logFilterMBean != null) {
            logFilterMBean2 = new ResolvedReference(this, 27, (AbstractDescriptorBean)logFilterMBean){

                protected Object getPropertyValue() {
                    return LogMBeanImpl.this.getLogFileFilter();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)logFilterMBean, (ResolvedReference)logFilterMBean2);
        }
        logFilterMBean2 = this._LogFileFilter;
        this._LogFileFilter = logFilterMBean;
        this._postSet(27, logFilterMBean2, logFilterMBean);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public LogFilterMBean getStdoutFilter() {
        return this._StdoutFilter;
    }

    public String getStdoutFilterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getStdoutFilter();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isStdoutFilterSet() {
        return this._isSet(28);
    }

    public void setStdoutFilterAsString(String string) {
        if (string == null || string.length() == 0) {
            LogFilterMBean logFilterMBean = this._StdoutFilter;
            this._initializeProperty(28);
            this._postSet(28, logFilterMBean, this._StdoutFilter);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, LogFilterMBean.class, new ReferenceManager.Resolver(this, 28){

                public void resolveReference(Object object) {
                    try {
                        LogMBeanImpl.this.setStdoutFilter((LogFilterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setStdoutFilter(LogFilterMBean logFilterMBean) {
        LogFilterMBean logFilterMBean2;
        if (logFilterMBean != null) {
            logFilterMBean2 = new ResolvedReference(this, 28, (AbstractDescriptorBean)logFilterMBean){

                protected Object getPropertyValue() {
                    return LogMBeanImpl.this.getStdoutFilter();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)logFilterMBean, (ResolvedReference)logFilterMBean2);
        }
        logFilterMBean2 = this._StdoutFilter;
        this._StdoutFilter = logFilterMBean;
        this._postSet(28, logFilterMBean2, logFilterMBean);
    }

    public String getDomainLogBroadcastSeverity() {
        return this._DomainLogBroadcastSeverity;
    }

    public boolean isDomainLogBroadcastSeveritySet() {
        return this._isSet(29);
    }

    public void setDomainLogBroadcastSeverity(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Debug", "Info", "Warning", "Error", "Notice", "Critical", "Alert", "Emergency", "Off"};
        string = LegalChecks.checkInEnum((String)"DomainLogBroadcastSeverity", (String)string, (String[])stringArray);
        String string2 = this._DomainLogBroadcastSeverity;
        this._DomainLogBroadcastSeverity = string;
        this._postSet(29, string2, string);
    }

    public LogFilterMBean getDomainLogBroadcastFilter() {
        return this._DomainLogBroadcastFilter;
    }

    public String getDomainLogBroadcastFilterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDomainLogBroadcastFilter();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDomainLogBroadcastFilterSet() {
        return this._isSet(30);
    }

    public void setDomainLogBroadcastFilterAsString(String string) {
        if (string == null || string.length() == 0) {
            LogFilterMBean logFilterMBean = this._DomainLogBroadcastFilter;
            this._initializeProperty(30);
            this._postSet(30, logFilterMBean, this._DomainLogBroadcastFilter);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, LogFilterMBean.class, new ReferenceManager.Resolver(this, 30){

                public void resolveReference(Object object) {
                    try {
                        LogMBeanImpl.this.setDomainLogBroadcastFilter((LogFilterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setDomainLogBroadcastFilter(LogFilterMBean logFilterMBean) {
        LogFilterMBean logFilterMBean2;
        if (logFilterMBean != null) {
            logFilterMBean2 = new ResolvedReference(this, 30, (AbstractDescriptorBean)logFilterMBean){

                protected Object getPropertyValue() {
                    return LogMBeanImpl.this.getDomainLogBroadcastFilter();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)logFilterMBean, (ResolvedReference)logFilterMBean2);
        }
        logFilterMBean2 = this._DomainLogBroadcastFilter;
        this._DomainLogBroadcastFilter = logFilterMBean;
        this._postSet(30, logFilterMBean2, logFilterMBean);
    }

    public String getMemoryBufferSeverity() {
        return this._MemoryBufferSeverity;
    }

    public boolean isMemoryBufferSeveritySet() {
        return this._isSet(31);
    }

    public void setMemoryBufferSeverity(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Trace", "Debug", "Info", "Warning", "Error", "Notice", "Critical", "Alert", "Emergency", "Off"};
        string = LegalChecks.checkInEnum((String)"MemoryBufferSeverity", (String)string, (String[])stringArray);
        String string2 = this._MemoryBufferSeverity;
        this._MemoryBufferSeverity = string;
        this._postSet(31, string2, string);
    }

    public LogFilterMBean getMemoryBufferFilter() {
        return this._MemoryBufferFilter;
    }

    public String getMemoryBufferFilterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getMemoryBufferFilter();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isMemoryBufferFilterSet() {
        return this._isSet(32);
    }

    public void setMemoryBufferFilterAsString(String string) {
        if (string == null || string.length() == 0) {
            LogFilterMBean logFilterMBean = this._MemoryBufferFilter;
            this._initializeProperty(32);
            this._postSet(32, logFilterMBean, this._MemoryBufferFilter);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, LogFilterMBean.class, new ReferenceManager.Resolver(this, 32){

                public void resolveReference(Object object) {
                    try {
                        LogMBeanImpl.this.setMemoryBufferFilter((LogFilterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setMemoryBufferFilter(LogFilterMBean logFilterMBean) {
        LogFilterMBean logFilterMBean2;
        if (logFilterMBean != null) {
            logFilterMBean2 = new ResolvedReference(this, 32, (AbstractDescriptorBean)logFilterMBean){

                protected Object getPropertyValue() {
                    return LogMBeanImpl.this.getMemoryBufferFilter();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)logFilterMBean, (ResolvedReference)logFilterMBean2);
        }
        logFilterMBean2 = this._MemoryBufferFilter;
        this._MemoryBufferFilter = logFilterMBean;
        this._postSet(32, logFilterMBean2, logFilterMBean);
    }

    public int getMemoryBufferSize() {
        if (!this._isSet(33)) {
            return this._isProductionModeEnabled() ? 500 : 10;
        }
        return this._MemoryBufferSize;
    }

    public boolean isMemoryBufferSizeSet() {
        return this._isSet(33);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setMemoryBufferSize(int n) {
        LegalChecks.checkInRange((String)"MemoryBufferSize", (long)n, (long)10L, (long)5000L);
        int n2 = this._MemoryBufferSize;
        this._MemoryBufferSize = n;
        this._postSet(33, n2, n);
    }

    public boolean isLog4jLoggingEnabled() {
        return this._Log4jLoggingEnabled;
    }

    public boolean isLog4jLoggingEnabledSet() {
        return this._isSet(34);
    }

    public void setLog4jLoggingEnabled(boolean bl) {
        boolean bl2 = this._Log4jLoggingEnabled;
        this._Log4jLoggingEnabled = bl;
        this._postSet(34, bl2, bl);
    }

    public boolean isRedirectStdoutToServerLogEnabled() {
        return this._RedirectStdoutToServerLogEnabled;
    }

    public boolean isRedirectStdoutToServerLogEnabledSet() {
        return this._isSet(35);
    }

    public void setRedirectStdoutToServerLogEnabled(boolean bl) {
        boolean bl2 = this._RedirectStdoutToServerLogEnabled;
        this._RedirectStdoutToServerLogEnabled = bl;
        this._postSet(35, bl2, bl);
    }

    public boolean isRedirectStderrToServerLogEnabled() {
        return this._RedirectStderrToServerLogEnabled;
    }

    public boolean isRedirectStderrToServerLogEnabledSet() {
        return this._isSet(36);
    }

    public void setRedirectStderrToServerLogEnabled(boolean bl) {
        boolean bl2 = this._RedirectStderrToServerLogEnabled;
        this._RedirectStderrToServerLogEnabled = bl;
        this._postSet(36, bl2, bl);
    }

    public int getDomainLogBroadcasterBufferSize() {
        if (!this._isSet(37)) {
            return this._isProductionModeEnabled() ? 10 : 1;
        }
        return this._DomainLogBroadcasterBufferSize;
    }

    public boolean isDomainLogBroadcasterBufferSizeSet() {
        return this._isSet(37);
    }

    public void setDomainLogBroadcasterBufferSize(int n) {
        LegalChecks.checkInRange((String)"DomainLogBroadcasterBufferSize", (long)n, (long)1L, (long)100L);
        int n2 = this._DomainLogBroadcasterBufferSize;
        this._DomainLogBroadcasterBufferSize = n;
        this._postSet(37, n2, n);
    }

    public String computeLogFilePath() {
        return this._customizer.computeLogFilePath();
    }

    public boolean isServerLoggingBridgeUseParentLoggersEnabled() {
        return this._ServerLoggingBridgeUseParentLoggersEnabled;
    }

    public boolean isServerLoggingBridgeUseParentLoggersEnabledSet() {
        return this._isSet(38);
    }

    public void setServerLoggingBridgeUseParentLoggersEnabled(boolean bl) {
        boolean bl2 = this._ServerLoggingBridgeUseParentLoggersEnabled;
        this._ServerLoggingBridgeUseParentLoggersEnabled = bl;
        this._postSet(38, bl2, bl);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 30;
        }
        try {
            switch (n) {
                case 30: {
                    this._DomainLogBroadcastFilter = null;
                    if (bl) break;
                }
                case 29: {
                    this._DomainLogBroadcastSeverity = "Notice";
                    if (bl) break;
                }
                case 37: {
                    this._DomainLogBroadcasterBufferSize = 1;
                    if (bl) break;
                }
                case 27: {
                    this._LogFileFilter = null;
                    if (bl) break;
                }
                case 32: {
                    this._MemoryBufferFilter = null;
                    if (bl) break;
                }
                case 31: {
                    this._MemoryBufferSeverity = "Trace";
                    if (bl) break;
                }
                case 33: {
                    this._MemoryBufferSize = 10;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 28: {
                    this._StdoutFilter = null;
                    if (bl) break;
                }
                case 34: {
                    this._Log4jLoggingEnabled = false;
                    if (bl) break;
                }
                case 36: {
                    this._RedirectStderrToServerLogEnabled = false;
                    if (bl) break;
                }
                case 35: {
                    this._RedirectStdoutToServerLogEnabled = false;
                    if (bl) break;
                }
                case 38: {
                    this._ServerLoggingBridgeUseParentLoggersEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Log";
    }

    public void putValue(String string, Object object) {
        if (string.equals("DomainLogBroadcastFilter")) {
            LogFilterMBean logFilterMBean = this._DomainLogBroadcastFilter;
            this._DomainLogBroadcastFilter = (LogFilterMBean)object;
            this._postSet(30, logFilterMBean, this._DomainLogBroadcastFilter);
            return;
        }
        if (string.equals("DomainLogBroadcastSeverity")) {
            String string2 = this._DomainLogBroadcastSeverity;
            this._DomainLogBroadcastSeverity = (String)object;
            this._postSet(29, string2, this._DomainLogBroadcastSeverity);
            return;
        }
        if (string.equals("DomainLogBroadcasterBufferSize")) {
            int n = this._DomainLogBroadcasterBufferSize;
            this._DomainLogBroadcasterBufferSize = (Integer)object;
            this._postSet(37, n, this._DomainLogBroadcasterBufferSize);
            return;
        }
        if (string.equals("Log4jLoggingEnabled")) {
            boolean bl = this._Log4jLoggingEnabled;
            this._Log4jLoggingEnabled = (Boolean)object;
            this._postSet(34, bl, this._Log4jLoggingEnabled);
            return;
        }
        if (string.equals("LogFileFilter")) {
            LogFilterMBean logFilterMBean = this._LogFileFilter;
            this._LogFileFilter = (LogFilterMBean)object;
            this._postSet(27, logFilterMBean, this._LogFileFilter);
            return;
        }
        if (string.equals("MemoryBufferFilter")) {
            LogFilterMBean logFilterMBean = this._MemoryBufferFilter;
            this._MemoryBufferFilter = (LogFilterMBean)object;
            this._postSet(32, logFilterMBean, this._MemoryBufferFilter);
            return;
        }
        if (string.equals("MemoryBufferSeverity")) {
            String string3 = this._MemoryBufferSeverity;
            this._MemoryBufferSeverity = (String)object;
            this._postSet(31, string3, this._MemoryBufferSeverity);
            return;
        }
        if (string.equals("MemoryBufferSize")) {
            int n = this._MemoryBufferSize;
            this._MemoryBufferSize = (Integer)object;
            this._postSet(33, n, this._MemoryBufferSize);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("RedirectStderrToServerLogEnabled")) {
            boolean bl = this._RedirectStderrToServerLogEnabled;
            this._RedirectStderrToServerLogEnabled = (Boolean)object;
            this._postSet(36, bl, this._RedirectStderrToServerLogEnabled);
            return;
        }
        if (string.equals("RedirectStdoutToServerLogEnabled")) {
            boolean bl = this._RedirectStdoutToServerLogEnabled;
            this._RedirectStdoutToServerLogEnabled = (Boolean)object;
            this._postSet(35, bl, this._RedirectStdoutToServerLogEnabled);
            return;
        }
        if (string.equals("ServerLoggingBridgeUseParentLoggersEnabled")) {
            boolean bl = this._ServerLoggingBridgeUseParentLoggersEnabled;
            this._ServerLoggingBridgeUseParentLoggersEnabled = (Boolean)object;
            this._postSet(38, bl, this._ServerLoggingBridgeUseParentLoggersEnabled);
            return;
        }
        if (string.equals("StdoutFilter")) {
            LogFilterMBean logFilterMBean = this._StdoutFilter;
            this._StdoutFilter = (LogFilterMBean)object;
            this._postSet(28, logFilterMBean, this._StdoutFilter);
            return;
        }
        if (string.equals("customizer")) {
            Log log = this._customizer;
            this._customizer = (Log)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("DomainLogBroadcastFilter")) {
            return this._DomainLogBroadcastFilter;
        }
        if (string.equals("DomainLogBroadcastSeverity")) {
            return this._DomainLogBroadcastSeverity;
        }
        if (string.equals("DomainLogBroadcasterBufferSize")) {
            return new Integer(this._DomainLogBroadcasterBufferSize);
        }
        if (string.equals("Log4jLoggingEnabled")) {
            return new Boolean(this._Log4jLoggingEnabled);
        }
        if (string.equals("LogFileFilter")) {
            return this._LogFileFilter;
        }
        if (string.equals("MemoryBufferFilter")) {
            return this._MemoryBufferFilter;
        }
        if (string.equals("MemoryBufferSeverity")) {
            return this._MemoryBufferSeverity;
        }
        if (string.equals("MemoryBufferSize")) {
            return new Integer(this._MemoryBufferSize);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("RedirectStderrToServerLogEnabled")) {
            return new Boolean(this._RedirectStderrToServerLogEnabled);
        }
        if (string.equals("RedirectStdoutToServerLogEnabled")) {
            return new Boolean(this._RedirectStdoutToServerLogEnabled);
        }
        if (string.equals("ServerLoggingBridgeUseParentLoggersEnabled")) {
            return new Boolean(this._ServerLoggingBridgeUseParentLoggersEnabled);
        }
        if (string.equals("StdoutFilter")) {
            return this._StdoutFilter;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends CommonLogMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 27: {
                    if (!string.equals("domain-log-broadcast-filter")) break;
                    return 30;
                }
                case 29: {
                    if (!string.equals("domain-log-broadcast-severity")) break;
                    return 29;
                }
                case 34: {
                    if (!string.equals("domain-log-broadcaster-buffer-size")) break;
                    return 37;
                }
                case 15: {
                    if (!string.equals("log-file-filter")) break;
                    return 27;
                }
                case 20: {
                    if (!string.equals("memory-buffer-filter")) break;
                    return 32;
                }
                case 22: {
                    if (!string.equals("memory-buffer-severity")) break;
                    return 31;
                }
                case 18: {
                    if (!string.equals("memory-buffer-size")) break;
                    return 33;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 13: {
                    if (!string.equals("stdout-filter")) break;
                    return 28;
                }
                case 21: {
                    if (!string.equals("log4j-logging-enabled")) break;
                    return 34;
                }
                case 37: {
                    if (string.equals("redirect-stderr-to-server-log-enabled")) {
                        return 36;
                    }
                    if (!string.equals("redirect-stdout-to-server-log-enabled")) break;
                    return 35;
                }
                case 48: {
                    if (!string.equals("server-logging-bridge-use-parent-loggers-enabled")) break;
                    return 38;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 30: {
                    return "domain-log-broadcast-filter";
                }
                case 29: {
                    return "domain-log-broadcast-severity";
                }
                case 37: {
                    return "domain-log-broadcaster-buffer-size";
                }
                case 27: {
                    return "log-file-filter";
                }
                case 32: {
                    return "memory-buffer-filter";
                }
                case 31: {
                    return "memory-buffer-severity";
                }
                case 33: {
                    return "memory-buffer-size";
                }
                case 2: {
                    return "name";
                }
                case 28: {
                    return "stdout-filter";
                }
                case 34: {
                    return "log4j-logging-enabled";
                }
                case 36: {
                    return "redirect-stderr-to-server-log-enabled";
                }
                case 35: {
                    return "redirect-stdout-to-server-log-enabled";
                }
                case 38: {
                    return "server-logging-bridge-use-parent-loggers-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 15: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 13: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends CommonLogMBeanImpl.Helper {
        private LogMBeanImpl bean;

        protected Helper(LogMBeanImpl logMBeanImpl) {
            super(logMBeanImpl);
            this.bean = logMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 30: {
                    return "DomainLogBroadcastFilter";
                }
                case 29: {
                    return "DomainLogBroadcastSeverity";
                }
                case 37: {
                    return "DomainLogBroadcasterBufferSize";
                }
                case 27: {
                    return "LogFileFilter";
                }
                case 32: {
                    return "MemoryBufferFilter";
                }
                case 31: {
                    return "MemoryBufferSeverity";
                }
                case 33: {
                    return "MemoryBufferSize";
                }
                case 2: {
                    return "Name";
                }
                case 28: {
                    return "StdoutFilter";
                }
                case 34: {
                    return "Log4jLoggingEnabled";
                }
                case 36: {
                    return "RedirectStderrToServerLogEnabled";
                }
                case 35: {
                    return "RedirectStdoutToServerLogEnabled";
                }
                case 38: {
                    return "ServerLoggingBridgeUseParentLoggersEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("DomainLogBroadcastFilter")) {
                return 30;
            }
            if (string.equals("DomainLogBroadcastSeverity")) {
                return 29;
            }
            if (string.equals("DomainLogBroadcasterBufferSize")) {
                return 37;
            }
            if (string.equals("LogFileFilter")) {
                return 27;
            }
            if (string.equals("MemoryBufferFilter")) {
                return 32;
            }
            if (string.equals("MemoryBufferSeverity")) {
                return 31;
            }
            if (string.equals("MemoryBufferSize")) {
                return 33;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("StdoutFilter")) {
                return 28;
            }
            if (string.equals("Log4jLoggingEnabled")) {
                return 34;
            }
            if (string.equals("RedirectStderrToServerLogEnabled")) {
                return 36;
            }
            if (string.equals("RedirectStdoutToServerLogEnabled")) {
                return 35;
            }
            if (string.equals("ServerLoggingBridgeUseParentLoggersEnabled")) {
                return 38;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDomainLogBroadcastFilterSet()) {
                    stringBuffer.append("DomainLogBroadcastFilter");
                    stringBuffer.append(String.valueOf(this.bean.getDomainLogBroadcastFilter()));
                }
                if (this.bean.isDomainLogBroadcastSeveritySet()) {
                    stringBuffer.append("DomainLogBroadcastSeverity");
                    stringBuffer.append(String.valueOf(this.bean.getDomainLogBroadcastSeverity()));
                }
                if (this.bean.isDomainLogBroadcasterBufferSizeSet()) {
                    stringBuffer.append("DomainLogBroadcasterBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getDomainLogBroadcasterBufferSize()));
                }
                if (this.bean.isLogFileFilterSet()) {
                    stringBuffer.append("LogFileFilter");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileFilter()));
                }
                if (this.bean.isMemoryBufferFilterSet()) {
                    stringBuffer.append("MemoryBufferFilter");
                    stringBuffer.append(String.valueOf(this.bean.getMemoryBufferFilter()));
                }
                if (this.bean.isMemoryBufferSeveritySet()) {
                    stringBuffer.append("MemoryBufferSeverity");
                    stringBuffer.append(String.valueOf(this.bean.getMemoryBufferSeverity()));
                }
                if (this.bean.isMemoryBufferSizeSet()) {
                    stringBuffer.append("MemoryBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getMemoryBufferSize()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isStdoutFilterSet()) {
                    stringBuffer.append("StdoutFilter");
                    stringBuffer.append(String.valueOf(this.bean.getStdoutFilter()));
                }
                if (this.bean.isLog4jLoggingEnabledSet()) {
                    stringBuffer.append("Log4jLoggingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLog4jLoggingEnabled()));
                }
                if (this.bean.isRedirectStderrToServerLogEnabledSet()) {
                    stringBuffer.append("RedirectStderrToServerLogEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isRedirectStderrToServerLogEnabled()));
                }
                if (this.bean.isRedirectStdoutToServerLogEnabledSet()) {
                    stringBuffer.append("RedirectStdoutToServerLogEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isRedirectStdoutToServerLogEnabled()));
                }
                if (this.bean.isServerLoggingBridgeUseParentLoggersEnabledSet()) {
                    stringBuffer.append("ServerLoggingBridgeUseParentLoggersEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isServerLoggingBridgeUseParentLoggersEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                LogMBeanImpl logMBeanImpl = (LogMBeanImpl)abstractDescriptorBean;
                this.computeDiff("DomainLogBroadcastFilter", this.bean.getDomainLogBroadcastFilter(), logMBeanImpl.getDomainLogBroadcastFilter(), true);
                this.computeDiff("DomainLogBroadcastSeverity", this.bean.getDomainLogBroadcastSeverity(), logMBeanImpl.getDomainLogBroadcastSeverity(), true);
                this.computeDiff("DomainLogBroadcasterBufferSize", this.bean.getDomainLogBroadcasterBufferSize(), logMBeanImpl.getDomainLogBroadcasterBufferSize(), true);
                this.computeDiff("LogFileFilter", this.bean.getLogFileFilter(), logMBeanImpl.getLogFileFilter(), true);
                this.computeDiff("MemoryBufferFilter", this.bean.getMemoryBufferFilter(), logMBeanImpl.getMemoryBufferFilter(), true);
                this.computeDiff("MemoryBufferSeverity", this.bean.getMemoryBufferSeverity(), logMBeanImpl.getMemoryBufferSeverity(), true);
                this.computeDiff("MemoryBufferSize", this.bean.getMemoryBufferSize(), logMBeanImpl.getMemoryBufferSize(), true);
                this.computeDiff("Name", this.bean.getName(), logMBeanImpl.getName(), false);
                this.computeDiff("StdoutFilter", this.bean.getStdoutFilter(), logMBeanImpl.getStdoutFilter(), true);
                this.computeDiff("Log4jLoggingEnabled", this.bean.isLog4jLoggingEnabled(), logMBeanImpl.isLog4jLoggingEnabled(), false);
                this.computeDiff("RedirectStderrToServerLogEnabled", this.bean.isRedirectStderrToServerLogEnabled(), logMBeanImpl.isRedirectStderrToServerLogEnabled(), false);
                this.computeDiff("RedirectStdoutToServerLogEnabled", this.bean.isRedirectStdoutToServerLogEnabled(), logMBeanImpl.isRedirectStdoutToServerLogEnabled(), false);
                this.computeDiff("ServerLoggingBridgeUseParentLoggersEnabled", this.bean.isServerLoggingBridgeUseParentLoggersEnabled(), logMBeanImpl.isServerLoggingBridgeUseParentLoggersEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                LogMBeanImpl logMBeanImpl = (LogMBeanImpl)beanUpdateEvent.getSourceBean();
                LogMBeanImpl logMBeanImpl2 = (LogMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("DomainLogBroadcastFilter")) {
                    logMBeanImpl.setDomainLogBroadcastFilterAsString(logMBeanImpl2.getDomainLogBroadcastFilterAsString());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("DomainLogBroadcastSeverity")) {
                    logMBeanImpl.setDomainLogBroadcastSeverity(logMBeanImpl2.getDomainLogBroadcastSeverity());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("DomainLogBroadcasterBufferSize")) {
                    logMBeanImpl.setDomainLogBroadcasterBufferSize(logMBeanImpl2.getDomainLogBroadcasterBufferSize());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                } else if (string.equals("LogFileFilter")) {
                    logMBeanImpl.setLogFileFilterAsString(logMBeanImpl2.getLogFileFilterAsString());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("MemoryBufferFilter")) {
                    logMBeanImpl.setMemoryBufferFilterAsString(logMBeanImpl2.getMemoryBufferFilterAsString());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                } else if (string.equals("MemoryBufferSeverity")) {
                    logMBeanImpl.setMemoryBufferSeverity(logMBeanImpl2.getMemoryBufferSeverity());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else if (string.equals("MemoryBufferSize")) {
                    logMBeanImpl.setMemoryBufferSize(logMBeanImpl2.getMemoryBufferSize());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                } else if (string.equals("Name")) {
                    logMBeanImpl.setName(logMBeanImpl2.getName());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("StdoutFilter")) {
                    logMBeanImpl.setStdoutFilterAsString(logMBeanImpl2.getStdoutFilterAsString());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("Log4jLoggingEnabled")) {
                    logMBeanImpl.setLog4jLoggingEnabled(logMBeanImpl2.isLog4jLoggingEnabled());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                } else if (string.equals("RedirectStderrToServerLogEnabled")) {
                    logMBeanImpl.setRedirectStderrToServerLogEnabled(logMBeanImpl2.isRedirectStderrToServerLogEnabled());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                } else if (string.equals("RedirectStdoutToServerLogEnabled")) {
                    logMBeanImpl.setRedirectStdoutToServerLogEnabled(logMBeanImpl2.isRedirectStdoutToServerLogEnabled());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                } else if (string.equals("ServerLoggingBridgeUseParentLoggersEnabled")) {
                    logMBeanImpl.setServerLoggingBridgeUseParentLoggersEnabled(logMBeanImpl2.isServerLoggingBridgeUseParentLoggersEnabled());
                    logMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                LogMBeanImpl logMBeanImpl = (LogMBeanImpl)abstractDescriptorBean;
                super.finishCopy(logMBeanImpl, bl, list);
                if ((list == null || !list.contains("DomainLogBroadcastFilter")) && this.bean.isDomainLogBroadcastFilterSet()) {
                    logMBeanImpl._unSet(logMBeanImpl, 30);
                    logMBeanImpl.setDomainLogBroadcastFilterAsString(this.bean.getDomainLogBroadcastFilterAsString());
                }
                if ((list == null || !list.contains("DomainLogBroadcastSeverity")) && this.bean.isDomainLogBroadcastSeveritySet()) {
                    logMBeanImpl.setDomainLogBroadcastSeverity(this.bean.getDomainLogBroadcastSeverity());
                }
                if ((list == null || !list.contains("DomainLogBroadcasterBufferSize")) && this.bean.isDomainLogBroadcasterBufferSizeSet()) {
                    logMBeanImpl.setDomainLogBroadcasterBufferSize(this.bean.getDomainLogBroadcasterBufferSize());
                }
                if ((list == null || !list.contains("LogFileFilter")) && this.bean.isLogFileFilterSet()) {
                    logMBeanImpl._unSet(logMBeanImpl, 27);
                    logMBeanImpl.setLogFileFilterAsString(this.bean.getLogFileFilterAsString());
                }
                if ((list == null || !list.contains("MemoryBufferFilter")) && this.bean.isMemoryBufferFilterSet()) {
                    logMBeanImpl._unSet(logMBeanImpl, 32);
                    logMBeanImpl.setMemoryBufferFilterAsString(this.bean.getMemoryBufferFilterAsString());
                }
                if ((list == null || !list.contains("MemoryBufferSeverity")) && this.bean.isMemoryBufferSeveritySet()) {
                    logMBeanImpl.setMemoryBufferSeverity(this.bean.getMemoryBufferSeverity());
                }
                if ((list == null || !list.contains("MemoryBufferSize")) && this.bean.isMemoryBufferSizeSet()) {
                    logMBeanImpl.setMemoryBufferSize(this.bean.getMemoryBufferSize());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    logMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("StdoutFilter")) && this.bean.isStdoutFilterSet()) {
                    logMBeanImpl._unSet(logMBeanImpl, 28);
                    logMBeanImpl.setStdoutFilterAsString(this.bean.getStdoutFilterAsString());
                }
                if ((list == null || !list.contains("Log4jLoggingEnabled")) && this.bean.isLog4jLoggingEnabledSet()) {
                    logMBeanImpl.setLog4jLoggingEnabled(this.bean.isLog4jLoggingEnabled());
                }
                if ((list == null || !list.contains("RedirectStderrToServerLogEnabled")) && this.bean.isRedirectStderrToServerLogEnabledSet()) {
                    logMBeanImpl.setRedirectStderrToServerLogEnabled(this.bean.isRedirectStderrToServerLogEnabled());
                }
                if ((list == null || !list.contains("RedirectStdoutToServerLogEnabled")) && this.bean.isRedirectStdoutToServerLogEnabledSet()) {
                    logMBeanImpl.setRedirectStdoutToServerLogEnabled(this.bean.isRedirectStdoutToServerLogEnabled());
                }
                if ((list == null || !list.contains("ServerLoggingBridgeUseParentLoggersEnabled")) && this.bean.isServerLoggingBridgeUseParentLoggersEnabledSet()) {
                    logMBeanImpl.setServerLoggingBridgeUseParentLoggersEnabled(this.bean.isServerLoggingBridgeUseParentLoggersEnabled());
                }
                return logMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDomainLogBroadcastFilter(), clazz, object);
            this.inferSubTree(this.bean.getLogFileFilter(), clazz, object);
            this.inferSubTree(this.bean.getMemoryBufferFilter(), clazz, object);
            this.inferSubTree(this.bean.getStdoutFilter(), clazz, object);
        }
    }
}

