/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ManagedExternalServerMBean;
import weblogic.management.configuration.ManagedExternalServerStartMBean;
import weblogic.utils.collections.CombinedIterator;

public class ManagedExternalServerMBeanImpl
extends ConfigurationMBeanImpl
implements ManagedExternalServerMBean,
Serializable {
    private boolean _AutoRestart;
    private MachineMBean _Machine;
    private ManagedExternalServerStartMBean _ManagedExternalServerStart;
    private int _NMSocketCreateTimeoutInMillis;
    private String _Name;
    private int _RestartDelaySeconds;
    private int _RestartIntervalSeconds;
    private int _RestartMax;
    private static SchemaHelper2 _schemaHelper;

    public ManagedExternalServerMBeanImpl() {
        this._initializeProperty(-1);
    }

    public ManagedExternalServerMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getName() {
        return this._Name;
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        ConfigurationValidator.validateName(string);
        String string2 = this._Name;
        this._Name = string;
        this._postSet(2, string2, string);
    }

    public MachineMBean getMachine() {
        return this._Machine;
    }

    public String getMachineAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getMachine();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isMachineSet() {
        return this._isSet(7);
    }

    public void setMachineAsString(String string) {
        if (string == null || string.length() == 0) {
            MachineMBean machineMBean = this._Machine;
            this._initializeProperty(7);
            this._postSet(7, machineMBean, this._Machine);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, MachineMBean.class, new ReferenceManager.Resolver(this, 7){

                public void resolveReference(Object object) {
                    try {
                        ManagedExternalServerMBeanImpl.this.setMachine((MachineMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setMachine(MachineMBean machineMBean) throws InvalidAttributeValueException {
        MachineMBean machineMBean2;
        if (machineMBean != null) {
            machineMBean2 = new ResolvedReference(this, 7, (AbstractDescriptorBean)machineMBean){

                protected Object getPropertyValue() {
                    return ManagedExternalServerMBeanImpl.this.getMachine();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)machineMBean, (ResolvedReference)machineMBean2);
        }
        machineMBean2 = this._Machine;
        this._Machine = machineMBean;
        this._postSet(7, machineMBean2, machineMBean);
    }

    public boolean getAutoRestart() {
        return this._AutoRestart;
    }

    public boolean isAutoRestartSet() {
        return this._isSet(8);
    }

    public void setAutoRestart(boolean bl) {
        boolean bl2 = this._AutoRestart;
        this._AutoRestart = bl;
        this._postSet(8, bl2, bl);
    }

    public int getRestartIntervalSeconds() {
        return this._RestartIntervalSeconds;
    }

    public boolean isRestartIntervalSecondsSet() {
        return this._isSet(9);
    }

    public void setRestartIntervalSeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RestartIntervalSeconds", (long)n, (long)300L, (long)Integer.MAX_VALUE);
        int n2 = this._RestartIntervalSeconds;
        this._RestartIntervalSeconds = n;
        this._postSet(9, n2, n);
    }

    public int getRestartMax() {
        return this._RestartMax;
    }

    public boolean isRestartMaxSet() {
        return this._isSet(10);
    }

    public void setRestartMax(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RestartMax", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._RestartMax;
        this._RestartMax = n;
        this._postSet(10, n2, n);
    }

    public int getRestartDelaySeconds() {
        return this._RestartDelaySeconds;
    }

    public boolean isRestartDelaySecondsSet() {
        return this._isSet(11);
    }

    public void setRestartDelaySeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RestartDelaySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._RestartDelaySeconds;
        this._RestartDelaySeconds = n;
        this._postSet(11, n2, n);
    }

    public int getNMSocketCreateTimeoutInMillis() {
        return this._NMSocketCreateTimeoutInMillis;
    }

    public boolean isNMSocketCreateTimeoutInMillisSet() {
        return this._isSet(12);
    }

    public void setNMSocketCreateTimeoutInMillis(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"NMSocketCreateTimeoutInMillis", (int)n, (int)0);
        int n2 = this._NMSocketCreateTimeoutInMillis;
        this._NMSocketCreateTimeoutInMillis = n;
        this._postSet(12, n2, n);
    }

    public ManagedExternalServerStartMBean getManagedExternalServerStart() {
        return this._ManagedExternalServerStart;
    }

    public boolean isManagedExternalServerStartSet() {
        return this._isSet(13);
    }

    public void setManagedExternalServerStart(ManagedExternalServerStartMBean managedExternalServerStartMBean) throws InvalidAttributeValueException {
        this._ManagedExternalServerStart = managedExternalServerStartMBean;
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._AutoRestart = true;
                    if (bl) break;
                }
                case 7: {
                    this._Machine = null;
                    if (bl) break;
                }
                case 13: {
                    this._ManagedExternalServerStart = null;
                    if (bl) break;
                }
                case 12: {
                    this._NMSocketCreateTimeoutInMillis = 180000;
                    if (bl) break;
                }
                case 2: {
                    this._Name = null;
                    if (bl) break;
                }
                case 11: {
                    this._RestartDelaySeconds = 0;
                    if (bl) break;
                }
                case 9: {
                    this._RestartIntervalSeconds = 3600;
                    if (bl) break;
                }
                case 10: {
                    this._RestartMax = 2;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "ManagedExternalServer";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AutoRestart")) {
            boolean bl = this._AutoRestart;
            this._AutoRestart = (Boolean)object;
            this._postSet(8, bl, this._AutoRestart);
            return;
        }
        if (string.equals("Machine")) {
            MachineMBean machineMBean = this._Machine;
            this._Machine = (MachineMBean)object;
            this._postSet(7, machineMBean, this._Machine);
            return;
        }
        if (string.equals("ManagedExternalServerStart")) {
            ManagedExternalServerStartMBean managedExternalServerStartMBean = this._ManagedExternalServerStart;
            this._ManagedExternalServerStart = (ManagedExternalServerStartMBean)object;
            this._postSet(13, managedExternalServerStartMBean, this._ManagedExternalServerStart);
            return;
        }
        if (string.equals("NMSocketCreateTimeoutInMillis")) {
            int n = this._NMSocketCreateTimeoutInMillis;
            this._NMSocketCreateTimeoutInMillis = (Integer)object;
            this._postSet(12, n, this._NMSocketCreateTimeoutInMillis);
            return;
        }
        if (string.equals("Name")) {
            String string2 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string2, this._Name);
            return;
        }
        if (string.equals("RestartDelaySeconds")) {
            int n = this._RestartDelaySeconds;
            this._RestartDelaySeconds = (Integer)object;
            this._postSet(11, n, this._RestartDelaySeconds);
            return;
        }
        if (string.equals("RestartIntervalSeconds")) {
            int n = this._RestartIntervalSeconds;
            this._RestartIntervalSeconds = (Integer)object;
            this._postSet(9, n, this._RestartIntervalSeconds);
            return;
        }
        if (string.equals("RestartMax")) {
            int n = this._RestartMax;
            this._RestartMax = (Integer)object;
            this._postSet(10, n, this._RestartMax);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AutoRestart")) {
            return new Boolean(this._AutoRestart);
        }
        if (string.equals("Machine")) {
            return this._Machine;
        }
        if (string.equals("ManagedExternalServerStart")) {
            return this._ManagedExternalServerStart;
        }
        if (string.equals("NMSocketCreateTimeoutInMillis")) {
            return new Integer(this._NMSocketCreateTimeoutInMillis);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("RestartDelaySeconds")) {
            return new Integer(this._RestartDelaySeconds);
        }
        if (string.equals("RestartIntervalSeconds")) {
            return new Integer(this._RestartIntervalSeconds);
        }
        if (string.equals("RestartMax")) {
            return new Integer(this._RestartMax);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 12: {
                    if (!string.equals("auto-restart")) break;
                    return 8;
                }
                case 7: {
                    if (!string.equals("machine")) break;
                    return 7;
                }
                case 29: {
                    if (!string.equals("managed-external-server-start")) break;
                    return 13;
                }
                case 34: {
                    if (!string.equals("nm-socket-create-timeout-in-millis")) break;
                    return 12;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 21: {
                    if (!string.equals("restart-delay-seconds")) break;
                    return 11;
                }
                case 24: {
                    if (!string.equals("restart-interval-seconds")) break;
                    return 9;
                }
                case 11: {
                    if (!string.equals("restart-max")) break;
                    return 10;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "auto-restart";
                }
                case 7: {
                    return "machine";
                }
                case 13: {
                    return "managed-external-server-start";
                }
                case 12: {
                    return "nm-socket-create-timeout-in-millis";
                }
                case 2: {
                    return "name";
                }
                case 11: {
                    return "restart-delay-seconds";
                }
                case 9: {
                    return "restart-interval-seconds";
                }
                case 10: {
                    return "restart-max";
                }
            }
            return super.getElementName(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 8: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 10: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private ManagedExternalServerMBeanImpl bean;

        protected Helper(ManagedExternalServerMBeanImpl managedExternalServerMBeanImpl) {
            super(managedExternalServerMBeanImpl);
            this.bean = managedExternalServerMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "AutoRestart";
                }
                case 7: {
                    return "Machine";
                }
                case 13: {
                    return "ManagedExternalServerStart";
                }
                case 12: {
                    return "NMSocketCreateTimeoutInMillis";
                }
                case 2: {
                    return "Name";
                }
                case 11: {
                    return "RestartDelaySeconds";
                }
                case 9: {
                    return "RestartIntervalSeconds";
                }
                case 10: {
                    return "RestartMax";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AutoRestart")) {
                return 8;
            }
            if (string.equals("Machine")) {
                return 7;
            }
            if (string.equals("ManagedExternalServerStart")) {
                return 13;
            }
            if (string.equals("NMSocketCreateTimeoutInMillis")) {
                return 12;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("RestartDelaySeconds")) {
                return 11;
            }
            if (string.equals("RestartIntervalSeconds")) {
                return 9;
            }
            if (string.equals("RestartMax")) {
                return 10;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAutoRestartSet()) {
                    stringBuffer.append("AutoRestart");
                    stringBuffer.append(String.valueOf(this.bean.getAutoRestart()));
                }
                if (this.bean.isMachineSet()) {
                    stringBuffer.append("Machine");
                    stringBuffer.append(String.valueOf(this.bean.getMachine()));
                }
                if (this.bean.isManagedExternalServerStartSet()) {
                    stringBuffer.append("ManagedExternalServerStart");
                    stringBuffer.append(String.valueOf(this.bean.getManagedExternalServerStart()));
                }
                if (this.bean.isNMSocketCreateTimeoutInMillisSet()) {
                    stringBuffer.append("NMSocketCreateTimeoutInMillis");
                    stringBuffer.append(String.valueOf(this.bean.getNMSocketCreateTimeoutInMillis()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isRestartDelaySecondsSet()) {
                    stringBuffer.append("RestartDelaySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getRestartDelaySeconds()));
                }
                if (this.bean.isRestartIntervalSecondsSet()) {
                    stringBuffer.append("RestartIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getRestartIntervalSeconds()));
                }
                if (this.bean.isRestartMaxSet()) {
                    stringBuffer.append("RestartMax");
                    stringBuffer.append(String.valueOf(this.bean.getRestartMax()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ManagedExternalServerMBeanImpl managedExternalServerMBeanImpl = (ManagedExternalServerMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AutoRestart", this.bean.getAutoRestart(), managedExternalServerMBeanImpl.getAutoRestart(), true);
                this.computeDiff("Machine", this.bean.getMachine(), managedExternalServerMBeanImpl.getMachine(), false);
                this.computeDiff("NMSocketCreateTimeoutInMillis", this.bean.getNMSocketCreateTimeoutInMillis(), managedExternalServerMBeanImpl.getNMSocketCreateTimeoutInMillis(), false);
                this.computeDiff("Name", this.bean.getName(), managedExternalServerMBeanImpl.getName(), false);
                this.computeDiff("RestartDelaySeconds", this.bean.getRestartDelaySeconds(), managedExternalServerMBeanImpl.getRestartDelaySeconds(), true);
                this.computeDiff("RestartIntervalSeconds", this.bean.getRestartIntervalSeconds(), managedExternalServerMBeanImpl.getRestartIntervalSeconds(), true);
                this.computeDiff("RestartMax", this.bean.getRestartMax(), managedExternalServerMBeanImpl.getRestartMax(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ManagedExternalServerMBeanImpl managedExternalServerMBeanImpl = (ManagedExternalServerMBeanImpl)beanUpdateEvent.getSourceBean();
                ManagedExternalServerMBeanImpl managedExternalServerMBeanImpl2 = (ManagedExternalServerMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AutoRestart")) {
                    managedExternalServerMBeanImpl.setAutoRestart(managedExternalServerMBeanImpl2.getAutoRestart());
                    managedExternalServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("Machine")) {
                    managedExternalServerMBeanImpl.setMachineAsString(managedExternalServerMBeanImpl2.getMachineAsString());
                    managedExternalServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (!string.equals("ManagedExternalServerStart")) {
                    if (string.equals("NMSocketCreateTimeoutInMillis")) {
                        managedExternalServerMBeanImpl.setNMSocketCreateTimeoutInMillis(managedExternalServerMBeanImpl2.getNMSocketCreateTimeoutInMillis());
                        managedExternalServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("Name")) {
                        managedExternalServerMBeanImpl.setName(managedExternalServerMBeanImpl2.getName());
                        managedExternalServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("RestartDelaySeconds")) {
                        managedExternalServerMBeanImpl.setRestartDelaySeconds(managedExternalServerMBeanImpl2.getRestartDelaySeconds());
                        managedExternalServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("RestartIntervalSeconds")) {
                        managedExternalServerMBeanImpl.setRestartIntervalSeconds(managedExternalServerMBeanImpl2.getRestartIntervalSeconds());
                        managedExternalServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("RestartMax")) {
                        managedExternalServerMBeanImpl.setRestartMax(managedExternalServerMBeanImpl2.getRestartMax());
                        managedExternalServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ManagedExternalServerMBeanImpl managedExternalServerMBeanImpl = (ManagedExternalServerMBeanImpl)abstractDescriptorBean;
                super.finishCopy(managedExternalServerMBeanImpl, bl, list);
                if ((list == null || !list.contains("AutoRestart")) && this.bean.isAutoRestartSet()) {
                    managedExternalServerMBeanImpl.setAutoRestart(this.bean.getAutoRestart());
                }
                if ((list == null || !list.contains("Machine")) && this.bean.isMachineSet()) {
                    managedExternalServerMBeanImpl._unSet(managedExternalServerMBeanImpl, 7);
                    managedExternalServerMBeanImpl.setMachineAsString(this.bean.getMachineAsString());
                }
                if ((list == null || !list.contains("NMSocketCreateTimeoutInMillis")) && this.bean.isNMSocketCreateTimeoutInMillisSet()) {
                    managedExternalServerMBeanImpl.setNMSocketCreateTimeoutInMillis(this.bean.getNMSocketCreateTimeoutInMillis());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    managedExternalServerMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("RestartDelaySeconds")) && this.bean.isRestartDelaySecondsSet()) {
                    managedExternalServerMBeanImpl.setRestartDelaySeconds(this.bean.getRestartDelaySeconds());
                }
                if ((list == null || !list.contains("RestartIntervalSeconds")) && this.bean.isRestartIntervalSecondsSet()) {
                    managedExternalServerMBeanImpl.setRestartIntervalSeconds(this.bean.getRestartIntervalSeconds());
                }
                if ((list == null || !list.contains("RestartMax")) && this.bean.isRestartMaxSet()) {
                    managedExternalServerMBeanImpl.setRestartMax(this.bean.getRestartMax());
                }
                return managedExternalServerMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getMachine(), clazz, object);
            this.inferSubTree(this.bean.getManagedExternalServerStart(), clazz, object);
        }
    }
}

