/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.MaxThreadsConstraintMBean;
import weblogic.management.configuration.WorkManagerLegalHelper;
import weblogic.utils.collections.CombinedIterator;
import weblogic.work.WorkManagerValidator;

public class MaxThreadsConstraintMBeanImpl
extends DeploymentMBeanImpl
implements MaxThreadsConstraintMBean,
Serializable {
    private String _ConnectionPoolName;
    private int _Count;
    private static SchemaHelper2 _schemaHelper;

    public MaxThreadsConstraintMBeanImpl() {
        this._initializeProperty(-1);
    }

    public MaxThreadsConstraintMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public int getCount() {
        return this._Count;
    }

    public boolean isCountSet() {
        return this._isSet(9);
    }

    public void setCount(int n) {
        WorkManagerValidator.validateMaxThreadsConstraintCount((int)n);
        int n2 = this._Count;
        this._Count = n;
        this._postSet(9, n2, n);
    }

    public String getConnectionPoolName() {
        return this._ConnectionPoolName;
    }

    public boolean isConnectionPoolNameSet() {
        return this._isSet(10);
    }

    public void setConnectionPoolName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ConnectionPoolName;
        this._ConnectionPoolName = string;
        this._postSet(10, string2, string);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        WorkManagerLegalHelper.validateMaxThreadsConstraint(this);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 10;
        }
        try {
            switch (n) {
                case 10: {
                    this._ConnectionPoolName = null;
                    if (bl) break;
                }
                case 9: {
                    this._Count = -1;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "MaxThreadsConstraint";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ConnectionPoolName")) {
            String string2 = this._ConnectionPoolName;
            this._ConnectionPoolName = (String)object;
            this._postSet(10, string2, this._ConnectionPoolName);
            return;
        }
        if (string.equals("Count")) {
            int n = this._Count;
            this._Count = (Integer)object;
            this._postSet(9, n, this._Count);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ConnectionPoolName")) {
            return this._ConnectionPoolName;
        }
        if (string.equals("Count")) {
            return new Integer(this._Count);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (!string.equals("connection-pool-name")) break;
                    return 10;
                }
                case 5: {
                    if (!string.equals("count")) break;
                    return 9;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 10: {
                    return "connection-pool-name";
                }
                case 9: {
                    return "count";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private MaxThreadsConstraintMBeanImpl bean;

        protected Helper(MaxThreadsConstraintMBeanImpl maxThreadsConstraintMBeanImpl) {
            super(maxThreadsConstraintMBeanImpl);
            this.bean = maxThreadsConstraintMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 10: {
                    return "ConnectionPoolName";
                }
                case 9: {
                    return "Count";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ConnectionPoolName")) {
                return 10;
            }
            if (string.equals("Count")) {
                return 9;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isConnectionPoolNameSet()) {
                    stringBuffer.append("ConnectionPoolName");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionPoolName()));
                }
                if (this.bean.isCountSet()) {
                    stringBuffer.append("Count");
                    stringBuffer.append(String.valueOf(this.bean.getCount()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                MaxThreadsConstraintMBeanImpl maxThreadsConstraintMBeanImpl = (MaxThreadsConstraintMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ConnectionPoolName", this.bean.getConnectionPoolName(), maxThreadsConstraintMBeanImpl.getConnectionPoolName(), false);
                this.computeDiff("Count", this.bean.getCount(), maxThreadsConstraintMBeanImpl.getCount(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                MaxThreadsConstraintMBeanImpl maxThreadsConstraintMBeanImpl = (MaxThreadsConstraintMBeanImpl)beanUpdateEvent.getSourceBean();
                MaxThreadsConstraintMBeanImpl maxThreadsConstraintMBeanImpl2 = (MaxThreadsConstraintMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ConnectionPoolName")) {
                    maxThreadsConstraintMBeanImpl.setConnectionPoolName(maxThreadsConstraintMBeanImpl2.getConnectionPoolName());
                    maxThreadsConstraintMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("Count")) {
                    maxThreadsConstraintMBeanImpl.setCount(maxThreadsConstraintMBeanImpl2.getCount());
                    maxThreadsConstraintMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                MaxThreadsConstraintMBeanImpl maxThreadsConstraintMBeanImpl = (MaxThreadsConstraintMBeanImpl)abstractDescriptorBean;
                super.finishCopy(maxThreadsConstraintMBeanImpl, bl, list);
                if ((list == null || !list.contains("ConnectionPoolName")) && this.bean.isConnectionPoolNameSet()) {
                    maxThreadsConstraintMBeanImpl.setConnectionPoolName(this.bean.getConnectionPoolName());
                }
                if ((list == null || !list.contains("Count")) && this.bean.isCountSet()) {
                    maxThreadsConstraintMBeanImpl.setCount(this.bean.getCount());
                }
                return maxThreadsConstraintMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

