/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.BridgeDestinationCommonMBean;
import weblogic.management.configuration.BridgeLegalHelper;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.MessagingBridgeMBean;
import weblogic.utils.collections.CombinedIterator;

public class MessagingBridgeMBeanImpl
extends DeploymentMBeanImpl
implements MessagingBridgeMBean,
Serializable {
    private boolean _AsyncDisabled;
    private boolean _AsyncEnabled;
    private long _BatchInterval;
    private int _BatchSize;
    private boolean _DurabilityDisabled;
    private boolean _DurabilityEnabled;
    private String _ForwardingPolicy;
    private int _IdleTimeMaximum;
    private long _MaximumIdleTimeMilliseconds;
    private boolean _PreserveMsgProperty;
    private boolean _QOSDegradationAllowed;
    private String _QualityOfService;
    private int _ReconnectDelayIncrease;
    private long _ReconnectDelayIncrement;
    private long _ReconnectDelayInitialMilliseconds;
    private int _ReconnectDelayMaximum;
    private long _ReconnectDelayMaximumMilliseconds;
    private int _ReconnectDelayMinimum;
    private long _ScanUnitMilliseconds;
    private String _ScheduleTime;
    private String _Selector;
    private BridgeDestinationCommonMBean _SourceDestination;
    private boolean _Started;
    private BridgeDestinationCommonMBean _TargetDestination;
    private int _TransactionTimeout;
    private int _TransactionTimeoutSeconds;
    private static SchemaHelper2 _schemaHelper;

    public MessagingBridgeMBeanImpl() {
        this._initializeProperty(-1);
    }

    public MessagingBridgeMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public BridgeDestinationCommonMBean getSourceDestination() {
        return this._SourceDestination;
    }

    public String getSourceDestinationAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getSourceDestination();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isSourceDestinationSet() {
        return this._isSet(9);
    }

    public void setSourceDestinationAsString(String string) {
        if (string == null || string.length() == 0) {
            BridgeDestinationCommonMBean bridgeDestinationCommonMBean = this._SourceDestination;
            this._initializeProperty(9);
            this._postSet(9, bridgeDestinationCommonMBean, this._SourceDestination);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, BridgeDestinationCommonMBean.class, new ReferenceManager.Resolver(this, 9){

                public void resolveReference(Object object) {
                    try {
                        MessagingBridgeMBeanImpl.this.setSourceDestination((BridgeDestinationCommonMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setSourceDestination(BridgeDestinationCommonMBean bridgeDestinationCommonMBean) throws InvalidAttributeValueException {
        BridgeDestinationCommonMBean bridgeDestinationCommonMBean2;
        if (bridgeDestinationCommonMBean != null) {
            bridgeDestinationCommonMBean2 = new ResolvedReference(this, 9, (AbstractDescriptorBean)bridgeDestinationCommonMBean){

                protected Object getPropertyValue() {
                    return MessagingBridgeMBeanImpl.this.getSourceDestination();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)bridgeDestinationCommonMBean, (ResolvedReference)bridgeDestinationCommonMBean2);
        }
        bridgeDestinationCommonMBean2 = this._SourceDestination;
        this._SourceDestination = bridgeDestinationCommonMBean;
        this._postSet(9, bridgeDestinationCommonMBean2, bridgeDestinationCommonMBean);
    }

    public BridgeDestinationCommonMBean getTargetDestination() {
        return this._TargetDestination;
    }

    public String getTargetDestinationAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getTargetDestination();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isTargetDestinationSet() {
        return this._isSet(10);
    }

    public void setTargetDestinationAsString(String string) {
        if (string == null || string.length() == 0) {
            BridgeDestinationCommonMBean bridgeDestinationCommonMBean = this._TargetDestination;
            this._initializeProperty(10);
            this._postSet(10, bridgeDestinationCommonMBean, this._TargetDestination);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, BridgeDestinationCommonMBean.class, new ReferenceManager.Resolver(this, 10){

                public void resolveReference(Object object) {
                    try {
                        MessagingBridgeMBeanImpl.this.setTargetDestination((BridgeDestinationCommonMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setTargetDestination(BridgeDestinationCommonMBean bridgeDestinationCommonMBean) throws InvalidAttributeValueException {
        BridgeDestinationCommonMBean bridgeDestinationCommonMBean2;
        if (bridgeDestinationCommonMBean != null) {
            bridgeDestinationCommonMBean2 = new ResolvedReference(this, 10, (AbstractDescriptorBean)bridgeDestinationCommonMBean){

                protected Object getPropertyValue() {
                    return MessagingBridgeMBeanImpl.this.getTargetDestination();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)bridgeDestinationCommonMBean, (ResolvedReference)bridgeDestinationCommonMBean2);
        }
        bridgeDestinationCommonMBean2 = this._TargetDestination;
        this._TargetDestination = bridgeDestinationCommonMBean;
        this._postSet(10, bridgeDestinationCommonMBean2, bridgeDestinationCommonMBean);
    }

    public String getSelector() {
        return this._Selector;
    }

    public boolean isSelectorSet() {
        return this._isSet(11);
    }

    public void setSelector(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Selector;
        this._Selector = string;
        this._postSet(11, string2, string);
    }

    public String getForwardingPolicy() {
        return this._ForwardingPolicy;
    }

    public boolean isForwardingPolicySet() {
        return this._isSet(12);
    }

    public void setForwardingPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Automatic", "Manual", "Scheduled"};
        this._ForwardingPolicy = string = LegalChecks.checkInEnum((String)"ForwardingPolicy", (String)string, (String[])stringArray);
    }

    public String getScheduleTime() {
        return this._ScheduleTime;
    }

    public boolean isScheduleTimeSet() {
        return this._isSet(13);
    }

    public void setScheduleTime(String string) throws InvalidAttributeValueException {
        this._ScheduleTime = string = string == null ? null : string.trim();
    }

    public String getQualityOfService() {
        return this._QualityOfService;
    }

    public boolean isQualityOfServiceSet() {
        return this._isSet(14);
    }

    public void setQualityOfService(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Exactly-once", "Atmost-once", "Duplicate-okay"};
        string = LegalChecks.checkInEnum((String)"QualityOfService", (String)string, (String[])stringArray);
        String string2 = this._QualityOfService;
        this._QualityOfService = string;
        this._postSet(14, string2, string);
    }

    public boolean isQOSDegradationAllowed() {
        return this._QOSDegradationAllowed;
    }

    public boolean isQOSDegradationAllowedSet() {
        return this._isSet(15);
    }

    public void setQOSDegradationAllowed(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._QOSDegradationAllowed;
        this._QOSDegradationAllowed = bl;
        this._postSet(15, bl2, bl);
    }

    public boolean isDurabilityDisabled() {
        return this._DurabilityDisabled;
    }

    public boolean isDurabilityDisabledSet() {
        return this._isSet(16);
    }

    public void setDurabilityDisabled(boolean bl) throws InvalidAttributeValueException {
        this._DurabilityDisabled = bl;
    }

    public boolean isDurabilityEnabled() {
        return this._DurabilityEnabled;
    }

    public boolean isDurabilityEnabledSet() {
        return this._isSet(17);
    }

    public void setDurabilityEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._DurabilityEnabled;
        this._DurabilityEnabled = bl;
        this._postSet(17, bl2, bl);
    }

    public long getReconnectDelayInitialMilliseconds() {
        return this._ReconnectDelayInitialMilliseconds;
    }

    public boolean isReconnectDelayInitialMillisecondsSet() {
        return this._isSet(18);
    }

    public void setReconnectDelayInitialMilliseconds(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ReconnectDelayInitialMilliseconds", (long)l, (long)0L, (long)Long.MAX_VALUE);
        this._ReconnectDelayInitialMilliseconds = l;
    }

    public int getReconnectDelayMinimum() {
        return this._ReconnectDelayMinimum;
    }

    public boolean isReconnectDelayMinimumSet() {
        return this._isSet(19);
    }

    public void setReconnectDelayMinimum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ReconnectDelayMinimum", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._ReconnectDelayMinimum;
        this._ReconnectDelayMinimum = n;
        this._postSet(19, n2, n);
    }

    public long getReconnectDelayIncrement() {
        return this._ReconnectDelayIncrement;
    }

    public boolean isReconnectDelayIncrementSet() {
        return this._isSet(20);
    }

    public void setReconnectDelayIncrement(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ReconnectDelayIncrement", (long)l, (long)0L, (long)Long.MAX_VALUE);
        this._ReconnectDelayIncrement = l;
    }

    public int getReconnectDelayIncrease() {
        return this._ReconnectDelayIncrease;
    }

    public boolean isReconnectDelayIncreaseSet() {
        return this._isSet(21);
    }

    public void setReconnectDelayIncrease(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ReconnectDelayIncrease", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._ReconnectDelayIncrease;
        this._ReconnectDelayIncrease = n;
        this._postSet(21, n2, n);
    }

    public long getReconnectDelayMaximumMilliseconds() {
        return this._ReconnectDelayMaximumMilliseconds;
    }

    public boolean isReconnectDelayMaximumMillisecondsSet() {
        return this._isSet(22);
    }

    public void setReconnectDelayMaximumMilliseconds(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ReconnectDelayMaximumMilliseconds", (long)l, (long)0L, (long)Long.MAX_VALUE);
        this._ReconnectDelayMaximumMilliseconds = l;
    }

    public int getReconnectDelayMaximum() {
        return this._ReconnectDelayMaximum;
    }

    public boolean isReconnectDelayMaximumSet() {
        return this._isSet(23);
    }

    public void setReconnectDelayMaximum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ReconnectDelayMaximum", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._ReconnectDelayMaximum;
        this._ReconnectDelayMaximum = n;
        this._postSet(23, n2, n);
    }

    public long getMaximumIdleTimeMilliseconds() {
        return this._MaximumIdleTimeMilliseconds;
    }

    public boolean isMaximumIdleTimeMillisecondsSet() {
        return this._isSet(24);
    }

    public void setMaximumIdleTimeMilliseconds(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MaximumIdleTimeMilliseconds", (long)l, (long)0L, (long)Long.MAX_VALUE);
        this._MaximumIdleTimeMilliseconds = l;
    }

    public int getIdleTimeMaximum() {
        return this._IdleTimeMaximum;
    }

    public boolean isIdleTimeMaximumSet() {
        return this._isSet(25);
    }

    public void setIdleTimeMaximum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"IdleTimeMaximum", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._IdleTimeMaximum;
        this._IdleTimeMaximum = n;
        this._postSet(25, n2, n);
    }

    public long getScanUnitMilliseconds() {
        return this._ScanUnitMilliseconds;
    }

    public boolean isScanUnitMillisecondsSet() {
        return this._isSet(26);
    }

    public void setScanUnitMilliseconds(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ScanUnitMilliseconds", (long)l, (long)0L, (long)Long.MAX_VALUE);
        this._ScanUnitMilliseconds = l;
    }

    public int getTransactionTimeoutSeconds() {
        return this._TransactionTimeoutSeconds;
    }

    public boolean isTransactionTimeoutSecondsSet() {
        return this._isSet(27);
    }

    public void setTransactionTimeoutSeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"TransactionTimeoutSeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        this._TransactionTimeoutSeconds = n;
    }

    public int getTransactionTimeout() {
        return this._TransactionTimeout;
    }

    public boolean isTransactionTimeoutSet() {
        return this._isSet(28);
    }

    public void setTransactionTimeout(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"TransactionTimeout", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._TransactionTimeout;
        this._TransactionTimeout = n;
        this._postSet(28, n2, n);
    }

    public boolean isAsyncDisabled() {
        return this._AsyncDisabled;
    }

    public boolean isAsyncDisabledSet() {
        return this._isSet(29);
    }

    public void setAsyncDisabled(boolean bl) throws InvalidAttributeValueException {
        this._AsyncDisabled = bl;
    }

    public boolean isAsyncEnabled() {
        return this._AsyncEnabled;
    }

    public boolean isAsyncEnabledSet() {
        return this._isSet(30);
    }

    public void setAsyncEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._AsyncEnabled;
        this._AsyncEnabled = bl;
        this._postSet(30, bl2, bl);
    }

    public boolean isStarted() {
        return this._Started;
    }

    public boolean isStartedSet() {
        return this._isSet(31);
    }

    public void setStarted(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._Started;
        this._Started = bl;
        this._postSet(31, bl2, bl);
    }

    public int getBatchSize() {
        return this._BatchSize;
    }

    public boolean isBatchSizeSet() {
        return this._isSet(32);
    }

    public void setBatchSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"BatchSize", (int)n, (int)0);
        int n2 = this._BatchSize;
        this._BatchSize = n;
        this._postSet(32, n2, n);
    }

    public long getBatchInterval() {
        return this._BatchInterval;
    }

    public boolean isBatchIntervalSet() {
        return this._isSet(33);
    }

    public void setBatchInterval(long l) throws InvalidAttributeValueException {
        long l2 = this._BatchInterval;
        this._BatchInterval = l;
        this._postSet(33, l2, l);
    }

    public boolean getPreserveMsgProperty() {
        return this._PreserveMsgProperty;
    }

    public boolean isPreserveMsgPropertySet() {
        return this._isSet(34);
    }

    public void setPreserveMsgProperty(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._PreserveMsgProperty;
        this._PreserveMsgProperty = bl;
        this._postSet(34, bl2, bl);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        BridgeLegalHelper.validateBridgeDestinations(this);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 33;
        }
        try {
            switch (n) {
                case 33: {
                    this._BatchInterval = -1L;
                    if (bl) break;
                }
                case 32: {
                    this._BatchSize = 10;
                    if (bl) break;
                }
                case 12: {
                    this._ForwardingPolicy = "Automatic";
                    if (bl) break;
                }
                case 25: {
                    this._IdleTimeMaximum = 60;
                    if (bl) break;
                }
                case 24: {
                    this._MaximumIdleTimeMilliseconds = 1800000L;
                    if (bl) break;
                }
                case 34: {
                    this._PreserveMsgProperty = false;
                    if (bl) break;
                }
                case 14: {
                    this._QualityOfService = "Exactly-once";
                    if (bl) break;
                }
                case 21: {
                    this._ReconnectDelayIncrease = 5;
                    if (bl) break;
                }
                case 20: {
                    this._ReconnectDelayIncrement = 5000L;
                    if (bl) break;
                }
                case 18: {
                    this._ReconnectDelayInitialMilliseconds = 15000L;
                    if (bl) break;
                }
                case 23: {
                    this._ReconnectDelayMaximum = 60;
                    if (bl) break;
                }
                case 22: {
                    this._ReconnectDelayMaximumMilliseconds = 50000L;
                    if (bl) break;
                }
                case 19: {
                    this._ReconnectDelayMinimum = 15;
                    if (bl) break;
                }
                case 26: {
                    this._ScanUnitMilliseconds = 5000L;
                    if (bl) break;
                }
                case 13: {
                    this._ScheduleTime = null;
                    if (bl) break;
                }
                case 11: {
                    this._Selector = null;
                    if (bl) break;
                }
                case 9: {
                    this._SourceDestination = null;
                    if (bl) break;
                }
                case 10: {
                    this._TargetDestination = null;
                    if (bl) break;
                }
                case 28: {
                    this._TransactionTimeout = 30;
                    if (bl) break;
                }
                case 27: {
                    this._TransactionTimeoutSeconds = 30;
                    if (bl) break;
                }
                case 29: {
                    this._AsyncDisabled = false;
                    if (bl) break;
                }
                case 30: {
                    this._AsyncEnabled = true;
                    if (bl) break;
                }
                case 16: {
                    this._DurabilityDisabled = false;
                    if (bl) break;
                }
                case 17: {
                    this._DurabilityEnabled = true;
                    if (bl) break;
                }
                case 15: {
                    this._QOSDegradationAllowed = false;
                    if (bl) break;
                }
                case 31: {
                    this._Started = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "MessagingBridge";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AsyncDisabled")) {
            boolean bl = this._AsyncDisabled;
            this._AsyncDisabled = (Boolean)object;
            this._postSet(29, bl, this._AsyncDisabled);
            return;
        }
        if (string.equals("AsyncEnabled")) {
            boolean bl = this._AsyncEnabled;
            this._AsyncEnabled = (Boolean)object;
            this._postSet(30, bl, this._AsyncEnabled);
            return;
        }
        if (string.equals("BatchInterval")) {
            long l = this._BatchInterval;
            this._BatchInterval = (Long)object;
            this._postSet(33, l, this._BatchInterval);
            return;
        }
        if (string.equals("BatchSize")) {
            int n = this._BatchSize;
            this._BatchSize = (Integer)object;
            this._postSet(32, n, this._BatchSize);
            return;
        }
        if (string.equals("DurabilityDisabled")) {
            boolean bl = this._DurabilityDisabled;
            this._DurabilityDisabled = (Boolean)object;
            this._postSet(16, bl, this._DurabilityDisabled);
            return;
        }
        if (string.equals("DurabilityEnabled")) {
            boolean bl = this._DurabilityEnabled;
            this._DurabilityEnabled = (Boolean)object;
            this._postSet(17, bl, this._DurabilityEnabled);
            return;
        }
        if (string.equals("ForwardingPolicy")) {
            String string2 = this._ForwardingPolicy;
            this._ForwardingPolicy = (String)object;
            this._postSet(12, string2, this._ForwardingPolicy);
            return;
        }
        if (string.equals("IdleTimeMaximum")) {
            int n = this._IdleTimeMaximum;
            this._IdleTimeMaximum = (Integer)object;
            this._postSet(25, n, this._IdleTimeMaximum);
            return;
        }
        if (string.equals("MaximumIdleTimeMilliseconds")) {
            long l = this._MaximumIdleTimeMilliseconds;
            this._MaximumIdleTimeMilliseconds = (Long)object;
            this._postSet(24, l, this._MaximumIdleTimeMilliseconds);
            return;
        }
        if (string.equals("PreserveMsgProperty")) {
            boolean bl = this._PreserveMsgProperty;
            this._PreserveMsgProperty = (Boolean)object;
            this._postSet(34, bl, this._PreserveMsgProperty);
            return;
        }
        if (string.equals("QOSDegradationAllowed")) {
            boolean bl = this._QOSDegradationAllowed;
            this._QOSDegradationAllowed = (Boolean)object;
            this._postSet(15, bl, this._QOSDegradationAllowed);
            return;
        }
        if (string.equals("QualityOfService")) {
            String string3 = this._QualityOfService;
            this._QualityOfService = (String)object;
            this._postSet(14, string3, this._QualityOfService);
            return;
        }
        if (string.equals("ReconnectDelayIncrease")) {
            int n = this._ReconnectDelayIncrease;
            this._ReconnectDelayIncrease = (Integer)object;
            this._postSet(21, n, this._ReconnectDelayIncrease);
            return;
        }
        if (string.equals("ReconnectDelayIncrement")) {
            long l = this._ReconnectDelayIncrement;
            this._ReconnectDelayIncrement = (Long)object;
            this._postSet(20, l, this._ReconnectDelayIncrement);
            return;
        }
        if (string.equals("ReconnectDelayInitialMilliseconds")) {
            long l = this._ReconnectDelayInitialMilliseconds;
            this._ReconnectDelayInitialMilliseconds = (Long)object;
            this._postSet(18, l, this._ReconnectDelayInitialMilliseconds);
            return;
        }
        if (string.equals("ReconnectDelayMaximum")) {
            int n = this._ReconnectDelayMaximum;
            this._ReconnectDelayMaximum = (Integer)object;
            this._postSet(23, n, this._ReconnectDelayMaximum);
            return;
        }
        if (string.equals("ReconnectDelayMaximumMilliseconds")) {
            long l = this._ReconnectDelayMaximumMilliseconds;
            this._ReconnectDelayMaximumMilliseconds = (Long)object;
            this._postSet(22, l, this._ReconnectDelayMaximumMilliseconds);
            return;
        }
        if (string.equals("ReconnectDelayMinimum")) {
            int n = this._ReconnectDelayMinimum;
            this._ReconnectDelayMinimum = (Integer)object;
            this._postSet(19, n, this._ReconnectDelayMinimum);
            return;
        }
        if (string.equals("ScanUnitMilliseconds")) {
            long l = this._ScanUnitMilliseconds;
            this._ScanUnitMilliseconds = (Long)object;
            this._postSet(26, l, this._ScanUnitMilliseconds);
            return;
        }
        if (string.equals("ScheduleTime")) {
            String string4 = this._ScheduleTime;
            this._ScheduleTime = (String)object;
            this._postSet(13, string4, this._ScheduleTime);
            return;
        }
        if (string.equals("Selector")) {
            String string5 = this._Selector;
            this._Selector = (String)object;
            this._postSet(11, string5, this._Selector);
            return;
        }
        if (string.equals("SourceDestination")) {
            BridgeDestinationCommonMBean bridgeDestinationCommonMBean = this._SourceDestination;
            this._SourceDestination = (BridgeDestinationCommonMBean)object;
            this._postSet(9, bridgeDestinationCommonMBean, this._SourceDestination);
            return;
        }
        if (string.equals("Started")) {
            boolean bl = this._Started;
            this._Started = (Boolean)object;
            this._postSet(31, bl, this._Started);
            return;
        }
        if (string.equals("TargetDestination")) {
            BridgeDestinationCommonMBean bridgeDestinationCommonMBean = this._TargetDestination;
            this._TargetDestination = (BridgeDestinationCommonMBean)object;
            this._postSet(10, bridgeDestinationCommonMBean, this._TargetDestination);
            return;
        }
        if (string.equals("TransactionTimeout")) {
            int n = this._TransactionTimeout;
            this._TransactionTimeout = (Integer)object;
            this._postSet(28, n, this._TransactionTimeout);
            return;
        }
        if (string.equals("TransactionTimeoutSeconds")) {
            int n = this._TransactionTimeoutSeconds;
            this._TransactionTimeoutSeconds = (Integer)object;
            this._postSet(27, n, this._TransactionTimeoutSeconds);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AsyncDisabled")) {
            return new Boolean(this._AsyncDisabled);
        }
        if (string.equals("AsyncEnabled")) {
            return new Boolean(this._AsyncEnabled);
        }
        if (string.equals("BatchInterval")) {
            return new Long(this._BatchInterval);
        }
        if (string.equals("BatchSize")) {
            return new Integer(this._BatchSize);
        }
        if (string.equals("DurabilityDisabled")) {
            return new Boolean(this._DurabilityDisabled);
        }
        if (string.equals("DurabilityEnabled")) {
            return new Boolean(this._DurabilityEnabled);
        }
        if (string.equals("ForwardingPolicy")) {
            return this._ForwardingPolicy;
        }
        if (string.equals("IdleTimeMaximum")) {
            return new Integer(this._IdleTimeMaximum);
        }
        if (string.equals("MaximumIdleTimeMilliseconds")) {
            return new Long(this._MaximumIdleTimeMilliseconds);
        }
        if (string.equals("PreserveMsgProperty")) {
            return new Boolean(this._PreserveMsgProperty);
        }
        if (string.equals("QOSDegradationAllowed")) {
            return new Boolean(this._QOSDegradationAllowed);
        }
        if (string.equals("QualityOfService")) {
            return this._QualityOfService;
        }
        if (string.equals("ReconnectDelayIncrease")) {
            return new Integer(this._ReconnectDelayIncrease);
        }
        if (string.equals("ReconnectDelayIncrement")) {
            return new Long(this._ReconnectDelayIncrement);
        }
        if (string.equals("ReconnectDelayInitialMilliseconds")) {
            return new Long(this._ReconnectDelayInitialMilliseconds);
        }
        if (string.equals("ReconnectDelayMaximum")) {
            return new Integer(this._ReconnectDelayMaximum);
        }
        if (string.equals("ReconnectDelayMaximumMilliseconds")) {
            return new Long(this._ReconnectDelayMaximumMilliseconds);
        }
        if (string.equals("ReconnectDelayMinimum")) {
            return new Integer(this._ReconnectDelayMinimum);
        }
        if (string.equals("ScanUnitMilliseconds")) {
            return new Long(this._ScanUnitMilliseconds);
        }
        if (string.equals("ScheduleTime")) {
            return this._ScheduleTime;
        }
        if (string.equals("Selector")) {
            return this._Selector;
        }
        if (string.equals("SourceDestination")) {
            return this._SourceDestination;
        }
        if (string.equals("Started")) {
            return new Boolean(this._Started);
        }
        if (string.equals("TargetDestination")) {
            return this._TargetDestination;
        }
        if (string.equals("TransactionTimeout")) {
            return new Integer(this._TransactionTimeout);
        }
        if (string.equals("TransactionTimeoutSeconds")) {
            return new Integer(this._TransactionTimeoutSeconds);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 14: {
                    if (string.equals("batch-interval")) {
                        return 33;
                    }
                    if (!string.equals("async-disabled")) break;
                    return 29;
                }
                case 10: {
                    if (!string.equals("batch-size")) break;
                    return 32;
                }
                case 17: {
                    if (string.equals("forwarding-policy")) {
                        return 12;
                    }
                    if (!string.equals("idle-time-maximum")) break;
                    return 25;
                }
                case 30: {
                    if (!string.equals("maximum-idle-time-milliseconds")) break;
                    return 24;
                }
                case 21: {
                    if (!string.equals("preserve-msg-property")) break;
                    return 34;
                }
                case 18: {
                    if (string.equals("quality-of-service")) {
                        return 14;
                    }
                    if (string.equals("source-destination")) {
                        return 9;
                    }
                    if (string.equals("target-destination")) {
                        return 10;
                    }
                    if (!string.equals("durability-enabled")) break;
                    return 17;
                }
                case 24: {
                    if (!string.equals("reconnect-delay-increase")) break;
                    return 21;
                }
                case 25: {
                    if (!string.equals("reconnect-delay-increment")) break;
                    return 20;
                }
                case 36: {
                    if (string.equals("reconnect-delay-initial-milliseconds")) {
                        return 18;
                    }
                    if (!string.equals("reconnect-delay-maximum-milliseconds")) break;
                    return 22;
                }
                case 23: {
                    if (string.equals("reconnect-delay-maximum")) {
                        return 23;
                    }
                    if (string.equals("reconnect-delay-minimum")) {
                        return 19;
                    }
                    if (!string.equals("qos-degradation-allowed")) break;
                    return 15;
                }
                case 22: {
                    if (!string.equals("scan-unit-milliseconds")) break;
                    return 26;
                }
                case 13: {
                    if (string.equals("schedule-time")) {
                        return 13;
                    }
                    if (!string.equals("async-enabled")) break;
                    return 30;
                }
                case 8: {
                    if (!string.equals("selector")) break;
                    return 11;
                }
                case 19: {
                    if (string.equals("transaction-timeout")) {
                        return 28;
                    }
                    if (!string.equals("durability-disabled")) break;
                    return 16;
                }
                case 27: {
                    if (!string.equals("transaction-timeout-seconds")) break;
                    return 27;
                }
                case 7: {
                    if (!string.equals("started")) break;
                    return 31;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 33: {
                    return "batch-interval";
                }
                case 32: {
                    return "batch-size";
                }
                case 12: {
                    return "forwarding-policy";
                }
                case 25: {
                    return "idle-time-maximum";
                }
                case 24: {
                    return "maximum-idle-time-milliseconds";
                }
                case 34: {
                    return "preserve-msg-property";
                }
                case 14: {
                    return "quality-of-service";
                }
                case 21: {
                    return "reconnect-delay-increase";
                }
                case 20: {
                    return "reconnect-delay-increment";
                }
                case 18: {
                    return "reconnect-delay-initial-milliseconds";
                }
                case 23: {
                    return "reconnect-delay-maximum";
                }
                case 22: {
                    return "reconnect-delay-maximum-milliseconds";
                }
                case 19: {
                    return "reconnect-delay-minimum";
                }
                case 26: {
                    return "scan-unit-milliseconds";
                }
                case 13: {
                    return "schedule-time";
                }
                case 11: {
                    return "selector";
                }
                case 9: {
                    return "source-destination";
                }
                case 10: {
                    return "target-destination";
                }
                case 28: {
                    return "transaction-timeout";
                }
                case 27: {
                    return "transaction-timeout-seconds";
                }
                case 29: {
                    return "async-disabled";
                }
                case 30: {
                    return "async-enabled";
                }
                case 16: {
                    return "durability-disabled";
                }
                case 17: {
                    return "durability-enabled";
                }
                case 15: {
                    return "qos-degradation-allowed";
                }
                case 31: {
                    return "started";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private MessagingBridgeMBeanImpl bean;

        protected Helper(MessagingBridgeMBeanImpl messagingBridgeMBeanImpl) {
            super(messagingBridgeMBeanImpl);
            this.bean = messagingBridgeMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 33: {
                    return "BatchInterval";
                }
                case 32: {
                    return "BatchSize";
                }
                case 12: {
                    return "ForwardingPolicy";
                }
                case 25: {
                    return "IdleTimeMaximum";
                }
                case 24: {
                    return "MaximumIdleTimeMilliseconds";
                }
                case 34: {
                    return "PreserveMsgProperty";
                }
                case 14: {
                    return "QualityOfService";
                }
                case 21: {
                    return "ReconnectDelayIncrease";
                }
                case 20: {
                    return "ReconnectDelayIncrement";
                }
                case 18: {
                    return "ReconnectDelayInitialMilliseconds";
                }
                case 23: {
                    return "ReconnectDelayMaximum";
                }
                case 22: {
                    return "ReconnectDelayMaximumMilliseconds";
                }
                case 19: {
                    return "ReconnectDelayMinimum";
                }
                case 26: {
                    return "ScanUnitMilliseconds";
                }
                case 13: {
                    return "ScheduleTime";
                }
                case 11: {
                    return "Selector";
                }
                case 9: {
                    return "SourceDestination";
                }
                case 10: {
                    return "TargetDestination";
                }
                case 28: {
                    return "TransactionTimeout";
                }
                case 27: {
                    return "TransactionTimeoutSeconds";
                }
                case 29: {
                    return "AsyncDisabled";
                }
                case 30: {
                    return "AsyncEnabled";
                }
                case 16: {
                    return "DurabilityDisabled";
                }
                case 17: {
                    return "DurabilityEnabled";
                }
                case 15: {
                    return "QOSDegradationAllowed";
                }
                case 31: {
                    return "Started";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BatchInterval")) {
                return 33;
            }
            if (string.equals("BatchSize")) {
                return 32;
            }
            if (string.equals("ForwardingPolicy")) {
                return 12;
            }
            if (string.equals("IdleTimeMaximum")) {
                return 25;
            }
            if (string.equals("MaximumIdleTimeMilliseconds")) {
                return 24;
            }
            if (string.equals("PreserveMsgProperty")) {
                return 34;
            }
            if (string.equals("QualityOfService")) {
                return 14;
            }
            if (string.equals("ReconnectDelayIncrease")) {
                return 21;
            }
            if (string.equals("ReconnectDelayIncrement")) {
                return 20;
            }
            if (string.equals("ReconnectDelayInitialMilliseconds")) {
                return 18;
            }
            if (string.equals("ReconnectDelayMaximum")) {
                return 23;
            }
            if (string.equals("ReconnectDelayMaximumMilliseconds")) {
                return 22;
            }
            if (string.equals("ReconnectDelayMinimum")) {
                return 19;
            }
            if (string.equals("ScanUnitMilliseconds")) {
                return 26;
            }
            if (string.equals("ScheduleTime")) {
                return 13;
            }
            if (string.equals("Selector")) {
                return 11;
            }
            if (string.equals("SourceDestination")) {
                return 9;
            }
            if (string.equals("TargetDestination")) {
                return 10;
            }
            if (string.equals("TransactionTimeout")) {
                return 28;
            }
            if (string.equals("TransactionTimeoutSeconds")) {
                return 27;
            }
            if (string.equals("AsyncDisabled")) {
                return 29;
            }
            if (string.equals("AsyncEnabled")) {
                return 30;
            }
            if (string.equals("DurabilityDisabled")) {
                return 16;
            }
            if (string.equals("DurabilityEnabled")) {
                return 17;
            }
            if (string.equals("QOSDegradationAllowed")) {
                return 15;
            }
            if (string.equals("Started")) {
                return 31;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBatchIntervalSet()) {
                    stringBuffer.append("BatchInterval");
                    stringBuffer.append(String.valueOf(this.bean.getBatchInterval()));
                }
                if (this.bean.isBatchSizeSet()) {
                    stringBuffer.append("BatchSize");
                    stringBuffer.append(String.valueOf(this.bean.getBatchSize()));
                }
                if (this.bean.isForwardingPolicySet()) {
                    stringBuffer.append("ForwardingPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getForwardingPolicy()));
                }
                if (this.bean.isIdleTimeMaximumSet()) {
                    stringBuffer.append("IdleTimeMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getIdleTimeMaximum()));
                }
                if (this.bean.isMaximumIdleTimeMillisecondsSet()) {
                    stringBuffer.append("MaximumIdleTimeMilliseconds");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumIdleTimeMilliseconds()));
                }
                if (this.bean.isPreserveMsgPropertySet()) {
                    stringBuffer.append("PreserveMsgProperty");
                    stringBuffer.append(String.valueOf(this.bean.getPreserveMsgProperty()));
                }
                if (this.bean.isQualityOfServiceSet()) {
                    stringBuffer.append("QualityOfService");
                    stringBuffer.append(String.valueOf(this.bean.getQualityOfService()));
                }
                if (this.bean.isReconnectDelayIncreaseSet()) {
                    stringBuffer.append("ReconnectDelayIncrease");
                    stringBuffer.append(String.valueOf(this.bean.getReconnectDelayIncrease()));
                }
                if (this.bean.isReconnectDelayIncrementSet()) {
                    stringBuffer.append("ReconnectDelayIncrement");
                    stringBuffer.append(String.valueOf(this.bean.getReconnectDelayIncrement()));
                }
                if (this.bean.isReconnectDelayInitialMillisecondsSet()) {
                    stringBuffer.append("ReconnectDelayInitialMilliseconds");
                    stringBuffer.append(String.valueOf(this.bean.getReconnectDelayInitialMilliseconds()));
                }
                if (this.bean.isReconnectDelayMaximumSet()) {
                    stringBuffer.append("ReconnectDelayMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getReconnectDelayMaximum()));
                }
                if (this.bean.isReconnectDelayMaximumMillisecondsSet()) {
                    stringBuffer.append("ReconnectDelayMaximumMilliseconds");
                    stringBuffer.append(String.valueOf(this.bean.getReconnectDelayMaximumMilliseconds()));
                }
                if (this.bean.isReconnectDelayMinimumSet()) {
                    stringBuffer.append("ReconnectDelayMinimum");
                    stringBuffer.append(String.valueOf(this.bean.getReconnectDelayMinimum()));
                }
                if (this.bean.isScanUnitMillisecondsSet()) {
                    stringBuffer.append("ScanUnitMilliseconds");
                    stringBuffer.append(String.valueOf(this.bean.getScanUnitMilliseconds()));
                }
                if (this.bean.isScheduleTimeSet()) {
                    stringBuffer.append("ScheduleTime");
                    stringBuffer.append(String.valueOf(this.bean.getScheduleTime()));
                }
                if (this.bean.isSelectorSet()) {
                    stringBuffer.append("Selector");
                    stringBuffer.append(String.valueOf(this.bean.getSelector()));
                }
                if (this.bean.isSourceDestinationSet()) {
                    stringBuffer.append("SourceDestination");
                    stringBuffer.append(String.valueOf(this.bean.getSourceDestination()));
                }
                if (this.bean.isTargetDestinationSet()) {
                    stringBuffer.append("TargetDestination");
                    stringBuffer.append(String.valueOf(this.bean.getTargetDestination()));
                }
                if (this.bean.isTransactionTimeoutSet()) {
                    stringBuffer.append("TransactionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getTransactionTimeout()));
                }
                if (this.bean.isTransactionTimeoutSecondsSet()) {
                    stringBuffer.append("TransactionTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getTransactionTimeoutSeconds()));
                }
                if (this.bean.isAsyncDisabledSet()) {
                    stringBuffer.append("AsyncDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isAsyncDisabled()));
                }
                if (this.bean.isAsyncEnabledSet()) {
                    stringBuffer.append("AsyncEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isAsyncEnabled()));
                }
                if (this.bean.isDurabilityDisabledSet()) {
                    stringBuffer.append("DurabilityDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isDurabilityDisabled()));
                }
                if (this.bean.isDurabilityEnabledSet()) {
                    stringBuffer.append("DurabilityEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDurabilityEnabled()));
                }
                if (this.bean.isQOSDegradationAllowedSet()) {
                    stringBuffer.append("QOSDegradationAllowed");
                    stringBuffer.append(String.valueOf(this.bean.isQOSDegradationAllowed()));
                }
                if (this.bean.isStartedSet()) {
                    stringBuffer.append("Started");
                    stringBuffer.append(String.valueOf(this.bean.isStarted()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                MessagingBridgeMBeanImpl messagingBridgeMBeanImpl = (MessagingBridgeMBeanImpl)abstractDescriptorBean;
                this.computeDiff("BatchInterval", this.bean.getBatchInterval(), messagingBridgeMBeanImpl.getBatchInterval(), true);
                this.computeDiff("BatchSize", this.bean.getBatchSize(), messagingBridgeMBeanImpl.getBatchSize(), true);
                this.computeDiff("IdleTimeMaximum", this.bean.getIdleTimeMaximum(), messagingBridgeMBeanImpl.getIdleTimeMaximum(), true);
                this.computeDiff("PreserveMsgProperty", this.bean.getPreserveMsgProperty(), messagingBridgeMBeanImpl.getPreserveMsgProperty(), true);
                this.computeDiff("QualityOfService", this.bean.getQualityOfService(), messagingBridgeMBeanImpl.getQualityOfService(), false);
                this.computeDiff("ReconnectDelayIncrease", this.bean.getReconnectDelayIncrease(), messagingBridgeMBeanImpl.getReconnectDelayIncrease(), true);
                this.computeDiff("ReconnectDelayMaximum", this.bean.getReconnectDelayMaximum(), messagingBridgeMBeanImpl.getReconnectDelayMaximum(), true);
                this.computeDiff("ReconnectDelayMinimum", this.bean.getReconnectDelayMinimum(), messagingBridgeMBeanImpl.getReconnectDelayMinimum(), true);
                this.computeDiff("Selector", this.bean.getSelector(), messagingBridgeMBeanImpl.getSelector(), false);
                this.computeDiff("SourceDestination", this.bean.getSourceDestination(), messagingBridgeMBeanImpl.getSourceDestination(), false);
                this.computeDiff("TargetDestination", this.bean.getTargetDestination(), messagingBridgeMBeanImpl.getTargetDestination(), false);
                this.computeDiff("TransactionTimeout", this.bean.getTransactionTimeout(), messagingBridgeMBeanImpl.getTransactionTimeout(), true);
                this.computeDiff("AsyncEnabled", this.bean.isAsyncEnabled(), messagingBridgeMBeanImpl.isAsyncEnabled(), false);
                this.computeDiff("DurabilityEnabled", this.bean.isDurabilityEnabled(), messagingBridgeMBeanImpl.isDurabilityEnabled(), false);
                this.computeDiff("QOSDegradationAllowed", this.bean.isQOSDegradationAllowed(), messagingBridgeMBeanImpl.isQOSDegradationAllowed(), false);
                this.computeDiff("Started", this.bean.isStarted(), messagingBridgeMBeanImpl.isStarted(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                MessagingBridgeMBeanImpl messagingBridgeMBeanImpl = (MessagingBridgeMBeanImpl)beanUpdateEvent.getSourceBean();
                MessagingBridgeMBeanImpl messagingBridgeMBeanImpl2 = (MessagingBridgeMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BatchInterval")) {
                    messagingBridgeMBeanImpl.setBatchInterval(messagingBridgeMBeanImpl2.getBatchInterval());
                    messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                } else if (string.equals("BatchSize")) {
                    messagingBridgeMBeanImpl.setBatchSize(messagingBridgeMBeanImpl2.getBatchSize());
                    messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                } else if (!string.equals("ForwardingPolicy")) {
                    if (string.equals("IdleTimeMaximum")) {
                        messagingBridgeMBeanImpl.setIdleTimeMaximum(messagingBridgeMBeanImpl2.getIdleTimeMaximum());
                        messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                    } else if (!string.equals("MaximumIdleTimeMilliseconds")) {
                        if (string.equals("PreserveMsgProperty")) {
                            messagingBridgeMBeanImpl.setPreserveMsgProperty(messagingBridgeMBeanImpl2.getPreserveMsgProperty());
                            messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                        } else if (string.equals("QualityOfService")) {
                            messagingBridgeMBeanImpl.setQualityOfService(messagingBridgeMBeanImpl2.getQualityOfService());
                            messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                        } else if (string.equals("ReconnectDelayIncrease")) {
                            messagingBridgeMBeanImpl.setReconnectDelayIncrease(messagingBridgeMBeanImpl2.getReconnectDelayIncrease());
                            messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                        } else if (!string.equals("ReconnectDelayIncrement") && !string.equals("ReconnectDelayInitialMilliseconds")) {
                            if (string.equals("ReconnectDelayMaximum")) {
                                messagingBridgeMBeanImpl.setReconnectDelayMaximum(messagingBridgeMBeanImpl2.getReconnectDelayMaximum());
                                messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                            } else if (!string.equals("ReconnectDelayMaximumMilliseconds")) {
                                if (string.equals("ReconnectDelayMinimum")) {
                                    messagingBridgeMBeanImpl.setReconnectDelayMinimum(messagingBridgeMBeanImpl2.getReconnectDelayMinimum());
                                    messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                                } else if (!string.equals("ScanUnitMilliseconds") && !string.equals("ScheduleTime")) {
                                    if (string.equals("Selector")) {
                                        messagingBridgeMBeanImpl.setSelector(messagingBridgeMBeanImpl2.getSelector());
                                        messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                                    } else if (string.equals("SourceDestination")) {
                                        messagingBridgeMBeanImpl.setSourceDestinationAsString(messagingBridgeMBeanImpl2.getSourceDestinationAsString());
                                        messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                                    } else if (string.equals("TargetDestination")) {
                                        messagingBridgeMBeanImpl.setTargetDestinationAsString(messagingBridgeMBeanImpl2.getTargetDestinationAsString());
                                        messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                                    } else if (string.equals("TransactionTimeout")) {
                                        messagingBridgeMBeanImpl.setTransactionTimeout(messagingBridgeMBeanImpl2.getTransactionTimeout());
                                        messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                                    } else if (!string.equals("TransactionTimeoutSeconds") && !string.equals("AsyncDisabled")) {
                                        if (string.equals("AsyncEnabled")) {
                                            messagingBridgeMBeanImpl.setAsyncEnabled(messagingBridgeMBeanImpl2.isAsyncEnabled());
                                            messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                                        } else if (!string.equals("DurabilityDisabled")) {
                                            if (string.equals("DurabilityEnabled")) {
                                                messagingBridgeMBeanImpl.setDurabilityEnabled(messagingBridgeMBeanImpl2.isDurabilityEnabled());
                                                messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                                            } else if (string.equals("QOSDegradationAllowed")) {
                                                messagingBridgeMBeanImpl.setQOSDegradationAllowed(messagingBridgeMBeanImpl2.isQOSDegradationAllowed());
                                                messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                                            } else if (string.equals("Started")) {
                                                messagingBridgeMBeanImpl.setStarted(messagingBridgeMBeanImpl2.isStarted());
                                                messagingBridgeMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                                            } else {
                                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                MessagingBridgeMBeanImpl messagingBridgeMBeanImpl = (MessagingBridgeMBeanImpl)abstractDescriptorBean;
                super.finishCopy(messagingBridgeMBeanImpl, bl, list);
                if ((list == null || !list.contains("BatchInterval")) && this.bean.isBatchIntervalSet()) {
                    messagingBridgeMBeanImpl.setBatchInterval(this.bean.getBatchInterval());
                }
                if ((list == null || !list.contains("BatchSize")) && this.bean.isBatchSizeSet()) {
                    messagingBridgeMBeanImpl.setBatchSize(this.bean.getBatchSize());
                }
                if ((list == null || !list.contains("IdleTimeMaximum")) && this.bean.isIdleTimeMaximumSet()) {
                    messagingBridgeMBeanImpl.setIdleTimeMaximum(this.bean.getIdleTimeMaximum());
                }
                if ((list == null || !list.contains("PreserveMsgProperty")) && this.bean.isPreserveMsgPropertySet()) {
                    messagingBridgeMBeanImpl.setPreserveMsgProperty(this.bean.getPreserveMsgProperty());
                }
                if ((list == null || !list.contains("QualityOfService")) && this.bean.isQualityOfServiceSet()) {
                    messagingBridgeMBeanImpl.setQualityOfService(this.bean.getQualityOfService());
                }
                if ((list == null || !list.contains("ReconnectDelayIncrease")) && this.bean.isReconnectDelayIncreaseSet()) {
                    messagingBridgeMBeanImpl.setReconnectDelayIncrease(this.bean.getReconnectDelayIncrease());
                }
                if ((list == null || !list.contains("ReconnectDelayMaximum")) && this.bean.isReconnectDelayMaximumSet()) {
                    messagingBridgeMBeanImpl.setReconnectDelayMaximum(this.bean.getReconnectDelayMaximum());
                }
                if ((list == null || !list.contains("ReconnectDelayMinimum")) && this.bean.isReconnectDelayMinimumSet()) {
                    messagingBridgeMBeanImpl.setReconnectDelayMinimum(this.bean.getReconnectDelayMinimum());
                }
                if ((list == null || !list.contains("Selector")) && this.bean.isSelectorSet()) {
                    messagingBridgeMBeanImpl.setSelector(this.bean.getSelector());
                }
                if ((list == null || !list.contains("SourceDestination")) && this.bean.isSourceDestinationSet()) {
                    messagingBridgeMBeanImpl._unSet(messagingBridgeMBeanImpl, 9);
                    messagingBridgeMBeanImpl.setSourceDestinationAsString(this.bean.getSourceDestinationAsString());
                }
                if ((list == null || !list.contains("TargetDestination")) && this.bean.isTargetDestinationSet()) {
                    messagingBridgeMBeanImpl._unSet(messagingBridgeMBeanImpl, 10);
                    messagingBridgeMBeanImpl.setTargetDestinationAsString(this.bean.getTargetDestinationAsString());
                }
                if ((list == null || !list.contains("TransactionTimeout")) && this.bean.isTransactionTimeoutSet()) {
                    messagingBridgeMBeanImpl.setTransactionTimeout(this.bean.getTransactionTimeout());
                }
                if ((list == null || !list.contains("AsyncEnabled")) && this.bean.isAsyncEnabledSet()) {
                    messagingBridgeMBeanImpl.setAsyncEnabled(this.bean.isAsyncEnabled());
                }
                if ((list == null || !list.contains("DurabilityEnabled")) && this.bean.isDurabilityEnabledSet()) {
                    messagingBridgeMBeanImpl.setDurabilityEnabled(this.bean.isDurabilityEnabled());
                }
                if ((list == null || !list.contains("QOSDegradationAllowed")) && this.bean.isQOSDegradationAllowedSet()) {
                    messagingBridgeMBeanImpl.setQOSDegradationAllowed(this.bean.isQOSDegradationAllowed());
                }
                if ((list == null || !list.contains("Started")) && this.bean.isStartedSet()) {
                    messagingBridgeMBeanImpl.setStarted(this.bean.isStarted());
                }
                return messagingBridgeMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getSourceDestination(), clazz, object);
            this.inferSubTree(this.bean.getTargetDestination(), clazz, object);
        }
    }
}

