/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.cluster.migration.MTCustomValidator;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerMBeanImpl;
import weblogic.management.configuration.SingletonServiceBaseMBeanImpl;
import weblogic.management.mbeans.custom.MigratableTarget;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class MigratableTargetMBeanImpl
extends SingletonServiceBaseMBeanImpl
implements MigratableTargetMBean,
Serializable {
    private ServerMBean[] _AllCandidateServers;
    private ClusterMBean _Cluster;
    private ServerMBean[] _ConstrainedCandidateServers;
    private ServerMBean _DestinationServer;
    private ServerMBean _HostingServer;
    private String _MigrationPolicy;
    private String _Name;
    private boolean _NonLocalPostAllowed;
    private int _NumberOfRestartAttempts;
    private String _PostScript;
    private boolean _PostScriptFailureFatal;
    private String _PreScript;
    private boolean _RestartOnFailure;
    private int _SecondsBetweenRestarts;
    private Set _ServerNames;
    private ServerMBean _UserPreferredServer;
    private MigratableTarget _customizer;
    private static SchemaHelper2 _schemaHelper;

    public MigratableTargetMBeanImpl() {
        try {
            this._customizer = new MigratableTarget(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public MigratableTargetMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new MigratableTarget(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ServerMBean[] getConstrainedCandidateServers() {
        return this._ConstrainedCandidateServers;
    }

    public String getConstrainedCandidateServersAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getConstrainedCandidateServers());
    }

    public ServerMBean getHostingServer() {
        return this._customizer.getHostingServer();
    }

    public String getHostingServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getHostingServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public Set getServerNames() {
        return this._customizer.getServerNames();
    }

    public boolean isConstrainedCandidateServersSet() {
        return this._isSet(12);
    }

    public boolean isHostingServerSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isServerNamesSet() {
        return this._isSet(11);
    }

    public void setConstrainedCandidateServersAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean[] serverMBeanArray = this._ConstrainedCandidateServers;
            this._initializeProperty(12);
            this._postSet(12, serverMBeanArray, this._ConstrainedCandidateServers);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._ConstrainedCandidateServers);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, ServerMBean.class, new ReferenceManager.Resolver(this, 12){

                    public void resolveReference(Object object) {
                        try {
                            MigratableTargetMBeanImpl.this.addConstrainedCandidateServer((ServerMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (ServerMBean serverMBean : this._ConstrainedCandidateServers) {
                    if (!string2.equals(serverMBean.getName())) continue;
                    try {
                        this.removeConstrainedCandidateServer(serverMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setHostingServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._HostingServer;
            this._initializeProperty(7);
            this._postSet(7, serverMBean, this._HostingServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 7){

                public void resolveReference(Object object) {
                    try {
                        MigratableTargetMBeanImpl.this.setHostingServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setServerNames(Set set) throws InvalidAttributeValueException {
        this._ServerNames = set;
    }

    public void setConstrainedCandidateServers(ServerMBean[] serverMBeanArray) throws InvalidAttributeValueException {
        serverMBeanArray = serverMBeanArray == null ? new ServerMBeanImpl[]{} : serverMBeanArray;
        serverMBeanArray = (ServerMBean[])this._getHelper()._cleanAndValidateArray((Object)serverMBeanArray, ServerMBean.class);
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (serverMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 12, (AbstractDescriptorBean)serverMBeanArray[i]){

                protected Object getPropertyValue() {
                    return MigratableTargetMBeanImpl.this.getConstrainedCandidateServers();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBeanArray[i], resolvedReference);
        }
        ServerMBean[] serverMBeanArray2 = this._ConstrainedCandidateServers;
        this._ConstrainedCandidateServers = serverMBeanArray;
        this._postSet(12, serverMBeanArray2, serverMBeanArray);
    }

    public void setHostingServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 7, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return MigratableTargetMBeanImpl.this.getHostingServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this._HostingServer;
        this._HostingServer = serverMBean;
        this._postSet(7, serverMBean2, serverMBean);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public boolean addConstrainedCandidateServer(ServerMBean serverMBean) throws InvalidAttributeValueException {
        this._getHelper()._ensureNonNull((Object)serverMBean);
        if (!((AbstractDescriptorBean)serverMBean).isChildProperty((DescriptorBean)this, 12)) {
            ServerMBean[] serverMBeanArray = this._isSet(12) ? (ServerMBean[])this._getHelper()._extendArray((Object)this.getConstrainedCandidateServers(), ServerMBean.class, (Object)serverMBean) : new ServerMBean[]{serverMBean};
            try {
                this.setConstrainedCandidateServers(serverMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public ServerMBean getUserPreferredServer() {
        return this._customizer.getUserPreferredServer();
    }

    public String getUserPreferredServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getUserPreferredServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isUserPreferredServerSet() {
        return this._isSet(8);
    }

    public void setUserPreferredServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._UserPreferredServer;
            this._initializeProperty(8);
            this._postSet(8, serverMBean, this._UserPreferredServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 8){

                public void resolveReference(Object object) {
                    try {
                        MigratableTargetMBeanImpl.this.setUserPreferredServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public boolean removeConstrainedCandidateServer(ServerMBean serverMBean) throws InvalidAttributeValueException {
        ServerMBean[] serverMBeanArray = this.getConstrainedCandidateServers();
        ServerMBean[] serverMBeanArray2 = (ServerMBean[])this._getHelper()._removeElement((Object)serverMBeanArray, ServerMBean.class, (Object)serverMBean);
        if (serverMBeanArray2.length != serverMBeanArray.length) {
            try {
                this.setConstrainedCandidateServers(serverMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setUserPreferredServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 8, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return MigratableTargetMBeanImpl.this.getUserPreferredServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this.getUserPreferredServer();
        this._customizer.setUserPreferredServer(serverMBean);
        this._postSet(8, serverMBean2, serverMBean);
    }

    public ClusterMBean getCluster() {
        return this._Cluster;
    }

    public String getClusterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getCluster();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isClusterSet() {
        return this._isSet(13);
    }

    public void setClusterAsString(String string) {
        if (string == null || string.length() == 0) {
            ClusterMBean clusterMBean = this._Cluster;
            this._initializeProperty(13);
            this._postSet(13, clusterMBean, this._Cluster);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ClusterMBean.class, new ReferenceManager.Resolver(this, 13){

                public void resolveReference(Object object) {
                    try {
                        MigratableTargetMBeanImpl.this.setCluster((ClusterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setCluster(ClusterMBean clusterMBean) {
        ClusterMBean clusterMBean2;
        if (clusterMBean != null) {
            clusterMBean2 = new ResolvedReference(this, 13, (AbstractDescriptorBean)clusterMBean){

                protected Object getPropertyValue() {
                    return MigratableTargetMBeanImpl.this.getCluster();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)clusterMBean, (ResolvedReference)clusterMBean2);
        }
        clusterMBean2 = this._Cluster;
        this._Cluster = clusterMBean;
        this._postSet(13, clusterMBean2, clusterMBean);
    }

    public void addAllCandidateServer(ServerMBean serverMBean) {
        this._getHelper()._ensureNonNull((Object)serverMBean);
        if (!((AbstractDescriptorBean)serverMBean).isChildProperty((DescriptorBean)this, 14)) {
            ServerMBean[] serverMBeanArray = (ServerMBean[])this._getHelper()._extendArray((Object)this.getAllCandidateServers(), ServerMBean.class, (Object)serverMBean);
            try {
                this.setAllCandidateServers(serverMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ServerMBean[] getAllCandidateServers() {
        return this._customizer.getAllCandidateServers();
    }

    public boolean isAllCandidateServersSet() {
        return this._isSet(14);
    }

    public void removeAllCandidateServer(ServerMBean serverMBean) {
        ServerMBean[] serverMBeanArray = this.getAllCandidateServers();
        ServerMBean[] serverMBeanArray2 = (ServerMBean[])this._getHelper()._removeElement((Object)serverMBeanArray, ServerMBean.class, (Object)serverMBean);
        if (serverMBeanArray2.length != serverMBeanArray.length) {
            try {
                this.setAllCandidateServers(serverMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setAllCandidateServers(ServerMBean[] serverMBeanArray) {
        serverMBeanArray = serverMBeanArray == null ? new ServerMBeanImpl[]{} : serverMBeanArray;
        this._AllCandidateServers = serverMBeanArray;
    }

    public boolean isManualActiveOn(ServerMBean serverMBean) {
        return this._customizer.isManualActiveOn(serverMBean);
    }

    public boolean isCandidate(ServerMBean serverMBean) {
        return this._customizer.isCandidate(serverMBean);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public ServerMBean getDestinationServer() {
        return this._DestinationServer;
    }

    public String getDestinationServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDestinationServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDestinationServerSet() {
        return this._isSet(15);
    }

    public void setDestinationServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._DestinationServer;
            this._initializeProperty(15);
            this._postSet(15, serverMBean, this._DestinationServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 15){

                public void resolveReference(Object object) {
                    try {
                        MigratableTargetMBeanImpl.this.setDestinationServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setDestinationServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 15, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return MigratableTargetMBeanImpl.this.getDestinationServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this._DestinationServer;
        this._DestinationServer = serverMBean;
        this._postSet(15, serverMBean2, serverMBean);
    }

    public String getMigrationPolicy() {
        return this._MigrationPolicy;
    }

    public boolean isMigrationPolicySet() {
        return this._isSet(16);
    }

    public void setMigrationPolicy(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"manual", "exactly-once", "failure-recovery"};
        string = LegalChecks.checkInEnum((String)"MigrationPolicy", (String)string, (String[])stringArray);
        MTCustomValidator.validateMigrationPolicy(this, string);
        String string2 = this._MigrationPolicy;
        this._MigrationPolicy = string;
        this._postSet(16, string2, string);
    }

    public String getPreScript() {
        return this._PreScript;
    }

    public boolean isPreScriptSet() {
        return this._isSet(17);
    }

    public void setPreScript(String string) {
        string = string == null ? null : string.trim();
        MTCustomValidator.validateScriptPath(string);
        String string2 = this._PreScript;
        this._PreScript = string;
        this._postSet(17, string2, string);
    }

    public String getPostScript() {
        return this._PostScript;
    }

    public boolean isPostScriptSet() {
        return this._isSet(18);
    }

    public void setPostScript(String string) {
        string = string == null ? null : string.trim();
        MTCustomValidator.validateScriptPath(string);
        String string2 = this._PostScript;
        this._PostScript = string;
        this._postSet(18, string2, string);
    }

    public boolean isPostScriptFailureFatal() {
        return this._PostScriptFailureFatal;
    }

    public boolean isPostScriptFailureFatalSet() {
        return this._isSet(19);
    }

    public void setPostScriptFailureFatal(boolean bl) {
        MTCustomValidator.validatePostScriptFailureFatal(this, bl);
        boolean bl2 = this._PostScriptFailureFatal;
        this._PostScriptFailureFatal = bl;
        this._postSet(19, bl2, bl);
    }

    public boolean isNonLocalPostAllowed() {
        return this._NonLocalPostAllowed;
    }

    public boolean isNonLocalPostAllowedSet() {
        return this._isSet(20);
    }

    public void setNonLocalPostAllowed(boolean bl) {
        boolean bl2 = this._NonLocalPostAllowed;
        this._NonLocalPostAllowed = bl;
        this._postSet(20, bl2, bl);
    }

    public boolean getRestartOnFailure() {
        return this._RestartOnFailure;
    }

    public boolean isRestartOnFailureSet() {
        return this._isSet(21);
    }

    public void setRestartOnFailure(boolean bl) {
        MTCustomValidator.validateRestartOnFailure(this, bl);
        boolean bl2 = this._RestartOnFailure;
        this._RestartOnFailure = bl;
        this._postSet(21, bl2, bl);
    }

    public int getSecondsBetweenRestarts() {
        return this._SecondsBetweenRestarts;
    }

    public boolean isSecondsBetweenRestartsSet() {
        return this._isSet(22);
    }

    public void setSecondsBetweenRestarts(int n) {
        MTCustomValidator.validateSecondsBetweenRestarts(this, n);
        int n2 = this._SecondsBetweenRestarts;
        this._SecondsBetweenRestarts = n;
        this._postSet(22, n2, n);
    }

    public int getNumberOfRestartAttempts() {
        return this._NumberOfRestartAttempts;
    }

    public boolean isNumberOfRestartAttemptsSet() {
        return this._isSet(23);
    }

    public void setNumberOfRestartAttempts(int n) {
        MTCustomValidator.validateNumberOfRestartAttempts(this, n);
        int n2 = this._NumberOfRestartAttempts;
        this._NumberOfRestartAttempts = n;
        this._postSet(23, n2, n);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        MTCustomValidator.validateMigratableTarget(this);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 14;
        }
        try {
            switch (n) {
                case 14: {
                    this._AllCandidateServers = new ServerMBean[0];
                    if (bl) break;
                }
                case 13: {
                    this._Cluster = null;
                    if (bl) break;
                }
                case 12: {
                    this._ConstrainedCandidateServers = new ServerMBean[0];
                    if (bl) break;
                }
                case 15: {
                    this._DestinationServer = null;
                    if (bl) break;
                }
                case 7: {
                    this._HostingServer = null;
                    if (bl) break;
                }
                case 16: {
                    this._MigrationPolicy = "manual";
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 23: {
                    this._NumberOfRestartAttempts = 6;
                    if (bl) break;
                }
                case 18: {
                    this._PostScript = null;
                    if (bl) break;
                }
                case 17: {
                    this._PreScript = null;
                    if (bl) break;
                }
                case 21: {
                    this._RestartOnFailure = false;
                    if (bl) break;
                }
                case 22: {
                    this._SecondsBetweenRestarts = 30;
                    if (bl) break;
                }
                case 11: {
                    this._ServerNames = null;
                    if (bl) break;
                }
                case 8: {
                    this._customizer.setUserPreferredServer(null);
                    if (bl) break;
                }
                case 20: {
                    this._NonLocalPostAllowed = false;
                    if (bl) break;
                }
                case 19: {
                    this._PostScriptFailureFatal = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "MigratableTarget";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AllCandidateServers")) {
            ServerMBean[] serverMBeanArray = this._AllCandidateServers;
            this._AllCandidateServers = (ServerMBean[])object;
            this._postSet(14, serverMBeanArray, this._AllCandidateServers);
            return;
        }
        if (string.equals("Cluster")) {
            ClusterMBean clusterMBean = this._Cluster;
            this._Cluster = (ClusterMBean)object;
            this._postSet(13, clusterMBean, this._Cluster);
            return;
        }
        if (string.equals("ConstrainedCandidateServers")) {
            ServerMBean[] serverMBeanArray = this._ConstrainedCandidateServers;
            this._ConstrainedCandidateServers = (ServerMBean[])object;
            this._postSet(12, serverMBeanArray, this._ConstrainedCandidateServers);
            return;
        }
        if (string.equals("DestinationServer")) {
            ServerMBean serverMBean = this._DestinationServer;
            this._DestinationServer = (ServerMBean)object;
            this._postSet(15, serverMBean, this._DestinationServer);
            return;
        }
        if (string.equals("HostingServer")) {
            ServerMBean serverMBean = this._HostingServer;
            this._HostingServer = (ServerMBean)object;
            this._postSet(7, serverMBean, this._HostingServer);
            return;
        }
        if (string.equals("MigrationPolicy")) {
            String string2 = this._MigrationPolicy;
            this._MigrationPolicy = (String)object;
            this._postSet(16, string2, this._MigrationPolicy);
            return;
        }
        if (string.equals("Name")) {
            String string3 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string3, this._Name);
            return;
        }
        if (string.equals("NonLocalPostAllowed")) {
            boolean bl = this._NonLocalPostAllowed;
            this._NonLocalPostAllowed = (Boolean)object;
            this._postSet(20, bl, this._NonLocalPostAllowed);
            return;
        }
        if (string.equals("NumberOfRestartAttempts")) {
            int n = this._NumberOfRestartAttempts;
            this._NumberOfRestartAttempts = (Integer)object;
            this._postSet(23, n, this._NumberOfRestartAttempts);
            return;
        }
        if (string.equals("PostScript")) {
            String string4 = this._PostScript;
            this._PostScript = (String)object;
            this._postSet(18, string4, this._PostScript);
            return;
        }
        if (string.equals("PostScriptFailureFatal")) {
            boolean bl = this._PostScriptFailureFatal;
            this._PostScriptFailureFatal = (Boolean)object;
            this._postSet(19, bl, this._PostScriptFailureFatal);
            return;
        }
        if (string.equals("PreScript")) {
            String string5 = this._PreScript;
            this._PreScript = (String)object;
            this._postSet(17, string5, this._PreScript);
            return;
        }
        if (string.equals("RestartOnFailure")) {
            boolean bl = this._RestartOnFailure;
            this._RestartOnFailure = (Boolean)object;
            this._postSet(21, bl, this._RestartOnFailure);
            return;
        }
        if (string.equals("SecondsBetweenRestarts")) {
            int n = this._SecondsBetweenRestarts;
            this._SecondsBetweenRestarts = (Integer)object;
            this._postSet(22, n, this._SecondsBetweenRestarts);
            return;
        }
        if (string.equals("ServerNames")) {
            Set set = this._ServerNames;
            this._ServerNames = (Set)object;
            this._postSet(11, set, this._ServerNames);
            return;
        }
        if (string.equals("UserPreferredServer")) {
            ServerMBean serverMBean = this._UserPreferredServer;
            this._UserPreferredServer = (ServerMBean)object;
            this._postSet(8, serverMBean, this._UserPreferredServer);
            return;
        }
        if (string.equals("customizer")) {
            MigratableTarget migratableTarget = this._customizer;
            this._customizer = (MigratableTarget)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AllCandidateServers")) {
            return this._AllCandidateServers;
        }
        if (string.equals("Cluster")) {
            return this._Cluster;
        }
        if (string.equals("ConstrainedCandidateServers")) {
            return this._ConstrainedCandidateServers;
        }
        if (string.equals("DestinationServer")) {
            return this._DestinationServer;
        }
        if (string.equals("HostingServer")) {
            return this._HostingServer;
        }
        if (string.equals("MigrationPolicy")) {
            return this._MigrationPolicy;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NonLocalPostAllowed")) {
            return new Boolean(this._NonLocalPostAllowed);
        }
        if (string.equals("NumberOfRestartAttempts")) {
            return new Integer(this._NumberOfRestartAttempts);
        }
        if (string.equals("PostScript")) {
            return this._PostScript;
        }
        if (string.equals("PostScriptFailureFatal")) {
            return new Boolean(this._PostScriptFailureFatal);
        }
        if (string.equals("PreScript")) {
            return this._PreScript;
        }
        if (string.equals("RestartOnFailure")) {
            return new Boolean(this._RestartOnFailure);
        }
        if (string.equals("SecondsBetweenRestarts")) {
            return new Integer(this._SecondsBetweenRestarts);
        }
        if (string.equals("ServerNames")) {
            return this._ServerNames;
        }
        if (string.equals("UserPreferredServer")) {
            return this._UserPreferredServer;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends SingletonServiceBaseMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (!string.equals("all-candidate-server")) break;
                    return 14;
                }
                case 7: {
                    if (!string.equals("cluster")) break;
                    return 13;
                }
                case 28: {
                    if (!string.equals("constrained-candidate-server")) break;
                    return 12;
                }
                case 18: {
                    if (string.equals("destination-server")) {
                        return 15;
                    }
                    if (!string.equals("restart-on-failure")) break;
                    return 21;
                }
                case 14: {
                    if (!string.equals("hosting-server")) break;
                    return 7;
                }
                case 16: {
                    if (!string.equals("migration-policy")) break;
                    return 16;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 26: {
                    if (!string.equals("number-of-restart-attempts")) break;
                    return 23;
                }
                case 11: {
                    if (!string.equals("post-script")) break;
                    return 18;
                }
                case 10: {
                    if (!string.equals("pre-script")) break;
                    return 17;
                }
                case 24: {
                    if (!string.equals("seconds-between-restarts")) break;
                    return 22;
                }
                case 12: {
                    if (!string.equals("server-names")) break;
                    return 11;
                }
                case 21: {
                    if (!string.equals("user-preferred-server")) break;
                    return 8;
                }
                case 22: {
                    if (!string.equals("non-local-post-allowed")) break;
                    return 20;
                }
                case 25: {
                    if (!string.equals("post-script-failure-fatal")) break;
                    return 19;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 14: {
                    return "all-candidate-server";
                }
                case 13: {
                    return "cluster";
                }
                case 12: {
                    return "constrained-candidate-server";
                }
                case 15: {
                    return "destination-server";
                }
                case 7: {
                    return "hosting-server";
                }
                case 16: {
                    return "migration-policy";
                }
                case 2: {
                    return "name";
                }
                case 23: {
                    return "number-of-restart-attempts";
                }
                case 18: {
                    return "post-script";
                }
                case 17: {
                    return "pre-script";
                }
                case 21: {
                    return "restart-on-failure";
                }
                case 22: {
                    return "seconds-between-restarts";
                }
                case 11: {
                    return "server-names";
                }
                case 8: {
                    return "user-preferred-server";
                }
                case 20: {
                    return "non-local-post-allowed";
                }
                case 19: {
                    return "post-script-failure-fatal";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends SingletonServiceBaseMBeanImpl.Helper {
        private MigratableTargetMBeanImpl bean;

        protected Helper(MigratableTargetMBeanImpl migratableTargetMBeanImpl) {
            super(migratableTargetMBeanImpl);
            this.bean = migratableTargetMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 14: {
                    return "AllCandidateServers";
                }
                case 13: {
                    return "Cluster";
                }
                case 12: {
                    return "ConstrainedCandidateServers";
                }
                case 15: {
                    return "DestinationServer";
                }
                case 7: {
                    return "HostingServer";
                }
                case 16: {
                    return "MigrationPolicy";
                }
                case 2: {
                    return "Name";
                }
                case 23: {
                    return "NumberOfRestartAttempts";
                }
                case 18: {
                    return "PostScript";
                }
                case 17: {
                    return "PreScript";
                }
                case 21: {
                    return "RestartOnFailure";
                }
                case 22: {
                    return "SecondsBetweenRestarts";
                }
                case 11: {
                    return "ServerNames";
                }
                case 8: {
                    return "UserPreferredServer";
                }
                case 20: {
                    return "NonLocalPostAllowed";
                }
                case 19: {
                    return "PostScriptFailureFatal";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AllCandidateServers")) {
                return 14;
            }
            if (string.equals("Cluster")) {
                return 13;
            }
            if (string.equals("ConstrainedCandidateServers")) {
                return 12;
            }
            if (string.equals("DestinationServer")) {
                return 15;
            }
            if (string.equals("HostingServer")) {
                return 7;
            }
            if (string.equals("MigrationPolicy")) {
                return 16;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("NumberOfRestartAttempts")) {
                return 23;
            }
            if (string.equals("PostScript")) {
                return 18;
            }
            if (string.equals("PreScript")) {
                return 17;
            }
            if (string.equals("RestartOnFailure")) {
                return 21;
            }
            if (string.equals("SecondsBetweenRestarts")) {
                return 22;
            }
            if (string.equals("ServerNames")) {
                return 11;
            }
            if (string.equals("UserPreferredServer")) {
                return 8;
            }
            if (string.equals("NonLocalPostAllowed")) {
                return 20;
            }
            if (string.equals("PostScriptFailureFatal")) {
                return 19;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAllCandidateServersSet()) {
                    stringBuffer.append("AllCandidateServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getAllCandidateServers())));
                }
                if (this.bean.isClusterSet()) {
                    stringBuffer.append("Cluster");
                    stringBuffer.append(String.valueOf(this.bean.getCluster()));
                }
                if (this.bean.isConstrainedCandidateServersSet()) {
                    stringBuffer.append("ConstrainedCandidateServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getConstrainedCandidateServers())));
                }
                if (this.bean.isDestinationServerSet()) {
                    stringBuffer.append("DestinationServer");
                    stringBuffer.append(String.valueOf(this.bean.getDestinationServer()));
                }
                if (this.bean.isHostingServerSet()) {
                    stringBuffer.append("HostingServer");
                    stringBuffer.append(String.valueOf(this.bean.getHostingServer()));
                }
                if (this.bean.isMigrationPolicySet()) {
                    stringBuffer.append("MigrationPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getMigrationPolicy()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNumberOfRestartAttemptsSet()) {
                    stringBuffer.append("NumberOfRestartAttempts");
                    stringBuffer.append(String.valueOf(this.bean.getNumberOfRestartAttempts()));
                }
                if (this.bean.isPostScriptSet()) {
                    stringBuffer.append("PostScript");
                    stringBuffer.append(String.valueOf(this.bean.getPostScript()));
                }
                if (this.bean.isPreScriptSet()) {
                    stringBuffer.append("PreScript");
                    stringBuffer.append(String.valueOf(this.bean.getPreScript()));
                }
                if (this.bean.isRestartOnFailureSet()) {
                    stringBuffer.append("RestartOnFailure");
                    stringBuffer.append(String.valueOf(this.bean.getRestartOnFailure()));
                }
                if (this.bean.isSecondsBetweenRestartsSet()) {
                    stringBuffer.append("SecondsBetweenRestarts");
                    stringBuffer.append(String.valueOf(this.bean.getSecondsBetweenRestarts()));
                }
                if (this.bean.isServerNamesSet()) {
                    stringBuffer.append("ServerNames");
                    stringBuffer.append(String.valueOf(this.bean.getServerNames()));
                }
                if (this.bean.isUserPreferredServerSet()) {
                    stringBuffer.append("UserPreferredServer");
                    stringBuffer.append(String.valueOf(this.bean.getUserPreferredServer()));
                }
                if (this.bean.isNonLocalPostAllowedSet()) {
                    stringBuffer.append("NonLocalPostAllowed");
                    stringBuffer.append(String.valueOf(this.bean.isNonLocalPostAllowed()));
                }
                if (this.bean.isPostScriptFailureFatalSet()) {
                    stringBuffer.append("PostScriptFailureFatal");
                    stringBuffer.append(String.valueOf(this.bean.isPostScriptFailureFatal()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                MigratableTargetMBeanImpl migratableTargetMBeanImpl = (MigratableTargetMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Cluster", this.bean.getCluster(), migratableTargetMBeanImpl.getCluster(), false);
                this.computeDiff("ConstrainedCandidateServers", this.bean.getConstrainedCandidateServers(), migratableTargetMBeanImpl.getConstrainedCandidateServers(), false);
                this.computeDiff("DestinationServer", this.bean.getDestinationServer(), migratableTargetMBeanImpl.getDestinationServer(), true);
                this.computeDiff("HostingServer", this.bean.getHostingServer(), migratableTargetMBeanImpl.getHostingServer(), true);
                this.computeDiff("MigrationPolicy", this.bean.getMigrationPolicy(), migratableTargetMBeanImpl.getMigrationPolicy(), false);
                this.computeDiff("Name", this.bean.getName(), migratableTargetMBeanImpl.getName(), false);
                this.computeDiff("NumberOfRestartAttempts", this.bean.getNumberOfRestartAttempts(), migratableTargetMBeanImpl.getNumberOfRestartAttempts(), false);
                this.computeDiff("PostScript", this.bean.getPostScript(), migratableTargetMBeanImpl.getPostScript(), false);
                this.computeDiff("PreScript", this.bean.getPreScript(), migratableTargetMBeanImpl.getPreScript(), false);
                this.computeDiff("RestartOnFailure", this.bean.getRestartOnFailure(), migratableTargetMBeanImpl.getRestartOnFailure(), false);
                this.computeDiff("SecondsBetweenRestarts", this.bean.getSecondsBetweenRestarts(), migratableTargetMBeanImpl.getSecondsBetweenRestarts(), false);
                this.computeDiff("UserPreferredServer", this.bean.getUserPreferredServer(), migratableTargetMBeanImpl.getUserPreferredServer(), true);
                this.computeDiff("NonLocalPostAllowed", this.bean.isNonLocalPostAllowed(), migratableTargetMBeanImpl.isNonLocalPostAllowed(), false);
                this.computeDiff("PostScriptFailureFatal", this.bean.isPostScriptFailureFatal(), migratableTargetMBeanImpl.isPostScriptFailureFatal(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                MigratableTargetMBeanImpl migratableTargetMBeanImpl = (MigratableTargetMBeanImpl)beanUpdateEvent.getSourceBean();
                MigratableTargetMBeanImpl migratableTargetMBeanImpl2 = (MigratableTargetMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("AllCandidateServers")) {
                    if (string.equals("Cluster")) {
                        migratableTargetMBeanImpl.setClusterAsString(migratableTargetMBeanImpl2.getClusterAsString());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("ConstrainedCandidateServers")) {
                        migratableTargetMBeanImpl.setConstrainedCandidateServersAsString(migratableTargetMBeanImpl2.getConstrainedCandidateServersAsString());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("DestinationServer")) {
                        migratableTargetMBeanImpl.setDestinationServerAsString(migratableTargetMBeanImpl2.getDestinationServerAsString());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("HostingServer")) {
                        migratableTargetMBeanImpl.setHostingServerAsString(migratableTargetMBeanImpl2.getHostingServerAsString());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("MigrationPolicy")) {
                        migratableTargetMBeanImpl.setMigrationPolicy(migratableTargetMBeanImpl2.getMigrationPolicy());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("Name")) {
                        migratableTargetMBeanImpl.setName(migratableTargetMBeanImpl2.getName());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("NumberOfRestartAttempts")) {
                        migratableTargetMBeanImpl.setNumberOfRestartAttempts(migratableTargetMBeanImpl2.getNumberOfRestartAttempts());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                    } else if (string.equals("PostScript")) {
                        migratableTargetMBeanImpl.setPostScript(migratableTargetMBeanImpl2.getPostScript());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("PreScript")) {
                        migratableTargetMBeanImpl.setPreScript(migratableTargetMBeanImpl2.getPreScript());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("RestartOnFailure")) {
                        migratableTargetMBeanImpl.setRestartOnFailure(migratableTargetMBeanImpl2.getRestartOnFailure());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("SecondsBetweenRestarts")) {
                        migratableTargetMBeanImpl.setSecondsBetweenRestarts(migratableTargetMBeanImpl2.getSecondsBetweenRestarts());
                        migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                    } else if (!string.equals("ServerNames")) {
                        if (string.equals("UserPreferredServer")) {
                            migratableTargetMBeanImpl.setUserPreferredServerAsString(migratableTargetMBeanImpl2.getUserPreferredServerAsString());
                            migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                        } else if (string.equals("NonLocalPostAllowed")) {
                            migratableTargetMBeanImpl.setNonLocalPostAllowed(migratableTargetMBeanImpl2.isNonLocalPostAllowed());
                            migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                        } else if (string.equals("PostScriptFailureFatal")) {
                            migratableTargetMBeanImpl.setPostScriptFailureFatal(migratableTargetMBeanImpl2.isPostScriptFailureFatal());
                            migratableTargetMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                        } else {
                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                MigratableTargetMBeanImpl migratableTargetMBeanImpl = (MigratableTargetMBeanImpl)abstractDescriptorBean;
                super.finishCopy(migratableTargetMBeanImpl, bl, list);
                if ((list == null || !list.contains("Cluster")) && this.bean.isClusterSet()) {
                    migratableTargetMBeanImpl._unSet(migratableTargetMBeanImpl, 13);
                    migratableTargetMBeanImpl.setClusterAsString(this.bean.getClusterAsString());
                }
                if ((list == null || !list.contains("ConstrainedCandidateServers")) && this.bean.isConstrainedCandidateServersSet()) {
                    migratableTargetMBeanImpl._unSet(migratableTargetMBeanImpl, 12);
                    migratableTargetMBeanImpl.setConstrainedCandidateServersAsString(this.bean.getConstrainedCandidateServersAsString());
                }
                if ((list == null || !list.contains("DestinationServer")) && this.bean.isDestinationServerSet()) {
                    migratableTargetMBeanImpl._unSet(migratableTargetMBeanImpl, 15);
                    migratableTargetMBeanImpl.setDestinationServerAsString(this.bean.getDestinationServerAsString());
                }
                if ((list == null || !list.contains("HostingServer")) && this.bean.isHostingServerSet()) {
                    migratableTargetMBeanImpl._unSet(migratableTargetMBeanImpl, 7);
                    migratableTargetMBeanImpl.setHostingServerAsString(this.bean.getHostingServerAsString());
                }
                if ((list == null || !list.contains("MigrationPolicy")) && this.bean.isMigrationPolicySet()) {
                    migratableTargetMBeanImpl.setMigrationPolicy(this.bean.getMigrationPolicy());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    migratableTargetMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("NumberOfRestartAttempts")) && this.bean.isNumberOfRestartAttemptsSet()) {
                    migratableTargetMBeanImpl.setNumberOfRestartAttempts(this.bean.getNumberOfRestartAttempts());
                }
                if ((list == null || !list.contains("PostScript")) && this.bean.isPostScriptSet()) {
                    migratableTargetMBeanImpl.setPostScript(this.bean.getPostScript());
                }
                if ((list == null || !list.contains("PreScript")) && this.bean.isPreScriptSet()) {
                    migratableTargetMBeanImpl.setPreScript(this.bean.getPreScript());
                }
                if ((list == null || !list.contains("RestartOnFailure")) && this.bean.isRestartOnFailureSet()) {
                    migratableTargetMBeanImpl.setRestartOnFailure(this.bean.getRestartOnFailure());
                }
                if ((list == null || !list.contains("SecondsBetweenRestarts")) && this.bean.isSecondsBetweenRestartsSet()) {
                    migratableTargetMBeanImpl.setSecondsBetweenRestarts(this.bean.getSecondsBetweenRestarts());
                }
                if ((list == null || !list.contains("UserPreferredServer")) && this.bean.isUserPreferredServerSet()) {
                    migratableTargetMBeanImpl._unSet(migratableTargetMBeanImpl, 8);
                    migratableTargetMBeanImpl.setUserPreferredServerAsString(this.bean.getUserPreferredServerAsString());
                }
                if ((list == null || !list.contains("NonLocalPostAllowed")) && this.bean.isNonLocalPostAllowedSet()) {
                    migratableTargetMBeanImpl.setNonLocalPostAllowed(this.bean.isNonLocalPostAllowed());
                }
                if ((list == null || !list.contains("PostScriptFailureFatal")) && this.bean.isPostScriptFailureFatalSet()) {
                    migratableTargetMBeanImpl.setPostScriptFailureFatal(this.bean.isPostScriptFailureFatal());
                }
                return migratableTargetMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getAllCandidateServers(), clazz, object);
            this.inferSubTree(this.bean.getCluster(), clazz, object);
            this.inferSubTree(this.bean.getConstrainedCandidateServers(), clazz, object);
            this.inferSubTree(this.bean.getDestinationServer(), clazz, object);
            this.inferSubTree(this.bean.getHostingServer(), clazz, object);
            this.inferSubTree(this.bean.getUserPreferredServer(), clazz, object);
        }
    }
}

