/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.BasicRealmMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.NTRealmMBean;
import weblogic.management.mbeans.custom.NTRealm;
import weblogic.utils.collections.CombinedIterator;

public class NTRealmMBeanImpl
extends BasicRealmMBeanImpl
implements NTRealmMBean,
Serializable {
    private boolean _IgnoreBadDomainName;
    private String _Name;
    private int _PreferredMaxBytes;
    private String _PrimaryDomain;
    private String _RealmClassName;
    private NTRealm _customizer;
    private static SchemaHelper2 _schemaHelper;

    public NTRealmMBeanImpl() {
        try {
            this._customizer = new NTRealm(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public NTRealmMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new NTRealm(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public String getPrimaryDomain() {
        return this._PrimaryDomain;
    }

    public String getRealmClassName() {
        return this._customizer.getRealmClassName();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isPrimaryDomainSet() {
        return this._isSet(8);
    }

    public boolean isRealmClassNameSet() {
        return this._isSet(7);
    }

    public void setRealmClassName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._RealmClassName;
        this._RealmClassName = string;
        this._postSet(7, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setPrimaryDomain(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._PrimaryDomain;
        this._PrimaryDomain = string;
        this._postSet(8, string2, string);
    }

    public int getPreferredMaxBytes() {
        return this._PreferredMaxBytes;
    }

    public boolean isPreferredMaxBytesSet() {
        return this._isSet(9);
    }

    public void setPreferredMaxBytes(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"PreferredMaxBytes", (int)n, (int)0);
        int n2 = this._PreferredMaxBytes;
        this._PreferredMaxBytes = n;
        this._postSet(9, n2, n);
    }

    public boolean getIgnoreBadDomainName() {
        return this._IgnoreBadDomainName;
    }

    public boolean isIgnoreBadDomainNameSet() {
        return this._isSet(10);
    }

    public void setIgnoreBadDomainName(boolean bl) {
        boolean bl2 = this._IgnoreBadDomainName;
        this._IgnoreBadDomainName = bl;
        this._postSet(10, bl2, bl);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 10;
        }
        try {
            switch (n) {
                case 10: {
                    this._IgnoreBadDomainName = false;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 9: {
                    this._PreferredMaxBytes = 10240;
                    if (bl) break;
                }
                case 8: {
                    this._PrimaryDomain = null;
                    if (bl) break;
                }
                case 7: {
                    this._RealmClassName = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "NTRealm";
    }

    public void putValue(String string, Object object) {
        if (string.equals("IgnoreBadDomainName")) {
            boolean bl = this._IgnoreBadDomainName;
            this._IgnoreBadDomainName = (Boolean)object;
            this._postSet(10, bl, this._IgnoreBadDomainName);
            return;
        }
        if (string.equals("Name")) {
            String string2 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string2, this._Name);
            return;
        }
        if (string.equals("PreferredMaxBytes")) {
            int n = this._PreferredMaxBytes;
            this._PreferredMaxBytes = (Integer)object;
            this._postSet(9, n, this._PreferredMaxBytes);
            return;
        }
        if (string.equals("PrimaryDomain")) {
            String string3 = this._PrimaryDomain;
            this._PrimaryDomain = (String)object;
            this._postSet(8, string3, this._PrimaryDomain);
            return;
        }
        if (string.equals("RealmClassName")) {
            String string4 = this._RealmClassName;
            this._RealmClassName = (String)object;
            this._postSet(7, string4, this._RealmClassName);
            return;
        }
        if (string.equals("customizer")) {
            NTRealm nTRealm = this._customizer;
            this._customizer = (NTRealm)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("IgnoreBadDomainName")) {
            return new Boolean(this._IgnoreBadDomainName);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PreferredMaxBytes")) {
            return new Integer(this._PreferredMaxBytes);
        }
        if (string.equals("PrimaryDomain")) {
            return this._PrimaryDomain;
        }
        if (string.equals("RealmClassName")) {
            return this._RealmClassName;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends BasicRealmMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 22: {
                    if (!string.equals("ignore-bad-domain-name")) break;
                    return 10;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 19: {
                    if (!string.equals("preferred-max-bytes")) break;
                    return 9;
                }
                case 14: {
                    if (!string.equals("primary-domain")) break;
                    return 8;
                }
                case 16: {
                    if (!string.equals("realm-class-name")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 10: {
                    return "ignore-bad-domain-name";
                }
                case 2: {
                    return "name";
                }
                case 9: {
                    return "preferred-max-bytes";
                }
                case 8: {
                    return "primary-domain";
                }
                case 7: {
                    return "realm-class-name";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends BasicRealmMBeanImpl.Helper {
        private NTRealmMBeanImpl bean;

        protected Helper(NTRealmMBeanImpl nTRealmMBeanImpl) {
            super(nTRealmMBeanImpl);
            this.bean = nTRealmMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 10: {
                    return "IgnoreBadDomainName";
                }
                case 2: {
                    return "Name";
                }
                case 9: {
                    return "PreferredMaxBytes";
                }
                case 8: {
                    return "PrimaryDomain";
                }
                case 7: {
                    return "RealmClassName";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("IgnoreBadDomainName")) {
                return 10;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PreferredMaxBytes")) {
                return 9;
            }
            if (string.equals("PrimaryDomain")) {
                return 8;
            }
            if (string.equals("RealmClassName")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isIgnoreBadDomainNameSet()) {
                    stringBuffer.append("IgnoreBadDomainName");
                    stringBuffer.append(String.valueOf(this.bean.getIgnoreBadDomainName()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPreferredMaxBytesSet()) {
                    stringBuffer.append("PreferredMaxBytes");
                    stringBuffer.append(String.valueOf(this.bean.getPreferredMaxBytes()));
                }
                if (this.bean.isPrimaryDomainSet()) {
                    stringBuffer.append("PrimaryDomain");
                    stringBuffer.append(String.valueOf(this.bean.getPrimaryDomain()));
                }
                if (this.bean.isRealmClassNameSet()) {
                    stringBuffer.append("RealmClassName");
                    stringBuffer.append(String.valueOf(this.bean.getRealmClassName()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                NTRealmMBeanImpl nTRealmMBeanImpl = (NTRealmMBeanImpl)abstractDescriptorBean;
                this.computeDiff("IgnoreBadDomainName", this.bean.getIgnoreBadDomainName(), nTRealmMBeanImpl.getIgnoreBadDomainName(), false);
                this.computeDiff("Name", this.bean.getName(), nTRealmMBeanImpl.getName(), false);
                this.computeDiff("PreferredMaxBytes", this.bean.getPreferredMaxBytes(), nTRealmMBeanImpl.getPreferredMaxBytes(), false);
                this.computeDiff("PrimaryDomain", this.bean.getPrimaryDomain(), nTRealmMBeanImpl.getPrimaryDomain(), false);
                this.computeDiff("RealmClassName", this.bean.getRealmClassName(), nTRealmMBeanImpl.getRealmClassName(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                NTRealmMBeanImpl nTRealmMBeanImpl = (NTRealmMBeanImpl)beanUpdateEvent.getSourceBean();
                NTRealmMBeanImpl nTRealmMBeanImpl2 = (NTRealmMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("IgnoreBadDomainName")) {
                    nTRealmMBeanImpl.setIgnoreBadDomainName(nTRealmMBeanImpl2.getIgnoreBadDomainName());
                    nTRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("Name")) {
                    nTRealmMBeanImpl.setName(nTRealmMBeanImpl2.getName());
                    nTRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("PreferredMaxBytes")) {
                    nTRealmMBeanImpl.setPreferredMaxBytes(nTRealmMBeanImpl2.getPreferredMaxBytes());
                    nTRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("PrimaryDomain")) {
                    nTRealmMBeanImpl.setPrimaryDomain(nTRealmMBeanImpl2.getPrimaryDomain());
                    nTRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("RealmClassName")) {
                    nTRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                NTRealmMBeanImpl nTRealmMBeanImpl = (NTRealmMBeanImpl)abstractDescriptorBean;
                super.finishCopy(nTRealmMBeanImpl, bl, list);
                if ((list == null || !list.contains("IgnoreBadDomainName")) && this.bean.isIgnoreBadDomainNameSet()) {
                    nTRealmMBeanImpl.setIgnoreBadDomainName(this.bean.getIgnoreBadDomainName());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    nTRealmMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PreferredMaxBytes")) && this.bean.isPreferredMaxBytesSet()) {
                    nTRealmMBeanImpl.setPreferredMaxBytes(this.bean.getPreferredMaxBytes());
                }
                if ((list == null || !list.contains("PrimaryDomain")) && this.bean.isPrimaryDomainSet()) {
                    nTRealmMBeanImpl.setPrimaryDomain(this.bean.getPrimaryDomain());
                }
                if (list != null && list.contains("RealmClassName") || this.bean.isRealmClassNameSet()) {
                    // empty if block
                }
                return nTRealmMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

