/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.NetworkAccessPointValidator;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.mbeans.custom.NetworkAccessPoint;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class NetworkAccessPointMBeanImpl
extends ConfigurationMBeanImpl
implements NetworkAccessPointMBean,
Serializable {
    private int _AcceptBacklog;
    private boolean _ChannelIdentityCustomized;
    private int _ChannelWeight;
    private boolean _ClientCertificateEnforced;
    private String _ClusterAddress;
    private int _CompleteCOMMessageTimeout;
    private int _CompleteHTTPMessageTimeout;
    private int _CompleteIIOPMessageTimeout;
    private int _CompleteMessageTimeout;
    private int _CompleteT3MessageTimeout;
    private int _ConnectTimeout;
    private String _CustomPrivateKeyAlias;
    private String _CustomPrivateKeyPassPhrase;
    private byte[] _CustomPrivateKeyPassPhraseEncrypted;
    private Properties _CustomProperties;
    private boolean _Enabled;
    private String _ExternalDNSName;
    private boolean _HttpEnabledForThisProtocol;
    private int _IdleConnectionTimeout;
    private int _IdleIIOPConnectionTimeout;
    private String _ListenAddress;
    private int _ListenPort;
    private int _LoginTimeoutMillis;
    private int _LoginTimeoutMillisSSL;
    private int _MaxBackoffBetweenFailures;
    private int _MaxConnectedClients;
    private int _MaxMessageSize;
    private String _Name;
    private boolean _OutboundEnabled;
    private String _OutboundPrivateKeyAlias;
    private boolean _OutboundPrivateKeyEnabled;
    private String _OutboundPrivateKeyPassPhrase;
    private String _PrivateKeyAlias;
    private String _PrivateKeyPassPhrase;
    private String _Protocol;
    private String _ProxyAddress;
    private int _ProxyPort;
    private String _PublicAddress;
    private int _PublicPort;
    private boolean _SDPEnabled;
    private int _SSLListenPort;
    private boolean _TimeoutConnectionWithPendingResponses;
    private int _TunnelingClientPingSecs;
    private int _TunnelingClientTimeoutSecs;
    private boolean _TunnelingEnabled;
    private boolean _TwoWaySSLEnabled;
    private boolean _UseFastSerialization;
    private static SchemaHelper2 _schemaHelper;

    public NetworkAccessPointMBeanImpl() {
        this._initializeProperty(-1);
    }

    public NetworkAccessPointMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getName() {
        return this._Name;
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        ConfigurationValidator.validateName(string);
        String string2 = this._Name;
        this._Name = string;
        this._postSet(2, string2, string);
    }

    public String getProtocol() {
        return this._Protocol;
    }

    public boolean isProtocolSet() {
        return this._isSet(7);
    }

    public void setProtocol(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Protocol;
        this._Protocol = string;
        this._postSet(7, string2, string);
    }

    public String getListenAddress() {
        if (!this._isSet(8)) {
            try {
                return ((ServerMBean)this.getParent()).getListenAddress();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._ListenAddress;
    }

    public boolean isListenAddressSet() {
        return this._isSet(8);
    }

    public void setListenAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ListenAddress;
        this._ListenAddress = string;
        this._postSet(8, string2, string);
    }

    public String getPublicAddress() {
        if (!this._isSet(9)) {
            try {
                return NetworkAccessPoint.getPublicAddress(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._PublicAddress;
    }

    public boolean isPublicAddressSet() {
        return this._isSet(9);
    }

    public void setPublicAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._PublicAddress;
        this._PublicAddress = string;
        this._postSet(9, string2, string);
    }

    public int getListenPort() {
        if (!this._isSet(10)) {
            try {
                return NetworkAccessPoint.isSecure(this) ? ((ServerMBean)this.getParent()).getSSL().getListenPort() : ((ServerMBean)this.getParent()).getListenPort();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._ListenPort;
    }

    public boolean isListenPortSet() {
        return this._isSet(10);
    }

    public void setListenPort(int n) throws InvalidAttributeValueException {
        NetworkAccessPointValidator.validateListenPort(n);
        int n2 = this._ListenPort;
        this._ListenPort = n;
        this._postSet(10, n2, n);
    }

    public int getPublicPort() {
        if (!this._isSet(11)) {
            try {
                return this.getListenPort();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._PublicPort;
    }

    public boolean isPublicPortSet() {
        return this._isSet(11);
    }

    public void setPublicPort(int n) throws InvalidAttributeValueException {
        NetworkAccessPointValidator.validatePublicPort(n);
        int n2 = this._PublicPort;
        this._PublicPort = n;
        this._postSet(11, n2, n);
    }

    public String getProxyAddress() {
        return this._ProxyAddress;
    }

    public boolean isProxyAddressSet() {
        return this._isSet(12);
    }

    public void setProxyAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ProxyAddress;
        this._ProxyAddress = string;
        this._postSet(12, string2, string);
    }

    public int getProxyPort() {
        return this._ProxyPort;
    }

    public boolean isProxyPortSet() {
        return this._isSet(13);
    }

    public void setProxyPort(int n) throws InvalidAttributeValueException {
        int n2 = this._ProxyPort;
        this._ProxyPort = n;
        this._postSet(13, n2, n);
    }

    public boolean isHttpEnabledForThisProtocol() {
        return this._HttpEnabledForThisProtocol;
    }

    public boolean isHttpEnabledForThisProtocolSet() {
        return this._isSet(14);
    }

    public void setHttpEnabledForThisProtocol(boolean bl) throws InvalidAttributeValueException {
        NetworkAccessPointValidator.validateHttpEnabledForThisProtocol(this, bl);
        boolean bl2 = this._HttpEnabledForThisProtocol;
        this._HttpEnabledForThisProtocol = bl;
        this._postSet(14, bl2, bl);
    }

    public int getAcceptBacklog() {
        if (!this._isSet(15)) {
            try {
                return ((ServerMBean)this.getParent()).getAcceptBacklog();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._AcceptBacklog;
    }

    public boolean isAcceptBacklogSet() {
        return this._isSet(15);
    }

    public void setAcceptBacklog(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"AcceptBacklog", (int)n, (int)0);
        int n2 = this._AcceptBacklog;
        this._AcceptBacklog = n;
        this._postSet(15, n2, n);
    }

    public int getMaxBackoffBetweenFailures() {
        if (!this._isSet(16)) {
            try {
                return ((ServerMBean)this.getParent()).getMaxBackoffBetweenFailures();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._MaxBackoffBetweenFailures;
    }

    public boolean isMaxBackoffBetweenFailuresSet() {
        return this._isSet(16);
    }

    public void setMaxBackoffBetweenFailures(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"MaxBackoffBetweenFailures", (int)n, (int)0);
        int n2 = this._MaxBackoffBetweenFailures;
        this._MaxBackoffBetweenFailures = n;
        this._postSet(16, n2, n);
    }

    public int getLoginTimeoutMillis() {
        if (!this._isSet(17)) {
            try {
                return NetworkAccessPoint.isSecure(this) ? ((ServerMBean)this.getParent()).getSSL().getLoginTimeoutMillis() : ((ServerMBean)this.getParent()).getLoginTimeoutMillis();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._LoginTimeoutMillis;
    }

    public boolean isLoginTimeoutMillisSet() {
        return this._isSet(17);
    }

    public void setLoginTimeoutMillis(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"LoginTimeoutMillis", (long)n, (long)0L, (long)100000L);
        int n2 = this._LoginTimeoutMillis;
        this._LoginTimeoutMillis = n;
        this._postSet(17, n2, n);
    }

    public int getTunnelingClientPingSecs() {
        if (!this._isSet(18)) {
            try {
                return ((ServerMBean)this.getParent()).getTunnelingClientPingSecs();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._TunnelingClientPingSecs;
    }

    public boolean isTunnelingClientPingSecsSet() {
        return this._isSet(18);
    }

    public void setTunnelingClientPingSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"TunnelingClientPingSecs", (int)n, (int)1);
        int n2 = this._TunnelingClientPingSecs;
        this._TunnelingClientPingSecs = n;
        this._postSet(18, n2, n);
    }

    public int getTunnelingClientTimeoutSecs() {
        if (!this._isSet(19)) {
            try {
                return ((ServerMBean)this.getParent()).getTunnelingClientTimeoutSecs();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._TunnelingClientTimeoutSecs;
    }

    public boolean isTunnelingClientTimeoutSecsSet() {
        return this._isSet(19);
    }

    public void setTunnelingClientTimeoutSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"TunnelingClientTimeoutSecs", (int)n, (int)1);
        int n2 = this._TunnelingClientTimeoutSecs;
        this._TunnelingClientTimeoutSecs = n;
        this._postSet(19, n2, n);
    }

    public boolean isTunnelingEnabled() {
        return this._TunnelingEnabled;
    }

    public boolean isTunnelingEnabledSet() {
        return this._isSet(20);
    }

    public void setTunnelingEnabled(boolean bl) throws InvalidAttributeValueException {
        NetworkAccessPointValidator.validateTunnelingEnabled(this, bl);
        boolean bl2 = this._TunnelingEnabled;
        this._TunnelingEnabled = bl;
        this._postSet(20, bl2, bl);
    }

    public int getCompleteMessageTimeout() {
        if (!this._isSet(21)) {
            try {
                return ((ServerMBean)this.getParent()).getCompleteMessageTimeout();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._CompleteMessageTimeout;
    }

    public boolean isCompleteMessageTimeoutSet() {
        return this._isSet(21);
    }

    public void setCompleteMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteMessageTimeout", (long)n, (long)0L, (long)480L);
        int n2 = this._CompleteMessageTimeout;
        this._CompleteMessageTimeout = n;
        this._postSet(21, n2, n);
    }

    public boolean getTimeoutConnectionWithPendingResponses() {
        return this._TimeoutConnectionWithPendingResponses;
    }

    public boolean isTimeoutConnectionWithPendingResponsesSet() {
        return this._isSet(22);
    }

    public void setTimeoutConnectionWithPendingResponses(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._TimeoutConnectionWithPendingResponses;
        this._TimeoutConnectionWithPendingResponses = bl;
        this._postSet(22, bl2, bl);
    }

    public int getIdleConnectionTimeout() {
        if (!this._isSet(23)) {
            try {
                return ((ServerMBean)this.getParent()).getIdleConnectionTimeout();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._IdleConnectionTimeout;
    }

    public boolean isIdleConnectionTimeoutSet() {
        return this._isSet(23);
    }

    public void setIdleConnectionTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"IdleConnectionTimeout", (int)n, (int)0);
        int n2 = this._IdleConnectionTimeout;
        this._IdleConnectionTimeout = n;
        this._postSet(23, n2, n);
    }

    public int getConnectTimeout() {
        if (!this._isSet(24)) {
            try {
                return ((ServerMBean)this.getParent()).getConnectTimeout();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._ConnectTimeout;
    }

    public boolean isConnectTimeoutSet() {
        return this._isSet(24);
    }

    public void setConnectTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"ConnectTimeout", (long)n, (long)0L, (long)240L);
        int n2 = this._ConnectTimeout;
        this._ConnectTimeout = n;
        this._postSet(24, n2, n);
    }

    public int getMaxMessageSize() {
        if (!this._isSet(25)) {
            try {
                return NetworkAccessPoint.getMaxMessageSize(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._MaxMessageSize;
    }

    public boolean isMaxMessageSizeSet() {
        return this._isSet(25);
    }

    public void setMaxMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxMessageSize", (long)n, (long)4096L, (long)100000000L);
        int n2 = this._MaxMessageSize;
        this._MaxMessageSize = n;
        this._postSet(25, n2, n);
    }

    public boolean isOutboundEnabled() {
        if (!this._isSet(26)) {
            try {
                return this.getProtocol().toLowerCase().equals("admin");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OutboundEnabled;
    }

    public boolean isOutboundEnabledSet() {
        return this._isSet(26);
    }

    public void setOutboundEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._OutboundEnabled;
        this._OutboundEnabled = bl;
        this._postSet(26, bl2, bl);
    }

    public int getChannelWeight() {
        return this._ChannelWeight;
    }

    public boolean isChannelWeightSet() {
        return this._isSet(27);
    }

    public void setChannelWeight(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ChannelWeight", (long)n, (long)1L, (long)100L);
        int n2 = this._ChannelWeight;
        this._ChannelWeight = n;
        this._postSet(27, n2, n);
    }

    public String getClusterAddress() {
        if (!this._isSet(28)) {
            try {
                return NetworkAccessPoint.getClusterAddress(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._ClusterAddress;
    }

    public boolean isClusterAddressSet() {
        return this._isSet(28);
    }

    public void setClusterAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ClusterAddress;
        this._ClusterAddress = string;
        this._postSet(28, string2, string);
    }

    public boolean isEnabled() {
        return this._Enabled;
    }

    public boolean isEnabledSet() {
        return this._isSet(29);
    }

    public void setEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._Enabled;
        this._Enabled = bl;
        this._postSet(29, bl2, bl);
    }

    public int getMaxConnectedClients() {
        return this._MaxConnectedClients;
    }

    public boolean isMaxConnectedClientsSet() {
        return this._isSet(30);
    }

    public void setMaxConnectedClients(int n) throws InvalidAttributeValueException {
        int n2 = this._MaxConnectedClients;
        this._MaxConnectedClients = n;
        this._postSet(30, n2, n);
    }

    public boolean isTwoWaySSLEnabled() {
        return this._TwoWaySSLEnabled;
    }

    public boolean isTwoWaySSLEnabledSet() {
        return this._isSet(31);
    }

    public void setTwoWaySSLEnabled(boolean bl) {
        boolean bl2 = this._TwoWaySSLEnabled;
        this._TwoWaySSLEnabled = bl;
        this._postSet(31, bl2, bl);
    }

    public boolean isChannelIdentityCustomized() {
        return this._ChannelIdentityCustomized;
    }

    public boolean isChannelIdentityCustomizedSet() {
        return this._isSet(32);
    }

    public void setChannelIdentityCustomized(boolean bl) {
        boolean bl2 = this._ChannelIdentityCustomized;
        this._ChannelIdentityCustomized = bl;
        this._postSet(32, bl2, bl);
    }

    public String getCustomPrivateKeyAlias() {
        if (!this._isSet(33)) {
            try {
                return ((ServerMBean)this.getParent()).getSSL().getServerPrivateKeyAlias();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._CustomPrivateKeyAlias;
    }

    public boolean isCustomPrivateKeyAliasSet() {
        return this._isSet(33);
    }

    public void setCustomPrivateKeyAlias(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._CustomPrivateKeyAlias;
        this._CustomPrivateKeyAlias = string;
        this._postSet(33, string2, string);
    }

    public String getPrivateKeyAlias() {
        if (!this._isSet(34)) {
            try {
                return this.isChannelIdentityCustomized() ? this.getCustomPrivateKeyAlias() : ((ServerMBean)this.getParent()).getSSL().getServerPrivateKeyAlias();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._PrivateKeyAlias;
    }

    public boolean isPrivateKeyAliasSet() {
        return this._isSet(34);
    }

    public void setPrivateKeyAlias(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._PrivateKeyAlias;
        this._PrivateKeyAlias = string;
        this._postSet(34, string2, string);
    }

    public String getCustomPrivateKeyPassPhrase() {
        byte[] byArray = this.getCustomPrivateKeyPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("CustomPrivateKeyPassPhrase", byArray);
    }

    public boolean isCustomPrivateKeyPassPhraseSet() {
        return this.isCustomPrivateKeyPassPhraseEncryptedSet();
    }

    public void setCustomPrivateKeyPassPhrase(String string) {
        string = string == null ? null : string.trim();
        this.setCustomPrivateKeyPassPhraseEncrypted(string == null ? null : this._encrypt("CustomPrivateKeyPassPhrase", string));
    }

    public String getPrivateKeyPassPhrase() {
        if (!this._isSet(36)) {
            try {
                return this.isChannelIdentityCustomized() ? this.getCustomPrivateKeyPassPhrase() : ((ServerMBean)this.getParent()).getSSL().getServerPrivateKeyPassPhrase();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._PrivateKeyPassPhrase;
    }

    public boolean isPrivateKeyPassPhraseSet() {
        return this._isSet(36);
    }

    public void setPrivateKeyPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._PrivateKeyPassPhrase;
        this._PrivateKeyPassPhrase = string;
        this._postSet(36, string2, string);
    }

    public byte[] getCustomPrivateKeyPassPhraseEncrypted() {
        if (!this._isSet(37)) {
            try {
                return ((ServerMBean)this.getParent()).getSSL().getServerPrivateKeyPassPhraseEncrypted();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._getHelper()._cloneArray(this._CustomPrivateKeyPassPhraseEncrypted);
    }

    public String getCustomPrivateKeyPassPhraseEncryptedAsString() {
        byte[] byArray = this.getCustomPrivateKeyPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isCustomPrivateKeyPassPhraseEncryptedSet() {
        return this._isSet(37);
    }

    public void setCustomPrivateKeyPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setCustomPrivateKeyPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isClientCertificateEnforced() {
        return this._ClientCertificateEnforced;
    }

    public boolean isClientCertificateEnforcedSet() {
        return this._isSet(38);
    }

    public void setClientCertificateEnforced(boolean bl) {
        boolean bl2 = this._ClientCertificateEnforced;
        this._ClientCertificateEnforced = bl;
        this._postSet(38, bl2, bl);
    }

    public boolean isOutboundPrivateKeyEnabled() {
        if (!this._isSet(39)) {
            try {
                return ((ServerMBean)this.getParent()).isOutboundPrivateKeyEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OutboundPrivateKeyEnabled;
    }

    public boolean isOutboundPrivateKeyEnabledSet() {
        return this._isSet(39);
    }

    public void setOutboundPrivateKeyEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._OutboundPrivateKeyEnabled;
        this._OutboundPrivateKeyEnabled = bl;
        this._postSet(39, bl2, bl);
    }

    public boolean getUseFastSerialization() {
        if (!this._isSet(40)) {
            try {
                return this.getProtocol().toLowerCase().startsWith("iiop") ? ((ServerMBean)this.getParent()).getIIOP().getUseJavaSerialization() : false;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._UseFastSerialization;
    }

    public boolean isUseFastSerializationSet() {
        return this._isSet(40);
    }

    public void setUseFastSerialization(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._UseFastSerialization;
        this._UseFastSerialization = bl;
        this._postSet(40, bl2, bl);
    }

    public int getIdleIIOPConnectionTimeout() {
        return this._IdleIIOPConnectionTimeout;
    }

    public boolean isIdleIIOPConnectionTimeoutSet() {
        return this._isSet(41);
    }

    public void setIdleIIOPConnectionTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"IdleIIOPConnectionTimeout", (int)n, (int)-1);
        int n2 = this._IdleIIOPConnectionTimeout;
        this._IdleIIOPConnectionTimeout = n;
        this._postSet(41, n2, n);
    }

    public int getSSLListenPort() {
        return this._SSLListenPort;
    }

    public boolean isSSLListenPortSet() {
        return this._isSet(42);
    }

    public void setSSLListenPort(int n) throws InvalidAttributeValueException {
        NetworkAccessPointValidator.validateMaxMessageSize(n);
        int n2 = this._SSLListenPort;
        this._SSLListenPort = n;
        this._postSet(42, n2, n);
    }

    public String getExternalDNSName() {
        return this._ExternalDNSName;
    }

    public boolean isExternalDNSNameSet() {
        return this._isSet(43);
    }

    public void setExternalDNSName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ExternalDNSName;
        this._ExternalDNSName = string;
        this._postSet(43, string2, string);
    }

    public int getLoginTimeoutMillisSSL() {
        return this._LoginTimeoutMillisSSL;
    }

    public boolean isLoginTimeoutMillisSSLSet() {
        return this._isSet(44);
    }

    public void setLoginTimeoutMillisSSL(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LoginTimeoutMillisSSL", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this._LoginTimeoutMillisSSL;
        this._LoginTimeoutMillisSSL = n;
        this._postSet(44, n2, n);
    }

    public int getCompleteT3MessageTimeout() {
        return this._CompleteT3MessageTimeout;
    }

    public boolean isCompleteT3MessageTimeoutSet() {
        return this._isSet(45);
    }

    public void setCompleteT3MessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteT3MessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteT3MessageTimeout;
        this._CompleteT3MessageTimeout = n;
        this._postSet(45, n2, n);
    }

    public int getCompleteHTTPMessageTimeout() {
        return this._CompleteHTTPMessageTimeout;
    }

    public boolean isCompleteHTTPMessageTimeoutSet() {
        return this._isSet(46);
    }

    public void setCompleteHTTPMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteHTTPMessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteHTTPMessageTimeout;
        this._CompleteHTTPMessageTimeout = n;
        this._postSet(46, n2, n);
    }

    public int getCompleteCOMMessageTimeout() {
        return this._CompleteCOMMessageTimeout;
    }

    public boolean isCompleteCOMMessageTimeoutSet() {
        return this._isSet(47);
    }

    public void setCompleteCOMMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteCOMMessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteCOMMessageTimeout;
        this._CompleteCOMMessageTimeout = n;
        this._postSet(47, n2, n);
    }

    public int getCompleteIIOPMessageTimeout() {
        return this._CompleteIIOPMessageTimeout;
    }

    public boolean isCompleteIIOPMessageTimeoutSet() {
        return this._isSet(48);
    }

    public void setCompleteIIOPMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteIIOPMessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteIIOPMessageTimeout;
        this._CompleteIIOPMessageTimeout = n;
        this._postSet(48, n2, n);
    }

    public void setCustomProperties(Properties properties) {
        Properties properties2 = this._CustomProperties;
        this._CustomProperties = properties;
        this._postSet(49, properties2, properties);
    }

    public Properties getCustomProperties() {
        return this._CustomProperties;
    }

    public String getCustomPropertiesAsString() {
        return StringHelper.objectToString((Object)this.getCustomProperties());
    }

    public boolean isCustomPropertiesSet() {
        return this._isSet(49);
    }

    public void setCustomPropertiesAsString(String string) {
        try {
            this.setCustomProperties(StringHelper.stringToProperties((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isSDPEnabled() {
        return this._SDPEnabled;
    }

    public boolean isSDPEnabledSet() {
        return this._isSet(50);
    }

    public void setSDPEnabled(boolean bl) {
        boolean bl2 = this._SDPEnabled;
        this._SDPEnabled = bl;
        this._postSet(50, bl2, bl);
    }

    public String getOutboundPrivateKeyAlias() {
        if (!this._isSet(51)) {
            try {
                return this.isOutboundPrivateKeyEnabled() && this.isChannelIdentityCustomized() ? this.getCustomPrivateKeyAlias() : ((ServerMBean)this.getParent()).getSSL().getOutboundPrivateKeyAlias();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OutboundPrivateKeyAlias;
    }

    public boolean isOutboundPrivateKeyAliasSet() {
        return this._isSet(51);
    }

    public void setOutboundPrivateKeyAlias(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._OutboundPrivateKeyAlias;
        this._OutboundPrivateKeyAlias = string;
        this._postSet(51, string2, string);
    }

    public String getOutboundPrivateKeyPassPhrase() {
        if (!this._isSet(52)) {
            try {
                return this.isOutboundPrivateKeyEnabled() && this.isChannelIdentityCustomized() ? this.getCustomPrivateKeyPassPhrase() : ((ServerMBean)this.getParent()).getSSL().getOutboundPrivateKeyPassPhrase();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OutboundPrivateKeyPassPhrase;
    }

    public boolean isOutboundPrivateKeyPassPhraseSet() {
        return this._isSet(52);
    }

    public void setOutboundPrivateKeyPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._OutboundPrivateKeyPassPhrase;
        this._OutboundPrivateKeyPassPhrase = string;
        this._postSet(52, string2, string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setCustomPrivateKeyPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._CustomPrivateKeyPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: CustomPrivateKeyPassPhraseEncrypted of NetworkAccessPointMBean");
        }
        this._getHelper()._clearArray(this._CustomPrivateKeyPassPhraseEncrypted);
        this._CustomPrivateKeyPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(37, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 35) {
                this._markSet(37, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 15;
        }
        try {
            switch (n) {
                case 15: {
                    this._AcceptBacklog = 0;
                    if (bl) break;
                }
                case 27: {
                    this._ChannelWeight = 50;
                    if (bl) break;
                }
                case 28: {
                    this._ClusterAddress = null;
                    if (bl) break;
                }
                case 47: {
                    this._CompleteCOMMessageTimeout = -1;
                    if (bl) break;
                }
                case 46: {
                    this._CompleteHTTPMessageTimeout = -1;
                    if (bl) break;
                }
                case 48: {
                    this._CompleteIIOPMessageTimeout = -1;
                    if (bl) break;
                }
                case 21: {
                    this._CompleteMessageTimeout = 0;
                    if (bl) break;
                }
                case 45: {
                    this._CompleteT3MessageTimeout = -1;
                    if (bl) break;
                }
                case 24: {
                    this._ConnectTimeout = 0;
                    if (bl) break;
                }
                case 33: {
                    this._CustomPrivateKeyAlias = null;
                    if (bl) break;
                }
                case 35: {
                    this._CustomPrivateKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 37: {
                    this._CustomPrivateKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 49: {
                    this._CustomProperties = null;
                    if (bl) break;
                }
                case 43: {
                    this._ExternalDNSName = null;
                    if (bl) break;
                }
                case 23: {
                    this._IdleConnectionTimeout = 0;
                    if (bl) break;
                }
                case 41: {
                    this._IdleIIOPConnectionTimeout = -1;
                    if (bl) break;
                }
                case 8: {
                    this._ListenAddress = null;
                    if (bl) break;
                }
                case 10: {
                    this._ListenPort = 0;
                    if (bl) break;
                }
                case 17: {
                    this._LoginTimeoutMillis = 0;
                    if (bl) break;
                }
                case 44: {
                    this._LoginTimeoutMillisSSL = -1;
                    if (bl) break;
                }
                case 16: {
                    this._MaxBackoffBetweenFailures = 0;
                    if (bl) break;
                }
                case 30: {
                    this._MaxConnectedClients = Integer.MAX_VALUE;
                    if (bl) break;
                }
                case 25: {
                    this._MaxMessageSize = 0;
                    if (bl) break;
                }
                case 2: {
                    this._Name = "<unknown>";
                    if (bl) break;
                }
                case 51: {
                    this._OutboundPrivateKeyAlias = null;
                    if (bl) break;
                }
                case 52: {
                    this._OutboundPrivateKeyPassPhrase = null;
                    if (bl) break;
                }
                case 34: {
                    this._PrivateKeyAlias = null;
                    if (bl) break;
                }
                case 36: {
                    this._PrivateKeyPassPhrase = null;
                    if (bl) break;
                }
                case 7: {
                    this._Protocol = "t3";
                    if (bl) break;
                }
                case 12: {
                    this._ProxyAddress = null;
                    if (bl) break;
                }
                case 13: {
                    this._ProxyPort = 80;
                    if (bl) break;
                }
                case 9: {
                    this._PublicAddress = null;
                    if (bl) break;
                }
                case 11: {
                    this._PublicPort = 0;
                    if (bl) break;
                }
                case 42: {
                    this._SSLListenPort = -1;
                    if (bl) break;
                }
                case 22: {
                    this._TimeoutConnectionWithPendingResponses = false;
                    if (bl) break;
                }
                case 18: {
                    this._TunnelingClientPingSecs = 0;
                    if (bl) break;
                }
                case 19: {
                    this._TunnelingClientTimeoutSecs = 0;
                    if (bl) break;
                }
                case 40: {
                    this._UseFastSerialization = false;
                    if (bl) break;
                }
                case 32: {
                    this._ChannelIdentityCustomized = false;
                    if (bl) break;
                }
                case 38: {
                    this._ClientCertificateEnforced = false;
                    if (bl) break;
                }
                case 29: {
                    this._Enabled = true;
                    if (bl) break;
                }
                case 14: {
                    this._HttpEnabledForThisProtocol = true;
                    if (bl) break;
                }
                case 26: {
                    this._OutboundEnabled = false;
                    if (bl) break;
                }
                case 39: {
                    this._OutboundPrivateKeyEnabled = false;
                    if (bl) break;
                }
                case 50: {
                    this._SDPEnabled = false;
                    if (bl) break;
                }
                case 20: {
                    this._TunnelingEnabled = false;
                    if (bl) break;
                }
                case 31: {
                    this._TwoWaySSLEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "NetworkAccessPoint";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AcceptBacklog")) {
            int n = this._AcceptBacklog;
            this._AcceptBacklog = (Integer)object;
            this._postSet(15, n, this._AcceptBacklog);
            return;
        }
        if (string.equals("ChannelIdentityCustomized")) {
            boolean bl = this._ChannelIdentityCustomized;
            this._ChannelIdentityCustomized = (Boolean)object;
            this._postSet(32, bl, this._ChannelIdentityCustomized);
            return;
        }
        if (string.equals("ChannelWeight")) {
            int n = this._ChannelWeight;
            this._ChannelWeight = (Integer)object;
            this._postSet(27, n, this._ChannelWeight);
            return;
        }
        if (string.equals("ClientCertificateEnforced")) {
            boolean bl = this._ClientCertificateEnforced;
            this._ClientCertificateEnforced = (Boolean)object;
            this._postSet(38, bl, this._ClientCertificateEnforced);
            return;
        }
        if (string.equals("ClusterAddress")) {
            String string2 = this._ClusterAddress;
            this._ClusterAddress = (String)object;
            this._postSet(28, string2, this._ClusterAddress);
            return;
        }
        if (string.equals("CompleteCOMMessageTimeout")) {
            int n = this._CompleteCOMMessageTimeout;
            this._CompleteCOMMessageTimeout = (Integer)object;
            this._postSet(47, n, this._CompleteCOMMessageTimeout);
            return;
        }
        if (string.equals("CompleteHTTPMessageTimeout")) {
            int n = this._CompleteHTTPMessageTimeout;
            this._CompleteHTTPMessageTimeout = (Integer)object;
            this._postSet(46, n, this._CompleteHTTPMessageTimeout);
            return;
        }
        if (string.equals("CompleteIIOPMessageTimeout")) {
            int n = this._CompleteIIOPMessageTimeout;
            this._CompleteIIOPMessageTimeout = (Integer)object;
            this._postSet(48, n, this._CompleteIIOPMessageTimeout);
            return;
        }
        if (string.equals("CompleteMessageTimeout")) {
            int n = this._CompleteMessageTimeout;
            this._CompleteMessageTimeout = (Integer)object;
            this._postSet(21, n, this._CompleteMessageTimeout);
            return;
        }
        if (string.equals("CompleteT3MessageTimeout")) {
            int n = this._CompleteT3MessageTimeout;
            this._CompleteT3MessageTimeout = (Integer)object;
            this._postSet(45, n, this._CompleteT3MessageTimeout);
            return;
        }
        if (string.equals("ConnectTimeout")) {
            int n = this._ConnectTimeout;
            this._ConnectTimeout = (Integer)object;
            this._postSet(24, n, this._ConnectTimeout);
            return;
        }
        if (string.equals("CustomPrivateKeyAlias")) {
            String string3 = this._CustomPrivateKeyAlias;
            this._CustomPrivateKeyAlias = (String)object;
            this._postSet(33, string3, this._CustomPrivateKeyAlias);
            return;
        }
        if (string.equals("CustomPrivateKeyPassPhrase")) {
            String string4 = this._CustomPrivateKeyPassPhrase;
            this._CustomPrivateKeyPassPhrase = (String)object;
            this._postSet(35, string4, this._CustomPrivateKeyPassPhrase);
            return;
        }
        if (string.equals("CustomPrivateKeyPassPhraseEncrypted")) {
            byte[] byArray = this._CustomPrivateKeyPassPhraseEncrypted;
            this._CustomPrivateKeyPassPhraseEncrypted = (byte[])object;
            this._postSet(37, byArray, this._CustomPrivateKeyPassPhraseEncrypted);
            return;
        }
        if (string.equals("CustomProperties")) {
            Properties properties = this._CustomProperties;
            this._CustomProperties = (Properties)object;
            this._postSet(49, properties, this._CustomProperties);
            return;
        }
        if (string.equals("Enabled")) {
            boolean bl = this._Enabled;
            this._Enabled = (Boolean)object;
            this._postSet(29, bl, this._Enabled);
            return;
        }
        if (string.equals("ExternalDNSName")) {
            String string5 = this._ExternalDNSName;
            this._ExternalDNSName = (String)object;
            this._postSet(43, string5, this._ExternalDNSName);
            return;
        }
        if (string.equals("HttpEnabledForThisProtocol")) {
            boolean bl = this._HttpEnabledForThisProtocol;
            this._HttpEnabledForThisProtocol = (Boolean)object;
            this._postSet(14, bl, this._HttpEnabledForThisProtocol);
            return;
        }
        if (string.equals("IdleConnectionTimeout")) {
            int n = this._IdleConnectionTimeout;
            this._IdleConnectionTimeout = (Integer)object;
            this._postSet(23, n, this._IdleConnectionTimeout);
            return;
        }
        if (string.equals("IdleIIOPConnectionTimeout")) {
            int n = this._IdleIIOPConnectionTimeout;
            this._IdleIIOPConnectionTimeout = (Integer)object;
            this._postSet(41, n, this._IdleIIOPConnectionTimeout);
            return;
        }
        if (string.equals("ListenAddress")) {
            String string6 = this._ListenAddress;
            this._ListenAddress = (String)object;
            this._postSet(8, string6, this._ListenAddress);
            return;
        }
        if (string.equals("ListenPort")) {
            int n = this._ListenPort;
            this._ListenPort = (Integer)object;
            this._postSet(10, n, this._ListenPort);
            return;
        }
        if (string.equals("LoginTimeoutMillis")) {
            int n = this._LoginTimeoutMillis;
            this._LoginTimeoutMillis = (Integer)object;
            this._postSet(17, n, this._LoginTimeoutMillis);
            return;
        }
        if (string.equals("LoginTimeoutMillisSSL")) {
            int n = this._LoginTimeoutMillisSSL;
            this._LoginTimeoutMillisSSL = (Integer)object;
            this._postSet(44, n, this._LoginTimeoutMillisSSL);
            return;
        }
        if (string.equals("MaxBackoffBetweenFailures")) {
            int n = this._MaxBackoffBetweenFailures;
            this._MaxBackoffBetweenFailures = (Integer)object;
            this._postSet(16, n, this._MaxBackoffBetweenFailures);
            return;
        }
        if (string.equals("MaxConnectedClients")) {
            int n = this._MaxConnectedClients;
            this._MaxConnectedClients = (Integer)object;
            this._postSet(30, n, this._MaxConnectedClients);
            return;
        }
        if (string.equals("MaxMessageSize")) {
            int n = this._MaxMessageSize;
            this._MaxMessageSize = (Integer)object;
            this._postSet(25, n, this._MaxMessageSize);
            return;
        }
        if (string.equals("Name")) {
            String string7 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string7, this._Name);
            return;
        }
        if (string.equals("OutboundEnabled")) {
            boolean bl = this._OutboundEnabled;
            this._OutboundEnabled = (Boolean)object;
            this._postSet(26, bl, this._OutboundEnabled);
            return;
        }
        if (string.equals("OutboundPrivateKeyAlias")) {
            String string8 = this._OutboundPrivateKeyAlias;
            this._OutboundPrivateKeyAlias = (String)object;
            this._postSet(51, string8, this._OutboundPrivateKeyAlias);
            return;
        }
        if (string.equals("OutboundPrivateKeyEnabled")) {
            boolean bl = this._OutboundPrivateKeyEnabled;
            this._OutboundPrivateKeyEnabled = (Boolean)object;
            this._postSet(39, bl, this._OutboundPrivateKeyEnabled);
            return;
        }
        if (string.equals("OutboundPrivateKeyPassPhrase")) {
            String string9 = this._OutboundPrivateKeyPassPhrase;
            this._OutboundPrivateKeyPassPhrase = (String)object;
            this._postSet(52, string9, this._OutboundPrivateKeyPassPhrase);
            return;
        }
        if (string.equals("PrivateKeyAlias")) {
            String string10 = this._PrivateKeyAlias;
            this._PrivateKeyAlias = (String)object;
            this._postSet(34, string10, this._PrivateKeyAlias);
            return;
        }
        if (string.equals("PrivateKeyPassPhrase")) {
            String string11 = this._PrivateKeyPassPhrase;
            this._PrivateKeyPassPhrase = (String)object;
            this._postSet(36, string11, this._PrivateKeyPassPhrase);
            return;
        }
        if (string.equals("Protocol")) {
            String string12 = this._Protocol;
            this._Protocol = (String)object;
            this._postSet(7, string12, this._Protocol);
            return;
        }
        if (string.equals("ProxyAddress")) {
            String string13 = this._ProxyAddress;
            this._ProxyAddress = (String)object;
            this._postSet(12, string13, this._ProxyAddress);
            return;
        }
        if (string.equals("ProxyPort")) {
            int n = this._ProxyPort;
            this._ProxyPort = (Integer)object;
            this._postSet(13, n, this._ProxyPort);
            return;
        }
        if (string.equals("PublicAddress")) {
            String string14 = this._PublicAddress;
            this._PublicAddress = (String)object;
            this._postSet(9, string14, this._PublicAddress);
            return;
        }
        if (string.equals("PublicPort")) {
            int n = this._PublicPort;
            this._PublicPort = (Integer)object;
            this._postSet(11, n, this._PublicPort);
            return;
        }
        if (string.equals("SDPEnabled")) {
            boolean bl = this._SDPEnabled;
            this._SDPEnabled = (Boolean)object;
            this._postSet(50, bl, this._SDPEnabled);
            return;
        }
        if (string.equals("SSLListenPort")) {
            int n = this._SSLListenPort;
            this._SSLListenPort = (Integer)object;
            this._postSet(42, n, this._SSLListenPort);
            return;
        }
        if (string.equals("TimeoutConnectionWithPendingResponses")) {
            boolean bl = this._TimeoutConnectionWithPendingResponses;
            this._TimeoutConnectionWithPendingResponses = (Boolean)object;
            this._postSet(22, bl, this._TimeoutConnectionWithPendingResponses);
            return;
        }
        if (string.equals("TunnelingClientPingSecs")) {
            int n = this._TunnelingClientPingSecs;
            this._TunnelingClientPingSecs = (Integer)object;
            this._postSet(18, n, this._TunnelingClientPingSecs);
            return;
        }
        if (string.equals("TunnelingClientTimeoutSecs")) {
            int n = this._TunnelingClientTimeoutSecs;
            this._TunnelingClientTimeoutSecs = (Integer)object;
            this._postSet(19, n, this._TunnelingClientTimeoutSecs);
            return;
        }
        if (string.equals("TunnelingEnabled")) {
            boolean bl = this._TunnelingEnabled;
            this._TunnelingEnabled = (Boolean)object;
            this._postSet(20, bl, this._TunnelingEnabled);
            return;
        }
        if (string.equals("TwoWaySSLEnabled")) {
            boolean bl = this._TwoWaySSLEnabled;
            this._TwoWaySSLEnabled = (Boolean)object;
            this._postSet(31, bl, this._TwoWaySSLEnabled);
            return;
        }
        if (string.equals("UseFastSerialization")) {
            boolean bl = this._UseFastSerialization;
            this._UseFastSerialization = (Boolean)object;
            this._postSet(40, bl, this._UseFastSerialization);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AcceptBacklog")) {
            return new Integer(this._AcceptBacklog);
        }
        if (string.equals("ChannelIdentityCustomized")) {
            return new Boolean(this._ChannelIdentityCustomized);
        }
        if (string.equals("ChannelWeight")) {
            return new Integer(this._ChannelWeight);
        }
        if (string.equals("ClientCertificateEnforced")) {
            return new Boolean(this._ClientCertificateEnforced);
        }
        if (string.equals("ClusterAddress")) {
            return this._ClusterAddress;
        }
        if (string.equals("CompleteCOMMessageTimeout")) {
            return new Integer(this._CompleteCOMMessageTimeout);
        }
        if (string.equals("CompleteHTTPMessageTimeout")) {
            return new Integer(this._CompleteHTTPMessageTimeout);
        }
        if (string.equals("CompleteIIOPMessageTimeout")) {
            return new Integer(this._CompleteIIOPMessageTimeout);
        }
        if (string.equals("CompleteMessageTimeout")) {
            return new Integer(this._CompleteMessageTimeout);
        }
        if (string.equals("CompleteT3MessageTimeout")) {
            return new Integer(this._CompleteT3MessageTimeout);
        }
        if (string.equals("ConnectTimeout")) {
            return new Integer(this._ConnectTimeout);
        }
        if (string.equals("CustomPrivateKeyAlias")) {
            return this._CustomPrivateKeyAlias;
        }
        if (string.equals("CustomPrivateKeyPassPhrase")) {
            return this._CustomPrivateKeyPassPhrase;
        }
        if (string.equals("CustomPrivateKeyPassPhraseEncrypted")) {
            return this._CustomPrivateKeyPassPhraseEncrypted;
        }
        if (string.equals("CustomProperties")) {
            return this._CustomProperties;
        }
        if (string.equals("Enabled")) {
            return new Boolean(this._Enabled);
        }
        if (string.equals("ExternalDNSName")) {
            return this._ExternalDNSName;
        }
        if (string.equals("HttpEnabledForThisProtocol")) {
            return new Boolean(this._HttpEnabledForThisProtocol);
        }
        if (string.equals("IdleConnectionTimeout")) {
            return new Integer(this._IdleConnectionTimeout);
        }
        if (string.equals("IdleIIOPConnectionTimeout")) {
            return new Integer(this._IdleIIOPConnectionTimeout);
        }
        if (string.equals("ListenAddress")) {
            return this._ListenAddress;
        }
        if (string.equals("ListenPort")) {
            return new Integer(this._ListenPort);
        }
        if (string.equals("LoginTimeoutMillis")) {
            return new Integer(this._LoginTimeoutMillis);
        }
        if (string.equals("LoginTimeoutMillisSSL")) {
            return new Integer(this._LoginTimeoutMillisSSL);
        }
        if (string.equals("MaxBackoffBetweenFailures")) {
            return new Integer(this._MaxBackoffBetweenFailures);
        }
        if (string.equals("MaxConnectedClients")) {
            return new Integer(this._MaxConnectedClients);
        }
        if (string.equals("MaxMessageSize")) {
            return new Integer(this._MaxMessageSize);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("OutboundEnabled")) {
            return new Boolean(this._OutboundEnabled);
        }
        if (string.equals("OutboundPrivateKeyAlias")) {
            return this._OutboundPrivateKeyAlias;
        }
        if (string.equals("OutboundPrivateKeyEnabled")) {
            return new Boolean(this._OutboundPrivateKeyEnabled);
        }
        if (string.equals("OutboundPrivateKeyPassPhrase")) {
            return this._OutboundPrivateKeyPassPhrase;
        }
        if (string.equals("PrivateKeyAlias")) {
            return this._PrivateKeyAlias;
        }
        if (string.equals("PrivateKeyPassPhrase")) {
            return this._PrivateKeyPassPhrase;
        }
        if (string.equals("Protocol")) {
            return this._Protocol;
        }
        if (string.equals("ProxyAddress")) {
            return this._ProxyAddress;
        }
        if (string.equals("ProxyPort")) {
            return new Integer(this._ProxyPort);
        }
        if (string.equals("PublicAddress")) {
            return this._PublicAddress;
        }
        if (string.equals("PublicPort")) {
            return new Integer(this._PublicPort);
        }
        if (string.equals("SDPEnabled")) {
            return new Boolean(this._SDPEnabled);
        }
        if (string.equals("SSLListenPort")) {
            return new Integer(this._SSLListenPort);
        }
        if (string.equals("TimeoutConnectionWithPendingResponses")) {
            return new Boolean(this._TimeoutConnectionWithPendingResponses);
        }
        if (string.equals("TunnelingClientPingSecs")) {
            return new Integer(this._TunnelingClientPingSecs);
        }
        if (string.equals("TunnelingClientTimeoutSecs")) {
            return new Integer(this._TunnelingClientTimeoutSecs);
        }
        if (string.equals("TunnelingEnabled")) {
            return new Boolean(this._TunnelingEnabled);
        }
        if (string.equals("TwoWaySSLEnabled")) {
            return new Boolean(this._TwoWaySSLEnabled);
        }
        if (string.equals("UseFastSerialization")) {
            return new Boolean(this._UseFastSerialization);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 14: {
                    if (string.equals("accept-backlog")) {
                        return 15;
                    }
                    if (string.equals("channel-weight")) {
                        return 27;
                    }
                    if (string.equals("listen-address")) {
                        return 8;
                    }
                    if (!string.equals("public-address")) break;
                    return 9;
                }
                case 15: {
                    if (string.equals("cluster-address")) {
                        return 28;
                    }
                    if (string.equals("connect-timeout")) {
                        return 24;
                    }
                    if (!string.equals("ssl-listen-port")) break;
                    return 42;
                }
                case 27: {
                    if (string.equals("completecom-message-timeout")) {
                        return 47;
                    }
                    if (string.equals("idleiiop-connection-timeout")) {
                        return 41;
                    }
                    if (string.equals("channel-identity-customized")) {
                        return 32;
                    }
                    if (!string.equals("client-certificate-enforced")) break;
                    return 38;
                }
                case 28: {
                    if (string.equals("completehttp-message-timeout")) {
                        return 46;
                    }
                    if (string.equals("completeiiop-message-timeout")) {
                        return 48;
                    }
                    if (string.equals("max-backoff-between-failures")) {
                        return 16;
                    }
                    if (!string.equals("outbound-private-key-enabled")) break;
                    return 39;
                }
                case 24: {
                    if (string.equals("complete-message-timeout")) {
                        return 21;
                    }
                    if (!string.equals("custom-private-key-alias")) break;
                    return 33;
                }
                case 26: {
                    if (string.equals("completet3-message-timeout")) {
                        return 45;
                    }
                    if (string.equals("outbound-private-key-alias")) {
                        return 51;
                    }
                    if (!string.equals("tunneling-client-ping-secs")) break;
                    return 18;
                }
                case 30: {
                    if (string.equals("custom-private-key-pass-phrase")) {
                        return 35;
                    }
                    if (!string.equals("http-enabled-for-this-protocol")) break;
                    return 14;
                }
                case 40: {
                    if (!string.equals("custom-private-key-pass-phrase-encrypted")) break;
                    return 37;
                }
                case 17: {
                    if (string.equals("custom-properties")) {
                        return 49;
                    }
                    if (string.equals("private-key-alias")) {
                        return 34;
                    }
                    if (!string.equals("tunneling-enabled")) break;
                    return 20;
                }
                case 16: {
                    if (string.equals("externaldns-name")) {
                        return 43;
                    }
                    if (string.equals("max-message-size")) {
                        return 25;
                    }
                    if (!string.equals("outbound-enabled")) break;
                    return 26;
                }
                case 23: {
                    if (string.equals("idle-connection-timeout")) {
                        return 23;
                    }
                    if (string.equals("login-timeout-millisssl")) {
                        return 44;
                    }
                    if (!string.equals("private-key-pass-phrase")) break;
                    return 36;
                }
                case 11: {
                    if (string.equals("listen-port")) {
                        return 10;
                    }
                    if (string.equals("public-port")) {
                        return 11;
                    }
                    if (!string.equals("sdp-enabled")) break;
                    return 50;
                }
                case 20: {
                    if (!string.equals("login-timeout-millis")) break;
                    return 17;
                }
                case 21: {
                    if (!string.equals("max-connected-clients")) break;
                    return 30;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 32: {
                    if (!string.equals("outbound-private-key-pass-phrase")) break;
                    return 52;
                }
                case 8: {
                    if (!string.equals("protocol")) break;
                    return 7;
                }
                case 13: {
                    if (!string.equals("proxy-address")) break;
                    return 12;
                }
                case 10: {
                    if (!string.equals("proxy-port")) break;
                    return 13;
                }
                case 41: {
                    if (!string.equals("timeout-connection-with-pending-responses")) break;
                    return 22;
                }
                case 29: {
                    if (!string.equals("tunneling-client-timeout-secs")) break;
                    return 19;
                }
                case 22: {
                    if (!string.equals("use-fast-serialization")) break;
                    return 40;
                }
                case 7: {
                    if (!string.equals("enabled")) break;
                    return 29;
                }
                case 18: {
                    if (!string.equals("two-wayssl-enabled")) break;
                    return 31;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 15: {
                    return "accept-backlog";
                }
                case 27: {
                    return "channel-weight";
                }
                case 28: {
                    return "cluster-address";
                }
                case 47: {
                    return "completecom-message-timeout";
                }
                case 46: {
                    return "completehttp-message-timeout";
                }
                case 48: {
                    return "completeiiop-message-timeout";
                }
                case 21: {
                    return "complete-message-timeout";
                }
                case 45: {
                    return "completet3-message-timeout";
                }
                case 24: {
                    return "connect-timeout";
                }
                case 33: {
                    return "custom-private-key-alias";
                }
                case 35: {
                    return "custom-private-key-pass-phrase";
                }
                case 37: {
                    return "custom-private-key-pass-phrase-encrypted";
                }
                case 49: {
                    return "custom-properties";
                }
                case 43: {
                    return "externaldns-name";
                }
                case 23: {
                    return "idle-connection-timeout";
                }
                case 41: {
                    return "idleiiop-connection-timeout";
                }
                case 8: {
                    return "listen-address";
                }
                case 10: {
                    return "listen-port";
                }
                case 17: {
                    return "login-timeout-millis";
                }
                case 44: {
                    return "login-timeout-millisssl";
                }
                case 16: {
                    return "max-backoff-between-failures";
                }
                case 30: {
                    return "max-connected-clients";
                }
                case 25: {
                    return "max-message-size";
                }
                case 2: {
                    return "name";
                }
                case 51: {
                    return "outbound-private-key-alias";
                }
                case 52: {
                    return "outbound-private-key-pass-phrase";
                }
                case 34: {
                    return "private-key-alias";
                }
                case 36: {
                    return "private-key-pass-phrase";
                }
                case 7: {
                    return "protocol";
                }
                case 12: {
                    return "proxy-address";
                }
                case 13: {
                    return "proxy-port";
                }
                case 9: {
                    return "public-address";
                }
                case 11: {
                    return "public-port";
                }
                case 42: {
                    return "ssl-listen-port";
                }
                case 22: {
                    return "timeout-connection-with-pending-responses";
                }
                case 18: {
                    return "tunneling-client-ping-secs";
                }
                case 19: {
                    return "tunneling-client-timeout-secs";
                }
                case 40: {
                    return "use-fast-serialization";
                }
                case 32: {
                    return "channel-identity-customized";
                }
                case 38: {
                    return "client-certificate-enforced";
                }
                case 29: {
                    return "enabled";
                }
                case 14: {
                    return "http-enabled-for-this-protocol";
                }
                case 26: {
                    return "outbound-enabled";
                }
                case 39: {
                    return "outbound-private-key-enabled";
                }
                case 50: {
                    return "sdp-enabled";
                }
                case 20: {
                    return "tunneling-enabled";
                }
                case 31: {
                    return "two-wayssl-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 15: {
                    return true;
                }
                case 28: {
                    return true;
                }
                case 47: {
                    return true;
                }
                case 46: {
                    return true;
                }
                case 48: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 45: {
                    return true;
                }
                case 24: {
                    return true;
                }
                case 33: {
                    return true;
                }
                case 35: {
                    return true;
                }
                case 49: {
                    return true;
                }
                case 23: {
                    return true;
                }
                case 41: {
                    return true;
                }
                case 17: {
                    return true;
                }
                case 44: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 25: {
                    return true;
                }
                case 34: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 19: {
                    return true;
                }
                case 40: {
                    return true;
                }
                case 32: {
                    return true;
                }
                case 38: {
                    return true;
                }
                case 26: {
                    return true;
                }
                case 39: {
                    return true;
                }
                case 50: {
                    return true;
                }
                case 31: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private NetworkAccessPointMBeanImpl bean;

        protected Helper(NetworkAccessPointMBeanImpl networkAccessPointMBeanImpl) {
            super(networkAccessPointMBeanImpl);
            this.bean = networkAccessPointMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 15: {
                    return "AcceptBacklog";
                }
                case 27: {
                    return "ChannelWeight";
                }
                case 28: {
                    return "ClusterAddress";
                }
                case 47: {
                    return "CompleteCOMMessageTimeout";
                }
                case 46: {
                    return "CompleteHTTPMessageTimeout";
                }
                case 48: {
                    return "CompleteIIOPMessageTimeout";
                }
                case 21: {
                    return "CompleteMessageTimeout";
                }
                case 45: {
                    return "CompleteT3MessageTimeout";
                }
                case 24: {
                    return "ConnectTimeout";
                }
                case 33: {
                    return "CustomPrivateKeyAlias";
                }
                case 35: {
                    return "CustomPrivateKeyPassPhrase";
                }
                case 37: {
                    return "CustomPrivateKeyPassPhraseEncrypted";
                }
                case 49: {
                    return "CustomProperties";
                }
                case 43: {
                    return "ExternalDNSName";
                }
                case 23: {
                    return "IdleConnectionTimeout";
                }
                case 41: {
                    return "IdleIIOPConnectionTimeout";
                }
                case 8: {
                    return "ListenAddress";
                }
                case 10: {
                    return "ListenPort";
                }
                case 17: {
                    return "LoginTimeoutMillis";
                }
                case 44: {
                    return "LoginTimeoutMillisSSL";
                }
                case 16: {
                    return "MaxBackoffBetweenFailures";
                }
                case 30: {
                    return "MaxConnectedClients";
                }
                case 25: {
                    return "MaxMessageSize";
                }
                case 2: {
                    return "Name";
                }
                case 51: {
                    return "OutboundPrivateKeyAlias";
                }
                case 52: {
                    return "OutboundPrivateKeyPassPhrase";
                }
                case 34: {
                    return "PrivateKeyAlias";
                }
                case 36: {
                    return "PrivateKeyPassPhrase";
                }
                case 7: {
                    return "Protocol";
                }
                case 12: {
                    return "ProxyAddress";
                }
                case 13: {
                    return "ProxyPort";
                }
                case 9: {
                    return "PublicAddress";
                }
                case 11: {
                    return "PublicPort";
                }
                case 42: {
                    return "SSLListenPort";
                }
                case 22: {
                    return "TimeoutConnectionWithPendingResponses";
                }
                case 18: {
                    return "TunnelingClientPingSecs";
                }
                case 19: {
                    return "TunnelingClientTimeoutSecs";
                }
                case 40: {
                    return "UseFastSerialization";
                }
                case 32: {
                    return "ChannelIdentityCustomized";
                }
                case 38: {
                    return "ClientCertificateEnforced";
                }
                case 29: {
                    return "Enabled";
                }
                case 14: {
                    return "HttpEnabledForThisProtocol";
                }
                case 26: {
                    return "OutboundEnabled";
                }
                case 39: {
                    return "OutboundPrivateKeyEnabled";
                }
                case 50: {
                    return "SDPEnabled";
                }
                case 20: {
                    return "TunnelingEnabled";
                }
                case 31: {
                    return "TwoWaySSLEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AcceptBacklog")) {
                return 15;
            }
            if (string.equals("ChannelWeight")) {
                return 27;
            }
            if (string.equals("ClusterAddress")) {
                return 28;
            }
            if (string.equals("CompleteCOMMessageTimeout")) {
                return 47;
            }
            if (string.equals("CompleteHTTPMessageTimeout")) {
                return 46;
            }
            if (string.equals("CompleteIIOPMessageTimeout")) {
                return 48;
            }
            if (string.equals("CompleteMessageTimeout")) {
                return 21;
            }
            if (string.equals("CompleteT3MessageTimeout")) {
                return 45;
            }
            if (string.equals("ConnectTimeout")) {
                return 24;
            }
            if (string.equals("CustomPrivateKeyAlias")) {
                return 33;
            }
            if (string.equals("CustomPrivateKeyPassPhrase")) {
                return 35;
            }
            if (string.equals("CustomPrivateKeyPassPhraseEncrypted")) {
                return 37;
            }
            if (string.equals("CustomProperties")) {
                return 49;
            }
            if (string.equals("ExternalDNSName")) {
                return 43;
            }
            if (string.equals("IdleConnectionTimeout")) {
                return 23;
            }
            if (string.equals("IdleIIOPConnectionTimeout")) {
                return 41;
            }
            if (string.equals("ListenAddress")) {
                return 8;
            }
            if (string.equals("ListenPort")) {
                return 10;
            }
            if (string.equals("LoginTimeoutMillis")) {
                return 17;
            }
            if (string.equals("LoginTimeoutMillisSSL")) {
                return 44;
            }
            if (string.equals("MaxBackoffBetweenFailures")) {
                return 16;
            }
            if (string.equals("MaxConnectedClients")) {
                return 30;
            }
            if (string.equals("MaxMessageSize")) {
                return 25;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("OutboundPrivateKeyAlias")) {
                return 51;
            }
            if (string.equals("OutboundPrivateKeyPassPhrase")) {
                return 52;
            }
            if (string.equals("PrivateKeyAlias")) {
                return 34;
            }
            if (string.equals("PrivateKeyPassPhrase")) {
                return 36;
            }
            if (string.equals("Protocol")) {
                return 7;
            }
            if (string.equals("ProxyAddress")) {
                return 12;
            }
            if (string.equals("ProxyPort")) {
                return 13;
            }
            if (string.equals("PublicAddress")) {
                return 9;
            }
            if (string.equals("PublicPort")) {
                return 11;
            }
            if (string.equals("SSLListenPort")) {
                return 42;
            }
            if (string.equals("TimeoutConnectionWithPendingResponses")) {
                return 22;
            }
            if (string.equals("TunnelingClientPingSecs")) {
                return 18;
            }
            if (string.equals("TunnelingClientTimeoutSecs")) {
                return 19;
            }
            if (string.equals("UseFastSerialization")) {
                return 40;
            }
            if (string.equals("ChannelIdentityCustomized")) {
                return 32;
            }
            if (string.equals("ClientCertificateEnforced")) {
                return 38;
            }
            if (string.equals("Enabled")) {
                return 29;
            }
            if (string.equals("HttpEnabledForThisProtocol")) {
                return 14;
            }
            if (string.equals("OutboundEnabled")) {
                return 26;
            }
            if (string.equals("OutboundPrivateKeyEnabled")) {
                return 39;
            }
            if (string.equals("SDPEnabled")) {
                return 50;
            }
            if (string.equals("TunnelingEnabled")) {
                return 20;
            }
            if (string.equals("TwoWaySSLEnabled")) {
                return 31;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAcceptBacklogSet()) {
                    stringBuffer.append("AcceptBacklog");
                    stringBuffer.append(String.valueOf(this.bean.getAcceptBacklog()));
                }
                if (this.bean.isChannelWeightSet()) {
                    stringBuffer.append("ChannelWeight");
                    stringBuffer.append(String.valueOf(this.bean.getChannelWeight()));
                }
                if (this.bean.isClusterAddressSet()) {
                    stringBuffer.append("ClusterAddress");
                    stringBuffer.append(String.valueOf(this.bean.getClusterAddress()));
                }
                if (this.bean.isCompleteCOMMessageTimeoutSet()) {
                    stringBuffer.append("CompleteCOMMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteCOMMessageTimeout()));
                }
                if (this.bean.isCompleteHTTPMessageTimeoutSet()) {
                    stringBuffer.append("CompleteHTTPMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteHTTPMessageTimeout()));
                }
                if (this.bean.isCompleteIIOPMessageTimeoutSet()) {
                    stringBuffer.append("CompleteIIOPMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteIIOPMessageTimeout()));
                }
                if (this.bean.isCompleteMessageTimeoutSet()) {
                    stringBuffer.append("CompleteMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteMessageTimeout()));
                }
                if (this.bean.isCompleteT3MessageTimeoutSet()) {
                    stringBuffer.append("CompleteT3MessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteT3MessageTimeout()));
                }
                if (this.bean.isConnectTimeoutSet()) {
                    stringBuffer.append("ConnectTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getConnectTimeout()));
                }
                if (this.bean.isCustomPrivateKeyAliasSet()) {
                    stringBuffer.append("CustomPrivateKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getCustomPrivateKeyAlias()));
                }
                if (this.bean.isCustomPrivateKeyPassPhraseSet()) {
                    stringBuffer.append("CustomPrivateKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getCustomPrivateKeyPassPhrase()));
                }
                if (this.bean.isCustomPrivateKeyPassPhraseEncryptedSet()) {
                    stringBuffer.append("CustomPrivateKeyPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getCustomPrivateKeyPassPhraseEncrypted())));
                }
                if (this.bean.isCustomPropertiesSet()) {
                    stringBuffer.append("CustomProperties");
                    stringBuffer.append(String.valueOf(this.bean.getCustomProperties()));
                }
                if (this.bean.isExternalDNSNameSet()) {
                    stringBuffer.append("ExternalDNSName");
                    stringBuffer.append(String.valueOf(this.bean.getExternalDNSName()));
                }
                if (this.bean.isIdleConnectionTimeoutSet()) {
                    stringBuffer.append("IdleConnectionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getIdleConnectionTimeout()));
                }
                if (this.bean.isIdleIIOPConnectionTimeoutSet()) {
                    stringBuffer.append("IdleIIOPConnectionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getIdleIIOPConnectionTimeout()));
                }
                if (this.bean.isListenAddressSet()) {
                    stringBuffer.append("ListenAddress");
                    stringBuffer.append(String.valueOf(this.bean.getListenAddress()));
                }
                if (this.bean.isListenPortSet()) {
                    stringBuffer.append("ListenPort");
                    stringBuffer.append(String.valueOf(this.bean.getListenPort()));
                }
                if (this.bean.isLoginTimeoutMillisSet()) {
                    stringBuffer.append("LoginTimeoutMillis");
                    stringBuffer.append(String.valueOf(this.bean.getLoginTimeoutMillis()));
                }
                if (this.bean.isLoginTimeoutMillisSSLSet()) {
                    stringBuffer.append("LoginTimeoutMillisSSL");
                    stringBuffer.append(String.valueOf(this.bean.getLoginTimeoutMillisSSL()));
                }
                if (this.bean.isMaxBackoffBetweenFailuresSet()) {
                    stringBuffer.append("MaxBackoffBetweenFailures");
                    stringBuffer.append(String.valueOf(this.bean.getMaxBackoffBetweenFailures()));
                }
                if (this.bean.isMaxConnectedClientsSet()) {
                    stringBuffer.append("MaxConnectedClients");
                    stringBuffer.append(String.valueOf(this.bean.getMaxConnectedClients()));
                }
                if (this.bean.isMaxMessageSizeSet()) {
                    stringBuffer.append("MaxMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxMessageSize()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isOutboundPrivateKeyAliasSet()) {
                    stringBuffer.append("OutboundPrivateKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getOutboundPrivateKeyAlias()));
                }
                if (this.bean.isOutboundPrivateKeyPassPhraseSet()) {
                    stringBuffer.append("OutboundPrivateKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getOutboundPrivateKeyPassPhrase()));
                }
                if (this.bean.isPrivateKeyAliasSet()) {
                    stringBuffer.append("PrivateKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getPrivateKeyAlias()));
                }
                if (this.bean.isPrivateKeyPassPhraseSet()) {
                    stringBuffer.append("PrivateKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getPrivateKeyPassPhrase()));
                }
                if (this.bean.isProtocolSet()) {
                    stringBuffer.append("Protocol");
                    stringBuffer.append(String.valueOf(this.bean.getProtocol()));
                }
                if (this.bean.isProxyAddressSet()) {
                    stringBuffer.append("ProxyAddress");
                    stringBuffer.append(String.valueOf(this.bean.getProxyAddress()));
                }
                if (this.bean.isProxyPortSet()) {
                    stringBuffer.append("ProxyPort");
                    stringBuffer.append(String.valueOf(this.bean.getProxyPort()));
                }
                if (this.bean.isPublicAddressSet()) {
                    stringBuffer.append("PublicAddress");
                    stringBuffer.append(String.valueOf(this.bean.getPublicAddress()));
                }
                if (this.bean.isPublicPortSet()) {
                    stringBuffer.append("PublicPort");
                    stringBuffer.append(String.valueOf(this.bean.getPublicPort()));
                }
                if (this.bean.isSSLListenPortSet()) {
                    stringBuffer.append("SSLListenPort");
                    stringBuffer.append(String.valueOf(this.bean.getSSLListenPort()));
                }
                if (this.bean.isTimeoutConnectionWithPendingResponsesSet()) {
                    stringBuffer.append("TimeoutConnectionWithPendingResponses");
                    stringBuffer.append(String.valueOf(this.bean.getTimeoutConnectionWithPendingResponses()));
                }
                if (this.bean.isTunnelingClientPingSecsSet()) {
                    stringBuffer.append("TunnelingClientPingSecs");
                    stringBuffer.append(String.valueOf(this.bean.getTunnelingClientPingSecs()));
                }
                if (this.bean.isTunnelingClientTimeoutSecsSet()) {
                    stringBuffer.append("TunnelingClientTimeoutSecs");
                    stringBuffer.append(String.valueOf(this.bean.getTunnelingClientTimeoutSecs()));
                }
                if (this.bean.isUseFastSerializationSet()) {
                    stringBuffer.append("UseFastSerialization");
                    stringBuffer.append(String.valueOf(this.bean.getUseFastSerialization()));
                }
                if (this.bean.isChannelIdentityCustomizedSet()) {
                    stringBuffer.append("ChannelIdentityCustomized");
                    stringBuffer.append(String.valueOf(this.bean.isChannelIdentityCustomized()));
                }
                if (this.bean.isClientCertificateEnforcedSet()) {
                    stringBuffer.append("ClientCertificateEnforced");
                    stringBuffer.append(String.valueOf(this.bean.isClientCertificateEnforced()));
                }
                if (this.bean.isEnabledSet()) {
                    stringBuffer.append("Enabled");
                    stringBuffer.append(String.valueOf(this.bean.isEnabled()));
                }
                if (this.bean.isHttpEnabledForThisProtocolSet()) {
                    stringBuffer.append("HttpEnabledForThisProtocol");
                    stringBuffer.append(String.valueOf(this.bean.isHttpEnabledForThisProtocol()));
                }
                if (this.bean.isOutboundEnabledSet()) {
                    stringBuffer.append("OutboundEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOutboundEnabled()));
                }
                if (this.bean.isOutboundPrivateKeyEnabledSet()) {
                    stringBuffer.append("OutboundPrivateKeyEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOutboundPrivateKeyEnabled()));
                }
                if (this.bean.isSDPEnabledSet()) {
                    stringBuffer.append("SDPEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSDPEnabled()));
                }
                if (this.bean.isTunnelingEnabledSet()) {
                    stringBuffer.append("TunnelingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isTunnelingEnabled()));
                }
                if (this.bean.isTwoWaySSLEnabledSet()) {
                    stringBuffer.append("TwoWaySSLEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isTwoWaySSLEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                NetworkAccessPointMBeanImpl networkAccessPointMBeanImpl = (NetworkAccessPointMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AcceptBacklog", this.bean.getAcceptBacklog(), networkAccessPointMBeanImpl.getAcceptBacklog(), true);
                this.computeDiff("ChannelWeight", this.bean.getChannelWeight(), networkAccessPointMBeanImpl.getChannelWeight(), true);
                this.computeDiff("ClusterAddress", this.bean.getClusterAddress(), networkAccessPointMBeanImpl.getClusterAddress(), true);
                this.computeDiff("CompleteCOMMessageTimeout", this.bean.getCompleteCOMMessageTimeout(), networkAccessPointMBeanImpl.getCompleteCOMMessageTimeout(), true);
                this.computeDiff("CompleteHTTPMessageTimeout", this.bean.getCompleteHTTPMessageTimeout(), networkAccessPointMBeanImpl.getCompleteHTTPMessageTimeout(), true);
                this.computeDiff("CompleteIIOPMessageTimeout", this.bean.getCompleteIIOPMessageTimeout(), networkAccessPointMBeanImpl.getCompleteIIOPMessageTimeout(), true);
                this.computeDiff("CompleteMessageTimeout", this.bean.getCompleteMessageTimeout(), networkAccessPointMBeanImpl.getCompleteMessageTimeout(), true);
                this.computeDiff("CompleteT3MessageTimeout", this.bean.getCompleteT3MessageTimeout(), networkAccessPointMBeanImpl.getCompleteT3MessageTimeout(), true);
                this.computeDiff("ConnectTimeout", this.bean.getConnectTimeout(), networkAccessPointMBeanImpl.getConnectTimeout(), true);
                this.computeDiff("CustomPrivateKeyAlias", this.bean.getCustomPrivateKeyAlias(), networkAccessPointMBeanImpl.getCustomPrivateKeyAlias(), true);
                this.computeDiff("CustomPrivateKeyPassPhraseEncrypted", this.bean.getCustomPrivateKeyPassPhraseEncrypted(), networkAccessPointMBeanImpl.getCustomPrivateKeyPassPhraseEncrypted(), false);
                this.computeDiff("CustomProperties", this.bean.getCustomProperties(), networkAccessPointMBeanImpl.getCustomProperties(), false);
                this.computeDiff("ExternalDNSName", this.bean.getExternalDNSName(), networkAccessPointMBeanImpl.getExternalDNSName(), false);
                this.computeDiff("IdleConnectionTimeout", this.bean.getIdleConnectionTimeout(), networkAccessPointMBeanImpl.getIdleConnectionTimeout(), true);
                this.computeDiff("IdleIIOPConnectionTimeout", this.bean.getIdleIIOPConnectionTimeout(), networkAccessPointMBeanImpl.getIdleIIOPConnectionTimeout(), true);
                this.computeDiff("ListenAddress", this.bean.getListenAddress(), networkAccessPointMBeanImpl.getListenAddress(), false);
                this.computeDiff("ListenPort", this.bean.getListenPort(), networkAccessPointMBeanImpl.getListenPort(), false);
                this.computeDiff("LoginTimeoutMillis", this.bean.getLoginTimeoutMillis(), networkAccessPointMBeanImpl.getLoginTimeoutMillis(), true);
                this.computeDiff("LoginTimeoutMillisSSL", this.bean.getLoginTimeoutMillisSSL(), networkAccessPointMBeanImpl.getLoginTimeoutMillisSSL(), true);
                this.computeDiff("MaxBackoffBetweenFailures", this.bean.getMaxBackoffBetweenFailures(), networkAccessPointMBeanImpl.getMaxBackoffBetweenFailures(), true);
                this.computeDiff("MaxConnectedClients", this.bean.getMaxConnectedClients(), networkAccessPointMBeanImpl.getMaxConnectedClients(), true);
                this.computeDiff("MaxMessageSize", this.bean.getMaxMessageSize(), networkAccessPointMBeanImpl.getMaxMessageSize(), true);
                this.computeDiff("Name", this.bean.getName(), networkAccessPointMBeanImpl.getName(), false);
                this.computeDiff("OutboundPrivateKeyAlias", this.bean.getOutboundPrivateKeyAlias(), networkAccessPointMBeanImpl.getOutboundPrivateKeyAlias(), true);
                this.computeDiff("OutboundPrivateKeyPassPhrase", this.bean.getOutboundPrivateKeyPassPhrase(), networkAccessPointMBeanImpl.getOutboundPrivateKeyPassPhrase(), true);
                this.computeDiff("PrivateKeyAlias", this.bean.getPrivateKeyAlias(), networkAccessPointMBeanImpl.getPrivateKeyAlias(), true);
                this.computeDiff("PrivateKeyPassPhrase", this.bean.getPrivateKeyPassPhrase(), networkAccessPointMBeanImpl.getPrivateKeyPassPhrase(), true);
                this.computeDiff("Protocol", this.bean.getProtocol(), networkAccessPointMBeanImpl.getProtocol(), false);
                this.computeDiff("ProxyAddress", this.bean.getProxyAddress(), networkAccessPointMBeanImpl.getProxyAddress(), true);
                this.computeDiff("ProxyPort", this.bean.getProxyPort(), networkAccessPointMBeanImpl.getProxyPort(), true);
                this.computeDiff("PublicAddress", this.bean.getPublicAddress(), networkAccessPointMBeanImpl.getPublicAddress(), true);
                this.computeDiff("PublicPort", this.bean.getPublicPort(), networkAccessPointMBeanImpl.getPublicPort(), true);
                this.computeDiff("SSLListenPort", this.bean.getSSLListenPort(), networkAccessPointMBeanImpl.getSSLListenPort(), false);
                this.computeDiff("TimeoutConnectionWithPendingResponses", this.bean.getTimeoutConnectionWithPendingResponses(), networkAccessPointMBeanImpl.getTimeoutConnectionWithPendingResponses(), true);
                this.computeDiff("TunnelingClientPingSecs", this.bean.getTunnelingClientPingSecs(), networkAccessPointMBeanImpl.getTunnelingClientPingSecs(), true);
                this.computeDiff("TunnelingClientTimeoutSecs", this.bean.getTunnelingClientTimeoutSecs(), networkAccessPointMBeanImpl.getTunnelingClientTimeoutSecs(), true);
                this.computeDiff("UseFastSerialization", this.bean.getUseFastSerialization(), networkAccessPointMBeanImpl.getUseFastSerialization(), true);
                this.computeDiff("ChannelIdentityCustomized", this.bean.isChannelIdentityCustomized(), networkAccessPointMBeanImpl.isChannelIdentityCustomized(), true);
                this.computeDiff("ClientCertificateEnforced", this.bean.isClientCertificateEnforced(), networkAccessPointMBeanImpl.isClientCertificateEnforced(), true);
                this.computeDiff("Enabled", this.bean.isEnabled(), networkAccessPointMBeanImpl.isEnabled(), true);
                this.computeDiff("HttpEnabledForThisProtocol", this.bean.isHttpEnabledForThisProtocol(), networkAccessPointMBeanImpl.isHttpEnabledForThisProtocol(), true);
                this.computeDiff("OutboundEnabled", this.bean.isOutboundEnabled(), networkAccessPointMBeanImpl.isOutboundEnabled(), true);
                this.computeDiff("OutboundPrivateKeyEnabled", this.bean.isOutboundPrivateKeyEnabled(), networkAccessPointMBeanImpl.isOutboundPrivateKeyEnabled(), true);
                this.computeDiff("SDPEnabled", this.bean.isSDPEnabled(), networkAccessPointMBeanImpl.isSDPEnabled(), false);
                this.computeDiff("TunnelingEnabled", this.bean.isTunnelingEnabled(), networkAccessPointMBeanImpl.isTunnelingEnabled(), true);
                this.computeDiff("TwoWaySSLEnabled", this.bean.isTwoWaySSLEnabled(), networkAccessPointMBeanImpl.isTwoWaySSLEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                NetworkAccessPointMBeanImpl networkAccessPointMBeanImpl = (NetworkAccessPointMBeanImpl)beanUpdateEvent.getSourceBean();
                NetworkAccessPointMBeanImpl networkAccessPointMBeanImpl2 = (NetworkAccessPointMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AcceptBacklog")) {
                    networkAccessPointMBeanImpl.setAcceptBacklog(networkAccessPointMBeanImpl2.getAcceptBacklog());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("ChannelWeight")) {
                    networkAccessPointMBeanImpl.setChannelWeight(networkAccessPointMBeanImpl2.getChannelWeight());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("ClusterAddress")) {
                    networkAccessPointMBeanImpl.setClusterAddress(networkAccessPointMBeanImpl2.getClusterAddress());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("CompleteCOMMessageTimeout")) {
                    networkAccessPointMBeanImpl.setCompleteCOMMessageTimeout(networkAccessPointMBeanImpl2.getCompleteCOMMessageTimeout());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 47);
                } else if (string.equals("CompleteHTTPMessageTimeout")) {
                    networkAccessPointMBeanImpl.setCompleteHTTPMessageTimeout(networkAccessPointMBeanImpl2.getCompleteHTTPMessageTimeout());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 46);
                } else if (string.equals("CompleteIIOPMessageTimeout")) {
                    networkAccessPointMBeanImpl.setCompleteIIOPMessageTimeout(networkAccessPointMBeanImpl2.getCompleteIIOPMessageTimeout());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 48);
                } else if (string.equals("CompleteMessageTimeout")) {
                    networkAccessPointMBeanImpl.setCompleteMessageTimeout(networkAccessPointMBeanImpl2.getCompleteMessageTimeout());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("CompleteT3MessageTimeout")) {
                    networkAccessPointMBeanImpl.setCompleteT3MessageTimeout(networkAccessPointMBeanImpl2.getCompleteT3MessageTimeout());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 45);
                } else if (string.equals("ConnectTimeout")) {
                    networkAccessPointMBeanImpl.setConnectTimeout(networkAccessPointMBeanImpl2.getConnectTimeout());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("CustomPrivateKeyAlias")) {
                    networkAccessPointMBeanImpl.setCustomPrivateKeyAlias(networkAccessPointMBeanImpl2.getCustomPrivateKeyAlias());
                    networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                } else if (!string.equals("CustomPrivateKeyPassPhrase")) {
                    if (string.equals("CustomPrivateKeyPassPhraseEncrypted")) {
                        networkAccessPointMBeanImpl.setCustomPrivateKeyPassPhraseEncrypted(networkAccessPointMBeanImpl2.getCustomPrivateKeyPassPhraseEncrypted());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                    } else if (string.equals("CustomProperties")) {
                        networkAccessPointMBeanImpl.setCustomProperties(networkAccessPointMBeanImpl2.getCustomProperties() == null ? null : (Properties)networkAccessPointMBeanImpl2.getCustomProperties().clone());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 49);
                    } else if (string.equals("ExternalDNSName")) {
                        networkAccessPointMBeanImpl.setExternalDNSName(networkAccessPointMBeanImpl2.getExternalDNSName());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 43);
                    } else if (string.equals("IdleConnectionTimeout")) {
                        networkAccessPointMBeanImpl.setIdleConnectionTimeout(networkAccessPointMBeanImpl2.getIdleConnectionTimeout());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                    } else if (string.equals("IdleIIOPConnectionTimeout")) {
                        networkAccessPointMBeanImpl.setIdleIIOPConnectionTimeout(networkAccessPointMBeanImpl2.getIdleIIOPConnectionTimeout());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 41);
                    } else if (string.equals("ListenAddress")) {
                        networkAccessPointMBeanImpl.setListenAddress(networkAccessPointMBeanImpl2.getListenAddress());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("ListenPort")) {
                        networkAccessPointMBeanImpl.setListenPort(networkAccessPointMBeanImpl2.getListenPort());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("LoginTimeoutMillis")) {
                        networkAccessPointMBeanImpl.setLoginTimeoutMillis(networkAccessPointMBeanImpl2.getLoginTimeoutMillis());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("LoginTimeoutMillisSSL")) {
                        networkAccessPointMBeanImpl.setLoginTimeoutMillisSSL(networkAccessPointMBeanImpl2.getLoginTimeoutMillisSSL());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 44);
                    } else if (string.equals("MaxBackoffBetweenFailures")) {
                        networkAccessPointMBeanImpl.setMaxBackoffBetweenFailures(networkAccessPointMBeanImpl2.getMaxBackoffBetweenFailures());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("MaxConnectedClients")) {
                        networkAccessPointMBeanImpl.setMaxConnectedClients(networkAccessPointMBeanImpl2.getMaxConnectedClients());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                    } else if (string.equals("MaxMessageSize")) {
                        networkAccessPointMBeanImpl.setMaxMessageSize(networkAccessPointMBeanImpl2.getMaxMessageSize());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                    } else if (string.equals("Name")) {
                        networkAccessPointMBeanImpl.setName(networkAccessPointMBeanImpl2.getName());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("OutboundPrivateKeyAlias")) {
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 51);
                    } else if (string.equals("OutboundPrivateKeyPassPhrase")) {
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 52);
                    } else if (string.equals("PrivateKeyAlias")) {
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                    } else if (string.equals("PrivateKeyPassPhrase")) {
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                    } else if (string.equals("Protocol")) {
                        networkAccessPointMBeanImpl.setProtocol(networkAccessPointMBeanImpl2.getProtocol());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("ProxyAddress")) {
                        networkAccessPointMBeanImpl.setProxyAddress(networkAccessPointMBeanImpl2.getProxyAddress());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("ProxyPort")) {
                        networkAccessPointMBeanImpl.setProxyPort(networkAccessPointMBeanImpl2.getProxyPort());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("PublicAddress")) {
                        networkAccessPointMBeanImpl.setPublicAddress(networkAccessPointMBeanImpl2.getPublicAddress());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("PublicPort")) {
                        networkAccessPointMBeanImpl.setPublicPort(networkAccessPointMBeanImpl2.getPublicPort());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("SSLListenPort")) {
                        networkAccessPointMBeanImpl.setSSLListenPort(networkAccessPointMBeanImpl2.getSSLListenPort());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                    } else if (string.equals("TimeoutConnectionWithPendingResponses")) {
                        networkAccessPointMBeanImpl.setTimeoutConnectionWithPendingResponses(networkAccessPointMBeanImpl2.getTimeoutConnectionWithPendingResponses());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                    } else if (string.equals("TunnelingClientPingSecs")) {
                        networkAccessPointMBeanImpl.setTunnelingClientPingSecs(networkAccessPointMBeanImpl2.getTunnelingClientPingSecs());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("TunnelingClientTimeoutSecs")) {
                        networkAccessPointMBeanImpl.setTunnelingClientTimeoutSecs(networkAccessPointMBeanImpl2.getTunnelingClientTimeoutSecs());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else if (string.equals("UseFastSerialization")) {
                        networkAccessPointMBeanImpl.setUseFastSerialization(networkAccessPointMBeanImpl2.getUseFastSerialization());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                    } else if (string.equals("ChannelIdentityCustomized")) {
                        networkAccessPointMBeanImpl.setChannelIdentityCustomized(networkAccessPointMBeanImpl2.isChannelIdentityCustomized());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                    } else if (string.equals("ClientCertificateEnforced")) {
                        networkAccessPointMBeanImpl.setClientCertificateEnforced(networkAccessPointMBeanImpl2.isClientCertificateEnforced());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                    } else if (string.equals("Enabled")) {
                        networkAccessPointMBeanImpl.setEnabled(networkAccessPointMBeanImpl2.isEnabled());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                    } else if (string.equals("HttpEnabledForThisProtocol")) {
                        networkAccessPointMBeanImpl.setHttpEnabledForThisProtocol(networkAccessPointMBeanImpl2.isHttpEnabledForThisProtocol());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (string.equals("OutboundEnabled")) {
                        networkAccessPointMBeanImpl.setOutboundEnabled(networkAccessPointMBeanImpl2.isOutboundEnabled());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                    } else if (string.equals("OutboundPrivateKeyEnabled")) {
                        networkAccessPointMBeanImpl.setOutboundPrivateKeyEnabled(networkAccessPointMBeanImpl2.isOutboundPrivateKeyEnabled());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                    } else if (string.equals("SDPEnabled")) {
                        networkAccessPointMBeanImpl.setSDPEnabled(networkAccessPointMBeanImpl2.isSDPEnabled());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 50);
                    } else if (string.equals("TunnelingEnabled")) {
                        networkAccessPointMBeanImpl.setTunnelingEnabled(networkAccessPointMBeanImpl2.isTunnelingEnabled());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                    } else if (string.equals("TwoWaySSLEnabled")) {
                        networkAccessPointMBeanImpl.setTwoWaySSLEnabled(networkAccessPointMBeanImpl2.isTwoWaySSLEnabled());
                        networkAccessPointMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                NetworkAccessPointMBeanImpl networkAccessPointMBeanImpl = (NetworkAccessPointMBeanImpl)abstractDescriptorBean;
                super.finishCopy(networkAccessPointMBeanImpl, bl, list);
                if ((list == null || !list.contains("AcceptBacklog")) && this.bean.isAcceptBacklogSet()) {
                    networkAccessPointMBeanImpl.setAcceptBacklog(this.bean.getAcceptBacklog());
                }
                if ((list == null || !list.contains("ChannelWeight")) && this.bean.isChannelWeightSet()) {
                    networkAccessPointMBeanImpl.setChannelWeight(this.bean.getChannelWeight());
                }
                if ((list == null || !list.contains("ClusterAddress")) && this.bean.isClusterAddressSet()) {
                    networkAccessPointMBeanImpl.setClusterAddress(this.bean.getClusterAddress());
                }
                if ((list == null || !list.contains("CompleteCOMMessageTimeout")) && this.bean.isCompleteCOMMessageTimeoutSet()) {
                    networkAccessPointMBeanImpl.setCompleteCOMMessageTimeout(this.bean.getCompleteCOMMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteHTTPMessageTimeout")) && this.bean.isCompleteHTTPMessageTimeoutSet()) {
                    networkAccessPointMBeanImpl.setCompleteHTTPMessageTimeout(this.bean.getCompleteHTTPMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteIIOPMessageTimeout")) && this.bean.isCompleteIIOPMessageTimeoutSet()) {
                    networkAccessPointMBeanImpl.setCompleteIIOPMessageTimeout(this.bean.getCompleteIIOPMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteMessageTimeout")) && this.bean.isCompleteMessageTimeoutSet()) {
                    networkAccessPointMBeanImpl.setCompleteMessageTimeout(this.bean.getCompleteMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteT3MessageTimeout")) && this.bean.isCompleteT3MessageTimeoutSet()) {
                    networkAccessPointMBeanImpl.setCompleteT3MessageTimeout(this.bean.getCompleteT3MessageTimeout());
                }
                if ((list == null || !list.contains("ConnectTimeout")) && this.bean.isConnectTimeoutSet()) {
                    networkAccessPointMBeanImpl.setConnectTimeout(this.bean.getConnectTimeout());
                }
                if ((list == null || !list.contains("CustomPrivateKeyAlias")) && this.bean.isCustomPrivateKeyAliasSet()) {
                    networkAccessPointMBeanImpl.setCustomPrivateKeyAlias(this.bean.getCustomPrivateKeyAlias());
                }
                if ((list == null || !list.contains("CustomPrivateKeyPassPhraseEncrypted")) && this.bean.isCustomPrivateKeyPassPhraseEncryptedSet()) {
                    byte[] byArray = this.bean.getCustomPrivateKeyPassPhraseEncrypted();
                    networkAccessPointMBeanImpl.setCustomPrivateKeyPassPhraseEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("CustomProperties")) && this.bean.isCustomPropertiesSet()) {
                    networkAccessPointMBeanImpl.setCustomProperties(this.bean.getCustomProperties());
                }
                if ((list == null || !list.contains("ExternalDNSName")) && this.bean.isExternalDNSNameSet()) {
                    networkAccessPointMBeanImpl.setExternalDNSName(this.bean.getExternalDNSName());
                }
                if ((list == null || !list.contains("IdleConnectionTimeout")) && this.bean.isIdleConnectionTimeoutSet()) {
                    networkAccessPointMBeanImpl.setIdleConnectionTimeout(this.bean.getIdleConnectionTimeout());
                }
                if ((list == null || !list.contains("IdleIIOPConnectionTimeout")) && this.bean.isIdleIIOPConnectionTimeoutSet()) {
                    networkAccessPointMBeanImpl.setIdleIIOPConnectionTimeout(this.bean.getIdleIIOPConnectionTimeout());
                }
                if ((list == null || !list.contains("ListenAddress")) && this.bean.isListenAddressSet()) {
                    networkAccessPointMBeanImpl.setListenAddress(this.bean.getListenAddress());
                }
                if ((list == null || !list.contains("ListenPort")) && this.bean.isListenPortSet()) {
                    networkAccessPointMBeanImpl.setListenPort(this.bean.getListenPort());
                }
                if ((list == null || !list.contains("LoginTimeoutMillis")) && this.bean.isLoginTimeoutMillisSet()) {
                    networkAccessPointMBeanImpl.setLoginTimeoutMillis(this.bean.getLoginTimeoutMillis());
                }
                if ((list == null || !list.contains("LoginTimeoutMillisSSL")) && this.bean.isLoginTimeoutMillisSSLSet()) {
                    networkAccessPointMBeanImpl.setLoginTimeoutMillisSSL(this.bean.getLoginTimeoutMillisSSL());
                }
                if ((list == null || !list.contains("MaxBackoffBetweenFailures")) && this.bean.isMaxBackoffBetweenFailuresSet()) {
                    networkAccessPointMBeanImpl.setMaxBackoffBetweenFailures(this.bean.getMaxBackoffBetweenFailures());
                }
                if ((list == null || !list.contains("MaxConnectedClients")) && this.bean.isMaxConnectedClientsSet()) {
                    networkAccessPointMBeanImpl.setMaxConnectedClients(this.bean.getMaxConnectedClients());
                }
                if ((list == null || !list.contains("MaxMessageSize")) && this.bean.isMaxMessageSizeSet()) {
                    networkAccessPointMBeanImpl.setMaxMessageSize(this.bean.getMaxMessageSize());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    networkAccessPointMBeanImpl.setName(this.bean.getName());
                }
                if (list != null && list.contains("OutboundPrivateKeyAlias") || this.bean.isOutboundPrivateKeyAliasSet()) {
                    // empty if block
                }
                if (list != null && list.contains("OutboundPrivateKeyPassPhrase") || this.bean.isOutboundPrivateKeyPassPhraseSet()) {
                    // empty if block
                }
                if (list != null && list.contains("PrivateKeyAlias") || this.bean.isPrivateKeyAliasSet()) {
                    // empty if block
                }
                if (list != null && list.contains("PrivateKeyPassPhrase") || this.bean.isPrivateKeyPassPhraseSet()) {
                    // empty if block
                }
                if ((list == null || !list.contains("Protocol")) && this.bean.isProtocolSet()) {
                    networkAccessPointMBeanImpl.setProtocol(this.bean.getProtocol());
                }
                if ((list == null || !list.contains("ProxyAddress")) && this.bean.isProxyAddressSet()) {
                    networkAccessPointMBeanImpl.setProxyAddress(this.bean.getProxyAddress());
                }
                if ((list == null || !list.contains("ProxyPort")) && this.bean.isProxyPortSet()) {
                    networkAccessPointMBeanImpl.setProxyPort(this.bean.getProxyPort());
                }
                if ((list == null || !list.contains("PublicAddress")) && this.bean.isPublicAddressSet()) {
                    networkAccessPointMBeanImpl.setPublicAddress(this.bean.getPublicAddress());
                }
                if ((list == null || !list.contains("PublicPort")) && this.bean.isPublicPortSet()) {
                    networkAccessPointMBeanImpl.setPublicPort(this.bean.getPublicPort());
                }
                if ((list == null || !list.contains("SSLListenPort")) && this.bean.isSSLListenPortSet()) {
                    networkAccessPointMBeanImpl.setSSLListenPort(this.bean.getSSLListenPort());
                }
                if ((list == null || !list.contains("TimeoutConnectionWithPendingResponses")) && this.bean.isTimeoutConnectionWithPendingResponsesSet()) {
                    networkAccessPointMBeanImpl.setTimeoutConnectionWithPendingResponses(this.bean.getTimeoutConnectionWithPendingResponses());
                }
                if ((list == null || !list.contains("TunnelingClientPingSecs")) && this.bean.isTunnelingClientPingSecsSet()) {
                    networkAccessPointMBeanImpl.setTunnelingClientPingSecs(this.bean.getTunnelingClientPingSecs());
                }
                if ((list == null || !list.contains("TunnelingClientTimeoutSecs")) && this.bean.isTunnelingClientTimeoutSecsSet()) {
                    networkAccessPointMBeanImpl.setTunnelingClientTimeoutSecs(this.bean.getTunnelingClientTimeoutSecs());
                }
                if ((list == null || !list.contains("UseFastSerialization")) && this.bean.isUseFastSerializationSet()) {
                    networkAccessPointMBeanImpl.setUseFastSerialization(this.bean.getUseFastSerialization());
                }
                if ((list == null || !list.contains("ChannelIdentityCustomized")) && this.bean.isChannelIdentityCustomizedSet()) {
                    networkAccessPointMBeanImpl.setChannelIdentityCustomized(this.bean.isChannelIdentityCustomized());
                }
                if ((list == null || !list.contains("ClientCertificateEnforced")) && this.bean.isClientCertificateEnforcedSet()) {
                    networkAccessPointMBeanImpl.setClientCertificateEnforced(this.bean.isClientCertificateEnforced());
                }
                if ((list == null || !list.contains("Enabled")) && this.bean.isEnabledSet()) {
                    networkAccessPointMBeanImpl.setEnabled(this.bean.isEnabled());
                }
                if ((list == null || !list.contains("HttpEnabledForThisProtocol")) && this.bean.isHttpEnabledForThisProtocolSet()) {
                    networkAccessPointMBeanImpl.setHttpEnabledForThisProtocol(this.bean.isHttpEnabledForThisProtocol());
                }
                if ((list == null || !list.contains("OutboundEnabled")) && this.bean.isOutboundEnabledSet()) {
                    networkAccessPointMBeanImpl.setOutboundEnabled(this.bean.isOutboundEnabled());
                }
                if ((list == null || !list.contains("OutboundPrivateKeyEnabled")) && this.bean.isOutboundPrivateKeyEnabledSet()) {
                    networkAccessPointMBeanImpl.setOutboundPrivateKeyEnabled(this.bean.isOutboundPrivateKeyEnabled());
                }
                if ((list == null || !list.contains("SDPEnabled")) && this.bean.isSDPEnabledSet()) {
                    networkAccessPointMBeanImpl.setSDPEnabled(this.bean.isSDPEnabled());
                }
                if ((list == null || !list.contains("TunnelingEnabled")) && this.bean.isTunnelingEnabledSet()) {
                    networkAccessPointMBeanImpl.setTunnelingEnabled(this.bean.isTunnelingEnabled());
                }
                if ((list == null || !list.contains("TwoWaySSLEnabled")) && this.bean.isTwoWaySSLEnabledSet()) {
                    networkAccessPointMBeanImpl.setTwoWaySSLEnabled(this.bean.isTwoWaySSLEnabled());
                }
                return networkAccessPointMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

