/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import weblogic.management.configuration.NetworkAccessPointMBean;

public class NetworkAccessPointValidator {
    public static void validateListenPort(int n) {
        if (n != -1 && (n < 1 || n > 65535)) {
            throw new IllegalArgumentException("Illegal value for ListenPort: " + n);
        }
    }

    public static void validatePublicPort(int n) {
        if (n != -1 && (n < 1 || n > 65535)) {
            throw new IllegalArgumentException("Illegal value for PublicPort: " + n);
        }
    }

    public static void validateMaxMessageSize(int n) {
        if (n != -1 && (n < 1 || n > 65534)) {
            throw new IllegalArgumentException("Illegal value for MaxMessageSize: " + n);
        }
    }

    public static void validateHttpEnabledForThisProtocol(NetworkAccessPointMBean networkAccessPointMBean, boolean bl) {
        if (networkAccessPointMBean.isTunnelingEnabled() && networkAccessPointMBean.isHttpEnabledForThisProtocol() && !bl) {
            throw new IllegalArgumentException("Can't disable HTTP as tunneling is enabled for channel: " + networkAccessPointMBean.getName());
        }
    }

    public static void validateTunnelingEnabled(NetworkAccessPointMBean networkAccessPointMBean, boolean bl) {
        if (!networkAccessPointMBean.isHttpEnabledForThisProtocol() && !networkAccessPointMBean.isTunnelingEnabled() && bl) {
            throw new IllegalArgumentException("Can't enable tunneling as HTTP is disabled for channel: " + networkAccessPointMBean.getName());
        }
    }
}

