/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.NetworkChannelMBean;
import weblogic.management.configuration.NetworkChannelValidator;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class NetworkChannelMBeanImpl
extends DeploymentMBeanImpl
implements NetworkChannelMBean,
Serializable {
    private int _AcceptBacklog;
    private boolean _BoundOutgoingEnabled;
    private boolean _COMEnabled;
    private int _ChannelWeight;
    private String _ClusterAddress;
    private int _CompleteCOMMessageTimeout;
    private int _CompleteHTTPMessageTimeout;
    private int _CompleteIIOPMessageTimeout;
    private int _CompleteT3MessageTimeout;
    private String _DefaultIIOPPassword;
    private byte[] _DefaultIIOPPasswordEncrypted;
    private String _DefaultIIOPUser;
    private String _Description;
    private boolean _HTTPEnabled;
    private boolean _HTTPSEnabled;
    private boolean _IIOPEnabled;
    private boolean _IIOPSEnabled;
    private int _IdleIIOPConnectionTimeout;
    private int _ListenPort;
    private boolean _ListenPortEnabled;
    private int _LoginTimeoutMillis;
    private int _LoginTimeoutMillisSSL;
    private int _MaxCOMMessageSize;
    private int _MaxHTTPMessageSize;
    private int _MaxIIOPMessageSize;
    private int _MaxT3MessageSize;
    private String _Name;
    private boolean _OutgoingEnabled;
    private int _SSLListenPort;
    private boolean _SSLListenPortEnabled;
    private boolean _T3Enabled;
    private boolean _T3SEnabled;
    private int _TunnelingClientPingSecs;
    private int _TunnelingClientTimeoutSecs;
    private boolean _TunnelingEnabled;
    private static SchemaHelper2 _schemaHelper;

    public NetworkChannelMBeanImpl() {
        this._initializeProperty(-1);
    }

    public NetworkChannelMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getName() {
        return this._Name;
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        NetworkChannelValidator.validateName(string);
        String string2 = this._Name;
        this._Name = string;
        this._postSet(2, string2, string);
    }

    public String getDescription() {
        return this._Description;
    }

    public boolean isDescriptionSet() {
        return this._isSet(9);
    }

    public void setDescription(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Description;
        this._Description = string;
        this._postSet(9, string2, string);
    }

    public int getListenPort() {
        return this._ListenPort;
    }

    public boolean isListenPortSet() {
        return this._isSet(10);
    }

    public void setListenPort(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ListenPort", (long)n, (long)1L, (long)65535L);
        int n2 = this._ListenPort;
        this._ListenPort = n;
        this._postSet(10, n2, n);
    }

    public boolean isListenPortEnabled() {
        return this._ListenPortEnabled;
    }

    public boolean isListenPortEnabledSet() {
        return this._isSet(11);
    }

    public void setListenPortEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ListenPortEnabled;
        this._ListenPortEnabled = bl;
        this._postSet(11, bl2, bl);
    }

    public int getSSLListenPort() {
        return this._SSLListenPort;
    }

    public boolean isSSLListenPortSet() {
        return this._isSet(12);
    }

    public void setSSLListenPort(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"SSLListenPort", (long)n, (long)1L, (long)65535L);
        int n2 = this._SSLListenPort;
        this._SSLListenPort = n;
        this._postSet(12, n2, n);
    }

    public boolean isSSLListenPortEnabled() {
        return this._SSLListenPortEnabled;
    }

    public boolean isSSLListenPortEnabledSet() {
        return this._isSet(13);
    }

    public void setSSLListenPortEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._SSLListenPortEnabled;
        this._SSLListenPortEnabled = bl;
        this._postSet(13, bl2, bl);
    }

    public String getClusterAddress() {
        return this._ClusterAddress;
    }

    public boolean isClusterAddressSet() {
        return this._isSet(14);
    }

    public void setClusterAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ClusterAddress;
        this._ClusterAddress = string;
        this._postSet(14, string2, string);
    }

    public boolean isT3Enabled() {
        return this._T3Enabled;
    }

    public boolean isT3EnabledSet() {
        return this._isSet(15);
    }

    public void setT3Enabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._T3Enabled;
        this._T3Enabled = bl;
        this._postSet(15, bl2, bl);
    }

    public boolean isT3SEnabled() {
        return this._T3SEnabled;
    }

    public boolean isT3SEnabledSet() {
        return this._isSet(16);
    }

    public void setT3SEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._T3SEnabled;
        this._T3SEnabled = bl;
        this._postSet(16, bl2, bl);
    }

    public boolean isHTTPEnabled() {
        return this._HTTPEnabled;
    }

    public boolean isHTTPEnabledSet() {
        return this._isSet(17);
    }

    public void setHTTPEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._HTTPEnabled;
        this._HTTPEnabled = bl;
        this._postSet(17, bl2, bl);
    }

    public boolean isHTTPSEnabled() {
        return this._HTTPSEnabled;
    }

    public boolean isHTTPSEnabledSet() {
        return this._isSet(18);
    }

    public void setHTTPSEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._HTTPSEnabled;
        this._HTTPSEnabled = bl;
        this._postSet(18, bl2, bl);
    }

    public boolean isCOMEnabled() {
        return this._COMEnabled;
    }

    public boolean isCOMEnabledSet() {
        return this._isSet(19);
    }

    public void setCOMEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._COMEnabled;
        this._COMEnabled = bl;
        this._postSet(19, bl2, bl);
    }

    public boolean isOutgoingEnabled() {
        return this._OutgoingEnabled;
    }

    public boolean isOutgoingEnabledSet() {
        return this._isSet(20);
    }

    public void setOutgoingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._OutgoingEnabled;
        this._OutgoingEnabled = bl;
        this._postSet(20, bl2, bl);
    }

    public boolean isBoundOutgoingEnabled() {
        return this._BoundOutgoingEnabled;
    }

    public boolean isBoundOutgoingEnabledSet() {
        return this._isSet(21);
    }

    public void setBoundOutgoingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._BoundOutgoingEnabled;
        this._BoundOutgoingEnabled = bl;
        this._postSet(21, bl2, bl);
    }

    public int getChannelWeight() {
        return this._ChannelWeight;
    }

    public boolean isChannelWeightSet() {
        return this._isSet(22);
    }

    public void setChannelWeight(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ChannelWeight", (long)n, (long)1L, (long)100L);
        int n2 = this._ChannelWeight;
        this._ChannelWeight = n;
        this._postSet(22, n2, n);
    }

    public int getAcceptBacklog() {
        return this._AcceptBacklog;
    }

    public boolean isAcceptBacklogSet() {
        return this._isSet(23);
    }

    public void setAcceptBacklog(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"AcceptBacklog", (int)n, (int)0);
        int n2 = this._AcceptBacklog;
        this._AcceptBacklog = n;
        this._postSet(23, n2, n);
    }

    public int getLoginTimeoutMillis() {
        return this._LoginTimeoutMillis;
    }

    public boolean isLoginTimeoutMillisSet() {
        return this._isSet(24);
    }

    public void setLoginTimeoutMillis(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"LoginTimeoutMillis", (long)n, (long)0L, (long)100000L);
        int n2 = this._LoginTimeoutMillis;
        this._LoginTimeoutMillis = n;
        this._postSet(24, n2, n);
    }

    public int getLoginTimeoutMillisSSL() {
        return this._LoginTimeoutMillisSSL;
    }

    public boolean isLoginTimeoutMillisSSLSet() {
        return this._isSet(25);
    }

    public void setLoginTimeoutMillisSSL(int n) {
        LegalChecks.checkInRange((String)"LoginTimeoutMillisSSL", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._LoginTimeoutMillisSSL;
        this._LoginTimeoutMillisSSL = n;
        this._postSet(25, n2, n);
    }

    public boolean isTunnelingEnabled() {
        return this._TunnelingEnabled;
    }

    public boolean isTunnelingEnabledSet() {
        return this._isSet(26);
    }

    public void setTunnelingEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this._TunnelingEnabled;
        this._TunnelingEnabled = bl;
        this._postSet(26, bl2, bl);
    }

    public int getTunnelingClientPingSecs() {
        return this._TunnelingClientPingSecs;
    }

    public boolean isTunnelingClientPingSecsSet() {
        return this._isSet(27);
    }

    public void setTunnelingClientPingSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"TunnelingClientPingSecs", (int)n, (int)1);
        int n2 = this._TunnelingClientPingSecs;
        this._TunnelingClientPingSecs = n;
        this._postSet(27, n2, n);
    }

    public int getTunnelingClientTimeoutSecs() {
        return this._TunnelingClientTimeoutSecs;
    }

    public boolean isTunnelingClientTimeoutSecsSet() {
        return this._isSet(28);
    }

    public void setTunnelingClientTimeoutSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"TunnelingClientTimeoutSecs", (int)n, (int)1);
        int n2 = this._TunnelingClientTimeoutSecs;
        this._TunnelingClientTimeoutSecs = n;
        this._postSet(28, n2, n);
    }

    public int getCompleteT3MessageTimeout() {
        return this._CompleteT3MessageTimeout;
    }

    public boolean isCompleteT3MessageTimeoutSet() {
        return this._isSet(29);
    }

    public void setCompleteT3MessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteT3MessageTimeout", (long)n, (long)0L, (long)480L);
        int n2 = this._CompleteT3MessageTimeout;
        this._CompleteT3MessageTimeout = n;
        this._postSet(29, n2, n);
    }

    public int getCompleteHTTPMessageTimeout() {
        return this._CompleteHTTPMessageTimeout;
    }

    public boolean isCompleteHTTPMessageTimeoutSet() {
        return this._isSet(30);
    }

    public void setCompleteHTTPMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteHTTPMessageTimeout", (long)n, (long)0L, (long)480L);
        int n2 = this._CompleteHTTPMessageTimeout;
        this._CompleteHTTPMessageTimeout = n;
        this._postSet(30, n2, n);
    }

    public int getCompleteCOMMessageTimeout() {
        return this._CompleteCOMMessageTimeout;
    }

    public boolean isCompleteCOMMessageTimeoutSet() {
        return this._isSet(31);
    }

    public void setCompleteCOMMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteCOMMessageTimeout", (long)n, (long)0L, (long)480L);
        int n2 = this._CompleteCOMMessageTimeout;
        this._CompleteCOMMessageTimeout = n;
        this._postSet(31, n2, n);
    }

    public int getMaxT3MessageSize() {
        return this._MaxT3MessageSize;
    }

    public boolean isMaxT3MessageSizeSet() {
        return this._isSet(32);
    }

    public void setMaxT3MessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxT3MessageSize", (long)n, (long)4096L, (long)2000000000L);
        int n2 = this._MaxT3MessageSize;
        this._MaxT3MessageSize = n;
        this._postSet(32, n2, n);
    }

    public int getMaxHTTPMessageSize() {
        return this._MaxHTTPMessageSize;
    }

    public boolean isMaxHTTPMessageSizeSet() {
        return this._isSet(33);
    }

    public void setMaxHTTPMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxHTTPMessageSize", (long)n, (long)4096L, (long)2000000000L);
        int n2 = this._MaxHTTPMessageSize;
        this._MaxHTTPMessageSize = n;
        this._postSet(33, n2, n);
    }

    public int getMaxCOMMessageSize() {
        return this._MaxCOMMessageSize;
    }

    public boolean isMaxCOMMessageSizeSet() {
        return this._isSet(34);
    }

    public void setMaxCOMMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxCOMMessageSize", (long)n, (long)4096L, (long)2000000000L);
        int n2 = this._MaxCOMMessageSize;
        this._MaxCOMMessageSize = n;
        this._postSet(34, n2, n);
    }

    public boolean isIIOPEnabled() {
        return this._IIOPEnabled;
    }

    public boolean isIIOPEnabledSet() {
        return this._isSet(35);
    }

    public void setIIOPEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._IIOPEnabled;
        this._IIOPEnabled = bl;
        this._postSet(35, bl2, bl);
    }

    public boolean isIIOPSEnabled() {
        return this._IIOPSEnabled;
    }

    public boolean isIIOPSEnabledSet() {
        return this._isSet(36);
    }

    public void setIIOPSEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._IIOPSEnabled;
        this._IIOPSEnabled = bl;
        this._postSet(36, bl2, bl);
    }

    public int getCompleteIIOPMessageTimeout() {
        return this._CompleteIIOPMessageTimeout;
    }

    public boolean isCompleteIIOPMessageTimeoutSet() {
        return this._isSet(37);
    }

    public void setCompleteIIOPMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteIIOPMessageTimeout", (long)n, (long)0L, (long)480L);
        int n2 = this._CompleteIIOPMessageTimeout;
        this._CompleteIIOPMessageTimeout = n;
        this._postSet(37, n2, n);
    }

    public int getMaxIIOPMessageSize() {
        return this._MaxIIOPMessageSize;
    }

    public boolean isMaxIIOPMessageSizeSet() {
        return this._isSet(38);
    }

    public void setMaxIIOPMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaxIIOPMessageSize", (long)n, (long)4096L, (long)2000000000L);
        int n2 = this._MaxIIOPMessageSize;
        this._MaxIIOPMessageSize = n;
        this._postSet(38, n2, n);
    }

    public int getIdleIIOPConnectionTimeout() {
        return this._IdleIIOPConnectionTimeout;
    }

    public boolean isIdleIIOPConnectionTimeoutSet() {
        return this._isSet(39);
    }

    public void setIdleIIOPConnectionTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"IdleIIOPConnectionTimeout", (int)n, (int)0);
        int n2 = this._IdleIIOPConnectionTimeout;
        this._IdleIIOPConnectionTimeout = n;
        this._postSet(39, n2, n);
    }

    public String getDefaultIIOPUser() {
        return this._DefaultIIOPUser;
    }

    public boolean isDefaultIIOPUserSet() {
        return this._isSet(40);
    }

    public void setDefaultIIOPUser(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._DefaultIIOPUser;
        this._DefaultIIOPUser = string;
        this._postSet(40, string2, string);
    }

    public String getDefaultIIOPPassword() {
        byte[] byArray = this.getDefaultIIOPPasswordEncrypted();
        return byArray == null ? null : this._decrypt("DefaultIIOPPassword", byArray);
    }

    public boolean isDefaultIIOPPasswordSet() {
        return this.isDefaultIIOPPasswordEncryptedSet();
    }

    public void setDefaultIIOPPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setDefaultIIOPPasswordEncrypted(string == null ? null : this._encrypt("DefaultIIOPPassword", string));
    }

    public byte[] getDefaultIIOPPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._DefaultIIOPPasswordEncrypted);
    }

    public String getDefaultIIOPPasswordEncryptedAsString() {
        byte[] byArray = this.getDefaultIIOPPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isDefaultIIOPPasswordEncryptedSet() {
        return this._isSet(42);
    }

    public void setDefaultIIOPPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setDefaultIIOPPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setDefaultIIOPPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._DefaultIIOPPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: DefaultIIOPPasswordEncrypted of NetworkChannelMBean");
        }
        this._getHelper()._clearArray(this._DefaultIIOPPasswordEncrypted);
        this._DefaultIIOPPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(42, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 41) {
                this._markSet(42, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 23;
        }
        try {
            switch (n) {
                case 23: {
                    this._AcceptBacklog = 50;
                    if (bl) break;
                }
                case 22: {
                    this._ChannelWeight = 50;
                    if (bl) break;
                }
                case 14: {
                    this._ClusterAddress = null;
                    if (bl) break;
                }
                case 31: {
                    this._CompleteCOMMessageTimeout = 60;
                    if (bl) break;
                }
                case 30: {
                    this._CompleteHTTPMessageTimeout = 60;
                    if (bl) break;
                }
                case 37: {
                    this._CompleteIIOPMessageTimeout = 60;
                    if (bl) break;
                }
                case 29: {
                    this._CompleteT3MessageTimeout = 60;
                    if (bl) break;
                }
                case 41: {
                    this._DefaultIIOPPasswordEncrypted = null;
                    if (bl) break;
                }
                case 42: {
                    this._DefaultIIOPPasswordEncrypted = null;
                    if (bl) break;
                }
                case 40: {
                    this._DefaultIIOPUser = null;
                    if (bl) break;
                }
                case 9: {
                    this._Description = null;
                    if (bl) break;
                }
                case 39: {
                    this._IdleIIOPConnectionTimeout = 60;
                    if (bl) break;
                }
                case 10: {
                    this._ListenPort = 8001;
                    if (bl) break;
                }
                case 24: {
                    this._LoginTimeoutMillis = 5000;
                    if (bl) break;
                }
                case 25: {
                    this._LoginTimeoutMillisSSL = 25000;
                    if (bl) break;
                }
                case 34: {
                    this._MaxCOMMessageSize = 10000000;
                    if (bl) break;
                }
                case 33: {
                    this._MaxHTTPMessageSize = 10000000;
                    if (bl) break;
                }
                case 38: {
                    this._MaxIIOPMessageSize = 10000000;
                    if (bl) break;
                }
                case 32: {
                    this._MaxT3MessageSize = 10000000;
                    if (bl) break;
                }
                case 2: {
                    this._Name = null;
                    if (bl) break;
                }
                case 12: {
                    this._SSLListenPort = 8002;
                    if (bl) break;
                }
                case 27: {
                    this._TunnelingClientPingSecs = 45;
                    if (bl) break;
                }
                case 28: {
                    this._TunnelingClientTimeoutSecs = 40;
                    if (bl) break;
                }
                case 21: {
                    this._BoundOutgoingEnabled = false;
                    if (bl) break;
                }
                case 19: {
                    this._COMEnabled = false;
                    if (bl) break;
                }
                case 17: {
                    this._HTTPEnabled = false;
                    if (bl) break;
                }
                case 18: {
                    this._HTTPSEnabled = false;
                    if (bl) break;
                }
                case 35: {
                    this._IIOPEnabled = false;
                    if (bl) break;
                }
                case 36: {
                    this._IIOPSEnabled = false;
                    if (bl) break;
                }
                case 11: {
                    this._ListenPortEnabled = false;
                    if (bl) break;
                }
                case 20: {
                    this._OutgoingEnabled = false;
                    if (bl) break;
                }
                case 13: {
                    this._SSLListenPortEnabled = false;
                    if (bl) break;
                }
                case 15: {
                    this._T3Enabled = false;
                    if (bl) break;
                }
                case 16: {
                    this._T3SEnabled = false;
                    if (bl) break;
                }
                case 26: {
                    this._TunnelingEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "NetworkChannel";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AcceptBacklog")) {
            int n = this._AcceptBacklog;
            this._AcceptBacklog = (Integer)object;
            this._postSet(23, n, this._AcceptBacklog);
            return;
        }
        if (string.equals("BoundOutgoingEnabled")) {
            boolean bl = this._BoundOutgoingEnabled;
            this._BoundOutgoingEnabled = (Boolean)object;
            this._postSet(21, bl, this._BoundOutgoingEnabled);
            return;
        }
        if (string.equals("COMEnabled")) {
            boolean bl = this._COMEnabled;
            this._COMEnabled = (Boolean)object;
            this._postSet(19, bl, this._COMEnabled);
            return;
        }
        if (string.equals("ChannelWeight")) {
            int n = this._ChannelWeight;
            this._ChannelWeight = (Integer)object;
            this._postSet(22, n, this._ChannelWeight);
            return;
        }
        if (string.equals("ClusterAddress")) {
            String string2 = this._ClusterAddress;
            this._ClusterAddress = (String)object;
            this._postSet(14, string2, this._ClusterAddress);
            return;
        }
        if (string.equals("CompleteCOMMessageTimeout")) {
            int n = this._CompleteCOMMessageTimeout;
            this._CompleteCOMMessageTimeout = (Integer)object;
            this._postSet(31, n, this._CompleteCOMMessageTimeout);
            return;
        }
        if (string.equals("CompleteHTTPMessageTimeout")) {
            int n = this._CompleteHTTPMessageTimeout;
            this._CompleteHTTPMessageTimeout = (Integer)object;
            this._postSet(30, n, this._CompleteHTTPMessageTimeout);
            return;
        }
        if (string.equals("CompleteIIOPMessageTimeout")) {
            int n = this._CompleteIIOPMessageTimeout;
            this._CompleteIIOPMessageTimeout = (Integer)object;
            this._postSet(37, n, this._CompleteIIOPMessageTimeout);
            return;
        }
        if (string.equals("CompleteT3MessageTimeout")) {
            int n = this._CompleteT3MessageTimeout;
            this._CompleteT3MessageTimeout = (Integer)object;
            this._postSet(29, n, this._CompleteT3MessageTimeout);
            return;
        }
        if (string.equals("DefaultIIOPPassword")) {
            String string3 = this._DefaultIIOPPassword;
            this._DefaultIIOPPassword = (String)object;
            this._postSet(41, string3, this._DefaultIIOPPassword);
            return;
        }
        if (string.equals("DefaultIIOPPasswordEncrypted")) {
            byte[] byArray = this._DefaultIIOPPasswordEncrypted;
            this._DefaultIIOPPasswordEncrypted = (byte[])object;
            this._postSet(42, byArray, this._DefaultIIOPPasswordEncrypted);
            return;
        }
        if (string.equals("DefaultIIOPUser")) {
            String string4 = this._DefaultIIOPUser;
            this._DefaultIIOPUser = (String)object;
            this._postSet(40, string4, this._DefaultIIOPUser);
            return;
        }
        if (string.equals("Description")) {
            String string5 = this._Description;
            this._Description = (String)object;
            this._postSet(9, string5, this._Description);
            return;
        }
        if (string.equals("HTTPEnabled")) {
            boolean bl = this._HTTPEnabled;
            this._HTTPEnabled = (Boolean)object;
            this._postSet(17, bl, this._HTTPEnabled);
            return;
        }
        if (string.equals("HTTPSEnabled")) {
            boolean bl = this._HTTPSEnabled;
            this._HTTPSEnabled = (Boolean)object;
            this._postSet(18, bl, this._HTTPSEnabled);
            return;
        }
        if (string.equals("IIOPEnabled")) {
            boolean bl = this._IIOPEnabled;
            this._IIOPEnabled = (Boolean)object;
            this._postSet(35, bl, this._IIOPEnabled);
            return;
        }
        if (string.equals("IIOPSEnabled")) {
            boolean bl = this._IIOPSEnabled;
            this._IIOPSEnabled = (Boolean)object;
            this._postSet(36, bl, this._IIOPSEnabled);
            return;
        }
        if (string.equals("IdleIIOPConnectionTimeout")) {
            int n = this._IdleIIOPConnectionTimeout;
            this._IdleIIOPConnectionTimeout = (Integer)object;
            this._postSet(39, n, this._IdleIIOPConnectionTimeout);
            return;
        }
        if (string.equals("ListenPort")) {
            int n = this._ListenPort;
            this._ListenPort = (Integer)object;
            this._postSet(10, n, this._ListenPort);
            return;
        }
        if (string.equals("ListenPortEnabled")) {
            boolean bl = this._ListenPortEnabled;
            this._ListenPortEnabled = (Boolean)object;
            this._postSet(11, bl, this._ListenPortEnabled);
            return;
        }
        if (string.equals("LoginTimeoutMillis")) {
            int n = this._LoginTimeoutMillis;
            this._LoginTimeoutMillis = (Integer)object;
            this._postSet(24, n, this._LoginTimeoutMillis);
            return;
        }
        if (string.equals("LoginTimeoutMillisSSL")) {
            int n = this._LoginTimeoutMillisSSL;
            this._LoginTimeoutMillisSSL = (Integer)object;
            this._postSet(25, n, this._LoginTimeoutMillisSSL);
            return;
        }
        if (string.equals("MaxCOMMessageSize")) {
            int n = this._MaxCOMMessageSize;
            this._MaxCOMMessageSize = (Integer)object;
            this._postSet(34, n, this._MaxCOMMessageSize);
            return;
        }
        if (string.equals("MaxHTTPMessageSize")) {
            int n = this._MaxHTTPMessageSize;
            this._MaxHTTPMessageSize = (Integer)object;
            this._postSet(33, n, this._MaxHTTPMessageSize);
            return;
        }
        if (string.equals("MaxIIOPMessageSize")) {
            int n = this._MaxIIOPMessageSize;
            this._MaxIIOPMessageSize = (Integer)object;
            this._postSet(38, n, this._MaxIIOPMessageSize);
            return;
        }
        if (string.equals("MaxT3MessageSize")) {
            int n = this._MaxT3MessageSize;
            this._MaxT3MessageSize = (Integer)object;
            this._postSet(32, n, this._MaxT3MessageSize);
            return;
        }
        if (string.equals("Name")) {
            String string6 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string6, this._Name);
            return;
        }
        if (string.equals("OutgoingEnabled")) {
            boolean bl = this._OutgoingEnabled;
            this._OutgoingEnabled = (Boolean)object;
            this._postSet(20, bl, this._OutgoingEnabled);
            return;
        }
        if (string.equals("SSLListenPort")) {
            int n = this._SSLListenPort;
            this._SSLListenPort = (Integer)object;
            this._postSet(12, n, this._SSLListenPort);
            return;
        }
        if (string.equals("SSLListenPortEnabled")) {
            boolean bl = this._SSLListenPortEnabled;
            this._SSLListenPortEnabled = (Boolean)object;
            this._postSet(13, bl, this._SSLListenPortEnabled);
            return;
        }
        if (string.equals("T3Enabled")) {
            boolean bl = this._T3Enabled;
            this._T3Enabled = (Boolean)object;
            this._postSet(15, bl, this._T3Enabled);
            return;
        }
        if (string.equals("T3SEnabled")) {
            boolean bl = this._T3SEnabled;
            this._T3SEnabled = (Boolean)object;
            this._postSet(16, bl, this._T3SEnabled);
            return;
        }
        if (string.equals("TunnelingClientPingSecs")) {
            int n = this._TunnelingClientPingSecs;
            this._TunnelingClientPingSecs = (Integer)object;
            this._postSet(27, n, this._TunnelingClientPingSecs);
            return;
        }
        if (string.equals("TunnelingClientTimeoutSecs")) {
            int n = this._TunnelingClientTimeoutSecs;
            this._TunnelingClientTimeoutSecs = (Integer)object;
            this._postSet(28, n, this._TunnelingClientTimeoutSecs);
            return;
        }
        if (string.equals("TunnelingEnabled")) {
            boolean bl = this._TunnelingEnabled;
            this._TunnelingEnabled = (Boolean)object;
            this._postSet(26, bl, this._TunnelingEnabled);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AcceptBacklog")) {
            return new Integer(this._AcceptBacklog);
        }
        if (string.equals("BoundOutgoingEnabled")) {
            return new Boolean(this._BoundOutgoingEnabled);
        }
        if (string.equals("COMEnabled")) {
            return new Boolean(this._COMEnabled);
        }
        if (string.equals("ChannelWeight")) {
            return new Integer(this._ChannelWeight);
        }
        if (string.equals("ClusterAddress")) {
            return this._ClusterAddress;
        }
        if (string.equals("CompleteCOMMessageTimeout")) {
            return new Integer(this._CompleteCOMMessageTimeout);
        }
        if (string.equals("CompleteHTTPMessageTimeout")) {
            return new Integer(this._CompleteHTTPMessageTimeout);
        }
        if (string.equals("CompleteIIOPMessageTimeout")) {
            return new Integer(this._CompleteIIOPMessageTimeout);
        }
        if (string.equals("CompleteT3MessageTimeout")) {
            return new Integer(this._CompleteT3MessageTimeout);
        }
        if (string.equals("DefaultIIOPPassword")) {
            return this._DefaultIIOPPassword;
        }
        if (string.equals("DefaultIIOPPasswordEncrypted")) {
            return this._DefaultIIOPPasswordEncrypted;
        }
        if (string.equals("DefaultIIOPUser")) {
            return this._DefaultIIOPUser;
        }
        if (string.equals("Description")) {
            return this._Description;
        }
        if (string.equals("HTTPEnabled")) {
            return new Boolean(this._HTTPEnabled);
        }
        if (string.equals("HTTPSEnabled")) {
            return new Boolean(this._HTTPSEnabled);
        }
        if (string.equals("IIOPEnabled")) {
            return new Boolean(this._IIOPEnabled);
        }
        if (string.equals("IIOPSEnabled")) {
            return new Boolean(this._IIOPSEnabled);
        }
        if (string.equals("IdleIIOPConnectionTimeout")) {
            return new Integer(this._IdleIIOPConnectionTimeout);
        }
        if (string.equals("ListenPort")) {
            return new Integer(this._ListenPort);
        }
        if (string.equals("ListenPortEnabled")) {
            return new Boolean(this._ListenPortEnabled);
        }
        if (string.equals("LoginTimeoutMillis")) {
            return new Integer(this._LoginTimeoutMillis);
        }
        if (string.equals("LoginTimeoutMillisSSL")) {
            return new Integer(this._LoginTimeoutMillisSSL);
        }
        if (string.equals("MaxCOMMessageSize")) {
            return new Integer(this._MaxCOMMessageSize);
        }
        if (string.equals("MaxHTTPMessageSize")) {
            return new Integer(this._MaxHTTPMessageSize);
        }
        if (string.equals("MaxIIOPMessageSize")) {
            return new Integer(this._MaxIIOPMessageSize);
        }
        if (string.equals("MaxT3MessageSize")) {
            return new Integer(this._MaxT3MessageSize);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("OutgoingEnabled")) {
            return new Boolean(this._OutgoingEnabled);
        }
        if (string.equals("SSLListenPort")) {
            return new Integer(this._SSLListenPort);
        }
        if (string.equals("SSLListenPortEnabled")) {
            return new Boolean(this._SSLListenPortEnabled);
        }
        if (string.equals("T3Enabled")) {
            return new Boolean(this._T3Enabled);
        }
        if (string.equals("T3SEnabled")) {
            return new Boolean(this._T3SEnabled);
        }
        if (string.equals("TunnelingClientPingSecs")) {
            return new Integer(this._TunnelingClientPingSecs);
        }
        if (string.equals("TunnelingClientTimeoutSecs")) {
            return new Integer(this._TunnelingClientTimeoutSecs);
        }
        if (string.equals("TunnelingEnabled")) {
            return new Boolean(this._TunnelingEnabled);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 14: {
                    if (string.equals("accept-backlog")) {
                        return 23;
                    }
                    if (!string.equals("channel-weight")) break;
                    return 22;
                }
                case 15: {
                    if (string.equals("cluster-address")) {
                        return 14;
                    }
                    if (!string.equals("ssl-listen-port")) break;
                    return 12;
                }
                case 27: {
                    if (string.equals("completecom-message-timeout")) {
                        return 31;
                    }
                    if (!string.equals("idleiiop-connection-timeout")) break;
                    return 39;
                }
                case 28: {
                    if (string.equals("completehttp-message-timeout")) {
                        return 30;
                    }
                    if (!string.equals("completeiiop-message-timeout")) break;
                    return 37;
                }
                case 26: {
                    if (string.equals("completet3-message-timeout")) {
                        return 29;
                    }
                    if (!string.equals("tunneling-client-ping-secs")) break;
                    return 27;
                }
                case 20: {
                    if (string.equals("defaultiiop-password")) {
                        return 41;
                    }
                    if (string.equals("login-timeout-millis")) {
                        return 24;
                    }
                    if (string.equals("maxhttp-message-size")) {
                        return 33;
                    }
                    if (!string.equals("maxiiop-message-size")) break;
                    return 38;
                }
                case 30: {
                    if (!string.equals("defaultiiop-password-encrypted")) break;
                    return 42;
                }
                case 16: {
                    if (string.equals("defaultiiop-user")) {
                        return 40;
                    }
                    if (!string.equals("outgoing-enabled")) break;
                    return 20;
                }
                case 11: {
                    if (string.equals("description")) {
                        return 9;
                    }
                    if (string.equals("listen-port")) {
                        return 10;
                    }
                    if (string.equals("com-enabled")) {
                        return 19;
                    }
                    if (!string.equals("t3s-enabled")) break;
                    return 16;
                }
                case 23: {
                    if (string.equals("login-timeout-millisssl")) {
                        return 25;
                    }
                    if (!string.equals("ssl-listen-port-enabled")) break;
                    return 13;
                }
                case 19: {
                    if (string.equals("maxcom-message-size")) {
                        return 34;
                    }
                    if (!string.equals("listen-port-enabled")) break;
                    return 11;
                }
                case 18: {
                    if (!string.equals("maxt3-message-size")) break;
                    return 32;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 29: {
                    if (!string.equals("tunneling-client-timeout-secs")) break;
                    return 28;
                }
                case 22: {
                    if (!string.equals("bound-outgoing-enabled")) break;
                    return 21;
                }
                case 12: {
                    if (string.equals("http-enabled")) {
                        return 17;
                    }
                    if (!string.equals("iiop-enabled")) break;
                    return 35;
                }
                case 13: {
                    if (string.equals("https-enabled")) {
                        return 18;
                    }
                    if (!string.equals("iiops-enabled")) break;
                    return 36;
                }
                case 10: {
                    if (!string.equals("t3-enabled")) break;
                    return 15;
                }
                case 17: {
                    if (!string.equals("tunneling-enabled")) break;
                    return 26;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 23: {
                    return "accept-backlog";
                }
                case 22: {
                    return "channel-weight";
                }
                case 14: {
                    return "cluster-address";
                }
                case 31: {
                    return "completecom-message-timeout";
                }
                case 30: {
                    return "completehttp-message-timeout";
                }
                case 37: {
                    return "completeiiop-message-timeout";
                }
                case 29: {
                    return "completet3-message-timeout";
                }
                case 41: {
                    return "defaultiiop-password";
                }
                case 42: {
                    return "defaultiiop-password-encrypted";
                }
                case 40: {
                    return "defaultiiop-user";
                }
                case 9: {
                    return "description";
                }
                case 39: {
                    return "idleiiop-connection-timeout";
                }
                case 10: {
                    return "listen-port";
                }
                case 24: {
                    return "login-timeout-millis";
                }
                case 25: {
                    return "login-timeout-millisssl";
                }
                case 34: {
                    return "maxcom-message-size";
                }
                case 33: {
                    return "maxhttp-message-size";
                }
                case 38: {
                    return "maxiiop-message-size";
                }
                case 32: {
                    return "maxt3-message-size";
                }
                case 2: {
                    return "name";
                }
                case 12: {
                    return "ssl-listen-port";
                }
                case 27: {
                    return "tunneling-client-ping-secs";
                }
                case 28: {
                    return "tunneling-client-timeout-secs";
                }
                case 21: {
                    return "bound-outgoing-enabled";
                }
                case 19: {
                    return "com-enabled";
                }
                case 17: {
                    return "http-enabled";
                }
                case 18: {
                    return "https-enabled";
                }
                case 35: {
                    return "iiop-enabled";
                }
                case 36: {
                    return "iiops-enabled";
                }
                case 11: {
                    return "listen-port-enabled";
                }
                case 20: {
                    return "outgoing-enabled";
                }
                case 13: {
                    return "ssl-listen-port-enabled";
                }
                case 15: {
                    return "t3-enabled";
                }
                case 16: {
                    return "t3s-enabled";
                }
                case 26: {
                    return "tunneling-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 31: {
                    return true;
                }
                case 30: {
                    return true;
                }
                case 37: {
                    return true;
                }
                case 29: {
                    return true;
                }
                case 39: {
                    return true;
                }
                case 25: {
                    return true;
                }
                case 34: {
                    return true;
                }
                case 33: {
                    return true;
                }
                case 38: {
                    return true;
                }
                case 32: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private NetworkChannelMBeanImpl bean;

        protected Helper(NetworkChannelMBeanImpl networkChannelMBeanImpl) {
            super(networkChannelMBeanImpl);
            this.bean = networkChannelMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 23: {
                    return "AcceptBacklog";
                }
                case 22: {
                    return "ChannelWeight";
                }
                case 14: {
                    return "ClusterAddress";
                }
                case 31: {
                    return "CompleteCOMMessageTimeout";
                }
                case 30: {
                    return "CompleteHTTPMessageTimeout";
                }
                case 37: {
                    return "CompleteIIOPMessageTimeout";
                }
                case 29: {
                    return "CompleteT3MessageTimeout";
                }
                case 41: {
                    return "DefaultIIOPPassword";
                }
                case 42: {
                    return "DefaultIIOPPasswordEncrypted";
                }
                case 40: {
                    return "DefaultIIOPUser";
                }
                case 9: {
                    return "Description";
                }
                case 39: {
                    return "IdleIIOPConnectionTimeout";
                }
                case 10: {
                    return "ListenPort";
                }
                case 24: {
                    return "LoginTimeoutMillis";
                }
                case 25: {
                    return "LoginTimeoutMillisSSL";
                }
                case 34: {
                    return "MaxCOMMessageSize";
                }
                case 33: {
                    return "MaxHTTPMessageSize";
                }
                case 38: {
                    return "MaxIIOPMessageSize";
                }
                case 32: {
                    return "MaxT3MessageSize";
                }
                case 2: {
                    return "Name";
                }
                case 12: {
                    return "SSLListenPort";
                }
                case 27: {
                    return "TunnelingClientPingSecs";
                }
                case 28: {
                    return "TunnelingClientTimeoutSecs";
                }
                case 21: {
                    return "BoundOutgoingEnabled";
                }
                case 19: {
                    return "COMEnabled";
                }
                case 17: {
                    return "HTTPEnabled";
                }
                case 18: {
                    return "HTTPSEnabled";
                }
                case 35: {
                    return "IIOPEnabled";
                }
                case 36: {
                    return "IIOPSEnabled";
                }
                case 11: {
                    return "ListenPortEnabled";
                }
                case 20: {
                    return "OutgoingEnabled";
                }
                case 13: {
                    return "SSLListenPortEnabled";
                }
                case 15: {
                    return "T3Enabled";
                }
                case 16: {
                    return "T3SEnabled";
                }
                case 26: {
                    return "TunnelingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AcceptBacklog")) {
                return 23;
            }
            if (string.equals("ChannelWeight")) {
                return 22;
            }
            if (string.equals("ClusterAddress")) {
                return 14;
            }
            if (string.equals("CompleteCOMMessageTimeout")) {
                return 31;
            }
            if (string.equals("CompleteHTTPMessageTimeout")) {
                return 30;
            }
            if (string.equals("CompleteIIOPMessageTimeout")) {
                return 37;
            }
            if (string.equals("CompleteT3MessageTimeout")) {
                return 29;
            }
            if (string.equals("DefaultIIOPPassword")) {
                return 41;
            }
            if (string.equals("DefaultIIOPPasswordEncrypted")) {
                return 42;
            }
            if (string.equals("DefaultIIOPUser")) {
                return 40;
            }
            if (string.equals("Description")) {
                return 9;
            }
            if (string.equals("IdleIIOPConnectionTimeout")) {
                return 39;
            }
            if (string.equals("ListenPort")) {
                return 10;
            }
            if (string.equals("LoginTimeoutMillis")) {
                return 24;
            }
            if (string.equals("LoginTimeoutMillisSSL")) {
                return 25;
            }
            if (string.equals("MaxCOMMessageSize")) {
                return 34;
            }
            if (string.equals("MaxHTTPMessageSize")) {
                return 33;
            }
            if (string.equals("MaxIIOPMessageSize")) {
                return 38;
            }
            if (string.equals("MaxT3MessageSize")) {
                return 32;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("SSLListenPort")) {
                return 12;
            }
            if (string.equals("TunnelingClientPingSecs")) {
                return 27;
            }
            if (string.equals("TunnelingClientTimeoutSecs")) {
                return 28;
            }
            if (string.equals("BoundOutgoingEnabled")) {
                return 21;
            }
            if (string.equals("COMEnabled")) {
                return 19;
            }
            if (string.equals("HTTPEnabled")) {
                return 17;
            }
            if (string.equals("HTTPSEnabled")) {
                return 18;
            }
            if (string.equals("IIOPEnabled")) {
                return 35;
            }
            if (string.equals("IIOPSEnabled")) {
                return 36;
            }
            if (string.equals("ListenPortEnabled")) {
                return 11;
            }
            if (string.equals("OutgoingEnabled")) {
                return 20;
            }
            if (string.equals("SSLListenPortEnabled")) {
                return 13;
            }
            if (string.equals("T3Enabled")) {
                return 15;
            }
            if (string.equals("T3SEnabled")) {
                return 16;
            }
            if (string.equals("TunnelingEnabled")) {
                return 26;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAcceptBacklogSet()) {
                    stringBuffer.append("AcceptBacklog");
                    stringBuffer.append(String.valueOf(this.bean.getAcceptBacklog()));
                }
                if (this.bean.isChannelWeightSet()) {
                    stringBuffer.append("ChannelWeight");
                    stringBuffer.append(String.valueOf(this.bean.getChannelWeight()));
                }
                if (this.bean.isClusterAddressSet()) {
                    stringBuffer.append("ClusterAddress");
                    stringBuffer.append(String.valueOf(this.bean.getClusterAddress()));
                }
                if (this.bean.isCompleteCOMMessageTimeoutSet()) {
                    stringBuffer.append("CompleteCOMMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteCOMMessageTimeout()));
                }
                if (this.bean.isCompleteHTTPMessageTimeoutSet()) {
                    stringBuffer.append("CompleteHTTPMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteHTTPMessageTimeout()));
                }
                if (this.bean.isCompleteIIOPMessageTimeoutSet()) {
                    stringBuffer.append("CompleteIIOPMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteIIOPMessageTimeout()));
                }
                if (this.bean.isCompleteT3MessageTimeoutSet()) {
                    stringBuffer.append("CompleteT3MessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteT3MessageTimeout()));
                }
                if (this.bean.isDefaultIIOPPasswordSet()) {
                    stringBuffer.append("DefaultIIOPPassword");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultIIOPPassword()));
                }
                if (this.bean.isDefaultIIOPPasswordEncryptedSet()) {
                    stringBuffer.append("DefaultIIOPPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getDefaultIIOPPasswordEncrypted())));
                }
                if (this.bean.isDefaultIIOPUserSet()) {
                    stringBuffer.append("DefaultIIOPUser");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultIIOPUser()));
                }
                if (this.bean.isDescriptionSet()) {
                    stringBuffer.append("Description");
                    stringBuffer.append(String.valueOf(this.bean.getDescription()));
                }
                if (this.bean.isIdleIIOPConnectionTimeoutSet()) {
                    stringBuffer.append("IdleIIOPConnectionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getIdleIIOPConnectionTimeout()));
                }
                if (this.bean.isListenPortSet()) {
                    stringBuffer.append("ListenPort");
                    stringBuffer.append(String.valueOf(this.bean.getListenPort()));
                }
                if (this.bean.isLoginTimeoutMillisSet()) {
                    stringBuffer.append("LoginTimeoutMillis");
                    stringBuffer.append(String.valueOf(this.bean.getLoginTimeoutMillis()));
                }
                if (this.bean.isLoginTimeoutMillisSSLSet()) {
                    stringBuffer.append("LoginTimeoutMillisSSL");
                    stringBuffer.append(String.valueOf(this.bean.getLoginTimeoutMillisSSL()));
                }
                if (this.bean.isMaxCOMMessageSizeSet()) {
                    stringBuffer.append("MaxCOMMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxCOMMessageSize()));
                }
                if (this.bean.isMaxHTTPMessageSizeSet()) {
                    stringBuffer.append("MaxHTTPMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxHTTPMessageSize()));
                }
                if (this.bean.isMaxIIOPMessageSizeSet()) {
                    stringBuffer.append("MaxIIOPMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxIIOPMessageSize()));
                }
                if (this.bean.isMaxT3MessageSizeSet()) {
                    stringBuffer.append("MaxT3MessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxT3MessageSize()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isSSLListenPortSet()) {
                    stringBuffer.append("SSLListenPort");
                    stringBuffer.append(String.valueOf(this.bean.getSSLListenPort()));
                }
                if (this.bean.isTunnelingClientPingSecsSet()) {
                    stringBuffer.append("TunnelingClientPingSecs");
                    stringBuffer.append(String.valueOf(this.bean.getTunnelingClientPingSecs()));
                }
                if (this.bean.isTunnelingClientTimeoutSecsSet()) {
                    stringBuffer.append("TunnelingClientTimeoutSecs");
                    stringBuffer.append(String.valueOf(this.bean.getTunnelingClientTimeoutSecs()));
                }
                if (this.bean.isBoundOutgoingEnabledSet()) {
                    stringBuffer.append("BoundOutgoingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isBoundOutgoingEnabled()));
                }
                if (this.bean.isCOMEnabledSet()) {
                    stringBuffer.append("COMEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCOMEnabled()));
                }
                if (this.bean.isHTTPEnabledSet()) {
                    stringBuffer.append("HTTPEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isHTTPEnabled()));
                }
                if (this.bean.isHTTPSEnabledSet()) {
                    stringBuffer.append("HTTPSEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isHTTPSEnabled()));
                }
                if (this.bean.isIIOPEnabledSet()) {
                    stringBuffer.append("IIOPEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIIOPEnabled()));
                }
                if (this.bean.isIIOPSEnabledSet()) {
                    stringBuffer.append("IIOPSEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIIOPSEnabled()));
                }
                if (this.bean.isListenPortEnabledSet()) {
                    stringBuffer.append("ListenPortEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isListenPortEnabled()));
                }
                if (this.bean.isOutgoingEnabledSet()) {
                    stringBuffer.append("OutgoingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOutgoingEnabled()));
                }
                if (this.bean.isSSLListenPortEnabledSet()) {
                    stringBuffer.append("SSLListenPortEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSSLListenPortEnabled()));
                }
                if (this.bean.isT3EnabledSet()) {
                    stringBuffer.append("T3Enabled");
                    stringBuffer.append(String.valueOf(this.bean.isT3Enabled()));
                }
                if (this.bean.isT3SEnabledSet()) {
                    stringBuffer.append("T3SEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isT3SEnabled()));
                }
                if (this.bean.isTunnelingEnabledSet()) {
                    stringBuffer.append("TunnelingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isTunnelingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                NetworkChannelMBeanImpl networkChannelMBeanImpl = (NetworkChannelMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AcceptBacklog", this.bean.getAcceptBacklog(), networkChannelMBeanImpl.getAcceptBacklog(), false);
                this.computeDiff("ChannelWeight", this.bean.getChannelWeight(), networkChannelMBeanImpl.getChannelWeight(), false);
                this.computeDiff("ClusterAddress", this.bean.getClusterAddress(), networkChannelMBeanImpl.getClusterAddress(), false);
                this.computeDiff("CompleteCOMMessageTimeout", this.bean.getCompleteCOMMessageTimeout(), networkChannelMBeanImpl.getCompleteCOMMessageTimeout(), true);
                this.computeDiff("CompleteHTTPMessageTimeout", this.bean.getCompleteHTTPMessageTimeout(), networkChannelMBeanImpl.getCompleteHTTPMessageTimeout(), true);
                this.computeDiff("CompleteIIOPMessageTimeout", this.bean.getCompleteIIOPMessageTimeout(), networkChannelMBeanImpl.getCompleteIIOPMessageTimeout(), true);
                this.computeDiff("CompleteT3MessageTimeout", this.bean.getCompleteT3MessageTimeout(), networkChannelMBeanImpl.getCompleteT3MessageTimeout(), true);
                this.computeDiff("DefaultIIOPPasswordEncrypted", this.bean.getDefaultIIOPPasswordEncrypted(), networkChannelMBeanImpl.getDefaultIIOPPasswordEncrypted(), false);
                this.computeDiff("DefaultIIOPUser", this.bean.getDefaultIIOPUser(), networkChannelMBeanImpl.getDefaultIIOPUser(), false);
                this.computeDiff("Description", this.bean.getDescription(), networkChannelMBeanImpl.getDescription(), false);
                this.computeDiff("IdleIIOPConnectionTimeout", this.bean.getIdleIIOPConnectionTimeout(), networkChannelMBeanImpl.getIdleIIOPConnectionTimeout(), true);
                this.computeDiff("ListenPort", this.bean.getListenPort(), networkChannelMBeanImpl.getListenPort(), false);
                this.computeDiff("LoginTimeoutMillis", this.bean.getLoginTimeoutMillis(), networkChannelMBeanImpl.getLoginTimeoutMillis(), true);
                this.computeDiff("LoginTimeoutMillisSSL", this.bean.getLoginTimeoutMillisSSL(), networkChannelMBeanImpl.getLoginTimeoutMillisSSL(), true);
                this.computeDiff("MaxCOMMessageSize", this.bean.getMaxCOMMessageSize(), networkChannelMBeanImpl.getMaxCOMMessageSize(), true);
                this.computeDiff("MaxHTTPMessageSize", this.bean.getMaxHTTPMessageSize(), networkChannelMBeanImpl.getMaxHTTPMessageSize(), true);
                this.computeDiff("MaxIIOPMessageSize", this.bean.getMaxIIOPMessageSize(), networkChannelMBeanImpl.getMaxIIOPMessageSize(), true);
                this.computeDiff("MaxT3MessageSize", this.bean.getMaxT3MessageSize(), networkChannelMBeanImpl.getMaxT3MessageSize(), true);
                this.computeDiff("Name", this.bean.getName(), networkChannelMBeanImpl.getName(), false);
                this.computeDiff("SSLListenPort", this.bean.getSSLListenPort(), networkChannelMBeanImpl.getSSLListenPort(), false);
                this.computeDiff("TunnelingClientPingSecs", this.bean.getTunnelingClientPingSecs(), networkChannelMBeanImpl.getTunnelingClientPingSecs(), false);
                this.computeDiff("TunnelingClientTimeoutSecs", this.bean.getTunnelingClientTimeoutSecs(), networkChannelMBeanImpl.getTunnelingClientTimeoutSecs(), false);
                this.computeDiff("BoundOutgoingEnabled", this.bean.isBoundOutgoingEnabled(), networkChannelMBeanImpl.isBoundOutgoingEnabled(), false);
                this.computeDiff("COMEnabled", this.bean.isCOMEnabled(), networkChannelMBeanImpl.isCOMEnabled(), false);
                this.computeDiff("HTTPEnabled", this.bean.isHTTPEnabled(), networkChannelMBeanImpl.isHTTPEnabled(), false);
                this.computeDiff("HTTPSEnabled", this.bean.isHTTPSEnabled(), networkChannelMBeanImpl.isHTTPSEnabled(), false);
                this.computeDiff("IIOPEnabled", this.bean.isIIOPEnabled(), networkChannelMBeanImpl.isIIOPEnabled(), false);
                this.computeDiff("IIOPSEnabled", this.bean.isIIOPSEnabled(), networkChannelMBeanImpl.isIIOPSEnabled(), false);
                this.computeDiff("ListenPortEnabled", this.bean.isListenPortEnabled(), networkChannelMBeanImpl.isListenPortEnabled(), false);
                this.computeDiff("OutgoingEnabled", this.bean.isOutgoingEnabled(), networkChannelMBeanImpl.isOutgoingEnabled(), false);
                this.computeDiff("SSLListenPortEnabled", this.bean.isSSLListenPortEnabled(), networkChannelMBeanImpl.isSSLListenPortEnabled(), false);
                this.computeDiff("T3Enabled", this.bean.isT3Enabled(), networkChannelMBeanImpl.isT3Enabled(), false);
                this.computeDiff("T3SEnabled", this.bean.isT3SEnabled(), networkChannelMBeanImpl.isT3SEnabled(), false);
                this.computeDiff("TunnelingEnabled", this.bean.isTunnelingEnabled(), networkChannelMBeanImpl.isTunnelingEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                NetworkChannelMBeanImpl networkChannelMBeanImpl = (NetworkChannelMBeanImpl)beanUpdateEvent.getSourceBean();
                NetworkChannelMBeanImpl networkChannelMBeanImpl2 = (NetworkChannelMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AcceptBacklog")) {
                    networkChannelMBeanImpl.setAcceptBacklog(networkChannelMBeanImpl2.getAcceptBacklog());
                    networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("ChannelWeight")) {
                    networkChannelMBeanImpl.setChannelWeight(networkChannelMBeanImpl2.getChannelWeight());
                    networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("ClusterAddress")) {
                    networkChannelMBeanImpl.setClusterAddress(networkChannelMBeanImpl2.getClusterAddress());
                    networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("CompleteCOMMessageTimeout")) {
                    networkChannelMBeanImpl.setCompleteCOMMessageTimeout(networkChannelMBeanImpl2.getCompleteCOMMessageTimeout());
                    networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else if (string.equals("CompleteHTTPMessageTimeout")) {
                    networkChannelMBeanImpl.setCompleteHTTPMessageTimeout(networkChannelMBeanImpl2.getCompleteHTTPMessageTimeout());
                    networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("CompleteIIOPMessageTimeout")) {
                    networkChannelMBeanImpl.setCompleteIIOPMessageTimeout(networkChannelMBeanImpl2.getCompleteIIOPMessageTimeout());
                    networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                } else if (string.equals("CompleteT3MessageTimeout")) {
                    networkChannelMBeanImpl.setCompleteT3MessageTimeout(networkChannelMBeanImpl2.getCompleteT3MessageTimeout());
                    networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (!string.equals("DefaultIIOPPassword")) {
                    if (string.equals("DefaultIIOPPasswordEncrypted")) {
                        networkChannelMBeanImpl.setDefaultIIOPPasswordEncrypted(networkChannelMBeanImpl2.getDefaultIIOPPasswordEncrypted());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                    } else if (string.equals("DefaultIIOPUser")) {
                        networkChannelMBeanImpl.setDefaultIIOPUser(networkChannelMBeanImpl2.getDefaultIIOPUser());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                    } else if (string.equals("Description")) {
                        networkChannelMBeanImpl.setDescription(networkChannelMBeanImpl2.getDescription());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("IdleIIOPConnectionTimeout")) {
                        networkChannelMBeanImpl.setIdleIIOPConnectionTimeout(networkChannelMBeanImpl2.getIdleIIOPConnectionTimeout());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                    } else if (string.equals("ListenPort")) {
                        networkChannelMBeanImpl.setListenPort(networkChannelMBeanImpl2.getListenPort());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("LoginTimeoutMillis")) {
                        networkChannelMBeanImpl.setLoginTimeoutMillis(networkChannelMBeanImpl2.getLoginTimeoutMillis());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                    } else if (string.equals("LoginTimeoutMillisSSL")) {
                        networkChannelMBeanImpl.setLoginTimeoutMillisSSL(networkChannelMBeanImpl2.getLoginTimeoutMillisSSL());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                    } else if (string.equals("MaxCOMMessageSize")) {
                        networkChannelMBeanImpl.setMaxCOMMessageSize(networkChannelMBeanImpl2.getMaxCOMMessageSize());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                    } else if (string.equals("MaxHTTPMessageSize")) {
                        networkChannelMBeanImpl.setMaxHTTPMessageSize(networkChannelMBeanImpl2.getMaxHTTPMessageSize());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                    } else if (string.equals("MaxIIOPMessageSize")) {
                        networkChannelMBeanImpl.setMaxIIOPMessageSize(networkChannelMBeanImpl2.getMaxIIOPMessageSize());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                    } else if (string.equals("MaxT3MessageSize")) {
                        networkChannelMBeanImpl.setMaxT3MessageSize(networkChannelMBeanImpl2.getMaxT3MessageSize());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                    } else if (string.equals("Name")) {
                        networkChannelMBeanImpl.setName(networkChannelMBeanImpl2.getName());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("SSLListenPort")) {
                        networkChannelMBeanImpl.setSSLListenPort(networkChannelMBeanImpl2.getSSLListenPort());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("TunnelingClientPingSecs")) {
                        networkChannelMBeanImpl.setTunnelingClientPingSecs(networkChannelMBeanImpl2.getTunnelingClientPingSecs());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                    } else if (string.equals("TunnelingClientTimeoutSecs")) {
                        networkChannelMBeanImpl.setTunnelingClientTimeoutSecs(networkChannelMBeanImpl2.getTunnelingClientTimeoutSecs());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                    } else if (string.equals("BoundOutgoingEnabled")) {
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("COMEnabled")) {
                        networkChannelMBeanImpl.setCOMEnabled(networkChannelMBeanImpl2.isCOMEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else if (string.equals("HTTPEnabled")) {
                        networkChannelMBeanImpl.setHTTPEnabled(networkChannelMBeanImpl2.isHTTPEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("HTTPSEnabled")) {
                        networkChannelMBeanImpl.setHTTPSEnabled(networkChannelMBeanImpl2.isHTTPSEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("IIOPEnabled")) {
                        networkChannelMBeanImpl.setIIOPEnabled(networkChannelMBeanImpl2.isIIOPEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                    } else if (string.equals("IIOPSEnabled")) {
                        networkChannelMBeanImpl.setIIOPSEnabled(networkChannelMBeanImpl2.isIIOPSEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                    } else if (string.equals("ListenPortEnabled")) {
                        networkChannelMBeanImpl.setListenPortEnabled(networkChannelMBeanImpl2.isListenPortEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("OutgoingEnabled")) {
                        networkChannelMBeanImpl.setOutgoingEnabled(networkChannelMBeanImpl2.isOutgoingEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                    } else if (string.equals("SSLListenPortEnabled")) {
                        networkChannelMBeanImpl.setSSLListenPortEnabled(networkChannelMBeanImpl2.isSSLListenPortEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("T3Enabled")) {
                        networkChannelMBeanImpl.setT3Enabled(networkChannelMBeanImpl2.isT3Enabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("T3SEnabled")) {
                        networkChannelMBeanImpl.setT3SEnabled(networkChannelMBeanImpl2.isT3SEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("TunnelingEnabled")) {
                        networkChannelMBeanImpl.setTunnelingEnabled(networkChannelMBeanImpl2.isTunnelingEnabled());
                        networkChannelMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                NetworkChannelMBeanImpl networkChannelMBeanImpl = (NetworkChannelMBeanImpl)abstractDescriptorBean;
                super.finishCopy(networkChannelMBeanImpl, bl, list);
                if ((list == null || !list.contains("AcceptBacklog")) && this.bean.isAcceptBacklogSet()) {
                    networkChannelMBeanImpl.setAcceptBacklog(this.bean.getAcceptBacklog());
                }
                if ((list == null || !list.contains("ChannelWeight")) && this.bean.isChannelWeightSet()) {
                    networkChannelMBeanImpl.setChannelWeight(this.bean.getChannelWeight());
                }
                if ((list == null || !list.contains("ClusterAddress")) && this.bean.isClusterAddressSet()) {
                    networkChannelMBeanImpl.setClusterAddress(this.bean.getClusterAddress());
                }
                if ((list == null || !list.contains("CompleteCOMMessageTimeout")) && this.bean.isCompleteCOMMessageTimeoutSet()) {
                    networkChannelMBeanImpl.setCompleteCOMMessageTimeout(this.bean.getCompleteCOMMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteHTTPMessageTimeout")) && this.bean.isCompleteHTTPMessageTimeoutSet()) {
                    networkChannelMBeanImpl.setCompleteHTTPMessageTimeout(this.bean.getCompleteHTTPMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteIIOPMessageTimeout")) && this.bean.isCompleteIIOPMessageTimeoutSet()) {
                    networkChannelMBeanImpl.setCompleteIIOPMessageTimeout(this.bean.getCompleteIIOPMessageTimeout());
                }
                if ((list == null || !list.contains("CompleteT3MessageTimeout")) && this.bean.isCompleteT3MessageTimeoutSet()) {
                    networkChannelMBeanImpl.setCompleteT3MessageTimeout(this.bean.getCompleteT3MessageTimeout());
                }
                if ((list == null || !list.contains("DefaultIIOPPasswordEncrypted")) && this.bean.isDefaultIIOPPasswordEncryptedSet()) {
                    byte[] byArray = this.bean.getDefaultIIOPPasswordEncrypted();
                    networkChannelMBeanImpl.setDefaultIIOPPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("DefaultIIOPUser")) && this.bean.isDefaultIIOPUserSet()) {
                    networkChannelMBeanImpl.setDefaultIIOPUser(this.bean.getDefaultIIOPUser());
                }
                if ((list == null || !list.contains("Description")) && this.bean.isDescriptionSet()) {
                    networkChannelMBeanImpl.setDescription(this.bean.getDescription());
                }
                if ((list == null || !list.contains("IdleIIOPConnectionTimeout")) && this.bean.isIdleIIOPConnectionTimeoutSet()) {
                    networkChannelMBeanImpl.setIdleIIOPConnectionTimeout(this.bean.getIdleIIOPConnectionTimeout());
                }
                if ((list == null || !list.contains("ListenPort")) && this.bean.isListenPortSet()) {
                    networkChannelMBeanImpl.setListenPort(this.bean.getListenPort());
                }
                if ((list == null || !list.contains("LoginTimeoutMillis")) && this.bean.isLoginTimeoutMillisSet()) {
                    networkChannelMBeanImpl.setLoginTimeoutMillis(this.bean.getLoginTimeoutMillis());
                }
                if ((list == null || !list.contains("LoginTimeoutMillisSSL")) && this.bean.isLoginTimeoutMillisSSLSet()) {
                    networkChannelMBeanImpl.setLoginTimeoutMillisSSL(this.bean.getLoginTimeoutMillisSSL());
                }
                if ((list == null || !list.contains("MaxCOMMessageSize")) && this.bean.isMaxCOMMessageSizeSet()) {
                    networkChannelMBeanImpl.setMaxCOMMessageSize(this.bean.getMaxCOMMessageSize());
                }
                if ((list == null || !list.contains("MaxHTTPMessageSize")) && this.bean.isMaxHTTPMessageSizeSet()) {
                    networkChannelMBeanImpl.setMaxHTTPMessageSize(this.bean.getMaxHTTPMessageSize());
                }
                if ((list == null || !list.contains("MaxIIOPMessageSize")) && this.bean.isMaxIIOPMessageSizeSet()) {
                    networkChannelMBeanImpl.setMaxIIOPMessageSize(this.bean.getMaxIIOPMessageSize());
                }
                if ((list == null || !list.contains("MaxT3MessageSize")) && this.bean.isMaxT3MessageSizeSet()) {
                    networkChannelMBeanImpl.setMaxT3MessageSize(this.bean.getMaxT3MessageSize());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    networkChannelMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("SSLListenPort")) && this.bean.isSSLListenPortSet()) {
                    networkChannelMBeanImpl.setSSLListenPort(this.bean.getSSLListenPort());
                }
                if ((list == null || !list.contains("TunnelingClientPingSecs")) && this.bean.isTunnelingClientPingSecsSet()) {
                    networkChannelMBeanImpl.setTunnelingClientPingSecs(this.bean.getTunnelingClientPingSecs());
                }
                if ((list == null || !list.contains("TunnelingClientTimeoutSecs")) && this.bean.isTunnelingClientTimeoutSecsSet()) {
                    networkChannelMBeanImpl.setTunnelingClientTimeoutSecs(this.bean.getTunnelingClientTimeoutSecs());
                }
                if (list != null && list.contains("BoundOutgoingEnabled") || this.bean.isBoundOutgoingEnabledSet()) {
                    // empty if block
                }
                if ((list == null || !list.contains("COMEnabled")) && this.bean.isCOMEnabledSet()) {
                    networkChannelMBeanImpl.setCOMEnabled(this.bean.isCOMEnabled());
                }
                if ((list == null || !list.contains("HTTPEnabled")) && this.bean.isHTTPEnabledSet()) {
                    networkChannelMBeanImpl.setHTTPEnabled(this.bean.isHTTPEnabled());
                }
                if ((list == null || !list.contains("HTTPSEnabled")) && this.bean.isHTTPSEnabledSet()) {
                    networkChannelMBeanImpl.setHTTPSEnabled(this.bean.isHTTPSEnabled());
                }
                if ((list == null || !list.contains("IIOPEnabled")) && this.bean.isIIOPEnabledSet()) {
                    networkChannelMBeanImpl.setIIOPEnabled(this.bean.isIIOPEnabled());
                }
                if ((list == null || !list.contains("IIOPSEnabled")) && this.bean.isIIOPSEnabledSet()) {
                    networkChannelMBeanImpl.setIIOPSEnabled(this.bean.isIIOPSEnabled());
                }
                if ((list == null || !list.contains("ListenPortEnabled")) && this.bean.isListenPortEnabledSet()) {
                    networkChannelMBeanImpl.setListenPortEnabled(this.bean.isListenPortEnabled());
                }
                if ((list == null || !list.contains("OutgoingEnabled")) && this.bean.isOutgoingEnabledSet()) {
                    networkChannelMBeanImpl.setOutgoingEnabled(this.bean.isOutgoingEnabled());
                }
                if ((list == null || !list.contains("SSLListenPortEnabled")) && this.bean.isSSLListenPortEnabledSet()) {
                    networkChannelMBeanImpl.setSSLListenPortEnabled(this.bean.isSSLListenPortEnabled());
                }
                if ((list == null || !list.contains("T3Enabled")) && this.bean.isT3EnabledSet()) {
                    networkChannelMBeanImpl.setT3Enabled(this.bean.isT3Enabled());
                }
                if ((list == null || !list.contains("T3SEnabled")) && this.bean.isT3SEnabledSet()) {
                    networkChannelMBeanImpl.setT3SEnabled(this.bean.isT3SEnabled());
                }
                if ((list == null || !list.contains("TunnelingEnabled")) && this.bean.isTunnelingEnabledSet()) {
                    networkChannelMBeanImpl.setTunnelingEnabled(this.bean.isTunnelingEnabled());
                }
                return networkChannelMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

