/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Map;
import weblogic.management.configuration.DeploymentMBeanImplBeanInfo;
import weblogic.management.configuration.NetworkChannelMBean;
import weblogic.management.configuration.NetworkChannelMBeanImpl;
import weblogic.management.internal.mbean.BeanInfoHelper;

public class NetworkChannelMBeanImplBeanInfo
extends DeploymentMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = NetworkChannelMBean.class;

    public NetworkChannelMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public NetworkChannelMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = NetworkChannelMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("deprecated", "7.0.0.0 use {@link NetworkAccessPointMBean} ");
        String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"ServerMBean#getListenPort"), BeanInfoHelper.encodeEntities((String)"ServerMBean#getAdministrationPort"), BeanInfoHelper.encodeEntities((String)"SSLMBean#getListenPort"), BeanInfoHelper.encodeEntities((String)"ServerMBean#getSSL"), BeanInfoHelper.encodeEntities((String)"NetworkAccessPointMBean"), BeanInfoHelper.encodeEntities((String)"ServerMBean#getNetworkAccessPoints")};
        beanDescriptor.setValue("see", stringArray);
        beanDescriptor.setValue("package", "weblogic.management.configuration");
        String string = new String("This MBean defines a network channel.   A network channel is used to configure additional ports for a server beyond its default listen ports.   Network channels do not support IIOP. <p> A network channel can be targeted at multiple clusters and servers. Targeting a channel at a cluster targets it at every server that is a member of that cluster. A server can support multiple channels.</p> A server can fine-tune its network channel settings by using a NetworkAccessPointMBean.  The NetworkAccessPointMBean also servers to set the listen address and external DNS name that a server uses for a particular channel. <p> A server serves up to three default listen ports: ServerMBean ListenPort, ServerMBean AdministrationPort, and SSLMBean ListenPort. The default listen ports form implicit channel(s) of weight 50.</p> <p> A network channel also defines the creation of server-to-server connections. If a server is initiating a new connection to another server, the highest weighted common (same named) channel that supports the desired protocol is used to determine which port to contact.</p>  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime. For more information, see \"Developing Manageable Applications with JMX.\"</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.configuration.NetworkChannelMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("AcceptBacklog")) {
            string2 = "getAcceptBacklog";
            string = null;
            if (!this.readOnly) {
                string = "setAcceptBacklog";
            }
            propertyDescriptor = new PropertyDescriptor("AcceptBacklog", NetworkChannelMBean.class, string2, string);
            map.put("AcceptBacklog", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Allowed backlog of connection requests on the listen port(s). Individual servers may override this value using a NetworkAccessPointMBean. Setting the backlog to 0 may prevent accepting any incoming connection on some of the OS.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getAcceptBacklog"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#getAcceptBacklog")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(50));
            propertyDescriptor.setValue("legalMin", new Integer(0));
        }
        if (!map.containsKey("ChannelWeight")) {
            string2 = "getChannelWeight";
            string = null;
            if (!this.readOnly) {
                string = "setChannelWeight";
            }
            propertyDescriptor = new PropertyDescriptor("ChannelWeight", NetworkChannelMBean.class, string2, string);
            map.put("ChannelWeight", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>A weight to give this channel when creating server-to-server connections.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkChannelMBean")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(50));
            propertyDescriptor.setValue("legalMax", new Integer(100));
            propertyDescriptor.setValue("legalMin", new Integer(1));
        }
        if (!map.containsKey("ClusterAddress")) {
            string2 = "getClusterAddress";
            string = null;
            if (!this.readOnly) {
                string = "setClusterAddress";
            }
            propertyDescriptor = new PropertyDescriptor("ClusterAddress", NetworkChannelMBean.class, string2, string);
            map.put("ClusterAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>This channel's cluster address. If this is not set, the cluster address from the cluster configuration is used in its place.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ClusterMBean#getClusterAddress")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
        }
        if (!map.containsKey("CompleteCOMMessageTimeout")) {
            string2 = "getCompleteCOMMessageTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setCompleteCOMMessageTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("CompleteCOMMessageTimeout", NetworkChannelMBean.class, string2, string);
            map.put("CompleteCOMMessageTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of seconds spent waiting for a complete COM message to be received. This attribute helps guard against denial of service attacks in which a caller indicates that they will be sending a message of a certain size which they never finish sending. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getCompleteCOMMessageTimeout"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getCompleteCOMMessageTimeout")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(60));
            propertyDescriptor.setValue("secureValue", new Integer(60));
            propertyDescriptor.setValue("legalMax", new Integer(480));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CompleteHTTPMessageTimeout")) {
            string2 = "getCompleteHTTPMessageTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setCompleteHTTPMessageTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("CompleteHTTPMessageTimeout", NetworkChannelMBean.class, string2, string);
            map.put("CompleteHTTPMessageTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of seconds spent waiting for a complete HTTP message to be received. This attribute helps guard against denial of service attacks in which a caller indicates that they will be sending a message of a certain size which they never finish sending. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getCompleteHTTPMessageTimeout"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getCompleteHTTPMessageTimeout")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(60));
            propertyDescriptor.setValue("secureValue", new Integer(60));
            propertyDescriptor.setValue("legalMax", new Integer(480));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CompleteT3MessageTimeout")) {
            string2 = "getCompleteT3MessageTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setCompleteT3MessageTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("CompleteT3MessageTimeout", NetworkChannelMBean.class, string2, string);
            map.put("CompleteT3MessageTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of seconds spent waiting for a complete T3 message to be received. This attribute helps guard against denial of service attacks in which a caller indicates that they will be sending a message of a certain size which they never finish sending. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getCompleteT3MessageTimeout"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getCompleteT3MessageTimeout")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(60));
            propertyDescriptor.setValue("secureValue", new Integer(60));
            propertyDescriptor.setValue("legalMax", new Integer(480));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultIIOPPasswordEncrypted")) {
            string2 = "getDefaultIIOPPasswordEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultIIOPPasswordEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultIIOPPasswordEncrypted", NetworkChannelMBean.class, string2, string);
            map.put("DefaultIIOPPasswordEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted password for the default IIOP user.</p>  <p>To set this attribute, use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.EncryptionHelper")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("Description")) {
            string2 = "getDescription";
            string = null;
            if (!this.readOnly) {
                string = "setDescription";
            }
            propertyDescriptor = new PropertyDescriptor("Description", NetworkChannelMBean.class, string2, string);
            map.put("Description", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Optional short description of this channel for console display purposes. For long descriptions, use the \"Notes\" field.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
        }
        if (!map.containsKey("ListenPort")) {
            string2 = "getListenPort";
            string = null;
            if (!this.readOnly) {
                string = "setListenPort";
            }
            propertyDescriptor = new PropertyDescriptor("ListenPort", NetworkChannelMBean.class, string2, string);
            map.put("ListenPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The plaintext (non-SSL) listen port for the channel. Individual servers may override this value, but may not enable the port if disabled here and may not disable the port if enabled here. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isListenPortEnabled"), BeanInfoHelper.encodeEntities((String)"#getSSLListenPort"), BeanInfoHelper.encodeEntities((String)"NetworkAccessPointMBean#getListenPort"), BeanInfoHelper.encodeEntities((String)"NetworkAccessPointMBean#getListenAddress"), BeanInfoHelper.encodeEntities((String)"NetworkAccessPointMBean#getExternalDNSName"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#getListenPort")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(8001));
            propertyDescriptor.setValue("legalMax", new Integer(65535));
            propertyDescriptor.setValue("legalMin", new Integer(1));
        }
        if (!map.containsKey("LoginTimeoutMillis")) {
            string2 = "getLoginTimeoutMillis";
            string = null;
            if (!this.readOnly) {
                string = "setLoginTimeoutMillis";
            }
            propertyDescriptor = new PropertyDescriptor("LoginTimeoutMillis", NetworkChannelMBean.class, string2, string);
            map.put("LoginTimeoutMillis", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The login timeout for the server, in milliseconds. This value must be equal to or greater than 0. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getLoginTimeoutMillis"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#getLoginTimeoutMillis")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(5000));
            propertyDescriptor.setValue("secureValue", new Integer(5000));
            propertyDescriptor.setValue("legalMax", new Integer(100000));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("LoginTimeoutMillisSSL")) {
            string2 = "getLoginTimeoutMillisSSL";
            string = null;
            if (!this.readOnly) {
                string = "setLoginTimeoutMillisSSL";
            }
            propertyDescriptor = new PropertyDescriptor("LoginTimeoutMillisSSL", NetworkChannelMBean.class, string2, string);
            map.put("LoginTimeoutMillisSSL", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Duration allowed for an SSL login sequence. If the duration is exceeded, the login is timed out. 0 to disable. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getLoginTimeoutMillisSSL"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#getLoginTimeoutMillis")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(25000));
            propertyDescriptor.setValue("secureValue", new Integer(25000));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MaxCOMMessageSize")) {
            string2 = "getMaxCOMMessageSize";
            string = null;
            if (!this.readOnly) {
                string = "setMaxCOMMessageSize";
            }
            propertyDescriptor = new PropertyDescriptor("MaxCOMMessageSize", NetworkChannelMBean.class, string2, string);
            map.put("MaxCOMMessageSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum COM message size allowable in a message header. This attribute attempts to prevent a denial of service attack whereby a caller attempts to force the server to allocate more memory than is available thereby keeping the server from responding quickly to other requests. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getMaxCOMMessageSize"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getMaxCOMMessageSize")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10000000));
            propertyDescriptor.setValue("secureValue", new Integer(10000000));
            propertyDescriptor.setValue("legalMax", new Integer(2000000000));
            propertyDescriptor.setValue("legalMin", new Integer(4096));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MaxHTTPMessageSize")) {
            string2 = "getMaxHTTPMessageSize";
            string = null;
            if (!this.readOnly) {
                string = "setMaxHTTPMessageSize";
            }
            propertyDescriptor = new PropertyDescriptor("MaxHTTPMessageSize", NetworkChannelMBean.class, string2, string);
            map.put("MaxHTTPMessageSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum HTTP message size allowable in a message header. This attribute attempts to prevent a denial of service attack whereby a caller attempts to force the server to allocate more memory than is available thereby keeping the server from responding quickly to other requests. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getMaxHTTPMessageSize"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getMaxHTTPMessageSize")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10000000));
            propertyDescriptor.setValue("secureValue", new Integer(10000000));
            propertyDescriptor.setValue("legalMax", new Integer(2000000000));
            propertyDescriptor.setValue("legalMin", new Integer(4096));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MaxT3MessageSize")) {
            string2 = "getMaxT3MessageSize";
            string = null;
            if (!this.readOnly) {
                string = "setMaxT3MessageSize";
            }
            propertyDescriptor = new PropertyDescriptor("MaxT3MessageSize", NetworkChannelMBean.class, string2, string);
            map.put("MaxT3MessageSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum T3 message size allowable in a message header. This attribute attempts to prevent a denial of service attack whereby a caller attempts to force the server to allocate more memory than is available thereby keeping the server from responding quickly to other requests. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getMaxT3MessageSize"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getMaxT3MessageSize")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10000000));
            propertyDescriptor.setValue("secureValue", new Integer(10000000));
            propertyDescriptor.setValue("legalMax", new Integer(2000000000));
            propertyDescriptor.setValue("legalMin", new Integer(4096));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            if (!this.readOnly) {
                string = "setName";
            }
            propertyDescriptor = new PropertyDescriptor("Name", NetworkChannelMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the channel. The name must not start with \".WL\".</p> ");
            propertyDescriptor.setValue("key", Boolean.TRUE);
        }
        if (!map.containsKey("SSLListenPort")) {
            string2 = "getSSLListenPort";
            string = null;
            if (!this.readOnly) {
                string = "setSSLListenPort";
            }
            propertyDescriptor = new PropertyDescriptor("SSLListenPort", NetworkChannelMBean.class, string2, string);
            map.put("SSLListenPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The SSL listen port for the channel. Individual server's may override this value, but may not enable the port if disabled here and may not disable the port if enabled here. SSL must be configured and enabled for this port to work. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getSSLListenPort"), BeanInfoHelper.encodeEntities((String)"#isSSLListenPortEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#getListenPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL"), BeanInfoHelper.encodeEntities((String)"NetworkAccessPointMBean#getSSLListenPort"), BeanInfoHelper.encodeEntities((String)"NetworkAccessPointMBean#getListenAddress")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(8002));
            propertyDescriptor.setValue("legalMax", new Integer(65535));
            propertyDescriptor.setValue("legalMin", new Integer(1));
        }
        if (!map.containsKey("TunnelingClientPingSecs")) {
            string2 = "getTunnelingClientPingSecs";
            string = null;
            if (!this.readOnly) {
                string = "setTunnelingClientPingSecs";
            }
            propertyDescriptor = new PropertyDescriptor("TunnelingClientPingSecs", NetworkChannelMBean.class, string2, string);
            map.put("TunnelingClientPingSecs", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Interval (in seconds) at which to ping an http-tunneled client to see if its still alive. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#getTunnelingClientPingSecs"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getTunnelingClientPingSecs")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(45));
            propertyDescriptor.setValue("legalMin", new Integer(1));
        }
        if (!map.containsKey("TunnelingClientTimeoutSecs")) {
            string2 = "getTunnelingClientTimeoutSecs";
            string = null;
            if (!this.readOnly) {
                string = "setTunnelingClientTimeoutSecs";
            }
            propertyDescriptor = new PropertyDescriptor("TunnelingClientTimeoutSecs", NetworkChannelMBean.class, string2, string);
            map.put("TunnelingClientTimeoutSecs", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Duration (in seconds) after which a missing http-tunneled client is considered dead. Individual servers may override this value using a NetworkAccessPointMBean.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#getTunnelingClientTimeoutSecs"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getTunnelingClientTimeoutSecs")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(40));
            propertyDescriptor.setValue("secureValue", new Integer(40));
            propertyDescriptor.setValue("legalMin", new Integer(1));
        }
        if (!map.containsKey("BoundOutgoingEnabled")) {
            string2 = "isBoundOutgoingEnabled";
            string = null;
            propertyDescriptor = new PropertyDescriptor("BoundOutgoingEnabled", NetworkChannelMBean.class, string2, string);
            map.put("BoundOutgoingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Bind new outgoing server side T3 or T3S connections to the server channel's listen address. Other protocols ignore this field. This field is ignored for connections initiated via URLs, it takes effect if and only if the connection was initiated by accessing a remote reference (such as an EJB or RMI stub.)</p> ");
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
        }
        if (!map.containsKey("COMEnabled")) {
            string2 = "isCOMEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setCOMEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("COMEnabled", NetworkChannelMBean.class, string2, string);
            map.put("COMEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether plaintext (non-SSL) COM traffic is enabled.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#isCOMEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
        }
        if (!map.containsKey("HTTPEnabled")) {
            string2 = "isHTTPEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setHTTPEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("HTTPEnabled", NetworkChannelMBean.class, string2, string);
            map.put("HTTPEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not plaintext (non-SSL) HTTP traffic is enabled.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#isHttpdEnabled"), BeanInfoHelper.encodeEntities((String)"#isHTTPSEnabled"), BeanInfoHelper.encodeEntities((String)"#isTunnelingEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
        }
        if (!map.containsKey("HTTPSEnabled")) {
            string2 = "isHTTPSEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setHTTPSEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("HTTPSEnabled", NetworkChannelMBean.class, string2, string);
            map.put("HTTPSEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not secure (SSL) HTTP traffic is enabled.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#isHttpdEnabled"), BeanInfoHelper.encodeEntities((String)"#isHTTPEnabled"), BeanInfoHelper.encodeEntities((String)"#isTunnelingEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
        }
        if (!map.containsKey("ListenPortEnabled")) {
            string2 = "isListenPortEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setListenPortEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ListenPortEnabled", NetworkChannelMBean.class, string2, string);
            map.put("ListenPortEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not plaintext port is enabled for the channel.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getListenPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#isListenPortEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
        }
        if (!map.containsKey("OutgoingEnabled")) {
            string2 = "isOutgoingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setOutgoingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("OutgoingEnabled", NetworkChannelMBean.class, string2, string);
            map.put("OutgoingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not new server-to-server connections may consider this channel when initiating.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkChannelMBean")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
        }
        if (!map.containsKey("SSLListenPortEnabled")) {
            string2 = "isSSLListenPortEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setSSLListenPortEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("SSLListenPortEnabled", NetworkChannelMBean.class, string2, string);
            map.put("SSLListenPortEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not SSL port is enabled for the channel. SSL must be configured and enabled in addition to this setting for the SSL port to work.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#isListenPortEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
        }
        if (!map.containsKey("T3Enabled")) {
            string2 = "isT3Enabled";
            string = null;
            if (!this.readOnly) {
                string = "setT3Enabled";
            }
            propertyDescriptor = new PropertyDescriptor("T3Enabled", NetworkChannelMBean.class, string2, string);
            map.put("T3Enabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not plaintext (non-SSL) T3 traffic is enabled. Note that it is not possible to disable T3 traffic on the default channel(s).</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkChannelMBean"), BeanInfoHelper.encodeEntities((String)"#isT3SEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
        }
        if (!map.containsKey("T3SEnabled")) {
            string2 = "isT3SEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setT3SEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("T3SEnabled", NetworkChannelMBean.class, string2, string);
            map.put("T3SEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not secure T3 traffic is enabled. Note that it is not possible to disable T3 traffic on the default channel(s).</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkChannelMBean"), BeanInfoHelper.encodeEntities((String)"#isT3Enabled")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
        }
        if (!map.containsKey("TunnelingEnabled")) {
            string2 = "isTunnelingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setTunnelingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("TunnelingEnabled", NetworkChannelMBean.class, string2, string);
            map.put("TunnelingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Enables tunneling via http.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#isTunnelingEnabled"), BeanInfoHelper.encodeEntities((String)"#isHTTPEnabled"), BeanInfoHelper.encodeEntities((String)"#isHTTPSEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            NetworkChannelMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

