/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.ConfigurationMBeanBinder;
import weblogic.management.configuration.NodeManagerMBeanImpl;
import weblogic.management.internal.mbean.SecurityReadOnlyMBeanBinder;
import weblogic.utils.codegen.AttributeBinder;

public class NodeManagerMBeanBinder
extends ConfigurationMBeanBinder
implements AttributeBinder {
    private NodeManagerMBeanImpl bean;

    protected NodeManagerMBeanBinder(DescriptorBean descriptorBean) {
        super(descriptorBean);
        this.bean = (NodeManagerMBeanImpl)descriptorBean;
    }

    public NodeManagerMBeanBinder() {
        super(new NodeManagerMBeanImpl());
        this.bean = (NodeManagerMBeanImpl)this.getBean();
    }

    public AttributeBinder bindAttribute(String string, Object object) throws IllegalArgumentException {
        try {
            NodeManagerMBeanBinder nodeManagerMBeanBinder = this;
            if (!(nodeManagerMBeanBinder instanceof SecurityReadOnlyMBeanBinder) && object != null && object.toString().trim().length() == 0) {
                return nodeManagerMBeanBinder;
            }
            if (string != null) {
                if (string.equals("Adapter")) {
                    try {
                        this.bean.setAdapter((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("AdapterName")) {
                    this.handleDeprecatedProperty("AdapterName", "10.3.4.0 Replaced by {@link weblogic.management.configuration.NodeManagerMBean#getAdapter()}");
                    try {
                        this.bean.setAdapterName((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("AdapterVersion")) {
                    this.handleDeprecatedProperty("AdapterVersion", "10.3.4.0 Replaced by {@link weblogic.management.configuration.NodeManagerMBean#setAdapter()}");
                    try {
                        this.bean.setAdapterVersion((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else {
                    if (string.equals("InstalledVMMAdapters")) {
                        throw new AssertionError((Object)"can't set read-only property InstalledVMMAdapters");
                    }
                    if (string.equals("ListenAddress")) {
                        try {
                            this.bean.setListenAddress((String)object);
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else if (string.equals("ListenPort")) {
                        try {
                            this.bean.setListenPort(Integer.valueOf((String)object));
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else if (string.equals("NMType")) {
                        try {
                            this.bean.setNMType((String)object);
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else if (string.equals("Name")) {
                        try {
                            this.bean.setName((String)object);
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else if (string.equals("NodeManagerHome")) {
                        try {
                            this.bean.setNodeManagerHome((String)object);
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else if (string.equals("Password")) {
                        try {
                            if (this.bean.isPasswordEncryptedSet()) {
                                throw new IllegalArgumentException("Encrypted attribute corresponding to Password [ NodeManagerMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                            }
                            this.bean.setPassword((String)object);
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else if (string.equals("PasswordEncrypted")) {
                        if (this.bean.isPasswordEncryptedSet()) {
                            throw new IllegalArgumentException("Unencrypted attribute corresponding to PasswordEncrypted [ NodeManagerMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                        }
                        this.bean.setPasswordEncryptedAsString((String)object);
                    } else if (string.equals("ShellCommand")) {
                        try {
                            this.bean.setShellCommand((String)object);
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else if (string.equals("UserName")) {
                        try {
                            this.bean.setUserName((String)object);
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else if (string.equals("DebugEnabled")) {
                        try {
                            this.bean.setDebugEnabled(Boolean.valueOf((String)object));
                        }
                        catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                            System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                        }
                    } else {
                        nodeManagerMBeanBinder = super.bindAttribute(string, object);
                    }
                }
            }
            return nodeManagerMBeanBinder;
        }
        catch (ClassCastException classCastException) {
            System.out.println(classCastException + " name: " + string + " class: " + object.getClass().getName());
            throw classCastException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            if (exception instanceof DistributedManagementException) {
                throw new AssertionError((Object)("impossible exception: " + exception));
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            throw new AssertionError((Object)("unexpected exception: " + exception));
        }
    }
}

