/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.NodeManagerMBean;
import weblogic.management.configuration.VMMAdapterValidator;
import weblogic.management.mbeans.custom.NodeManager;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class NodeManagerMBeanImpl
extends ConfigurationMBeanImpl
implements NodeManagerMBean,
Serializable {
    private String _Adapter;
    private String _AdapterName;
    private String _AdapterVersion;
    private boolean _DebugEnabled;
    private String[] _InstalledVMMAdapters;
    private String _ListenAddress;
    private int _ListenPort;
    private String _NMType;
    private String _Name;
    private String _NodeManagerHome;
    private String _Password;
    private byte[] _PasswordEncrypted;
    private String _ShellCommand;
    private String _UserName;
    private NodeManager _customizer;
    private static SchemaHelper2 _schemaHelper;

    public NodeManagerMBeanImpl() {
        try {
            this._customizer = new NodeManager(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public NodeManagerMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new NodeManager(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setNMType(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"SSH", "RSH", "Plain", "SSL", "ssh", "rsh", "ssl", "plain", "VMM", "vmm", "VMMS", "vmms"};
        string = LegalChecks.checkInEnum((String)"NMType", (String)string, (String[])stringArray);
        String string2 = this._NMType;
        this._NMType = string;
        this._postSet(7, string2, string);
    }

    public String getNMType() {
        return this._NMType;
    }

    public boolean isNMTypeSet() {
        return this._isSet(7);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public String getListenAddress() {
        return this._ListenAddress;
    }

    public boolean isListenAddressSet() {
        return this._isSet(8);
    }

    public void setListenAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ListenAddress;
        this._ListenAddress = string;
        this._postSet(8, string2, string);
    }

    public int getListenPort() {
        return this._ListenPort;
    }

    public boolean isListenPortSet() {
        return this._isSet(9);
    }

    public void setListenPort(int n) {
        LegalChecks.checkInRange((String)"ListenPort", (long)n, (long)1L, (long)65534L);
        int n2 = this._ListenPort;
        this._ListenPort = n;
        this._postSet(9, n2, n);
    }

    public boolean isDebugEnabled() {
        return this._DebugEnabled;
    }

    public boolean isDebugEnabledSet() {
        return this._isSet(10);
    }

    public void setDebugEnabled(boolean bl) {
        boolean bl2 = this._DebugEnabled;
        this._DebugEnabled = bl;
        this._postSet(10, bl2, bl);
    }

    public void setShellCommand(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ShellCommand;
        this._ShellCommand = string;
        this._postSet(11, string2, string);
    }

    public String getShellCommand() {
        return this._ShellCommand;
    }

    public boolean isShellCommandSet() {
        return this._isSet(11);
    }

    public void setNodeManagerHome(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._NodeManagerHome;
        this._NodeManagerHome = string;
        this._postSet(12, string2, string);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public String getNodeManagerHome() {
        return this._NodeManagerHome;
    }

    public boolean isNodeManagerHomeSet() {
        return this._isSet(12);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setAdapter(String string) {
        string = string == null ? null : string.trim();
        VMMAdapterValidator.validateAdapter(string);
        String string2 = this.getAdapter();
        this._customizer.setAdapter(string);
        this._postSet(13, string2, string);
    }

    public String getAdapter() {
        return this._customizer.getAdapter();
    }

    public boolean isAdapterSet() {
        return this._isSet(13);
    }

    public void setAdapterName(String string) {
        string = string == null ? null : string.trim();
        VMMAdapterValidator.validateAdapterName(string);
        String string2 = this._AdapterName;
        this._AdapterName = string;
        this._postSet(14, string2, string);
    }

    public String getAdapterName() {
        return this._AdapterName;
    }

    public boolean isAdapterNameSet() {
        return this._isSet(14);
    }

    public void setAdapterVersion(String string) {
        string = string == null ? null : string.trim();
        VMMAdapterValidator.validateAdapterVersion(string);
        String string2 = this._AdapterVersion;
        this._AdapterVersion = string;
        this._postSet(15, string2, string);
    }

    public String getAdapterVersion() {
        return this._AdapterVersion;
    }

    public boolean isAdapterVersionSet() {
        return this._isSet(15);
    }

    public void setUserName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._UserName;
        this._UserName = string;
        this._postSet(16, string2, string);
    }

    public String getUserName() {
        return this._UserName;
    }

    public boolean isUserNameSet() {
        return this._isSet(16);
    }

    public void setPassword(String string) {
        string = string == null ? null : string.trim();
        this.setPasswordEncrypted(string == null ? null : this._encrypt("Password", string));
    }

    public String getPassword() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : this._decrypt("Password", byArray);
    }

    public boolean isPasswordSet() {
        return this.isPasswordEncryptedSet();
    }

    public byte[] getPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._PasswordEncrypted);
    }

    public String getPasswordEncryptedAsString() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isPasswordEncryptedSet() {
        return this._isSet(18);
    }

    public void setPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String[] getInstalledVMMAdapters() {
        return this._customizer.getInstalledVMMAdapters();
    }

    public boolean isInstalledVMMAdaptersSet() {
        return this._isSet(19);
    }

    public void setInstalledVMMAdapters(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._InstalledVMMAdapters;
        this._InstalledVMMAdapters = stringArray;
        this._postSet(19, stringArray2, stringArray);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._PasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: PasswordEncrypted of NodeManagerMBean");
        }
        this._getHelper()._clearArray(this._PasswordEncrypted);
        this._PasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(18, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 17) {
                this._markSet(18, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 13;
        }
        try {
            switch (n) {
                case 13: {
                    this._customizer.setAdapter(null);
                    if (bl) break;
                }
                case 14: {
                    this._AdapterName = null;
                    if (bl) break;
                }
                case 15: {
                    this._AdapterVersion = null;
                    if (bl) break;
                }
                case 19: {
                    this._InstalledVMMAdapters = new String[0];
                    if (bl) break;
                }
                case 8: {
                    this._ListenAddress = "localhost";
                    if (bl) break;
                }
                case 9: {
                    this._ListenPort = 5556;
                    if (bl) break;
                }
                case 7: {
                    this._NMType = "SSL";
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 12: {
                    this._NodeManagerHome = null;
                    if (bl) break;
                }
                case 17: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 18: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 11: {
                    this._ShellCommand = null;
                    if (bl) break;
                }
                case 16: {
                    this._UserName = null;
                    if (bl) break;
                }
                case 10: {
                    this._DebugEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "NodeManager";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Adapter")) {
            String string2 = this._Adapter;
            this._Adapter = (String)object;
            this._postSet(13, string2, this._Adapter);
            return;
        }
        if (string.equals("AdapterName")) {
            String string3 = this._AdapterName;
            this._AdapterName = (String)object;
            this._postSet(14, string3, this._AdapterName);
            return;
        }
        if (string.equals("AdapterVersion")) {
            String string4 = this._AdapterVersion;
            this._AdapterVersion = (String)object;
            this._postSet(15, string4, this._AdapterVersion);
            return;
        }
        if (string.equals("DebugEnabled")) {
            boolean bl = this._DebugEnabled;
            this._DebugEnabled = (Boolean)object;
            this._postSet(10, bl, this._DebugEnabled);
            return;
        }
        if (string.equals("InstalledVMMAdapters")) {
            String[] stringArray = this._InstalledVMMAdapters;
            this._InstalledVMMAdapters = (String[])object;
            this._postSet(19, stringArray, this._InstalledVMMAdapters);
            return;
        }
        if (string.equals("ListenAddress")) {
            String string5 = this._ListenAddress;
            this._ListenAddress = (String)object;
            this._postSet(8, string5, this._ListenAddress);
            return;
        }
        if (string.equals("ListenPort")) {
            int n = this._ListenPort;
            this._ListenPort = (Integer)object;
            this._postSet(9, n, this._ListenPort);
            return;
        }
        if (string.equals("NMType")) {
            String string6 = this._NMType;
            this._NMType = (String)object;
            this._postSet(7, string6, this._NMType);
            return;
        }
        if (string.equals("Name")) {
            String string7 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string7, this._Name);
            return;
        }
        if (string.equals("NodeManagerHome")) {
            String string8 = this._NodeManagerHome;
            this._NodeManagerHome = (String)object;
            this._postSet(12, string8, this._NodeManagerHome);
            return;
        }
        if (string.equals("Password")) {
            String string9 = this._Password;
            this._Password = (String)object;
            this._postSet(17, string9, this._Password);
            return;
        }
        if (string.equals("PasswordEncrypted")) {
            byte[] byArray = this._PasswordEncrypted;
            this._PasswordEncrypted = (byte[])object;
            this._postSet(18, byArray, this._PasswordEncrypted);
            return;
        }
        if (string.equals("ShellCommand")) {
            String string10 = this._ShellCommand;
            this._ShellCommand = (String)object;
            this._postSet(11, string10, this._ShellCommand);
            return;
        }
        if (string.equals("UserName")) {
            String string11 = this._UserName;
            this._UserName = (String)object;
            this._postSet(16, string11, this._UserName);
            return;
        }
        if (string.equals("customizer")) {
            NodeManager nodeManager = this._customizer;
            this._customizer = (NodeManager)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Adapter")) {
            return this._Adapter;
        }
        if (string.equals("AdapterName")) {
            return this._AdapterName;
        }
        if (string.equals("AdapterVersion")) {
            return this._AdapterVersion;
        }
        if (string.equals("DebugEnabled")) {
            return new Boolean(this._DebugEnabled);
        }
        if (string.equals("InstalledVMMAdapters")) {
            return this._InstalledVMMAdapters;
        }
        if (string.equals("ListenAddress")) {
            return this._ListenAddress;
        }
        if (string.equals("ListenPort")) {
            return new Integer(this._ListenPort);
        }
        if (string.equals("NMType")) {
            return this._NMType;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NodeManagerHome")) {
            return this._NodeManagerHome;
        }
        if (string.equals("Password")) {
            return this._Password;
        }
        if (string.equals("PasswordEncrypted")) {
            return this._PasswordEncrypted;
        }
        if (string.equals("ShellCommand")) {
            return this._ShellCommand;
        }
        if (string.equals("UserName")) {
            return this._UserName;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 7: {
                    if (string.equals("adapter")) {
                        return 13;
                    }
                    if (!string.equals("nm-type")) break;
                    return 7;
                }
                case 12: {
                    if (!string.equals("adapter-name")) break;
                    return 14;
                }
                case 15: {
                    if (!string.equals("adapter-version")) break;
                    return 15;
                }
                case 20: {
                    if (!string.equals("installedvmm-adapter")) break;
                    return 19;
                }
                case 14: {
                    if (!string.equals("listen-address")) break;
                    return 8;
                }
                case 11: {
                    if (!string.equals("listen-port")) break;
                    return 9;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 17: {
                    if (!string.equals("node-manager-home")) break;
                    return 12;
                }
                case 8: {
                    if (!string.equals("password")) break;
                    return 17;
                }
                case 18: {
                    if (!string.equals("password-encrypted")) break;
                    return 18;
                }
                case 13: {
                    if (string.equals("shell-command")) {
                        return 11;
                    }
                    if (!string.equals("debug-enabled")) break;
                    return 10;
                }
                case 9: {
                    if (!string.equals("user-name")) break;
                    return 16;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 13: {
                    return "adapter";
                }
                case 14: {
                    return "adapter-name";
                }
                case 15: {
                    return "adapter-version";
                }
                case 19: {
                    return "installedvmm-adapter";
                }
                case 8: {
                    return "listen-address";
                }
                case 9: {
                    return "listen-port";
                }
                case 7: {
                    return "nm-type";
                }
                case 2: {
                    return "name";
                }
                case 12: {
                    return "node-manager-home";
                }
                case 17: {
                    return "password";
                }
                case 18: {
                    return "password-encrypted";
                }
                case 11: {
                    return "shell-command";
                }
                case 16: {
                    return "user-name";
                }
                case 10: {
                    return "debug-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 19: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private NodeManagerMBeanImpl bean;

        protected Helper(NodeManagerMBeanImpl nodeManagerMBeanImpl) {
            super(nodeManagerMBeanImpl);
            this.bean = nodeManagerMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 13: {
                    return "Adapter";
                }
                case 14: {
                    return "AdapterName";
                }
                case 15: {
                    return "AdapterVersion";
                }
                case 19: {
                    return "InstalledVMMAdapters";
                }
                case 8: {
                    return "ListenAddress";
                }
                case 9: {
                    return "ListenPort";
                }
                case 7: {
                    return "NMType";
                }
                case 2: {
                    return "Name";
                }
                case 12: {
                    return "NodeManagerHome";
                }
                case 17: {
                    return "Password";
                }
                case 18: {
                    return "PasswordEncrypted";
                }
                case 11: {
                    return "ShellCommand";
                }
                case 16: {
                    return "UserName";
                }
                case 10: {
                    return "DebugEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Adapter")) {
                return 13;
            }
            if (string.equals("AdapterName")) {
                return 14;
            }
            if (string.equals("AdapterVersion")) {
                return 15;
            }
            if (string.equals("InstalledVMMAdapters")) {
                return 19;
            }
            if (string.equals("ListenAddress")) {
                return 8;
            }
            if (string.equals("ListenPort")) {
                return 9;
            }
            if (string.equals("NMType")) {
                return 7;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("NodeManagerHome")) {
                return 12;
            }
            if (string.equals("Password")) {
                return 17;
            }
            if (string.equals("PasswordEncrypted")) {
                return 18;
            }
            if (string.equals("ShellCommand")) {
                return 11;
            }
            if (string.equals("UserName")) {
                return 16;
            }
            if (string.equals("DebugEnabled")) {
                return 10;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAdapterSet()) {
                    stringBuffer.append("Adapter");
                    stringBuffer.append(String.valueOf(this.bean.getAdapter()));
                }
                if (this.bean.isAdapterNameSet()) {
                    stringBuffer.append("AdapterName");
                    stringBuffer.append(String.valueOf(this.bean.getAdapterName()));
                }
                if (this.bean.isAdapterVersionSet()) {
                    stringBuffer.append("AdapterVersion");
                    stringBuffer.append(String.valueOf(this.bean.getAdapterVersion()));
                }
                if (this.bean.isInstalledVMMAdaptersSet()) {
                    stringBuffer.append("InstalledVMMAdapters");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getInstalledVMMAdapters())));
                }
                if (this.bean.isListenAddressSet()) {
                    stringBuffer.append("ListenAddress");
                    stringBuffer.append(String.valueOf(this.bean.getListenAddress()));
                }
                if (this.bean.isListenPortSet()) {
                    stringBuffer.append("ListenPort");
                    stringBuffer.append(String.valueOf(this.bean.getListenPort()));
                }
                if (this.bean.isNMTypeSet()) {
                    stringBuffer.append("NMType");
                    stringBuffer.append(String.valueOf(this.bean.getNMType()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNodeManagerHomeSet()) {
                    stringBuffer.append("NodeManagerHome");
                    stringBuffer.append(String.valueOf(this.bean.getNodeManagerHome()));
                }
                if (this.bean.isPasswordSet()) {
                    stringBuffer.append("Password");
                    stringBuffer.append(String.valueOf(this.bean.getPassword()));
                }
                if (this.bean.isPasswordEncryptedSet()) {
                    stringBuffer.append("PasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getPasswordEncrypted())));
                }
                if (this.bean.isShellCommandSet()) {
                    stringBuffer.append("ShellCommand");
                    stringBuffer.append(String.valueOf(this.bean.getShellCommand()));
                }
                if (this.bean.isUserNameSet()) {
                    stringBuffer.append("UserName");
                    stringBuffer.append(String.valueOf(this.bean.getUserName()));
                }
                if (this.bean.isDebugEnabledSet()) {
                    stringBuffer.append("DebugEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDebugEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                NodeManagerMBeanImpl nodeManagerMBeanImpl = (NodeManagerMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Adapter", this.bean.getAdapter(), nodeManagerMBeanImpl.getAdapter(), false);
                this.computeDiff("AdapterName", this.bean.getAdapterName(), nodeManagerMBeanImpl.getAdapterName(), false);
                this.computeDiff("AdapterVersion", this.bean.getAdapterVersion(), nodeManagerMBeanImpl.getAdapterVersion(), false);
                this.computeDiff("InstalledVMMAdapters", this.bean.getInstalledVMMAdapters(), nodeManagerMBeanImpl.getInstalledVMMAdapters(), false);
                this.computeDiff("ListenAddress", this.bean.getListenAddress(), nodeManagerMBeanImpl.getListenAddress(), true);
                this.computeDiff("ListenPort", this.bean.getListenPort(), nodeManagerMBeanImpl.getListenPort(), true);
                this.computeDiff("NMType", this.bean.getNMType(), nodeManagerMBeanImpl.getNMType(), false);
                this.computeDiff("Name", this.bean.getName(), nodeManagerMBeanImpl.getName(), false);
                this.computeDiff("NodeManagerHome", this.bean.getNodeManagerHome(), nodeManagerMBeanImpl.getNodeManagerHome(), false);
                this.computeDiff("PasswordEncrypted", this.bean.getPasswordEncrypted(), nodeManagerMBeanImpl.getPasswordEncrypted(), false);
                this.computeDiff("ShellCommand", this.bean.getShellCommand(), nodeManagerMBeanImpl.getShellCommand(), false);
                this.computeDiff("UserName", this.bean.getUserName(), nodeManagerMBeanImpl.getUserName(), true);
                this.computeDiff("DebugEnabled", this.bean.isDebugEnabled(), nodeManagerMBeanImpl.isDebugEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                NodeManagerMBeanImpl nodeManagerMBeanImpl = (NodeManagerMBeanImpl)beanUpdateEvent.getSourceBean();
                NodeManagerMBeanImpl nodeManagerMBeanImpl2 = (NodeManagerMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("Adapter")) {
                    nodeManagerMBeanImpl.setAdapter(nodeManagerMBeanImpl2.getAdapter());
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("AdapterName")) {
                    nodeManagerMBeanImpl.setAdapterName(nodeManagerMBeanImpl2.getAdapterName());
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("AdapterVersion")) {
                    nodeManagerMBeanImpl.setAdapterVersion(nodeManagerMBeanImpl2.getAdapterVersion());
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("InstalledVMMAdapters")) {
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("ListenAddress")) {
                    nodeManagerMBeanImpl.setListenAddress(nodeManagerMBeanImpl2.getListenAddress());
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("ListenPort")) {
                    nodeManagerMBeanImpl.setListenPort(nodeManagerMBeanImpl2.getListenPort());
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("NMType")) {
                    nodeManagerMBeanImpl.setNMType(nodeManagerMBeanImpl2.getNMType());
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("Name")) {
                    nodeManagerMBeanImpl.setName(nodeManagerMBeanImpl2.getName());
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("NodeManagerHome")) {
                    nodeManagerMBeanImpl.setNodeManagerHome(nodeManagerMBeanImpl2.getNodeManagerHome());
                    nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (!string.equals("Password")) {
                    if (string.equals("PasswordEncrypted")) {
                        nodeManagerMBeanImpl.setPasswordEncrypted(nodeManagerMBeanImpl2.getPasswordEncrypted());
                        nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("ShellCommand")) {
                        nodeManagerMBeanImpl.setShellCommand(nodeManagerMBeanImpl2.getShellCommand());
                        nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("UserName")) {
                        nodeManagerMBeanImpl.setUserName(nodeManagerMBeanImpl2.getUserName());
                        nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("DebugEnabled")) {
                        nodeManagerMBeanImpl.setDebugEnabled(nodeManagerMBeanImpl2.isDebugEnabled());
                        nodeManagerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                Object[] objectArray;
                NodeManagerMBeanImpl nodeManagerMBeanImpl = (NodeManagerMBeanImpl)abstractDescriptorBean;
                super.finishCopy(nodeManagerMBeanImpl, bl, list);
                if ((list == null || !list.contains("Adapter")) && this.bean.isAdapterSet()) {
                    nodeManagerMBeanImpl.setAdapter(this.bean.getAdapter());
                }
                if ((list == null || !list.contains("AdapterName")) && this.bean.isAdapterNameSet()) {
                    nodeManagerMBeanImpl.setAdapterName(this.bean.getAdapterName());
                }
                if ((list == null || !list.contains("AdapterVersion")) && this.bean.isAdapterVersionSet()) {
                    nodeManagerMBeanImpl.setAdapterVersion(this.bean.getAdapterVersion());
                }
                if ((list == null || !list.contains("InstalledVMMAdapters")) && this.bean.isInstalledVMMAdaptersSet()) {
                    objectArray = this.bean.getInstalledVMMAdapters();
                    nodeManagerMBeanImpl.setInstalledVMMAdapters(objectArray == null ? null : (String[])objectArray.clone());
                }
                if ((list == null || !list.contains("ListenAddress")) && this.bean.isListenAddressSet()) {
                    nodeManagerMBeanImpl.setListenAddress(this.bean.getListenAddress());
                }
                if ((list == null || !list.contains("ListenPort")) && this.bean.isListenPortSet()) {
                    nodeManagerMBeanImpl.setListenPort(this.bean.getListenPort());
                }
                if ((list == null || !list.contains("NMType")) && this.bean.isNMTypeSet()) {
                    nodeManagerMBeanImpl.setNMType(this.bean.getNMType());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    nodeManagerMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("NodeManagerHome")) && this.bean.isNodeManagerHomeSet()) {
                    nodeManagerMBeanImpl.setNodeManagerHome(this.bean.getNodeManagerHome());
                }
                if ((list == null || !list.contains("PasswordEncrypted")) && this.bean.isPasswordEncryptedSet()) {
                    objectArray = this.bean.getPasswordEncrypted();
                    nodeManagerMBeanImpl.setPasswordEncrypted(objectArray == null ? null : (byte[])((byte[])objectArray).clone());
                }
                if ((list == null || !list.contains("ShellCommand")) && this.bean.isShellCommandSet()) {
                    nodeManagerMBeanImpl.setShellCommand(this.bean.getShellCommand());
                }
                if ((list == null || !list.contains("UserName")) && this.bean.isUserNameSet()) {
                    nodeManagerMBeanImpl.setUserName(this.bean.getUserName());
                }
                if ((list == null || !list.contains("DebugEnabled")) && this.bean.isDebugEnabledSet()) {
                    nodeManagerMBeanImpl.setDebugEnabled(this.bean.isDebugEnabled());
                }
                return nodeManagerMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

