/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.OverloadProtectionMBean;
import weblogic.management.configuration.ServerFailureTriggerMBean;
import weblogic.management.configuration.ServerFailureTriggerMBeanImpl;
import weblogic.management.configuration.ServerMBean;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class OverloadProtectionMBeanImpl
extends ConfigurationMBeanImpl
implements OverloadProtectionMBean,
Serializable {
    private String _FailureAction;
    private int _FreeMemoryPercentHighThreshold;
    private int _FreeMemoryPercentLowThreshold;
    private String _PanicAction;
    private ServerFailureTriggerMBean _ServerFailureTrigger;
    private int _SharedCapacityForWorkManagers;
    private static SchemaHelper2 _schemaHelper;

    public OverloadProtectionMBeanImpl() {
        this._initializeProperty(-1);
    }

    public OverloadProtectionMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public void setSharedCapacityForWorkManagers(int n) {
        LegalChecks.checkInRange((String)"SharedCapacityForWorkManagers", (long)n, (long)1L, (long)0x40000000L);
        int n2 = this._SharedCapacityForWorkManagers;
        this._SharedCapacityForWorkManagers = n;
        this._postSet(7, n2, n);
    }

    public int getSharedCapacityForWorkManagers() {
        if (!this._isSet(7)) {
            try {
                return this.getParent() instanceof ServerMBean ? ((ServerMBean)this.getParent()).getCluster().getOverloadProtection().getSharedCapacityForWorkManagers() : 65536;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._SharedCapacityForWorkManagers;
    }

    public boolean isSharedCapacityForWorkManagersSet() {
        return this._isSet(7);
    }

    public void setPanicAction(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"no-action", "system-exit"};
        string = LegalChecks.checkInEnum((String)"PanicAction", (String)string, (String[])stringArray);
        String string2 = this._PanicAction;
        this._PanicAction = string;
        this._postSet(8, string2, string);
    }

    public String getPanicAction() {
        if (!this._isSet(8)) {
            try {
                return this.getParent() instanceof ServerMBean ? ((ServerMBean)this.getParent()).getCluster().getOverloadProtection().getPanicAction() : "no-action";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._PanicAction;
    }

    public boolean isPanicActionSet() {
        return this._isSet(8);
    }

    public void setFailureAction(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"no-action", "force-shutdown", "admin-state"};
        string = LegalChecks.checkInEnum((String)"FailureAction", (String)string, (String[])stringArray);
        String string2 = this._FailureAction;
        this._FailureAction = string;
        this._postSet(9, string2, string);
    }

    public String getFailureAction() {
        if (!this._isSet(9)) {
            try {
                return this.getParent() instanceof ServerMBean ? ((ServerMBean)this.getParent()).getCluster().getOverloadProtection().getFailureAction() : "no-action";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._FailureAction;
    }

    public boolean isFailureActionSet() {
        return this._isSet(9);
    }

    public void setFreeMemoryPercentHighThreshold(int n) {
        LegalChecks.checkInRange((String)"FreeMemoryPercentHighThreshold", (long)n, (long)0L, (long)99L);
        int n2 = this._FreeMemoryPercentHighThreshold;
        this._FreeMemoryPercentHighThreshold = n;
        this._postSet(10, n2, n);
    }

    public int getFreeMemoryPercentHighThreshold() {
        if (!this._isSet(10)) {
            try {
                return this.getParent() instanceof ServerMBean ? ((ServerMBean)this.getParent()).getCluster().getOverloadProtection().getFreeMemoryPercentHighThreshold() : 0;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._FreeMemoryPercentHighThreshold;
    }

    public boolean isFreeMemoryPercentHighThresholdSet() {
        return this._isSet(10);
    }

    public void setFreeMemoryPercentLowThreshold(int n) {
        LegalChecks.checkInRange((String)"FreeMemoryPercentLowThreshold", (long)n, (long)0L, (long)99L);
        int n2 = this._FreeMemoryPercentLowThreshold;
        this._FreeMemoryPercentLowThreshold = n;
        this._postSet(11, n2, n);
    }

    public int getFreeMemoryPercentLowThreshold() {
        if (!this._isSet(11)) {
            try {
                return this.getParent() instanceof ServerMBean ? ((ServerMBean)this.getParent()).getCluster().getOverloadProtection().getFreeMemoryPercentLowThreshold() : 0;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._FreeMemoryPercentLowThreshold;
    }

    public boolean isFreeMemoryPercentLowThresholdSet() {
        return this._isSet(11);
    }

    public ServerFailureTriggerMBean getServerFailureTrigger() {
        if (!this._isSet(12)) {
            try {
                return this.getParent() instanceof ServerMBean ? ((ServerMBean)this.getParent()).getCluster().getOverloadProtection().getServerFailureTrigger() : null;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._ServerFailureTrigger;
    }

    public boolean isServerFailureTriggerSet() {
        return this._isSet(12);
    }

    public void setServerFailureTrigger(ServerFailureTriggerMBean serverFailureTriggerMBean) throws InvalidAttributeValueException {
        Object object;
        if (serverFailureTriggerMBean != null && this.getServerFailureTrigger() != null && serverFailureTriggerMBean != this.getServerFailureTrigger()) {
            throw new BeanAlreadyExistsException(this.getServerFailureTrigger() + " has already been created");
        }
        if (serverFailureTriggerMBean != null && this._setParent((DescriptorBean)(object = (AbstractDescriptorBean)serverFailureTriggerMBean), this, 12)) {
            this._getReferenceManager().registerBean(object, false);
            this._postCreate((AbstractDescriptorBean)object);
        }
        object = this._ServerFailureTrigger;
        this._ServerFailureTrigger = serverFailureTriggerMBean;
        this._postSet(12, object, serverFailureTriggerMBean);
    }

    public ServerFailureTriggerMBean createServerFailureTrigger() {
        ServerFailureTriggerMBeanImpl serverFailureTriggerMBeanImpl = new ServerFailureTriggerMBeanImpl(this, -1);
        try {
            this.setServerFailureTrigger(serverFailureTriggerMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return serverFailureTriggerMBeanImpl;
    }

    public void destroyServerFailureTrigger() {
        try {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this._ServerFailureTrigger;
            if (abstractDescriptorBean == null) {
                return;
            }
            List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
            if (list != null && list.size() > 0) {
                throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
            }
            this._getReferenceManager().unregisterBean(abstractDescriptorBean);
            this._markDestroyed(abstractDescriptorBean);
            this.setServerFailureTrigger(null);
            this._unSet(12);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 9;
        }
        try {
            switch (n) {
                case 9: {
                    this._FailureAction = "no-action";
                    if (bl) break;
                }
                case 10: {
                    this._FreeMemoryPercentHighThreshold = 0;
                    if (bl) break;
                }
                case 11: {
                    this._FreeMemoryPercentLowThreshold = 0;
                    if (bl) break;
                }
                case 8: {
                    this._PanicAction = "no-action";
                    if (bl) break;
                }
                case 12: {
                    this._ServerFailureTrigger = null;
                    if (bl) break;
                }
                case 7: {
                    this._SharedCapacityForWorkManagers = 65536;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "OverloadProtection";
    }

    public void putValue(String string, Object object) {
        if (string.equals("FailureAction")) {
            String string2 = this._FailureAction;
            this._FailureAction = (String)object;
            this._postSet(9, string2, this._FailureAction);
            return;
        }
        if (string.equals("FreeMemoryPercentHighThreshold")) {
            int n = this._FreeMemoryPercentHighThreshold;
            this._FreeMemoryPercentHighThreshold = (Integer)object;
            this._postSet(10, n, this._FreeMemoryPercentHighThreshold);
            return;
        }
        if (string.equals("FreeMemoryPercentLowThreshold")) {
            int n = this._FreeMemoryPercentLowThreshold;
            this._FreeMemoryPercentLowThreshold = (Integer)object;
            this._postSet(11, n, this._FreeMemoryPercentLowThreshold);
            return;
        }
        if (string.equals("PanicAction")) {
            String string3 = this._PanicAction;
            this._PanicAction = (String)object;
            this._postSet(8, string3, this._PanicAction);
            return;
        }
        if (string.equals("ServerFailureTrigger")) {
            ServerFailureTriggerMBean serverFailureTriggerMBean = this._ServerFailureTrigger;
            this._ServerFailureTrigger = (ServerFailureTriggerMBean)object;
            this._postSet(12, serverFailureTriggerMBean, this._ServerFailureTrigger);
            return;
        }
        if (string.equals("SharedCapacityForWorkManagers")) {
            int n = this._SharedCapacityForWorkManagers;
            this._SharedCapacityForWorkManagers = (Integer)object;
            this._postSet(7, n, this._SharedCapacityForWorkManagers);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("FailureAction")) {
            return this._FailureAction;
        }
        if (string.equals("FreeMemoryPercentHighThreshold")) {
            return new Integer(this._FreeMemoryPercentHighThreshold);
        }
        if (string.equals("FreeMemoryPercentLowThreshold")) {
            return new Integer(this._FreeMemoryPercentLowThreshold);
        }
        if (string.equals("PanicAction")) {
            return this._PanicAction;
        }
        if (string.equals("ServerFailureTrigger")) {
            return this._ServerFailureTrigger;
        }
        if (string.equals("SharedCapacityForWorkManagers")) {
            return new Integer(this._SharedCapacityForWorkManagers);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 14: {
                    if (!string.equals("failure-action")) break;
                    return 9;
                }
                case 34: {
                    if (!string.equals("free-memory-percent-high-threshold")) break;
                    return 10;
                }
                case 33: {
                    if (string.equals("free-memory-percent-low-threshold")) {
                        return 11;
                    }
                    if (!string.equals("shared-capacity-for-work-managers")) break;
                    return 7;
                }
                case 12: {
                    if (!string.equals("panic-action")) break;
                    return 8;
                }
                case 22: {
                    if (!string.equals("server-failure-trigger")) break;
                    return 12;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 12: {
                    return new ServerFailureTriggerMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 9: {
                    return "failure-action";
                }
                case 10: {
                    return "free-memory-percent-high-threshold";
                }
                case 11: {
                    return "free-memory-percent-low-threshold";
                }
                case 8: {
                    return "panic-action";
                }
                case 12: {
                    return "server-failure-trigger";
                }
                case 7: {
                    return "shared-capacity-for-work-managers";
                }
            }
            return super.getElementName(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 12: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private OverloadProtectionMBeanImpl bean;

        protected Helper(OverloadProtectionMBeanImpl overloadProtectionMBeanImpl) {
            super(overloadProtectionMBeanImpl);
            this.bean = overloadProtectionMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 9: {
                    return "FailureAction";
                }
                case 10: {
                    return "FreeMemoryPercentHighThreshold";
                }
                case 11: {
                    return "FreeMemoryPercentLowThreshold";
                }
                case 8: {
                    return "PanicAction";
                }
                case 12: {
                    return "ServerFailureTrigger";
                }
                case 7: {
                    return "SharedCapacityForWorkManagers";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("FailureAction")) {
                return 9;
            }
            if (string.equals("FreeMemoryPercentHighThreshold")) {
                return 10;
            }
            if (string.equals("FreeMemoryPercentLowThreshold")) {
                return 11;
            }
            if (string.equals("PanicAction")) {
                return 8;
            }
            if (string.equals("ServerFailureTrigger")) {
                return 12;
            }
            if (string.equals("SharedCapacityForWorkManagers")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getServerFailureTrigger() != null) {
                arrayList.add(new ArrayIterator((Object[])new ServerFailureTriggerMBean[]{this.bean.getServerFailureTrigger()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isFailureActionSet()) {
                    stringBuffer.append("FailureAction");
                    stringBuffer.append(String.valueOf(this.bean.getFailureAction()));
                }
                if (this.bean.isFreeMemoryPercentHighThresholdSet()) {
                    stringBuffer.append("FreeMemoryPercentHighThreshold");
                    stringBuffer.append(String.valueOf(this.bean.getFreeMemoryPercentHighThreshold()));
                }
                if (this.bean.isFreeMemoryPercentLowThresholdSet()) {
                    stringBuffer.append("FreeMemoryPercentLowThreshold");
                    stringBuffer.append(String.valueOf(this.bean.getFreeMemoryPercentLowThreshold()));
                }
                if (this.bean.isPanicActionSet()) {
                    stringBuffer.append("PanicAction");
                    stringBuffer.append(String.valueOf(this.bean.getPanicAction()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getServerFailureTrigger())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isSharedCapacityForWorkManagersSet()) {
                    stringBuffer.append("SharedCapacityForWorkManagers");
                    stringBuffer.append(String.valueOf(this.bean.getSharedCapacityForWorkManagers()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                OverloadProtectionMBeanImpl overloadProtectionMBeanImpl = (OverloadProtectionMBeanImpl)abstractDescriptorBean;
                this.computeDiff("FailureAction", this.bean.getFailureAction(), overloadProtectionMBeanImpl.getFailureAction(), true);
                this.computeDiff("FreeMemoryPercentHighThreshold", this.bean.getFreeMemoryPercentHighThreshold(), overloadProtectionMBeanImpl.getFreeMemoryPercentHighThreshold(), false);
                this.computeDiff("FreeMemoryPercentLowThreshold", this.bean.getFreeMemoryPercentLowThreshold(), overloadProtectionMBeanImpl.getFreeMemoryPercentLowThreshold(), false);
                this.computeDiff("PanicAction", this.bean.getPanicAction(), overloadProtectionMBeanImpl.getPanicAction(), false);
                this.computeChildDiff("ServerFailureTrigger", this.bean.getServerFailureTrigger(), overloadProtectionMBeanImpl.getServerFailureTrigger(), false);
                this.computeDiff("SharedCapacityForWorkManagers", this.bean.getSharedCapacityForWorkManagers(), overloadProtectionMBeanImpl.getSharedCapacityForWorkManagers(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                OverloadProtectionMBeanImpl overloadProtectionMBeanImpl = (OverloadProtectionMBeanImpl)beanUpdateEvent.getSourceBean();
                OverloadProtectionMBeanImpl overloadProtectionMBeanImpl2 = (OverloadProtectionMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("FailureAction")) {
                    overloadProtectionMBeanImpl.setFailureAction(overloadProtectionMBeanImpl2.getFailureAction());
                    overloadProtectionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("FreeMemoryPercentHighThreshold")) {
                    overloadProtectionMBeanImpl.setFreeMemoryPercentHighThreshold(overloadProtectionMBeanImpl2.getFreeMemoryPercentHighThreshold());
                    overloadProtectionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("FreeMemoryPercentLowThreshold")) {
                    overloadProtectionMBeanImpl.setFreeMemoryPercentLowThreshold(overloadProtectionMBeanImpl2.getFreeMemoryPercentLowThreshold());
                    overloadProtectionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("PanicAction")) {
                    overloadProtectionMBeanImpl.setPanicAction(overloadProtectionMBeanImpl2.getPanicAction());
                    overloadProtectionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("ServerFailureTrigger")) {
                    if (n == 2) {
                        overloadProtectionMBeanImpl.setServerFailureTrigger((ServerFailureTriggerMBean)this.createCopy((AbstractDescriptorBean)overloadProtectionMBeanImpl2.getServerFailureTrigger()));
                    } else if (n == 3) {
                        overloadProtectionMBeanImpl._destroySingleton("ServerFailureTrigger", overloadProtectionMBeanImpl.getServerFailureTrigger());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    overloadProtectionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("SharedCapacityForWorkManagers")) {
                    overloadProtectionMBeanImpl.setSharedCapacityForWorkManagers(overloadProtectionMBeanImpl2.getSharedCapacityForWorkManagers());
                    overloadProtectionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                OverloadProtectionMBeanImpl overloadProtectionMBeanImpl = (OverloadProtectionMBeanImpl)abstractDescriptorBean;
                super.finishCopy(overloadProtectionMBeanImpl, bl, list);
                if ((list == null || !list.contains("FailureAction")) && this.bean.isFailureActionSet()) {
                    overloadProtectionMBeanImpl.setFailureAction(this.bean.getFailureAction());
                }
                if ((list == null || !list.contains("FreeMemoryPercentHighThreshold")) && this.bean.isFreeMemoryPercentHighThresholdSet()) {
                    overloadProtectionMBeanImpl.setFreeMemoryPercentHighThreshold(this.bean.getFreeMemoryPercentHighThreshold());
                }
                if ((list == null || !list.contains("FreeMemoryPercentLowThreshold")) && this.bean.isFreeMemoryPercentLowThresholdSet()) {
                    overloadProtectionMBeanImpl.setFreeMemoryPercentLowThreshold(this.bean.getFreeMemoryPercentLowThreshold());
                }
                if ((list == null || !list.contains("PanicAction")) && this.bean.isPanicActionSet()) {
                    overloadProtectionMBeanImpl.setPanicAction(this.bean.getPanicAction());
                }
                if (!(list != null && list.contains("ServerFailureTrigger") || !this.bean.isServerFailureTriggerSet() || overloadProtectionMBeanImpl._isSet(12))) {
                    ServerFailureTriggerMBean serverFailureTriggerMBean = this.bean.getServerFailureTrigger();
                    overloadProtectionMBeanImpl.setServerFailureTrigger(null);
                    overloadProtectionMBeanImpl.setServerFailureTrigger(serverFailureTriggerMBean == null ? null : (ServerFailureTriggerMBean)this.createCopy((AbstractDescriptorBean)serverFailureTriggerMBean, bl));
                }
                if ((list == null || !list.contains("SharedCapacityForWorkManagers")) && this.bean.isSharedCapacityForWorkManagersSet()) {
                    overloadProtectionMBeanImpl.setSharedCapacityForWorkManagers(this.bean.getSharedCapacityForWorkManagers());
                }
                return overloadProtectionMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getServerFailureTrigger(), clazz, object);
        }
    }
}

