/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.PasswordPolicyMBean;
import weblogic.utils.collections.CombinedIterator;

public class PasswordPolicyMBeanImpl
extends ConfigurationMBeanImpl
implements PasswordPolicyMBean,
Serializable {
    private int _LockoutCacheSize;
    private int _LockoutDuration;
    private boolean _LockoutEnabled;
    private int _LockoutGCThreshold;
    private int _LockoutResetDuration;
    private int _LockoutThreshold;
    private int _MinimumPasswordLength;
    private static SchemaHelper2 _schemaHelper;

    public PasswordPolicyMBeanImpl() {
        this._initializeProperty(-1);
    }

    public PasswordPolicyMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public int getMinimumPasswordLength() {
        return this._MinimumPasswordLength;
    }

    public boolean isMinimumPasswordLengthSet() {
        return this._isSet(7);
    }

    public void setMinimumPasswordLength(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"MinimumPasswordLength", (int)n, (int)0);
        int n2 = this._MinimumPasswordLength;
        this._MinimumPasswordLength = n;
        this._postSet(7, n2, n);
    }

    public boolean isLockoutEnabled() {
        return this._LockoutEnabled;
    }

    public boolean isLockoutEnabledSet() {
        return this._isSet(8);
    }

    public void setLockoutEnabled(boolean bl) {
        boolean bl2 = this._LockoutEnabled;
        this._LockoutEnabled = bl;
        this._postSet(8, bl2, bl);
    }

    public int getLockoutThreshold() {
        return this._LockoutThreshold;
    }

    public boolean isLockoutThresholdSet() {
        return this._isSet(9);
    }

    public void setLockoutThreshold(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LockoutThreshold", (long)n, (long)1L, (long)99999L);
        int n2 = this._LockoutThreshold;
        this._LockoutThreshold = n;
        this._postSet(9, n2, n);
    }

    public int getLockoutDuration() {
        return this._LockoutDuration;
    }

    public boolean isLockoutDurationSet() {
        return this._isSet(10);
    }

    public void setLockoutDuration(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LockoutDuration", (long)n, (long)0L, (long)999999L);
        int n2 = this._LockoutDuration;
        this._LockoutDuration = n;
        this._postSet(10, n2, n);
    }

    public int getLockoutResetDuration() {
        return this._LockoutResetDuration;
    }

    public boolean isLockoutResetDurationSet() {
        return this._isSet(11);
    }

    public void setLockoutResetDuration(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LockoutResetDuration", (long)n, (long)1L, (long)99999L);
        int n2 = this._LockoutResetDuration;
        this._LockoutResetDuration = n;
        this._postSet(11, n2, n);
    }

    public int getLockoutCacheSize() {
        return this._LockoutCacheSize;
    }

    public boolean isLockoutCacheSizeSet() {
        return this._isSet(12);
    }

    public void setLockoutCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LockoutCacheSize", (long)n, (long)0L, (long)99999L);
        int n2 = this._LockoutCacheSize;
        this._LockoutCacheSize = n;
        this._postSet(12, n2, n);
    }

    public int getLockoutGCThreshold() {
        return this._LockoutGCThreshold;
    }

    public boolean isLockoutGCThresholdSet() {
        return this._isSet(13);
    }

    public void setLockoutGCThreshold(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LockoutGCThreshold", (long)n, (long)0L, (long)999999L);
        int n2 = this._LockoutGCThreshold;
        this._LockoutGCThreshold = n;
        this._postSet(13, n2, n);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 12;
        }
        try {
            switch (n) {
                case 12: {
                    this._LockoutCacheSize = 5;
                    if (bl) break;
                }
                case 10: {
                    this._LockoutDuration = 30;
                    if (bl) break;
                }
                case 13: {
                    this._LockoutGCThreshold = 400;
                    if (bl) break;
                }
                case 11: {
                    this._LockoutResetDuration = 5;
                    if (bl) break;
                }
                case 9: {
                    this._LockoutThreshold = 5;
                    if (bl) break;
                }
                case 7: {
                    this._MinimumPasswordLength = 8;
                    if (bl) break;
                }
                case 8: {
                    this._LockoutEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "PasswordPolicy";
    }

    public void putValue(String string, Object object) {
        if (string.equals("LockoutCacheSize")) {
            int n = this._LockoutCacheSize;
            this._LockoutCacheSize = (Integer)object;
            this._postSet(12, n, this._LockoutCacheSize);
            return;
        }
        if (string.equals("LockoutDuration")) {
            int n = this._LockoutDuration;
            this._LockoutDuration = (Integer)object;
            this._postSet(10, n, this._LockoutDuration);
            return;
        }
        if (string.equals("LockoutEnabled")) {
            boolean bl = this._LockoutEnabled;
            this._LockoutEnabled = (Boolean)object;
            this._postSet(8, bl, this._LockoutEnabled);
            return;
        }
        if (string.equals("LockoutGCThreshold")) {
            int n = this._LockoutGCThreshold;
            this._LockoutGCThreshold = (Integer)object;
            this._postSet(13, n, this._LockoutGCThreshold);
            return;
        }
        if (string.equals("LockoutResetDuration")) {
            int n = this._LockoutResetDuration;
            this._LockoutResetDuration = (Integer)object;
            this._postSet(11, n, this._LockoutResetDuration);
            return;
        }
        if (string.equals("LockoutThreshold")) {
            int n = this._LockoutThreshold;
            this._LockoutThreshold = (Integer)object;
            this._postSet(9, n, this._LockoutThreshold);
            return;
        }
        if (string.equals("MinimumPasswordLength")) {
            int n = this._MinimumPasswordLength;
            this._MinimumPasswordLength = (Integer)object;
            this._postSet(7, n, this._MinimumPasswordLength);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("LockoutCacheSize")) {
            return new Integer(this._LockoutCacheSize);
        }
        if (string.equals("LockoutDuration")) {
            return new Integer(this._LockoutDuration);
        }
        if (string.equals("LockoutEnabled")) {
            return new Boolean(this._LockoutEnabled);
        }
        if (string.equals("LockoutGCThreshold")) {
            return new Integer(this._LockoutGCThreshold);
        }
        if (string.equals("LockoutResetDuration")) {
            return new Integer(this._LockoutResetDuration);
        }
        if (string.equals("LockoutThreshold")) {
            return new Integer(this._LockoutThreshold);
        }
        if (string.equals("MinimumPasswordLength")) {
            return new Integer(this._MinimumPasswordLength);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 18: {
                    if (!string.equals("lockout-cache-size")) break;
                    return 12;
                }
                case 16: {
                    if (!string.equals("lockout-duration")) break;
                    return 10;
                }
                case 19: {
                    if (!string.equals("lockoutgc-threshold")) break;
                    return 13;
                }
                case 22: {
                    if (!string.equals("lockout-reset-duration")) break;
                    return 11;
                }
                case 17: {
                    if (!string.equals("lockout-threshold")) break;
                    return 9;
                }
                case 23: {
                    if (!string.equals("minimum-password-length")) break;
                    return 7;
                }
                case 15: {
                    if (!string.equals("lockout-enabled")) break;
                    return 8;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 12: {
                    return "lockout-cache-size";
                }
                case 10: {
                    return "lockout-duration";
                }
                case 13: {
                    return "lockoutgc-threshold";
                }
                case 11: {
                    return "lockout-reset-duration";
                }
                case 9: {
                    return "lockout-threshold";
                }
                case 7: {
                    return "minimum-password-length";
                }
                case 8: {
                    return "lockout-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private PasswordPolicyMBeanImpl bean;

        protected Helper(PasswordPolicyMBeanImpl passwordPolicyMBeanImpl) {
            super(passwordPolicyMBeanImpl);
            this.bean = passwordPolicyMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 12: {
                    return "LockoutCacheSize";
                }
                case 10: {
                    return "LockoutDuration";
                }
                case 13: {
                    return "LockoutGCThreshold";
                }
                case 11: {
                    return "LockoutResetDuration";
                }
                case 9: {
                    return "LockoutThreshold";
                }
                case 7: {
                    return "MinimumPasswordLength";
                }
                case 8: {
                    return "LockoutEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("LockoutCacheSize")) {
                return 12;
            }
            if (string.equals("LockoutDuration")) {
                return 10;
            }
            if (string.equals("LockoutGCThreshold")) {
                return 13;
            }
            if (string.equals("LockoutResetDuration")) {
                return 11;
            }
            if (string.equals("LockoutThreshold")) {
                return 9;
            }
            if (string.equals("MinimumPasswordLength")) {
                return 7;
            }
            if (string.equals("LockoutEnabled")) {
                return 8;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isLockoutCacheSizeSet()) {
                    stringBuffer.append("LockoutCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getLockoutCacheSize()));
                }
                if (this.bean.isLockoutDurationSet()) {
                    stringBuffer.append("LockoutDuration");
                    stringBuffer.append(String.valueOf(this.bean.getLockoutDuration()));
                }
                if (this.bean.isLockoutGCThresholdSet()) {
                    stringBuffer.append("LockoutGCThreshold");
                    stringBuffer.append(String.valueOf(this.bean.getLockoutGCThreshold()));
                }
                if (this.bean.isLockoutResetDurationSet()) {
                    stringBuffer.append("LockoutResetDuration");
                    stringBuffer.append(String.valueOf(this.bean.getLockoutResetDuration()));
                }
                if (this.bean.isLockoutThresholdSet()) {
                    stringBuffer.append("LockoutThreshold");
                    stringBuffer.append(String.valueOf(this.bean.getLockoutThreshold()));
                }
                if (this.bean.isMinimumPasswordLengthSet()) {
                    stringBuffer.append("MinimumPasswordLength");
                    stringBuffer.append(String.valueOf(this.bean.getMinimumPasswordLength()));
                }
                if (this.bean.isLockoutEnabledSet()) {
                    stringBuffer.append("LockoutEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLockoutEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                PasswordPolicyMBeanImpl passwordPolicyMBeanImpl = (PasswordPolicyMBeanImpl)abstractDescriptorBean;
                this.computeDiff("LockoutCacheSize", this.bean.getLockoutCacheSize(), passwordPolicyMBeanImpl.getLockoutCacheSize(), false);
                this.computeDiff("LockoutDuration", this.bean.getLockoutDuration(), passwordPolicyMBeanImpl.getLockoutDuration(), false);
                this.computeDiff("LockoutGCThreshold", this.bean.getLockoutGCThreshold(), passwordPolicyMBeanImpl.getLockoutGCThreshold(), false);
                this.computeDiff("LockoutResetDuration", this.bean.getLockoutResetDuration(), passwordPolicyMBeanImpl.getLockoutResetDuration(), false);
                this.computeDiff("LockoutThreshold", this.bean.getLockoutThreshold(), passwordPolicyMBeanImpl.getLockoutThreshold(), false);
                this.computeDiff("MinimumPasswordLength", this.bean.getMinimumPasswordLength(), passwordPolicyMBeanImpl.getMinimumPasswordLength(), false);
                this.computeDiff("LockoutEnabled", this.bean.isLockoutEnabled(), passwordPolicyMBeanImpl.isLockoutEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                PasswordPolicyMBeanImpl passwordPolicyMBeanImpl = (PasswordPolicyMBeanImpl)beanUpdateEvent.getSourceBean();
                PasswordPolicyMBeanImpl passwordPolicyMBeanImpl2 = (PasswordPolicyMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("LockoutCacheSize")) {
                    passwordPolicyMBeanImpl.setLockoutCacheSize(passwordPolicyMBeanImpl2.getLockoutCacheSize());
                    passwordPolicyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("LockoutDuration")) {
                    passwordPolicyMBeanImpl.setLockoutDuration(passwordPolicyMBeanImpl2.getLockoutDuration());
                    passwordPolicyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("LockoutGCThreshold")) {
                    passwordPolicyMBeanImpl.setLockoutGCThreshold(passwordPolicyMBeanImpl2.getLockoutGCThreshold());
                    passwordPolicyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("LockoutResetDuration")) {
                    passwordPolicyMBeanImpl.setLockoutResetDuration(passwordPolicyMBeanImpl2.getLockoutResetDuration());
                    passwordPolicyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("LockoutThreshold")) {
                    passwordPolicyMBeanImpl.setLockoutThreshold(passwordPolicyMBeanImpl2.getLockoutThreshold());
                    passwordPolicyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("MinimumPasswordLength")) {
                    passwordPolicyMBeanImpl.setMinimumPasswordLength(passwordPolicyMBeanImpl2.getMinimumPasswordLength());
                    passwordPolicyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("LockoutEnabled")) {
                    passwordPolicyMBeanImpl.setLockoutEnabled(passwordPolicyMBeanImpl2.isLockoutEnabled());
                    passwordPolicyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                PasswordPolicyMBeanImpl passwordPolicyMBeanImpl = (PasswordPolicyMBeanImpl)abstractDescriptorBean;
                super.finishCopy(passwordPolicyMBeanImpl, bl, list);
                if ((list == null || !list.contains("LockoutCacheSize")) && this.bean.isLockoutCacheSizeSet()) {
                    passwordPolicyMBeanImpl.setLockoutCacheSize(this.bean.getLockoutCacheSize());
                }
                if ((list == null || !list.contains("LockoutDuration")) && this.bean.isLockoutDurationSet()) {
                    passwordPolicyMBeanImpl.setLockoutDuration(this.bean.getLockoutDuration());
                }
                if ((list == null || !list.contains("LockoutGCThreshold")) && this.bean.isLockoutGCThresholdSet()) {
                    passwordPolicyMBeanImpl.setLockoutGCThreshold(this.bean.getLockoutGCThreshold());
                }
                if ((list == null || !list.contains("LockoutResetDuration")) && this.bean.isLockoutResetDurationSet()) {
                    passwordPolicyMBeanImpl.setLockoutResetDuration(this.bean.getLockoutResetDuration());
                }
                if ((list == null || !list.contains("LockoutThreshold")) && this.bean.isLockoutThresholdSet()) {
                    passwordPolicyMBeanImpl.setLockoutThreshold(this.bean.getLockoutThreshold());
                }
                if ((list == null || !list.contains("MinimumPasswordLength")) && this.bean.isMinimumPasswordLengthSet()) {
                    passwordPolicyMBeanImpl.setMinimumPasswordLength(this.bean.getMinimumPasswordLength());
                }
                if ((list == null || !list.contains("LockoutEnabled")) && this.bean.isLockoutEnabledSet()) {
                    passwordPolicyMBeanImpl.setLockoutEnabled(this.bean.isLockoutEnabled());
                }
                return passwordPolicyMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

