/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.BasicRealmMBeanImpl;
import weblogic.management.configuration.LegalHelper;
import weblogic.management.configuration.RDBMSRealmMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class RDBMSRealmMBeanImpl
extends BasicRealmMBeanImpl
implements RDBMSRealmMBean,
Serializable {
    private String _DatabaseDriver;
    private String _DatabasePassword;
    private byte[] _DatabasePasswordEncrypted;
    private String _DatabaseURL;
    private String _DatabaseUserName;
    private String _RealmClassName;
    private Properties _SchemaProperties;
    private static SchemaHelper2 _schemaHelper;

    public RDBMSRealmMBeanImpl() {
        this._initializeProperty(-1);
    }

    public RDBMSRealmMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getRealmClassName() {
        return this._RealmClassName;
    }

    public boolean isRealmClassNameSet() {
        return this._isSet(7);
    }

    public void setRealmClassName(String string) throws InvalidAttributeValueException {
        String string2 = string = string == null ? null : string.trim();
        string = string2 = LegalHelper.checkClassName(string2);
        String string3 = this._RealmClassName;
        this._RealmClassName = string;
        this._postSet(7, string3, string);
    }

    public String getDatabaseDriver() {
        return this._DatabaseDriver;
    }

    public boolean isDatabaseDriverSet() {
        return this._isSet(8);
    }

    public void setDatabaseDriver(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._DatabaseDriver;
        this._DatabaseDriver = string;
        this._postSet(8, string2, string);
    }

    public String getDatabaseURL() {
        return this._DatabaseURL;
    }

    public boolean isDatabaseURLSet() {
        return this._isSet(9);
    }

    public void setDatabaseURL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._DatabaseURL;
        this._DatabaseURL = string;
        this._postSet(9, string2, string);
    }

    public String getDatabaseUserName() {
        return this._DatabaseUserName;
    }

    public boolean isDatabaseUserNameSet() {
        return this._isSet(10);
    }

    public void setDatabaseUserName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._DatabaseUserName;
        this._DatabaseUserName = string;
        this._postSet(10, string2, string);
    }

    public String getDatabasePassword() {
        byte[] byArray = this.getDatabasePasswordEncrypted();
        return byArray == null ? null : this._decrypt("DatabasePassword", byArray);
    }

    public boolean isDatabasePasswordSet() {
        return this.isDatabasePasswordEncryptedSet();
    }

    public void setDatabasePassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setDatabasePasswordEncrypted(string == null ? null : this._encrypt("DatabasePassword", string));
    }

    public byte[] getDatabasePasswordEncrypted() {
        return this._getHelper()._cloneArray(this._DatabasePasswordEncrypted);
    }

    public String getDatabasePasswordEncryptedAsString() {
        byte[] byArray = this.getDatabasePasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isDatabasePasswordEncryptedSet() {
        return this._isSet(12);
    }

    public void setDatabasePasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setDatabasePasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public Properties getSchemaProperties() {
        return this._SchemaProperties;
    }

    public String getSchemaPropertiesAsString() {
        return StringHelper.objectToString((Object)this.getSchemaProperties());
    }

    public boolean isSchemaPropertiesSet() {
        return this._isSet(13);
    }

    public void setSchemaPropertiesAsString(String string) {
        try {
            this.setSchemaProperties(StringHelper.stringToProperties((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setSchemaProperties(Properties properties) throws InvalidAttributeValueException {
        Properties properties2 = this._SchemaProperties;
        this._SchemaProperties = properties;
        this._postSet(13, properties2, properties);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setDatabasePasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._DatabasePasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: DatabasePasswordEncrypted of RDBMSRealmMBean");
        }
        this._getHelper()._clearArray(this._DatabasePasswordEncrypted);
        this._DatabasePasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(12, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 11) {
                this._markSet(12, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._DatabaseDriver = "";
                    if (bl) break;
                }
                case 11: {
                    this._DatabasePasswordEncrypted = null;
                    if (bl) break;
                }
                case 12: {
                    this._DatabasePasswordEncrypted = null;
                    if (bl) break;
                }
                case 9: {
                    this._DatabaseURL = "";
                    if (bl) break;
                }
                case 10: {
                    this._DatabaseUserName = null;
                    if (bl) break;
                }
                case 7: {
                    this._RealmClassName = "";
                    if (bl) break;
                }
                case 13: {
                    this._SchemaProperties = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "RDBMSRealm";
    }

    public void putValue(String string, Object object) {
        if (string.equals("DatabaseDriver")) {
            String string2 = this._DatabaseDriver;
            this._DatabaseDriver = (String)object;
            this._postSet(8, string2, this._DatabaseDriver);
            return;
        }
        if (string.equals("DatabasePassword")) {
            String string3 = this._DatabasePassword;
            this._DatabasePassword = (String)object;
            this._postSet(11, string3, this._DatabasePassword);
            return;
        }
        if (string.equals("DatabasePasswordEncrypted")) {
            byte[] byArray = this._DatabasePasswordEncrypted;
            this._DatabasePasswordEncrypted = (byte[])object;
            this._postSet(12, byArray, this._DatabasePasswordEncrypted);
            return;
        }
        if (string.equals("DatabaseURL")) {
            String string4 = this._DatabaseURL;
            this._DatabaseURL = (String)object;
            this._postSet(9, string4, this._DatabaseURL);
            return;
        }
        if (string.equals("DatabaseUserName")) {
            String string5 = this._DatabaseUserName;
            this._DatabaseUserName = (String)object;
            this._postSet(10, string5, this._DatabaseUserName);
            return;
        }
        if (string.equals("RealmClassName")) {
            String string6 = this._RealmClassName;
            this._RealmClassName = (String)object;
            this._postSet(7, string6, this._RealmClassName);
            return;
        }
        if (string.equals("SchemaProperties")) {
            Properties properties = this._SchemaProperties;
            this._SchemaProperties = (Properties)object;
            this._postSet(13, properties, this._SchemaProperties);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("DatabaseDriver")) {
            return this._DatabaseDriver;
        }
        if (string.equals("DatabasePassword")) {
            return this._DatabasePassword;
        }
        if (string.equals("DatabasePasswordEncrypted")) {
            return this._DatabasePasswordEncrypted;
        }
        if (string.equals("DatabaseURL")) {
            return this._DatabaseURL;
        }
        if (string.equals("DatabaseUserName")) {
            return this._DatabaseUserName;
        }
        if (string.equals("RealmClassName")) {
            return this._RealmClassName;
        }
        if (string.equals("SchemaProperties")) {
            return this._SchemaProperties;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends BasicRealmMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 15: {
                    if (!string.equals("database-driver")) break;
                    return 8;
                }
                case 17: {
                    if (string.equals("database-password")) {
                        return 11;
                    }
                    if (!string.equals("schema-properties")) break;
                    return 13;
                }
                case 27: {
                    if (!string.equals("database-password-encrypted")) break;
                    return 12;
                }
                case 12: {
                    if (!string.equals("database-url")) break;
                    return 9;
                }
                case 18: {
                    if (!string.equals("database-user-name")) break;
                    return 10;
                }
                case 16: {
                    if (!string.equals("realm-class-name")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "database-driver";
                }
                case 11: {
                    return "database-password";
                }
                case 12: {
                    return "database-password-encrypted";
                }
                case 9: {
                    return "database-url";
                }
                case 10: {
                    return "database-user-name";
                }
                case 7: {
                    return "realm-class-name";
                }
                case 13: {
                    return "schema-properties";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends BasicRealmMBeanImpl.Helper {
        private RDBMSRealmMBeanImpl bean;

        protected Helper(RDBMSRealmMBeanImpl rDBMSRealmMBeanImpl) {
            super(rDBMSRealmMBeanImpl);
            this.bean = rDBMSRealmMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "DatabaseDriver";
                }
                case 11: {
                    return "DatabasePassword";
                }
                case 12: {
                    return "DatabasePasswordEncrypted";
                }
                case 9: {
                    return "DatabaseURL";
                }
                case 10: {
                    return "DatabaseUserName";
                }
                case 7: {
                    return "RealmClassName";
                }
                case 13: {
                    return "SchemaProperties";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("DatabaseDriver")) {
                return 8;
            }
            if (string.equals("DatabasePassword")) {
                return 11;
            }
            if (string.equals("DatabasePasswordEncrypted")) {
                return 12;
            }
            if (string.equals("DatabaseURL")) {
                return 9;
            }
            if (string.equals("DatabaseUserName")) {
                return 10;
            }
            if (string.equals("RealmClassName")) {
                return 7;
            }
            if (string.equals("SchemaProperties")) {
                return 13;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDatabaseDriverSet()) {
                    stringBuffer.append("DatabaseDriver");
                    stringBuffer.append(String.valueOf(this.bean.getDatabaseDriver()));
                }
                if (this.bean.isDatabasePasswordSet()) {
                    stringBuffer.append("DatabasePassword");
                    stringBuffer.append(String.valueOf(this.bean.getDatabasePassword()));
                }
                if (this.bean.isDatabasePasswordEncryptedSet()) {
                    stringBuffer.append("DatabasePasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getDatabasePasswordEncrypted())));
                }
                if (this.bean.isDatabaseURLSet()) {
                    stringBuffer.append("DatabaseURL");
                    stringBuffer.append(String.valueOf(this.bean.getDatabaseURL()));
                }
                if (this.bean.isDatabaseUserNameSet()) {
                    stringBuffer.append("DatabaseUserName");
                    stringBuffer.append(String.valueOf(this.bean.getDatabaseUserName()));
                }
                if (this.bean.isRealmClassNameSet()) {
                    stringBuffer.append("RealmClassName");
                    stringBuffer.append(String.valueOf(this.bean.getRealmClassName()));
                }
                if (this.bean.isSchemaPropertiesSet()) {
                    stringBuffer.append("SchemaProperties");
                    stringBuffer.append(String.valueOf(this.bean.getSchemaProperties()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                RDBMSRealmMBeanImpl rDBMSRealmMBeanImpl = (RDBMSRealmMBeanImpl)abstractDescriptorBean;
                this.computeDiff("DatabaseDriver", this.bean.getDatabaseDriver(), rDBMSRealmMBeanImpl.getDatabaseDriver(), false);
                this.computeDiff("DatabasePasswordEncrypted", this.bean.getDatabasePasswordEncrypted(), rDBMSRealmMBeanImpl.getDatabasePasswordEncrypted(), false);
                this.computeDiff("DatabaseURL", this.bean.getDatabaseURL(), rDBMSRealmMBeanImpl.getDatabaseURL(), false);
                this.computeDiff("DatabaseUserName", this.bean.getDatabaseUserName(), rDBMSRealmMBeanImpl.getDatabaseUserName(), false);
                this.computeDiff("RealmClassName", this.bean.getRealmClassName(), rDBMSRealmMBeanImpl.getRealmClassName(), false);
                this.computeDiff("SchemaProperties", this.bean.getSchemaProperties(), rDBMSRealmMBeanImpl.getSchemaProperties(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                RDBMSRealmMBeanImpl rDBMSRealmMBeanImpl = (RDBMSRealmMBeanImpl)beanUpdateEvent.getSourceBean();
                RDBMSRealmMBeanImpl rDBMSRealmMBeanImpl2 = (RDBMSRealmMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("DatabaseDriver")) {
                    rDBMSRealmMBeanImpl.setDatabaseDriver(rDBMSRealmMBeanImpl2.getDatabaseDriver());
                    rDBMSRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (!string.equals("DatabasePassword")) {
                    if (string.equals("DatabasePasswordEncrypted")) {
                        rDBMSRealmMBeanImpl.setDatabasePasswordEncrypted(rDBMSRealmMBeanImpl2.getDatabasePasswordEncrypted());
                        rDBMSRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("DatabaseURL")) {
                        rDBMSRealmMBeanImpl.setDatabaseURL(rDBMSRealmMBeanImpl2.getDatabaseURL());
                        rDBMSRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("DatabaseUserName")) {
                        rDBMSRealmMBeanImpl.setDatabaseUserName(rDBMSRealmMBeanImpl2.getDatabaseUserName());
                        rDBMSRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("RealmClassName")) {
                        rDBMSRealmMBeanImpl.setRealmClassName(rDBMSRealmMBeanImpl2.getRealmClassName());
                        rDBMSRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("SchemaProperties")) {
                        rDBMSRealmMBeanImpl.setSchemaProperties(rDBMSRealmMBeanImpl2.getSchemaProperties() == null ? null : (Properties)rDBMSRealmMBeanImpl2.getSchemaProperties().clone());
                        rDBMSRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                RDBMSRealmMBeanImpl rDBMSRealmMBeanImpl = (RDBMSRealmMBeanImpl)abstractDescriptorBean;
                super.finishCopy(rDBMSRealmMBeanImpl, bl, list);
                if ((list == null || !list.contains("DatabaseDriver")) && this.bean.isDatabaseDriverSet()) {
                    rDBMSRealmMBeanImpl.setDatabaseDriver(this.bean.getDatabaseDriver());
                }
                if ((list == null || !list.contains("DatabasePasswordEncrypted")) && this.bean.isDatabasePasswordEncryptedSet()) {
                    byte[] byArray = this.bean.getDatabasePasswordEncrypted();
                    rDBMSRealmMBeanImpl.setDatabasePasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("DatabaseURL")) && this.bean.isDatabaseURLSet()) {
                    rDBMSRealmMBeanImpl.setDatabaseURL(this.bean.getDatabaseURL());
                }
                if ((list == null || !list.contains("DatabaseUserName")) && this.bean.isDatabaseUserNameSet()) {
                    rDBMSRealmMBeanImpl.setDatabaseUserName(this.bean.getDatabaseUserName());
                }
                if ((list == null || !list.contains("RealmClassName")) && this.bean.isRealmClassNameSet()) {
                    rDBMSRealmMBeanImpl.setRealmClassName(this.bean.getRealmClassName());
                }
                if ((list == null || !list.contains("SchemaProperties")) && this.bean.isSchemaPropertiesSet()) {
                    rDBMSRealmMBeanImpl.setSchemaProperties(this.bean.getSchemaProperties());
                }
                return rDBMSRealmMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

