/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import weblogic.management.configuration.ListResults;
import weblogic.management.configuration.RemoteEnumeration;
import weblogic.utils.NestedRuntimeException;

public final class RealmIterator
implements Iterator,
Serializable {
    private static final long serialVersionUID = 7069491944073400204L;
    private static boolean debug = false;
    private RemoteEnumeration helper;
    private ElementHandler handler;
    private boolean done = false;
    private Object[] elements = null;
    private int current = 0;

    public RealmIterator(ListResults listResults, ElementHandler elementHandler) {
        this.elements = listResults.getFirstBatch();
        this.helper = listResults.getRest();
        this.handler = elementHandler;
        if (debug) {
            this.trace("constructor");
        }
    }

    public boolean hasNext() {
        if (debug) {
            this.trace("hasNext");
        }
        this.ensureBatch();
        return !this.done;
    }

    public Object next() {
        if (debug) {
            this.trace("next");
        }
        this.ensureBatch();
        if (this.done) {
            throw new NoSuchElementException("RealmIterator.getNextElement");
        }
        return this.handler.handle(this.elements[this.current++]);
    }

    public void remove() {
        if (debug) {
            this.trace("remove");
        }
        throw new UnsupportedOperationException("RealmIterator.remove");
    }

    public void close() {
        if (debug) {
            this.trace("close");
        }
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.helper == null) {
            return;
        }
        try {
            this.helper.close();
            this.helper = null;
        }
        catch (Throwable throwable) {
            this.helper = null;
            throw new NestedRuntimeException("RealmIterator.close", throwable);
        }
    }

    public void finalize() {
        if (debug) {
            this.trace("finalize");
        }
    }

    private void trace(String string) {
        System.out.print("RealmIterator done=" + this.done + ", current=" + this.current);
        if (this.elements == null) {
            System.out.print("no elements");
        } else {
            System.out.print("elements.length=" + this.elements.length);
        }
        System.out.println(" " + string);
    }

    private void ensureBatch() {
        if (debug) {
            this.trace("ensureBatch");
        }
        if (this.done) {
            return;
        }
        if (this.elements != null && 0 <= this.current && this.current < this.elements.length) {
            return;
        }
        try {
            this.current = 0;
            this.elements = null;
            if (this.helper != null) {
                this.elements = this.helper.getNextBatch();
                if (this.elements == null || this.elements.length == 0) {
                    this.close();
                }
            } else {
                this.close();
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw new NestedRuntimeException("RealmIterator.ensureBatch", throwable);
        }
    }

    static interface ElementHandler {
        public Object handle(Object var1);
    }
}

