/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.CachingRealmMBean;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.FileRealmMBean;
import weblogic.management.configuration.RealmException;
import weblogic.management.configuration.RealmMBean;
import weblogic.management.configuration.RealmManager;
import weblogic.management.mbeans.custom.Realm;
import weblogic.utils.collections.CombinedIterator;

public class RealmMBeanImpl
extends ConfigurationMBeanImpl
implements RealmMBean,
Serializable {
    private CachingRealmMBean _CachingRealm;
    private boolean _EnumerationAllowed;
    private FileRealmMBean _FileRealm;
    private String _Name;
    private int _ResultsBatchSize;
    private Realm _customizer;
    private static SchemaHelper2 _schemaHelper;

    public RealmMBeanImpl() {
        try {
            this._customizer = new Realm(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public RealmMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new Realm(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public CachingRealmMBean getCachingRealm() {
        return this._CachingRealm;
    }

    public String getCachingRealmAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getCachingRealm();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isCachingRealmSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setCachingRealmAsString(String string) {
        if (string == null || string.length() == 0) {
            CachingRealmMBean cachingRealmMBean = this._CachingRealm;
            this._initializeProperty(7);
            this._postSet(7, cachingRealmMBean, this._CachingRealm);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, CachingRealmMBean.class, new ReferenceManager.Resolver(this, 7){

                public void resolveReference(Object object) {
                    try {
                        RealmMBeanImpl.this.setCachingRealm((CachingRealmMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setCachingRealm(CachingRealmMBean cachingRealmMBean) throws InvalidAttributeValueException {
        CachingRealmMBean cachingRealmMBean2;
        if (cachingRealmMBean != null) {
            cachingRealmMBean2 = new ResolvedReference(this, 7, (AbstractDescriptorBean)cachingRealmMBean){

                protected Object getPropertyValue() {
                    return RealmMBeanImpl.this.getCachingRealm();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)cachingRealmMBean, (ResolvedReference)cachingRealmMBean2);
        }
        cachingRealmMBean2 = this._CachingRealm;
        this._CachingRealm = cachingRealmMBean;
        this._postSet(7, cachingRealmMBean2, cachingRealmMBean);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public FileRealmMBean getFileRealm() {
        return this._FileRealm;
    }

    public String getFileRealmAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getFileRealm();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isFileRealmSet() {
        return this._isSet(8);
    }

    public void setFileRealmAsString(String string) {
        if (string == null || string.length() == 0) {
            FileRealmMBean fileRealmMBean = this._FileRealm;
            this._initializeProperty(8);
            this._postSet(8, fileRealmMBean, this._FileRealm);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, FileRealmMBean.class, new ReferenceManager.Resolver(this, 8){

                public void resolveReference(Object object) {
                    try {
                        RealmMBeanImpl.this.setFileRealm((FileRealmMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setFileRealm(FileRealmMBean fileRealmMBean) throws InvalidAttributeValueException {
        FileRealmMBean fileRealmMBean2;
        if (fileRealmMBean != null) {
            fileRealmMBean2 = new ResolvedReference(this, 8, (AbstractDescriptorBean)fileRealmMBean){

                protected Object getPropertyValue() {
                    return RealmMBeanImpl.this.getFileRealm();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)fileRealmMBean, (ResolvedReference)fileRealmMBean2);
        }
        fileRealmMBean2 = this._FileRealm;
        this._FileRealm = fileRealmMBean;
        this._postSet(8, fileRealmMBean2, fileRealmMBean);
    }

    public void refresh() throws RealmException, DistributedManagementException {
        this._customizer.refresh();
    }

    public RealmManager manager() {
        return this._customizer.manager();
    }

    public int getResultsBatchSize() {
        return this._ResultsBatchSize;
    }

    public boolean isResultsBatchSizeSet() {
        return this._isSet(9);
    }

    public void setResultsBatchSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"ResultsBatchSize", (int)n, (int)0);
        int n2 = this._ResultsBatchSize;
        this._ResultsBatchSize = n;
        this._postSet(9, n2, n);
    }

    public boolean isEnumerationAllowed() {
        return this._EnumerationAllowed;
    }

    public boolean isEnumerationAllowedSet() {
        return this._isSet(10);
    }

    public void setEnumerationAllowed(boolean bl) {
        boolean bl2 = this._EnumerationAllowed;
        this._EnumerationAllowed = bl;
        this._postSet(10, bl2, bl);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 7;
        }
        try {
            switch (n) {
                case 7: {
                    this._CachingRealm = null;
                    if (bl) break;
                }
                case 8: {
                    this._FileRealm = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 9: {
                    this._ResultsBatchSize = 200;
                    if (bl) break;
                }
                case 10: {
                    this._EnumerationAllowed = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Realm";
    }

    public void putValue(String string, Object object) {
        if (string.equals("CachingRealm")) {
            CachingRealmMBean cachingRealmMBean = this._CachingRealm;
            this._CachingRealm = (CachingRealmMBean)object;
            this._postSet(7, cachingRealmMBean, this._CachingRealm);
            return;
        }
        if (string.equals("EnumerationAllowed")) {
            boolean bl = this._EnumerationAllowed;
            this._EnumerationAllowed = (Boolean)object;
            this._postSet(10, bl, this._EnumerationAllowed);
            return;
        }
        if (string.equals("FileRealm")) {
            FileRealmMBean fileRealmMBean = this._FileRealm;
            this._FileRealm = (FileRealmMBean)object;
            this._postSet(8, fileRealmMBean, this._FileRealm);
            return;
        }
        if (string.equals("Name")) {
            String string2 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string2, this._Name);
            return;
        }
        if (string.equals("ResultsBatchSize")) {
            int n = this._ResultsBatchSize;
            this._ResultsBatchSize = (Integer)object;
            this._postSet(9, n, this._ResultsBatchSize);
            return;
        }
        if (string.equals("customizer")) {
            Realm realm = this._customizer;
            this._customizer = (Realm)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("CachingRealm")) {
            return this._CachingRealm;
        }
        if (string.equals("EnumerationAllowed")) {
            return new Boolean(this._EnumerationAllowed);
        }
        if (string.equals("FileRealm")) {
            return this._FileRealm;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("ResultsBatchSize")) {
            return new Integer(this._ResultsBatchSize);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (!string.equals("caching-realm")) break;
                    return 7;
                }
                case 10: {
                    if (!string.equals("file-realm")) break;
                    return 8;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 18: {
                    if (!string.equals("results-batch-size")) break;
                    return 9;
                }
                case 19: {
                    if (!string.equals("enumeration-allowed")) break;
                    return 10;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 7: {
                    return "caching-realm";
                }
                case 8: {
                    return "file-realm";
                }
                case 2: {
                    return "name";
                }
                case 9: {
                    return "results-batch-size";
                }
                case 10: {
                    return "enumeration-allowed";
                }
            }
            return super.getElementName(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private RealmMBeanImpl bean;

        protected Helper(RealmMBeanImpl realmMBeanImpl) {
            super(realmMBeanImpl);
            this.bean = realmMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 7: {
                    return "CachingRealm";
                }
                case 8: {
                    return "FileRealm";
                }
                case 2: {
                    return "Name";
                }
                case 9: {
                    return "ResultsBatchSize";
                }
                case 10: {
                    return "EnumerationAllowed";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CachingRealm")) {
                return 7;
            }
            if (string.equals("FileRealm")) {
                return 8;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("ResultsBatchSize")) {
                return 9;
            }
            if (string.equals("EnumerationAllowed")) {
                return 10;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCachingRealmSet()) {
                    stringBuffer.append("CachingRealm");
                    stringBuffer.append(String.valueOf(this.bean.getCachingRealm()));
                }
                if (this.bean.isFileRealmSet()) {
                    stringBuffer.append("FileRealm");
                    stringBuffer.append(String.valueOf(this.bean.getFileRealm()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isResultsBatchSizeSet()) {
                    stringBuffer.append("ResultsBatchSize");
                    stringBuffer.append(String.valueOf(this.bean.getResultsBatchSize()));
                }
                if (this.bean.isEnumerationAllowedSet()) {
                    stringBuffer.append("EnumerationAllowed");
                    stringBuffer.append(String.valueOf(this.bean.isEnumerationAllowed()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                RealmMBeanImpl realmMBeanImpl = (RealmMBeanImpl)abstractDescriptorBean;
                this.computeDiff("CachingRealm", this.bean.getCachingRealm(), realmMBeanImpl.getCachingRealm(), false);
                this.computeDiff("FileRealm", this.bean.getFileRealm(), realmMBeanImpl.getFileRealm(), false);
                this.computeDiff("Name", this.bean.getName(), realmMBeanImpl.getName(), false);
                this.computeDiff("ResultsBatchSize", this.bean.getResultsBatchSize(), realmMBeanImpl.getResultsBatchSize(), false);
                this.computeDiff("EnumerationAllowed", this.bean.isEnumerationAllowed(), realmMBeanImpl.isEnumerationAllowed(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                RealmMBeanImpl realmMBeanImpl = (RealmMBeanImpl)beanUpdateEvent.getSourceBean();
                RealmMBeanImpl realmMBeanImpl2 = (RealmMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CachingRealm")) {
                    realmMBeanImpl.setCachingRealmAsString(realmMBeanImpl2.getCachingRealmAsString());
                    realmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("FileRealm")) {
                    realmMBeanImpl.setFileRealmAsString(realmMBeanImpl2.getFileRealmAsString());
                    realmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("Name")) {
                    realmMBeanImpl.setName(realmMBeanImpl2.getName());
                    realmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("ResultsBatchSize")) {
                    realmMBeanImpl.setResultsBatchSize(realmMBeanImpl2.getResultsBatchSize());
                    realmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("EnumerationAllowed")) {
                    realmMBeanImpl.setEnumerationAllowed(realmMBeanImpl2.isEnumerationAllowed());
                    realmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                RealmMBeanImpl realmMBeanImpl = (RealmMBeanImpl)abstractDescriptorBean;
                super.finishCopy(realmMBeanImpl, bl, list);
                if ((list == null || !list.contains("CachingRealm")) && this.bean.isCachingRealmSet()) {
                    realmMBeanImpl._unSet(realmMBeanImpl, 7);
                    realmMBeanImpl.setCachingRealmAsString(this.bean.getCachingRealmAsString());
                }
                if ((list == null || !list.contains("FileRealm")) && this.bean.isFileRealmSet()) {
                    realmMBeanImpl._unSet(realmMBeanImpl, 8);
                    realmMBeanImpl.setFileRealmAsString(this.bean.getFileRealmAsString());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    realmMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("ResultsBatchSize")) && this.bean.isResultsBatchSizeSet()) {
                    realmMBeanImpl.setResultsBatchSize(this.bean.getResultsBatchSize());
                }
                if ((list == null || !list.contains("EnumerationAllowed")) && this.bean.isEnumerationAllowedSet()) {
                    realmMBeanImpl.setEnumerationAllowed(this.bean.isEnumerationAllowed());
                }
                return realmMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getCachingRealm(), clazz, object);
            this.inferSubTree(this.bean.getFileRealm(), clazz, object);
        }
    }
}

