/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.security.AccessController;
import weblogic.management.configuration.Acl;
import weblogic.management.configuration.BasicRealmMBean;
import weblogic.management.configuration.CachingRealmMBean;
import weblogic.management.configuration.CustomRealmMBean;
import weblogic.management.configuration.Group;
import weblogic.management.configuration.LDAPRealmMBean;
import weblogic.management.configuration.NTRealmMBean;
import weblogic.management.configuration.RealmException;
import weblogic.management.configuration.RealmIterator;
import weblogic.management.configuration.UnixRealmMBean;
import weblogic.management.configuration.User;
import weblogic.management.internal.RemoteRealmManager;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class RealmManager
implements Serializable {
    private static final long serialVersionUID = 1127506422744561803L;
    private static boolean debug = false;
    private RemoteRealmManager helper;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public RealmManager(RemoteRealmManager remoteRealmManager) {
        if (debug) {
            this.trace("constructor");
        }
        this.helper = remoteRealmManager;
    }

    public User getUser(String string) throws RealmException {
        if (debug) {
            this.trace("getUser(" + string + ")");
        }
        try {
            return this.helper.userExists(string) ? new User(string, this.helper) : null;
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.getUser", throwable);
        }
    }

    public Group getGroup(String string) throws RealmException {
        if (debug) {
            this.trace("getGroup(" + string + ")");
        }
        try {
            return this.helper.groupExists(string) ? new Group(string, this.helper) : null;
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.getGroup", throwable);
        }
    }

    public Acl getAcl(String string) throws RealmException {
        if (debug) {
            this.trace("getAcl(" + string + ")");
        }
        try {
            return this.helper.aclExists(string) ? new Acl(string, this.helper) : null;
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.getAcl", throwable);
        }
    }

    public boolean addUserFailsOver() {
        return this.isReadonlyUserGroupAlternateRealm();
    }

    public boolean addGroupFailsOver() {
        return this.isReadonlyUserGroupAlternateRealm();
    }

    public boolean addAclFailsOver() {
        return false;
    }

    public User createUser(String string, Object object) throws RealmException {
        if (debug) {
            this.trace("createUser(" + string + ")");
        }
        try {
            this.helper.createUser(string, object);
            return new User(string, this.helper);
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.createUser", throwable);
        }
    }

    public Group createGroup(String string) throws RealmException {
        if (debug) {
            this.trace("createGroup(" + string + ")");
        }
        try {
            this.helper.createGroup(string);
            return new Group(string, this.helper);
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.createGroup", throwable);
        }
    }

    public Acl createAcl(String string) throws RealmException {
        if (debug) {
            this.trace("createAcl(" + string + ")");
        }
        try {
            this.helper.createAcl(string);
            return new Acl(string, this.helper);
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.createAcl", throwable);
        }
    }

    public void removeUser(User user) throws RealmException {
        if (debug) {
            this.trace("removeUser(" + user.getName() + ")");
        }
        try {
            this.helper.removeUser(user.getName());
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.removeUser", throwable);
        }
    }

    public void removeGroup(Group group) throws RealmException {
        if (debug) {
            this.trace("removeGroup(" + group.getName() + ")");
        }
        try {
            this.helper.removeGroup(group.getName());
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.removeGroup", throwable);
        }
    }

    public void removeAcl(Acl acl) throws RealmException {
        if (debug) {
            this.trace("removeAcl(" + acl.getName() + ")");
        }
        try {
            this.helper.removeAcl(acl.getName());
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.removeAcl", throwable);
        }
    }

    public RealmIterator listUsers() throws RealmException {
        if (debug) {
            this.trace("listUsers");
        }
        try {
            return new RealmIterator(this.helper.listUsers(), new RealmIterator.ElementHandler(){

                public Object handle(Object object) {
                    if (debug) {
                        RealmManager.this.trace("listUsers handle " + (String)object);
                    }
                    return new User((String)object, RealmManager.this.helper);
                }
            });
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.listUsers", throwable);
        }
    }

    public RealmIterator listGroups() throws RealmException {
        if (debug) {
            this.trace("listGroups");
        }
        try {
            return new RealmIterator(this.helper.listGroups(), new RealmIterator.ElementHandler(){

                public Object handle(Object object) {
                    if (debug) {
                        RealmManager.this.trace("listGroups handle " + (String)object);
                    }
                    return new Group((String)object, RealmManager.this.helper);
                }
            });
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.listGroups", throwable);
        }
    }

    public RealmIterator listAcls() throws RealmException {
        if (debug) {
            this.trace("listAcls");
        }
        try {
            return new RealmIterator(this.helper.listAcls(), new RealmIterator.ElementHandler(){

                public Object handle(Object object) {
                    if (debug) {
                        RealmManager.this.trace("listAcls handle " + (String)object);
                    }
                    return new Acl((String)object, RealmManager.this.helper);
                }
            });
        }
        catch (Throwable throwable) {
            throw new RealmException("RealmManager.listAcls", throwable);
        }
    }

    private boolean isReadonlyUserGroupAlternateRealm() {
        CachingRealmMBean cachingRealmMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getRealm().getCachingRealm();
        if (cachingRealmMBean != null) {
            CustomRealmMBean customRealmMBean;
            String string;
            BasicRealmMBean basicRealmMBean = cachingRealmMBean.getBasicRealm();
            if (basicRealmMBean instanceof LDAPRealmMBean || basicRealmMBean instanceof UnixRealmMBean || basicRealmMBean instanceof NTRealmMBean) {
                return true;
            }
            if (basicRealmMBean instanceof CustomRealmMBean && "weblogic.security.ldaprealmv2.LDAPRealm".equals(string = (customRealmMBean = (CustomRealmMBean)basicRealmMBean).getRealmClassName())) {
                return true;
            }
        }
        return false;
    }

    private void trace(String string) {
        System.out.println("RealmManger " + string);
    }
}

