/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.JMSLegalHelper;
import weblogic.management.configuration.JMSSAFMessageLogFileMBean;
import weblogic.management.configuration.JMSSAFMessageLogFileMBeanImpl;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.SAFAgent;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class SAFAgentMBeanImpl
extends DeploymentMBeanImpl
implements SAFAgentMBean,
Serializable {
    private long _AcknowledgeInterval;
    private long _BytesMaximum;
    private long _BytesThresholdHigh;
    private long _BytesThresholdLow;
    private long _ConversationIdleTimeMaximum;
    private long _DefaultRetryDelayBase;
    private long _DefaultRetryDelayMaximum;
    private double _DefaultRetryDelayMultiplier;
    private long _DefaultTimeToLive;
    private boolean _ForwardingPausedAtStartup;
    private boolean _IncomingPausedAtStartup;
    private JMSSAFMessageLogFileMBean _JMSSAFMessageLogFile;
    private boolean _LoggingEnabled;
    private int _MaximumMessageSize;
    private long _MessageBufferSize;
    private long _MessagesMaximum;
    private long _MessagesThresholdHigh;
    private long _MessagesThresholdLow;
    private String _Name;
    private String _PagingDirectory;
    private boolean _ReceivingPausedAtStartup;
    private Set _ServerNames;
    private String _ServiceType;
    private PersistentStoreMBean _Store;
    private TargetMBean[] _Targets;
    private long _WindowInterval;
    private int _WindowSize;
    private SAFAgent _customizer;
    private static SchemaHelper2 _schemaHelper;

    public SAFAgentMBeanImpl() {
        try {
            this._customizer = new SAFAgent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public SAFAgentMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new SAFAgent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public Set getServerNames() {
        return this._customizer.getServerNames();
    }

    public TargetMBean[] getTargets() {
        return this._Targets;
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isServerNamesSet() {
        return this._isSet(9);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setServerNames(Set set) throws InvalidAttributeValueException {
        this._ServerNames = set;
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            SAFAgentMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        JMSLegalHelper.validateSAFAgentTargets(targetMBeanArray);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return SAFAgentMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this._Targets;
        this._Targets = targetMBeanArray;
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = this._isSet(7) ? (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean) : new TargetMBean[]{targetMBean};
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public PersistentStoreMBean getStore() {
        return this._Store;
    }

    public String getStoreAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getStore();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isStoreSet() {
        return this._isSet(10);
    }

    public void setStoreAsString(String string) {
        if (string == null || string.length() == 0) {
            PersistentStoreMBean persistentStoreMBean = this._Store;
            this._initializeProperty(10);
            this._postSet(10, persistentStoreMBean, this._Store);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, PersistentStoreMBean.class, new ReferenceManager.Resolver(this, 10){

                public void resolveReference(Object object) {
                    try {
                        SAFAgentMBeanImpl.this.setStore((PersistentStoreMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setStore(PersistentStoreMBean persistentStoreMBean) throws InvalidAttributeValueException {
        PersistentStoreMBean persistentStoreMBean2;
        if (persistentStoreMBean != null) {
            persistentStoreMBean2 = new ResolvedReference(this, 10, (AbstractDescriptorBean)persistentStoreMBean){

                protected Object getPropertyValue() {
                    return SAFAgentMBeanImpl.this.getStore();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)persistentStoreMBean, (ResolvedReference)persistentStoreMBean2);
        }
        persistentStoreMBean2 = this._Store;
        this._Store = persistentStoreMBean;
        this._postSet(10, persistentStoreMBean2, persistentStoreMBean);
    }

    public long getBytesMaximum() {
        return this._BytesMaximum;
    }

    public boolean isBytesMaximumSet() {
        return this._isSet(11);
    }

    public void setBytesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"BytesMaximum", (long)l, (long)-1L);
        long l2 = this._BytesMaximum;
        this._BytesMaximum = l;
        this._postSet(11, l2, l);
    }

    public long getBytesThresholdHigh() {
        return this._BytesThresholdHigh;
    }

    public boolean isBytesThresholdHighSet() {
        return this._isSet(12);
    }

    public void setBytesThresholdHigh(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"BytesThresholdHigh", (long)l, (long)-1L);
        long l2 = this._BytesThresholdHigh;
        this._BytesThresholdHigh = l;
        this._postSet(12, l2, l);
    }

    public long getBytesThresholdLow() {
        return this._BytesThresholdLow;
    }

    public boolean isBytesThresholdLowSet() {
        return this._isSet(13);
    }

    public void setBytesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"BytesThresholdLow", (long)l, (long)-1L);
        long l2 = this._BytesThresholdLow;
        this._BytesThresholdLow = l;
        this._postSet(13, l2, l);
    }

    public long getMessagesMaximum() {
        return this._MessagesMaximum;
    }

    public boolean isMessagesMaximumSet() {
        return this._isSet(14);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setMessagesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"MessagesMaximum", (long)l, (long)-1L);
        long l2 = this._MessagesMaximum;
        this._MessagesMaximum = l;
        this._postSet(14, l2, l);
    }

    public long getMessagesThresholdHigh() {
        return this._MessagesThresholdHigh;
    }

    public boolean isMessagesThresholdHighSet() {
        return this._isSet(15);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setMessagesThresholdHigh(long l) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"MessagesThresholdHigh", (long)l, (long)-1L);
        long l2 = this._MessagesThresholdHigh;
        this._MessagesThresholdHigh = l;
        this._postSet(15, l2, l);
    }

    public long getMessagesThresholdLow() {
        return this._MessagesThresholdLow;
    }

    public boolean isMessagesThresholdLowSet() {
        return this._isSet(16);
    }

    public void setMessagesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"MessagesThresholdLow", (long)l, (long)-1L);
        long l2 = this._MessagesThresholdLow;
        this._MessagesThresholdLow = l;
        this._postSet(16, l2, l);
    }

    public int getMaximumMessageSize() {
        return this._MaximumMessageSize;
    }

    public boolean isMaximumMessageSizeSet() {
        return this._isSet(17);
    }

    public void setMaximumMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"MaximumMessageSize", (int)n, (int)0);
        int n2 = this._MaximumMessageSize;
        this._MaximumMessageSize = n;
        this._postSet(17, n2, n);
    }

    public long getDefaultRetryDelayBase() {
        return this._DefaultRetryDelayBase;
    }

    public boolean isDefaultRetryDelayBaseSet() {
        return this._isSet(18);
    }

    public void setDefaultRetryDelayBase(long l) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"DefaultRetryDelayBase", (long)l, (long)1L);
        long l2 = this._DefaultRetryDelayBase;
        this._DefaultRetryDelayBase = l;
        this._postSet(18, l2, l);
    }

    public long getDefaultRetryDelayMaximum() {
        return this._DefaultRetryDelayMaximum;
    }

    public boolean isDefaultRetryDelayMaximumSet() {
        return this._isSet(19);
    }

    public void setDefaultRetryDelayMaximum(long l) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"DefaultRetryDelayMaximum", (long)l, (long)1L);
        long l2 = this._DefaultRetryDelayMaximum;
        this._DefaultRetryDelayMaximum = l;
        this._postSet(19, l2, l);
    }

    public double getDefaultRetryDelayMultiplier() {
        return this._DefaultRetryDelayMultiplier;
    }

    public boolean isDefaultRetryDelayMultiplierSet() {
        return this._isSet(20);
    }

    public void setDefaultRetryDelayMultiplier(double d) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"DefaultRetryDelayMultiplier", (double)d, (double)1.0);
        double d2 = this._DefaultRetryDelayMultiplier;
        this._DefaultRetryDelayMultiplier = d;
        this._postSet(20, d2, d);
    }

    public String getServiceType() {
        return this._ServiceType;
    }

    public boolean isServiceTypeSet() {
        return this._isSet(21);
    }

    public void setServiceType(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Both", "Sending-only", "Receiving-only"};
        string = LegalChecks.checkInEnum((String)"ServiceType", (String)string, (String[])stringArray);
        String string2 = this._ServiceType;
        this._ServiceType = string;
        this._postSet(21, string2, string);
    }

    public int getWindowSize() {
        return this._WindowSize;
    }

    public boolean isWindowSizeSet() {
        return this._isSet(22);
    }

    public void setWindowSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"WindowSize", (int)n, (int)1);
        int n2 = this._WindowSize;
        this._WindowSize = n;
        this._postSet(22, n2, n);
    }

    public boolean isLoggingEnabled() {
        return this._LoggingEnabled;
    }

    public boolean isLoggingEnabledSet() {
        return this._isSet(23);
    }

    public void setLoggingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._LoggingEnabled;
        this._LoggingEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public long getConversationIdleTimeMaximum() {
        return this._ConversationIdleTimeMaximum;
    }

    public boolean isConversationIdleTimeMaximumSet() {
        return this._isSet(24);
    }

    public void setConversationIdleTimeMaximum(long l) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"ConversationIdleTimeMaximum", (long)l, (long)0L);
        long l2 = this._ConversationIdleTimeMaximum;
        this._ConversationIdleTimeMaximum = l;
        this._postSet(24, l2, l);
    }

    public long getAcknowledgeInterval() {
        return this._AcknowledgeInterval;
    }

    public boolean isAcknowledgeIntervalSet() {
        return this._isSet(25);
    }

    public void setAcknowledgeInterval(long l) throws InvalidAttributeValueException {
        JMSLegalHelper.validateAcknowledgeIntervalValue(l);
        long l2 = this._AcknowledgeInterval;
        this._AcknowledgeInterval = l;
        this._postSet(25, l2, l);
    }

    public long getDefaultTimeToLive() {
        return this._DefaultTimeToLive;
    }

    public boolean isDefaultTimeToLiveSet() {
        return this._isSet(26);
    }

    public void setDefaultTimeToLive(long l) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"DefaultTimeToLive", (long)l, (long)0L);
        long l2 = this._DefaultTimeToLive;
        this._DefaultTimeToLive = l;
        this._postSet(26, l2, l);
    }

    public boolean isIncomingPausedAtStartup() {
        return this._IncomingPausedAtStartup;
    }

    public boolean isIncomingPausedAtStartupSet() {
        return this._isSet(27);
    }

    public void setIncomingPausedAtStartup(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._IncomingPausedAtStartup;
        this._IncomingPausedAtStartup = bl;
        this._postSet(27, bl2, bl);
    }

    public boolean isForwardingPausedAtStartup() {
        return this._ForwardingPausedAtStartup;
    }

    public boolean isForwardingPausedAtStartupSet() {
        return this._isSet(28);
    }

    public void setForwardingPausedAtStartup(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ForwardingPausedAtStartup;
        this._ForwardingPausedAtStartup = bl;
        this._postSet(28, bl2, bl);
    }

    public boolean isReceivingPausedAtStartup() {
        return this._ReceivingPausedAtStartup;
    }

    public boolean isReceivingPausedAtStartupSet() {
        return this._isSet(29);
    }

    public void setReceivingPausedAtStartup(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ReceivingPausedAtStartup;
        this._ReceivingPausedAtStartup = bl;
        this._postSet(29, bl2, bl);
    }

    public long getMessageBufferSize() {
        return this._MessageBufferSize;
    }

    public boolean isMessageBufferSizeSet() {
        return this._isSet(30);
    }

    public void setMessageBufferSize(long l) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"MessageBufferSize", (long)l, (long)-1L);
        long l2 = this._MessageBufferSize;
        this._MessageBufferSize = l;
        this._postSet(30, l2, l);
    }

    public String getPagingDirectory() {
        return this._PagingDirectory;
    }

    public boolean isPagingDirectorySet() {
        return this._isSet(31);
    }

    public void setPagingDirectory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._PagingDirectory;
        this._PagingDirectory = string;
        this._postSet(31, string2, string);
    }

    public long getWindowInterval() {
        return this._WindowInterval;
    }

    public boolean isWindowIntervalSet() {
        return this._isSet(32);
    }

    public void setWindowInterval(long l) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"WindowInterval", (long)l, (long)0L);
        long l2 = this._WindowInterval;
        this._WindowInterval = l;
        this._postSet(32, l2, l);
    }

    public JMSSAFMessageLogFileMBean getJMSSAFMessageLogFile() {
        return this._JMSSAFMessageLogFile;
    }

    public boolean isJMSSAFMessageLogFileSet() {
        return this._isSet(33) || this._isAnythingSet((AbstractDescriptorBean)this.getJMSSAFMessageLogFile());
    }

    public void setJMSSAFMessageLogFile(JMSSAFMessageLogFileMBean jMSSAFMessageLogFileMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSSAFMessageLogFileMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 33)) {
            this._postCreate(abstractDescriptorBean);
        }
        JMSSAFMessageLogFileMBean jMSSAFMessageLogFileMBean2 = this._JMSSAFMessageLogFile;
        this._JMSSAFMessageLogFile = jMSSAFMessageLogFileMBean;
        this._postSet(33, jMSSAFMessageLogFileMBean2, jMSSAFMessageLogFileMBean);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        JMSLegalHelper.validateSAFAgent(this);
        JMSLegalHelper.validateServerBytesValues(this);
        JMSLegalHelper.validateRetryBaseAndMax(this);
        JMSLegalHelper.validateServerMessagesValues(this);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet() || this.isJMSSAFMessageLogFileSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 25;
        }
        try {
            switch (n) {
                case 25: {
                    this._AcknowledgeInterval = -1L;
                    if (bl) break;
                }
                case 11: {
                    this._BytesMaximum = -1L;
                    if (bl) break;
                }
                case 12: {
                    this._BytesThresholdHigh = -1L;
                    if (bl) break;
                }
                case 13: {
                    this._BytesThresholdLow = -1L;
                    if (bl) break;
                }
                case 24: {
                    this._ConversationIdleTimeMaximum = 0L;
                    if (bl) break;
                }
                case 18: {
                    this._DefaultRetryDelayBase = 20000L;
                    if (bl) break;
                }
                case 19: {
                    this._DefaultRetryDelayMaximum = 180000L;
                    if (bl) break;
                }
                case 20: {
                    this._DefaultRetryDelayMultiplier = 1.0;
                    if (bl) break;
                }
                case 26: {
                    this._DefaultTimeToLive = 0L;
                    if (bl) break;
                }
                case 33: {
                    this._JMSSAFMessageLogFile = new JMSSAFMessageLogFileMBeanImpl(this, 33);
                    this._postCreate((AbstractDescriptorBean)this._JMSSAFMessageLogFile);
                    if (bl) break;
                }
                case 17: {
                    this._MaximumMessageSize = Integer.MAX_VALUE;
                    if (bl) break;
                }
                case 30: {
                    this._MessageBufferSize = -1L;
                    if (bl) break;
                }
                case 14: {
                    this._MessagesMaximum = -1L;
                    if (bl) break;
                }
                case 15: {
                    this._MessagesThresholdHigh = -1L;
                    if (bl) break;
                }
                case 16: {
                    this._MessagesThresholdLow = -1L;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 31: {
                    this._PagingDirectory = null;
                    if (bl) break;
                }
                case 9: {
                    this._ServerNames = null;
                    if (bl) break;
                }
                case 21: {
                    this._ServiceType = "Both";
                    if (bl) break;
                }
                case 10: {
                    this._Store = null;
                    if (bl) break;
                }
                case 7: {
                    this._Targets = new TargetMBean[0];
                    if (bl) break;
                }
                case 32: {
                    this._WindowInterval = 0L;
                    if (bl) break;
                }
                case 22: {
                    this._WindowSize = 10;
                    if (bl) break;
                }
                case 28: {
                    this._ForwardingPausedAtStartup = false;
                    if (bl) break;
                }
                case 27: {
                    this._IncomingPausedAtStartup = false;
                    if (bl) break;
                }
                case 23: {
                    this._LoggingEnabled = true;
                    if (bl) break;
                }
                case 29: {
                    this._ReceivingPausedAtStartup = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SAFAgent";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AcknowledgeInterval")) {
            long l = this._AcknowledgeInterval;
            this._AcknowledgeInterval = (Long)object;
            this._postSet(25, l, this._AcknowledgeInterval);
            return;
        }
        if (string.equals("BytesMaximum")) {
            long l = this._BytesMaximum;
            this._BytesMaximum = (Long)object;
            this._postSet(11, l, this._BytesMaximum);
            return;
        }
        if (string.equals("BytesThresholdHigh")) {
            long l = this._BytesThresholdHigh;
            this._BytesThresholdHigh = (Long)object;
            this._postSet(12, l, this._BytesThresholdHigh);
            return;
        }
        if (string.equals("BytesThresholdLow")) {
            long l = this._BytesThresholdLow;
            this._BytesThresholdLow = (Long)object;
            this._postSet(13, l, this._BytesThresholdLow);
            return;
        }
        if (string.equals("ConversationIdleTimeMaximum")) {
            long l = this._ConversationIdleTimeMaximum;
            this._ConversationIdleTimeMaximum = (Long)object;
            this._postSet(24, l, this._ConversationIdleTimeMaximum);
            return;
        }
        if (string.equals("DefaultRetryDelayBase")) {
            long l = this._DefaultRetryDelayBase;
            this._DefaultRetryDelayBase = (Long)object;
            this._postSet(18, l, this._DefaultRetryDelayBase);
            return;
        }
        if (string.equals("DefaultRetryDelayMaximum")) {
            long l = this._DefaultRetryDelayMaximum;
            this._DefaultRetryDelayMaximum = (Long)object;
            this._postSet(19, l, this._DefaultRetryDelayMaximum);
            return;
        }
        if (string.equals("DefaultRetryDelayMultiplier")) {
            double d = this._DefaultRetryDelayMultiplier;
            this._DefaultRetryDelayMultiplier = (Double)object;
            this._postSet(20, d, this._DefaultRetryDelayMultiplier);
            return;
        }
        if (string.equals("DefaultTimeToLive")) {
            long l = this._DefaultTimeToLive;
            this._DefaultTimeToLive = (Long)object;
            this._postSet(26, l, this._DefaultTimeToLive);
            return;
        }
        if (string.equals("ForwardingPausedAtStartup")) {
            boolean bl = this._ForwardingPausedAtStartup;
            this._ForwardingPausedAtStartup = (Boolean)object;
            this._postSet(28, bl, this._ForwardingPausedAtStartup);
            return;
        }
        if (string.equals("IncomingPausedAtStartup")) {
            boolean bl = this._IncomingPausedAtStartup;
            this._IncomingPausedAtStartup = (Boolean)object;
            this._postSet(27, bl, this._IncomingPausedAtStartup);
            return;
        }
        if (string.equals("JMSSAFMessageLogFile")) {
            JMSSAFMessageLogFileMBean jMSSAFMessageLogFileMBean = this._JMSSAFMessageLogFile;
            this._JMSSAFMessageLogFile = (JMSSAFMessageLogFileMBean)object;
            this._postSet(33, jMSSAFMessageLogFileMBean, this._JMSSAFMessageLogFile);
            return;
        }
        if (string.equals("LoggingEnabled")) {
            boolean bl = this._LoggingEnabled;
            this._LoggingEnabled = (Boolean)object;
            this._postSet(23, bl, this._LoggingEnabled);
            return;
        }
        if (string.equals("MaximumMessageSize")) {
            int n = this._MaximumMessageSize;
            this._MaximumMessageSize = (Integer)object;
            this._postSet(17, n, this._MaximumMessageSize);
            return;
        }
        if (string.equals("MessageBufferSize")) {
            long l = this._MessageBufferSize;
            this._MessageBufferSize = (Long)object;
            this._postSet(30, l, this._MessageBufferSize);
            return;
        }
        if (string.equals("MessagesMaximum")) {
            long l = this._MessagesMaximum;
            this._MessagesMaximum = (Long)object;
            this._postSet(14, l, this._MessagesMaximum);
            return;
        }
        if (string.equals("MessagesThresholdHigh")) {
            long l = this._MessagesThresholdHigh;
            this._MessagesThresholdHigh = (Long)object;
            this._postSet(15, l, this._MessagesThresholdHigh);
            return;
        }
        if (string.equals("MessagesThresholdLow")) {
            long l = this._MessagesThresholdLow;
            this._MessagesThresholdLow = (Long)object;
            this._postSet(16, l, this._MessagesThresholdLow);
            return;
        }
        if (string.equals("Name")) {
            String string2 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string2, this._Name);
            return;
        }
        if (string.equals("PagingDirectory")) {
            String string3 = this._PagingDirectory;
            this._PagingDirectory = (String)object;
            this._postSet(31, string3, this._PagingDirectory);
            return;
        }
        if (string.equals("ReceivingPausedAtStartup")) {
            boolean bl = this._ReceivingPausedAtStartup;
            this._ReceivingPausedAtStartup = (Boolean)object;
            this._postSet(29, bl, this._ReceivingPausedAtStartup);
            return;
        }
        if (string.equals("ServerNames")) {
            Set set = this._ServerNames;
            this._ServerNames = (Set)object;
            this._postSet(9, set, this._ServerNames);
            return;
        }
        if (string.equals("ServiceType")) {
            String string4 = this._ServiceType;
            this._ServiceType = (String)object;
            this._postSet(21, string4, this._ServiceType);
            return;
        }
        if (string.equals("Store")) {
            PersistentStoreMBean persistentStoreMBean = this._Store;
            this._Store = (PersistentStoreMBean)object;
            this._postSet(10, persistentStoreMBean, this._Store);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("WindowInterval")) {
            long l = this._WindowInterval;
            this._WindowInterval = (Long)object;
            this._postSet(32, l, this._WindowInterval);
            return;
        }
        if (string.equals("WindowSize")) {
            int n = this._WindowSize;
            this._WindowSize = (Integer)object;
            this._postSet(22, n, this._WindowSize);
            return;
        }
        if (string.equals("customizer")) {
            SAFAgent sAFAgent = this._customizer;
            this._customizer = (SAFAgent)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AcknowledgeInterval")) {
            return new Long(this._AcknowledgeInterval);
        }
        if (string.equals("BytesMaximum")) {
            return new Long(this._BytesMaximum);
        }
        if (string.equals("BytesThresholdHigh")) {
            return new Long(this._BytesThresholdHigh);
        }
        if (string.equals("BytesThresholdLow")) {
            return new Long(this._BytesThresholdLow);
        }
        if (string.equals("ConversationIdleTimeMaximum")) {
            return new Long(this._ConversationIdleTimeMaximum);
        }
        if (string.equals("DefaultRetryDelayBase")) {
            return new Long(this._DefaultRetryDelayBase);
        }
        if (string.equals("DefaultRetryDelayMaximum")) {
            return new Long(this._DefaultRetryDelayMaximum);
        }
        if (string.equals("DefaultRetryDelayMultiplier")) {
            return new Double(this._DefaultRetryDelayMultiplier);
        }
        if (string.equals("DefaultTimeToLive")) {
            return new Long(this._DefaultTimeToLive);
        }
        if (string.equals("ForwardingPausedAtStartup")) {
            return new Boolean(this._ForwardingPausedAtStartup);
        }
        if (string.equals("IncomingPausedAtStartup")) {
            return new Boolean(this._IncomingPausedAtStartup);
        }
        if (string.equals("JMSSAFMessageLogFile")) {
            return this._JMSSAFMessageLogFile;
        }
        if (string.equals("LoggingEnabled")) {
            return new Boolean(this._LoggingEnabled);
        }
        if (string.equals("MaximumMessageSize")) {
            return new Integer(this._MaximumMessageSize);
        }
        if (string.equals("MessageBufferSize")) {
            return new Long(this._MessageBufferSize);
        }
        if (string.equals("MessagesMaximum")) {
            return new Long(this._MessagesMaximum);
        }
        if (string.equals("MessagesThresholdHigh")) {
            return new Long(this._MessagesThresholdHigh);
        }
        if (string.equals("MessagesThresholdLow")) {
            return new Long(this._MessagesThresholdLow);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PagingDirectory")) {
            return this._PagingDirectory;
        }
        if (string.equals("ReceivingPausedAtStartup")) {
            return new Boolean(this._ReceivingPausedAtStartup);
        }
        if (string.equals("ServerNames")) {
            return this._ServerNames;
        }
        if (string.equals("ServiceType")) {
            return this._ServiceType;
        }
        if (string.equals("Store")) {
            return this._Store;
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("WindowInterval")) {
            return new Long(this._WindowInterval);
        }
        if (string.equals("WindowSize")) {
            return new Integer(this._WindowSize);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (string.equals("acknowledge-interval")) {
                        return 25;
                    }
                    if (string.equals("bytes-threshold-high")) {
                        return 12;
                    }
                    if (string.equals("default-time-to-live")) {
                        return 26;
                    }
                    if (!string.equals("maximum-message-size")) break;
                    return 17;
                }
                case 13: {
                    if (!string.equals("bytes-maximum")) break;
                    return 11;
                }
                case 19: {
                    if (string.equals("bytes-threshold-low")) {
                        return 13;
                    }
                    if (!string.equals("message-buffer-size")) break;
                    return 30;
                }
                case 30: {
                    if (string.equals("conversation-idle-time-maximum")) {
                        return 24;
                    }
                    if (!string.equals("default-retry-delay-multiplier")) break;
                    return 20;
                }
                case 24: {
                    if (string.equals("default-retry-delay-base")) {
                        return 18;
                    }
                    if (!string.equals("jms-saf-message-log-file")) break;
                    return 33;
                }
                case 27: {
                    if (string.equals("default-retry-delay-maximum")) {
                        return 19;
                    }
                    if (!string.equals("receiving-paused-at-startup")) break;
                    return 29;
                }
                case 16: {
                    if (string.equals("messages-maximum")) {
                        return 14;
                    }
                    if (!string.equals("paging-directory")) break;
                    return 31;
                }
                case 23: {
                    if (!string.equals("messages-threshold-high")) break;
                    return 15;
                }
                case 22: {
                    if (!string.equals("messages-threshold-low")) break;
                    return 16;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 12: {
                    if (string.equals("server-names")) {
                        return 9;
                    }
                    if (!string.equals("service-type")) break;
                    return 21;
                }
                case 5: {
                    if (!string.equals("store")) break;
                    return 10;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 15: {
                    if (string.equals("window-interval")) {
                        return 32;
                    }
                    if (!string.equals("logging-enabled")) break;
                    return 23;
                }
                case 11: {
                    if (!string.equals("window-size")) break;
                    return 22;
                }
                case 28: {
                    if (!string.equals("forwarding-paused-at-startup")) break;
                    return 28;
                }
                case 26: {
                    if (!string.equals("incoming-paused-at-startup")) break;
                    return 27;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 33: {
                    return new JMSSAFMessageLogFileMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 25: {
                    return "acknowledge-interval";
                }
                case 11: {
                    return "bytes-maximum";
                }
                case 12: {
                    return "bytes-threshold-high";
                }
                case 13: {
                    return "bytes-threshold-low";
                }
                case 24: {
                    return "conversation-idle-time-maximum";
                }
                case 18: {
                    return "default-retry-delay-base";
                }
                case 19: {
                    return "default-retry-delay-maximum";
                }
                case 20: {
                    return "default-retry-delay-multiplier";
                }
                case 26: {
                    return "default-time-to-live";
                }
                case 33: {
                    return "jms-saf-message-log-file";
                }
                case 17: {
                    return "maximum-message-size";
                }
                case 30: {
                    return "message-buffer-size";
                }
                case 14: {
                    return "messages-maximum";
                }
                case 15: {
                    return "messages-threshold-high";
                }
                case 16: {
                    return "messages-threshold-low";
                }
                case 2: {
                    return "name";
                }
                case 31: {
                    return "paging-directory";
                }
                case 9: {
                    return "server-names";
                }
                case 21: {
                    return "service-type";
                }
                case 10: {
                    return "store";
                }
                case 7: {
                    return "target";
                }
                case 32: {
                    return "window-interval";
                }
                case 22: {
                    return "window-size";
                }
                case 28: {
                    return "forwarding-paused-at-startup";
                }
                case 27: {
                    return "incoming-paused-at-startup";
                }
                case 23: {
                    return "logging-enabled";
                }
                case 29: {
                    return "receiving-paused-at-startup";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 33: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private SAFAgentMBeanImpl bean;

        protected Helper(SAFAgentMBeanImpl sAFAgentMBeanImpl) {
            super(sAFAgentMBeanImpl);
            this.bean = sAFAgentMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 25: {
                    return "AcknowledgeInterval";
                }
                case 11: {
                    return "BytesMaximum";
                }
                case 12: {
                    return "BytesThresholdHigh";
                }
                case 13: {
                    return "BytesThresholdLow";
                }
                case 24: {
                    return "ConversationIdleTimeMaximum";
                }
                case 18: {
                    return "DefaultRetryDelayBase";
                }
                case 19: {
                    return "DefaultRetryDelayMaximum";
                }
                case 20: {
                    return "DefaultRetryDelayMultiplier";
                }
                case 26: {
                    return "DefaultTimeToLive";
                }
                case 33: {
                    return "JMSSAFMessageLogFile";
                }
                case 17: {
                    return "MaximumMessageSize";
                }
                case 30: {
                    return "MessageBufferSize";
                }
                case 14: {
                    return "MessagesMaximum";
                }
                case 15: {
                    return "MessagesThresholdHigh";
                }
                case 16: {
                    return "MessagesThresholdLow";
                }
                case 2: {
                    return "Name";
                }
                case 31: {
                    return "PagingDirectory";
                }
                case 9: {
                    return "ServerNames";
                }
                case 21: {
                    return "ServiceType";
                }
                case 10: {
                    return "Store";
                }
                case 7: {
                    return "Targets";
                }
                case 32: {
                    return "WindowInterval";
                }
                case 22: {
                    return "WindowSize";
                }
                case 28: {
                    return "ForwardingPausedAtStartup";
                }
                case 27: {
                    return "IncomingPausedAtStartup";
                }
                case 23: {
                    return "LoggingEnabled";
                }
                case 29: {
                    return "ReceivingPausedAtStartup";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AcknowledgeInterval")) {
                return 25;
            }
            if (string.equals("BytesMaximum")) {
                return 11;
            }
            if (string.equals("BytesThresholdHigh")) {
                return 12;
            }
            if (string.equals("BytesThresholdLow")) {
                return 13;
            }
            if (string.equals("ConversationIdleTimeMaximum")) {
                return 24;
            }
            if (string.equals("DefaultRetryDelayBase")) {
                return 18;
            }
            if (string.equals("DefaultRetryDelayMaximum")) {
                return 19;
            }
            if (string.equals("DefaultRetryDelayMultiplier")) {
                return 20;
            }
            if (string.equals("DefaultTimeToLive")) {
                return 26;
            }
            if (string.equals("JMSSAFMessageLogFile")) {
                return 33;
            }
            if (string.equals("MaximumMessageSize")) {
                return 17;
            }
            if (string.equals("MessageBufferSize")) {
                return 30;
            }
            if (string.equals("MessagesMaximum")) {
                return 14;
            }
            if (string.equals("MessagesThresholdHigh")) {
                return 15;
            }
            if (string.equals("MessagesThresholdLow")) {
                return 16;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PagingDirectory")) {
                return 31;
            }
            if (string.equals("ServerNames")) {
                return 9;
            }
            if (string.equals("ServiceType")) {
                return 21;
            }
            if (string.equals("Store")) {
                return 10;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("WindowInterval")) {
                return 32;
            }
            if (string.equals("WindowSize")) {
                return 22;
            }
            if (string.equals("ForwardingPausedAtStartup")) {
                return 28;
            }
            if (string.equals("IncomingPausedAtStartup")) {
                return 27;
            }
            if (string.equals("LoggingEnabled")) {
                return 23;
            }
            if (string.equals("ReceivingPausedAtStartup")) {
                return 29;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getJMSSAFMessageLogFile() != null) {
                arrayList.add(new ArrayIterator((Object[])new JMSSAFMessageLogFileMBean[]{this.bean.getJMSSAFMessageLogFile()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAcknowledgeIntervalSet()) {
                    stringBuffer.append("AcknowledgeInterval");
                    stringBuffer.append(String.valueOf(this.bean.getAcknowledgeInterval()));
                }
                if (this.bean.isBytesMaximumSet()) {
                    stringBuffer.append("BytesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getBytesMaximum()));
                }
                if (this.bean.isBytesThresholdHighSet()) {
                    stringBuffer.append("BytesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdHigh()));
                }
                if (this.bean.isBytesThresholdLowSet()) {
                    stringBuffer.append("BytesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdLow()));
                }
                if (this.bean.isConversationIdleTimeMaximumSet()) {
                    stringBuffer.append("ConversationIdleTimeMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getConversationIdleTimeMaximum()));
                }
                if (this.bean.isDefaultRetryDelayBaseSet()) {
                    stringBuffer.append("DefaultRetryDelayBase");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultRetryDelayBase()));
                }
                if (this.bean.isDefaultRetryDelayMaximumSet()) {
                    stringBuffer.append("DefaultRetryDelayMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultRetryDelayMaximum()));
                }
                if (this.bean.isDefaultRetryDelayMultiplierSet()) {
                    stringBuffer.append("DefaultRetryDelayMultiplier");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultRetryDelayMultiplier()));
                }
                if (this.bean.isDefaultTimeToLiveSet()) {
                    stringBuffer.append("DefaultTimeToLive");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultTimeToLive()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getJMSSAFMessageLogFile())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isMaximumMessageSizeSet()) {
                    stringBuffer.append("MaximumMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumMessageSize()));
                }
                if (this.bean.isMessageBufferSizeSet()) {
                    stringBuffer.append("MessageBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getMessageBufferSize()));
                }
                if (this.bean.isMessagesMaximumSet()) {
                    stringBuffer.append("MessagesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesMaximum()));
                }
                if (this.bean.isMessagesThresholdHighSet()) {
                    stringBuffer.append("MessagesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdHigh()));
                }
                if (this.bean.isMessagesThresholdLowSet()) {
                    stringBuffer.append("MessagesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdLow()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPagingDirectorySet()) {
                    stringBuffer.append("PagingDirectory");
                    stringBuffer.append(String.valueOf(this.bean.getPagingDirectory()));
                }
                if (this.bean.isServerNamesSet()) {
                    stringBuffer.append("ServerNames");
                    stringBuffer.append(String.valueOf(this.bean.getServerNames()));
                }
                if (this.bean.isServiceTypeSet()) {
                    stringBuffer.append("ServiceType");
                    stringBuffer.append(String.valueOf(this.bean.getServiceType()));
                }
                if (this.bean.isStoreSet()) {
                    stringBuffer.append("Store");
                    stringBuffer.append(String.valueOf(this.bean.getStore()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isWindowIntervalSet()) {
                    stringBuffer.append("WindowInterval");
                    stringBuffer.append(String.valueOf(this.bean.getWindowInterval()));
                }
                if (this.bean.isWindowSizeSet()) {
                    stringBuffer.append("WindowSize");
                    stringBuffer.append(String.valueOf(this.bean.getWindowSize()));
                }
                if (this.bean.isForwardingPausedAtStartupSet()) {
                    stringBuffer.append("ForwardingPausedAtStartup");
                    stringBuffer.append(String.valueOf(this.bean.isForwardingPausedAtStartup()));
                }
                if (this.bean.isIncomingPausedAtStartupSet()) {
                    stringBuffer.append("IncomingPausedAtStartup");
                    stringBuffer.append(String.valueOf(this.bean.isIncomingPausedAtStartup()));
                }
                if (this.bean.isLoggingEnabledSet()) {
                    stringBuffer.append("LoggingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLoggingEnabled()));
                }
                if (this.bean.isReceivingPausedAtStartupSet()) {
                    stringBuffer.append("ReceivingPausedAtStartup");
                    stringBuffer.append(String.valueOf(this.bean.isReceivingPausedAtStartup()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SAFAgentMBeanImpl sAFAgentMBeanImpl = (SAFAgentMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AcknowledgeInterval", this.bean.getAcknowledgeInterval(), sAFAgentMBeanImpl.getAcknowledgeInterval(), true);
                this.computeDiff("BytesMaximum", this.bean.getBytesMaximum(), sAFAgentMBeanImpl.getBytesMaximum(), true);
                this.computeDiff("BytesThresholdHigh", this.bean.getBytesThresholdHigh(), sAFAgentMBeanImpl.getBytesThresholdHigh(), true);
                this.computeDiff("BytesThresholdLow", this.bean.getBytesThresholdLow(), sAFAgentMBeanImpl.getBytesThresholdLow(), true);
                this.computeDiff("ConversationIdleTimeMaximum", this.bean.getConversationIdleTimeMaximum(), sAFAgentMBeanImpl.getConversationIdleTimeMaximum(), true);
                this.computeDiff("DefaultRetryDelayBase", this.bean.getDefaultRetryDelayBase(), sAFAgentMBeanImpl.getDefaultRetryDelayBase(), true);
                this.computeDiff("DefaultRetryDelayMaximum", this.bean.getDefaultRetryDelayMaximum(), sAFAgentMBeanImpl.getDefaultRetryDelayMaximum(), true);
                this.computeDiff("DefaultRetryDelayMultiplier", this.bean.getDefaultRetryDelayMultiplier(), sAFAgentMBeanImpl.getDefaultRetryDelayMultiplier(), true);
                this.computeDiff("DefaultTimeToLive", this.bean.getDefaultTimeToLive(), sAFAgentMBeanImpl.getDefaultTimeToLive(), true);
                this.computeSubDiff("JMSSAFMessageLogFile", this.bean.getJMSSAFMessageLogFile(), sAFAgentMBeanImpl.getJMSSAFMessageLogFile());
                this.computeDiff("MaximumMessageSize", this.bean.getMaximumMessageSize(), sAFAgentMBeanImpl.getMaximumMessageSize(), true);
                this.computeDiff("MessageBufferSize", this.bean.getMessageBufferSize(), sAFAgentMBeanImpl.getMessageBufferSize(), true);
                this.computeDiff("MessagesMaximum", this.bean.getMessagesMaximum(), sAFAgentMBeanImpl.getMessagesMaximum(), true);
                this.computeDiff("MessagesThresholdHigh", this.bean.getMessagesThresholdHigh(), sAFAgentMBeanImpl.getMessagesThresholdHigh(), true);
                this.computeDiff("MessagesThresholdLow", this.bean.getMessagesThresholdLow(), sAFAgentMBeanImpl.getMessagesThresholdLow(), true);
                this.computeDiff("Name", this.bean.getName(), sAFAgentMBeanImpl.getName(), false);
                this.computeDiff("PagingDirectory", this.bean.getPagingDirectory(), sAFAgentMBeanImpl.getPagingDirectory(), false);
                this.computeDiff("ServiceType", this.bean.getServiceType(), sAFAgentMBeanImpl.getServiceType(), false);
                this.computeDiff("Store", this.bean.getStore(), sAFAgentMBeanImpl.getStore(), false);
                this.computeDiff("Targets", this.bean.getTargets(), sAFAgentMBeanImpl.getTargets(), true);
                this.computeDiff("WindowInterval", this.bean.getWindowInterval(), sAFAgentMBeanImpl.getWindowInterval(), true);
                this.computeDiff("WindowSize", this.bean.getWindowSize(), sAFAgentMBeanImpl.getWindowSize(), true);
                this.computeDiff("ForwardingPausedAtStartup", this.bean.isForwardingPausedAtStartup(), sAFAgentMBeanImpl.isForwardingPausedAtStartup(), false);
                this.computeDiff("IncomingPausedAtStartup", this.bean.isIncomingPausedAtStartup(), sAFAgentMBeanImpl.isIncomingPausedAtStartup(), false);
                this.computeDiff("LoggingEnabled", this.bean.isLoggingEnabled(), sAFAgentMBeanImpl.isLoggingEnabled(), true);
                this.computeDiff("ReceivingPausedAtStartup", this.bean.isReceivingPausedAtStartup(), sAFAgentMBeanImpl.isReceivingPausedAtStartup(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SAFAgentMBeanImpl sAFAgentMBeanImpl = (SAFAgentMBeanImpl)beanUpdateEvent.getSourceBean();
                SAFAgentMBeanImpl sAFAgentMBeanImpl2 = (SAFAgentMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AcknowledgeInterval")) {
                    sAFAgentMBeanImpl.setAcknowledgeInterval(sAFAgentMBeanImpl2.getAcknowledgeInterval());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("BytesMaximum")) {
                    sAFAgentMBeanImpl.setBytesMaximum(sAFAgentMBeanImpl2.getBytesMaximum());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("BytesThresholdHigh")) {
                    sAFAgentMBeanImpl.setBytesThresholdHigh(sAFAgentMBeanImpl2.getBytesThresholdHigh());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("BytesThresholdLow")) {
                    sAFAgentMBeanImpl.setBytesThresholdLow(sAFAgentMBeanImpl2.getBytesThresholdLow());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("ConversationIdleTimeMaximum")) {
                    sAFAgentMBeanImpl.setConversationIdleTimeMaximum(sAFAgentMBeanImpl2.getConversationIdleTimeMaximum());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("DefaultRetryDelayBase")) {
                    sAFAgentMBeanImpl.setDefaultRetryDelayBase(sAFAgentMBeanImpl2.getDefaultRetryDelayBase());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("DefaultRetryDelayMaximum")) {
                    sAFAgentMBeanImpl.setDefaultRetryDelayMaximum(sAFAgentMBeanImpl2.getDefaultRetryDelayMaximum());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("DefaultRetryDelayMultiplier")) {
                    sAFAgentMBeanImpl.setDefaultRetryDelayMultiplier(sAFAgentMBeanImpl2.getDefaultRetryDelayMultiplier());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("DefaultTimeToLive")) {
                    sAFAgentMBeanImpl.setDefaultTimeToLive(sAFAgentMBeanImpl2.getDefaultTimeToLive());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("JMSSAFMessageLogFile")) {
                    if (n == 2) {
                        sAFAgentMBeanImpl.setJMSSAFMessageLogFile((JMSSAFMessageLogFileMBean)this.createCopy((AbstractDescriptorBean)sAFAgentMBeanImpl2.getJMSSAFMessageLogFile()));
                    } else if (n == 3) {
                        sAFAgentMBeanImpl._destroySingleton("JMSSAFMessageLogFile", sAFAgentMBeanImpl.getJMSSAFMessageLogFile());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                } else if (string.equals("MaximumMessageSize")) {
                    sAFAgentMBeanImpl.setMaximumMessageSize(sAFAgentMBeanImpl2.getMaximumMessageSize());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("MessageBufferSize")) {
                    sAFAgentMBeanImpl.setMessageBufferSize(sAFAgentMBeanImpl2.getMessageBufferSize());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("MessagesMaximum")) {
                    sAFAgentMBeanImpl.setMessagesMaximum(sAFAgentMBeanImpl2.getMessagesMaximum());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("MessagesThresholdHigh")) {
                    sAFAgentMBeanImpl.setMessagesThresholdHigh(sAFAgentMBeanImpl2.getMessagesThresholdHigh());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("MessagesThresholdLow")) {
                    sAFAgentMBeanImpl.setMessagesThresholdLow(sAFAgentMBeanImpl2.getMessagesThresholdLow());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("Name")) {
                    sAFAgentMBeanImpl.setName(sAFAgentMBeanImpl2.getName());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("PagingDirectory")) {
                    sAFAgentMBeanImpl.setPagingDirectory(sAFAgentMBeanImpl2.getPagingDirectory());
                    sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else if (!string.equals("ServerNames")) {
                    if (string.equals("ServiceType")) {
                        sAFAgentMBeanImpl.setServiceType(sAFAgentMBeanImpl2.getServiceType());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("Store")) {
                        sAFAgentMBeanImpl.setStoreAsString(sAFAgentMBeanImpl2.getStoreAsString());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("Targets")) {
                        sAFAgentMBeanImpl.setTargetsAsString(sAFAgentMBeanImpl2.getTargetsAsString());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("WindowInterval")) {
                        sAFAgentMBeanImpl.setWindowInterval(sAFAgentMBeanImpl2.getWindowInterval());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                    } else if (string.equals("WindowSize")) {
                        sAFAgentMBeanImpl.setWindowSize(sAFAgentMBeanImpl2.getWindowSize());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                    } else if (string.equals("ForwardingPausedAtStartup")) {
                        sAFAgentMBeanImpl.setForwardingPausedAtStartup(sAFAgentMBeanImpl2.isForwardingPausedAtStartup());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                    } else if (string.equals("IncomingPausedAtStartup")) {
                        sAFAgentMBeanImpl.setIncomingPausedAtStartup(sAFAgentMBeanImpl2.isIncomingPausedAtStartup());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                    } else if (string.equals("LoggingEnabled")) {
                        sAFAgentMBeanImpl.setLoggingEnabled(sAFAgentMBeanImpl2.isLoggingEnabled());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                    } else if (string.equals("ReceivingPausedAtStartup")) {
                        sAFAgentMBeanImpl.setReceivingPausedAtStartup(sAFAgentMBeanImpl2.isReceivingPausedAtStartup());
                        sAFAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                SAFAgentMBeanImpl sAFAgentMBeanImpl = (SAFAgentMBeanImpl)abstractDescriptorBean;
                super.finishCopy(sAFAgentMBeanImpl, bl, list);
                if ((list == null || !list.contains("AcknowledgeInterval")) && this.bean.isAcknowledgeIntervalSet()) {
                    sAFAgentMBeanImpl.setAcknowledgeInterval(this.bean.getAcknowledgeInterval());
                }
                if ((list == null || !list.contains("BytesMaximum")) && this.bean.isBytesMaximumSet()) {
                    sAFAgentMBeanImpl.setBytesMaximum(this.bean.getBytesMaximum());
                }
                if ((list == null || !list.contains("BytesThresholdHigh")) && this.bean.isBytesThresholdHighSet()) {
                    sAFAgentMBeanImpl.setBytesThresholdHigh(this.bean.getBytesThresholdHigh());
                }
                if ((list == null || !list.contains("BytesThresholdLow")) && this.bean.isBytesThresholdLowSet()) {
                    sAFAgentMBeanImpl.setBytesThresholdLow(this.bean.getBytesThresholdLow());
                }
                if ((list == null || !list.contains("ConversationIdleTimeMaximum")) && this.bean.isConversationIdleTimeMaximumSet()) {
                    sAFAgentMBeanImpl.setConversationIdleTimeMaximum(this.bean.getConversationIdleTimeMaximum());
                }
                if ((list == null || !list.contains("DefaultRetryDelayBase")) && this.bean.isDefaultRetryDelayBaseSet()) {
                    sAFAgentMBeanImpl.setDefaultRetryDelayBase(this.bean.getDefaultRetryDelayBase());
                }
                if ((list == null || !list.contains("DefaultRetryDelayMaximum")) && this.bean.isDefaultRetryDelayMaximumSet()) {
                    sAFAgentMBeanImpl.setDefaultRetryDelayMaximum(this.bean.getDefaultRetryDelayMaximum());
                }
                if ((list == null || !list.contains("DefaultRetryDelayMultiplier")) && this.bean.isDefaultRetryDelayMultiplierSet()) {
                    sAFAgentMBeanImpl.setDefaultRetryDelayMultiplier(this.bean.getDefaultRetryDelayMultiplier());
                }
                if ((list == null || !list.contains("DefaultTimeToLive")) && this.bean.isDefaultTimeToLiveSet()) {
                    sAFAgentMBeanImpl.setDefaultTimeToLive(this.bean.getDefaultTimeToLive());
                }
                if (!(list != null && list.contains("JMSSAFMessageLogFile") || !this.bean.isJMSSAFMessageLogFileSet() || sAFAgentMBeanImpl._isSet(33))) {
                    JMSSAFMessageLogFileMBean jMSSAFMessageLogFileMBean = this.bean.getJMSSAFMessageLogFile();
                    sAFAgentMBeanImpl.setJMSSAFMessageLogFile(null);
                    sAFAgentMBeanImpl.setJMSSAFMessageLogFile(jMSSAFMessageLogFileMBean == null ? null : (JMSSAFMessageLogFileMBean)this.createCopy((AbstractDescriptorBean)jMSSAFMessageLogFileMBean, bl));
                }
                if ((list == null || !list.contains("MaximumMessageSize")) && this.bean.isMaximumMessageSizeSet()) {
                    sAFAgentMBeanImpl.setMaximumMessageSize(this.bean.getMaximumMessageSize());
                }
                if ((list == null || !list.contains("MessageBufferSize")) && this.bean.isMessageBufferSizeSet()) {
                    sAFAgentMBeanImpl.setMessageBufferSize(this.bean.getMessageBufferSize());
                }
                if ((list == null || !list.contains("MessagesMaximum")) && this.bean.isMessagesMaximumSet()) {
                    sAFAgentMBeanImpl.setMessagesMaximum(this.bean.getMessagesMaximum());
                }
                if ((list == null || !list.contains("MessagesThresholdHigh")) && this.bean.isMessagesThresholdHighSet()) {
                    sAFAgentMBeanImpl.setMessagesThresholdHigh(this.bean.getMessagesThresholdHigh());
                }
                if ((list == null || !list.contains("MessagesThresholdLow")) && this.bean.isMessagesThresholdLowSet()) {
                    sAFAgentMBeanImpl.setMessagesThresholdLow(this.bean.getMessagesThresholdLow());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    sAFAgentMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PagingDirectory")) && this.bean.isPagingDirectorySet()) {
                    sAFAgentMBeanImpl.setPagingDirectory(this.bean.getPagingDirectory());
                }
                if ((list == null || !list.contains("ServiceType")) && this.bean.isServiceTypeSet()) {
                    sAFAgentMBeanImpl.setServiceType(this.bean.getServiceType());
                }
                if ((list == null || !list.contains("Store")) && this.bean.isStoreSet()) {
                    sAFAgentMBeanImpl._unSet(sAFAgentMBeanImpl, 10);
                    sAFAgentMBeanImpl.setStoreAsString(this.bean.getStoreAsString());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    sAFAgentMBeanImpl._unSet(sAFAgentMBeanImpl, 7);
                    sAFAgentMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if ((list == null || !list.contains("WindowInterval")) && this.bean.isWindowIntervalSet()) {
                    sAFAgentMBeanImpl.setWindowInterval(this.bean.getWindowInterval());
                }
                if ((list == null || !list.contains("WindowSize")) && this.bean.isWindowSizeSet()) {
                    sAFAgentMBeanImpl.setWindowSize(this.bean.getWindowSize());
                }
                if ((list == null || !list.contains("ForwardingPausedAtStartup")) && this.bean.isForwardingPausedAtStartupSet()) {
                    sAFAgentMBeanImpl.setForwardingPausedAtStartup(this.bean.isForwardingPausedAtStartup());
                }
                if ((list == null || !list.contains("IncomingPausedAtStartup")) && this.bean.isIncomingPausedAtStartupSet()) {
                    sAFAgentMBeanImpl.setIncomingPausedAtStartup(this.bean.isIncomingPausedAtStartup());
                }
                if ((list == null || !list.contains("LoggingEnabled")) && this.bean.isLoggingEnabledSet()) {
                    sAFAgentMBeanImpl.setLoggingEnabled(this.bean.isLoggingEnabled());
                }
                if ((list == null || !list.contains("ReceivingPausedAtStartup")) && this.bean.isReceivingPausedAtStartupSet()) {
                    sAFAgentMBeanImpl.setReceivingPausedAtStartup(this.bean.isReceivingPausedAtStartup());
                }
                return sAFAgentMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getJMSSAFMessageLogFile(), clazz, object);
            this.inferSubTree(this.bean.getStore(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

