/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.configuration.DeploymentMBeanImplBeanInfo;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.SAFAgentMBeanImpl;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.internal.mbean.BeanInfoHelper;

public class SAFAgentMBeanImplBeanInfo
extends DeploymentMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = SAFAgentMBean.class;

    public SAFAgentMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public SAFAgentMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = SAFAgentMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("since", "9.0.0.0");
        beanDescriptor.setValue("package", "weblogic.management.configuration");
        String string = new String("This class represents a Store-and-Forward (SAF) agent. A SAF sending agent takes care of storing messages to a persistent storage, forwarding messages to the receiving side, and re-transmitting messages when acknowledgements do not come back in time. A SAF receiving agent takes care of detecting and eliminating duplicate messages sent by the receiving agent, and deliver messages to the final endpoint.  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime. For more information, see \"Developing Manageable Applications with JMX\" on <a href=\"http://www.oracle.com/technology/products/weblogic/index.html\" shape=\"rect\">http://www.oracle.com/technology/products/weblogic/index.html</a>.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.configuration.SAFAgentMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("AcknowledgeInterval")) {
            string2 = "getAcknowledgeInterval";
            string = null;
            if (!this.readOnly) {
                string = "setAcknowledgeInterval";
            }
            propertyDescriptor = new PropertyDescriptor("AcknowledgeInterval", SAFAgentMBean.class, string2, string);
            map.put("AcknowledgeInterval", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum interval between two successive acknowledgements sent by the receiving side.</p>  <ul> <li> <p>Applies only to agents with receiving capability.</p> </li>  <li> <p>A value of <code>-1</code> specifies that there is no time limit between successive acknowledgement.</p> </li>  <li> <p>Updating <code>AcknowlegeInterval</code> causes connections starting after the update to use the new value.</p> </li> </ul> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("BytesMaximum")) {
            string2 = "getBytesMaximum";
            string = null;
            if (!this.readOnly) {
                string = "setBytesMaximum";
            }
            propertyDescriptor = new PropertyDescriptor("BytesMaximum", SAFAgentMBean.class, string2, string);
            map.put("BytesMaximum", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum bytes quota (total amount of bytes) that can be stored in this SAF agent.</p>  <ul> <li> <p>The default value of <code>-1</code> specifies that there is no WebLogic-imposed limit on the number of bytes that can be stored. However, excessive bytes volume can cause memory saturation, so this value should correspond to the total amount of available system memory relative to the rest of your application load.</p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>BytesMaximum</code> affects only new requests.</p> </li> </ul>  <p><b>Range of Values:</b> &gt;= BytesThresholdHigh</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("BytesThresholdHigh")) {
            string2 = "getBytesThresholdHigh";
            string = null;
            if (!this.readOnly) {
                string = "setBytesThresholdHigh";
            }
            propertyDescriptor = new PropertyDescriptor("BytesThresholdHigh", SAFAgentMBean.class, string2, string);
            map.put("BytesThresholdHigh", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The upper threshold value that triggers events based on the number of bytes stored in the SAF agent.</p>  <ul> <li> <p>The default value of <code>-1</code>  disables the events for this SAF agent. </p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>BytesThresholdHigh</code> affects only new requests.</p> </li>  <li> <p>If the number of bytes exceeds this threshold, the triggered events are:</p>  <ul> <li><p><b>Log Messages</b>: A message is logged on the server indicating a high threshold condition.</p> </li>  <li><p><b>Flow Control</b>: The agent becomes armed and instructs producers to begin decreasing their message flow.</p> </li> </ul> </li> </ul>  <p><b>Range of Values:</b> &lt;= BytesMaximum; &gt;= BytesThresholdLow</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("BytesThresholdLow")) {
            string2 = "getBytesThresholdLow";
            string = null;
            if (!this.readOnly) {
                string = "setBytesThresholdLow";
            }
            propertyDescriptor = new PropertyDescriptor("BytesThresholdLow", SAFAgentMBean.class, string2, string);
            map.put("BytesThresholdLow", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The lower threshold that triggers events based on the number of bytes stored in the SAF agent.</p>  <ul> <li> <p>The default value of <code>-1</code>  disables the events for this SAF agent. </p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>BytesThresholdLow</code> affects only new requests.</p> </li>  <li> <p>If the number of bytes falls below this threshold, the triggered events are:</p>  <ul> <li><p><b>Log Messages</b>: A message is logged on the server indicating that the threshold condition has cleared.</p> </li>  <li><p><b>Flow Control</b>: The agent becomes disarmed and instructs producers to begin increasing their message flow.</p> </li> </ul> </li> </ul>  <p><b>Range of Values:</b> &lt;= BytesThresholdHigh</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ConversationIdleTimeMaximum")) {
            string2 = "getConversationIdleTimeMaximum";
            string = null;
            if (!this.readOnly) {
                string = "setConversationIdleTimeMaximum";
            }
            propertyDescriptor = new PropertyDescriptor("ConversationIdleTimeMaximum", SAFAgentMBean.class, string2, string);
            map.put("ConversationIdleTimeMaximum", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum amount of time allowed before a sending side releases the resources used by a conversation.</p>  <ul> <li> <p>If there is no activity for a conversation for the specified amount of time, the sending agent releases all resources for that conversation and notifies the receiving agent to do the same.</p> </li>  <li> <p>A value of <code>0</code> specifies that resources for a conversation are not released unless the application explicitly closes the conversation.</p> </li>  <li> <p>Updating <code>ConversationIdleTimeMaximum</code> causes connections starting after the update to use the new value.</p> </li> </ul> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(0L));
            propertyDescriptor.setValue("legalMin", new Long(0L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultRetryDelayBase")) {
            string2 = "getDefaultRetryDelayBase";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultRetryDelayBase";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultRetryDelayBase", SAFAgentMBean.class, string2, string);
            map.put("DefaultRetryDelayBase", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The amount of time, in milliseconds, between the original delivery attempt and the first retry.</p>  <ul> <li> <p>If <code>RetryDelayMultiplier</code> is set to <code>1</code>, this defines the interval between any two successive retry attempts.</p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>DefaultRetryDelayBase</code> causes connections starting after the update to use the new value.</p> </li> </ul>  <p><b>Range of Values:</b> &lt;= RetryDelayMaximum if RetryDelayMultiplier is not 1.0. </p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(20000L));
            propertyDescriptor.setValue("legalMin", new Long(1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultRetryDelayMaximum")) {
            string2 = "getDefaultRetryDelayMaximum";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultRetryDelayMaximum";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultRetryDelayMaximum", SAFAgentMBean.class, string2, string);
            map.put("DefaultRetryDelayMaximum", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum amount of time, in milliseconds, between two successive delivery retry attempts.</p>  <ul> <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>DefaultRetryDelayMaximum</code> causes connections starting after the update to use the new value.</p> </li> </ul>  <p><b>Range of Values:</b> &gt; = RetryDelayBase if RetryDelayMultiplier is not 1.0. </p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(180000L));
            propertyDescriptor.setValue("legalMin", new Long(1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultRetryDelayMultiplier")) {
            string2 = "getDefaultRetryDelayMultiplier";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultRetryDelayMultiplier";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultRetryDelayMultiplier", SAFAgentMBean.class, string2, string);
            map.put("DefaultRetryDelayMultiplier", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The factor used to multiply the previous delay time to calculate the next delay time to be used.</p>  <ul> <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>DefaultRetryDelayMuliplier</code> causes connections starting after the update to use the new value.</p> </li> </ul>  <p><b>Range of Values:</b> &gt;= 1.</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Double(1.0));
            propertyDescriptor.setValue("legalMin", new Double(1.0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultTimeToLive")) {
            string2 = "getDefaultTimeToLive";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultTimeToLive";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultTimeToLive", SAFAgentMBean.class, string2, string);
            map.put("DefaultTimeToLive", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The default amount of time, in milliseconds, that the agent guarantees to reliably send messages.</p>  <ul> <li> <p>A value of 0 means the agent guarantees to reliably send messages for the duration of the conversation.</p> </li>  <li> <p>Updating <code>DefaultTimeToLive</code> causes conversations starting after the update to use the new value.</p> </li> </ul> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(0L));
            propertyDescriptor.setValue("legalMin", new Long(0L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("JMSSAFMessageLogFile")) {
            string2 = "getJMSSAFMessageLogFile";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JMSSAFMessageLogFile", SAFAgentMBean.class, string2, string);
            map.put("JMSSAFMessageLogFile", propertyDescriptor);
            propertyDescriptor.setValue("description", "The jms message log file configuration for this saf agent ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("MaximumMessageSize")) {
            string2 = "getMaximumMessageSize";
            string = null;
            if (!this.readOnly) {
                string = "setMaximumMessageSize";
            }
            propertyDescriptor = new PropertyDescriptor("MaximumMessageSize", SAFAgentMBean.class, string2, string);
            map.put("MaximumMessageSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of bytes allowed in individual messages on this SAF agent.</p>  <ul> <li> <p>The message size includes the message body, any user-defined properties, and the user-defined JMS header fields: <code>JMSCorrelationID</code> and <code>JMSType</code>.</p> </li>  <li> <p>Producers sending messages that exceed the configured maximum message size for the SAF agent will receive a <code>ResourceAllocationException</code>.</p> </li>  <li> <p>The maximum message size is only enforced for the initial production of a message. Messages that are redirected to an error destination or forwarded to a member of a distributed destination are not checked for size. For instance, if a destination and its corresponding error destination are configured with a maximum message size of 128K bytes and 64K bytes, respectively, a message of 96K bytes could be redirected to the error destination (even though it exceeds the 64K byte maximum), but a producer could not directly send the 96K byte message to the error destination.</p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>MaximumMessageSize</code> affects only incoming messages; stored messages are not affected.</p> </li> </ul> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessageBufferSize")) {
            string2 = "getMessageBufferSize";
            string = null;
            if (!this.readOnly) {
                string = "setMessageBufferSize";
            }
            propertyDescriptor = new PropertyDescriptor("MessageBufferSize", SAFAgentMBean.class, string2, string);
            map.put("MessageBufferSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The amount of memory used to store message bodies in memory before they are paged out to disk.</p> <ul> <li> <p>A value of -1 (the default) specifies that the server will automatically determine a size based on the maximum heap size of the JVM. This default will be set to either one-third the maximum heap size, or 512 megabytes, whichever is smaller.</p> </li>  <li> <p>The larger the buffer, the more memory JMS will consume when many messages are waiting on queues or topics. Once the buffer is surpassed, JMS may write message bodies to the directory specified by PagingDirectory in an effort to reduce memory usage below this buffer.</p> </li>  <li> <p>Surpassing the buffer size does not stop the JMS server from accepting new messages. It is still possible to run out of memory if messages are arriving faster than they can be written to disk. Users with high messaging loads who wish to support the highest possible availability should consider setting a quota or setting a threshold and enabling flow control.</p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Paging is always supported. </p> </li>  <li> <p>Updating the memory size resets the message count so that only requests arriving after the update are charged against the new memory size.</p> </li> </ul> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getPagingDirectory")};
            propertyDescriptor.setValue("see", stringArray);
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessagesMaximum")) {
            string2 = "getMessagesMaximum";
            string = null;
            if (!this.readOnly) {
                string = "setMessagesMaximum";
            }
            propertyDescriptor = new PropertyDescriptor("MessagesMaximum", SAFAgentMBean.class, string2, string);
            map.put("MessagesMaximum", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum message quota (total amount of messages) that can be stored in this SAF agent.</p>  <ul> <li> <p>The default value of <code>-1</code> specifies that the server instance has no limit on the number of messages that can be stored. However, excessive message volume can cause memory saturation, so this value should correspond to the total amount of available system memory relative to the rest of your application load.</p> </li>  <li> <p>Applies only to sending agents.</p> </li>  <li> <p>Updating the maximum message quota resets the message count so that only requests arriving after the update are charged against the new quota.</p> </li> </ul>  <p><b>Range of Values:</b> &gt;= MessagesThresholdHigh</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessagesThresholdHigh")) {
            string2 = "getMessagesThresholdHigh";
            string = null;
            if (!this.readOnly) {
                string = "setMessagesThresholdHigh";
            }
            propertyDescriptor = new PropertyDescriptor("MessagesThresholdHigh", SAFAgentMBean.class, string2, string);
            map.put("MessagesThresholdHigh", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The upper threshold that triggers events based on the number of messages stored in the SAF agent.</p>  <ul> <li> <p>The default value of <code>-1</code> disables the events for this SAF agent. </p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>MessagesThresholdHigh</code> affects only new requests.</p> </li>  <li> <p>If the number of messages exceeds this threshold, the triggered events are:</p>  <ul> <li><p><b>Log Messages</b>: A message is logged on the server indicating a high threshold condition.</p> </li>  <li><p><b>Flow Control</b>: The agent becomes armed and instructs producers to begin decreasing their message flow.</p> </li> </ul> </li> </ul>  <p><b>Range of Values:</b> &lt;= MessagesMaximum; &gt;= MessagesThresholdLow</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MessagesThresholdLow")) {
            string2 = "getMessagesThresholdLow";
            string = null;
            if (!this.readOnly) {
                string = "setMessagesThresholdLow";
            }
            propertyDescriptor = new PropertyDescriptor("MessagesThresholdLow", SAFAgentMBean.class, string2, string);
            map.put("MessagesThresholdLow", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The low threshold that triggers events based on the number of messages stored in the SAF agent.</p>  <ul> <li> <p>The default value of <code>-1</code> disables the events for this SAF agent. </p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li>  <li> <p>Updating <code>MessagesThresholdLow</code> affects only new requests.</p> </li>  <li> <p>If the number of messages falls below this threshold, the triggered events are:</p>  <ul> <li><p><b>Log Messages</b>: A message is logged on the server indicating that the threshold condition has cleared.</p> </li>  <li><p><b>Flow Control</b>: The agent becomes disarmed and instructs producers to begin increasing their message flow.</p> </li> </ul> </li> </ul>  <p><b>Range of Values:</b> &lt;= MessagesThresholdHigh.</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(-1L));
            propertyDescriptor.setValue("legalMin", new Long(-1L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            if (!this.readOnly) {
                string = "setName";
            }
            propertyDescriptor = new PropertyDescriptor("Name", SAFAgentMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The user-specified name of this MBean instance.</p>  <p>This name is included as one of the key properties in the MBean's <code>javax.management.ObjectName</code>:<br clear=\"none\" /> <code>Name=<i>user-specified-name</i></code></p> ");
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("key", Boolean.TRUE);
        }
        if (!map.containsKey("PagingDirectory")) {
            string2 = "getPagingDirectory";
            string = null;
            if (!this.readOnly) {
                string = "setPagingDirectory";
            }
            propertyDescriptor = new PropertyDescriptor("PagingDirectory", SAFAgentMBean.class, string2, string);
            map.put("PagingDirectory", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Specifies where message bodies are written when the size of the message bodies in the JMS server exceeds the message buffer size. If unspecified, messages are written to the <code>tmp</code> directory in the host WebLogic Server instance's directory. For example, <code><em>domainName</em>/servers/<em>servername</em>/tmp</code>. </p>  <ul> <li> <p>For best performance, this directory should not be the same as the directory used by the SAF agent's persistent store.</p> </li>  <li> <p>Applies only to agents with sending capability.</p> </li> </ul> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getMessageBufferSize")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ServiceType")) {
            string2 = "getServiceType";
            string = null;
            if (!this.readOnly) {
                string = "setServiceType";
            }
            propertyDescriptor = new PropertyDescriptor("ServiceType", SAFAgentMBean.class, string2, string);
            map.put("ServiceType", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The type of service that this SAF agent provides. JMS requires only a Sending agent on the sending side for messages. Whereas, Web Services Reliable Messaging requires both a Sending and Receiving agent for messages.</p> <ul> <li><b>Sending-only</b> Configures an agent that stores messages in persistent storage, forwards messages to the receiving side, and re-transmits messages when acknowledgements do not come back in time. <li><b>Receiving-only</b> Configures an agent that detects and eliminates duplicate messages sent by a receiving agent, and delivers messages to the final destination. <li><b>Both</b> Configures an agent that has sending and receiving agent functionality. </ul> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"Both");
            propertyDescriptor.setValue("legalValues", new Object[]{"Both", "Sending-only", "Receiving-only"});
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Store")) {
            string2 = "getStore";
            string = null;
            if (!this.readOnly) {
                string = "setStore";
            }
            propertyDescriptor = new PropertyDescriptor("Store", SAFAgentMBean.class, string2, string);
            map.put("Store", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The persistent disk-based file store or JDBC-accessible database for the SAF agent.</p>  <p>If a store is not configured, the server's default store is used.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Targets")) {
            string2 = "getTargets";
            string = null;
            if (!this.readOnly) {
                string = "setTargets";
            }
            propertyDescriptor = new PropertyDescriptor("Targets", SAFAgentMBean.class, string2, string);
            map.put("Targets", propertyDescriptor);
            propertyDescriptor.setValue("description", " ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("adder", "addTarget");
            propertyDescriptor.setValue("remover", "removeTarget");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("WindowInterval")) {
            string2 = "getWindowInterval";
            string = null;
            if (!this.readOnly) {
                string = "setWindowInterval";
            }
            propertyDescriptor = new PropertyDescriptor("WindowInterval", SAFAgentMBean.class, string2, string);
            map.put("WindowInterval", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum amount of time, in milliseconds, that a JMS sending agent waits before forwarding messages in a single batch. For a distributed queue or topic, <code>WindowInterval</code> setting is ignored.</p>  <p>A sending agent waits to forward the message batch until either: (A) the source destination message count is greater than or equal to the configured <code>Window Size</code>; (B) it has waited a specified <code>Window Interval</code>, whichever comes first.</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(0L));
            propertyDescriptor.setValue("legalMin", new Long(0L));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("WindowSize")) {
            string2 = "getWindowSize";
            string = null;
            if (!this.readOnly) {
                string = "setWindowSize";
            }
            propertyDescriptor = new PropertyDescriptor("WindowSize", SAFAgentMBean.class, string2, string);
            map.put("WindowSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>For JMS messages, the number of messages in a batch. A sending agent waits to forward a message batch until the source destination message count is greater than or equal to this value. For a distributed queue or topic, <code>WindowSize</code> setting is ignored and always internally set to 1 message.</p> <p>For WSRM, the maximum number of unacknowledged messages allowed between a source destination and a target destination during a conversation.</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ForwardingPausedAtStartup")) {
            string2 = "isForwardingPausedAtStartup";
            string = null;
            if (!this.readOnly) {
                string = "setForwardingPausedAtStartup";
            }
            propertyDescriptor = new PropertyDescriptor("ForwardingPausedAtStartup", SAFAgentMBean.class, string2, string);
            map.put("ForwardingPausedAtStartup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the agent is paused for forwarding messages at the startup time.</p>  <p>When enabled, the sending agent forwards messages. Otherwise, the sending agent does not forward any messages.</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("IncomingPausedAtStartup")) {
            string2 = "isIncomingPausedAtStartup";
            string = null;
            if (!this.readOnly) {
                string = "setIncomingPausedAtStartup";
            }
            propertyDescriptor = new PropertyDescriptor("IncomingPausedAtStartup", SAFAgentMBean.class, string2, string);
            map.put("IncomingPausedAtStartup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the agent is paused for incoming messages at startup time.</p>  <p>When enabled, the sending agent accepts new messages. Otherwise, the sending agent does not accept any new messages.</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("LoggingEnabled")) {
            string2 = "isLoggingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setLoggingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("LoggingEnabled", SAFAgentMBean.class, string2, string);
            map.put("LoggingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether a message is logged in the server log file when a message fails to be forwarded.</p>  <ul> <li> <p>If selected, this applies to messages that fail to be forwarded and delivered to the final destination when there is no error handling in a SAF application or the application's error handling fails.</p> </li>  <li> <p>Applies only to agents with receiving capability.</p> </li>  <li> <p>Updating <code>LoggingEnabled</code> causes connections starting after the update to use the new value.</p> </li> </ul> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ReceivingPausedAtStartup")) {
            string2 = "isReceivingPausedAtStartup";
            string = null;
            if (!this.readOnly) {
                string = "setReceivingPausedAtStartup";
            }
            propertyDescriptor = new PropertyDescriptor("ReceivingPausedAtStartup", SAFAgentMBean.class, string2, string);
            map.put("ReceivingPausedAtStartup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the agent is paused for receiving messages at the startup time.</p>  <p>When enabled, the sending agent receives messages. Otherwise, the sending agent does not receive any messages.</p> ");
            SAFAgentMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = SAFAgentMBean.class.getMethod("addTarget", TargetMBean.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{SAFAgentMBeanImplBeanInfo.createParameterDescriptor((String)"target", (String)"The feature to be added to the Target attribute ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>You can add a target to specify additional servers on which the deployment can be deployed. The targets must be either clusters or servers.</p> ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "Targets");
        }
        method = SAFAgentMBean.class.getMethod("removeTarget", TargetMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{SAFAgentMBeanImplBeanInfo.createParameterDescriptor((String)"target", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Removes the value of the addTarget attribute.</p> ");
            String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#addTarget")};
            methodDescriptor.setValue("see", stringArray);
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "Targets");
        }
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = SAFAgentMBean.class.getMethod("freezeCurrentValue", String.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{SAFAgentMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has not been set explicitly, and if the attribute has a default value, this operation forces the MBean to persist the default value.</p>  <p>Unless you use this operation, the default value is not saved and is subject to change if you update to a newer release of WebLogic Server. Invoking this operation isolates this MBean from the effects of such changes.</p>  <dl> <dt>Note:</dt>  <dd> <p>To insure that you are freezing the default value, invoke the <code>restoreDefaultValue</code> operation before you invoke this.</p> </dd> </dl>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute for which some other value has been set.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = SAFAgentMBean.class.getMethod("restoreDefaultValue", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{SAFAgentMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string) && !this.readOnly) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has a default value, this operation removes any value that has been set explicitly and causes the attribute to use the default value.</p>  <p>Default values are subject to change if you update to a newer release of WebLogic Server. To prevent the value from changing if you update to a newer release, invoke the <code>freezeCurrentValue</code> operation.</p>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute that is already using the default.</p> ");
            methodDescriptor.setValue("role", "operation");
            methodDescriptor.setValue("impact", "action");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

