/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPAttributeChangeMBean;
import weblogic.management.configuration.SNMPAttributeChangeMBeanImpl;
import weblogic.management.configuration.SNMPCounterMonitorMBean;
import weblogic.management.configuration.SNMPCounterMonitorMBeanImpl;
import weblogic.management.configuration.SNMPGaugeMonitorMBean;
import weblogic.management.configuration.SNMPGaugeMonitorMBeanImpl;
import weblogic.management.configuration.SNMPLogFilterMBean;
import weblogic.management.configuration.SNMPLogFilterMBeanImpl;
import weblogic.management.configuration.SNMPProxyMBean;
import weblogic.management.configuration.SNMPProxyMBeanImpl;
import weblogic.management.configuration.SNMPStringMonitorMBean;
import weblogic.management.configuration.SNMPStringMonitorMBeanImpl;
import weblogic.management.configuration.SNMPTrapDestinationMBean;
import weblogic.management.configuration.SNMPTrapDestinationMBeanImpl;
import weblogic.management.configuration.SNMPValidator;
import weblogic.management.mbeans.custom.SNMPAgent;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class SNMPAgentMBeanImpl
extends ConfigurationMBeanImpl
implements SNMPAgentMBean,
Serializable {
    private String _AuthenticationProtocol;
    private boolean _CommunityBasedAccessEnabled;
    private String _CommunityPrefix;
    private int _DebugLevel;
    private boolean _Enabled;
    private boolean _InformEnabled;
    private int _InformRetryInterval;
    private long _LocalizedKeyCacheInvalidationInterval;
    private int _MasterAgentXPort;
    private int _MaxInformRetryCount;
    private int _MibDataRefreshInterval;
    private String _Name;
    private String _PrivacyProtocol;
    private boolean _SNMPAccessForUserMBeansEnabled;
    private SNMPAttributeChangeMBean[] _SNMPAttributeChanges;
    private SNMPCounterMonitorMBean[] _SNMPCounterMonitors;
    private String _SNMPEngineId;
    private SNMPGaugeMonitorMBean[] _SNMPGaugeMonitors;
    private SNMPLogFilterMBean[] _SNMPLogFilters;
    private int _SNMPPort;
    private SNMPProxyMBean[] _SNMPProxies;
    private SNMPStringMonitorMBean[] _SNMPStringMonitors;
    private SNMPTrapDestinationMBean[] _SNMPTrapDestinations;
    private int _SNMPTrapVersion;
    private boolean _SendAutomaticTrapsEnabled;
    private int _ServerStatusCheckIntervalFactor;
    private SNMPTrapDestinationMBean[] _TargetedTrapDestinations;
    private String _UserDefinedMib;
    private SNMPAgent _customizer;
    private static SchemaHelper2 _schemaHelper;

    public SNMPAgentMBeanImpl() {
        try {
            this._customizer = new SNMPAgent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public SNMPAgentMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new SNMPAgent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isEnabled() {
        return this._Enabled;
    }

    public boolean isEnabledSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this._Enabled;
        this._Enabled = bl;
        this._postSet(7, bl2, bl);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public boolean isSendAutomaticTrapsEnabled() {
        return this._SendAutomaticTrapsEnabled;
    }

    public boolean isSendAutomaticTrapsEnabledSet() {
        return this._isSet(8);
    }

    public void setSendAutomaticTrapsEnabled(boolean bl) {
        boolean bl2 = this._SendAutomaticTrapsEnabled;
        this._SendAutomaticTrapsEnabled = bl;
        this._postSet(8, bl2, bl);
    }

    public int getSNMPPort() {
        return this._SNMPPort;
    }

    public boolean isSNMPPortSet() {
        return this._isSet(9);
    }

    public void setSNMPPort(int n) throws InvalidAttributeValueException, ConfigurationException {
        LegalChecks.checkInRange((String)"SNMPPort", (long)n, (long)1L, (long)65535L);
        int n2 = this._SNMPPort;
        this._SNMPPort = n;
        this._postSet(9, n2, n);
    }

    public int getSNMPTrapVersion() {
        return this._SNMPTrapVersion;
    }

    public boolean isSNMPTrapVersionSet() {
        return this._isSet(10);
    }

    public void setSNMPTrapVersion(int n) {
        int[] nArray = new int[]{1, 2, 3};
        n = LegalChecks.checkInEnum((String)"SNMPTrapVersion", (int)n, (int[])nArray);
        int n2 = this._SNMPTrapVersion;
        this._SNMPTrapVersion = n;
        this._postSet(10, n2, n);
    }

    public int getMibDataRefreshInterval() {
        return this._MibDataRefreshInterval;
    }

    public boolean isMibDataRefreshIntervalSet() {
        return this._isSet(11);
    }

    public void setMibDataRefreshInterval(int n) throws InvalidAttributeValueException, ConfigurationException {
        LegalChecks.checkInRange((String)"MibDataRefreshInterval", (long)n, (long)30L, (long)65535L);
        int n2 = this._MibDataRefreshInterval;
        this._MibDataRefreshInterval = n;
        this._postSet(11, n2, n);
    }

    public int getServerStatusCheckIntervalFactor() {
        return this._ServerStatusCheckIntervalFactor;
    }

    public boolean isServerStatusCheckIntervalFactorSet() {
        return this._isSet(12);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setServerStatusCheckIntervalFactor(int n) throws InvalidAttributeValueException, ConfigurationException {
        LegalChecks.checkInRange((String)"ServerStatusCheckIntervalFactor", (long)n, (long)1L, (long)65535L);
        int n2 = this._ServerStatusCheckIntervalFactor;
        this._ServerStatusCheckIntervalFactor = n;
        this._postSet(12, n2, n);
    }

    public String getCommunityPrefix() {
        return this._CommunityPrefix;
    }

    public boolean isCommunityPrefixSet() {
        return this._isSet(13);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setCommunityPrefix(String string) throws InvalidAttributeValueException, ConfigurationException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"CommunityPrefix", (String)string);
        String string2 = this._CommunityPrefix;
        this._CommunityPrefix = string;
        this._postSet(13, string2, string);
    }

    public String getUserDefinedMib() {
        return this._UserDefinedMib;
    }

    public boolean isUserDefinedMibSet() {
        return this._isSet(14);
    }

    public void setUserDefinedMib(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"UserDefinedMib", (String)string);
        String string2 = this._UserDefinedMib;
        this._UserDefinedMib = string;
        this._postSet(14, string2, string);
    }

    public int getDebugLevel() {
        return this._DebugLevel;
    }

    public boolean isDebugLevelSet() {
        return this._isSet(15);
    }

    public void setDebugLevel(int n) throws InvalidAttributeValueException, ConfigurationException {
        int[] nArray = new int[]{0, 1, 2, 3};
        n = LegalChecks.checkInEnum((String)"DebugLevel", (int)n, (int[])nArray);
        int n2 = this._DebugLevel;
        this._DebugLevel = n;
        this._postSet(15, n2, n);
    }

    public SNMPTrapDestinationMBean[] getTargetedTrapDestinations() {
        return this._TargetedTrapDestinations;
    }

    public String getTargetedTrapDestinationsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargetedTrapDestinations());
    }

    public boolean isTargetedTrapDestinationsSet() {
        return this._isSet(16);
    }

    public void setTargetedTrapDestinationsAsString(String string) {
        if (string == null || string.length() == 0) {
            SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = this._TargetedTrapDestinations;
            this._initializeProperty(16);
            this._postSet(16, sNMPTrapDestinationMBeanArray, this._TargetedTrapDestinations);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._TargetedTrapDestinations);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, SNMPTrapDestinationMBean.class, new ReferenceManager.Resolver(this, 16){

                    public void resolveReference(Object object) {
                        try {
                            SNMPAgentMBeanImpl.this.addTargetedTrapDestination((SNMPTrapDestinationMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (SNMPTrapDestinationMBean sNMPTrapDestinationMBean : this._TargetedTrapDestinations) {
                    if (!string2.equals(sNMPTrapDestinationMBean.getName())) continue;
                    try {
                        this.removeTargetedTrapDestination(sNMPTrapDestinationMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setTargetedTrapDestinations(SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray) throws InvalidAttributeValueException, ConfigurationException {
        sNMPTrapDestinationMBeanArray = sNMPTrapDestinationMBeanArray == null ? new SNMPTrapDestinationMBeanImpl[]{} : sNMPTrapDestinationMBeanArray;
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray2 = this._TargetedTrapDestinations;
        this._TargetedTrapDestinations = sNMPTrapDestinationMBeanArray;
        this._postSet(16, sNMPTrapDestinationMBeanArray2, sNMPTrapDestinationMBeanArray);
    }

    public boolean addTargetedTrapDestination(SNMPTrapDestinationMBean sNMPTrapDestinationMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)sNMPTrapDestinationMBean);
        if (!((AbstractDescriptorBean)sNMPTrapDestinationMBean).isChildProperty((DescriptorBean)this, 16)) {
            SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = this._isSet(16) ? (SNMPTrapDestinationMBean[])this._getHelper()._extendArray((Object)this.getTargetedTrapDestinations(), SNMPTrapDestinationMBean.class, (Object)sNMPTrapDestinationMBean) : new SNMPTrapDestinationMBean[]{sNMPTrapDestinationMBean};
            try {
                this.setTargetedTrapDestinations(sNMPTrapDestinationMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeTargetedTrapDestination(SNMPTrapDestinationMBean sNMPTrapDestinationMBean) throws InvalidAttributeValueException, ConfigurationException {
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = this.getTargetedTrapDestinations();
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray2 = (SNMPTrapDestinationMBean[])this._getHelper()._removeElement((Object)sNMPTrapDestinationMBeanArray, SNMPTrapDestinationMBean.class, (Object)sNMPTrapDestinationMBean);
        if (sNMPTrapDestinationMBeanArray2.length != sNMPTrapDestinationMBeanArray.length) {
            try {
                this.setTargetedTrapDestinations(sNMPTrapDestinationMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public SNMPTrapDestinationMBean createSNMPTrapDestination(String string) {
        SNMPTrapDestinationMBeanImpl sNMPTrapDestinationMBeanImpl = new SNMPTrapDestinationMBeanImpl(this, -1);
        try {
            sNMPTrapDestinationMBeanImpl.setName(string);
            this.addSNMPTrapDestination(sNMPTrapDestinationMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return sNMPTrapDestinationMBeanImpl;
    }

    public SNMPTrapDestinationMBean createSNMPTrapDestination(String string, SNMPTrapDestinationMBean sNMPTrapDestinationMBean) {
        return this._customizer.createSNMPTrapDestination(string, sNMPTrapDestinationMBean);
    }

    public void destroySNMPTrapDestination(SNMPTrapDestinationMBean sNMPTrapDestinationMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(sNMPTrapDestinationMBean, 17);
                SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = this.getSNMPTrapDestinations();
                SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray2 = (SNMPTrapDestinationMBean[])this._getHelper()._removeElement((Object)sNMPTrapDestinationMBeanArray, SNMPTrapDestinationMBean.class, (Object)sNMPTrapDestinationMBean);
                if (sNMPTrapDestinationMBeanArray.length == sNMPTrapDestinationMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)sNMPTrapDestinationMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPTrapDestinationMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSNMPTrapDestinations(sNMPTrapDestinationMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public SNMPTrapDestinationMBean lookupSNMPTrapDestination(String string) {
        for (SNMPTrapDestinationMBeanImpl sNMPTrapDestinationMBeanImpl : Arrays.asList((Object[])this._SNMPTrapDestinations)) {
            String string2 = string;
            if (!sNMPTrapDestinationMBeanImpl.getName().equals(string2)) continue;
            return sNMPTrapDestinationMBeanImpl;
        }
        return null;
    }

    public SNMPTrapDestinationMBean[] getSNMPTrapDestinations() {
        return this._SNMPTrapDestinations;
    }

    public boolean isSNMPTrapDestinationsSet() {
        return this._isSet(17);
    }

    public void removeSNMPTrapDestination(SNMPTrapDestinationMBean sNMPTrapDestinationMBean) {
        this.destroySNMPTrapDestination(sNMPTrapDestinationMBean);
    }

    public void setSNMPTrapDestinations(SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray) throws InvalidAttributeValueException {
        sNMPTrapDestinationMBeanArray = sNMPTrapDestinationMBeanArray == null ? new SNMPTrapDestinationMBeanImpl[]{} : sNMPTrapDestinationMBeanArray;
        for (int i = 0; i < sNMPTrapDestinationMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPTrapDestinationMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 17)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray2 = this._SNMPTrapDestinations;
        this._SNMPTrapDestinations = sNMPTrapDestinationMBeanArray;
        this._postSet(17, sNMPTrapDestinationMBeanArray2, sNMPTrapDestinationMBeanArray);
    }

    public boolean addSNMPTrapDestination(SNMPTrapDestinationMBean sNMPTrapDestinationMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)sNMPTrapDestinationMBean);
        if (!((AbstractDescriptorBean)sNMPTrapDestinationMBean).isChildProperty((DescriptorBean)this, 17)) {
            SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = this._isSet(17) ? (SNMPTrapDestinationMBean[])this._getHelper()._extendArray((Object)this.getSNMPTrapDestinations(), SNMPTrapDestinationMBean.class, (Object)sNMPTrapDestinationMBean) : new SNMPTrapDestinationMBean[]{sNMPTrapDestinationMBean};
            try {
                this.setSNMPTrapDestinations(sNMPTrapDestinationMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public SNMPProxyMBean[] getSNMPProxies() {
        return this._SNMPProxies;
    }

    public boolean isSNMPProxiesSet() {
        return this._isSet(18);
    }

    public void setSNMPProxies(SNMPProxyMBean[] sNMPProxyMBeanArray) throws InvalidAttributeValueException, ConfigurationException {
        sNMPProxyMBeanArray = sNMPProxyMBeanArray == null ? new SNMPProxyMBeanImpl[]{} : sNMPProxyMBeanArray;
        for (int i = 0; i < sNMPProxyMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPProxyMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 18)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        SNMPProxyMBean[] sNMPProxyMBeanArray2 = this._SNMPProxies;
        this._SNMPProxies = sNMPProxyMBeanArray;
        this._postSet(18, sNMPProxyMBeanArray2, sNMPProxyMBeanArray);
    }

    public boolean addSNMPProxy(SNMPProxyMBean sNMPProxyMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)sNMPProxyMBean);
        if (!((AbstractDescriptorBean)sNMPProxyMBean).isChildProperty((DescriptorBean)this, 18)) {
            SNMPProxyMBean[] sNMPProxyMBeanArray = this._isSet(18) ? (SNMPProxyMBean[])this._getHelper()._extendArray((Object)this.getSNMPProxies(), SNMPProxyMBean.class, (Object)sNMPProxyMBean) : new SNMPProxyMBean[]{sNMPProxyMBean};
            try {
                this.setSNMPProxies(sNMPProxyMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeSNMPProxy(SNMPProxyMBean sNMPProxyMBean) throws InvalidAttributeValueException, ConfigurationException {
        this.destroySNMPProxy(sNMPProxyMBean);
        return true;
    }

    public SNMPProxyMBean createSNMPProxy(String string) {
        SNMPProxyMBeanImpl sNMPProxyMBeanImpl = new SNMPProxyMBeanImpl(this, -1);
        try {
            sNMPProxyMBeanImpl.setName(string);
            this.addSNMPProxy(sNMPProxyMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return sNMPProxyMBeanImpl;
    }

    public SNMPProxyMBean createSNMPProxy(String string, SNMPProxyMBean sNMPProxyMBean) {
        return this._customizer.createSNMPProxy(string, sNMPProxyMBean);
    }

    public void destroySNMPProxy(SNMPProxyMBean sNMPProxyMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(sNMPProxyMBean, 18);
                SNMPProxyMBean[] sNMPProxyMBeanArray = this.getSNMPProxies();
                SNMPProxyMBean[] sNMPProxyMBeanArray2 = (SNMPProxyMBean[])this._getHelper()._removeElement((Object)sNMPProxyMBeanArray, SNMPProxyMBean.class, (Object)sNMPProxyMBean);
                if (sNMPProxyMBeanArray.length == sNMPProxyMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)sNMPProxyMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPProxyMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSNMPProxies(sNMPProxyMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public SNMPProxyMBean lookupSNMPProxy(String string) {
        for (SNMPProxyMBeanImpl sNMPProxyMBeanImpl : Arrays.asList((Object[])this._SNMPProxies)) {
            String string2 = string;
            if (!sNMPProxyMBeanImpl.getName().equals(string2)) continue;
            return sNMPProxyMBeanImpl;
        }
        return null;
    }

    public SNMPGaugeMonitorMBean[] getSNMPGaugeMonitors() {
        return this._SNMPGaugeMonitors;
    }

    public boolean isSNMPGaugeMonitorsSet() {
        return this._isSet(19);
    }

    public void setSNMPGaugeMonitors(SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray) throws InvalidAttributeValueException, ConfigurationException {
        sNMPGaugeMonitorMBeanArray = sNMPGaugeMonitorMBeanArray == null ? new SNMPGaugeMonitorMBeanImpl[]{} : sNMPGaugeMonitorMBeanArray;
        for (int i = 0; i < sNMPGaugeMonitorMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPGaugeMonitorMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 19)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray2 = this._SNMPGaugeMonitors;
        this._SNMPGaugeMonitors = sNMPGaugeMonitorMBeanArray;
        this._postSet(19, sNMPGaugeMonitorMBeanArray2, sNMPGaugeMonitorMBeanArray);
    }

    public boolean addSNMPGaugeMonitor(SNMPGaugeMonitorMBean sNMPGaugeMonitorMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)sNMPGaugeMonitorMBean);
        if (!((AbstractDescriptorBean)sNMPGaugeMonitorMBean).isChildProperty((DescriptorBean)this, 19)) {
            SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray = this._isSet(19) ? (SNMPGaugeMonitorMBean[])this._getHelper()._extendArray((Object)this.getSNMPGaugeMonitors(), SNMPGaugeMonitorMBean.class, (Object)sNMPGaugeMonitorMBean) : new SNMPGaugeMonitorMBean[]{sNMPGaugeMonitorMBean};
            try {
                this.setSNMPGaugeMonitors(sNMPGaugeMonitorMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeSNMPGaugeMonitor(SNMPGaugeMonitorMBean sNMPGaugeMonitorMBean) throws InvalidAttributeValueException, ConfigurationException {
        this.destroySNMPGaugeMonitor(sNMPGaugeMonitorMBean);
        return true;
    }

    public SNMPGaugeMonitorMBean createSNMPGaugeMonitor(String string) {
        SNMPGaugeMonitorMBeanImpl sNMPGaugeMonitorMBeanImpl = new SNMPGaugeMonitorMBeanImpl(this, -1);
        try {
            sNMPGaugeMonitorMBeanImpl.setName(string);
            this.addSNMPGaugeMonitor(sNMPGaugeMonitorMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return sNMPGaugeMonitorMBeanImpl;
    }

    public SNMPGaugeMonitorMBean createSNMPGaugeMonitor(String string, SNMPGaugeMonitorMBean sNMPGaugeMonitorMBean) {
        return this._customizer.createSNMPGaugeMonitor(string, sNMPGaugeMonitorMBean);
    }

    public void destroySNMPGaugeMonitor(SNMPGaugeMonitorMBean sNMPGaugeMonitorMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(sNMPGaugeMonitorMBean, 19);
                SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray = this.getSNMPGaugeMonitors();
                SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray2 = (SNMPGaugeMonitorMBean[])this._getHelper()._removeElement((Object)sNMPGaugeMonitorMBeanArray, SNMPGaugeMonitorMBean.class, (Object)sNMPGaugeMonitorMBean);
                if (sNMPGaugeMonitorMBeanArray.length == sNMPGaugeMonitorMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)sNMPGaugeMonitorMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPGaugeMonitorMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSNMPGaugeMonitors(sNMPGaugeMonitorMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public SNMPGaugeMonitorMBean lookupSNMPGaugeMonitor(String string) {
        for (SNMPGaugeMonitorMBeanImpl sNMPGaugeMonitorMBeanImpl : Arrays.asList((Object[])this._SNMPGaugeMonitors)) {
            String string2 = string;
            if (!sNMPGaugeMonitorMBeanImpl.getName().equals(string2)) continue;
            return sNMPGaugeMonitorMBeanImpl;
        }
        return null;
    }

    public SNMPStringMonitorMBean[] getSNMPStringMonitors() {
        return this._SNMPStringMonitors;
    }

    public boolean isSNMPStringMonitorsSet() {
        return this._isSet(20);
    }

    public void setSNMPStringMonitors(SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray) throws InvalidAttributeValueException, ConfigurationException {
        sNMPStringMonitorMBeanArray = sNMPStringMonitorMBeanArray == null ? new SNMPStringMonitorMBeanImpl[]{} : sNMPStringMonitorMBeanArray;
        for (int i = 0; i < sNMPStringMonitorMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPStringMonitorMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 20)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray2 = this._SNMPStringMonitors;
        this._SNMPStringMonitors = sNMPStringMonitorMBeanArray;
        this._postSet(20, sNMPStringMonitorMBeanArray2, sNMPStringMonitorMBeanArray);
    }

    public boolean addSNMPStringMonitor(SNMPStringMonitorMBean sNMPStringMonitorMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)sNMPStringMonitorMBean);
        if (!((AbstractDescriptorBean)sNMPStringMonitorMBean).isChildProperty((DescriptorBean)this, 20)) {
            SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray = this._isSet(20) ? (SNMPStringMonitorMBean[])this._getHelper()._extendArray((Object)this.getSNMPStringMonitors(), SNMPStringMonitorMBean.class, (Object)sNMPStringMonitorMBean) : new SNMPStringMonitorMBean[]{sNMPStringMonitorMBean};
            try {
                this.setSNMPStringMonitors(sNMPStringMonitorMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeSNMPStringMonitor(SNMPStringMonitorMBean sNMPStringMonitorMBean) throws InvalidAttributeValueException, ConfigurationException {
        this.destroySNMPStringMonitor(sNMPStringMonitorMBean);
        return true;
    }

    public SNMPStringMonitorMBean createSNMPStringMonitor(String string) {
        SNMPStringMonitorMBeanImpl sNMPStringMonitorMBeanImpl = new SNMPStringMonitorMBeanImpl(this, -1);
        try {
            sNMPStringMonitorMBeanImpl.setName(string);
            this.addSNMPStringMonitor(sNMPStringMonitorMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return sNMPStringMonitorMBeanImpl;
    }

    public SNMPStringMonitorMBean createSNMPStringMonitor(String string, SNMPStringMonitorMBean sNMPStringMonitorMBean) {
        return this._customizer.createSNMPStringMonitor(string, sNMPStringMonitorMBean);
    }

    public void destroySNMPStringMonitor(SNMPStringMonitorMBean sNMPStringMonitorMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(sNMPStringMonitorMBean, 20);
                SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray = this.getSNMPStringMonitors();
                SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray2 = (SNMPStringMonitorMBean[])this._getHelper()._removeElement((Object)sNMPStringMonitorMBeanArray, SNMPStringMonitorMBean.class, (Object)sNMPStringMonitorMBean);
                if (sNMPStringMonitorMBeanArray.length == sNMPStringMonitorMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)sNMPStringMonitorMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPStringMonitorMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSNMPStringMonitors(sNMPStringMonitorMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public SNMPStringMonitorMBean lookupSNMPStringMonitor(String string) {
        for (SNMPStringMonitorMBeanImpl sNMPStringMonitorMBeanImpl : Arrays.asList((Object[])this._SNMPStringMonitors)) {
            String string2 = string;
            if (!sNMPStringMonitorMBeanImpl.getName().equals(string2)) continue;
            return sNMPStringMonitorMBeanImpl;
        }
        return null;
    }

    public SNMPCounterMonitorMBean[] getSNMPCounterMonitors() {
        return this._SNMPCounterMonitors;
    }

    public boolean isSNMPCounterMonitorsSet() {
        return this._isSet(21);
    }

    public void setSNMPCounterMonitors(SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray) throws InvalidAttributeValueException, ConfigurationException {
        sNMPCounterMonitorMBeanArray = sNMPCounterMonitorMBeanArray == null ? new SNMPCounterMonitorMBeanImpl[]{} : sNMPCounterMonitorMBeanArray;
        for (int i = 0; i < sNMPCounterMonitorMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPCounterMonitorMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 21)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray2 = this._SNMPCounterMonitors;
        this._SNMPCounterMonitors = sNMPCounterMonitorMBeanArray;
        this._postSet(21, sNMPCounterMonitorMBeanArray2, sNMPCounterMonitorMBeanArray);
    }

    public boolean addSNMPCounterMonitor(SNMPCounterMonitorMBean sNMPCounterMonitorMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)sNMPCounterMonitorMBean);
        if (!((AbstractDescriptorBean)sNMPCounterMonitorMBean).isChildProperty((DescriptorBean)this, 21)) {
            SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray = this._isSet(21) ? (SNMPCounterMonitorMBean[])this._getHelper()._extendArray((Object)this.getSNMPCounterMonitors(), SNMPCounterMonitorMBean.class, (Object)sNMPCounterMonitorMBean) : new SNMPCounterMonitorMBean[]{sNMPCounterMonitorMBean};
            try {
                this.setSNMPCounterMonitors(sNMPCounterMonitorMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeSNMPCounterMonitor(SNMPCounterMonitorMBean sNMPCounterMonitorMBean) throws InvalidAttributeValueException, ConfigurationException {
        this.destroySNMPCounterMonitor(sNMPCounterMonitorMBean);
        return true;
    }

    public SNMPCounterMonitorMBean createSNMPCounterMonitor(String string) {
        SNMPCounterMonitorMBeanImpl sNMPCounterMonitorMBeanImpl = new SNMPCounterMonitorMBeanImpl(this, -1);
        try {
            sNMPCounterMonitorMBeanImpl.setName(string);
            this.addSNMPCounterMonitor(sNMPCounterMonitorMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return sNMPCounterMonitorMBeanImpl;
    }

    public SNMPCounterMonitorMBean createSNMPCounterMonitor(String string, SNMPCounterMonitorMBean sNMPCounterMonitorMBean) {
        return this._customizer.createSNMPCounterMonitor(string, sNMPCounterMonitorMBean);
    }

    public void destroySNMPCounterMonitor(SNMPCounterMonitorMBean sNMPCounterMonitorMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(sNMPCounterMonitorMBean, 21);
                SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray = this.getSNMPCounterMonitors();
                SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray2 = (SNMPCounterMonitorMBean[])this._getHelper()._removeElement((Object)sNMPCounterMonitorMBeanArray, SNMPCounterMonitorMBean.class, (Object)sNMPCounterMonitorMBean);
                if (sNMPCounterMonitorMBeanArray.length == sNMPCounterMonitorMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)sNMPCounterMonitorMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPCounterMonitorMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSNMPCounterMonitors(sNMPCounterMonitorMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public SNMPCounterMonitorMBean lookupSNMPCounterMonitor(String string) {
        for (SNMPCounterMonitorMBeanImpl sNMPCounterMonitorMBeanImpl : Arrays.asList((Object[])this._SNMPCounterMonitors)) {
            String string2 = string;
            if (!sNMPCounterMonitorMBeanImpl.getName().equals(string2)) continue;
            return sNMPCounterMonitorMBeanImpl;
        }
        return null;
    }

    public SNMPLogFilterMBean[] getSNMPLogFilters() {
        return this._SNMPLogFilters;
    }

    public boolean isSNMPLogFiltersSet() {
        return this._isSet(22);
    }

    public void setSNMPLogFilters(SNMPLogFilterMBean[] sNMPLogFilterMBeanArray) throws InvalidAttributeValueException, ConfigurationException {
        sNMPLogFilterMBeanArray = sNMPLogFilterMBeanArray == null ? new SNMPLogFilterMBeanImpl[]{} : sNMPLogFilterMBeanArray;
        for (int i = 0; i < sNMPLogFilterMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPLogFilterMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 22)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        SNMPLogFilterMBean[] sNMPLogFilterMBeanArray2 = this._SNMPLogFilters;
        this._SNMPLogFilters = sNMPLogFilterMBeanArray;
        this._postSet(22, sNMPLogFilterMBeanArray2, sNMPLogFilterMBeanArray);
    }

    public boolean addSNMPLogFilter(SNMPLogFilterMBean sNMPLogFilterMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)sNMPLogFilterMBean);
        if (!((AbstractDescriptorBean)sNMPLogFilterMBean).isChildProperty((DescriptorBean)this, 22)) {
            SNMPLogFilterMBean[] sNMPLogFilterMBeanArray = this._isSet(22) ? (SNMPLogFilterMBean[])this._getHelper()._extendArray((Object)this.getSNMPLogFilters(), SNMPLogFilterMBean.class, (Object)sNMPLogFilterMBean) : new SNMPLogFilterMBean[]{sNMPLogFilterMBean};
            try {
                this.setSNMPLogFilters(sNMPLogFilterMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeSNMPLogFilter(SNMPLogFilterMBean sNMPLogFilterMBean) throws InvalidAttributeValueException, ConfigurationException {
        this.destroySNMPLogFilter(sNMPLogFilterMBean);
        return true;
    }

    public SNMPLogFilterMBean createSNMPLogFilter(String string) {
        SNMPLogFilterMBeanImpl sNMPLogFilterMBeanImpl = new SNMPLogFilterMBeanImpl(this, -1);
        try {
            sNMPLogFilterMBeanImpl.setName(string);
            this.addSNMPLogFilter(sNMPLogFilterMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return sNMPLogFilterMBeanImpl;
    }

    public SNMPLogFilterMBean createSNMPLogFilter(String string, SNMPLogFilterMBean sNMPLogFilterMBean) {
        return this._customizer.createSNMPLogFilter(string, sNMPLogFilterMBean);
    }

    public void destroySNMPLogFilter(SNMPLogFilterMBean sNMPLogFilterMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(sNMPLogFilterMBean, 22);
                SNMPLogFilterMBean[] sNMPLogFilterMBeanArray = this.getSNMPLogFilters();
                SNMPLogFilterMBean[] sNMPLogFilterMBeanArray2 = (SNMPLogFilterMBean[])this._getHelper()._removeElement((Object)sNMPLogFilterMBeanArray, SNMPLogFilterMBean.class, (Object)sNMPLogFilterMBean);
                if (sNMPLogFilterMBeanArray.length == sNMPLogFilterMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)sNMPLogFilterMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPLogFilterMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSNMPLogFilters(sNMPLogFilterMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public SNMPLogFilterMBean lookupSNMPLogFilter(String string) {
        for (SNMPLogFilterMBeanImpl sNMPLogFilterMBeanImpl : Arrays.asList((Object[])this._SNMPLogFilters)) {
            String string2 = string;
            if (!sNMPLogFilterMBeanImpl.getName().equals(string2)) continue;
            return sNMPLogFilterMBeanImpl;
        }
        return null;
    }

    public SNMPAttributeChangeMBean[] getSNMPAttributeChanges() {
        return this._SNMPAttributeChanges;
    }

    public boolean isSNMPAttributeChangesSet() {
        return this._isSet(23);
    }

    public void setSNMPAttributeChanges(SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray) throws InvalidAttributeValueException, ConfigurationException {
        sNMPAttributeChangeMBeanArray = sNMPAttributeChangeMBeanArray == null ? new SNMPAttributeChangeMBeanImpl[]{} : sNMPAttributeChangeMBeanArray;
        for (int i = 0; i < sNMPAttributeChangeMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPAttributeChangeMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 23)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray2 = this._SNMPAttributeChanges;
        this._SNMPAttributeChanges = sNMPAttributeChangeMBeanArray;
        this._postSet(23, sNMPAttributeChangeMBeanArray2, sNMPAttributeChangeMBeanArray);
    }

    public boolean addSNMPAttributeChange(SNMPAttributeChangeMBean sNMPAttributeChangeMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)sNMPAttributeChangeMBean);
        if (!((AbstractDescriptorBean)sNMPAttributeChangeMBean).isChildProperty((DescriptorBean)this, 23)) {
            SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray = this._isSet(23) ? (SNMPAttributeChangeMBean[])this._getHelper()._extendArray((Object)this.getSNMPAttributeChanges(), SNMPAttributeChangeMBean.class, (Object)sNMPAttributeChangeMBean) : new SNMPAttributeChangeMBean[]{sNMPAttributeChangeMBean};
            try {
                this.setSNMPAttributeChanges(sNMPAttributeChangeMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeSNMPAttributeChange(SNMPAttributeChangeMBean sNMPAttributeChangeMBean) throws InvalidAttributeValueException, ConfigurationException {
        this.destroySNMPAttributeChange(sNMPAttributeChangeMBean);
        return true;
    }

    public SNMPAttributeChangeMBean createSNMPAttributeChange(String string) {
        SNMPAttributeChangeMBeanImpl sNMPAttributeChangeMBeanImpl = new SNMPAttributeChangeMBeanImpl(this, -1);
        try {
            sNMPAttributeChangeMBeanImpl.setName(string);
            this.addSNMPAttributeChange(sNMPAttributeChangeMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return sNMPAttributeChangeMBeanImpl;
    }

    public SNMPAttributeChangeMBean createSNMPAttributeChange(String string, SNMPAttributeChangeMBean sNMPAttributeChangeMBean) {
        return this._customizer.createSNMPAttributeChange(string, sNMPAttributeChangeMBean);
    }

    public void destroySNMPAttributeChange(SNMPAttributeChangeMBean sNMPAttributeChangeMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(sNMPAttributeChangeMBean, 23);
                SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray = this.getSNMPAttributeChanges();
                SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray2 = (SNMPAttributeChangeMBean[])this._getHelper()._removeElement((Object)sNMPAttributeChangeMBeanArray, SNMPAttributeChangeMBean.class, (Object)sNMPAttributeChangeMBean);
                if (sNMPAttributeChangeMBeanArray.length == sNMPAttributeChangeMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)sNMPAttributeChangeMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)sNMPAttributeChangeMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSNMPAttributeChanges(sNMPAttributeChangeMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public SNMPAttributeChangeMBean lookupSNMPAttributeChange(String string) {
        for (SNMPAttributeChangeMBeanImpl sNMPAttributeChangeMBeanImpl : Arrays.asList((Object[])this._SNMPAttributeChanges)) {
            String string2 = string;
            if (!sNMPAttributeChangeMBeanImpl.getName().equals(string2)) continue;
            return sNMPAttributeChangeMBeanImpl;
        }
        return null;
    }

    public boolean isCommunityBasedAccessEnabled() {
        return this._CommunityBasedAccessEnabled;
    }

    public boolean isCommunityBasedAccessEnabledSet() {
        return this._isSet(24);
    }

    public void setCommunityBasedAccessEnabled(boolean bl) {
        boolean bl2 = this._CommunityBasedAccessEnabled;
        this._CommunityBasedAccessEnabled = bl;
        this._postSet(24, bl2, bl);
    }

    public String getSNMPEngineId() {
        if (!this._isSet(25)) {
            try {
                return this.getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._SNMPEngineId;
    }

    public boolean isSNMPEngineIdSet() {
        return this._isSet(25);
    }

    public void setSNMPEngineId(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"SNMPEngineId", (Object)string);
        String string2 = this._SNMPEngineId;
        this._SNMPEngineId = string;
        this._postSet(25, string2, string);
    }

    public String getAuthenticationProtocol() {
        if (!this._isSet(26)) {
            return this._isProductionModeEnabled() ? "MD5" : "noAuth";
        }
        return this._AuthenticationProtocol;
    }

    public boolean isAuthenticationProtocolSet() {
        return this._isSet(26);
    }

    public void setAuthenticationProtocol(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"noAuth", "MD5", "SHA"};
        string = LegalChecks.checkInEnum((String)"AuthenticationProtocol", (String)string, (String[])stringArray);
        LegalChecks.checkNonNull((String)"AuthenticationProtocol", (Object)string);
        String string2 = this._AuthenticationProtocol;
        this._AuthenticationProtocol = string;
        this._postSet(26, string2, string);
    }

    public String getPrivacyProtocol() {
        return this._PrivacyProtocol;
    }

    public boolean isPrivacyProtocolSet() {
        return this._isSet(27);
    }

    public void setPrivacyProtocol(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"noPriv", "DES", "AES_128"};
        string = LegalChecks.checkInEnum((String)"PrivacyProtocol", (String)string, (String[])stringArray);
        LegalChecks.checkNonNull((String)"PrivacyProtocol", (Object)string);
        String string2 = this._PrivacyProtocol;
        this._PrivacyProtocol = string;
        this._postSet(27, string2, string);
    }

    public int getInformRetryInterval() {
        return this._InformRetryInterval;
    }

    public boolean isInformRetryIntervalSet() {
        return this._isSet(28);
    }

    public void setInformRetryInterval(int n) {
        LegalChecks.checkInRange((String)"InformRetryInterval", (long)n, (long)3000L, (long)30000L);
        int n2 = this._InformRetryInterval;
        this._InformRetryInterval = n;
        this._postSet(28, n2, n);
    }

    public int getMaxInformRetryCount() {
        return this._MaxInformRetryCount;
    }

    public boolean isMaxInformRetryCountSet() {
        return this._isSet(29);
    }

    public void setMaxInformRetryCount(int n) {
        LegalChecks.checkInRange((String)"MaxInformRetryCount", (long)n, (long)1L, (long)3L);
        int n2 = this._MaxInformRetryCount;
        this._MaxInformRetryCount = n;
        this._postSet(29, n2, n);
    }

    public long getLocalizedKeyCacheInvalidationInterval() {
        return this._LocalizedKeyCacheInvalidationInterval;
    }

    public boolean isLocalizedKeyCacheInvalidationIntervalSet() {
        return this._isSet(30);
    }

    public void setLocalizedKeyCacheInvalidationInterval(long l) {
        LegalChecks.checkMax((String)"LocalizedKeyCacheInvalidationInterval", (long)l, (long)86400000L);
        long l2 = this._LocalizedKeyCacheInvalidationInterval;
        this._LocalizedKeyCacheInvalidationInterval = l;
        this._postSet(30, l2, l);
    }

    public boolean isSNMPAccessForUserMBeansEnabled() {
        return this._SNMPAccessForUserMBeansEnabled;
    }

    public boolean isSNMPAccessForUserMBeansEnabledSet() {
        return this._isSet(31);
    }

    public void setSNMPAccessForUserMBeansEnabled(boolean bl) {
        boolean bl2 = this._SNMPAccessForUserMBeansEnabled;
        this._SNMPAccessForUserMBeansEnabled = bl;
        this._postSet(31, bl2, bl);
    }

    public boolean isInformEnabled() {
        return this._InformEnabled;
    }

    public boolean isInformEnabledSet() {
        return this._isSet(32);
    }

    public void setInformEnabled(boolean bl) {
        boolean bl2 = this._InformEnabled;
        this._InformEnabled = bl;
        this._postSet(32, bl2, bl);
    }

    public int getMasterAgentXPort() {
        return this._MasterAgentXPort;
    }

    public boolean isMasterAgentXPortSet() {
        return this._isSet(33);
    }

    public void setMasterAgentXPort(int n) {
        LegalChecks.checkInRange((String)"MasterAgentXPort", (long)n, (long)1L, (long)65535L);
        int n2 = this._MasterAgentXPort;
        this._MasterAgentXPort = n;
        this._postSet(33, n2, n);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        SNMPValidator.validateSNMPAgent(this);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 26;
        }
        try {
            switch (n) {
                case 26: {
                    this._AuthenticationProtocol = "noAuth";
                    if (bl) break;
                }
                case 13: {
                    this._CommunityPrefix = "public";
                    if (bl) break;
                }
                case 15: {
                    this._DebugLevel = 0;
                    if (bl) break;
                }
                case 28: {
                    this._InformRetryInterval = 10000;
                    if (bl) break;
                }
                case 30: {
                    this._LocalizedKeyCacheInvalidationInterval = 3600000L;
                    if (bl) break;
                }
                case 33: {
                    this._MasterAgentXPort = 705;
                    if (bl) break;
                }
                case 29: {
                    this._MaxInformRetryCount = 1;
                    if (bl) break;
                }
                case 11: {
                    this._MibDataRefreshInterval = 120;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 27: {
                    this._PrivacyProtocol = "noPriv";
                    if (bl) break;
                }
                case 23: {
                    this._SNMPAttributeChanges = new SNMPAttributeChangeMBean[0];
                    if (bl) break;
                }
                case 21: {
                    this._SNMPCounterMonitors = new SNMPCounterMonitorMBean[0];
                    if (bl) break;
                }
                case 25: {
                    this._SNMPEngineId = null;
                    if (bl) break;
                }
                case 19: {
                    this._SNMPGaugeMonitors = new SNMPGaugeMonitorMBean[0];
                    if (bl) break;
                }
                case 22: {
                    this._SNMPLogFilters = new SNMPLogFilterMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._SNMPPort = 161;
                    if (bl) break;
                }
                case 18: {
                    this._SNMPProxies = new SNMPProxyMBean[0];
                    if (bl) break;
                }
                case 20: {
                    this._SNMPStringMonitors = new SNMPStringMonitorMBean[0];
                    if (bl) break;
                }
                case 17: {
                    this._SNMPTrapDestinations = new SNMPTrapDestinationMBean[0];
                    if (bl) break;
                }
                case 10: {
                    this._SNMPTrapVersion = 1;
                    if (bl) break;
                }
                case 12: {
                    this._ServerStatusCheckIntervalFactor = 1;
                    if (bl) break;
                }
                case 16: {
                    this._TargetedTrapDestinations = new SNMPTrapDestinationMBean[0];
                    if (bl) break;
                }
                case 14: {
                    this._UserDefinedMib = "na";
                    if (bl) break;
                }
                case 24: {
                    this._CommunityBasedAccessEnabled = true;
                    if (bl) break;
                }
                case 7: {
                    this._Enabled = false;
                    if (bl) break;
                }
                case 32: {
                    this._InformEnabled = false;
                    if (bl) break;
                }
                case 31: {
                    this._SNMPAccessForUserMBeansEnabled = false;
                    if (bl) break;
                }
                case 8: {
                    this._SendAutomaticTrapsEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SNMPAgent";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AuthenticationProtocol")) {
            String string2 = this._AuthenticationProtocol;
            this._AuthenticationProtocol = (String)object;
            this._postSet(26, string2, this._AuthenticationProtocol);
            return;
        }
        if (string.equals("CommunityBasedAccessEnabled")) {
            boolean bl = this._CommunityBasedAccessEnabled;
            this._CommunityBasedAccessEnabled = (Boolean)object;
            this._postSet(24, bl, this._CommunityBasedAccessEnabled);
            return;
        }
        if (string.equals("CommunityPrefix")) {
            String string3 = this._CommunityPrefix;
            this._CommunityPrefix = (String)object;
            this._postSet(13, string3, this._CommunityPrefix);
            return;
        }
        if (string.equals("DebugLevel")) {
            int n = this._DebugLevel;
            this._DebugLevel = (Integer)object;
            this._postSet(15, n, this._DebugLevel);
            return;
        }
        if (string.equals("Enabled")) {
            boolean bl = this._Enabled;
            this._Enabled = (Boolean)object;
            this._postSet(7, bl, this._Enabled);
            return;
        }
        if (string.equals("InformEnabled")) {
            boolean bl = this._InformEnabled;
            this._InformEnabled = (Boolean)object;
            this._postSet(32, bl, this._InformEnabled);
            return;
        }
        if (string.equals("InformRetryInterval")) {
            int n = this._InformRetryInterval;
            this._InformRetryInterval = (Integer)object;
            this._postSet(28, n, this._InformRetryInterval);
            return;
        }
        if (string.equals("LocalizedKeyCacheInvalidationInterval")) {
            long l = this._LocalizedKeyCacheInvalidationInterval;
            this._LocalizedKeyCacheInvalidationInterval = (Long)object;
            this._postSet(30, l, this._LocalizedKeyCacheInvalidationInterval);
            return;
        }
        if (string.equals("MasterAgentXPort")) {
            int n = this._MasterAgentXPort;
            this._MasterAgentXPort = (Integer)object;
            this._postSet(33, n, this._MasterAgentXPort);
            return;
        }
        if (string.equals("MaxInformRetryCount")) {
            int n = this._MaxInformRetryCount;
            this._MaxInformRetryCount = (Integer)object;
            this._postSet(29, n, this._MaxInformRetryCount);
            return;
        }
        if (string.equals("MibDataRefreshInterval")) {
            int n = this._MibDataRefreshInterval;
            this._MibDataRefreshInterval = (Integer)object;
            this._postSet(11, n, this._MibDataRefreshInterval);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("PrivacyProtocol")) {
            String string5 = this._PrivacyProtocol;
            this._PrivacyProtocol = (String)object;
            this._postSet(27, string5, this._PrivacyProtocol);
            return;
        }
        if (string.equals("SNMPAccessForUserMBeansEnabled")) {
            boolean bl = this._SNMPAccessForUserMBeansEnabled;
            this._SNMPAccessForUserMBeansEnabled = (Boolean)object;
            this._postSet(31, bl, this._SNMPAccessForUserMBeansEnabled);
            return;
        }
        if (string.equals("SNMPAttributeChanges")) {
            SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray = this._SNMPAttributeChanges;
            this._SNMPAttributeChanges = (SNMPAttributeChangeMBean[])object;
            this._postSet(23, sNMPAttributeChangeMBeanArray, this._SNMPAttributeChanges);
            return;
        }
        if (string.equals("SNMPCounterMonitors")) {
            SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray = this._SNMPCounterMonitors;
            this._SNMPCounterMonitors = (SNMPCounterMonitorMBean[])object;
            this._postSet(21, sNMPCounterMonitorMBeanArray, this._SNMPCounterMonitors);
            return;
        }
        if (string.equals("SNMPEngineId")) {
            String string6 = this._SNMPEngineId;
            this._SNMPEngineId = (String)object;
            this._postSet(25, string6, this._SNMPEngineId);
            return;
        }
        if (string.equals("SNMPGaugeMonitors")) {
            SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray = this._SNMPGaugeMonitors;
            this._SNMPGaugeMonitors = (SNMPGaugeMonitorMBean[])object;
            this._postSet(19, sNMPGaugeMonitorMBeanArray, this._SNMPGaugeMonitors);
            return;
        }
        if (string.equals("SNMPLogFilters")) {
            SNMPLogFilterMBean[] sNMPLogFilterMBeanArray = this._SNMPLogFilters;
            this._SNMPLogFilters = (SNMPLogFilterMBean[])object;
            this._postSet(22, sNMPLogFilterMBeanArray, this._SNMPLogFilters);
            return;
        }
        if (string.equals("SNMPPort")) {
            int n = this._SNMPPort;
            this._SNMPPort = (Integer)object;
            this._postSet(9, n, this._SNMPPort);
            return;
        }
        if (string.equals("SNMPProxies")) {
            SNMPProxyMBean[] sNMPProxyMBeanArray = this._SNMPProxies;
            this._SNMPProxies = (SNMPProxyMBean[])object;
            this._postSet(18, sNMPProxyMBeanArray, this._SNMPProxies);
            return;
        }
        if (string.equals("SNMPStringMonitors")) {
            SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray = this._SNMPStringMonitors;
            this._SNMPStringMonitors = (SNMPStringMonitorMBean[])object;
            this._postSet(20, sNMPStringMonitorMBeanArray, this._SNMPStringMonitors);
            return;
        }
        if (string.equals("SNMPTrapDestinations")) {
            SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = this._SNMPTrapDestinations;
            this._SNMPTrapDestinations = (SNMPTrapDestinationMBean[])object;
            this._postSet(17, sNMPTrapDestinationMBeanArray, this._SNMPTrapDestinations);
            return;
        }
        if (string.equals("SNMPTrapVersion")) {
            int n = this._SNMPTrapVersion;
            this._SNMPTrapVersion = (Integer)object;
            this._postSet(10, n, this._SNMPTrapVersion);
            return;
        }
        if (string.equals("SendAutomaticTrapsEnabled")) {
            boolean bl = this._SendAutomaticTrapsEnabled;
            this._SendAutomaticTrapsEnabled = (Boolean)object;
            this._postSet(8, bl, this._SendAutomaticTrapsEnabled);
            return;
        }
        if (string.equals("ServerStatusCheckIntervalFactor")) {
            int n = this._ServerStatusCheckIntervalFactor;
            this._ServerStatusCheckIntervalFactor = (Integer)object;
            this._postSet(12, n, this._ServerStatusCheckIntervalFactor);
            return;
        }
        if (string.equals("TargetedTrapDestinations")) {
            SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = this._TargetedTrapDestinations;
            this._TargetedTrapDestinations = (SNMPTrapDestinationMBean[])object;
            this._postSet(16, sNMPTrapDestinationMBeanArray, this._TargetedTrapDestinations);
            return;
        }
        if (string.equals("UserDefinedMib")) {
            String string7 = this._UserDefinedMib;
            this._UserDefinedMib = (String)object;
            this._postSet(14, string7, this._UserDefinedMib);
            return;
        }
        if (string.equals("customizer")) {
            SNMPAgent sNMPAgent = this._customizer;
            this._customizer = (SNMPAgent)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AuthenticationProtocol")) {
            return this._AuthenticationProtocol;
        }
        if (string.equals("CommunityBasedAccessEnabled")) {
            return new Boolean(this._CommunityBasedAccessEnabled);
        }
        if (string.equals("CommunityPrefix")) {
            return this._CommunityPrefix;
        }
        if (string.equals("DebugLevel")) {
            return new Integer(this._DebugLevel);
        }
        if (string.equals("Enabled")) {
            return new Boolean(this._Enabled);
        }
        if (string.equals("InformEnabled")) {
            return new Boolean(this._InformEnabled);
        }
        if (string.equals("InformRetryInterval")) {
            return new Integer(this._InformRetryInterval);
        }
        if (string.equals("LocalizedKeyCacheInvalidationInterval")) {
            return new Long(this._LocalizedKeyCacheInvalidationInterval);
        }
        if (string.equals("MasterAgentXPort")) {
            return new Integer(this._MasterAgentXPort);
        }
        if (string.equals("MaxInformRetryCount")) {
            return new Integer(this._MaxInformRetryCount);
        }
        if (string.equals("MibDataRefreshInterval")) {
            return new Integer(this._MibDataRefreshInterval);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PrivacyProtocol")) {
            return this._PrivacyProtocol;
        }
        if (string.equals("SNMPAccessForUserMBeansEnabled")) {
            return new Boolean(this._SNMPAccessForUserMBeansEnabled);
        }
        if (string.equals("SNMPAttributeChanges")) {
            return this._SNMPAttributeChanges;
        }
        if (string.equals("SNMPCounterMonitors")) {
            return this._SNMPCounterMonitors;
        }
        if (string.equals("SNMPEngineId")) {
            return this._SNMPEngineId;
        }
        if (string.equals("SNMPGaugeMonitors")) {
            return this._SNMPGaugeMonitors;
        }
        if (string.equals("SNMPLogFilters")) {
            return this._SNMPLogFilters;
        }
        if (string.equals("SNMPPort")) {
            return new Integer(this._SNMPPort);
        }
        if (string.equals("SNMPProxies")) {
            return this._SNMPProxies;
        }
        if (string.equals("SNMPStringMonitors")) {
            return this._SNMPStringMonitors;
        }
        if (string.equals("SNMPTrapDestinations")) {
            return this._SNMPTrapDestinations;
        }
        if (string.equals("SNMPTrapVersion")) {
            return new Integer(this._SNMPTrapVersion);
        }
        if (string.equals("SendAutomaticTrapsEnabled")) {
            return new Boolean(this._SendAutomaticTrapsEnabled);
        }
        if (string.equals("ServerStatusCheckIntervalFactor")) {
            return new Integer(this._ServerStatusCheckIntervalFactor);
        }
        if (string.equals("TargetedTrapDestinations")) {
            return this._TargetedTrapDestinations;
        }
        if (string.equals("UserDefinedMib")) {
            return this._UserDefinedMib;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonNull((String)"AuthenticationProtocol", (Object)"noAuth");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property AuthenticationProtocol in SNMPAgentMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonEmptyString((String)"CommunityPrefix", (String)"public");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is zero-length. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-zero-length value on @default annotation. Refer annotation legalZeroLength on property CommunityPrefix in SNMPAgentMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"PrivacyProtocol", (Object)"noPriv");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property PrivacyProtocol in SNMPAgentMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonEmptyString((String)"UserDefinedMib", (String)"na");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is zero-length. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-zero-length value on @default annotation. Refer annotation legalZeroLength on property UserDefinedMib in SNMPAgentMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 23: {
                    if (!string.equals("authentication-protocol")) break;
                    return 26;
                }
                case 16: {
                    if (string.equals("community-prefix")) {
                        return 13;
                    }
                    if (string.equals("privacy-protocol")) {
                        return 27;
                    }
                    if (!string.equals("user-defined-mib")) break;
                    return 14;
                }
                case 11: {
                    if (!string.equals("debug-level")) break;
                    return 15;
                }
                case 21: {
                    if (string.equals("inform-retry-interval")) {
                        return 28;
                    }
                    if (string.equals("snmp-attribute-change")) {
                        return 23;
                    }
                    if (!string.equals("snmp-trap-destination")) break;
                    return 17;
                }
                case 41: {
                    if (!string.equals("localized-key-cache-invalidation-interval")) break;
                    return 30;
                }
                case 18: {
                    if (string.equals("master-agentx-port")) {
                        return 33;
                    }
                    if (!string.equals("snmp-gauge-monitor")) break;
                    return 19;
                }
                case 22: {
                    if (!string.equals("max-inform-retry-count")) break;
                    return 29;
                }
                case 25: {
                    if (string.equals("mib-data-refresh-interval")) {
                        return 11;
                    }
                    if (!string.equals("targeted-trap-destination")) break;
                    return 16;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 20: {
                    if (!string.equals("snmp-counter-monitor")) break;
                    return 21;
                }
                case 14: {
                    if (string.equals("snmp-engine-id")) {
                        return 25;
                    }
                    if (!string.equals("inform-enabled")) break;
                    return 32;
                }
                case 15: {
                    if (!string.equals("snmp-log-filter")) break;
                    return 22;
                }
                case 9: {
                    if (!string.equals("snmp-port")) break;
                    return 9;
                }
                case 10: {
                    if (!string.equals("snmp-proxy")) break;
                    return 18;
                }
                case 19: {
                    if (!string.equals("snmp-string-monitor")) break;
                    return 20;
                }
                case 17: {
                    if (!string.equals("snmp-trap-version")) break;
                    return 10;
                }
                case 35: {
                    if (string.equals("server-status-check-interval-factor")) {
                        return 12;
                    }
                    if (!string.equals("snmp-access-for-userm-beans-enabled")) break;
                    return 31;
                }
                case 30: {
                    if (!string.equals("community-based-access-enabled")) break;
                    return 24;
                }
                case 7: {
                    if (!string.equals("enabled")) break;
                    return 7;
                }
                case 28: {
                    if (!string.equals("send-automatic-traps-enabled")) break;
                    return 8;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 23: {
                    return new SNMPAttributeChangeMBeanImpl.SchemaHelper2();
                }
                case 21: {
                    return new SNMPCounterMonitorMBeanImpl.SchemaHelper2();
                }
                case 19: {
                    return new SNMPGaugeMonitorMBeanImpl.SchemaHelper2();
                }
                case 22: {
                    return new SNMPLogFilterMBeanImpl.SchemaHelper2();
                }
                case 18: {
                    return new SNMPProxyMBeanImpl.SchemaHelper2();
                }
                case 20: {
                    return new SNMPStringMonitorMBeanImpl.SchemaHelper2();
                }
                case 17: {
                    return new SNMPTrapDestinationMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 26: {
                    return "authentication-protocol";
                }
                case 13: {
                    return "community-prefix";
                }
                case 15: {
                    return "debug-level";
                }
                case 28: {
                    return "inform-retry-interval";
                }
                case 30: {
                    return "localized-key-cache-invalidation-interval";
                }
                case 33: {
                    return "master-agentx-port";
                }
                case 29: {
                    return "max-inform-retry-count";
                }
                case 11: {
                    return "mib-data-refresh-interval";
                }
                case 2: {
                    return "name";
                }
                case 27: {
                    return "privacy-protocol";
                }
                case 23: {
                    return "snmp-attribute-change";
                }
                case 21: {
                    return "snmp-counter-monitor";
                }
                case 25: {
                    return "snmp-engine-id";
                }
                case 19: {
                    return "snmp-gauge-monitor";
                }
                case 22: {
                    return "snmp-log-filter";
                }
                case 9: {
                    return "snmp-port";
                }
                case 18: {
                    return "snmp-proxy";
                }
                case 20: {
                    return "snmp-string-monitor";
                }
                case 17: {
                    return "snmp-trap-destination";
                }
                case 10: {
                    return "snmp-trap-version";
                }
                case 12: {
                    return "server-status-check-interval-factor";
                }
                case 16: {
                    return "targeted-trap-destination";
                }
                case 14: {
                    return "user-defined-mib";
                }
                case 24: {
                    return "community-based-access-enabled";
                }
                case 7: {
                    return "enabled";
                }
                case 32: {
                    return "inform-enabled";
                }
                case 31: {
                    return "snmp-access-for-userm-beans-enabled";
                }
                case 8: {
                    return "send-automatic-traps-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 23: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 19: {
                    return true;
                }
                case 22: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 20: {
                    return true;
                }
                case 17: {
                    return true;
                }
                case 16: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 23: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 19: {
                    return true;
                }
                case 22: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 20: {
                    return true;
                }
                case 17: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private SNMPAgentMBeanImpl bean;

        protected Helper(SNMPAgentMBeanImpl sNMPAgentMBeanImpl) {
            super(sNMPAgentMBeanImpl);
            this.bean = sNMPAgentMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 26: {
                    return "AuthenticationProtocol";
                }
                case 13: {
                    return "CommunityPrefix";
                }
                case 15: {
                    return "DebugLevel";
                }
                case 28: {
                    return "InformRetryInterval";
                }
                case 30: {
                    return "LocalizedKeyCacheInvalidationInterval";
                }
                case 33: {
                    return "MasterAgentXPort";
                }
                case 29: {
                    return "MaxInformRetryCount";
                }
                case 11: {
                    return "MibDataRefreshInterval";
                }
                case 2: {
                    return "Name";
                }
                case 27: {
                    return "PrivacyProtocol";
                }
                case 23: {
                    return "SNMPAttributeChanges";
                }
                case 21: {
                    return "SNMPCounterMonitors";
                }
                case 25: {
                    return "SNMPEngineId";
                }
                case 19: {
                    return "SNMPGaugeMonitors";
                }
                case 22: {
                    return "SNMPLogFilters";
                }
                case 9: {
                    return "SNMPPort";
                }
                case 18: {
                    return "SNMPProxies";
                }
                case 20: {
                    return "SNMPStringMonitors";
                }
                case 17: {
                    return "SNMPTrapDestinations";
                }
                case 10: {
                    return "SNMPTrapVersion";
                }
                case 12: {
                    return "ServerStatusCheckIntervalFactor";
                }
                case 16: {
                    return "TargetedTrapDestinations";
                }
                case 14: {
                    return "UserDefinedMib";
                }
                case 24: {
                    return "CommunityBasedAccessEnabled";
                }
                case 7: {
                    return "Enabled";
                }
                case 32: {
                    return "InformEnabled";
                }
                case 31: {
                    return "SNMPAccessForUserMBeansEnabled";
                }
                case 8: {
                    return "SendAutomaticTrapsEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AuthenticationProtocol")) {
                return 26;
            }
            if (string.equals("CommunityPrefix")) {
                return 13;
            }
            if (string.equals("DebugLevel")) {
                return 15;
            }
            if (string.equals("InformRetryInterval")) {
                return 28;
            }
            if (string.equals("LocalizedKeyCacheInvalidationInterval")) {
                return 30;
            }
            if (string.equals("MasterAgentXPort")) {
                return 33;
            }
            if (string.equals("MaxInformRetryCount")) {
                return 29;
            }
            if (string.equals("MibDataRefreshInterval")) {
                return 11;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PrivacyProtocol")) {
                return 27;
            }
            if (string.equals("SNMPAttributeChanges")) {
                return 23;
            }
            if (string.equals("SNMPCounterMonitors")) {
                return 21;
            }
            if (string.equals("SNMPEngineId")) {
                return 25;
            }
            if (string.equals("SNMPGaugeMonitors")) {
                return 19;
            }
            if (string.equals("SNMPLogFilters")) {
                return 22;
            }
            if (string.equals("SNMPPort")) {
                return 9;
            }
            if (string.equals("SNMPProxies")) {
                return 18;
            }
            if (string.equals("SNMPStringMonitors")) {
                return 20;
            }
            if (string.equals("SNMPTrapDestinations")) {
                return 17;
            }
            if (string.equals("SNMPTrapVersion")) {
                return 10;
            }
            if (string.equals("ServerStatusCheckIntervalFactor")) {
                return 12;
            }
            if (string.equals("TargetedTrapDestinations")) {
                return 16;
            }
            if (string.equals("UserDefinedMib")) {
                return 14;
            }
            if (string.equals("CommunityBasedAccessEnabled")) {
                return 24;
            }
            if (string.equals("Enabled")) {
                return 7;
            }
            if (string.equals("InformEnabled")) {
                return 32;
            }
            if (string.equals("SNMPAccessForUserMBeansEnabled")) {
                return 31;
            }
            if (string.equals("SendAutomaticTrapsEnabled")) {
                return 8;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getSNMPAttributeChanges()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getSNMPCounterMonitors()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getSNMPGaugeMonitors()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getSNMPLogFilters()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getSNMPProxies()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getSNMPStringMonitors()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getSNMPTrapDestinations()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAuthenticationProtocolSet()) {
                    stringBuffer.append("AuthenticationProtocol");
                    stringBuffer.append(String.valueOf(this.bean.getAuthenticationProtocol()));
                }
                if (this.bean.isCommunityPrefixSet()) {
                    stringBuffer.append("CommunityPrefix");
                    stringBuffer.append(String.valueOf(this.bean.getCommunityPrefix()));
                }
                if (this.bean.isDebugLevelSet()) {
                    stringBuffer.append("DebugLevel");
                    stringBuffer.append(String.valueOf(this.bean.getDebugLevel()));
                }
                if (this.bean.isInformRetryIntervalSet()) {
                    stringBuffer.append("InformRetryInterval");
                    stringBuffer.append(String.valueOf(this.bean.getInformRetryInterval()));
                }
                if (this.bean.isLocalizedKeyCacheInvalidationIntervalSet()) {
                    stringBuffer.append("LocalizedKeyCacheInvalidationInterval");
                    stringBuffer.append(String.valueOf(this.bean.getLocalizedKeyCacheInvalidationInterval()));
                }
                if (this.bean.isMasterAgentXPortSet()) {
                    stringBuffer.append("MasterAgentXPort");
                    stringBuffer.append(String.valueOf(this.bean.getMasterAgentXPort()));
                }
                if (this.bean.isMaxInformRetryCountSet()) {
                    stringBuffer.append("MaxInformRetryCount");
                    stringBuffer.append(String.valueOf(this.bean.getMaxInformRetryCount()));
                }
                if (this.bean.isMibDataRefreshIntervalSet()) {
                    stringBuffer.append("MibDataRefreshInterval");
                    stringBuffer.append(String.valueOf(this.bean.getMibDataRefreshInterval()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPrivacyProtocolSet()) {
                    stringBuffer.append("PrivacyProtocol");
                    stringBuffer.append(String.valueOf(this.bean.getPrivacyProtocol()));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSNMPAttributeChanges().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSNMPAttributeChanges()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSNMPCounterMonitors().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSNMPCounterMonitors()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isSNMPEngineIdSet()) {
                    stringBuffer.append("SNMPEngineId");
                    stringBuffer.append(String.valueOf(this.bean.getSNMPEngineId()));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSNMPGaugeMonitors().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSNMPGaugeMonitors()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSNMPLogFilters().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSNMPLogFilters()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isSNMPPortSet()) {
                    stringBuffer.append("SNMPPort");
                    stringBuffer.append(String.valueOf(this.bean.getSNMPPort()));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSNMPProxies().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSNMPProxies()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSNMPStringMonitors().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSNMPStringMonitors()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSNMPTrapDestinations().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSNMPTrapDestinations()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isSNMPTrapVersionSet()) {
                    stringBuffer.append("SNMPTrapVersion");
                    stringBuffer.append(String.valueOf(this.bean.getSNMPTrapVersion()));
                }
                if (this.bean.isServerStatusCheckIntervalFactorSet()) {
                    stringBuffer.append("ServerStatusCheckIntervalFactor");
                    stringBuffer.append(String.valueOf(this.bean.getServerStatusCheckIntervalFactor()));
                }
                if (this.bean.isTargetedTrapDestinationsSet()) {
                    stringBuffer.append("TargetedTrapDestinations");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargetedTrapDestinations())));
                }
                if (this.bean.isUserDefinedMibSet()) {
                    stringBuffer.append("UserDefinedMib");
                    stringBuffer.append(String.valueOf(this.bean.getUserDefinedMib()));
                }
                if (this.bean.isCommunityBasedAccessEnabledSet()) {
                    stringBuffer.append("CommunityBasedAccessEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCommunityBasedAccessEnabled()));
                }
                if (this.bean.isEnabledSet()) {
                    stringBuffer.append("Enabled");
                    stringBuffer.append(String.valueOf(this.bean.isEnabled()));
                }
                if (this.bean.isInformEnabledSet()) {
                    stringBuffer.append("InformEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isInformEnabled()));
                }
                if (this.bean.isSNMPAccessForUserMBeansEnabledSet()) {
                    stringBuffer.append("SNMPAccessForUserMBeansEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSNMPAccessForUserMBeansEnabled()));
                }
                if (this.bean.isSendAutomaticTrapsEnabledSet()) {
                    stringBuffer.append("SendAutomaticTrapsEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSendAutomaticTrapsEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SNMPAgentMBeanImpl sNMPAgentMBeanImpl = (SNMPAgentMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AuthenticationProtocol", this.bean.getAuthenticationProtocol(), sNMPAgentMBeanImpl.getAuthenticationProtocol(), true);
                this.computeDiff("CommunityPrefix", this.bean.getCommunityPrefix(), sNMPAgentMBeanImpl.getCommunityPrefix(), true);
                this.computeDiff("DebugLevel", this.bean.getDebugLevel(), sNMPAgentMBeanImpl.getDebugLevel(), true);
                this.computeDiff("InformRetryInterval", this.bean.getInformRetryInterval(), sNMPAgentMBeanImpl.getInformRetryInterval(), true);
                this.computeDiff("LocalizedKeyCacheInvalidationInterval", this.bean.getLocalizedKeyCacheInvalidationInterval(), sNMPAgentMBeanImpl.getLocalizedKeyCacheInvalidationInterval(), true);
                this.computeDiff("MasterAgentXPort", this.bean.getMasterAgentXPort(), sNMPAgentMBeanImpl.getMasterAgentXPort(), true);
                this.computeDiff("MaxInformRetryCount", this.bean.getMaxInformRetryCount(), sNMPAgentMBeanImpl.getMaxInformRetryCount(), true);
                this.computeDiff("MibDataRefreshInterval", this.bean.getMibDataRefreshInterval(), sNMPAgentMBeanImpl.getMibDataRefreshInterval(), true);
                this.computeDiff("Name", this.bean.getName(), sNMPAgentMBeanImpl.getName(), false);
                this.computeDiff("PrivacyProtocol", this.bean.getPrivacyProtocol(), sNMPAgentMBeanImpl.getPrivacyProtocol(), true);
                this.computeChildDiff("SNMPAttributeChanges", this.bean.getSNMPAttributeChanges(), sNMPAgentMBeanImpl.getSNMPAttributeChanges(), true);
                this.computeChildDiff("SNMPCounterMonitors", this.bean.getSNMPCounterMonitors(), sNMPAgentMBeanImpl.getSNMPCounterMonitors(), true);
                this.computeDiff("SNMPEngineId", this.bean.getSNMPEngineId(), sNMPAgentMBeanImpl.getSNMPEngineId(), true);
                this.computeChildDiff("SNMPGaugeMonitors", this.bean.getSNMPGaugeMonitors(), sNMPAgentMBeanImpl.getSNMPGaugeMonitors(), true);
                this.computeChildDiff("SNMPLogFilters", this.bean.getSNMPLogFilters(), sNMPAgentMBeanImpl.getSNMPLogFilters(), true);
                this.computeDiff("SNMPPort", this.bean.getSNMPPort(), sNMPAgentMBeanImpl.getSNMPPort(), true);
                this.computeChildDiff("SNMPProxies", this.bean.getSNMPProxies(), sNMPAgentMBeanImpl.getSNMPProxies(), true);
                this.computeChildDiff("SNMPStringMonitors", this.bean.getSNMPStringMonitors(), sNMPAgentMBeanImpl.getSNMPStringMonitors(), true);
                this.computeChildDiff("SNMPTrapDestinations", this.bean.getSNMPTrapDestinations(), sNMPAgentMBeanImpl.getSNMPTrapDestinations(), true);
                this.computeDiff("SNMPTrapVersion", this.bean.getSNMPTrapVersion(), sNMPAgentMBeanImpl.getSNMPTrapVersion(), true);
                this.computeDiff("ServerStatusCheckIntervalFactor", this.bean.getServerStatusCheckIntervalFactor(), sNMPAgentMBeanImpl.getServerStatusCheckIntervalFactor(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TargetedTrapDestinations", this.bean.getTargetedTrapDestinations(), sNMPAgentMBeanImpl.getTargetedTrapDestinations(), true);
                }
                this.computeDiff("UserDefinedMib", this.bean.getUserDefinedMib(), sNMPAgentMBeanImpl.getUserDefinedMib(), true);
                this.computeDiff("CommunityBasedAccessEnabled", this.bean.isCommunityBasedAccessEnabled(), sNMPAgentMBeanImpl.isCommunityBasedAccessEnabled(), true);
                this.computeDiff("Enabled", this.bean.isEnabled(), sNMPAgentMBeanImpl.isEnabled(), true);
                this.computeDiff("InformEnabled", this.bean.isInformEnabled(), sNMPAgentMBeanImpl.isInformEnabled(), true);
                this.computeDiff("SNMPAccessForUserMBeansEnabled", this.bean.isSNMPAccessForUserMBeansEnabled(), sNMPAgentMBeanImpl.isSNMPAccessForUserMBeansEnabled(), true);
                this.computeDiff("SendAutomaticTrapsEnabled", this.bean.isSendAutomaticTrapsEnabled(), sNMPAgentMBeanImpl.isSendAutomaticTrapsEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SNMPAgentMBeanImpl sNMPAgentMBeanImpl = (SNMPAgentMBeanImpl)beanUpdateEvent.getSourceBean();
                SNMPAgentMBeanImpl sNMPAgentMBeanImpl2 = (SNMPAgentMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AuthenticationProtocol")) {
                    sNMPAgentMBeanImpl.setAuthenticationProtocol(sNMPAgentMBeanImpl2.getAuthenticationProtocol());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("CommunityPrefix")) {
                    sNMPAgentMBeanImpl.setCommunityPrefix(sNMPAgentMBeanImpl2.getCommunityPrefix());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("DebugLevel")) {
                    sNMPAgentMBeanImpl.setDebugLevel(sNMPAgentMBeanImpl2.getDebugLevel());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("InformRetryInterval")) {
                    sNMPAgentMBeanImpl.setInformRetryInterval(sNMPAgentMBeanImpl2.getInformRetryInterval());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("LocalizedKeyCacheInvalidationInterval")) {
                    sNMPAgentMBeanImpl.setLocalizedKeyCacheInvalidationInterval(sNMPAgentMBeanImpl2.getLocalizedKeyCacheInvalidationInterval());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("MasterAgentXPort")) {
                    sNMPAgentMBeanImpl.setMasterAgentXPort(sNMPAgentMBeanImpl2.getMasterAgentXPort());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                } else if (string.equals("MaxInformRetryCount")) {
                    sNMPAgentMBeanImpl.setMaxInformRetryCount(sNMPAgentMBeanImpl2.getMaxInformRetryCount());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("MibDataRefreshInterval")) {
                    sNMPAgentMBeanImpl.setMibDataRefreshInterval(sNMPAgentMBeanImpl2.getMibDataRefreshInterval());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("Name")) {
                    sNMPAgentMBeanImpl.setName(sNMPAgentMBeanImpl2.getName());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("PrivacyProtocol")) {
                    sNMPAgentMBeanImpl.setPrivacyProtocol(sNMPAgentMBeanImpl2.getPrivacyProtocol());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("SNMPAttributeChanges")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        sNMPAgentMBeanImpl.addSNMPAttributeChange((SNMPAttributeChangeMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        sNMPAgentMBeanImpl.removeSNMPAttributeChange((SNMPAttributeChangeMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (sNMPAgentMBeanImpl.getSNMPAttributeChanges() == null || sNMPAgentMBeanImpl.getSNMPAttributeChanges().length == 0) {
                        sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                    }
                } else if (string.equals("SNMPCounterMonitors")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        sNMPAgentMBeanImpl.addSNMPCounterMonitor((SNMPCounterMonitorMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        sNMPAgentMBeanImpl.removeSNMPCounterMonitor((SNMPCounterMonitorMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (sNMPAgentMBeanImpl.getSNMPCounterMonitors() == null || sNMPAgentMBeanImpl.getSNMPCounterMonitors().length == 0) {
                        sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    }
                } else if (string.equals("SNMPEngineId")) {
                    sNMPAgentMBeanImpl.setSNMPEngineId(sNMPAgentMBeanImpl2.getSNMPEngineId());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("SNMPGaugeMonitors")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        sNMPAgentMBeanImpl.addSNMPGaugeMonitor((SNMPGaugeMonitorMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        sNMPAgentMBeanImpl.removeSNMPGaugeMonitor((SNMPGaugeMonitorMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (sNMPAgentMBeanImpl.getSNMPGaugeMonitors() == null || sNMPAgentMBeanImpl.getSNMPGaugeMonitors().length == 0) {
                        sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    }
                } else if (string.equals("SNMPLogFilters")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        sNMPAgentMBeanImpl.addSNMPLogFilter((SNMPLogFilterMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        sNMPAgentMBeanImpl.removeSNMPLogFilter((SNMPLogFilterMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (sNMPAgentMBeanImpl.getSNMPLogFilters() == null || sNMPAgentMBeanImpl.getSNMPLogFilters().length == 0) {
                        sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                    }
                } else if (string.equals("SNMPPort")) {
                    sNMPAgentMBeanImpl.setSNMPPort(sNMPAgentMBeanImpl2.getSNMPPort());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("SNMPProxies")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        sNMPAgentMBeanImpl.addSNMPProxy((SNMPProxyMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        sNMPAgentMBeanImpl.removeSNMPProxy((SNMPProxyMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (sNMPAgentMBeanImpl.getSNMPProxies() == null || sNMPAgentMBeanImpl.getSNMPProxies().length == 0) {
                        sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    }
                } else if (string.equals("SNMPStringMonitors")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        sNMPAgentMBeanImpl.addSNMPStringMonitor((SNMPStringMonitorMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        sNMPAgentMBeanImpl.removeSNMPStringMonitor((SNMPStringMonitorMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (sNMPAgentMBeanImpl.getSNMPStringMonitors() == null || sNMPAgentMBeanImpl.getSNMPStringMonitors().length == 0) {
                        sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                    }
                } else if (string.equals("SNMPTrapDestinations")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        sNMPAgentMBeanImpl.addSNMPTrapDestination((SNMPTrapDestinationMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        sNMPAgentMBeanImpl.removeSNMPTrapDestination((SNMPTrapDestinationMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (sNMPAgentMBeanImpl.getSNMPTrapDestinations() == null || sNMPAgentMBeanImpl.getSNMPTrapDestinations().length == 0) {
                        sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    }
                } else if (string.equals("SNMPTrapVersion")) {
                    sNMPAgentMBeanImpl.setSNMPTrapVersion(sNMPAgentMBeanImpl2.getSNMPTrapVersion());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("ServerStatusCheckIntervalFactor")) {
                    sNMPAgentMBeanImpl.setServerStatusCheckIntervalFactor(sNMPAgentMBeanImpl2.getServerStatusCheckIntervalFactor());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("TargetedTrapDestinations")) {
                    sNMPAgentMBeanImpl.setTargetedTrapDestinationsAsString(sNMPAgentMBeanImpl2.getTargetedTrapDestinationsAsString());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("UserDefinedMib")) {
                    sNMPAgentMBeanImpl.setUserDefinedMib(sNMPAgentMBeanImpl2.getUserDefinedMib());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("CommunityBasedAccessEnabled")) {
                    sNMPAgentMBeanImpl.setCommunityBasedAccessEnabled(sNMPAgentMBeanImpl2.isCommunityBasedAccessEnabled());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("Enabled")) {
                    sNMPAgentMBeanImpl.setEnabled(sNMPAgentMBeanImpl2.isEnabled());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("InformEnabled")) {
                    sNMPAgentMBeanImpl.setInformEnabled(sNMPAgentMBeanImpl2.isInformEnabled());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                } else if (string.equals("SNMPAccessForUserMBeansEnabled")) {
                    sNMPAgentMBeanImpl.setSNMPAccessForUserMBeansEnabled(sNMPAgentMBeanImpl2.isSNMPAccessForUserMBeansEnabled());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else if (string.equals("SendAutomaticTrapsEnabled")) {
                    sNMPAgentMBeanImpl.setSendAutomaticTrapsEnabled(sNMPAgentMBeanImpl2.isSendAutomaticTrapsEnabled());
                    sNMPAgentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                int n;
                ConfigurationMBean[] configurationMBeanArray;
                ConfigurationMBean[] configurationMBeanArray2;
                SNMPAgentMBeanImpl sNMPAgentMBeanImpl = (SNMPAgentMBeanImpl)abstractDescriptorBean;
                super.finishCopy(sNMPAgentMBeanImpl, bl, list);
                if ((list == null || !list.contains("AuthenticationProtocol")) && this.bean.isAuthenticationProtocolSet()) {
                    sNMPAgentMBeanImpl.setAuthenticationProtocol(this.bean.getAuthenticationProtocol());
                }
                if ((list == null || !list.contains("CommunityPrefix")) && this.bean.isCommunityPrefixSet()) {
                    sNMPAgentMBeanImpl.setCommunityPrefix(this.bean.getCommunityPrefix());
                }
                if ((list == null || !list.contains("DebugLevel")) && this.bean.isDebugLevelSet()) {
                    sNMPAgentMBeanImpl.setDebugLevel(this.bean.getDebugLevel());
                }
                if ((list == null || !list.contains("InformRetryInterval")) && this.bean.isInformRetryIntervalSet()) {
                    sNMPAgentMBeanImpl.setInformRetryInterval(this.bean.getInformRetryInterval());
                }
                if ((list == null || !list.contains("LocalizedKeyCacheInvalidationInterval")) && this.bean.isLocalizedKeyCacheInvalidationIntervalSet()) {
                    sNMPAgentMBeanImpl.setLocalizedKeyCacheInvalidationInterval(this.bean.getLocalizedKeyCacheInvalidationInterval());
                }
                if ((list == null || !list.contains("MasterAgentXPort")) && this.bean.isMasterAgentXPortSet()) {
                    sNMPAgentMBeanImpl.setMasterAgentXPort(this.bean.getMasterAgentXPort());
                }
                if ((list == null || !list.contains("MaxInformRetryCount")) && this.bean.isMaxInformRetryCountSet()) {
                    sNMPAgentMBeanImpl.setMaxInformRetryCount(this.bean.getMaxInformRetryCount());
                }
                if ((list == null || !list.contains("MibDataRefreshInterval")) && this.bean.isMibDataRefreshIntervalSet()) {
                    sNMPAgentMBeanImpl.setMibDataRefreshInterval(this.bean.getMibDataRefreshInterval());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    sNMPAgentMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PrivacyProtocol")) && this.bean.isPrivacyProtocolSet()) {
                    sNMPAgentMBeanImpl.setPrivacyProtocol(this.bean.getPrivacyProtocol());
                }
                if (!(list != null && list.contains("SNMPAttributeChanges") || !this.bean.isSNMPAttributeChangesSet() || sNMPAgentMBeanImpl._isSet(23))) {
                    configurationMBeanArray2 = this.bean.getSNMPAttributeChanges();
                    configurationMBeanArray = new SNMPAttributeChangeMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (SNMPAttributeChangeMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    sNMPAgentMBeanImpl.setSNMPAttributeChanges((SNMPAttributeChangeMBean[])configurationMBeanArray);
                }
                if (!(list != null && list.contains("SNMPCounterMonitors") || !this.bean.isSNMPCounterMonitorsSet() || sNMPAgentMBeanImpl._isSet(21))) {
                    configurationMBeanArray2 = this.bean.getSNMPCounterMonitors();
                    configurationMBeanArray = new SNMPCounterMonitorMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (SNMPCounterMonitorMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    sNMPAgentMBeanImpl.setSNMPCounterMonitors((SNMPCounterMonitorMBean[])configurationMBeanArray);
                }
                if ((list == null || !list.contains("SNMPEngineId")) && this.bean.isSNMPEngineIdSet()) {
                    sNMPAgentMBeanImpl.setSNMPEngineId(this.bean.getSNMPEngineId());
                }
                if (!(list != null && list.contains("SNMPGaugeMonitors") || !this.bean.isSNMPGaugeMonitorsSet() || sNMPAgentMBeanImpl._isSet(19))) {
                    configurationMBeanArray2 = this.bean.getSNMPGaugeMonitors();
                    configurationMBeanArray = new SNMPGaugeMonitorMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (SNMPGaugeMonitorMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    sNMPAgentMBeanImpl.setSNMPGaugeMonitors((SNMPGaugeMonitorMBean[])configurationMBeanArray);
                }
                if (!(list != null && list.contains("SNMPLogFilters") || !this.bean.isSNMPLogFiltersSet() || sNMPAgentMBeanImpl._isSet(22))) {
                    configurationMBeanArray2 = this.bean.getSNMPLogFilters();
                    configurationMBeanArray = new SNMPLogFilterMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (SNMPLogFilterMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    sNMPAgentMBeanImpl.setSNMPLogFilters((SNMPLogFilterMBean[])configurationMBeanArray);
                }
                if ((list == null || !list.contains("SNMPPort")) && this.bean.isSNMPPortSet()) {
                    sNMPAgentMBeanImpl.setSNMPPort(this.bean.getSNMPPort());
                }
                if (!(list != null && list.contains("SNMPProxies") || !this.bean.isSNMPProxiesSet() || sNMPAgentMBeanImpl._isSet(18))) {
                    configurationMBeanArray2 = this.bean.getSNMPProxies();
                    configurationMBeanArray = new SNMPProxyMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (SNMPProxyMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    sNMPAgentMBeanImpl.setSNMPProxies((SNMPProxyMBean[])configurationMBeanArray);
                }
                if (!(list != null && list.contains("SNMPStringMonitors") || !this.bean.isSNMPStringMonitorsSet() || sNMPAgentMBeanImpl._isSet(20))) {
                    configurationMBeanArray2 = this.bean.getSNMPStringMonitors();
                    configurationMBeanArray = new SNMPStringMonitorMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (SNMPStringMonitorMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    sNMPAgentMBeanImpl.setSNMPStringMonitors((SNMPStringMonitorMBean[])configurationMBeanArray);
                }
                if (!(list != null && list.contains("SNMPTrapDestinations") || !this.bean.isSNMPTrapDestinationsSet() || sNMPAgentMBeanImpl._isSet(17))) {
                    configurationMBeanArray2 = this.bean.getSNMPTrapDestinations();
                    configurationMBeanArray = new SNMPTrapDestinationMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (SNMPTrapDestinationMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    sNMPAgentMBeanImpl.setSNMPTrapDestinations((SNMPTrapDestinationMBean[])configurationMBeanArray);
                }
                if ((list == null || !list.contains("SNMPTrapVersion")) && this.bean.isSNMPTrapVersionSet()) {
                    sNMPAgentMBeanImpl.setSNMPTrapVersion(this.bean.getSNMPTrapVersion());
                }
                if ((list == null || !list.contains("ServerStatusCheckIntervalFactor")) && this.bean.isServerStatusCheckIntervalFactorSet()) {
                    sNMPAgentMBeanImpl.setServerStatusCheckIntervalFactor(this.bean.getServerStatusCheckIntervalFactor());
                }
                if (bl && (list == null || !list.contains("TargetedTrapDestinations")) && this.bean.isTargetedTrapDestinationsSet()) {
                    sNMPAgentMBeanImpl._unSet(sNMPAgentMBeanImpl, 16);
                    sNMPAgentMBeanImpl.setTargetedTrapDestinationsAsString(this.bean.getTargetedTrapDestinationsAsString());
                }
                if ((list == null || !list.contains("UserDefinedMib")) && this.bean.isUserDefinedMibSet()) {
                    sNMPAgentMBeanImpl.setUserDefinedMib(this.bean.getUserDefinedMib());
                }
                if ((list == null || !list.contains("CommunityBasedAccessEnabled")) && this.bean.isCommunityBasedAccessEnabledSet()) {
                    sNMPAgentMBeanImpl.setCommunityBasedAccessEnabled(this.bean.isCommunityBasedAccessEnabled());
                }
                if ((list == null || !list.contains("Enabled")) && this.bean.isEnabledSet()) {
                    sNMPAgentMBeanImpl.setEnabled(this.bean.isEnabled());
                }
                if ((list == null || !list.contains("InformEnabled")) && this.bean.isInformEnabledSet()) {
                    sNMPAgentMBeanImpl.setInformEnabled(this.bean.isInformEnabled());
                }
                if ((list == null || !list.contains("SNMPAccessForUserMBeansEnabled")) && this.bean.isSNMPAccessForUserMBeansEnabledSet()) {
                    sNMPAgentMBeanImpl.setSNMPAccessForUserMBeansEnabled(this.bean.isSNMPAccessForUserMBeansEnabled());
                }
                if ((list == null || !list.contains("SendAutomaticTrapsEnabled")) && this.bean.isSendAutomaticTrapsEnabledSet()) {
                    sNMPAgentMBeanImpl.setSendAutomaticTrapsEnabled(this.bean.isSendAutomaticTrapsEnabled());
                }
                return sNMPAgentMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getSNMPAttributeChanges(), clazz, object);
            this.inferSubTree(this.bean.getSNMPCounterMonitors(), clazz, object);
            this.inferSubTree(this.bean.getSNMPGaugeMonitors(), clazz, object);
            this.inferSubTree(this.bean.getSNMPLogFilters(), clazz, object);
            this.inferSubTree(this.bean.getSNMPProxies(), clazz, object);
            this.inferSubTree(this.bean.getSNMPStringMonitors(), clazz, object);
            this.inferSubTree(this.bean.getSNMPTrapDestinations(), clazz, object);
            this.inferSubTree(this.bean.getTargetedTrapDestinations(), clazz, object);
        }
    }
}

