/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.SNMPProxyMBean;
import weblogic.management.configuration.SNMPValidator;
import weblogic.utils.collections.CombinedIterator;

public class SNMPProxyMBeanImpl
extends ConfigurationMBeanImpl
implements SNMPProxyMBean,
Serializable {
    private String _Community;
    private String _OidRoot;
    private int _Port;
    private String _SecurityLevel;
    private String _SecurityName;
    private long _Timeout;
    private static SchemaHelper2 _schemaHelper;

    public SNMPProxyMBeanImpl() {
        this._initializeProperty(-1);
    }

    public SNMPProxyMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public int getPort() {
        return this._Port;
    }

    public boolean isPortSet() {
        return this._isSet(7);
    }

    public void setPort(int n) throws InvalidAttributeValueException, ConfigurationException {
        LegalChecks.checkInRange((String)"Port", (long)n, (long)0L, (long)65535L);
        int n2 = this._Port;
        this._Port = n;
        this._postSet(7, n2, n);
    }

    public String getOidRoot() {
        return this._OidRoot;
    }

    public boolean isOidRootSet() {
        return this._isSet(8);
    }

    public void setOidRoot(String string) throws InvalidAttributeValueException, ConfigurationException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"OidRoot", (String)string);
        String string2 = this._OidRoot;
        this._OidRoot = string;
        this._postSet(8, string2, string);
    }

    public String getCommunity() {
        return this._Community;
    }

    public boolean isCommunitySet() {
        return this._isSet(9);
    }

    public void setCommunity(String string) throws InvalidAttributeValueException, ConfigurationException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Community", (String)string);
        String string2 = this._Community;
        this._Community = string;
        this._postSet(9, string2, string);
    }

    public long getTimeout() {
        return this._Timeout;
    }

    public boolean isTimeoutSet() {
        return this._isSet(10);
    }

    public void setTimeout(long l) throws InvalidAttributeValueException, ConfigurationException {
        LegalChecks.checkMin((String)"Timeout", (long)l, (long)0L);
        long l2 = this._Timeout;
        this._Timeout = l;
        this._postSet(10, l2, l);
    }

    public String getSecurityName() {
        return this._SecurityName;
    }

    public boolean isSecurityNameSet() {
        return this._isSet(11);
    }

    public void setSecurityName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._SecurityName;
        this._SecurityName = string;
        this._postSet(11, string2, string);
    }

    public String getSecurityLevel() {
        if (!this._isSet(12)) {
            return this._isProductionModeEnabled() ? "authNoPriv" : "noAuthNoPriv";
        }
        return this._SecurityLevel;
    }

    public boolean isSecurityLevelSet() {
        return this._isSet(12);
    }

    public void setSecurityLevel(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"noAuthNoPriv", "authNoPriv", "authPriv"};
        string = LegalChecks.checkInEnum((String)"SecurityLevel", (String)string, (String[])stringArray);
        LegalChecks.checkNonNull((String)"SecurityLevel", (Object)string);
        String string2 = this._SecurityLevel;
        this._SecurityLevel = string;
        this._postSet(12, string2, string);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        SNMPValidator.validateSNMPProxy(this);
        LegalChecks.checkIsSet((String)"OidRoot", (boolean)this.isOidRootSet());
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 9;
        }
        try {
            switch (n) {
                case 9: {
                    this._Community = "public";
                    if (bl) break;
                }
                case 8: {
                    this._OidRoot = null;
                    if (bl) break;
                }
                case 7: {
                    this._Port = 0;
                    if (bl) break;
                }
                case 12: {
                    this._SecurityLevel = "noAuthNoPriv";
                    if (bl) break;
                }
                case 11: {
                    this._SecurityName = null;
                    if (bl) break;
                }
                case 10: {
                    this._Timeout = 5000L;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SNMPProxy";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Community")) {
            String string2 = this._Community;
            this._Community = (String)object;
            this._postSet(9, string2, this._Community);
            return;
        }
        if (string.equals("OidRoot")) {
            String string3 = this._OidRoot;
            this._OidRoot = (String)object;
            this._postSet(8, string3, this._OidRoot);
            return;
        }
        if (string.equals("Port")) {
            int n = this._Port;
            this._Port = (Integer)object;
            this._postSet(7, n, this._Port);
            return;
        }
        if (string.equals("SecurityLevel")) {
            String string4 = this._SecurityLevel;
            this._SecurityLevel = (String)object;
            this._postSet(12, string4, this._SecurityLevel);
            return;
        }
        if (string.equals("SecurityName")) {
            String string5 = this._SecurityName;
            this._SecurityName = (String)object;
            this._postSet(11, string5, this._SecurityName);
            return;
        }
        if (string.equals("Timeout")) {
            long l = this._Timeout;
            this._Timeout = (Long)object;
            this._postSet(10, l, this._Timeout);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Community")) {
            return this._Community;
        }
        if (string.equals("OidRoot")) {
            return this._OidRoot;
        }
        if (string.equals("Port")) {
            return new Integer(this._Port);
        }
        if (string.equals("SecurityLevel")) {
            return this._SecurityLevel;
        }
        if (string.equals("SecurityName")) {
            return this._SecurityName;
        }
        if (string.equals("Timeout")) {
            return new Long(this._Timeout);
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonEmptyString((String)"Community", (String)"public");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is zero-length. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-zero-length value on @default annotation. Refer annotation legalZeroLength on property Community in SNMPProxyMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"SecurityLevel", (Object)"noAuthNoPriv");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property SecurityLevel in SNMPProxyMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 9: {
                    if (!string.equals("community")) break;
                    return 9;
                }
                case 8: {
                    if (!string.equals("oid-root")) break;
                    return 8;
                }
                case 4: {
                    if (!string.equals("port")) break;
                    return 7;
                }
                case 14: {
                    if (!string.equals("security-level")) break;
                    return 12;
                }
                case 13: {
                    if (!string.equals("security-name")) break;
                    return 11;
                }
                case 7: {
                    if (!string.equals("timeout")) break;
                    return 10;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 9: {
                    return "community";
                }
                case 8: {
                    return "oid-root";
                }
                case 7: {
                    return "port";
                }
                case 12: {
                    return "security-level";
                }
                case 11: {
                    return "security-name";
                }
                case 10: {
                    return "timeout";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private SNMPProxyMBeanImpl bean;

        protected Helper(SNMPProxyMBeanImpl sNMPProxyMBeanImpl) {
            super(sNMPProxyMBeanImpl);
            this.bean = sNMPProxyMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 9: {
                    return "Community";
                }
                case 8: {
                    return "OidRoot";
                }
                case 7: {
                    return "Port";
                }
                case 12: {
                    return "SecurityLevel";
                }
                case 11: {
                    return "SecurityName";
                }
                case 10: {
                    return "Timeout";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Community")) {
                return 9;
            }
            if (string.equals("OidRoot")) {
                return 8;
            }
            if (string.equals("Port")) {
                return 7;
            }
            if (string.equals("SecurityLevel")) {
                return 12;
            }
            if (string.equals("SecurityName")) {
                return 11;
            }
            if (string.equals("Timeout")) {
                return 10;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCommunitySet()) {
                    stringBuffer.append("Community");
                    stringBuffer.append(String.valueOf(this.bean.getCommunity()));
                }
                if (this.bean.isOidRootSet()) {
                    stringBuffer.append("OidRoot");
                    stringBuffer.append(String.valueOf(this.bean.getOidRoot()));
                }
                if (this.bean.isPortSet()) {
                    stringBuffer.append("Port");
                    stringBuffer.append(String.valueOf(this.bean.getPort()));
                }
                if (this.bean.isSecurityLevelSet()) {
                    stringBuffer.append("SecurityLevel");
                    stringBuffer.append(String.valueOf(this.bean.getSecurityLevel()));
                }
                if (this.bean.isSecurityNameSet()) {
                    stringBuffer.append("SecurityName");
                    stringBuffer.append(String.valueOf(this.bean.getSecurityName()));
                }
                if (this.bean.isTimeoutSet()) {
                    stringBuffer.append("Timeout");
                    stringBuffer.append(String.valueOf(this.bean.getTimeout()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SNMPProxyMBeanImpl sNMPProxyMBeanImpl = (SNMPProxyMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Community", this.bean.getCommunity(), sNMPProxyMBeanImpl.getCommunity(), true);
                this.computeDiff("OidRoot", this.bean.getOidRoot(), sNMPProxyMBeanImpl.getOidRoot(), true);
                this.computeDiff("Port", this.bean.getPort(), sNMPProxyMBeanImpl.getPort(), true);
                this.computeDiff("SecurityLevel", this.bean.getSecurityLevel(), sNMPProxyMBeanImpl.getSecurityLevel(), true);
                this.computeDiff("SecurityName", this.bean.getSecurityName(), sNMPProxyMBeanImpl.getSecurityName(), true);
                this.computeDiff("Timeout", this.bean.getTimeout(), sNMPProxyMBeanImpl.getTimeout(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SNMPProxyMBeanImpl sNMPProxyMBeanImpl = (SNMPProxyMBeanImpl)beanUpdateEvent.getSourceBean();
                SNMPProxyMBeanImpl sNMPProxyMBeanImpl2 = (SNMPProxyMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("Community")) {
                    sNMPProxyMBeanImpl.setCommunity(sNMPProxyMBeanImpl2.getCommunity());
                    sNMPProxyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("OidRoot")) {
                    sNMPProxyMBeanImpl.setOidRoot(sNMPProxyMBeanImpl2.getOidRoot());
                    sNMPProxyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("Port")) {
                    sNMPProxyMBeanImpl.setPort(sNMPProxyMBeanImpl2.getPort());
                    sNMPProxyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("SecurityLevel")) {
                    sNMPProxyMBeanImpl.setSecurityLevel(sNMPProxyMBeanImpl2.getSecurityLevel());
                    sNMPProxyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("SecurityName")) {
                    sNMPProxyMBeanImpl.setSecurityName(sNMPProxyMBeanImpl2.getSecurityName());
                    sNMPProxyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("Timeout")) {
                    sNMPProxyMBeanImpl.setTimeout(sNMPProxyMBeanImpl2.getTimeout());
                    sNMPProxyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                SNMPProxyMBeanImpl sNMPProxyMBeanImpl = (SNMPProxyMBeanImpl)abstractDescriptorBean;
                super.finishCopy(sNMPProxyMBeanImpl, bl, list);
                if ((list == null || !list.contains("Community")) && this.bean.isCommunitySet()) {
                    sNMPProxyMBeanImpl.setCommunity(this.bean.getCommunity());
                }
                if ((list == null || !list.contains("OidRoot")) && this.bean.isOidRootSet()) {
                    sNMPProxyMBeanImpl.setOidRoot(this.bean.getOidRoot());
                }
                if ((list == null || !list.contains("Port")) && this.bean.isPortSet()) {
                    sNMPProxyMBeanImpl.setPort(this.bean.getPort());
                }
                if ((list == null || !list.contains("SecurityLevel")) && this.bean.isSecurityLevelSet()) {
                    sNMPProxyMBeanImpl.setSecurityLevel(this.bean.getSecurityLevel());
                }
                if ((list == null || !list.contains("SecurityName")) && this.bean.isSecurityNameSet()) {
                    sNMPProxyMBeanImpl.setSecurityName(this.bean.getSecurityName());
                }
                if ((list == null || !list.contains("Timeout")) && this.bean.isTimeoutSet()) {
                    sNMPProxyMBeanImpl.setTimeout(this.bean.getTimeout());
                }
                return sNMPProxyMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

