/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.SNMPTrapDestinationMBean;
import weblogic.utils.collections.CombinedIterator;

public class SNMPTrapDestinationMBeanImpl
extends ConfigurationMBeanImpl
implements SNMPTrapDestinationMBean,
Serializable {
    private String _Community;
    private String _Host;
    private int _Port;
    private String _SecurityLevel;
    private String _SecurityName;
    private static SchemaHelper2 _schemaHelper;

    public SNMPTrapDestinationMBeanImpl() {
        this._initializeProperty(-1);
    }

    public SNMPTrapDestinationMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getHost() {
        return this._Host;
    }

    public boolean isHostSet() {
        return this._isSet(7);
    }

    public void setHost(String string) throws InvalidAttributeValueException, ConfigurationException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Host", (String)string);
        String string2 = this._Host;
        this._Host = string;
        this._postSet(7, string2, string);
    }

    public int getPort() {
        return this._Port;
    }

    public boolean isPortSet() {
        return this._isSet(8);
    }

    public void setPort(int n) throws InvalidAttributeValueException, ConfigurationException {
        LegalChecks.checkInRange((String)"Port", (long)n, (long)1L, (long)65535L);
        int n2 = this._Port;
        this._Port = n;
        this._postSet(8, n2, n);
    }

    public String getCommunity() {
        return this._Community;
    }

    public boolean isCommunitySet() {
        return this._isSet(9);
    }

    public void setCommunity(String string) throws InvalidAttributeValueException, ConfigurationException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Community", (String)string);
        String string2 = this._Community;
        this._Community = string;
        this._postSet(9, string2, string);
    }

    public String getSecurityName() {
        return this._SecurityName;
    }

    public boolean isSecurityNameSet() {
        return this._isSet(10);
    }

    public void setSecurityName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._SecurityName;
        this._SecurityName = string;
        this._postSet(10, string2, string);
    }

    public String getSecurityLevel() {
        if (!this._isSet(11)) {
            return this._isProductionModeEnabled() ? "authNoPriv" : "noAuthNoPriv";
        }
        return this._SecurityLevel;
    }

    public boolean isSecurityLevelSet() {
        return this._isSet(11);
    }

    public void setSecurityLevel(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"noAuthNoPriv", "authNoPriv", "authPriv"};
        string = LegalChecks.checkInEnum((String)"SecurityLevel", (String)string, (String[])stringArray);
        LegalChecks.checkNonNull((String)"SecurityLevel", (Object)string);
        String string2 = this._SecurityLevel;
        this._SecurityLevel = string;
        this._postSet(11, string2, string);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 9;
        }
        try {
            switch (n) {
                case 9: {
                    this._Community = "public";
                    if (bl) break;
                }
                case 7: {
                    this._Host = "localhost";
                    if (bl) break;
                }
                case 8: {
                    this._Port = 162;
                    if (bl) break;
                }
                case 11: {
                    this._SecurityLevel = "noAuthNoPriv";
                    if (bl) break;
                }
                case 10: {
                    this._SecurityName = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SNMPTrapDestination";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Community")) {
            String string2 = this._Community;
            this._Community = (String)object;
            this._postSet(9, string2, this._Community);
            return;
        }
        if (string.equals("Host")) {
            String string3 = this._Host;
            this._Host = (String)object;
            this._postSet(7, string3, this._Host);
            return;
        }
        if (string.equals("Port")) {
            int n = this._Port;
            this._Port = (Integer)object;
            this._postSet(8, n, this._Port);
            return;
        }
        if (string.equals("SecurityLevel")) {
            String string4 = this._SecurityLevel;
            this._SecurityLevel = (String)object;
            this._postSet(11, string4, this._SecurityLevel);
            return;
        }
        if (string.equals("SecurityName")) {
            String string5 = this._SecurityName;
            this._SecurityName = (String)object;
            this._postSet(10, string5, this._SecurityName);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Community")) {
            return this._Community;
        }
        if (string.equals("Host")) {
            return this._Host;
        }
        if (string.equals("Port")) {
            return new Integer(this._Port);
        }
        if (string.equals("SecurityLevel")) {
            return this._SecurityLevel;
        }
        if (string.equals("SecurityName")) {
            return this._SecurityName;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonEmptyString((String)"Community", (String)"public");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is zero-length. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-zero-length value on @default annotation. Refer annotation legalZeroLength on property Community in SNMPTrapDestinationMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonEmptyString((String)"Host", (String)"localhost");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is zero-length. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-zero-length value on @default annotation. Refer annotation legalZeroLength on property Host in SNMPTrapDestinationMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"SecurityLevel", (Object)"noAuthNoPriv");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property SecurityLevel in SNMPTrapDestinationMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 9: {
                    if (!string.equals("community")) break;
                    return 9;
                }
                case 4: {
                    if (string.equals("host")) {
                        return 7;
                    }
                    if (!string.equals("port")) break;
                    return 8;
                }
                case 14: {
                    if (!string.equals("security-level")) break;
                    return 11;
                }
                case 13: {
                    if (!string.equals("security-name")) break;
                    return 10;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 9: {
                    return "community";
                }
                case 7: {
                    return "host";
                }
                case 8: {
                    return "port";
                }
                case 11: {
                    return "security-level";
                }
                case 10: {
                    return "security-name";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private SNMPTrapDestinationMBeanImpl bean;

        protected Helper(SNMPTrapDestinationMBeanImpl sNMPTrapDestinationMBeanImpl) {
            super(sNMPTrapDestinationMBeanImpl);
            this.bean = sNMPTrapDestinationMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 9: {
                    return "Community";
                }
                case 7: {
                    return "Host";
                }
                case 8: {
                    return "Port";
                }
                case 11: {
                    return "SecurityLevel";
                }
                case 10: {
                    return "SecurityName";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Community")) {
                return 9;
            }
            if (string.equals("Host")) {
                return 7;
            }
            if (string.equals("Port")) {
                return 8;
            }
            if (string.equals("SecurityLevel")) {
                return 11;
            }
            if (string.equals("SecurityName")) {
                return 10;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCommunitySet()) {
                    stringBuffer.append("Community");
                    stringBuffer.append(String.valueOf(this.bean.getCommunity()));
                }
                if (this.bean.isHostSet()) {
                    stringBuffer.append("Host");
                    stringBuffer.append(String.valueOf(this.bean.getHost()));
                }
                if (this.bean.isPortSet()) {
                    stringBuffer.append("Port");
                    stringBuffer.append(String.valueOf(this.bean.getPort()));
                }
                if (this.bean.isSecurityLevelSet()) {
                    stringBuffer.append("SecurityLevel");
                    stringBuffer.append(String.valueOf(this.bean.getSecurityLevel()));
                }
                if (this.bean.isSecurityNameSet()) {
                    stringBuffer.append("SecurityName");
                    stringBuffer.append(String.valueOf(this.bean.getSecurityName()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SNMPTrapDestinationMBeanImpl sNMPTrapDestinationMBeanImpl = (SNMPTrapDestinationMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Community", this.bean.getCommunity(), sNMPTrapDestinationMBeanImpl.getCommunity(), true);
                this.computeDiff("Host", this.bean.getHost(), sNMPTrapDestinationMBeanImpl.getHost(), true);
                this.computeDiff("Port", this.bean.getPort(), sNMPTrapDestinationMBeanImpl.getPort(), true);
                this.computeDiff("SecurityLevel", this.bean.getSecurityLevel(), sNMPTrapDestinationMBeanImpl.getSecurityLevel(), true);
                this.computeDiff("SecurityName", this.bean.getSecurityName(), sNMPTrapDestinationMBeanImpl.getSecurityName(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SNMPTrapDestinationMBeanImpl sNMPTrapDestinationMBeanImpl = (SNMPTrapDestinationMBeanImpl)beanUpdateEvent.getSourceBean();
                SNMPTrapDestinationMBeanImpl sNMPTrapDestinationMBeanImpl2 = (SNMPTrapDestinationMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("Community")) {
                    sNMPTrapDestinationMBeanImpl.setCommunity(sNMPTrapDestinationMBeanImpl2.getCommunity());
                    sNMPTrapDestinationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("Host")) {
                    sNMPTrapDestinationMBeanImpl.setHost(sNMPTrapDestinationMBeanImpl2.getHost());
                    sNMPTrapDestinationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("Port")) {
                    sNMPTrapDestinationMBeanImpl.setPort(sNMPTrapDestinationMBeanImpl2.getPort());
                    sNMPTrapDestinationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("SecurityLevel")) {
                    sNMPTrapDestinationMBeanImpl.setSecurityLevel(sNMPTrapDestinationMBeanImpl2.getSecurityLevel());
                    sNMPTrapDestinationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("SecurityName")) {
                    sNMPTrapDestinationMBeanImpl.setSecurityName(sNMPTrapDestinationMBeanImpl2.getSecurityName());
                    sNMPTrapDestinationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                SNMPTrapDestinationMBeanImpl sNMPTrapDestinationMBeanImpl = (SNMPTrapDestinationMBeanImpl)abstractDescriptorBean;
                super.finishCopy(sNMPTrapDestinationMBeanImpl, bl, list);
                if ((list == null || !list.contains("Community")) && this.bean.isCommunitySet()) {
                    sNMPTrapDestinationMBeanImpl.setCommunity(this.bean.getCommunity());
                }
                if ((list == null || !list.contains("Host")) && this.bean.isHostSet()) {
                    sNMPTrapDestinationMBeanImpl.setHost(this.bean.getHost());
                }
                if ((list == null || !list.contains("Port")) && this.bean.isPortSet()) {
                    sNMPTrapDestinationMBeanImpl.setPort(this.bean.getPort());
                }
                if ((list == null || !list.contains("SecurityLevel")) && this.bean.isSecurityLevelSet()) {
                    sNMPTrapDestinationMBeanImpl.setSecurityLevel(this.bean.getSecurityLevel());
                }
                if ((list == null || !list.contains("SecurityName")) && this.bean.isSecurityNameSet()) {
                    sNMPTrapDestinationMBeanImpl.setSecurityName(this.bean.getSecurityName());
                }
                return sNMPTrapDestinationMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

