/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import weblogic.common.internal.VersionInfo;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SNMPAgentDeploymentMBean;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPAttributeChangeMBean;
import weblogic.management.configuration.SNMPJMXMonitorMBean;
import weblogic.management.configuration.SNMPProxyMBean;
import weblogic.management.configuration.SNMPTrapDestinationMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WLDFValidator;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceClient;
import weblogic.management.provider.beaninfo.BeanInfoAccess;

public class SNMPValidator {
    private static final int AUTH_FLAG = 1;
    private static final int PRIV_FLAG = 2;
    private static final boolean DEBUG = false;
    private static BeanInfoAccess beanInfoAccess;

    public static void validateSNMPAgentDeployments(DomainMBean domainMBean) {
        int n;
        SNMPAgentDeploymentMBean[] sNMPAgentDeploymentMBeanArray = domainMBean.getSNMPAgentDeployments();
        if (sNMPAgentDeploymentMBeanArray == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (n = 0; n < serverMBeanArray.length; ++n) {
            hashMap.put(serverMBeanArray[n].getName(), null);
        }
        for (n = 0; n < sNMPAgentDeploymentMBeanArray.length; ++n) {
            SNMPAgentDeploymentMBean sNMPAgentDeploymentMBean = sNMPAgentDeploymentMBeanArray[n];
            TargetMBean[] targetMBeanArray = sNMPAgentDeploymentMBean.getTargets();
            ServerMBean[] serverMBeanArray2 = WLDFValidator.getServersInTargets(targetMBeanArray);
            if (serverMBeanArray2 == null) continue;
            for (int i = 0; i < serverMBeanArray2.length; ++i) {
                String string = serverMBeanArray2[i].getName();
                String string2 = (String)hashMap.get(string);
                if (string2 != null) {
                    throw new IllegalArgumentException(SNMPLogger.logSNMPAgentDeployedToServerLoggable((String)string2, (String)string).getMessage());
                }
                hashMap.put(string, sNMPAgentDeploymentMBean.getName());
            }
        }
    }

    public static void validateSNMPProxy(SNMPProxyMBean sNMPProxyMBean) {
        WebLogicMBean webLogicMBean;
        if (sNMPProxyMBean != null && sNMPProxyMBean.getParent() != null && (webLogicMBean = sNMPProxyMBean.getParent()) instanceof SNMPAgentMBean) {
            SNMPValidator.validateProxy(sNMPProxyMBean, (SNMPAgentMBean)webLogicMBean);
        }
    }

    private static void validateProxy(SNMPProxyMBean sNMPProxyMBean, SNMPAgentMBean sNMPAgentMBean) {
        String string = sNMPProxyMBean.getSecurityName();
        String string2 = sNMPProxyMBean.getSecurityLevel();
        if (string != null && string.length() != 0) {
            int n = SNMPValidator.getSecurityLevel(sNMPAgentMBean);
            int n2 = 0;
            if (string2.equals("authNoPriv")) {
                n2 = 1;
            } else if (string2.equals("authPriv")) {
                n2 = 3;
            }
            if (n2 > n) {
                throw new IllegalArgumentException(SNMPLogger.logSNMPProxyInvalidSecurityLevelLoggable((String)sNMPAgentMBean.getName(), (String)SNMPValidator.getAgentSecurityLevelString(n), (String)sNMPProxyMBean.getName(), (String)string2).getMessage());
            }
        }
    }

    public static void validateSNMPAgent(SNMPAgentMBean sNMPAgentMBean) {
        if (sNMPAgentMBean.getSNMPTrapVersion() == 1 && sNMPAgentMBean.isInformEnabled()) {
            String string = SNMPLogger.logSNMPInvalidTrapVersionLoggable().getMessageBody();
            throw new IllegalArgumentException(string);
        }
        String string = sNMPAgentMBean.getAuthenticationProtocol();
        String string2 = sNMPAgentMBean.getPrivacyProtocol();
        if (string.equals("noAuth") && !string2.equals("noPriv")) {
            String string3 = SNMPLogger.logInvalidAuthenticationProtocolLoggable((String)sNMPAgentMBean.getName(), (String)string2).getMessageBody();
            throw new IllegalArgumentException(string3);
        }
        int n = SNMPValidator.getSecurityLevel(sNMPAgentMBean);
        String string4 = SNMPValidator.getAgentSecurityLevelString(n);
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = sNMPAgentMBean.getSNMPTrapDestinations();
        if (sNMPTrapDestinationMBeanArray != null) {
            for (int i = 0; i < sNMPTrapDestinationMBeanArray.length; ++i) {
                String string5 = sNMPTrapDestinationMBeanArray[i].getSecurityLevel();
                int n2 = 0;
                if (string5.equals("authNoPriv")) {
                    n2 = 1;
                } else if (string5.equals("authPriv")) {
                    n2 = 3;
                }
                if (n < n2) {
                    String string6 = SNMPLogger.logInvalidSNMPTrapDestinationSecurityLevelLoggable((String)sNMPTrapDestinationMBeanArray[i].getName(), (String)sNMPTrapDestinationMBeanArray[i].getSecurityLevel(), (String)string4).getMessageBody();
                    throw new IllegalArgumentException(string6);
                }
                SNMPValidator.validateSNMPTrapDestination(sNMPTrapDestinationMBeanArray[i]);
            }
        }
    }

    private static String getAgentSecurityLevelString(int n) {
        String string = "noAuthNoPriv";
        switch (n) {
            case 1: {
                string = "authNoPriv";
                break;
            }
            case 3: {
                string = "authPriv";
                break;
            }
            default: {
                string = "noAuthNoPriv";
            }
        }
        return string;
    }

    private static void validateSNMPTrapDestination(SNMPTrapDestinationMBean sNMPTrapDestinationMBean) {
        SNMPAgentMBean sNMPAgentMBean = (SNMPAgentMBean)sNMPTrapDestinationMBean.getParent();
        if (sNMPAgentMBean.getSNMPTrapVersion() == 3 && (sNMPTrapDestinationMBean.getSecurityName() == null || sNMPTrapDestinationMBean.getSecurityName().length() == 0)) {
            String string = SNMPLogger.logSecurityNameNotSpecifiedForV3TrapDestinationLoggable((String)sNMPTrapDestinationMBean.getName()).getMessageBody();
            throw new IllegalArgumentException(string);
        }
    }

    public static void validateJMXMonitorMBean(SNMPJMXMonitorMBean sNMPJMXMonitorMBean) {
        String string = sNMPJMXMonitorMBean.getMonitoredMBeanType();
        String string2 = sNMPJMXMonitorMBean.getMonitoredAttributeName();
        BeanInfo beanInfo = SNMPValidator.getBeanInfo(string);
        if (beanInfo == null) {
            Loggable loggable = SNMPLogger.logInvalidTypeNameLoggable((String)string);
            throw new IllegalArgumentException(loggable.getMessageBody());
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray != null) {
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                String string3 = propertyDescriptor.getName();
                if (string3 == null || !string3.equals(string2)) continue;
                return;
            }
        }
        Loggable loggable = SNMPLogger.logInvalidAttributeNameLoggable((String)string, (String)string2);
        throw new IllegalArgumentException(loggable.getMessageBody());
    }

    public static void validateAttributeChangeMBean(SNMPAttributeChangeMBean sNMPAttributeChangeMBean) {
        String string = sNMPAttributeChangeMBean.getAttributeMBeanType();
        String string2 = sNMPAttributeChangeMBean.getAttributeName();
        BeanInfo beanInfo = SNMPValidator.getBeanInfo(string);
        if (beanInfo == null) {
            Loggable loggable = SNMPLogger.logInvalidTypeNameLoggable((String)string);
            throw new IllegalArgumentException(loggable.getMessageBody());
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray != null) {
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                String string3 = propertyDescriptor.getName();
                if (string3 == null || !string3.equals(string2)) continue;
                return;
            }
        }
        Loggable loggable = SNMPLogger.logInvalidAttributeNameLoggable((String)string, (String)string2);
        throw new IllegalArgumentException(loggable.getMessageBody());
    }

    private static BeanInfo getBeanInfo(String string) {
        Object object;
        String string2;
        BeanInfo beanInfo;
        if (beanInfoAccess == null) {
            BeanInfoAccess beanInfoAccess = SNMPValidator.beanInfoAccess = Kernel.isServer() ? ManagementService.getBeanInfoAccess() : ManagementServiceClient.getBeanInfoAccess();
        }
        if ((beanInfo = beanInfoAccess.getBeanInfoForInterface(string, true, string2 = VersionInfo.theOne().getReleaseVersion())) == null && string.indexOf(".") == -1) {
            object = "weblogic.management.configuration." + string + "MBean";
            beanInfo = beanInfoAccess.getBeanInfoForInterface((String)object, true, string2);
        }
        if (beanInfo == null && string.indexOf(".") == -1) {
            object = "weblogic.management.runtime." + string + "MBean";
            beanInfo = beanInfoAccess.getBeanInfoForInterface((String)object, true, string2);
        }
        if ((object = (Boolean)beanInfo.getBeanDescriptor().getValue("exclude")) != null && ((Boolean)object).booleanValue()) {
            return null;
        }
        String string3 = (String)beanInfo.getBeanDescriptor().getValue("obsolete");
        if (string3 != null && string3.length() > 0) {
            return null;
        }
        return beanInfo;
    }

    public static int getSecurityLevel(SNMPAgentMBean sNMPAgentMBean) {
        if (sNMPAgentMBean == null) {
            return 0;
        }
        int n = 0;
        String string = sNMPAgentMBean.getAuthenticationProtocol();
        String string2 = sNMPAgentMBean.getPrivacyProtocol();
        if (!string.equals("noAuth")) {
            n |= 1;
        }
        if (!string2.equals("noPriv")) {
            n |= 2;
        }
        return n;
    }
}

