/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerLegalHelper;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.mbeans.custom.SSL;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class SSLMBeanImpl
extends ConfigurationMBeanImpl
implements SSLMBean,
Serializable {
    private boolean _AllowUnencryptedNullCipher;
    private String _CertAuthenticator;
    private int _CertificateCacheSize;
    private String[] _Ciphersuites;
    private String _ClientCertAlias;
    private String _ClientCertPrivateKeyPassPhrase;
    private byte[] _ClientCertPrivateKeyPassPhraseEncrypted;
    private boolean _ClientCertificateEnforced;
    private boolean _Enabled;
    private int _ExportKeyLifespan;
    private boolean _HandlerEnabled;
    private boolean _HostnameVerificationIgnored;
    private String _HostnameVerifier;
    private String _IdentityAndTrustLocations;
    private String _InboundCertificateValidation;
    private boolean _JSSEEnabled;
    private boolean _KeyEncrypted;
    private int _ListenPort;
    private boolean _ListenPortEnabled;
    private int _LoginTimeoutMillis;
    private String _Name;
    private String _OutboundCertificateValidation;
    private String _OutboundPrivateKeyAlias;
    private String _OutboundPrivateKeyPassPhrase;
    private int _PeerValidationEnforced;
    private boolean _SSLRejectionLoggingEnabled;
    private String _ServerCertificateChainFileName;
    private String _ServerCertificateFileName;
    private String _ServerKeyFileName;
    private String _ServerPrivateKeyAlias;
    private String _ServerPrivateKeyPassPhrase;
    private byte[] _ServerPrivateKeyPassPhraseEncrypted;
    private String _TrustedCAFileName;
    private boolean _TwoWaySSLEnabled;
    private boolean _UseClientCertForOutbound;
    private boolean _UseJava;
    private boolean _UseServerCerts;
    private SSL _customizer;
    private static SchemaHelper2 _schemaHelper;

    public SSLMBeanImpl() {
        try {
            this._customizer = new SSL(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public SSLMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new SSL(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isUseJava() {
        return this._UseJava;
    }

    public boolean isUseJavaSet() {
        return this._isSet(7);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setUseJava(boolean bl) {
        boolean bl2 = this._UseJava;
        this._UseJava = bl;
        this._postSet(7, bl2, bl);
    }

    public boolean isEnabled() {
        return this._Enabled;
    }

    public boolean isEnabledSet() {
        return this._isSet(8);
    }

    public void setEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._Enabled;
        this._Enabled = bl;
        this._postSet(8, bl2, bl);
    }

    public String[] getCiphersuites() {
        return this._Ciphersuites;
    }

    public boolean isCiphersuitesSet() {
        return this._isSet(9);
    }

    public void setCiphersuites(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._Ciphersuites;
        this._Ciphersuites = stringArray;
        this._postSet(9, stringArray2, stringArray);
    }

    public String getCertAuthenticator() {
        return this._CertAuthenticator;
    }

    public boolean isCertAuthenticatorSet() {
        return this._isSet(10);
    }

    public void setCertAuthenticator(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._CertAuthenticator;
        this._CertAuthenticator = string;
        this._postSet(10, string2, string);
    }

    public String getHostnameVerifier() {
        return this._HostnameVerifier;
    }

    public boolean isHostnameVerifierSet() {
        return this._isSet(11);
    }

    public void setHostnameVerifier(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._HostnameVerifier;
        this._HostnameVerifier = string;
        this._postSet(11, string2, string);
    }

    public boolean isHostnameVerificationIgnored() {
        return this._HostnameVerificationIgnored;
    }

    public boolean isHostnameVerificationIgnoredSet() {
        return this._isSet(12);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setHostnameVerificationIgnored(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._HostnameVerificationIgnored;
        this._HostnameVerificationIgnored = bl;
        this._postSet(12, bl2, bl);
    }

    public String getTrustedCAFileName() {
        return this._TrustedCAFileName;
    }

    public boolean isTrustedCAFileNameSet() {
        return this._isSet(13);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setTrustedCAFileName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TrustedCAFileName;
        this._TrustedCAFileName = string;
        this._postSet(13, string2, string);
    }

    public int getPeerValidationEnforced() {
        return this._PeerValidationEnforced;
    }

    public boolean isPeerValidationEnforcedSet() {
        return this._isSet(14);
    }

    public void setPeerValidationEnforced(int n) throws InvalidAttributeValueException {
        this._PeerValidationEnforced = n;
    }

    public boolean isKeyEncrypted() {
        return this._KeyEncrypted;
    }

    public boolean isKeyEncryptedSet() {
        return this._isSet(15);
    }

    public void setKeyEncrypted(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._KeyEncrypted;
        this._KeyEncrypted = bl;
        this._postSet(15, bl2, bl);
    }

    public int getExportKeyLifespan() {
        return this._ExportKeyLifespan;
    }

    public boolean isExportKeyLifespanSet() {
        return this._isSet(16);
    }

    public void setExportKeyLifespan(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ExportKeyLifespan", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._ExportKeyLifespan;
        this._ExportKeyLifespan = n;
        this._postSet(16, n2, n);
    }

    public boolean isClientCertificateEnforced() {
        return this._ClientCertificateEnforced;
    }

    public boolean isClientCertificateEnforcedSet() {
        return this._isSet(17);
    }

    public void setClientCertificateEnforced(boolean bl) {
        boolean bl2 = this._ClientCertificateEnforced;
        this._ClientCertificateEnforced = bl;
        this._postSet(17, bl2, bl);
    }

    public String getServerCertificateFileName() {
        return this._ServerCertificateFileName;
    }

    public boolean isServerCertificateFileNameSet() {
        return this._isSet(18);
    }

    public void setServerCertificateFileName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ServerCertificateFileName;
        this._ServerCertificateFileName = string;
        this._postSet(18, string2, string);
    }

    public int getListenPort() {
        return this._ListenPort;
    }

    public boolean isListenPortSet() {
        return this._isSet(19);
    }

    public void setListenPort(int n) {
        LegalChecks.checkInRange((String)"ListenPort", (long)n, (long)1L, (long)65535L);
        int n2 = this._ListenPort;
        this._ListenPort = n;
        this._postSet(19, n2, n);
    }

    public boolean isListenPortEnabled() {
        return this._customizer.isListenPortEnabled();
    }

    public boolean isListenPortEnabledSet() {
        return this._isSet(20);
    }

    public void setListenPortEnabled(boolean bl) throws InvalidAttributeValueException {
        this._ListenPortEnabled = bl;
    }

    public String getServerCertificateChainFileName() {
        return this._ServerCertificateChainFileName;
    }

    public boolean isServerCertificateChainFileNameSet() {
        return this._isSet(21);
    }

    public void setServerCertificateChainFileName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ServerCertificateChainFileName;
        this._ServerCertificateChainFileName = string;
        this._postSet(21, string2, string);
    }

    public int getCertificateCacheSize() {
        return this._CertificateCacheSize;
    }

    public boolean isCertificateCacheSizeSet() {
        return this._isSet(22);
    }

    public void setCertificateCacheSize(int n) {
        LegalChecks.checkInRange((String)"CertificateCacheSize", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._CertificateCacheSize;
        this._CertificateCacheSize = n;
        this._postSet(22, n2, n);
    }

    public boolean isHandlerEnabled() {
        return this._HandlerEnabled;
    }

    public boolean isHandlerEnabledSet() {
        return this._isSet(23);
    }

    public void setHandlerEnabled(boolean bl) {
        boolean bl2 = this._HandlerEnabled;
        this._HandlerEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public int getLoginTimeoutMillis() {
        return this._LoginTimeoutMillis;
    }

    public boolean isLoginTimeoutMillisSet() {
        return this._isSet(24);
    }

    public void setLoginTimeoutMillis(int n) {
        LegalChecks.checkInRange((String)"LoginTimeoutMillis", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._LoginTimeoutMillis;
        this._LoginTimeoutMillis = n;
        this._postSet(24, n2, n);
    }

    public String getServerKeyFileName() {
        return this._ServerKeyFileName;
    }

    public boolean isServerKeyFileNameSet() {
        return this._isSet(25);
    }

    public void setServerKeyFileName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ServerKeyFileName;
        this._ServerKeyFileName = string;
        this._postSet(25, string2, string);
    }

    public boolean isTwoWaySSLEnabled() {
        return this._TwoWaySSLEnabled;
    }

    public boolean isTwoWaySSLEnabledSet() {
        return this._isSet(26);
    }

    public void setTwoWaySSLEnabled(boolean bl) {
        boolean bl2 = this._TwoWaySSLEnabled;
        this._TwoWaySSLEnabled = bl;
        this._postSet(26, bl2, bl);
    }

    public String getServerPrivateKeyAlias() {
        return this._ServerPrivateKeyAlias;
    }

    public boolean isServerPrivateKeyAliasSet() {
        return this._isSet(27);
    }

    public void setServerPrivateKeyAlias(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ServerPrivateKeyAlias;
        this._ServerPrivateKeyAlias = string;
        this._postSet(27, string2, string);
    }

    public String getServerPrivateKeyPassPhrase() {
        byte[] byArray = this.getServerPrivateKeyPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("ServerPrivateKeyPassPhrase", byArray);
    }

    public boolean isServerPrivateKeyPassPhraseSet() {
        return this.isServerPrivateKeyPassPhraseEncryptedSet();
    }

    public void setServerPrivateKeyPassPhrase(String string) {
        string = string == null ? null : string.trim();
        this.setServerPrivateKeyPassPhraseEncrypted(string == null ? null : this._encrypt("ServerPrivateKeyPassPhrase", string));
    }

    public byte[] getServerPrivateKeyPassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._ServerPrivateKeyPassPhraseEncrypted);
    }

    public String getServerPrivateKeyPassPhraseEncryptedAsString() {
        byte[] byArray = this.getServerPrivateKeyPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isServerPrivateKeyPassPhraseEncryptedSet() {
        return this._isSet(29);
    }

    public void setServerPrivateKeyPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setServerPrivateKeyPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isSSLRejectionLoggingEnabled() {
        return this._SSLRejectionLoggingEnabled;
    }

    public boolean isSSLRejectionLoggingEnabledSet() {
        return this._isSet(30);
    }

    public void setSSLRejectionLoggingEnabled(boolean bl) {
        boolean bl2 = this._SSLRejectionLoggingEnabled;
        this._SSLRejectionLoggingEnabled = bl;
        this._postSet(30, bl2, bl);
    }

    public String getIdentityAndTrustLocations() {
        return this._IdentityAndTrustLocations;
    }

    public boolean isIdentityAndTrustLocationsSet() {
        return this._isSet(31);
    }

    public void setIdentityAndTrustLocations(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"KeyStores", "FilesOrKeyStoreProviders"};
        string = LegalChecks.checkInEnum((String)"IdentityAndTrustLocations", (String)string, (String[])stringArray);
        String string2 = this._IdentityAndTrustLocations;
        this._IdentityAndTrustLocations = string;
        this._postSet(31, string2, string);
    }

    public String getInboundCertificateValidation() {
        return this._InboundCertificateValidation;
    }

    public boolean isInboundCertificateValidationSet() {
        return this._isSet(32);
    }

    public void setInboundCertificateValidation(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"BuiltinSSLValidationOnly", "BuiltinSSLValidationAndCertPathValidators"};
        string = LegalChecks.checkInEnum((String)"InboundCertificateValidation", (String)string, (String[])stringArray);
        String string2 = this._InboundCertificateValidation;
        this._InboundCertificateValidation = string;
        this._postSet(32, string2, string);
    }

    public String getOutboundCertificateValidation() {
        return this._OutboundCertificateValidation;
    }

    public boolean isOutboundCertificateValidationSet() {
        return this._isSet(33);
    }

    public void setOutboundCertificateValidation(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"BuiltinSSLValidationOnly", "BuiltinSSLValidationAndCertPathValidators"};
        string = LegalChecks.checkInEnum((String)"OutboundCertificateValidation", (String)string, (String[])stringArray);
        String string2 = this._OutboundCertificateValidation;
        this._OutboundCertificateValidation = string;
        this._postSet(33, string2, string);
    }

    public void setAllowUnencryptedNullCipher(boolean bl) {
        boolean bl2 = this._AllowUnencryptedNullCipher;
        this._AllowUnencryptedNullCipher = bl;
        this._postSet(34, bl2, bl);
    }

    public boolean isAllowUnencryptedNullCipher() {
        return this._AllowUnencryptedNullCipher;
    }

    public boolean isAllowUnencryptedNullCipherSet() {
        return this._isSet(34);
    }

    public boolean isUseServerCerts() {
        return this._UseServerCerts;
    }

    public boolean isUseServerCertsSet() {
        return this._isSet(35);
    }

    public void setUseServerCerts(boolean bl) {
        boolean bl2 = this._UseServerCerts;
        this._UseServerCerts = bl;
        this._postSet(35, bl2, bl);
    }

    public void setJSSEEnabled(boolean bl) {
        boolean bl2 = this._JSSEEnabled;
        this._JSSEEnabled = bl;
        this._postSet(36, bl2, bl);
    }

    public boolean isJSSEEnabled() {
        if (!this._isSet(36)) {
            try {
                return ((DomainMBean)((ServerMBean)this.getParent()).getParent()).isExalogicOptimizationsEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._JSSEEnabled;
    }

    public boolean isJSSEEnabledSet() {
        return this._isSet(36);
    }

    public void setUseClientCertForOutbound(boolean bl) {
        boolean bl2 = this._UseClientCertForOutbound;
        this._UseClientCertForOutbound = bl;
        this._postSet(37, bl2, bl);
    }

    public boolean isUseClientCertForOutbound() {
        return this._UseClientCertForOutbound;
    }

    public boolean isUseClientCertForOutboundSet() {
        return this._isSet(37);
    }

    public void setClientCertAlias(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ClientCertAlias;
        this._ClientCertAlias = string;
        this._postSet(38, string2, string);
    }

    public String getClientCertAlias() {
        return this._ClientCertAlias;
    }

    public boolean isClientCertAliasSet() {
        return this._isSet(38);
    }

    public String getClientCertPrivateKeyPassPhrase() {
        byte[] byArray = this.getClientCertPrivateKeyPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("ClientCertPrivateKeyPassPhrase", byArray);
    }

    public boolean isClientCertPrivateKeyPassPhraseSet() {
        return this.isClientCertPrivateKeyPassPhraseEncryptedSet();
    }

    public void setClientCertPrivateKeyPassPhrase(String string) {
        string = string == null ? null : string.trim();
        this.setClientCertPrivateKeyPassPhraseEncrypted(string == null ? null : this._encrypt("ClientCertPrivateKeyPassPhrase", string));
    }

    public byte[] getClientCertPrivateKeyPassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._ClientCertPrivateKeyPassPhraseEncrypted);
    }

    public String getClientCertPrivateKeyPassPhraseEncryptedAsString() {
        byte[] byArray = this.getClientCertPrivateKeyPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isClientCertPrivateKeyPassPhraseEncryptedSet() {
        return this._isSet(40);
    }

    public void setClientCertPrivateKeyPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setClientCertPrivateKeyPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getOutboundPrivateKeyAlias() {
        if (!this._isSet(41)) {
            try {
                return this.isUseClientCertForOutbound() ? this.getClientCertAlias() : this.getServerPrivateKeyAlias();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OutboundPrivateKeyAlias;
    }

    public boolean isOutboundPrivateKeyAliasSet() {
        return this._isSet(41);
    }

    public void setOutboundPrivateKeyAlias(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._OutboundPrivateKeyAlias;
        this._OutboundPrivateKeyAlias = string;
        this._postSet(41, string2, string);
    }

    public String getOutboundPrivateKeyPassPhrase() {
        if (!this._isSet(42)) {
            try {
                return this.isUseClientCertForOutbound() ? this.getClientCertPrivateKeyPassPhrase() : this.getServerPrivateKeyPassPhrase();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OutboundPrivateKeyPassPhrase;
    }

    public boolean isOutboundPrivateKeyPassPhraseSet() {
        return this._isSet(42);
    }

    public void setOutboundPrivateKeyPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._OutboundPrivateKeyPassPhrase;
        this._OutboundPrivateKeyPassPhrase = string;
        this._postSet(42, string2, string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        ServerLegalHelper.validateSSL(this);
    }

    public void setClientCertPrivateKeyPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._ClientCertPrivateKeyPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: ClientCertPrivateKeyPassPhraseEncrypted of SSLMBean");
        }
        this._getHelper()._clearArray(this._ClientCertPrivateKeyPassPhraseEncrypted);
        this._ClientCertPrivateKeyPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(40, byArray2, byArray);
    }

    public void setServerPrivateKeyPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._ServerPrivateKeyPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: ServerPrivateKeyPassPhraseEncrypted of SSLMBean");
        }
        this._getHelper()._clearArray(this._ServerPrivateKeyPassPhraseEncrypted);
        this._ServerPrivateKeyPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(29, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 39) {
                this._markSet(40, false);
            }
            if (n == 28) {
                this._markSet(29, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 10;
        }
        try {
            switch (n) {
                case 10: {
                    this._CertAuthenticator = null;
                    if (bl) break;
                }
                case 22: {
                    this._CertificateCacheSize = 3;
                    if (bl) break;
                }
                case 9: {
                    this._Ciphersuites = new String[0];
                    if (bl) break;
                }
                case 38: {
                    this._ClientCertAlias = null;
                    if (bl) break;
                }
                case 39: {
                    this._ClientCertPrivateKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 40: {
                    this._ClientCertPrivateKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 16: {
                    this._ExportKeyLifespan = 500;
                    if (bl) break;
                }
                case 11: {
                    this._HostnameVerifier = null;
                    if (bl) break;
                }
                case 31: {
                    this._IdentityAndTrustLocations = "KeyStores";
                    if (bl) break;
                }
                case 32: {
                    this._InboundCertificateValidation = "BuiltinSSLValidationOnly";
                    if (bl) break;
                }
                case 19: {
                    this._ListenPort = 7002;
                    if (bl) break;
                }
                case 24: {
                    this._LoginTimeoutMillis = 25000;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 33: {
                    this._OutboundCertificateValidation = "BuiltinSSLValidationOnly";
                    if (bl) break;
                }
                case 41: {
                    this._OutboundPrivateKeyAlias = null;
                    if (bl) break;
                }
                case 42: {
                    this._OutboundPrivateKeyPassPhrase = null;
                    if (bl) break;
                }
                case 14: {
                    this._PeerValidationEnforced = 0;
                    if (bl) break;
                }
                case 21: {
                    this._ServerCertificateChainFileName = "server-certchain.pem";
                    if (bl) break;
                }
                case 18: {
                    this._ServerCertificateFileName = "server-cert.der";
                    if (bl) break;
                }
                case 25: {
                    this._ServerKeyFileName = "server-key.der";
                    if (bl) break;
                }
                case 27: {
                    this._ServerPrivateKeyAlias = null;
                    if (bl) break;
                }
                case 28: {
                    this._ServerPrivateKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 29: {
                    this._ServerPrivateKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 13: {
                    this._TrustedCAFileName = "trusted-ca.pem";
                    if (bl) break;
                }
                case 34: {
                    this._AllowUnencryptedNullCipher = false;
                    if (bl) break;
                }
                case 17: {
                    this._ClientCertificateEnforced = false;
                    if (bl) break;
                }
                case 8: {
                    this._Enabled = false;
                    if (bl) break;
                }
                case 23: {
                    this._HandlerEnabled = true;
                    if (bl) break;
                }
                case 12: {
                    this._HostnameVerificationIgnored = false;
                    if (bl) break;
                }
                case 36: {
                    this._JSSEEnabled = false;
                    if (bl) break;
                }
                case 15: {
                    this._KeyEncrypted = false;
                    if (bl) break;
                }
                case 20: {
                    this._ListenPortEnabled = false;
                    if (bl) break;
                }
                case 30: {
                    this._SSLRejectionLoggingEnabled = true;
                    if (bl) break;
                }
                case 26: {
                    this._TwoWaySSLEnabled = false;
                    if (bl) break;
                }
                case 37: {
                    this._UseClientCertForOutbound = false;
                    if (bl) break;
                }
                case 7: {
                    this._UseJava = true;
                    if (bl) break;
                }
                case 35: {
                    this._UseServerCerts = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SSL";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AllowUnencryptedNullCipher")) {
            boolean bl = this._AllowUnencryptedNullCipher;
            this._AllowUnencryptedNullCipher = (Boolean)object;
            this._postSet(34, bl, this._AllowUnencryptedNullCipher);
            return;
        }
        if (string.equals("CertAuthenticator")) {
            String string2 = this._CertAuthenticator;
            this._CertAuthenticator = (String)object;
            this._postSet(10, string2, this._CertAuthenticator);
            return;
        }
        if (string.equals("CertificateCacheSize")) {
            int n = this._CertificateCacheSize;
            this._CertificateCacheSize = (Integer)object;
            this._postSet(22, n, this._CertificateCacheSize);
            return;
        }
        if (string.equals("Ciphersuites")) {
            String[] stringArray = this._Ciphersuites;
            this._Ciphersuites = (String[])object;
            this._postSet(9, stringArray, this._Ciphersuites);
            return;
        }
        if (string.equals("ClientCertAlias")) {
            String string3 = this._ClientCertAlias;
            this._ClientCertAlias = (String)object;
            this._postSet(38, string3, this._ClientCertAlias);
            return;
        }
        if (string.equals("ClientCertPrivateKeyPassPhrase")) {
            String string4 = this._ClientCertPrivateKeyPassPhrase;
            this._ClientCertPrivateKeyPassPhrase = (String)object;
            this._postSet(39, string4, this._ClientCertPrivateKeyPassPhrase);
            return;
        }
        if (string.equals("ClientCertPrivateKeyPassPhraseEncrypted")) {
            byte[] byArray = this._ClientCertPrivateKeyPassPhraseEncrypted;
            this._ClientCertPrivateKeyPassPhraseEncrypted = (byte[])object;
            this._postSet(40, byArray, this._ClientCertPrivateKeyPassPhraseEncrypted);
            return;
        }
        if (string.equals("ClientCertificateEnforced")) {
            boolean bl = this._ClientCertificateEnforced;
            this._ClientCertificateEnforced = (Boolean)object;
            this._postSet(17, bl, this._ClientCertificateEnforced);
            return;
        }
        if (string.equals("Enabled")) {
            boolean bl = this._Enabled;
            this._Enabled = (Boolean)object;
            this._postSet(8, bl, this._Enabled);
            return;
        }
        if (string.equals("ExportKeyLifespan")) {
            int n = this._ExportKeyLifespan;
            this._ExportKeyLifespan = (Integer)object;
            this._postSet(16, n, this._ExportKeyLifespan);
            return;
        }
        if (string.equals("HandlerEnabled")) {
            boolean bl = this._HandlerEnabled;
            this._HandlerEnabled = (Boolean)object;
            this._postSet(23, bl, this._HandlerEnabled);
            return;
        }
        if (string.equals("HostnameVerificationIgnored")) {
            boolean bl = this._HostnameVerificationIgnored;
            this._HostnameVerificationIgnored = (Boolean)object;
            this._postSet(12, bl, this._HostnameVerificationIgnored);
            return;
        }
        if (string.equals("HostnameVerifier")) {
            String string5 = this._HostnameVerifier;
            this._HostnameVerifier = (String)object;
            this._postSet(11, string5, this._HostnameVerifier);
            return;
        }
        if (string.equals("IdentityAndTrustLocations")) {
            String string6 = this._IdentityAndTrustLocations;
            this._IdentityAndTrustLocations = (String)object;
            this._postSet(31, string6, this._IdentityAndTrustLocations);
            return;
        }
        if (string.equals("InboundCertificateValidation")) {
            String string7 = this._InboundCertificateValidation;
            this._InboundCertificateValidation = (String)object;
            this._postSet(32, string7, this._InboundCertificateValidation);
            return;
        }
        if (string.equals("JSSEEnabled")) {
            boolean bl = this._JSSEEnabled;
            this._JSSEEnabled = (Boolean)object;
            this._postSet(36, bl, this._JSSEEnabled);
            return;
        }
        if (string.equals("KeyEncrypted")) {
            boolean bl = this._KeyEncrypted;
            this._KeyEncrypted = (Boolean)object;
            this._postSet(15, bl, this._KeyEncrypted);
            return;
        }
        if (string.equals("ListenPort")) {
            int n = this._ListenPort;
            this._ListenPort = (Integer)object;
            this._postSet(19, n, this._ListenPort);
            return;
        }
        if (string.equals("ListenPortEnabled")) {
            boolean bl = this._ListenPortEnabled;
            this._ListenPortEnabled = (Boolean)object;
            this._postSet(20, bl, this._ListenPortEnabled);
            return;
        }
        if (string.equals("LoginTimeoutMillis")) {
            int n = this._LoginTimeoutMillis;
            this._LoginTimeoutMillis = (Integer)object;
            this._postSet(24, n, this._LoginTimeoutMillis);
            return;
        }
        if (string.equals("Name")) {
            String string8 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string8, this._Name);
            return;
        }
        if (string.equals("OutboundCertificateValidation")) {
            String string9 = this._OutboundCertificateValidation;
            this._OutboundCertificateValidation = (String)object;
            this._postSet(33, string9, this._OutboundCertificateValidation);
            return;
        }
        if (string.equals("OutboundPrivateKeyAlias")) {
            String string10 = this._OutboundPrivateKeyAlias;
            this._OutboundPrivateKeyAlias = (String)object;
            this._postSet(41, string10, this._OutboundPrivateKeyAlias);
            return;
        }
        if (string.equals("OutboundPrivateKeyPassPhrase")) {
            String string11 = this._OutboundPrivateKeyPassPhrase;
            this._OutboundPrivateKeyPassPhrase = (String)object;
            this._postSet(42, string11, this._OutboundPrivateKeyPassPhrase);
            return;
        }
        if (string.equals("PeerValidationEnforced")) {
            int n = this._PeerValidationEnforced;
            this._PeerValidationEnforced = (Integer)object;
            this._postSet(14, n, this._PeerValidationEnforced);
            return;
        }
        if (string.equals("SSLRejectionLoggingEnabled")) {
            boolean bl = this._SSLRejectionLoggingEnabled;
            this._SSLRejectionLoggingEnabled = (Boolean)object;
            this._postSet(30, bl, this._SSLRejectionLoggingEnabled);
            return;
        }
        if (string.equals("ServerCertificateChainFileName")) {
            String string12 = this._ServerCertificateChainFileName;
            this._ServerCertificateChainFileName = (String)object;
            this._postSet(21, string12, this._ServerCertificateChainFileName);
            return;
        }
        if (string.equals("ServerCertificateFileName")) {
            String string13 = this._ServerCertificateFileName;
            this._ServerCertificateFileName = (String)object;
            this._postSet(18, string13, this._ServerCertificateFileName);
            return;
        }
        if (string.equals("ServerKeyFileName")) {
            String string14 = this._ServerKeyFileName;
            this._ServerKeyFileName = (String)object;
            this._postSet(25, string14, this._ServerKeyFileName);
            return;
        }
        if (string.equals("ServerPrivateKeyAlias")) {
            String string15 = this._ServerPrivateKeyAlias;
            this._ServerPrivateKeyAlias = (String)object;
            this._postSet(27, string15, this._ServerPrivateKeyAlias);
            return;
        }
        if (string.equals("ServerPrivateKeyPassPhrase")) {
            String string16 = this._ServerPrivateKeyPassPhrase;
            this._ServerPrivateKeyPassPhrase = (String)object;
            this._postSet(28, string16, this._ServerPrivateKeyPassPhrase);
            return;
        }
        if (string.equals("ServerPrivateKeyPassPhraseEncrypted")) {
            byte[] byArray = this._ServerPrivateKeyPassPhraseEncrypted;
            this._ServerPrivateKeyPassPhraseEncrypted = (byte[])object;
            this._postSet(29, byArray, this._ServerPrivateKeyPassPhraseEncrypted);
            return;
        }
        if (string.equals("TrustedCAFileName")) {
            String string17 = this._TrustedCAFileName;
            this._TrustedCAFileName = (String)object;
            this._postSet(13, string17, this._TrustedCAFileName);
            return;
        }
        if (string.equals("TwoWaySSLEnabled")) {
            boolean bl = this._TwoWaySSLEnabled;
            this._TwoWaySSLEnabled = (Boolean)object;
            this._postSet(26, bl, this._TwoWaySSLEnabled);
            return;
        }
        if (string.equals("UseClientCertForOutbound")) {
            boolean bl = this._UseClientCertForOutbound;
            this._UseClientCertForOutbound = (Boolean)object;
            this._postSet(37, bl, this._UseClientCertForOutbound);
            return;
        }
        if (string.equals("UseJava")) {
            boolean bl = this._UseJava;
            this._UseJava = (Boolean)object;
            this._postSet(7, bl, this._UseJava);
            return;
        }
        if (string.equals("UseServerCerts")) {
            boolean bl = this._UseServerCerts;
            this._UseServerCerts = (Boolean)object;
            this._postSet(35, bl, this._UseServerCerts);
            return;
        }
        if (string.equals("customizer")) {
            SSL sSL = this._customizer;
            this._customizer = (SSL)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AllowUnencryptedNullCipher")) {
            return new Boolean(this._AllowUnencryptedNullCipher);
        }
        if (string.equals("CertAuthenticator")) {
            return this._CertAuthenticator;
        }
        if (string.equals("CertificateCacheSize")) {
            return new Integer(this._CertificateCacheSize);
        }
        if (string.equals("Ciphersuites")) {
            return this._Ciphersuites;
        }
        if (string.equals("ClientCertAlias")) {
            return this._ClientCertAlias;
        }
        if (string.equals("ClientCertPrivateKeyPassPhrase")) {
            return this._ClientCertPrivateKeyPassPhrase;
        }
        if (string.equals("ClientCertPrivateKeyPassPhraseEncrypted")) {
            return this._ClientCertPrivateKeyPassPhraseEncrypted;
        }
        if (string.equals("ClientCertificateEnforced")) {
            return new Boolean(this._ClientCertificateEnforced);
        }
        if (string.equals("Enabled")) {
            return new Boolean(this._Enabled);
        }
        if (string.equals("ExportKeyLifespan")) {
            return new Integer(this._ExportKeyLifespan);
        }
        if (string.equals("HandlerEnabled")) {
            return new Boolean(this._HandlerEnabled);
        }
        if (string.equals("HostnameVerificationIgnored")) {
            return new Boolean(this._HostnameVerificationIgnored);
        }
        if (string.equals("HostnameVerifier")) {
            return this._HostnameVerifier;
        }
        if (string.equals("IdentityAndTrustLocations")) {
            return this._IdentityAndTrustLocations;
        }
        if (string.equals("InboundCertificateValidation")) {
            return this._InboundCertificateValidation;
        }
        if (string.equals("JSSEEnabled")) {
            return new Boolean(this._JSSEEnabled);
        }
        if (string.equals("KeyEncrypted")) {
            return new Boolean(this._KeyEncrypted);
        }
        if (string.equals("ListenPort")) {
            return new Integer(this._ListenPort);
        }
        if (string.equals("ListenPortEnabled")) {
            return new Boolean(this._ListenPortEnabled);
        }
        if (string.equals("LoginTimeoutMillis")) {
            return new Integer(this._LoginTimeoutMillis);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("OutboundCertificateValidation")) {
            return this._OutboundCertificateValidation;
        }
        if (string.equals("OutboundPrivateKeyAlias")) {
            return this._OutboundPrivateKeyAlias;
        }
        if (string.equals("OutboundPrivateKeyPassPhrase")) {
            return this._OutboundPrivateKeyPassPhrase;
        }
        if (string.equals("PeerValidationEnforced")) {
            return new Integer(this._PeerValidationEnforced);
        }
        if (string.equals("SSLRejectionLoggingEnabled")) {
            return new Boolean(this._SSLRejectionLoggingEnabled);
        }
        if (string.equals("ServerCertificateChainFileName")) {
            return this._ServerCertificateChainFileName;
        }
        if (string.equals("ServerCertificateFileName")) {
            return this._ServerCertificateFileName;
        }
        if (string.equals("ServerKeyFileName")) {
            return this._ServerKeyFileName;
        }
        if (string.equals("ServerPrivateKeyAlias")) {
            return this._ServerPrivateKeyAlias;
        }
        if (string.equals("ServerPrivateKeyPassPhrase")) {
            return this._ServerPrivateKeyPassPhrase;
        }
        if (string.equals("ServerPrivateKeyPassPhraseEncrypted")) {
            return this._ServerPrivateKeyPassPhraseEncrypted;
        }
        if (string.equals("TrustedCAFileName")) {
            return this._TrustedCAFileName;
        }
        if (string.equals("TwoWaySSLEnabled")) {
            return new Boolean(this._TwoWaySSLEnabled);
        }
        if (string.equals("UseClientCertForOutbound")) {
            return new Boolean(this._UseClientCertForOutbound);
        }
        if (string.equals("UseJava")) {
            return new Boolean(this._UseJava);
        }
        if (string.equals("UseServerCerts")) {
            return new Boolean(this._UseServerCerts);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 18: {
                    if (string.equals("cert-authenticator")) {
                        return 10;
                    }
                    if (!string.equals("two-wayssl-enabled")) break;
                    return 26;
                }
                case 22: {
                    if (!string.equals("certificate-cache-size")) break;
                    return 22;
                }
                case 11: {
                    if (string.equals("ciphersuite")) {
                        return 9;
                    }
                    if (!string.equals("listen-port")) break;
                    return 19;
                }
                case 17: {
                    if (string.equals("client-cert-alias")) {
                        return 38;
                    }
                    if (!string.equals("hostname-verifier")) break;
                    return 11;
                }
                case 35: {
                    if (!string.equals("client-cert-private-key-pass-phrase")) break;
                    return 39;
                }
                case 45: {
                    if (!string.equals("client-cert-private-key-pass-phrase-encrypted")) break;
                    return 40;
                }
                case 19: {
                    if (string.equals("export-key-lifespan")) {
                        return 16;
                    }
                    if (string.equals("trustedca-file-name")) {
                        return 13;
                    }
                    if (!string.equals("listen-port-enabled")) break;
                    return 20;
                }
                case 28: {
                    if (string.equals("identity-and-trust-locations")) {
                        return 31;
                    }
                    if (string.equals("server-certificate-file-name")) {
                        return 18;
                    }
                    if (!string.equals("use-client-cert-for-outbound")) break;
                    return 37;
                }
                case 30: {
                    if (string.equals("inbound-certificate-validation")) {
                        return 32;
                    }
                    if (!string.equals("server-private-key-pass-phrase")) break;
                    return 28;
                }
                case 20: {
                    if (string.equals("login-timeout-millis")) {
                        return 24;
                    }
                    if (!string.equals("server-key-file-name")) break;
                    return 25;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 31: {
                    if (!string.equals("outbound-certificate-validation")) break;
                    return 33;
                }
                case 26: {
                    if (!string.equals("outbound-private-key-alias")) break;
                    return 41;
                }
                case 32: {
                    if (!string.equals("outbound-private-key-pass-phrase")) break;
                    return 42;
                }
                case 24: {
                    if (string.equals("peer-validation-enforced")) {
                        return 14;
                    }
                    if (!string.equals("server-private-key-alias")) break;
                    return 27;
                }
                case 34: {
                    if (!string.equals("server-certificate-chain-file-name")) break;
                    return 21;
                }
                case 40: {
                    if (!string.equals("server-private-key-pass-phrase-encrypted")) break;
                    return 29;
                }
                case 29: {
                    if (string.equals("allow-unencrypted-null-cipher")) {
                        return 34;
                    }
                    if (string.equals("hostname-verification-ignored")) {
                        return 12;
                    }
                    if (!string.equals("ssl-rejection-logging-enabled")) break;
                    return 30;
                }
                case 27: {
                    if (!string.equals("client-certificate-enforced")) break;
                    return 17;
                }
                case 7: {
                    if (!string.equals("enabled")) break;
                    return 8;
                }
                case 15: {
                    if (!string.equals("handler-enabled")) break;
                    return 23;
                }
                case 12: {
                    if (!string.equals("jsse-enabled")) break;
                    return 36;
                }
                case 13: {
                    if (!string.equals("key-encrypted")) break;
                    return 15;
                }
                case 8: {
                    if (!string.equals("use-java")) break;
                    return 7;
                }
                case 16: {
                    if (!string.equals("use-server-certs")) break;
                    return 35;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 10: {
                    return "cert-authenticator";
                }
                case 22: {
                    return "certificate-cache-size";
                }
                case 9: {
                    return "ciphersuite";
                }
                case 38: {
                    return "client-cert-alias";
                }
                case 39: {
                    return "client-cert-private-key-pass-phrase";
                }
                case 40: {
                    return "client-cert-private-key-pass-phrase-encrypted";
                }
                case 16: {
                    return "export-key-lifespan";
                }
                case 11: {
                    return "hostname-verifier";
                }
                case 31: {
                    return "identity-and-trust-locations";
                }
                case 32: {
                    return "inbound-certificate-validation";
                }
                case 19: {
                    return "listen-port";
                }
                case 24: {
                    return "login-timeout-millis";
                }
                case 2: {
                    return "name";
                }
                case 33: {
                    return "outbound-certificate-validation";
                }
                case 41: {
                    return "outbound-private-key-alias";
                }
                case 42: {
                    return "outbound-private-key-pass-phrase";
                }
                case 14: {
                    return "peer-validation-enforced";
                }
                case 21: {
                    return "server-certificate-chain-file-name";
                }
                case 18: {
                    return "server-certificate-file-name";
                }
                case 25: {
                    return "server-key-file-name";
                }
                case 27: {
                    return "server-private-key-alias";
                }
                case 28: {
                    return "server-private-key-pass-phrase";
                }
                case 29: {
                    return "server-private-key-pass-phrase-encrypted";
                }
                case 13: {
                    return "trustedca-file-name";
                }
                case 34: {
                    return "allow-unencrypted-null-cipher";
                }
                case 17: {
                    return "client-certificate-enforced";
                }
                case 8: {
                    return "enabled";
                }
                case 23: {
                    return "handler-enabled";
                }
                case 12: {
                    return "hostname-verification-ignored";
                }
                case 36: {
                    return "jsse-enabled";
                }
                case 15: {
                    return "key-encrypted";
                }
                case 20: {
                    return "listen-port-enabled";
                }
                case 30: {
                    return "ssl-rejection-logging-enabled";
                }
                case 26: {
                    return "two-wayssl-enabled";
                }
                case 37: {
                    return "use-client-cert-for-outbound";
                }
                case 7: {
                    return "use-java";
                }
                case 35: {
                    return "use-server-certs";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 9: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private SSLMBeanImpl bean;

        protected Helper(SSLMBeanImpl sSLMBeanImpl) {
            super(sSLMBeanImpl);
            this.bean = sSLMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 10: {
                    return "CertAuthenticator";
                }
                case 22: {
                    return "CertificateCacheSize";
                }
                case 9: {
                    return "Ciphersuites";
                }
                case 38: {
                    return "ClientCertAlias";
                }
                case 39: {
                    return "ClientCertPrivateKeyPassPhrase";
                }
                case 40: {
                    return "ClientCertPrivateKeyPassPhraseEncrypted";
                }
                case 16: {
                    return "ExportKeyLifespan";
                }
                case 11: {
                    return "HostnameVerifier";
                }
                case 31: {
                    return "IdentityAndTrustLocations";
                }
                case 32: {
                    return "InboundCertificateValidation";
                }
                case 19: {
                    return "ListenPort";
                }
                case 24: {
                    return "LoginTimeoutMillis";
                }
                case 2: {
                    return "Name";
                }
                case 33: {
                    return "OutboundCertificateValidation";
                }
                case 41: {
                    return "OutboundPrivateKeyAlias";
                }
                case 42: {
                    return "OutboundPrivateKeyPassPhrase";
                }
                case 14: {
                    return "PeerValidationEnforced";
                }
                case 21: {
                    return "ServerCertificateChainFileName";
                }
                case 18: {
                    return "ServerCertificateFileName";
                }
                case 25: {
                    return "ServerKeyFileName";
                }
                case 27: {
                    return "ServerPrivateKeyAlias";
                }
                case 28: {
                    return "ServerPrivateKeyPassPhrase";
                }
                case 29: {
                    return "ServerPrivateKeyPassPhraseEncrypted";
                }
                case 13: {
                    return "TrustedCAFileName";
                }
                case 34: {
                    return "AllowUnencryptedNullCipher";
                }
                case 17: {
                    return "ClientCertificateEnforced";
                }
                case 8: {
                    return "Enabled";
                }
                case 23: {
                    return "HandlerEnabled";
                }
                case 12: {
                    return "HostnameVerificationIgnored";
                }
                case 36: {
                    return "JSSEEnabled";
                }
                case 15: {
                    return "KeyEncrypted";
                }
                case 20: {
                    return "ListenPortEnabled";
                }
                case 30: {
                    return "SSLRejectionLoggingEnabled";
                }
                case 26: {
                    return "TwoWaySSLEnabled";
                }
                case 37: {
                    return "UseClientCertForOutbound";
                }
                case 7: {
                    return "UseJava";
                }
                case 35: {
                    return "UseServerCerts";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CertAuthenticator")) {
                return 10;
            }
            if (string.equals("CertificateCacheSize")) {
                return 22;
            }
            if (string.equals("Ciphersuites")) {
                return 9;
            }
            if (string.equals("ClientCertAlias")) {
                return 38;
            }
            if (string.equals("ClientCertPrivateKeyPassPhrase")) {
                return 39;
            }
            if (string.equals("ClientCertPrivateKeyPassPhraseEncrypted")) {
                return 40;
            }
            if (string.equals("ExportKeyLifespan")) {
                return 16;
            }
            if (string.equals("HostnameVerifier")) {
                return 11;
            }
            if (string.equals("IdentityAndTrustLocations")) {
                return 31;
            }
            if (string.equals("InboundCertificateValidation")) {
                return 32;
            }
            if (string.equals("ListenPort")) {
                return 19;
            }
            if (string.equals("LoginTimeoutMillis")) {
                return 24;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("OutboundCertificateValidation")) {
                return 33;
            }
            if (string.equals("OutboundPrivateKeyAlias")) {
                return 41;
            }
            if (string.equals("OutboundPrivateKeyPassPhrase")) {
                return 42;
            }
            if (string.equals("PeerValidationEnforced")) {
                return 14;
            }
            if (string.equals("ServerCertificateChainFileName")) {
                return 21;
            }
            if (string.equals("ServerCertificateFileName")) {
                return 18;
            }
            if (string.equals("ServerKeyFileName")) {
                return 25;
            }
            if (string.equals("ServerPrivateKeyAlias")) {
                return 27;
            }
            if (string.equals("ServerPrivateKeyPassPhrase")) {
                return 28;
            }
            if (string.equals("ServerPrivateKeyPassPhraseEncrypted")) {
                return 29;
            }
            if (string.equals("TrustedCAFileName")) {
                return 13;
            }
            if (string.equals("AllowUnencryptedNullCipher")) {
                return 34;
            }
            if (string.equals("ClientCertificateEnforced")) {
                return 17;
            }
            if (string.equals("Enabled")) {
                return 8;
            }
            if (string.equals("HandlerEnabled")) {
                return 23;
            }
            if (string.equals("HostnameVerificationIgnored")) {
                return 12;
            }
            if (string.equals("JSSEEnabled")) {
                return 36;
            }
            if (string.equals("KeyEncrypted")) {
                return 15;
            }
            if (string.equals("ListenPortEnabled")) {
                return 20;
            }
            if (string.equals("SSLRejectionLoggingEnabled")) {
                return 30;
            }
            if (string.equals("TwoWaySSLEnabled")) {
                return 26;
            }
            if (string.equals("UseClientCertForOutbound")) {
                return 37;
            }
            if (string.equals("UseJava")) {
                return 7;
            }
            if (string.equals("UseServerCerts")) {
                return 35;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCertAuthenticatorSet()) {
                    stringBuffer.append("CertAuthenticator");
                    stringBuffer.append(String.valueOf(this.bean.getCertAuthenticator()));
                }
                if (this.bean.isCertificateCacheSizeSet()) {
                    stringBuffer.append("CertificateCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getCertificateCacheSize()));
                }
                if (this.bean.isCiphersuitesSet()) {
                    stringBuffer.append("Ciphersuites");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getCiphersuites())));
                }
                if (this.bean.isClientCertAliasSet()) {
                    stringBuffer.append("ClientCertAlias");
                    stringBuffer.append(String.valueOf(this.bean.getClientCertAlias()));
                }
                if (this.bean.isClientCertPrivateKeyPassPhraseSet()) {
                    stringBuffer.append("ClientCertPrivateKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getClientCertPrivateKeyPassPhrase()));
                }
                if (this.bean.isClientCertPrivateKeyPassPhraseEncryptedSet()) {
                    stringBuffer.append("ClientCertPrivateKeyPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getClientCertPrivateKeyPassPhraseEncrypted())));
                }
                if (this.bean.isExportKeyLifespanSet()) {
                    stringBuffer.append("ExportKeyLifespan");
                    stringBuffer.append(String.valueOf(this.bean.getExportKeyLifespan()));
                }
                if (this.bean.isHostnameVerifierSet()) {
                    stringBuffer.append("HostnameVerifier");
                    stringBuffer.append(String.valueOf(this.bean.getHostnameVerifier()));
                }
                if (this.bean.isIdentityAndTrustLocationsSet()) {
                    stringBuffer.append("IdentityAndTrustLocations");
                    stringBuffer.append(String.valueOf(this.bean.getIdentityAndTrustLocations()));
                }
                if (this.bean.isInboundCertificateValidationSet()) {
                    stringBuffer.append("InboundCertificateValidation");
                    stringBuffer.append(String.valueOf(this.bean.getInboundCertificateValidation()));
                }
                if (this.bean.isListenPortSet()) {
                    stringBuffer.append("ListenPort");
                    stringBuffer.append(String.valueOf(this.bean.getListenPort()));
                }
                if (this.bean.isLoginTimeoutMillisSet()) {
                    stringBuffer.append("LoginTimeoutMillis");
                    stringBuffer.append(String.valueOf(this.bean.getLoginTimeoutMillis()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isOutboundCertificateValidationSet()) {
                    stringBuffer.append("OutboundCertificateValidation");
                    stringBuffer.append(String.valueOf(this.bean.getOutboundCertificateValidation()));
                }
                if (this.bean.isOutboundPrivateKeyAliasSet()) {
                    stringBuffer.append("OutboundPrivateKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getOutboundPrivateKeyAlias()));
                }
                if (this.bean.isOutboundPrivateKeyPassPhraseSet()) {
                    stringBuffer.append("OutboundPrivateKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getOutboundPrivateKeyPassPhrase()));
                }
                if (this.bean.isPeerValidationEnforcedSet()) {
                    stringBuffer.append("PeerValidationEnforced");
                    stringBuffer.append(String.valueOf(this.bean.getPeerValidationEnforced()));
                }
                if (this.bean.isServerCertificateChainFileNameSet()) {
                    stringBuffer.append("ServerCertificateChainFileName");
                    stringBuffer.append(String.valueOf(this.bean.getServerCertificateChainFileName()));
                }
                if (this.bean.isServerCertificateFileNameSet()) {
                    stringBuffer.append("ServerCertificateFileName");
                    stringBuffer.append(String.valueOf(this.bean.getServerCertificateFileName()));
                }
                if (this.bean.isServerKeyFileNameSet()) {
                    stringBuffer.append("ServerKeyFileName");
                    stringBuffer.append(String.valueOf(this.bean.getServerKeyFileName()));
                }
                if (this.bean.isServerPrivateKeyAliasSet()) {
                    stringBuffer.append("ServerPrivateKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getServerPrivateKeyAlias()));
                }
                if (this.bean.isServerPrivateKeyPassPhraseSet()) {
                    stringBuffer.append("ServerPrivateKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getServerPrivateKeyPassPhrase()));
                }
                if (this.bean.isServerPrivateKeyPassPhraseEncryptedSet()) {
                    stringBuffer.append("ServerPrivateKeyPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getServerPrivateKeyPassPhraseEncrypted())));
                }
                if (this.bean.isTrustedCAFileNameSet()) {
                    stringBuffer.append("TrustedCAFileName");
                    stringBuffer.append(String.valueOf(this.bean.getTrustedCAFileName()));
                }
                if (this.bean.isAllowUnencryptedNullCipherSet()) {
                    stringBuffer.append("AllowUnencryptedNullCipher");
                    stringBuffer.append(String.valueOf(this.bean.isAllowUnencryptedNullCipher()));
                }
                if (this.bean.isClientCertificateEnforcedSet()) {
                    stringBuffer.append("ClientCertificateEnforced");
                    stringBuffer.append(String.valueOf(this.bean.isClientCertificateEnforced()));
                }
                if (this.bean.isEnabledSet()) {
                    stringBuffer.append("Enabled");
                    stringBuffer.append(String.valueOf(this.bean.isEnabled()));
                }
                if (this.bean.isHandlerEnabledSet()) {
                    stringBuffer.append("HandlerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isHandlerEnabled()));
                }
                if (this.bean.isHostnameVerificationIgnoredSet()) {
                    stringBuffer.append("HostnameVerificationIgnored");
                    stringBuffer.append(String.valueOf(this.bean.isHostnameVerificationIgnored()));
                }
                if (this.bean.isJSSEEnabledSet()) {
                    stringBuffer.append("JSSEEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isJSSEEnabled()));
                }
                if (this.bean.isKeyEncryptedSet()) {
                    stringBuffer.append("KeyEncrypted");
                    stringBuffer.append(String.valueOf(this.bean.isKeyEncrypted()));
                }
                if (this.bean.isListenPortEnabledSet()) {
                    stringBuffer.append("ListenPortEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isListenPortEnabled()));
                }
                if (this.bean.isSSLRejectionLoggingEnabledSet()) {
                    stringBuffer.append("SSLRejectionLoggingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSSLRejectionLoggingEnabled()));
                }
                if (this.bean.isTwoWaySSLEnabledSet()) {
                    stringBuffer.append("TwoWaySSLEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isTwoWaySSLEnabled()));
                }
                if (this.bean.isUseClientCertForOutboundSet()) {
                    stringBuffer.append("UseClientCertForOutbound");
                    stringBuffer.append(String.valueOf(this.bean.isUseClientCertForOutbound()));
                }
                if (this.bean.isUseJavaSet()) {
                    stringBuffer.append("UseJava");
                    stringBuffer.append(String.valueOf(this.bean.isUseJava()));
                }
                if (this.bean.isUseServerCertsSet()) {
                    stringBuffer.append("UseServerCerts");
                    stringBuffer.append(String.valueOf(this.bean.isUseServerCerts()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SSLMBeanImpl sSLMBeanImpl = (SSLMBeanImpl)abstractDescriptorBean;
                this.computeDiff("CertAuthenticator", this.bean.getCertAuthenticator(), sSLMBeanImpl.getCertAuthenticator(), false);
                this.computeDiff("CertificateCacheSize", this.bean.getCertificateCacheSize(), sSLMBeanImpl.getCertificateCacheSize(), false);
                this.computeDiff("Ciphersuites", this.bean.getCiphersuites(), sSLMBeanImpl.getCiphersuites(), true);
                this.computeDiff("ClientCertAlias", this.bean.getClientCertAlias(), sSLMBeanImpl.getClientCertAlias(), true);
                this.computeDiff("ClientCertPrivateKeyPassPhraseEncrypted", this.bean.getClientCertPrivateKeyPassPhraseEncrypted(), sSLMBeanImpl.getClientCertPrivateKeyPassPhraseEncrypted(), true);
                this.computeDiff("ExportKeyLifespan", this.bean.getExportKeyLifespan(), sSLMBeanImpl.getExportKeyLifespan(), true);
                this.computeDiff("HostnameVerifier", this.bean.getHostnameVerifier(), sSLMBeanImpl.getHostnameVerifier(), false);
                this.computeDiff("IdentityAndTrustLocations", this.bean.getIdentityAndTrustLocations(), sSLMBeanImpl.getIdentityAndTrustLocations(), true);
                this.computeDiff("InboundCertificateValidation", this.bean.getInboundCertificateValidation(), sSLMBeanImpl.getInboundCertificateValidation(), true);
                this.computeDiff("ListenPort", this.bean.getListenPort(), sSLMBeanImpl.getListenPort(), true);
                this.computeDiff("LoginTimeoutMillis", this.bean.getLoginTimeoutMillis(), sSLMBeanImpl.getLoginTimeoutMillis(), true);
                this.computeDiff("Name", this.bean.getName(), sSLMBeanImpl.getName(), false);
                this.computeDiff("OutboundCertificateValidation", this.bean.getOutboundCertificateValidation(), sSLMBeanImpl.getOutboundCertificateValidation(), true);
                this.computeDiff("OutboundPrivateKeyAlias", this.bean.getOutboundPrivateKeyAlias(), sSLMBeanImpl.getOutboundPrivateKeyAlias(), true);
                this.computeDiff("OutboundPrivateKeyPassPhrase", this.bean.getOutboundPrivateKeyPassPhrase(), sSLMBeanImpl.getOutboundPrivateKeyPassPhrase(), true);
                this.computeDiff("ServerCertificateChainFileName", this.bean.getServerCertificateChainFileName(), sSLMBeanImpl.getServerCertificateChainFileName(), true);
                this.computeDiff("ServerCertificateFileName", this.bean.getServerCertificateFileName(), sSLMBeanImpl.getServerCertificateFileName(), true);
                this.computeDiff("ServerKeyFileName", this.bean.getServerKeyFileName(), sSLMBeanImpl.getServerKeyFileName(), true);
                this.computeDiff("ServerPrivateKeyAlias", this.bean.getServerPrivateKeyAlias(), sSLMBeanImpl.getServerPrivateKeyAlias(), true);
                this.computeDiff("ServerPrivateKeyPassPhraseEncrypted", this.bean.getServerPrivateKeyPassPhraseEncrypted(), sSLMBeanImpl.getServerPrivateKeyPassPhraseEncrypted(), true);
                this.computeDiff("TrustedCAFileName", this.bean.getTrustedCAFileName(), sSLMBeanImpl.getTrustedCAFileName(), true);
                this.computeDiff("AllowUnencryptedNullCipher", this.bean.isAllowUnencryptedNullCipher(), sSLMBeanImpl.isAllowUnencryptedNullCipher(), false);
                this.computeDiff("ClientCertificateEnforced", this.bean.isClientCertificateEnforced(), sSLMBeanImpl.isClientCertificateEnforced(), true);
                this.computeDiff("Enabled", this.bean.isEnabled(), sSLMBeanImpl.isEnabled(), true);
                this.computeDiff("HandlerEnabled", this.bean.isHandlerEnabled(), sSLMBeanImpl.isHandlerEnabled(), false);
                this.computeDiff("HostnameVerificationIgnored", this.bean.isHostnameVerificationIgnored(), sSLMBeanImpl.isHostnameVerificationIgnored(), false);
                this.computeDiff("JSSEEnabled", this.bean.isJSSEEnabled(), sSLMBeanImpl.isJSSEEnabled(), false);
                this.computeDiff("KeyEncrypted", this.bean.isKeyEncrypted(), sSLMBeanImpl.isKeyEncrypted(), false);
                this.computeDiff("SSLRejectionLoggingEnabled", this.bean.isSSLRejectionLoggingEnabled(), sSLMBeanImpl.isSSLRejectionLoggingEnabled(), true);
                this.computeDiff("TwoWaySSLEnabled", this.bean.isTwoWaySSLEnabled(), sSLMBeanImpl.isTwoWaySSLEnabled(), true);
                this.computeDiff("UseClientCertForOutbound", this.bean.isUseClientCertForOutbound(), sSLMBeanImpl.isUseClientCertForOutbound(), true);
                this.computeDiff("UseJava", this.bean.isUseJava(), sSLMBeanImpl.isUseJava(), false);
                this.computeDiff("UseServerCerts", this.bean.isUseServerCerts(), sSLMBeanImpl.isUseServerCerts(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SSLMBeanImpl sSLMBeanImpl = (SSLMBeanImpl)beanUpdateEvent.getSourceBean();
                SSLMBeanImpl sSLMBeanImpl2 = (SSLMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CertAuthenticator")) {
                    sSLMBeanImpl.setCertAuthenticator(sSLMBeanImpl2.getCertAuthenticator());
                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("CertificateCacheSize")) {
                    sSLMBeanImpl.setCertificateCacheSize(sSLMBeanImpl2.getCertificateCacheSize());
                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("Ciphersuites")) {
                    sSLMBeanImpl.setCiphersuites(sSLMBeanImpl2.getCiphersuites());
                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ClientCertAlias")) {
                    sSLMBeanImpl.setClientCertAlias(sSLMBeanImpl2.getClientCertAlias());
                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                } else if (!string.equals("ClientCertPrivateKeyPassPhrase")) {
                    if (string.equals("ClientCertPrivateKeyPassPhraseEncrypted")) {
                        sSLMBeanImpl.setClientCertPrivateKeyPassPhraseEncrypted(sSLMBeanImpl2.getClientCertPrivateKeyPassPhraseEncrypted());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                    } else if (string.equals("ExportKeyLifespan")) {
                        sSLMBeanImpl.setExportKeyLifespan(sSLMBeanImpl2.getExportKeyLifespan());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("HostnameVerifier")) {
                        sSLMBeanImpl.setHostnameVerifier(sSLMBeanImpl2.getHostnameVerifier());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("IdentityAndTrustLocations")) {
                        sSLMBeanImpl.setIdentityAndTrustLocations(sSLMBeanImpl2.getIdentityAndTrustLocations());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                    } else if (string.equals("InboundCertificateValidation")) {
                        sSLMBeanImpl.setInboundCertificateValidation(sSLMBeanImpl2.getInboundCertificateValidation());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                    } else if (string.equals("ListenPort")) {
                        sSLMBeanImpl.setListenPort(sSLMBeanImpl2.getListenPort());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else if (string.equals("LoginTimeoutMillis")) {
                        sSLMBeanImpl.setLoginTimeoutMillis(sSLMBeanImpl2.getLoginTimeoutMillis());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                    } else if (string.equals("Name")) {
                        sSLMBeanImpl.setName(sSLMBeanImpl2.getName());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("OutboundCertificateValidation")) {
                        sSLMBeanImpl.setOutboundCertificateValidation(sSLMBeanImpl2.getOutboundCertificateValidation());
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                    } else if (string.equals("OutboundPrivateKeyAlias")) {
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 41);
                    } else if (string.equals("OutboundPrivateKeyPassPhrase")) {
                        sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                    } else if (!string.equals("PeerValidationEnforced")) {
                        if (string.equals("ServerCertificateChainFileName")) {
                            sSLMBeanImpl.setServerCertificateChainFileName(sSLMBeanImpl2.getServerCertificateChainFileName());
                            sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                        } else if (string.equals("ServerCertificateFileName")) {
                            sSLMBeanImpl.setServerCertificateFileName(sSLMBeanImpl2.getServerCertificateFileName());
                            sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                        } else if (string.equals("ServerKeyFileName")) {
                            sSLMBeanImpl.setServerKeyFileName(sSLMBeanImpl2.getServerKeyFileName());
                            sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                        } else if (string.equals("ServerPrivateKeyAlias")) {
                            sSLMBeanImpl.setServerPrivateKeyAlias(sSLMBeanImpl2.getServerPrivateKeyAlias());
                            sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                        } else if (!string.equals("ServerPrivateKeyPassPhrase")) {
                            if (string.equals("ServerPrivateKeyPassPhraseEncrypted")) {
                                sSLMBeanImpl.setServerPrivateKeyPassPhraseEncrypted(sSLMBeanImpl2.getServerPrivateKeyPassPhraseEncrypted());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                            } else if (string.equals("TrustedCAFileName")) {
                                sSLMBeanImpl.setTrustedCAFileName(sSLMBeanImpl2.getTrustedCAFileName());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                            } else if (string.equals("AllowUnencryptedNullCipher")) {
                                sSLMBeanImpl.setAllowUnencryptedNullCipher(sSLMBeanImpl2.isAllowUnencryptedNullCipher());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                            } else if (string.equals("ClientCertificateEnforced")) {
                                sSLMBeanImpl.setClientCertificateEnforced(sSLMBeanImpl2.isClientCertificateEnforced());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                            } else if (string.equals("Enabled")) {
                                sSLMBeanImpl.setEnabled(sSLMBeanImpl2.isEnabled());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                            } else if (string.equals("HandlerEnabled")) {
                                sSLMBeanImpl.setHandlerEnabled(sSLMBeanImpl2.isHandlerEnabled());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                            } else if (string.equals("HostnameVerificationIgnored")) {
                                sSLMBeanImpl.setHostnameVerificationIgnored(sSLMBeanImpl2.isHostnameVerificationIgnored());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                            } else if (string.equals("JSSEEnabled")) {
                                sSLMBeanImpl.setJSSEEnabled(sSLMBeanImpl2.isJSSEEnabled());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                            } else if (string.equals("KeyEncrypted")) {
                                sSLMBeanImpl.setKeyEncrypted(sSLMBeanImpl2.isKeyEncrypted());
                                sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                            } else if (!string.equals("ListenPortEnabled")) {
                                if (string.equals("SSLRejectionLoggingEnabled")) {
                                    sSLMBeanImpl.setSSLRejectionLoggingEnabled(sSLMBeanImpl2.isSSLRejectionLoggingEnabled());
                                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                                } else if (string.equals("TwoWaySSLEnabled")) {
                                    sSLMBeanImpl.setTwoWaySSLEnabled(sSLMBeanImpl2.isTwoWaySSLEnabled());
                                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                                } else if (string.equals("UseClientCertForOutbound")) {
                                    sSLMBeanImpl.setUseClientCertForOutbound(sSLMBeanImpl2.isUseClientCertForOutbound());
                                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                                } else if (string.equals("UseJava")) {
                                    sSLMBeanImpl.setUseJava(sSLMBeanImpl2.isUseJava());
                                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                                } else if (string.equals("UseServerCerts")) {
                                    sSLMBeanImpl.setUseServerCerts(sSLMBeanImpl2.isUseServerCerts());
                                    sSLMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                                } else {
                                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                Object[] objectArray;
                SSLMBeanImpl sSLMBeanImpl = (SSLMBeanImpl)abstractDescriptorBean;
                super.finishCopy(sSLMBeanImpl, bl, list);
                if ((list == null || !list.contains("CertAuthenticator")) && this.bean.isCertAuthenticatorSet()) {
                    sSLMBeanImpl.setCertAuthenticator(this.bean.getCertAuthenticator());
                }
                if ((list == null || !list.contains("CertificateCacheSize")) && this.bean.isCertificateCacheSizeSet()) {
                    sSLMBeanImpl.setCertificateCacheSize(this.bean.getCertificateCacheSize());
                }
                if ((list == null || !list.contains("Ciphersuites")) && this.bean.isCiphersuitesSet()) {
                    objectArray = this.bean.getCiphersuites();
                    sSLMBeanImpl.setCiphersuites(objectArray == null ? null : (String[])objectArray.clone());
                }
                if ((list == null || !list.contains("ClientCertAlias")) && this.bean.isClientCertAliasSet()) {
                    sSLMBeanImpl.setClientCertAlias(this.bean.getClientCertAlias());
                }
                if ((list == null || !list.contains("ClientCertPrivateKeyPassPhraseEncrypted")) && this.bean.isClientCertPrivateKeyPassPhraseEncryptedSet()) {
                    objectArray = this.bean.getClientCertPrivateKeyPassPhraseEncrypted();
                    sSLMBeanImpl.setClientCertPrivateKeyPassPhraseEncrypted(objectArray == null ? null : (byte[])((byte[])objectArray).clone());
                }
                if ((list == null || !list.contains("ExportKeyLifespan")) && this.bean.isExportKeyLifespanSet()) {
                    sSLMBeanImpl.setExportKeyLifespan(this.bean.getExportKeyLifespan());
                }
                if ((list == null || !list.contains("HostnameVerifier")) && this.bean.isHostnameVerifierSet()) {
                    sSLMBeanImpl.setHostnameVerifier(this.bean.getHostnameVerifier());
                }
                if ((list == null || !list.contains("IdentityAndTrustLocations")) && this.bean.isIdentityAndTrustLocationsSet()) {
                    sSLMBeanImpl.setIdentityAndTrustLocations(this.bean.getIdentityAndTrustLocations());
                }
                if ((list == null || !list.contains("InboundCertificateValidation")) && this.bean.isInboundCertificateValidationSet()) {
                    sSLMBeanImpl.setInboundCertificateValidation(this.bean.getInboundCertificateValidation());
                }
                if ((list == null || !list.contains("ListenPort")) && this.bean.isListenPortSet()) {
                    sSLMBeanImpl.setListenPort(this.bean.getListenPort());
                }
                if ((list == null || !list.contains("LoginTimeoutMillis")) && this.bean.isLoginTimeoutMillisSet()) {
                    sSLMBeanImpl.setLoginTimeoutMillis(this.bean.getLoginTimeoutMillis());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    sSLMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("OutboundCertificateValidation")) && this.bean.isOutboundCertificateValidationSet()) {
                    sSLMBeanImpl.setOutboundCertificateValidation(this.bean.getOutboundCertificateValidation());
                }
                if (list != null && list.contains("OutboundPrivateKeyAlias") || this.bean.isOutboundPrivateKeyAliasSet()) {
                    // empty if block
                }
                if (list != null && list.contains("OutboundPrivateKeyPassPhrase") || this.bean.isOutboundPrivateKeyPassPhraseSet()) {
                    // empty if block
                }
                if ((list == null || !list.contains("ServerCertificateChainFileName")) && this.bean.isServerCertificateChainFileNameSet()) {
                    sSLMBeanImpl.setServerCertificateChainFileName(this.bean.getServerCertificateChainFileName());
                }
                if ((list == null || !list.contains("ServerCertificateFileName")) && this.bean.isServerCertificateFileNameSet()) {
                    sSLMBeanImpl.setServerCertificateFileName(this.bean.getServerCertificateFileName());
                }
                if ((list == null || !list.contains("ServerKeyFileName")) && this.bean.isServerKeyFileNameSet()) {
                    sSLMBeanImpl.setServerKeyFileName(this.bean.getServerKeyFileName());
                }
                if ((list == null || !list.contains("ServerPrivateKeyAlias")) && this.bean.isServerPrivateKeyAliasSet()) {
                    sSLMBeanImpl.setServerPrivateKeyAlias(this.bean.getServerPrivateKeyAlias());
                }
                if ((list == null || !list.contains("ServerPrivateKeyPassPhraseEncrypted")) && this.bean.isServerPrivateKeyPassPhraseEncryptedSet()) {
                    objectArray = this.bean.getServerPrivateKeyPassPhraseEncrypted();
                    sSLMBeanImpl.setServerPrivateKeyPassPhraseEncrypted(objectArray == null ? null : (byte[])((byte[])objectArray).clone());
                }
                if ((list == null || !list.contains("TrustedCAFileName")) && this.bean.isTrustedCAFileNameSet()) {
                    sSLMBeanImpl.setTrustedCAFileName(this.bean.getTrustedCAFileName());
                }
                if ((list == null || !list.contains("AllowUnencryptedNullCipher")) && this.bean.isAllowUnencryptedNullCipherSet()) {
                    sSLMBeanImpl.setAllowUnencryptedNullCipher(this.bean.isAllowUnencryptedNullCipher());
                }
                if ((list == null || !list.contains("ClientCertificateEnforced")) && this.bean.isClientCertificateEnforcedSet()) {
                    sSLMBeanImpl.setClientCertificateEnforced(this.bean.isClientCertificateEnforced());
                }
                if ((list == null || !list.contains("Enabled")) && this.bean.isEnabledSet()) {
                    sSLMBeanImpl.setEnabled(this.bean.isEnabled());
                }
                if ((list == null || !list.contains("HandlerEnabled")) && this.bean.isHandlerEnabledSet()) {
                    sSLMBeanImpl.setHandlerEnabled(this.bean.isHandlerEnabled());
                }
                if ((list == null || !list.contains("HostnameVerificationIgnored")) && this.bean.isHostnameVerificationIgnoredSet()) {
                    sSLMBeanImpl.setHostnameVerificationIgnored(this.bean.isHostnameVerificationIgnored());
                }
                if ((list == null || !list.contains("JSSEEnabled")) && this.bean.isJSSEEnabledSet()) {
                    sSLMBeanImpl.setJSSEEnabled(this.bean.isJSSEEnabled());
                }
                if ((list == null || !list.contains("KeyEncrypted")) && this.bean.isKeyEncryptedSet()) {
                    sSLMBeanImpl.setKeyEncrypted(this.bean.isKeyEncrypted());
                }
                if ((list == null || !list.contains("SSLRejectionLoggingEnabled")) && this.bean.isSSLRejectionLoggingEnabledSet()) {
                    sSLMBeanImpl.setSSLRejectionLoggingEnabled(this.bean.isSSLRejectionLoggingEnabled());
                }
                if ((list == null || !list.contains("TwoWaySSLEnabled")) && this.bean.isTwoWaySSLEnabledSet()) {
                    sSLMBeanImpl.setTwoWaySSLEnabled(this.bean.isTwoWaySSLEnabled());
                }
                if ((list == null || !list.contains("UseClientCertForOutbound")) && this.bean.isUseClientCertForOutboundSet()) {
                    sSLMBeanImpl.setUseClientCertForOutbound(this.bean.isUseClientCertForOutbound());
                }
                if ((list == null || !list.contains("UseJava")) && this.bean.isUseJavaSet()) {
                    sSLMBeanImpl.setUseJava(this.bean.isUseJava());
                }
                if ((list == null || !list.contains("UseServerCerts")) && this.bean.isUseServerCertsSet()) {
                    sSLMBeanImpl.setUseServerCerts(this.bean.isUseServerCerts());
                }
                return sSLMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

