/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.CertRevocMBean;
import weblogic.management.configuration.CertRevocMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.SecurityLegalHelper;
import weblogic.management.mbeans.custom.SecurityConfiguration;
import weblogic.management.security.ProviderMBean;
import weblogic.management.security.RealmMBean;
import weblogic.management.security.RealmMBeanImpl;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class SecurityConfigurationMBeanImpl
extends ConfigurationMBeanImpl
implements SecurityConfigurationMBean,
Serializable {
    private boolean _AnonymousAdminLookupEnabled;
    private CertRevocMBean _CertRevoc;
    private boolean _ClearTextCredentialAccessEnabled;
    private boolean _CompatibilityConnectionFiltersEnabled;
    private String _ConnectionFilter;
    private String[] _ConnectionFilterRules;
    private boolean _ConnectionLoggerEnabled;
    private boolean _ConsoleFullDelegationEnabled;
    private String _Credential;
    private byte[] _CredentialEncrypted;
    private boolean _CredentialGenerated;
    private boolean _CrossDomainSecurityEnabled;
    private RealmMBean _DefaultRealm;
    private RealmMBean _DefaultRealmInternal;
    private boolean _DowngradeUntrustedPrincipals;
    private byte[] _EncryptedAESSecretKey;
    private byte[] _EncryptedSecretKey;
    private boolean _EnforceStrictURLPattern;
    private boolean _EnforceValidBasicAuthCredentials;
    private String[] _ExcludedDomainNames;
    private String _Name;
    private String _NodeManagerPassword;
    private byte[] _NodeManagerPasswordEncrypted;
    private String _NodeManagerUsername;
    private boolean _PrincipalEqualsCaseInsensitive;
    private boolean _PrincipalEqualsCompareDnAndGuid;
    private String _RealmBootStrapVersion;
    private RealmMBean[] _Realms;
    private byte[] _Salt;
    private String _WebAppFilesCaseInsensitive;
    private SecurityConfiguration _customizer;
    private static SchemaHelper2 _schemaHelper;

    public SecurityConfigurationMBeanImpl() {
        try {
            this._customizer = new SecurityConfiguration(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public SecurityConfigurationMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new SecurityConfiguration(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public RealmMBean createRealm(String string) throws JMException {
        return this._customizer.createRealm(string);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public RealmMBean createRealm() throws JMException {
        RealmMBeanImpl realmMBeanImpl = new RealmMBeanImpl(this, -1);
        try {
            this.addRealm(realmMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof JMException) {
                throw (JMException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return realmMBeanImpl;
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void destroyRealm(RealmMBean realmMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(realmMBean, 7);
                RealmMBean[] realmMBeanArray = this.getRealms();
                RealmMBean[] realmMBeanArray2 = (RealmMBean[])this._getHelper()._removeElement((Object)realmMBeanArray, RealmMBean.class, (Object)realmMBean);
                if (realmMBeanArray.length == realmMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)realmMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)realmMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setRealms(realmMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void addRealm(RealmMBean realmMBean) {
        this._getHelper()._ensureNonNull((Object)realmMBean);
        if (!((AbstractDescriptorBean)realmMBean).isChildProperty((DescriptorBean)this, 7)) {
            RealmMBean[] realmMBeanArray = this._isSet(7) ? (RealmMBean[])this._getHelper()._extendArray((Object)this.getRealms(), RealmMBean.class, (Object)realmMBean) : new RealmMBean[]{realmMBean};
            try {
                this.setRealms(realmMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public RealmMBean[] getRealms() {
        return this._Realms;
    }

    public boolean isRealmsSet() {
        return this._isSet(7);
    }

    public void removeRealm(RealmMBean realmMBean) {
        this.destroyRealm(realmMBean);
    }

    public void setRealms(RealmMBean[] realmMBeanArray) throws InvalidAttributeValueException {
        realmMBeanArray = realmMBeanArray == null ? new RealmMBeanImpl[]{} : realmMBeanArray;
        for (int i = 0; i < realmMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)realmMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 7)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        RealmMBean[] realmMBeanArray2 = this._Realms;
        this._Realms = realmMBeanArray;
        this._postSet(7, realmMBeanArray2, realmMBeanArray);
    }

    public RealmMBean lookupRealm(String string) {
        for (RealmMBeanImpl realmMBeanImpl : Arrays.asList((Object[])this._Realms)) {
            String string2 = string;
            if (!realmMBeanImpl.getName().equals(string2)) continue;
            return realmMBeanImpl;
        }
        return null;
    }

    public RealmMBean[] findRealms() {
        return this._customizer.findRealms();
    }

    public RealmMBean findDefaultRealm() {
        return this._customizer.findDefaultRealm();
    }

    public RealmMBean findRealm(String string) {
        return this._customizer.findRealm(string);
    }

    public RealmMBean getDefaultRealm() {
        return this._DefaultRealm;
    }

    public String getDefaultRealmAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDefaultRealm();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDefaultRealmSet() {
        return this._isSet(8);
    }

    public void setDefaultRealmAsString(String string) {
        if (string == null || string.length() == 0) {
            RealmMBean realmMBean = this._DefaultRealm;
            this._initializeProperty(8);
            this._postSet(8, realmMBean, this._DefaultRealm);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, RealmMBean.class, new ReferenceManager.Resolver(this, 8){

                public void resolveReference(Object object) {
                    try {
                        SecurityConfigurationMBeanImpl.this.setDefaultRealm((RealmMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setDefaultRealm(RealmMBean realmMBean) throws InvalidAttributeValueException {
        RealmMBean realmMBean2;
        if (realmMBean != null) {
            realmMBean2 = new ResolvedReference(this, 8, (AbstractDescriptorBean)realmMBean){

                protected Object getPropertyValue() {
                    return SecurityConfigurationMBeanImpl.this.getDefaultRealm();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)realmMBean, (ResolvedReference)realmMBean2);
        }
        realmMBean2 = this._DefaultRealm;
        this._DefaultRealm = realmMBean;
        this._postSet(8, realmMBean2, realmMBean);
    }

    public ProviderMBean[] pre90getProviders() {
        return this._customizer.pre90getProviders();
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public byte[] getSalt() {
        return this._customizer.getSalt();
    }

    public boolean isSaltSet() {
        return this._isSet(9);
    }

    public void setSalt(byte[] byArray) throws InvalidAttributeValueException {
        this._Salt = byArray;
    }

    public byte[] getEncryptedSecretKey() {
        return this._customizer.getEncryptedSecretKey();
    }

    public boolean isEncryptedSecretKeySet() {
        return this._isSet(10);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setEncryptedSecretKey(byte[] byArray) throws InvalidAttributeValueException {
        this._EncryptedSecretKey = byArray;
    }

    public boolean isAnonymousAdminLookupEnabled() {
        return this._AnonymousAdminLookupEnabled;
    }

    public boolean isAnonymousAdminLookupEnabledSet() {
        return this._isSet(11);
    }

    public void setAnonymousAdminLookupEnabled(boolean bl) {
        boolean bl2 = this._AnonymousAdminLookupEnabled;
        this._AnonymousAdminLookupEnabled = bl;
        this._postSet(11, bl2, bl);
    }

    public boolean isClearTextCredentialAccessEnabled() {
        return this._ClearTextCredentialAccessEnabled;
    }

    public boolean isClearTextCredentialAccessEnabledSet() {
        return this._isSet(12);
    }

    public void setClearTextCredentialAccessEnabled(boolean bl) {
        boolean bl2 = this._ClearTextCredentialAccessEnabled;
        this._ClearTextCredentialAccessEnabled = bl;
        this._postSet(12, bl2, bl);
    }

    public boolean isCredentialGenerated() {
        return this._CredentialGenerated;
    }

    public boolean isCredentialGeneratedSet() {
        return this._isSet(13);
    }

    public void setCredentialGenerated(boolean bl) {
        boolean bl2 = this.isCredentialGenerated();
        this._customizer.setCredentialGenerated(bl);
        this._postSet(13, bl2, bl);
    }

    public byte[] generateCredential() {
        return this._customizer.generateCredential();
    }

    public String getCredential() {
        byte[] byArray = this.getCredentialEncrypted();
        return byArray == null ? null : this._decrypt("Credential", byArray);
    }

    public boolean isCredentialSet() {
        return this.isCredentialEncryptedSet();
    }

    public void setCredential(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setCredentialEncrypted(string == null ? null : this._encrypt("Credential", string));
    }

    public byte[] getCredentialEncrypted() {
        return this._getHelper()._cloneArray(this._CredentialEncrypted);
    }

    public String getCredentialEncryptedAsString() {
        byte[] byArray = this.getCredentialEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isCredentialEncryptedSet() {
        return this._isSet(15);
    }

    public void setCredentialEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setCredentialEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getWebAppFilesCaseInsensitive() {
        return this._WebAppFilesCaseInsensitive;
    }

    public boolean isWebAppFilesCaseInsensitiveSet() {
        return this._isSet(16);
    }

    public void setWebAppFilesCaseInsensitive(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"os", "true", "false"};
        string = LegalChecks.checkInEnum((String)"WebAppFilesCaseInsensitive", (String)string, (String[])stringArray);
        String string2 = this._WebAppFilesCaseInsensitive;
        this._WebAppFilesCaseInsensitive = string;
        this._postSet(16, string2, string);
    }

    public String getRealmBootStrapVersion() {
        if (!this._isSet(17)) {
            try {
                return "1";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._RealmBootStrapVersion;
    }

    public boolean isRealmBootStrapVersionSet() {
        return this._isSet(17);
    }

    public void setRealmBootStrapVersion(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"unknown", "1"};
        string = LegalChecks.checkInEnum((String)"RealmBootStrapVersion", (String)string, (String[])stringArray);
        String string2 = this._RealmBootStrapVersion;
        this._RealmBootStrapVersion = string;
        this._postSet(17, string2, string);
    }

    public String getConnectionFilter() {
        return this._ConnectionFilter;
    }

    public boolean isConnectionFilterSet() {
        return this._isSet(18);
    }

    public void setConnectionFilter(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ConnectionFilter;
        this._ConnectionFilter = string;
        this._postSet(18, string2, string);
    }

    public String[] getConnectionFilterRules() {
        return this._ConnectionFilterRules;
    }

    public boolean isConnectionFilterRulesSet() {
        return this._isSet(19);
    }

    public void setConnectionFilterRules(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        this._getHelper()._ensureNonNullElements(stringArray);
        String[] stringArray2 = this._ConnectionFilterRules;
        this._ConnectionFilterRules = stringArray;
        this._postSet(19, stringArray2, stringArray);
    }

    public boolean getConnectionLoggerEnabled() {
        return this._ConnectionLoggerEnabled;
    }

    public boolean isConnectionLoggerEnabledSet() {
        return this._isSet(20);
    }

    public void setConnectionLoggerEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ConnectionLoggerEnabled;
        this._ConnectionLoggerEnabled = bl;
        this._postSet(20, bl2, bl);
    }

    public boolean getCompatibilityConnectionFiltersEnabled() {
        return this._CompatibilityConnectionFiltersEnabled;
    }

    public boolean isCompatibilityConnectionFiltersEnabledSet() {
        return this._isSet(21);
    }

    public void setCompatibilityConnectionFiltersEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._CompatibilityConnectionFiltersEnabled;
        this._CompatibilityConnectionFiltersEnabled = bl;
        this._postSet(21, bl2, bl);
    }

    public String getNodeManagerUsername() {
        return this._NodeManagerUsername;
    }

    public boolean isNodeManagerUsernameSet() {
        return this._isSet(22);
    }

    public void setNodeManagerUsername(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._NodeManagerUsername;
        this._NodeManagerUsername = string;
        this._postSet(22, string2, string);
    }

    public String getNodeManagerPassword() {
        byte[] byArray = this.getNodeManagerPasswordEncrypted();
        return byArray == null ? null : this._decrypt("NodeManagerPassword", byArray);
    }

    public boolean isNodeManagerPasswordSet() {
        return this.isNodeManagerPasswordEncryptedSet();
    }

    public void setNodeManagerPassword(String string) {
        string = string == null ? null : string.trim();
        this.setNodeManagerPasswordEncrypted(string == null ? null : this._encrypt("NodeManagerPassword", string));
    }

    public byte[] getNodeManagerPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._NodeManagerPasswordEncrypted);
    }

    public String getNodeManagerPasswordEncryptedAsString() {
        byte[] byArray = this.getNodeManagerPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isNodeManagerPasswordEncryptedSet() {
        return this._isSet(24);
    }

    public void setNodeManagerPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setNodeManagerPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isPrincipalEqualsCaseInsensitive() {
        return this._PrincipalEqualsCaseInsensitive;
    }

    public boolean isPrincipalEqualsCaseInsensitiveSet() {
        return this._isSet(25);
    }

    public void setPrincipalEqualsCaseInsensitive(boolean bl) {
        boolean bl2 = this._PrincipalEqualsCaseInsensitive;
        this._PrincipalEqualsCaseInsensitive = bl;
        this._postSet(25, bl2, bl);
    }

    public boolean isPrincipalEqualsCompareDnAndGuid() {
        return this._PrincipalEqualsCompareDnAndGuid;
    }

    public boolean isPrincipalEqualsCompareDnAndGuidSet() {
        return this._isSet(26);
    }

    public void setPrincipalEqualsCompareDnAndGuid(boolean bl) {
        boolean bl2 = this._PrincipalEqualsCompareDnAndGuid;
        this._PrincipalEqualsCompareDnAndGuid = bl;
        this._postSet(26, bl2, bl);
    }

    public boolean getDowngradeUntrustedPrincipals() {
        return this._DowngradeUntrustedPrincipals;
    }

    public boolean isDowngradeUntrustedPrincipalsSet() {
        return this._isSet(27);
    }

    public void setDowngradeUntrustedPrincipals(boolean bl) {
        boolean bl2 = this._DowngradeUntrustedPrincipals;
        this._DowngradeUntrustedPrincipals = bl;
        this._postSet(27, bl2, bl);
    }

    public boolean getEnforceStrictURLPattern() {
        return this._EnforceStrictURLPattern;
    }

    public boolean isEnforceStrictURLPatternSet() {
        return this._isSet(28);
    }

    public void setEnforceStrictURLPattern(boolean bl) {
        boolean bl2 = this._EnforceStrictURLPattern;
        this._EnforceStrictURLPattern = bl;
        this._postSet(28, bl2, bl);
    }

    public boolean getEnforceValidBasicAuthCredentials() {
        return this._EnforceValidBasicAuthCredentials;
    }

    public boolean isEnforceValidBasicAuthCredentialsSet() {
        return this._isSet(29);
    }

    public void setEnforceValidBasicAuthCredentials(boolean bl) {
        boolean bl2 = this._EnforceValidBasicAuthCredentials;
        this._EnforceValidBasicAuthCredentials = bl;
        this._postSet(29, bl2, bl);
    }

    public boolean isConsoleFullDelegationEnabled() {
        return this._ConsoleFullDelegationEnabled;
    }

    public boolean isConsoleFullDelegationEnabledSet() {
        return this._isSet(30);
    }

    public void setConsoleFullDelegationEnabled(boolean bl) {
        boolean bl2 = this._ConsoleFullDelegationEnabled;
        this._ConsoleFullDelegationEnabled = bl;
        this._postSet(30, bl2, bl);
    }

    public RealmMBean getDefaultRealmInternal() {
        return this._customizer.getDefaultRealmInternal();
    }

    public String getDefaultRealmInternalAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDefaultRealmInternal();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDefaultRealmInternalSet() {
        return this._isSet(31);
    }

    public void setDefaultRealmInternalAsString(String string) {
        if (string == null || string.length() == 0) {
            RealmMBean realmMBean = this._DefaultRealmInternal;
            this._initializeProperty(31);
            this._postSet(31, realmMBean, this._DefaultRealmInternal);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, RealmMBean.class, new ReferenceManager.Resolver(this, 31){

                public void resolveReference(Object object) {
                    try {
                        SecurityConfigurationMBeanImpl.this.setDefaultRealmInternal((RealmMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setDefaultRealmInternal(RealmMBean realmMBean) {
        RealmMBean realmMBean2;
        if (realmMBean != null) {
            realmMBean2 = new ResolvedReference(this, 31, (AbstractDescriptorBean)realmMBean){

                protected Object getPropertyValue() {
                    return SecurityConfigurationMBeanImpl.this.getDefaultRealmInternal();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)realmMBean, (ResolvedReference)realmMBean2);
        }
        realmMBean2 = this.getDefaultRealmInternal();
        this._customizer.setDefaultRealmInternal(realmMBean);
        this._postSet(31, realmMBean2, realmMBean);
    }

    public String[] getExcludedDomainNames() {
        return this._ExcludedDomainNames;
    }

    public boolean isExcludedDomainNamesSet() {
        return this._isSet(32);
    }

    public void setExcludedDomainNames(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._ExcludedDomainNames;
        this._ExcludedDomainNames = stringArray;
        this._postSet(32, stringArray2, stringArray);
    }

    public boolean isCrossDomainSecurityEnabled() {
        return this._CrossDomainSecurityEnabled;
    }

    public boolean isCrossDomainSecurityEnabledSet() {
        return this._isSet(33);
    }

    public void setCrossDomainSecurityEnabled(boolean bl) {
        boolean bl2 = this._CrossDomainSecurityEnabled;
        this._CrossDomainSecurityEnabled = bl;
        this._postSet(33, bl2, bl);
    }

    public byte[] getEncryptedAESSecretKey() {
        return this._customizer.getEncryptedAESSecretKey();
    }

    public boolean isEncryptedAESSecretKeySet() {
        return this._isSet(34);
    }

    public void setEncryptedAESSecretKey(byte[] byArray) throws InvalidAttributeValueException {
        this._EncryptedAESSecretKey = byArray;
    }

    public CertRevocMBean getCertRevoc() {
        return this._CertRevoc;
    }

    public boolean isCertRevocSet() {
        return this._isSet(35) || this._isAnythingSet((AbstractDescriptorBean)this.getCertRevoc());
    }

    public void setCertRevoc(CertRevocMBean certRevocMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)certRevocMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 35)) {
            this._postCreate(abstractDescriptorBean);
        }
        CertRevocMBean certRevocMBean2 = this._CertRevoc;
        this._CertRevoc = certRevocMBean;
        this._postSet(35, certRevocMBean2, certRevocMBean);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        SecurityLegalHelper.validateSecurityConfiguration(this);
    }

    public void setCredentialEncrypted(byte[] byArray) {
        byte[] byArray2 = this._CredentialEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: CredentialEncrypted of SecurityConfigurationMBean");
        }
        this._getHelper()._clearArray(this._CredentialEncrypted);
        this._CredentialEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(15, byArray2, byArray);
    }

    public void setNodeManagerPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._NodeManagerPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: NodeManagerPasswordEncrypted of SecurityConfigurationMBean");
        }
        this._getHelper()._clearArray(this._NodeManagerPasswordEncrypted);
        this._NodeManagerPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(24, byArray2, byArray);
    }

    protected void _postCreate() {
        this._customizer._postCreate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 14) {
                this._markSet(15, false);
            }
            if (n == 23) {
                this._markSet(24, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet() || this.isCertRevocSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 35;
        }
        try {
            switch (n) {
                case 35: {
                    this._CertRevoc = new CertRevocMBeanImpl(this, 35);
                    this._postCreate((AbstractDescriptorBean)this._CertRevoc);
                    if (bl) break;
                }
                case 21: {
                    this._CompatibilityConnectionFiltersEnabled = false;
                    if (bl) break;
                }
                case 18: {
                    this._ConnectionFilter = null;
                    if (bl) break;
                }
                case 19: {
                    this._ConnectionFilterRules = new String[0];
                    if (bl) break;
                }
                case 20: {
                    this._ConnectionLoggerEnabled = false;
                    if (bl) break;
                }
                case 14: {
                    this._CredentialEncrypted = null;
                    if (bl) break;
                }
                case 15: {
                    this._CredentialEncrypted = null;
                    if (bl) break;
                }
                case 8: {
                    this._DefaultRealm = null;
                    if (bl) break;
                }
                case 31: {
                    this._customizer.setDefaultRealmInternal(null);
                    if (bl) break;
                }
                case 27: {
                    this._DowngradeUntrustedPrincipals = false;
                    if (bl) break;
                }
                case 34: {
                    this._EncryptedAESSecretKey = new byte[0];
                    if (bl) break;
                }
                case 10: {
                    this._EncryptedSecretKey = new byte[0];
                    if (bl) break;
                }
                case 28: {
                    this._EnforceStrictURLPattern = true;
                    if (bl) break;
                }
                case 29: {
                    this._EnforceValidBasicAuthCredentials = true;
                    if (bl) break;
                }
                case 32: {
                    this._ExcludedDomainNames = new String[0];
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 23: {
                    this._NodeManagerPasswordEncrypted = "".getBytes();
                    if (bl) break;
                }
                case 24: {
                    this._NodeManagerPasswordEncrypted = "".getBytes();
                    if (bl) break;
                }
                case 22: {
                    this._NodeManagerUsername = "";
                    if (bl) break;
                }
                case 17: {
                    this._RealmBootStrapVersion = null;
                    if (bl) break;
                }
                case 7: {
                    this._Realms = new RealmMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._Salt = new byte[0];
                    if (bl) break;
                }
                case 16: {
                    this._WebAppFilesCaseInsensitive = "false";
                    if (bl) break;
                }
                case 11: {
                    this._AnonymousAdminLookupEnabled = false;
                    if (bl) break;
                }
                case 12: {
                    this._ClearTextCredentialAccessEnabled = false;
                    if (bl) break;
                }
                case 30: {
                    this._ConsoleFullDelegationEnabled = false;
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setCredentialGenerated(true);
                    if (bl) break;
                }
                case 33: {
                    this._CrossDomainSecurityEnabled = false;
                    if (bl) break;
                }
                case 25: {
                    this._PrincipalEqualsCaseInsensitive = false;
                    if (bl) break;
                }
                case 26: {
                    this._PrincipalEqualsCompareDnAndGuid = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SecurityConfiguration";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AnonymousAdminLookupEnabled")) {
            boolean bl = this._AnonymousAdminLookupEnabled;
            this._AnonymousAdminLookupEnabled = (Boolean)object;
            this._postSet(11, bl, this._AnonymousAdminLookupEnabled);
            return;
        }
        if (string.equals("CertRevoc")) {
            CertRevocMBean certRevocMBean = this._CertRevoc;
            this._CertRevoc = (CertRevocMBean)object;
            this._postSet(35, certRevocMBean, this._CertRevoc);
            return;
        }
        if (string.equals("ClearTextCredentialAccessEnabled")) {
            boolean bl = this._ClearTextCredentialAccessEnabled;
            this._ClearTextCredentialAccessEnabled = (Boolean)object;
            this._postSet(12, bl, this._ClearTextCredentialAccessEnabled);
            return;
        }
        if (string.equals("CompatibilityConnectionFiltersEnabled")) {
            boolean bl = this._CompatibilityConnectionFiltersEnabled;
            this._CompatibilityConnectionFiltersEnabled = (Boolean)object;
            this._postSet(21, bl, this._CompatibilityConnectionFiltersEnabled);
            return;
        }
        if (string.equals("ConnectionFilter")) {
            String string2 = this._ConnectionFilter;
            this._ConnectionFilter = (String)object;
            this._postSet(18, string2, this._ConnectionFilter);
            return;
        }
        if (string.equals("ConnectionFilterRules")) {
            String[] stringArray = this._ConnectionFilterRules;
            this._ConnectionFilterRules = (String[])object;
            this._postSet(19, stringArray, this._ConnectionFilterRules);
            return;
        }
        if (string.equals("ConnectionLoggerEnabled")) {
            boolean bl = this._ConnectionLoggerEnabled;
            this._ConnectionLoggerEnabled = (Boolean)object;
            this._postSet(20, bl, this._ConnectionLoggerEnabled);
            return;
        }
        if (string.equals("ConsoleFullDelegationEnabled")) {
            boolean bl = this._ConsoleFullDelegationEnabled;
            this._ConsoleFullDelegationEnabled = (Boolean)object;
            this._postSet(30, bl, this._ConsoleFullDelegationEnabled);
            return;
        }
        if (string.equals("Credential")) {
            String string3 = this._Credential;
            this._Credential = (String)object;
            this._postSet(14, string3, this._Credential);
            return;
        }
        if (string.equals("CredentialEncrypted")) {
            byte[] byArray = this._CredentialEncrypted;
            this._CredentialEncrypted = (byte[])object;
            this._postSet(15, byArray, this._CredentialEncrypted);
            return;
        }
        if (string.equals("CredentialGenerated")) {
            boolean bl = this._CredentialGenerated;
            this._CredentialGenerated = (Boolean)object;
            this._postSet(13, bl, this._CredentialGenerated);
            return;
        }
        if (string.equals("CrossDomainSecurityEnabled")) {
            boolean bl = this._CrossDomainSecurityEnabled;
            this._CrossDomainSecurityEnabled = (Boolean)object;
            this._postSet(33, bl, this._CrossDomainSecurityEnabled);
            return;
        }
        if (string.equals("DefaultRealm")) {
            RealmMBean realmMBean = this._DefaultRealm;
            this._DefaultRealm = (RealmMBean)object;
            this._postSet(8, realmMBean, this._DefaultRealm);
            return;
        }
        if (string.equals("DefaultRealmInternal")) {
            RealmMBean realmMBean = this._DefaultRealmInternal;
            this._DefaultRealmInternal = (RealmMBean)object;
            this._postSet(31, realmMBean, this._DefaultRealmInternal);
            return;
        }
        if (string.equals("DowngradeUntrustedPrincipals")) {
            boolean bl = this._DowngradeUntrustedPrincipals;
            this._DowngradeUntrustedPrincipals = (Boolean)object;
            this._postSet(27, bl, this._DowngradeUntrustedPrincipals);
            return;
        }
        if (string.equals("EncryptedAESSecretKey")) {
            byte[] byArray = this._EncryptedAESSecretKey;
            this._EncryptedAESSecretKey = (byte[])object;
            this._postSet(34, byArray, this._EncryptedAESSecretKey);
            return;
        }
        if (string.equals("EncryptedSecretKey")) {
            byte[] byArray = this._EncryptedSecretKey;
            this._EncryptedSecretKey = (byte[])object;
            this._postSet(10, byArray, this._EncryptedSecretKey);
            return;
        }
        if (string.equals("EnforceStrictURLPattern")) {
            boolean bl = this._EnforceStrictURLPattern;
            this._EnforceStrictURLPattern = (Boolean)object;
            this._postSet(28, bl, this._EnforceStrictURLPattern);
            return;
        }
        if (string.equals("EnforceValidBasicAuthCredentials")) {
            boolean bl = this._EnforceValidBasicAuthCredentials;
            this._EnforceValidBasicAuthCredentials = (Boolean)object;
            this._postSet(29, bl, this._EnforceValidBasicAuthCredentials);
            return;
        }
        if (string.equals("ExcludedDomainNames")) {
            String[] stringArray = this._ExcludedDomainNames;
            this._ExcludedDomainNames = (String[])object;
            this._postSet(32, stringArray, this._ExcludedDomainNames);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("NodeManagerPassword")) {
            String string5 = this._NodeManagerPassword;
            this._NodeManagerPassword = (String)object;
            this._postSet(23, string5, this._NodeManagerPassword);
            return;
        }
        if (string.equals("NodeManagerPasswordEncrypted")) {
            byte[] byArray = this._NodeManagerPasswordEncrypted;
            this._NodeManagerPasswordEncrypted = (byte[])object;
            this._postSet(24, byArray, this._NodeManagerPasswordEncrypted);
            return;
        }
        if (string.equals("NodeManagerUsername")) {
            String string6 = this._NodeManagerUsername;
            this._NodeManagerUsername = (String)object;
            this._postSet(22, string6, this._NodeManagerUsername);
            return;
        }
        if (string.equals("PrincipalEqualsCaseInsensitive")) {
            boolean bl = this._PrincipalEqualsCaseInsensitive;
            this._PrincipalEqualsCaseInsensitive = (Boolean)object;
            this._postSet(25, bl, this._PrincipalEqualsCaseInsensitive);
            return;
        }
        if (string.equals("PrincipalEqualsCompareDnAndGuid")) {
            boolean bl = this._PrincipalEqualsCompareDnAndGuid;
            this._PrincipalEqualsCompareDnAndGuid = (Boolean)object;
            this._postSet(26, bl, this._PrincipalEqualsCompareDnAndGuid);
            return;
        }
        if (string.equals("RealmBootStrapVersion")) {
            String string7 = this._RealmBootStrapVersion;
            this._RealmBootStrapVersion = (String)object;
            this._postSet(17, string7, this._RealmBootStrapVersion);
            return;
        }
        if (string.equals("Realms")) {
            RealmMBean[] realmMBeanArray = this._Realms;
            this._Realms = (RealmMBean[])object;
            this._postSet(7, realmMBeanArray, this._Realms);
            return;
        }
        if (string.equals("Salt")) {
            byte[] byArray = this._Salt;
            this._Salt = (byte[])object;
            this._postSet(9, byArray, this._Salt);
            return;
        }
        if (string.equals("WebAppFilesCaseInsensitive")) {
            String string8 = this._WebAppFilesCaseInsensitive;
            this._WebAppFilesCaseInsensitive = (String)object;
            this._postSet(16, string8, this._WebAppFilesCaseInsensitive);
            return;
        }
        if (string.equals("customizer")) {
            SecurityConfiguration securityConfiguration = this._customizer;
            this._customizer = (SecurityConfiguration)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AnonymousAdminLookupEnabled")) {
            return new Boolean(this._AnonymousAdminLookupEnabled);
        }
        if (string.equals("CertRevoc")) {
            return this._CertRevoc;
        }
        if (string.equals("ClearTextCredentialAccessEnabled")) {
            return new Boolean(this._ClearTextCredentialAccessEnabled);
        }
        if (string.equals("CompatibilityConnectionFiltersEnabled")) {
            return new Boolean(this._CompatibilityConnectionFiltersEnabled);
        }
        if (string.equals("ConnectionFilter")) {
            return this._ConnectionFilter;
        }
        if (string.equals("ConnectionFilterRules")) {
            return this._ConnectionFilterRules;
        }
        if (string.equals("ConnectionLoggerEnabled")) {
            return new Boolean(this._ConnectionLoggerEnabled);
        }
        if (string.equals("ConsoleFullDelegationEnabled")) {
            return new Boolean(this._ConsoleFullDelegationEnabled);
        }
        if (string.equals("Credential")) {
            return this._Credential;
        }
        if (string.equals("CredentialEncrypted")) {
            return this._CredentialEncrypted;
        }
        if (string.equals("CredentialGenerated")) {
            return new Boolean(this._CredentialGenerated);
        }
        if (string.equals("CrossDomainSecurityEnabled")) {
            return new Boolean(this._CrossDomainSecurityEnabled);
        }
        if (string.equals("DefaultRealm")) {
            return this._DefaultRealm;
        }
        if (string.equals("DefaultRealmInternal")) {
            return this._DefaultRealmInternal;
        }
        if (string.equals("DowngradeUntrustedPrincipals")) {
            return new Boolean(this._DowngradeUntrustedPrincipals);
        }
        if (string.equals("EncryptedAESSecretKey")) {
            return this._EncryptedAESSecretKey;
        }
        if (string.equals("EncryptedSecretKey")) {
            return this._EncryptedSecretKey;
        }
        if (string.equals("EnforceStrictURLPattern")) {
            return new Boolean(this._EnforceStrictURLPattern);
        }
        if (string.equals("EnforceValidBasicAuthCredentials")) {
            return new Boolean(this._EnforceValidBasicAuthCredentials);
        }
        if (string.equals("ExcludedDomainNames")) {
            return this._ExcludedDomainNames;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NodeManagerPassword")) {
            return this._NodeManagerPassword;
        }
        if (string.equals("NodeManagerPasswordEncrypted")) {
            return this._NodeManagerPasswordEncrypted;
        }
        if (string.equals("NodeManagerUsername")) {
            return this._NodeManagerUsername;
        }
        if (string.equals("PrincipalEqualsCaseInsensitive")) {
            return new Boolean(this._PrincipalEqualsCaseInsensitive);
        }
        if (string.equals("PrincipalEqualsCompareDnAndGuid")) {
            return new Boolean(this._PrincipalEqualsCompareDnAndGuid);
        }
        if (string.equals("RealmBootStrapVersion")) {
            return this._RealmBootStrapVersion;
        }
        if (string.equals("Realms")) {
            return this._Realms;
        }
        if (string.equals("Salt")) {
            return this._Salt;
        }
        if (string.equals("WebAppFilesCaseInsensitive")) {
            return this._WebAppFilesCaseInsensitive;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 10: {
                    if (string.equals("cert-revoc")) {
                        return 35;
                    }
                    if (!string.equals("credential")) break;
                    return 14;
                }
                case 40: {
                    if (!string.equals("compatibility-connection-filters-enabled")) break;
                    return 21;
                }
                case 17: {
                    if (!string.equals("connection-filter")) break;
                    return 18;
                }
                case 22: {
                    if (string.equals("connection-filter-rule")) {
                        return 19;
                    }
                    if (!string.equals("default-realm-internal")) break;
                    return 31;
                }
                case 25: {
                    if (!string.equals("connection-logger-enabled")) break;
                    return 20;
                }
                case 20: {
                    if (string.equals("credential-encrypted")) {
                        return 15;
                    }
                    if (string.equals("encrypted-secret-key")) {
                        return 10;
                    }
                    if (string.equals("excluded-domain-name")) {
                        return 32;
                    }
                    if (!string.equals("credential-generated")) break;
                    return 13;
                }
                case 13: {
                    if (!string.equals("default-realm")) break;
                    return 8;
                }
                case 30: {
                    if (string.equals("downgrade-untrusted-principals")) {
                        return 27;
                    }
                    if (string.equals("web-app-files-case-insensitive")) {
                        return 16;
                    }
                    if (!string.equals("anonymous-admin-lookup-enabled")) break;
                    return 11;
                }
                case 23: {
                    if (!string.equals("encryptedaes-secret-key")) break;
                    return 34;
                }
                case 26: {
                    if (!string.equals("enforce-strict-url-pattern")) break;
                    return 28;
                }
                case 36: {
                    if (string.equals("enforce-valid-basic-auth-credentials")) {
                        return 29;
                    }
                    if (string.equals("clear-text-credential-access-enabled")) {
                        return 12;
                    }
                    if (!string.equals("principal-equals-compare-dn-and-guid")) break;
                    return 26;
                }
                case 4: {
                    if (string.equals("name")) {
                        return 2;
                    }
                    if (!string.equals("salt")) break;
                    return 9;
                }
                case 21: {
                    if (string.equals("node-manager-password")) {
                        return 23;
                    }
                    if (!string.equals("node-manager-username")) break;
                    return 22;
                }
                case 31: {
                    if (string.equals("node-manager-password-encrypted")) {
                        return 24;
                    }
                    if (!string.equals("console-full-delegation-enabled")) break;
                    return 30;
                }
                case 24: {
                    if (!string.equals("realm-boot-strap-version")) break;
                    return 17;
                }
                case 5: {
                    if (!string.equals("realm")) break;
                    return 7;
                }
                case 29: {
                    if (!string.equals("cross-domain-security-enabled")) break;
                    return 33;
                }
                case 33: {
                    if (!string.equals("principal-equals-case-insensitive")) break;
                    return 25;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 35: {
                    return new CertRevocMBeanImpl.SchemaHelper2();
                }
                case 7: {
                    return new RealmMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 35: {
                    return "cert-revoc";
                }
                case 21: {
                    return "compatibility-connection-filters-enabled";
                }
                case 18: {
                    return "connection-filter";
                }
                case 19: {
                    return "connection-filter-rule";
                }
                case 20: {
                    return "connection-logger-enabled";
                }
                case 14: {
                    return "credential";
                }
                case 15: {
                    return "credential-encrypted";
                }
                case 8: {
                    return "default-realm";
                }
                case 31: {
                    return "default-realm-internal";
                }
                case 27: {
                    return "downgrade-untrusted-principals";
                }
                case 34: {
                    return "encryptedaes-secret-key";
                }
                case 10: {
                    return "encrypted-secret-key";
                }
                case 28: {
                    return "enforce-strict-url-pattern";
                }
                case 29: {
                    return "enforce-valid-basic-auth-credentials";
                }
                case 32: {
                    return "excluded-domain-name";
                }
                case 2: {
                    return "name";
                }
                case 23: {
                    return "node-manager-password";
                }
                case 24: {
                    return "node-manager-password-encrypted";
                }
                case 22: {
                    return "node-manager-username";
                }
                case 17: {
                    return "realm-boot-strap-version";
                }
                case 7: {
                    return "realm";
                }
                case 9: {
                    return "salt";
                }
                case 16: {
                    return "web-app-files-case-insensitive";
                }
                case 11: {
                    return "anonymous-admin-lookup-enabled";
                }
                case 12: {
                    return "clear-text-credential-access-enabled";
                }
                case 30: {
                    return "console-full-delegation-enabled";
                }
                case 13: {
                    return "credential-generated";
                }
                case 33: {
                    return "cross-domain-security-enabled";
                }
                case 25: {
                    return "principal-equals-case-insensitive";
                }
                case 26: {
                    return "principal-equals-compare-dn-and-guid";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 19: {
                    return true;
                }
                case 34: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 32: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 9: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 35: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private SecurityConfigurationMBeanImpl bean;

        protected Helper(SecurityConfigurationMBeanImpl securityConfigurationMBeanImpl) {
            super(securityConfigurationMBeanImpl);
            this.bean = securityConfigurationMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 35: {
                    return "CertRevoc";
                }
                case 21: {
                    return "CompatibilityConnectionFiltersEnabled";
                }
                case 18: {
                    return "ConnectionFilter";
                }
                case 19: {
                    return "ConnectionFilterRules";
                }
                case 20: {
                    return "ConnectionLoggerEnabled";
                }
                case 14: {
                    return "Credential";
                }
                case 15: {
                    return "CredentialEncrypted";
                }
                case 8: {
                    return "DefaultRealm";
                }
                case 31: {
                    return "DefaultRealmInternal";
                }
                case 27: {
                    return "DowngradeUntrustedPrincipals";
                }
                case 34: {
                    return "EncryptedAESSecretKey";
                }
                case 10: {
                    return "EncryptedSecretKey";
                }
                case 28: {
                    return "EnforceStrictURLPattern";
                }
                case 29: {
                    return "EnforceValidBasicAuthCredentials";
                }
                case 32: {
                    return "ExcludedDomainNames";
                }
                case 2: {
                    return "Name";
                }
                case 23: {
                    return "NodeManagerPassword";
                }
                case 24: {
                    return "NodeManagerPasswordEncrypted";
                }
                case 22: {
                    return "NodeManagerUsername";
                }
                case 17: {
                    return "RealmBootStrapVersion";
                }
                case 7: {
                    return "Realms";
                }
                case 9: {
                    return "Salt";
                }
                case 16: {
                    return "WebAppFilesCaseInsensitive";
                }
                case 11: {
                    return "AnonymousAdminLookupEnabled";
                }
                case 12: {
                    return "ClearTextCredentialAccessEnabled";
                }
                case 30: {
                    return "ConsoleFullDelegationEnabled";
                }
                case 13: {
                    return "CredentialGenerated";
                }
                case 33: {
                    return "CrossDomainSecurityEnabled";
                }
                case 25: {
                    return "PrincipalEqualsCaseInsensitive";
                }
                case 26: {
                    return "PrincipalEqualsCompareDnAndGuid";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CertRevoc")) {
                return 35;
            }
            if (string.equals("CompatibilityConnectionFiltersEnabled")) {
                return 21;
            }
            if (string.equals("ConnectionFilter")) {
                return 18;
            }
            if (string.equals("ConnectionFilterRules")) {
                return 19;
            }
            if (string.equals("ConnectionLoggerEnabled")) {
                return 20;
            }
            if (string.equals("Credential")) {
                return 14;
            }
            if (string.equals("CredentialEncrypted")) {
                return 15;
            }
            if (string.equals("DefaultRealm")) {
                return 8;
            }
            if (string.equals("DefaultRealmInternal")) {
                return 31;
            }
            if (string.equals("DowngradeUntrustedPrincipals")) {
                return 27;
            }
            if (string.equals("EncryptedAESSecretKey")) {
                return 34;
            }
            if (string.equals("EncryptedSecretKey")) {
                return 10;
            }
            if (string.equals("EnforceStrictURLPattern")) {
                return 28;
            }
            if (string.equals("EnforceValidBasicAuthCredentials")) {
                return 29;
            }
            if (string.equals("ExcludedDomainNames")) {
                return 32;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("NodeManagerPassword")) {
                return 23;
            }
            if (string.equals("NodeManagerPasswordEncrypted")) {
                return 24;
            }
            if (string.equals("NodeManagerUsername")) {
                return 22;
            }
            if (string.equals("RealmBootStrapVersion")) {
                return 17;
            }
            if (string.equals("Realms")) {
                return 7;
            }
            if (string.equals("Salt")) {
                return 9;
            }
            if (string.equals("WebAppFilesCaseInsensitive")) {
                return 16;
            }
            if (string.equals("AnonymousAdminLookupEnabled")) {
                return 11;
            }
            if (string.equals("ClearTextCredentialAccessEnabled")) {
                return 12;
            }
            if (string.equals("ConsoleFullDelegationEnabled")) {
                return 30;
            }
            if (string.equals("CredentialGenerated")) {
                return 13;
            }
            if (string.equals("CrossDomainSecurityEnabled")) {
                return 33;
            }
            if (string.equals("PrincipalEqualsCaseInsensitive")) {
                return 25;
            }
            if (string.equals("PrincipalEqualsCompareDnAndGuid")) {
                return 26;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getCertRevoc() != null) {
                arrayList.add(new ArrayIterator((Object[])new CertRevocMBean[]{this.bean.getCertRevoc()}));
            }
            arrayList.add(new ArrayIterator((Object[])this.bean.getRealms()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                l2 = this.computeChildHashValue(this.bean.getCertRevoc());
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isCompatibilityConnectionFiltersEnabledSet()) {
                    stringBuffer.append("CompatibilityConnectionFiltersEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getCompatibilityConnectionFiltersEnabled()));
                }
                if (this.bean.isConnectionFilterSet()) {
                    stringBuffer.append("ConnectionFilter");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionFilter()));
                }
                if (this.bean.isConnectionFilterRulesSet()) {
                    stringBuffer.append("ConnectionFilterRules");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getConnectionFilterRules())));
                }
                if (this.bean.isConnectionLoggerEnabledSet()) {
                    stringBuffer.append("ConnectionLoggerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionLoggerEnabled()));
                }
                if (this.bean.isCredentialSet()) {
                    stringBuffer.append("Credential");
                    stringBuffer.append(String.valueOf(this.bean.getCredential()));
                }
                if (this.bean.isCredentialEncryptedSet()) {
                    stringBuffer.append("CredentialEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getCredentialEncrypted())));
                }
                if (this.bean.isDefaultRealmSet()) {
                    stringBuffer.append("DefaultRealm");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultRealm()));
                }
                if (this.bean.isDefaultRealmInternalSet()) {
                    stringBuffer.append("DefaultRealmInternal");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultRealmInternal()));
                }
                if (this.bean.isDowngradeUntrustedPrincipalsSet()) {
                    stringBuffer.append("DowngradeUntrustedPrincipals");
                    stringBuffer.append(String.valueOf(this.bean.getDowngradeUntrustedPrincipals()));
                }
                if (this.bean.isEncryptedAESSecretKeySet()) {
                    stringBuffer.append("EncryptedAESSecretKey");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getEncryptedAESSecretKey())));
                }
                if (this.bean.isEncryptedSecretKeySet()) {
                    stringBuffer.append("EncryptedSecretKey");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getEncryptedSecretKey())));
                }
                if (this.bean.isEnforceStrictURLPatternSet()) {
                    stringBuffer.append("EnforceStrictURLPattern");
                    stringBuffer.append(String.valueOf(this.bean.getEnforceStrictURLPattern()));
                }
                if (this.bean.isEnforceValidBasicAuthCredentialsSet()) {
                    stringBuffer.append("EnforceValidBasicAuthCredentials");
                    stringBuffer.append(String.valueOf(this.bean.getEnforceValidBasicAuthCredentials()));
                }
                if (this.bean.isExcludedDomainNamesSet()) {
                    stringBuffer.append("ExcludedDomainNames");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getExcludedDomainNames())));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNodeManagerPasswordSet()) {
                    stringBuffer.append("NodeManagerPassword");
                    stringBuffer.append(String.valueOf(this.bean.getNodeManagerPassword()));
                }
                if (this.bean.isNodeManagerPasswordEncryptedSet()) {
                    stringBuffer.append("NodeManagerPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getNodeManagerPasswordEncrypted())));
                }
                if (this.bean.isNodeManagerUsernameSet()) {
                    stringBuffer.append("NodeManagerUsername");
                    stringBuffer.append(String.valueOf(this.bean.getNodeManagerUsername()));
                }
                if (this.bean.isRealmBootStrapVersionSet()) {
                    stringBuffer.append("RealmBootStrapVersion");
                    stringBuffer.append(String.valueOf(this.bean.getRealmBootStrapVersion()));
                }
                l2 = 0L;
                for (int i = 0; i < this.bean.getRealms().length; ++i) {
                    l2 ^= this.computeChildHashValue(this.bean.getRealms()[i]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isSaltSet()) {
                    stringBuffer.append("Salt");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getSalt())));
                }
                if (this.bean.isWebAppFilesCaseInsensitiveSet()) {
                    stringBuffer.append("WebAppFilesCaseInsensitive");
                    stringBuffer.append(String.valueOf(this.bean.getWebAppFilesCaseInsensitive()));
                }
                if (this.bean.isAnonymousAdminLookupEnabledSet()) {
                    stringBuffer.append("AnonymousAdminLookupEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isAnonymousAdminLookupEnabled()));
                }
                if (this.bean.isClearTextCredentialAccessEnabledSet()) {
                    stringBuffer.append("ClearTextCredentialAccessEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isClearTextCredentialAccessEnabled()));
                }
                if (this.bean.isConsoleFullDelegationEnabledSet()) {
                    stringBuffer.append("ConsoleFullDelegationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isConsoleFullDelegationEnabled()));
                }
                if (this.bean.isCredentialGeneratedSet()) {
                    stringBuffer.append("CredentialGenerated");
                    stringBuffer.append(String.valueOf(this.bean.isCredentialGenerated()));
                }
                if (this.bean.isCrossDomainSecurityEnabledSet()) {
                    stringBuffer.append("CrossDomainSecurityEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCrossDomainSecurityEnabled()));
                }
                if (this.bean.isPrincipalEqualsCaseInsensitiveSet()) {
                    stringBuffer.append("PrincipalEqualsCaseInsensitive");
                    stringBuffer.append(String.valueOf(this.bean.isPrincipalEqualsCaseInsensitive()));
                }
                if (this.bean.isPrincipalEqualsCompareDnAndGuidSet()) {
                    stringBuffer.append("PrincipalEqualsCompareDnAndGuid");
                    stringBuffer.append(String.valueOf(this.bean.isPrincipalEqualsCompareDnAndGuid()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SecurityConfigurationMBeanImpl securityConfigurationMBeanImpl = (SecurityConfigurationMBeanImpl)abstractDescriptorBean;
                this.computeSubDiff("CertRevoc", this.bean.getCertRevoc(), securityConfigurationMBeanImpl.getCertRevoc());
                this.computeDiff("CompatibilityConnectionFiltersEnabled", this.bean.getCompatibilityConnectionFiltersEnabled(), securityConfigurationMBeanImpl.getCompatibilityConnectionFiltersEnabled(), true);
                this.computeDiff("ConnectionFilter", this.bean.getConnectionFilter(), securityConfigurationMBeanImpl.getConnectionFilter(), false);
                this.computeDiff("ConnectionFilterRules", this.bean.getConnectionFilterRules(), securityConfigurationMBeanImpl.getConnectionFilterRules(), true);
                this.computeDiff("ConnectionLoggerEnabled", this.bean.getConnectionLoggerEnabled(), securityConfigurationMBeanImpl.getConnectionLoggerEnabled(), true);
                this.computeDiff("CredentialEncrypted", this.bean.getCredentialEncrypted(), securityConfigurationMBeanImpl.getCredentialEncrypted(), true);
                this.computeDiff("DefaultRealm", this.bean.getDefaultRealm(), securityConfigurationMBeanImpl.getDefaultRealm(), false);
                this.computeDiff("DefaultRealmInternal", this.bean.getDefaultRealmInternal(), securityConfigurationMBeanImpl.getDefaultRealmInternal(), false);
                this.computeDiff("DowngradeUntrustedPrincipals", this.bean.getDowngradeUntrustedPrincipals(), securityConfigurationMBeanImpl.getDowngradeUntrustedPrincipals(), false);
                this.computeDiff("EnforceStrictURLPattern", this.bean.getEnforceStrictURLPattern(), securityConfigurationMBeanImpl.getEnforceStrictURLPattern(), false);
                this.computeDiff("EnforceValidBasicAuthCredentials", this.bean.getEnforceValidBasicAuthCredentials(), securityConfigurationMBeanImpl.getEnforceValidBasicAuthCredentials(), false);
                this.computeDiff("ExcludedDomainNames", this.bean.getExcludedDomainNames(), securityConfigurationMBeanImpl.getExcludedDomainNames(), true);
                this.computeDiff("Name", this.bean.getName(), securityConfigurationMBeanImpl.getName(), false);
                this.computeDiff("NodeManagerPasswordEncrypted", this.bean.getNodeManagerPasswordEncrypted(), securityConfigurationMBeanImpl.getNodeManagerPasswordEncrypted(), true);
                this.computeDiff("NodeManagerUsername", this.bean.getNodeManagerUsername(), securityConfigurationMBeanImpl.getNodeManagerUsername(), true);
                this.computeDiff("RealmBootStrapVersion", this.bean.getRealmBootStrapVersion(), securityConfigurationMBeanImpl.getRealmBootStrapVersion(), false);
                this.computeChildDiff("Realms", this.bean.getRealms(), securityConfigurationMBeanImpl.getRealms(), false);
                this.computeDiff("WebAppFilesCaseInsensitive", this.bean.getWebAppFilesCaseInsensitive(), securityConfigurationMBeanImpl.getWebAppFilesCaseInsensitive(), false);
                this.computeDiff("AnonymousAdminLookupEnabled", this.bean.isAnonymousAdminLookupEnabled(), securityConfigurationMBeanImpl.isAnonymousAdminLookupEnabled(), false);
                this.computeDiff("ClearTextCredentialAccessEnabled", this.bean.isClearTextCredentialAccessEnabled(), securityConfigurationMBeanImpl.isClearTextCredentialAccessEnabled(), true);
                this.computeDiff("ConsoleFullDelegationEnabled", this.bean.isConsoleFullDelegationEnabled(), securityConfigurationMBeanImpl.isConsoleFullDelegationEnabled(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("CredentialGenerated", this.bean.isCredentialGenerated(), securityConfigurationMBeanImpl.isCredentialGenerated(), false);
                }
                this.computeDiff("CrossDomainSecurityEnabled", this.bean.isCrossDomainSecurityEnabled(), securityConfigurationMBeanImpl.isCrossDomainSecurityEnabled(), true);
                this.computeDiff("PrincipalEqualsCaseInsensitive", this.bean.isPrincipalEqualsCaseInsensitive(), securityConfigurationMBeanImpl.isPrincipalEqualsCaseInsensitive(), true);
                this.computeDiff("PrincipalEqualsCompareDnAndGuid", this.bean.isPrincipalEqualsCompareDnAndGuid(), securityConfigurationMBeanImpl.isPrincipalEqualsCompareDnAndGuid(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SecurityConfigurationMBeanImpl securityConfigurationMBeanImpl = (SecurityConfigurationMBeanImpl)beanUpdateEvent.getSourceBean();
                SecurityConfigurationMBeanImpl securityConfigurationMBeanImpl2 = (SecurityConfigurationMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CertRevoc")) {
                    if (n == 2) {
                        securityConfigurationMBeanImpl.setCertRevoc((CertRevocMBean)this.createCopy((AbstractDescriptorBean)securityConfigurationMBeanImpl2.getCertRevoc()));
                    } else if (n == 3) {
                        securityConfigurationMBeanImpl._destroySingleton("CertRevoc", securityConfigurationMBeanImpl.getCertRevoc());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                } else if (string.equals("CompatibilityConnectionFiltersEnabled")) {
                    securityConfigurationMBeanImpl.setCompatibilityConnectionFiltersEnabled(securityConfigurationMBeanImpl2.getCompatibilityConnectionFiltersEnabled());
                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("ConnectionFilter")) {
                    securityConfigurationMBeanImpl.setConnectionFilter(securityConfigurationMBeanImpl2.getConnectionFilter());
                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("ConnectionFilterRules")) {
                    securityConfigurationMBeanImpl.setConnectionFilterRules(securityConfigurationMBeanImpl2.getConnectionFilterRules());
                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("ConnectionLoggerEnabled")) {
                    securityConfigurationMBeanImpl.setConnectionLoggerEnabled(securityConfigurationMBeanImpl2.getConnectionLoggerEnabled());
                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (!string.equals("Credential")) {
                    if (string.equals("CredentialEncrypted")) {
                        securityConfigurationMBeanImpl.setCredentialEncrypted(securityConfigurationMBeanImpl2.getCredentialEncrypted());
                        securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("DefaultRealm")) {
                        securityConfigurationMBeanImpl.setDefaultRealmAsString(securityConfigurationMBeanImpl2.getDefaultRealmAsString());
                        securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("DefaultRealmInternal")) {
                        securityConfigurationMBeanImpl.setDefaultRealmInternalAsString(securityConfigurationMBeanImpl2.getDefaultRealmInternalAsString());
                        securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                    } else if (string.equals("DowngradeUntrustedPrincipals")) {
                        securityConfigurationMBeanImpl.setDowngradeUntrustedPrincipals(securityConfigurationMBeanImpl2.getDowngradeUntrustedPrincipals());
                        securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                    } else if (!string.equals("EncryptedAESSecretKey") && !string.equals("EncryptedSecretKey")) {
                        if (string.equals("EnforceStrictURLPattern")) {
                            securityConfigurationMBeanImpl.setEnforceStrictURLPattern(securityConfigurationMBeanImpl2.getEnforceStrictURLPattern());
                            securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                        } else if (string.equals("EnforceValidBasicAuthCredentials")) {
                            securityConfigurationMBeanImpl.setEnforceValidBasicAuthCredentials(securityConfigurationMBeanImpl2.getEnforceValidBasicAuthCredentials());
                            securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                        } else if (string.equals("ExcludedDomainNames")) {
                            securityConfigurationMBeanImpl.setExcludedDomainNames(securityConfigurationMBeanImpl2.getExcludedDomainNames());
                            securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                        } else if (string.equals("Name")) {
                            securityConfigurationMBeanImpl.setName(securityConfigurationMBeanImpl2.getName());
                            securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                        } else if (!string.equals("NodeManagerPassword")) {
                            if (string.equals("NodeManagerPasswordEncrypted")) {
                                securityConfigurationMBeanImpl.setNodeManagerPasswordEncrypted(securityConfigurationMBeanImpl2.getNodeManagerPasswordEncrypted());
                                securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                            } else if (string.equals("NodeManagerUsername")) {
                                securityConfigurationMBeanImpl.setNodeManagerUsername(securityConfigurationMBeanImpl2.getNodeManagerUsername());
                                securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                            } else if (string.equals("RealmBootStrapVersion")) {
                                securityConfigurationMBeanImpl.setRealmBootStrapVersion(securityConfigurationMBeanImpl2.getRealmBootStrapVersion());
                                securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                            } else if (string.equals("Realms")) {
                                if (n == 2) {
                                    propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                    securityConfigurationMBeanImpl.addRealm((RealmMBean)propertyUpdate.getAddedObject());
                                } else if (n == 3) {
                                    securityConfigurationMBeanImpl.removeRealm((RealmMBean)propertyUpdate.getRemovedObject());
                                } else {
                                    throw new AssertionError((Object)("Invalid type: " + n));
                                }
                                if (securityConfigurationMBeanImpl.getRealms() == null || securityConfigurationMBeanImpl.getRealms().length == 0) {
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                                }
                            } else if (!string.equals("Salt")) {
                                if (string.equals("WebAppFilesCaseInsensitive")) {
                                    securityConfigurationMBeanImpl.setWebAppFilesCaseInsensitive(securityConfigurationMBeanImpl2.getWebAppFilesCaseInsensitive());
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                                } else if (string.equals("AnonymousAdminLookupEnabled")) {
                                    securityConfigurationMBeanImpl.setAnonymousAdminLookupEnabled(securityConfigurationMBeanImpl2.isAnonymousAdminLookupEnabled());
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                                } else if (string.equals("ClearTextCredentialAccessEnabled")) {
                                    securityConfigurationMBeanImpl.setClearTextCredentialAccessEnabled(securityConfigurationMBeanImpl2.isClearTextCredentialAccessEnabled());
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                                } else if (string.equals("ConsoleFullDelegationEnabled")) {
                                    securityConfigurationMBeanImpl.setConsoleFullDelegationEnabled(securityConfigurationMBeanImpl2.isConsoleFullDelegationEnabled());
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                                } else if (string.equals("CredentialGenerated")) {
                                    securityConfigurationMBeanImpl.setCredentialGenerated(securityConfigurationMBeanImpl2.isCredentialGenerated());
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                                } else if (string.equals("CrossDomainSecurityEnabled")) {
                                    securityConfigurationMBeanImpl.setCrossDomainSecurityEnabled(securityConfigurationMBeanImpl2.isCrossDomainSecurityEnabled());
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                                } else if (string.equals("PrincipalEqualsCaseInsensitive")) {
                                    securityConfigurationMBeanImpl.setPrincipalEqualsCaseInsensitive(securityConfigurationMBeanImpl2.isPrincipalEqualsCaseInsensitive());
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                                } else if (string.equals("PrincipalEqualsCompareDnAndGuid")) {
                                    securityConfigurationMBeanImpl.setPrincipalEqualsCompareDnAndGuid(securityConfigurationMBeanImpl2.isPrincipalEqualsCompareDnAndGuid());
                                    securityConfigurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                                } else {
                                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                Object[] objectArray;
                SecurityConfigurationMBeanImpl securityConfigurationMBeanImpl = (SecurityConfigurationMBeanImpl)abstractDescriptorBean;
                super.finishCopy(securityConfigurationMBeanImpl, bl, list);
                if (!(list != null && list.contains("CertRevoc") || !this.bean.isCertRevocSet() || securityConfigurationMBeanImpl._isSet(35))) {
                    objectArray = this.bean.getCertRevoc();
                    securityConfigurationMBeanImpl.setCertRevoc(null);
                    securityConfigurationMBeanImpl.setCertRevoc(objectArray == null ? null : (CertRevocMBean)this.createCopy((AbstractDescriptorBean)objectArray, bl));
                }
                if ((list == null || !list.contains("CompatibilityConnectionFiltersEnabled")) && this.bean.isCompatibilityConnectionFiltersEnabledSet()) {
                    securityConfigurationMBeanImpl.setCompatibilityConnectionFiltersEnabled(this.bean.getCompatibilityConnectionFiltersEnabled());
                }
                if ((list == null || !list.contains("ConnectionFilter")) && this.bean.isConnectionFilterSet()) {
                    securityConfigurationMBeanImpl.setConnectionFilter(this.bean.getConnectionFilter());
                }
                if ((list == null || !list.contains("ConnectionFilterRules")) && this.bean.isConnectionFilterRulesSet()) {
                    objectArray = this.bean.getConnectionFilterRules();
                    securityConfigurationMBeanImpl.setConnectionFilterRules(objectArray == null ? null : (String[])objectArray.clone());
                }
                if ((list == null || !list.contains("ConnectionLoggerEnabled")) && this.bean.isConnectionLoggerEnabledSet()) {
                    securityConfigurationMBeanImpl.setConnectionLoggerEnabled(this.bean.getConnectionLoggerEnabled());
                }
                if ((list == null || !list.contains("CredentialEncrypted")) && this.bean.isCredentialEncryptedSet()) {
                    objectArray = this.bean.getCredentialEncrypted();
                    securityConfigurationMBeanImpl.setCredentialEncrypted(objectArray == null ? null : (byte[])((byte[])objectArray).clone());
                }
                if ((list == null || !list.contains("DefaultRealm")) && this.bean.isDefaultRealmSet()) {
                    securityConfigurationMBeanImpl._unSet(securityConfigurationMBeanImpl, 8);
                    securityConfigurationMBeanImpl.setDefaultRealmAsString(this.bean.getDefaultRealmAsString());
                }
                if ((list == null || !list.contains("DefaultRealmInternal")) && this.bean.isDefaultRealmInternalSet()) {
                    securityConfigurationMBeanImpl._unSet(securityConfigurationMBeanImpl, 31);
                    securityConfigurationMBeanImpl.setDefaultRealmInternalAsString(this.bean.getDefaultRealmInternalAsString());
                }
                if ((list == null || !list.contains("DowngradeUntrustedPrincipals")) && this.bean.isDowngradeUntrustedPrincipalsSet()) {
                    securityConfigurationMBeanImpl.setDowngradeUntrustedPrincipals(this.bean.getDowngradeUntrustedPrincipals());
                }
                if ((list == null || !list.contains("EnforceStrictURLPattern")) && this.bean.isEnforceStrictURLPatternSet()) {
                    securityConfigurationMBeanImpl.setEnforceStrictURLPattern(this.bean.getEnforceStrictURLPattern());
                }
                if ((list == null || !list.contains("EnforceValidBasicAuthCredentials")) && this.bean.isEnforceValidBasicAuthCredentialsSet()) {
                    securityConfigurationMBeanImpl.setEnforceValidBasicAuthCredentials(this.bean.getEnforceValidBasicAuthCredentials());
                }
                if ((list == null || !list.contains("ExcludedDomainNames")) && this.bean.isExcludedDomainNamesSet()) {
                    objectArray = this.bean.getExcludedDomainNames();
                    securityConfigurationMBeanImpl.setExcludedDomainNames(objectArray == null ? null : (String[])objectArray.clone());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    securityConfigurationMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("NodeManagerPasswordEncrypted")) && this.bean.isNodeManagerPasswordEncryptedSet()) {
                    objectArray = this.bean.getNodeManagerPasswordEncrypted();
                    securityConfigurationMBeanImpl.setNodeManagerPasswordEncrypted(objectArray == null ? null : (byte[])((byte[])objectArray).clone());
                }
                if ((list == null || !list.contains("NodeManagerUsername")) && this.bean.isNodeManagerUsernameSet()) {
                    securityConfigurationMBeanImpl.setNodeManagerUsername(this.bean.getNodeManagerUsername());
                }
                if ((list == null || !list.contains("RealmBootStrapVersion")) && this.bean.isRealmBootStrapVersionSet()) {
                    securityConfigurationMBeanImpl.setRealmBootStrapVersion(this.bean.getRealmBootStrapVersion());
                }
                if (!(list != null && list.contains("Realms") || !this.bean.isRealmsSet() || securityConfigurationMBeanImpl._isSet(7))) {
                    RealmMBean[] realmMBeanArray = this.bean.getRealms();
                    RealmMBean[] realmMBeanArray2 = new RealmMBean[realmMBeanArray.length];
                    for (int i = 0; i < realmMBeanArray2.length; ++i) {
                        realmMBeanArray2[i] = (RealmMBean)this.createCopy((AbstractDescriptorBean)realmMBeanArray[i], bl);
                    }
                    securityConfigurationMBeanImpl.setRealms(realmMBeanArray2);
                }
                if ((list == null || !list.contains("WebAppFilesCaseInsensitive")) && this.bean.isWebAppFilesCaseInsensitiveSet()) {
                    securityConfigurationMBeanImpl.setWebAppFilesCaseInsensitive(this.bean.getWebAppFilesCaseInsensitive());
                }
                if ((list == null || !list.contains("AnonymousAdminLookupEnabled")) && this.bean.isAnonymousAdminLookupEnabledSet()) {
                    securityConfigurationMBeanImpl.setAnonymousAdminLookupEnabled(this.bean.isAnonymousAdminLookupEnabled());
                }
                if ((list == null || !list.contains("ClearTextCredentialAccessEnabled")) && this.bean.isClearTextCredentialAccessEnabledSet()) {
                    securityConfigurationMBeanImpl.setClearTextCredentialAccessEnabled(this.bean.isClearTextCredentialAccessEnabled());
                }
                if ((list == null || !list.contains("ConsoleFullDelegationEnabled")) && this.bean.isConsoleFullDelegationEnabledSet()) {
                    securityConfigurationMBeanImpl.setConsoleFullDelegationEnabled(this.bean.isConsoleFullDelegationEnabled());
                }
                if (bl && (list == null || !list.contains("CredentialGenerated")) && this.bean.isCredentialGeneratedSet()) {
                    securityConfigurationMBeanImpl.setCredentialGenerated(this.bean.isCredentialGenerated());
                }
                if ((list == null || !list.contains("CrossDomainSecurityEnabled")) && this.bean.isCrossDomainSecurityEnabledSet()) {
                    securityConfigurationMBeanImpl.setCrossDomainSecurityEnabled(this.bean.isCrossDomainSecurityEnabled());
                }
                if ((list == null || !list.contains("PrincipalEqualsCaseInsensitive")) && this.bean.isPrincipalEqualsCaseInsensitiveSet()) {
                    securityConfigurationMBeanImpl.setPrincipalEqualsCaseInsensitive(this.bean.isPrincipalEqualsCaseInsensitive());
                }
                if ((list == null || !list.contains("PrincipalEqualsCompareDnAndGuid")) && this.bean.isPrincipalEqualsCompareDnAndGuidSet()) {
                    securityConfigurationMBeanImpl.setPrincipalEqualsCompareDnAndGuid(this.bean.isPrincipalEqualsCompareDnAndGuid());
                }
                return securityConfigurationMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getCertRevoc(), clazz, object);
            this.inferSubTree(this.bean.getDefaultRealm(), clazz, object);
            this.inferSubTree(this.bean.getDefaultRealmInternal(), clazz, object);
            this.inferSubTree(this.bean.getRealms(), clazz, object);
        }
    }
}

