/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.security.auth.login.LoginException;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.SecurityMBean;
import weblogic.security.SecurityLogger;
import weblogic.security.SecurityService;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.net.ConnectionFilter;
import weblogic.security.net.ConnectionFilterRulesListener;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;

public final class SecurityLegalHelper {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static boolean isLegalFilterRules(SecurityMBean securityMBean, String[] stringArray) {
        return SecurityLegalHelper.isLegalFilterRules(securityMBean.getConnectionFilter(), stringArray);
    }

    public static boolean isLegalFilterRules(SecurityConfigurationMBean securityConfigurationMBean, String[] stringArray) {
        return SecurityLegalHelper.isLegalFilterRules(securityConfigurationMBean.getConnectionFilter(), stringArray);
    }

    private static boolean isLegalFilterRules(String string, String[] stringArray) {
        block6: {
            if (string != null && SecurityService.getConnectionFilterEnabled()) {
                ConnectionFilter connectionFilter = SecurityService.getConnectionFilter();
                try {
                    Class<?> clazz = Class.forName(string);
                    if (!ConnectionFilterRulesListener.class.isAssignableFrom(clazz)) break block6;
                    try {
                        String string2 = "checkRules";
                        Class[] classArray = new Class[]{String[].class};
                        Method method = clazz.getMethod(string2, classArray);
                        Object[] objectArray = new Object[]{stringArray};
                        method.invoke((Object)connectionFilter, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        if (throwable.toString().startsWith("java.text.ParseException")) {
                            String string3 = throwable.getMessage();
                            SecurityLogger.logUpdateFilterWarn((String)string3);
                            throw new IllegalArgumentException(string3 + "  Rules will not be updated.");
                        }
                        throw invocationTargetException;
                    }
                }
                catch (Throwable throwable) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("problem with connection filter. Exception:" + throwable);
                    illegalArgumentException.initCause(throwable);
                    throw illegalArgumentException;
                }
            }
        }
        return true;
    }

    public static void validateSecurity(SecurityMBean securityMBean) throws IllegalArgumentException {
        boolean bl = SecurityLegalHelper.isLegalFilterRules(securityMBean, securityMBean.getConnectionFilterRules());
        if (!bl) {
            throw new IllegalArgumentException("ConnectionFilterRules string is not valid");
        }
    }

    public static void validateSecurityConfiguration(SecurityConfigurationMBean securityConfigurationMBean) throws IllegalArgumentException {
        boolean bl = SecurityLegalHelper.isLegalFilterRules(securityConfigurationMBean, securityConfigurationMBean.getConnectionFilterRules());
        if (!bl) {
            throw new IllegalArgumentException("ConnectionFilterRules string is not valid");
        }
    }

    public static void validatePrincipalName(String string) throws IllegalArgumentException {
        try {
            if (!Kernel.isServer()) {
                return;
            }
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
            if (SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject)) {
                return;
            }
            PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)SecurityServiceManager.getDefaultRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
            AuthenticatedSubject authenticatedSubject2 = principalAuthenticator.impersonateIdentity(string);
            if (SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject2)) {
                throw new IllegalArgumentException("The principal name : " + string + " has higher privileges than the current user: " + authenticatedSubject + ". Hence the current user cannot set the principal name." + " Modify the principal name with admin privileged user.");
            }
        }
        catch (LoginException loginException) {
            throw new IllegalArgumentException("Invalid principal name: " + string, loginException);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid principal name: " + string, exception);
        }
    }
}

