/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.PasswordPolicyMBean;
import weblogic.management.configuration.RealmMBean;
import weblogic.management.configuration.SecurityLegalHelper;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.mbeans.custom.Security;
import weblogic.management.runtime.ServerSecurityRuntimeMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class SecurityMBeanImpl
extends ConfigurationMBeanImpl
implements SecurityMBean,
Serializable {
    private String _AuditProviderClassName;
    private boolean _CompatibilityMode;
    private String _ConnectionFilter;
    private String[] _ConnectionFilterRules;
    private boolean _ConnectionLoggerEnabled;
    private byte[] _EncryptedSecretKey;
    private boolean _GuestDisabled;
    private boolean _LogAllChecksEnabled;
    private String _Name;
    private PasswordPolicyMBean _PasswordPolicy;
    private RealmMBean _Realm;
    private byte[] _Salt;
    private ServerSecurityRuntimeMBean _ServerSecurityRuntime;
    private String _SystemUser;
    private Security _customizer;
    private static SchemaHelper2 _schemaHelper;

    public SecurityMBeanImpl() {
        try {
            this._customizer = new Security(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public SecurityMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new Security(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public RealmMBean getRealm() {
        return this._Realm;
    }

    public String getRealmAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getRealm();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isRealmSet() {
        return this._isSet(7);
    }

    public void setRealmAsString(String string) {
        if (string == null || string.length() == 0) {
            RealmMBean realmMBean = this._Realm;
            this._initializeProperty(7);
            this._postSet(7, realmMBean, this._Realm);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, RealmMBean.class, new ReferenceManager.Resolver(this, 7){

                public void resolveReference(Object object) {
                    try {
                        SecurityMBeanImpl.this.setRealm((RealmMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setRealm(RealmMBean realmMBean) throws InvalidAttributeValueException {
        RealmMBean realmMBean2;
        if (realmMBean != null) {
            realmMBean2 = new ResolvedReference(this, 7, (AbstractDescriptorBean)realmMBean){

                protected Object getPropertyValue() {
                    return SecurityMBeanImpl.this.getRealm();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)realmMBean, (ResolvedReference)realmMBean2);
        }
        realmMBean2 = this._Realm;
        this._Realm = realmMBean;
        this._postSet(7, realmMBean2, realmMBean);
    }

    public String getAuditProviderClassName() {
        return this._AuditProviderClassName;
    }

    public boolean isAuditProviderClassNameSet() {
        return this._isSet(8);
    }

    public void setAuditProviderClassName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._AuditProviderClassName;
        this._AuditProviderClassName = string;
        this._postSet(8, string2, string);
    }

    public boolean isGuestDisabled() {
        return this._GuestDisabled;
    }

    public boolean isGuestDisabledSet() {
        return this._isSet(9);
    }

    public void setGuestDisabled(boolean bl) {
        boolean bl2 = this._GuestDisabled;
        this._GuestDisabled = bl;
        this._postSet(9, bl2, bl);
    }

    public String getConnectionFilter() {
        return this._customizer.getConnectionFilter();
    }

    public boolean isConnectionFilterSet() {
        return this._isSet(10);
    }

    public void setConnectionFilter(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this._customizer.setConnectionFilter(string);
    }

    public String getSystemUser() {
        return this._customizer.getSystemUser();
    }

    public boolean isSystemUserSet() {
        return this._isSet(11);
    }

    public void setSystemUser(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"SystemUser", (Object)string);
        String string2 = this.getSystemUser();
        this._customizer.setSystemUser(string);
        this._postSet(11, string2, string);
    }

    public boolean getLogAllChecksEnabled() {
        return this._LogAllChecksEnabled;
    }

    public boolean isLogAllChecksEnabledSet() {
        return this._isSet(12);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setLogAllChecksEnabled(boolean bl) {
        boolean bl2 = this._LogAllChecksEnabled;
        this._LogAllChecksEnabled = bl;
        this._postSet(12, bl2, bl);
    }

    public PasswordPolicyMBean getPasswordPolicy() {
        return this._PasswordPolicy;
    }

    public String getPasswordPolicyAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getPasswordPolicy();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isPasswordPolicySet() {
        return this._isSet(13);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setPasswordPolicyAsString(String string) {
        if (string == null || string.length() == 0) {
            PasswordPolicyMBean passwordPolicyMBean = this._PasswordPolicy;
            this._initializeProperty(13);
            this._postSet(13, passwordPolicyMBean, this._PasswordPolicy);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, PasswordPolicyMBean.class, new ReferenceManager.Resolver(this, 13){

                public void resolveReference(Object object) {
                    try {
                        SecurityMBeanImpl.this.setPasswordPolicy((PasswordPolicyMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setPasswordPolicy(PasswordPolicyMBean passwordPolicyMBean) throws InvalidAttributeValueException {
        PasswordPolicyMBean passwordPolicyMBean2;
        if (passwordPolicyMBean != null) {
            passwordPolicyMBean2 = new ResolvedReference(this, 13, (AbstractDescriptorBean)passwordPolicyMBean){

                protected Object getPropertyValue() {
                    return SecurityMBeanImpl.this.getPasswordPolicy();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)passwordPolicyMBean, (ResolvedReference)passwordPolicyMBean2);
        }
        passwordPolicyMBean2 = this._PasswordPolicy;
        this._PasswordPolicy = passwordPolicyMBean;
        this._postSet(13, passwordPolicyMBean2, passwordPolicyMBean);
    }

    public byte[] getSalt() {
        return this._customizer.getSalt();
    }

    public boolean isSaltSet() {
        return this._isSet(14);
    }

    public void setSalt(byte[] byArray) throws InvalidAttributeValueException {
        this._Salt = byArray;
    }

    public byte[] getEncryptedSecretKey() {
        return this._customizer.getEncryptedSecretKey();
    }

    public boolean isEncryptedSecretKeySet() {
        return this._isSet(15);
    }

    public void setEncryptedSecretKey(byte[] byArray) throws InvalidAttributeValueException {
        this._EncryptedSecretKey = byArray;
    }

    public ServerSecurityRuntimeMBean getServerSecurityRuntime() {
        return this._ServerSecurityRuntime;
    }

    public boolean isServerSecurityRuntimeSet() {
        return this._isSet(16);
    }

    public void setServerSecurityRuntime(ServerSecurityRuntimeMBean serverSecurityRuntimeMBean) {
        this._ServerSecurityRuntime = serverSecurityRuntimeMBean;
    }

    public boolean isCompatibilityMode() {
        return this._CompatibilityMode;
    }

    public boolean isCompatibilityModeSet() {
        return this._isSet(17);
    }

    public void setCompatibilityMode(boolean bl) {
        boolean bl2 = this._CompatibilityMode;
        this._CompatibilityMode = bl;
        this._postSet(17, bl2, bl);
    }

    public String[] getConnectionFilterRules() {
        return this._customizer.getConnectionFilterRules();
    }

    public boolean isConnectionFilterRulesSet() {
        return this._isSet(18);
    }

    public void setConnectionFilterRules(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        this._getHelper()._ensureNonNullElements(stringArray);
        this._customizer.setConnectionFilterRules(stringArray);
    }

    public boolean getConnectionLoggerEnabled() {
        return this._customizer.getConnectionLoggerEnabled();
    }

    public boolean isConnectionLoggerEnabledSet() {
        return this._isSet(19);
    }

    public void setConnectionLoggerEnabled(boolean bl) throws InvalidAttributeValueException {
        this._customizer.setConnectionLoggerEnabled(bl);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        SecurityLegalHelper.validateSecurity(this);
    }

    protected void _postCreate() {
        this._customizer._postCreate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._AuditProviderClassName = null;
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setConnectionFilter(null);
                    if (bl) break;
                }
                case 18: {
                    this._customizer.setConnectionFilterRules(new String[0]);
                    if (bl) break;
                }
                case 19: {
                    this._customizer.setConnectionLoggerEnabled(false);
                    if (bl) break;
                }
                case 15: {
                    this._EncryptedSecretKey = new byte[0];
                    if (bl) break;
                }
                case 12: {
                    this._LogAllChecksEnabled = false;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 13: {
                    this._PasswordPolicy = null;
                    if (bl) break;
                }
                case 7: {
                    this._Realm = null;
                    if (bl) break;
                }
                case 14: {
                    this._Salt = new byte[0];
                    if (bl) break;
                }
                case 16: {
                    this._ServerSecurityRuntime = null;
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setSystemUser("system");
                    if (bl) break;
                }
                case 17: {
                    this._CompatibilityMode = false;
                    if (bl) break;
                }
                case 9: {
                    this._GuestDisabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Security";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AuditProviderClassName")) {
            String string2 = this._AuditProviderClassName;
            this._AuditProviderClassName = (String)object;
            this._postSet(8, string2, this._AuditProviderClassName);
            return;
        }
        if (string.equals("CompatibilityMode")) {
            boolean bl = this._CompatibilityMode;
            this._CompatibilityMode = (Boolean)object;
            this._postSet(17, bl, this._CompatibilityMode);
            return;
        }
        if (string.equals("ConnectionFilter")) {
            String string3 = this._ConnectionFilter;
            this._ConnectionFilter = (String)object;
            this._postSet(10, string3, this._ConnectionFilter);
            return;
        }
        if (string.equals("ConnectionFilterRules")) {
            String[] stringArray = this._ConnectionFilterRules;
            this._ConnectionFilterRules = (String[])object;
            this._postSet(18, stringArray, this._ConnectionFilterRules);
            return;
        }
        if (string.equals("ConnectionLoggerEnabled")) {
            boolean bl = this._ConnectionLoggerEnabled;
            this._ConnectionLoggerEnabled = (Boolean)object;
            this._postSet(19, bl, this._ConnectionLoggerEnabled);
            return;
        }
        if (string.equals("EncryptedSecretKey")) {
            byte[] byArray = this._EncryptedSecretKey;
            this._EncryptedSecretKey = (byte[])object;
            this._postSet(15, byArray, this._EncryptedSecretKey);
            return;
        }
        if (string.equals("GuestDisabled")) {
            boolean bl = this._GuestDisabled;
            this._GuestDisabled = (Boolean)object;
            this._postSet(9, bl, this._GuestDisabled);
            return;
        }
        if (string.equals("LogAllChecksEnabled")) {
            boolean bl = this._LogAllChecksEnabled;
            this._LogAllChecksEnabled = (Boolean)object;
            this._postSet(12, bl, this._LogAllChecksEnabled);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("PasswordPolicy")) {
            PasswordPolicyMBean passwordPolicyMBean = this._PasswordPolicy;
            this._PasswordPolicy = (PasswordPolicyMBean)object;
            this._postSet(13, passwordPolicyMBean, this._PasswordPolicy);
            return;
        }
        if (string.equals("Realm")) {
            RealmMBean realmMBean = this._Realm;
            this._Realm = (RealmMBean)object;
            this._postSet(7, realmMBean, this._Realm);
            return;
        }
        if (string.equals("Salt")) {
            byte[] byArray = this._Salt;
            this._Salt = (byte[])object;
            this._postSet(14, byArray, this._Salt);
            return;
        }
        if (string.equals("ServerSecurityRuntime")) {
            ServerSecurityRuntimeMBean serverSecurityRuntimeMBean = this._ServerSecurityRuntime;
            this._ServerSecurityRuntime = (ServerSecurityRuntimeMBean)object;
            this._postSet(16, serverSecurityRuntimeMBean, this._ServerSecurityRuntime);
            return;
        }
        if (string.equals("SystemUser")) {
            String string5 = this._SystemUser;
            this._SystemUser = (String)object;
            this._postSet(11, string5, this._SystemUser);
            return;
        }
        if (string.equals("customizer")) {
            Security security = this._customizer;
            this._customizer = (Security)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AuditProviderClassName")) {
            return this._AuditProviderClassName;
        }
        if (string.equals("CompatibilityMode")) {
            return new Boolean(this._CompatibilityMode);
        }
        if (string.equals("ConnectionFilter")) {
            return this._ConnectionFilter;
        }
        if (string.equals("ConnectionFilterRules")) {
            return this._ConnectionFilterRules;
        }
        if (string.equals("ConnectionLoggerEnabled")) {
            return new Boolean(this._ConnectionLoggerEnabled);
        }
        if (string.equals("EncryptedSecretKey")) {
            return this._EncryptedSecretKey;
        }
        if (string.equals("GuestDisabled")) {
            return new Boolean(this._GuestDisabled);
        }
        if (string.equals("LogAllChecksEnabled")) {
            return new Boolean(this._LogAllChecksEnabled);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PasswordPolicy")) {
            return this._PasswordPolicy;
        }
        if (string.equals("Realm")) {
            return this._Realm;
        }
        if (string.equals("Salt")) {
            return this._Salt;
        }
        if (string.equals("ServerSecurityRuntime")) {
            return this._ServerSecurityRuntime;
        }
        if (string.equals("SystemUser")) {
            return this._SystemUser;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonNull((String)"SystemUser", (Object)"system");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property SystemUser in SecurityMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 25: {
                    if (string.equals("audit-provider-class-name")) {
                        return 8;
                    }
                    if (!string.equals("connection-logger-enabled")) break;
                    return 19;
                }
                case 17: {
                    if (!string.equals("connection-filter")) break;
                    return 10;
                }
                case 22: {
                    if (string.equals("connection-filter-rule")) {
                        return 18;
                    }
                    if (!string.equals("log-all-checks-enabled")) break;
                    return 12;
                }
                case 20: {
                    if (!string.equals("encrypted-secret-key")) break;
                    return 15;
                }
                case 4: {
                    if (string.equals("name")) {
                        return 2;
                    }
                    if (!string.equals("salt")) break;
                    return 14;
                }
                case 15: {
                    if (!string.equals("password-policy")) break;
                    return 13;
                }
                case 5: {
                    if (!string.equals("realm")) break;
                    return 7;
                }
                case 23: {
                    if (!string.equals("server-security-runtime")) break;
                    return 16;
                }
                case 11: {
                    if (!string.equals("system-user")) break;
                    return 11;
                }
                case 18: {
                    if (!string.equals("compatibility-mode")) break;
                    return 17;
                }
                case 14: {
                    if (!string.equals("guest-disabled")) break;
                    return 9;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "audit-provider-class-name";
                }
                case 10: {
                    return "connection-filter";
                }
                case 18: {
                    return "connection-filter-rule";
                }
                case 19: {
                    return "connection-logger-enabled";
                }
                case 15: {
                    return "encrypted-secret-key";
                }
                case 12: {
                    return "log-all-checks-enabled";
                }
                case 2: {
                    return "name";
                }
                case 13: {
                    return "password-policy";
                }
                case 7: {
                    return "realm";
                }
                case 14: {
                    return "salt";
                }
                case 16: {
                    return "server-security-runtime";
                }
                case 11: {
                    return "system-user";
                }
                case 17: {
                    return "compatibility-mode";
                }
                case 9: {
                    return "guest-disabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 18: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 14: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private SecurityMBeanImpl bean;

        protected Helper(SecurityMBeanImpl securityMBeanImpl) {
            super(securityMBeanImpl);
            this.bean = securityMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "AuditProviderClassName";
                }
                case 10: {
                    return "ConnectionFilter";
                }
                case 18: {
                    return "ConnectionFilterRules";
                }
                case 19: {
                    return "ConnectionLoggerEnabled";
                }
                case 15: {
                    return "EncryptedSecretKey";
                }
                case 12: {
                    return "LogAllChecksEnabled";
                }
                case 2: {
                    return "Name";
                }
                case 13: {
                    return "PasswordPolicy";
                }
                case 7: {
                    return "Realm";
                }
                case 14: {
                    return "Salt";
                }
                case 16: {
                    return "ServerSecurityRuntime";
                }
                case 11: {
                    return "SystemUser";
                }
                case 17: {
                    return "CompatibilityMode";
                }
                case 9: {
                    return "GuestDisabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AuditProviderClassName")) {
                return 8;
            }
            if (string.equals("ConnectionFilter")) {
                return 10;
            }
            if (string.equals("ConnectionFilterRules")) {
                return 18;
            }
            if (string.equals("ConnectionLoggerEnabled")) {
                return 19;
            }
            if (string.equals("EncryptedSecretKey")) {
                return 15;
            }
            if (string.equals("LogAllChecksEnabled")) {
                return 12;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PasswordPolicy")) {
                return 13;
            }
            if (string.equals("Realm")) {
                return 7;
            }
            if (string.equals("Salt")) {
                return 14;
            }
            if (string.equals("ServerSecurityRuntime")) {
                return 16;
            }
            if (string.equals("SystemUser")) {
                return 11;
            }
            if (string.equals("CompatibilityMode")) {
                return 17;
            }
            if (string.equals("GuestDisabled")) {
                return 9;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAuditProviderClassNameSet()) {
                    stringBuffer.append("AuditProviderClassName");
                    stringBuffer.append(String.valueOf(this.bean.getAuditProviderClassName()));
                }
                if (this.bean.isConnectionFilterSet()) {
                    stringBuffer.append("ConnectionFilter");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionFilter()));
                }
                if (this.bean.isConnectionFilterRulesSet()) {
                    stringBuffer.append("ConnectionFilterRules");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getConnectionFilterRules())));
                }
                if (this.bean.isConnectionLoggerEnabledSet()) {
                    stringBuffer.append("ConnectionLoggerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionLoggerEnabled()));
                }
                if (this.bean.isEncryptedSecretKeySet()) {
                    stringBuffer.append("EncryptedSecretKey");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getEncryptedSecretKey())));
                }
                if (this.bean.isLogAllChecksEnabledSet()) {
                    stringBuffer.append("LogAllChecksEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getLogAllChecksEnabled()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPasswordPolicySet()) {
                    stringBuffer.append("PasswordPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getPasswordPolicy()));
                }
                if (this.bean.isRealmSet()) {
                    stringBuffer.append("Realm");
                    stringBuffer.append(String.valueOf(this.bean.getRealm()));
                }
                if (this.bean.isSaltSet()) {
                    stringBuffer.append("Salt");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getSalt())));
                }
                if (this.bean.isServerSecurityRuntimeSet()) {
                    stringBuffer.append("ServerSecurityRuntime");
                    stringBuffer.append(String.valueOf(this.bean.getServerSecurityRuntime()));
                }
                if (this.bean.isSystemUserSet()) {
                    stringBuffer.append("SystemUser");
                    stringBuffer.append(String.valueOf(this.bean.getSystemUser()));
                }
                if (this.bean.isCompatibilityModeSet()) {
                    stringBuffer.append("CompatibilityMode");
                    stringBuffer.append(String.valueOf(this.bean.isCompatibilityMode()));
                }
                if (this.bean.isGuestDisabledSet()) {
                    stringBuffer.append("GuestDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isGuestDisabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SecurityMBeanImpl securityMBeanImpl = (SecurityMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AuditProviderClassName", this.bean.getAuditProviderClassName(), securityMBeanImpl.getAuditProviderClassName(), false);
                this.computeDiff("LogAllChecksEnabled", this.bean.getLogAllChecksEnabled(), securityMBeanImpl.getLogAllChecksEnabled(), false);
                this.computeDiff("Name", this.bean.getName(), securityMBeanImpl.getName(), false);
                this.computeDiff("PasswordPolicy", this.bean.getPasswordPolicy(), securityMBeanImpl.getPasswordPolicy(), false);
                this.computeDiff("Realm", this.bean.getRealm(), securityMBeanImpl.getRealm(), false);
                this.computeDiff("SystemUser", this.bean.getSystemUser(), securityMBeanImpl.getSystemUser(), false);
                this.computeDiff("CompatibilityMode", this.bean.isCompatibilityMode(), securityMBeanImpl.isCompatibilityMode(), false);
                this.computeDiff("GuestDisabled", this.bean.isGuestDisabled(), securityMBeanImpl.isGuestDisabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SecurityMBeanImpl securityMBeanImpl = (SecurityMBeanImpl)beanUpdateEvent.getSourceBean();
                SecurityMBeanImpl securityMBeanImpl2 = (SecurityMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AuditProviderClassName")) {
                    securityMBeanImpl.setAuditProviderClassName(securityMBeanImpl2.getAuditProviderClassName());
                    securityMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (!(string.equals("ConnectionFilter") || string.equals("ConnectionFilterRules") || string.equals("ConnectionLoggerEnabled") || string.equals("EncryptedSecretKey"))) {
                    if (string.equals("LogAllChecksEnabled")) {
                        securityMBeanImpl.setLogAllChecksEnabled(securityMBeanImpl2.getLogAllChecksEnabled());
                        securityMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("Name")) {
                        securityMBeanImpl.setName(securityMBeanImpl2.getName());
                        securityMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("PasswordPolicy")) {
                        securityMBeanImpl.setPasswordPolicyAsString(securityMBeanImpl2.getPasswordPolicyAsString());
                        securityMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("Realm")) {
                        securityMBeanImpl.setRealmAsString(securityMBeanImpl2.getRealmAsString());
                        securityMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (!string.equals("Salt") && !string.equals("ServerSecurityRuntime")) {
                        if (string.equals("SystemUser")) {
                            securityMBeanImpl.setSystemUser(securityMBeanImpl2.getSystemUser());
                            securityMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                        } else if (string.equals("CompatibilityMode")) {
                            securityMBeanImpl.setCompatibilityMode(securityMBeanImpl2.isCompatibilityMode());
                            securityMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                        } else if (string.equals("GuestDisabled")) {
                            securityMBeanImpl.setGuestDisabled(securityMBeanImpl2.isGuestDisabled());
                            securityMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                        } else {
                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                SecurityMBeanImpl securityMBeanImpl = (SecurityMBeanImpl)abstractDescriptorBean;
                super.finishCopy(securityMBeanImpl, bl, list);
                if ((list == null || !list.contains("AuditProviderClassName")) && this.bean.isAuditProviderClassNameSet()) {
                    securityMBeanImpl.setAuditProviderClassName(this.bean.getAuditProviderClassName());
                }
                if ((list == null || !list.contains("LogAllChecksEnabled")) && this.bean.isLogAllChecksEnabledSet()) {
                    securityMBeanImpl.setLogAllChecksEnabled(this.bean.getLogAllChecksEnabled());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    securityMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PasswordPolicy")) && this.bean.isPasswordPolicySet()) {
                    securityMBeanImpl._unSet(securityMBeanImpl, 13);
                    securityMBeanImpl.setPasswordPolicyAsString(this.bean.getPasswordPolicyAsString());
                }
                if ((list == null || !list.contains("Realm")) && this.bean.isRealmSet()) {
                    securityMBeanImpl._unSet(securityMBeanImpl, 7);
                    securityMBeanImpl.setRealmAsString(this.bean.getRealmAsString());
                }
                if ((list == null || !list.contains("SystemUser")) && this.bean.isSystemUserSet()) {
                    securityMBeanImpl.setSystemUser(this.bean.getSystemUser());
                }
                if ((list == null || !list.contains("CompatibilityMode")) && this.bean.isCompatibilityModeSet()) {
                    securityMBeanImpl.setCompatibilityMode(this.bean.isCompatibilityMode());
                }
                if ((list == null || !list.contains("GuestDisabled")) && this.bean.isGuestDisabledSet()) {
                    securityMBeanImpl.setGuestDisabled(this.bean.isGuestDisabled());
                }
                return securityMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getPasswordPolicy(), clazz, object);
            this.inferSubTree(this.bean.getRealm(), clazz, object);
        }
    }
}

