/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import javax.management.InvalidAttributeValueException;
import weblogic.logging.Loggable;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.FederationServicesMBean;
import weblogic.management.configuration.LegalHelper;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingleSignOnServicesMBean;
import weblogic.security.SecurityLogger;
import weblogic.utils.Debug;

public final class ServerLegalHelper {
    public static final int DEFAULT_THREAD_POOL_SIZE = 15;
    public static final int PRODUCTION_MODE_THREAD_POOL_SIZE = 25;

    public static boolean isSSLListenPortEnabled(ServerMBean serverMBean) {
        if (Boolean.getBoolean("weblogic.mbeanLegalClause.ByPass")) {
            return true;
        }
        if (serverMBean.getSSL().isEnabled()) {
            return true;
        }
        Debug.assertion((serverMBean.getParent() != null ? 1 : 0) != 0);
        if (((DomainMBean)serverMBean.getParent()).isAdministrationPortEnabled()) {
            return true;
        }
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            if (!networkAccessPointMBeanArray[i].isEnabled()) continue;
            return true;
        }
        return false;
    }

    public static boolean isListenPortEnabled(SSLMBean sSLMBean) {
        if (Boolean.getBoolean("weblogic.mbeanLegalClause.ByPass")) {
            return true;
        }
        ServerMBean serverMBean = (ServerMBean)sSLMBean.getParent();
        Debug.assertion((serverMBean != null ? 1 : 0) != 0);
        if (serverMBean.isListenPortEnabled()) {
            return true;
        }
        return ServerLegalHelper.isSSLListenPortEnabled(serverMBean);
    }

    public static void validateSSL(SSLMBean sSLMBean) throws IllegalArgumentException {
        int n;
        ServerMBean serverMBean;
        if (!sSLMBean.isEnabled() && !ServerLegalHelper.isListenPortEnabled(sSLMBean)) {
            throw new IllegalArgumentException("Either ListenPort or SSLListenPort must be enabled");
        }
        if (sSLMBean.isEnabled() && (serverMBean = (ServerMBean)sSLMBean.getParent()) != null && (n = serverMBean.getListenPort()) == sSLMBean.getListenPort()) {
            Loggable loggable = SecurityLogger.logSSLListenPortSameAsServerListenPortLoggable((String)Integer.toString(n));
            loggable.log();
            throw new IllegalArgumentException(loggable.getMessage());
        }
    }

    public static void validateServer(ServerMBean serverMBean) throws IllegalArgumentException {
        if (!serverMBean.isListenPortEnabled() && !ServerLegalHelper.isSSLListenPortEnabled(serverMBean)) {
            throw new IllegalArgumentException("Either ListenPort or SSLListenPort must be enabled");
        }
        String string = serverMBean.getName();
        try {
            if (!LegalHelper.serverMBeanSetNameLegalCheck(string, serverMBean)) {
                throw new IllegalArgumentException("ServerName " + string + " is invalid");
            }
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new IllegalArgumentException(invalidAttributeValueException.getMessage());
        }
    }

    public static void checkListenAddress(ServerMBean serverMBean, Object object) throws InvalidAttributeValueException {
        if (object == null) {
            throw new InvalidAttributeValueException("null port");
        }
        if (!(object instanceof Integer)) {
            throw new InvalidAttributeValueException("port not integer:" + object);
        }
        int n = (Integer)object;
        if (serverMBean.getSSL().getListenPort() == n) {
            throw new InvalidAttributeValueException("Listen port cannot be the same as SSL port");
        }
    }

    public static void validateFederationServices(FederationServicesMBean federationServicesMBean) throws IllegalArgumentException {
    }

    public static void validateSingleSignOnServices(SingleSignOnServicesMBean singleSignOnServicesMBean) throws IllegalArgumentException {
    }
}

