/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.cluster.ClusterValidator;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.COMMBean;
import weblogic.management.configuration.COMMBeanImpl;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.CoherenceClusterSystemResourceMBean;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DataSourceMBean;
import weblogic.management.configuration.DataSourceMBeanImpl;
import weblogic.management.configuration.DefaultFileStoreMBean;
import weblogic.management.configuration.DefaultFileStoreMBeanImpl;
import weblogic.management.configuration.DomainLogFilterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ExecuteQueueMBeanImpl;
import weblogic.management.configuration.FederationServicesMBean;
import weblogic.management.configuration.FederationServicesMBeanImpl;
import weblogic.management.configuration.IIOPMBean;
import weblogic.management.configuration.IIOPMBeanImpl;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.JTAMigratableTargetMBeanImpl;
import weblogic.management.configuration.KernelDebugMBean;
import weblogic.management.configuration.KernelMBeanImpl;
import weblogic.management.configuration.LegalHelper;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.LogMBeanImpl;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.MachineMBeanImpl;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.NetworkAccessPointMBeanImpl;
import weblogic.management.configuration.OverloadProtectionMBean;
import weblogic.management.configuration.OverloadProtectionMBeanImpl;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.SSLMBeanImpl;
import weblogic.management.configuration.ServerDebugMBean;
import weblogic.management.configuration.ServerDebugMBeanImpl;
import weblogic.management.configuration.ServerLegalHelper;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerStartMBean;
import weblogic.management.configuration.ServerStartMBeanImpl;
import weblogic.management.configuration.SingleSignOnServicesMBean;
import weblogic.management.configuration.SingleSignOnServicesMBeanImpl;
import weblogic.management.configuration.TransactionLogJDBCStoreMBean;
import weblogic.management.configuration.TransactionLogJDBCStoreMBeanImpl;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBeanImpl;
import weblogic.management.configuration.WSReliableDeliveryPolicyMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.configuration.WebServerMBeanImpl;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.management.configuration.WebServiceMBeanImpl;
import weblogic.management.configuration.XMLEntityCacheMBean;
import weblogic.management.configuration.XMLRegistryMBean;
import weblogic.management.mbeans.custom.Server;
import weblogic.management.runtime.ClusterRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class ServerMBeanImpl
extends KernelMBeanImpl
implements ServerMBean,
Serializable {
    private String _81StyleDefaultStagingDirName;
    private int _AcceptBacklog;
    private String _ActiveDirectoryName;
    private int _AdminReconnectIntervalSeconds;
    private int _AdministrationPort;
    private boolean _AdministrationPortEnabled;
    private String _AutoJDBCConnectionClose;
    private boolean _AutoKillIfFailed;
    private boolean _AutoMigrationEnabled;
    private boolean _AutoRestart;
    private COMMBean _COM;
    private boolean _COMEnabled;
    private MachineMBean[] _CandidateMachines;
    private boolean _ClasspathServletDisabled;
    private boolean _ClientCertProxyEnabled;
    private ClusterMBean _Cluster;
    private ClusterRuntimeMBean _ClusterRuntime;
    private int _ClusterWeight;
    private CoherenceClusterSystemResourceMBean _CoherenceClusterSystemResource;
    private int _ConsensusProcessIdentifier;
    private boolean _ConsoleInputEnabled;
    private String _CustomIdentityKeyStoreFileName;
    private String _CustomIdentityKeyStorePassPhrase;
    private byte[] _CustomIdentityKeyStorePassPhraseEncrypted;
    private String _CustomIdentityKeyStoreType;
    private String _CustomTrustKeyStoreFileName;
    private String _CustomTrustKeyStorePassPhrase;
    private byte[] _CustomTrustKeyStorePassPhraseEncrypted;
    private String _CustomTrustKeyStoreType;
    private DataSourceMBean _DataSource;
    private DefaultFileStoreMBean _DefaultFileStore;
    private String _DefaultIIOPPassword;
    private byte[] _DefaultIIOPPasswordEncrypted;
    private String _DefaultIIOPUser;
    private boolean _DefaultInternalServletsDisabled;
    private String _DefaultStagingDirName;
    private String _DefaultTGIOPPassword;
    private byte[] _DefaultTGIOPPasswordEncrypted;
    private String _DefaultTGIOPUser;
    private DomainLogFilterMBean _DomainLogFilter;
    private boolean _EnabledForDomainLog;
    private boolean _ExpectedToRun;
    private String _ExternalDNSName;
    private String _ExtraEjbcOptions;
    private String _ExtraRmicOptions;
    private FederationServicesMBean _FederationServices;
    private int _GracefulShutdownTimeout;
    private int _HealthCheckIntervalSeconds;
    private int _HealthCheckStartDelaySeconds;
    private int _HealthCheckTimeoutSeconds;
    private boolean _HostsMigratableServices;
    private boolean _HttpTraceSupportEnabled;
    private boolean _HttpdEnabled;
    private Map _IIOPConnectionPools;
    private boolean _IIOPEnabled;
    private boolean _IgnoreSessionsDuringShutdown;
    private String _InterfaceAddress;
    private boolean _J2EE12OnlyModeEnabled;
    private boolean _J2EE13WarningEnabled;
    private String _JDBCLLRTableName;
    private int _JDBCLLRTablePoolColumnSize;
    private int _JDBCLLRTableRecordColumnSize;
    private int _JDBCLLRTableXIDColumnSize;
    private String _JDBCLogFileName;
    private boolean _JDBCLoggingEnabled;
    private int _JDBCLoginTimeoutSeconds;
    private boolean _JMSDefaultConnectionFactoriesEnabled;
    private String[] _JNDITransportableObjectFactoryList;
    private boolean _JRMPEnabled;
    private JTAMigratableTargetMBean _JTAMigratableTarget;
    private String _JavaCompiler;
    private String _JavaCompilerPostClassPath;
    private String _JavaCompilerPreClassPath;
    private String _JavaStandardTrustKeyStorePassPhrase;
    private byte[] _JavaStandardTrustKeyStorePassPhraseEncrypted;
    private KernelDebugMBean _KernelDebug;
    private String _KeyStores;
    private String _ListenAddress;
    private int _ListenDelaySecs;
    private int _ListenPort;
    private boolean _ListenPortEnabled;
    private int _ListenThreadStartDelaySecs;
    private boolean _ListenersBindEarly;
    private int _LoginTimeout;
    private int _LoginTimeoutMillis;
    private int _LowMemoryGCThreshold;
    private int _LowMemoryGranularityLevel;
    private int _LowMemorySampleSize;
    private int _LowMemoryTimeInterval;
    private boolean _MSIFileReplicationEnabled;
    private MachineMBean _Machine;
    private boolean _ManagedServerIndependenceEnabled;
    private int _MaxBackoffBetweenFailures;
    private boolean _MessageIdPrefixEnabled;
    private int _NMSocketCreateTimeoutInMillis;
    private String _Name;
    private NetworkAccessPointMBean[] _NetworkAccessPoints;
    private boolean _NetworkClassLoadingEnabled;
    private OverloadProtectionMBean _OverloadProtection;
    private String _PreferredSecondaryGroup;
    private WSReliableDeliveryPolicyMBean _ReliableDeliveryPolicy;
    private String _ReplicationGroup;
    private String _ReplicationPorts;
    private int _RestartDelaySeconds;
    private int _RestartIntervalSeconds;
    private int _RestartMax;
    private String _RootDirectory;
    private ServerDebugMBean _ServerDebug;
    private WLDFServerDiagnosticMBean _ServerDiagnosticConfig;
    private int _ServerLifeCycleTimeoutVal;
    private Set _ServerNames;
    private ServerStartMBean _ServerStart;
    private String _ServerVersion;
    private SingleSignOnServicesMBean _SingleSignOnServices;
    private String _StagingDirectoryName;
    private String _StagingMode;
    private String _StartupMode;
    private int _StartupTimeout;
    private boolean _StdoutDebugEnabled;
    private boolean _StdoutEnabled;
    private String _StdoutFormat;
    private boolean _StdoutLogStack;
    private int _StdoutSeverityLevel;
    private String[] _SupportedProtocols;
    private String _SystemPassword;
    private byte[] _SystemPasswordEncrypted;
    private boolean _TGIOPEnabled;
    private int _ThreadPoolSize;
    private String _TransactionLogFilePrefix;
    private String _TransactionLogFileWritePolicy;
    private TransactionLogJDBCStoreMBean _TransactionLogJDBCStore;
    private int _TunnelingClientPingSecs;
    private int _TunnelingClientTimeoutSecs;
    private boolean _TunnelingEnabled;
    private String _UploadDirectoryName;
    private boolean _UseFusionForLLR;
    private String _VerboseEJBDeploymentEnabled;
    private String _VirtualMachineName;
    private WebServerMBean _WebServer;
    private WebServiceMBean _WebService;
    private boolean _WeblogicPluginEnabled;
    private XMLEntityCacheMBean _XMLEntityCache;
    private XMLRegistryMBean _XMLRegistry;
    private Server _customizer;
    private static SchemaHelper2 _schemaHelper;

    public ServerMBeanImpl() {
        try {
            this._customizer = new Server(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ServerMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new Server(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        return this._customizer.getName();
    }

    public String getRootDirectory() {
        return this._customizer.getRootDirectory();
    }

    public Set getServerNames() {
        return this._customizer.getServerNames();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isRootDirectorySet() {
        return this._isSet(78);
    }

    public boolean isServerNamesSet() {
        return this._isSet(77);
    }

    public void setServerNames(Set set) throws InvalidAttributeValueException {
        this._ServerNames = set;
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setRootDirectory(String string) throws InvalidAttributeValueException {
        this._RootDirectory = string = string == null ? null : string.trim();
    }

    public MachineMBean getMachine() {
        return this._Machine;
    }

    public String getMachineAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getMachine();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isMachineSet() {
        return this._isSet(79);
    }

    public void setMachineAsString(String string) {
        if (string == null || string.length() == 0) {
            MachineMBean machineMBean = this._Machine;
            this._initializeProperty(79);
            this._postSet(79, machineMBean, this._Machine);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, MachineMBean.class, new ReferenceManager.Resolver(this, 79){

                public void resolveReference(Object object) {
                    try {
                        ServerMBeanImpl.this.setMachine((MachineMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setMachine(MachineMBean machineMBean) throws InvalidAttributeValueException {
        MachineMBean machineMBean2;
        if (machineMBean != null) {
            machineMBean2 = new ResolvedReference(this, 79, (AbstractDescriptorBean)machineMBean){

                protected Object getPropertyValue() {
                    return ServerMBeanImpl.this.getMachine();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)machineMBean, (ResolvedReference)machineMBean2);
        }
        machineMBean2 = this._Machine;
        this._Machine = machineMBean;
        this._postSet(79, machineMBean2, machineMBean);
    }

    public int getListenPort() {
        return this._ListenPort;
    }

    public boolean isListenPortSet() {
        return this._isSet(80);
    }

    public void setListenPort(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ListenPort", (long)n, (long)1L, (long)65535L);
        int n2 = this._ListenPort;
        this._ListenPort = n;
        this._postSet(80, n2, n);
    }

    public boolean isListenPortEnabled() {
        return this._ListenPortEnabled;
    }

    public boolean isListenPortEnabledSet() {
        return this._isSet(81);
    }

    public void setListenPortEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ListenPortEnabled;
        this._ListenPortEnabled = bl;
        this._postSet(81, bl2, bl);
    }

    public int getLoginTimeout() {
        return this._LoginTimeout;
    }

    public boolean isLoginTimeoutSet() {
        return this._isSet(82);
    }

    public int getThreadPoolSize() {
        return this._customizer.getThreadPoolSize();
    }

    public boolean isThreadPoolSizeSet() {
        return this._isSet(12);
    }

    public void setLoginTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        int n2 = this._LoginTimeout;
        this._LoginTimeout = n;
        this._postSet(82, n2, n);
    }

    public ClusterMBean getCluster() {
        return this._customizer.getCluster();
    }

    public String getClusterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getCluster();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isClusterSet() {
        return this._isSet(83);
    }

    public void setClusterAsString(String string) {
        if (string == null || string.length() == 0) {
            ClusterMBean clusterMBean = this._Cluster;
            this._initializeProperty(83);
            this._postSet(83, clusterMBean, this._Cluster);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ClusterMBean.class, new ReferenceManager.Resolver(this, 83){

                public void resolveReference(Object object) {
                    try {
                        ServerMBeanImpl.this.setCluster((ClusterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setThreadPoolSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"ThreadPoolSize", (long)n, (long)0L, (long)65534L);
        int n2 = this.getThreadPoolSize();
        this._customizer.setThreadPoolSize(n);
        this._postSet(12, n2, n);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setCluster(ClusterMBean clusterMBean) throws InvalidAttributeValueException {
        ClusterMBean clusterMBean2;
        if (clusterMBean != null) {
            clusterMBean2 = new ResolvedReference(this, 83, (AbstractDescriptorBean)clusterMBean){

                protected Object getPropertyValue() {
                    return ServerMBeanImpl.this.getCluster();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)clusterMBean, (ResolvedReference)clusterMBean2);
        }
        clusterMBean2 = this.getCluster();
        this._customizer.setCluster(clusterMBean);
        this._postSet(83, clusterMBean2, clusterMBean);
    }

    public int getClusterWeight() {
        return this._ClusterWeight;
    }

    public boolean isClusterWeightSet() {
        return this._isSet(84);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setClusterWeight(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ClusterWeight", (long)n, (long)1L, (long)100L);
        int n2 = this._ClusterWeight;
        this._ClusterWeight = n;
        this._postSet(84, n2, n);
    }

    public String getReplicationGroup() {
        return this._ReplicationGroup;
    }

    public boolean isReplicationGroupSet() {
        return this._isSet(85);
    }

    public void setReplicationGroup(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ReplicationGroup;
        this._ReplicationGroup = string;
        this._postSet(85, string2, string);
    }

    public String getPreferredSecondaryGroup() {
        return this._PreferredSecondaryGroup;
    }

    public boolean isPreferredSecondaryGroupSet() {
        return this._isSet(86);
    }

    public void setPreferredSecondaryGroup(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._PreferredSecondaryGroup;
        this._PreferredSecondaryGroup = string;
        this._postSet(86, string2, string);
    }

    public int getConsensusProcessIdentifier() {
        return this._ConsensusProcessIdentifier;
    }

    public boolean isConsensusProcessIdentifierSet() {
        return this._isSet(87);
    }

    public void setConsensusProcessIdentifier(int n) {
        LegalChecks.checkInRange((String)"ConsensusProcessIdentifier", (long)n, (long)-1L, (long)65535L);
        int n2 = this._ConsensusProcessIdentifier;
        this._ConsensusProcessIdentifier = n;
        this._postSet(87, n2, n);
    }

    public boolean isAutoMigrationEnabled() {
        return this._AutoMigrationEnabled;
    }

    public boolean isAutoMigrationEnabledSet() {
        return this._isSet(88);
    }

    public void setAutoMigrationEnabled(boolean bl) {
        ClusterValidator.validateAutoMigration(bl);
        boolean bl2 = this._AutoMigrationEnabled;
        this._AutoMigrationEnabled = bl;
        this._postSet(88, bl2, bl);
    }

    public ClusterRuntimeMBean getClusterRuntime() {
        return this._ClusterRuntime;
    }

    public boolean isClusterRuntimeSet() {
        return this._isSet(89);
    }

    public void setClusterRuntime(ClusterRuntimeMBean clusterRuntimeMBean) {
        this._ClusterRuntime = clusterRuntimeMBean;
    }

    public WebServerMBean getWebServer() {
        return this._WebServer;
    }

    public boolean isWebServerSet() {
        return this._isSet(90) || this._isAnythingSet((AbstractDescriptorBean)this.getWebServer());
    }

    public void setWebServer(WebServerMBean webServerMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)webServerMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 90)) {
            this._postCreate(abstractDescriptorBean);
        }
        WebServerMBean webServerMBean2 = this._WebServer;
        this._WebServer = webServerMBean;
        this._postSet(90, webServerMBean2, webServerMBean);
    }

    public boolean getExpectedToRun() {
        return this._ExpectedToRun;
    }

    public boolean isExpectedToRunSet() {
        return this._isSet(91);
    }

    public void setExpectedToRun(boolean bl) {
        this._ExpectedToRun = bl;
    }

    public String synchronousStart() {
        return this._customizer.synchronousStart();
    }

    public String synchronousKill() {
        return this._customizer.synchronousKill();
    }

    public boolean isJDBCLoggingEnabled() {
        return this._JDBCLoggingEnabled;
    }

    public boolean isJDBCLoggingEnabledSet() {
        return this._isSet(92);
    }

    public void setJDBCLoggingEnabled(boolean bl) {
        boolean bl2 = this._JDBCLoggingEnabled;
        this._JDBCLoggingEnabled = bl;
        this._postSet(92, bl2, bl);
    }

    public String getJDBCLogFileName() {
        return this._JDBCLogFileName;
    }

    public boolean isJDBCLogFileNameSet() {
        return this._isSet(93);
    }

    public void setJDBCLogFileName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JDBCLogFileName;
        this._JDBCLogFileName = string;
        this._postSet(93, string2, string);
    }

    public boolean isJ2EE12OnlyModeEnabled() {
        return this._J2EE12OnlyModeEnabled;
    }

    public boolean isJ2EE12OnlyModeEnabledSet() {
        return this._isSet(94);
    }

    public void setJ2EE12OnlyModeEnabled(boolean bl) {
        boolean bl2 = this._J2EE12OnlyModeEnabled;
        this._J2EE12OnlyModeEnabled = bl;
        this._postSet(94, bl2, bl);
    }

    public boolean isJ2EE13WarningEnabled() {
        return this._J2EE13WarningEnabled;
    }

    public boolean isJ2EE13WarningEnabledSet() {
        return this._isSet(95);
    }

    public void setJ2EE13WarningEnabled(boolean bl) {
        boolean bl2 = this._J2EE13WarningEnabled;
        this._J2EE13WarningEnabled = bl;
        this._postSet(95, bl2, bl);
    }

    public boolean isIIOPEnabled() {
        return this._IIOPEnabled;
    }

    public boolean isIIOPEnabledSet() {
        return this._isSet(96);
    }

    public void setIIOPEnabled(boolean bl) {
        boolean bl2 = this._IIOPEnabled;
        this._IIOPEnabled = bl;
        this._postSet(96, bl2, bl);
    }

    public String getDefaultIIOPUser() {
        return this._DefaultIIOPUser;
    }

    public boolean isDefaultIIOPUserSet() {
        return this._isSet(97);
    }

    public void setDefaultIIOPUser(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._DefaultIIOPUser;
        this._DefaultIIOPUser = string;
        this._postSet(97, string2, string);
    }

    public String getDefaultIIOPPassword() {
        byte[] byArray = this.getDefaultIIOPPasswordEncrypted();
        return byArray == null ? null : this._decrypt("DefaultIIOPPassword", byArray);
    }

    public boolean isDefaultIIOPPasswordSet() {
        return this.isDefaultIIOPPasswordEncryptedSet();
    }

    public void setDefaultIIOPPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setDefaultIIOPPasswordEncrypted(string == null ? null : this._encrypt("DefaultIIOPPassword", string));
    }

    public byte[] getDefaultIIOPPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._DefaultIIOPPasswordEncrypted);
    }

    public String getDefaultIIOPPasswordEncryptedAsString() {
        byte[] byArray = this.getDefaultIIOPPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isDefaultIIOPPasswordEncryptedSet() {
        return this._isSet(99);
    }

    public void setDefaultIIOPPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setDefaultIIOPPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isTGIOPEnabled() {
        return this._TGIOPEnabled;
    }

    public boolean isTGIOPEnabledSet() {
        return this._isSet(100);
    }

    public void setTGIOPEnabled(boolean bl) {
        boolean bl2 = this._TGIOPEnabled;
        this._TGIOPEnabled = bl;
        this._postSet(100, bl2, bl);
    }

    public String getDefaultTGIOPUser() {
        return this._DefaultTGIOPUser;
    }

    public boolean isDefaultTGIOPUserSet() {
        return this._isSet(101);
    }

    public void setDefaultTGIOPUser(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._DefaultTGIOPUser;
        this._DefaultTGIOPUser = string;
        this._postSet(101, string2, string);
    }

    public String getDefaultTGIOPPassword() {
        byte[] byArray = this.getDefaultTGIOPPasswordEncrypted();
        return byArray == null ? null : this._decrypt("DefaultTGIOPPassword", byArray);
    }

    public boolean isDefaultTGIOPPasswordSet() {
        return this.isDefaultTGIOPPasswordEncryptedSet();
    }

    public void setDefaultTGIOPPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setDefaultTGIOPPasswordEncrypted(string == null ? null : this._encrypt("DefaultTGIOPPassword", string));
    }

    public byte[] getDefaultTGIOPPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._DefaultTGIOPPasswordEncrypted);
    }

    public String getDefaultTGIOPPasswordEncryptedAsString() {
        byte[] byArray = this.getDefaultTGIOPPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isDefaultTGIOPPasswordEncryptedSet() {
        return this._isSet(103);
    }

    public void setDefaultTGIOPPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setDefaultTGIOPPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isCOMEnabled() {
        return this._COMEnabled;
    }

    public boolean isCOMEnabledSet() {
        return this._isSet(104);
    }

    public void setCOMEnabled(boolean bl) {
        boolean bl2 = this._COMEnabled;
        this._COMEnabled = bl;
        this._postSet(104, bl2, bl);
    }

    public boolean isJRMPEnabled() {
        return this._JRMPEnabled;
    }

    public boolean isJRMPEnabledSet() {
        return this._isSet(105);
    }

    public void setJRMPEnabled(boolean bl) {
        boolean bl2 = this._JRMPEnabled;
        this._JRMPEnabled = bl;
        this._postSet(105, bl2, bl);
    }

    public COMMBean getCOM() {
        return this._COM;
    }

    public boolean isCOMSet() {
        return this._isSet(106) || this._isAnythingSet((AbstractDescriptorBean)this.getCOM());
    }

    public void setCOM(COMMBean cOMMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)cOMMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 106)) {
            this._postCreate(abstractDescriptorBean);
        }
        COMMBean cOMMBean2 = this._COM;
        this._COM = cOMMBean;
        this._postSet(106, cOMMBean2, cOMMBean);
    }

    public ServerDebugMBean getServerDebug() {
        return this._ServerDebug;
    }

    public boolean isServerDebugSet() {
        return this._isSet(107) || this._isAnythingSet((AbstractDescriptorBean)this.getServerDebug());
    }

    public void setServerDebug(ServerDebugMBean serverDebugMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)serverDebugMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 107)) {
            this._postCreate(abstractDescriptorBean);
        }
        ServerDebugMBean serverDebugMBean2 = this._ServerDebug;
        this._ServerDebug = serverDebugMBean;
        this._postSet(107, serverDebugMBean2, serverDebugMBean);
    }

    public boolean isHttpdEnabled() {
        return this._HttpdEnabled;
    }

    public boolean isHttpdEnabledSet() {
        return this._isSet(108);
    }

    public void setHttpdEnabled(boolean bl) {
        boolean bl2 = this._HttpdEnabled;
        this._HttpdEnabled = bl;
        this._postSet(108, bl2, bl);
    }

    public String getSystemPassword() {
        byte[] byArray = this.getSystemPasswordEncrypted();
        return byArray == null ? null : this._decrypt("SystemPassword", byArray);
    }

    public boolean isSystemPasswordSet() {
        return this.isSystemPasswordEncryptedSet();
    }

    public void setSystemPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setSystemPasswordEncrypted(string == null ? null : this._encrypt("SystemPassword", string));
    }

    public byte[] getSystemPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._SystemPasswordEncrypted);
    }

    public String getSystemPasswordEncryptedAsString() {
        byte[] byArray = this.getSystemPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isSystemPasswordEncryptedSet() {
        return this._isSet(110);
    }

    public void setSystemPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setSystemPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isConsoleInputEnabled() {
        return this._ConsoleInputEnabled;
    }

    public boolean isConsoleInputEnabledSet() {
        return this._isSet(111);
    }

    public void setConsoleInputEnabled(boolean bl) {
        boolean bl2 = this._ConsoleInputEnabled;
        this._ConsoleInputEnabled = bl;
        this._postSet(111, bl2, bl);
    }

    public int getListenThreadStartDelaySecs() {
        return this._ListenThreadStartDelaySecs;
    }

    public boolean isListenThreadStartDelaySecsSet() {
        return this._isSet(112);
    }

    public void setListenThreadStartDelaySecs(int n) throws InvalidAttributeValueException {
        int n2 = this._ListenThreadStartDelaySecs;
        this._ListenThreadStartDelaySecs = n;
        this._postSet(112, n2, n);
    }

    public boolean getListenersBindEarly() {
        return this._ListenersBindEarly;
    }

    public boolean isListenersBindEarlySet() {
        return this._isSet(113);
    }

    public void setListenersBindEarly(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ListenersBindEarly;
        this._ListenersBindEarly = bl;
        this._postSet(113, bl2, bl);
    }

    public String getListenAddress() {
        return this._ListenAddress;
    }

    public boolean isListenAddressSet() {
        return this._isSet(114);
    }

    public void setListenAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ListenAddress;
        this._ListenAddress = string;
        this._postSet(114, string2, string);
    }

    public String getExternalDNSName() {
        return this._ExternalDNSName;
    }

    public boolean isExternalDNSNameSet() {
        return this._isSet(115);
    }

    public void setExternalDNSName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ExternalDNSName;
        this._ExternalDNSName = string;
        this._postSet(115, string2, string);
    }

    public String getInterfaceAddress() {
        return this._InterfaceAddress;
    }

    public boolean isInterfaceAddressSet() {
        return this._isSet(116);
    }

    public void setInterfaceAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._InterfaceAddress;
        this._InterfaceAddress = string;
        this._postSet(116, string2, string);
    }

    public NetworkAccessPointMBean[] getNetworkAccessPoints() {
        return this._NetworkAccessPoints;
    }

    public boolean isNetworkAccessPointsSet() {
        return this._isSet(117);
    }

    public NetworkAccessPointMBean lookupNetworkAccessPoint(String string) {
        for (NetworkAccessPointMBeanImpl networkAccessPointMBeanImpl : Arrays.asList((Object[])this._NetworkAccessPoints)) {
            String string2 = string;
            if (!networkAccessPointMBeanImpl.getName().equals(string2)) continue;
            return networkAccessPointMBeanImpl;
        }
        return null;
    }

    public NetworkAccessPointMBean createNetworkAccessPoint(String string) {
        NetworkAccessPointMBeanImpl networkAccessPointMBeanImpl = new NetworkAccessPointMBeanImpl(this, -1);
        try {
            networkAccessPointMBeanImpl.setName(string);
            this.addNetworkAccessPoint(networkAccessPointMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return networkAccessPointMBeanImpl;
    }

    public void destroyNetworkAccessPoint(NetworkAccessPointMBean networkAccessPointMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(networkAccessPointMBean, 117);
                NetworkAccessPointMBean[] networkAccessPointMBeanArray = this.getNetworkAccessPoints();
                NetworkAccessPointMBean[] networkAccessPointMBeanArray2 = (NetworkAccessPointMBean[])this._getHelper()._removeElement((Object)networkAccessPointMBeanArray, NetworkAccessPointMBean.class, (Object)networkAccessPointMBean);
                if (networkAccessPointMBeanArray.length == networkAccessPointMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)networkAccessPointMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)networkAccessPointMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setNetworkAccessPoints(networkAccessPointMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public KernelDebugMBean getKernelDebug() {
        return this._customizer.getKernelDebug();
    }

    public boolean isKernelDebugSet() {
        return this._isSet(48);
    }

    public void setKernelDebug(KernelDebugMBean kernelDebugMBean) throws InvalidAttributeValueException {
        this._KernelDebug = kernelDebugMBean;
    }

    public void setNetworkAccessPoints(NetworkAccessPointMBean[] networkAccessPointMBeanArray) throws InvalidAttributeValueException, ConfigurationException {
        networkAccessPointMBeanArray = networkAccessPointMBeanArray == null ? new NetworkAccessPointMBeanImpl[]{} : networkAccessPointMBeanArray;
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)networkAccessPointMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 117)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        NetworkAccessPointMBean[] networkAccessPointMBeanArray2 = this._NetworkAccessPoints;
        this._NetworkAccessPoints = networkAccessPointMBeanArray;
        this._postSet(117, networkAccessPointMBeanArray2, networkAccessPointMBeanArray);
    }

    public boolean addNetworkAccessPoint(NetworkAccessPointMBean networkAccessPointMBean) throws InvalidAttributeValueException, ConfigurationException {
        this._getHelper()._ensureNonNull((Object)networkAccessPointMBean);
        if (!((AbstractDescriptorBean)networkAccessPointMBean).isChildProperty((DescriptorBean)this, 117)) {
            NetworkAccessPointMBean[] networkAccessPointMBeanArray = this._isSet(117) ? (NetworkAccessPointMBean[])this._getHelper()._extendArray((Object)this.getNetworkAccessPoints(), NetworkAccessPointMBean.class, (Object)networkAccessPointMBean) : new NetworkAccessPointMBean[]{networkAccessPointMBean};
            try {
                this.setNetworkAccessPoints(networkAccessPointMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeNetworkAccessPoint(NetworkAccessPointMBean networkAccessPointMBean) throws InvalidAttributeValueException, ConfigurationException {
        this.destroyNetworkAccessPoint(networkAccessPointMBean);
        return true;
    }

    public int getAcceptBacklog() {
        return this._AcceptBacklog;
    }

    public boolean isAcceptBacklogSet() {
        return this._isSet(118);
    }

    public void setAcceptBacklog(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"AcceptBacklog", (int)n, (int)0);
        int n2 = this._AcceptBacklog;
        this._AcceptBacklog = n;
        this._postSet(118, n2, n);
    }

    public int getMaxBackoffBetweenFailures() {
        return this._MaxBackoffBetweenFailures;
    }

    public boolean isMaxBackoffBetweenFailuresSet() {
        return this._isSet(119);
    }

    public boolean isStdoutEnabled() {
        return this._customizer.isStdoutEnabled();
    }

    public boolean isStdoutEnabledSet() {
        return this._isSet(53);
    }

    public void setMaxBackoffBetweenFailures(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"MaxBackoffBetweenFailures", (int)n, (int)0);
        int n2 = this._MaxBackoffBetweenFailures;
        this._MaxBackoffBetweenFailures = n;
        this._postSet(119, n2, n);
    }

    public int getLoginTimeoutMillis() {
        return this._LoginTimeoutMillis;
    }

    public boolean isLoginTimeoutMillisSet() {
        return this._isSet(120);
    }

    public void setStdoutEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this.isStdoutEnabled();
        this._customizer.setStdoutEnabled(bl);
        this._postSet(53, bl2, bl);
    }

    public int getStdoutSeverityLevel() {
        return this._customizer.getStdoutSeverityLevel();
    }

    public boolean isStdoutSeverityLevelSet() {
        return this._isSet(54);
    }

    public void setLoginTimeoutMillis(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LoginTimeoutMillis", (long)n, (long)0L, (long)100000L);
        int n2 = this._LoginTimeoutMillis;
        this._LoginTimeoutMillis = n;
        this._postSet(120, n2, n);
    }

    public boolean isAdministrationPortEnabled() {
        if (!this._isSet(121)) {
            try {
                return ((DomainMBean)this.getParent()).isAdministrationPortEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._AdministrationPortEnabled;
    }

    public boolean isAdministrationPortEnabledSet() {
        return this._isSet(121);
    }

    public void setStdoutSeverityLevel(int n) throws InvalidAttributeValueException, DistributedManagementException {
        int[] nArray = new int[]{256, 128, 64, 16, 8, 32, 4, 2, 1, 0};
        n = LegalChecks.checkInEnum((String)"StdoutSeverityLevel", (int)n, (int[])nArray);
        int n2 = this.getStdoutSeverityLevel();
        this._customizer.setStdoutSeverityLevel(n);
        this._postSet(54, n2, n);
    }

    public boolean isStdoutDebugEnabled() {
        return this._customizer.isStdoutDebugEnabled();
    }

    public boolean isStdoutDebugEnabledSet() {
        return this._isSet(55);
    }

    public void setAdministrationPortEnabled(boolean bl) {
        boolean bl2 = this._AdministrationPortEnabled;
        this._AdministrationPortEnabled = bl;
        this._postSet(121, bl2, bl);
    }

    public int getAdministrationPort() {
        if (!this._isSet(122)) {
            try {
                return ((DomainMBean)this.getParent()).getAdministrationPort();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getAdministrationPort();
    }

    public boolean isAdministrationPortSet() {
        return this._isSet(122);
    }

    public void setStdoutDebugEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this.isStdoutDebugEnabled();
        this._customizer.setStdoutDebugEnabled(bl);
        this._postSet(55, bl2, bl);
    }

    public void setAdministrationPort(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"AdministrationPort", (long)n, (long)0L, (long)65535L);
        int n2 = this.getAdministrationPort();
        this._customizer.setAdministrationPort(n);
        this._postSet(122, n2, n);
    }

    public String[] getJNDITransportableObjectFactoryList() {
        return this._JNDITransportableObjectFactoryList;
    }

    public boolean isJNDITransportableObjectFactoryListSet() {
        return this._isSet(123);
    }

    public void setJNDITransportableObjectFactoryList(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._JNDITransportableObjectFactoryList;
        this._JNDITransportableObjectFactoryList = stringArray;
        this._postSet(123, stringArray2, stringArray);
    }

    public Map getIIOPConnectionPools() {
        return this._IIOPConnectionPools;
    }

    public String getIIOPConnectionPoolsAsString() {
        return StringHelper.objectToString((Object)this.getIIOPConnectionPools());
    }

    public boolean isIIOPConnectionPoolsSet() {
        return this._isSet(124);
    }

    public void setIIOPConnectionPoolsAsString(String string) {
        try {
            this.setIIOPConnectionPools(StringHelper.stringToMap((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setIIOPConnectionPools(Map map) throws InvalidAttributeValueException {
        Map map2 = this._IIOPConnectionPools;
        this._IIOPConnectionPools = map;
        this._postSet(124, map2, map);
    }

    public XMLRegistryMBean getXMLRegistry() {
        return this._XMLRegistry;
    }

    public String getXMLRegistryAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getXMLRegistry();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isXMLRegistrySet() {
        return this._isSet(125);
    }

    public void setXMLRegistryAsString(String string) {
        if (string == null || string.length() == 0) {
            XMLRegistryMBean xMLRegistryMBean = this._XMLRegistry;
            this._initializeProperty(125);
            this._postSet(125, xMLRegistryMBean, this._XMLRegistry);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, XMLRegistryMBean.class, new ReferenceManager.Resolver(this, 125){

                public void resolveReference(Object object) {
                    try {
                        ServerMBeanImpl.this.setXMLRegistry((XMLRegistryMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setXMLEntityCache(XMLEntityCacheMBean xMLEntityCacheMBean) throws InvalidAttributeValueException {
        XMLEntityCacheMBean xMLEntityCacheMBean2;
        if (xMLEntityCacheMBean != null) {
            xMLEntityCacheMBean2 = new ResolvedReference(this, 126, (AbstractDescriptorBean)xMLEntityCacheMBean){

                protected Object getPropertyValue() {
                    return ServerMBeanImpl.this.getXMLEntityCache();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)xMLEntityCacheMBean, (ResolvedReference)xMLEntityCacheMBean2);
        }
        xMLEntityCacheMBean2 = this._XMLEntityCache;
        this._XMLEntityCache = xMLEntityCacheMBean;
        this._postSet(126, xMLEntityCacheMBean2, xMLEntityCacheMBean);
    }

    public String getStdoutFormat() {
        return this._customizer.getStdoutFormat();
    }

    public XMLEntityCacheMBean getXMLEntityCache() {
        return this._XMLEntityCache;
    }

    public String getXMLEntityCacheAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getXMLEntityCache();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isStdoutFormatSet() {
        return this._isSet(60);
    }

    public boolean isXMLEntityCacheSet() {
        return this._isSet(126);
    }

    public void setXMLEntityCacheAsString(String string) {
        if (string == null || string.length() == 0) {
            XMLEntityCacheMBean xMLEntityCacheMBean = this._XMLEntityCache;
            this._initializeProperty(126);
            this._postSet(126, xMLEntityCacheMBean, this._XMLEntityCache);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, XMLEntityCacheMBean.class, new ReferenceManager.Resolver(this, 126){

                public void resolveReference(Object object) {
                    try {
                        ServerMBeanImpl.this.setXMLEntityCache((XMLEntityCacheMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setStdoutFormat(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"standard", "noid"};
        string = LegalChecks.checkInEnum((String)"StdoutFormat", (String)string, (String[])stringArray);
        String string2 = this.getStdoutFormat();
        this._customizer.setStdoutFormat(string);
        this._postSet(60, string2, string);
    }

    public void setXMLRegistry(XMLRegistryMBean xMLRegistryMBean) throws InvalidAttributeValueException {
        XMLRegistryMBean xMLRegistryMBean2;
        if (xMLRegistryMBean != null) {
            xMLRegistryMBean2 = new ResolvedReference(this, 125, (AbstractDescriptorBean)xMLRegistryMBean){

                protected Object getPropertyValue() {
                    return ServerMBeanImpl.this.getXMLRegistry();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)xMLRegistryMBean, (ResolvedReference)xMLRegistryMBean2);
        }
        xMLRegistryMBean2 = this._XMLRegistry;
        this._XMLRegistry = xMLRegistryMBean;
        this._postSet(125, xMLRegistryMBean2, xMLRegistryMBean);
    }

    public String getJavaCompiler() {
        return this._JavaCompiler;
    }

    public boolean isJavaCompilerSet() {
        return this._isSet(127);
    }

    public boolean isStdoutLogStack() {
        return this._customizer.isStdoutLogStack();
    }

    public boolean isStdoutLogStackSet() {
        return this._isSet(61);
    }

    public void setJavaCompiler(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JavaCompiler;
        this._JavaCompiler = string;
        this._postSet(127, string2, string);
    }

    public void setStdoutLogStack(boolean bl) {
        boolean bl2 = this.isStdoutLogStack();
        this._customizer.setStdoutLogStack(bl);
        this._postSet(61, bl2, bl);
    }

    public String getJavaCompilerPreClassPath() {
        return this._JavaCompilerPreClassPath;
    }

    public boolean isJavaCompilerPreClassPathSet() {
        return this._isSet(128);
    }

    public void setJavaCompilerPreClassPath(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JavaCompilerPreClassPath;
        this._JavaCompilerPreClassPath = string;
        this._postSet(128, string2, string);
    }

    public String getJavaCompilerPostClassPath() {
        return this._JavaCompilerPostClassPath;
    }

    public boolean isJavaCompilerPostClassPathSet() {
        return this._isSet(129);
    }

    public void setJavaCompilerPostClassPath(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JavaCompilerPostClassPath;
        this._JavaCompilerPostClassPath = string;
        this._postSet(129, string2, string);
    }

    public String getExtraRmicOptions() {
        return this._ExtraRmicOptions;
    }

    public boolean isExtraRmicOptionsSet() {
        return this._isSet(130);
    }

    public void setExtraRmicOptions(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ExtraRmicOptions;
        this._ExtraRmicOptions = string;
        this._postSet(130, string2, string);
    }

    public String getExtraEjbcOptions() {
        return this._ExtraEjbcOptions;
    }

    public boolean isExtraEjbcOptionsSet() {
        return this._isSet(131);
    }

    public void setExtraEjbcOptions(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ExtraEjbcOptions;
        this._ExtraEjbcOptions = string;
        this._postSet(131, string2, string);
    }

    public String getVerboseEJBDeploymentEnabled() {
        return this._VerboseEJBDeploymentEnabled;
    }

    public boolean isVerboseEJBDeploymentEnabledSet() {
        return this._isSet(132);
    }

    public void setVerboseEJBDeploymentEnabled(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._VerboseEJBDeploymentEnabled;
        this._VerboseEJBDeploymentEnabled = string;
        this._postSet(132, string2, string);
    }

    public String getTransactionLogFilePrefix() {
        return this._TransactionLogFilePrefix;
    }

    public boolean isTransactionLogFilePrefixSet() {
        return this._isSet(133);
    }

    public void setTransactionLogFilePrefix(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TransactionLogFilePrefix;
        this._TransactionLogFilePrefix = string;
        this._postSet(133, string2, string);
    }

    public String getTransactionLogFileWritePolicy() {
        return this._TransactionLogFileWritePolicy;
    }

    public boolean isTransactionLogFileWritePolicySet() {
        return this._isSet(134);
    }

    public void setTransactionLogFileWritePolicy(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Cache-Flush", "Direct-Write"};
        string = LegalChecks.checkInEnum((String)"TransactionLogFileWritePolicy", (String)string, (String[])stringArray);
        LegalChecks.checkNonNull((String)"TransactionLogFileWritePolicy", (Object)string);
        String string2 = this._TransactionLogFileWritePolicy;
        this._TransactionLogFileWritePolicy = string;
        this._postSet(134, string2, string);
    }

    public boolean isNetworkClassLoadingEnabled() {
        return this._NetworkClassLoadingEnabled;
    }

    public boolean isNetworkClassLoadingEnabledSet() {
        return this._isSet(135);
    }

    public void setNetworkClassLoadingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._NetworkClassLoadingEnabled;
        this._NetworkClassLoadingEnabled = bl;
        this._postSet(135, bl2, bl);
    }

    public boolean isEnabledForDomainLog() {
        return this._customizer.isEnabledForDomainLog();
    }

    public boolean isEnabledForDomainLogSet() {
        return this._isSet(136);
    }

    public void setEnabledForDomainLog(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this.isEnabledForDomainLog();
        this._customizer.setEnabledForDomainLog(bl);
        this._postSet(136, bl2, bl);
    }

    public DomainLogFilterMBean getDomainLogFilter() {
        return this._customizer.getDomainLogFilter();
    }

    public String getDomainLogFilterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDomainLogFilter();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDomainLogFilterSet() {
        return this._isSet(137);
    }

    public void setDomainLogFilterAsString(String string) {
        if (string == null || string.length() == 0) {
            DomainLogFilterMBean domainLogFilterMBean = this._DomainLogFilter;
            this._initializeProperty(137);
            this._postSet(137, domainLogFilterMBean, this._DomainLogFilter);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, DomainLogFilterMBean.class, new ReferenceManager.Resolver(this, 137){

                public void resolveReference(Object object) {
                    try {
                        ServerMBeanImpl.this.setDomainLogFilter((DomainLogFilterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setDomainLogFilter(DomainLogFilterMBean domainLogFilterMBean) throws InvalidAttributeValueException, DistributedManagementException {
        DomainLogFilterMBean domainLogFilterMBean2 = this.getDomainLogFilter();
        this._customizer.setDomainLogFilter(domainLogFilterMBean);
        this._postSet(137, domainLogFilterMBean2, domainLogFilterMBean);
    }

    public boolean isTunnelingEnabled() {
        return this._TunnelingEnabled;
    }

    public boolean isTunnelingEnabledSet() {
        return this._isSet(138);
    }

    public void setTunnelingEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this._TunnelingEnabled;
        this._TunnelingEnabled = bl;
        this._postSet(138, bl2, bl);
    }

    public int getTunnelingClientPingSecs() {
        return this._TunnelingClientPingSecs;
    }

    public boolean isTunnelingClientPingSecsSet() {
        return this._isSet(139);
    }

    public void setTunnelingClientPingSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"TunnelingClientPingSecs", (int)n, (int)1);
        int n2 = this._TunnelingClientPingSecs;
        this._TunnelingClientPingSecs = n;
        this._postSet(139, n2, n);
    }

    public int getTunnelingClientTimeoutSecs() {
        return this._TunnelingClientTimeoutSecs;
    }

    public boolean isTunnelingClientTimeoutSecsSet() {
        return this._isSet(140);
    }

    public void setTunnelingClientTimeoutSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"TunnelingClientTimeoutSecs", (int)n, (int)1);
        int n2 = this._TunnelingClientTimeoutSecs;
        this._TunnelingClientTimeoutSecs = n;
        this._postSet(140, n2, n);
    }

    public int getAdminReconnectIntervalSeconds() {
        return this._AdminReconnectIntervalSeconds;
    }

    public boolean isAdminReconnectIntervalSecondsSet() {
        return this._isSet(141);
    }

    public void setAdminReconnectIntervalSeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"AdminReconnectIntervalSeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._AdminReconnectIntervalSeconds;
        this._AdminReconnectIntervalSeconds = n;
        this._postSet(141, n2, n);
    }

    public boolean isJMSDefaultConnectionFactoriesEnabled() {
        return this._JMSDefaultConnectionFactoriesEnabled;
    }

    public boolean isJMSDefaultConnectionFactoriesEnabledSet() {
        return this._isSet(142);
    }

    public void setJMSDefaultConnectionFactoriesEnabled(boolean bl) throws DistributedManagementException {
        boolean bl2 = this._JMSDefaultConnectionFactoriesEnabled;
        this._JMSDefaultConnectionFactoriesEnabled = bl;
        this._postSet(142, bl2, bl);
    }

    public ServerLifeCycleRuntimeMBean lookupServerLifeCycleRuntime() {
        return this._customizer.lookupServerLifeCycleRuntime();
    }

    public ServerStartMBean getServerStart() {
        return this._ServerStart;
    }

    public boolean isServerStartSet() {
        return this._isSet(143) || this._isAnythingSet((AbstractDescriptorBean)this.getServerStart());
    }

    public void setServerStart(ServerStartMBean serverStartMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)serverStartMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 143)) {
            this._postCreate(abstractDescriptorBean);
        }
        ServerStartMBean serverStartMBean2 = this._ServerStart;
        this._ServerStart = serverStartMBean;
        this._postSet(143, serverStartMBean2, serverStartMBean);
    }

    public int getListenDelaySecs() {
        return this._ListenDelaySecs;
    }

    public boolean isListenDelaySecsSet() {
        return this._isSet(144);
    }

    public void setListenDelaySecs(int n) {
        int n2 = this._ListenDelaySecs;
        this._ListenDelaySecs = n;
        this._postSet(144, n2, n);
    }

    public JTAMigratableTargetMBean getJTAMigratableTarget() {
        return this._JTAMigratableTarget;
    }

    public boolean isJTAMigratableTargetSet() {
        return this._isSet(145);
    }

    public void setJTAMigratableTarget(JTAMigratableTargetMBean jTAMigratableTargetMBean) throws InvalidAttributeValueException {
        Object object;
        if (jTAMigratableTargetMBean != null && this.getJTAMigratableTarget() != null && jTAMigratableTargetMBean != this.getJTAMigratableTarget()) {
            throw new BeanAlreadyExistsException(this.getJTAMigratableTarget() + " has already been created");
        }
        if (jTAMigratableTargetMBean != null && this._setParent((DescriptorBean)(object = (AbstractDescriptorBean)jTAMigratableTargetMBean), this, 145)) {
            this._getReferenceManager().registerBean(object, true);
            this._postCreate((AbstractDescriptorBean)object);
        }
        object = this._JTAMigratableTarget;
        this._JTAMigratableTarget = jTAMigratableTargetMBean;
        this._postSet(145, object, jTAMigratableTargetMBean);
    }

    public JTAMigratableTargetMBean createJTAMigratableTarget() {
        JTAMigratableTargetMBeanImpl jTAMigratableTargetMBeanImpl = new JTAMigratableTargetMBeanImpl(this, -1);
        try {
            this.setJTAMigratableTarget(jTAMigratableTargetMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return jTAMigratableTargetMBeanImpl;
    }

    public void destroyJTAMigratableTarget() {
        try {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this._JTAMigratableTarget;
            if (abstractDescriptorBean == null) {
                return;
            }
            List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
            if (list != null && list.size() > 0) {
                throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
            }
            this._getReferenceManager().unregisterBean(abstractDescriptorBean);
            this._markDestroyed(abstractDescriptorBean);
            this.setJTAMigratableTarget(null);
            this._unSet(145);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public int getLowMemoryTimeInterval() {
        return this._LowMemoryTimeInterval;
    }

    public boolean isLowMemoryTimeIntervalSet() {
        return this._isSet(146);
    }

    public void setLowMemoryTimeInterval(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LowMemoryTimeInterval", (long)n, (long)300L, (long)Integer.MAX_VALUE);
        int n2 = this._LowMemoryTimeInterval;
        this._LowMemoryTimeInterval = n;
        this._postSet(146, n2, n);
    }

    public int getLowMemorySampleSize() {
        return this._LowMemorySampleSize;
    }

    public boolean isLowMemorySampleSizeSet() {
        return this._isSet(147);
    }

    public void setLowMemorySampleSize(int n) {
        LegalChecks.checkInRange((String)"LowMemorySampleSize", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._LowMemorySampleSize;
        this._LowMemorySampleSize = n;
        this._postSet(147, n2, n);
    }

    public int getLowMemoryGranularityLevel() {
        return this._LowMemoryGranularityLevel;
    }

    public boolean isLowMemoryGranularityLevelSet() {
        return this._isSet(148);
    }

    public void setLowMemoryGranularityLevel(int n) {
        LegalChecks.checkInRange((String)"LowMemoryGranularityLevel", (long)n, (long)1L, (long)100L);
        int n2 = this._LowMemoryGranularityLevel;
        this._LowMemoryGranularityLevel = n;
        this._postSet(148, n2, n);
    }

    public int getLowMemoryGCThreshold() {
        return this._LowMemoryGCThreshold;
    }

    public boolean isLowMemoryGCThresholdSet() {
        return this._isSet(149);
    }

    public void setLowMemoryGCThreshold(int n) {
        LegalChecks.checkInRange((String)"LowMemoryGCThreshold", (long)n, (long)0L, (long)99L);
        int n2 = this._LowMemoryGCThreshold;
        this._LowMemoryGCThreshold = n;
        this._postSet(149, n2, n);
    }

    public String getStagingDirectoryName() {
        return this._customizer.getStagingDirectoryName();
    }

    public boolean isStagingDirectoryNameSet() {
        return this._isSet(150);
    }

    public void setStagingDirectoryName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getStagingDirectoryName();
        this._customizer.setStagingDirectoryName(string);
        this._postSet(150, string2, string);
    }

    public String getUploadDirectoryName() {
        return this._customizer.getUploadDirectoryName();
    }

    public boolean isUploadDirectoryNameSet() {
        return this._isSet(151);
    }

    public void setUploadDirectoryName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getUploadDirectoryName();
        this._customizer.setUploadDirectoryName(string);
        this._postSet(151, string2, string);
    }

    public String getActiveDirectoryName() {
        return this._customizer.getActiveDirectoryName();
    }

    public boolean isActiveDirectoryNameSet() {
        return this._isSet(152);
    }

    public void setActiveDirectoryName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getActiveDirectoryName();
        this._customizer.setActiveDirectoryName(string);
        this._postSet(152, string2, string);
    }

    public String getStagingMode() {
        if (!this._isSet(153)) {
            try {
                return DeployHelper.determineDefaultStagingMode(this.getName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._StagingMode;
    }

    public boolean isStagingModeSet() {
        return this._isSet(153);
    }

    public void setStagingMode(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{ServerMBean.DEFAULT_STAGE, "stage", "nostage", "external_stage"};
        string = LegalChecks.checkInEnum((String)"StagingMode", (String)string, (String[])stringArray);
        String string2 = this._StagingMode;
        this._StagingMode = string;
        this._postSet(153, string2, string);
    }

    public boolean getAutoRestart() {
        return this._AutoRestart;
    }

    public boolean isAutoRestartSet() {
        return this._isSet(154);
    }

    public void setAutoRestart(boolean bl) {
        boolean bl2 = this._AutoRestart;
        this._AutoRestart = bl;
        this._postSet(154, bl2, bl);
    }

    public boolean getAutoKillIfFailed() {
        return this._AutoKillIfFailed;
    }

    public boolean isAutoKillIfFailedSet() {
        return this._isSet(155);
    }

    public void setAutoKillIfFailed(boolean bl) {
        boolean bl2 = this._AutoKillIfFailed;
        this._AutoKillIfFailed = bl;
        this._postSet(155, bl2, bl);
    }

    public int getRestartIntervalSeconds() {
        return this._RestartIntervalSeconds;
    }

    public boolean isRestartIntervalSecondsSet() {
        return this._isSet(156);
    }

    public void setRestartIntervalSeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RestartIntervalSeconds", (long)n, (long)300L, (long)Integer.MAX_VALUE);
        int n2 = this._RestartIntervalSeconds;
        this._RestartIntervalSeconds = n;
        this._postSet(156, n2, n);
    }

    public int getRestartMax() {
        return this._RestartMax;
    }

    public boolean isRestartMaxSet() {
        return this._isSet(157);
    }

    public void setRestartMax(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RestartMax", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._RestartMax;
        this._RestartMax = n;
        this._postSet(157, n2, n);
    }

    public int getHealthCheckIntervalSeconds() {
        return this._HealthCheckIntervalSeconds;
    }

    public boolean isHealthCheckIntervalSecondsSet() {
        return this._isSet(158);
    }

    public void setHealthCheckIntervalSeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"HealthCheckIntervalSeconds", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._HealthCheckIntervalSeconds;
        this._HealthCheckIntervalSeconds = n;
        this._postSet(158, n2, n);
    }

    public int getHealthCheckTimeoutSeconds() {
        return this._HealthCheckTimeoutSeconds;
    }

    public boolean isHealthCheckTimeoutSecondsSet() {
        return this._isSet(159);
    }

    public void setHealthCheckTimeoutSeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"HealthCheckTimeoutSeconds", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._HealthCheckTimeoutSeconds;
        this._HealthCheckTimeoutSeconds = n;
        this._postSet(159, n2, n);
    }

    public int getHealthCheckStartDelaySeconds() {
        return this._HealthCheckStartDelaySeconds;
    }

    public boolean isHealthCheckStartDelaySecondsSet() {
        return this._isSet(160);
    }

    public void setHealthCheckStartDelaySeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"HealthCheckStartDelaySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._HealthCheckStartDelaySeconds;
        this._HealthCheckStartDelaySeconds = n;
        this._postSet(160, n2, n);
    }

    public int getRestartDelaySeconds() {
        return this._RestartDelaySeconds;
    }

    public boolean isRestartDelaySecondsSet() {
        return this._isSet(161);
    }

    public void setRestartDelaySeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RestartDelaySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._RestartDelaySeconds;
        this._RestartDelaySeconds = n;
        this._postSet(161, n2, n);
    }

    public void setClasspathServletDisabled(boolean bl) {
        boolean bl2 = this._ClasspathServletDisabled;
        this._ClasspathServletDisabled = bl;
        this._postSet(162, bl2, bl);
    }

    public boolean isClasspathServletDisabled() {
        return this._ClasspathServletDisabled;
    }

    public boolean isClasspathServletDisabledSet() {
        return this._isSet(162);
    }

    public void setDefaultInternalServletsDisabled(boolean bl) {
        boolean bl2 = this._DefaultInternalServletsDisabled;
        this._DefaultInternalServletsDisabled = bl;
        this._postSet(163, bl2, bl);
    }

    public boolean isDefaultInternalServletsDisabled() {
        return this._DefaultInternalServletsDisabled;
    }

    public boolean isDefaultInternalServletsDisabledSet() {
        return this._isSet(163);
    }

    public String getServerVersion() {
        return this._ServerVersion;
    }

    public boolean isServerVersionSet() {
        return this._isSet(164);
    }

    public void setServerVersion(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ServerVersion;
        this._ServerVersion = string;
        this._postSet(164, string2, string);
    }

    public void setStartupMode(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getStartupMode();
        this._customizer.setStartupMode(string);
        this._postSet(165, string2, string);
    }

    public String getStartupMode() {
        return this._customizer.getStartupMode();
    }

    public boolean isStartupModeSet() {
        return this._isSet(165);
    }

    public void setServerLifeCycleTimeoutVal(int n) {
        LegalChecks.checkMin((String)"ServerLifeCycleTimeoutVal", (int)n, (int)0);
        int n2 = this._ServerLifeCycleTimeoutVal;
        this._ServerLifeCycleTimeoutVal = n;
        this._postSet(166, n2, n);
    }

    public int getServerLifeCycleTimeoutVal() {
        if (!this._isSet(166)) {
            return this._isProductionModeEnabled() ? 120 : 30;
        }
        return this._ServerLifeCycleTimeoutVal;
    }

    public boolean isServerLifeCycleTimeoutValSet() {
        return this._isSet(166);
    }

    public void setGracefulShutdownTimeout(int n) {
        LegalChecks.checkMin((String)"GracefulShutdownTimeout", (int)n, (int)0);
        int n2 = this._GracefulShutdownTimeout;
        this._GracefulShutdownTimeout = n;
        this._postSet(168, n2, n);
    }

    public void setStartupTimeout(int n) {
        LegalChecks.checkMin((String)"StartupTimeout", (int)n, (int)0);
        int n2 = this._StartupTimeout;
        this._StartupTimeout = n;
        this._postSet(167, n2, n);
    }

    public int getStartupTimeout() {
        if (!this._isSet(167)) {
            return this._isProductionModeEnabled() ? 0 : 0;
        }
        return this._StartupTimeout;
    }

    public boolean isStartupTimeoutSet() {
        return this._isSet(167);
    }

    public int getGracefulShutdownTimeout() {
        return this._GracefulShutdownTimeout;
    }

    public boolean isGracefulShutdownTimeoutSet() {
        return this._isSet(168);
    }

    public boolean isIgnoreSessionsDuringShutdown() {
        return this._IgnoreSessionsDuringShutdown;
    }

    public boolean isIgnoreSessionsDuringShutdownSet() {
        return this._isSet(169);
    }

    public void setIgnoreSessionsDuringShutdown(boolean bl) {
        boolean bl2 = this._IgnoreSessionsDuringShutdown;
        this._IgnoreSessionsDuringShutdown = bl;
        this._postSet(169, bl2, bl);
    }

    public boolean isManagedServerIndependenceEnabled() {
        return this._ManagedServerIndependenceEnabled;
    }

    public boolean isManagedServerIndependenceEnabledSet() {
        return this._isSet(170);
    }

    public void setManagedServerIndependenceEnabled(boolean bl) {
        boolean bl2 = this._ManagedServerIndependenceEnabled;
        this._ManagedServerIndependenceEnabled = bl;
        this._postSet(170, bl2, bl);
    }

    public boolean isMSIFileReplicationEnabled() {
        return this._MSIFileReplicationEnabled;
    }

    public boolean isMSIFileReplicationEnabledSet() {
        return this._isSet(171);
    }

    public void setMSIFileReplicationEnabled(boolean bl) {
        boolean bl2 = this._MSIFileReplicationEnabled;
        this._MSIFileReplicationEnabled = bl;
        this._postSet(171, bl2, bl);
    }

    public void setClientCertProxyEnabled(boolean bl) {
        boolean bl2 = this._ClientCertProxyEnabled;
        this._ClientCertProxyEnabled = bl;
        this._postSet(172, bl2, bl);
    }

    public boolean isClientCertProxyEnabled() {
        return this._ClientCertProxyEnabled;
    }

    public boolean isClientCertProxyEnabledSet() {
        return this._isSet(172);
    }

    public void setWeblogicPluginEnabled(boolean bl) {
        boolean bl2 = this._WeblogicPluginEnabled;
        this._WeblogicPluginEnabled = bl;
        this._postSet(173, bl2, bl);
    }

    public boolean isWeblogicPluginEnabled() {
        return this._WeblogicPluginEnabled;
    }

    public boolean isWeblogicPluginEnabledSet() {
        return this._isSet(173);
    }

    public void setHostsMigratableServices(boolean bl) {
        boolean bl2 = this._HostsMigratableServices;
        this._HostsMigratableServices = bl;
        this._postSet(174, bl2, bl);
    }

    public boolean getHostsMigratableServices() {
        return this._HostsMigratableServices;
    }

    public boolean isHostsMigratableServicesSet() {
        return this._isSet(174);
    }

    public void setHttpTraceSupportEnabled(boolean bl) {
        boolean bl2 = this._HttpTraceSupportEnabled;
        this._HttpTraceSupportEnabled = bl;
        this._postSet(175, bl2, bl);
    }

    public boolean isHttpTraceSupportEnabled() {
        return this._HttpTraceSupportEnabled;
    }

    public boolean isHttpTraceSupportEnabledSet() {
        return this._isSet(175);
    }

    public String getKeyStores() {
        return this._KeyStores;
    }

    public boolean isKeyStoresSet() {
        return this._isSet(176);
    }

    public void setKeyStores(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"DemoIdentityAndDemoTrust", "CustomIdentityAndJavaStandardTrust", "CustomIdentityAndCustomTrust", "CustomIdentityAndCommandLineTrust"};
        string = LegalChecks.checkInEnum((String)"KeyStores", (String)string, (String[])stringArray);
        String string2 = this._KeyStores;
        this._KeyStores = string;
        this._postSet(176, string2, string);
    }

    public String getCustomIdentityKeyStoreFileName() {
        return this._CustomIdentityKeyStoreFileName;
    }

    public boolean isCustomIdentityKeyStoreFileNameSet() {
        return this._isSet(177);
    }

    public void setCustomIdentityKeyStoreFileName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._CustomIdentityKeyStoreFileName;
        this._CustomIdentityKeyStoreFileName = string;
        this._postSet(177, string2, string);
    }

    public String getCustomIdentityKeyStoreType() {
        return this._CustomIdentityKeyStoreType;
    }

    public boolean isCustomIdentityKeyStoreTypeSet() {
        return this._isSet(178);
    }

    public void setCustomIdentityKeyStoreType(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._CustomIdentityKeyStoreType;
        this._CustomIdentityKeyStoreType = string;
        this._postSet(178, string2, string);
    }

    public String getCustomIdentityKeyStorePassPhrase() {
        byte[] byArray = this.getCustomIdentityKeyStorePassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("CustomIdentityKeyStorePassPhrase", byArray);
    }

    public boolean isCustomIdentityKeyStorePassPhraseSet() {
        return this.isCustomIdentityKeyStorePassPhraseEncryptedSet();
    }

    public void setCustomIdentityKeyStorePassPhrase(String string) {
        string = string == null ? null : string.trim();
        this.setCustomIdentityKeyStorePassPhraseEncrypted(string == null ? null : this._encrypt("CustomIdentityKeyStorePassPhrase", string));
    }

    public byte[] getCustomIdentityKeyStorePassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._CustomIdentityKeyStorePassPhraseEncrypted);
    }

    public String getCustomIdentityKeyStorePassPhraseEncryptedAsString() {
        byte[] byArray = this.getCustomIdentityKeyStorePassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isCustomIdentityKeyStorePassPhraseEncryptedSet() {
        return this._isSet(180);
    }

    public void setCustomIdentityKeyStorePassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setCustomIdentityKeyStorePassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getCustomTrustKeyStoreFileName() {
        return this._CustomTrustKeyStoreFileName;
    }

    public boolean isCustomTrustKeyStoreFileNameSet() {
        return this._isSet(181);
    }

    public void setCustomTrustKeyStoreFileName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._CustomTrustKeyStoreFileName;
        this._CustomTrustKeyStoreFileName = string;
        this._postSet(181, string2, string);
    }

    public String getCustomTrustKeyStoreType() {
        return this._CustomTrustKeyStoreType;
    }

    public boolean isCustomTrustKeyStoreTypeSet() {
        return this._isSet(182);
    }

    public void setCustomTrustKeyStoreType(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._CustomTrustKeyStoreType;
        this._CustomTrustKeyStoreType = string;
        this._postSet(182, string2, string);
    }

    public String getCustomTrustKeyStorePassPhrase() {
        byte[] byArray = this.getCustomTrustKeyStorePassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("CustomTrustKeyStorePassPhrase", byArray);
    }

    public boolean isCustomTrustKeyStorePassPhraseSet() {
        return this.isCustomTrustKeyStorePassPhraseEncryptedSet();
    }

    public void setCustomTrustKeyStorePassPhrase(String string) {
        string = string == null ? null : string.trim();
        this.setCustomTrustKeyStorePassPhraseEncrypted(string == null ? null : this._encrypt("CustomTrustKeyStorePassPhrase", string));
    }

    public byte[] getCustomTrustKeyStorePassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._CustomTrustKeyStorePassPhraseEncrypted);
    }

    public String getCustomTrustKeyStorePassPhraseEncryptedAsString() {
        byte[] byArray = this.getCustomTrustKeyStorePassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isCustomTrustKeyStorePassPhraseEncryptedSet() {
        return this._isSet(184);
    }

    public void setCustomTrustKeyStorePassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setCustomTrustKeyStorePassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getJavaStandardTrustKeyStorePassPhrase() {
        byte[] byArray = this.getJavaStandardTrustKeyStorePassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("JavaStandardTrustKeyStorePassPhrase", byArray);
    }

    public boolean isJavaStandardTrustKeyStorePassPhraseSet() {
        return this.isJavaStandardTrustKeyStorePassPhraseEncryptedSet();
    }

    public void setJavaStandardTrustKeyStorePassPhrase(String string) {
        string = string == null ? null : string.trim();
        this.setJavaStandardTrustKeyStorePassPhraseEncrypted(string == null ? null : this._encrypt("JavaStandardTrustKeyStorePassPhrase", string));
    }

    public byte[] getJavaStandardTrustKeyStorePassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._JavaStandardTrustKeyStorePassPhraseEncrypted);
    }

    public String getJavaStandardTrustKeyStorePassPhraseEncryptedAsString() {
        byte[] byArray = this.getJavaStandardTrustKeyStorePassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isJavaStandardTrustKeyStorePassPhraseEncryptedSet() {
        return this._isSet(186);
    }

    public void setJavaStandardTrustKeyStorePassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setJavaStandardTrustKeyStorePassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setReliableDeliveryPolicy(WSReliableDeliveryPolicyMBean wSReliableDeliveryPolicyMBean) {
        WSReliableDeliveryPolicyMBean wSReliableDeliveryPolicyMBean2;
        if (wSReliableDeliveryPolicyMBean != null) {
            wSReliableDeliveryPolicyMBean2 = new ResolvedReference(this, 187, (AbstractDescriptorBean)wSReliableDeliveryPolicyMBean){

                protected Object getPropertyValue() {
                    return ServerMBeanImpl.this.getReliableDeliveryPolicy();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)wSReliableDeliveryPolicyMBean, (ResolvedReference)wSReliableDeliveryPolicyMBean2);
        }
        wSReliableDeliveryPolicyMBean2 = this._ReliableDeliveryPolicy;
        this._ReliableDeliveryPolicy = wSReliableDeliveryPolicyMBean;
        this._postSet(187, wSReliableDeliveryPolicyMBean2, wSReliableDeliveryPolicyMBean);
    }

    public WSReliableDeliveryPolicyMBean getReliableDeliveryPolicy() {
        return this._ReliableDeliveryPolicy;
    }

    public String getReliableDeliveryPolicyAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getReliableDeliveryPolicy();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isReliableDeliveryPolicySet() {
        return this._isSet(187);
    }

    public void setReliableDeliveryPolicyAsString(String string) {
        if (string == null || string.length() == 0) {
            WSReliableDeliveryPolicyMBean wSReliableDeliveryPolicyMBean = this._ReliableDeliveryPolicy;
            this._initializeProperty(187);
            this._postSet(187, wSReliableDeliveryPolicyMBean, this._ReliableDeliveryPolicy);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, WSReliableDeliveryPolicyMBean.class, new ReferenceManager.Resolver(this, 187){

                public void resolveReference(Object object) {
                    try {
                        ServerMBeanImpl.this.setReliableDeliveryPolicy((WSReliableDeliveryPolicyMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public boolean isMessageIdPrefixEnabled() {
        return this._MessageIdPrefixEnabled;
    }

    public boolean isMessageIdPrefixEnabledSet() {
        return this._isSet(188);
    }

    public void setMessageIdPrefixEnabled(boolean bl) {
        boolean bl2 = this.isMessageIdPrefixEnabled();
        this._customizer.setMessageIdPrefixEnabled(bl);
        this._postSet(188, bl2, bl);
    }

    public DefaultFileStoreMBean getDefaultFileStore() {
        return this._DefaultFileStore;
    }

    public boolean isDefaultFileStoreSet() {
        return this._isSet(189) || this._isAnythingSet((AbstractDescriptorBean)this.getDefaultFileStore());
    }

    public void setDefaultFileStore(DefaultFileStoreMBean defaultFileStoreMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)defaultFileStoreMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 189)) {
            this._postCreate(abstractDescriptorBean);
        }
        DefaultFileStoreMBean defaultFileStoreMBean2 = this._DefaultFileStore;
        this._DefaultFileStore = defaultFileStoreMBean;
        this._postSet(189, defaultFileStoreMBean2, defaultFileStoreMBean);
    }

    public void addCandidateMachine(MachineMBean machineMBean) {
        this._getHelper()._ensureNonNull((Object)machineMBean);
        if (!((AbstractDescriptorBean)machineMBean).isChildProperty((DescriptorBean)this, 190)) {
            MachineMBean[] machineMBeanArray = this._isSet(190) ? (MachineMBean[])this._getHelper()._extendArray((Object)this.getCandidateMachines(), MachineMBean.class, (Object)machineMBean) : new MachineMBean[]{machineMBean};
            try {
                this.setCandidateMachines(machineMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public MachineMBean[] getCandidateMachines() {
        return this._CandidateMachines;
    }

    public String getCandidateMachinesAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getCandidateMachines());
    }

    public boolean isCandidateMachinesSet() {
        return this._isSet(190);
    }

    public void removeCandidateMachine(MachineMBean machineMBean) {
        MachineMBean[] machineMBeanArray = this.getCandidateMachines();
        MachineMBean[] machineMBeanArray2 = (MachineMBean[])this._getHelper()._removeElement((Object)machineMBeanArray, MachineMBean.class, (Object)machineMBean);
        if (machineMBeanArray2.length != machineMBeanArray.length) {
            try {
                this.setCandidateMachines(machineMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setCandidateMachinesAsString(String string) {
        if (string == null || string.length() == 0) {
            MachineMBean[] machineMBeanArray = this._CandidateMachines;
            this._initializeProperty(190);
            this._postSet(190, machineMBeanArray, this._CandidateMachines);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._CandidateMachines);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, MachineMBean.class, new ReferenceManager.Resolver(this, 190){

                    public void resolveReference(Object object) {
                        try {
                            ServerMBeanImpl.this.addCandidateMachine((MachineMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (MachineMBean machineMBean : this._CandidateMachines) {
                    if (!string2.equals(machineMBean.getName())) continue;
                    try {
                        this.removeCandidateMachine(machineMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setCandidateMachines(MachineMBean[] machineMBeanArray) {
        machineMBeanArray = machineMBeanArray == null ? new MachineMBeanImpl[]{} : machineMBeanArray;
        machineMBeanArray = (MachineMBean[])this._getHelper()._cleanAndValidateArray((Object)machineMBeanArray, MachineMBean.class);
        for (int i = 0; i < machineMBeanArray.length; ++i) {
            if (machineMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 190, (AbstractDescriptorBean)machineMBeanArray[i]){

                protected Object getPropertyValue() {
                    return ServerMBeanImpl.this.getCandidateMachines();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)machineMBeanArray[i], resolvedReference);
        }
        MachineMBean[] machineMBeanArray2 = this._CandidateMachines;
        this._CandidateMachines = machineMBeanArray;
        this._postSet(190, machineMBeanArray2, machineMBeanArray);
    }

    public OverloadProtectionMBean getOverloadProtection() {
        return this._OverloadProtection;
    }

    public boolean isOverloadProtectionSet() {
        return this._isSet(191) || this._isAnythingSet((AbstractDescriptorBean)this.getOverloadProtection());
    }

    public void setOverloadProtection(OverloadProtectionMBean overloadProtectionMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)overloadProtectionMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 191)) {
            this._postCreate(abstractDescriptorBean);
        }
        OverloadProtectionMBean overloadProtectionMBean2 = this._OverloadProtection;
        this._OverloadProtection = overloadProtectionMBean;
        this._postSet(191, overloadProtectionMBean2, overloadProtectionMBean);
    }

    public String getJDBCLLRTableName() {
        return this._JDBCLLRTableName;
    }

    public boolean isJDBCLLRTableNameSet() {
        return this._isSet(192);
    }

    public void setJDBCLLRTableName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._JDBCLLRTableName;
        this._JDBCLLRTableName = string;
        this._postSet(192, string2, string);
    }

    public boolean isUseFusionForLLR() {
        return this._UseFusionForLLR;
    }

    public boolean isUseFusionForLLRSet() {
        return this._isSet(193);
    }

    public void setUseFusionForLLR(boolean bl) {
        boolean bl2 = this._UseFusionForLLR;
        this._UseFusionForLLR = bl;
        this._postSet(193, bl2, bl);
    }

    public int getJDBCLLRTableXIDColumnSize() {
        return this._JDBCLLRTableXIDColumnSize;
    }

    public boolean isJDBCLLRTableXIDColumnSizeSet() {
        return this._isSet(194);
    }

    public void setJDBCLLRTableXIDColumnSize(int n) {
        int n2 = this._JDBCLLRTableXIDColumnSize;
        this._JDBCLLRTableXIDColumnSize = n;
        this._postSet(194, n2, n);
    }

    public int getJDBCLLRTablePoolColumnSize() {
        return this._JDBCLLRTablePoolColumnSize;
    }

    public boolean isJDBCLLRTablePoolColumnSizeSet() {
        return this._isSet(195);
    }

    public void setJDBCLLRTablePoolColumnSize(int n) {
        int n2 = this._JDBCLLRTablePoolColumnSize;
        this._JDBCLLRTablePoolColumnSize = n;
        this._postSet(195, n2, n);
    }

    public int getJDBCLLRTableRecordColumnSize() {
        return this._JDBCLLRTableRecordColumnSize;
    }

    public boolean isJDBCLLRTableRecordColumnSizeSet() {
        return this._isSet(196);
    }

    public void setJDBCLLRTableRecordColumnSize(int n) {
        int n2 = this._JDBCLLRTableRecordColumnSize;
        this._JDBCLLRTableRecordColumnSize = n;
        this._postSet(196, n2, n);
    }

    public int getJDBCLoginTimeoutSeconds() {
        return this._JDBCLoginTimeoutSeconds;
    }

    public boolean isJDBCLoginTimeoutSecondsSet() {
        return this._isSet(197);
    }

    public void setJDBCLoginTimeoutSeconds(int n) {
        LegalChecks.checkInRange((String)"JDBCLoginTimeoutSeconds", (long)n, (long)0L, (long)300L);
        int n2 = this._JDBCLoginTimeoutSeconds;
        this._JDBCLoginTimeoutSeconds = n;
        this._postSet(197, n2, n);
    }

    public WLDFServerDiagnosticMBean getServerDiagnosticConfig() {
        return this._ServerDiagnosticConfig;
    }

    public boolean isServerDiagnosticConfigSet() {
        return this._isSet(198) || this._isAnythingSet((AbstractDescriptorBean)this.getServerDiagnosticConfig());
    }

    public void setServerDiagnosticConfig(WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFServerDiagnosticMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 198)) {
            this._postCreate(abstractDescriptorBean);
        }
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean2 = this._ServerDiagnosticConfig;
        this._ServerDiagnosticConfig = wLDFServerDiagnosticMBean;
        this._postSet(198, wLDFServerDiagnosticMBean2, wLDFServerDiagnosticMBean);
    }

    public void setAutoJDBCConnectionClose(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._AutoJDBCConnectionClose;
        this._AutoJDBCConnectionClose = string;
        this._postSet(199, string2, string);
    }

    public String getAutoJDBCConnectionClose() {
        return this._AutoJDBCConnectionClose;
    }

    public boolean isAutoJDBCConnectionCloseSet() {
        return this._isSet(199);
    }

    public String[] getSupportedProtocols() {
        return this._customizer.getSupportedProtocols();
    }

    public boolean isSupportedProtocolsSet() {
        return this._isSet(200);
    }

    public void setSupportedProtocols(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._SupportedProtocols;
        this._SupportedProtocols = stringArray;
        this._postSet(200, stringArray2, stringArray);
    }

    public String getDefaultStagingDirName() {
        return this._customizer.getDefaultStagingDirName();
    }

    public boolean isDefaultStagingDirNameSet() {
        return this._isSet(201);
    }

    public void setDefaultStagingDirName(String string) throws InvalidAttributeValueException {
        this._DefaultStagingDirName = string = string == null ? null : string.trim();
    }

    public String get81StyleDefaultStagingDirName() {
        return this._customizer.get81StyleDefaultStagingDirName();
    }

    public boolean is81StyleDefaultStagingDirNameSet() {
        return this._isSet(202);
    }

    public void set81StyleDefaultStagingDirName(String string) throws InvalidAttributeValueException {
        this._81StyleDefaultStagingDirName = string = string == null ? null : string.trim();
    }

    public FederationServicesMBean getFederationServices() {
        return this._FederationServices;
    }

    public boolean isFederationServicesSet() {
        return this._isSet(203) || this._isAnythingSet((AbstractDescriptorBean)this.getFederationServices());
    }

    public void setFederationServices(FederationServicesMBean federationServicesMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)federationServicesMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 203)) {
            this._postCreate(abstractDescriptorBean);
        }
        FederationServicesMBean federationServicesMBean2 = this._FederationServices;
        this._FederationServices = federationServicesMBean;
        this._postSet(203, federationServicesMBean2, federationServicesMBean);
    }

    public SingleSignOnServicesMBean getSingleSignOnServices() {
        return this._SingleSignOnServices;
    }

    public boolean isSingleSignOnServicesSet() {
        return this._isSet(204) || this._isAnythingSet((AbstractDescriptorBean)this.getSingleSignOnServices());
    }

    public void setSingleSignOnServices(SingleSignOnServicesMBean singleSignOnServicesMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)singleSignOnServicesMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 204)) {
            this._postCreate(abstractDescriptorBean);
        }
        SingleSignOnServicesMBean singleSignOnServicesMBean2 = this._SingleSignOnServices;
        this._SingleSignOnServices = singleSignOnServicesMBean;
        this._postSet(204, singleSignOnServicesMBean2, singleSignOnServicesMBean);
    }

    public WebServiceMBean getWebService() {
        return this._WebService;
    }

    public boolean isWebServiceSet() {
        return this._isSet(205) || this._isAnythingSet((AbstractDescriptorBean)this.getWebService());
    }

    public void setWebService(WebServiceMBean webServiceMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)webServiceMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 205)) {
            this._postCreate(abstractDescriptorBean);
        }
        WebServiceMBean webServiceMBean2 = this._WebService;
        this._WebService = webServiceMBean;
        this._postSet(205, webServiceMBean2, webServiceMBean);
    }

    public int getNMSocketCreateTimeoutInMillis() {
        return this._NMSocketCreateTimeoutInMillis;
    }

    public boolean isNMSocketCreateTimeoutInMillisSet() {
        return this._isSet(206);
    }

    public void setNMSocketCreateTimeoutInMillis(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"NMSocketCreateTimeoutInMillis", (int)n, (int)0);
        int n2 = this._NMSocketCreateTimeoutInMillis;
        this._NMSocketCreateTimeoutInMillis = n;
        this._postSet(206, n2, n);
    }

    public void setCoherenceClusterSystemResource(CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean) {
        CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean2;
        if (coherenceClusterSystemResourceMBean != null) {
            coherenceClusterSystemResourceMBean2 = new ResolvedReference(this, 207, (AbstractDescriptorBean)coherenceClusterSystemResourceMBean){

                protected Object getPropertyValue() {
                    return ServerMBeanImpl.this.getCoherenceClusterSystemResource();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)coherenceClusterSystemResourceMBean, (ResolvedReference)coherenceClusterSystemResourceMBean2);
        }
        coherenceClusterSystemResourceMBean2 = this.getCoherenceClusterSystemResource();
        this._customizer.setCoherenceClusterSystemResource(coherenceClusterSystemResourceMBean);
        this._postSet(207, coherenceClusterSystemResourceMBean2, coherenceClusterSystemResourceMBean);
    }

    public CoherenceClusterSystemResourceMBean getCoherenceClusterSystemResource() {
        return this._customizer.getCoherenceClusterSystemResource();
    }

    public String getCoherenceClusterSystemResourceAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getCoherenceClusterSystemResource();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isCoherenceClusterSystemResourceSet() {
        return this._isSet(207);
    }

    public void setCoherenceClusterSystemResourceAsString(String string) {
        if (string == null || string.length() == 0) {
            CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean = this._CoherenceClusterSystemResource;
            this._initializeProperty(207);
            this._postSet(207, coherenceClusterSystemResourceMBean, this._CoherenceClusterSystemResource);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, CoherenceClusterSystemResourceMBean.class, new ReferenceManager.Resolver(this, 207){

                public void resolveReference(Object object) {
                    try {
                        ServerMBeanImpl.this.setCoherenceClusterSystemResource((CoherenceClusterSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setVirtualMachineName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._VirtualMachineName;
        this._VirtualMachineName = string;
        this._postSet(208, string2, string);
    }

    public String getVirtualMachineName() {
        if (!this._isSet(208)) {
            try {
                return ((DomainMBean)this.getParent()).getName() + "_" + this.getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._VirtualMachineName;
    }

    public boolean isVirtualMachineNameSet() {
        return this._isSet(208);
    }

    public String getReplicationPorts() {
        return this._ReplicationPorts;
    }

    public boolean isReplicationPortsSet() {
        return this._isSet(209);
    }

    public void setReplicationPorts(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ReplicationPorts;
        this._ReplicationPorts = string;
        this._postSet(209, string2, string);
    }

    public TransactionLogJDBCStoreMBean getTransactionLogJDBCStore() {
        return this._TransactionLogJDBCStore;
    }

    public boolean isTransactionLogJDBCStoreSet() {
        return this._isSet(210) || this._isAnythingSet((AbstractDescriptorBean)this.getTransactionLogJDBCStore());
    }

    public void setTransactionLogJDBCStore(TransactionLogJDBCStoreMBean transactionLogJDBCStoreMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)transactionLogJDBCStoreMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 210)) {
            this._postCreate(abstractDescriptorBean);
        }
        TransactionLogJDBCStoreMBean transactionLogJDBCStoreMBean2 = this._TransactionLogJDBCStore;
        this._TransactionLogJDBCStore = transactionLogJDBCStoreMBean;
        this._postSet(210, transactionLogJDBCStoreMBean2, transactionLogJDBCStoreMBean);
    }

    public DataSourceMBean getDataSource() {
        return this._DataSource;
    }

    public boolean isDataSourceSet() {
        return this._isSet(211) || this._isAnythingSet((AbstractDescriptorBean)this.getDataSource());
    }

    public void setDataSource(DataSourceMBean dataSourceMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)dataSourceMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 211)) {
            this._postCreate(abstractDescriptorBean);
        }
        DataSourceMBean dataSourceMBean2 = this._DataSource;
        this._DataSource = dataSourceMBean;
        this._postSet(211, dataSourceMBean2, dataSourceMBean);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        ServerLegalHelper.validateServer(this);
        LegalHelper.validateListenPorts(this);
    }

    public void setCustomIdentityKeyStorePassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._CustomIdentityKeyStorePassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: CustomIdentityKeyStorePassPhraseEncrypted of ServerMBean");
        }
        this._getHelper()._clearArray(this._CustomIdentityKeyStorePassPhraseEncrypted);
        this._CustomIdentityKeyStorePassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(180, byArray2, byArray);
    }

    public void setCustomTrustKeyStorePassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._CustomTrustKeyStorePassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: CustomTrustKeyStorePassPhraseEncrypted of ServerMBean");
        }
        this._getHelper()._clearArray(this._CustomTrustKeyStorePassPhraseEncrypted);
        this._CustomTrustKeyStorePassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(184, byArray2, byArray);
    }

    public void setDefaultIIOPPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._DefaultIIOPPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: DefaultIIOPPasswordEncrypted of ServerMBean");
        }
        this._getHelper()._clearArray(this._DefaultIIOPPasswordEncrypted);
        this._DefaultIIOPPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(99, byArray2, byArray);
    }

    public void setDefaultTGIOPPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._DefaultTGIOPPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: DefaultTGIOPPasswordEncrypted of ServerMBean");
        }
        this._getHelper()._clearArray(this._DefaultTGIOPPasswordEncrypted);
        this._DefaultTGIOPPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(103, byArray2, byArray);
    }

    public void setJavaStandardTrustKeyStorePassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._JavaStandardTrustKeyStorePassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: JavaStandardTrustKeyStorePassPhraseEncrypted of ServerMBean");
        }
        this._getHelper()._clearArray(this._JavaStandardTrustKeyStorePassPhraseEncrypted);
        this._JavaStandardTrustKeyStorePassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(186, byArray2, byArray);
    }

    public void setSystemPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._SystemPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: SystemPasswordEncrypted of ServerMBean");
        }
        this._getHelper()._clearArray(this._SystemPasswordEncrypted);
        this._SystemPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(110, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 179) {
                this._markSet(180, false);
            }
            if (n == 183) {
                this._markSet(184, false);
            }
            if (n == 98) {
                this._markSet(99, false);
            }
            if (n == 102) {
                this._markSet(103, false);
            }
            if (n == 185) {
                this._markSet(186, false);
            }
            if (n == 109) {
                this._markSet(110, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet() || this.isCOMSet() || this.isDataSourceSet() || this.isDefaultFileStoreSet() || this.isFederationServicesSet() || this.isOverloadProtectionSet() || this.isServerDebugSet() || this.isServerDiagnosticConfigSet() || this.isServerStartSet() || this.isSingleSignOnServicesSet() || this.isTransactionLogJDBCStoreSet() || this.isWebServerSet() || this.isWebServiceSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 202;
        }
        try {
            switch (n) {
                case 202: {
                    this._81StyleDefaultStagingDirName = null;
                    if (bl) break;
                }
                case 118: {
                    this._AcceptBacklog = 300;
                    if (bl) break;
                }
                case 152: {
                    this._customizer.setActiveDirectoryName(null);
                    if (bl) break;
                }
                case 141: {
                    this._AdminReconnectIntervalSeconds = 10;
                    if (bl) break;
                }
                case 122: {
                    this._customizer.setAdministrationPort(0);
                    if (bl) break;
                }
                case 199: {
                    this._AutoJDBCConnectionClose = "false";
                    if (bl) break;
                }
                case 155: {
                    this._AutoKillIfFailed = false;
                    if (bl) break;
                }
                case 154: {
                    this._AutoRestart = true;
                    if (bl) break;
                }
                case 106: {
                    this._COM = new COMMBeanImpl(this, 106);
                    this._postCreate((AbstractDescriptorBean)this._COM);
                    if (bl) break;
                }
                case 190: {
                    this._CandidateMachines = new MachineMBean[0];
                    if (bl) break;
                }
                case 83: {
                    this._customizer.setCluster(null);
                    if (bl) break;
                }
                case 89: {
                    this._ClusterRuntime = null;
                    if (bl) break;
                }
                case 84: {
                    this._ClusterWeight = 100;
                    if (bl) break;
                }
                case 207: {
                    this._customizer.setCoherenceClusterSystemResource(null);
                    if (bl) break;
                }
                case 87: {
                    this._ConsensusProcessIdentifier = -1;
                    if (bl) break;
                }
                case 177: {
                    this._CustomIdentityKeyStoreFileName = null;
                    if (bl) break;
                }
                case 179: {
                    this._CustomIdentityKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 180: {
                    this._CustomIdentityKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 178: {
                    this._CustomIdentityKeyStoreType = null;
                    if (bl) break;
                }
                case 181: {
                    this._CustomTrustKeyStoreFileName = null;
                    if (bl) break;
                }
                case 183: {
                    this._CustomTrustKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 184: {
                    this._CustomTrustKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 182: {
                    this._CustomTrustKeyStoreType = null;
                    if (bl) break;
                }
                case 211: {
                    this._DataSource = new DataSourceMBeanImpl(this, 211);
                    this._postCreate((AbstractDescriptorBean)this._DataSource);
                    if (bl) break;
                }
                case 189: {
                    this._DefaultFileStore = new DefaultFileStoreMBeanImpl(this, 189);
                    this._postCreate((AbstractDescriptorBean)this._DefaultFileStore);
                    if (bl) break;
                }
                case 98: {
                    this._DefaultIIOPPasswordEncrypted = null;
                    if (bl) break;
                }
                case 99: {
                    this._DefaultIIOPPasswordEncrypted = null;
                    if (bl) break;
                }
                case 97: {
                    this._DefaultIIOPUser = null;
                    if (bl) break;
                }
                case 201: {
                    this._DefaultStagingDirName = null;
                    if (bl) break;
                }
                case 102: {
                    this._DefaultTGIOPPasswordEncrypted = null;
                    if (bl) break;
                }
                case 103: {
                    this._DefaultTGIOPPasswordEncrypted = null;
                    if (bl) break;
                }
                case 101: {
                    this._DefaultTGIOPUser = "guest";
                    if (bl) break;
                }
                case 137: {
                    this._customizer.setDomainLogFilter(null);
                    if (bl) break;
                }
                case 91: {
                    this._ExpectedToRun = true;
                    if (bl) break;
                }
                case 115: {
                    this._ExternalDNSName = null;
                    if (bl) break;
                }
                case 131: {
                    this._ExtraEjbcOptions = null;
                    if (bl) break;
                }
                case 130: {
                    this._ExtraRmicOptions = null;
                    if (bl) break;
                }
                case 203: {
                    this._FederationServices = new FederationServicesMBeanImpl(this, 203);
                    this._postCreate((AbstractDescriptorBean)this._FederationServices);
                    if (bl) break;
                }
                case 168: {
                    this._GracefulShutdownTimeout = 0;
                    if (bl) break;
                }
                case 158: {
                    this._HealthCheckIntervalSeconds = 180;
                    if (bl) break;
                }
                case 160: {
                    this._HealthCheckStartDelaySeconds = 120;
                    if (bl) break;
                }
                case 159: {
                    this._HealthCheckTimeoutSeconds = 60;
                    if (bl) break;
                }
                case 174: {
                    this._HostsMigratableServices = true;
                    if (bl) break;
                }
                case 124: {
                    this._IIOPConnectionPools = null;
                    if (bl) break;
                }
                case 116: {
                    this._InterfaceAddress = null;
                    if (bl) break;
                }
                case 192: {
                    this._JDBCLLRTableName = null;
                    if (bl) break;
                }
                case 195: {
                    this._JDBCLLRTablePoolColumnSize = 64;
                    if (bl) break;
                }
                case 196: {
                    this._JDBCLLRTableRecordColumnSize = 1000;
                    if (bl) break;
                }
                case 194: {
                    this._JDBCLLRTableXIDColumnSize = 40;
                    if (bl) break;
                }
                case 93: {
                    this._JDBCLogFileName = "jdbc.log";
                    if (bl) break;
                }
                case 197: {
                    this._JDBCLoginTimeoutSeconds = 0;
                    if (bl) break;
                }
                case 123: {
                    this._JNDITransportableObjectFactoryList = new String[0];
                    if (bl) break;
                }
                case 145: {
                    this._JTAMigratableTarget = null;
                    if (bl) break;
                }
                case 127: {
                    this._JavaCompiler = "javac";
                    if (bl) break;
                }
                case 129: {
                    this._JavaCompilerPostClassPath = null;
                    if (bl) break;
                }
                case 128: {
                    this._JavaCompilerPreClassPath = null;
                    if (bl) break;
                }
                case 185: {
                    this._JavaStandardTrustKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 186: {
                    this._JavaStandardTrustKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 48: {
                    this._KernelDebug = null;
                    if (bl) break;
                }
                case 176: {
                    this._KeyStores = "DemoIdentityAndDemoTrust";
                    if (bl) break;
                }
                case 114: {
                    this._ListenAddress = null;
                    if (bl) break;
                }
                case 144: {
                    this._ListenDelaySecs = 0;
                    if (bl) break;
                }
                case 80: {
                    this._ListenPort = 7001;
                    if (bl) break;
                }
                case 112: {
                    this._ListenThreadStartDelaySecs = 60;
                    if (bl) break;
                }
                case 113: {
                    this._ListenersBindEarly = false;
                    if (bl) break;
                }
                case 82: {
                    this._LoginTimeout = 1000;
                    if (bl) break;
                }
                case 120: {
                    this._LoginTimeoutMillis = 5000;
                    if (bl) break;
                }
                case 149: {
                    this._LowMemoryGCThreshold = 5;
                    if (bl) break;
                }
                case 148: {
                    this._LowMemoryGranularityLevel = 5;
                    if (bl) break;
                }
                case 147: {
                    this._LowMemorySampleSize = 10;
                    if (bl) break;
                }
                case 146: {
                    this._LowMemoryTimeInterval = 3600;
                    if (bl) break;
                }
                case 79: {
                    this._Machine = null;
                    if (bl) break;
                }
                case 119: {
                    this._MaxBackoffBetweenFailures = 10000;
                    if (bl) break;
                }
                case 206: {
                    this._NMSocketCreateTimeoutInMillis = 180000;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 117: {
                    this._NetworkAccessPoints = new NetworkAccessPointMBean[0];
                    if (bl) break;
                }
                case 191: {
                    this._OverloadProtection = new OverloadProtectionMBeanImpl(this, 191);
                    this._postCreate((AbstractDescriptorBean)this._OverloadProtection);
                    if (bl) break;
                }
                case 86: {
                    this._PreferredSecondaryGroup = null;
                    if (bl) break;
                }
                case 187: {
                    this._ReliableDeliveryPolicy = null;
                    if (bl) break;
                }
                case 85: {
                    this._ReplicationGroup = null;
                    if (bl) break;
                }
                case 209: {
                    this._ReplicationPorts = null;
                    if (bl) break;
                }
                case 161: {
                    this._RestartDelaySeconds = 0;
                    if (bl) break;
                }
                case 156: {
                    this._RestartIntervalSeconds = 3600;
                    if (bl) break;
                }
                case 157: {
                    this._RestartMax = 2;
                    if (bl) break;
                }
                case 78: {
                    this._RootDirectory = ".";
                    if (bl) break;
                }
                case 107: {
                    this._ServerDebug = new ServerDebugMBeanImpl(this, 107);
                    this._postCreate((AbstractDescriptorBean)this._ServerDebug);
                    if (bl) break;
                }
                case 198: {
                    this._ServerDiagnosticConfig = new WLDFServerDiagnosticMBeanImpl(this, 198);
                    this._postCreate((AbstractDescriptorBean)this._ServerDiagnosticConfig);
                    if (bl) break;
                }
                case 166: {
                    this._ServerLifeCycleTimeoutVal = 30;
                    if (bl) break;
                }
                case 77: {
                    this._ServerNames = null;
                    if (bl) break;
                }
                case 143: {
                    this._ServerStart = new ServerStartMBeanImpl(this, 143);
                    this._postCreate((AbstractDescriptorBean)this._ServerStart);
                    if (bl) break;
                }
                case 164: {
                    this._ServerVersion = "unknown";
                    if (bl) break;
                }
                case 204: {
                    this._SingleSignOnServices = new SingleSignOnServicesMBeanImpl(this, 204);
                    this._postCreate((AbstractDescriptorBean)this._SingleSignOnServices);
                    if (bl) break;
                }
                case 150: {
                    this._customizer.setStagingDirectoryName(null);
                    if (bl) break;
                }
                case 153: {
                    this._StagingMode = null;
                    if (bl) break;
                }
                case 165: {
                    this._customizer.setStartupMode("RUNNING");
                    if (bl) break;
                }
                case 167: {
                    this._StartupTimeout = 0;
                    if (bl) break;
                }
                case 60: {
                    this._customizer.setStdoutFormat("standard");
                    if (bl) break;
                }
                case 54: {
                    this._customizer.setStdoutSeverityLevel(32);
                    if (bl) break;
                }
                case 200: {
                    this._SupportedProtocols = new String[0];
                    if (bl) break;
                }
                case 109: {
                    this._SystemPasswordEncrypted = null;
                    if (bl) break;
                }
                case 110: {
                    this._SystemPasswordEncrypted = null;
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setThreadPoolSize(15);
                    if (bl) break;
                }
                case 133: {
                    this._TransactionLogFilePrefix = "./";
                    if (bl) break;
                }
                case 134: {
                    this._TransactionLogFileWritePolicy = "Direct-Write";
                    if (bl) break;
                }
                case 210: {
                    this._TransactionLogJDBCStore = new TransactionLogJDBCStoreMBeanImpl(this, 210);
                    this._postCreate((AbstractDescriptorBean)this._TransactionLogJDBCStore);
                    if (bl) break;
                }
                case 139: {
                    this._TunnelingClientPingSecs = 45;
                    if (bl) break;
                }
                case 140: {
                    this._TunnelingClientTimeoutSecs = 40;
                    if (bl) break;
                }
                case 151: {
                    this._customizer.setUploadDirectoryName(null);
                    if (bl) break;
                }
                case 132: {
                    this._VerboseEJBDeploymentEnabled = "false";
                    if (bl) break;
                }
                case 208: {
                    this._VirtualMachineName = null;
                    if (bl) break;
                }
                case 90: {
                    this._WebServer = new WebServerMBeanImpl(this, 90);
                    this._postCreate((AbstractDescriptorBean)this._WebServer);
                    if (bl) break;
                }
                case 205: {
                    this._WebService = new WebServiceMBeanImpl(this, 205);
                    this._postCreate((AbstractDescriptorBean)this._WebService);
                    if (bl) break;
                }
                case 126: {
                    this._XMLEntityCache = null;
                    if (bl) break;
                }
                case 125: {
                    this._XMLRegistry = null;
                    if (bl) break;
                }
                case 121: {
                    this._AdministrationPortEnabled = false;
                    if (bl) break;
                }
                case 88: {
                    this._AutoMigrationEnabled = false;
                    if (bl) break;
                }
                case 104: {
                    this._COMEnabled = false;
                    if (bl) break;
                }
                case 162: {
                    this._ClasspathServletDisabled = false;
                    if (bl) break;
                }
                case 172: {
                    this._ClientCertProxyEnabled = false;
                    if (bl) break;
                }
                case 111: {
                    this._ConsoleInputEnabled = false;
                    if (bl) break;
                }
                case 163: {
                    this._DefaultInternalServletsDisabled = false;
                    if (bl) break;
                }
                case 136: {
                    this._customizer.setEnabledForDomainLog(true);
                    if (bl) break;
                }
                case 175: {
                    this._HttpTraceSupportEnabled = false;
                    if (bl) break;
                }
                case 108: {
                    this._HttpdEnabled = true;
                    if (bl) break;
                }
                case 96: {
                    this._IIOPEnabled = true;
                    if (bl) break;
                }
                case 169: {
                    this._IgnoreSessionsDuringShutdown = false;
                    if (bl) break;
                }
                case 94: {
                    this._J2EE12OnlyModeEnabled = false;
                    if (bl) break;
                }
                case 95: {
                    this._J2EE13WarningEnabled = false;
                    if (bl) break;
                }
                case 92: {
                    this._JDBCLoggingEnabled = false;
                    if (bl) break;
                }
                case 142: {
                    this._JMSDefaultConnectionFactoriesEnabled = true;
                    if (bl) break;
                }
                case 105: {
                    this._JRMPEnabled = false;
                    if (bl) break;
                }
                case 81: {
                    this._ListenPortEnabled = true;
                    if (bl) break;
                }
                case 171: {
                    this._MSIFileReplicationEnabled = false;
                    if (bl) break;
                }
                case 170: {
                    this._ManagedServerIndependenceEnabled = true;
                    if (bl) break;
                }
                case 188: {
                    this._customizer.setMessageIdPrefixEnabled(true);
                    if (bl) break;
                }
                case 135: {
                    this._NetworkClassLoadingEnabled = false;
                    if (bl) break;
                }
                case 55: {
                    this._customizer.setStdoutDebugEnabled(false);
                    if (bl) break;
                }
                case 53: {
                    this._customizer.setStdoutEnabled(true);
                    if (bl) break;
                }
                case 61: {
                    this._customizer.setStdoutLogStack(true);
                    if (bl) break;
                }
                case 100: {
                    this._TGIOPEnabled = true;
                    if (bl) break;
                }
                case 138: {
                    this._TunnelingEnabled = false;
                    if (bl) break;
                }
                case 193: {
                    this._UseFusionForLLR = false;
                    if (bl) break;
                }
                case 173: {
                    this._WeblogicPluginEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Server";
    }

    public void putValue(String string, Object object) {
        if (string.equals("81StyleDefaultStagingDirName")) {
            String string2 = this._81StyleDefaultStagingDirName;
            this._81StyleDefaultStagingDirName = (String)object;
            this._postSet(202, string2, this._81StyleDefaultStagingDirName);
            return;
        }
        if (string.equals("AcceptBacklog")) {
            int n = this._AcceptBacklog;
            this._AcceptBacklog = (Integer)object;
            this._postSet(118, n, this._AcceptBacklog);
            return;
        }
        if (string.equals("ActiveDirectoryName")) {
            String string3 = this._ActiveDirectoryName;
            this._ActiveDirectoryName = (String)object;
            this._postSet(152, string3, this._ActiveDirectoryName);
            return;
        }
        if (string.equals("AdminReconnectIntervalSeconds")) {
            int n = this._AdminReconnectIntervalSeconds;
            this._AdminReconnectIntervalSeconds = (Integer)object;
            this._postSet(141, n, this._AdminReconnectIntervalSeconds);
            return;
        }
        if (string.equals("AdministrationPort")) {
            int n = this._AdministrationPort;
            this._AdministrationPort = (Integer)object;
            this._postSet(122, n, this._AdministrationPort);
            return;
        }
        if (string.equals("AdministrationPortEnabled")) {
            boolean bl = this._AdministrationPortEnabled;
            this._AdministrationPortEnabled = (Boolean)object;
            this._postSet(121, bl, this._AdministrationPortEnabled);
            return;
        }
        if (string.equals("AutoJDBCConnectionClose")) {
            String string4 = this._AutoJDBCConnectionClose;
            this._AutoJDBCConnectionClose = (String)object;
            this._postSet(199, string4, this._AutoJDBCConnectionClose);
            return;
        }
        if (string.equals("AutoKillIfFailed")) {
            boolean bl = this._AutoKillIfFailed;
            this._AutoKillIfFailed = (Boolean)object;
            this._postSet(155, bl, this._AutoKillIfFailed);
            return;
        }
        if (string.equals("AutoMigrationEnabled")) {
            boolean bl = this._AutoMigrationEnabled;
            this._AutoMigrationEnabled = (Boolean)object;
            this._postSet(88, bl, this._AutoMigrationEnabled);
            return;
        }
        if (string.equals("AutoRestart")) {
            boolean bl = this._AutoRestart;
            this._AutoRestart = (Boolean)object;
            this._postSet(154, bl, this._AutoRestart);
            return;
        }
        if (string.equals("COM")) {
            COMMBean cOMMBean = this._COM;
            this._COM = (COMMBean)object;
            this._postSet(106, cOMMBean, this._COM);
            return;
        }
        if (string.equals("COMEnabled")) {
            boolean bl = this._COMEnabled;
            this._COMEnabled = (Boolean)object;
            this._postSet(104, bl, this._COMEnabled);
            return;
        }
        if (string.equals("CandidateMachines")) {
            MachineMBean[] machineMBeanArray = this._CandidateMachines;
            this._CandidateMachines = (MachineMBean[])object;
            this._postSet(190, machineMBeanArray, this._CandidateMachines);
            return;
        }
        if (string.equals("ClasspathServletDisabled")) {
            boolean bl = this._ClasspathServletDisabled;
            this._ClasspathServletDisabled = (Boolean)object;
            this._postSet(162, bl, this._ClasspathServletDisabled);
            return;
        }
        if (string.equals("ClientCertProxyEnabled")) {
            boolean bl = this._ClientCertProxyEnabled;
            this._ClientCertProxyEnabled = (Boolean)object;
            this._postSet(172, bl, this._ClientCertProxyEnabled);
            return;
        }
        if (string.equals("Cluster")) {
            ClusterMBean clusterMBean = this._Cluster;
            this._Cluster = (ClusterMBean)object;
            this._postSet(83, clusterMBean, this._Cluster);
            return;
        }
        if (string.equals("ClusterRuntime")) {
            ClusterRuntimeMBean clusterRuntimeMBean = this._ClusterRuntime;
            this._ClusterRuntime = (ClusterRuntimeMBean)object;
            this._postSet(89, clusterRuntimeMBean, this._ClusterRuntime);
            return;
        }
        if (string.equals("ClusterWeight")) {
            int n = this._ClusterWeight;
            this._ClusterWeight = (Integer)object;
            this._postSet(84, n, this._ClusterWeight);
            return;
        }
        if (string.equals("CoherenceClusterSystemResource")) {
            CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean = this._CoherenceClusterSystemResource;
            this._CoherenceClusterSystemResource = (CoherenceClusterSystemResourceMBean)object;
            this._postSet(207, coherenceClusterSystemResourceMBean, this._CoherenceClusterSystemResource);
            return;
        }
        if (string.equals("ConsensusProcessIdentifier")) {
            int n = this._ConsensusProcessIdentifier;
            this._ConsensusProcessIdentifier = (Integer)object;
            this._postSet(87, n, this._ConsensusProcessIdentifier);
            return;
        }
        if (string.equals("ConsoleInputEnabled")) {
            boolean bl = this._ConsoleInputEnabled;
            this._ConsoleInputEnabled = (Boolean)object;
            this._postSet(111, bl, this._ConsoleInputEnabled);
            return;
        }
        if (string.equals("CustomIdentityKeyStoreFileName")) {
            String string5 = this._CustomIdentityKeyStoreFileName;
            this._CustomIdentityKeyStoreFileName = (String)object;
            this._postSet(177, string5, this._CustomIdentityKeyStoreFileName);
            return;
        }
        if (string.equals("CustomIdentityKeyStorePassPhrase")) {
            String string6 = this._CustomIdentityKeyStorePassPhrase;
            this._CustomIdentityKeyStorePassPhrase = (String)object;
            this._postSet(179, string6, this._CustomIdentityKeyStorePassPhrase);
            return;
        }
        if (string.equals("CustomIdentityKeyStorePassPhraseEncrypted")) {
            byte[] byArray = this._CustomIdentityKeyStorePassPhraseEncrypted;
            this._CustomIdentityKeyStorePassPhraseEncrypted = (byte[])object;
            this._postSet(180, byArray, this._CustomIdentityKeyStorePassPhraseEncrypted);
            return;
        }
        if (string.equals("CustomIdentityKeyStoreType")) {
            String string7 = this._CustomIdentityKeyStoreType;
            this._CustomIdentityKeyStoreType = (String)object;
            this._postSet(178, string7, this._CustomIdentityKeyStoreType);
            return;
        }
        if (string.equals("CustomTrustKeyStoreFileName")) {
            String string8 = this._CustomTrustKeyStoreFileName;
            this._CustomTrustKeyStoreFileName = (String)object;
            this._postSet(181, string8, this._CustomTrustKeyStoreFileName);
            return;
        }
        if (string.equals("CustomTrustKeyStorePassPhrase")) {
            String string9 = this._CustomTrustKeyStorePassPhrase;
            this._CustomTrustKeyStorePassPhrase = (String)object;
            this._postSet(183, string9, this._CustomTrustKeyStorePassPhrase);
            return;
        }
        if (string.equals("CustomTrustKeyStorePassPhraseEncrypted")) {
            byte[] byArray = this._CustomTrustKeyStorePassPhraseEncrypted;
            this._CustomTrustKeyStorePassPhraseEncrypted = (byte[])object;
            this._postSet(184, byArray, this._CustomTrustKeyStorePassPhraseEncrypted);
            return;
        }
        if (string.equals("CustomTrustKeyStoreType")) {
            String string10 = this._CustomTrustKeyStoreType;
            this._CustomTrustKeyStoreType = (String)object;
            this._postSet(182, string10, this._CustomTrustKeyStoreType);
            return;
        }
        if (string.equals("DataSource")) {
            DataSourceMBean dataSourceMBean = this._DataSource;
            this._DataSource = (DataSourceMBean)object;
            this._postSet(211, dataSourceMBean, this._DataSource);
            return;
        }
        if (string.equals("DefaultFileStore")) {
            DefaultFileStoreMBean defaultFileStoreMBean = this._DefaultFileStore;
            this._DefaultFileStore = (DefaultFileStoreMBean)object;
            this._postSet(189, defaultFileStoreMBean, this._DefaultFileStore);
            return;
        }
        if (string.equals("DefaultIIOPPassword")) {
            String string11 = this._DefaultIIOPPassword;
            this._DefaultIIOPPassword = (String)object;
            this._postSet(98, string11, this._DefaultIIOPPassword);
            return;
        }
        if (string.equals("DefaultIIOPPasswordEncrypted")) {
            byte[] byArray = this._DefaultIIOPPasswordEncrypted;
            this._DefaultIIOPPasswordEncrypted = (byte[])object;
            this._postSet(99, byArray, this._DefaultIIOPPasswordEncrypted);
            return;
        }
        if (string.equals("DefaultIIOPUser")) {
            String string12 = this._DefaultIIOPUser;
            this._DefaultIIOPUser = (String)object;
            this._postSet(97, string12, this._DefaultIIOPUser);
            return;
        }
        if (string.equals("DefaultInternalServletsDisabled")) {
            boolean bl = this._DefaultInternalServletsDisabled;
            this._DefaultInternalServletsDisabled = (Boolean)object;
            this._postSet(163, bl, this._DefaultInternalServletsDisabled);
            return;
        }
        if (string.equals("DefaultStagingDirName")) {
            String string13 = this._DefaultStagingDirName;
            this._DefaultStagingDirName = (String)object;
            this._postSet(201, string13, this._DefaultStagingDirName);
            return;
        }
        if (string.equals("DefaultTGIOPPassword")) {
            String string14 = this._DefaultTGIOPPassword;
            this._DefaultTGIOPPassword = (String)object;
            this._postSet(102, string14, this._DefaultTGIOPPassword);
            return;
        }
        if (string.equals("DefaultTGIOPPasswordEncrypted")) {
            byte[] byArray = this._DefaultTGIOPPasswordEncrypted;
            this._DefaultTGIOPPasswordEncrypted = (byte[])object;
            this._postSet(103, byArray, this._DefaultTGIOPPasswordEncrypted);
            return;
        }
        if (string.equals("DefaultTGIOPUser")) {
            String string15 = this._DefaultTGIOPUser;
            this._DefaultTGIOPUser = (String)object;
            this._postSet(101, string15, this._DefaultTGIOPUser);
            return;
        }
        if (string.equals("DomainLogFilter")) {
            DomainLogFilterMBean domainLogFilterMBean = this._DomainLogFilter;
            this._DomainLogFilter = (DomainLogFilterMBean)object;
            this._postSet(137, domainLogFilterMBean, this._DomainLogFilter);
            return;
        }
        if (string.equals("EnabledForDomainLog")) {
            boolean bl = this._EnabledForDomainLog;
            this._EnabledForDomainLog = (Boolean)object;
            this._postSet(136, bl, this._EnabledForDomainLog);
            return;
        }
        if (string.equals("ExpectedToRun")) {
            boolean bl = this._ExpectedToRun;
            this._ExpectedToRun = (Boolean)object;
            this._postSet(91, bl, this._ExpectedToRun);
            return;
        }
        if (string.equals("ExternalDNSName")) {
            String string16 = this._ExternalDNSName;
            this._ExternalDNSName = (String)object;
            this._postSet(115, string16, this._ExternalDNSName);
            return;
        }
        if (string.equals("ExtraEjbcOptions")) {
            String string17 = this._ExtraEjbcOptions;
            this._ExtraEjbcOptions = (String)object;
            this._postSet(131, string17, this._ExtraEjbcOptions);
            return;
        }
        if (string.equals("ExtraRmicOptions")) {
            String string18 = this._ExtraRmicOptions;
            this._ExtraRmicOptions = (String)object;
            this._postSet(130, string18, this._ExtraRmicOptions);
            return;
        }
        if (string.equals("FederationServices")) {
            FederationServicesMBean federationServicesMBean = this._FederationServices;
            this._FederationServices = (FederationServicesMBean)object;
            this._postSet(203, federationServicesMBean, this._FederationServices);
            return;
        }
        if (string.equals("GracefulShutdownTimeout")) {
            int n = this._GracefulShutdownTimeout;
            this._GracefulShutdownTimeout = (Integer)object;
            this._postSet(168, n, this._GracefulShutdownTimeout);
            return;
        }
        if (string.equals("HealthCheckIntervalSeconds")) {
            int n = this._HealthCheckIntervalSeconds;
            this._HealthCheckIntervalSeconds = (Integer)object;
            this._postSet(158, n, this._HealthCheckIntervalSeconds);
            return;
        }
        if (string.equals("HealthCheckStartDelaySeconds")) {
            int n = this._HealthCheckStartDelaySeconds;
            this._HealthCheckStartDelaySeconds = (Integer)object;
            this._postSet(160, n, this._HealthCheckStartDelaySeconds);
            return;
        }
        if (string.equals("HealthCheckTimeoutSeconds")) {
            int n = this._HealthCheckTimeoutSeconds;
            this._HealthCheckTimeoutSeconds = (Integer)object;
            this._postSet(159, n, this._HealthCheckTimeoutSeconds);
            return;
        }
        if (string.equals("HostsMigratableServices")) {
            boolean bl = this._HostsMigratableServices;
            this._HostsMigratableServices = (Boolean)object;
            this._postSet(174, bl, this._HostsMigratableServices);
            return;
        }
        if (string.equals("HttpTraceSupportEnabled")) {
            boolean bl = this._HttpTraceSupportEnabled;
            this._HttpTraceSupportEnabled = (Boolean)object;
            this._postSet(175, bl, this._HttpTraceSupportEnabled);
            return;
        }
        if (string.equals("HttpdEnabled")) {
            boolean bl = this._HttpdEnabled;
            this._HttpdEnabled = (Boolean)object;
            this._postSet(108, bl, this._HttpdEnabled);
            return;
        }
        if (string.equals("IIOPConnectionPools")) {
            Map map = this._IIOPConnectionPools;
            this._IIOPConnectionPools = (Map)object;
            this._postSet(124, map, this._IIOPConnectionPools);
            return;
        }
        if (string.equals("IIOPEnabled")) {
            boolean bl = this._IIOPEnabled;
            this._IIOPEnabled = (Boolean)object;
            this._postSet(96, bl, this._IIOPEnabled);
            return;
        }
        if (string.equals("IgnoreSessionsDuringShutdown")) {
            boolean bl = this._IgnoreSessionsDuringShutdown;
            this._IgnoreSessionsDuringShutdown = (Boolean)object;
            this._postSet(169, bl, this._IgnoreSessionsDuringShutdown);
            return;
        }
        if (string.equals("InterfaceAddress")) {
            String string19 = this._InterfaceAddress;
            this._InterfaceAddress = (String)object;
            this._postSet(116, string19, this._InterfaceAddress);
            return;
        }
        if (string.equals("J2EE12OnlyModeEnabled")) {
            boolean bl = this._J2EE12OnlyModeEnabled;
            this._J2EE12OnlyModeEnabled = (Boolean)object;
            this._postSet(94, bl, this._J2EE12OnlyModeEnabled);
            return;
        }
        if (string.equals("J2EE13WarningEnabled")) {
            boolean bl = this._J2EE13WarningEnabled;
            this._J2EE13WarningEnabled = (Boolean)object;
            this._postSet(95, bl, this._J2EE13WarningEnabled);
            return;
        }
        if (string.equals("JDBCLLRTableName")) {
            String string20 = this._JDBCLLRTableName;
            this._JDBCLLRTableName = (String)object;
            this._postSet(192, string20, this._JDBCLLRTableName);
            return;
        }
        if (string.equals("JDBCLLRTablePoolColumnSize")) {
            int n = this._JDBCLLRTablePoolColumnSize;
            this._JDBCLLRTablePoolColumnSize = (Integer)object;
            this._postSet(195, n, this._JDBCLLRTablePoolColumnSize);
            return;
        }
        if (string.equals("JDBCLLRTableRecordColumnSize")) {
            int n = this._JDBCLLRTableRecordColumnSize;
            this._JDBCLLRTableRecordColumnSize = (Integer)object;
            this._postSet(196, n, this._JDBCLLRTableRecordColumnSize);
            return;
        }
        if (string.equals("JDBCLLRTableXIDColumnSize")) {
            int n = this._JDBCLLRTableXIDColumnSize;
            this._JDBCLLRTableXIDColumnSize = (Integer)object;
            this._postSet(194, n, this._JDBCLLRTableXIDColumnSize);
            return;
        }
        if (string.equals("JDBCLogFileName")) {
            String string21 = this._JDBCLogFileName;
            this._JDBCLogFileName = (String)object;
            this._postSet(93, string21, this._JDBCLogFileName);
            return;
        }
        if (string.equals("JDBCLoggingEnabled")) {
            boolean bl = this._JDBCLoggingEnabled;
            this._JDBCLoggingEnabled = (Boolean)object;
            this._postSet(92, bl, this._JDBCLoggingEnabled);
            return;
        }
        if (string.equals("JDBCLoginTimeoutSeconds")) {
            int n = this._JDBCLoginTimeoutSeconds;
            this._JDBCLoginTimeoutSeconds = (Integer)object;
            this._postSet(197, n, this._JDBCLoginTimeoutSeconds);
            return;
        }
        if (string.equals("JMSDefaultConnectionFactoriesEnabled")) {
            boolean bl = this._JMSDefaultConnectionFactoriesEnabled;
            this._JMSDefaultConnectionFactoriesEnabled = (Boolean)object;
            this._postSet(142, bl, this._JMSDefaultConnectionFactoriesEnabled);
            return;
        }
        if (string.equals("JNDITransportableObjectFactoryList")) {
            String[] stringArray = this._JNDITransportableObjectFactoryList;
            this._JNDITransportableObjectFactoryList = (String[])object;
            this._postSet(123, stringArray, this._JNDITransportableObjectFactoryList);
            return;
        }
        if (string.equals("JRMPEnabled")) {
            boolean bl = this._JRMPEnabled;
            this._JRMPEnabled = (Boolean)object;
            this._postSet(105, bl, this._JRMPEnabled);
            return;
        }
        if (string.equals("JTAMigratableTarget")) {
            JTAMigratableTargetMBean jTAMigratableTargetMBean = this._JTAMigratableTarget;
            this._JTAMigratableTarget = (JTAMigratableTargetMBean)object;
            this._postSet(145, jTAMigratableTargetMBean, this._JTAMigratableTarget);
            return;
        }
        if (string.equals("JavaCompiler")) {
            String string22 = this._JavaCompiler;
            this._JavaCompiler = (String)object;
            this._postSet(127, string22, this._JavaCompiler);
            return;
        }
        if (string.equals("JavaCompilerPostClassPath")) {
            String string23 = this._JavaCompilerPostClassPath;
            this._JavaCompilerPostClassPath = (String)object;
            this._postSet(129, string23, this._JavaCompilerPostClassPath);
            return;
        }
        if (string.equals("JavaCompilerPreClassPath")) {
            String string24 = this._JavaCompilerPreClassPath;
            this._JavaCompilerPreClassPath = (String)object;
            this._postSet(128, string24, this._JavaCompilerPreClassPath);
            return;
        }
        if (string.equals("JavaStandardTrustKeyStorePassPhrase")) {
            String string25 = this._JavaStandardTrustKeyStorePassPhrase;
            this._JavaStandardTrustKeyStorePassPhrase = (String)object;
            this._postSet(185, string25, this._JavaStandardTrustKeyStorePassPhrase);
            return;
        }
        if (string.equals("JavaStandardTrustKeyStorePassPhraseEncrypted")) {
            byte[] byArray = this._JavaStandardTrustKeyStorePassPhraseEncrypted;
            this._JavaStandardTrustKeyStorePassPhraseEncrypted = (byte[])object;
            this._postSet(186, byArray, this._JavaStandardTrustKeyStorePassPhraseEncrypted);
            return;
        }
        if (string.equals("KernelDebug")) {
            KernelDebugMBean kernelDebugMBean = this._KernelDebug;
            this._KernelDebug = (KernelDebugMBean)object;
            this._postSet(48, kernelDebugMBean, this._KernelDebug);
            return;
        }
        if (string.equals("KeyStores")) {
            String string26 = this._KeyStores;
            this._KeyStores = (String)object;
            this._postSet(176, string26, this._KeyStores);
            return;
        }
        if (string.equals("ListenAddress")) {
            String string27 = this._ListenAddress;
            this._ListenAddress = (String)object;
            this._postSet(114, string27, this._ListenAddress);
            return;
        }
        if (string.equals("ListenDelaySecs")) {
            int n = this._ListenDelaySecs;
            this._ListenDelaySecs = (Integer)object;
            this._postSet(144, n, this._ListenDelaySecs);
            return;
        }
        if (string.equals("ListenPort")) {
            int n = this._ListenPort;
            this._ListenPort = (Integer)object;
            this._postSet(80, n, this._ListenPort);
            return;
        }
        if (string.equals("ListenPortEnabled")) {
            boolean bl = this._ListenPortEnabled;
            this._ListenPortEnabled = (Boolean)object;
            this._postSet(81, bl, this._ListenPortEnabled);
            return;
        }
        if (string.equals("ListenThreadStartDelaySecs")) {
            int n = this._ListenThreadStartDelaySecs;
            this._ListenThreadStartDelaySecs = (Integer)object;
            this._postSet(112, n, this._ListenThreadStartDelaySecs);
            return;
        }
        if (string.equals("ListenersBindEarly")) {
            boolean bl = this._ListenersBindEarly;
            this._ListenersBindEarly = (Boolean)object;
            this._postSet(113, bl, this._ListenersBindEarly);
            return;
        }
        if (string.equals("LoginTimeout")) {
            int n = this._LoginTimeout;
            this._LoginTimeout = (Integer)object;
            this._postSet(82, n, this._LoginTimeout);
            return;
        }
        if (string.equals("LoginTimeoutMillis")) {
            int n = this._LoginTimeoutMillis;
            this._LoginTimeoutMillis = (Integer)object;
            this._postSet(120, n, this._LoginTimeoutMillis);
            return;
        }
        if (string.equals("LowMemoryGCThreshold")) {
            int n = this._LowMemoryGCThreshold;
            this._LowMemoryGCThreshold = (Integer)object;
            this._postSet(149, n, this._LowMemoryGCThreshold);
            return;
        }
        if (string.equals("LowMemoryGranularityLevel")) {
            int n = this._LowMemoryGranularityLevel;
            this._LowMemoryGranularityLevel = (Integer)object;
            this._postSet(148, n, this._LowMemoryGranularityLevel);
            return;
        }
        if (string.equals("LowMemorySampleSize")) {
            int n = this._LowMemorySampleSize;
            this._LowMemorySampleSize = (Integer)object;
            this._postSet(147, n, this._LowMemorySampleSize);
            return;
        }
        if (string.equals("LowMemoryTimeInterval")) {
            int n = this._LowMemoryTimeInterval;
            this._LowMemoryTimeInterval = (Integer)object;
            this._postSet(146, n, this._LowMemoryTimeInterval);
            return;
        }
        if (string.equals("MSIFileReplicationEnabled")) {
            boolean bl = this._MSIFileReplicationEnabled;
            this._MSIFileReplicationEnabled = (Boolean)object;
            this._postSet(171, bl, this._MSIFileReplicationEnabled);
            return;
        }
        if (string.equals("Machine")) {
            MachineMBean machineMBean = this._Machine;
            this._Machine = (MachineMBean)object;
            this._postSet(79, machineMBean, this._Machine);
            return;
        }
        if (string.equals("ManagedServerIndependenceEnabled")) {
            boolean bl = this._ManagedServerIndependenceEnabled;
            this._ManagedServerIndependenceEnabled = (Boolean)object;
            this._postSet(170, bl, this._ManagedServerIndependenceEnabled);
            return;
        }
        if (string.equals("MaxBackoffBetweenFailures")) {
            int n = this._MaxBackoffBetweenFailures;
            this._MaxBackoffBetweenFailures = (Integer)object;
            this._postSet(119, n, this._MaxBackoffBetweenFailures);
            return;
        }
        if (string.equals("MessageIdPrefixEnabled")) {
            boolean bl = this._MessageIdPrefixEnabled;
            this._MessageIdPrefixEnabled = (Boolean)object;
            this._postSet(188, bl, this._MessageIdPrefixEnabled);
            return;
        }
        if (string.equals("NMSocketCreateTimeoutInMillis")) {
            int n = this._NMSocketCreateTimeoutInMillis;
            this._NMSocketCreateTimeoutInMillis = (Integer)object;
            this._postSet(206, n, this._NMSocketCreateTimeoutInMillis);
            return;
        }
        if (string.equals("Name")) {
            String string28 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string28, this._Name);
            return;
        }
        if (string.equals("NetworkAccessPoints")) {
            NetworkAccessPointMBean[] networkAccessPointMBeanArray = this._NetworkAccessPoints;
            this._NetworkAccessPoints = (NetworkAccessPointMBean[])object;
            this._postSet(117, networkAccessPointMBeanArray, this._NetworkAccessPoints);
            return;
        }
        if (string.equals("NetworkClassLoadingEnabled")) {
            boolean bl = this._NetworkClassLoadingEnabled;
            this._NetworkClassLoadingEnabled = (Boolean)object;
            this._postSet(135, bl, this._NetworkClassLoadingEnabled);
            return;
        }
        if (string.equals("OverloadProtection")) {
            OverloadProtectionMBean overloadProtectionMBean = this._OverloadProtection;
            this._OverloadProtection = (OverloadProtectionMBean)object;
            this._postSet(191, overloadProtectionMBean, this._OverloadProtection);
            return;
        }
        if (string.equals("PreferredSecondaryGroup")) {
            String string29 = this._PreferredSecondaryGroup;
            this._PreferredSecondaryGroup = (String)object;
            this._postSet(86, string29, this._PreferredSecondaryGroup);
            return;
        }
        if (string.equals("ReliableDeliveryPolicy")) {
            WSReliableDeliveryPolicyMBean wSReliableDeliveryPolicyMBean = this._ReliableDeliveryPolicy;
            this._ReliableDeliveryPolicy = (WSReliableDeliveryPolicyMBean)object;
            this._postSet(187, wSReliableDeliveryPolicyMBean, this._ReliableDeliveryPolicy);
            return;
        }
        if (string.equals("ReplicationGroup")) {
            String string30 = this._ReplicationGroup;
            this._ReplicationGroup = (String)object;
            this._postSet(85, string30, this._ReplicationGroup);
            return;
        }
        if (string.equals("ReplicationPorts")) {
            String string31 = this._ReplicationPorts;
            this._ReplicationPorts = (String)object;
            this._postSet(209, string31, this._ReplicationPorts);
            return;
        }
        if (string.equals("RestartDelaySeconds")) {
            int n = this._RestartDelaySeconds;
            this._RestartDelaySeconds = (Integer)object;
            this._postSet(161, n, this._RestartDelaySeconds);
            return;
        }
        if (string.equals("RestartIntervalSeconds")) {
            int n = this._RestartIntervalSeconds;
            this._RestartIntervalSeconds = (Integer)object;
            this._postSet(156, n, this._RestartIntervalSeconds);
            return;
        }
        if (string.equals("RestartMax")) {
            int n = this._RestartMax;
            this._RestartMax = (Integer)object;
            this._postSet(157, n, this._RestartMax);
            return;
        }
        if (string.equals("RootDirectory")) {
            String string32 = this._RootDirectory;
            this._RootDirectory = (String)object;
            this._postSet(78, string32, this._RootDirectory);
            return;
        }
        if (string.equals("ServerDebug")) {
            ServerDebugMBean serverDebugMBean = this._ServerDebug;
            this._ServerDebug = (ServerDebugMBean)object;
            this._postSet(107, serverDebugMBean, this._ServerDebug);
            return;
        }
        if (string.equals("ServerDiagnosticConfig")) {
            WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = this._ServerDiagnosticConfig;
            this._ServerDiagnosticConfig = (WLDFServerDiagnosticMBean)object;
            this._postSet(198, wLDFServerDiagnosticMBean, this._ServerDiagnosticConfig);
            return;
        }
        if (string.equals("ServerLifeCycleTimeoutVal")) {
            int n = this._ServerLifeCycleTimeoutVal;
            this._ServerLifeCycleTimeoutVal = (Integer)object;
            this._postSet(166, n, this._ServerLifeCycleTimeoutVal);
            return;
        }
        if (string.equals("ServerNames")) {
            Set set = this._ServerNames;
            this._ServerNames = (Set)object;
            this._postSet(77, set, this._ServerNames);
            return;
        }
        if (string.equals("ServerStart")) {
            ServerStartMBean serverStartMBean = this._ServerStart;
            this._ServerStart = (ServerStartMBean)object;
            this._postSet(143, serverStartMBean, this._ServerStart);
            return;
        }
        if (string.equals("ServerVersion")) {
            String string33 = this._ServerVersion;
            this._ServerVersion = (String)object;
            this._postSet(164, string33, this._ServerVersion);
            return;
        }
        if (string.equals("SingleSignOnServices")) {
            SingleSignOnServicesMBean singleSignOnServicesMBean = this._SingleSignOnServices;
            this._SingleSignOnServices = (SingleSignOnServicesMBean)object;
            this._postSet(204, singleSignOnServicesMBean, this._SingleSignOnServices);
            return;
        }
        if (string.equals("StagingDirectoryName")) {
            String string34 = this._StagingDirectoryName;
            this._StagingDirectoryName = (String)object;
            this._postSet(150, string34, this._StagingDirectoryName);
            return;
        }
        if (string.equals("StagingMode")) {
            String string35 = this._StagingMode;
            this._StagingMode = (String)object;
            this._postSet(153, string35, this._StagingMode);
            return;
        }
        if (string.equals("StartupMode")) {
            String string36 = this._StartupMode;
            this._StartupMode = (String)object;
            this._postSet(165, string36, this._StartupMode);
            return;
        }
        if (string.equals("StartupTimeout")) {
            int n = this._StartupTimeout;
            this._StartupTimeout = (Integer)object;
            this._postSet(167, n, this._StartupTimeout);
            return;
        }
        if (string.equals("StdoutDebugEnabled")) {
            boolean bl = this._StdoutDebugEnabled;
            this._StdoutDebugEnabled = (Boolean)object;
            this._postSet(55, bl, this._StdoutDebugEnabled);
            return;
        }
        if (string.equals("StdoutEnabled")) {
            boolean bl = this._StdoutEnabled;
            this._StdoutEnabled = (Boolean)object;
            this._postSet(53, bl, this._StdoutEnabled);
            return;
        }
        if (string.equals("StdoutFormat")) {
            String string37 = this._StdoutFormat;
            this._StdoutFormat = (String)object;
            this._postSet(60, string37, this._StdoutFormat);
            return;
        }
        if (string.equals("StdoutLogStack")) {
            boolean bl = this._StdoutLogStack;
            this._StdoutLogStack = (Boolean)object;
            this._postSet(61, bl, this._StdoutLogStack);
            return;
        }
        if (string.equals("StdoutSeverityLevel")) {
            int n = this._StdoutSeverityLevel;
            this._StdoutSeverityLevel = (Integer)object;
            this._postSet(54, n, this._StdoutSeverityLevel);
            return;
        }
        if (string.equals("SupportedProtocols")) {
            String[] stringArray = this._SupportedProtocols;
            this._SupportedProtocols = (String[])object;
            this._postSet(200, stringArray, this._SupportedProtocols);
            return;
        }
        if (string.equals("SystemPassword")) {
            String string38 = this._SystemPassword;
            this._SystemPassword = (String)object;
            this._postSet(109, string38, this._SystemPassword);
            return;
        }
        if (string.equals("SystemPasswordEncrypted")) {
            byte[] byArray = this._SystemPasswordEncrypted;
            this._SystemPasswordEncrypted = (byte[])object;
            this._postSet(110, byArray, this._SystemPasswordEncrypted);
            return;
        }
        if (string.equals("TGIOPEnabled")) {
            boolean bl = this._TGIOPEnabled;
            this._TGIOPEnabled = (Boolean)object;
            this._postSet(100, bl, this._TGIOPEnabled);
            return;
        }
        if (string.equals("ThreadPoolSize")) {
            int n = this._ThreadPoolSize;
            this._ThreadPoolSize = (Integer)object;
            this._postSet(12, n, this._ThreadPoolSize);
            return;
        }
        if (string.equals("TransactionLogFilePrefix")) {
            String string39 = this._TransactionLogFilePrefix;
            this._TransactionLogFilePrefix = (String)object;
            this._postSet(133, string39, this._TransactionLogFilePrefix);
            return;
        }
        if (string.equals("TransactionLogFileWritePolicy")) {
            String string40 = this._TransactionLogFileWritePolicy;
            this._TransactionLogFileWritePolicy = (String)object;
            this._postSet(134, string40, this._TransactionLogFileWritePolicy);
            return;
        }
        if (string.equals("TransactionLogJDBCStore")) {
            TransactionLogJDBCStoreMBean transactionLogJDBCStoreMBean = this._TransactionLogJDBCStore;
            this._TransactionLogJDBCStore = (TransactionLogJDBCStoreMBean)object;
            this._postSet(210, transactionLogJDBCStoreMBean, this._TransactionLogJDBCStore);
            return;
        }
        if (string.equals("TunnelingClientPingSecs")) {
            int n = this._TunnelingClientPingSecs;
            this._TunnelingClientPingSecs = (Integer)object;
            this._postSet(139, n, this._TunnelingClientPingSecs);
            return;
        }
        if (string.equals("TunnelingClientTimeoutSecs")) {
            int n = this._TunnelingClientTimeoutSecs;
            this._TunnelingClientTimeoutSecs = (Integer)object;
            this._postSet(140, n, this._TunnelingClientTimeoutSecs);
            return;
        }
        if (string.equals("TunnelingEnabled")) {
            boolean bl = this._TunnelingEnabled;
            this._TunnelingEnabled = (Boolean)object;
            this._postSet(138, bl, this._TunnelingEnabled);
            return;
        }
        if (string.equals("UploadDirectoryName")) {
            String string41 = this._UploadDirectoryName;
            this._UploadDirectoryName = (String)object;
            this._postSet(151, string41, this._UploadDirectoryName);
            return;
        }
        if (string.equals("UseFusionForLLR")) {
            boolean bl = this._UseFusionForLLR;
            this._UseFusionForLLR = (Boolean)object;
            this._postSet(193, bl, this._UseFusionForLLR);
            return;
        }
        if (string.equals("VerboseEJBDeploymentEnabled")) {
            String string42 = this._VerboseEJBDeploymentEnabled;
            this._VerboseEJBDeploymentEnabled = (String)object;
            this._postSet(132, string42, this._VerboseEJBDeploymentEnabled);
            return;
        }
        if (string.equals("VirtualMachineName")) {
            String string43 = this._VirtualMachineName;
            this._VirtualMachineName = (String)object;
            this._postSet(208, string43, this._VirtualMachineName);
            return;
        }
        if (string.equals("WebServer")) {
            WebServerMBean webServerMBean = this._WebServer;
            this._WebServer = (WebServerMBean)object;
            this._postSet(90, webServerMBean, this._WebServer);
            return;
        }
        if (string.equals("WebService")) {
            WebServiceMBean webServiceMBean = this._WebService;
            this._WebService = (WebServiceMBean)object;
            this._postSet(205, webServiceMBean, this._WebService);
            return;
        }
        if (string.equals("WeblogicPluginEnabled")) {
            boolean bl = this._WeblogicPluginEnabled;
            this._WeblogicPluginEnabled = (Boolean)object;
            this._postSet(173, bl, this._WeblogicPluginEnabled);
            return;
        }
        if (string.equals("XMLEntityCache")) {
            XMLEntityCacheMBean xMLEntityCacheMBean = this._XMLEntityCache;
            this._XMLEntityCache = (XMLEntityCacheMBean)object;
            this._postSet(126, xMLEntityCacheMBean, this._XMLEntityCache);
            return;
        }
        if (string.equals("XMLRegistry")) {
            XMLRegistryMBean xMLRegistryMBean = this._XMLRegistry;
            this._XMLRegistry = (XMLRegistryMBean)object;
            this._postSet(125, xMLRegistryMBean, this._XMLRegistry);
            return;
        }
        if (string.equals("customizer")) {
            Server server = this._customizer;
            this._customizer = (Server)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("81StyleDefaultStagingDirName")) {
            return this._81StyleDefaultStagingDirName;
        }
        if (string.equals("AcceptBacklog")) {
            return new Integer(this._AcceptBacklog);
        }
        if (string.equals("ActiveDirectoryName")) {
            return this._ActiveDirectoryName;
        }
        if (string.equals("AdminReconnectIntervalSeconds")) {
            return new Integer(this._AdminReconnectIntervalSeconds);
        }
        if (string.equals("AdministrationPort")) {
            return new Integer(this._AdministrationPort);
        }
        if (string.equals("AdministrationPortEnabled")) {
            return new Boolean(this._AdministrationPortEnabled);
        }
        if (string.equals("AutoJDBCConnectionClose")) {
            return this._AutoJDBCConnectionClose;
        }
        if (string.equals("AutoKillIfFailed")) {
            return new Boolean(this._AutoKillIfFailed);
        }
        if (string.equals("AutoMigrationEnabled")) {
            return new Boolean(this._AutoMigrationEnabled);
        }
        if (string.equals("AutoRestart")) {
            return new Boolean(this._AutoRestart);
        }
        if (string.equals("COM")) {
            return this._COM;
        }
        if (string.equals("COMEnabled")) {
            return new Boolean(this._COMEnabled);
        }
        if (string.equals("CandidateMachines")) {
            return this._CandidateMachines;
        }
        if (string.equals("ClasspathServletDisabled")) {
            return new Boolean(this._ClasspathServletDisabled);
        }
        if (string.equals("ClientCertProxyEnabled")) {
            return new Boolean(this._ClientCertProxyEnabled);
        }
        if (string.equals("Cluster")) {
            return this._Cluster;
        }
        if (string.equals("ClusterRuntime")) {
            return this._ClusterRuntime;
        }
        if (string.equals("ClusterWeight")) {
            return new Integer(this._ClusterWeight);
        }
        if (string.equals("CoherenceClusterSystemResource")) {
            return this._CoherenceClusterSystemResource;
        }
        if (string.equals("ConsensusProcessIdentifier")) {
            return new Integer(this._ConsensusProcessIdentifier);
        }
        if (string.equals("ConsoleInputEnabled")) {
            return new Boolean(this._ConsoleInputEnabled);
        }
        if (string.equals("CustomIdentityKeyStoreFileName")) {
            return this._CustomIdentityKeyStoreFileName;
        }
        if (string.equals("CustomIdentityKeyStorePassPhrase")) {
            return this._CustomIdentityKeyStorePassPhrase;
        }
        if (string.equals("CustomIdentityKeyStorePassPhraseEncrypted")) {
            return this._CustomIdentityKeyStorePassPhraseEncrypted;
        }
        if (string.equals("CustomIdentityKeyStoreType")) {
            return this._CustomIdentityKeyStoreType;
        }
        if (string.equals("CustomTrustKeyStoreFileName")) {
            return this._CustomTrustKeyStoreFileName;
        }
        if (string.equals("CustomTrustKeyStorePassPhrase")) {
            return this._CustomTrustKeyStorePassPhrase;
        }
        if (string.equals("CustomTrustKeyStorePassPhraseEncrypted")) {
            return this._CustomTrustKeyStorePassPhraseEncrypted;
        }
        if (string.equals("CustomTrustKeyStoreType")) {
            return this._CustomTrustKeyStoreType;
        }
        if (string.equals("DataSource")) {
            return this._DataSource;
        }
        if (string.equals("DefaultFileStore")) {
            return this._DefaultFileStore;
        }
        if (string.equals("DefaultIIOPPassword")) {
            return this._DefaultIIOPPassword;
        }
        if (string.equals("DefaultIIOPPasswordEncrypted")) {
            return this._DefaultIIOPPasswordEncrypted;
        }
        if (string.equals("DefaultIIOPUser")) {
            return this._DefaultIIOPUser;
        }
        if (string.equals("DefaultInternalServletsDisabled")) {
            return new Boolean(this._DefaultInternalServletsDisabled);
        }
        if (string.equals("DefaultStagingDirName")) {
            return this._DefaultStagingDirName;
        }
        if (string.equals("DefaultTGIOPPassword")) {
            return this._DefaultTGIOPPassword;
        }
        if (string.equals("DefaultTGIOPPasswordEncrypted")) {
            return this._DefaultTGIOPPasswordEncrypted;
        }
        if (string.equals("DefaultTGIOPUser")) {
            return this._DefaultTGIOPUser;
        }
        if (string.equals("DomainLogFilter")) {
            return this._DomainLogFilter;
        }
        if (string.equals("EnabledForDomainLog")) {
            return new Boolean(this._EnabledForDomainLog);
        }
        if (string.equals("ExpectedToRun")) {
            return new Boolean(this._ExpectedToRun);
        }
        if (string.equals("ExternalDNSName")) {
            return this._ExternalDNSName;
        }
        if (string.equals("ExtraEjbcOptions")) {
            return this._ExtraEjbcOptions;
        }
        if (string.equals("ExtraRmicOptions")) {
            return this._ExtraRmicOptions;
        }
        if (string.equals("FederationServices")) {
            return this._FederationServices;
        }
        if (string.equals("GracefulShutdownTimeout")) {
            return new Integer(this._GracefulShutdownTimeout);
        }
        if (string.equals("HealthCheckIntervalSeconds")) {
            return new Integer(this._HealthCheckIntervalSeconds);
        }
        if (string.equals("HealthCheckStartDelaySeconds")) {
            return new Integer(this._HealthCheckStartDelaySeconds);
        }
        if (string.equals("HealthCheckTimeoutSeconds")) {
            return new Integer(this._HealthCheckTimeoutSeconds);
        }
        if (string.equals("HostsMigratableServices")) {
            return new Boolean(this._HostsMigratableServices);
        }
        if (string.equals("HttpTraceSupportEnabled")) {
            return new Boolean(this._HttpTraceSupportEnabled);
        }
        if (string.equals("HttpdEnabled")) {
            return new Boolean(this._HttpdEnabled);
        }
        if (string.equals("IIOPConnectionPools")) {
            return this._IIOPConnectionPools;
        }
        if (string.equals("IIOPEnabled")) {
            return new Boolean(this._IIOPEnabled);
        }
        if (string.equals("IgnoreSessionsDuringShutdown")) {
            return new Boolean(this._IgnoreSessionsDuringShutdown);
        }
        if (string.equals("InterfaceAddress")) {
            return this._InterfaceAddress;
        }
        if (string.equals("J2EE12OnlyModeEnabled")) {
            return new Boolean(this._J2EE12OnlyModeEnabled);
        }
        if (string.equals("J2EE13WarningEnabled")) {
            return new Boolean(this._J2EE13WarningEnabled);
        }
        if (string.equals("JDBCLLRTableName")) {
            return this._JDBCLLRTableName;
        }
        if (string.equals("JDBCLLRTablePoolColumnSize")) {
            return new Integer(this._JDBCLLRTablePoolColumnSize);
        }
        if (string.equals("JDBCLLRTableRecordColumnSize")) {
            return new Integer(this._JDBCLLRTableRecordColumnSize);
        }
        if (string.equals("JDBCLLRTableXIDColumnSize")) {
            return new Integer(this._JDBCLLRTableXIDColumnSize);
        }
        if (string.equals("JDBCLogFileName")) {
            return this._JDBCLogFileName;
        }
        if (string.equals("JDBCLoggingEnabled")) {
            return new Boolean(this._JDBCLoggingEnabled);
        }
        if (string.equals("JDBCLoginTimeoutSeconds")) {
            return new Integer(this._JDBCLoginTimeoutSeconds);
        }
        if (string.equals("JMSDefaultConnectionFactoriesEnabled")) {
            return new Boolean(this._JMSDefaultConnectionFactoriesEnabled);
        }
        if (string.equals("JNDITransportableObjectFactoryList")) {
            return this._JNDITransportableObjectFactoryList;
        }
        if (string.equals("JRMPEnabled")) {
            return new Boolean(this._JRMPEnabled);
        }
        if (string.equals("JTAMigratableTarget")) {
            return this._JTAMigratableTarget;
        }
        if (string.equals("JavaCompiler")) {
            return this._JavaCompiler;
        }
        if (string.equals("JavaCompilerPostClassPath")) {
            return this._JavaCompilerPostClassPath;
        }
        if (string.equals("JavaCompilerPreClassPath")) {
            return this._JavaCompilerPreClassPath;
        }
        if (string.equals("JavaStandardTrustKeyStorePassPhrase")) {
            return this._JavaStandardTrustKeyStorePassPhrase;
        }
        if (string.equals("JavaStandardTrustKeyStorePassPhraseEncrypted")) {
            return this._JavaStandardTrustKeyStorePassPhraseEncrypted;
        }
        if (string.equals("KernelDebug")) {
            return this._KernelDebug;
        }
        if (string.equals("KeyStores")) {
            return this._KeyStores;
        }
        if (string.equals("ListenAddress")) {
            return this._ListenAddress;
        }
        if (string.equals("ListenDelaySecs")) {
            return new Integer(this._ListenDelaySecs);
        }
        if (string.equals("ListenPort")) {
            return new Integer(this._ListenPort);
        }
        if (string.equals("ListenPortEnabled")) {
            return new Boolean(this._ListenPortEnabled);
        }
        if (string.equals("ListenThreadStartDelaySecs")) {
            return new Integer(this._ListenThreadStartDelaySecs);
        }
        if (string.equals("ListenersBindEarly")) {
            return new Boolean(this._ListenersBindEarly);
        }
        if (string.equals("LoginTimeout")) {
            return new Integer(this._LoginTimeout);
        }
        if (string.equals("LoginTimeoutMillis")) {
            return new Integer(this._LoginTimeoutMillis);
        }
        if (string.equals("LowMemoryGCThreshold")) {
            return new Integer(this._LowMemoryGCThreshold);
        }
        if (string.equals("LowMemoryGranularityLevel")) {
            return new Integer(this._LowMemoryGranularityLevel);
        }
        if (string.equals("LowMemorySampleSize")) {
            return new Integer(this._LowMemorySampleSize);
        }
        if (string.equals("LowMemoryTimeInterval")) {
            return new Integer(this._LowMemoryTimeInterval);
        }
        if (string.equals("MSIFileReplicationEnabled")) {
            return new Boolean(this._MSIFileReplicationEnabled);
        }
        if (string.equals("Machine")) {
            return this._Machine;
        }
        if (string.equals("ManagedServerIndependenceEnabled")) {
            return new Boolean(this._ManagedServerIndependenceEnabled);
        }
        if (string.equals("MaxBackoffBetweenFailures")) {
            return new Integer(this._MaxBackoffBetweenFailures);
        }
        if (string.equals("MessageIdPrefixEnabled")) {
            return new Boolean(this._MessageIdPrefixEnabled);
        }
        if (string.equals("NMSocketCreateTimeoutInMillis")) {
            return new Integer(this._NMSocketCreateTimeoutInMillis);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NetworkAccessPoints")) {
            return this._NetworkAccessPoints;
        }
        if (string.equals("NetworkClassLoadingEnabled")) {
            return new Boolean(this._NetworkClassLoadingEnabled);
        }
        if (string.equals("OverloadProtection")) {
            return this._OverloadProtection;
        }
        if (string.equals("PreferredSecondaryGroup")) {
            return this._PreferredSecondaryGroup;
        }
        if (string.equals("ReliableDeliveryPolicy")) {
            return this._ReliableDeliveryPolicy;
        }
        if (string.equals("ReplicationGroup")) {
            return this._ReplicationGroup;
        }
        if (string.equals("ReplicationPorts")) {
            return this._ReplicationPorts;
        }
        if (string.equals("RestartDelaySeconds")) {
            return new Integer(this._RestartDelaySeconds);
        }
        if (string.equals("RestartIntervalSeconds")) {
            return new Integer(this._RestartIntervalSeconds);
        }
        if (string.equals("RestartMax")) {
            return new Integer(this._RestartMax);
        }
        if (string.equals("RootDirectory")) {
            return this._RootDirectory;
        }
        if (string.equals("ServerDebug")) {
            return this._ServerDebug;
        }
        if (string.equals("ServerDiagnosticConfig")) {
            return this._ServerDiagnosticConfig;
        }
        if (string.equals("ServerLifeCycleTimeoutVal")) {
            return new Integer(this._ServerLifeCycleTimeoutVal);
        }
        if (string.equals("ServerNames")) {
            return this._ServerNames;
        }
        if (string.equals("ServerStart")) {
            return this._ServerStart;
        }
        if (string.equals("ServerVersion")) {
            return this._ServerVersion;
        }
        if (string.equals("SingleSignOnServices")) {
            return this._SingleSignOnServices;
        }
        if (string.equals("StagingDirectoryName")) {
            return this._StagingDirectoryName;
        }
        if (string.equals("StagingMode")) {
            return this._StagingMode;
        }
        if (string.equals("StartupMode")) {
            return this._StartupMode;
        }
        if (string.equals("StartupTimeout")) {
            return new Integer(this._StartupTimeout);
        }
        if (string.equals("StdoutDebugEnabled")) {
            return new Boolean(this._StdoutDebugEnabled);
        }
        if (string.equals("StdoutEnabled")) {
            return new Boolean(this._StdoutEnabled);
        }
        if (string.equals("StdoutFormat")) {
            return this._StdoutFormat;
        }
        if (string.equals("StdoutLogStack")) {
            return new Boolean(this._StdoutLogStack);
        }
        if (string.equals("StdoutSeverityLevel")) {
            return new Integer(this._StdoutSeverityLevel);
        }
        if (string.equals("SupportedProtocols")) {
            return this._SupportedProtocols;
        }
        if (string.equals("SystemPassword")) {
            return this._SystemPassword;
        }
        if (string.equals("SystemPasswordEncrypted")) {
            return this._SystemPasswordEncrypted;
        }
        if (string.equals("TGIOPEnabled")) {
            return new Boolean(this._TGIOPEnabled);
        }
        if (string.equals("ThreadPoolSize")) {
            return new Integer(this._ThreadPoolSize);
        }
        if (string.equals("TransactionLogFilePrefix")) {
            return this._TransactionLogFilePrefix;
        }
        if (string.equals("TransactionLogFileWritePolicy")) {
            return this._TransactionLogFileWritePolicy;
        }
        if (string.equals("TransactionLogJDBCStore")) {
            return this._TransactionLogJDBCStore;
        }
        if (string.equals("TunnelingClientPingSecs")) {
            return new Integer(this._TunnelingClientPingSecs);
        }
        if (string.equals("TunnelingClientTimeoutSecs")) {
            return new Integer(this._TunnelingClientTimeoutSecs);
        }
        if (string.equals("TunnelingEnabled")) {
            return new Boolean(this._TunnelingEnabled);
        }
        if (string.equals("UploadDirectoryName")) {
            return this._UploadDirectoryName;
        }
        if (string.equals("UseFusionForLLR")) {
            return new Boolean(this._UseFusionForLLR);
        }
        if (string.equals("VerboseEJBDeploymentEnabled")) {
            return this._VerboseEJBDeploymentEnabled;
        }
        if (string.equals("VirtualMachineName")) {
            return this._VirtualMachineName;
        }
        if (string.equals("WebServer")) {
            return this._WebServer;
        }
        if (string.equals("WebService")) {
            return this._WebService;
        }
        if (string.equals("WeblogicPluginEnabled")) {
            return new Boolean(this._WeblogicPluginEnabled);
        }
        if (string.equals("XMLEntityCache")) {
            return this._XMLEntityCache;
        }
        if (string.equals("XMLRegistry")) {
            return this._XMLRegistry;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonNull((String)"TransactionLogFileWritePolicy", (Object)"Direct-Write");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property TransactionLogFileWritePolicy in ServerMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends KernelMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 33: {
                    if (string.equals("81-style-default-staging-dir-name")) {
                        return 202;
                    }
                    if (string.equals("coherence-cluster-system-resource")) {
                        return 207;
                    }
                    if (!string.equals("transaction-log-file-write-policy")) break;
                    return 134;
                }
                case 14: {
                    if (string.equals("accept-backlog")) {
                        return 118;
                    }
                    if (string.equals("cluster-weight")) {
                        return 84;
                    }
                    if (string.equals("listen-address")) {
                        return 114;
                    }
                    if (string.equals("root-directory")) {
                        return 78;
                    }
                    if (string.equals("server-version")) {
                        return 164;
                    }
                    if (!string.equals("stdout-enabled")) break;
                    return 53;
                }
                case 21: {
                    if (string.equals("active-directory-name")) {
                        return 152;
                    }
                    if (string.equals("defaulttgiop-password")) {
                        return 102;
                    }
                    if (string.equals("iiop-connection-pools")) {
                        return 124;
                    }
                    if (string.equals("jta-migratable-target")) {
                        return 145;
                    }
                    if (string.equals("restart-delay-seconds")) {
                        return 161;
                    }
                    if (string.equals("stdout-severity-level")) {
                        return 54;
                    }
                    if (string.equals("upload-directory-name")) {
                        return 151;
                    }
                    if (!string.equals("console-input-enabled")) break;
                    return 111;
                }
                case 32: {
                    if (string.equals("admin-reconnect-interval-seconds")) {
                        return 141;
                    }
                    if (string.equals("custom-trust-key-store-file-name")) {
                        return 181;
                    }
                    if (string.equals("health-check-start-delay-seconds")) {
                        return 160;
                    }
                    if (!string.equals("jdbcllr-table-record-column-size")) break;
                    return 196;
                }
                case 19: {
                    if (string.equals("administration-port")) {
                        return 122;
                    }
                    if (string.equals("auto-kill-if-failed")) {
                        return 155;
                    }
                    if (string.equals("federation-services")) {
                        return 203;
                    }
                    if (string.equals("overload-protection")) {
                        return 191;
                    }
                    if (!string.equals("listen-port-enabled")) break;
                    return 81;
                }
                case 26: {
                    if (string.equals("auto-jdbc-connection-close")) {
                        return 199;
                    }
                    if (string.equals("jdbc-login-timeout-seconds")) {
                        return 197;
                    }
                    if (string.equals("transaction-log-jdbc-store")) {
                        return 210;
                    }
                    if (string.equals("tunneling-client-ping-secs")) {
                        return 139;
                    }
                    if (string.equals("classpath-servlet-disabled")) {
                        return 162;
                    }
                    if (!string.equals("http-trace-support-enabled")) break;
                    return 175;
                }
                case 12: {
                    if (string.equals("auto-restart")) {
                        return 154;
                    }
                    if (string.equals("kernel-debug")) {
                        return 48;
                    }
                    if (string.equals("server-debug")) {
                        return 107;
                    }
                    if (string.equals("server-names")) {
                        return 77;
                    }
                    if (string.equals("server-start")) {
                        return 143;
                    }
                    if (string.equals("staging-mode")) {
                        return 153;
                    }
                    if (string.equals("startup-mode")) {
                        return 165;
                    }
                    if (string.equals("xml-registry")) {
                        return 125;
                    }
                    if (string.equals("iiop-enabled")) {
                        return 96;
                    }
                    if (!string.equals("jrmp-enabled")) break;
                    return 105;
                }
                case 3: {
                    if (!string.equals("com")) break;
                    return 106;
                }
                case 17: {
                    if (string.equals("candidate-machine")) {
                        return 190;
                    }
                    if (string.equals("defaulttgiop-user")) {
                        return 101;
                    }
                    if (string.equals("domain-log-filter")) {
                        return 137;
                    }
                    if (string.equals("interface-address")) {
                        return 116;
                    }
                    if (string.equals("listen-delay-secs")) {
                        return 144;
                    }
                    if (string.equals("replication-group")) {
                        return 85;
                    }
                    if (string.equals("replication-ports")) {
                        return 209;
                    }
                    if (string.equals("tunneling-enabled")) {
                        return 138;
                    }
                    if (!string.equals("use-fusion-forllr")) break;
                    return 193;
                }
                case 7: {
                    if (string.equals("cluster")) {
                        return 83;
                    }
                    if (!string.equals("machine")) break;
                    return 79;
                }
                case 15: {
                    if (string.equals("cluster-runtime")) {
                        return 89;
                    }
                    if (string.equals("expected-to-run")) {
                        return 91;
                    }
                    if (string.equals("startup-timeout")) {
                        return 167;
                    }
                    if (!string.equals("system-password")) break;
                    return 109;
                }
                case 28: {
                    if (string.equals("consensus-process-identifier")) {
                        return 87;
                    }
                    if (string.equals("health-check-timeout-seconds")) {
                        return 159;
                    }
                    if (string.equals("jdbcllr-tablexid-column-size")) {
                        return 194;
                    }
                    if (string.equals("java-compiler-pre-class-path")) {
                        return 128;
                    }
                    if (string.equals("low-memory-granularity-level")) {
                        return 148;
                    }
                    if (string.equals("max-backoff-between-failures")) {
                        return 119;
                    }
                    if (!string.equals("msi-file-replication-enabled")) break;
                    return 171;
                }
                case 35: {
                    if (string.equals("custom-identity-key-store-file-name")) {
                        return 177;
                    }
                    if (!string.equals("managed-server-independence-enabled")) break;
                    return 170;
                }
                case 37: {
                    if (!string.equals("custom-identity-key-store-pass-phrase")) break;
                    return 179;
                }
                case 47: {
                    if (!string.equals("custom-identity-key-store-pass-phrase-encrypted")) break;
                    return 180;
                }
                case 30: {
                    if (string.equals("custom-identity-key-store-type")) {
                        return 178;
                    }
                    if (string.equals("defaultiiop-password-encrypted")) {
                        return 99;
                    }
                    if (string.equals("jdbcllr-table-pool-column-size")) {
                        return 195;
                    }
                    if (!string.equals("listen-thread-start-delay-secs")) break;
                    return 112;
                }
                case 34: {
                    if (string.equals("custom-trust-key-store-pass-phrase")) {
                        return 183;
                    }
                    if (string.equals("nm-socket-create-timeout-in-millis")) {
                        return 206;
                    }
                    if (!string.equals("default-internal-servlets-disabled")) break;
                    return 163;
                }
                case 44: {
                    if (!string.equals("custom-trust-key-store-pass-phrase-encrypted")) break;
                    return 184;
                }
                case 27: {
                    if (string.equals("custom-trust-key-store-type")) {
                        return 182;
                    }
                    if (string.equals("transaction-log-file-prefix")) {
                        return 133;
                    }
                    if (!string.equals("administration-port-enabled")) break;
                    return 121;
                }
                case 11: {
                    if (string.equals("data-source")) {
                        return 211;
                    }
                    if (string.equals("listen-port")) {
                        return 80;
                    }
                    if (string.equals("restart-max")) {
                        return 157;
                    }
                    if (string.equals("web-service")) {
                        return 205;
                    }
                    if (!string.equals("com-enabled")) break;
                    return 104;
                }
                case 18: {
                    if (string.equals("default-file-store")) {
                        return 189;
                    }
                    if (string.equals("extra-ejbc-options")) {
                        return 131;
                    }
                    if (string.equals("extra-rmic-options")) {
                        return 130;
                    }
                    if (string.equals("jdbcllr-table-name")) {
                        return 192;
                    }
                    if (string.equals("jdbc-log-file-name")) {
                        return 93;
                    }
                    if (!string.equals("supported-protocol")) break;
                    return 200;
                }
                case 20: {
                    if (string.equals("defaultiiop-password")) {
                        return 98;
                    }
                    if (string.equals("listeners-bind-early")) {
                        return 113;
                    }
                    if (string.equals("login-timeout-millis")) {
                        return 120;
                    }
                    if (string.equals("network-access-point")) {
                        return 117;
                    }
                    if (string.equals("virtual-machine-name")) {
                        return 208;
                    }
                    if (string.equals("jdbc-logging-enabled")) {
                        return 92;
                    }
                    if (!string.equals("stdout-debug-enabled")) break;
                    return 55;
                }
                case 16: {
                    if (string.equals("defaultiiop-user")) {
                        return 97;
                    }
                    if (string.equals("externaldns-name")) {
                        return 115;
                    }
                    if (string.equals("thread-pool-size")) {
                        return 12;
                    }
                    if (string.equals("xml-entity-cache")) {
                        return 126;
                    }
                    if (!string.equals("stdout-log-stack")) break;
                    return 61;
                }
                case 24: {
                    if (string.equals("default-staging-dir-name")) {
                        return 201;
                    }
                    if (string.equals("low-memory-time-interval")) {
                        return 146;
                    }
                    if (string.equals("reliable-delivery-policy")) {
                        return 187;
                    }
                    if (string.equals("restart-interval-seconds")) {
                        return 156;
                    }
                    if (string.equals("server-diagnostic-config")) {
                        return 198;
                    }
                    if (!string.equals("j2ee12-only-mode-enabled")) break;
                    return 94;
                }
                case 31: {
                    if (string.equals("defaulttgiop-password-encrypted")) {
                        return 103;
                    }
                    if (!string.equals("ignore-sessions-during-shutdown")) break;
                    return 169;
                }
                case 25: {
                    if (string.equals("graceful-shutdown-timeout")) {
                        return 168;
                    }
                    if (string.equals("hosts-migratable-services")) {
                        return 174;
                    }
                    if (string.equals("preferred-secondary-group")) {
                        return 86;
                    }
                    if (string.equals("system-password-encrypted")) {
                        return 110;
                    }
                    if (string.equals("client-cert-proxy-enabled")) {
                        return 172;
                    }
                    if (!string.equals("message-id-prefix-enabled")) break;
                    return 188;
                }
                case 29: {
                    if (string.equals("health-check-interval-seconds")) {
                        return 158;
                    }
                    if (string.equals("java-compiler-post-class-path")) {
                        return 129;
                    }
                    if (string.equals("server-life-cycle-timeout-val")) {
                        return 166;
                    }
                    if (string.equals("tunneling-client-timeout-secs")) {
                        return 140;
                    }
                    if (string.equals("verboseejb-deployment-enabled")) {
                        return 132;
                    }
                    if (!string.equals("network-class-loading-enabled")) break;
                    return 135;
                }
                case 38: {
                    if (!string.equals("jndi-transportable-object-factory-list")) break;
                    return 123;
                }
                case 13: {
                    if (string.equals("java-compiler")) {
                        return 127;
                    }
                    if (string.equals("login-timeout")) {
                        return 82;
                    }
                    if (string.equals("stdout-format")) {
                        return 60;
                    }
                    if (string.equals("httpd-enabled")) {
                        return 108;
                    }
                    if (!string.equals("tgiop-enabled")) break;
                    return 100;
                }
                case 41: {
                    if (!string.equals("java-standard-trust-key-store-pass-phrase")) break;
                    return 185;
                }
                case 51: {
                    if (!string.equals("java-standard-trust-key-store-pass-phrase-encrypted")) break;
                    return 186;
                }
                case 10: {
                    if (string.equals("key-stores")) {
                        return 176;
                    }
                    if (!string.equals("web-server")) break;
                    return 90;
                }
                case 22: {
                    if (string.equals("low-memorygc-threshold")) {
                        return 149;
                    }
                    if (string.equals("low-memory-sample-size")) {
                        return 147;
                    }
                    if (string.equals("staging-directory-name")) {
                        return 150;
                    }
                    if (string.equals("auto-migration-enabled")) {
                        return 88;
                    }
                    if (string.equals("enabled-for-domain-log")) {
                        return 136;
                    }
                    if (!string.equals("j2ee13-warning-enabled")) break;
                    return 95;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 23: {
                    if (string.equals("single-sign-on-services")) {
                        return 204;
                    }
                    if (!string.equals("weblogic-plugin-enabled")) break;
                    return 173;
                }
                case 40: {
                    if (!string.equals("jms-default-connection-factories-enabled")) break;
                    return 142;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 106: {
                    return new COMMBeanImpl.SchemaHelper2();
                }
                case 211: {
                    return new DataSourceMBeanImpl.SchemaHelper2();
                }
                case 189: {
                    return new DefaultFileStoreMBeanImpl.SchemaHelper2();
                }
                case 58: {
                    return new ExecuteQueueMBeanImpl.SchemaHelper2();
                }
                case 203: {
                    return new FederationServicesMBeanImpl.SchemaHelper2();
                }
                case 51: {
                    return new IIOPMBeanImpl.SchemaHelper2();
                }
                case 145: {
                    return new JTAMigratableTargetMBeanImpl.SchemaHelper2();
                }
                case 52: {
                    return new LogMBeanImpl.SchemaHelper2();
                }
                case 117: {
                    return new NetworkAccessPointMBeanImpl.SchemaHelper2();
                }
                case 191: {
                    return new OverloadProtectionMBeanImpl.SchemaHelper2();
                }
                case 50: {
                    return new SSLMBeanImpl.SchemaHelper2();
                }
                case 107: {
                    return new ServerDebugMBeanImpl.SchemaHelper2();
                }
                case 198: {
                    return new WLDFServerDiagnosticMBeanImpl.SchemaHelper2();
                }
                case 143: {
                    return new ServerStartMBeanImpl.SchemaHelper2();
                }
                case 204: {
                    return new SingleSignOnServicesMBeanImpl.SchemaHelper2();
                }
                case 210: {
                    return new TransactionLogJDBCStoreMBeanImpl.SchemaHelper2();
                }
                case 90: {
                    return new WebServerMBeanImpl.SchemaHelper2();
                }
                case 205: {
                    return new WebServiceMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 202: {
                    return "81-style-default-staging-dir-name";
                }
                case 118: {
                    return "accept-backlog";
                }
                case 152: {
                    return "active-directory-name";
                }
                case 141: {
                    return "admin-reconnect-interval-seconds";
                }
                case 122: {
                    return "administration-port";
                }
                case 199: {
                    return "auto-jdbc-connection-close";
                }
                case 155: {
                    return "auto-kill-if-failed";
                }
                case 154: {
                    return "auto-restart";
                }
                case 106: {
                    return "com";
                }
                case 190: {
                    return "candidate-machine";
                }
                case 83: {
                    return "cluster";
                }
                case 89: {
                    return "cluster-runtime";
                }
                case 84: {
                    return "cluster-weight";
                }
                case 207: {
                    return "coherence-cluster-system-resource";
                }
                case 87: {
                    return "consensus-process-identifier";
                }
                case 177: {
                    return "custom-identity-key-store-file-name";
                }
                case 179: {
                    return "custom-identity-key-store-pass-phrase";
                }
                case 180: {
                    return "custom-identity-key-store-pass-phrase-encrypted";
                }
                case 178: {
                    return "custom-identity-key-store-type";
                }
                case 181: {
                    return "custom-trust-key-store-file-name";
                }
                case 183: {
                    return "custom-trust-key-store-pass-phrase";
                }
                case 184: {
                    return "custom-trust-key-store-pass-phrase-encrypted";
                }
                case 182: {
                    return "custom-trust-key-store-type";
                }
                case 211: {
                    return "data-source";
                }
                case 189: {
                    return "default-file-store";
                }
                case 98: {
                    return "defaultiiop-password";
                }
                case 99: {
                    return "defaultiiop-password-encrypted";
                }
                case 97: {
                    return "defaultiiop-user";
                }
                case 201: {
                    return "default-staging-dir-name";
                }
                case 102: {
                    return "defaulttgiop-password";
                }
                case 103: {
                    return "defaulttgiop-password-encrypted";
                }
                case 101: {
                    return "defaulttgiop-user";
                }
                case 137: {
                    return "domain-log-filter";
                }
                case 91: {
                    return "expected-to-run";
                }
                case 115: {
                    return "externaldns-name";
                }
                case 131: {
                    return "extra-ejbc-options";
                }
                case 130: {
                    return "extra-rmic-options";
                }
                case 203: {
                    return "federation-services";
                }
                case 168: {
                    return "graceful-shutdown-timeout";
                }
                case 158: {
                    return "health-check-interval-seconds";
                }
                case 160: {
                    return "health-check-start-delay-seconds";
                }
                case 159: {
                    return "health-check-timeout-seconds";
                }
                case 174: {
                    return "hosts-migratable-services";
                }
                case 124: {
                    return "iiop-connection-pools";
                }
                case 116: {
                    return "interface-address";
                }
                case 192: {
                    return "jdbcllr-table-name";
                }
                case 195: {
                    return "jdbcllr-table-pool-column-size";
                }
                case 196: {
                    return "jdbcllr-table-record-column-size";
                }
                case 194: {
                    return "jdbcllr-tablexid-column-size";
                }
                case 93: {
                    return "jdbc-log-file-name";
                }
                case 197: {
                    return "jdbc-login-timeout-seconds";
                }
                case 123: {
                    return "jndi-transportable-object-factory-list";
                }
                case 145: {
                    return "jta-migratable-target";
                }
                case 127: {
                    return "java-compiler";
                }
                case 129: {
                    return "java-compiler-post-class-path";
                }
                case 128: {
                    return "java-compiler-pre-class-path";
                }
                case 185: {
                    return "java-standard-trust-key-store-pass-phrase";
                }
                case 186: {
                    return "java-standard-trust-key-store-pass-phrase-encrypted";
                }
                case 48: {
                    return "kernel-debug";
                }
                case 176: {
                    return "key-stores";
                }
                case 114: {
                    return "listen-address";
                }
                case 144: {
                    return "listen-delay-secs";
                }
                case 80: {
                    return "listen-port";
                }
                case 112: {
                    return "listen-thread-start-delay-secs";
                }
                case 113: {
                    return "listeners-bind-early";
                }
                case 82: {
                    return "login-timeout";
                }
                case 120: {
                    return "login-timeout-millis";
                }
                case 149: {
                    return "low-memorygc-threshold";
                }
                case 148: {
                    return "low-memory-granularity-level";
                }
                case 147: {
                    return "low-memory-sample-size";
                }
                case 146: {
                    return "low-memory-time-interval";
                }
                case 79: {
                    return "machine";
                }
                case 119: {
                    return "max-backoff-between-failures";
                }
                case 206: {
                    return "nm-socket-create-timeout-in-millis";
                }
                case 2: {
                    return "name";
                }
                case 117: {
                    return "network-access-point";
                }
                case 191: {
                    return "overload-protection";
                }
                case 86: {
                    return "preferred-secondary-group";
                }
                case 187: {
                    return "reliable-delivery-policy";
                }
                case 85: {
                    return "replication-group";
                }
                case 209: {
                    return "replication-ports";
                }
                case 161: {
                    return "restart-delay-seconds";
                }
                case 156: {
                    return "restart-interval-seconds";
                }
                case 157: {
                    return "restart-max";
                }
                case 78: {
                    return "root-directory";
                }
                case 107: {
                    return "server-debug";
                }
                case 198: {
                    return "server-diagnostic-config";
                }
                case 166: {
                    return "server-life-cycle-timeout-val";
                }
                case 77: {
                    return "server-names";
                }
                case 143: {
                    return "server-start";
                }
                case 164: {
                    return "server-version";
                }
                case 204: {
                    return "single-sign-on-services";
                }
                case 150: {
                    return "staging-directory-name";
                }
                case 153: {
                    return "staging-mode";
                }
                case 165: {
                    return "startup-mode";
                }
                case 167: {
                    return "startup-timeout";
                }
                case 60: {
                    return "stdout-format";
                }
                case 54: {
                    return "stdout-severity-level";
                }
                case 200: {
                    return "supported-protocol";
                }
                case 109: {
                    return "system-password";
                }
                case 110: {
                    return "system-password-encrypted";
                }
                case 12: {
                    return "thread-pool-size";
                }
                case 133: {
                    return "transaction-log-file-prefix";
                }
                case 134: {
                    return "transaction-log-file-write-policy";
                }
                case 210: {
                    return "transaction-log-jdbc-store";
                }
                case 139: {
                    return "tunneling-client-ping-secs";
                }
                case 140: {
                    return "tunneling-client-timeout-secs";
                }
                case 151: {
                    return "upload-directory-name";
                }
                case 132: {
                    return "verboseejb-deployment-enabled";
                }
                case 208: {
                    return "virtual-machine-name";
                }
                case 90: {
                    return "web-server";
                }
                case 205: {
                    return "web-service";
                }
                case 126: {
                    return "xml-entity-cache";
                }
                case 125: {
                    return "xml-registry";
                }
                case 121: {
                    return "administration-port-enabled";
                }
                case 88: {
                    return "auto-migration-enabled";
                }
                case 104: {
                    return "com-enabled";
                }
                case 162: {
                    return "classpath-servlet-disabled";
                }
                case 172: {
                    return "client-cert-proxy-enabled";
                }
                case 111: {
                    return "console-input-enabled";
                }
                case 163: {
                    return "default-internal-servlets-disabled";
                }
                case 136: {
                    return "enabled-for-domain-log";
                }
                case 175: {
                    return "http-trace-support-enabled";
                }
                case 108: {
                    return "httpd-enabled";
                }
                case 96: {
                    return "iiop-enabled";
                }
                case 169: {
                    return "ignore-sessions-during-shutdown";
                }
                case 94: {
                    return "j2ee12-only-mode-enabled";
                }
                case 95: {
                    return "j2ee13-warning-enabled";
                }
                case 92: {
                    return "jdbc-logging-enabled";
                }
                case 142: {
                    return "jms-default-connection-factories-enabled";
                }
                case 105: {
                    return "jrmp-enabled";
                }
                case 81: {
                    return "listen-port-enabled";
                }
                case 171: {
                    return "msi-file-replication-enabled";
                }
                case 170: {
                    return "managed-server-independence-enabled";
                }
                case 188: {
                    return "message-id-prefix-enabled";
                }
                case 135: {
                    return "network-class-loading-enabled";
                }
                case 55: {
                    return "stdout-debug-enabled";
                }
                case 53: {
                    return "stdout-enabled";
                }
                case 61: {
                    return "stdout-log-stack";
                }
                case 100: {
                    return "tgiop-enabled";
                }
                case 138: {
                    return "tunneling-enabled";
                }
                case 193: {
                    return "use-fusion-forllr";
                }
                case 173: {
                    return "weblogic-plugin-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 190: {
                    return true;
                }
                case 58: {
                    return true;
                }
                case 123: {
                    return true;
                }
                case 117: {
                    return true;
                }
                case 200: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 106: {
                    return true;
                }
                case 211: {
                    return true;
                }
                case 189: {
                    return true;
                }
                case 58: {
                    return true;
                }
                case 203: {
                    return true;
                }
                case 51: {
                    return true;
                }
                case 145: {
                    return true;
                }
                case 52: {
                    return true;
                }
                case 117: {
                    return true;
                }
                case 191: {
                    return true;
                }
                case 50: {
                    return true;
                }
                case 107: {
                    return true;
                }
                case 198: {
                    return true;
                }
                case 143: {
                    return true;
                }
                case 204: {
                    return true;
                }
                case 210: {
                    return true;
                }
                case 90: {
                    return true;
                }
                case 205: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 141: {
                    return true;
                }
                case 155: {
                    return true;
                }
                case 154: {
                    return true;
                }
                case 83: {
                    return true;
                }
                case 84: {
                    return true;
                }
                case 87: {
                    return true;
                }
                case 91: {
                    return true;
                }
                case 115: {
                    return true;
                }
                case 168: {
                    return true;
                }
                case 158: {
                    return true;
                }
                case 160: {
                    return true;
                }
                case 159: {
                    return true;
                }
                case 174: {
                    return true;
                }
                case 116: {
                    return true;
                }
                case 144: {
                    return true;
                }
                case 80: {
                    return true;
                }
                case 149: {
                    return true;
                }
                case 148: {
                    return true;
                }
                case 147: {
                    return true;
                }
                case 146: {
                    return true;
                }
                case 79: {
                    return true;
                }
                case 187: {
                    return true;
                }
                case 161: {
                    return true;
                }
                case 156: {
                    return true;
                }
                case 157: {
                    return true;
                }
                case 166: {
                    return true;
                }
                case 165: {
                    return true;
                }
                case 167: {
                    return true;
                }
                case 210: {
                    return true;
                }
                case 126: {
                    return true;
                }
                case 125: {
                    return true;
                }
                case 169: {
                    return true;
                }
                case 188: {
                    return true;
                }
                case 135: {
                    return true;
                }
                case 28: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends KernelMBeanImpl.Helper {
        private ServerMBeanImpl bean;

        protected Helper(ServerMBeanImpl serverMBeanImpl) {
            super(serverMBeanImpl);
            this.bean = serverMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 202: {
                    return "81StyleDefaultStagingDirName";
                }
                case 118: {
                    return "AcceptBacklog";
                }
                case 152: {
                    return "ActiveDirectoryName";
                }
                case 141: {
                    return "AdminReconnectIntervalSeconds";
                }
                case 122: {
                    return "AdministrationPort";
                }
                case 199: {
                    return "AutoJDBCConnectionClose";
                }
                case 155: {
                    return "AutoKillIfFailed";
                }
                case 154: {
                    return "AutoRestart";
                }
                case 106: {
                    return "COM";
                }
                case 190: {
                    return "CandidateMachines";
                }
                case 83: {
                    return "Cluster";
                }
                case 89: {
                    return "ClusterRuntime";
                }
                case 84: {
                    return "ClusterWeight";
                }
                case 207: {
                    return "CoherenceClusterSystemResource";
                }
                case 87: {
                    return "ConsensusProcessIdentifier";
                }
                case 177: {
                    return "CustomIdentityKeyStoreFileName";
                }
                case 179: {
                    return "CustomIdentityKeyStorePassPhrase";
                }
                case 180: {
                    return "CustomIdentityKeyStorePassPhraseEncrypted";
                }
                case 178: {
                    return "CustomIdentityKeyStoreType";
                }
                case 181: {
                    return "CustomTrustKeyStoreFileName";
                }
                case 183: {
                    return "CustomTrustKeyStorePassPhrase";
                }
                case 184: {
                    return "CustomTrustKeyStorePassPhraseEncrypted";
                }
                case 182: {
                    return "CustomTrustKeyStoreType";
                }
                case 211: {
                    return "DataSource";
                }
                case 189: {
                    return "DefaultFileStore";
                }
                case 98: {
                    return "DefaultIIOPPassword";
                }
                case 99: {
                    return "DefaultIIOPPasswordEncrypted";
                }
                case 97: {
                    return "DefaultIIOPUser";
                }
                case 201: {
                    return "DefaultStagingDirName";
                }
                case 102: {
                    return "DefaultTGIOPPassword";
                }
                case 103: {
                    return "DefaultTGIOPPasswordEncrypted";
                }
                case 101: {
                    return "DefaultTGIOPUser";
                }
                case 137: {
                    return "DomainLogFilter";
                }
                case 91: {
                    return "ExpectedToRun";
                }
                case 115: {
                    return "ExternalDNSName";
                }
                case 131: {
                    return "ExtraEjbcOptions";
                }
                case 130: {
                    return "ExtraRmicOptions";
                }
                case 203: {
                    return "FederationServices";
                }
                case 168: {
                    return "GracefulShutdownTimeout";
                }
                case 158: {
                    return "HealthCheckIntervalSeconds";
                }
                case 160: {
                    return "HealthCheckStartDelaySeconds";
                }
                case 159: {
                    return "HealthCheckTimeoutSeconds";
                }
                case 174: {
                    return "HostsMigratableServices";
                }
                case 124: {
                    return "IIOPConnectionPools";
                }
                case 116: {
                    return "InterfaceAddress";
                }
                case 192: {
                    return "JDBCLLRTableName";
                }
                case 195: {
                    return "JDBCLLRTablePoolColumnSize";
                }
                case 196: {
                    return "JDBCLLRTableRecordColumnSize";
                }
                case 194: {
                    return "JDBCLLRTableXIDColumnSize";
                }
                case 93: {
                    return "JDBCLogFileName";
                }
                case 197: {
                    return "JDBCLoginTimeoutSeconds";
                }
                case 123: {
                    return "JNDITransportableObjectFactoryList";
                }
                case 145: {
                    return "JTAMigratableTarget";
                }
                case 127: {
                    return "JavaCompiler";
                }
                case 129: {
                    return "JavaCompilerPostClassPath";
                }
                case 128: {
                    return "JavaCompilerPreClassPath";
                }
                case 185: {
                    return "JavaStandardTrustKeyStorePassPhrase";
                }
                case 186: {
                    return "JavaStandardTrustKeyStorePassPhraseEncrypted";
                }
                case 48: {
                    return "KernelDebug";
                }
                case 176: {
                    return "KeyStores";
                }
                case 114: {
                    return "ListenAddress";
                }
                case 144: {
                    return "ListenDelaySecs";
                }
                case 80: {
                    return "ListenPort";
                }
                case 112: {
                    return "ListenThreadStartDelaySecs";
                }
                case 113: {
                    return "ListenersBindEarly";
                }
                case 82: {
                    return "LoginTimeout";
                }
                case 120: {
                    return "LoginTimeoutMillis";
                }
                case 149: {
                    return "LowMemoryGCThreshold";
                }
                case 148: {
                    return "LowMemoryGranularityLevel";
                }
                case 147: {
                    return "LowMemorySampleSize";
                }
                case 146: {
                    return "LowMemoryTimeInterval";
                }
                case 79: {
                    return "Machine";
                }
                case 119: {
                    return "MaxBackoffBetweenFailures";
                }
                case 206: {
                    return "NMSocketCreateTimeoutInMillis";
                }
                case 2: {
                    return "Name";
                }
                case 117: {
                    return "NetworkAccessPoints";
                }
                case 191: {
                    return "OverloadProtection";
                }
                case 86: {
                    return "PreferredSecondaryGroup";
                }
                case 187: {
                    return "ReliableDeliveryPolicy";
                }
                case 85: {
                    return "ReplicationGroup";
                }
                case 209: {
                    return "ReplicationPorts";
                }
                case 161: {
                    return "RestartDelaySeconds";
                }
                case 156: {
                    return "RestartIntervalSeconds";
                }
                case 157: {
                    return "RestartMax";
                }
                case 78: {
                    return "RootDirectory";
                }
                case 107: {
                    return "ServerDebug";
                }
                case 198: {
                    return "ServerDiagnosticConfig";
                }
                case 166: {
                    return "ServerLifeCycleTimeoutVal";
                }
                case 77: {
                    return "ServerNames";
                }
                case 143: {
                    return "ServerStart";
                }
                case 164: {
                    return "ServerVersion";
                }
                case 204: {
                    return "SingleSignOnServices";
                }
                case 150: {
                    return "StagingDirectoryName";
                }
                case 153: {
                    return "StagingMode";
                }
                case 165: {
                    return "StartupMode";
                }
                case 167: {
                    return "StartupTimeout";
                }
                case 60: {
                    return "StdoutFormat";
                }
                case 54: {
                    return "StdoutSeverityLevel";
                }
                case 200: {
                    return "SupportedProtocols";
                }
                case 109: {
                    return "SystemPassword";
                }
                case 110: {
                    return "SystemPasswordEncrypted";
                }
                case 12: {
                    return "ThreadPoolSize";
                }
                case 133: {
                    return "TransactionLogFilePrefix";
                }
                case 134: {
                    return "TransactionLogFileWritePolicy";
                }
                case 210: {
                    return "TransactionLogJDBCStore";
                }
                case 139: {
                    return "TunnelingClientPingSecs";
                }
                case 140: {
                    return "TunnelingClientTimeoutSecs";
                }
                case 151: {
                    return "UploadDirectoryName";
                }
                case 132: {
                    return "VerboseEJBDeploymentEnabled";
                }
                case 208: {
                    return "VirtualMachineName";
                }
                case 90: {
                    return "WebServer";
                }
                case 205: {
                    return "WebService";
                }
                case 126: {
                    return "XMLEntityCache";
                }
                case 125: {
                    return "XMLRegistry";
                }
                case 121: {
                    return "AdministrationPortEnabled";
                }
                case 88: {
                    return "AutoMigrationEnabled";
                }
                case 104: {
                    return "COMEnabled";
                }
                case 162: {
                    return "ClasspathServletDisabled";
                }
                case 172: {
                    return "ClientCertProxyEnabled";
                }
                case 111: {
                    return "ConsoleInputEnabled";
                }
                case 163: {
                    return "DefaultInternalServletsDisabled";
                }
                case 136: {
                    return "EnabledForDomainLog";
                }
                case 175: {
                    return "HttpTraceSupportEnabled";
                }
                case 108: {
                    return "HttpdEnabled";
                }
                case 96: {
                    return "IIOPEnabled";
                }
                case 169: {
                    return "IgnoreSessionsDuringShutdown";
                }
                case 94: {
                    return "J2EE12OnlyModeEnabled";
                }
                case 95: {
                    return "J2EE13WarningEnabled";
                }
                case 92: {
                    return "JDBCLoggingEnabled";
                }
                case 142: {
                    return "JMSDefaultConnectionFactoriesEnabled";
                }
                case 105: {
                    return "JRMPEnabled";
                }
                case 81: {
                    return "ListenPortEnabled";
                }
                case 171: {
                    return "MSIFileReplicationEnabled";
                }
                case 170: {
                    return "ManagedServerIndependenceEnabled";
                }
                case 188: {
                    return "MessageIdPrefixEnabled";
                }
                case 135: {
                    return "NetworkClassLoadingEnabled";
                }
                case 55: {
                    return "StdoutDebugEnabled";
                }
                case 53: {
                    return "StdoutEnabled";
                }
                case 61: {
                    return "StdoutLogStack";
                }
                case 100: {
                    return "TGIOPEnabled";
                }
                case 138: {
                    return "TunnelingEnabled";
                }
                case 193: {
                    return "UseFusionForLLR";
                }
                case 173: {
                    return "WeblogicPluginEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("81StyleDefaultStagingDirName")) {
                return 202;
            }
            if (string.equals("AcceptBacklog")) {
                return 118;
            }
            if (string.equals("ActiveDirectoryName")) {
                return 152;
            }
            if (string.equals("AdminReconnectIntervalSeconds")) {
                return 141;
            }
            if (string.equals("AdministrationPort")) {
                return 122;
            }
            if (string.equals("AutoJDBCConnectionClose")) {
                return 199;
            }
            if (string.equals("AutoKillIfFailed")) {
                return 155;
            }
            if (string.equals("AutoRestart")) {
                return 154;
            }
            if (string.equals("COM")) {
                return 106;
            }
            if (string.equals("CandidateMachines")) {
                return 190;
            }
            if (string.equals("Cluster")) {
                return 83;
            }
            if (string.equals("ClusterRuntime")) {
                return 89;
            }
            if (string.equals("ClusterWeight")) {
                return 84;
            }
            if (string.equals("CoherenceClusterSystemResource")) {
                return 207;
            }
            if (string.equals("ConsensusProcessIdentifier")) {
                return 87;
            }
            if (string.equals("CustomIdentityKeyStoreFileName")) {
                return 177;
            }
            if (string.equals("CustomIdentityKeyStorePassPhrase")) {
                return 179;
            }
            if (string.equals("CustomIdentityKeyStorePassPhraseEncrypted")) {
                return 180;
            }
            if (string.equals("CustomIdentityKeyStoreType")) {
                return 178;
            }
            if (string.equals("CustomTrustKeyStoreFileName")) {
                return 181;
            }
            if (string.equals("CustomTrustKeyStorePassPhrase")) {
                return 183;
            }
            if (string.equals("CustomTrustKeyStorePassPhraseEncrypted")) {
                return 184;
            }
            if (string.equals("CustomTrustKeyStoreType")) {
                return 182;
            }
            if (string.equals("DataSource")) {
                return 211;
            }
            if (string.equals("DefaultFileStore")) {
                return 189;
            }
            if (string.equals("DefaultIIOPPassword")) {
                return 98;
            }
            if (string.equals("DefaultIIOPPasswordEncrypted")) {
                return 99;
            }
            if (string.equals("DefaultIIOPUser")) {
                return 97;
            }
            if (string.equals("DefaultStagingDirName")) {
                return 201;
            }
            if (string.equals("DefaultTGIOPPassword")) {
                return 102;
            }
            if (string.equals("DefaultTGIOPPasswordEncrypted")) {
                return 103;
            }
            if (string.equals("DefaultTGIOPUser")) {
                return 101;
            }
            if (string.equals("DomainLogFilter")) {
                return 137;
            }
            if (string.equals("ExpectedToRun")) {
                return 91;
            }
            if (string.equals("ExternalDNSName")) {
                return 115;
            }
            if (string.equals("ExtraEjbcOptions")) {
                return 131;
            }
            if (string.equals("ExtraRmicOptions")) {
                return 130;
            }
            if (string.equals("FederationServices")) {
                return 203;
            }
            if (string.equals("GracefulShutdownTimeout")) {
                return 168;
            }
            if (string.equals("HealthCheckIntervalSeconds")) {
                return 158;
            }
            if (string.equals("HealthCheckStartDelaySeconds")) {
                return 160;
            }
            if (string.equals("HealthCheckTimeoutSeconds")) {
                return 159;
            }
            if (string.equals("HostsMigratableServices")) {
                return 174;
            }
            if (string.equals("IIOPConnectionPools")) {
                return 124;
            }
            if (string.equals("InterfaceAddress")) {
                return 116;
            }
            if (string.equals("JDBCLLRTableName")) {
                return 192;
            }
            if (string.equals("JDBCLLRTablePoolColumnSize")) {
                return 195;
            }
            if (string.equals("JDBCLLRTableRecordColumnSize")) {
                return 196;
            }
            if (string.equals("JDBCLLRTableXIDColumnSize")) {
                return 194;
            }
            if (string.equals("JDBCLogFileName")) {
                return 93;
            }
            if (string.equals("JDBCLoginTimeoutSeconds")) {
                return 197;
            }
            if (string.equals("JNDITransportableObjectFactoryList")) {
                return 123;
            }
            if (string.equals("JTAMigratableTarget")) {
                return 145;
            }
            if (string.equals("JavaCompiler")) {
                return 127;
            }
            if (string.equals("JavaCompilerPostClassPath")) {
                return 129;
            }
            if (string.equals("JavaCompilerPreClassPath")) {
                return 128;
            }
            if (string.equals("JavaStandardTrustKeyStorePassPhrase")) {
                return 185;
            }
            if (string.equals("JavaStandardTrustKeyStorePassPhraseEncrypted")) {
                return 186;
            }
            if (string.equals("KernelDebug")) {
                return 48;
            }
            if (string.equals("KeyStores")) {
                return 176;
            }
            if (string.equals("ListenAddress")) {
                return 114;
            }
            if (string.equals("ListenDelaySecs")) {
                return 144;
            }
            if (string.equals("ListenPort")) {
                return 80;
            }
            if (string.equals("ListenThreadStartDelaySecs")) {
                return 112;
            }
            if (string.equals("ListenersBindEarly")) {
                return 113;
            }
            if (string.equals("LoginTimeout")) {
                return 82;
            }
            if (string.equals("LoginTimeoutMillis")) {
                return 120;
            }
            if (string.equals("LowMemoryGCThreshold")) {
                return 149;
            }
            if (string.equals("LowMemoryGranularityLevel")) {
                return 148;
            }
            if (string.equals("LowMemorySampleSize")) {
                return 147;
            }
            if (string.equals("LowMemoryTimeInterval")) {
                return 146;
            }
            if (string.equals("Machine")) {
                return 79;
            }
            if (string.equals("MaxBackoffBetweenFailures")) {
                return 119;
            }
            if (string.equals("NMSocketCreateTimeoutInMillis")) {
                return 206;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("NetworkAccessPoints")) {
                return 117;
            }
            if (string.equals("OverloadProtection")) {
                return 191;
            }
            if (string.equals("PreferredSecondaryGroup")) {
                return 86;
            }
            if (string.equals("ReliableDeliveryPolicy")) {
                return 187;
            }
            if (string.equals("ReplicationGroup")) {
                return 85;
            }
            if (string.equals("ReplicationPorts")) {
                return 209;
            }
            if (string.equals("RestartDelaySeconds")) {
                return 161;
            }
            if (string.equals("RestartIntervalSeconds")) {
                return 156;
            }
            if (string.equals("RestartMax")) {
                return 157;
            }
            if (string.equals("RootDirectory")) {
                return 78;
            }
            if (string.equals("ServerDebug")) {
                return 107;
            }
            if (string.equals("ServerDiagnosticConfig")) {
                return 198;
            }
            if (string.equals("ServerLifeCycleTimeoutVal")) {
                return 166;
            }
            if (string.equals("ServerNames")) {
                return 77;
            }
            if (string.equals("ServerStart")) {
                return 143;
            }
            if (string.equals("ServerVersion")) {
                return 164;
            }
            if (string.equals("SingleSignOnServices")) {
                return 204;
            }
            if (string.equals("StagingDirectoryName")) {
                return 150;
            }
            if (string.equals("StagingMode")) {
                return 153;
            }
            if (string.equals("StartupMode")) {
                return 165;
            }
            if (string.equals("StartupTimeout")) {
                return 167;
            }
            if (string.equals("StdoutFormat")) {
                return 60;
            }
            if (string.equals("StdoutSeverityLevel")) {
                return 54;
            }
            if (string.equals("SupportedProtocols")) {
                return 200;
            }
            if (string.equals("SystemPassword")) {
                return 109;
            }
            if (string.equals("SystemPasswordEncrypted")) {
                return 110;
            }
            if (string.equals("ThreadPoolSize")) {
                return 12;
            }
            if (string.equals("TransactionLogFilePrefix")) {
                return 133;
            }
            if (string.equals("TransactionLogFileWritePolicy")) {
                return 134;
            }
            if (string.equals("TransactionLogJDBCStore")) {
                return 210;
            }
            if (string.equals("TunnelingClientPingSecs")) {
                return 139;
            }
            if (string.equals("TunnelingClientTimeoutSecs")) {
                return 140;
            }
            if (string.equals("UploadDirectoryName")) {
                return 151;
            }
            if (string.equals("VerboseEJBDeploymentEnabled")) {
                return 132;
            }
            if (string.equals("VirtualMachineName")) {
                return 208;
            }
            if (string.equals("WebServer")) {
                return 90;
            }
            if (string.equals("WebService")) {
                return 205;
            }
            if (string.equals("XMLEntityCache")) {
                return 126;
            }
            if (string.equals("XMLRegistry")) {
                return 125;
            }
            if (string.equals("AdministrationPortEnabled")) {
                return 121;
            }
            if (string.equals("AutoMigrationEnabled")) {
                return 88;
            }
            if (string.equals("COMEnabled")) {
                return 104;
            }
            if (string.equals("ClasspathServletDisabled")) {
                return 162;
            }
            if (string.equals("ClientCertProxyEnabled")) {
                return 172;
            }
            if (string.equals("ConsoleInputEnabled")) {
                return 111;
            }
            if (string.equals("DefaultInternalServletsDisabled")) {
                return 163;
            }
            if (string.equals("EnabledForDomainLog")) {
                return 136;
            }
            if (string.equals("HttpTraceSupportEnabled")) {
                return 175;
            }
            if (string.equals("HttpdEnabled")) {
                return 108;
            }
            if (string.equals("IIOPEnabled")) {
                return 96;
            }
            if (string.equals("IgnoreSessionsDuringShutdown")) {
                return 169;
            }
            if (string.equals("J2EE12OnlyModeEnabled")) {
                return 94;
            }
            if (string.equals("J2EE13WarningEnabled")) {
                return 95;
            }
            if (string.equals("JDBCLoggingEnabled")) {
                return 92;
            }
            if (string.equals("JMSDefaultConnectionFactoriesEnabled")) {
                return 142;
            }
            if (string.equals("JRMPEnabled")) {
                return 105;
            }
            if (string.equals("ListenPortEnabled")) {
                return 81;
            }
            if (string.equals("MSIFileReplicationEnabled")) {
                return 171;
            }
            if (string.equals("ManagedServerIndependenceEnabled")) {
                return 170;
            }
            if (string.equals("MessageIdPrefixEnabled")) {
                return 188;
            }
            if (string.equals("NetworkClassLoadingEnabled")) {
                return 135;
            }
            if (string.equals("StdoutDebugEnabled")) {
                return 55;
            }
            if (string.equals("StdoutEnabled")) {
                return 53;
            }
            if (string.equals("StdoutLogStack")) {
                return 61;
            }
            if (string.equals("TGIOPEnabled")) {
                return 100;
            }
            if (string.equals("TunnelingEnabled")) {
                return 138;
            }
            if (string.equals("UseFusionForLLR")) {
                return 193;
            }
            if (string.equals("WeblogicPluginEnabled")) {
                return 173;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getCOM() != null) {
                arrayList.add(new ArrayIterator((Object[])new COMMBean[]{this.bean.getCOM()}));
            }
            if (this.bean.getDataSource() != null) {
                arrayList.add(new ArrayIterator((Object[])new DataSourceMBean[]{this.bean.getDataSource()}));
            }
            if (this.bean.getDefaultFileStore() != null) {
                arrayList.add(new ArrayIterator((Object[])new DefaultFileStoreMBean[]{this.bean.getDefaultFileStore()}));
            }
            arrayList.add(new ArrayIterator((Object[])this.bean.getExecuteQueues()));
            if (this.bean.getFederationServices() != null) {
                arrayList.add(new ArrayIterator((Object[])new FederationServicesMBean[]{this.bean.getFederationServices()}));
            }
            if (this.bean.getIIOP() != null) {
                arrayList.add(new ArrayIterator((Object[])new IIOPMBean[]{this.bean.getIIOP()}));
            }
            if (this.bean.getJTAMigratableTarget() != null) {
                arrayList.add(new ArrayIterator((Object[])new JTAMigratableTargetMBean[]{this.bean.getJTAMigratableTarget()}));
            }
            if (this.bean.getLog() != null) {
                arrayList.add(new ArrayIterator((Object[])new LogMBean[]{this.bean.getLog()}));
            }
            arrayList.add(new ArrayIterator((Object[])this.bean.getNetworkAccessPoints()));
            if (this.bean.getOverloadProtection() != null) {
                arrayList.add(new ArrayIterator((Object[])new OverloadProtectionMBean[]{this.bean.getOverloadProtection()}));
            }
            if (this.bean.getSSL() != null) {
                arrayList.add(new ArrayIterator((Object[])new SSLMBean[]{this.bean.getSSL()}));
            }
            if (this.bean.getServerDebug() != null) {
                arrayList.add(new ArrayIterator((Object[])new ServerDebugMBean[]{this.bean.getServerDebug()}));
            }
            if (this.bean.getServerDiagnosticConfig() != null) {
                arrayList.add(new ArrayIterator((Object[])new WLDFServerDiagnosticMBean[]{this.bean.getServerDiagnosticConfig()}));
            }
            if (this.bean.getServerStart() != null) {
                arrayList.add(new ArrayIterator((Object[])new ServerStartMBean[]{this.bean.getServerStart()}));
            }
            if (this.bean.getSingleSignOnServices() != null) {
                arrayList.add(new ArrayIterator((Object[])new SingleSignOnServicesMBean[]{this.bean.getSingleSignOnServices()}));
            }
            if (this.bean.getTransactionLogJDBCStore() != null) {
                arrayList.add(new ArrayIterator((Object[])new TransactionLogJDBCStoreMBean[]{this.bean.getTransactionLogJDBCStore()}));
            }
            if (this.bean.getWebServer() != null) {
                arrayList.add(new ArrayIterator((Object[])new WebServerMBean[]{this.bean.getWebServer()}));
            }
            if (this.bean.getWebService() != null) {
                arrayList.add(new ArrayIterator((Object[])new WebServiceMBean[]{this.bean.getWebService()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.is81StyleDefaultStagingDirNameSet()) {
                    stringBuffer.append("81StyleDefaultStagingDirName");
                    stringBuffer.append(String.valueOf(this.bean.get81StyleDefaultStagingDirName()));
                }
                if (this.bean.isAcceptBacklogSet()) {
                    stringBuffer.append("AcceptBacklog");
                    stringBuffer.append(String.valueOf(this.bean.getAcceptBacklog()));
                }
                if (this.bean.isActiveDirectoryNameSet()) {
                    stringBuffer.append("ActiveDirectoryName");
                    stringBuffer.append(String.valueOf(this.bean.getActiveDirectoryName()));
                }
                if (this.bean.isAdminReconnectIntervalSecondsSet()) {
                    stringBuffer.append("AdminReconnectIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getAdminReconnectIntervalSeconds()));
                }
                if (this.bean.isAdministrationPortSet()) {
                    stringBuffer.append("AdministrationPort");
                    stringBuffer.append(String.valueOf(this.bean.getAdministrationPort()));
                }
                if (this.bean.isAutoJDBCConnectionCloseSet()) {
                    stringBuffer.append("AutoJDBCConnectionClose");
                    stringBuffer.append(String.valueOf(this.bean.getAutoJDBCConnectionClose()));
                }
                if (this.bean.isAutoKillIfFailedSet()) {
                    stringBuffer.append("AutoKillIfFailed");
                    stringBuffer.append(String.valueOf(this.bean.getAutoKillIfFailed()));
                }
                if (this.bean.isAutoRestartSet()) {
                    stringBuffer.append("AutoRestart");
                    stringBuffer.append(String.valueOf(this.bean.getAutoRestart()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getCOM())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isCandidateMachinesSet()) {
                    stringBuffer.append("CandidateMachines");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getCandidateMachines())));
                }
                if (this.bean.isClusterSet()) {
                    stringBuffer.append("Cluster");
                    stringBuffer.append(String.valueOf(this.bean.getCluster()));
                }
                if (this.bean.isClusterRuntimeSet()) {
                    stringBuffer.append("ClusterRuntime");
                    stringBuffer.append(String.valueOf(this.bean.getClusterRuntime()));
                }
                if (this.bean.isClusterWeightSet()) {
                    stringBuffer.append("ClusterWeight");
                    stringBuffer.append(String.valueOf(this.bean.getClusterWeight()));
                }
                if (this.bean.isCoherenceClusterSystemResourceSet()) {
                    stringBuffer.append("CoherenceClusterSystemResource");
                    stringBuffer.append(String.valueOf(this.bean.getCoherenceClusterSystemResource()));
                }
                if (this.bean.isConsensusProcessIdentifierSet()) {
                    stringBuffer.append("ConsensusProcessIdentifier");
                    stringBuffer.append(String.valueOf(this.bean.getConsensusProcessIdentifier()));
                }
                if (this.bean.isCustomIdentityKeyStoreFileNameSet()) {
                    stringBuffer.append("CustomIdentityKeyStoreFileName");
                    stringBuffer.append(String.valueOf(this.bean.getCustomIdentityKeyStoreFileName()));
                }
                if (this.bean.isCustomIdentityKeyStorePassPhraseSet()) {
                    stringBuffer.append("CustomIdentityKeyStorePassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getCustomIdentityKeyStorePassPhrase()));
                }
                if (this.bean.isCustomIdentityKeyStorePassPhraseEncryptedSet()) {
                    stringBuffer.append("CustomIdentityKeyStorePassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getCustomIdentityKeyStorePassPhraseEncrypted())));
                }
                if (this.bean.isCustomIdentityKeyStoreTypeSet()) {
                    stringBuffer.append("CustomIdentityKeyStoreType");
                    stringBuffer.append(String.valueOf(this.bean.getCustomIdentityKeyStoreType()));
                }
                if (this.bean.isCustomTrustKeyStoreFileNameSet()) {
                    stringBuffer.append("CustomTrustKeyStoreFileName");
                    stringBuffer.append(String.valueOf(this.bean.getCustomTrustKeyStoreFileName()));
                }
                if (this.bean.isCustomTrustKeyStorePassPhraseSet()) {
                    stringBuffer.append("CustomTrustKeyStorePassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getCustomTrustKeyStorePassPhrase()));
                }
                if (this.bean.isCustomTrustKeyStorePassPhraseEncryptedSet()) {
                    stringBuffer.append("CustomTrustKeyStorePassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getCustomTrustKeyStorePassPhraseEncrypted())));
                }
                if (this.bean.isCustomTrustKeyStoreTypeSet()) {
                    stringBuffer.append("CustomTrustKeyStoreType");
                    stringBuffer.append(String.valueOf(this.bean.getCustomTrustKeyStoreType()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getDataSource())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getDefaultFileStore())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isDefaultIIOPPasswordSet()) {
                    stringBuffer.append("DefaultIIOPPassword");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultIIOPPassword()));
                }
                if (this.bean.isDefaultIIOPPasswordEncryptedSet()) {
                    stringBuffer.append("DefaultIIOPPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getDefaultIIOPPasswordEncrypted())));
                }
                if (this.bean.isDefaultIIOPUserSet()) {
                    stringBuffer.append("DefaultIIOPUser");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultIIOPUser()));
                }
                if (this.bean.isDefaultStagingDirNameSet()) {
                    stringBuffer.append("DefaultStagingDirName");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultStagingDirName()));
                }
                if (this.bean.isDefaultTGIOPPasswordSet()) {
                    stringBuffer.append("DefaultTGIOPPassword");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultTGIOPPassword()));
                }
                if (this.bean.isDefaultTGIOPPasswordEncryptedSet()) {
                    stringBuffer.append("DefaultTGIOPPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getDefaultTGIOPPasswordEncrypted())));
                }
                if (this.bean.isDefaultTGIOPUserSet()) {
                    stringBuffer.append("DefaultTGIOPUser");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultTGIOPUser()));
                }
                if (this.bean.isDomainLogFilterSet()) {
                    stringBuffer.append("DomainLogFilter");
                    stringBuffer.append(String.valueOf(this.bean.getDomainLogFilter()));
                }
                if (this.bean.isExpectedToRunSet()) {
                    stringBuffer.append("ExpectedToRun");
                    stringBuffer.append(String.valueOf(this.bean.getExpectedToRun()));
                }
                if (this.bean.isExternalDNSNameSet()) {
                    stringBuffer.append("ExternalDNSName");
                    stringBuffer.append(String.valueOf(this.bean.getExternalDNSName()));
                }
                if (this.bean.isExtraEjbcOptionsSet()) {
                    stringBuffer.append("ExtraEjbcOptions");
                    stringBuffer.append(String.valueOf(this.bean.getExtraEjbcOptions()));
                }
                if (this.bean.isExtraRmicOptionsSet()) {
                    stringBuffer.append("ExtraRmicOptions");
                    stringBuffer.append(String.valueOf(this.bean.getExtraRmicOptions()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getFederationServices())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isGracefulShutdownTimeoutSet()) {
                    stringBuffer.append("GracefulShutdownTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getGracefulShutdownTimeout()));
                }
                if (this.bean.isHealthCheckIntervalSecondsSet()) {
                    stringBuffer.append("HealthCheckIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getHealthCheckIntervalSeconds()));
                }
                if (this.bean.isHealthCheckStartDelaySecondsSet()) {
                    stringBuffer.append("HealthCheckStartDelaySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getHealthCheckStartDelaySeconds()));
                }
                if (this.bean.isHealthCheckTimeoutSecondsSet()) {
                    stringBuffer.append("HealthCheckTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getHealthCheckTimeoutSeconds()));
                }
                if (this.bean.isHostsMigratableServicesSet()) {
                    stringBuffer.append("HostsMigratableServices");
                    stringBuffer.append(String.valueOf(this.bean.getHostsMigratableServices()));
                }
                if (this.bean.isIIOPConnectionPoolsSet()) {
                    stringBuffer.append("IIOPConnectionPools");
                    stringBuffer.append(String.valueOf(this.bean.getIIOPConnectionPools()));
                }
                if (this.bean.isInterfaceAddressSet()) {
                    stringBuffer.append("InterfaceAddress");
                    stringBuffer.append(String.valueOf(this.bean.getInterfaceAddress()));
                }
                if (this.bean.isJDBCLLRTableNameSet()) {
                    stringBuffer.append("JDBCLLRTableName");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCLLRTableName()));
                }
                if (this.bean.isJDBCLLRTablePoolColumnSizeSet()) {
                    stringBuffer.append("JDBCLLRTablePoolColumnSize");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCLLRTablePoolColumnSize()));
                }
                if (this.bean.isJDBCLLRTableRecordColumnSizeSet()) {
                    stringBuffer.append("JDBCLLRTableRecordColumnSize");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCLLRTableRecordColumnSize()));
                }
                if (this.bean.isJDBCLLRTableXIDColumnSizeSet()) {
                    stringBuffer.append("JDBCLLRTableXIDColumnSize");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCLLRTableXIDColumnSize()));
                }
                if (this.bean.isJDBCLogFileNameSet()) {
                    stringBuffer.append("JDBCLogFileName");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCLogFileName()));
                }
                if (this.bean.isJDBCLoginTimeoutSecondsSet()) {
                    stringBuffer.append("JDBCLoginTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCLoginTimeoutSeconds()));
                }
                if (this.bean.isJNDITransportableObjectFactoryListSet()) {
                    stringBuffer.append("JNDITransportableObjectFactoryList");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getJNDITransportableObjectFactoryList())));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getJTAMigratableTarget())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isJavaCompilerSet()) {
                    stringBuffer.append("JavaCompiler");
                    stringBuffer.append(String.valueOf(this.bean.getJavaCompiler()));
                }
                if (this.bean.isJavaCompilerPostClassPathSet()) {
                    stringBuffer.append("JavaCompilerPostClassPath");
                    stringBuffer.append(String.valueOf(this.bean.getJavaCompilerPostClassPath()));
                }
                if (this.bean.isJavaCompilerPreClassPathSet()) {
                    stringBuffer.append("JavaCompilerPreClassPath");
                    stringBuffer.append(String.valueOf(this.bean.getJavaCompilerPreClassPath()));
                }
                if (this.bean.isJavaStandardTrustKeyStorePassPhraseSet()) {
                    stringBuffer.append("JavaStandardTrustKeyStorePassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getJavaStandardTrustKeyStorePassPhrase()));
                }
                if (this.bean.isJavaStandardTrustKeyStorePassPhraseEncryptedSet()) {
                    stringBuffer.append("JavaStandardTrustKeyStorePassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getJavaStandardTrustKeyStorePassPhraseEncrypted())));
                }
                if (this.bean.isKernelDebugSet()) {
                    stringBuffer.append("KernelDebug");
                    stringBuffer.append(String.valueOf(this.bean.getKernelDebug()));
                }
                if (this.bean.isKeyStoresSet()) {
                    stringBuffer.append("KeyStores");
                    stringBuffer.append(String.valueOf(this.bean.getKeyStores()));
                }
                if (this.bean.isListenAddressSet()) {
                    stringBuffer.append("ListenAddress");
                    stringBuffer.append(String.valueOf(this.bean.getListenAddress()));
                }
                if (this.bean.isListenDelaySecsSet()) {
                    stringBuffer.append("ListenDelaySecs");
                    stringBuffer.append(String.valueOf(this.bean.getListenDelaySecs()));
                }
                if (this.bean.isListenPortSet()) {
                    stringBuffer.append("ListenPort");
                    stringBuffer.append(String.valueOf(this.bean.getListenPort()));
                }
                if (this.bean.isListenThreadStartDelaySecsSet()) {
                    stringBuffer.append("ListenThreadStartDelaySecs");
                    stringBuffer.append(String.valueOf(this.bean.getListenThreadStartDelaySecs()));
                }
                if (this.bean.isListenersBindEarlySet()) {
                    stringBuffer.append("ListenersBindEarly");
                    stringBuffer.append(String.valueOf(this.bean.getListenersBindEarly()));
                }
                if (this.bean.isLoginTimeoutSet()) {
                    stringBuffer.append("LoginTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getLoginTimeout()));
                }
                if (this.bean.isLoginTimeoutMillisSet()) {
                    stringBuffer.append("LoginTimeoutMillis");
                    stringBuffer.append(String.valueOf(this.bean.getLoginTimeoutMillis()));
                }
                if (this.bean.isLowMemoryGCThresholdSet()) {
                    stringBuffer.append("LowMemoryGCThreshold");
                    stringBuffer.append(String.valueOf(this.bean.getLowMemoryGCThreshold()));
                }
                if (this.bean.isLowMemoryGranularityLevelSet()) {
                    stringBuffer.append("LowMemoryGranularityLevel");
                    stringBuffer.append(String.valueOf(this.bean.getLowMemoryGranularityLevel()));
                }
                if (this.bean.isLowMemorySampleSizeSet()) {
                    stringBuffer.append("LowMemorySampleSize");
                    stringBuffer.append(String.valueOf(this.bean.getLowMemorySampleSize()));
                }
                if (this.bean.isLowMemoryTimeIntervalSet()) {
                    stringBuffer.append("LowMemoryTimeInterval");
                    stringBuffer.append(String.valueOf(this.bean.getLowMemoryTimeInterval()));
                }
                if (this.bean.isMachineSet()) {
                    stringBuffer.append("Machine");
                    stringBuffer.append(String.valueOf(this.bean.getMachine()));
                }
                if (this.bean.isMaxBackoffBetweenFailuresSet()) {
                    stringBuffer.append("MaxBackoffBetweenFailures");
                    stringBuffer.append(String.valueOf(this.bean.getMaxBackoffBetweenFailures()));
                }
                if (this.bean.isNMSocketCreateTimeoutInMillisSet()) {
                    stringBuffer.append("NMSocketCreateTimeoutInMillis");
                    stringBuffer.append(String.valueOf(this.bean.getNMSocketCreateTimeoutInMillis()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                l2 = 0L;
                for (int i = 0; i < this.bean.getNetworkAccessPoints().length; ++i) {
                    l2 ^= this.computeChildHashValue(this.bean.getNetworkAccessPoints()[i]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getOverloadProtection())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isPreferredSecondaryGroupSet()) {
                    stringBuffer.append("PreferredSecondaryGroup");
                    stringBuffer.append(String.valueOf(this.bean.getPreferredSecondaryGroup()));
                }
                if (this.bean.isReliableDeliveryPolicySet()) {
                    stringBuffer.append("ReliableDeliveryPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getReliableDeliveryPolicy()));
                }
                if (this.bean.isReplicationGroupSet()) {
                    stringBuffer.append("ReplicationGroup");
                    stringBuffer.append(String.valueOf(this.bean.getReplicationGroup()));
                }
                if (this.bean.isReplicationPortsSet()) {
                    stringBuffer.append("ReplicationPorts");
                    stringBuffer.append(String.valueOf(this.bean.getReplicationPorts()));
                }
                if (this.bean.isRestartDelaySecondsSet()) {
                    stringBuffer.append("RestartDelaySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getRestartDelaySeconds()));
                }
                if (this.bean.isRestartIntervalSecondsSet()) {
                    stringBuffer.append("RestartIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getRestartIntervalSeconds()));
                }
                if (this.bean.isRestartMaxSet()) {
                    stringBuffer.append("RestartMax");
                    stringBuffer.append(String.valueOf(this.bean.getRestartMax()));
                }
                if (this.bean.isRootDirectorySet()) {
                    stringBuffer.append("RootDirectory");
                    stringBuffer.append(String.valueOf(this.bean.getRootDirectory()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getServerDebug())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getServerDiagnosticConfig())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isServerLifeCycleTimeoutValSet()) {
                    stringBuffer.append("ServerLifeCycleTimeoutVal");
                    stringBuffer.append(String.valueOf(this.bean.getServerLifeCycleTimeoutVal()));
                }
                if (this.bean.isServerNamesSet()) {
                    stringBuffer.append("ServerNames");
                    stringBuffer.append(String.valueOf(this.bean.getServerNames()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getServerStart())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isServerVersionSet()) {
                    stringBuffer.append("ServerVersion");
                    stringBuffer.append(String.valueOf(this.bean.getServerVersion()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getSingleSignOnServices())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isStagingDirectoryNameSet()) {
                    stringBuffer.append("StagingDirectoryName");
                    stringBuffer.append(String.valueOf(this.bean.getStagingDirectoryName()));
                }
                if (this.bean.isStagingModeSet()) {
                    stringBuffer.append("StagingMode");
                    stringBuffer.append(String.valueOf(this.bean.getStagingMode()));
                }
                if (this.bean.isStartupModeSet()) {
                    stringBuffer.append("StartupMode");
                    stringBuffer.append(String.valueOf(this.bean.getStartupMode()));
                }
                if (this.bean.isStartupTimeoutSet()) {
                    stringBuffer.append("StartupTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getStartupTimeout()));
                }
                if (this.bean.isStdoutFormatSet()) {
                    stringBuffer.append("StdoutFormat");
                    stringBuffer.append(String.valueOf(this.bean.getStdoutFormat()));
                }
                if (this.bean.isStdoutSeverityLevelSet()) {
                    stringBuffer.append("StdoutSeverityLevel");
                    stringBuffer.append(String.valueOf(this.bean.getStdoutSeverityLevel()));
                }
                if (this.bean.isSupportedProtocolsSet()) {
                    stringBuffer.append("SupportedProtocols");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getSupportedProtocols())));
                }
                if (this.bean.isSystemPasswordSet()) {
                    stringBuffer.append("SystemPassword");
                    stringBuffer.append(String.valueOf(this.bean.getSystemPassword()));
                }
                if (this.bean.isSystemPasswordEncryptedSet()) {
                    stringBuffer.append("SystemPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getSystemPasswordEncrypted())));
                }
                if (this.bean.isThreadPoolSizeSet()) {
                    stringBuffer.append("ThreadPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getThreadPoolSize()));
                }
                if (this.bean.isTransactionLogFilePrefixSet()) {
                    stringBuffer.append("TransactionLogFilePrefix");
                    stringBuffer.append(String.valueOf(this.bean.getTransactionLogFilePrefix()));
                }
                if (this.bean.isTransactionLogFileWritePolicySet()) {
                    stringBuffer.append("TransactionLogFileWritePolicy");
                    stringBuffer.append(String.valueOf(this.bean.getTransactionLogFileWritePolicy()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getTransactionLogJDBCStore())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isTunnelingClientPingSecsSet()) {
                    stringBuffer.append("TunnelingClientPingSecs");
                    stringBuffer.append(String.valueOf(this.bean.getTunnelingClientPingSecs()));
                }
                if (this.bean.isTunnelingClientTimeoutSecsSet()) {
                    stringBuffer.append("TunnelingClientTimeoutSecs");
                    stringBuffer.append(String.valueOf(this.bean.getTunnelingClientTimeoutSecs()));
                }
                if (this.bean.isUploadDirectoryNameSet()) {
                    stringBuffer.append("UploadDirectoryName");
                    stringBuffer.append(String.valueOf(this.bean.getUploadDirectoryName()));
                }
                if (this.bean.isVerboseEJBDeploymentEnabledSet()) {
                    stringBuffer.append("VerboseEJBDeploymentEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getVerboseEJBDeploymentEnabled()));
                }
                if (this.bean.isVirtualMachineNameSet()) {
                    stringBuffer.append("VirtualMachineName");
                    stringBuffer.append(String.valueOf(this.bean.getVirtualMachineName()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getWebServer())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getWebService())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isXMLEntityCacheSet()) {
                    stringBuffer.append("XMLEntityCache");
                    stringBuffer.append(String.valueOf(this.bean.getXMLEntityCache()));
                }
                if (this.bean.isXMLRegistrySet()) {
                    stringBuffer.append("XMLRegistry");
                    stringBuffer.append(String.valueOf(this.bean.getXMLRegistry()));
                }
                if (this.bean.isAdministrationPortEnabledSet()) {
                    stringBuffer.append("AdministrationPortEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isAdministrationPortEnabled()));
                }
                if (this.bean.isAutoMigrationEnabledSet()) {
                    stringBuffer.append("AutoMigrationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isAutoMigrationEnabled()));
                }
                if (this.bean.isCOMEnabledSet()) {
                    stringBuffer.append("COMEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCOMEnabled()));
                }
                if (this.bean.isClasspathServletDisabledSet()) {
                    stringBuffer.append("ClasspathServletDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isClasspathServletDisabled()));
                }
                if (this.bean.isClientCertProxyEnabledSet()) {
                    stringBuffer.append("ClientCertProxyEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isClientCertProxyEnabled()));
                }
                if (this.bean.isConsoleInputEnabledSet()) {
                    stringBuffer.append("ConsoleInputEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isConsoleInputEnabled()));
                }
                if (this.bean.isDefaultInternalServletsDisabledSet()) {
                    stringBuffer.append("DefaultInternalServletsDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isDefaultInternalServletsDisabled()));
                }
                if (this.bean.isEnabledForDomainLogSet()) {
                    stringBuffer.append("EnabledForDomainLog");
                    stringBuffer.append(String.valueOf(this.bean.isEnabledForDomainLog()));
                }
                if (this.bean.isHttpTraceSupportEnabledSet()) {
                    stringBuffer.append("HttpTraceSupportEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isHttpTraceSupportEnabled()));
                }
                if (this.bean.isHttpdEnabledSet()) {
                    stringBuffer.append("HttpdEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isHttpdEnabled()));
                }
                if (this.bean.isIIOPEnabledSet()) {
                    stringBuffer.append("IIOPEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIIOPEnabled()));
                }
                if (this.bean.isIgnoreSessionsDuringShutdownSet()) {
                    stringBuffer.append("IgnoreSessionsDuringShutdown");
                    stringBuffer.append(String.valueOf(this.bean.isIgnoreSessionsDuringShutdown()));
                }
                if (this.bean.isJ2EE12OnlyModeEnabledSet()) {
                    stringBuffer.append("J2EE12OnlyModeEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isJ2EE12OnlyModeEnabled()));
                }
                if (this.bean.isJ2EE13WarningEnabledSet()) {
                    stringBuffer.append("J2EE13WarningEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isJ2EE13WarningEnabled()));
                }
                if (this.bean.isJDBCLoggingEnabledSet()) {
                    stringBuffer.append("JDBCLoggingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isJDBCLoggingEnabled()));
                }
                if (this.bean.isJMSDefaultConnectionFactoriesEnabledSet()) {
                    stringBuffer.append("JMSDefaultConnectionFactoriesEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isJMSDefaultConnectionFactoriesEnabled()));
                }
                if (this.bean.isJRMPEnabledSet()) {
                    stringBuffer.append("JRMPEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isJRMPEnabled()));
                }
                if (this.bean.isListenPortEnabledSet()) {
                    stringBuffer.append("ListenPortEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isListenPortEnabled()));
                }
                if (this.bean.isMSIFileReplicationEnabledSet()) {
                    stringBuffer.append("MSIFileReplicationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isMSIFileReplicationEnabled()));
                }
                if (this.bean.isManagedServerIndependenceEnabledSet()) {
                    stringBuffer.append("ManagedServerIndependenceEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isManagedServerIndependenceEnabled()));
                }
                if (this.bean.isMessageIdPrefixEnabledSet()) {
                    stringBuffer.append("MessageIdPrefixEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isMessageIdPrefixEnabled()));
                }
                if (this.bean.isNetworkClassLoadingEnabledSet()) {
                    stringBuffer.append("NetworkClassLoadingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isNetworkClassLoadingEnabled()));
                }
                if (this.bean.isStdoutDebugEnabledSet()) {
                    stringBuffer.append("StdoutDebugEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isStdoutDebugEnabled()));
                }
                if (this.bean.isStdoutEnabledSet()) {
                    stringBuffer.append("StdoutEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isStdoutEnabled()));
                }
                if (this.bean.isStdoutLogStackSet()) {
                    stringBuffer.append("StdoutLogStack");
                    stringBuffer.append(String.valueOf(this.bean.isStdoutLogStack()));
                }
                if (this.bean.isTGIOPEnabledSet()) {
                    stringBuffer.append("TGIOPEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isTGIOPEnabled()));
                }
                if (this.bean.isTunnelingEnabledSet()) {
                    stringBuffer.append("TunnelingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isTunnelingEnabled()));
                }
                if (this.bean.isUseFusionForLLRSet()) {
                    stringBuffer.append("UseFusionForLLR");
                    stringBuffer.append(String.valueOf(this.bean.isUseFusionForLLR()));
                }
                if (this.bean.isWeblogicPluginEnabledSet()) {
                    stringBuffer.append("WeblogicPluginEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isWeblogicPluginEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ServerMBeanImpl serverMBeanImpl = (ServerMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AcceptBacklog", this.bean.getAcceptBacklog(), serverMBeanImpl.getAcceptBacklog(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ActiveDirectoryName", this.bean.getActiveDirectoryName(), serverMBeanImpl.getActiveDirectoryName(), false);
                }
                this.computeDiff("AdminReconnectIntervalSeconds", this.bean.getAdminReconnectIntervalSeconds(), serverMBeanImpl.getAdminReconnectIntervalSeconds(), true);
                this.computeDiff("AdministrationPort", this.bean.getAdministrationPort(), serverMBeanImpl.getAdministrationPort(), true);
                this.computeDiff("AutoJDBCConnectionClose", this.bean.getAutoJDBCConnectionClose(), serverMBeanImpl.getAutoJDBCConnectionClose(), false);
                this.computeDiff("AutoKillIfFailed", this.bean.getAutoKillIfFailed(), serverMBeanImpl.getAutoKillIfFailed(), true);
                this.computeDiff("AutoRestart", this.bean.getAutoRestart(), serverMBeanImpl.getAutoRestart(), true);
                this.computeSubDiff("COM", this.bean.getCOM(), serverMBeanImpl.getCOM());
                this.computeDiff("CandidateMachines", this.bean.getCandidateMachines(), serverMBeanImpl.getCandidateMachines(), false, true);
                this.computeDiff("Cluster", this.bean.getCluster(), serverMBeanImpl.getCluster(), false);
                this.computeDiff("ClusterWeight", this.bean.getClusterWeight(), serverMBeanImpl.getClusterWeight(), false);
                this.computeDiff("CoherenceClusterSystemResource", this.bean.getCoherenceClusterSystemResource(), serverMBeanImpl.getCoherenceClusterSystemResource(), false);
                this.computeDiff("ConsensusProcessIdentifier", this.bean.getConsensusProcessIdentifier(), serverMBeanImpl.getConsensusProcessIdentifier(), false);
                this.computeDiff("CustomIdentityKeyStoreFileName", this.bean.getCustomIdentityKeyStoreFileName(), serverMBeanImpl.getCustomIdentityKeyStoreFileName(), true);
                this.computeDiff("CustomIdentityKeyStorePassPhraseEncrypted", this.bean.getCustomIdentityKeyStorePassPhraseEncrypted(), serverMBeanImpl.getCustomIdentityKeyStorePassPhraseEncrypted(), true);
                this.computeDiff("CustomIdentityKeyStoreType", this.bean.getCustomIdentityKeyStoreType(), serverMBeanImpl.getCustomIdentityKeyStoreType(), true);
                this.computeDiff("CustomTrustKeyStoreFileName", this.bean.getCustomTrustKeyStoreFileName(), serverMBeanImpl.getCustomTrustKeyStoreFileName(), true);
                this.computeDiff("CustomTrustKeyStorePassPhraseEncrypted", this.bean.getCustomTrustKeyStorePassPhraseEncrypted(), serverMBeanImpl.getCustomTrustKeyStorePassPhraseEncrypted(), true);
                this.computeDiff("CustomTrustKeyStoreType", this.bean.getCustomTrustKeyStoreType(), serverMBeanImpl.getCustomTrustKeyStoreType(), true);
                this.computeSubDiff("DataSource", this.bean.getDataSource(), serverMBeanImpl.getDataSource());
                this.computeSubDiff("DefaultFileStore", this.bean.getDefaultFileStore(), serverMBeanImpl.getDefaultFileStore());
                this.computeDiff("DefaultIIOPPasswordEncrypted", this.bean.getDefaultIIOPPasswordEncrypted(), serverMBeanImpl.getDefaultIIOPPasswordEncrypted(), false);
                this.computeDiff("DefaultIIOPUser", this.bean.getDefaultIIOPUser(), serverMBeanImpl.getDefaultIIOPUser(), false);
                this.computeDiff("DefaultTGIOPPasswordEncrypted", this.bean.getDefaultTGIOPPasswordEncrypted(), serverMBeanImpl.getDefaultTGIOPPasswordEncrypted(), false);
                this.computeDiff("DefaultTGIOPUser", this.bean.getDefaultTGIOPUser(), serverMBeanImpl.getDefaultTGIOPUser(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DomainLogFilter", this.bean.getDomainLogFilter(), serverMBeanImpl.getDomainLogFilter(), true);
                }
                this.computeDiff("ExternalDNSName", this.bean.getExternalDNSName(), serverMBeanImpl.getExternalDNSName(), false);
                this.computeDiff("ExtraEjbcOptions", this.bean.getExtraEjbcOptions(), serverMBeanImpl.getExtraEjbcOptions(), false);
                this.computeDiff("ExtraRmicOptions", this.bean.getExtraRmicOptions(), serverMBeanImpl.getExtraRmicOptions(), false);
                this.computeSubDiff("FederationServices", this.bean.getFederationServices(), serverMBeanImpl.getFederationServices());
                this.computeDiff("GracefulShutdownTimeout", this.bean.getGracefulShutdownTimeout(), serverMBeanImpl.getGracefulShutdownTimeout(), true);
                this.computeDiff("HealthCheckIntervalSeconds", this.bean.getHealthCheckIntervalSeconds(), serverMBeanImpl.getHealthCheckIntervalSeconds(), true);
                this.computeDiff("HealthCheckStartDelaySeconds", this.bean.getHealthCheckStartDelaySeconds(), serverMBeanImpl.getHealthCheckStartDelaySeconds(), true);
                this.computeDiff("HealthCheckTimeoutSeconds", this.bean.getHealthCheckTimeoutSeconds(), serverMBeanImpl.getHealthCheckTimeoutSeconds(), true);
                this.computeDiff("HostsMigratableServices", this.bean.getHostsMigratableServices(), serverMBeanImpl.getHostsMigratableServices(), false);
                this.computeDiff("IIOPConnectionPools", this.bean.getIIOPConnectionPools(), serverMBeanImpl.getIIOPConnectionPools(), false);
                this.computeDiff("InterfaceAddress", this.bean.getInterfaceAddress(), serverMBeanImpl.getInterfaceAddress(), false);
                this.computeDiff("JDBCLLRTableName", this.bean.getJDBCLLRTableName(), serverMBeanImpl.getJDBCLLRTableName(), false);
                this.computeDiff("JDBCLLRTablePoolColumnSize", this.bean.getJDBCLLRTablePoolColumnSize(), serverMBeanImpl.getJDBCLLRTablePoolColumnSize(), false);
                this.computeDiff("JDBCLLRTableRecordColumnSize", this.bean.getJDBCLLRTableRecordColumnSize(), serverMBeanImpl.getJDBCLLRTableRecordColumnSize(), false);
                this.computeDiff("JDBCLLRTableXIDColumnSize", this.bean.getJDBCLLRTableXIDColumnSize(), serverMBeanImpl.getJDBCLLRTableXIDColumnSize(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JDBCLogFileName", this.bean.getJDBCLogFileName(), serverMBeanImpl.getJDBCLogFileName(), false);
                }
                this.computeDiff("JDBCLoginTimeoutSeconds", this.bean.getJDBCLoginTimeoutSeconds(), serverMBeanImpl.getJDBCLoginTimeoutSeconds(), false);
                this.computeDiff("JNDITransportableObjectFactoryList", this.bean.getJNDITransportableObjectFactoryList(), serverMBeanImpl.getJNDITransportableObjectFactoryList(), false);
                this.computeChildDiff("JTAMigratableTarget", this.bean.getJTAMigratableTarget(), serverMBeanImpl.getJTAMigratableTarget(), false);
                this.computeDiff("JavaCompiler", this.bean.getJavaCompiler(), serverMBeanImpl.getJavaCompiler(), true);
                this.computeDiff("JavaCompilerPostClassPath", this.bean.getJavaCompilerPostClassPath(), serverMBeanImpl.getJavaCompilerPostClassPath(), false);
                this.computeDiff("JavaCompilerPreClassPath", this.bean.getJavaCompilerPreClassPath(), serverMBeanImpl.getJavaCompilerPreClassPath(), false);
                this.computeDiff("JavaStandardTrustKeyStorePassPhraseEncrypted", this.bean.getJavaStandardTrustKeyStorePassPhraseEncrypted(), serverMBeanImpl.getJavaStandardTrustKeyStorePassPhraseEncrypted(), true);
                this.computeDiff("KeyStores", this.bean.getKeyStores(), serverMBeanImpl.getKeyStores(), true);
                this.computeDiff("ListenAddress", this.bean.getListenAddress(), serverMBeanImpl.getListenAddress(), false);
                this.computeDiff("ListenDelaySecs", this.bean.getListenDelaySecs(), serverMBeanImpl.getListenDelaySecs(), false);
                this.computeDiff("ListenPort", this.bean.getListenPort(), serverMBeanImpl.getListenPort(), true);
                this.computeDiff("ListenThreadStartDelaySecs", this.bean.getListenThreadStartDelaySecs(), serverMBeanImpl.getListenThreadStartDelaySecs(), false);
                this.computeDiff("ListenersBindEarly", this.bean.getListenersBindEarly(), serverMBeanImpl.getListenersBindEarly(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LoginTimeout", this.bean.getLoginTimeout(), serverMBeanImpl.getLoginTimeout(), false);
                }
                this.computeDiff("LoginTimeoutMillis", this.bean.getLoginTimeoutMillis(), serverMBeanImpl.getLoginTimeoutMillis(), true);
                this.computeDiff("LowMemoryGCThreshold", this.bean.getLowMemoryGCThreshold(), serverMBeanImpl.getLowMemoryGCThreshold(), false);
                this.computeDiff("LowMemoryGranularityLevel", this.bean.getLowMemoryGranularityLevel(), serverMBeanImpl.getLowMemoryGranularityLevel(), false);
                this.computeDiff("LowMemorySampleSize", this.bean.getLowMemorySampleSize(), serverMBeanImpl.getLowMemorySampleSize(), false);
                this.computeDiff("LowMemoryTimeInterval", this.bean.getLowMemoryTimeInterval(), serverMBeanImpl.getLowMemoryTimeInterval(), false);
                this.computeDiff("Machine", this.bean.getMachine(), serverMBeanImpl.getMachine(), false);
                this.computeDiff("MaxBackoffBetweenFailures", this.bean.getMaxBackoffBetweenFailures(), serverMBeanImpl.getMaxBackoffBetweenFailures(), false);
                this.computeDiff("NMSocketCreateTimeoutInMillis", this.bean.getNMSocketCreateTimeoutInMillis(), serverMBeanImpl.getNMSocketCreateTimeoutInMillis(), false);
                this.computeDiff("Name", this.bean.getName(), serverMBeanImpl.getName(), false);
                this.computeChildDiff("NetworkAccessPoints", this.bean.getNetworkAccessPoints(), serverMBeanImpl.getNetworkAccessPoints(), true);
                this.computeSubDiff("OverloadProtection", this.bean.getOverloadProtection(), serverMBeanImpl.getOverloadProtection());
                this.computeDiff("PreferredSecondaryGroup", this.bean.getPreferredSecondaryGroup(), serverMBeanImpl.getPreferredSecondaryGroup(), false);
                this.computeDiff("ReliableDeliveryPolicy", this.bean.getReliableDeliveryPolicy(), serverMBeanImpl.getReliableDeliveryPolicy(), false);
                this.computeDiff("ReplicationGroup", this.bean.getReplicationGroup(), serverMBeanImpl.getReplicationGroup(), false);
                this.computeDiff("ReplicationPorts", this.bean.getReplicationPorts(), serverMBeanImpl.getReplicationPorts(), false);
                this.computeDiff("RestartDelaySeconds", this.bean.getRestartDelaySeconds(), serverMBeanImpl.getRestartDelaySeconds(), true);
                this.computeDiff("RestartIntervalSeconds", this.bean.getRestartIntervalSeconds(), serverMBeanImpl.getRestartIntervalSeconds(), true);
                this.computeDiff("RestartMax", this.bean.getRestartMax(), serverMBeanImpl.getRestartMax(), true);
                this.computeSubDiff("ServerDebug", this.bean.getServerDebug(), serverMBeanImpl.getServerDebug());
                this.computeSubDiff("ServerDiagnosticConfig", this.bean.getServerDiagnosticConfig(), serverMBeanImpl.getServerDiagnosticConfig());
                this.computeDiff("ServerLifeCycleTimeoutVal", this.bean.getServerLifeCycleTimeoutVal(), serverMBeanImpl.getServerLifeCycleTimeoutVal(), true);
                this.computeSubDiff("ServerStart", this.bean.getServerStart(), serverMBeanImpl.getServerStart());
                this.computeDiff("ServerVersion", this.bean.getServerVersion(), serverMBeanImpl.getServerVersion(), false);
                this.computeSubDiff("SingleSignOnServices", this.bean.getSingleSignOnServices(), serverMBeanImpl.getSingleSignOnServices());
                this.computeDiff("StagingDirectoryName", this.bean.getStagingDirectoryName(), serverMBeanImpl.getStagingDirectoryName(), false);
                this.computeDiff("StagingMode", this.bean.getStagingMode(), serverMBeanImpl.getStagingMode(), false);
                this.computeDiff("StartupMode", this.bean.getStartupMode(), serverMBeanImpl.getStartupMode(), true);
                this.computeDiff("StartupTimeout", this.bean.getStartupTimeout(), serverMBeanImpl.getStartupTimeout(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutFormat", this.bean.getStdoutFormat(), serverMBeanImpl.getStdoutFormat(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutSeverityLevel", this.bean.getStdoutSeverityLevel(), serverMBeanImpl.getStdoutSeverityLevel(), true);
                }
                this.computeDiff("SupportedProtocols", this.bean.getSupportedProtocols(), serverMBeanImpl.getSupportedProtocols(), false);
                this.computeDiff("SystemPasswordEncrypted", this.bean.getSystemPasswordEncrypted(), serverMBeanImpl.getSystemPasswordEncrypted(), false);
                this.computeDiff("ThreadPoolSize", this.bean.getThreadPoolSize(), serverMBeanImpl.getThreadPoolSize(), false);
                this.computeDiff("TransactionLogFilePrefix", this.bean.getTransactionLogFilePrefix(), serverMBeanImpl.getTransactionLogFilePrefix(), false);
                this.computeDiff("TransactionLogFileWritePolicy", this.bean.getTransactionLogFileWritePolicy(), serverMBeanImpl.getTransactionLogFileWritePolicy(), false);
                this.computeSubDiff("TransactionLogJDBCStore", this.bean.getTransactionLogJDBCStore(), serverMBeanImpl.getTransactionLogJDBCStore());
                this.computeDiff("TunnelingClientPingSecs", this.bean.getTunnelingClientPingSecs(), serverMBeanImpl.getTunnelingClientPingSecs(), true);
                this.computeDiff("TunnelingClientTimeoutSecs", this.bean.getTunnelingClientTimeoutSecs(), serverMBeanImpl.getTunnelingClientTimeoutSecs(), true);
                this.computeDiff("UploadDirectoryName", this.bean.getUploadDirectoryName(), serverMBeanImpl.getUploadDirectoryName(), true);
                this.computeDiff("VerboseEJBDeploymentEnabled", this.bean.getVerboseEJBDeploymentEnabled(), serverMBeanImpl.getVerboseEJBDeploymentEnabled(), false);
                this.computeDiff("VirtualMachineName", this.bean.getVirtualMachineName(), serverMBeanImpl.getVirtualMachineName(), true);
                this.computeSubDiff("WebServer", this.bean.getWebServer(), serverMBeanImpl.getWebServer());
                this.computeSubDiff("WebService", this.bean.getWebService(), serverMBeanImpl.getWebService());
                this.computeDiff("XMLEntityCache", this.bean.getXMLEntityCache(), serverMBeanImpl.getXMLEntityCache(), false);
                this.computeDiff("XMLRegistry", this.bean.getXMLRegistry(), serverMBeanImpl.getXMLRegistry(), false);
                this.computeDiff("AdministrationPortEnabled", this.bean.isAdministrationPortEnabled(), serverMBeanImpl.isAdministrationPortEnabled(), true);
                this.computeDiff("AutoMigrationEnabled", this.bean.isAutoMigrationEnabled(), serverMBeanImpl.isAutoMigrationEnabled(), false);
                this.computeDiff("COMEnabled", this.bean.isCOMEnabled(), serverMBeanImpl.isCOMEnabled(), false);
                this.computeDiff("ClasspathServletDisabled", this.bean.isClasspathServletDisabled(), serverMBeanImpl.isClasspathServletDisabled(), false);
                this.computeDiff("ClientCertProxyEnabled", this.bean.isClientCertProxyEnabled(), serverMBeanImpl.isClientCertProxyEnabled(), false);
                this.computeDiff("ConsoleInputEnabled", this.bean.isConsoleInputEnabled(), serverMBeanImpl.isConsoleInputEnabled(), false);
                this.computeDiff("DefaultInternalServletsDisabled", this.bean.isDefaultInternalServletsDisabled(), serverMBeanImpl.isDefaultInternalServletsDisabled(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("EnabledForDomainLog", this.bean.isEnabledForDomainLog(), serverMBeanImpl.isEnabledForDomainLog(), true);
                }
                this.computeDiff("HttpTraceSupportEnabled", this.bean.isHttpTraceSupportEnabled(), serverMBeanImpl.isHttpTraceSupportEnabled(), false);
                this.computeDiff("HttpdEnabled", this.bean.isHttpdEnabled(), serverMBeanImpl.isHttpdEnabled(), false);
                this.computeDiff("IIOPEnabled", this.bean.isIIOPEnabled(), serverMBeanImpl.isIIOPEnabled(), false);
                this.computeDiff("IgnoreSessionsDuringShutdown", this.bean.isIgnoreSessionsDuringShutdown(), serverMBeanImpl.isIgnoreSessionsDuringShutdown(), true);
                this.computeDiff("J2EE12OnlyModeEnabled", this.bean.isJ2EE12OnlyModeEnabled(), serverMBeanImpl.isJ2EE12OnlyModeEnabled(), false);
                this.computeDiff("J2EE13WarningEnabled", this.bean.isJ2EE13WarningEnabled(), serverMBeanImpl.isJ2EE13WarningEnabled(), false);
                this.computeDiff("JDBCLoggingEnabled", this.bean.isJDBCLoggingEnabled(), serverMBeanImpl.isJDBCLoggingEnabled(), false);
                this.computeDiff("JMSDefaultConnectionFactoriesEnabled", this.bean.isJMSDefaultConnectionFactoriesEnabled(), serverMBeanImpl.isJMSDefaultConnectionFactoriesEnabled(), true);
                this.computeDiff("JRMPEnabled", this.bean.isJRMPEnabled(), serverMBeanImpl.isJRMPEnabled(), false);
                this.computeDiff("ListenPortEnabled", this.bean.isListenPortEnabled(), serverMBeanImpl.isListenPortEnabled(), true);
                this.computeDiff("MSIFileReplicationEnabled", this.bean.isMSIFileReplicationEnabled(), serverMBeanImpl.isMSIFileReplicationEnabled(), false);
                this.computeDiff("ManagedServerIndependenceEnabled", this.bean.isManagedServerIndependenceEnabled(), serverMBeanImpl.isManagedServerIndependenceEnabled(), false);
                this.computeDiff("MessageIdPrefixEnabled", this.bean.isMessageIdPrefixEnabled(), serverMBeanImpl.isMessageIdPrefixEnabled(), false);
                this.computeDiff("NetworkClassLoadingEnabled", this.bean.isNetworkClassLoadingEnabled(), serverMBeanImpl.isNetworkClassLoadingEnabled(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutDebugEnabled", this.bean.isStdoutDebugEnabled(), serverMBeanImpl.isStdoutDebugEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutEnabled", this.bean.isStdoutEnabled(), serverMBeanImpl.isStdoutEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StdoutLogStack", this.bean.isStdoutLogStack(), serverMBeanImpl.isStdoutLogStack(), true);
                }
                this.computeDiff("TGIOPEnabled", this.bean.isTGIOPEnabled(), serverMBeanImpl.isTGIOPEnabled(), false);
                this.computeDiff("TunnelingEnabled", this.bean.isTunnelingEnabled(), serverMBeanImpl.isTunnelingEnabled(), true);
                this.computeDiff("UseFusionForLLR", this.bean.isUseFusionForLLR(), serverMBeanImpl.isUseFusionForLLR(), false);
                this.computeDiff("WeblogicPluginEnabled", this.bean.isWeblogicPluginEnabled(), serverMBeanImpl.isWeblogicPluginEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ServerMBeanImpl serverMBeanImpl = (ServerMBeanImpl)beanUpdateEvent.getSourceBean();
                ServerMBeanImpl serverMBeanImpl2 = (ServerMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("81StyleDefaultStagingDirName")) {
                    if (string.equals("AcceptBacklog")) {
                        serverMBeanImpl.setAcceptBacklog(serverMBeanImpl2.getAcceptBacklog());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 118);
                    } else if (string.equals("ActiveDirectoryName")) {
                        serverMBeanImpl.setActiveDirectoryName(serverMBeanImpl2.getActiveDirectoryName());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 152);
                    } else if (string.equals("AdminReconnectIntervalSeconds")) {
                        serverMBeanImpl.setAdminReconnectIntervalSeconds(serverMBeanImpl2.getAdminReconnectIntervalSeconds());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 141);
                    } else if (string.equals("AdministrationPort")) {
                        serverMBeanImpl.setAdministrationPort(serverMBeanImpl2.getAdministrationPort());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 122);
                    } else if (string.equals("AutoJDBCConnectionClose")) {
                        serverMBeanImpl.setAutoJDBCConnectionClose(serverMBeanImpl2.getAutoJDBCConnectionClose());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 199);
                    } else if (string.equals("AutoKillIfFailed")) {
                        serverMBeanImpl.setAutoKillIfFailed(serverMBeanImpl2.getAutoKillIfFailed());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 155);
                    } else if (string.equals("AutoRestart")) {
                        serverMBeanImpl.setAutoRestart(serverMBeanImpl2.getAutoRestart());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 154);
                    } else if (string.equals("COM")) {
                        if (n == 2) {
                            serverMBeanImpl.setCOM((COMMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getCOM()));
                        } else if (n == 3) {
                            serverMBeanImpl._destroySingleton("COM", serverMBeanImpl.getCOM());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 106);
                    } else if (string.equals("CandidateMachines")) {
                        serverMBeanImpl.setCandidateMachinesAsString(serverMBeanImpl2.getCandidateMachinesAsString());
                        this.reorderArrayObjects(serverMBeanImpl.getCandidateMachines(), serverMBeanImpl2.getCandidateMachines());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 190);
                    } else if (string.equals("Cluster")) {
                        serverMBeanImpl.setClusterAsString(serverMBeanImpl2.getClusterAsString());
                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 83);
                    } else if (!string.equals("ClusterRuntime")) {
                        if (string.equals("ClusterWeight")) {
                            serverMBeanImpl.setClusterWeight(serverMBeanImpl2.getClusterWeight());
                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 84);
                        } else if (string.equals("CoherenceClusterSystemResource")) {
                            serverMBeanImpl.setCoherenceClusterSystemResourceAsString(serverMBeanImpl2.getCoherenceClusterSystemResourceAsString());
                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 207);
                        } else if (string.equals("ConsensusProcessIdentifier")) {
                            serverMBeanImpl.setConsensusProcessIdentifier(serverMBeanImpl2.getConsensusProcessIdentifier());
                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 87);
                        } else if (string.equals("CustomIdentityKeyStoreFileName")) {
                            serverMBeanImpl.setCustomIdentityKeyStoreFileName(serverMBeanImpl2.getCustomIdentityKeyStoreFileName());
                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 177);
                        } else if (!string.equals("CustomIdentityKeyStorePassPhrase")) {
                            if (string.equals("CustomIdentityKeyStorePassPhraseEncrypted")) {
                                serverMBeanImpl.setCustomIdentityKeyStorePassPhraseEncrypted(serverMBeanImpl2.getCustomIdentityKeyStorePassPhraseEncrypted());
                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 180);
                            } else if (string.equals("CustomIdentityKeyStoreType")) {
                                serverMBeanImpl.setCustomIdentityKeyStoreType(serverMBeanImpl2.getCustomIdentityKeyStoreType());
                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 178);
                            } else if (string.equals("CustomTrustKeyStoreFileName")) {
                                serverMBeanImpl.setCustomTrustKeyStoreFileName(serverMBeanImpl2.getCustomTrustKeyStoreFileName());
                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 181);
                            } else if (!string.equals("CustomTrustKeyStorePassPhrase")) {
                                if (string.equals("CustomTrustKeyStorePassPhraseEncrypted")) {
                                    serverMBeanImpl.setCustomTrustKeyStorePassPhraseEncrypted(serverMBeanImpl2.getCustomTrustKeyStorePassPhraseEncrypted());
                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 184);
                                } else if (string.equals("CustomTrustKeyStoreType")) {
                                    serverMBeanImpl.setCustomTrustKeyStoreType(serverMBeanImpl2.getCustomTrustKeyStoreType());
                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 182);
                                } else if (string.equals("DataSource")) {
                                    if (n == 2) {
                                        serverMBeanImpl.setDataSource((DataSourceMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getDataSource()));
                                    } else if (n == 3) {
                                        serverMBeanImpl._destroySingleton("DataSource", serverMBeanImpl.getDataSource());
                                    } else {
                                        throw new AssertionError((Object)("Invalid type: " + n));
                                    }
                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 211);
                                } else if (string.equals("DefaultFileStore")) {
                                    if (n == 2) {
                                        serverMBeanImpl.setDefaultFileStore((DefaultFileStoreMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getDefaultFileStore()));
                                    } else if (n == 3) {
                                        serverMBeanImpl._destroySingleton("DefaultFileStore", serverMBeanImpl.getDefaultFileStore());
                                    } else {
                                        throw new AssertionError((Object)("Invalid type: " + n));
                                    }
                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 189);
                                } else if (!string.equals("DefaultIIOPPassword")) {
                                    if (string.equals("DefaultIIOPPasswordEncrypted")) {
                                        serverMBeanImpl.setDefaultIIOPPasswordEncrypted(serverMBeanImpl2.getDefaultIIOPPasswordEncrypted());
                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 99);
                                    } else if (string.equals("DefaultIIOPUser")) {
                                        serverMBeanImpl.setDefaultIIOPUser(serverMBeanImpl2.getDefaultIIOPUser());
                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 97);
                                    } else if (!string.equals("DefaultStagingDirName") && !string.equals("DefaultTGIOPPassword")) {
                                        if (string.equals("DefaultTGIOPPasswordEncrypted")) {
                                            serverMBeanImpl.setDefaultTGIOPPasswordEncrypted(serverMBeanImpl2.getDefaultTGIOPPasswordEncrypted());
                                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 103);
                                        } else if (string.equals("DefaultTGIOPUser")) {
                                            serverMBeanImpl.setDefaultTGIOPUser(serverMBeanImpl2.getDefaultTGIOPUser());
                                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 101);
                                        } else if (string.equals("DomainLogFilter")) {
                                            serverMBeanImpl.setDomainLogFilterAsString(serverMBeanImpl2.getDomainLogFilterAsString());
                                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 137);
                                        } else if (!string.equals("ExpectedToRun")) {
                                            if (string.equals("ExternalDNSName")) {
                                                serverMBeanImpl.setExternalDNSName(serverMBeanImpl2.getExternalDNSName());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 115);
                                            } else if (string.equals("ExtraEjbcOptions")) {
                                                serverMBeanImpl.setExtraEjbcOptions(serverMBeanImpl2.getExtraEjbcOptions());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 131);
                                            } else if (string.equals("ExtraRmicOptions")) {
                                                serverMBeanImpl.setExtraRmicOptions(serverMBeanImpl2.getExtraRmicOptions());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 130);
                                            } else if (string.equals("FederationServices")) {
                                                if (n == 2) {
                                                    serverMBeanImpl.setFederationServices((FederationServicesMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getFederationServices()));
                                                } else if (n == 3) {
                                                    serverMBeanImpl._destroySingleton("FederationServices", serverMBeanImpl.getFederationServices());
                                                } else {
                                                    throw new AssertionError((Object)("Invalid type: " + n));
                                                }
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 203);
                                            } else if (string.equals("GracefulShutdownTimeout")) {
                                                serverMBeanImpl.setGracefulShutdownTimeout(serverMBeanImpl2.getGracefulShutdownTimeout());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 168);
                                            } else if (string.equals("HealthCheckIntervalSeconds")) {
                                                serverMBeanImpl.setHealthCheckIntervalSeconds(serverMBeanImpl2.getHealthCheckIntervalSeconds());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 158);
                                            } else if (string.equals("HealthCheckStartDelaySeconds")) {
                                                serverMBeanImpl.setHealthCheckStartDelaySeconds(serverMBeanImpl2.getHealthCheckStartDelaySeconds());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 160);
                                            } else if (string.equals("HealthCheckTimeoutSeconds")) {
                                                serverMBeanImpl.setHealthCheckTimeoutSeconds(serverMBeanImpl2.getHealthCheckTimeoutSeconds());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 159);
                                            } else if (string.equals("HostsMigratableServices")) {
                                                serverMBeanImpl.setHostsMigratableServices(serverMBeanImpl2.getHostsMigratableServices());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 174);
                                            } else if (string.equals("IIOPConnectionPools")) {
                                                serverMBeanImpl.setIIOPConnectionPools(serverMBeanImpl2.getIIOPConnectionPools());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 124);
                                            } else if (string.equals("InterfaceAddress")) {
                                                serverMBeanImpl.setInterfaceAddress(serverMBeanImpl2.getInterfaceAddress());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 116);
                                            } else if (string.equals("JDBCLLRTableName")) {
                                                serverMBeanImpl.setJDBCLLRTableName(serverMBeanImpl2.getJDBCLLRTableName());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 192);
                                            } else if (string.equals("JDBCLLRTablePoolColumnSize")) {
                                                serverMBeanImpl.setJDBCLLRTablePoolColumnSize(serverMBeanImpl2.getJDBCLLRTablePoolColumnSize());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 195);
                                            } else if (string.equals("JDBCLLRTableRecordColumnSize")) {
                                                serverMBeanImpl.setJDBCLLRTableRecordColumnSize(serverMBeanImpl2.getJDBCLLRTableRecordColumnSize());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 196);
                                            } else if (string.equals("JDBCLLRTableXIDColumnSize")) {
                                                serverMBeanImpl.setJDBCLLRTableXIDColumnSize(serverMBeanImpl2.getJDBCLLRTableXIDColumnSize());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 194);
                                            } else if (string.equals("JDBCLogFileName")) {
                                                serverMBeanImpl.setJDBCLogFileName(serverMBeanImpl2.getJDBCLogFileName());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 93);
                                            } else if (string.equals("JDBCLoginTimeoutSeconds")) {
                                                serverMBeanImpl.setJDBCLoginTimeoutSeconds(serverMBeanImpl2.getJDBCLoginTimeoutSeconds());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 197);
                                            } else if (string.equals("JNDITransportableObjectFactoryList")) {
                                                serverMBeanImpl.setJNDITransportableObjectFactoryList(serverMBeanImpl2.getJNDITransportableObjectFactoryList());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 123);
                                            } else if (string.equals("JTAMigratableTarget")) {
                                                if (n == 2) {
                                                    serverMBeanImpl.setJTAMigratableTarget((JTAMigratableTargetMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getJTAMigratableTarget()));
                                                } else if (n == 3) {
                                                    serverMBeanImpl._destroySingleton("JTAMigratableTarget", serverMBeanImpl.getJTAMigratableTarget());
                                                } else {
                                                    throw new AssertionError((Object)("Invalid type: " + n));
                                                }
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 145);
                                            } else if (string.equals("JavaCompiler")) {
                                                serverMBeanImpl.setJavaCompiler(serverMBeanImpl2.getJavaCompiler());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 127);
                                            } else if (string.equals("JavaCompilerPostClassPath")) {
                                                serverMBeanImpl.setJavaCompilerPostClassPath(serverMBeanImpl2.getJavaCompilerPostClassPath());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 129);
                                            } else if (string.equals("JavaCompilerPreClassPath")) {
                                                serverMBeanImpl.setJavaCompilerPreClassPath(serverMBeanImpl2.getJavaCompilerPreClassPath());
                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 128);
                                            } else if (!string.equals("JavaStandardTrustKeyStorePassPhrase")) {
                                                if (string.equals("JavaStandardTrustKeyStorePassPhraseEncrypted")) {
                                                    serverMBeanImpl.setJavaStandardTrustKeyStorePassPhraseEncrypted(serverMBeanImpl2.getJavaStandardTrustKeyStorePassPhraseEncrypted());
                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 186);
                                                } else if (!string.equals("KernelDebug")) {
                                                    if (string.equals("KeyStores")) {
                                                        serverMBeanImpl.setKeyStores(serverMBeanImpl2.getKeyStores());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 176);
                                                    } else if (string.equals("ListenAddress")) {
                                                        serverMBeanImpl.setListenAddress(serverMBeanImpl2.getListenAddress());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 114);
                                                    } else if (string.equals("ListenDelaySecs")) {
                                                        serverMBeanImpl.setListenDelaySecs(serverMBeanImpl2.getListenDelaySecs());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 144);
                                                    } else if (string.equals("ListenPort")) {
                                                        serverMBeanImpl.setListenPort(serverMBeanImpl2.getListenPort());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 80);
                                                    } else if (string.equals("ListenThreadStartDelaySecs")) {
                                                        serverMBeanImpl.setListenThreadStartDelaySecs(serverMBeanImpl2.getListenThreadStartDelaySecs());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 112);
                                                    } else if (string.equals("ListenersBindEarly")) {
                                                        serverMBeanImpl.setListenersBindEarly(serverMBeanImpl2.getListenersBindEarly());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 113);
                                                    } else if (string.equals("LoginTimeout")) {
                                                        serverMBeanImpl.setLoginTimeout(serverMBeanImpl2.getLoginTimeout());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 82);
                                                    } else if (string.equals("LoginTimeoutMillis")) {
                                                        serverMBeanImpl.setLoginTimeoutMillis(serverMBeanImpl2.getLoginTimeoutMillis());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 120);
                                                    } else if (string.equals("LowMemoryGCThreshold")) {
                                                        serverMBeanImpl.setLowMemoryGCThreshold(serverMBeanImpl2.getLowMemoryGCThreshold());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 149);
                                                    } else if (string.equals("LowMemoryGranularityLevel")) {
                                                        serverMBeanImpl.setLowMemoryGranularityLevel(serverMBeanImpl2.getLowMemoryGranularityLevel());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 148);
                                                    } else if (string.equals("LowMemorySampleSize")) {
                                                        serverMBeanImpl.setLowMemorySampleSize(serverMBeanImpl2.getLowMemorySampleSize());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 147);
                                                    } else if (string.equals("LowMemoryTimeInterval")) {
                                                        serverMBeanImpl.setLowMemoryTimeInterval(serverMBeanImpl2.getLowMemoryTimeInterval());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 146);
                                                    } else if (string.equals("Machine")) {
                                                        serverMBeanImpl.setMachineAsString(serverMBeanImpl2.getMachineAsString());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 79);
                                                    } else if (string.equals("MaxBackoffBetweenFailures")) {
                                                        serverMBeanImpl.setMaxBackoffBetweenFailures(serverMBeanImpl2.getMaxBackoffBetweenFailures());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 119);
                                                    } else if (string.equals("NMSocketCreateTimeoutInMillis")) {
                                                        serverMBeanImpl.setNMSocketCreateTimeoutInMillis(serverMBeanImpl2.getNMSocketCreateTimeoutInMillis());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 206);
                                                    } else if (string.equals("Name")) {
                                                        serverMBeanImpl.setName(serverMBeanImpl2.getName());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                                                    } else if (string.equals("NetworkAccessPoints")) {
                                                        if (n == 2) {
                                                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                                            serverMBeanImpl.addNetworkAccessPoint((NetworkAccessPointMBean)propertyUpdate.getAddedObject());
                                                        } else if (n == 3) {
                                                            serverMBeanImpl.removeNetworkAccessPoint((NetworkAccessPointMBean)propertyUpdate.getRemovedObject());
                                                        } else {
                                                            throw new AssertionError((Object)("Invalid type: " + n));
                                                        }
                                                        if (serverMBeanImpl.getNetworkAccessPoints() == null || serverMBeanImpl.getNetworkAccessPoints().length == 0) {
                                                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 117);
                                                        }
                                                    } else if (string.equals("OverloadProtection")) {
                                                        if (n == 2) {
                                                            serverMBeanImpl.setOverloadProtection((OverloadProtectionMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getOverloadProtection()));
                                                        } else if (n == 3) {
                                                            serverMBeanImpl._destroySingleton("OverloadProtection", serverMBeanImpl.getOverloadProtection());
                                                        } else {
                                                            throw new AssertionError((Object)("Invalid type: " + n));
                                                        }
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 191);
                                                    } else if (string.equals("PreferredSecondaryGroup")) {
                                                        serverMBeanImpl.setPreferredSecondaryGroup(serverMBeanImpl2.getPreferredSecondaryGroup());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 86);
                                                    } else if (string.equals("ReliableDeliveryPolicy")) {
                                                        serverMBeanImpl.setReliableDeliveryPolicyAsString(serverMBeanImpl2.getReliableDeliveryPolicyAsString());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 187);
                                                    } else if (string.equals("ReplicationGroup")) {
                                                        serverMBeanImpl.setReplicationGroup(serverMBeanImpl2.getReplicationGroup());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 85);
                                                    } else if (string.equals("ReplicationPorts")) {
                                                        serverMBeanImpl.setReplicationPorts(serverMBeanImpl2.getReplicationPorts());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 209);
                                                    } else if (string.equals("RestartDelaySeconds")) {
                                                        serverMBeanImpl.setRestartDelaySeconds(serverMBeanImpl2.getRestartDelaySeconds());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 161);
                                                    } else if (string.equals("RestartIntervalSeconds")) {
                                                        serverMBeanImpl.setRestartIntervalSeconds(serverMBeanImpl2.getRestartIntervalSeconds());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 156);
                                                    } else if (string.equals("RestartMax")) {
                                                        serverMBeanImpl.setRestartMax(serverMBeanImpl2.getRestartMax());
                                                        serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 157);
                                                    } else if (!string.equals("RootDirectory")) {
                                                        if (string.equals("ServerDebug")) {
                                                            if (n == 2) {
                                                                serverMBeanImpl.setServerDebug((ServerDebugMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getServerDebug()));
                                                            } else if (n == 3) {
                                                                serverMBeanImpl._destroySingleton("ServerDebug", serverMBeanImpl.getServerDebug());
                                                            } else {
                                                                throw new AssertionError((Object)("Invalid type: " + n));
                                                            }
                                                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 107);
                                                        } else if (string.equals("ServerDiagnosticConfig")) {
                                                            if (n == 2) {
                                                                serverMBeanImpl.setServerDiagnosticConfig((WLDFServerDiagnosticMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getServerDiagnosticConfig()));
                                                            } else if (n == 3) {
                                                                serverMBeanImpl._destroySingleton("ServerDiagnosticConfig", serverMBeanImpl.getServerDiagnosticConfig());
                                                            } else {
                                                                throw new AssertionError((Object)("Invalid type: " + n));
                                                            }
                                                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 198);
                                                        } else if (string.equals("ServerLifeCycleTimeoutVal")) {
                                                            serverMBeanImpl.setServerLifeCycleTimeoutVal(serverMBeanImpl2.getServerLifeCycleTimeoutVal());
                                                            serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 166);
                                                        } else if (!string.equals("ServerNames")) {
                                                            if (string.equals("ServerStart")) {
                                                                if (n == 2) {
                                                                    serverMBeanImpl.setServerStart((ServerStartMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getServerStart()));
                                                                } else if (n == 3) {
                                                                    serverMBeanImpl._destroySingleton("ServerStart", serverMBeanImpl.getServerStart());
                                                                } else {
                                                                    throw new AssertionError((Object)("Invalid type: " + n));
                                                                }
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 143);
                                                            } else if (string.equals("ServerVersion")) {
                                                                serverMBeanImpl.setServerVersion(serverMBeanImpl2.getServerVersion());
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 164);
                                                            } else if (string.equals("SingleSignOnServices")) {
                                                                if (n == 2) {
                                                                    serverMBeanImpl.setSingleSignOnServices((SingleSignOnServicesMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getSingleSignOnServices()));
                                                                } else if (n == 3) {
                                                                    serverMBeanImpl._destroySingleton("SingleSignOnServices", serverMBeanImpl.getSingleSignOnServices());
                                                                } else {
                                                                    throw new AssertionError((Object)("Invalid type: " + n));
                                                                }
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 204);
                                                            } else if (string.equals("StagingDirectoryName")) {
                                                                serverMBeanImpl.setStagingDirectoryName(serverMBeanImpl2.getStagingDirectoryName());
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 150);
                                                            } else if (string.equals("StagingMode")) {
                                                                serverMBeanImpl.setStagingMode(serverMBeanImpl2.getStagingMode());
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 153);
                                                            } else if (string.equals("StartupMode")) {
                                                                serverMBeanImpl.setStartupMode(serverMBeanImpl2.getStartupMode());
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 165);
                                                            } else if (string.equals("StartupTimeout")) {
                                                                serverMBeanImpl.setStartupTimeout(serverMBeanImpl2.getStartupTimeout());
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 167);
                                                            } else if (string.equals("StdoutFormat")) {
                                                                serverMBeanImpl.setStdoutFormat(serverMBeanImpl2.getStdoutFormat());
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 60);
                                                            } else if (string.equals("StdoutSeverityLevel")) {
                                                                serverMBeanImpl.setStdoutSeverityLevel(serverMBeanImpl2.getStdoutSeverityLevel());
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 54);
                                                            } else if (string.equals("SupportedProtocols")) {
                                                                serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 200);
                                                            } else if (!string.equals("SystemPassword")) {
                                                                if (string.equals("SystemPasswordEncrypted")) {
                                                                    serverMBeanImpl.setSystemPasswordEncrypted(serverMBeanImpl2.getSystemPasswordEncrypted());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 110);
                                                                } else if (string.equals("ThreadPoolSize")) {
                                                                    serverMBeanImpl.setThreadPoolSize(serverMBeanImpl2.getThreadPoolSize());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                                                                } else if (string.equals("TransactionLogFilePrefix")) {
                                                                    serverMBeanImpl.setTransactionLogFilePrefix(serverMBeanImpl2.getTransactionLogFilePrefix());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 133);
                                                                } else if (string.equals("TransactionLogFileWritePolicy")) {
                                                                    serverMBeanImpl.setTransactionLogFileWritePolicy(serverMBeanImpl2.getTransactionLogFileWritePolicy());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 134);
                                                                } else if (string.equals("TransactionLogJDBCStore")) {
                                                                    if (n == 2) {
                                                                        serverMBeanImpl.setTransactionLogJDBCStore((TransactionLogJDBCStoreMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getTransactionLogJDBCStore()));
                                                                    } else if (n == 3) {
                                                                        serverMBeanImpl._destroySingleton("TransactionLogJDBCStore", serverMBeanImpl.getTransactionLogJDBCStore());
                                                                    } else {
                                                                        throw new AssertionError((Object)("Invalid type: " + n));
                                                                    }
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 210);
                                                                } else if (string.equals("TunnelingClientPingSecs")) {
                                                                    serverMBeanImpl.setTunnelingClientPingSecs(serverMBeanImpl2.getTunnelingClientPingSecs());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 139);
                                                                } else if (string.equals("TunnelingClientTimeoutSecs")) {
                                                                    serverMBeanImpl.setTunnelingClientTimeoutSecs(serverMBeanImpl2.getTunnelingClientTimeoutSecs());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 140);
                                                                } else if (string.equals("UploadDirectoryName")) {
                                                                    serverMBeanImpl.setUploadDirectoryName(serverMBeanImpl2.getUploadDirectoryName());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 151);
                                                                } else if (string.equals("VerboseEJBDeploymentEnabled")) {
                                                                    serverMBeanImpl.setVerboseEJBDeploymentEnabled(serverMBeanImpl2.getVerboseEJBDeploymentEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 132);
                                                                } else if (string.equals("VirtualMachineName")) {
                                                                    serverMBeanImpl.setVirtualMachineName(serverMBeanImpl2.getVirtualMachineName());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 208);
                                                                } else if (string.equals("WebServer")) {
                                                                    if (n == 2) {
                                                                        serverMBeanImpl.setWebServer((WebServerMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getWebServer()));
                                                                    } else if (n == 3) {
                                                                        serverMBeanImpl._destroySingleton("WebServer", serverMBeanImpl.getWebServer());
                                                                    } else {
                                                                        throw new AssertionError((Object)("Invalid type: " + n));
                                                                    }
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 90);
                                                                } else if (string.equals("WebService")) {
                                                                    if (n == 2) {
                                                                        serverMBeanImpl.setWebService((WebServiceMBean)this.createCopy((AbstractDescriptorBean)serverMBeanImpl2.getWebService()));
                                                                    } else if (n == 3) {
                                                                        serverMBeanImpl._destroySingleton("WebService", serverMBeanImpl.getWebService());
                                                                    } else {
                                                                        throw new AssertionError((Object)("Invalid type: " + n));
                                                                    }
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 205);
                                                                } else if (string.equals("XMLEntityCache")) {
                                                                    serverMBeanImpl.setXMLEntityCacheAsString(serverMBeanImpl2.getXMLEntityCacheAsString());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 126);
                                                                } else if (string.equals("XMLRegistry")) {
                                                                    serverMBeanImpl.setXMLRegistryAsString(serverMBeanImpl2.getXMLRegistryAsString());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 125);
                                                                } else if (string.equals("AdministrationPortEnabled")) {
                                                                    serverMBeanImpl.setAdministrationPortEnabled(serverMBeanImpl2.isAdministrationPortEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 121);
                                                                } else if (string.equals("AutoMigrationEnabled")) {
                                                                    serverMBeanImpl.setAutoMigrationEnabled(serverMBeanImpl2.isAutoMigrationEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 88);
                                                                } else if (string.equals("COMEnabled")) {
                                                                    serverMBeanImpl.setCOMEnabled(serverMBeanImpl2.isCOMEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 104);
                                                                } else if (string.equals("ClasspathServletDisabled")) {
                                                                    serverMBeanImpl.setClasspathServletDisabled(serverMBeanImpl2.isClasspathServletDisabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 162);
                                                                } else if (string.equals("ClientCertProxyEnabled")) {
                                                                    serverMBeanImpl.setClientCertProxyEnabled(serverMBeanImpl2.isClientCertProxyEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 172);
                                                                } else if (string.equals("ConsoleInputEnabled")) {
                                                                    serverMBeanImpl.setConsoleInputEnabled(serverMBeanImpl2.isConsoleInputEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 111);
                                                                } else if (string.equals("DefaultInternalServletsDisabled")) {
                                                                    serverMBeanImpl.setDefaultInternalServletsDisabled(serverMBeanImpl2.isDefaultInternalServletsDisabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 163);
                                                                } else if (string.equals("EnabledForDomainLog")) {
                                                                    serverMBeanImpl.setEnabledForDomainLog(serverMBeanImpl2.isEnabledForDomainLog());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 136);
                                                                } else if (string.equals("HttpTraceSupportEnabled")) {
                                                                    serverMBeanImpl.setHttpTraceSupportEnabled(serverMBeanImpl2.isHttpTraceSupportEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 175);
                                                                } else if (string.equals("HttpdEnabled")) {
                                                                    serverMBeanImpl.setHttpdEnabled(serverMBeanImpl2.isHttpdEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 108);
                                                                } else if (string.equals("IIOPEnabled")) {
                                                                    serverMBeanImpl.setIIOPEnabled(serverMBeanImpl2.isIIOPEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 96);
                                                                } else if (string.equals("IgnoreSessionsDuringShutdown")) {
                                                                    serverMBeanImpl.setIgnoreSessionsDuringShutdown(serverMBeanImpl2.isIgnoreSessionsDuringShutdown());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 169);
                                                                } else if (string.equals("J2EE12OnlyModeEnabled")) {
                                                                    serverMBeanImpl.setJ2EE12OnlyModeEnabled(serverMBeanImpl2.isJ2EE12OnlyModeEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 94);
                                                                } else if (string.equals("J2EE13WarningEnabled")) {
                                                                    serverMBeanImpl.setJ2EE13WarningEnabled(serverMBeanImpl2.isJ2EE13WarningEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 95);
                                                                } else if (string.equals("JDBCLoggingEnabled")) {
                                                                    serverMBeanImpl.setJDBCLoggingEnabled(serverMBeanImpl2.isJDBCLoggingEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 92);
                                                                } else if (string.equals("JMSDefaultConnectionFactoriesEnabled")) {
                                                                    serverMBeanImpl.setJMSDefaultConnectionFactoriesEnabled(serverMBeanImpl2.isJMSDefaultConnectionFactoriesEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 142);
                                                                } else if (string.equals("JRMPEnabled")) {
                                                                    serverMBeanImpl.setJRMPEnabled(serverMBeanImpl2.isJRMPEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 105);
                                                                } else if (string.equals("ListenPortEnabled")) {
                                                                    serverMBeanImpl.setListenPortEnabled(serverMBeanImpl2.isListenPortEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 81);
                                                                } else if (string.equals("MSIFileReplicationEnabled")) {
                                                                    serverMBeanImpl.setMSIFileReplicationEnabled(serverMBeanImpl2.isMSIFileReplicationEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 171);
                                                                } else if (string.equals("ManagedServerIndependenceEnabled")) {
                                                                    serverMBeanImpl.setManagedServerIndependenceEnabled(serverMBeanImpl2.isManagedServerIndependenceEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 170);
                                                                } else if (string.equals("MessageIdPrefixEnabled")) {
                                                                    serverMBeanImpl.setMessageIdPrefixEnabled(serverMBeanImpl2.isMessageIdPrefixEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 188);
                                                                } else if (string.equals("NetworkClassLoadingEnabled")) {
                                                                    serverMBeanImpl.setNetworkClassLoadingEnabled(serverMBeanImpl2.isNetworkClassLoadingEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 135);
                                                                } else if (string.equals("StdoutDebugEnabled")) {
                                                                    serverMBeanImpl.setStdoutDebugEnabled(serverMBeanImpl2.isStdoutDebugEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 55);
                                                                } else if (string.equals("StdoutEnabled")) {
                                                                    serverMBeanImpl.setStdoutEnabled(serverMBeanImpl2.isStdoutEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 53);
                                                                } else if (string.equals("StdoutLogStack")) {
                                                                    serverMBeanImpl.setStdoutLogStack(serverMBeanImpl2.isStdoutLogStack());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 61);
                                                                } else if (string.equals("TGIOPEnabled")) {
                                                                    serverMBeanImpl.setTGIOPEnabled(serverMBeanImpl2.isTGIOPEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 100);
                                                                } else if (string.equals("TunnelingEnabled")) {
                                                                    serverMBeanImpl.setTunnelingEnabled(serverMBeanImpl2.isTunnelingEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 138);
                                                                } else if (string.equals("UseFusionForLLR")) {
                                                                    serverMBeanImpl.setUseFusionForLLR(serverMBeanImpl2.isUseFusionForLLR());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 193);
                                                                } else if (string.equals("WeblogicPluginEnabled")) {
                                                                    serverMBeanImpl.setWeblogicPluginEnabled(serverMBeanImpl2.isWeblogicPluginEnabled());
                                                                    serverMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 173);
                                                                } else {
                                                                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                Object object;
                ServerMBeanImpl serverMBeanImpl = (ServerMBeanImpl)abstractDescriptorBean;
                super.finishCopy(serverMBeanImpl, bl, list);
                if ((list == null || !list.contains("AcceptBacklog")) && this.bean.isAcceptBacklogSet()) {
                    serverMBeanImpl.setAcceptBacklog(this.bean.getAcceptBacklog());
                }
                if (bl && (list == null || !list.contains("ActiveDirectoryName")) && this.bean.isActiveDirectoryNameSet()) {
                    serverMBeanImpl.setActiveDirectoryName(this.bean.getActiveDirectoryName());
                }
                if ((list == null || !list.contains("AdminReconnectIntervalSeconds")) && this.bean.isAdminReconnectIntervalSecondsSet()) {
                    serverMBeanImpl.setAdminReconnectIntervalSeconds(this.bean.getAdminReconnectIntervalSeconds());
                }
                if ((list == null || !list.contains("AdministrationPort")) && this.bean.isAdministrationPortSet()) {
                    serverMBeanImpl.setAdministrationPort(this.bean.getAdministrationPort());
                }
                if ((list == null || !list.contains("AutoJDBCConnectionClose")) && this.bean.isAutoJDBCConnectionCloseSet()) {
                    serverMBeanImpl.setAutoJDBCConnectionClose(this.bean.getAutoJDBCConnectionClose());
                }
                if ((list == null || !list.contains("AutoKillIfFailed")) && this.bean.isAutoKillIfFailedSet()) {
                    serverMBeanImpl.setAutoKillIfFailed(this.bean.getAutoKillIfFailed());
                }
                if ((list == null || !list.contains("AutoRestart")) && this.bean.isAutoRestartSet()) {
                    serverMBeanImpl.setAutoRestart(this.bean.getAutoRestart());
                }
                if (!(list != null && list.contains("COM") || !this.bean.isCOMSet() || serverMBeanImpl._isSet(106))) {
                    object = this.bean.getCOM();
                    serverMBeanImpl.setCOM(null);
                    serverMBeanImpl.setCOM(object == null ? null : (COMMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("CandidateMachines")) && this.bean.isCandidateMachinesSet()) {
                    serverMBeanImpl._unSet(serverMBeanImpl, 190);
                    serverMBeanImpl.setCandidateMachinesAsString(this.bean.getCandidateMachinesAsString());
                }
                if ((list == null || !list.contains("Cluster")) && this.bean.isClusterSet()) {
                    serverMBeanImpl._unSet(serverMBeanImpl, 83);
                    serverMBeanImpl.setClusterAsString(this.bean.getClusterAsString());
                }
                if ((list == null || !list.contains("ClusterWeight")) && this.bean.isClusterWeightSet()) {
                    serverMBeanImpl.setClusterWeight(this.bean.getClusterWeight());
                }
                if ((list == null || !list.contains("CoherenceClusterSystemResource")) && this.bean.isCoherenceClusterSystemResourceSet()) {
                    serverMBeanImpl._unSet(serverMBeanImpl, 207);
                    serverMBeanImpl.setCoherenceClusterSystemResourceAsString(this.bean.getCoherenceClusterSystemResourceAsString());
                }
                if ((list == null || !list.contains("ConsensusProcessIdentifier")) && this.bean.isConsensusProcessIdentifierSet()) {
                    serverMBeanImpl.setConsensusProcessIdentifier(this.bean.getConsensusProcessIdentifier());
                }
                if ((list == null || !list.contains("CustomIdentityKeyStoreFileName")) && this.bean.isCustomIdentityKeyStoreFileNameSet()) {
                    serverMBeanImpl.setCustomIdentityKeyStoreFileName(this.bean.getCustomIdentityKeyStoreFileName());
                }
                if ((list == null || !list.contains("CustomIdentityKeyStorePassPhraseEncrypted")) && this.bean.isCustomIdentityKeyStorePassPhraseEncryptedSet()) {
                    object = this.bean.getCustomIdentityKeyStorePassPhraseEncrypted();
                    serverMBeanImpl.setCustomIdentityKeyStorePassPhraseEncrypted(object == null ? null : (byte[])((byte[])object).clone());
                }
                if ((list == null || !list.contains("CustomIdentityKeyStoreType")) && this.bean.isCustomIdentityKeyStoreTypeSet()) {
                    serverMBeanImpl.setCustomIdentityKeyStoreType(this.bean.getCustomIdentityKeyStoreType());
                }
                if ((list == null || !list.contains("CustomTrustKeyStoreFileName")) && this.bean.isCustomTrustKeyStoreFileNameSet()) {
                    serverMBeanImpl.setCustomTrustKeyStoreFileName(this.bean.getCustomTrustKeyStoreFileName());
                }
                if ((list == null || !list.contains("CustomTrustKeyStorePassPhraseEncrypted")) && this.bean.isCustomTrustKeyStorePassPhraseEncryptedSet()) {
                    object = this.bean.getCustomTrustKeyStorePassPhraseEncrypted();
                    serverMBeanImpl.setCustomTrustKeyStorePassPhraseEncrypted(object == null ? null : (byte[])((byte[])object).clone());
                }
                if ((list == null || !list.contains("CustomTrustKeyStoreType")) && this.bean.isCustomTrustKeyStoreTypeSet()) {
                    serverMBeanImpl.setCustomTrustKeyStoreType(this.bean.getCustomTrustKeyStoreType());
                }
                if (!(list != null && list.contains("DataSource") || !this.bean.isDataSourceSet() || serverMBeanImpl._isSet(211))) {
                    object = this.bean.getDataSource();
                    serverMBeanImpl.setDataSource(null);
                    serverMBeanImpl.setDataSource(object == null ? null : (DataSourceMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if (!(list != null && list.contains("DefaultFileStore") || !this.bean.isDefaultFileStoreSet() || serverMBeanImpl._isSet(189))) {
                    object = this.bean.getDefaultFileStore();
                    serverMBeanImpl.setDefaultFileStore(null);
                    serverMBeanImpl.setDefaultFileStore(object == null ? null : (DefaultFileStoreMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("DefaultIIOPPasswordEncrypted")) && this.bean.isDefaultIIOPPasswordEncryptedSet()) {
                    object = this.bean.getDefaultIIOPPasswordEncrypted();
                    serverMBeanImpl.setDefaultIIOPPasswordEncrypted(object == null ? null : (byte[])((byte[])object).clone());
                }
                if ((list == null || !list.contains("DefaultIIOPUser")) && this.bean.isDefaultIIOPUserSet()) {
                    serverMBeanImpl.setDefaultIIOPUser(this.bean.getDefaultIIOPUser());
                }
                if ((list == null || !list.contains("DefaultTGIOPPasswordEncrypted")) && this.bean.isDefaultTGIOPPasswordEncryptedSet()) {
                    object = this.bean.getDefaultTGIOPPasswordEncrypted();
                    serverMBeanImpl.setDefaultTGIOPPasswordEncrypted(object == null ? null : (byte[])((byte[])object).clone());
                }
                if ((list == null || !list.contains("DefaultTGIOPUser")) && this.bean.isDefaultTGIOPUserSet()) {
                    serverMBeanImpl.setDefaultTGIOPUser(this.bean.getDefaultTGIOPUser());
                }
                if (bl && (list == null || !list.contains("DomainLogFilter")) && this.bean.isDomainLogFilterSet()) {
                    serverMBeanImpl._unSet(serverMBeanImpl, 137);
                    serverMBeanImpl.setDomainLogFilterAsString(this.bean.getDomainLogFilterAsString());
                }
                if ((list == null || !list.contains("ExternalDNSName")) && this.bean.isExternalDNSNameSet()) {
                    serverMBeanImpl.setExternalDNSName(this.bean.getExternalDNSName());
                }
                if ((list == null || !list.contains("ExtraEjbcOptions")) && this.bean.isExtraEjbcOptionsSet()) {
                    serverMBeanImpl.setExtraEjbcOptions(this.bean.getExtraEjbcOptions());
                }
                if ((list == null || !list.contains("ExtraRmicOptions")) && this.bean.isExtraRmicOptionsSet()) {
                    serverMBeanImpl.setExtraRmicOptions(this.bean.getExtraRmicOptions());
                }
                if (!(list != null && list.contains("FederationServices") || !this.bean.isFederationServicesSet() || serverMBeanImpl._isSet(203))) {
                    object = this.bean.getFederationServices();
                    serverMBeanImpl.setFederationServices(null);
                    serverMBeanImpl.setFederationServices(object == null ? null : (FederationServicesMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("GracefulShutdownTimeout")) && this.bean.isGracefulShutdownTimeoutSet()) {
                    serverMBeanImpl.setGracefulShutdownTimeout(this.bean.getGracefulShutdownTimeout());
                }
                if ((list == null || !list.contains("HealthCheckIntervalSeconds")) && this.bean.isHealthCheckIntervalSecondsSet()) {
                    serverMBeanImpl.setHealthCheckIntervalSeconds(this.bean.getHealthCheckIntervalSeconds());
                }
                if ((list == null || !list.contains("HealthCheckStartDelaySeconds")) && this.bean.isHealthCheckStartDelaySecondsSet()) {
                    serverMBeanImpl.setHealthCheckStartDelaySeconds(this.bean.getHealthCheckStartDelaySeconds());
                }
                if ((list == null || !list.contains("HealthCheckTimeoutSeconds")) && this.bean.isHealthCheckTimeoutSecondsSet()) {
                    serverMBeanImpl.setHealthCheckTimeoutSeconds(this.bean.getHealthCheckTimeoutSeconds());
                }
                if ((list == null || !list.contains("HostsMigratableServices")) && this.bean.isHostsMigratableServicesSet()) {
                    serverMBeanImpl.setHostsMigratableServices(this.bean.getHostsMigratableServices());
                }
                if ((list == null || !list.contains("IIOPConnectionPools")) && this.bean.isIIOPConnectionPoolsSet()) {
                    serverMBeanImpl.setIIOPConnectionPools(this.bean.getIIOPConnectionPools());
                }
                if ((list == null || !list.contains("InterfaceAddress")) && this.bean.isInterfaceAddressSet()) {
                    serverMBeanImpl.setInterfaceAddress(this.bean.getInterfaceAddress());
                }
                if ((list == null || !list.contains("JDBCLLRTableName")) && this.bean.isJDBCLLRTableNameSet()) {
                    serverMBeanImpl.setJDBCLLRTableName(this.bean.getJDBCLLRTableName());
                }
                if ((list == null || !list.contains("JDBCLLRTablePoolColumnSize")) && this.bean.isJDBCLLRTablePoolColumnSizeSet()) {
                    serverMBeanImpl.setJDBCLLRTablePoolColumnSize(this.bean.getJDBCLLRTablePoolColumnSize());
                }
                if ((list == null || !list.contains("JDBCLLRTableRecordColumnSize")) && this.bean.isJDBCLLRTableRecordColumnSizeSet()) {
                    serverMBeanImpl.setJDBCLLRTableRecordColumnSize(this.bean.getJDBCLLRTableRecordColumnSize());
                }
                if ((list == null || !list.contains("JDBCLLRTableXIDColumnSize")) && this.bean.isJDBCLLRTableXIDColumnSizeSet()) {
                    serverMBeanImpl.setJDBCLLRTableXIDColumnSize(this.bean.getJDBCLLRTableXIDColumnSize());
                }
                if (bl && (list == null || !list.contains("JDBCLogFileName")) && this.bean.isJDBCLogFileNameSet()) {
                    serverMBeanImpl.setJDBCLogFileName(this.bean.getJDBCLogFileName());
                }
                if ((list == null || !list.contains("JDBCLoginTimeoutSeconds")) && this.bean.isJDBCLoginTimeoutSecondsSet()) {
                    serverMBeanImpl.setJDBCLoginTimeoutSeconds(this.bean.getJDBCLoginTimeoutSeconds());
                }
                if ((list == null || !list.contains("JNDITransportableObjectFactoryList")) && this.bean.isJNDITransportableObjectFactoryListSet()) {
                    object = this.bean.getJNDITransportableObjectFactoryList();
                    serverMBeanImpl.setJNDITransportableObjectFactoryList(object == null ? null : (String[])object.clone());
                }
                if (!(list != null && list.contains("JTAMigratableTarget") || !this.bean.isJTAMigratableTargetSet() || serverMBeanImpl._isSet(145))) {
                    object = this.bean.getJTAMigratableTarget();
                    serverMBeanImpl.setJTAMigratableTarget(null);
                    serverMBeanImpl.setJTAMigratableTarget(object == null ? null : (JTAMigratableTargetMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("JavaCompiler")) && this.bean.isJavaCompilerSet()) {
                    serverMBeanImpl.setJavaCompiler(this.bean.getJavaCompiler());
                }
                if ((list == null || !list.contains("JavaCompilerPostClassPath")) && this.bean.isJavaCompilerPostClassPathSet()) {
                    serverMBeanImpl.setJavaCompilerPostClassPath(this.bean.getJavaCompilerPostClassPath());
                }
                if ((list == null || !list.contains("JavaCompilerPreClassPath")) && this.bean.isJavaCompilerPreClassPathSet()) {
                    serverMBeanImpl.setJavaCompilerPreClassPath(this.bean.getJavaCompilerPreClassPath());
                }
                if ((list == null || !list.contains("JavaStandardTrustKeyStorePassPhraseEncrypted")) && this.bean.isJavaStandardTrustKeyStorePassPhraseEncryptedSet()) {
                    object = this.bean.getJavaStandardTrustKeyStorePassPhraseEncrypted();
                    serverMBeanImpl.setJavaStandardTrustKeyStorePassPhraseEncrypted(object == null ? null : (byte[])((byte[])object).clone());
                }
                if ((list == null || !list.contains("KeyStores")) && this.bean.isKeyStoresSet()) {
                    serverMBeanImpl.setKeyStores(this.bean.getKeyStores());
                }
                if ((list == null || !list.contains("ListenAddress")) && this.bean.isListenAddressSet()) {
                    serverMBeanImpl.setListenAddress(this.bean.getListenAddress());
                }
                if ((list == null || !list.contains("ListenDelaySecs")) && this.bean.isListenDelaySecsSet()) {
                    serverMBeanImpl.setListenDelaySecs(this.bean.getListenDelaySecs());
                }
                if ((list == null || !list.contains("ListenPort")) && this.bean.isListenPortSet()) {
                    serverMBeanImpl.setListenPort(this.bean.getListenPort());
                }
                if ((list == null || !list.contains("ListenThreadStartDelaySecs")) && this.bean.isListenThreadStartDelaySecsSet()) {
                    serverMBeanImpl.setListenThreadStartDelaySecs(this.bean.getListenThreadStartDelaySecs());
                }
                if ((list == null || !list.contains("ListenersBindEarly")) && this.bean.isListenersBindEarlySet()) {
                    serverMBeanImpl.setListenersBindEarly(this.bean.getListenersBindEarly());
                }
                if (bl && (list == null || !list.contains("LoginTimeout")) && this.bean.isLoginTimeoutSet()) {
                    serverMBeanImpl.setLoginTimeout(this.bean.getLoginTimeout());
                }
                if ((list == null || !list.contains("LoginTimeoutMillis")) && this.bean.isLoginTimeoutMillisSet()) {
                    serverMBeanImpl.setLoginTimeoutMillis(this.bean.getLoginTimeoutMillis());
                }
                if ((list == null || !list.contains("LowMemoryGCThreshold")) && this.bean.isLowMemoryGCThresholdSet()) {
                    serverMBeanImpl.setLowMemoryGCThreshold(this.bean.getLowMemoryGCThreshold());
                }
                if ((list == null || !list.contains("LowMemoryGranularityLevel")) && this.bean.isLowMemoryGranularityLevelSet()) {
                    serverMBeanImpl.setLowMemoryGranularityLevel(this.bean.getLowMemoryGranularityLevel());
                }
                if ((list == null || !list.contains("LowMemorySampleSize")) && this.bean.isLowMemorySampleSizeSet()) {
                    serverMBeanImpl.setLowMemorySampleSize(this.bean.getLowMemorySampleSize());
                }
                if ((list == null || !list.contains("LowMemoryTimeInterval")) && this.bean.isLowMemoryTimeIntervalSet()) {
                    serverMBeanImpl.setLowMemoryTimeInterval(this.bean.getLowMemoryTimeInterval());
                }
                if ((list == null || !list.contains("Machine")) && this.bean.isMachineSet()) {
                    serverMBeanImpl._unSet(serverMBeanImpl, 79);
                    serverMBeanImpl.setMachineAsString(this.bean.getMachineAsString());
                }
                if ((list == null || !list.contains("MaxBackoffBetweenFailures")) && this.bean.isMaxBackoffBetweenFailuresSet()) {
                    serverMBeanImpl.setMaxBackoffBetweenFailures(this.bean.getMaxBackoffBetweenFailures());
                }
                if ((list == null || !list.contains("NMSocketCreateTimeoutInMillis")) && this.bean.isNMSocketCreateTimeoutInMillisSet()) {
                    serverMBeanImpl.setNMSocketCreateTimeoutInMillis(this.bean.getNMSocketCreateTimeoutInMillis());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    serverMBeanImpl.setName(this.bean.getName());
                }
                if (!(list != null && list.contains("NetworkAccessPoints") || !this.bean.isNetworkAccessPointsSet() || serverMBeanImpl._isSet(117))) {
                    NetworkAccessPointMBean[] networkAccessPointMBeanArray = this.bean.getNetworkAccessPoints();
                    NetworkAccessPointMBean[] networkAccessPointMBeanArray2 = new NetworkAccessPointMBean[networkAccessPointMBeanArray.length];
                    for (int i = 0; i < networkAccessPointMBeanArray2.length; ++i) {
                        networkAccessPointMBeanArray2[i] = (NetworkAccessPointMBean)this.createCopy((AbstractDescriptorBean)networkAccessPointMBeanArray[i], bl);
                    }
                    serverMBeanImpl.setNetworkAccessPoints(networkAccessPointMBeanArray2);
                }
                if (!(list != null && list.contains("OverloadProtection") || !this.bean.isOverloadProtectionSet() || serverMBeanImpl._isSet(191))) {
                    object = this.bean.getOverloadProtection();
                    serverMBeanImpl.setOverloadProtection(null);
                    serverMBeanImpl.setOverloadProtection(object == null ? null : (OverloadProtectionMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("PreferredSecondaryGroup")) && this.bean.isPreferredSecondaryGroupSet()) {
                    serverMBeanImpl.setPreferredSecondaryGroup(this.bean.getPreferredSecondaryGroup());
                }
                if ((list == null || !list.contains("ReliableDeliveryPolicy")) && this.bean.isReliableDeliveryPolicySet()) {
                    serverMBeanImpl._unSet(serverMBeanImpl, 187);
                    serverMBeanImpl.setReliableDeliveryPolicyAsString(this.bean.getReliableDeliveryPolicyAsString());
                }
                if ((list == null || !list.contains("ReplicationGroup")) && this.bean.isReplicationGroupSet()) {
                    serverMBeanImpl.setReplicationGroup(this.bean.getReplicationGroup());
                }
                if ((list == null || !list.contains("ReplicationPorts")) && this.bean.isReplicationPortsSet()) {
                    serverMBeanImpl.setReplicationPorts(this.bean.getReplicationPorts());
                }
                if ((list == null || !list.contains("RestartDelaySeconds")) && this.bean.isRestartDelaySecondsSet()) {
                    serverMBeanImpl.setRestartDelaySeconds(this.bean.getRestartDelaySeconds());
                }
                if ((list == null || !list.contains("RestartIntervalSeconds")) && this.bean.isRestartIntervalSecondsSet()) {
                    serverMBeanImpl.setRestartIntervalSeconds(this.bean.getRestartIntervalSeconds());
                }
                if ((list == null || !list.contains("RestartMax")) && this.bean.isRestartMaxSet()) {
                    serverMBeanImpl.setRestartMax(this.bean.getRestartMax());
                }
                if (!(list != null && list.contains("ServerDebug") || !this.bean.isServerDebugSet() || serverMBeanImpl._isSet(107))) {
                    object = this.bean.getServerDebug();
                    serverMBeanImpl.setServerDebug(null);
                    serverMBeanImpl.setServerDebug(object == null ? null : (ServerDebugMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if (!(list != null && list.contains("ServerDiagnosticConfig") || !this.bean.isServerDiagnosticConfigSet() || serverMBeanImpl._isSet(198))) {
                    object = this.bean.getServerDiagnosticConfig();
                    serverMBeanImpl.setServerDiagnosticConfig(null);
                    serverMBeanImpl.setServerDiagnosticConfig(object == null ? null : (WLDFServerDiagnosticMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("ServerLifeCycleTimeoutVal")) && this.bean.isServerLifeCycleTimeoutValSet()) {
                    serverMBeanImpl.setServerLifeCycleTimeoutVal(this.bean.getServerLifeCycleTimeoutVal());
                }
                if (!(list != null && list.contains("ServerStart") || !this.bean.isServerStartSet() || serverMBeanImpl._isSet(143))) {
                    object = this.bean.getServerStart();
                    serverMBeanImpl.setServerStart(null);
                    serverMBeanImpl.setServerStart(object == null ? null : (ServerStartMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("ServerVersion")) && this.bean.isServerVersionSet()) {
                    serverMBeanImpl.setServerVersion(this.bean.getServerVersion());
                }
                if (!(list != null && list.contains("SingleSignOnServices") || !this.bean.isSingleSignOnServicesSet() || serverMBeanImpl._isSet(204))) {
                    object = this.bean.getSingleSignOnServices();
                    serverMBeanImpl.setSingleSignOnServices(null);
                    serverMBeanImpl.setSingleSignOnServices(object == null ? null : (SingleSignOnServicesMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("StagingDirectoryName")) && this.bean.isStagingDirectoryNameSet()) {
                    serverMBeanImpl.setStagingDirectoryName(this.bean.getStagingDirectoryName());
                }
                if ((list == null || !list.contains("StagingMode")) && this.bean.isStagingModeSet()) {
                    serverMBeanImpl.setStagingMode(this.bean.getStagingMode());
                }
                if ((list == null || !list.contains("StartupMode")) && this.bean.isStartupModeSet()) {
                    serverMBeanImpl.setStartupMode(this.bean.getStartupMode());
                }
                if ((list == null || !list.contains("StartupTimeout")) && this.bean.isStartupTimeoutSet()) {
                    serverMBeanImpl.setStartupTimeout(this.bean.getStartupTimeout());
                }
                if (bl && (list == null || !list.contains("StdoutFormat")) && this.bean.isStdoutFormatSet()) {
                    serverMBeanImpl.setStdoutFormat(this.bean.getStdoutFormat());
                }
                if (bl && (list == null || !list.contains("StdoutSeverityLevel")) && this.bean.isStdoutSeverityLevelSet()) {
                    serverMBeanImpl.setStdoutSeverityLevel(this.bean.getStdoutSeverityLevel());
                }
                if ((list == null || !list.contains("SupportedProtocols")) && this.bean.isSupportedProtocolsSet()) {
                    object = this.bean.getSupportedProtocols();
                    serverMBeanImpl.setSupportedProtocols(object == null ? null : (String[])object.clone());
                }
                if ((list == null || !list.contains("SystemPasswordEncrypted")) && this.bean.isSystemPasswordEncryptedSet()) {
                    object = this.bean.getSystemPasswordEncrypted();
                    serverMBeanImpl.setSystemPasswordEncrypted(object == null ? null : (byte[])((byte[])object).clone());
                }
                if ((list == null || !list.contains("ThreadPoolSize")) && this.bean.isThreadPoolSizeSet()) {
                    serverMBeanImpl.setThreadPoolSize(this.bean.getThreadPoolSize());
                }
                if ((list == null || !list.contains("TransactionLogFilePrefix")) && this.bean.isTransactionLogFilePrefixSet()) {
                    serverMBeanImpl.setTransactionLogFilePrefix(this.bean.getTransactionLogFilePrefix());
                }
                if ((list == null || !list.contains("TransactionLogFileWritePolicy")) && this.bean.isTransactionLogFileWritePolicySet()) {
                    serverMBeanImpl.setTransactionLogFileWritePolicy(this.bean.getTransactionLogFileWritePolicy());
                }
                if (!(list != null && list.contains("TransactionLogJDBCStore") || !this.bean.isTransactionLogJDBCStoreSet() || serverMBeanImpl._isSet(210))) {
                    object = this.bean.getTransactionLogJDBCStore();
                    serverMBeanImpl.setTransactionLogJDBCStore(null);
                    serverMBeanImpl.setTransactionLogJDBCStore(object == null ? null : (TransactionLogJDBCStoreMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("TunnelingClientPingSecs")) && this.bean.isTunnelingClientPingSecsSet()) {
                    serverMBeanImpl.setTunnelingClientPingSecs(this.bean.getTunnelingClientPingSecs());
                }
                if ((list == null || !list.contains("TunnelingClientTimeoutSecs")) && this.bean.isTunnelingClientTimeoutSecsSet()) {
                    serverMBeanImpl.setTunnelingClientTimeoutSecs(this.bean.getTunnelingClientTimeoutSecs());
                }
                if ((list == null || !list.contains("UploadDirectoryName")) && this.bean.isUploadDirectoryNameSet()) {
                    serverMBeanImpl.setUploadDirectoryName(this.bean.getUploadDirectoryName());
                }
                if ((list == null || !list.contains("VerboseEJBDeploymentEnabled")) && this.bean.isVerboseEJBDeploymentEnabledSet()) {
                    serverMBeanImpl.setVerboseEJBDeploymentEnabled(this.bean.getVerboseEJBDeploymentEnabled());
                }
                if ((list == null || !list.contains("VirtualMachineName")) && this.bean.isVirtualMachineNameSet()) {
                    serverMBeanImpl.setVirtualMachineName(this.bean.getVirtualMachineName());
                }
                if (!(list != null && list.contains("WebServer") || !this.bean.isWebServerSet() || serverMBeanImpl._isSet(90))) {
                    object = this.bean.getWebServer();
                    serverMBeanImpl.setWebServer(null);
                    serverMBeanImpl.setWebServer(object == null ? null : (WebServerMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if (!(list != null && list.contains("WebService") || !this.bean.isWebServiceSet() || serverMBeanImpl._isSet(205))) {
                    object = this.bean.getWebService();
                    serverMBeanImpl.setWebService(null);
                    serverMBeanImpl.setWebService(object == null ? null : (WebServiceMBean)this.createCopy((AbstractDescriptorBean)object, bl));
                }
                if ((list == null || !list.contains("XMLEntityCache")) && this.bean.isXMLEntityCacheSet()) {
                    serverMBeanImpl._unSet(serverMBeanImpl, 126);
                    serverMBeanImpl.setXMLEntityCacheAsString(this.bean.getXMLEntityCacheAsString());
                }
                if ((list == null || !list.contains("XMLRegistry")) && this.bean.isXMLRegistrySet()) {
                    serverMBeanImpl._unSet(serverMBeanImpl, 125);
                    serverMBeanImpl.setXMLRegistryAsString(this.bean.getXMLRegistryAsString());
                }
                if ((list == null || !list.contains("AdministrationPortEnabled")) && this.bean.isAdministrationPortEnabledSet()) {
                    serverMBeanImpl.setAdministrationPortEnabled(this.bean.isAdministrationPortEnabled());
                }
                if ((list == null || !list.contains("AutoMigrationEnabled")) && this.bean.isAutoMigrationEnabledSet()) {
                    serverMBeanImpl.setAutoMigrationEnabled(this.bean.isAutoMigrationEnabled());
                }
                if ((list == null || !list.contains("COMEnabled")) && this.bean.isCOMEnabledSet()) {
                    serverMBeanImpl.setCOMEnabled(this.bean.isCOMEnabled());
                }
                if ((list == null || !list.contains("ClasspathServletDisabled")) && this.bean.isClasspathServletDisabledSet()) {
                    serverMBeanImpl.setClasspathServletDisabled(this.bean.isClasspathServletDisabled());
                }
                if ((list == null || !list.contains("ClientCertProxyEnabled")) && this.bean.isClientCertProxyEnabledSet()) {
                    serverMBeanImpl.setClientCertProxyEnabled(this.bean.isClientCertProxyEnabled());
                }
                if ((list == null || !list.contains("ConsoleInputEnabled")) && this.bean.isConsoleInputEnabledSet()) {
                    serverMBeanImpl.setConsoleInputEnabled(this.bean.isConsoleInputEnabled());
                }
                if ((list == null || !list.contains("DefaultInternalServletsDisabled")) && this.bean.isDefaultInternalServletsDisabledSet()) {
                    serverMBeanImpl.setDefaultInternalServletsDisabled(this.bean.isDefaultInternalServletsDisabled());
                }
                if (bl && (list == null || !list.contains("EnabledForDomainLog")) && this.bean.isEnabledForDomainLogSet()) {
                    serverMBeanImpl.setEnabledForDomainLog(this.bean.isEnabledForDomainLog());
                }
                if ((list == null || !list.contains("HttpTraceSupportEnabled")) && this.bean.isHttpTraceSupportEnabledSet()) {
                    serverMBeanImpl.setHttpTraceSupportEnabled(this.bean.isHttpTraceSupportEnabled());
                }
                if ((list == null || !list.contains("HttpdEnabled")) && this.bean.isHttpdEnabledSet()) {
                    serverMBeanImpl.setHttpdEnabled(this.bean.isHttpdEnabled());
                }
                if ((list == null || !list.contains("IIOPEnabled")) && this.bean.isIIOPEnabledSet()) {
                    serverMBeanImpl.setIIOPEnabled(this.bean.isIIOPEnabled());
                }
                if ((list == null || !list.contains("IgnoreSessionsDuringShutdown")) && this.bean.isIgnoreSessionsDuringShutdownSet()) {
                    serverMBeanImpl.setIgnoreSessionsDuringShutdown(this.bean.isIgnoreSessionsDuringShutdown());
                }
                if ((list == null || !list.contains("J2EE12OnlyModeEnabled")) && this.bean.isJ2EE12OnlyModeEnabledSet()) {
                    serverMBeanImpl.setJ2EE12OnlyModeEnabled(this.bean.isJ2EE12OnlyModeEnabled());
                }
                if ((list == null || !list.contains("J2EE13WarningEnabled")) && this.bean.isJ2EE13WarningEnabledSet()) {
                    serverMBeanImpl.setJ2EE13WarningEnabled(this.bean.isJ2EE13WarningEnabled());
                }
                if ((list == null || !list.contains("JDBCLoggingEnabled")) && this.bean.isJDBCLoggingEnabledSet()) {
                    serverMBeanImpl.setJDBCLoggingEnabled(this.bean.isJDBCLoggingEnabled());
                }
                if ((list == null || !list.contains("JMSDefaultConnectionFactoriesEnabled")) && this.bean.isJMSDefaultConnectionFactoriesEnabledSet()) {
                    serverMBeanImpl.setJMSDefaultConnectionFactoriesEnabled(this.bean.isJMSDefaultConnectionFactoriesEnabled());
                }
                if ((list == null || !list.contains("JRMPEnabled")) && this.bean.isJRMPEnabledSet()) {
                    serverMBeanImpl.setJRMPEnabled(this.bean.isJRMPEnabled());
                }
                if ((list == null || !list.contains("ListenPortEnabled")) && this.bean.isListenPortEnabledSet()) {
                    serverMBeanImpl.setListenPortEnabled(this.bean.isListenPortEnabled());
                }
                if ((list == null || !list.contains("MSIFileReplicationEnabled")) && this.bean.isMSIFileReplicationEnabledSet()) {
                    serverMBeanImpl.setMSIFileReplicationEnabled(this.bean.isMSIFileReplicationEnabled());
                }
                if ((list == null || !list.contains("ManagedServerIndependenceEnabled")) && this.bean.isManagedServerIndependenceEnabledSet()) {
                    serverMBeanImpl.setManagedServerIndependenceEnabled(this.bean.isManagedServerIndependenceEnabled());
                }
                if ((list == null || !list.contains("MessageIdPrefixEnabled")) && this.bean.isMessageIdPrefixEnabledSet()) {
                    serverMBeanImpl.setMessageIdPrefixEnabled(this.bean.isMessageIdPrefixEnabled());
                }
                if ((list == null || !list.contains("NetworkClassLoadingEnabled")) && this.bean.isNetworkClassLoadingEnabledSet()) {
                    serverMBeanImpl.setNetworkClassLoadingEnabled(this.bean.isNetworkClassLoadingEnabled());
                }
                if (bl && (list == null || !list.contains("StdoutDebugEnabled")) && this.bean.isStdoutDebugEnabledSet()) {
                    serverMBeanImpl.setStdoutDebugEnabled(this.bean.isStdoutDebugEnabled());
                }
                if (bl && (list == null || !list.contains("StdoutEnabled")) && this.bean.isStdoutEnabledSet()) {
                    serverMBeanImpl.setStdoutEnabled(this.bean.isStdoutEnabled());
                }
                if (bl && (list == null || !list.contains("StdoutLogStack")) && this.bean.isStdoutLogStackSet()) {
                    serverMBeanImpl.setStdoutLogStack(this.bean.isStdoutLogStack());
                }
                if ((list == null || !list.contains("TGIOPEnabled")) && this.bean.isTGIOPEnabledSet()) {
                    serverMBeanImpl.setTGIOPEnabled(this.bean.isTGIOPEnabled());
                }
                if ((list == null || !list.contains("TunnelingEnabled")) && this.bean.isTunnelingEnabledSet()) {
                    serverMBeanImpl.setTunnelingEnabled(this.bean.isTunnelingEnabled());
                }
                if ((list == null || !list.contains("UseFusionForLLR")) && this.bean.isUseFusionForLLRSet()) {
                    serverMBeanImpl.setUseFusionForLLR(this.bean.isUseFusionForLLR());
                }
                if ((list == null || !list.contains("WeblogicPluginEnabled")) && this.bean.isWeblogicPluginEnabledSet()) {
                    serverMBeanImpl.setWeblogicPluginEnabled(this.bean.isWeblogicPluginEnabled());
                }
                return serverMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getCOM(), clazz, object);
            this.inferSubTree(this.bean.getCandidateMachines(), clazz, object);
            this.inferSubTree(this.bean.getCluster(), clazz, object);
            this.inferSubTree(this.bean.getCoherenceClusterSystemResource(), clazz, object);
            this.inferSubTree(this.bean.getDataSource(), clazz, object);
            this.inferSubTree(this.bean.getDefaultFileStore(), clazz, object);
            this.inferSubTree(this.bean.getDomainLogFilter(), clazz, object);
            this.inferSubTree(this.bean.getFederationServices(), clazz, object);
            this.inferSubTree(this.bean.getJTAMigratableTarget(), clazz, object);
            this.inferSubTree(this.bean.getKernelDebug(), clazz, object);
            this.inferSubTree(this.bean.getMachine(), clazz, object);
            this.inferSubTree(this.bean.getNetworkAccessPoints(), clazz, object);
            this.inferSubTree(this.bean.getOverloadProtection(), clazz, object);
            this.inferSubTree(this.bean.getReliableDeliveryPolicy(), clazz, object);
            this.inferSubTree(this.bean.getServerDebug(), clazz, object);
            this.inferSubTree(this.bean.getServerDiagnosticConfig(), clazz, object);
            this.inferSubTree(this.bean.getServerStart(), clazz, object);
            this.inferSubTree(this.bean.getSingleSignOnServices(), clazz, object);
            this.inferSubTree(this.bean.getTransactionLogJDBCStore(), clazz, object);
            this.inferSubTree(this.bean.getWebServer(), clazz, object);
            this.inferSubTree(this.bean.getWebService(), clazz, object);
            this.inferSubTree(this.bean.getXMLEntityCache(), clazz, object);
            this.inferSubTree(this.bean.getXMLRegistry(), clazz, object);
        }
    }
}

