/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.configuration.KernelMBeanImplBeanInfo;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerMBeanImpl;
import weblogic.management.internal.mbean.BeanInfoHelper;

public class ServerMBeanImplBeanInfo
extends KernelMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = ServerMBean.class;

    public ServerMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public ServerMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = ServerMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.management.configuration");
        String string = new String("<p>This class represents a WebLogic Server. A WebLogic Server is a Java process that is a container for J2EE applications.</p>  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime. </p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.configuration.ServerMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("AcceptBacklog")) {
            string2 = "getAcceptBacklog";
            string = null;
            if (!this.readOnly) {
                string = "setAcceptBacklog";
            }
            propertyDescriptor = new PropertyDescriptor("AcceptBacklog", ServerMBean.class, string2, string);
            map.put("AcceptBacklog", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of backlogged, new TCP connection requests that should be allowed for this server's regular and SSL ports.</p>  <p>Setting the backlog to <code>0</code> may prevent this server from accepting any incoming connection on some operating systems.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getListenPort"), BeanInfoHelper.encodeEntities((String)"#getAcceptBacklog"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getAcceptBacklog")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(300));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("AdminReconnectIntervalSeconds")) {
            string2 = "getAdminReconnectIntervalSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setAdminReconnectIntervalSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("AdminReconnectIntervalSeconds", ServerMBean.class, string2, string);
            map.put("AdminReconnectIntervalSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds between reconnection attempts to the admin server. When the admin server fails the managed server will periodically try to connect back to it.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("AdministrationPort")) {
            string2 = "getAdministrationPort";
            string = null;
            if (!this.readOnly) {
                string = "setAdministrationPort";
            }
            propertyDescriptor = new PropertyDescriptor("AdministrationPort", ServerMBean.class, string2, string);
            map.put("AdministrationPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The secure administration port for the server. This port requires that you enable the domain's administration port and that SSL is configured and enabled.</p>  <p>By default, the server uses the administration port that is specified at the domain level. To override the domain-level administration port for the current server instance, set this server's administration port. ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.DomainMBean#isAdministrationPortEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.DomainMBean#getAdministrationPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("secureValue", new Integer(7002));
            propertyDescriptor.setValue("legalMax", new Integer(65535));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("AutoKillIfFailed")) {
            string2 = "getAutoKillIfFailed";
            string = null;
            if (!this.readOnly) {
                string = "setAutoKillIfFailed";
            }
            propertyDescriptor = new PropertyDescriptor("AutoKillIfFailed", ServerMBean.class, string2, string);
            map.put("AutoKillIfFailed", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the Node Manager should automatically kill this server if its health state is <code>failed</code>.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("AutoRestart")) {
            string2 = "getAutoRestart";
            string = null;
            if (!this.readOnly) {
                string = "setAutoRestart";
            }
            propertyDescriptor = new PropertyDescriptor("AutoRestart", ServerMBean.class, string2, string);
            map.put("AutoRestart", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the Node Manager can automatically restart this server if it crashes or otherwise goes down unexpectedly.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("COM")) {
            string2 = "getCOM";
            string = null;
            propertyDescriptor = new PropertyDescriptor("COM", ServerMBean.class, string2, string);
            map.put("COM", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the server's COM configuration.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("CandidateMachines")) {
            string2 = "getCandidateMachines";
            string = null;
            if (!this.readOnly) {
                string = "setCandidateMachines";
            }
            propertyDescriptor = new PropertyDescriptor("CandidateMachines", ServerMBean.class, string2, string);
            map.put("CandidateMachines", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Limits the list of candidate machines that the cluster specifies. (Requires you to enable this server for automatic migration and to configure the cluster with a set of candidate machines.)</p>  <p>If this server fails and if it is enabled for automatic migration, Node Manager automatically restarts it. By default, Node Manager restarts the server on any of the candidate machines that the cluster specifies (in order of preference that you configured in the cluster). To change the default, you use this server's list of candidate machines to create a subset of the cluster-wide candidates. You can also change the order of preference.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"ClusterMBean#getCandidateMachines")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("Cluster")) {
            string2 = "getCluster";
            string = null;
            if (!this.readOnly) {
                string = "setCluster";
            }
            propertyDescriptor = new PropertyDescriptor("Cluster", ServerMBean.class, string2, string);
            map.put("Cluster", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The cluster, or group of WebLogic Server instances, to which this server belongs.</p>  <p>If set, the server will listen for cluster multicast events.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getClusterWeight"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ClusterMBean#getMulticastPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ClusterMBean#getMulticastAddress")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("ClusterRuntime")) {
            string2 = "getClusterRuntime";
            string = null;
            if (!this.readOnly) {
                string = "setClusterRuntime";
            }
            propertyDescriptor = new PropertyDescriptor("ClusterRuntime", ServerMBean.class, string2, string);
            map.put("ClusterRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>This method is unsupported and always returns null. Use ServerRuntimeMBean.getClusterRuntime instead.</p> ");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
        }
        if (!map.containsKey("ClusterWeight")) {
            string2 = "getClusterWeight";
            string = null;
            if (!this.readOnly) {
                string = "setClusterWeight";
            }
            propertyDescriptor = new PropertyDescriptor("ClusterWeight", ServerMBean.class, string2, string);
            map.put("ClusterWeight", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The proportion of the load that this server will bear, relative to other servers in a cluster.</p>  <p>If all servers have the default weight or the same weight, each bears an equal proportion of the load. If one server has weight 50 and all other servers have weight 100, the 50-weight server will bear half as much load as any other server.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getCluster")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(100));
            propertyDescriptor.setValue("legalMax", new Integer(100));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("CoherenceClusterSystemResource")) {
            string2 = "getCoherenceClusterSystemResource";
            string = null;
            if (!this.readOnly) {
                string = "setCoherenceClusterSystemResource";
            }
            propertyDescriptor = new PropertyDescriptor("CoherenceClusterSystemResource", ServerMBean.class, string2, string);
            map.put("CoherenceClusterSystemResource", propertyDescriptor);
            propertyDescriptor.setValue("description", "The system-level Coherence cluster resource associated with this server. ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("ConsensusProcessIdentifier")) {
            string2 = "getConsensusProcessIdentifier";
            string = null;
            if (!this.readOnly) {
                string = "setConsensusProcessIdentifier";
            }
            propertyDescriptor = new PropertyDescriptor("ConsensusProcessIdentifier", ServerMBean.class, string2, string);
            map.put("ConsensusProcessIdentifier", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies the identifier to be used for consensus-based algorithms. Each server should have a unique identifier indexed from 0.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(65535));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("CustomIdentityKeyStoreFileName")) {
            string2 = "getCustomIdentityKeyStoreFileName";
            string = null;
            if (!this.readOnly) {
                string = "setCustomIdentityKeyStoreFileName";
            }
            propertyDescriptor = new PropertyDescriptor("CustomIdentityKeyStoreFileName", ServerMBean.class, string2, string);
            map.put("CustomIdentityKeyStoreFileName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The path and file name of the identity keystore.</p>  <p>The path name must either be absolute or relative to where the server was booted. The custom identity key store file name is only used if KeyStores is CUSTOM_IDENTITY_AND_JAVA_STANDARD_TRUST, CUSTOM_IDENTITY_AND_CUSTOM_TRUST or CUSTOM_IDENTITY_AND_COMMAND_LINE_TRUST.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CustomIdentityKeyStorePassPhrase")) {
            string2 = "getCustomIdentityKeyStorePassPhrase";
            string = null;
            if (!this.readOnly) {
                string = "setCustomIdentityKeyStorePassPhrase";
            }
            propertyDescriptor = new PropertyDescriptor("CustomIdentityKeyStorePassPhrase", ServerMBean.class, string2, string);
            map.put("CustomIdentityKeyStorePassPhrase", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted custom identity keystore's passphrase. If empty or null, then the keystore will be opened without a passphrase.</p>  <p>This attribute is only used if KeyStores is CUSTOM_IDENTITY_AND_JAVA_STANDARD_TRUST, CUSTOM_IDENTITY_AND_CUSTOM_TRUST or CUSTOM_IDENTITY_AND_COMMAND_LINE_TRUST.</p>  <p>When you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>CustomIdentityKeyStorePassPhraseEncrypted</code> attribute.</li> <li>Decrypts the value and returns the unencrypted password as a String.</li> </ol>  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>CustomIdentityKeyStorePassPhraseEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this attribute (<code>CustomIdentityKeyStorePassPhrase</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>CustomIdentityKeyStorePassPhraseEncrypted</code>.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getCustomIdentityKeyStorePassPhraseEncrypted()")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("CustomIdentityKeyStorePassPhraseEncrypted")) {
            string2 = "getCustomIdentityKeyStorePassPhraseEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setCustomIdentityKeyStorePassPhraseEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("CustomIdentityKeyStorePassPhraseEncrypted", ServerMBean.class, string2, string);
            map.put("CustomIdentityKeyStorePassPhraseEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns encrypted pass phrase defined when creating the keystore.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CustomIdentityKeyStoreType")) {
            string2 = "getCustomIdentityKeyStoreType";
            string = null;
            if (!this.readOnly) {
                string = "setCustomIdentityKeyStoreType";
            }
            propertyDescriptor = new PropertyDescriptor("CustomIdentityKeyStoreType", ServerMBean.class, string2, string);
            map.put("CustomIdentityKeyStoreType", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The type of the keystore. Generally, this is <code>JKS</code>.</p>  <p>If empty or null, then the JDK's default keystore type (specified in <code>java.security</code>) is used. The custom identity key store type is only used if KeyStores is CUSTOM_IDENTITY_AND_JAVA_STANDARD_TRUST, CUSTOM_IDENTITY_AND_CUSTOM_TRUST or CUSTOM_IDENTITY_AND_COMMAND_LINE_TRUST.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CustomTrustKeyStoreFileName")) {
            string2 = "getCustomTrustKeyStoreFileName";
            string = null;
            if (!this.readOnly) {
                string = "setCustomTrustKeyStoreFileName";
            }
            propertyDescriptor = new PropertyDescriptor("CustomTrustKeyStoreFileName", ServerMBean.class, string2, string);
            map.put("CustomTrustKeyStoreFileName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The path and file name of the custom trust keystore.</p>  <p>The path name must either be absolute or relative to where the server was booted. This file name is only used if KeyStores is CUSTOM_IDENTITY_AND_CUSTOM_TRUST.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CustomTrustKeyStorePassPhrase")) {
            string2 = "getCustomTrustKeyStorePassPhrase";
            string = null;
            if (!this.readOnly) {
                string = "setCustomTrustKeyStorePassPhrase";
            }
            propertyDescriptor = new PropertyDescriptor("CustomTrustKeyStorePassPhrase", ServerMBean.class, string2, string);
            map.put("CustomTrustKeyStorePassPhrase", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The custom trust keystore's passphrase. If empty or null, then the keystore will be opened without a passphrase.</p>  <p>This attribute is only used if KeyStores is CUSTOM_IDENTITY_AND_CUSTOM_TRUST.</p>  <p>When you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>CustomTrustKeyStorePassPhraseEncrypted</code> attribute.</li> <li>Decrypts the value and returns the unencrypted password as a String.</li> </ol>  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>CustomTrustKeyStorePassPhraseEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this attribute (<code>CustomTrustKeyStorePassPhrase</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>CustomTrustKeyStorePassPhraseEncrypted</code>.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getCustomTrustKeyStorePassPhraseEncrypted()")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("CustomTrustKeyStorePassPhraseEncrypted")) {
            string2 = "getCustomTrustKeyStorePassPhraseEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setCustomTrustKeyStorePassPhraseEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("CustomTrustKeyStorePassPhraseEncrypted", ServerMBean.class, string2, string);
            map.put("CustomTrustKeyStorePassPhraseEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The custom trust keystore's encrypted passphrase. If empty or null, then the keystore will be opened without a passphrase.</p>  <p>This attribute is only used if KeyStores is CUSTOM_IDENTITY_AND_CUSTOM_TRUST.</p>  <p>To set this attribute, use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method. </p>  <p>To compare a password that a user enters with the encrypted value of this attribute, use the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CustomTrustKeyStoreType")) {
            string2 = "getCustomTrustKeyStoreType";
            string = null;
            if (!this.readOnly) {
                string = "setCustomTrustKeyStoreType";
            }
            propertyDescriptor = new PropertyDescriptor("CustomTrustKeyStoreType", ServerMBean.class, string2, string);
            map.put("CustomTrustKeyStoreType", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The type of the keystore. Generally, this is <code>JKS</code>.</p>  <p>If empty or null, then the JDK's default keystore type (specified in java.security) is used. This keystore type is only used if KeyStores is CUSTOM_IDENTITY_AND_CUSTOM_TRUST.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DataSource")) {
            string2 = "getDataSource";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DataSource", ServerMBean.class, string2, string);
            map.put("DataSource", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The data source configured for the persistent TLOG JDBC store used for transaction logging. A server has exactly one DataSource.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("DefaultFileStore")) {
            string2 = "getDefaultFileStore";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DefaultFileStore", ServerMBean.class, string2, string);
            map.put("DefaultFileStore", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Controls the configuration of the default persistent store on this server. Each server has a default store, which is a file-based object repository used by various subsystems.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("DefaultIIOPPassword")) {
            string2 = "getDefaultIIOPPassword";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultIIOPPassword";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultIIOPPassword", ServerMBean.class, string2, string);
            map.put("DefaultIIOPPassword", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The password for the default IIOP user. (Requires you to enable IIOP.)</p> <p>As of 8.1 sp4, when you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>DefaultIIOPPasswordEncrypted</code> attribute.</li> <li>Decrypts the value and returns the unencrypted password as a String.</li> </ol>  <p>Using this attribute (<code>DefaultIIOPPassword</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>DefaultIIOPPasswordEncrypted</code>.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isIIOPEnabled"), BeanInfoHelper.encodeEntities((String)"#getDefaultIIOPPasswordEncrypted()")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultIIOPPasswordEncrypted")) {
            string2 = "getDefaultIIOPPasswordEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultIIOPPasswordEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultIIOPPasswordEncrypted", ServerMBean.class, string2, string);
            map.put("DefaultIIOPPasswordEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted password for the default IIOP user.</p> <p>To set this attribute, use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method.</p>  <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultIIOPUser")) {
            string2 = "getDefaultIIOPUser";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultIIOPUser";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultIIOPUser", ServerMBean.class, string2, string);
            map.put("DefaultIIOPUser", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The user name of the default IIOP user. (Requires you to enable IIOP.)</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isIIOPEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultTGIOPPassword")) {
            string2 = "getDefaultTGIOPPassword";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultTGIOPPassword";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultTGIOPPassword", ServerMBean.class, string2, string);
            map.put("DefaultTGIOPPassword", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The password for the default user associated with the Tuxedo GIOP (TGIOP) protocol. (Requires you to configure WebLogic Tuxedo Connector (WTC) for this server.)</p>  <p>As of 8.1 sp4, when you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>DefaultTGIOPPasswordEncrypted</code> attribute.</li> <li>Decrypts the value and returns the unencrypted password as a String.</li> </ol> <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>DefaultTGIOPPasswordEncrypted</code> attribute to the encrypted value.</li> </ol>  <p>Using this attribute (<code>DefaultTGIOPPassword</code>) is a potential security risk in because the String object (which contains the unencrypted password) remains the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>DefaultTGIOPPasswordEncrypted</code>.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getDefaultTGIOPPasswordEncrypted()")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultTGIOPPasswordEncrypted")) {
            string2 = "getDefaultTGIOPPasswordEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultTGIOPPasswordEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultTGIOPPasswordEncrypted", ServerMBean.class, string2, string);
            map.put("DefaultTGIOPPasswordEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted password for the default TGIOP user.</p>  <p>To set this attribute, use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method.</p>  <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultTGIOPUser")) {
            string2 = "getDefaultTGIOPUser";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultTGIOPUser";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultTGIOPUser", ServerMBean.class, string2, string);
            map.put("DefaultTGIOPUser", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The default user associated with the Tuxedo GIOP (TGIOP) protocol. (Requires you to configure WebLogic Tuxedo Connector (WTC) for this server.)</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"guest");
            propertyDescriptor.setValue("secureValueNull", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("DomainLogFilter")) {
            string2 = "getDomainLogFilter";
            string = null;
            if (!this.readOnly) {
                string = "setDomainLogFilter";
            }
            propertyDescriptor = new PropertyDescriptor("DomainLogFilter", ServerMBean.class, string2, string);
            map.put("DomainLogFilter", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Determines which messages this server sends to the domain log. (Requires you to enable domain logging for this server.)</p> <p>If you specify <code>none</code>, the server sends all messages of severity <code>WARNING</code> and higher. This list contains all Domain Log Filters that have been defined for the domain. A server can user only one Domain Log Filter.</p> ");
            propertyDescriptor.setValue("secureValue", "none");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by LogMBean.LogBroadcastFilter The severity of messages going to the domain log is configured separately through LogMBean.LogBroadcastSeverity, For backward compatibility the changes to this attribute will be propagated to the LogMBean. ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("ExpectedToRun")) {
            string2 = "getExpectedToRun";
            string = null;
            if (!this.readOnly) {
                string = "setExpectedToRun";
            }
            propertyDescriptor = new PropertyDescriptor("ExpectedToRun", ServerMBean.class, string2, string);
            map.put("ExpectedToRun", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>If this server expected to run if the domain is started.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#stop"), BeanInfoHelper.encodeEntities((String)"#kill")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("ExternalDNSName")) {
            string2 = "getExternalDNSName";
            string = null;
            if (!this.readOnly) {
                string = "setExternalDNSName";
            }
            propertyDescriptor = new PropertyDescriptor("ExternalDNSName", ServerMBean.class, string2, string);
            map.put("ExternalDNSName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The external IP address or DNS name for this server.</p>  <p>This address will be sent with HTTP session cookies and with dynamic server lists to HTTP proxies. It will also be used by external application clients to enable the propagation of RMI traffic through network address translating (NAT) firewalls.</p>  <p>You must specify an external DNS name for configurations in which a firewall is performing network address translation, unless clients are accessing WebLogic Server using t3 and the default channel. For example, define the external DNS name for configurations in which a firewall is performing network address translation, and clients are accessing WebLogic Server using HTTP via a proxy plug-in.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getListenAddress"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getExternalDNSName")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("ExtraEjbcOptions")) {
            string2 = "getExtraEjbcOptions";
            string = null;
            if (!this.readOnly) {
                string = "setExtraEjbcOptions";
            }
            propertyDescriptor = new PropertyDescriptor("ExtraEjbcOptions", ServerMBean.class, string2, string);
            map.put("ExtraEjbcOptions", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The options passed to the EJB compiler during server-side generation.</p>  <p>Each EJB component can override the compiler options that you specify here. The following options are valid:</p>  <dl> <dt>-forcegeneration</dt> <dd>Forces generation of wrapper classes. Without this flag the classes may not be regenerated if it is determined to be unnecessary.</dd>  <dt>-disableHotCodeGen</dt> <dd>Generate ejb stub and skel as part of ejbc. Avoid HotCodeGen to have better performance. </dd>  <dt>-keepgenerated</dt> <dd>Keep the generated .java files.</dd>   <dt>-compiler javac</dt> <dd>Java compiler to exec.  If not specified, the -compilerclass option will be used.</dd>  <dt>-compilerclass com.sun.tools.javac.Main</dt> <dd>Specifies the compiler class to invoke.</dd>  <dt>-g</dt> <dd>Compile debugging info into class file.</dd>  <dt>-normi</dt> <dd>Passed through to Symantec's sj.</dd>  <dt>-classpath path</dt> <dd>Classpath to use.</dd>  <dt>-source source</dt> <dd>Source version.</dd>  <dt>-J<i>option</i></dt> <dd>Flags passed through to java runtime.</dd> </dl> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.EJBContainerMBean#getExtraEjbcOptions()")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
        }
        if (!map.containsKey("ExtraRmicOptions")) {
            string2 = "getExtraRmicOptions";
            string = null;
            if (!this.readOnly) {
                string = "setExtraRmicOptions";
            }
            propertyDescriptor = new PropertyDescriptor("ExtraRmicOptions", ServerMBean.class, string2, string);
            map.put("ExtraRmicOptions", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The options passed to the RMIC compiler during server-side generation.</p>  <p>Each EJB component can override the compiler options that you specify here.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.EJBContainerMBean#getExtraRmicOptions()")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.1.0.0", null, (String)this.targetVersion) && !map.containsKey("FederationServices")) {
            string2 = "getFederationServices";
            string = null;
            propertyDescriptor = new PropertyDescriptor("FederationServices", ServerMBean.class, string2, string);
            map.put("FederationServices", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Gets the Federation Services MBean</p> ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("since", "9.1.0.0");
        }
        if (!map.containsKey("GracefulShutdownTimeout")) {
            string2 = "getGracefulShutdownTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setGracefulShutdownTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("GracefulShutdownTimeout", ServerMBean.class, string2, string);
            map.put("GracefulShutdownTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Number of seconds a graceful shutdown operation waits before forcing a shut down. A graceful shutdown gives WebLogic Server subsystems time to complete certain application processing currently in progress. If subsystems are unable to complete processing within the number of seconds that you specify here, then the server will force shutdown automatically.</p>  <p>A value of <code>0</code> means that the server will wait indefinitely for graceful shutdown to complete.</p>  <p>The graceful shutdown timeout applies only to graceful shutdown operations.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getServerLifeCycleTimeoutVal")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("HealthCheckIntervalSeconds")) {
            string2 = "getHealthCheckIntervalSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setHealthCheckIntervalSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("HealthCheckIntervalSeconds", ServerMBean.class, string2, string);
            map.put("HealthCheckIntervalSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds that defines the frequency of this server's self-health monitoring. The server monitors the health of it's subsystems every HealthCheckIntervalSeconds and changes the Server's overall state if required. </p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(180));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("HealthCheckStartDelaySeconds")) {
            string2 = "getHealthCheckStartDelaySeconds";
            string = null;
            if (!this.readOnly) {
                string = "setHealthCheckStartDelaySeconds";
            }
            propertyDescriptor = new PropertyDescriptor("HealthCheckStartDelaySeconds", ServerMBean.class, string2, string);
            map.put("HealthCheckStartDelaySeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds the Node Manager should wait before starting to monitor the server.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(120));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("HealthCheckTimeoutSeconds")) {
            string2 = "getHealthCheckTimeoutSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setHealthCheckTimeoutSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("HealthCheckTimeoutSeconds", ServerMBean.class, string2, string);
            map.put("HealthCheckTimeoutSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds the Node Manager should wait before timing out its health query to this server.</p>  <p>If the timeout is reached, Node Managed assumes the Managed Server has failed.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(60));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by Server self-health monitoring that takes action without NodeManager intervention. NodeManager identifies if a running server was shutdown due to a restartable failure and restarts the server. ");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("HostsMigratableServices")) {
            string2 = "getHostsMigratableServices";
            string = null;
            propertyDescriptor = new PropertyDescriptor("HostsMigratableServices", ServerMBean.class, string2, string);
            map.put("HostsMigratableServices", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Gets the hostsMigratableServices attribute of the ServerMBean object</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("InterfaceAddress")) {
            string2 = "getInterfaceAddress";
            string = null;
            if (!this.readOnly) {
                string = "setInterfaceAddress";
            }
            propertyDescriptor = new PropertyDescriptor("InterfaceAddress", ServerMBean.class, string2, string);
            map.put("InterfaceAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The IP address of the NIC that this server should use for multicast traffic.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getCluster"), BeanInfoHelper.encodeEntities((String)"#setInterfaceAddress"), BeanInfoHelper.encodeEntities((String)"ClusterMBean#getMulticastAddress")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("JDBCLLRTableName")) {
            string2 = "getJDBCLLRTableName";
            string = null;
            if (!this.readOnly) {
                string = "setJDBCLLRTableName";
            }
            propertyDescriptor = new PropertyDescriptor("JDBCLLRTableName", ServerMBean.class, string2, string);
            map.put("JDBCLLRTableName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The table name for this server's Logging Last Resource (LLR) database table(s). WebLogic Server creates the table(s) and then uses them during transaction processing for the LLR transaction optimization. This setting must be unique for each server. The default table name is <code>WL_LLR_<i>SERVERNAME</i></code>.</p>  <p>This setting only applies if this server hosts one or more LLR-enabled JDBC data sources.</p>  <p>The format for the tables that WebLogic Server creates is [[[catalog.]schema.]name.] Each \".\" in the table name is significant, and schema generally corresponds to username in many databases.</p>  <p><b>IMPORTANT:</b> If this value is changed but the LLR table already exists in the database, you must preserve the existing table's data. Consequently, when changing the table name, the existing database table must be renamed by a database administrator to match the new configured table name. Otherwise, transaction records may be lost, resulting in heuristic failures that aren't logged.</p>  <p><b>IMPORTANT:</b> Each server's table name must be unique. Multiple LLR-enabled data sources within the same server may share the same table, but multiple servers must not share the same table. If multiple same-named servers share a table, the behavior is undefined and it is likely that transactions will not recover properly after a crash, creating heuristic hazards.</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("JDBCLogFileName")) {
            string2 = "getJDBCLogFileName";
            string = null;
            if (!this.readOnly) {
                string = "setJDBCLogFileName";
            }
            propertyDescriptor = new PropertyDescriptor("JDBCLogFileName", ServerMBean.class, string2, string);
            map.put("JDBCLogFileName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the JDBC log file. If the pathname is not absolute, it is assumed to be relative to the root directory of the machine on which this server is running. (Requires you to enable JDBC logging.)</p>  <p>If the log has no path element and is atomic (for example, <code>jdbc.log</code>), the file will be placed relative to the root directory in ./SERVER_NAME/ to avoid name space conflicts. This attribute is deprecated because the JDBC output now goes in the server log.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isJDBCLoggingEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"jdbc.log");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 ");
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("JDBCLoginTimeoutSeconds")) {
            string2 = "getJDBCLoginTimeoutSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setJDBCLoginTimeoutSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("JDBCLoginTimeoutSeconds", ServerMBean.class, string2, string);
            map.put("JDBCLoginTimeoutSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "The JDBC Login Timeout value. Specified value is passed into java.sql.DriverManager.setLoginTimeout(). Note that this DriverManager setting will impact *all* JDBC drivers loaded into this JVM. Feature is disabled by default. ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(300));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("JNDITransportableObjectFactoryList")) {
            string2 = "getJNDITransportableObjectFactoryList";
            string = null;
            if (!this.readOnly) {
                string = "setJNDITransportableObjectFactoryList";
            }
            propertyDescriptor = new PropertyDescriptor("JNDITransportableObjectFactoryList", ServerMBean.class, string2, string);
            map.put("JNDITransportableObjectFactoryList", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>List of factories that create transportable objects.</p> ");
        }
        if (!map.containsKey("JTAMigratableTarget")) {
            string2 = "getJTAMigratableTarget";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JTAMigratableTarget", ServerMBean.class, string2, string);
            map.put("JTAMigratableTarget", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the JTAMigratableTargetMBean that is used to deploy the JTA Recovery Service to (is the server's cluster is not null).</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("JavaCompiler")) {
            string2 = "getJavaCompiler";
            string = null;
            if (!this.readOnly) {
                string = "setJavaCompiler";
            }
            propertyDescriptor = new PropertyDescriptor("JavaCompiler", ServerMBean.class, string2, string);
            map.put("JavaCompiler", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The Java compiler to use for all applications hosted on this server that need to compile Java code.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"javac");
            propertyDescriptor.setValue("secureValue", "javac");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("JavaCompilerPostClassPath")) {
            string2 = "getJavaCompilerPostClassPath";
            string = null;
            if (!this.readOnly) {
                string = "setJavaCompilerPostClassPath";
            }
            propertyDescriptor = new PropertyDescriptor("JavaCompilerPostClassPath", ServerMBean.class, string2, string);
            map.put("JavaCompilerPostClassPath", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The options to append to the Java compiler classpath when compiling Java code.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("secureValueNull", Boolean.TRUE);
        }
        if (!map.containsKey("JavaCompilerPreClassPath")) {
            string2 = "getJavaCompilerPreClassPath";
            string = null;
            if (!this.readOnly) {
                string = "setJavaCompilerPreClassPath";
            }
            propertyDescriptor = new PropertyDescriptor("JavaCompilerPreClassPath", ServerMBean.class, string2, string);
            map.put("JavaCompilerPreClassPath", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The options to prepend to the Java compiler classpath when compiling Java code.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("secureValueNull", Boolean.TRUE);
        }
        if (!map.containsKey("JavaStandardTrustKeyStorePassPhrase")) {
            string2 = "getJavaStandardTrustKeyStorePassPhrase";
            string = null;
            if (!this.readOnly) {
                string = "setJavaStandardTrustKeyStorePassPhrase";
            }
            propertyDescriptor = new PropertyDescriptor("JavaStandardTrustKeyStorePassPhrase", ServerMBean.class, string2, string);
            map.put("JavaStandardTrustKeyStorePassPhrase", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The password for the Java Standard Trust keystore. This password is defined when the keystore is created.</p> <p>If empty or null, then the keystore will be opened without a passphrase.</p>  <p>This attribute is only used if KeyStores is CUSTOM_IDENTITY_AND_JAVA_STANDARD_TRUST or DEMO_IDENTITY_AND_DEMO_TRUST.</p>  <p>When you get the value of this attribute, WebLogic Server does the following:</p> <ol><li>Retrieves the value of the <code>JavaStandardTrustKeyStorePassPhraseEncrypted</code> attribute.</li> <li>Decrypts the value and returns the unencrypted password as a String.</li> </ol>  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>JavaStandardTrustKeyStorePassPhraseEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this attribute (<code>JavaStandardTrustKeyStorePassPhrase</code>) is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>JavaStandardTrustKeyStorePassPhraseEncrypted</code>.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getJavaStandardTrustKeyStorePassPhraseEncrypted()")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("JavaStandardTrustKeyStorePassPhraseEncrypted")) {
            string2 = "getJavaStandardTrustKeyStorePassPhraseEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setJavaStandardTrustKeyStorePassPhraseEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("JavaStandardTrustKeyStorePassPhraseEncrypted", ServerMBean.class, string2, string);
            map.put("JavaStandardTrustKeyStorePassPhraseEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted password for the Java Standard Trust keystore. This password is defined when the keystore is created.</p>  <p>To set this attribute,  use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method.</p>  <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("KernelDebug")) {
            string2 = "getKernelDebug";
            string = null;
            propertyDescriptor = new PropertyDescriptor("KernelDebug", ServerMBean.class, string2, string);
            map.put("KernelDebug", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the debug flags for this kernel (will return a KernelDebugMBean if this is a KernelMBean) or the server (will return a ServerDebugMBean if this is a ServerMBean)</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("KeyStores")) {
            string2 = "getKeyStores";
            string = null;
            if (!this.readOnly) {
                string = "setKeyStores";
            }
            propertyDescriptor = new PropertyDescriptor("KeyStores", ServerMBean.class, string2, string);
            map.put("KeyStores", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Which configuration rules should be used for finding the server's identity and trust keystores?</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"DemoIdentityAndDemoTrust");
            propertyDescriptor.setValue("legalValues", new Object[]{"DemoIdentityAndDemoTrust", "CustomIdentityAndJavaStandardTrust", "CustomIdentityAndCustomTrust", "CustomIdentityAndCommandLineTrust"});
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ListenAddress")) {
            string2 = "getListenAddress";
            string = null;
            if (!this.readOnly) {
                string = "setListenAddress";
            }
            propertyDescriptor = new PropertyDescriptor("ListenAddress", ServerMBean.class, string2, string);
            map.put("ListenAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The IP address or DNS name this server uses to listen for incoming connections.</p>  <p>Servers can be reached through the following URL:<br> <i>protocol://listen-address:listen-port</i></p>  <p>Any network channel that you configure for this server can override this listen address.</p>  <p>If a server's listen address is undefined, clients can reach the server through an IP address of the computer that hosts the server, a DNS name that resolves to the host, or the localhost string. The localhost string can be used only for requests from clients that running on the same computer as the server.</p>  <p>If you want to limit the valid addresses for a server instance, specify one of the following:</p>  <ul> <li> <p>If you provide an IP address, clients can specify either the IP address or a DNS name that maps to the IP address. Clients that specify an IP address and attempt to connect through an SSL port must disable hostname verification.</p> </li>  <li> <p>If you provide a DNS name, clients can specify either the DNS name or the corresponding IP address.</p> </li> </ul>  <p>Do not leave the listen address undefined on a computer that uses multiple IP address (a multihomed computer). On such a computer, the server will bind to all available IP addresses.</p>  <dl> <dt>Notes:</dt>  <dd> <p>To resolve a DNS name to an IP address, WebLogic Server must be able to contact an appropriate DNS server or obtain the IP address mapping locally. Therefore, if you specify a DNS name for the listen address, you must either leave a port open long enough for the WebLogic Server instance to connect to a DNS server and cache its mapping or you must specify the IP address mapping in a local file. If you specify an IP address for ListenAddress and then a client request specifies a DNS name, WebLogic Server will attempt to resolve the DNS name, but if it cannot access DNS name mapping, the request will fail.</p> <p>Note also that you are using the demo certificates in a multi-server domain, Managed Server instances will fail to boot if you specify the fully-qualified DNS name. For information about this limitation and suggested workarounds, see \"Limitation on CertGen Usage\" in <i>Securing Oracle WebLogic Server</i>. </dd> </dl> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getExternalDNSName"), BeanInfoHelper.encodeEntities((String)"#getListenPort"), BeanInfoHelper.encodeEntities((String)"#getInterfaceAddress"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#getListenPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getListenAddress")};
            propertyDescriptor.setValue("see", stringArray);
        }
        if (!map.containsKey("ListenDelaySecs")) {
            string2 = "getListenDelaySecs";
            string = null;
            if (!this.readOnly) {
                string = "setListenDelaySecs";
            }
            propertyDescriptor = new PropertyDescriptor("ListenDelaySecs", ServerMBean.class, string2, string);
            map.put("ListenDelaySecs", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Perpetuated for compatibility with 6.1 only.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("deprecated", " ");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("ListenPort")) {
            string2 = "getListenPort";
            string = null;
            if (!this.readOnly) {
                string = "setListenPort";
            }
            propertyDescriptor = new PropertyDescriptor("ListenPort", ServerMBean.class, string2, string);
            map.put("ListenPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The default TCP port that this server uses to listen for regular (non-SSL) incoming connections.</p>  <p>Administrators must have the right privileges before binding to a port or else this operation will not be successful and it will render the console un-reachable.</p>  <p>If this port is disabled, the SSL port must be enabled. Additional ports can be configured using network channels. The cluster (multicast) port is configured separately.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isListenPortEnabled"), BeanInfoHelper.encodeEntities((String)"#getAdministrationPort"), BeanInfoHelper.encodeEntities((String)"#getListenAddress"), BeanInfoHelper.encodeEntities((String)"#getCluster"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#getListenPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ClusterMBean#getMulticastPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getListenPort")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(7001));
            propertyDescriptor.setValue("legalMax", new Integer(65535));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ListenThreadStartDelaySecs")) {
            string2 = "getListenThreadStartDelaySecs";
            string = null;
            if (!this.readOnly) {
                string = "setListenThreadStartDelaySecs";
            }
            propertyDescriptor = new PropertyDescriptor("ListenThreadStartDelaySecs", ServerMBean.class, string2, string);
            map.put("ListenThreadStartDelaySecs", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the maximum time that the server will wait for server sockets to bind before starting a listen thread.</p>  <p>Properties to consider for removal</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(60));
        }
        if (!map.containsKey("ListenersBindEarly")) {
            string2 = "getListenersBindEarly";
            string = null;
            if (!this.readOnly) {
                string = "setListenersBindEarly";
            }
            propertyDescriptor = new PropertyDescriptor("ListenersBindEarly", ServerMBean.class, string2, string);
            map.put("ListenersBindEarly", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Determines whether the server should bind server sockets early.</p> Early binding detects port conflicts quickly and also gives user feedback on the default listen port as to the server state. ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("LoginTimeout")) {
            string2 = "getLoginTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setLoginTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("LoginTimeout", ServerMBean.class, string2, string);
            map.put("LoginTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "This does nothing. ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(1000));
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("LoginTimeoutMillis")) {
            string2 = "getLoginTimeoutMillis";
            string = null;
            if (!this.readOnly) {
                string = "setLoginTimeoutMillis";
            }
            propertyDescriptor = new PropertyDescriptor("LoginTimeoutMillis", ServerMBean.class, string2, string);
            map.put("LoginTimeoutMillis", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The login timeout for this server's default regular (non-SSL) listen port. This is the maximum amount of time allowed for a new connection to establish.</p>  <p>A value of <code>0</code> indicates there is no maximum.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#getLoginTimeoutMillis"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getLoginTimeoutMillis")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(5000));
            propertyDescriptor.setValue("secureValue", new Integer(5000));
            propertyDescriptor.setValue("legalMax", new Integer(100000));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("LowMemoryGCThreshold")) {
            string2 = "getLowMemoryGCThreshold";
            string = null;
            if (!this.readOnly) {
                string = "setLowMemoryGCThreshold";
            }
            propertyDescriptor = new PropertyDescriptor("LowMemoryGCThreshold", ServerMBean.class, string2, string);
            map.put("LowMemoryGCThreshold", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The threshold level (in percent) that this server uses for logging low memory conditions and changing the server health state to <tt>Warning</tt>.</p>  <p>For example, if you specify 5, the server logs a low memory warning in the log file and changes the server health state to <tt>Warning</tt> after the average free memory reaches 5% of the initial free memory measured at the server's boot time.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(5));
            propertyDescriptor.setValue("secureValue", new Integer(5));
            propertyDescriptor.setValue("legalMax", new Integer(99));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("LowMemoryGranularityLevel")) {
            string2 = "getLowMemoryGranularityLevel";
            string = null;
            if (!this.readOnly) {
                string = "setLowMemoryGranularityLevel";
            }
            propertyDescriptor = new PropertyDescriptor("LowMemoryGranularityLevel", ServerMBean.class, string2, string);
            map.put("LowMemoryGranularityLevel", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The granularity level (in percent) that this server uses for logging low memory conditions and changing the server health state to <tt>Warning</tt>.</p>  <p>For example, if you specify 5 and the average free memory drops by 5% or more over two measured intervals, the server logs a low memory warning in the log file and changes the server health state to <tt>Warning</tt>.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(5));
            propertyDescriptor.setValue("secureValue", new Integer(5));
            propertyDescriptor.setValue("legalMax", new Integer(100));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("LowMemorySampleSize")) {
            string2 = "getLowMemorySampleSize";
            string = null;
            if (!this.readOnly) {
                string = "setLowMemorySampleSize";
            }
            propertyDescriptor = new PropertyDescriptor("LowMemorySampleSize", ServerMBean.class, string2, string);
            map.put("LowMemorySampleSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of times this server samples free memory during the time period specified by LowMemoryTimeInterval.</p>  <p>Increasing the sample size can improve the accuracy of the reading.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("LowMemoryTimeInterval")) {
            string2 = "getLowMemoryTimeInterval";
            string = null;
            if (!this.readOnly) {
                string = "setLowMemoryTimeInterval";
            }
            propertyDescriptor = new PropertyDescriptor("LowMemoryTimeInterval", ServerMBean.class, string2, string);
            map.put("LowMemoryTimeInterval", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The amount of time (in seconds) that defines the interval over which this server determines average free memory values.</p>  <p>By default, the server obtains an average free memory value every 3600 seconds. This interval is not used if the JRockit VM is used, as the memory samples are collected immediately after a VM-scheduled garbage collection. Taking memory samples after a garbage collection gives a more accurate average value of the free memory.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3600));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(300));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("Machine")) {
            string2 = "getMachine";
            string = null;
            if (!this.readOnly) {
                string = "setMachine";
            }
            propertyDescriptor = new PropertyDescriptor("Machine", ServerMBean.class, string2, string);
            map.put("Machine", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The WebLogic Server host computer (machine) on which this server is meant to run.</p>  <p>If you want to use a Node Manager to start this server, you must assign the server to a machine and you must configure the machine for the Node Manager.</p>  <p>You cannot change this value if a server instance is already running.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.2.3.0", null, (String)this.targetVersion) && !map.containsKey("NMSocketCreateTimeoutInMillis")) {
            string2 = "getNMSocketCreateTimeoutInMillis";
            string = null;
            if (!this.readOnly) {
                string = "setNMSocketCreateTimeoutInMillis";
            }
            propertyDescriptor = new PropertyDescriptor("NMSocketCreateTimeoutInMillis", ServerMBean.class, string2, string);
            map.put("NMSocketCreateTimeoutInMillis", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the timeout value to be used by NodeManagerRuntime when creating a a socket connection to the agent. Default set high as SSH agent may require a high connection establishment time. ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(180000));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("since", "9.2.3.0");
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            if (!this.readOnly) {
                string = "setName";
            }
            propertyDescriptor = new PropertyDescriptor("Name", ServerMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>An alphanumeric name for this server instance. (Spaces are not valid.)</p>  <p>The name must be unique for all configuration objects in the domain. Within a domain, each server, machine, cluster, JDBC connection pool, virtual host, and any other resource type must be named uniquely and must not use the same name as the domain.</p>  <p>The server name is not used as part of the URL for applications that are deployed on the server. It is for your identification purposes only. The server name displays in the Administration Console, and if you use WebLogic Server command-line utilities or APIs, you use this name to identify the server.</p>  <p>After you have created a server, you cannot change its name. Instead, clone the server and provide a new name for the clone.</p> ");
            propertyDescriptor.setValue("key", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion) && !map.containsKey("NetworkAccessPoints")) {
            string2 = "getNetworkAccessPoints";
            string = null;
            if (!this.readOnly) {
                string = "setNetworkAccessPoints";
            }
            propertyDescriptor = new PropertyDescriptor("NetworkAccessPoints", ServerMBean.class, string2, string);
            map.put("NetworkAccessPoints", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Network access points, or \"NAPs\", define additional ports and addresses that this server listens on. Additionally, if two servers both support the same channel for a given protocol, then new connections between them will use that channel.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyNetworkAccessPoint");
            propertyDescriptor.setValue("creator", "createNetworkAccessPoint");
            propertyDescriptor.setValue("setterDeprecated", "9.0.0.0 Use createNetworkAccessPoint() instead. ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("since", "7.0.0.0");
        }
        if (!map.containsKey("OverloadProtection")) {
            string2 = "getOverloadProtection";
            string = null;
            propertyDescriptor = new PropertyDescriptor("OverloadProtection", ServerMBean.class, string2, string);
            map.put("OverloadProtection", propertyDescriptor);
            propertyDescriptor.setValue("description", "get attributes related to server overload protection ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("PreferredSecondaryGroup")) {
            string2 = "getPreferredSecondaryGroup";
            string = null;
            if (!this.readOnly) {
                string = "setPreferredSecondaryGroup";
            }
            propertyDescriptor = new PropertyDescriptor("PreferredSecondaryGroup", ServerMBean.class, string2, string);
            map.put("PreferredSecondaryGroup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Defines secondary clustered instances considered for hosting replicas of the primary HTTP session states created on the server.</p> ");
        }
        if (!map.containsKey("ReliableDeliveryPolicy")) {
            string2 = "getReliableDeliveryPolicy";
            string = null;
            if (!this.readOnly) {
                string = "setReliableDeliveryPolicy";
            }
            propertyDescriptor = new PropertyDescriptor("ReliableDeliveryPolicy", ServerMBean.class, string2, string);
            map.put("ReliableDeliveryPolicy", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The reliable delivery policy for web services.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("ReplicationGroup")) {
            string2 = "getReplicationGroup";
            string = null;
            if (!this.readOnly) {
                string = "setReplicationGroup";
            }
            propertyDescriptor = new PropertyDescriptor("ReplicationGroup", ServerMBean.class, string2, string);
            map.put("ReplicationGroup", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Defines preferred clustered instances considered for hosting replicas of the primary HTTP session states created on the server.</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.4.0", null, (String)this.targetVersion) && !map.containsKey("ReplicationPorts")) {
            string2 = "getReplicationPorts";
            string = null;
            if (!this.readOnly) {
                string = "setReplicationPorts";
            }
            propertyDescriptor = new PropertyDescriptor("ReplicationPorts", ServerMBean.class, string2, string);
            map.put("ReplicationPorts", propertyDescriptor);
            propertyDescriptor.setValue("description", "When WLS is running on Exalogic machines, cluster replication traffic could go over multiple replication channels. However multiple replication channels need not be configured on each clustered server instance. Only one replication channel with explicit IP-Address needs to be configured for each server and replicationPorts range can be specified for each server. For eg. range 7001-7010 will create 10 replication channels with ports 7001 to 7010 for the given server. These channels inherits all the properties of the configured replication channel except the listen port.Names of these channels will be derived from the configured replication channel with suffic {x} added where x could be 1,2.. as per the number of ports specified. Public ports are same as the listen port for these additional channels. ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "10.3.4.0");
        }
        if (!map.containsKey("RestartDelaySeconds")) {
            string2 = "getRestartDelaySeconds";
            string = null;
            if (!this.readOnly) {
                string = "setRestartDelaySeconds";
            }
            propertyDescriptor = new PropertyDescriptor("RestartDelaySeconds", ServerMBean.class, string2, string);
            map.put("RestartDelaySeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds the Node Manager should wait before restarting this server.</p>  <p>After killing a server process, the system might need several seconds to release the TCP port(s) the server was using. If Node Manager attempts to restart the Managed Server while its ports are still active, the startup attempt fails.</p>  <p>If AutoMigration is enabled and RestartDelaySeconds is 0, the RestartDelaySeconds is automatically set to the lease time. This prevents the server from failing to restart after migration when the previous lease is still valid.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("RestartIntervalSeconds")) {
            string2 = "getRestartIntervalSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setRestartIntervalSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("RestartIntervalSeconds", ServerMBean.class, string2, string);
            map.put("RestartIntervalSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds during which this server can be restarted, up to the number of times specified in RestartMax.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getRestartMax")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3600));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(300));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("RestartMax")) {
            string2 = "getRestartMax";
            string = null;
            if (!this.readOnly) {
                string = "setRestartMax";
            }
            propertyDescriptor = new PropertyDescriptor("RestartMax", ServerMBean.class, string2, string);
            map.put("RestartMax", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of times that the Node Manager can restart this server within the interval specified in RestartIntervalSeconds.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(2));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ServerDebug")) {
            string2 = "getServerDebug";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerDebug", ServerMBean.class, string2, string);
            map.put("ServerDebug", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The debug setting for this server.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("ServerDiagnosticConfig")) {
            string2 = "getServerDiagnosticConfig";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerDiagnosticConfig", ServerMBean.class, string2, string);
            map.put("ServerDiagnosticConfig", propertyDescriptor);
            propertyDescriptor.setValue("description", "The diagnostic configuration for the servers ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("ServerLifeCycleTimeoutVal")) {
            string2 = "getServerLifeCycleTimeoutVal";
            string = null;
            if (!this.readOnly) {
                string = "setServerLifeCycleTimeoutVal";
            }
            propertyDescriptor = new PropertyDescriptor("ServerLifeCycleTimeoutVal", ServerMBean.class, string2, string);
            map.put("ServerLifeCycleTimeoutVal", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Number of seconds a force shutdown operation waits before timing out and killing itself. If the operation does not complete within the configured timeout seconds, the server will shutdown automatically if the state of the server at that time was <code>SHUTTING_DOWN</code>.</p>  <p>A value of <code>0</code> means that the server will wait indefinitely for life cycle operation to complete.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(30));
            propertyDescriptor.setValue("secureValue", new Integer(120));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ServerStart")) {
            string2 = "getServerStart";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerStart", ServerMBean.class, string2, string);
            map.put("ServerStart", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the ServerStartMBean that can be used to start up this server remotely.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("ServerVersion")) {
            string2 = "getServerVersion";
            string = null;
            if (!this.readOnly) {
                string = "setServerVersion";
            }
            propertyDescriptor = new PropertyDescriptor("ServerVersion", ServerMBean.class, string2, string);
            map.put("ServerVersion", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The release identifier for the server. Since this is a configured attribute it is only as accurate as the configuration. The form of the version is major.minor.servicepack.rollingpatch. Not all parts of the version are required. i.e. \"7\" is acceptable.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"unknown");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.5.0.0", null, (String)this.targetVersion) && !map.containsKey("SingleSignOnServices")) {
            string2 = "getSingleSignOnServices";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SingleSignOnServices", ServerMBean.class, string2, string);
            map.put("SingleSignOnServices", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Gets the Single Sign-On Services MBean</p> ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("since", "9.5.0.0");
        }
        if (!map.containsKey("StagingDirectoryName")) {
            string2 = "getStagingDirectoryName";
            string = null;
            if (!this.readOnly) {
                string = "setStagingDirectoryName";
            }
            propertyDescriptor = new PropertyDescriptor("StagingDirectoryName", ServerMBean.class, string2, string);
            map.put("StagingDirectoryName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The directory path on the Managed Server where all staged (prepared) applications are placed.</p>  <p>If an absolute directory name is not specified, the path is relative to the root directory \"/\". Once configured, you cannot change the staging directory name. Remove all applications from the server prior to changing this attribute. The default staging directory is \"stage\", relative to the server root.</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion) && !map.containsKey("StagingMode")) {
            string2 = "getStagingMode";
            string = null;
            if (!this.readOnly) {
                string = "setStagingMode";
            }
            propertyDescriptor = new PropertyDescriptor("StagingMode", ServerMBean.class, string2, string);
            map.put("StagingMode", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The mode that specifies whether an application's files are copied from a source on the Administration Server to the Managed Server's staging area during application preparation.</p>  <p>During application preparation, the application's files are copied from the source on the Administration Server to the Managed Server's staging area. If you specify <code>nostage</code> or <code>external_stage</code>, the copy will not occur. This is useful when the staging area is a shared directory, already containing the application files, or if this is a single server domain. The administrator must ensure that the Managed Server's staging directory is set appropriately. Deployment errors will result if the application is not available during the preparation or activation of the application. Each application can override the staging mode specified here.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ApplicationMBean#getStagingMode()")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("legalValues", new Object[]{ServerMBean.DEFAULT_STAGE, "stage", "nostage", "external_stage"});
            propertyDescriptor.setValue("since", "7.0.0.0");
        }
        if (!map.containsKey("StartupMode")) {
            string2 = "getStartupMode";
            string = null;
            if (!this.readOnly) {
                string = "setStartupMode";
            }
            propertyDescriptor = new PropertyDescriptor("StartupMode", ServerMBean.class, string2, string);
            map.put("StartupMode", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The state in which this server should be started. If you specify <tt>STANDBY</tt>, you must also enable the domain-wide administration port.</p>  <p>In the <code>RUNNING</code> state, a server offers its services to clients and can operate as a full member of a cluster. In the <code>ADMIN</code> state, the server is up and running, but available only for administration operations, allowing you to perform server and application-level administration tasks without risk to running applications. In the <code>STANDBY</code> state, a server instance does not process any request; its regular Listen Port is closed. The Administration Port is open. It only accepts life cycle commands that transition the server instance to either the <code>RUNNING</code> or the <code>SHUTDOWN</code> state. Other Administration requests are not accepted. A <code>STANDBY</code> server's only purpose is to resume into the <code>RUNNING</code> state quickly; it saves server startup time.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"RUNNING");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("StartupTimeout")) {
            string2 = "getStartupTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setStartupTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("StartupTimeout", ServerMBean.class, string2, string);
            map.put("StartupTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Timeout value for server start and resume operations. If the server fails to start in the timeout period, it will force shutdown.</p>  <p>A value of <code>0</code> means that the server will wait indefinitely for the operation to complete.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("StdoutFormat")) {
            string2 = "getStdoutFormat";
            string = null;
            if (!this.readOnly) {
                string = "setStdoutFormat";
            }
            propertyDescriptor = new PropertyDescriptor("StdoutFormat", ServerMBean.class, string2, string);
            map.put("StdoutFormat", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The output format to use when logging to the console.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"standard");
            propertyDescriptor.setValue("legalValues", new Object[]{"standard", "noid"});
            propertyDescriptor.setValue("deprecated", " ");
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("StdoutSeverityLevel")) {
            string2 = "getStdoutSeverityLevel";
            string = null;
            if (!this.readOnly) {
                string = "setStdoutSeverityLevel";
            }
            propertyDescriptor = new PropertyDescriptor("StdoutSeverityLevel", ServerMBean.class, string2, string);
            map.put("StdoutSeverityLevel", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The minimum severity of a message that the server sends to standard out. (Requires you to enable sending messages to standard out.)</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isStdoutEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(32));
            propertyDescriptor.setValue("secureValue", new Integer(32));
            propertyDescriptor.setValue("legalValues", new Object[]{new Integer(256), new Integer(128), new Integer(64), new Integer(16), new Integer(8), new Integer(32), new Integer(4), new Integer(2), new Integer(1), new Integer(0)});
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by LogMBean.StdoutSeverity.  For backward compatibility the changes to this attribute will be  propagated to the LogMBean. ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("SystemPasswordEncrypted")) {
            string2 = "getSystemPasswordEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setSystemPasswordEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("SystemPasswordEncrypted", ServerMBean.class, string2, string);
            map.put("SystemPasswordEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The password required to access administrative functions on this server.</p>  <p>To set this attribute,  use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method.</p>  <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
        }
        if (!map.containsKey("TransactionLogFilePrefix")) {
            string2 = "getTransactionLogFilePrefix";
            string = null;
            if (!this.readOnly) {
                string = "setTransactionLogFilePrefix";
            }
            propertyDescriptor = new PropertyDescriptor("TransactionLogFilePrefix", ServerMBean.class, string2, string);
            map.put("TransactionLogFilePrefix", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The path prefix for the server's JTA transaction log files. If the pathname is not absolute, the path is assumed to be relative to the server's root directory.</p>  <p>For a clustered server, if you plan to be able to migrate the Transaction Recovery Service from this server if it fails to another server (backup server) in the same cluster, you must store transaction log files on persistent storage, such as a Storage Area Network (SAN) device or a dual-ported disk, available to both servers.</p>  <p>Do not use an NFS file system to store transaction log files. Because of the caching scheme in NFS, transaction log files on disk may not always be current. Using transaction log files stored on an NFS device for recovery may cause data corruption. </p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"./");
        }
        if (!map.containsKey("TransactionLogFileWritePolicy")) {
            string2 = "getTransactionLogFileWritePolicy";
            string = null;
            if (!this.readOnly) {
                string = "setTransactionLogFileWritePolicy";
            }
            propertyDescriptor = new PropertyDescriptor("TransactionLogFileWritePolicy", ServerMBean.class, string2, string);
            map.put("TransactionLogFileWritePolicy", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The policy that determines how transaction log file entries are written to disk. This policy can affect transaction performance. (Note: To be transactionally safe, the Direct-Write policy may require additional OS or environment changes on some Windows systems.)</p>  <p>WebLogic Server supports the following policies:</p>  <ul> <li> <p>Cache-Flush. Flushes operating system and on-disk caches after each write.</p> </li>  <li> <p>Direct-Write. Tells the operating system to write directly to disk with each write. Direct-Write performs better than Cache-Flush.</p> </li> </ul>  <p>If Direct-Write is not supported on the host platform, the policy becomes Cache-Flush and a log message is printed.</p>  <p><b>Note</b>: On Windows, the \"Direct-Write\" policy may leave transaction data in the on-disk cache without writing it to disk immediately. This is not transactionally safe because a power failure can cause loss of on-disk cache data. For transactionally safe writes using \"Direct-Write\" on Windows, either disable all write caching for the disk (enabled by default), or use a disk with a battery-backed cache.</p>  <p>The on-disk cache for a hard-drive on Windows can be disabled through system administration: Control-Panel -&gt; System -&gt; Hardware-tab -&gt; Device-Manager-button -&gt; Disk-Drives -&gt; name-of-drive -&gt; Policies-tab -&gt; \"Enable write caching on the disk\" check-box. Some file systems do not allow this value to be changed. For example, a RAID system that has a reliable cache.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"Direct-Write");
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("legalValues", new Object[]{"Cache-Flush", "Direct-Write"});
        }
        if (!map.containsKey("TransactionLogJDBCStore")) {
            string2 = "getTransactionLogJDBCStore";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TransactionLogJDBCStore", ServerMBean.class, string2, string);
            map.put("TransactionLogJDBCStore", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The JDBC TLOG store used for transaction logging. </p> ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("TunnelingClientPingSecs")) {
            string2 = "getTunnelingClientPingSecs";
            string = null;
            if (!this.readOnly) {
                string = "setTunnelingClientPingSecs";
            }
            propertyDescriptor = new PropertyDescriptor("TunnelingClientPingSecs", ServerMBean.class, string2, string);
            map.put("TunnelingClientPingSecs", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The interval (in seconds) at which to ping a tunneled client to see if it is still alive.</p>  <p>If you create network channels for this server, each channel can override this setting.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getTunnelingClientPingSecs")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(45));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("TunnelingClientTimeoutSecs")) {
            string2 = "getTunnelingClientTimeoutSecs";
            string = null;
            if (!this.readOnly) {
                string = "setTunnelingClientTimeoutSecs";
            }
            propertyDescriptor = new PropertyDescriptor("TunnelingClientTimeoutSecs", ServerMBean.class, string2, string);
            map.put("TunnelingClientTimeoutSecs", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The amount of time (in seconds) after which a missing tunneled client is considered dead.</p>  <p>If you create network channels for this server, each channel can override this setting.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#getTunnelingClientTimeoutSecs")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(40));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("UploadDirectoryName")) {
            string2 = "getUploadDirectoryName";
            string = null;
            if (!this.readOnly) {
                string = "setUploadDirectoryName";
            }
            propertyDescriptor = new PropertyDescriptor("UploadDirectoryName", ServerMBean.class, string2, string);
            map.put("UploadDirectoryName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The directory path on the Administration Server where all uploaded applications are placed.</p>  <p>If an absolute directory name is not specified, the path is relative to the root directory \"/\". The default staging directory is \"stage\", relative to the server root. On the Managed Server this returns null, and is not configurable.</p> ");
            propertyDescriptor.setValue("secureValue", "An absolute directory that is outside the root directory of any  WebLogic Server instance or application, and that resides on a physical disk  that is separate from the WebLogic Server host's system disk.");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("VerboseEJBDeploymentEnabled")) {
            string2 = "getVerboseEJBDeploymentEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setVerboseEJBDeploymentEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("VerboseEJBDeploymentEnabled", ServerMBean.class, string2, string);
            map.put("VerboseEJBDeploymentEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not verbose deployment of EJBs is enabled.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"false");
            propertyDescriptor.setValue("deprecated", "Deprecated as of 10.3.3.0 in favor of {@link ServerDebugMBean#getDebugEjbDeployment()} ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.2.0", null, (String)this.targetVersion) && !map.containsKey("VirtualMachineName")) {
            string2 = "getVirtualMachineName";
            string = null;
            if (!this.readOnly) {
                string = "setVirtualMachineName";
            }
            propertyDescriptor = new PropertyDescriptor("VirtualMachineName", ServerMBean.class, string2, string);
            map.put("VirtualMachineName", propertyDescriptor);
            propertyDescriptor.setValue("description", "When WLS is running on JRVE, this specifies the name of the virtual machine running this server ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("since", "10.3.2.0");
        }
        if (!map.containsKey("WebServer")) {
            string2 = "getWebServer";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WebServer", ServerMBean.class, string2, string);
            map.put("WebServer", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the web server for this server. A server has exactly one WebServer. A server may also have one or more VirtualHosts. A VirtualHost is a subclass of WebServer.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.2.0.0", null, (String)this.targetVersion) && !map.containsKey("WebService")) {
            string2 = "getWebService";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WebService", ServerMBean.class, string2, string);
            map.put("WebService", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Gets Web service configuration for this server</p> ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("since", "9.2.0.0");
        }
        if (!map.containsKey("XMLEntityCache")) {
            string2 = "getXMLEntityCache";
            string = null;
            if (!this.readOnly) {
                string = "setXMLEntityCache";
            }
            propertyDescriptor = new PropertyDescriptor("XMLEntityCache", ServerMBean.class, string2, string);
            map.put("XMLEntityCache", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The server's XML entity cache, which is used to configure the behavior of JAXP (Java API for XML Parsing).</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"XMLEntityCacheMBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("XMLRegistry")) {
            string2 = "getXMLRegistry";
            string = null;
            if (!this.readOnly) {
                string = "setXMLRegistry";
            }
            propertyDescriptor = new PropertyDescriptor("XMLRegistry", ServerMBean.class, string2, string);
            map.put("XMLRegistry", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The server's XML registry, which is used to configure the behavior of JAXP (Java API for XML Parsing).</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"XMLRegistryMBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("AdministrationPortEnabled")) {
            string2 = "isAdministrationPortEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setAdministrationPortEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("AdministrationPortEnabled", ServerMBean.class, string2, string);
            map.put("AdministrationPortEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether or not administration port is enabled for the server. This field is derived from the DomainMBean and has no setter here All the server (7.0 and later) in s single domain should either have an administration port or not The administration port uses SSL, so SSL must be configured and enabled properly for it to be active.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getAdministrationPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.DomainMBean#isAdministrationPortEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.DomainMBean#getAdministrationPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("AutoMigrationEnabled")) {
            string2 = "isAutoMigrationEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setAutoMigrationEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("AutoMigrationEnabled", ServerMBean.class, string2, string);
            map.put("AutoMigrationEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether Node Manager can automatically restart this server and its services on another machine if the server fails.</p> ");
        }
        if (!map.containsKey("COMEnabled")) {
            string2 = "isCOMEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setCOMEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("COMEnabled", ServerMBean.class, string2, string);
            map.put("COMEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether COM support is enabled on the regular (non-SSL) port. COM is not supported on the SSL port. (The remaining fields on this page are relevant only if you check this box.)</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getListenPort")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
        }
        if (!map.containsKey("ClasspathServletDisabled")) {
            string2 = "isClasspathServletDisabled";
            string = null;
            if (!this.readOnly) {
                string = "setClasspathServletDisabled";
            }
            propertyDescriptor = new PropertyDescriptor("ClasspathServletDisabled", ServerMBean.class, string2, string);
            map.put("ClasspathServletDisabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The ClasspathServlet will serve any class file in the classpath and is registered by default in every Web application (including management). It does not need to be turned on for many applications though, and represents a security hole if unchecked.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
        }
        if (!map.containsKey("ClientCertProxyEnabled")) {
            string2 = "isClientCertProxyEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setClientCertProxyEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ClientCertProxyEnabled", ServerMBean.class, string2, string);
            map.put("ClientCertProxyEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the <tt>HttpClusterServlet</tt> proxies the client certificate in a special header.</p>  <p>By default (or if you specify <code>false</code>), the <code>weblogic.xml</code> deployment descriptor for each web application that is deployed on this server determines whether the web application trusts certificates sent from the proxy server plugin. By default (or if the deployment descriptor specifies <code>false</code>), users cannot log in to the web application from a proxy server plugin.</p>  <p>A value of <code>true</code> causes proxy-server plugins to pass identity certifications from clients to all web applications that are deployed on this server instance. A proxy-server plugin encodes each identify certification in the <code>WL-Proxy-Client-Cert</code> header and passes the header to WebLogic Server instances. A WebLogic Server instance takes the certificate information from the header, trusting that it came from a secure source, and uses that information to authenticate the user.</p>  <p>If you specify <code>true</code>, use a <code>weblogic.security.net.ConnectionFilter</code> to ensure that this WebLogic Server instance accepts connections only from the machine on which the proxy-server plugin is running. Specifying <code>true</code> without using a connection filter creates a security vulnerability because the <code>WL-Proxy-Client-Cert</code> header can be spoofed.</p>  <p>A cluster can also specify whether the <tt>HttpClusterServlet</tt> proxies the client certificate in a special header. The cluster-level setting overrides the setting in individual servers that are part of the cluster.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.security.net.ConnectionFilter"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebAppContainerMBean#isClientCertProxyEnabled()"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ClusterMBean#isClientCertProxyEnabled()")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
        }
        if (!map.containsKey("ConsoleInputEnabled")) {
            string2 = "isConsoleInputEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setConsoleInputEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ConsoleInputEnabled", ServerMBean.class, string2, string);
            map.put("ConsoleInputEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>True if commands can be typed at console. REMOVE?</p> ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultInternalServletsDisabled")) {
            string2 = "isDefaultInternalServletsDisabled";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultInternalServletsDisabled";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultInternalServletsDisabled", ServerMBean.class, string2, string);
            map.put("DefaultInternalServletsDisabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether all default servlets in the servlet engine are disabled.</p>  <p>This includes: weblogic.servlet.ClasspathServlet weblogic.servlet.utils.iiop.GetIORServlet weblogic.rjvm.http.TunnelSendServlet weblogic.rjvm.http.TunnelRecvServlet weblogic.rjvm.http.TunnelLoginServlet weblogic.rjvm.http.TunnelCloseServlet If set to true, this property overrides the ClasspathServletDisabled property.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("EnabledForDomainLog")) {
            string2 = "isEnabledForDomainLog";
            string = null;
            if (!this.readOnly) {
                string = "setEnabledForDomainLog";
            }
            propertyDescriptor = new PropertyDescriptor("EnabledForDomainLog", ServerMBean.class, string2, string);
            map.put("EnabledForDomainLog", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Determines whether this server sends messages to the domain log (in addition to keeping its own log).</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 replaced by LogMBean.LogBroadcastSeverity, For backward compatibility the changes to this attribute will be propagated to the LogMBean. ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("HttpTraceSupportEnabled")) {
            string2 = "isHttpTraceSupportEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setHttpTraceSupportEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("HttpTraceSupportEnabled", ServerMBean.class, string2, string);
            map.put("HttpTraceSupportEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the HttpTraceSupportEnabled value ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebAppContainerMBean#isHttpTraceSupportEnabled()"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ClusterMBean#isHttpTraceSupportEnabled()")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
        }
        if (!map.containsKey("HttpdEnabled")) {
            string2 = "isHttpdEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setHttpdEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("HttpdEnabled", ServerMBean.class, string2, string);
            map.put("HttpdEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not HTTP support is enabled on the regular port or SSL port.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getListenPort"), BeanInfoHelper.encodeEntities((String)"#isTunnelingEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#getListenPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
        }
        if (!map.containsKey("IIOPEnabled")) {
            string2 = "isIIOPEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setIIOPEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("IIOPEnabled", ServerMBean.class, string2, string);
            map.put("IIOPEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether this server has IIOP support enabled for both the regular (non-SSL) and SSL ports.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getListenPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#getListenPort"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
        }
        if (!map.containsKey("IgnoreSessionsDuringShutdown")) {
            string2 = "isIgnoreSessionsDuringShutdown";
            string = null;
            if (!this.readOnly) {
                string = "setIgnoreSessionsDuringShutdown";
            }
            propertyDescriptor = new PropertyDescriptor("IgnoreSessionsDuringShutdown", ServerMBean.class, string2, string);
            map.put("IgnoreSessionsDuringShutdown", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether a graceful shutdown operation drops all HTTP sessions immediately.</p> <p>If this is set to <code>false</code>, a graceful shutdown operation waits for HTTP sessions to complete or timeout.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("JDBCLoggingEnabled")) {
            string2 = "isJDBCLoggingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setJDBCLoggingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("JDBCLoggingEnabled", ServerMBean.class, string2, string);
            map.put("JDBCLoggingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether this server maintains a JDBC log file.</p> ");
            propertyDescriptor.setValue("secureValue", new Boolean(true));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Use ServerDebugMBean.getJDBCDriverLogging ");
        }
        if (!map.containsKey("JMSDefaultConnectionFactoriesEnabled")) {
            string2 = "isJMSDefaultConnectionFactoriesEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setJMSDefaultConnectionFactoriesEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("JMSDefaultConnectionFactoriesEnabled", ServerMBean.class, string2, string);
            map.put("JMSDefaultConnectionFactoriesEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether this server uses JMS default connection factories.</p>  <p>WebLogic Server provides the following JMS default connection factories:</p>  <ul> <li> <code>weblogic.jms.ConnectionFactory</code> </li>  <li> <code>weblogic.jms.XAConnectionFactory</code> An XA factory is required for JMS applications to use JTA user-transactions, but is not required for transacted sessions. All other preconfigured attributes for the default connection factories are set to the same default values as a user-defined connection factory. If the preconfigured settings of the default factories are appropriate for your application, you do not need to configure any additional factories for your application. </li> </ul> <p> <b>Note:</b> When using the default connection factories, you have no control over targeting the WebLogic Server instances where the connection factory may be deployed. However, you can disable the default connection factories on a per-server basis. To deploy a connection factory on independent servers, on specific servers within a cluster, or on an entire cluster, you need to configure a connection factory and specify the appropriate server targets.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion) && !map.containsKey("ListenPortEnabled")) {
            string2 = "isListenPortEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setListenPortEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ListenPortEnabled", ServerMBean.class, string2, string);
            map.put("ListenPortEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether this server can be reached through the default plain-text (non-SSL) listen port.</p>  <p>If you disable this listen port, you must enable the default SSL listen port.</p>  <p>You can define additional listen ports for this server by configuring network channels.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getListenPort"), BeanInfoHelper.encodeEntities((String)"#isAdministrationPortEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.KernelMBean#getSSL"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.SSLMBean#isListenPortEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#isEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("since", "7.0.0.0");
        }
        if (!map.containsKey("MSIFileReplicationEnabled")) {
            string2 = "isMSIFileReplicationEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setMSIFileReplicationEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("MSIFileReplicationEnabled", ServerMBean.class, string2, string);
            map.put("MSIFileReplicationEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the Administration Server replicates its configuration files to this Managed Server.</p>  <p>With file replication enabled, the Administration Server copies its configuration file and <code>SerializedSystemIni.dat</code> into the Managed Server's root directory every 5 minutes. This option does not replicate a boot identity file.</p>  <p>Regardless of the name of the configuration file that you used to start the Administration Server, the replicated file is always named <code>msi-config.xml</code>. For example, if you specified <code>-Dweblogic.ConfigFile=MyConfig.xml</code> when you started the Administration Server, if you have enabled file replication, the Administration Server copies <code>MyConfig.xml</code> and names the copy <code>msi-config.xml</code>.</p>  <p>Depending on your backup schemes and the frequency with which you update your domain's configuration, this option might not be worth the performance cost of copying potentially large files across a network.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("deprecated", " ");
        }
        if (!map.containsKey("ManagedServerIndependenceEnabled")) {
            string2 = "isManagedServerIndependenceEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setManagedServerIndependenceEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ManagedServerIndependenceEnabled", ServerMBean.class, string2, string);
            map.put("ManagedServerIndependenceEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether this Managed Server can be started when the Administration Server is unavailable.</p>  <p>In such a case, the Managed Server retrieves its configuration by reading a configuration file and other files directly.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
        }
        if (!map.containsKey("MessageIdPrefixEnabled")) {
            string2 = "isMessageIdPrefixEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setMessageIdPrefixEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("MessageIdPrefixEnabled", ServerMBean.class, string2, string);
            map.put("MessageIdPrefixEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether message IDs in logged messages will include a prefix. Message ids are 6 digit numeric strings that can be optionally presented in a log entry with a prefix. The prefix used by server messages is \"BEA-\".</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("StdoutDebugEnabled")) {
            string2 = "isStdoutDebugEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setStdoutDebugEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("StdoutDebugEnabled", ServerMBean.class, string2, string);
            map.put("StdoutDebugEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the server sends messages of the <code>DEBUG</code> severity to standard out in addition to the log file. (Requires you to enable sending messages to standard out.)</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 replaced by LogMBean.StdoutSeverity For backward compatibility the changes to this attribute will be propagated to the LogMBean. ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("StdoutEnabled")) {
            string2 = "isStdoutEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setStdoutEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("StdoutEnabled", ServerMBean.class, string2, string);
            map.put("StdoutEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the server sends messages to standard out in addition to the log file.</p>  <p>Other settings configure the minimum severity of a message that the server sends to standard out.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isStdoutDebugEnabled"), BeanInfoHelper.encodeEntities((String)"#getStdoutSeverityLevel")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 replaced by LogMBean.StdoutSeverity, for backward compatibility the changes to this attribute will be propagated to the LogMBean. ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant(null, (String)"9.0.0.0", (String)this.targetVersion) && !map.containsKey("StdoutLogStack")) {
            string2 = "isStdoutLogStack";
            string = null;
            if (!this.readOnly) {
                string = "setStdoutLogStack";
            }
            propertyDescriptor = new PropertyDescriptor("StdoutLogStack", ServerMBean.class, string2, string);
            map.put("StdoutLogStack", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether to dump stack traces to the console when included in logged message.</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("obsolete", "9.0.0.0");
        }
        if (!map.containsKey("TGIOPEnabled")) {
            string2 = "isTGIOPEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setTGIOPEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("TGIOPEnabled", ServerMBean.class, string2, string);
            map.put("TGIOPEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether this server supports Tuxedo GIOP (TGIOP) requests. (Requires you to configure WebLogic Tuxedo Connector (WTC) for this server.)</p> ");
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
        }
        if (!map.containsKey("TunnelingEnabled")) {
            string2 = "isTunnelingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setTunnelingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("TunnelingEnabled", ServerMBean.class, string2, string);
            map.put("TunnelingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether tunneling for the T3, T3S, HTTP, HTTPS, IIOP, and IIOPS protocols should be enabled for this server.</p>  <p>If you create network channels for this server, each channel can override this setting.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isHttpdEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkAccessPointMBean#isTunnelingEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("UseFusionForLLR")) {
            string2 = "isUseFusionForLLR";
            string = null;
            if (!this.readOnly) {
                string = "setUseFusionForLLR";
            }
            propertyDescriptor = new PropertyDescriptor("UseFusionForLLR", ServerMBean.class, string2, string);
            map.put("UseFusionForLLR", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Enables the use of the <code>ADM_DDL </code> store procedure for LLR. The default value is <code>false</code> (not enabled). </p> <p>When enabled, a  <code>WLS_</code> prefix and <code>_DYD</code> suffix is is automatically added to the LLR table name at runtime so the LLR table name in server configuration is not consistent with the actual table name in database.</p> ");
        }
        if (!map.containsKey("WeblogicPluginEnabled")) {
            string2 = "isWeblogicPluginEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setWeblogicPluginEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("WeblogicPluginEnabled", ServerMBean.class, string2, string);
            map.put("WeblogicPluginEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether this server uses the proprietary <tt>WL-Proxy-Client-IP</tt> header, which is recommended if the server instance will receive requests from a proxy plug-in.</p>  <p>If the server instance is a member of a cluster that will receive proxied requests, enable the WebLogic plugin at the cluster level. For servers that are members of a cluster, the setting at the cluster level overrides the server's setting.</p>  <p>When the WebLogic plugin is enabled, a call to <code>getRemoteAddr</code> will return the address of the browser client from the proprietary <code>WL-Proxy-Client-IP</code> header instead of the web server.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebAppContainerMBean#isWeblogicPluginEnabled()"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ClusterMBean#isWeblogicPluginEnabled()")};
            propertyDescriptor.setValue("see", stringArray);
            ServerMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        String string;
        ParameterDescriptor[] parameterDescriptorArray;
        Method method;
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion)) {
            method = ServerMBean.class.getMethod("createNetworkAccessPoint", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{ServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "7.0.0.0");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Factory to create a new NetworkAccessPoint instance for this Server.</p> ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "NetworkAccessPoints");
                methodDescriptor.setValue("since", "7.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion)) {
            method = ServerMBean.class.getMethod("destroyNetworkAccessPoint", NetworkAccessPointMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{ServerMBeanImplBeanInfo.createParameterDescriptor((String)"accessPoint", (String)"to be destroyed ")};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "7.0.0.0");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Destroys a NetworkAccessPoint object.</p> ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "NetworkAccessPoints");
                methodDescriptor.setValue("since", "7.0.0.0");
            }
        }
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String[] stringArray;
        MethodDescriptor methodDescriptor;
        String string;
        ParameterDescriptor[] parameterDescriptorArray;
        Method method;
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion)) {
            method = ServerMBean.class.getMethod("addNetworkAccessPoint", NetworkAccessPointMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{ServerMBeanImplBeanInfo.createParameterDescriptor((String)"networkAccessPoint", (String)"The feature to be added to the NetworkAccessPoint attribute ")};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "7.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", " ");
                stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getNetworkAccessPoints")};
                methodDescriptor.setValue("see", stringArray);
                methodDescriptor.setValue("role", "collection");
                methodDescriptor.setValue("property", "NetworkAccessPoints");
                methodDescriptor.setValue("since", "7.0.0.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion)) {
            method = ServerMBean.class.getMethod("removeNetworkAccessPoint", NetworkAccessPointMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{ServerMBeanImplBeanInfo.createParameterDescriptor((String)"networkAccessPoint", null)};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "7.0.0.0");
                methodDescriptor.setValue("deprecated", "9.0.0.0 ");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", " ");
                stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getNetworkAccessPoints")};
                methodDescriptor.setValue("see", stringArray);
                methodDescriptor.setValue("role", "collection");
                methodDescriptor.setValue("property", "NetworkAccessPoints");
                methodDescriptor.setValue("since", "7.0.0.0");
            }
        }
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion)) {
            Method method = ServerMBean.class.getMethod("lookupNetworkAccessPoint", String.class);
            ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{ServerMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"the key of the network access point. ")};
            String string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                MethodDescriptor methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "7.0.0.0");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "<p>Look up an NetworkAccessPoint by name</p> ");
                methodDescriptor.setValue("role", "finder");
                methodDescriptor.setValue("property", "NetworkAccessPoints");
                methodDescriptor.setValue("since", "7.0.0.0");
            }
        }
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = ServerMBean.class.getMethod("freezeCurrentValue", String.class);
        Object object = new ParameterDescriptor[]{ServerMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        Object object2 = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object2)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has not been set explicitly, and if the attribute has a default value, this operation forces the MBean to persist the default value.</p>  <p>Unless you use this operation, the default value is not saved and is subject to change if you update to a newer release of WebLogic Server. Invoking this operation isolates this MBean from the effects of such changes.</p>  <dl> <dt>Note:</dt>  <dd> <p>To insure that you are freezing the default value, invoke the <code>restoreDefaultValue</code> operation before you invoke this.</p> </dd> </dl>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute for which some other value has been set.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ServerMBean.class.getMethod("restoreDefaultValue", String.class);
        object = new ParameterDescriptor[]{ServerMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        object2 = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object2) && !this.readOnly) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has a default value, this operation removes any value that has been set explicitly and causes the attribute to use the default value.</p>  <p>Default values are subject to change if you update to a newer release of WebLogic Server. To prevent the value from changing if you update to a newer release, invoke the <code>freezeCurrentValue</code> operation.</p>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute that is already using the default.</p> ");
            methodDescriptor.setValue("role", "operation");
            methodDescriptor.setValue("impact", "action");
        }
        if (!map.containsKey(object = BeanInfoHelper.buildMethodKey((Method)(method = ServerMBean.class.getMethod("synchronousStart", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("deprecated", "9.0.0.0 Use {@link weblogic.management.runtime.ServerLifeCycleRuntimeMBean#start()} instead. ");
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Start this server. This is a blocking call. Returns String containing NodeManger log for starting the server.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(object = BeanInfoHelper.buildMethodKey((Method)(method = ServerMBean.class.getMethod("synchronousKill", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("deprecated", "9.0.0.0 Use {@link weblogic.management.runtime.ServerRuntimeMBean#forceShutdown()} instead ");
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Kill this server. This is a blocking call. Returns String containing NodeManger log for killing the server.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(object = BeanInfoHelper.buildMethodKey((Method)(method = ServerMBean.class.getMethod("lookupServerLifeCycleRuntime", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Lookup a ServerLifeCycleRuntimeMbean.</p> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
            object2 = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer"), BeanInfoHelper.encodeEntities((String)"Operator"), BeanInfoHelper.encodeEntities((String)"Monitor")};
            methodDescriptor.setValue("rolesAllowed", object2);
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

