/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.LegalHelper;
import weblogic.management.configuration.ServerStartMBean;
import weblogic.management.mbeans.custom.ServerStart;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class ServerStartMBeanImpl
extends ConfigurationMBeanImpl
implements ServerStartMBean,
Serializable {
    private String _Arguments;
    private String _BeaHome;
    private Properties _BootProperties;
    private String _ClassPath;
    private String _JavaHome;
    private String _JavaVendor;
    private int _MaxRestartCount;
    private String _Name;
    private String _OutputFile;
    private String _Password;
    private byte[] _PasswordEncrypted;
    private String _RootDirectory;
    private String _SecurityPolicyFile;
    private Properties _StartupProperties;
    private String _Username;
    private ServerStart _customizer;
    private static SchemaHelper2 _schemaHelper;

    public ServerStartMBeanImpl() {
        try {
            this._customizer = new ServerStart(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ServerStartMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new ServerStart(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getJavaVendor() {
        return this._JavaVendor;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isJavaVendorSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setJavaVendor(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JavaVendor;
        this._JavaVendor = string;
        this._postSet(7, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public String getJavaHome() {
        return this._JavaHome;
    }

    public boolean isJavaHomeSet() {
        return this._isSet(8);
    }

    public void setJavaHome(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalHelper.validateJavaHome(string);
        String string2 = this._JavaHome;
        this._JavaHome = string;
        this._postSet(8, string2, string);
    }

    public String getClassPath() {
        return this._ClassPath;
    }

    public boolean isClassPathSet() {
        return this._isSet(9);
    }

    public void setClassPath(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalHelper.validateClasspath(string);
        String string2 = this._ClassPath;
        this._ClassPath = string;
        this._postSet(9, string2, string);
    }

    public String getBeaHome() {
        return this._BeaHome;
    }

    public boolean isBeaHomeSet() {
        return this._isSet(10);
    }

    public void setBeaHome(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalHelper.validateBeaHome(string);
        String string2 = this._BeaHome;
        this._BeaHome = string;
        this._postSet(10, string2, string);
    }

    public String getRootDirectory() {
        return this._RootDirectory;
    }

    public boolean isRootDirectorySet() {
        return this._isSet(11);
    }

    public void setRootDirectory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalHelper.validateRootDirectory(string);
        String string2 = this._RootDirectory;
        this._RootDirectory = string;
        this._postSet(11, string2, string);
    }

    public String getSecurityPolicyFile() {
        return this._SecurityPolicyFile;
    }

    public boolean isSecurityPolicyFileSet() {
        return this._isSet(12);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setSecurityPolicyFile(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalHelper.validateSecurityPolicyFile(string);
        String string2 = this._SecurityPolicyFile;
        this._SecurityPolicyFile = string;
        this._postSet(12, string2, string);
    }

    public String getArguments() {
        return this._Arguments;
    }

    public boolean isArgumentsSet() {
        return this._isSet(13);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setArguments(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalHelper.validateArguments(string);
        String string2 = this._Arguments;
        this._Arguments = string;
        this._postSet(13, string2, string);
    }

    public int getMaxRestartCount() {
        return this._MaxRestartCount;
    }

    public boolean isMaxRestartCountSet() {
        return this._isSet(14);
    }

    public void setMaxRestartCount(int n) throws InvalidAttributeValueException {
        int n2 = this._MaxRestartCount;
        this._MaxRestartCount = n;
        this._postSet(14, n2, n);
    }

    public String getOutputFile() {
        return this._OutputFile;
    }

    public boolean isOutputFileSet() {
        return this._isSet(15);
    }

    public void setOutputFile(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._OutputFile;
        this._OutputFile = string;
        this._postSet(15, string2, string);
    }

    public String getUsername() {
        return this._Username;
    }

    public boolean isUsernameSet() {
        return this._isSet(16);
    }

    public void setUsername(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Username;
        this._Username = string;
        this._postSet(16, string2, string);
    }

    public String getPassword() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : this._decrypt("Password", byArray);
    }

    public boolean isPasswordSet() {
        return this.isPasswordEncryptedSet();
    }

    public void setPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setPasswordEncrypted(string == null ? null : this._encrypt("Password", string));
    }

    public byte[] getPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._PasswordEncrypted);
    }

    public String getPasswordEncryptedAsString() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isPasswordEncryptedSet() {
        return this._isSet(18);
    }

    public void setPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public Properties getBootProperties() {
        return this._customizer.getBootProperties();
    }

    public boolean isBootPropertiesSet() {
        return this._isSet(19);
    }

    public void setBootProperties(Properties properties) throws InvalidAttributeValueException {
        this._BootProperties = properties;
    }

    public Properties getStartupProperties() {
        return this._customizer.getStartupProperties();
    }

    public boolean isStartupPropertiesSet() {
        return this._isSet(20);
    }

    public void setStartupProperties(Properties properties) throws InvalidAttributeValueException {
        this._StartupProperties = properties;
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._PasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: PasswordEncrypted of ServerStartMBean");
        }
        this._getHelper()._clearArray(this._PasswordEncrypted);
        this._PasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(18, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 17) {
                this._markSet(18, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 13;
        }
        try {
            switch (n) {
                case 13: {
                    this._Arguments = null;
                    if (bl) break;
                }
                case 10: {
                    this._BeaHome = null;
                    if (bl) break;
                }
                case 19: {
                    this._BootProperties = null;
                    if (bl) break;
                }
                case 9: {
                    this._ClassPath = null;
                    if (bl) break;
                }
                case 8: {
                    this._JavaHome = null;
                    if (bl) break;
                }
                case 7: {
                    this._JavaVendor = null;
                    if (bl) break;
                }
                case 14: {
                    this._MaxRestartCount = 0;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 15: {
                    this._OutputFile = null;
                    if (bl) break;
                }
                case 17: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 18: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 11: {
                    this._RootDirectory = null;
                    if (bl) break;
                }
                case 12: {
                    this._SecurityPolicyFile = null;
                    if (bl) break;
                }
                case 20: {
                    this._StartupProperties = null;
                    if (bl) break;
                }
                case 16: {
                    this._Username = "";
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "ServerStart";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Arguments")) {
            String string2 = this._Arguments;
            this._Arguments = (String)object;
            this._postSet(13, string2, this._Arguments);
            return;
        }
        if (string.equals("BeaHome")) {
            String string3 = this._BeaHome;
            this._BeaHome = (String)object;
            this._postSet(10, string3, this._BeaHome);
            return;
        }
        if (string.equals("BootProperties")) {
            Properties properties = this._BootProperties;
            this._BootProperties = (Properties)object;
            this._postSet(19, properties, this._BootProperties);
            return;
        }
        if (string.equals("ClassPath")) {
            String string4 = this._ClassPath;
            this._ClassPath = (String)object;
            this._postSet(9, string4, this._ClassPath);
            return;
        }
        if (string.equals("JavaHome")) {
            String string5 = this._JavaHome;
            this._JavaHome = (String)object;
            this._postSet(8, string5, this._JavaHome);
            return;
        }
        if (string.equals("JavaVendor")) {
            String string6 = this._JavaVendor;
            this._JavaVendor = (String)object;
            this._postSet(7, string6, this._JavaVendor);
            return;
        }
        if (string.equals("MaxRestartCount")) {
            int n = this._MaxRestartCount;
            this._MaxRestartCount = (Integer)object;
            this._postSet(14, n, this._MaxRestartCount);
            return;
        }
        if (string.equals("Name")) {
            String string7 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string7, this._Name);
            return;
        }
        if (string.equals("OutputFile")) {
            String string8 = this._OutputFile;
            this._OutputFile = (String)object;
            this._postSet(15, string8, this._OutputFile);
            return;
        }
        if (string.equals("Password")) {
            String string9 = this._Password;
            this._Password = (String)object;
            this._postSet(17, string9, this._Password);
            return;
        }
        if (string.equals("PasswordEncrypted")) {
            byte[] byArray = this._PasswordEncrypted;
            this._PasswordEncrypted = (byte[])object;
            this._postSet(18, byArray, this._PasswordEncrypted);
            return;
        }
        if (string.equals("RootDirectory")) {
            String string10 = this._RootDirectory;
            this._RootDirectory = (String)object;
            this._postSet(11, string10, this._RootDirectory);
            return;
        }
        if (string.equals("SecurityPolicyFile")) {
            String string11 = this._SecurityPolicyFile;
            this._SecurityPolicyFile = (String)object;
            this._postSet(12, string11, this._SecurityPolicyFile);
            return;
        }
        if (string.equals("StartupProperties")) {
            Properties properties = this._StartupProperties;
            this._StartupProperties = (Properties)object;
            this._postSet(20, properties, this._StartupProperties);
            return;
        }
        if (string.equals("Username")) {
            String string12 = this._Username;
            this._Username = (String)object;
            this._postSet(16, string12, this._Username);
            return;
        }
        if (string.equals("customizer")) {
            ServerStart serverStart = this._customizer;
            this._customizer = (ServerStart)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Arguments")) {
            return this._Arguments;
        }
        if (string.equals("BeaHome")) {
            return this._BeaHome;
        }
        if (string.equals("BootProperties")) {
            return this._BootProperties;
        }
        if (string.equals("ClassPath")) {
            return this._ClassPath;
        }
        if (string.equals("JavaHome")) {
            return this._JavaHome;
        }
        if (string.equals("JavaVendor")) {
            return this._JavaVendor;
        }
        if (string.equals("MaxRestartCount")) {
            return new Integer(this._MaxRestartCount);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("OutputFile")) {
            return this._OutputFile;
        }
        if (string.equals("Password")) {
            return this._Password;
        }
        if (string.equals("PasswordEncrypted")) {
            return this._PasswordEncrypted;
        }
        if (string.equals("RootDirectory")) {
            return this._RootDirectory;
        }
        if (string.equals("SecurityPolicyFile")) {
            return this._SecurityPolicyFile;
        }
        if (string.equals("StartupProperties")) {
            return this._StartupProperties;
        }
        if (string.equals("Username")) {
            return this._Username;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 9: {
                    if (string.equals("arguments")) {
                        return 13;
                    }
                    if (!string.equals("java-home")) break;
                    return 8;
                }
                case 8: {
                    if (string.equals("bea-home")) {
                        return 10;
                    }
                    if (string.equals("password")) {
                        return 17;
                    }
                    if (!string.equals("username")) break;
                    return 16;
                }
                case 15: {
                    if (!string.equals("boot-properties")) break;
                    return 19;
                }
                case 10: {
                    if (!string.equals("class-path")) break;
                    return 9;
                }
                case 11: {
                    if (string.equals("java-vendor")) {
                        return 7;
                    }
                    if (!string.equals("output-file")) break;
                    return 15;
                }
                case 17: {
                    if (!string.equals("max-restart-count")) break;
                    return 14;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 18: {
                    if (string.equals("password-encrypted")) {
                        return 18;
                    }
                    if (!string.equals("startup-properties")) break;
                    return 20;
                }
                case 14: {
                    if (!string.equals("root-directory")) break;
                    return 11;
                }
                case 20: {
                    if (!string.equals("security-policy-file")) break;
                    return 12;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 13: {
                    return "arguments";
                }
                case 10: {
                    return "bea-home";
                }
                case 19: {
                    return "boot-properties";
                }
                case 9: {
                    return "class-path";
                }
                case 8: {
                    return "java-home";
                }
                case 7: {
                    return "java-vendor";
                }
                case 14: {
                    return "max-restart-count";
                }
                case 2: {
                    return "name";
                }
                case 15: {
                    return "output-file";
                }
                case 17: {
                    return "password";
                }
                case 18: {
                    return "password-encrypted";
                }
                case 11: {
                    return "root-directory";
                }
                case 12: {
                    return "security-policy-file";
                }
                case 20: {
                    return "startup-properties";
                }
                case 16: {
                    return "username";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private ServerStartMBeanImpl bean;

        protected Helper(ServerStartMBeanImpl serverStartMBeanImpl) {
            super(serverStartMBeanImpl);
            this.bean = serverStartMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 13: {
                    return "Arguments";
                }
                case 10: {
                    return "BeaHome";
                }
                case 19: {
                    return "BootProperties";
                }
                case 9: {
                    return "ClassPath";
                }
                case 8: {
                    return "JavaHome";
                }
                case 7: {
                    return "JavaVendor";
                }
                case 14: {
                    return "MaxRestartCount";
                }
                case 2: {
                    return "Name";
                }
                case 15: {
                    return "OutputFile";
                }
                case 17: {
                    return "Password";
                }
                case 18: {
                    return "PasswordEncrypted";
                }
                case 11: {
                    return "RootDirectory";
                }
                case 12: {
                    return "SecurityPolicyFile";
                }
                case 20: {
                    return "StartupProperties";
                }
                case 16: {
                    return "Username";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Arguments")) {
                return 13;
            }
            if (string.equals("BeaHome")) {
                return 10;
            }
            if (string.equals("BootProperties")) {
                return 19;
            }
            if (string.equals("ClassPath")) {
                return 9;
            }
            if (string.equals("JavaHome")) {
                return 8;
            }
            if (string.equals("JavaVendor")) {
                return 7;
            }
            if (string.equals("MaxRestartCount")) {
                return 14;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("OutputFile")) {
                return 15;
            }
            if (string.equals("Password")) {
                return 17;
            }
            if (string.equals("PasswordEncrypted")) {
                return 18;
            }
            if (string.equals("RootDirectory")) {
                return 11;
            }
            if (string.equals("SecurityPolicyFile")) {
                return 12;
            }
            if (string.equals("StartupProperties")) {
                return 20;
            }
            if (string.equals("Username")) {
                return 16;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isArgumentsSet()) {
                    stringBuffer.append("Arguments");
                    stringBuffer.append(String.valueOf(this.bean.getArguments()));
                }
                if (this.bean.isBeaHomeSet()) {
                    stringBuffer.append("BeaHome");
                    stringBuffer.append(String.valueOf(this.bean.getBeaHome()));
                }
                if (this.bean.isBootPropertiesSet()) {
                    stringBuffer.append("BootProperties");
                    stringBuffer.append(String.valueOf(this.bean.getBootProperties()));
                }
                if (this.bean.isClassPathSet()) {
                    stringBuffer.append("ClassPath");
                    stringBuffer.append(String.valueOf(this.bean.getClassPath()));
                }
                if (this.bean.isJavaHomeSet()) {
                    stringBuffer.append("JavaHome");
                    stringBuffer.append(String.valueOf(this.bean.getJavaHome()));
                }
                if (this.bean.isJavaVendorSet()) {
                    stringBuffer.append("JavaVendor");
                    stringBuffer.append(String.valueOf(this.bean.getJavaVendor()));
                }
                if (this.bean.isMaxRestartCountSet()) {
                    stringBuffer.append("MaxRestartCount");
                    stringBuffer.append(String.valueOf(this.bean.getMaxRestartCount()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isOutputFileSet()) {
                    stringBuffer.append("OutputFile");
                    stringBuffer.append(String.valueOf(this.bean.getOutputFile()));
                }
                if (this.bean.isPasswordSet()) {
                    stringBuffer.append("Password");
                    stringBuffer.append(String.valueOf(this.bean.getPassword()));
                }
                if (this.bean.isPasswordEncryptedSet()) {
                    stringBuffer.append("PasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getPasswordEncrypted())));
                }
                if (this.bean.isRootDirectorySet()) {
                    stringBuffer.append("RootDirectory");
                    stringBuffer.append(String.valueOf(this.bean.getRootDirectory()));
                }
                if (this.bean.isSecurityPolicyFileSet()) {
                    stringBuffer.append("SecurityPolicyFile");
                    stringBuffer.append(String.valueOf(this.bean.getSecurityPolicyFile()));
                }
                if (this.bean.isStartupPropertiesSet()) {
                    stringBuffer.append("StartupProperties");
                    stringBuffer.append(String.valueOf(this.bean.getStartupProperties()));
                }
                if (this.bean.isUsernameSet()) {
                    stringBuffer.append("Username");
                    stringBuffer.append(String.valueOf(this.bean.getUsername()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ServerStartMBeanImpl serverStartMBeanImpl = (ServerStartMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Arguments", this.bean.getArguments(), serverStartMBeanImpl.getArguments(), true);
                this.computeDiff("BeaHome", this.bean.getBeaHome(), serverStartMBeanImpl.getBeaHome(), true);
                this.computeDiff("ClassPath", this.bean.getClassPath(), serverStartMBeanImpl.getClassPath(), true);
                this.computeDiff("JavaHome", this.bean.getJavaHome(), serverStartMBeanImpl.getJavaHome(), true);
                this.computeDiff("JavaVendor", this.bean.getJavaVendor(), serverStartMBeanImpl.getJavaVendor(), true);
                this.computeDiff("MaxRestartCount", this.bean.getMaxRestartCount(), serverStartMBeanImpl.getMaxRestartCount(), true);
                this.computeDiff("Name", this.bean.getName(), serverStartMBeanImpl.getName(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("OutputFile", this.bean.getOutputFile(), serverStartMBeanImpl.getOutputFile(), true);
                }
                this.computeDiff("PasswordEncrypted", this.bean.getPasswordEncrypted(), serverStartMBeanImpl.getPasswordEncrypted(), true);
                this.computeDiff("RootDirectory", this.bean.getRootDirectory(), serverStartMBeanImpl.getRootDirectory(), true);
                this.computeDiff("SecurityPolicyFile", this.bean.getSecurityPolicyFile(), serverStartMBeanImpl.getSecurityPolicyFile(), true);
                this.computeDiff("Username", this.bean.getUsername(), serverStartMBeanImpl.getUsername(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ServerStartMBeanImpl serverStartMBeanImpl = (ServerStartMBeanImpl)beanUpdateEvent.getSourceBean();
                ServerStartMBeanImpl serverStartMBeanImpl2 = (ServerStartMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("Arguments")) {
                    serverStartMBeanImpl.setArguments(serverStartMBeanImpl2.getArguments());
                    serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("BeaHome")) {
                    serverStartMBeanImpl.setBeaHome(serverStartMBeanImpl2.getBeaHome());
                    serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (!string.equals("BootProperties")) {
                    if (string.equals("ClassPath")) {
                        serverStartMBeanImpl.setClassPath(serverStartMBeanImpl2.getClassPath());
                        serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("JavaHome")) {
                        serverStartMBeanImpl.setJavaHome(serverStartMBeanImpl2.getJavaHome());
                        serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("JavaVendor")) {
                        serverStartMBeanImpl.setJavaVendor(serverStartMBeanImpl2.getJavaVendor());
                        serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("MaxRestartCount")) {
                        serverStartMBeanImpl.setMaxRestartCount(serverStartMBeanImpl2.getMaxRestartCount());
                        serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (string.equals("Name")) {
                        serverStartMBeanImpl.setName(serverStartMBeanImpl2.getName());
                        serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("OutputFile")) {
                        serverStartMBeanImpl.setOutputFile(serverStartMBeanImpl2.getOutputFile());
                        serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (!string.equals("Password")) {
                        if (string.equals("PasswordEncrypted")) {
                            serverStartMBeanImpl.setPasswordEncrypted(serverStartMBeanImpl2.getPasswordEncrypted());
                            serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                        } else if (string.equals("RootDirectory")) {
                            serverStartMBeanImpl.setRootDirectory(serverStartMBeanImpl2.getRootDirectory());
                            serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                        } else if (string.equals("SecurityPolicyFile")) {
                            serverStartMBeanImpl.setSecurityPolicyFile(serverStartMBeanImpl2.getSecurityPolicyFile());
                            serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                        } else if (!string.equals("StartupProperties")) {
                            if (string.equals("Username")) {
                                serverStartMBeanImpl.setUsername(serverStartMBeanImpl2.getUsername());
                                serverStartMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                            } else {
                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ServerStartMBeanImpl serverStartMBeanImpl = (ServerStartMBeanImpl)abstractDescriptorBean;
                super.finishCopy(serverStartMBeanImpl, bl, list);
                if ((list == null || !list.contains("Arguments")) && this.bean.isArgumentsSet()) {
                    serverStartMBeanImpl.setArguments(this.bean.getArguments());
                }
                if ((list == null || !list.contains("BeaHome")) && this.bean.isBeaHomeSet()) {
                    serverStartMBeanImpl.setBeaHome(this.bean.getBeaHome());
                }
                if ((list == null || !list.contains("ClassPath")) && this.bean.isClassPathSet()) {
                    serverStartMBeanImpl.setClassPath(this.bean.getClassPath());
                }
                if ((list == null || !list.contains("JavaHome")) && this.bean.isJavaHomeSet()) {
                    serverStartMBeanImpl.setJavaHome(this.bean.getJavaHome());
                }
                if ((list == null || !list.contains("JavaVendor")) && this.bean.isJavaVendorSet()) {
                    serverStartMBeanImpl.setJavaVendor(this.bean.getJavaVendor());
                }
                if ((list == null || !list.contains("MaxRestartCount")) && this.bean.isMaxRestartCountSet()) {
                    serverStartMBeanImpl.setMaxRestartCount(this.bean.getMaxRestartCount());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    serverStartMBeanImpl.setName(this.bean.getName());
                }
                if (bl && (list == null || !list.contains("OutputFile")) && this.bean.isOutputFileSet()) {
                    serverStartMBeanImpl.setOutputFile(this.bean.getOutputFile());
                }
                if ((list == null || !list.contains("PasswordEncrypted")) && this.bean.isPasswordEncryptedSet()) {
                    byte[] byArray = this.bean.getPasswordEncrypted();
                    serverStartMBeanImpl.setPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("RootDirectory")) && this.bean.isRootDirectorySet()) {
                    serverStartMBeanImpl.setRootDirectory(this.bean.getRootDirectory());
                }
                if ((list == null || !list.contains("SecurityPolicyFile")) && this.bean.isSecurityPolicyFileSet()) {
                    serverStartMBeanImpl.setSecurityPolicyFile(this.bean.getSecurityPolicyFile());
                }
                if ((list == null || !list.contains("Username")) && this.bean.isUsernameSet()) {
                    serverStartMBeanImpl.setUsername(this.bean.getUsername());
                }
                return serverStartMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

