/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ServerLegalHelper;
import weblogic.management.configuration.SingleSignOnServicesMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class SingleSignOnServicesMBeanImpl
extends ConfigurationMBeanImpl
implements SingleSignOnServicesMBean,
Serializable {
    private int _ArtifactMaxCacheSize;
    private int _ArtifactTimeout;
    private int _AuthnRequestMaxCacheSize;
    private int _AuthnRequestTimeout;
    private String _BasicAuthPassword;
    private byte[] _BasicAuthPasswordEncrypted;
    private String _BasicAuthUsername;
    private String _ContactPersonCompany;
    private String _ContactPersonEmailAddress;
    private String _ContactPersonGivenName;
    private String _ContactPersonSurName;
    private String _ContactPersonTelephoneNumber;
    private String _ContactPersonType;
    private String _DefaultURL;
    private String _EntityID;
    private String _ErrorPath;
    private boolean _ForceAuthn;
    private boolean _IdentityProviderArtifactBindingEnabled;
    private boolean _IdentityProviderEnabled;
    private boolean _IdentityProviderPOSTBindingEnabled;
    private String _IdentityProviderPreferredBinding;
    private boolean _IdentityProviderRedirectBindingEnabled;
    private String _LoginReturnQueryParameter;
    private String _LoginURL;
    private String _OrganizationName;
    private String _OrganizationURL;
    private boolean _POSTOneUseCheckEnabled;
    private boolean _Passive;
    private String _PublishedSiteURL;
    private boolean _RecipientCheckEnabled;
    private boolean _ReplicatedCacheEnabled;
    private String _SSOSigningKeyAlias;
    private String _SSOSigningKeyPassPhrase;
    private byte[] _SSOSigningKeyPassPhraseEncrypted;
    private boolean _ServiceProviderArtifactBindingEnabled;
    private boolean _ServiceProviderEnabled;
    private boolean _ServiceProviderPOSTBindingEnabled;
    private String _ServiceProviderPreferredBinding;
    private boolean _SignAuthnRequests;
    private String _TransportLayerSecurityKeyAlias;
    private String _TransportLayerSecurityKeyPassPhrase;
    private byte[] _TransportLayerSecurityKeyPassPhraseEncrypted;
    private boolean _WantArtifactRequestsSigned;
    private boolean _WantAssertionsSigned;
    private boolean _WantAuthnRequestsSigned;
    private boolean _WantBasicAuthClientAuthentication;
    private boolean _WantTransportLayerSecurityClientAuthentication;
    private static SchemaHelper2 _schemaHelper;

    public SingleSignOnServicesMBeanImpl() {
        this._initializeProperty(-1);
    }

    public SingleSignOnServicesMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getContactPersonGivenName() {
        return this._ContactPersonGivenName;
    }

    public boolean isContactPersonGivenNameSet() {
        return this._isSet(7);
    }

    public void setContactPersonGivenName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ContactPersonGivenName;
        this._ContactPersonGivenName = string;
        this._postSet(7, string2, string);
    }

    public String getContactPersonSurName() {
        return this._ContactPersonSurName;
    }

    public boolean isContactPersonSurNameSet() {
        return this._isSet(8);
    }

    public void setContactPersonSurName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ContactPersonSurName;
        this._ContactPersonSurName = string;
        this._postSet(8, string2, string);
    }

    public String getContactPersonType() {
        return this._ContactPersonType;
    }

    public boolean isContactPersonTypeSet() {
        return this._isSet(9);
    }

    public void setContactPersonType(String string) {
        String string2 = string = string == null ? null : string.trim();
        if (string != null && string.trim().length() > 0) {
            LegalChecks.checkInEnum((String)"ContactPersonType", (String)string, (String[])new String[]{"technical", "support", "administrative", "billing", "other"});
        }
        String string3 = this._ContactPersonType;
        this._ContactPersonType = string;
        this._postSet(9, string3, string);
    }

    public String getContactPersonCompany() {
        return this._ContactPersonCompany;
    }

    public boolean isContactPersonCompanySet() {
        return this._isSet(10);
    }

    public void setContactPersonCompany(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ContactPersonCompany;
        this._ContactPersonCompany = string;
        this._postSet(10, string2, string);
    }

    public String getContactPersonTelephoneNumber() {
        return this._ContactPersonTelephoneNumber;
    }

    public boolean isContactPersonTelephoneNumberSet() {
        return this._isSet(11);
    }

    public void setContactPersonTelephoneNumber(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ContactPersonTelephoneNumber;
        this._ContactPersonTelephoneNumber = string;
        this._postSet(11, string2, string);
    }

    public String getContactPersonEmailAddress() {
        return this._ContactPersonEmailAddress;
    }

    public boolean isContactPersonEmailAddressSet() {
        return this._isSet(12);
    }

    public void setContactPersonEmailAddress(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ContactPersonEmailAddress;
        this._ContactPersonEmailAddress = string;
        this._postSet(12, string2, string);
    }

    public String getOrganizationName() {
        return this._OrganizationName;
    }

    public boolean isOrganizationNameSet() {
        return this._isSet(13);
    }

    public void setOrganizationName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._OrganizationName;
        this._OrganizationName = string;
        this._postSet(13, string2, string);
    }

    public String getOrganizationURL() {
        return this._OrganizationURL;
    }

    public boolean isOrganizationURLSet() {
        return this._isSet(14);
    }

    public void setOrganizationURL(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._OrganizationURL;
        this._OrganizationURL = string;
        this._postSet(14, string2, string);
    }

    public String getPublishedSiteURL() {
        return this._PublishedSiteURL;
    }

    public boolean isPublishedSiteURLSet() {
        return this._isSet(15);
    }

    public void setPublishedSiteURL(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._PublishedSiteURL;
        this._PublishedSiteURL = string;
        this._postSet(15, string2, string);
    }

    public String getEntityID() {
        return this._EntityID;
    }

    public boolean isEntityIDSet() {
        return this._isSet(16);
    }

    public void setEntityID(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._EntityID;
        this._EntityID = string;
        this._postSet(16, string2, string);
    }

    public String getErrorPath() {
        return this._ErrorPath;
    }

    public boolean isErrorPathSet() {
        return this._isSet(17);
    }

    public void setErrorPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ErrorPath;
        this._ErrorPath = string;
        this._postSet(17, string2, string);
    }

    public boolean isServiceProviderEnabled() {
        return this._ServiceProviderEnabled;
    }

    public boolean isServiceProviderEnabledSet() {
        return this._isSet(18);
    }

    public void setServiceProviderEnabled(boolean bl) {
        boolean bl2 = this._ServiceProviderEnabled;
        this._ServiceProviderEnabled = bl;
        this._postSet(18, bl2, bl);
    }

    public String getDefaultURL() {
        return this._DefaultURL;
    }

    public boolean isDefaultURLSet() {
        return this._isSet(19);
    }

    public void setDefaultURL(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._DefaultURL;
        this._DefaultURL = string;
        this._postSet(19, string2, string);
    }

    public boolean isServiceProviderArtifactBindingEnabled() {
        return this._ServiceProviderArtifactBindingEnabled;
    }

    public boolean isServiceProviderArtifactBindingEnabledSet() {
        return this._isSet(20);
    }

    public void setServiceProviderArtifactBindingEnabled(boolean bl) {
        boolean bl2 = this._ServiceProviderArtifactBindingEnabled;
        this._ServiceProviderArtifactBindingEnabled = bl;
        this._postSet(20, bl2, bl);
    }

    public boolean isServiceProviderPOSTBindingEnabled() {
        return this._ServiceProviderPOSTBindingEnabled;
    }

    public boolean isServiceProviderPOSTBindingEnabledSet() {
        return this._isSet(21);
    }

    public void setServiceProviderPOSTBindingEnabled(boolean bl) {
        boolean bl2 = this._ServiceProviderPOSTBindingEnabled;
        this._ServiceProviderPOSTBindingEnabled = bl;
        this._postSet(21, bl2, bl);
    }

    public String getServiceProviderPreferredBinding() {
        return this._ServiceProviderPreferredBinding;
    }

    public boolean isServiceProviderPreferredBindingSet() {
        return this._isSet(22);
    }

    public void setServiceProviderPreferredBinding(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"None", "HTTP/POST", "HTTP/Artifact"};
        string = LegalChecks.checkInEnum((String)"ServiceProviderPreferredBinding", (String)string, (String[])stringArray);
        LegalChecks.checkNonNull((String)"ServiceProviderPreferredBinding", (Object)string);
        String string2 = this._ServiceProviderPreferredBinding;
        this._ServiceProviderPreferredBinding = string;
        this._postSet(22, string2, string);
    }

    public boolean isSignAuthnRequests() {
        return this._SignAuthnRequests;
    }

    public boolean isSignAuthnRequestsSet() {
        return this._isSet(23);
    }

    public void setSignAuthnRequests(boolean bl) {
        boolean bl2 = this._SignAuthnRequests;
        this._SignAuthnRequests = bl;
        this._postSet(23, bl2, bl);
    }

    public boolean isWantAssertionsSigned() {
        return this._WantAssertionsSigned;
    }

    public boolean isWantAssertionsSignedSet() {
        return this._isSet(24);
    }

    public void setWantAssertionsSigned(boolean bl) {
        boolean bl2 = this._WantAssertionsSigned;
        this._WantAssertionsSigned = bl;
        this._postSet(24, bl2, bl);
    }

    public String getSSOSigningKeyAlias() {
        return this._SSOSigningKeyAlias;
    }

    public boolean isSSOSigningKeyAliasSet() {
        return this._isSet(25);
    }

    public void setSSOSigningKeyAlias(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._SSOSigningKeyAlias;
        this._SSOSigningKeyAlias = string;
        this._postSet(25, string2, string);
    }

    public String getSSOSigningKeyPassPhrase() {
        byte[] byArray = this.getSSOSigningKeyPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("SSOSigningKeyPassPhrase", byArray);
    }

    public boolean isSSOSigningKeyPassPhraseSet() {
        return this.isSSOSigningKeyPassPhraseEncryptedSet();
    }

    public void setSSOSigningKeyPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setSSOSigningKeyPassPhraseEncrypted(string == null ? null : this._encrypt("SSOSigningKeyPassPhrase", string));
    }

    public byte[] getSSOSigningKeyPassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._SSOSigningKeyPassPhraseEncrypted);
    }

    public String getSSOSigningKeyPassPhraseEncryptedAsString() {
        byte[] byArray = this.getSSOSigningKeyPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isSSOSigningKeyPassPhraseEncryptedSet() {
        return this._isSet(27);
    }

    public void setSSOSigningKeyPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setSSOSigningKeyPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isForceAuthn() {
        return this._ForceAuthn;
    }

    public boolean isForceAuthnSet() {
        return this._isSet(28);
    }

    public void setForceAuthn(boolean bl) {
        boolean bl2 = this._ForceAuthn;
        this._ForceAuthn = bl;
        this._postSet(28, bl2, bl);
    }

    public boolean isPassive() {
        return this._Passive;
    }

    public boolean isPassiveSet() {
        return this._isSet(29);
    }

    public void setPassive(boolean bl) {
        boolean bl2 = this._Passive;
        this._Passive = bl;
        this._postSet(29, bl2, bl);
    }

    public boolean isIdentityProviderEnabled() {
        return this._IdentityProviderEnabled;
    }

    public boolean isIdentityProviderEnabledSet() {
        return this._isSet(30);
    }

    public void setIdentityProviderEnabled(boolean bl) {
        boolean bl2 = this._IdentityProviderEnabled;
        this._IdentityProviderEnabled = bl;
        this._postSet(30, bl2, bl);
    }

    public boolean isIdentityProviderArtifactBindingEnabled() {
        return this._IdentityProviderArtifactBindingEnabled;
    }

    public boolean isIdentityProviderArtifactBindingEnabledSet() {
        return this._isSet(31);
    }

    public void setIdentityProviderArtifactBindingEnabled(boolean bl) {
        boolean bl2 = this._IdentityProviderArtifactBindingEnabled;
        this._IdentityProviderArtifactBindingEnabled = bl;
        this._postSet(31, bl2, bl);
    }

    public boolean isIdentityProviderPOSTBindingEnabled() {
        return this._IdentityProviderPOSTBindingEnabled;
    }

    public boolean isIdentityProviderPOSTBindingEnabledSet() {
        return this._isSet(32);
    }

    public void setIdentityProviderPOSTBindingEnabled(boolean bl) {
        boolean bl2 = this._IdentityProviderPOSTBindingEnabled;
        this._IdentityProviderPOSTBindingEnabled = bl;
        this._postSet(32, bl2, bl);
    }

    public boolean isIdentityProviderRedirectBindingEnabled() {
        return this._IdentityProviderRedirectBindingEnabled;
    }

    public boolean isIdentityProviderRedirectBindingEnabledSet() {
        return this._isSet(33);
    }

    public void setIdentityProviderRedirectBindingEnabled(boolean bl) {
        boolean bl2 = this._IdentityProviderRedirectBindingEnabled;
        this._IdentityProviderRedirectBindingEnabled = bl;
        this._postSet(33, bl2, bl);
    }

    public String getIdentityProviderPreferredBinding() {
        return this._IdentityProviderPreferredBinding;
    }

    public boolean isIdentityProviderPreferredBindingSet() {
        return this._isSet(34);
    }

    public void setIdentityProviderPreferredBinding(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"None", "HTTP/POST", "HTTP/Artifact", "HTTP/Redirect"};
        string = LegalChecks.checkInEnum((String)"IdentityProviderPreferredBinding", (String)string, (String[])stringArray);
        LegalChecks.checkNonNull((String)"IdentityProviderPreferredBinding", (Object)string);
        String string2 = this._IdentityProviderPreferredBinding;
        this._IdentityProviderPreferredBinding = string;
        this._postSet(34, string2, string);
    }

    public String getLoginURL() {
        return this._LoginURL;
    }

    public boolean isLoginURLSet() {
        return this._isSet(35);
    }

    public void setLoginURL(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"LoginURL", (String)string);
        LegalChecks.checkNonNull((String)"LoginURL", (Object)string);
        String string2 = this._LoginURL;
        this._LoginURL = string;
        this._postSet(35, string2, string);
    }

    public String getLoginReturnQueryParameter() {
        return this._LoginReturnQueryParameter;
    }

    public boolean isLoginReturnQueryParameterSet() {
        return this._isSet(36);
    }

    public void setLoginReturnQueryParameter(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._LoginReturnQueryParameter;
        this._LoginReturnQueryParameter = string;
        this._postSet(36, string2, string);
    }

    public boolean isWantAuthnRequestsSigned() {
        return this._WantAuthnRequestsSigned;
    }

    public boolean isWantAuthnRequestsSignedSet() {
        return this._isSet(37);
    }

    public void setWantAuthnRequestsSigned(boolean bl) {
        boolean bl2 = this._WantAuthnRequestsSigned;
        this._WantAuthnRequestsSigned = bl;
        this._postSet(37, bl2, bl);
    }

    public boolean isRecipientCheckEnabled() {
        return this._RecipientCheckEnabled;
    }

    public boolean isRecipientCheckEnabledSet() {
        return this._isSet(38);
    }

    public void setRecipientCheckEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._RecipientCheckEnabled;
        this._RecipientCheckEnabled = bl;
        this._postSet(38, bl2, bl);
    }

    public boolean isPOSTOneUseCheckEnabled() {
        return this._POSTOneUseCheckEnabled;
    }

    public boolean isPOSTOneUseCheckEnabledSet() {
        return this._isSet(39);
    }

    public void setPOSTOneUseCheckEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._POSTOneUseCheckEnabled;
        this._POSTOneUseCheckEnabled = bl;
        this._postSet(39, bl2, bl);
    }

    public String getTransportLayerSecurityKeyAlias() {
        return this._TransportLayerSecurityKeyAlias;
    }

    public boolean isTransportLayerSecurityKeyAliasSet() {
        return this._isSet(40);
    }

    public void setTransportLayerSecurityKeyAlias(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._TransportLayerSecurityKeyAlias;
        this._TransportLayerSecurityKeyAlias = string;
        this._postSet(40, string2, string);
    }

    public String getTransportLayerSecurityKeyPassPhrase() {
        byte[] byArray = this.getTransportLayerSecurityKeyPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("TransportLayerSecurityKeyPassPhrase", byArray);
    }

    public boolean isTransportLayerSecurityKeyPassPhraseSet() {
        return this.isTransportLayerSecurityKeyPassPhraseEncryptedSet();
    }

    public void setTransportLayerSecurityKeyPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setTransportLayerSecurityKeyPassPhraseEncrypted(string == null ? null : this._encrypt("TransportLayerSecurityKeyPassPhrase", string));
    }

    public byte[] getTransportLayerSecurityKeyPassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._TransportLayerSecurityKeyPassPhraseEncrypted);
    }

    public String getTransportLayerSecurityKeyPassPhraseEncryptedAsString() {
        byte[] byArray = this.getTransportLayerSecurityKeyPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isTransportLayerSecurityKeyPassPhraseEncryptedSet() {
        return this._isSet(42);
    }

    public void setTransportLayerSecurityKeyPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setTransportLayerSecurityKeyPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getBasicAuthUsername() {
        return this._BasicAuthUsername;
    }

    public boolean isBasicAuthUsernameSet() {
        return this._isSet(43);
    }

    public void setBasicAuthUsername(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._BasicAuthUsername;
        this._BasicAuthUsername = string;
        this._postSet(43, string2, string);
    }

    public String getBasicAuthPassword() {
        byte[] byArray = this.getBasicAuthPasswordEncrypted();
        return byArray == null ? null : this._decrypt("BasicAuthPassword", byArray);
    }

    public boolean isBasicAuthPasswordSet() {
        return this.isBasicAuthPasswordEncryptedSet();
    }

    public void setBasicAuthPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setBasicAuthPasswordEncrypted(string == null ? null : this._encrypt("BasicAuthPassword", string));
    }

    public byte[] getBasicAuthPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._BasicAuthPasswordEncrypted);
    }

    public String getBasicAuthPasswordEncryptedAsString() {
        byte[] byArray = this.getBasicAuthPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isBasicAuthPasswordEncryptedSet() {
        return this._isSet(45);
    }

    public void setBasicAuthPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setBasicAuthPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isWantArtifactRequestsSigned() {
        return this._WantArtifactRequestsSigned;
    }

    public boolean isWantArtifactRequestsSignedSet() {
        return this._isSet(46);
    }

    public void setWantArtifactRequestsSigned(boolean bl) {
        boolean bl2 = this._WantArtifactRequestsSigned;
        this._WantArtifactRequestsSigned = bl;
        this._postSet(46, bl2, bl);
    }

    public boolean isWantTransportLayerSecurityClientAuthentication() {
        return this._WantTransportLayerSecurityClientAuthentication;
    }

    public boolean isWantTransportLayerSecurityClientAuthenticationSet() {
        return this._isSet(47);
    }

    public void setWantTransportLayerSecurityClientAuthentication(boolean bl) {
        boolean bl2 = this._WantTransportLayerSecurityClientAuthentication;
        this._WantTransportLayerSecurityClientAuthentication = bl;
        this._postSet(47, bl2, bl);
    }

    public boolean isWantBasicAuthClientAuthentication() {
        return this._WantBasicAuthClientAuthentication;
    }

    public boolean isWantBasicAuthClientAuthenticationSet() {
        return this._isSet(48);
    }

    public void setWantBasicAuthClientAuthentication(boolean bl) {
        boolean bl2 = this._WantBasicAuthClientAuthentication;
        this._WantBasicAuthClientAuthentication = bl;
        this._postSet(48, bl2, bl);
    }

    public int getAuthnRequestMaxCacheSize() {
        return this._AuthnRequestMaxCacheSize;
    }

    public boolean isAuthnRequestMaxCacheSizeSet() {
        return this._isSet(49);
    }

    public void setAuthnRequestMaxCacheSize(int n) {
        int n2 = this._AuthnRequestMaxCacheSize;
        this._AuthnRequestMaxCacheSize = n;
        this._postSet(49, n2, n);
    }

    public int getAuthnRequestTimeout() {
        return this._AuthnRequestTimeout;
    }

    public boolean isAuthnRequestTimeoutSet() {
        return this._isSet(50);
    }

    public void setAuthnRequestTimeout(int n) {
        int n2 = this._AuthnRequestTimeout;
        this._AuthnRequestTimeout = n;
        this._postSet(50, n2, n);
    }

    public int getArtifactMaxCacheSize() {
        return this._ArtifactMaxCacheSize;
    }

    public boolean isArtifactMaxCacheSizeSet() {
        return this._isSet(51);
    }

    public void setArtifactMaxCacheSize(int n) {
        int n2 = this._ArtifactMaxCacheSize;
        this._ArtifactMaxCacheSize = n;
        this._postSet(51, n2, n);
    }

    public int getArtifactTimeout() {
        return this._ArtifactTimeout;
    }

    public boolean isArtifactTimeoutSet() {
        return this._isSet(52);
    }

    public void setArtifactTimeout(int n) {
        int n2 = this._ArtifactTimeout;
        this._ArtifactTimeout = n;
        this._postSet(52, n2, n);
    }

    public boolean isReplicatedCacheEnabled() {
        return this._ReplicatedCacheEnabled;
    }

    public boolean isReplicatedCacheEnabledSet() {
        return this._isSet(53);
    }

    public void setReplicatedCacheEnabled(boolean bl) {
        boolean bl2 = this._ReplicatedCacheEnabled;
        this._ReplicatedCacheEnabled = bl;
        this._postSet(53, bl2, bl);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        ServerLegalHelper.validateSingleSignOnServices(this);
    }

    public void setBasicAuthPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._BasicAuthPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: BasicAuthPasswordEncrypted of SingleSignOnServicesMBean");
        }
        this._getHelper()._clearArray(this._BasicAuthPasswordEncrypted);
        this._BasicAuthPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(45, byArray2, byArray);
    }

    public void setSSOSigningKeyPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._SSOSigningKeyPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: SSOSigningKeyPassPhraseEncrypted of SingleSignOnServicesMBean");
        }
        this._getHelper()._clearArray(this._SSOSigningKeyPassPhraseEncrypted);
        this._SSOSigningKeyPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(27, byArray2, byArray);
    }

    public void setTransportLayerSecurityKeyPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._TransportLayerSecurityKeyPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: TransportLayerSecurityKeyPassPhraseEncrypted of SingleSignOnServicesMBean");
        }
        this._getHelper()._clearArray(this._TransportLayerSecurityKeyPassPhraseEncrypted);
        this._TransportLayerSecurityKeyPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(42, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 44) {
                this._markSet(45, false);
            }
            if (n == 26) {
                this._markSet(27, false);
            }
            if (n == 41) {
                this._markSet(42, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 51;
        }
        try {
            switch (n) {
                case 51: {
                    this._ArtifactMaxCacheSize = 10000;
                    if (bl) break;
                }
                case 52: {
                    this._ArtifactTimeout = 300;
                    if (bl) break;
                }
                case 49: {
                    this._AuthnRequestMaxCacheSize = 10000;
                    if (bl) break;
                }
                case 50: {
                    this._AuthnRequestTimeout = 300;
                    if (bl) break;
                }
                case 44: {
                    this._BasicAuthPasswordEncrypted = null;
                    if (bl) break;
                }
                case 45: {
                    this._BasicAuthPasswordEncrypted = null;
                    if (bl) break;
                }
                case 43: {
                    this._BasicAuthUsername = null;
                    if (bl) break;
                }
                case 10: {
                    this._ContactPersonCompany = null;
                    if (bl) break;
                }
                case 12: {
                    this._ContactPersonEmailAddress = null;
                    if (bl) break;
                }
                case 7: {
                    this._ContactPersonGivenName = null;
                    if (bl) break;
                }
                case 8: {
                    this._ContactPersonSurName = null;
                    if (bl) break;
                }
                case 11: {
                    this._ContactPersonTelephoneNumber = null;
                    if (bl) break;
                }
                case 9: {
                    this._ContactPersonType = null;
                    if (bl) break;
                }
                case 19: {
                    this._DefaultURL = null;
                    if (bl) break;
                }
                case 16: {
                    this._EntityID = null;
                    if (bl) break;
                }
                case 17: {
                    this._ErrorPath = null;
                    if (bl) break;
                }
                case 34: {
                    this._IdentityProviderPreferredBinding = "None";
                    if (bl) break;
                }
                case 36: {
                    this._LoginReturnQueryParameter = null;
                    if (bl) break;
                }
                case 35: {
                    this._LoginURL = "/saml2/idp/login";
                    if (bl) break;
                }
                case 13: {
                    this._OrganizationName = null;
                    if (bl) break;
                }
                case 14: {
                    this._OrganizationURL = null;
                    if (bl) break;
                }
                case 15: {
                    this._PublishedSiteURL = null;
                    if (bl) break;
                }
                case 25: {
                    this._SSOSigningKeyAlias = null;
                    if (bl) break;
                }
                case 26: {
                    this._SSOSigningKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 27: {
                    this._SSOSigningKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 22: {
                    this._ServiceProviderPreferredBinding = "None";
                    if (bl) break;
                }
                case 40: {
                    this._TransportLayerSecurityKeyAlias = null;
                    if (bl) break;
                }
                case 41: {
                    this._TransportLayerSecurityKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 42: {
                    this._TransportLayerSecurityKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 28: {
                    this._ForceAuthn = false;
                    if (bl) break;
                }
                case 31: {
                    this._IdentityProviderArtifactBindingEnabled = true;
                    if (bl) break;
                }
                case 30: {
                    this._IdentityProviderEnabled = false;
                    if (bl) break;
                }
                case 32: {
                    this._IdentityProviderPOSTBindingEnabled = true;
                    if (bl) break;
                }
                case 33: {
                    this._IdentityProviderRedirectBindingEnabled = true;
                    if (bl) break;
                }
                case 39: {
                    this._POSTOneUseCheckEnabled = true;
                    if (bl) break;
                }
                case 29: {
                    this._Passive = false;
                    if (bl) break;
                }
                case 38: {
                    this._RecipientCheckEnabled = true;
                    if (bl) break;
                }
                case 53: {
                    this._ReplicatedCacheEnabled = false;
                    if (bl) break;
                }
                case 20: {
                    this._ServiceProviderArtifactBindingEnabled = true;
                    if (bl) break;
                }
                case 18: {
                    this._ServiceProviderEnabled = false;
                    if (bl) break;
                }
                case 21: {
                    this._ServiceProviderPOSTBindingEnabled = true;
                    if (bl) break;
                }
                case 23: {
                    this._SignAuthnRequests = false;
                    if (bl) break;
                }
                case 46: {
                    this._WantArtifactRequestsSigned = false;
                    if (bl) break;
                }
                case 24: {
                    this._WantAssertionsSigned = false;
                    if (bl) break;
                }
                case 37: {
                    this._WantAuthnRequestsSigned = false;
                    if (bl) break;
                }
                case 48: {
                    this._WantBasicAuthClientAuthentication = false;
                    if (bl) break;
                }
                case 47: {
                    this._WantTransportLayerSecurityClientAuthentication = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SingleSignOnServices";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ArtifactMaxCacheSize")) {
            int n = this._ArtifactMaxCacheSize;
            this._ArtifactMaxCacheSize = (Integer)object;
            this._postSet(51, n, this._ArtifactMaxCacheSize);
            return;
        }
        if (string.equals("ArtifactTimeout")) {
            int n = this._ArtifactTimeout;
            this._ArtifactTimeout = (Integer)object;
            this._postSet(52, n, this._ArtifactTimeout);
            return;
        }
        if (string.equals("AuthnRequestMaxCacheSize")) {
            int n = this._AuthnRequestMaxCacheSize;
            this._AuthnRequestMaxCacheSize = (Integer)object;
            this._postSet(49, n, this._AuthnRequestMaxCacheSize);
            return;
        }
        if (string.equals("AuthnRequestTimeout")) {
            int n = this._AuthnRequestTimeout;
            this._AuthnRequestTimeout = (Integer)object;
            this._postSet(50, n, this._AuthnRequestTimeout);
            return;
        }
        if (string.equals("BasicAuthPassword")) {
            String string2 = this._BasicAuthPassword;
            this._BasicAuthPassword = (String)object;
            this._postSet(44, string2, this._BasicAuthPassword);
            return;
        }
        if (string.equals("BasicAuthPasswordEncrypted")) {
            byte[] byArray = this._BasicAuthPasswordEncrypted;
            this._BasicAuthPasswordEncrypted = (byte[])object;
            this._postSet(45, byArray, this._BasicAuthPasswordEncrypted);
            return;
        }
        if (string.equals("BasicAuthUsername")) {
            String string3 = this._BasicAuthUsername;
            this._BasicAuthUsername = (String)object;
            this._postSet(43, string3, this._BasicAuthUsername);
            return;
        }
        if (string.equals("ContactPersonCompany")) {
            String string4 = this._ContactPersonCompany;
            this._ContactPersonCompany = (String)object;
            this._postSet(10, string4, this._ContactPersonCompany);
            return;
        }
        if (string.equals("ContactPersonEmailAddress")) {
            String string5 = this._ContactPersonEmailAddress;
            this._ContactPersonEmailAddress = (String)object;
            this._postSet(12, string5, this._ContactPersonEmailAddress);
            return;
        }
        if (string.equals("ContactPersonGivenName")) {
            String string6 = this._ContactPersonGivenName;
            this._ContactPersonGivenName = (String)object;
            this._postSet(7, string6, this._ContactPersonGivenName);
            return;
        }
        if (string.equals("ContactPersonSurName")) {
            String string7 = this._ContactPersonSurName;
            this._ContactPersonSurName = (String)object;
            this._postSet(8, string7, this._ContactPersonSurName);
            return;
        }
        if (string.equals("ContactPersonTelephoneNumber")) {
            String string8 = this._ContactPersonTelephoneNumber;
            this._ContactPersonTelephoneNumber = (String)object;
            this._postSet(11, string8, this._ContactPersonTelephoneNumber);
            return;
        }
        if (string.equals("ContactPersonType")) {
            String string9 = this._ContactPersonType;
            this._ContactPersonType = (String)object;
            this._postSet(9, string9, this._ContactPersonType);
            return;
        }
        if (string.equals("DefaultURL")) {
            String string10 = this._DefaultURL;
            this._DefaultURL = (String)object;
            this._postSet(19, string10, this._DefaultURL);
            return;
        }
        if (string.equals("EntityID")) {
            String string11 = this._EntityID;
            this._EntityID = (String)object;
            this._postSet(16, string11, this._EntityID);
            return;
        }
        if (string.equals("ErrorPath")) {
            String string12 = this._ErrorPath;
            this._ErrorPath = (String)object;
            this._postSet(17, string12, this._ErrorPath);
            return;
        }
        if (string.equals("ForceAuthn")) {
            boolean bl = this._ForceAuthn;
            this._ForceAuthn = (Boolean)object;
            this._postSet(28, bl, this._ForceAuthn);
            return;
        }
        if (string.equals("IdentityProviderArtifactBindingEnabled")) {
            boolean bl = this._IdentityProviderArtifactBindingEnabled;
            this._IdentityProviderArtifactBindingEnabled = (Boolean)object;
            this._postSet(31, bl, this._IdentityProviderArtifactBindingEnabled);
            return;
        }
        if (string.equals("IdentityProviderEnabled")) {
            boolean bl = this._IdentityProviderEnabled;
            this._IdentityProviderEnabled = (Boolean)object;
            this._postSet(30, bl, this._IdentityProviderEnabled);
            return;
        }
        if (string.equals("IdentityProviderPOSTBindingEnabled")) {
            boolean bl = this._IdentityProviderPOSTBindingEnabled;
            this._IdentityProviderPOSTBindingEnabled = (Boolean)object;
            this._postSet(32, bl, this._IdentityProviderPOSTBindingEnabled);
            return;
        }
        if (string.equals("IdentityProviderPreferredBinding")) {
            String string13 = this._IdentityProviderPreferredBinding;
            this._IdentityProviderPreferredBinding = (String)object;
            this._postSet(34, string13, this._IdentityProviderPreferredBinding);
            return;
        }
        if (string.equals("IdentityProviderRedirectBindingEnabled")) {
            boolean bl = this._IdentityProviderRedirectBindingEnabled;
            this._IdentityProviderRedirectBindingEnabled = (Boolean)object;
            this._postSet(33, bl, this._IdentityProviderRedirectBindingEnabled);
            return;
        }
        if (string.equals("LoginReturnQueryParameter")) {
            String string14 = this._LoginReturnQueryParameter;
            this._LoginReturnQueryParameter = (String)object;
            this._postSet(36, string14, this._LoginReturnQueryParameter);
            return;
        }
        if (string.equals("LoginURL")) {
            String string15 = this._LoginURL;
            this._LoginURL = (String)object;
            this._postSet(35, string15, this._LoginURL);
            return;
        }
        if (string.equals("OrganizationName")) {
            String string16 = this._OrganizationName;
            this._OrganizationName = (String)object;
            this._postSet(13, string16, this._OrganizationName);
            return;
        }
        if (string.equals("OrganizationURL")) {
            String string17 = this._OrganizationURL;
            this._OrganizationURL = (String)object;
            this._postSet(14, string17, this._OrganizationURL);
            return;
        }
        if (string.equals("POSTOneUseCheckEnabled")) {
            boolean bl = this._POSTOneUseCheckEnabled;
            this._POSTOneUseCheckEnabled = (Boolean)object;
            this._postSet(39, bl, this._POSTOneUseCheckEnabled);
            return;
        }
        if (string.equals("Passive")) {
            boolean bl = this._Passive;
            this._Passive = (Boolean)object;
            this._postSet(29, bl, this._Passive);
            return;
        }
        if (string.equals("PublishedSiteURL")) {
            String string18 = this._PublishedSiteURL;
            this._PublishedSiteURL = (String)object;
            this._postSet(15, string18, this._PublishedSiteURL);
            return;
        }
        if (string.equals("RecipientCheckEnabled")) {
            boolean bl = this._RecipientCheckEnabled;
            this._RecipientCheckEnabled = (Boolean)object;
            this._postSet(38, bl, this._RecipientCheckEnabled);
            return;
        }
        if (string.equals("ReplicatedCacheEnabled")) {
            boolean bl = this._ReplicatedCacheEnabled;
            this._ReplicatedCacheEnabled = (Boolean)object;
            this._postSet(53, bl, this._ReplicatedCacheEnabled);
            return;
        }
        if (string.equals("SSOSigningKeyAlias")) {
            String string19 = this._SSOSigningKeyAlias;
            this._SSOSigningKeyAlias = (String)object;
            this._postSet(25, string19, this._SSOSigningKeyAlias);
            return;
        }
        if (string.equals("SSOSigningKeyPassPhrase")) {
            String string20 = this._SSOSigningKeyPassPhrase;
            this._SSOSigningKeyPassPhrase = (String)object;
            this._postSet(26, string20, this._SSOSigningKeyPassPhrase);
            return;
        }
        if (string.equals("SSOSigningKeyPassPhraseEncrypted")) {
            byte[] byArray = this._SSOSigningKeyPassPhraseEncrypted;
            this._SSOSigningKeyPassPhraseEncrypted = (byte[])object;
            this._postSet(27, byArray, this._SSOSigningKeyPassPhraseEncrypted);
            return;
        }
        if (string.equals("ServiceProviderArtifactBindingEnabled")) {
            boolean bl = this._ServiceProviderArtifactBindingEnabled;
            this._ServiceProviderArtifactBindingEnabled = (Boolean)object;
            this._postSet(20, bl, this._ServiceProviderArtifactBindingEnabled);
            return;
        }
        if (string.equals("ServiceProviderEnabled")) {
            boolean bl = this._ServiceProviderEnabled;
            this._ServiceProviderEnabled = (Boolean)object;
            this._postSet(18, bl, this._ServiceProviderEnabled);
            return;
        }
        if (string.equals("ServiceProviderPOSTBindingEnabled")) {
            boolean bl = this._ServiceProviderPOSTBindingEnabled;
            this._ServiceProviderPOSTBindingEnabled = (Boolean)object;
            this._postSet(21, bl, this._ServiceProviderPOSTBindingEnabled);
            return;
        }
        if (string.equals("ServiceProviderPreferredBinding")) {
            String string21 = this._ServiceProviderPreferredBinding;
            this._ServiceProviderPreferredBinding = (String)object;
            this._postSet(22, string21, this._ServiceProviderPreferredBinding);
            return;
        }
        if (string.equals("SignAuthnRequests")) {
            boolean bl = this._SignAuthnRequests;
            this._SignAuthnRequests = (Boolean)object;
            this._postSet(23, bl, this._SignAuthnRequests);
            return;
        }
        if (string.equals("TransportLayerSecurityKeyAlias")) {
            String string22 = this._TransportLayerSecurityKeyAlias;
            this._TransportLayerSecurityKeyAlias = (String)object;
            this._postSet(40, string22, this._TransportLayerSecurityKeyAlias);
            return;
        }
        if (string.equals("TransportLayerSecurityKeyPassPhrase")) {
            String string23 = this._TransportLayerSecurityKeyPassPhrase;
            this._TransportLayerSecurityKeyPassPhrase = (String)object;
            this._postSet(41, string23, this._TransportLayerSecurityKeyPassPhrase);
            return;
        }
        if (string.equals("TransportLayerSecurityKeyPassPhraseEncrypted")) {
            byte[] byArray = this._TransportLayerSecurityKeyPassPhraseEncrypted;
            this._TransportLayerSecurityKeyPassPhraseEncrypted = (byte[])object;
            this._postSet(42, byArray, this._TransportLayerSecurityKeyPassPhraseEncrypted);
            return;
        }
        if (string.equals("WantArtifactRequestsSigned")) {
            boolean bl = this._WantArtifactRequestsSigned;
            this._WantArtifactRequestsSigned = (Boolean)object;
            this._postSet(46, bl, this._WantArtifactRequestsSigned);
            return;
        }
        if (string.equals("WantAssertionsSigned")) {
            boolean bl = this._WantAssertionsSigned;
            this._WantAssertionsSigned = (Boolean)object;
            this._postSet(24, bl, this._WantAssertionsSigned);
            return;
        }
        if (string.equals("WantAuthnRequestsSigned")) {
            boolean bl = this._WantAuthnRequestsSigned;
            this._WantAuthnRequestsSigned = (Boolean)object;
            this._postSet(37, bl, this._WantAuthnRequestsSigned);
            return;
        }
        if (string.equals("WantBasicAuthClientAuthentication")) {
            boolean bl = this._WantBasicAuthClientAuthentication;
            this._WantBasicAuthClientAuthentication = (Boolean)object;
            this._postSet(48, bl, this._WantBasicAuthClientAuthentication);
            return;
        }
        if (string.equals("WantTransportLayerSecurityClientAuthentication")) {
            boolean bl = this._WantTransportLayerSecurityClientAuthentication;
            this._WantTransportLayerSecurityClientAuthentication = (Boolean)object;
            this._postSet(47, bl, this._WantTransportLayerSecurityClientAuthentication);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ArtifactMaxCacheSize")) {
            return new Integer(this._ArtifactMaxCacheSize);
        }
        if (string.equals("ArtifactTimeout")) {
            return new Integer(this._ArtifactTimeout);
        }
        if (string.equals("AuthnRequestMaxCacheSize")) {
            return new Integer(this._AuthnRequestMaxCacheSize);
        }
        if (string.equals("AuthnRequestTimeout")) {
            return new Integer(this._AuthnRequestTimeout);
        }
        if (string.equals("BasicAuthPassword")) {
            return this._BasicAuthPassword;
        }
        if (string.equals("BasicAuthPasswordEncrypted")) {
            return this._BasicAuthPasswordEncrypted;
        }
        if (string.equals("BasicAuthUsername")) {
            return this._BasicAuthUsername;
        }
        if (string.equals("ContactPersonCompany")) {
            return this._ContactPersonCompany;
        }
        if (string.equals("ContactPersonEmailAddress")) {
            return this._ContactPersonEmailAddress;
        }
        if (string.equals("ContactPersonGivenName")) {
            return this._ContactPersonGivenName;
        }
        if (string.equals("ContactPersonSurName")) {
            return this._ContactPersonSurName;
        }
        if (string.equals("ContactPersonTelephoneNumber")) {
            return this._ContactPersonTelephoneNumber;
        }
        if (string.equals("ContactPersonType")) {
            return this._ContactPersonType;
        }
        if (string.equals("DefaultURL")) {
            return this._DefaultURL;
        }
        if (string.equals("EntityID")) {
            return this._EntityID;
        }
        if (string.equals("ErrorPath")) {
            return this._ErrorPath;
        }
        if (string.equals("ForceAuthn")) {
            return new Boolean(this._ForceAuthn);
        }
        if (string.equals("IdentityProviderArtifactBindingEnabled")) {
            return new Boolean(this._IdentityProviderArtifactBindingEnabled);
        }
        if (string.equals("IdentityProviderEnabled")) {
            return new Boolean(this._IdentityProviderEnabled);
        }
        if (string.equals("IdentityProviderPOSTBindingEnabled")) {
            return new Boolean(this._IdentityProviderPOSTBindingEnabled);
        }
        if (string.equals("IdentityProviderPreferredBinding")) {
            return this._IdentityProviderPreferredBinding;
        }
        if (string.equals("IdentityProviderRedirectBindingEnabled")) {
            return new Boolean(this._IdentityProviderRedirectBindingEnabled);
        }
        if (string.equals("LoginReturnQueryParameter")) {
            return this._LoginReturnQueryParameter;
        }
        if (string.equals("LoginURL")) {
            return this._LoginURL;
        }
        if (string.equals("OrganizationName")) {
            return this._OrganizationName;
        }
        if (string.equals("OrganizationURL")) {
            return this._OrganizationURL;
        }
        if (string.equals("POSTOneUseCheckEnabled")) {
            return new Boolean(this._POSTOneUseCheckEnabled);
        }
        if (string.equals("Passive")) {
            return new Boolean(this._Passive);
        }
        if (string.equals("PublishedSiteURL")) {
            return this._PublishedSiteURL;
        }
        if (string.equals("RecipientCheckEnabled")) {
            return new Boolean(this._RecipientCheckEnabled);
        }
        if (string.equals("ReplicatedCacheEnabled")) {
            return new Boolean(this._ReplicatedCacheEnabled);
        }
        if (string.equals("SSOSigningKeyAlias")) {
            return this._SSOSigningKeyAlias;
        }
        if (string.equals("SSOSigningKeyPassPhrase")) {
            return this._SSOSigningKeyPassPhrase;
        }
        if (string.equals("SSOSigningKeyPassPhraseEncrypted")) {
            return this._SSOSigningKeyPassPhraseEncrypted;
        }
        if (string.equals("ServiceProviderArtifactBindingEnabled")) {
            return new Boolean(this._ServiceProviderArtifactBindingEnabled);
        }
        if (string.equals("ServiceProviderEnabled")) {
            return new Boolean(this._ServiceProviderEnabled);
        }
        if (string.equals("ServiceProviderPOSTBindingEnabled")) {
            return new Boolean(this._ServiceProviderPOSTBindingEnabled);
        }
        if (string.equals("ServiceProviderPreferredBinding")) {
            return this._ServiceProviderPreferredBinding;
        }
        if (string.equals("SignAuthnRequests")) {
            return new Boolean(this._SignAuthnRequests);
        }
        if (string.equals("TransportLayerSecurityKeyAlias")) {
            return this._TransportLayerSecurityKeyAlias;
        }
        if (string.equals("TransportLayerSecurityKeyPassPhrase")) {
            return this._TransportLayerSecurityKeyPassPhrase;
        }
        if (string.equals("TransportLayerSecurityKeyPassPhraseEncrypted")) {
            return this._TransportLayerSecurityKeyPassPhraseEncrypted;
        }
        if (string.equals("WantArtifactRequestsSigned")) {
            return new Boolean(this._WantArtifactRequestsSigned);
        }
        if (string.equals("WantAssertionsSigned")) {
            return new Boolean(this._WantAssertionsSigned);
        }
        if (string.equals("WantAuthnRequestsSigned")) {
            return new Boolean(this._WantAuthnRequestsSigned);
        }
        if (string.equals("WantBasicAuthClientAuthentication")) {
            return new Boolean(this._WantBasicAuthClientAuthentication);
        }
        if (string.equals("WantTransportLayerSecurityClientAuthentication")) {
            return new Boolean(this._WantTransportLayerSecurityClientAuthentication);
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonNull((String)"IdentityProviderPreferredBinding", (Object)"None");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property IdentityProviderPreferredBinding in SingleSignOnServicesMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonEmptyString((String)"LoginURL", (String)"/saml2/idp/login");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is zero-length. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-zero-length value on @default annotation. Refer annotation legalZeroLength on property LoginURL in SingleSignOnServicesMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"LoginURL", (Object)"/saml2/idp/login");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property LoginURL in SingleSignOnServicesMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"ServiceProviderPreferredBinding", (Object)"None");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property ServiceProviderPreferredBinding in SingleSignOnServicesMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 23: {
                    if (string.equals("artifact-max-cache-size")) {
                        return 51;
                    }
                    if (string.equals("contact-person-sur-name")) {
                        return 8;
                    }
                    if (!string.equals("recipient-check-enabled")) break;
                    return 38;
                }
                case 16: {
                    if (string.equals("artifact-timeout")) {
                        return 52;
                    }
                    if (!string.equals("organization-url")) break;
                    return 14;
                }
                case 28: {
                    if (string.equals("authn-request-max-cache-size")) {
                        return 49;
                    }
                    if (string.equals("contact-person-email-address")) {
                        return 12;
                    }
                    if (!string.equals("login-return-query-parameter")) break;
                    return 36;
                }
                case 21: {
                    if (string.equals("authn-request-timeout")) {
                        return 50;
                    }
                    if (!string.equals("sso-signing-key-alias")) break;
                    return 25;
                }
                case 19: {
                    if (string.equals("basic-auth-password")) {
                        return 44;
                    }
                    if (string.equals("basic-auth-username")) {
                        return 43;
                    }
                    if (string.equals("contact-person-type")) {
                        return 9;
                    }
                    if (!string.equals("sign-authn-requests")) break;
                    return 23;
                }
                case 29: {
                    if (string.equals("basic-auth-password-encrypted")) {
                        return 45;
                    }
                    if (!string.equals("want-artifact-requests-signed")) break;
                    return 46;
                }
                case 22: {
                    if (string.equals("contact-person-company")) {
                        return 10;
                    }
                    if (!string.equals("want-assertions-signed")) break;
                    return 24;
                }
                case 25: {
                    if (string.equals("contact-person-given-name")) {
                        return 7;
                    }
                    if (!string.equals("identity-provider-enabled")) break;
                    return 30;
                }
                case 31: {
                    if (!string.equals("contact-person-telephone-number")) break;
                    return 11;
                }
                case 11: {
                    if (string.equals("default-url")) {
                        return 19;
                    }
                    if (!string.equals("force-authn")) break;
                    return 28;
                }
                case 8: {
                    if (!string.equals("entityid")) break;
                    return 16;
                }
                case 10: {
                    if (!string.equals("error-path")) break;
                    return 17;
                }
                case 35: {
                    if (!string.equals("identity-provider-preferred-binding")) break;
                    return 34;
                }
                case 9: {
                    if (!string.equals("login-url")) break;
                    return 35;
                }
                case 17: {
                    if (!string.equals("organization-name")) break;
                    return 13;
                }
                case 18: {
                    if (!string.equals("published-site-url")) break;
                    return 15;
                }
                case 27: {
                    if (!string.equals("sso-signing-key-pass-phrase")) break;
                    return 26;
                }
                case 37: {
                    if (string.equals("sso-signing-key-pass-phrase-encrypted")) {
                        return 27;
                    }
                    if (string.equals("identity-providerpost-binding-enabled")) {
                        return 32;
                    }
                    if (!string.equals("want-basic-auth-client-authentication")) break;
                    return 48;
                }
                case 34: {
                    if (string.equals("service-provider-preferred-binding")) {
                        return 22;
                    }
                    if (!string.equals("transport-layer-security-key-alias")) break;
                    return 40;
                }
                case 40: {
                    if (!string.equals("transport-layer-security-key-pass-phrase")) break;
                    return 41;
                }
                case 50: {
                    if (!string.equals("transport-layer-security-key-pass-phrase-encrypted")) break;
                    return 42;
                }
                case 42: {
                    if (string.equals("identity-provider-artifact-binding-enabled")) {
                        return 31;
                    }
                    if (!string.equals("identity-provider-redirect-binding-enabled")) break;
                    return 33;
                }
                case 26: {
                    if (string.equals("post-one-use-check-enabled")) {
                        return 39;
                    }
                    if (!string.equals("want-authn-requests-signed")) break;
                    return 37;
                }
                case 7: {
                    if (!string.equals("passive")) break;
                    return 29;
                }
                case 24: {
                    if (string.equals("replicated-cache-enabled")) {
                        return 53;
                    }
                    if (!string.equals("service-provider-enabled")) break;
                    return 18;
                }
                case 41: {
                    if (!string.equals("service-provider-artifact-binding-enabled")) break;
                    return 20;
                }
                case 36: {
                    if (!string.equals("service-providerpost-binding-enabled")) break;
                    return 21;
                }
                case 51: {
                    if (!string.equals("want-transport-layer-security-client-authentication")) break;
                    return 47;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 51: {
                    return "artifact-max-cache-size";
                }
                case 52: {
                    return "artifact-timeout";
                }
                case 49: {
                    return "authn-request-max-cache-size";
                }
                case 50: {
                    return "authn-request-timeout";
                }
                case 44: {
                    return "basic-auth-password";
                }
                case 45: {
                    return "basic-auth-password-encrypted";
                }
                case 43: {
                    return "basic-auth-username";
                }
                case 10: {
                    return "contact-person-company";
                }
                case 12: {
                    return "contact-person-email-address";
                }
                case 7: {
                    return "contact-person-given-name";
                }
                case 8: {
                    return "contact-person-sur-name";
                }
                case 11: {
                    return "contact-person-telephone-number";
                }
                case 9: {
                    return "contact-person-type";
                }
                case 19: {
                    return "default-url";
                }
                case 16: {
                    return "entityid";
                }
                case 17: {
                    return "error-path";
                }
                case 34: {
                    return "identity-provider-preferred-binding";
                }
                case 36: {
                    return "login-return-query-parameter";
                }
                case 35: {
                    return "login-url";
                }
                case 13: {
                    return "organization-name";
                }
                case 14: {
                    return "organization-url";
                }
                case 15: {
                    return "published-site-url";
                }
                case 25: {
                    return "sso-signing-key-alias";
                }
                case 26: {
                    return "sso-signing-key-pass-phrase";
                }
                case 27: {
                    return "sso-signing-key-pass-phrase-encrypted";
                }
                case 22: {
                    return "service-provider-preferred-binding";
                }
                case 40: {
                    return "transport-layer-security-key-alias";
                }
                case 41: {
                    return "transport-layer-security-key-pass-phrase";
                }
                case 42: {
                    return "transport-layer-security-key-pass-phrase-encrypted";
                }
                case 28: {
                    return "force-authn";
                }
                case 31: {
                    return "identity-provider-artifact-binding-enabled";
                }
                case 30: {
                    return "identity-provider-enabled";
                }
                case 32: {
                    return "identity-providerpost-binding-enabled";
                }
                case 33: {
                    return "identity-provider-redirect-binding-enabled";
                }
                case 39: {
                    return "post-one-use-check-enabled";
                }
                case 29: {
                    return "passive";
                }
                case 38: {
                    return "recipient-check-enabled";
                }
                case 53: {
                    return "replicated-cache-enabled";
                }
                case 20: {
                    return "service-provider-artifact-binding-enabled";
                }
                case 18: {
                    return "service-provider-enabled";
                }
                case 21: {
                    return "service-providerpost-binding-enabled";
                }
                case 23: {
                    return "sign-authn-requests";
                }
                case 46: {
                    return "want-artifact-requests-signed";
                }
                case 24: {
                    return "want-assertions-signed";
                }
                case 37: {
                    return "want-authn-requests-signed";
                }
                case 48: {
                    return "want-basic-auth-client-authentication";
                }
                case 47: {
                    return "want-transport-layer-security-client-authentication";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private SingleSignOnServicesMBeanImpl bean;

        protected Helper(SingleSignOnServicesMBeanImpl singleSignOnServicesMBeanImpl) {
            super(singleSignOnServicesMBeanImpl);
            this.bean = singleSignOnServicesMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 51: {
                    return "ArtifactMaxCacheSize";
                }
                case 52: {
                    return "ArtifactTimeout";
                }
                case 49: {
                    return "AuthnRequestMaxCacheSize";
                }
                case 50: {
                    return "AuthnRequestTimeout";
                }
                case 44: {
                    return "BasicAuthPassword";
                }
                case 45: {
                    return "BasicAuthPasswordEncrypted";
                }
                case 43: {
                    return "BasicAuthUsername";
                }
                case 10: {
                    return "ContactPersonCompany";
                }
                case 12: {
                    return "ContactPersonEmailAddress";
                }
                case 7: {
                    return "ContactPersonGivenName";
                }
                case 8: {
                    return "ContactPersonSurName";
                }
                case 11: {
                    return "ContactPersonTelephoneNumber";
                }
                case 9: {
                    return "ContactPersonType";
                }
                case 19: {
                    return "DefaultURL";
                }
                case 16: {
                    return "EntityID";
                }
                case 17: {
                    return "ErrorPath";
                }
                case 34: {
                    return "IdentityProviderPreferredBinding";
                }
                case 36: {
                    return "LoginReturnQueryParameter";
                }
                case 35: {
                    return "LoginURL";
                }
                case 13: {
                    return "OrganizationName";
                }
                case 14: {
                    return "OrganizationURL";
                }
                case 15: {
                    return "PublishedSiteURL";
                }
                case 25: {
                    return "SSOSigningKeyAlias";
                }
                case 26: {
                    return "SSOSigningKeyPassPhrase";
                }
                case 27: {
                    return "SSOSigningKeyPassPhraseEncrypted";
                }
                case 22: {
                    return "ServiceProviderPreferredBinding";
                }
                case 40: {
                    return "TransportLayerSecurityKeyAlias";
                }
                case 41: {
                    return "TransportLayerSecurityKeyPassPhrase";
                }
                case 42: {
                    return "TransportLayerSecurityKeyPassPhraseEncrypted";
                }
                case 28: {
                    return "ForceAuthn";
                }
                case 31: {
                    return "IdentityProviderArtifactBindingEnabled";
                }
                case 30: {
                    return "IdentityProviderEnabled";
                }
                case 32: {
                    return "IdentityProviderPOSTBindingEnabled";
                }
                case 33: {
                    return "IdentityProviderRedirectBindingEnabled";
                }
                case 39: {
                    return "POSTOneUseCheckEnabled";
                }
                case 29: {
                    return "Passive";
                }
                case 38: {
                    return "RecipientCheckEnabled";
                }
                case 53: {
                    return "ReplicatedCacheEnabled";
                }
                case 20: {
                    return "ServiceProviderArtifactBindingEnabled";
                }
                case 18: {
                    return "ServiceProviderEnabled";
                }
                case 21: {
                    return "ServiceProviderPOSTBindingEnabled";
                }
                case 23: {
                    return "SignAuthnRequests";
                }
                case 46: {
                    return "WantArtifactRequestsSigned";
                }
                case 24: {
                    return "WantAssertionsSigned";
                }
                case 37: {
                    return "WantAuthnRequestsSigned";
                }
                case 48: {
                    return "WantBasicAuthClientAuthentication";
                }
                case 47: {
                    return "WantTransportLayerSecurityClientAuthentication";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ArtifactMaxCacheSize")) {
                return 51;
            }
            if (string.equals("ArtifactTimeout")) {
                return 52;
            }
            if (string.equals("AuthnRequestMaxCacheSize")) {
                return 49;
            }
            if (string.equals("AuthnRequestTimeout")) {
                return 50;
            }
            if (string.equals("BasicAuthPassword")) {
                return 44;
            }
            if (string.equals("BasicAuthPasswordEncrypted")) {
                return 45;
            }
            if (string.equals("BasicAuthUsername")) {
                return 43;
            }
            if (string.equals("ContactPersonCompany")) {
                return 10;
            }
            if (string.equals("ContactPersonEmailAddress")) {
                return 12;
            }
            if (string.equals("ContactPersonGivenName")) {
                return 7;
            }
            if (string.equals("ContactPersonSurName")) {
                return 8;
            }
            if (string.equals("ContactPersonTelephoneNumber")) {
                return 11;
            }
            if (string.equals("ContactPersonType")) {
                return 9;
            }
            if (string.equals("DefaultURL")) {
                return 19;
            }
            if (string.equals("EntityID")) {
                return 16;
            }
            if (string.equals("ErrorPath")) {
                return 17;
            }
            if (string.equals("IdentityProviderPreferredBinding")) {
                return 34;
            }
            if (string.equals("LoginReturnQueryParameter")) {
                return 36;
            }
            if (string.equals("LoginURL")) {
                return 35;
            }
            if (string.equals("OrganizationName")) {
                return 13;
            }
            if (string.equals("OrganizationURL")) {
                return 14;
            }
            if (string.equals("PublishedSiteURL")) {
                return 15;
            }
            if (string.equals("SSOSigningKeyAlias")) {
                return 25;
            }
            if (string.equals("SSOSigningKeyPassPhrase")) {
                return 26;
            }
            if (string.equals("SSOSigningKeyPassPhraseEncrypted")) {
                return 27;
            }
            if (string.equals("ServiceProviderPreferredBinding")) {
                return 22;
            }
            if (string.equals("TransportLayerSecurityKeyAlias")) {
                return 40;
            }
            if (string.equals("TransportLayerSecurityKeyPassPhrase")) {
                return 41;
            }
            if (string.equals("TransportLayerSecurityKeyPassPhraseEncrypted")) {
                return 42;
            }
            if (string.equals("ForceAuthn")) {
                return 28;
            }
            if (string.equals("IdentityProviderArtifactBindingEnabled")) {
                return 31;
            }
            if (string.equals("IdentityProviderEnabled")) {
                return 30;
            }
            if (string.equals("IdentityProviderPOSTBindingEnabled")) {
                return 32;
            }
            if (string.equals("IdentityProviderRedirectBindingEnabled")) {
                return 33;
            }
            if (string.equals("POSTOneUseCheckEnabled")) {
                return 39;
            }
            if (string.equals("Passive")) {
                return 29;
            }
            if (string.equals("RecipientCheckEnabled")) {
                return 38;
            }
            if (string.equals("ReplicatedCacheEnabled")) {
                return 53;
            }
            if (string.equals("ServiceProviderArtifactBindingEnabled")) {
                return 20;
            }
            if (string.equals("ServiceProviderEnabled")) {
                return 18;
            }
            if (string.equals("ServiceProviderPOSTBindingEnabled")) {
                return 21;
            }
            if (string.equals("SignAuthnRequests")) {
                return 23;
            }
            if (string.equals("WantArtifactRequestsSigned")) {
                return 46;
            }
            if (string.equals("WantAssertionsSigned")) {
                return 24;
            }
            if (string.equals("WantAuthnRequestsSigned")) {
                return 37;
            }
            if (string.equals("WantBasicAuthClientAuthentication")) {
                return 48;
            }
            if (string.equals("WantTransportLayerSecurityClientAuthentication")) {
                return 47;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isArtifactMaxCacheSizeSet()) {
                    stringBuffer.append("ArtifactMaxCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getArtifactMaxCacheSize()));
                }
                if (this.bean.isArtifactTimeoutSet()) {
                    stringBuffer.append("ArtifactTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getArtifactTimeout()));
                }
                if (this.bean.isAuthnRequestMaxCacheSizeSet()) {
                    stringBuffer.append("AuthnRequestMaxCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getAuthnRequestMaxCacheSize()));
                }
                if (this.bean.isAuthnRequestTimeoutSet()) {
                    stringBuffer.append("AuthnRequestTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getAuthnRequestTimeout()));
                }
                if (this.bean.isBasicAuthPasswordSet()) {
                    stringBuffer.append("BasicAuthPassword");
                    stringBuffer.append(String.valueOf(this.bean.getBasicAuthPassword()));
                }
                if (this.bean.isBasicAuthPasswordEncryptedSet()) {
                    stringBuffer.append("BasicAuthPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getBasicAuthPasswordEncrypted())));
                }
                if (this.bean.isBasicAuthUsernameSet()) {
                    stringBuffer.append("BasicAuthUsername");
                    stringBuffer.append(String.valueOf(this.bean.getBasicAuthUsername()));
                }
                if (this.bean.isContactPersonCompanySet()) {
                    stringBuffer.append("ContactPersonCompany");
                    stringBuffer.append(String.valueOf(this.bean.getContactPersonCompany()));
                }
                if (this.bean.isContactPersonEmailAddressSet()) {
                    stringBuffer.append("ContactPersonEmailAddress");
                    stringBuffer.append(String.valueOf(this.bean.getContactPersonEmailAddress()));
                }
                if (this.bean.isContactPersonGivenNameSet()) {
                    stringBuffer.append("ContactPersonGivenName");
                    stringBuffer.append(String.valueOf(this.bean.getContactPersonGivenName()));
                }
                if (this.bean.isContactPersonSurNameSet()) {
                    stringBuffer.append("ContactPersonSurName");
                    stringBuffer.append(String.valueOf(this.bean.getContactPersonSurName()));
                }
                if (this.bean.isContactPersonTelephoneNumberSet()) {
                    stringBuffer.append("ContactPersonTelephoneNumber");
                    stringBuffer.append(String.valueOf(this.bean.getContactPersonTelephoneNumber()));
                }
                if (this.bean.isContactPersonTypeSet()) {
                    stringBuffer.append("ContactPersonType");
                    stringBuffer.append(String.valueOf(this.bean.getContactPersonType()));
                }
                if (this.bean.isDefaultURLSet()) {
                    stringBuffer.append("DefaultURL");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultURL()));
                }
                if (this.bean.isEntityIDSet()) {
                    stringBuffer.append("EntityID");
                    stringBuffer.append(String.valueOf(this.bean.getEntityID()));
                }
                if (this.bean.isErrorPathSet()) {
                    stringBuffer.append("ErrorPath");
                    stringBuffer.append(String.valueOf(this.bean.getErrorPath()));
                }
                if (this.bean.isIdentityProviderPreferredBindingSet()) {
                    stringBuffer.append("IdentityProviderPreferredBinding");
                    stringBuffer.append(String.valueOf(this.bean.getIdentityProviderPreferredBinding()));
                }
                if (this.bean.isLoginReturnQueryParameterSet()) {
                    stringBuffer.append("LoginReturnQueryParameter");
                    stringBuffer.append(String.valueOf(this.bean.getLoginReturnQueryParameter()));
                }
                if (this.bean.isLoginURLSet()) {
                    stringBuffer.append("LoginURL");
                    stringBuffer.append(String.valueOf(this.bean.getLoginURL()));
                }
                if (this.bean.isOrganizationNameSet()) {
                    stringBuffer.append("OrganizationName");
                    stringBuffer.append(String.valueOf(this.bean.getOrganizationName()));
                }
                if (this.bean.isOrganizationURLSet()) {
                    stringBuffer.append("OrganizationURL");
                    stringBuffer.append(String.valueOf(this.bean.getOrganizationURL()));
                }
                if (this.bean.isPublishedSiteURLSet()) {
                    stringBuffer.append("PublishedSiteURL");
                    stringBuffer.append(String.valueOf(this.bean.getPublishedSiteURL()));
                }
                if (this.bean.isSSOSigningKeyAliasSet()) {
                    stringBuffer.append("SSOSigningKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getSSOSigningKeyAlias()));
                }
                if (this.bean.isSSOSigningKeyPassPhraseSet()) {
                    stringBuffer.append("SSOSigningKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getSSOSigningKeyPassPhrase()));
                }
                if (this.bean.isSSOSigningKeyPassPhraseEncryptedSet()) {
                    stringBuffer.append("SSOSigningKeyPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getSSOSigningKeyPassPhraseEncrypted())));
                }
                if (this.bean.isServiceProviderPreferredBindingSet()) {
                    stringBuffer.append("ServiceProviderPreferredBinding");
                    stringBuffer.append(String.valueOf(this.bean.getServiceProviderPreferredBinding()));
                }
                if (this.bean.isTransportLayerSecurityKeyAliasSet()) {
                    stringBuffer.append("TransportLayerSecurityKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getTransportLayerSecurityKeyAlias()));
                }
                if (this.bean.isTransportLayerSecurityKeyPassPhraseSet()) {
                    stringBuffer.append("TransportLayerSecurityKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getTransportLayerSecurityKeyPassPhrase()));
                }
                if (this.bean.isTransportLayerSecurityKeyPassPhraseEncryptedSet()) {
                    stringBuffer.append("TransportLayerSecurityKeyPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getTransportLayerSecurityKeyPassPhraseEncrypted())));
                }
                if (this.bean.isForceAuthnSet()) {
                    stringBuffer.append("ForceAuthn");
                    stringBuffer.append(String.valueOf(this.bean.isForceAuthn()));
                }
                if (this.bean.isIdentityProviderArtifactBindingEnabledSet()) {
                    stringBuffer.append("IdentityProviderArtifactBindingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIdentityProviderArtifactBindingEnabled()));
                }
                if (this.bean.isIdentityProviderEnabledSet()) {
                    stringBuffer.append("IdentityProviderEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIdentityProviderEnabled()));
                }
                if (this.bean.isIdentityProviderPOSTBindingEnabledSet()) {
                    stringBuffer.append("IdentityProviderPOSTBindingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIdentityProviderPOSTBindingEnabled()));
                }
                if (this.bean.isIdentityProviderRedirectBindingEnabledSet()) {
                    stringBuffer.append("IdentityProviderRedirectBindingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIdentityProviderRedirectBindingEnabled()));
                }
                if (this.bean.isPOSTOneUseCheckEnabledSet()) {
                    stringBuffer.append("POSTOneUseCheckEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isPOSTOneUseCheckEnabled()));
                }
                if (this.bean.isPassiveSet()) {
                    stringBuffer.append("Passive");
                    stringBuffer.append(String.valueOf(this.bean.isPassive()));
                }
                if (this.bean.isRecipientCheckEnabledSet()) {
                    stringBuffer.append("RecipientCheckEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isRecipientCheckEnabled()));
                }
                if (this.bean.isReplicatedCacheEnabledSet()) {
                    stringBuffer.append("ReplicatedCacheEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isReplicatedCacheEnabled()));
                }
                if (this.bean.isServiceProviderArtifactBindingEnabledSet()) {
                    stringBuffer.append("ServiceProviderArtifactBindingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isServiceProviderArtifactBindingEnabled()));
                }
                if (this.bean.isServiceProviderEnabledSet()) {
                    stringBuffer.append("ServiceProviderEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isServiceProviderEnabled()));
                }
                if (this.bean.isServiceProviderPOSTBindingEnabledSet()) {
                    stringBuffer.append("ServiceProviderPOSTBindingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isServiceProviderPOSTBindingEnabled()));
                }
                if (this.bean.isSignAuthnRequestsSet()) {
                    stringBuffer.append("SignAuthnRequests");
                    stringBuffer.append(String.valueOf(this.bean.isSignAuthnRequests()));
                }
                if (this.bean.isWantArtifactRequestsSignedSet()) {
                    stringBuffer.append("WantArtifactRequestsSigned");
                    stringBuffer.append(String.valueOf(this.bean.isWantArtifactRequestsSigned()));
                }
                if (this.bean.isWantAssertionsSignedSet()) {
                    stringBuffer.append("WantAssertionsSigned");
                    stringBuffer.append(String.valueOf(this.bean.isWantAssertionsSigned()));
                }
                if (this.bean.isWantAuthnRequestsSignedSet()) {
                    stringBuffer.append("WantAuthnRequestsSigned");
                    stringBuffer.append(String.valueOf(this.bean.isWantAuthnRequestsSigned()));
                }
                if (this.bean.isWantBasicAuthClientAuthenticationSet()) {
                    stringBuffer.append("WantBasicAuthClientAuthentication");
                    stringBuffer.append(String.valueOf(this.bean.isWantBasicAuthClientAuthentication()));
                }
                if (this.bean.isWantTransportLayerSecurityClientAuthenticationSet()) {
                    stringBuffer.append("WantTransportLayerSecurityClientAuthentication");
                    stringBuffer.append(String.valueOf(this.bean.isWantTransportLayerSecurityClientAuthentication()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SingleSignOnServicesMBeanImpl singleSignOnServicesMBeanImpl = (SingleSignOnServicesMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ArtifactMaxCacheSize", this.bean.getArtifactMaxCacheSize(), singleSignOnServicesMBeanImpl.getArtifactMaxCacheSize(), true);
                this.computeDiff("ArtifactTimeout", this.bean.getArtifactTimeout(), singleSignOnServicesMBeanImpl.getArtifactTimeout(), true);
                this.computeDiff("AuthnRequestMaxCacheSize", this.bean.getAuthnRequestMaxCacheSize(), singleSignOnServicesMBeanImpl.getAuthnRequestMaxCacheSize(), true);
                this.computeDiff("AuthnRequestTimeout", this.bean.getAuthnRequestTimeout(), singleSignOnServicesMBeanImpl.getAuthnRequestTimeout(), true);
                this.computeDiff("BasicAuthPasswordEncrypted", this.bean.getBasicAuthPasswordEncrypted(), singleSignOnServicesMBeanImpl.getBasicAuthPasswordEncrypted(), true);
                this.computeDiff("BasicAuthUsername", this.bean.getBasicAuthUsername(), singleSignOnServicesMBeanImpl.getBasicAuthUsername(), true);
                this.computeDiff("ContactPersonCompany", this.bean.getContactPersonCompany(), singleSignOnServicesMBeanImpl.getContactPersonCompany(), true);
                this.computeDiff("ContactPersonEmailAddress", this.bean.getContactPersonEmailAddress(), singleSignOnServicesMBeanImpl.getContactPersonEmailAddress(), true);
                this.computeDiff("ContactPersonGivenName", this.bean.getContactPersonGivenName(), singleSignOnServicesMBeanImpl.getContactPersonGivenName(), true);
                this.computeDiff("ContactPersonSurName", this.bean.getContactPersonSurName(), singleSignOnServicesMBeanImpl.getContactPersonSurName(), true);
                this.computeDiff("ContactPersonTelephoneNumber", this.bean.getContactPersonTelephoneNumber(), singleSignOnServicesMBeanImpl.getContactPersonTelephoneNumber(), true);
                this.computeDiff("ContactPersonType", this.bean.getContactPersonType(), singleSignOnServicesMBeanImpl.getContactPersonType(), true);
                this.computeDiff("DefaultURL", this.bean.getDefaultURL(), singleSignOnServicesMBeanImpl.getDefaultURL(), true);
                this.computeDiff("EntityID", this.bean.getEntityID(), singleSignOnServicesMBeanImpl.getEntityID(), true);
                this.computeDiff("ErrorPath", this.bean.getErrorPath(), singleSignOnServicesMBeanImpl.getErrorPath(), true);
                this.computeDiff("IdentityProviderPreferredBinding", this.bean.getIdentityProviderPreferredBinding(), singleSignOnServicesMBeanImpl.getIdentityProviderPreferredBinding(), true);
                this.computeDiff("LoginReturnQueryParameter", this.bean.getLoginReturnQueryParameter(), singleSignOnServicesMBeanImpl.getLoginReturnQueryParameter(), true);
                this.computeDiff("LoginURL", this.bean.getLoginURL(), singleSignOnServicesMBeanImpl.getLoginURL(), true);
                this.computeDiff("OrganizationName", this.bean.getOrganizationName(), singleSignOnServicesMBeanImpl.getOrganizationName(), true);
                this.computeDiff("OrganizationURL", this.bean.getOrganizationURL(), singleSignOnServicesMBeanImpl.getOrganizationURL(), true);
                this.computeDiff("PublishedSiteURL", this.bean.getPublishedSiteURL(), singleSignOnServicesMBeanImpl.getPublishedSiteURL(), true);
                this.computeDiff("SSOSigningKeyAlias", this.bean.getSSOSigningKeyAlias(), singleSignOnServicesMBeanImpl.getSSOSigningKeyAlias(), true);
                this.computeDiff("SSOSigningKeyPassPhraseEncrypted", this.bean.getSSOSigningKeyPassPhraseEncrypted(), singleSignOnServicesMBeanImpl.getSSOSigningKeyPassPhraseEncrypted(), true);
                this.computeDiff("ServiceProviderPreferredBinding", this.bean.getServiceProviderPreferredBinding(), singleSignOnServicesMBeanImpl.getServiceProviderPreferredBinding(), true);
                this.computeDiff("TransportLayerSecurityKeyAlias", this.bean.getTransportLayerSecurityKeyAlias(), singleSignOnServicesMBeanImpl.getTransportLayerSecurityKeyAlias(), true);
                this.computeDiff("TransportLayerSecurityKeyPassPhraseEncrypted", this.bean.getTransportLayerSecurityKeyPassPhraseEncrypted(), singleSignOnServicesMBeanImpl.getTransportLayerSecurityKeyPassPhraseEncrypted(), true);
                this.computeDiff("ForceAuthn", this.bean.isForceAuthn(), singleSignOnServicesMBeanImpl.isForceAuthn(), true);
                this.computeDiff("IdentityProviderArtifactBindingEnabled", this.bean.isIdentityProviderArtifactBindingEnabled(), singleSignOnServicesMBeanImpl.isIdentityProviderArtifactBindingEnabled(), true);
                this.computeDiff("IdentityProviderEnabled", this.bean.isIdentityProviderEnabled(), singleSignOnServicesMBeanImpl.isIdentityProviderEnabled(), true);
                this.computeDiff("IdentityProviderPOSTBindingEnabled", this.bean.isIdentityProviderPOSTBindingEnabled(), singleSignOnServicesMBeanImpl.isIdentityProviderPOSTBindingEnabled(), true);
                this.computeDiff("IdentityProviderRedirectBindingEnabled", this.bean.isIdentityProviderRedirectBindingEnabled(), singleSignOnServicesMBeanImpl.isIdentityProviderRedirectBindingEnabled(), true);
                this.computeDiff("POSTOneUseCheckEnabled", this.bean.isPOSTOneUseCheckEnabled(), singleSignOnServicesMBeanImpl.isPOSTOneUseCheckEnabled(), true);
                this.computeDiff("Passive", this.bean.isPassive(), singleSignOnServicesMBeanImpl.isPassive(), true);
                this.computeDiff("RecipientCheckEnabled", this.bean.isRecipientCheckEnabled(), singleSignOnServicesMBeanImpl.isRecipientCheckEnabled(), true);
                this.computeDiff("ReplicatedCacheEnabled", this.bean.isReplicatedCacheEnabled(), singleSignOnServicesMBeanImpl.isReplicatedCacheEnabled(), false);
                this.computeDiff("ServiceProviderArtifactBindingEnabled", this.bean.isServiceProviderArtifactBindingEnabled(), singleSignOnServicesMBeanImpl.isServiceProviderArtifactBindingEnabled(), true);
                this.computeDiff("ServiceProviderEnabled", this.bean.isServiceProviderEnabled(), singleSignOnServicesMBeanImpl.isServiceProviderEnabled(), true);
                this.computeDiff("ServiceProviderPOSTBindingEnabled", this.bean.isServiceProviderPOSTBindingEnabled(), singleSignOnServicesMBeanImpl.isServiceProviderPOSTBindingEnabled(), true);
                this.computeDiff("SignAuthnRequests", this.bean.isSignAuthnRequests(), singleSignOnServicesMBeanImpl.isSignAuthnRequests(), true);
                this.computeDiff("WantArtifactRequestsSigned", this.bean.isWantArtifactRequestsSigned(), singleSignOnServicesMBeanImpl.isWantArtifactRequestsSigned(), true);
                this.computeDiff("WantAssertionsSigned", this.bean.isWantAssertionsSigned(), singleSignOnServicesMBeanImpl.isWantAssertionsSigned(), true);
                this.computeDiff("WantAuthnRequestsSigned", this.bean.isWantAuthnRequestsSigned(), singleSignOnServicesMBeanImpl.isWantAuthnRequestsSigned(), true);
                this.computeDiff("WantBasicAuthClientAuthentication", this.bean.isWantBasicAuthClientAuthentication(), singleSignOnServicesMBeanImpl.isWantBasicAuthClientAuthentication(), true);
                this.computeDiff("WantTransportLayerSecurityClientAuthentication", this.bean.isWantTransportLayerSecurityClientAuthentication(), singleSignOnServicesMBeanImpl.isWantTransportLayerSecurityClientAuthentication(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SingleSignOnServicesMBeanImpl singleSignOnServicesMBeanImpl = (SingleSignOnServicesMBeanImpl)beanUpdateEvent.getSourceBean();
                SingleSignOnServicesMBeanImpl singleSignOnServicesMBeanImpl2 = (SingleSignOnServicesMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ArtifactMaxCacheSize")) {
                    singleSignOnServicesMBeanImpl.setArtifactMaxCacheSize(singleSignOnServicesMBeanImpl2.getArtifactMaxCacheSize());
                    singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 51);
                } else if (string.equals("ArtifactTimeout")) {
                    singleSignOnServicesMBeanImpl.setArtifactTimeout(singleSignOnServicesMBeanImpl2.getArtifactTimeout());
                    singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 52);
                } else if (string.equals("AuthnRequestMaxCacheSize")) {
                    singleSignOnServicesMBeanImpl.setAuthnRequestMaxCacheSize(singleSignOnServicesMBeanImpl2.getAuthnRequestMaxCacheSize());
                    singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 49);
                } else if (string.equals("AuthnRequestTimeout")) {
                    singleSignOnServicesMBeanImpl.setAuthnRequestTimeout(singleSignOnServicesMBeanImpl2.getAuthnRequestTimeout());
                    singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 50);
                } else if (!string.equals("BasicAuthPassword")) {
                    if (string.equals("BasicAuthPasswordEncrypted")) {
                        singleSignOnServicesMBeanImpl.setBasicAuthPasswordEncrypted(singleSignOnServicesMBeanImpl2.getBasicAuthPasswordEncrypted());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 45);
                    } else if (string.equals("BasicAuthUsername")) {
                        singleSignOnServicesMBeanImpl.setBasicAuthUsername(singleSignOnServicesMBeanImpl2.getBasicAuthUsername());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 43);
                    } else if (string.equals("ContactPersonCompany")) {
                        singleSignOnServicesMBeanImpl.setContactPersonCompany(singleSignOnServicesMBeanImpl2.getContactPersonCompany());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("ContactPersonEmailAddress")) {
                        singleSignOnServicesMBeanImpl.setContactPersonEmailAddress(singleSignOnServicesMBeanImpl2.getContactPersonEmailAddress());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("ContactPersonGivenName")) {
                        singleSignOnServicesMBeanImpl.setContactPersonGivenName(singleSignOnServicesMBeanImpl2.getContactPersonGivenName());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("ContactPersonSurName")) {
                        singleSignOnServicesMBeanImpl.setContactPersonSurName(singleSignOnServicesMBeanImpl2.getContactPersonSurName());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("ContactPersonTelephoneNumber")) {
                        singleSignOnServicesMBeanImpl.setContactPersonTelephoneNumber(singleSignOnServicesMBeanImpl2.getContactPersonTelephoneNumber());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("ContactPersonType")) {
                        singleSignOnServicesMBeanImpl.setContactPersonType(singleSignOnServicesMBeanImpl2.getContactPersonType());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("DefaultURL")) {
                        singleSignOnServicesMBeanImpl.setDefaultURL(singleSignOnServicesMBeanImpl2.getDefaultURL());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else if (string.equals("EntityID")) {
                        singleSignOnServicesMBeanImpl.setEntityID(singleSignOnServicesMBeanImpl2.getEntityID());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("ErrorPath")) {
                        singleSignOnServicesMBeanImpl.setErrorPath(singleSignOnServicesMBeanImpl2.getErrorPath());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("IdentityProviderPreferredBinding")) {
                        singleSignOnServicesMBeanImpl.setIdentityProviderPreferredBinding(singleSignOnServicesMBeanImpl2.getIdentityProviderPreferredBinding());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                    } else if (string.equals("LoginReturnQueryParameter")) {
                        singleSignOnServicesMBeanImpl.setLoginReturnQueryParameter(singleSignOnServicesMBeanImpl2.getLoginReturnQueryParameter());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                    } else if (string.equals("LoginURL")) {
                        singleSignOnServicesMBeanImpl.setLoginURL(singleSignOnServicesMBeanImpl2.getLoginURL());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                    } else if (string.equals("OrganizationName")) {
                        singleSignOnServicesMBeanImpl.setOrganizationName(singleSignOnServicesMBeanImpl2.getOrganizationName());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("OrganizationURL")) {
                        singleSignOnServicesMBeanImpl.setOrganizationURL(singleSignOnServicesMBeanImpl2.getOrganizationURL());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (string.equals("PublishedSiteURL")) {
                        singleSignOnServicesMBeanImpl.setPublishedSiteURL(singleSignOnServicesMBeanImpl2.getPublishedSiteURL());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("SSOSigningKeyAlias")) {
                        singleSignOnServicesMBeanImpl.setSSOSigningKeyAlias(singleSignOnServicesMBeanImpl2.getSSOSigningKeyAlias());
                        singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                    } else if (!string.equals("SSOSigningKeyPassPhrase")) {
                        if (string.equals("SSOSigningKeyPassPhraseEncrypted")) {
                            singleSignOnServicesMBeanImpl.setSSOSigningKeyPassPhraseEncrypted(singleSignOnServicesMBeanImpl2.getSSOSigningKeyPassPhraseEncrypted());
                            singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                        } else if (string.equals("ServiceProviderPreferredBinding")) {
                            singleSignOnServicesMBeanImpl.setServiceProviderPreferredBinding(singleSignOnServicesMBeanImpl2.getServiceProviderPreferredBinding());
                            singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                        } else if (string.equals("TransportLayerSecurityKeyAlias")) {
                            singleSignOnServicesMBeanImpl.setTransportLayerSecurityKeyAlias(singleSignOnServicesMBeanImpl2.getTransportLayerSecurityKeyAlias());
                            singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                        } else if (!string.equals("TransportLayerSecurityKeyPassPhrase")) {
                            if (string.equals("TransportLayerSecurityKeyPassPhraseEncrypted")) {
                                singleSignOnServicesMBeanImpl.setTransportLayerSecurityKeyPassPhraseEncrypted(singleSignOnServicesMBeanImpl2.getTransportLayerSecurityKeyPassPhraseEncrypted());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                            } else if (string.equals("ForceAuthn")) {
                                singleSignOnServicesMBeanImpl.setForceAuthn(singleSignOnServicesMBeanImpl2.isForceAuthn());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                            } else if (string.equals("IdentityProviderArtifactBindingEnabled")) {
                                singleSignOnServicesMBeanImpl.setIdentityProviderArtifactBindingEnabled(singleSignOnServicesMBeanImpl2.isIdentityProviderArtifactBindingEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                            } else if (string.equals("IdentityProviderEnabled")) {
                                singleSignOnServicesMBeanImpl.setIdentityProviderEnabled(singleSignOnServicesMBeanImpl2.isIdentityProviderEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                            } else if (string.equals("IdentityProviderPOSTBindingEnabled")) {
                                singleSignOnServicesMBeanImpl.setIdentityProviderPOSTBindingEnabled(singleSignOnServicesMBeanImpl2.isIdentityProviderPOSTBindingEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                            } else if (string.equals("IdentityProviderRedirectBindingEnabled")) {
                                singleSignOnServicesMBeanImpl.setIdentityProviderRedirectBindingEnabled(singleSignOnServicesMBeanImpl2.isIdentityProviderRedirectBindingEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                            } else if (string.equals("POSTOneUseCheckEnabled")) {
                                singleSignOnServicesMBeanImpl.setPOSTOneUseCheckEnabled(singleSignOnServicesMBeanImpl2.isPOSTOneUseCheckEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                            } else if (string.equals("Passive")) {
                                singleSignOnServicesMBeanImpl.setPassive(singleSignOnServicesMBeanImpl2.isPassive());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                            } else if (string.equals("RecipientCheckEnabled")) {
                                singleSignOnServicesMBeanImpl.setRecipientCheckEnabled(singleSignOnServicesMBeanImpl2.isRecipientCheckEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                            } else if (string.equals("ReplicatedCacheEnabled")) {
                                singleSignOnServicesMBeanImpl.setReplicatedCacheEnabled(singleSignOnServicesMBeanImpl2.isReplicatedCacheEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 53);
                            } else if (string.equals("ServiceProviderArtifactBindingEnabled")) {
                                singleSignOnServicesMBeanImpl.setServiceProviderArtifactBindingEnabled(singleSignOnServicesMBeanImpl2.isServiceProviderArtifactBindingEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                            } else if (string.equals("ServiceProviderEnabled")) {
                                singleSignOnServicesMBeanImpl.setServiceProviderEnabled(singleSignOnServicesMBeanImpl2.isServiceProviderEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                            } else if (string.equals("ServiceProviderPOSTBindingEnabled")) {
                                singleSignOnServicesMBeanImpl.setServiceProviderPOSTBindingEnabled(singleSignOnServicesMBeanImpl2.isServiceProviderPOSTBindingEnabled());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                            } else if (string.equals("SignAuthnRequests")) {
                                singleSignOnServicesMBeanImpl.setSignAuthnRequests(singleSignOnServicesMBeanImpl2.isSignAuthnRequests());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                            } else if (string.equals("WantArtifactRequestsSigned")) {
                                singleSignOnServicesMBeanImpl.setWantArtifactRequestsSigned(singleSignOnServicesMBeanImpl2.isWantArtifactRequestsSigned());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 46);
                            } else if (string.equals("WantAssertionsSigned")) {
                                singleSignOnServicesMBeanImpl.setWantAssertionsSigned(singleSignOnServicesMBeanImpl2.isWantAssertionsSigned());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                            } else if (string.equals("WantAuthnRequestsSigned")) {
                                singleSignOnServicesMBeanImpl.setWantAuthnRequestsSigned(singleSignOnServicesMBeanImpl2.isWantAuthnRequestsSigned());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                            } else if (string.equals("WantBasicAuthClientAuthentication")) {
                                singleSignOnServicesMBeanImpl.setWantBasicAuthClientAuthentication(singleSignOnServicesMBeanImpl2.isWantBasicAuthClientAuthentication());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 48);
                            } else if (string.equals("WantTransportLayerSecurityClientAuthentication")) {
                                singleSignOnServicesMBeanImpl.setWantTransportLayerSecurityClientAuthentication(singleSignOnServicesMBeanImpl2.isWantTransportLayerSecurityClientAuthentication());
                                singleSignOnServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 47);
                            } else {
                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                byte[] byArray;
                SingleSignOnServicesMBeanImpl singleSignOnServicesMBeanImpl = (SingleSignOnServicesMBeanImpl)abstractDescriptorBean;
                super.finishCopy(singleSignOnServicesMBeanImpl, bl, list);
                if ((list == null || !list.contains("ArtifactMaxCacheSize")) && this.bean.isArtifactMaxCacheSizeSet()) {
                    singleSignOnServicesMBeanImpl.setArtifactMaxCacheSize(this.bean.getArtifactMaxCacheSize());
                }
                if ((list == null || !list.contains("ArtifactTimeout")) && this.bean.isArtifactTimeoutSet()) {
                    singleSignOnServicesMBeanImpl.setArtifactTimeout(this.bean.getArtifactTimeout());
                }
                if ((list == null || !list.contains("AuthnRequestMaxCacheSize")) && this.bean.isAuthnRequestMaxCacheSizeSet()) {
                    singleSignOnServicesMBeanImpl.setAuthnRequestMaxCacheSize(this.bean.getAuthnRequestMaxCacheSize());
                }
                if ((list == null || !list.contains("AuthnRequestTimeout")) && this.bean.isAuthnRequestTimeoutSet()) {
                    singleSignOnServicesMBeanImpl.setAuthnRequestTimeout(this.bean.getAuthnRequestTimeout());
                }
                if ((list == null || !list.contains("BasicAuthPasswordEncrypted")) && this.bean.isBasicAuthPasswordEncryptedSet()) {
                    byArray = this.bean.getBasicAuthPasswordEncrypted();
                    singleSignOnServicesMBeanImpl.setBasicAuthPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("BasicAuthUsername")) && this.bean.isBasicAuthUsernameSet()) {
                    singleSignOnServicesMBeanImpl.setBasicAuthUsername(this.bean.getBasicAuthUsername());
                }
                if ((list == null || !list.contains("ContactPersonCompany")) && this.bean.isContactPersonCompanySet()) {
                    singleSignOnServicesMBeanImpl.setContactPersonCompany(this.bean.getContactPersonCompany());
                }
                if ((list == null || !list.contains("ContactPersonEmailAddress")) && this.bean.isContactPersonEmailAddressSet()) {
                    singleSignOnServicesMBeanImpl.setContactPersonEmailAddress(this.bean.getContactPersonEmailAddress());
                }
                if ((list == null || !list.contains("ContactPersonGivenName")) && this.bean.isContactPersonGivenNameSet()) {
                    singleSignOnServicesMBeanImpl.setContactPersonGivenName(this.bean.getContactPersonGivenName());
                }
                if ((list == null || !list.contains("ContactPersonSurName")) && this.bean.isContactPersonSurNameSet()) {
                    singleSignOnServicesMBeanImpl.setContactPersonSurName(this.bean.getContactPersonSurName());
                }
                if ((list == null || !list.contains("ContactPersonTelephoneNumber")) && this.bean.isContactPersonTelephoneNumberSet()) {
                    singleSignOnServicesMBeanImpl.setContactPersonTelephoneNumber(this.bean.getContactPersonTelephoneNumber());
                }
                if ((list == null || !list.contains("ContactPersonType")) && this.bean.isContactPersonTypeSet()) {
                    singleSignOnServicesMBeanImpl.setContactPersonType(this.bean.getContactPersonType());
                }
                if ((list == null || !list.contains("DefaultURL")) && this.bean.isDefaultURLSet()) {
                    singleSignOnServicesMBeanImpl.setDefaultURL(this.bean.getDefaultURL());
                }
                if ((list == null || !list.contains("EntityID")) && this.bean.isEntityIDSet()) {
                    singleSignOnServicesMBeanImpl.setEntityID(this.bean.getEntityID());
                }
                if ((list == null || !list.contains("ErrorPath")) && this.bean.isErrorPathSet()) {
                    singleSignOnServicesMBeanImpl.setErrorPath(this.bean.getErrorPath());
                }
                if ((list == null || !list.contains("IdentityProviderPreferredBinding")) && this.bean.isIdentityProviderPreferredBindingSet()) {
                    singleSignOnServicesMBeanImpl.setIdentityProviderPreferredBinding(this.bean.getIdentityProviderPreferredBinding());
                }
                if ((list == null || !list.contains("LoginReturnQueryParameter")) && this.bean.isLoginReturnQueryParameterSet()) {
                    singleSignOnServicesMBeanImpl.setLoginReturnQueryParameter(this.bean.getLoginReturnQueryParameter());
                }
                if ((list == null || !list.contains("LoginURL")) && this.bean.isLoginURLSet()) {
                    singleSignOnServicesMBeanImpl.setLoginURL(this.bean.getLoginURL());
                }
                if ((list == null || !list.contains("OrganizationName")) && this.bean.isOrganizationNameSet()) {
                    singleSignOnServicesMBeanImpl.setOrganizationName(this.bean.getOrganizationName());
                }
                if ((list == null || !list.contains("OrganizationURL")) && this.bean.isOrganizationURLSet()) {
                    singleSignOnServicesMBeanImpl.setOrganizationURL(this.bean.getOrganizationURL());
                }
                if ((list == null || !list.contains("PublishedSiteURL")) && this.bean.isPublishedSiteURLSet()) {
                    singleSignOnServicesMBeanImpl.setPublishedSiteURL(this.bean.getPublishedSiteURL());
                }
                if ((list == null || !list.contains("SSOSigningKeyAlias")) && this.bean.isSSOSigningKeyAliasSet()) {
                    singleSignOnServicesMBeanImpl.setSSOSigningKeyAlias(this.bean.getSSOSigningKeyAlias());
                }
                if ((list == null || !list.contains("SSOSigningKeyPassPhraseEncrypted")) && this.bean.isSSOSigningKeyPassPhraseEncryptedSet()) {
                    byArray = this.bean.getSSOSigningKeyPassPhraseEncrypted();
                    singleSignOnServicesMBeanImpl.setSSOSigningKeyPassPhraseEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("ServiceProviderPreferredBinding")) && this.bean.isServiceProviderPreferredBindingSet()) {
                    singleSignOnServicesMBeanImpl.setServiceProviderPreferredBinding(this.bean.getServiceProviderPreferredBinding());
                }
                if ((list == null || !list.contains("TransportLayerSecurityKeyAlias")) && this.bean.isTransportLayerSecurityKeyAliasSet()) {
                    singleSignOnServicesMBeanImpl.setTransportLayerSecurityKeyAlias(this.bean.getTransportLayerSecurityKeyAlias());
                }
                if ((list == null || !list.contains("TransportLayerSecurityKeyPassPhraseEncrypted")) && this.bean.isTransportLayerSecurityKeyPassPhraseEncryptedSet()) {
                    byArray = this.bean.getTransportLayerSecurityKeyPassPhraseEncrypted();
                    singleSignOnServicesMBeanImpl.setTransportLayerSecurityKeyPassPhraseEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("ForceAuthn")) && this.bean.isForceAuthnSet()) {
                    singleSignOnServicesMBeanImpl.setForceAuthn(this.bean.isForceAuthn());
                }
                if ((list == null || !list.contains("IdentityProviderArtifactBindingEnabled")) && this.bean.isIdentityProviderArtifactBindingEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setIdentityProviderArtifactBindingEnabled(this.bean.isIdentityProviderArtifactBindingEnabled());
                }
                if ((list == null || !list.contains("IdentityProviderEnabled")) && this.bean.isIdentityProviderEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setIdentityProviderEnabled(this.bean.isIdentityProviderEnabled());
                }
                if ((list == null || !list.contains("IdentityProviderPOSTBindingEnabled")) && this.bean.isIdentityProviderPOSTBindingEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setIdentityProviderPOSTBindingEnabled(this.bean.isIdentityProviderPOSTBindingEnabled());
                }
                if ((list == null || !list.contains("IdentityProviderRedirectBindingEnabled")) && this.bean.isIdentityProviderRedirectBindingEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setIdentityProviderRedirectBindingEnabled(this.bean.isIdentityProviderRedirectBindingEnabled());
                }
                if ((list == null || !list.contains("POSTOneUseCheckEnabled")) && this.bean.isPOSTOneUseCheckEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setPOSTOneUseCheckEnabled(this.bean.isPOSTOneUseCheckEnabled());
                }
                if ((list == null || !list.contains("Passive")) && this.bean.isPassiveSet()) {
                    singleSignOnServicesMBeanImpl.setPassive(this.bean.isPassive());
                }
                if ((list == null || !list.contains("RecipientCheckEnabled")) && this.bean.isRecipientCheckEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setRecipientCheckEnabled(this.bean.isRecipientCheckEnabled());
                }
                if ((list == null || !list.contains("ReplicatedCacheEnabled")) && this.bean.isReplicatedCacheEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setReplicatedCacheEnabled(this.bean.isReplicatedCacheEnabled());
                }
                if ((list == null || !list.contains("ServiceProviderArtifactBindingEnabled")) && this.bean.isServiceProviderArtifactBindingEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setServiceProviderArtifactBindingEnabled(this.bean.isServiceProviderArtifactBindingEnabled());
                }
                if ((list == null || !list.contains("ServiceProviderEnabled")) && this.bean.isServiceProviderEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setServiceProviderEnabled(this.bean.isServiceProviderEnabled());
                }
                if ((list == null || !list.contains("ServiceProviderPOSTBindingEnabled")) && this.bean.isServiceProviderPOSTBindingEnabledSet()) {
                    singleSignOnServicesMBeanImpl.setServiceProviderPOSTBindingEnabled(this.bean.isServiceProviderPOSTBindingEnabled());
                }
                if ((list == null || !list.contains("SignAuthnRequests")) && this.bean.isSignAuthnRequestsSet()) {
                    singleSignOnServicesMBeanImpl.setSignAuthnRequests(this.bean.isSignAuthnRequests());
                }
                if ((list == null || !list.contains("WantArtifactRequestsSigned")) && this.bean.isWantArtifactRequestsSignedSet()) {
                    singleSignOnServicesMBeanImpl.setWantArtifactRequestsSigned(this.bean.isWantArtifactRequestsSigned());
                }
                if ((list == null || !list.contains("WantAssertionsSigned")) && this.bean.isWantAssertionsSignedSet()) {
                    singleSignOnServicesMBeanImpl.setWantAssertionsSigned(this.bean.isWantAssertionsSigned());
                }
                if ((list == null || !list.contains("WantAuthnRequestsSigned")) && this.bean.isWantAuthnRequestsSignedSet()) {
                    singleSignOnServicesMBeanImpl.setWantAuthnRequestsSigned(this.bean.isWantAuthnRequestsSigned());
                }
                if ((list == null || !list.contains("WantBasicAuthClientAuthentication")) && this.bean.isWantBasicAuthClientAuthenticationSet()) {
                    singleSignOnServicesMBeanImpl.setWantBasicAuthClientAuthentication(this.bean.isWantBasicAuthClientAuthentication());
                }
                if ((list == null || !list.contains("WantTransportLayerSecurityClientAuthentication")) && this.bean.isWantTransportLayerSecurityClientAuthenticationSet()) {
                    singleSignOnServicesMBeanImpl.setWantTransportLayerSecurityClientAuthentication(this.bean.isWantTransportLayerSecurityClientAuthentication());
                }
                return singleSignOnServicesMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

